<?php
//
// ZoneMinder web Japanese language file, $Date: 2004/12/29 18:50:35 $, $Revision: 1.12 $
// Copyright (C) 2003  Philip Coombes
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//

// ZoneMinder Japanese Translation by Andrew Arkley

// Notes for Translators
// 0. Get some credit, put your name in the line above (optional)
// 1. When composing the language tokens in your language you should try and keep to roughly the
//   same length text if possible. Abbreviate where necessary as spacing is quite close in a number of places.
// 2. There are four types of string replacement
//   a) Simple replacements are words or short phrases that are static and used directly. This type of
//     replacement can be used 'as is'.
//   b) Complex replacements involve some dynamic element being included and so may require substitution
//     or changing into a different order. The token listed in this file will be passed through sprintf as
//     a formatting string. If the dynamic element is a number you will usually need to use a variable
//     replacement also as described below.
//   c) Variable replacements are used in conjunction with complex replacements and involve the generation
//     of a singular or plural noun depending on the number passed into the zmVlang function. See the 
//     the zmVlang section below for a further description of this.
//   d) Optional strings which can be used to replace the prompts and/or help text for the Options section
//     of the web interface. These are not listed below as they are quite large and held in the database
//     so that they can also be used by the zmconfig.pl script. However you can build up your own list
//     quite easily from the Config table in the database if necessary.
// 3. The tokens listed below are not used to build up phrases or sentences from single words. Therefore
//   you can safely assume that a single word token will only be used in that context.
// 4. In new language files, or if you are changing only a few words or phrases it makes sense from a 
//   maintenance point of view to include the original language file and override the old definitions rather
//   than copy all the language tokens across. To do this change the line below to whatever your base language
//   is and uncomment it.
// require_once( 'zm_lang_en_gb.php' );

// You may need to change the character set here, if your web server does not already
// do this by default, uncomment this if required.
//
// Example
// header( "Content-Type: text/html; charset=iso-8859-1" );

// You may need to change your locale here if your default one is incorrect for the
// language described in this file, or if you have multiple languages supported.
// If you do need to change your locale, be aware that the format of this function
// is subtlely different in versions of PHP before and after 4.3.0, see
// http://uk2.php.net/manual/en/function.setlocale.php for details.
// Also be aware that changing the whole locale may affect some floating point or decimal 
// arithmetic in the database, if this is the case change only the individual locale areas
// that don't affect this rather than all at once. See the examples below.
// Finally, depending on your setup, PHP may not enjoy have multiple locales in a shared 
// threaded environment, if you get funny errors it may be this.
//
// Examples
// setlocale( 'LC_ALL', 'en_GB' ); All locale settings pre-4.3.0
// setlocale( LC_ALL, 'en_GB' ); All locale settings 4.3.0 and after
// setlocale( LC_CTYPE, 'en_GB' ); Character class settings 4.3.0 and after
// setlocale( LC_TIME, 'en_GB' ); Date and time formatting 4.3.0 and after

// Simple String Replacements
$zmSlang24BitColour          = '24ޯĶװ';
$zmSlang8BitGrey             = '8ޯĔZW摜';
$zmSlangActual               = 'p';
$zmSlangAddNewMonitor        = 'ǉ';
$zmSlangAddNewUser           = 'հޒǉ';
$zmSlangAddNewZone           = 'ްݒǉ';
$zmSlangAlarmBrFrames        = 'װ<br/>ڰ';	
$zmSlangAlarmFrameCount      = 'Alarm Frame Count';
$zmSlangAlarmFrame           = 'װ ڰ';
$zmSlangAlarmLimits          = 'װьx';
$zmSlangAlarm                = 'װ';
$zmSlangAlarmPx              = 'װ Px';
$zmSlangAlert                = 'x';
$zmSlangAll                  = 'S';
$zmSlangApplyingStateChange  = 'ύXKp';
$zmSlangApply                = 'Kp';
$zmSlangArchArchived         = 'ۑ̂';
$zmSlangArchive              = '';
$zmSlangArchUnarchived       = 'ۑȊÔ';
$zmSlangAttrAlarmFrames      = 'װ ڰ';
$zmSlangAttrArchiveStatus    = 'ۑ';
$zmSlangAttrAvgScore         = 'Ͻ';
$zmSlangAttrCause            = 'Cause';
$zmSlangAttrDateTime         = '';
$zmSlangAttrDate             = 't';
$zmSlangAttrDiskBlocks       = 'Disk Blocks';
$zmSlangAttrDiskPercent      = 'Disk Percent';
$zmSlangAttrDuration         = 'p';
$zmSlangAttrFrames           = 'ڰ';
$zmSlangAttrId               = 'Id';
$zmSlangAttrMaxScore         = 'ō';
$zmSlangAttrMonitorId        = ' Id';
$zmSlangAttrMonitorName      = ' O';
$zmSlangAttrName             = 'Name';
$zmSlangAttrTime             = '';
$zmSlangAttrTotalScore       = 'v';
$zmSlangAttrWeekday          = 'j';
$zmSlangAutoArchiveEvents    = 'Automatically archive all matches';
$zmSlangAutoDeleteEvents     = 'Automatically delete all matches';
$zmSlangAutoEmailEvents      = 'Automatically email details of all matches';
$zmSlangAutoExecuteEvents    = 'Automatically execute command on all matches';
$zmSlangAutoMessageEvents    = 'Automatically message details of all matches';
$zmSlangAutoUploadEvents     = 'Automatically upload all matches';
$zmSlangAvgBrScore           = '<br/>';
$zmSlangBadMonitorChars      = '̖OɎg镶͏a-zA0-9A-_ł';
$zmSlangBandwidth            = 'ш敝';
$zmSlangBlobPx               = ' Px';
$zmSlangBlobSizes            = ' ';
$zmSlangBlobs                = '';
$zmSlangBrightness           = 'Px';
$zmSlangBuffers              = 'ޯ̧';
$zmSlangCancelForcedAlarm    = 'װѷݾ';
$zmSlangCancel               = 'ݾ';
$zmSlangCaptureHeight        = '荞ݍ';
$zmSlangCapturePalette       = '荞گ';
$zmSlangCaptureWidth         = '荞ݕ';
$zmSlangCause                = 'Cause';
$zmSlangCheckAll             = 'SđI';
$zmSlangCheckMethod          = 'װ @';
$zmSlangChooseFilter         = '̨̑I';
$zmSlangClose                = '';
$zmSlangColour               = 'F';
$zmSlangConfig               = 'Config';
$zmSlangConfiguredFor        = 'ݒ:';
$zmSlangConfirmPassword      = '߽ܰނ̊mF';
$zmSlangConjAnd              = 'y';
$zmSlangConjOr               = '';
$zmSlangConsole              = 'ݿ';
$zmSlangContactAdmin         = 'Ǘ҂ɂ₢킹B';
$zmSlangContinue             = 'Continue';
$zmSlangContrast             = '׽';
$zmSlangCycle                = 'Cycle';
$zmSlangCycleWatch           = 'يώ@';
$zmSlangDay                  = 'j';
$zmSlangDeleteAndNext        = '폜';
$zmSlangDeleteAndPrev        = 'O폜';
$zmSlangDelete               = '폜';
$zmSlangDeleteSavedFilter    = 'ۑ̨̍폜';
$zmSlangDescription          = '';
$zmSlangDeviceChannel        = '޲ ';
$zmSlangDeviceFormat         = '޲ ̫ϯ (0=PAL,1=NTSC  )';
$zmSlangDeviceNumber         = '޲ԍ (/dev/video?)';
$zmSlangDimensions           = '@';
$zmSlangDisk                 = 'Disk';
$zmSlangDuration             = 'p';
$zmSlangEdit                 = 'ҏW';
$zmSlangEmail                = 'Ұ';
$zmSlangEnabled              = 'gp\\';
$zmSlangEnterNewFilterName   = 'V̨̓';
$zmSlangErrorBrackets        = 'G[AJʂƕʂ̐Ă̂mFĂ';
$zmSlangError                = 'G[';
$zmSlangErrorValidValue      = 'G[ASĂ̍̐lLǂmFĂ';
$zmSlangEtc                  = '';
$zmSlangEvent                = '';
$zmSlangEventFilter          = ' ̨';
$zmSlangEventId              = 'Event Id';
$zmSlangEventName            = 'Event Name';
$zmSlangEventPrefix          = 'Event Prefix';
$zmSlangEvents               = '';
$zmSlangExclude              = 'r';
$zmSlangFeed                 = '荞';
$zmSlangFilterPx             = '̨ Px';
$zmSlangFirst                = 'ŏ';
$zmSlangForceAlarm           = 'װ';
$zmSlangFPS                  = 'fps';
$zmSlangFPSReportInterval    = 'FPS񍐊Ԋu';
$zmSlangFrameId              = 'ڰ ID';
$zmSlangFrame                = 'ڰ';
$zmSlangFrameRate            = 'ڰڰ';
$zmSlangFrames               = 'ڰ';
$zmSlangFrameSkip            = 'ڰѽ';
$zmSlangFTP                  = 'FTP';
$zmSlangFunc                 = '@\\';
$zmSlangFunction             = '@\\';
$zmSlangGenerateVideo        = '޵̐';
$zmSlangGeneratingVideo      = '޵';
$zmSlangGoToZoneMinder       = 'ZoneMinder.comɍs';
$zmSlangGrey                 = 'ڰ';
$zmSlangGroups               = 'Groups';
$zmSlangHigh                 = '';
$zmSlangHighBW               = 'ш';
$zmSlangHour                 = '';
$zmSlangHue                  = 'F';
$zmSlangId                   = 'ID';
$zmSlangIdle                 = 'ҋ@';
$zmSlangIgnore               = '';
$zmSlangImage                = '摜';
$zmSlangImageBufferSize      = '摜 ޯ̧ ';
$zmSlangInclude              = 'gݍ';
$zmSlangInverted             = ']';
$zmSlangLanguage             = '';
$zmSlangLast                 = 'ŏI';
$zmSlangLimitResultsPost     = 'results only;'; // This is used at the end of the phrase 'Limit to first N results only'
$zmSlangLimitResultsPre      = 'Limit to first'; // This is used at the beginning of the phrase 'Limit to first N results only'
$zmSlangLoad                 = 'Load';
$zmSlangLocal                = '۰';
$zmSlangLoggedInAs           = '۸޲ݍς:';
$zmSlangLoggingIn            = '۸޲ݒ';
$zmSlangLogin                = '۸޲';
$zmSlangLogout               = '۸ޱ';
$zmSlangLow                  = '';
$zmSlangLowBW                = 'ш';
$zmSlangMark                 = 'I';
$zmSlangMax                  = 'ō';
$zmSlangMaxBrScore           = 'ō<br/>';
$zmSlangMaximumFPS           = 'ō FPS';
$zmSlangMedium               = '';
$zmSlangMediumBW             = 'ш';
$zmSlangMinAlarmGeMinBlob    = 'ŒA[sNZŒuusNZȏłȂ΂Ȃ';
$zmSlangMinAlarmGeMinFilter  = 'ŒA[sNZŒtB^[sNZȏłȂ΂Ȃ';
$zmSlangMinAlarmPixelsLtMax  = 'Œװ߸ق͍ōlȉłȂ΂Ȃ';
$zmSlangMinBlobAreaLtMax     = 'Œۯޔ͈͍͂ōlȉłȂ΂Ȃ';
$zmSlangMinBlobsLtMax        = 'Œۯސ͍ōȉłȂ΂Ȃ';
$zmSlangMinFilterPixelsLtMax = 'Œ̨߸ِ͍ōȉłȂ΂Ȃ';
$zmSlangMinPixelThresLtMax   = 'Œ߸臒l͍ōlȉłȂ΂Ȃ';
$zmSlangMisc                 = '̑';
$zmSlangMonitorIds           = ' ID';
$zmSlangMonitor              = '';
$zmSlangMonitors             = '';
$zmSlangMontage              = 'ޭ';
$zmSlangMonth                = '';
$zmSlangMustBeGe             = 'ȏłȂ΂Ȃ';
$zmSlangMustBeLe             = 'ȉłȂ΂Ȃ';
$zmSlangMustConfirmPassword  = 'pX[h̊mFĂ';
$zmSlangMustSupplyPassword   = 'pX[h͂Ă';
$zmSlangMustSupplyUsername   = '[U͂Ă';
$zmSlangName                 = 'O';
$zmSlangNetwork              = 'ȯܰ';
$zmSlangNewGroup             = 'New Group';
$zmSlangNewPassword          = 'V߽ܰ';
$zmSlangNewState             = 'VK';	
$zmSlangNewUser              = 'Vհ';
$zmSlangNew                  = 'VK';
$zmSlangNext                 = '';
$zmSlangNo                   = '';
$zmSlangNoFramesRecorded     = '̲Ăڰт͓o^Ă܂';
$zmSlangNoGroups             = 'No groups have been defined';
$zmSlangNoneAvailable        = '܂';
$zmSlangNone                 = '܂';
$zmSlangNormal               = '';
$zmSlangNoSavedFilters       = 'ۑꂽ̨͂܂';
$zmSlangNoStatisticsRecorded = '̲/ڰт̓v͓o^Ă܂';
$zmSlangOpEq                 = '';
$zmSlangOpGt                 = 'ȉ';
$zmSlangOpGtEq               = 'ȏ';
$zmSlangOpIn                 = 'ĂɓĂ';
$zmSlangOpLt                 = 'ȉ';
$zmSlangOpLtEq               = 'ȉ';
$zmSlangOpMatches            = 'v';
$zmSlangOpNe                 = 'łȂ';
$zmSlangOpNotIn              = 'ĂɓĂȂ';
$zmSlangOpNotMatches         = 'vȂ';
$zmSlangOptionHelp           = '߼ ';
$zmSlangOptionRestartWarning = '̕ύX͋NfȂꍇ܂B\nύXĂZoneMinderċNĂB';
$zmSlangOptions              = '߼';
$zmSlangOrEnterNewName       = '͐VO͂Ă';
$zmSlangOrientation          = 'صð';
$zmSlangOverwriteExisting    = '㏑܂';
$zmSlangPaged                = '߰މ';
$zmSlangParameter            = 'Ұ';
$zmSlangPassword             = '߽ܰ';
$zmSlangPasswordsDifferent   = 'VpX[hƍē̓pX[hv܂';
$zmSlangPaths                = '߽';
$zmSlangPhoneBW              = 'gїp';
$zmSlangPhone                = 'Phone';
$zmSlangPixels               = '߸';
$zmSlangPlayAll              = 'Play All';
$zmSlangPleaseWait           = '҂';
$zmSlangPostEventImageBuffer = ' Ұ ޯ̧';
$zmSlangPreEventImageBuffer  = ' Ұ ޯ̧O';
$zmSlangPrev                 = 'O';
$zmSlangRate                 = 'ڰ';
$zmSlangReal                 = 'p';
$zmSlangRecord               = '^';
$zmSlangRefImageBlendPct     = 'Ұ  Q %';
$zmSlangRefresh              = 'ŐV̏ɍXV';
$zmSlangRemoteHostName       = 'Ӱ ν ';
$zmSlangRemoteHostPath       = 'Ӱ ν ߽';
$zmSlangRemoteHostPort       = 'Ӱ ν ߰';
$zmSlangRemoteImageColours   = 'Ӱ Ұ װ';
$zmSlangRemote               = 'Ӱ';
$zmSlangRename               = 'VO';
$zmSlangReplay               = 'Đ';
$zmSlangResetEventCounts     = '  ؾ';
$zmSlangReset                = 'Reset';
$zmSlangRestart              = 'ċN';
$zmSlangRestarting           = 'ċN';
$zmSlangRestrictedCameraIds  = 'ꂽ ID';
$zmSlangRotateLeft           = 'ɉ]';
$zmSlangRotateRight          = 'Eɉ]';
$zmSlangRunMode              = 'NӰ';
$zmSlangRunning              = 'N';
$zmSlangRunState             = 'N';
$zmSlangSaveAs               = 'Oĕۑ';
$zmSlangSaveFilter           = '̨ۑ';
$zmSlangSave                 = 'ۑ';
$zmSlangScale                = '';
$zmSlangScore                = '';
$zmSlangSecs                 = 'b';
$zmSlangSectionlength        = '';
$zmSlangSelect               = 'Select';
$zmSlangSetLearnPrefs        = 'Set Learn Prefs'; // Vݒ̎ۑ@This can be ignored for now
$zmSlangSetNewBandwidth      = 'Vш敝̐ݒ';
$zmSlangSettings             = 'ݒ';
$zmSlangShowFilterWindow     = '̨ ް̕\';
$zmSlangSortAsc              = 'Asc';
$zmSlangSortBy               = 'Sort by';
$zmSlangSortDesc             = 'Desc';
$zmSlangSource               = '';
$zmSlangSourceType           = ' ';
$zmSlangStart                = '';
$zmSlangState                = '';
$zmSlangStats                = 'v';
$zmSlangStatus               = '';
$zmSlangStills               = 'ى摜';
$zmSlangStop                 = '~';
$zmSlangStopped              = '~';
$zmSlangStream               = 'ذ';
$zmSlangSubmit               = 'Submit';
$zmSlangSystem               = '';
$zmSlangThumbnail            = 'Thumbnail';
$zmSlangTimeDelta            = ' ';
$zmSlangTime                 = '';
$zmSlangTimestamp            = 'ѽ';
$zmSlangTimeStamp            = ' ';
$zmSlangTimestampLabelFormat = 'ѽ  ̫ϯ';
$zmSlangTimestampLabelX      = 'ѽ  X';
$zmSlangTimestampLabelY      = 'ѽ  Y';
$zmSlangToday                = 'Today';
$zmSlangTools                = '°';
$zmSlangTotalBrScore         = 'v<br/>';
$zmSlangTriggers             = 'ضް';
$zmSlangType                 = '';
$zmSlangUnarchive            = '';
$zmSlangUnits                = 'Ư';
$zmSlangUnknown              = 's';
$zmSlangUpdateAvailable      = 'ZoneMindeṟްĂ܂';
$zmSlangUpdateNotNecessary   = 'ްĂ̕Kv͂܂';
$zmSlangUseFilterExprsPost   = '&nbsp;̨'; // This is used at the end of the phrase 'use N filter expressions'
$zmSlangUseFilterExprsPre    = 'w肵Ă:&nbsp;'; // This is used at the beginning of the phrase 'use N filter expressions'
$zmSlangUseFilter            = '̨gpĂ';
$zmSlangUsername             = 'հޖ';
$zmSlangUser                 = 'հ';
$zmSlangUsers                = 'հ';
$zmSlangValue                = 'l';
$zmSlangVersion              = 'ްޮ';
$zmSlangVersionIgnore        = 'ްޮ݂𖳎';
$zmSlangVersionRemindDay     = '1ɍēxm点';
$zmSlangVersionRemindHour    = '1Ԍɍēxm点';
$zmSlangVersionRemindNever   = 'Vްޮ݂̒m点͕KvȂ';
$zmSlangVersionRemindWeek    = '1TԌɍēxm点';
$zmSlangVideo                = '޵';
$zmSlangVideoGenFailed       = '޵̎sI';
$zmSlangVideoGenParms        = '޵ Ұ';
$zmSlangVideoSize            = '޵ ';
$zmSlangView                 = '\';
$zmSlangViewAll              = 'S\';
$zmSlangViewPaged            = '߰މ̕\';
$zmSlangWarmupFrames         = 'ѱ ڰ';
$zmSlangWatch                = 'Ď';
$zmSlangWeb                  = '';
$zmSlangWeek                 = 'T';
$zmSlangX10ActivationString  = 'X10N';
$zmSlangX10InputAlarmString  = 'X10ͱװѕ';
$zmSlangX10OutputAlarmString = 'X10oͱװѕ';
$zmSlangX10                  = 'X10';
$zmSlangYes                  = '͂';
$zmSlangYouNoPerms           = '̱̎܂B';
$zmSlangZoneAlarmColour      = 'װ װ (RGB)';
$zmSlangZoneAlarmThreshold   = 'װ 臒l(0>=?<=255)';
$zmSlangZoneFilterHeight     = '̨  (߸)';
$zmSlangZoneFilterWidth      = '̨  (߸)';
$zmSlangZoneMaxAlarmedArea   = 'ōװї̈';
$zmSlangZoneMaxBlobArea      = 'ōޗ̈';
$zmSlangZoneMaxBlobs         = 'ōސ';
$zmSlangZoneMaxFilteredArea  = 'ǭ̈';
$zmSlangZoneMaxPixelThres    = 'ō߸臒l (0>=?<=255)';
$zmSlangZoneMaxX             = 'X (E)ō';
$zmSlangZoneMaxY             = 'Y ()ō';
$zmSlangZoneMinAlarmedArea   = 'Œװї̈';
$zmSlangZoneMinBlobArea      = 'Œޗ̈';
$zmSlangZoneMinBlobs         = 'Œސ';
$zmSlangZoneMinFilteredArea  = 'Œ̨̈';
$zmSlangZoneMinPixelThres    = 'Œ߸臒l (0>=?<=255)';
$zmSlangZoneMinX             = 'X (E)Œ';
$zmSlangZoneMinY             = 'Y ()Œ';
$zmSlangZones                = 'ް';
$zmSlangZone                 = 'ް';

// Complex replacements with formatting and/or placements, must be passed through sprintf
$zmClangCurrentLogin         = '\'%1$s\۸޲݂Ă܂';
$zmClangEventCount           = '%1$s %2$s';
$zmClangLastEvents           = 'ŏI %1$s %2$s';
$zmClangLatestRelease        = 'ŐVްޮ݂ v%1$sApްޮ݂v%2$s.';
$zmClangMonitorCount         = '%1$s %2$s';
$zmClangMonitorFunction      = '%1$s @\\';
$zmClangRunningRecentVer     = 'ȂZoneMinder̍ŐVްޮ v%s.gĂ܂';

// The next section allows you to describe a series of word ending and counts used to 
// generate the correctly conjugated forms of words depending on a count that is associated
// with that word.
// This intended to allow phrases such a '0 potatoes', '1 potato', '2 potatoes' etc to
// conjugate correctly with the associated count.
// In some languages such as English this is fairly simple and can be expressed by assigning
// a count with a singular or plural form of a word and then finding the nearest (lower) value.
// So '0' of something generally ends in 's', 1 of something is singular and has no extra
// ending and 2 or more is a plural and ends in 's' also. So to find the ending for '187' of
// something you would find the nearest lower count (2) and use that ending.
//
// So examples of this would be
// $zmVlangPotato = array( 0=>'Potatoes', 1=>'Potato', 2=>'Potatoes' );
// $zmVlangSheep = array( 0=>'Sheep' );
//
// where you can have as few or as many entries in the array as necessary
// If your language is similar in form to this then use the same format and choose the
// appropriate zmVlang function below.
// If however you have a language with a different format of plural endings then another
// approach is required . For instance in Russian the word endings change continuously
// depending on the last digit (or digits) of the numerator. In this case then zmVlang
// arrays could be written so that the array index just represents an arbitrary 'type'
// and the zmVlang function does the calculation about which version is appropriate.
//
// So an example in Russian might be (using English words, and made up endings as I
// don't know any Russian!!)
// $zmVlangPotato = array( 1=>'Potati', 2=>'Potaton', 3=>'Potaten' );
//
// and the zmVlang function decides that the first form is used for counts ending in
// 0, 5-9 or 11-19 and the second form when ending in 1 etc.
//

// Variable arrays expressing plurality, see the zmVlang description above
$zmVlangEvent                = array( 0=>'', 1=>'', 2=>'' );
$zmVlangMonitor              = array( 0=>'', 1=>'', 2=>'' );

// You will need to choose or write a function that can correlate the plurality string arrays
// with variable counts. This is used to conjugate the Vlang arrays above with a number passed
// in to generate the correct noun form.
//
// In languages such as English this is fairly simple 
// Note this still has to be used with printf etc to get the right formating
function zmVlang( $lang_var_array, $count )
{
	krsort( $lang_var_array );
	foreach ( $lang_var_array as $key=>$value )
	{
		if ( abs($count) >= $key )
		{
			return( $value );
		}
	}
	die( 'Error, unable to correlate variable language string' );
}

// This is an version that could be used in the Russian example above
// The rules are that the first word form is used if the count ends in
// 0, 5-9 or 11-19. The second form is used then the count ends in 1
// (not including 11 as above) and the third form is used when the 
// count ends in 2-4, again excluding any values ending in 12-14.
// 
// function zmVlang( $lang_var_array, $count )
// {
// 	$secondlastdigit = substr( $count, -2, 1 );
// 	$lastdigit = substr( $count, -1, 1 );
// 	// or
// 	// $secondlastdigit = ($count/10)%10;
// 	// $lastdigit = $count%10;
// 
// 	// Get rid of the special cases first, the teens
// 	if ( $secondlastdigit == 1 && $lastdigit != 0 )
// 	{
// 		return( $lang_var_array[1] );
// 	}
// 	switch ( $lastdigit )
// 	{
// 		case 0 :
// 		case 5 :
// 		case 6 :
// 		case 7 :
// 		case 8 :
// 		case 9 :
// 		{
// 			return( $lang_var_array[1] );
// 			break;
// 		}
// 		case 1 :
// 		{
// 			return( $lang_var_array[2] );
// 			break;
// 		}
// 		case 2 :
// 		case 3 :
// 		case 4 :
// 		{
// 			return( $lang_var_array[3] );
// 			break;
// 		}
// 	}
// 	die( 'Error, unable to correlate variable language string' );
// }

// This is an example of how the function is used in the code which you can uncomment and 
// use to test your custom function.
//$monitors = array();
//$monitors[] = 1; // Choose any number
//echo sprintf( $zmClangMonitorCount, count($monitors), zmVlang( $zmVlangMonitor, count($monitors) ) );

// In this section you can override the default prompt and help texts for the options area
// These overrides are in the form of $zmOlangPrompt<option> and $zmOlangHelp<option>
// where <option> represents the option name minus the initial ZM_
// So for example, to override the help text for ZM_LANG_DEFAULT do
//$zmOlangPromptLANG_DEFAULT = "This is a new prompt for this option";
//$zmOlangHelpLANG_DEFAULT = "This is some new help for this option which will be displayed in the popup window when the ? is clicked";
//

?>
