#include "sjog_sonypi.h"
int lastbutton = 0;
int lastevent = 0;

/*
 * Open the device or exit if failed.
 */
void
sjog_sonypi_init()
{

   /* open sonypi device */
   if ((sonypi_fd = open("/dev/sonypi", O_RDONLY)) == -1)
   {
      fprintf(stderr, "Failed to open /dev/sonypi: %s\n", strerror(errno));
      exit(1);

   }
   else
   {
      gdk_input_add(sonypi_fd, GDK_INPUT_READ, sjog_sonypi_read, NULL);
   }
}

/*
 * Reads the jog position by doing a select() on the device.
 */
void
sjog_sonypi_read(gpointer * data)
{
   unsigned char event;

   if (read(sonypi_fd, &event, sizeof(event)) != sizeof(event))
   {
      fprintf(stderr, "read failed: %s\n", strerror(errno));
   }

   fprintf(stderr, "verbose mode event: %d\n", event );

   switch (event)
   {
        /* the cases sjog actually handle are */
     case SONYPI_EVENT_JOGDIAL_DOWN:
       sjog_jog_position_changed(JOG_BOTTOM);
        break;
     case SONYPI_EVENT_JOGDIAL_UP:
        sjog_jog_position_changed(JOG_TOP);
        break;
//     case SONYPI_EVENT_JOGDIAL_DOWN_PRESSED:
//        sjog_jog_position_changed(JOG_PUSHED);
//        break;
//     case SONYPI_EVENT_JOGDIAL_UP_PRESSED:
//        sjog_jog_position_changed(JOG_PUSHED);
//        break;
     case SONYPI_EVENT_JOGDIAL_PRESSED:
//        sjog_button_faketap(2);      
	//lastevent = SONYPI_EVENT_JOGDIAL_PRESSED ;
        break;

        /* and the ones it should probably handle ...

           case SONYPI_EVENT_JOGDIAL_RELEASED:
           break;
           case SONYPI_EVENT_CAPTURE_PRESSED:
           break;
           case SONYPI_EVENT_CAPTURE_RELEASED:
           break;
           case SONYPI_EVENT_CAPTURE_PARTIALPRESSED:
           break;
           case SONYPI_EVENT_CAPTURE_PARTIALRELEASED:
           break;
           case SONYPI_EVENT_FNKEY_ESC:
           break;
           case SONYPI_EVENT_FNKEY_F1:
           break;
           case SONYPI_EVENT_FNKEY_F2:
           break;
           case SONYPI_EVENT_FNKEY_F3:
           break;
           case SONYPI_EVENT_FNKEY_F4:
           break;
           case SONYPI_EVENT_FNKEY_F5:
           break;
           case SONYPI_EVENT_FNKEY_F6:
           break;
           case SONYPI_EVENT_FNKEY_F7:
           break;
           case SONYPI_EVENT_FNKEY_F8:
           break;
           case SONYPI_EVENT_FNKEY_F9:
           break;
           case SONYPI_EVENT_FNKEY_F10:
           break;
           case SONYPI_EVENT_FNKEY_F11:
           break;
           case SONYPI_EVENT_FNKEY_F12:
           break;
           case SONYPI_EVENT_FNKEY_1:
           break;
           case SONYPI_EVENT_FNKEY_2:
           break;
           case SONYPI_EVENT_FNKEY_D:
           break;
           case SONYPI_EVENT_FNKEY_E:
           break;
           case SONYPI_EVENT_FNKEY_F:
           break;
           case SONYPI_EVENT_FNKEY_S:
           break;
           case SONYPI_EVENT_FNKEY_B:
           break;
           case SONYPI_EVENT_BLUETOOTH_PRESSED:
           break;
         */
    case SONYPI_EVENT_JOGDIAL_RELEASED:
      fprintf(stderr, "something released\n");
      break;
    case SONYPI_EVENT_FNKEY_ESC:
        sjog_jog_position_changed(JOG_PUSHED);
      //fprintf(stderr, "standby pressed\n");
      break;
    case SONYPI_EVENT_BACK_PRESSED:
      sjog_button_faketap(1);      
      fprintf(stderr, "back pressed\n");
      break;
    case SONYPI_EVENT_LID_OPENED:
      fprintf(stderr, "lid opened\n");
      break;
    case SONYPI_EVENT_LID_CLOSED:
      fprintf(stderr, "lid close\n");
      break;
    case SONYPI_EVENT_FNKEY_THUMBPHRASE:
      sjog_button_faketap(2);
      //fprintf(stderr, "thumb pressed\n");
      break;
    case SONYPI_EVENT_FNKEY_ZOOM:
      sjog_zoom_handler();
      //fprintf(stderr, "zoom pressed\n");
      break;
    default:
      fprintf(stderr, "unknown event: %d\n", event );
      break;
   }

}
