/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SMSREADERSMSMESSAGE_H
#define SMSREADERSMSMESSAGE_H

#include <qdatetime.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qprocess.h>
#include <vector>
#include "qprocesssync.h"
#include "misch.h"
//#include "qextserialport.h"

namespace SMSManager {

	/**
	@author GUILLAUME Nicolas
	*/
	
	typedef enum {
		ssNative = 0,
		ssGSMlib = 1
	} SMSSendType;
	
	
	typedef struct SMSDeviceConfig {
		QString primaryDevice;
		QString secondaryDevice;
		QString baudrate;
		QString initString;
		QString serviceCentreAddress;
		bool xonxoff;
		SMSSendType library;
		
		SMSDeviceConfig()
		 : primaryDevice("/dev/mobile"), secondaryDevice(QSTRING_EMPTY),
		   baudrate(QSTRING_EMPTY), initString(QSTRING_EMPTY),
		   serviceCentreAddress(QSTRING_EMPTY),xonxoff(false), library(ssGSMlib) {}
		   
		SMSDeviceConfig(const SMSDeviceConfig& dev)
		 : primaryDevice(dev.primaryDevice), secondaryDevice(dev.secondaryDevice),
		   baudrate(dev.baudrate), initString(dev.initString),
		   serviceCentreAddress(dev.serviceCentreAddress),xonxoff(dev.xonxoff),
		   library(dev.library) {}
		   
		SMSDeviceConfig(const QString& dev1, const QString& dev2 = QSTRING_EMPTY,
		    const QString& baud = QSTRING_EMPTY, const QString& init = QSTRING_EMPTY,
		    const QString& sca = QSTRING_EMPTY, bool use_xonxoff = false,
		    SMSSendType lib = ssGSMlib)
		 : primaryDevice(dev1), secondaryDevice(dev2), baudrate(baud),
		   initString(init), serviceCentreAddress(sca), xonxoff(use_xonxoff),
		    library(lib) {} 
		   
		void appendArguments(QProcess* proc, bool useSndDev = false, bool useSCA = false,
				     bool deviceIsSource = false) const
		{
			if(!baudrate.isEmpty())
			{
				proc->addArgument("--baudrate");
				proc->addArgument(baudrate);
			}
			if( useSCA && !serviceCentreAddress.isEmpty() )
			{
				proc->addArgument("--sca");
				proc->addArgument(serviceCentreAddress);
			}
			
			if(deviceIsSource)
				proc->addArgument("-s");
			else
				proc->addArgument("--device");
				
			proc->addArgument( (useSndDev ? secondaryDevice : primaryDevice) );
			
			if(!initString.isEmpty())
			{
				proc->addArgument("--init");
				proc->addArgument(initString);
			}
			
			if(xonxoff)
				proc->addArgument("--xonxoff");
		}
		   
	} SMSDeviceConfig;
	
	typedef struct SMSContact {
		QString Name;
		QString Address;
		QString PType;
		int index;
		
		SMSContact()
		 : Name(QSTRING_EMPTY), Address(QSTRING_EMPTY), 
		   PType(QSTRING_EMPTY), index(0) {};
		   
		SMSContact(const SMSContact& sc)
		 : Name(sc.Name), Address(sc.Address), 
		   PType(sc.PType), index(sc.index) {};
		   
		SMSContact(const QString& name, const QString& address, 
		  const QString& type = QSTRING_EMPTY, int index = 0)
		 : Name(name), Address(address), PType(type), index(index) {};
		
		QString toString(const QString& pattern = PREF_CT_PATTERN3 )
		{
			if( pattern == PREF_CT_PATTERN1 )
				return QString( Name.isEmpty() ? Address : Name );
			else if( pattern == PREF_CT_PATTERN2 )
				return QString( Address );
			else
				return QString( Name.isEmpty() ? Address :
								 QString("%1 [%2]").arg(Name)
									.arg(Address) );
		}
		
		static SMSContact fromString(const QString& str)
		{
			SMSContact contact;
			QStringList lstStr = QStringList::split( '|', str, true );
			if( lstStr.count() >= 3 )
			{
				QStringList::Iterator it = lstStr.begin();
				
				contact.index = (*it).toInt(); it++;
				contact.Name = (*it); it++;
				contact.Address = (*it);
			}
			return contact;
		}
		 
	} SMSContact;
	
	
	class SMSMessage
	{

	private:
		QString strSubject, strMessage, strPDU, strType;
		QDateTime dtDate;
		SMSContact scFrom, scTo;
		
		QString convNum(const QString&) const;
		QString toBin7(const char&) const;
		QString bin2Hex(const QString&) const;
		QString convTxtPDU(const QString&) const;
		QString encode2PDU(const QString&, const QString&) const;

		void sended();
	public:
		SMSMessage();
		SMSMessage(const SMSMessage&);
		~SMSMessage();

		QDateTime date() const;
		void setDate(const QDateTime&);
		
		QString type() const;
		void setType(const QString&);
	
		QString subject() const;
		void setSubject(const QString&);
		
		QString message() const;
		void setMessage(const QString&);
		
		SMSContact from() const;
		void setFrom(const SMSContact&);
		
		SMSContact to() const;
		void setTo(const SMSContact&);
		
		QString PDU();
		void setPDU(const QString&);
		
		QString toStringHTML() const;
		
		bool sendSMS(const SMSDeviceConfig&);
		
		static SMSMessage fromString(const QString&, bool isFMAFormat = false);
	
	};
	
	typedef std::vector<SMSManager::SMSMessage> SMSMessageList;
	typedef std::vector<SMSManager::SMSContact> SMSContactList;

};

#endif
