/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef QPROCESSSYNC_H
#define QPROCESSSYNC_H

#include <qobject.h>
#include <qprocess.h>
#include <qapplication.h>
#include "misch.h"

extern QApplication *current_app;

/**
@author GUILLAUME Nicolas
*/
class QProcessSync : public QProcess
{
Q_OBJECT
private:
	bool flag_start_finished;
	QString _stdOut, _stdErr;
private slots:
	void start_finished();
	void readFromStdout();
	void readFromStderr();
public:
	QProcessSync(QObject *parent = 0, const char *name = 0);
	~QProcessSync();
	
	virtual bool startSync( QStringList * env = 0 );
	QString getStdOut() const;
	QString getStdErr() const;
};

#endif
