/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 ***************************************************************************/
#include "qlistviewitemsms.h"

QListViewItemSMS::QListViewItemSMS(QListView* parent,
				   const SMSManager::SMSMessage& mess, int index, const QString& pattern)
 : QListViewItem(parent), _index(index) //, _sms(mess) on ne stocke plus le message
					//car il l'est deja dans current_box
{
	QListViewItem::setText(0, mess.from().toString(pattern) );
	
	QListViewItem::setText(1, mess.to().toString(pattern) );
	
	
			      
	QListViewItem::setText(2, mess.message().length() <= 50 ? mess.message() :
					mess.message().left(50) + QString("...")
			      );
	QListViewItem::setText(3, mess.date().toString( "dd/MM/yyyy" ));
}


QListViewItemSMS::~QListViewItemSMS()
{
}

int QListViewItemSMS::index() const
{
	return _index;
}

QListViewItemTagInt::QListViewItemTagInt(QListView* parent, int tag, const QString& txt)
 : QListViewItem(parent), _tag(tag)
{
	QListViewItem::setText(0, txt);
}

QListViewItemTagInt::QListViewItemTagInt(QListViewItem* parent, int tag, const QString& txt)
 : QListViewItem(parent), _tag(tag)
{
	QListViewItem::setText(0, txt);
}

QListViewItemTagInt::~QListViewItemTagInt()
{
}

int QListViewItemTagInt::tag() const
{
	return _tag;
}

