/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 ***************************************************************************/


#include "newcontact.h"

using namespace SMSManager;

NewContact::NewContact(SMSManager::ContactList* cl,const QString& str,
			QWidget* parent, const char* name, WFlags fl)
: NewContactBase(parent,name,fl), strModif(str), contacts(cl)
{
	if( strModif != QSTRING_EMPTY )
	{
		this->setCaption( tr("Modification d'un contact") );
		txtName->setText( strModif );
		nums = contacts->getContactsFromName( strModif );
		
		for(SMSContactList::iterator it = nums.begin(); it != nums.end(); it++)
		{
			lstNum->insertItem( (*it).Address );
		}
		
	}
	else
		this->setCaption( tr("Nouveau contact") );
}

NewContact::~NewContact()
{
}

/*$SPECIALIZATION$*/
void NewContact::btnDelClick()
{
	QListBoxItem* item = lstNum->selectedItem();
	if( item != NULL )
	{
		nums.erase( nums.begin() + lstNum->index(item) );
		lstNum->takeItem( item );
	}
}

void NewContact::btnOKClick()
{
	if( strModif != QSTRING_EMPTY )
	{
		bool delete_more = true;
		while(delete_more)
		{
			delete_more = false;
			for(int i = 0; i < contacts->contactsCount(); i++)
			{	
				if( contacts->contact(i).Name == strModif)
				{
					contacts->removeContact(i);
					delete_more = true;
				}
			}
		}
	}

	for(SMSContactList::iterator it = nums.begin(); it != nums.end(); it++)
	{
		(*it).Name = txtName->text();
		contacts->addContact( *it );
	}
	
	this->accept();
}

void NewContact::btnAddClick()
{
	if(txtNum->text() != QSTRING_EMPTY)
	{
		lstNum->insertItem( txtNum->text() );
		nums.push_back( SMSContact( txtName->text(), txtNum->text() ) );
		txtNum->setText( QSTRING_EMPTY );
		txtNum->setFocus();
	}
}



