/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FORMMAIN_H
#define FORMMAIN_H

#include "FormMainBase.h"
#include "formnew.h"
#include "smsreceiver.h"
#include <vector>
#include <qfile.h>
#include <qtextbrowser.h>
#include <qstatusbar.h>
#include <qtimer.h>
#include <qpopupmenu.h>
#include "qlistviewitemsms.h" //listview.h,smsmessage.h
#include "appsettings.h"
#include "boxfile.h"
#include "contactlist.h"
#include "misch.h"
#include "qpopupdialog.h"
#include "newcontact.h"
#include "trayicon.h"
#include "formcfg.h"

#define DEAMON_ACTIVE 1

extern QApplication *current_app;

class FormMain : public FormMainBase
{
	Q_OBJECT
private:
	QPopupMenu* pop_systray;
	QPopupMenu* pop_contact;
	QPopupMenu* pop_message;
	
	bool flag_quit;
	
	TrayIcon *tray;
	QString current_box_id;
	BoxFile current_box;
	SMSManager::ContactList current_contacts;
	AppSettings cfg;
	std::vector<QWidget*> child;
	SMSManager::SMSReceiver *sms_deamon;
	QListViewItem * contact_item;
	
	void createSMSWin(const QString& = QSTRING_EMPTY, const QString& = QSTRING_EMPTY);
	void openBox(const QString&);
	void addMessageInBox(const QString&, const SMSManager::SMSMessage&);
	void refreshContactList();
	QString getSelectedContactName() const;
	QString getSelectedContactAddress() const;
	
	void addMessageToLV(const SMSManager::SMSMessage&, int index);


private slots:
	void sendWaitingMessages();

public:
	FormMain(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~FormMain();
	/*$PUBLIC_FUNCTIONS$*/

public slots:
	void startDeamon();
	void stopDeamon();
	void showPopup();
	void lvDblClick(QListViewItem*);
	void tvClick(QListViewItem*);
	void lvMessRightClick( QListViewItem*, const QPoint& );
	void lvTreeRightClick( QListViewItem*, const QPoint& );
	void actionNewClick();
	void actionReplyClick();
	void actionFwClick();
	void actionRedit();
	void actionDelete();
	void actionImportMess();
	void actionExportMess();
	void actionNewContact();
	void actionDelContact();
	void actionImportContactFile();
	void actionImportContactPhone();
	void actionExportContactFile();
	void actionExportContactPhone();
	void actionSyncContact();
	void actionDeleteAllContact();
	void actionModifContact();
	void actionShowHide();
	void actionNewContactMess();
	void actionConfig();
	void actionQuit();
	void actionAbout();
	
	void newMessageToSend(SMSManager::SMSMessage); //on a besoin d'une copie de l'objet sms
	void newDraftToSave(SMSManager::SMSMessage); //on a besoin d'une copie de l'objet sms
	void incomingSMS(SMSManager::SMSMessage); //on a besoin d'une copie de l'objet sms
	void deamonError(const QString&);
	void deamonStopped();
	void popupClicked();
	
	/*$PUBLIC_SLOTS$*/

protected:
	/*$PROTECTED_FUNCTIONS$*/

protected slots:
	void closeEvent(QCloseEvent*);
	/*$PROTECTED_SLOTS$*/

};

#endif

