/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 ***************************************************************************/
#include "formcfg.h"

/*	bool start_min, auto_start_deamon, show_popup;
	QString rm_phonebook, popup_sound, contact_pattern, popup_pixmap_path;
	QPixmap popup_pixmap;
	SMSManager::SMSContact contact_local;
	SMSManager::SMSDeviceConfig dev_config;
		QString primaryDevice;
		QString secondaryDevice;
		QString baudrate;
		QString initString;
		QString serviceCentreAddress;
		bool xonxoff;*/
		
FormCfg::FormCfg(QWidget* parent, AppSettings* config)
: FormCfgBase(parent, 0, false, 0), cfg(config)
{
	//membres privs utiliss ici volontairement
	
	chkMin->setChecked( cfg->start_min );
	chkDeamon->setChecked( cfg->auto_start_deamon );
	cboMPattern->setCurrentItem( misc::pattern2index(cfg->contact_pattern) - 1 );///
	txtName->setText( cfg->contact_local.Name );
	txtAddress->setText( cfg->contact_local.Address );
	chkDeamonMsg->setChecked( cfg->show_deamon_error );
	chkPrefix->setChecked( cfg->prefix_num );
	
	txtDev1->setText( cfg->dev_config.primaryDevice );
	txtDev2->setText( cfg->dev_config.secondaryDevice );
	txtBaudRate->setText( cfg->dev_config.baudrate );
	txtInitSting->setText( cfg->dev_config.initString );
	chkSCA->setChecked( !cfg->dev_config.serviceCentreAddress.isEmpty() );
	txtSCA->setText( cfg->dev_config.serviceCentreAddress );
	chkXonXoff->setChecked( cfg->dev_config.xonxoff );
	
	for(int i = 0; i < cboPB->count(); i++)
	{
		if(cboPB->text(i).left(2) == cfg->rm_phonebook)
		{
			cboPB->setCurrentItem(i);
			break;
		}
	}
	
	chkShowPopup->setChecked( cfg->show_popup );
	DB_VAR( cfg->popup_pixmap_path );
	DB_VAR( cfg->popup_sound );
	if( cfg->popup_pixmap_path == PREF_DEFAULT_IMG )
		cboImg->setCurrentItem(0);
	else
	{
		cboImg->insertItem( cfg->popup_pixmap_path, 1 );
		cboImg->setCurrentItem(1);
	}

	if( cfg->popup_sound == PREF_DEFAULT_SND )
		cboSnd->setCurrentItem(0);
	else if( cfg->popup_sound == QSTRING_EMPTY )
		cboSnd->setCurrentItem(1);
	else
	{
		cboSnd->insertItem( cfg->popup_sound, 2 );
		cboSnd->setCurrentItem(2);
	}
}

void FormCfg::saveSettings()
{
	//membres privs utiliss ici volontairement
	
	cfg->start_min = chkMin->isChecked();
	cfg->auto_start_deamon = chkDeamon->isChecked();
	cfg->contact_pattern = misc::index2pattern( cboMPattern->currentItem() + 1 );
	cfg->contact_local.Name = txtName->text();
	cfg->contact_local.Address = txtAddress->text();
	cfg->show_deamon_error = chkDeamonMsg->isChecked();
	cfg->prefix_num = chkPrefix->isChecked();

	cfg->dev_config.primaryDevice = txtDev1->text();
	cfg->dev_config.secondaryDevice = txtDev2->text();
	cfg->dev_config.baudrate = txtBaudRate->text();
	cfg->dev_config.initString = txtInitSting->text();
	cfg->dev_config.serviceCentreAddress = chkSCA->isChecked() ? txtSCA->text() : QSTRING_EMPTY;
	cfg->dev_config.xonxoff = chkXonXoff->isChecked();
	
	cfg->rm_phonebook = cboPB->currentText().left(2);
	
	cfg->show_popup = chkShowPopup->isChecked();
	
	cfg->popup_pixmap_path = (cboImg->currentItem() == 0) ? PREF_DEFAULT_IMG : cboImg->currentText();
	cfg->popup_pixmap = QPixmap::fromMimeSource( cfg->popup_pixmap_path );

	if( cboSnd->currentItem() == 0 )
		cfg->popup_sound = PREF_DEFAULT_SND;
	else if( cboSnd->currentItem() == 1 )
		cfg->popup_sound = QSTRING_EMPTY;
	else
		cfg->popup_sound = cboSnd->currentText();
	
	cfg->saveSettings();
}

FormCfg::~FormCfg()
{
}

/*$SPECIALIZATION$*/
void FormCfg::cboSndHighlighted(int index)
{
	if( index == cboSnd->count() - 1 )
	{
		QString s = QFileDialog::getOpenFileName(
				"/home",
				"Sons (*.*)",
				this,
				0,
				"Choisir un fichier" );
				
		if( index != 2 )
			cboSnd->removeItem( 2 );
		
		cboSnd->insertItem( s , 2 );
	}
}

void FormCfg::cboImgHighlighted(int index)
{
	if( index == cboImg->count() - 1 )
	{
		QString s = QFileDialog::getOpenFileName(
				"/home",
				"Images (*.png *.xpm *.jpg)",
				this,
				0,
				"Choisir un fichier" );
				
		if( index != 1 )
			cboImg->removeItem( 1 );
		
		cboImg->insertItem( s , 1 );
	}
}

void FormCfg::btnTestClick()
{
	FormMain* frm = dynamic_cast<FormMain*>( this->parent() );
	if(frm != NULL)
		frm->showPopup();
}

void FormCfg::btnOkClick()
{
	saveSettings();
	this->accept();
}

void FormCfg::btnApplyClick()
{
	saveSettings();
}




