/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SMSMANAGERCONTACTLIST_H
#define SMSMANAGERCONTACTLIST_H

#include <algorithm>
#include <qobject.h>
#include <qfile.h>
#include <qstringlist.h>
#include <qmessagebox.h>
#include <qlistview.h>
#include "qprocesssync.h"
#include "smsmessage.h"
#include "misch.h"

namespace SMSManager {

/**
@author GUILLAUME Nicolas
*/
	typedef struct {
		bool operator()(const SMSContact& x, const SMSContact& y)
		{
			return x.Name < y.Name;
		}
	} SortContact;
	
	class ContactList : public QObject
	{
	Q_OBJECT
	private:
		SMSContactList contact_list;
		QString opened_file;
		
		ContactList(const ContactList&);	
	public:
		ContactList(QObject *parent = 0, const char *name = 0);
		~ContactList();
	
		void loadFromFile(const QString&);
		void saveToFile(const QString& = QSTRING_EMPTY);
		
		bool importFromPhone(const SMSDeviceConfig&, const QString&);
		void exportToPhone(const SMSDeviceConfig&, const QString&);
		void syncWithPhone(const SMSDeviceConfig&, const QString&);
		
		int contactsCount() const;
		SMSContact contact(int index) const;
		SMSContact getContactName(const SMSContact& , bool carePrefix = true) const;
		SMSContactList getContactsFromName(const QString&);
		
		void addContact(const SMSContact&);
		void addContacts(const ContactList&);
		void removeContact(int index);
		void removeAll();
		
		void sortContacts();
		void replaceIndex();
		
		void clear();
	};

};

#endif
