/***************************************************************************
 *   Copyright (C) 2005 by GUILLAUME Nicolas                               *
 *   ng@ngsoft-fr.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef BOXFILE_H
#define BOXFILE_H

#include "smsmessage.h"
#include <qfile.h>
#include "misch.h"

/**
@author GUILLAUME Nicolas
*/
class BoxFile
{
private:
	SMSManager::SMSMessageList mess_list;
	QString opened_file;
	
	BoxFile(const BoxFile&);
public:
	BoxFile();
	~BoxFile();
	
	void refreshFromFile(const QString&, bool isFMAFile = false);
	void saveToFile(const QString& = QSTRING_EMPTY) const;
	
	int messagesCount() const;
	SMSManager::SMSMessage message(int index) const;
	void setMessage(int index, SMSManager::SMSMessage);
	
	void addMessage(const SMSManager::SMSMessage&);
	void addMessages(const BoxFile&);
	void removeMessage(int index);
	void removeAll();
	
	void clear();
};

#endif
