/*
Configbutton Plugin for toggling the keyboard light
written 2013-07-15 by Daniel Hertrich, http://www.hermocom.com

The author, Daniel Hertrich (http://www.hermocom.com), hereby waives all 
copyright and related or neighboring rights to this Plugin, pursuant to the 
Creative Commons CC0 Universal relinquishment of rights 
found at http://creativecommons.org/publicdomain/zero/1.0/ 
*/


#include "configbutton.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


typedef struct {
	int	action;
	char	path[512];
} INTERNAL;


int activate(void *internal) {
	INTERNAL *ip = internal;
	char cmdline[1024];
	FILE *fp;
	int brightness;

	if( ip->action == 0 )
	{
		sprintf(cmdline, "sudo /usr/pandora/scripts/op_kbd_light.sh on");
		system(cmdline);
	}
	else if( ip->action == 1 )
	{
		sprintf(cmdline, "sudo /usr/pandora/scripts/op_kbd_light.sh off");
		system(cmdline);
	}
	return 0;
}


int getinfo(PLUGIN_INFO *info) {
	FILE *fp;
	INTERNAL *internal = info->internal;
	int kbl_status;

	if (info->internal == NULL) {
		internal = malloc(sizeof(INTERNAL));
		internal->action = 0;
		info->internal = internal;
	}


	if ((fp = fopen("/sys/class/leds/pandora::keypad_bl/brightness", "r")) == NULL)
	{
		kbl_status = 0;
	} else
	{
		fscanf(fp,"%d",&kbl_status);
		fclose(fp);
	}


	if (kbl_status == 0)
	{
		internal->action = 0;
		info->label = "Enable Keyboard Light";
		info->icon_path = "./light_bulb_off_48.png";
	} else 
	{
		internal->action = 1;
		info->label = "Disable Keyboard Light";
		info->icon_path = "./light_bulb_on_48.png";
	}

//	info->sort_hint = 30;

	return 0;
}



