@echo off

echo LXRTF Version 1.2 by Daniel Hertrich

echo   1. Checking for errors...

if      "%1"==""    goto ERROR1
if      "%2"==""    goto ERROR1
if not  "%3"==""    goto ERROR1
if not  exist %1    goto ERROR2
if      "%1"=="%2"  goto ERROR4
if      exist %2    goto ERROR3

:CONTINUE
echo       OK. Input: %1, Output: %2
echo   2. Preparing output...

type header.rth > %2

echo   3. Processing input...
REM substitute *\ and \* because they have special meanings.
sed -e "s/\\\x2A/BaCKSLASHAsTERISK/g" -e "s/\x2A\\/AsTERISKBACKSLaSH/g" %1 > rtftemp1.tmp

REM Convert to RTF
sed -f sedrtf.sed rtftemp1.tmp >> rtftemp2.tmp

REM Convert the substitute for \* to *
sed -e "s/BaCKSLASHAsTERISK/\x2A/g"  rtftemp2.tmp > rtftemp3.tmp

REM Find out which line break behaviour to use
echo   4. Analyzing input...
xgrep AsTERISKBACKSLaSH rtftemp3.tmp > nul
if errorlevel 1 goto NOTFOUND

:FOUND
echo       Asterisk-Backslash sequence found in input file. 
echo       Using MANUAL NEWLINE formatting.
sed -e "s/AsTERISKBACKSLaSH/\x2A\\/g" -e "s/^[ \t]*$/\\par/g" rtftemp3.tmp > rtftmp3a.tmp
addspace.exe < rtftmp3a.tmp >> %2
goto finish


:NOTFOUND
echo       No Asterisk-Backslash sequence found in input file.
echo       Using 1:1 NEWLINE formatting.
sed -e "s/$/\\par&/g" rtftemp3.tmp >> %2


:finish
REM Finish RTF file and clean up
echo   5. Finishing output...
echo } >> %2
del *.tmp
echo   6. DONE.
GOTO END

:ERROR1
echo.
echo.
echo ERROR:
echo ======
echo.
echo Usage of LXRTF.BAT:
echo LXRTF INFILE OUTFILE
echo.
echo Example:
echo LXRTF example.txr example.rtf
echo.
goto END

:ERROR2
echo.
echo.
echo ERROR:
echo ======
echo.
echo FILE %1 DOES NOT EXIST!
echo.
goto END

:ERROR3
echo.
echo.
echo WARNING:
echo ========
echo.
choice /c:yn Overwrite existing output file %2? 
if errorlevel 2 goto END
if errorlevel 1 goto CONTINUE

:ERROR4
echo.
echo.
echo ERROR:
echo ======
echo.
echo Input and Output file must not be identical!
echo.
echo Example:
echo LXRTF example.txr example.rtf
echo.
goto END

:END


