# Publication implements the interface between high-level part of the system
# (Presentation/Administration scripts) and the file system level. From the
# user's point of view, publication is a unit of data, which can be displayed
# and/or managed.  There are two types of publications: single publication and
# publication collection (which is are children of this class).
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::Mode::Publication;

use strict;
use CMSsh::Messages;

my $Msg = CMSsh::Messages->new;

sub new ($$) {
    my ($class_name, $uri) = @_;
   
    unless ($uri && $uri =~ /\//) {
        warn $Msg->get('WRONG_URI', $uri);
        return undef;
    }

    my $self = {
        _uri => undef,
        _name => undef,
    };
    bless $self, $class_name;

    $self->_set_uri($uri);
    $self->_update_name;

    return $self;
}

sub _set_uri ($$) {
    my ($self, $uri) = @_;
# Remove extra leading and tailing slashes
    (my $normal_uri = $uri) =~ s/^\/*(\/.+?)\/*$/$1/;
    $self->{_uri} = $normal_uri;
}

sub get_uri ($) {
    my $self = shift;
    return $self->{_uri};
}

sub _update_name ($) {
    my $self = shift;
    $self->{_name} = ($self->{_uri} =~ /\/([^\/]+)$/) ? $1 : undef;
}

sub get_type () {
    die $Msg->get('ABSTRACT_CLASS');
}

sub _extract_type ($$) {
    my ($self, $package_name) = @_;
    return ($package_name =~ /^\w+::(.+)$/) ? $1 : undef;
}

sub get_name ($) {
    my $self = shift;
    return $self->{_name};
}

sub get_parent_uri ($) {
    my $self = shift;
    if ($self->{_uri} =~ /^(.*)\/([^\/]+)$/) {
        return $1 || '/';
    } else {
        return undef;
    }
}

1
