# The Messages class defines common messages which can be displayed to the user.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::Messages;

use strict;
use utf8;
use CMSsh::Dictionary;

my $Messages = {
# Various
    ABSTRACT_CLASS =>   "Attempt to call a method of an abstract class.",
    USE_FAILURE =>      "Failed to use the '%s' module: '%s'",
    CANT_INST_DICT =>   "Can not instantiate a dictionaty.",
    CANT_ADD_GLOSS =>   "Can not add the glossary to the dictionary.",
    CANT_ADD_PAIR =>    "Can not add the pair to the dictionary.",
    CANT_CHANGE_VAL =>  "Can not change the value of the dictionary.",
    WRONG_NAME =>       "The specified name is invalid: %s.",
    UNSUPPORTED_TYPE => "The following type is unsuported: %s.",

# Presentation
    BAD_REQUEST =>      "Malformed request.",
    TEMPLATE_ERR =>     "Can not handle the template: '%s'.",

# Publications
    WRONG_URI =>        "The specified URI is invalid: %s.",
    CANT_FIND_PUB =>    "Can not find the requested content.",
    UNKNOWN_PUB_TYPE => "Unknown type of the '%s' publication: '%s'.",
    CANT_MAKE_PUB =>    "Can not make the publication.",
    CANT_RENAME_PUB =>  "Can not rename the publication '%s' to '%s'.",
    CANT_MOVE_PUB =>    "Can not move the '%s' publication into '%s'.",
    CANT_REMOVE_PUB =>  "Can not remove the '%s' publication'.",
    CANT_PREV_PUB =>    "Can not compose a preview of the following " .
                            "publication: %s.",
    CANT_LIST_COLL =>   "Can not list the following collection of " .
                            "publications: %s.",
    CANT_INST_PUB =>    "Can not instantiate a publication by '%s' URI.",
    PUB_DOESNT_EXIST => "The following publication doesn't exist: '%s'.",
    ORPHANED_PUB =>     "Can not find parent publication of '%s'.",
    COLL_NOT_EMPTY =>   "The following publication collection is not empty: " .
                            "%s.",
    COLL_LISTING_ERR => "Error listing the following collection of " .
                            "publications: %s.",

# File system objects
    CANT_INST_FSO =>    "Can not instantiate a file or a directory by '%s'.",
    CANT_MOVE_FSO =>    "Can not move the file or directory '%s' to '%s'.",
    CANT_RENAME_FSO =>  "Can not rename the file or directory '%s' to '%s'.",
    CANT_REMOVE_FSO =>  "Can not remove the file or directory '%s'.",
    CANT_MAKE_DIR =>    "Can not make the '%s' directory in '%s'.",
    CANT_LIST_DIR =>    "Can not list the '%s' directory.",
    CANT_MAP_FSO =>     "Can not find a publication corresponding to " .
                            "the file or directory '%s'.",
    CANT_CP_RES_IMG =>  "Can not make a resized copy of the '%s' image.",
    FILE_READING_ERR => "Error getting content of the following file: %s.",
    FILE_CONT_ERR =>    "Content of the following file is invalid: %s.",
    FSO_DOESNT_EXIST => "The following file or directory doesn't exist: '%s'.",
    FSO_ALRD_EXISTS =>  "The destination file or directory already exists " .
                            "(%s).",
    LOW_LEVEL_IO_ERR => "Low level I/O error occurred: '%s'",
    CANT_INST_GD_IMG => "Can not instantiate a GD image by '%s'.",

# Publication managers
    UNKNOWN_CMD =>      "Unknown command: '%s'.",
    FORBIDDEN_OPER =>   "The requested operation is not allowed for the " .
                            "specified type.",
    NOT_ENGH_PARAMS =>  "Not enough parameters.",
    TOO_MANY_PARAMS =>  "Too many parameters specified.",
    TOO_MANY_SOURCES => "Too many sources match the '%s' pattern.",
    WRONG_DST =>        "The specified destination is wrong.",
    WRONG_SRC_NAME =>   "Wrong source file name: '%s'.",
    WRONG_SRC_EXT =>    "Wrong source file extension, '%s' expected.",
    SRC_NOT_FOUND =>    "Can not find the '%s' source.",
    OCCUPIED_URI =>     "The desired URI is occupied by '%s'.",
    CANT_PARSE_SRC =>   "Can not parse the '%s' source.",
    ROOT_PUB_OPER =>    "The administration operation is not allowed for " .
                            "root publications.",
};

sub get ($$@) {
    my ($self, $key, @args) = @_;
    my $msg_fmt = $self->{_dict}->get_value($key);
    return $msg_fmt ? sprintf $msg_fmt, @args : undef;
}

# This private method is to be called only from a constructor.
sub _install_gloss ($$) {
    my ($self, $gloss) = @_;
    $self->{_dict}->add_gloss($gloss) or die $Messages->{CANT_ADD_GLOSS};
}

sub new ($) {
    my $class_name = shift;

    my $self = {
        _dict => CMSsh::Dictionary->new($Messages),
    };
    die $Messages->{CANT_INST_DICT} unless ($self->{_dict});

    bless $self, $class_name;
    return $self;
}

1
