/*	$OpenBSD: uftdi.c,v 1.74 2015/06/18 09:47:16 mpi Exp $ 	*/
/*	$NetBSD: uftdi.c,v 1.14 2003/02/23 04:20:07 simonb Exp $	*/

/*
 * Copyright (c) 2000 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Lennart Augustsson (lennart@augustsson.net).
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * FTDI FT8U100AX serial adapter driver
 */

/*
 * XXX This driver will not support multiple serial ports.
 * XXX The ucom layer needs to be extended first.
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/kernel.h>
#include <sys/device.h>
#include <sys/conf.h>
#include <sys/tty.h>

#include <dev/usb/usb.h>

#include <dev/usb/usbdi.h>
#include <dev/usb/usbdi_util.h>
#include <dev/usb/usbdevs.h>

#include <dev/usb/ucomvar.h>

#include <dev/usb/uftdireg.h>

#ifdef UFTDI_DEBUG
#define DPRINTF(x)	do { if (uftdidebug) printf x; } while (0)
#define DPRINTFN(n,x)	do { if (uftdidebug>(n)) printf x; } while (0)
int uftdidebug = 0;
#else
#define DPRINTF(x)
#define DPRINTFN(n,x)
#endif

/*
 * These are the maximum number of bytes transferred per frame.
 * The output buffer size cannot be increased due to the size encoding.
 */
#define UFTDIIBUFSIZE 64
#define UFTDIOBUFSIZE 64

struct uftdi_softc {
	struct device		 sc_dev;		/* base device */
	struct usbd_device	*sc_udev;	/* device */
	struct usbd_interface	*sc_iface;	/* interface */

	enum uftdi_type		 sc_type;
	u_int			 sc_hdrlen;

	u_char			 sc_msr;
	u_char			 sc_lsr;

	struct device		*sc_subdev;

	u_int			 last_lcr;
};

void	uftdi_get_status(void *, int portno, u_char *lsr, u_char *msr);
void	uftdi_set(void *, int, int, int);
int	uftdi_param(void *, int, struct termios *);
int	uftdi_open(void *sc, int portno);
void	uftdi_read(void *sc, int portno, u_char **ptr,
			   u_int32_t *count);
void	uftdi_write(void *sc, int portno, u_char *to, u_char *from,
			    u_int32_t *count);
void	uftdi_break(void *sc, int portno, int onoff);
int	uftdi_8u232am_getrate(speed_t speed, int *rate);
int	uftdi_2232h_getrate(speed_t speed, int *rate);

struct ucom_methods uftdi_methods = {
	uftdi_get_status,
	uftdi_set,
	uftdi_param,
	NULL,
	uftdi_open,
	NULL,
	uftdi_read,
	uftdi_write,
};

int uftdi_match(struct device *, void *, void *);
void uftdi_attach(struct device *, struct device *, void *);
int uftdi_detach(struct device *, int);

struct cfdriver uftdi_cd = {
	NULL, "uftdi", DV_DULL
};

const struct cfattach uftdi_ca = {
	sizeof(struct uftdi_softc), uftdi_match, uftdi_attach, uftdi_detach
};

static const struct usb_devno uftdi_devs[] = {
	{ USB_VENDOR_ALTI2, USB_PRODUCT_ALTI2_NEPTUNE3 },
	{ USB_VENDOR_ANALOGDEVICES, USB_PRODUCT_ANALOGDEVICES_GNICE },
	{ USB_VENDOR_ANALOGDEVICES, USB_PRODUCT_ANALOGDEVICES_GNICEPLUS },
	{ USB_VENDOR_ATMEL, USB_PRODUCT_ATMEL_STK541 },
	{ USB_VENDOR_BAYER, USB_PRODUCT_BAYER_CONTOUR },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_232USB9M },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_485USB9F2W },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_485USB9F4W },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_485USBTB_2W },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_485USBTB_4W },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_TTL3USB9M },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_TTL5USB9M },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USO9ML2 },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USO9ML2DR },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USO9ML2DR2 },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USOPTL4 },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USOPTL4DR },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USOPTL4DR2 },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USOTL4 },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USPTL4 },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_USTL4 },
	{ USB_VENDOR_BBELECTR, USB_PRODUCT_BBELECTR_ZZ_PROG1 },
	{ USB_VENDOR_DRESDENELEC, USB_PRODUCT_DRESDENELEC_STB },
	{ USB_VENDOR_DRESDENELEC, USB_PRODUCT_DRESDENELEC_WHT },
	{ USB_VENDOR_ELEKTOR, USB_PRODUCT_ELEKTOR_FT323R },
	{ USB_VENDOR_EVOLUTION, USB_PRODUCT_EVOLUTION_ER1 },
	{ USB_VENDOR_EVOLUTION, USB_PRODUCT_EVOLUTION_RCM4_1 },
	{ USB_VENDOR_EVOLUTION, USB_PRODUCT_EVOLUTION_RCM4_2 },
	{ USB_VENDOR_FALCOM, USB_PRODUCT_FALCOM_SAMBA },
	{ USB_VENDOR_FALCOM, USB_PRODUCT_FALCOM_TWIST },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ACCESSO },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ACG_HFDUAL },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ACTROBOTS },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ACTZWAVE },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_AMC232 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ARTEMIS },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_1 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_2 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_3 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_4 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_5 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_6 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_7 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ASK_RDR4X7_8 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ATK16 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ATK16C },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ATK16HR },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ATK16HRC },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ATK16IC },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_BCS_SE923 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CANDAPTER },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CANUSB },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CCS_ICDU20 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CCS_ICDU40 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CCS_ICDU64 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CCS_LOAD_N_GO },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CCS_MACHX },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CCS_PRIME8 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_CHAMELEON },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_COASTAL_TNCX },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_DGQG },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_DMX4ALL },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_DUSB },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ECLO_1WIRE },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ECO_PRO },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_EISCOU },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_ALC8500 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_CLI7000 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_CSI8 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_EM1000DL },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_EM1010PC },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_FEM },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_FHZ1000PC },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_FHZ1300PC },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_FM3RX },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_FS20SIG },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_HS485 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_KL100 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_MSM1 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_PCD200 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_PCK100 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_PPS7330 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_RFP500 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_T1100 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_TFD128 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_TFM100 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_TWS550 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UAD7 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UAD8 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UDF77 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UIO88 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_ULA200 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UM100 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UMS100 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UO100 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UR100 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_USI2 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_USR },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_UTP8 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_WS300PC },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_WS444PC },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_WS500 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_WS550 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_WS777 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_ELV_WS888 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FISCO },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT232RL },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT232_1 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT232_3 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT232_4 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT232_5 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT232_6 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FT4232H },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_FTX },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GAMMASCOUT },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_1 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_2 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_3 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_4 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_5 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_6 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_7 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_8 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_9 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_A },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_GUDE_B },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_HO820 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_HO870 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_1 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_APP70 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_PCMCIA },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_PEDO },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_PICPRO },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_PK1 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_RS232MON },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IBS_US485 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IPLUS },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_IPLUS2 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_JTAGCABLEII },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_547 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_631 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_632 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_633 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_634 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_635 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_640 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_CFA_642 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_LK202_24 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_LK204_24 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_MTXO },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LCD_MX200 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LINX_1 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LINX_2 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LINX_3 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LINX_MASTER2 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LM3S_DEVEL },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LM3S_EVAL },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_LOCOBUFFER },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MATRIX_2 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MATRIX_3 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_DB9 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_IC },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_KW },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_RS232 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_Y6 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_Y8 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_Y9 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MHAM_YS },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MJS_SIRIUS_PC_1 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_MJS_SIRIUS_PC_2 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_NXTCAM },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OCEANIC },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OOCDLINK },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENDCC },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENDCC_GATEWAY },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENDCC_SNIFFER },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENDCC_THROTTLE },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENPORT_13M },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENPORT_13S },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENPORT_13U },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_OPENRD },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PCDJ_DAC2 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PIEGROUP_IR },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PROTEGO_1 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PROTEGO_3 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PROTEGO_4 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PROTEGO_R200 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_PYRAMID },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_R2000KU_RNG },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_RELAIS },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_REU_TINY },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_0 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_1 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_2 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_3 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_4 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_5 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_6 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SCS_7 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SEMC_DSS20 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_2232C },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_2232L },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_232BM },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_8U100AX },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_8U232AM },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SERIAL_8U232AM4 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_SPROG_II },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_TERATRONIK_D2XX },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_TERATRONIK_VCP },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_THORLABS },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_TIRA1 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_TNCX },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_TURTELIZER_JTAG },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_UNICOM },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_UOPTBR },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_USBSERIAL },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_USBUIRT },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_USBX_707 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_VNHC },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_WESTREX_777 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_WESTREX_8900F },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_1 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_2 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_3 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_4 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_5 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_6 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_7 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_XSENS_8 },
	{ USB_VENDOR_FTDI, USB_PRODUCT_FTDI_YEI_SC31 },
	{ USB_VENDOR_GNOTOMETRICS, USB_PRODUCT_GNOTOMETRICS_AURICAL },
	{ USB_VENDOR_ICOM, USB_PRODUCT_ICOM_ID1 },
	{ USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2000VR },
	{ USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2000VT },
	{ USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2C1 },
	{ USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2C2 },
	{ USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2D },
	{ USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2VR },
	{ USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP2VT },
	{ USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP4000VR },
	{ USB_VENDOR_ICOM, USB_PRODUCT_ICOM_RP4000VT },
	{ USB_VENDOR_IDTECH, USB_PRODUCT_IDTECH_SERIAL },
	{ USB_VENDOR_INTERBIO, USB_PRODUCT_INTERBIO_IOBOARD },
	{ USB_VENDOR_INTERBIO, USB_PRODUCT_INTERBIO_MINIIOBOARD },
	{ USB_VENDOR_INTERBIO, USB_PRODUCT_INTERBIO_MINIIOBOARD2 },
	{ USB_VENDOR_INTREPIDCS, USB_PRODUCT_INTREPIDCS_NEOVI },
	{ USB_VENDOR_INTREPIDCS, USB_PRODUCT_INTREPIDCS_VALUECAN },
	{ USB_VENDOR_IODATA, USB_PRODUCT_IODATA_FT232R },
	{ USB_VENDOR_JETI, USB_PRODUCT_JETI_SPC1201 },
	{ USB_VENDOR_KOBIL, USB_PRODUCT_KOBIL_B1 },
	{ USB_VENDOR_KOBIL, USB_PRODUCT_KOBIL_KAAN },
	{ USB_VENDOR_LARSENBRUSGAARD, USB_PRODUCT_LARSENBRUSGAARD_ALTITRACK },
	{ USB_VENDOR_MARVELL, USB_PRODUCT_MARVELL_SHEEVAPLUG },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0100 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0101 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0102 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0103 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0104 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0105 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0106 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0107 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0108 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0109 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_010A },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_010B },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_010C },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_010D },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_010E },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_010F },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0110 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0111 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0112 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0113 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0114 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0115 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0116 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0117 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0118 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0119 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_011A },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_011B },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_011C },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_011D },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_011E },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_011F },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0120 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0121 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0122 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0123 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0124 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0125 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0126 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0127 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0128 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0129 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_012A },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_012B },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_012C },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_012D },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_012E },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_012F },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0130 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0131 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0132 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0133 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0134 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0135 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0136 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0137 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0138 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0139 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_013A },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_013B },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_013C },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_013D },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_013E },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_013F },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0140 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0141 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0142 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0143 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0144 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0145 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0146 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0147 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0148 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0149 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_014A },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_014B },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_014C },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_014D },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_014E },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_014F },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0150 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0151 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0152 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0153 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0154 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0155 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0156 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0157 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0158 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0159 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_015A },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_015B },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_015C },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_015D },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_015E },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_015F },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0160 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0161 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0162 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0163 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0164 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0165 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0166 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0167 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0168 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0169 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_016A },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_016B },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_016C },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_016D },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_016E },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_016F },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0170 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0171 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0172 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0173 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0174 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0175 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0176 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0177 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0178 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0179 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_017A },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_017B },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_017C },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_017D },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_017E },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_017F },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0180 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0181 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0182 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0183 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0184 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0185 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0186 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0187 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0188 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0189 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_018A },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_018B },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_018C },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_018D },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_018E },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_018F },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0190 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0191 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0192 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0193 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0194 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0195 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0196 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0197 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0198 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_0199 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_019A },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_019B },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_019C },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_019D },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_019E },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_019F },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A0 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A1 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A2 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A3 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A4 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A5 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A6 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A7 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A8 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01A9 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01AA },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01AB },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01AC },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01AD },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01AE },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01AF },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B0 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B1 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B2 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B3 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B4 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B5 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B6 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B7 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B8 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01B9 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01BA },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01BB },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01BC },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01BD },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01BE },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01BF },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C0 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C1 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C2 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C3 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C4 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C5 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C6 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C7 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C8 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01C9 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01CA },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01CB },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01CC },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01CD },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01CE },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01CF },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D0 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D1 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D2 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D3 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D4 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D5 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D6 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D7 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D8 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01D9 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01DA },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01DB },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01DC },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01DD },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01DE },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01DF },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E0 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E1 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E2 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E3 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E4 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E5 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E6 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E7 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E8 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01E9 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01EA },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01EB },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01EC },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01ED },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01EE },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01EF },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F0 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F1 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F2 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F3 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F4 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F5 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F6 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F7 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F8 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01F9 },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01FA },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01FB },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01FC },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01FD },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01FE },
	{ USB_VENDOR_MATRIXORB, USB_PRODUCT_MATRIXORB_LCD_01FF },
	{ USB_VENDOR_MECANIQUE, USB_PRODUCT_MECANIQUE_TELLSTICK },
	{ USB_VENDOR_MELCO, USB_PRODUCT_MELCO_PCOPRS1 },
	{ USB_VENDOR_MOBILITY, USB_PRODUCT_MOBILITY_ED200H },
	{ USB_VENDOR_OCT, USB_PRODUCT_OCT_US2308 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_AD4USB },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_AP485_1 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_AP485_2 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_DRAK5 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_DRAK6 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_GOLIATH_MSR },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_GOLIATH_MUX },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_IRAMP },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_LEC },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_MUC },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO101 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO216 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO22 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO303 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO332 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO44 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO603 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_QUIDO88 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB232 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB422_1 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB422_2 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB485C },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB485S },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB485_1 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SB485_2 },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SERIAL },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_SIMUKEY },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_STAVOVY },
	{ USB_VENDOR_PAPOUCH, USB_PRODUCT_PAPOUCH_TMU },
	{ USB_VENDOR_POSIFLEX, USB_PRODUCT_POSIFLEX_PP7000_1 },
	{ USB_VENDOR_POSIFLEX, USB_PRODUCT_POSIFLEX_PP7000_2 },
	{ USB_VENDOR_RATOC, USB_PRODUCT_RATOC_REXUSB60F },
	{ USB_VENDOR_RTSYSTEMS, USB_PRODUCT_RTSYSTEMS_CT57B },
	{ USB_VENDOR_SACOM, USB_PRODUCT_SACOM_USB485BL },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2101 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2102 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2103 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2104 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2106 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2201_1 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2201_2 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2202_1 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2202_2 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2203_1 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2203_2 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2401_1 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2401_2 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2401_3 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2401_4 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2402_1 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2402_2 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2402_3 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2402_4 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2403_1 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2403_2 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2403_3 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2403_4 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_1 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_2 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_3 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_4 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_5 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_6 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_7 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2801_8 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_1 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_2 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_3 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_4 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_5 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_6 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_7 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2802_8 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_1 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_2 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_3 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_4 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_5 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_6 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_7 },
	{ USB_VENDOR_SEALEVEL, USB_PRODUCT_SEALEVEL_2803_8 },
	{ USB_VENDOR_STOLLMANN, USB_PRODUCT_STOLLMANN_ISDN_TA_USBA },
	{ USB_VENDOR_TESTO, USB_PRODUCT_TESTO_174 },
	{ USB_VENDOR_TESTO, USB_PRODUCT_TESTO_175 },
	{ USB_VENDOR_TESTO, USB_PRODUCT_TESTO_330 },
	{ USB_VENDOR_TESTO, USB_PRODUCT_TESTO_435 },
	{ USB_VENDOR_TESTO, USB_PRODUCT_TESTO_556 },
	{ USB_VENDOR_TESTO, USB_PRODUCT_TESTO_580 },
	{ USB_VENDOR_TESTO, USB_PRODUCT_TESTO_845 },
	{ USB_VENDOR_TESTO, USB_PRODUCT_TESTO_SERIAL_1 },
	{ USB_VENDOR_TESTO, USB_PRODUCT_TESTO_SERIAL_2 },
	{ USB_VENDOR_TESTO, USB_PRODUCT_TESTO_SERVICE },
	{ USB_VENDOR_THURLBY, USB_PRODUCT_THURLBY_QL355P },
	{ USB_VENDOR_TML, USB_PRODUCT_TML_SERIAL },
	{ USB_VENDOR_UNKNOWN5, USB_PRODUCT_UNKNOWN5_NF_RIC }
};

int
uftdi_match(struct device *parent, void *match, void *aux)
{
	struct usb_attach_arg *uaa = aux;

	if (uaa->iface == NULL || uaa->configno != 1)
		return (UMATCH_NONE);

	if (usb_lookup(uftdi_devs, uaa->vendor, uaa->product) == NULL)
		return (UMATCH_NONE);

	/* JTAG on USB interface 0 */
	if (uaa->vendor == USB_VENDOR_FTDI &&
	    uaa->product == USB_PRODUCT_FTDI_OPENRD &&
	    uaa->ifaceno == 0)
		return (UMATCH_NONE);

	return (UMATCH_VENDOR_PRODUCT_CONF_IFACE);
}

void
uftdi_attach(struct device *parent, struct device *self, void *aux)
{
	struct uftdi_softc *sc = (struct uftdi_softc *)self;
	struct usb_attach_arg *uaa = aux;
	usb_interface_descriptor_t *id;
	usb_endpoint_descriptor_t *ed;
	char *devname = sc->sc_dev.dv_xname;
	struct ucom_attach_args uca;
	int i;

	sc->sc_udev = uaa->device;
	sc->sc_iface = uaa->iface;

	if (uaa->release < 0x0200) {
		sc->sc_type = UFTDI_TYPE_SIO;
		sc->sc_hdrlen = 1;
	} else if (uaa->release == 0x0700  || uaa->release == 0x0800) {
		sc->sc_type = UFTDI_TYPE_2232H;
		sc->sc_hdrlen = 0;
	} else {
		sc->sc_type = UFTDI_TYPE_8U232AM;
		sc->sc_hdrlen = 0;
	}

	uca.bulkin = uca.bulkout = -1;
	id = usbd_get_interface_descriptor(sc->sc_iface);
	for (i = 0; i < id->bNumEndpoints; i++) {
		int addr, dir, attr;
		ed = usbd_interface2endpoint_descriptor(sc->sc_iface, i);
		if (ed == NULL) {
			printf("%s: could not read endpoint descriptor\n",
			    devname);
			goto bad;
		}

		addr = ed->bEndpointAddress;
		dir = UE_GET_DIR(ed->bEndpointAddress);
		attr = ed->bmAttributes & UE_XFERTYPE;
		if (dir == UE_DIR_IN && attr == UE_BULK) {
			uca.bulkin = addr;
			uca.ibufsize = (UGETW(ed->wMaxPacketSize) > 0) ?
			    UGETW(ed->wMaxPacketSize) : UFTDIIBUFSIZE;
		} else if (dir == UE_DIR_OUT && attr == UE_BULK) {
			uca.bulkout = addr;
			uca.obufsize = (UGETW(ed->wMaxPacketSize) > 0) ?
			    UGETW(ed->wMaxPacketSize) : UFTDIOBUFSIZE;
			uca.obufsize-= sc->sc_hdrlen;
		} else {
			printf("%s: unexpected endpoint\n", devname);
			goto bad;
		}
	}
	if (uca.bulkin == -1) {
		printf("%s: Could not find data bulk in\n",
		       sc->sc_dev.dv_xname);
		goto bad;
	}
	if (uca.bulkout == -1) {
		printf("%s: Could not find data bulk out\n",
		       sc->sc_dev.dv_xname);
		goto bad;
	}

	if (uaa->iface == NULL)
		uca.portno = FTDI_PIT_SIOA;
	else
		uca.portno = FTDI_PIT_SIOA + id->bInterfaceNumber;
	/* bulkin, bulkout set above */
	uca.ibufsizepad = uca.ibufsize;
	uca.opkthdrlen = sc->sc_hdrlen;
	uca.device = sc->sc_udev;
	uca.iface = sc->sc_iface;
	uca.methods = &uftdi_methods;
	uca.arg = sc;
	uca.info = NULL;

	DPRINTF(("uftdi: in=0x%x out=0x%x\n", uca.bulkin, uca.bulkout));
	sc->sc_subdev = config_found_sm(self, &uca, ucomprint, ucomsubmatch);

	return;

bad:
	DPRINTF(("uftdi_attach: ATTACH ERROR\n"));
	usbd_deactivate(sc->sc_udev);
}

int
uftdi_detach(struct device *self, int flags)
{
	struct uftdi_softc *sc = (struct uftdi_softc *)self;

	DPRINTF(("uftdi_detach: sc=%p flags=%d\n", sc, flags));
	if (sc->sc_subdev != NULL) {
		config_detach(sc->sc_subdev, flags);
		sc->sc_subdev = NULL;
	}

	return (0);
}

int
uftdi_open(void *vsc, int portno)
{
	struct uftdi_softc *sc = vsc;
	usb_device_request_t req;
	usbd_status err;
	struct termios t;

	DPRINTF(("uftdi_open: sc=%p\n", sc));

	if (usbd_is_dying(sc->sc_udev))
		return (EIO);

	/* Perform a full reset on the device */
	req.bmRequestType = UT_WRITE_VENDOR_DEVICE;
	req.bRequest = FTDI_SIO_RESET;
	USETW(req.wValue, FTDI_SIO_RESET_SIO);
	USETW(req.wIndex, portno);
	USETW(req.wLength, 0);
	err = usbd_do_request(sc->sc_udev, &req, NULL);
	if (err)
		return (EIO);

	/* Set 9600 baud, 2 stop bits, no parity, 8 bits */
	t.c_ospeed = 9600;
	t.c_cflag = CSTOPB | CS8;
	(void)uftdi_param(sc, portno, &t);

	/* Turn on RTS/CTS flow control */
	req.bmRequestType = UT_WRITE_VENDOR_DEVICE;
	req.bRequest = FTDI_SIO_SET_FLOW_CTRL;
	USETW(req.wValue, 0);
	USETW2(req.wIndex, FTDI_SIO_RTS_CTS_HS, portno);
	USETW(req.wLength, 0);
	err = usbd_do_request(sc->sc_udev, &req, NULL);
	if (err)
		return (EIO);

	return (0);
}

void
uftdi_read(void *vsc, int portno, u_char **ptr, u_int32_t *count)
{
	struct uftdi_softc *sc = vsc;
	u_char msr, lsr;

	DPRINTFN(15,("uftdi_read: sc=%p, port=%d count=%d\n", sc, portno,
		     *count));

	msr = FTDI_GET_MSR(*ptr);
	lsr = FTDI_GET_LSR(*ptr);

#ifdef UFTDI_DEBUG
	if (*count != 2)
		DPRINTFN(10,("uftdi_read: sc=%p, port=%d count=%d data[0]="
			    "0x%02x\n", sc, portno, *count, (*ptr)[2]));
#endif

	if (sc->sc_msr != msr ||
	    (sc->sc_lsr & FTDI_LSR_MASK) != (lsr & FTDI_LSR_MASK)) {
		DPRINTF(("uftdi_read: status change msr=0x%02x(0x%02x) "
			 "lsr=0x%02x(0x%02x)\n", msr, sc->sc_msr,
			 lsr, sc->sc_lsr));
		sc->sc_msr = msr;
		sc->sc_lsr = lsr;
		ucom_status_change((struct ucom_softc *)sc->sc_subdev);
	}

	/* Pick up status and adjust data part. */
	*ptr += 2;
	*count -= 2;
}

void
uftdi_write(void *vsc, int portno, u_char *to, u_char *from, u_int32_t *count)
{
	struct uftdi_softc *sc = vsc;

	DPRINTFN(10,("uftdi_write: sc=%p, port=%d count=%u data[0]=0x%02x\n",
		     vsc, portno, *count, from[0]));

	/* Make length tag and copy data */
	if (sc->sc_hdrlen > 0)
		*to = FTDI_OUT_TAG(*count, portno);

	memcpy(to + sc->sc_hdrlen, from, *count);
	*count += sc->sc_hdrlen;
}

void
uftdi_set(void *vsc, int portno, int reg, int onoff)
{
	struct uftdi_softc *sc = vsc;
	usb_device_request_t req;
	int ctl;

	DPRINTF(("uftdi_set: sc=%p, port=%d reg=%d onoff=%d\n", vsc, portno,
		 reg, onoff));

	switch (reg) {
	case UCOM_SET_DTR:
		ctl = onoff ? FTDI_SIO_SET_DTR_HIGH : FTDI_SIO_SET_DTR_LOW;
		break;
	case UCOM_SET_RTS:
		ctl = onoff ? FTDI_SIO_SET_RTS_HIGH : FTDI_SIO_SET_RTS_LOW;
		break;
	case UCOM_SET_BREAK:
		uftdi_break(sc, portno, onoff);
		return;
	default:
		return;
	}
	req.bmRequestType = UT_WRITE_VENDOR_DEVICE;
	req.bRequest = FTDI_SIO_MODEM_CTRL;
	USETW(req.wValue, ctl);
	USETW(req.wIndex, portno);
	USETW(req.wLength, 0);
	DPRINTFN(2,("uftdi_set: reqtype=0x%02x req=0x%02x value=0x%04x "
		    "index=0x%04x len=%d\n", req.bmRequestType, req.bRequest,
		    UGETW(req.wValue), UGETW(req.wIndex), UGETW(req.wLength)));
	(void)usbd_do_request(sc->sc_udev, &req, NULL);
}

int
uftdi_param(void *vsc, int portno, struct termios *t)
{
	struct uftdi_softc *sc = vsc;
	usb_device_request_t req;
	usbd_status err;
	int rate, data, flow;

	DPRINTF(("uftdi_param: sc=%p\n", sc));

	if (usbd_is_dying(sc->sc_udev))
		return (EIO);

	switch (sc->sc_type) {
	case UFTDI_TYPE_SIO:
		switch (t->c_ospeed) {
		case 300: rate = ftdi_sio_b300; break;
		case 600: rate = ftdi_sio_b600; break;
		case 1200: rate = ftdi_sio_b1200; break;
		case 2400: rate = ftdi_sio_b2400; break;
		case 4800: rate = ftdi_sio_b4800; break;
		case 9600: rate = ftdi_sio_b9600; break;
		case 19200: rate = ftdi_sio_b19200; break;
		case 38400: rate = ftdi_sio_b38400; break;
		case 57600: rate = ftdi_sio_b57600; break;
		case 115200: rate = ftdi_sio_b115200; break;
		default:
			return (EINVAL);
		}
		break;

	case UFTDI_TYPE_8U232AM:
		if (uftdi_8u232am_getrate(t->c_ospeed, &rate) == -1)
			return (EINVAL);
		break;
	case UFTDI_TYPE_2232H:
		if (uftdi_2232h_getrate(t->c_ospeed, &rate) == -1)
			 return (EINVAL);
		break;
	}
	req.bmRequestType = UT_WRITE_VENDOR_DEVICE;
	req.bRequest = FTDI_SIO_SET_BAUD_RATE;
	USETW(req.wValue, rate);
	USETW(req.wIndex, ((rate >> 8) & 0xFF00) | portno);
	USETW(req.wLength, 0);
	DPRINTFN(2,("uftdi_param: reqtype=0x%02x req=0x%02x value=0x%04x "
		    "index=0x%04x len=%d\n", req.bmRequestType, req.bRequest,
		    UGETW(req.wValue), UGETW(req.wIndex), UGETW(req.wLength)));
	err = usbd_do_request(sc->sc_udev, &req, NULL);
	if (err)
		return (EIO);

	if (ISSET(t->c_cflag, CSTOPB))
		data = FTDI_SIO_SET_DATA_STOP_BITS_2;
	else
		data = FTDI_SIO_SET_DATA_STOP_BITS_1;
	if (ISSET(t->c_cflag, PARENB)) {
		if (ISSET(t->c_cflag, PARODD))
			data |= FTDI_SIO_SET_DATA_PARITY_ODD;
		else
			data |= FTDI_SIO_SET_DATA_PARITY_EVEN;
	} else
		data |= FTDI_SIO_SET_DATA_PARITY_NONE;
	switch (ISSET(t->c_cflag, CSIZE)) {
	case CS5:
		data |= FTDI_SIO_SET_DATA_BITS(5);
		break;
	case CS6:
		data |= FTDI_SIO_SET_DATA_BITS(6);
		break;
	case CS7:
		data |= FTDI_SIO_SET_DATA_BITS(7);
		break;
	case CS8:
		data |= FTDI_SIO_SET_DATA_BITS(8);
		break;
	}
	sc->last_lcr = data;

	req.bmRequestType = UT_WRITE_VENDOR_DEVICE;
	req.bRequest = FTDI_SIO_SET_DATA;
	USETW(req.wValue, data);
	USETW(req.wIndex, portno);
	USETW(req.wLength, 0);
	DPRINTFN(2,("uftdi_param: reqtype=0x%02x req=0x%02x value=0x%04x "
		    "index=0x%04x len=%d\n", req.bmRequestType, req.bRequest,
		    UGETW(req.wValue), UGETW(req.wIndex), UGETW(req.wLength)));
	err = usbd_do_request(sc->sc_udev, &req, NULL);
	if (err)
		return (EIO);

	if (ISSET(t->c_cflag, CRTSCTS)) {
		flow = FTDI_SIO_RTS_CTS_HS;
		USETW(req.wValue, 0);
	} else if (ISSET(t->c_iflag, IXON|IXOFF)) {
		flow = FTDI_SIO_XON_XOFF_HS;
		USETW2(req.wValue, t->c_cc[VSTOP], t->c_cc[VSTART]);
	} else {
		flow = FTDI_SIO_DISABLE_FLOW_CTRL;
		USETW(req.wValue, 0);
	}
	req.bmRequestType = UT_WRITE_VENDOR_DEVICE;
	req.bRequest = FTDI_SIO_SET_FLOW_CTRL;
	USETW2(req.wIndex, flow, portno);
	USETW(req.wLength, 0);
	err = usbd_do_request(sc->sc_udev, &req, NULL);
	if (err)
		return (EIO);

	return (0);
}

void
uftdi_get_status(void *vsc, int portno, u_char *lsr, u_char *msr)
{
	struct uftdi_softc *sc = vsc;

	DPRINTF(("uftdi_status: msr=0x%02x lsr=0x%02x\n",
		 sc->sc_msr, sc->sc_lsr));

	if (msr != NULL)
		*msr = sc->sc_msr;
	if (lsr != NULL)
		*lsr = sc->sc_lsr;
}

void
uftdi_break(void *vsc, int portno, int onoff)
{
	struct uftdi_softc *sc = vsc;
	usb_device_request_t req;
	int data;

	DPRINTF(("uftdi_break: sc=%p, port=%d onoff=%d\n", vsc, portno,
		  onoff));

	if (onoff) {
		data = sc->last_lcr | FTDI_SIO_SET_BREAK;
	} else {
		data = sc->last_lcr;
	}

	req.bmRequestType = UT_WRITE_VENDOR_DEVICE;
	req.bRequest = FTDI_SIO_SET_DATA;
	USETW(req.wValue, data);
	USETW(req.wIndex, portno);
	USETW(req.wLength, 0);
	(void)usbd_do_request(sc->sc_udev, &req, NULL);
}

int
uftdi_8u232am_getrate(speed_t speed, int *rate)
{
	/* Table of the nearest even powers-of-2 for values 0..15. */
	static const unsigned char roundoff[16] = {
		0, 2, 2, 4,  4,  4,  8,  8,
		8, 8, 8, 8, 16, 16, 16, 16,
	};

	unsigned int d, freq;
	int result;

	if (speed <= 0)
		return (-1);

	/* Special cases for 2M and 3M. */
	if (speed >= 3000000 * 100 / 103 &&
	    speed <= 3000000 * 100 / 97) {
		result = 0;
		goto done;
	}
	if (speed >= 2000000 * 100 / 103 &&
	    speed <= 2000000 * 100 / 97) {
		result = 1;
		goto done;
	}

	d = (FTDI_8U232AM_FREQ << 4) / speed;
	d = (d & ~15) + roundoff[d & 15];

	if (d < FTDI_8U232AM_MIN_DIV)
		d = FTDI_8U232AM_MIN_DIV;
	else if (d > FTDI_8U232AM_MAX_DIV)
		d = FTDI_8U232AM_MAX_DIV;

	/* 
	 * Calculate the frequency needed for d to exactly divide down
	 * to our target speed, and check that the actual frequency is
	 * within 3% of this.
	 */
	freq = speed * d;
	if (freq < (quad_t)(FTDI_8U232AM_FREQ << 4) * 100 / 103 ||
	    freq > (quad_t)(FTDI_8U232AM_FREQ << 4) * 100 / 97)
		return (-1);

	/* 
	 * Pack the divisor into the resultant value.  The lower
	 * 14-bits hold the integral part, while the upper 2 bits
	 * encode the fractional component: either 0, 0.5, 0.25, or
	 * 0.125.
	 */
	result = d >> 4;
	if (d & 8)
		result |= 0x4000;
	else if (d & 4)
		result |= 0x8000;
	else if (d & 2)
		result |= 0xc000;

done:
	*rate = result;
	return (0);
}

int
uftdi_2232h_getrate(speed_t speed, int *rate)
{
	char sub[8] = {0, 3, 2, 4, 1, 5, 6, 7};
	int n = (FTDI_2232H_FREQ << 3) / speed;
	int s = n & 7;
	int result = (n >> 3) | (sub[s] << 14);
	int resultspeed, accuracy;

	/* Special cases */
	if (result == 1)
		result = 0;
	else if (result == 0x4001)
		result = 1;

	/* Check if resulting baud rate is within 3%. */
	if (result == 0)
		goto done;
	resultspeed = (FTDI_2232H_FREQ << 3) /
	    (((result & 0x00003FFF) << 3) | s);
	accuracy = (abs(speed - resultspeed) * 100) / speed;
	if (accuracy > 3)
		return -1;

done:
	result|= 0x00020000; /* Set this bit to turn off a divide by 2.5 */
	*rate = result;
	return 0;
}
