/*	$OpenBSD: udl_huffman.h,v 1.4 2009/08/26 12:32:27 mglocker Exp $ */

/*
 * Huffman table for pixel difference compression.
 *
 * This table has been captured by Florian Echtler <floe@butterbrot.org>.
 *
 * For now we don't know how to program generate the table.  If someone
 * comes up with a solution, you're most welcome.  The algorythm could
 * be hidden in the 4kB decompression table (udl_decomp_table[]) which
 * is sent to the device at initialization time.
 */

#define UDL_HUFFMAN_RECORDS 65536 + 1

struct record {
	uint32_t	bit_count;
	uint32_t	bit_pattern;
} udl_huffman[] = {
	{ 20, 966905 },
	{ 20, 954617 },
	{ 20, 957689 },
	{ 20, 973053 },
	{ 22, 1794297 },
	{ 22, 1732857 },
	{ 22, 2007289 },
	{ 22, 1880313 },
	{ 22, 1499385 },
	{ 22, 1372409 },
	{ 22, 1941753 },
	{ 22, 1683705 },
	{ 22, 909561 },
	{ 22, 651513 },
	{ 20, 499961 },
	{ 20, 241913 },
	{ 15, 7530 },
	{ 20, 243193 },
	{ 20, 501241 },
	{ 22, 652793 },
	{ 22, 910841 },
	{ 22, 1684985 },
	{ 22, 1943033 },
	{ 22, 1373689 },
	{ 22, 1500665 },
	{ 22, 1881593 },
	{ 22, 2075129 },
	{ 22, 1812985 },
	{ 22, 1026553 },
	{ 20, 507389 },
	{ 20, 502265 },
	{ 20, 240121 },
	{ 20, 967161 },
	{ 20, 954873 },
	{ 20, 957945 },
	{ 20, 973309 },
	{ 22, 1794553 },
	{ 22, 1733113 },
	{ 22, 2007545 },
	{ 22, 1880569 },
	{ 22, 1499641 },
	{ 22, 1372665 },
	{ 22, 1942009 },
	{ 22, 1683961 },
	{ 22, 909817 },
	{ 22, 651769 },
	{ 20, 500217 },
	{ 20, 242169 },
	{ 15, 23914 },
	{ 20, 254461 },
	{ 20, 516605 },
	{ 22, 778749 },
	{ 22, 1040893 },
	{ 22, 1827325 },
	{ 22, 2089469 },
	{ 23, 2875901 },
	{ 23, 3138045 },
	{ 23, 3924477 },
	{ 23, 4186621 },
	{ 24, 7856889 },
	{ 24, 6808313 },
	{ 24, 3662585 },
	{ 22, 2011901 },
	{ 22, 1565433 },
	{ 22, 516857 },
	{ 22, 3801849 },
	{ 22, 2048761 },
	{ 22, 3896057 },
	{ 22, 4088573 },
	{ 24, 6914809 },
	{ 23, 4047609 },
	{ 24, 7504633 },
	{ 24, 5948153 },
	{ 24, 5473017 },
	{ 23, 3916537 },
	{ 24, 6718201 },
	{ 24, 3588857 },
	{ 24, 2589433 },
	{ 22, 1557241 },
	{ 22, 951033 },
	{ 17, 12266 },
	{ 22, 1020921 },
	{ 22, 2020345 },
	{ 24, 3052537 },
	{ 24, 3658745 },
	{ 24, 6788089 },
	{ 24, 7787513 },
	{ 25, 16245753 },
	{ 24, 6018041 },
	{ 24, 7574521 },
	{ 24, 8049657 },
	{ 24, 7857145 },
	{ 24, 6808569 },
	{ 24, 3662841 },
	{ 22, 2012157 },
	{ 22, 1565689 },
	{ 22, 517113 },
	{ 22, 3802105 },
	{ 22, 2049017 },
	{ 22, 3896313 },
	{ 22, 4088829 },
	{ 24, 6915065 },
	{ 23, 4047865 },
	{ 24, 7504889 },
	{ 24, 5948409 },
	{ 24, 5473273 },
	{ 23, 3916793 },
	{ 24, 6718457 },
	{ 24, 3589113 },
	{ 24, 2589689 },
	{ 22, 1557497 },
	{ 22, 951289 },
	{ 17, 28650 },
	{ 22, 1038073 },
	{ 22, 2070265 },
	{ 24, 3069689 },
	{ 24, 4101881 },
	{ 24, 6805241 },
	{ 24, 7837433 },
	{ 25, 10934009 },
	{ 25, 16230137 },
	{ 24, 7591673 },
	{ 24, 8099577 },
	{ 24, 7862013 },
	{ 24, 7841529 },
	{ 24, 6792953 },
	{ 24, 3647225 },
	{ 22, 1570557 },
	{ 22, 1550073 },
	{ 22, 501497 },
	{ 22, 2033401 },
	{ 22, 1984249 },
	{ 22, 4093689 },
	{ 22, 4155133 },
	{ 23, 4032249 },
	{ 23, 3786489 },
	{ 24, 5932793 },
	{ 24, 5424889 },
	{ 23, 3901177 },
	{ 23, 3393273 },
	{ 24, 3573497 },
	{ 24, 2541305 },
	{ 22, 1541881 },
	{ 22, 509689 },
	{ 17, 44906 },
	{ 22, 1038329 },
	{ 22, 2070521 },
	{ 24, 3069945 },
	{ 24, 4102137 },
	{ 24, 6805497 },
	{ 24, 7837689 },
	{ 25, 10934265 },
	{ 25, 16230393 },
	{ 24, 7591929 },
	{ 24, 8099833 },
	{ 24, 7862269 },
	{ 24, 7841785 },
	{ 24, 6793209 },
	{ 24, 3647481 },
	{ 22, 1570813 },
	{ 22, 1550329 },
	{ 22, 501753 },
	{ 22, 2033657 },
	{ 22, 1984505 },
	{ 22, 4093945 },
	{ 22, 4155389 },
	{ 23, 4032505 },
	{ 23, 3786745 },
	{ 24, 5933049 },
	{ 24, 5425145 },
	{ 23, 3901433 },
	{ 23, 3393529 },
	{ 24, 3573753 },
	{ 24, 2541561 },
	{ 22, 1542137 },
	{ 22, 509945 },
	{ 17, 61290 },
	{ 22, 952317 },
	{ 22, 2000893 },
	{ 24, 3049469 },
	{ 24, 4098045 },
	{ 24, 7243773 },
	{ 24, 8292349 },
	{ 25, 11438077 },
	{ 25, 12486653 },
	{ 25, 15632381 },
	{ 25, 16680957 },
	{ 26, 28215293 },
	{ 26, 31378173 },
	{ 26, 31165177 },
	{ 26, 26970873 },
	{ 26, 14387961 },
	{ 24, 6212349 },
	{ 24, 5999353 },
	{ 24, 1805049 },
	{ 24, 7867129 },
	{ 24, 7146233 },
	{ 24, 16632569 },
	{ 25, 15928057 },
	{ 25, 15076089 },
	{ 25, 11995897 },
	{ 26, 21629689 },
	{ 25, 15403769 },
	{ 25, 13503225 },
	{ 25, 7277305 },
	{ 26, 10095353 },
	{ 24, 5966585 },
	{ 24, 1968889 },
	{ 19, 77290 },
	{ 24, 2034429 },
	{ 24, 8342521 },
	{ 26, 12471289 },
	{ 26, 16468985 },
	{ 26, 28986361 },
	{ 26, 31411193 },
	{ 27, 43928569 },
	{ 27, 47926265 },
	{ 27, 64719865 },
	{ 26, 32459769 },
	{ 27, 47942649 },
	{ 26, 31378429 },
	{ 26, 31165433 },
	{ 26, 26971129 },
	{ 26, 14388217 },
	{ 24, 6212605 },
	{ 24, 5999609 },
	{ 24, 1805305 },
	{ 24, 7867385 },
	{ 24, 7146489 },
	{ 24, 16632825 },
	{ 25, 15928313 },
	{ 25, 15076345 },
	{ 25, 11996153 },
	{ 26, 21629945 },
	{ 25, 15404025 },
	{ 25, 13503481 },
	{ 25, 7277561 },
	{ 26, 10095609 },
	{ 24, 5966841 },
	{ 24, 1969145 },
	{ 19, 93674 },
	{ 24, 2034685 },
	{ 24, 6228989 },
	{ 26, 12537593 },
	{ 26, 16666361 },
	{ 26, 29052665 },
	{ 26, 33181433 },
	{ 27, 43994873 },
	{ 27, 48123641 },
	{ 27, 60509945 },
	{ 27, 64655097 },
	{ 27, 60460793 },
	{ 27, 47877881 },
	{ 26, 31182589 },
	{ 26, 31100665 },
	{ 26, 26906361 },
	{ 26, 14323449 },
	{ 24, 6016765 },
	{ 24, 5934841 },
	{ 24, 1740537 },
	{ 24, 7081721 },
	{ 24, 6885113 },
	{ 25, 15863545 },
	{ 25, 14880505 },
	{ 25, 11931385 },
	{ 25, 10948345 },
	{ 25, 15339257 },
	{ 25, 13307641 },
	{ 25, 7212793 },
	{ 25, 5181177 },
	{ 24, 5902073 },
	{ 24, 1773305 },
	{ 19, 109930 },
	{ 24, 1969917 },
	{ 24, 6164221 },
	{ 26, 12537849 },
	{ 26, 16666617 },
	{ 26, 29052921 },
	{ 26, 33181689 },
	{ 27, 43995129 },
	{ 27, 48123897 },
	{ 27, 60510201 },
	{ 27, 64655353 },
	{ 27, 60461049 },
	{ 27, 47878137 },
	{ 26, 31182845 },
	{ 26, 31100921 },
	{ 26, 26906617 },
	{ 26, 14323705 },
	{ 24, 6017021 },
	{ 24, 5935097 },
	{ 24, 1740793 },
	{ 24, 7081977 },
	{ 24, 6885369 },
	{ 25, 15863801 },
	{ 25, 14880761 },
	{ 25, 11931641 },
	{ 25, 10948601 },
	{ 25, 15339513 },
	{ 25, 13307897 },
	{ 25, 7213049 },
	{ 25, 5181433 },
	{ 24, 5902329 },
	{ 24, 1773561 },
	{ 19, 126314 },
	{ 24, 1970173 },
	{ 24, 6164477 },
	{ 26, 10358781 },
	{ 26, 16734969 },
	{ 26, 29252345 },
	{ 26, 33250041 },
	{ 27, 66034425 },
	{ 27, 63937273 },
	{ 27, 57645817 },
	{ 27, 55548665 },
	{ 26, 32479993 },
	{ 26, 30382841 },
	{ 26, 24091385 },
	{ 26, 21994233 },
	{ 25, 15702777 },
	{ 25, 13605625 },
	{ 25, 7314169 },
	{ 24, 5954301 },
	{ 23, 3119865 },
	{ 23, 1022713 },
	{ 24, 6822649 },
	{ 23, 4004601 },
	{ 25, 14818041 },
	{ 25, 11737849 },
	{ 25, 10885881 },
	{ 24, 7805689 },
	{ 25, 13245177 },
	{ 25, 7019257 },
	{ 25, 5118713 },
	{ 23, 3087097 },
	{ 24, 1710841 },
	{ 18, 104426 },
	{ 24, 1776381 },
	{ 24, 5970685 },
	{ 26, 10164989 },
	{ 26, 16735225 },
	{ 26, 29252601 },
	{ 26, 33250297 },
	{ 27, 66034681 },
	{ 27, 63937529 },
	{ 27, 57646073 },
	{ 27, 55548921 },
	{ 26, 32480249 },
	{ 26, 30383097 },
	{ 26, 24091641 },
	{ 26, 21994489 },
	{ 25, 15703033 },
	{ 25, 13605881 },
	{ 25, 7314425 },
	{ 24, 5954557 },
	{ 23, 3120121 },
	{ 23, 1022969 },
	{ 24, 6822905 },
	{ 23, 4004857 },
	{ 25, 14818297 },
	{ 25, 11738105 },
	{ 25, 10886137 },
	{ 24, 7805945 },
	{ 25, 13245433 },
	{ 25, 7019513 },
	{ 25, 5118969 },
	{ 23, 3087353 },
	{ 24, 1711097 },
	{ 18, 112618 },
	{ 24, 1776637 },
	{ 24, 5970941 },
	{ 26, 10165245 },
	{ 26, 14359549 },
	{ 26, 29318905 },
	{ 26, 33447673 },
	{ 27, 122593017 },
	{ 27, 65969913 },
	{ 27, 63872761 },
	{ 27, 57581305 },
	{ 26, 32497405 },
	{ 26, 32415481 },
	{ 26, 30318329 },
	{ 26, 24026873 },
	{ 25, 15720189 },
	{ 25, 15638265 },
	{ 25, 13541113 },
	{ 25, 7249657 },
	{ 23, 3137277 },
	{ 23, 3055353 },
	{ 23, 958201 },
	{ 23, 3940089 },
	{ 23, 3743481 },
	{ 25, 11673337 },
	{ 25, 10690297 },
	{ 24, 7741177 },
	{ 24, 6758137 },
	{ 25, 6954745 },
	{ 25, 4923129 },
	{ 23, 3022585 },
	{ 23, 990969 },
	{ 18, 120682 },
	{ 24, 1711869 },
	{ 24, 5906173 },
	{ 26, 10100477 },
	{ 26, 14294781 },
	{ 26, 29319161 },
	{ 26, 33447929 },
	{ 27, 122593273 },
	{ 27, 65970169 },
	{ 27, 63873017 },
	{ 27, 57581561 },
	{ 26, 32497661 },
	{ 26, 32415737 },
	{ 26, 30318585 },
	{ 26, 24027129 },
	{ 25, 15720445 },
	{ 25, 15638521 },
	{ 25, 13541369 },
	{ 25, 7249913 },
	{ 23, 3137533 },
	{ 23, 3055609 },
	{ 23, 958457 },
	{ 23, 3940345 },
	{ 23, 3743737 },
	{ 25, 11673593 },
	{ 25, 10690553 },
	{ 24, 7741433 },
	{ 24, 6758393 },
	{ 25, 6955001 },
	{ 25, 4923385 },
	{ 23, 3022841 },
	{ 23, 991225 },
	{ 18, 128874 },
	{ 24, 1712125 },
	{ 24, 5906429 },
	{ 26, 10100733 },
	{ 26, 14295037 },
	{ 26, 26877949 },
	{ 26, 31072253 },
	{ 27, 43655165 },
	{ 27, 47849469 },
	{ 27, 60432381 },
	{ 27, 64626685 },
	{ 28, 110764029 },
	{ 28, 129706749 },
	{ 28, 128854777 },
	{ 28, 120466169 },
	{ 28, 95300345 },
	{ 27, 62597885 },
	{ 27, 61745913 },
	{ 27, 53357305 },
	{ 27, 28191481 },
	{ 25, 12266237 },
	{ 25, 11414265 },
	{ 25, 3025657 },
	{ 25, 14691065 },
	{ 25, 11807481 },
	{ 27, 42478329 },
	{ 26, 30157561 },
	{ 26, 26749689 },
	{ 26, 14428921 },
	{ 27, 19409657 },
	{ 25, 11283193 },
	{ 25, 3681017 },
	{ 19, 169450 },
	{ 25, 3943165 },
	{ 25, 12331773 },
	{ 27, 20720381 },
	{ 27, 29108989 },
	{ 27, 54274813 },
	{ 27, 62663421 },
	{ 28, 87829245 },
	{ 28, 96217853 },
	{ 28, 121383677 },
	{ 28, 129772285 },
	{ 29, 229518329 },
	{ 28, 129707005 },
	{ 28, 128855033 },
	{ 28, 120466425 },
	{ 28, 95300601 },
	{ 27, 62598141 },
	{ 27, 61746169 },
	{ 27, 53357561 },
	{ 27, 28191737 },
	{ 25, 12266493 },
	{ 25, 11414521 },
	{ 25, 3025913 },
	{ 25, 14691321 },
	{ 25, 11807737 },
	{ 27, 42478585 },
	{ 26, 30157817 },
	{ 26, 26749945 },
	{ 26, 14429177 },
	{ 27, 19409913 },
	{ 25, 11283449 },
	{ 25, 3681273 },
	{ 19, 177642 },
	{ 25, 3943421 },
	{ 25, 12332029 },
	{ 27, 20720637 },
	{ 27, 29109245 },
	{ 27, 54275069 },
	{ 27, 62663677 },
	{ 28, 87829501 },
	{ 28, 96218109 },
	{ 28, 121383933 },
	{ 28, 129772541 },
	{ 29, 254422777 },
	{ 29, 229256953 },
	{ 28, 128921341 },
	{ 28, 128593657 },
	{ 28, 120205049 },
	{ 28, 95039225 },
	{ 27, 61812477 },
	{ 27, 61484793 },
	{ 27, 53096185 },
	{ 27, 27930361 },
	{ 25, 11480829 },
	{ 25, 11153145 },
	{ 25, 2764537 },
	{ 25, 11546361 },
	{ 25, 10759929 },
	{ 26, 29896441 },
	{ 26, 25964281 },
	{ 26, 14167801 },
	{ 26, 10235641 },
	{ 25, 11022073 },
	{ 25, 2895609 },
	{ 19, 185706 },
	{ 25, 3682045 },
	{ 25, 12070653 },
	{ 27, 20459261 },
	{ 27, 28847869 },
	{ 27, 54013693 },
	{ 27, 62402301 },
	{ 28, 87568125 },
	{ 28, 95956733 },
	{ 28, 121122557 },
	{ 28, 129511165 },
	{ 29, 254423033 },
	{ 29, 229257209 },
	{ 28, 128921597 },
	{ 28, 128593913 },
	{ 28, 120205305 },
	{ 28, 95039481 },
	{ 27, 61812733 },
	{ 27, 61485049 },
	{ 27, 53096441 },
	{ 27, 27930617 },
	{ 25, 11481085 },
	{ 25, 11153401 },
	{ 25, 2764793 },
	{ 25, 11546617 },
	{ 25, 10760185 },
	{ 26, 29896697 },
	{ 26, 25964537 },
	{ 26, 14168057 },
	{ 26, 10235897 },
	{ 25, 11022329 },
	{ 25, 2895865 },
	{ 19, 193898 },
	{ 25, 3682301 },
	{ 25, 12070909 },
	{ 27, 20459517 },
	{ 27, 28848125 },
	{ 27, 54013949 },
	{ 27, 62402557 },
	{ 28, 266222329 },
	{ 28, 262028025 },
	{ 28, 249445113 },
	{ 28, 245250809 },
	{ 28, 132004601 },
	{ 28, 127810297 },
	{ 28, 115227385 },
	{ 28, 111033081 },
	{ 27, 64895737 },
	{ 27, 60701433 },
	{ 27, 48118521 },
	{ 27, 43924217 },
	{ 26, 31341305 },
	{ 26, 27147001 },
	{ 26, 14564089 },
	{ 25, 11221757 },
	{ 24, 6175481 },
	{ 24, 1981177 },
	{ 25, 10500857 },
	{ 24, 7617273 },
	{ 25, 15400955 },
	{ 26, 13384441 },
	{ 26, 9976569 },
	{ 24, 6044409 },
	{ 25, 2636537 },
	{ 18, 117738 },
	{ 25, 2898685 },
	{ 25, 11287293 },
	{ 26, 22740991 },
	{ 27, 28064509 },
	{ 27, 53230333 },
	{ 27, 61618941 },
	{ 28, 266222585 },
	{ 28, 262028281 },
	{ 28, 249445369 },
	{ 28, 245251065 },
	{ 28, 132004857 },
	{ 28, 127810553 },
	{ 28, 115227641 },
	{ 28, 111033337 },
	{ 27, 64895993 },
	{ 27, 60701689 },
	{ 27, 48118777 },
	{ 27, 43924473 },
	{ 26, 31341561 },
	{ 26, 27147257 },
	{ 26, 14564345 },
	{ 25, 11222013 },
	{ 24, 6175737 },
	{ 24, 1981433 },
	{ 25, 10501113 },
	{ 24, 7617529 },
	{ 25, 15400699 },
	{ 26, 13384697 },
	{ 26, 9976825 },
	{ 24, 6044665 },
	{ 25, 2636793 },
	{ 18, 121834 },
	{ 25, 2898941 },
	{ 25, 11287549 },
	{ 26, 22740735 },
	{ 27, 28064765 },
	{ 27, 53230589 },
	{ 27, 61619197 },
	{ 28, 266288893 },
	{ 28, 265961209 },
	{ 28, 261766905 },
	{ 28, 249183993 },
	{ 28, 244989689 },
	{ 28, 131743481 },
	{ 28, 127549177 },
	{ 28, 114966265 },
	{ 27, 64962301 },
	{ 27, 64634617 },
	{ 27, 60440313 },
	{ 27, 47857401 },
	{ 26, 31407869 },
	{ 26, 31080185 },
	{ 26, 26885881 },
	{ 26, 14302969 },
	{ 24, 6242045 },
	{ 24, 5914361 },
	{ 24, 1720057 },
	{ 24, 7356153 },
	{ 24, 6569721 },
	{ 25, 13302779 },
	{ 26, 9191161 },
	{ 24, 5783289 },
	{ 24, 1851129 },
	{ 18, 125802 },
	{ 25, 2637565 },
	{ 25, 11026173 },
	{ 26, 22215679 },
	{ 27, 27803389 },
	{ 27, 52969213 },
	{ 27, 61357821 },
	{ 28, 86523645 },
	{ 28, 265961465 },
	{ 28, 261767161 },
	{ 28, 249184249 },
	{ 28, 244989945 },
	{ 28, 131743737 },
	{ 28, 127549433 },
	{ 28, 114966521 },
	{ 27, 64962557 },
	{ 27, 64634873 },
	{ 27, 60440569 },
	{ 27, 47857657 },
	{ 26, 31408125 },
	{ 26, 31080441 },
	{ 26, 26886137 },
	{ 26, 14303225 },
	{ 24, 6242301 },
	{ 24, 5914617 },
	{ 24, 1720313 },
	{ 24, 7356409 },
	{ 24, 6569977 },
	{ 25, 13302523 },
	{ 26, 9191417 },
	{ 24, 5783545 },
	{ 24, 1851385 },
	{ 18, 129898 },
	{ 25, 2637821 },
	{ 25, 11026429 },
	{ 26, 22215423 },
	{ 27, 27803645 },
	{ 27, 52969469 },
	{ 27, 61358077 },
	{ 28, 86523901 },
	{ 28, 266038013 },
	{ 28, 265186041 },
	{ 28, 260991737 },
	{ 28, 248408825 },
	{ 28, 244214521 },
	{ 28, 130968313 },
	{ 28, 126774009 },
	{ 28, 114191097 },
	{ 27, 64711421 },
	{ 27, 63859449 },
	{ 27, 59665145 },
	{ 27, 47082233 },
	{ 26, 31156989 },
	{ 26, 30305017 },
	{ 26, 26110713 },
	{ 26, 13527801 },
	{ 24, 5991165 },
	{ 24, 5139193 },
	{ 24, 944889 },
	{ 24, 6318841 },
	{ 24, 3435257 },
	{ 25, 7008251 },
	{ 24, 5008121 },
	{ 24, 1600249 },
	{ 19, 215530 },
	{ 24, 1862397 },
	{ 24, 6056701 },
	{ 25, 12251135 },
	{ 26, 14445309 },
	{ 26, 27028221 },
	{ 26, 31222525 },
	{ 27, 43805437 },
	{ 27, 47999741 },
	{ 27, 60582653 },
	{ 27, 64776957 },
	{ 28, 248409081 },
	{ 28, 244214777 },
	{ 28, 130968569 },
	{ 28, 126774265 },
	{ 28, 114191353 },
	{ 27, 64711677 },
	{ 27, 63859705 },
	{ 27, 59665401 },
	{ 27, 47082489 },
	{ 26, 31157245 },
	{ 26, 30305273 },
	{ 26, 26110969 },
	{ 26, 13528057 },
	{ 24, 5991421 },
	{ 24, 5139449 },
	{ 24, 945145 },
	{ 24, 6319097 },
	{ 24, 3435513 },
	{ 25, 7007995 },
	{ 24, 5008377 },
	{ 24, 1600505 },
	{ 19, 219626 },
	{ 24, 1862653 },
	{ 24, 6056957 },
	{ 25, 12250879 },
	{ 26, 14445565 },
	{ 26, 27028477 },
	{ 26, 31222781 },
	{ 27, 43805693 },
	{ 27, 47999997 },
	{ 27, 60582909 },
	{ 27, 64777213 },
	{ 28, 260730617 },
	{ 28, 248147705 },
	{ 28, 243953401 },
	{ 28, 130707193 },
	{ 28, 126512889 },
	{ 28, 113929977 },
	{ 27, 63926013 },
	{ 27, 63598329 },
	{ 27, 59404025 },
	{ 27, 46821113 },
	{ 26, 30371581 },
	{ 26, 30043897 },
	{ 26, 25849593 },
	{ 26, 13266681 },
	{ 24, 5205757 },
	{ 24, 4878073 },
	{ 24, 683769 },
	{ 24, 3174137 },
	{ 24, 2387705 },
	{ 24, 4747001 },
	{ 24, 814841 },
	{ 19, 223594 },
	{ 24, 1601277 },
	{ 24, 5795581 },
	{ 25, 11725823 },
	{ 26, 14184189 },
	{ 26, 26767101 },
	{ 26, 30961405 },
	{ 27, 43544317 },
	{ 27, 47738621 },
	{ 27, 60321533 },
	{ 27, 64515837 },
	{ 28, 260730873 },
	{ 28, 248147961 },
	{ 28, 243953657 },
	{ 28, 130707449 },
	{ 28, 126513145 },
	{ 28, 113930233 },
	{ 27, 63926269 },
	{ 27, 63598585 },
	{ 27, 59404281 },
	{ 27, 46821369 },
	{ 26, 30371837 },
	{ 26, 30044153 },
	{ 26, 25849849 },
	{ 26, 13266937 },
	{ 24, 5206013 },
	{ 24, 4878329 },
	{ 24, 684025 },
	{ 24, 3174393 },
	{ 24, 2387961 },
	{ 24, 4747257 },
	{ 24, 815097 },
	{ 19, 227690 },
	{ 24, 1601533 },
	{ 24, 5795837 },
	{ 25, 11725567 },
	{ 26, 14184445 },
	{ 26, 26767357 },
	{ 26, 30961661 },
	{ 27, 43544573 },
	{ 27, 47738877 },
	{ 27, 60321789 },
	{ 27, 64516093 },
	{ 26, 66484985 },
	{ 26, 65436409 },
	{ 26, 62290681 },
	{ 26, 61242105 },
	{ 26, 32930553 },
	{ 26, 31881977 },
	{ 26, 28736249 },
	{ 26, 27687673 },
	{ 25, 16153337 },
	{ 25, 15104761 },
	{ 25, 11959033 },
	{ 25, 10910457 },
	{ 24, 7764729 },
	{ 24, 6716153 },
	{ 24, 3570425 },
	{ 24, 2521849 },
	{ 22, 1473273 },
	{ 22, 424697 },
	{ 23, 2539515 },
	{ 22, 1342201 },
	{ 23, 2801659 },
	{ 17, 62186 },
	{ 17, 130718 },
	{ 24, 5012221 },
	{ 25, 10141695 },
	{ 26, 13400829 },
	{ 26, 25983741 },
	{ 26, 30178045 },
	{ 27, 42760957 },
	{ 27, 46955261 },
	{ 27, 59538173 },
	{ 27, 63732477 },
	{ 26, 66485241 },
	{ 26, 65436665 },
	{ 26, 62290937 },
	{ 26, 61242361 },
	{ 26, 32930809 },
	{ 26, 31882233 },
	{ 26, 28736505 },
	{ 26, 27687929 },
	{ 25, 16153593 },
	{ 25, 15105017 },
	{ 25, 11959289 },
	{ 25, 10910713 },
	{ 24, 7764985 },
	{ 24, 6716409 },
	{ 24, 3570681 },
	{ 24, 2522105 },
	{ 22, 1473529 },
	{ 22, 424953 },
	{ 23, 2539259 },
	{ 22, 1342457 },
	{ 23, 2801403 },
	{ 17, 63210 },
	{ 17, 129694 },
	{ 24, 5012477 },
	{ 25, 10141439 },
	{ 26, 13401085 },
	{ 26, 25983997 },
	{ 26, 30178301 },
	{ 27, 42761213 },
	{ 27, 46955517 },
	{ 27, 59538429 },
	{ 27, 63732733 },
	{ 26, 66551549 },
	{ 26, 66223865 },
	{ 26, 65175289 },
	{ 26, 62029561 },
	{ 26, 60980985 },
	{ 26, 32669433 },
	{ 26, 31620857 },
	{ 26, 28475129 },
	{ 25, 16219901 },
	{ 25, 15892217 },
	{ 25, 14843641 },
	{ 25, 11697913 },
	{ 24, 7831293 },
	{ 24, 7503609 },
	{ 24, 6455033 },
	{ 24, 3309305 },
	{ 22, 1539837 },
	{ 22, 1212153 },
	{ 22, 163577 },
	{ 18, 128377 },
	{ 18, 257915 },
	{ 17, 64106 },
	{ 17, 128542 },
	{ 24, 4751101 },
	{ 25, 9616383 },
	{ 26, 13139709 },
	{ 26, 25722621 },
	{ 26, 29916925 },
	{ 27, 42499837 },
	{ 27, 46694141 },
	{ 27, 59277053 },
	{ 27, 63471357 },
	{ 26, 66551805 },
	{ 26, 66224121 },
	{ 26, 65175545 },
	{ 26, 62029817 },
	{ 26, 60981241 },
	{ 26, 32669689 },
	{ 26, 31621113 },
	{ 26, 28475385 },
	{ 25, 16220157 },
	{ 25, 15892473 },
	{ 25, 14843897 },
	{ 25, 11698169 },
	{ 24, 7831549 },
	{ 24, 7503865 },
	{ 24, 6455289 },
	{ 24, 3309561 },
	{ 22, 1540093 },
	{ 22, 1212409 },
	{ 22, 163833 },
	{ 18, 130425 },
	{ 18, 255867 },
	{ 17, 65130 },
	{ 17, 127518 },
	{ 24, 4751357 },
	{ 25, 9616127 },
	{ 26, 13139965 },
	{ 26, 25722877 },
	{ 26, 29917181 },
	{ 27, 42500093 },
	{ 27, 46694397 },
	{ 27, 59277309 },
	{ 27, 63471613 },
	{ 28, 109608957 },
	{ 27, 132557565 },
	{ 27, 130460413 },
	{ 27, 124168957 },
	{ 27, 122071805 },
	{ 27, 65448701 },
	{ 27, 63351549 },
	{ 27, 57060093 },
	{ 27, 54962941 },
	{ 26, 31894269 },
	{ 26, 29797117 },
	{ 26, 23505661 },
	{ 26, 21408509 },
	{ 25, 15117053 },
	{ 25, 13019901 },
	{ 25, 6728445 },
	{ 25, 4631293 },
	{ 23, 2534141 },
	{ 23, 436989 },
	{ 23, 307199 },
	{ 22, 2097065 },
	{ 23, 4194138 },
	{ 23, 568061 },
	{ 23, 2665213 },
	{ 23, 2797567 },
	{ 25, 6859517 },
	{ 25, 13150973 },
	{ 25, 15248125 },
	{ 25, 15380479 },
	{ 26, 23636733 },
	{ 26, 29928189 },
	{ 26, 32025341 },
	{ 26, 32157695 },
	{ 27, 57191165 },
	{ 27, 63482621 },
	{ 27, 65579773 },
	{ 27, 122202877 },
	{ 27, 124300029 },
	{ 27, 130591485 },
	{ 27, 132688637 },
	{ 27, 54963197 },
	{ 26, 31894525 },
	{ 26, 29797373 },
	{ 26, 23505917 },
	{ 26, 21408765 },
	{ 25, 15117309 },
	{ 25, 13020157 },
	{ 25, 6728701 },
	{ 25, 4631549 },
	{ 23, 2534397 },
	{ 23, 437245 },
	{ 23, 306943 },
	{ 21, 1048521 },
	{ 22, 2097115 },
	{ 14, 8142 },
	{ 23, 2665469 },
	{ 23, 2797311 },
	{ 25, 6859773 },
	{ 25, 13151229 },
	{ 25, 15248381 },
	{ 25, 15380223 },
	{ 26, 23636989 },
	{ 26, 29928445 },
	{ 26, 32025597 },
	{ 26, 32157439 },
	{ 27, 57191421 },
	{ 27, 63482877 },
	{ 27, 132296445 },
	{ 27, 130199293 },
	{ 27, 123907837 },
	{ 27, 121810685 },
	{ 27, 65187581 },
	{ 27, 63090429 },
	{ 27, 56798973 },
	{ 27, 54701821 },
	{ 26, 31633149 },
	{ 26, 29535997 },
	{ 26, 23244541 },
	{ 26, 21147389 },
	{ 25, 14855933 },
	{ 25, 12758781 },
	{ 25, 6467325 },
	{ 25, 4370173 },
	{ 18, 243581 },
	{ 18, 241023 },
	{ 21, 1048527 },
	{ 14, 8078 },
	{ 18, 243069 },
	{ 18, 241535 },
	{ 25, 6336253 },
	{ 25, 12627709 },
	{ 25, 14724861 },
	{ 25, 14855167 },
	{ 26, 23113469 },
	{ 26, 29404925 },
	{ 26, 31502077 },
	{ 26, 31632383 },
	{ 27, 56667901 },
	{ 27, 62959357 },
	{ 27, 65056509 },
	{ 27, 121679613 },
	{ 27, 123776765 },
	{ 27, 130068221 },
	{ 27, 132165373 },
	{ 27, 63090685 },
	{ 27, 56799229 },
	{ 27, 54702077 },
	{ 26, 31633405 },
	{ 26, 29536253 },
	{ 26, 23244797 },
	{ 26, 21147645 },
	{ 25, 14856189 },
	{ 25, 12759037 },
	{ 25, 6467581 },
	{ 25, 4370429 },
	{ 18, 245629 },
	{ 18, 238975 },
	{ 14, 14986 },
	{ 22, 2097101 },
	{ 18, 245117 },
	{ 18, 239487 },
	{ 25, 6336509 },
	{ 25, 12627965 },
	{ 25, 14725117 },
	{ 25, 14854911 },
	{ 26, 23113725 },
	{ 26, 29405181 },
	{ 26, 31502333 },
	{ 26, 31632127 },
	{ 27, 56668157 },
	{ 27, 62959613 },
	{ 27, 132823805 },
	{ 26, 66355199 },
	{ 26, 65306623 },
	{ 26, 62160895 },
	{ 26, 61112319 },
	{ 26, 32800767 },
	{ 26, 31752191 },
	{ 26, 28606463 },
	{ 26, 32160509 },
	{ 25, 16023551 },
	{ 25, 14974975 },
	{ 25, 11829247 },
	{ 25, 15383293 },
	{ 24, 7634943 },
	{ 24, 6586367 },
	{ 24, 3440639 },
	{ 23, 2800381 },
	{ 22, 1343487 },
	{ 14, 15050 },
	{ 22, 2097118 },
	{ 20, 524235 },
	{ 23, 310013 },
	{ 22, 229375 },
	{ 22, 1277951 },
	{ 24, 2326527 },
	{ 24, 3375103 },
	{ 24, 6520831 },
	{ 24, 7569407 },
	{ 25, 10715135 },
	{ 25, 11763711 },
	{ 25, 14909439 },
	{ 25, 15958015 },
	{ 26, 27492351 },
	{ 26, 66354943 },
	{ 26, 65306367 },
	{ 26, 62160639 },
	{ 26, 61112063 },
	{ 26, 32800511 },
	{ 26, 31751935 },
	{ 26, 28606207 },
	{ 26, 32160765 },
	{ 25, 16023295 },
	{ 25, 14974719 },
	{ 25, 11828991 },
	{ 25, 15383549 },
	{ 24, 7634687 },
	{ 24, 6586111 },
	{ 24, 3440383 },
	{ 23, 2800637 },
	{ 22, 1343231 },
	{ 22, 294655 },
	{ 22, 2096990 },
	{ 21, 1048491 },
	{ 23, 310269 },
	{ 22, 229119 },
	{ 22, 1277695 },
	{ 24, 2326271 },
	{ 24, 3374847 },
	{ 24, 6520575 },
	{ 24, 7569151 },
	{ 25, 10714879 },
	{ 25, 11763455 },
	{ 25, 14909183 },
	{ 25, 15957759 },
	{ 26, 27492095 },
	{ 26, 28540671 },
	{ 26, 31686399 },
	{ 26, 32734975 },
	{ 26, 61046527 },
	{ 26, 62095103 },
	{ 26, 65240831 },
	{ 26, 66289407 },
	{ 28, 127057661 },
	{ 27, 63470591 },
	{ 27, 59276287 },
	{ 27, 46693375 },
	{ 27, 59948797 },
	{ 26, 29916159 },
	{ 26, 25721855 },
	{ 26, 13138943 },
	{ 25, 9617149 },
	{ 24, 4750335 },
	{ 17, 129562 },
	{ 17, 63086 },
	{ 18, 259961 },
	{ 18, 126331 },
	{ 22, 162811 },
	{ 22, 1211387 },
	{ 22, 1539071 },
	{ 24, 3308539 },
	{ 24, 6454267 },
	{ 24, 7502843 },
	{ 24, 7830527 },
	{ 25, 11697147 },
	{ 25, 14842875 },
	{ 25, 15891451 },
	{ 25, 16219135 },
	{ 26, 28474363 },
	{ 26, 31620091 },
	{ 26, 32668667 },
	{ 26, 60980219 },
	{ 26, 62028795 },
	{ 26, 65174523 },
	{ 26, 66223099 },
	{ 26, 66550783 },
	{ 27, 63470335 },
	{ 27, 59276031 },
	{ 27, 46693119 },
	{ 27, 59949053 },
	{ 26, 29915903 },
	{ 26, 25721599 },
	{ 26, 13138687 },
	{ 25, 9617405 },
	{ 24, 4750079 },
	{ 17, 130586 },
	{ 17, 62062 },
	{ 18, 262009 },
	{ 18, 124283 },
	{ 22, 162555 },
	{ 22, 1211131 },
	{ 22, 1538815 },
	{ 24, 3308283 },
	{ 24, 6454011 },
	{ 24, 7502587 },
	{ 24, 7830271 },
	{ 25, 11696891 },
	{ 25, 14842619 },
	{ 25, 15891195 },
	{ 25, 16218879 },
	{ 26, 28474107 },
	{ 26, 31619835 },
	{ 26, 32668411 },
	{ 26, 60979963 },
	{ 26, 62028539 },
	{ 26, 65174267 },
	{ 26, 66222843 },
	{ 26, 66550527 },
	{ 27, 63729663 },
	{ 27, 59535359 },
	{ 27, 46952447 },
	{ 27, 60484349 },
	{ 26, 30175231 },
	{ 26, 25980927 },
	{ 26, 13398015 },
	{ 25, 10152701 },
	{ 24, 5009407 },
	{ 24, 815103 },
	{ 17, 57070 },
	{ 23, 2812665 },
	{ 22, 1339387 },
	{ 23, 2550521 },
	{ 22, 421883 },
	{ 22, 1470459 },
	{ 24, 2519035 },
	{ 24, 3567611 },
	{ 24, 6713339 },
	{ 24, 7761915 },
	{ 25, 10907643 },
	{ 25, 11956219 },
	{ 25, 15101947 },
	{ 25, 16150523 },
	{ 26, 27684859 },
	{ 26, 28733435 },
	{ 26, 31879163 },
	{ 26, 32927739 },
	{ 26, 61239291 },
	{ 26, 62287867 },
	{ 26, 65433595 },
	{ 26, 66482171 },
	{ 27, 63729407 },
	{ 27, 59535103 },
	{ 27, 46952191 },
	{ 27, 60484605 },
	{ 26, 30174975 },
	{ 26, 25980671 },
	{ 26, 13397759 },
	{ 25, 10152957 },
	{ 24, 5009151 },
	{ 24, 814847 },
	{ 17, 56046 },
	{ 23, 2812921 },
	{ 22, 1339131 },
	{ 23, 2550777 },
	{ 22, 421627 },
	{ 22, 1470203 },
	{ 24, 2518779 },
	{ 24, 3567355 },
	{ 24, 6713083 },
	{ 24, 7761659 },
	{ 25, 10907387 },
	{ 25, 11955963 },
	{ 25, 15101691 },
	{ 25, 16150267 },
	{ 26, 27684603 },
	{ 26, 28733179 },
	{ 26, 31878907 },
	{ 26, 32927483 },
	{ 26, 61239035 },
	{ 26, 62287611 },
	{ 26, 65433339 },
	{ 26, 66481915 },
	{ 27, 64515071 },
	{ 27, 60320767 },
	{ 27, 47737855 },
	{ 27, 62058237 },
	{ 26, 30960639 },
	{ 26, 26766335 },
	{ 26, 14183423 },
	{ 25, 11726589 },
	{ 24, 5794815 },
	{ 24, 1600511 },
	{ 19, 219502 },
	{ 24, 814075 },
	{ 24, 4746235 },
	{ 24, 2386939 },
	{ 24, 3173371 },
	{ 24, 683003 },
	{ 24, 4877307 },
	{ 24, 5204991 },
	{ 26, 13265915 },
	{ 26, 25848827 },
	{ 26, 30043131 },
	{ 26, 30370815 },
	{ 27, 46820347 },
	{ 27, 59403259 },
	{ 27, 63597563 },
	{ 27, 63925247 },
	{ 28, 113929211 },
	{ 28, 126512123 },
	{ 28, 130706427 },
	{ 28, 243952635 },
	{ 28, 248146939 },
	{ 28, 129167357 },
	{ 27, 64514815 },
	{ 27, 60320511 },
	{ 27, 47737599 },
	{ 27, 62058493 },
	{ 26, 30960383 },
	{ 26, 26766079 },
	{ 26, 14183167 },
	{ 25, 11726845 },
	{ 24, 5794559 },
	{ 24, 1600255 },
	{ 19, 215406 },
	{ 24, 813819 },
	{ 24, 4745979 },
	{ 24, 2386683 },
	{ 24, 3173115 },
	{ 24, 682747 },
	{ 24, 4877051 },
	{ 24, 5204735 },
	{ 26, 13265659 },
	{ 26, 25848571 },
	{ 26, 30042875 },
	{ 26, 30370559 },
	{ 27, 46820091 },
	{ 27, 59403003 },
	{ 27, 63597307 },
	{ 27, 63924991 },
	{ 28, 113928955 },
	{ 28, 126511867 },
	{ 28, 130706171 },
	{ 28, 243952379 },
	{ 28, 248146683 },
	{ 28, 129694461 },
	{ 27, 64765951 },
	{ 27, 60571647 },
	{ 27, 47988735 },
	{ 27, 62585597 },
	{ 26, 31211519 },
	{ 26, 27017215 },
	{ 26, 14434303 },
	{ 25, 12253949 },
	{ 24, 6045695 },
	{ 24, 1851391 },
	{ 18, 129518 },
	{ 24, 1589243 },
	{ 24, 4997115 },
	{ 25, 7011065 },
	{ 24, 3424251 },
	{ 24, 6307835 },
	{ 24, 933883 },
	{ 24, 5128187 },
	{ 24, 5980159 },
	{ 26, 13516795 },
	{ 26, 26099707 },
	{ 26, 30294011 },
	{ 26, 31145983 },
	{ 27, 47071227 },
	{ 27, 59654139 },
	{ 27, 63848443 },
	{ 27, 64700415 },
	{ 28, 114180091 },
	{ 28, 126763003 },
	{ 28, 130957307 },
	{ 28, 244203515 },
	{ 28, 129694717 },
	{ 27, 64765695 },
	{ 27, 60571391 },
	{ 27, 47988479 },
	{ 27, 62585853 },
	{ 26, 31211263 },
	{ 26, 27016959 },
	{ 26, 14434047 },
	{ 25, 12254205 },
	{ 24, 6045439 },
	{ 24, 1851135 },
	{ 18, 125422 },
	{ 24, 1588987 },
	{ 24, 4996859 },
	{ 25, 7011321 },
	{ 24, 3423995 },
	{ 24, 6307579 },
	{ 24, 933627 },
	{ 24, 5127931 },
	{ 24, 5979903 },
	{ 26, 13516539 },
	{ 26, 26099451 },
	{ 26, 30293755 },
	{ 26, 31145727 },
	{ 27, 47070971 },
	{ 27, 59653883 },
	{ 27, 63848187 },
	{ 27, 64700159 },
	{ 28, 114179835 },
	{ 28, 126762747 },
	{ 28, 130957051 },
	{ 28, 244203259 },
	{ 28, 248397563 },
	{ 28, 260980475 },
	{ 28, 265174779 },
	{ 28, 266026751 },
	{ 28, 122879741 },
	{ 27, 61357055 },
	{ 27, 52968447 },
	{ 27, 27802623 },
	{ 26, 22216445 },
	{ 25, 11025407 },
	{ 25, 2636799 },
	{ 18, 121710 },
	{ 24, 1850363 },
	{ 24, 5782523 },
	{ 26, 9190395 },
	{ 25, 13303545 },
	{ 24, 6568955 },
	{ 24, 7355387 },
	{ 24, 1719291 },
	{ 24, 5913595 },
	{ 24, 6241279 },
	{ 26, 14302203 },
	{ 26, 26885115 },
	{ 26, 31079419 },
	{ 26, 31407103 },
	{ 27, 47856635 },
	{ 27, 60439547 },
	{ 27, 64633851 },
	{ 27, 64961535 },
	{ 28, 114965499 },
	{ 28, 127548411 },
	{ 28, 131742715 },
	{ 28, 244988923 },
	{ 28, 249183227 },
	{ 28, 261766139 },
	{ 28, 265960443 },
	{ 28, 122879997 },
	{ 27, 61356799 },
	{ 27, 52968191 },
	{ 27, 27802367 },
	{ 26, 22216701 },
	{ 25, 11025151 },
	{ 25, 2636543 },
	{ 18, 117614 },
	{ 24, 1850107 },
	{ 24, 5782267 },
	{ 26, 9190139 },
	{ 25, 13303801 },
	{ 24, 6568699 },
	{ 24, 7355131 },
	{ 24, 1719035 },
	{ 24, 5913339 },
	{ 24, 6241023 },
	{ 26, 14301947 },
	{ 26, 26884859 },
	{ 26, 31079163 },
	{ 26, 31406847 },
	{ 27, 47856379 },
	{ 27, 60439291 },
	{ 27, 64633595 },
	{ 27, 64961279 },
	{ 28, 114965243 },
	{ 28, 127548155 },
	{ 28, 131742459 },
	{ 28, 244988667 },
	{ 28, 249182971 },
	{ 28, 261765883 },
	{ 28, 265960187 },
	{ 28, 266287871 },
	{ 27, 61616127 },
	{ 27, 53227519 },
	{ 27, 28061695 },
	{ 27, 45460221 },
	{ 25, 11284479 },
	{ 25, 2895871 },
	{ 18, 97262 },
	{ 25, 2633723 },
	{ 24, 6041595 },
	{ 26, 9973755 },
	{ 26, 13381627 },
	{ 26, 30780153 },
	{ 24, 7614459 },
	{ 25, 10498043 },
	{ 24, 1978363 },
	{ 24, 6172667 },
	{ 25, 11218943 },
	{ 26, 14561275 },
	{ 26, 27144187 },
	{ 26, 31338491 },
	{ 27, 43921403 },
	{ 27, 48115707 },
	{ 27, 60698619 },
	{ 27, 64892923 },
	{ 28, 111030267 },
	{ 28, 115224571 },
	{ 28, 127807483 },
	{ 28, 132001787 },
	{ 28, 245247995 },
	{ 28, 249442299 },
	{ 28, 262025211 },
	{ 28, 266219515 },
	{ 27, 61615871 },
	{ 27, 53227263 },
	{ 27, 28061439 },
	{ 27, 45460477 },
	{ 25, 11284223 },
	{ 25, 2895615 },
	{ 18, 93166 },
	{ 25, 2633467 },
	{ 24, 6041339 },
	{ 26, 9973499 },
	{ 26, 13381371 },
	{ 26, 30780409 },
	{ 24, 7614203 },
	{ 25, 10497787 },
	{ 24, 1978107 },
	{ 24, 6172411 },
	{ 25, 11218687 },
	{ 26, 14561019 },
	{ 26, 27143931 },
	{ 26, 31338235 },
	{ 27, 43921147 },
	{ 27, 48115451 },
	{ 27, 60698363 },
	{ 27, 64892667 },
	{ 28, 111030011 },
	{ 28, 115224315 },
	{ 28, 127807227 },
	{ 28, 132001531 },
	{ 28, 245247739 },
	{ 28, 249442043 },
	{ 28, 262024955 },
	{ 28, 266219259 },
	{ 27, 62401535 },
	{ 27, 54012927 },
	{ 27, 28847103 },
	{ 27, 48606973 },
	{ 25, 12069887 },
	{ 25, 3681279 },
	{ 19, 177518 },
	{ 25, 2894843 },
	{ 25, 11021307 },
	{ 26, 10234875 },
	{ 26, 14167035 },
	{ 26, 25963515 },
	{ 26, 29895675 },
	{ 25, 10759163 },
	{ 25, 11545595 },
	{ 25, 2763771 },
	{ 25, 11152379 },
	{ 25, 11480063 },
	{ 27, 27929595 },
	{ 27, 53095419 },
	{ 27, 61484027 },
	{ 27, 61811711 },
	{ 28, 95038459 },
	{ 28, 120204283 },
	{ 28, 128592891 },
	{ 28, 128920575 },
	{ 29, 229256187 },
	{ 29, 254422011 },
	{ 28, 129510143 },
	{ 28, 121121535 },
	{ 28, 95955711 },
	{ 28, 87567103 },
	{ 27, 62401279 },
	{ 27, 54012671 },
	{ 27, 28846847 },
	{ 27, 48607229 },
	{ 25, 12069631 },
	{ 25, 3681023 },
	{ 19, 169326 },
	{ 25, 2894587 },
	{ 25, 11021051 },
	{ 26, 10234619 },
	{ 26, 14166779 },
	{ 26, 25963259 },
	{ 26, 29895419 },
	{ 25, 10758907 },
	{ 25, 11545339 },
	{ 25, 2763515 },
	{ 25, 11152123 },
	{ 25, 11479807 },
	{ 27, 27929339 },
	{ 27, 53095163 },
	{ 27, 61483771 },
	{ 27, 61811455 },
	{ 27, 124723199 },
	{ 27, 122626047 },
	{ 27, 66002943 },
	{ 27, 63905791 },
	{ 27, 57614335 },
	{ 27, 55517183 },
	{ 26, 32448511 },
	{ 26, 30351359 },
	{ 26, 24059903 },
	{ 26, 21962751 },
	{ 25, 15671295 },
	{ 25, 13574143 },
	{ 25, 7282687 },
	{ 25, 5185535 },
	{ 23, 3088383 },
	{ 23, 991231 },
	{ 18, 128494 },
	{ 23, 925691 },
	{ 23, 2826235 },
	{ 25, 4857851 },
	{ 24, 3612667 },
	{ 24, 6692859 },
	{ 24, 7544827 },
	{ 25, 10625019 },
	{ 23, 2957307 },
	{ 23, 3678203 },
	{ 23, 761851 },
	{ 23, 2859003 },
	{ 23, 3071999 },
	{ 25, 7053307 },
	{ 25, 13344763 },
	{ 25, 15441915 },
	{ 25, 15654911 },
	{ 26, 23830523 },
	{ 26, 30121979 },
	{ 26, 32219131 },
	{ 26, 32432127 },
	{ 27, 57384955 },
	{ 26, 32448255 },
	{ 26, 30351103 },
	{ 26, 24059647 },
	{ 26, 21962495 },
	{ 25, 15671039 },
	{ 25, 13573887 },
	{ 25, 7282431 },
	{ 25, 5185279 },
	{ 23, 3088127 },
	{ 23, 990975 },
	{ 18, 120302 },
	{ 23, 925435 },
	{ 23, 2825979 },
	{ 25, 4857595 },
	{ 24, 3612411 },
	{ 24, 6692603 },
	{ 24, 7544571 },
	{ 25, 10624763 },
	{ 23, 2957051 },
	{ 23, 3677947 },
	{ 23, 761595 },
	{ 23, 2858747 },
	{ 23, 3071743 },
	{ 25, 7053051 },
	{ 25, 13344507 },
	{ 25, 15441659 },
	{ 25, 15654655 },
	{ 26, 23830267 },
	{ 26, 30121723 },
	{ 26, 32218875 },
	{ 26, 32431871 },
	{ 27, 57384699 },
	{ 27, 63676155 },
	{ 27, 65773307 },
	{ 27, 122396411 },
	{ 27, 124493563 },
	{ 26, 33513211 },
	{ 26, 26876927 },
	{ 26, 14294015 },
	{ 26, 10099711 },
	{ 24, 5905407 },
	{ 24, 1711103 },
	{ 18, 112494 },
	{ 23, 990203 },
	{ 23, 3021819 },
	{ 25, 4922363 },
	{ 25, 6953979 },
	{ 24, 6757371 },
	{ 24, 7740411 },
	{ 25, 10689531 },
	{ 25, 11672571 },
	{ 23, 3742715 },
	{ 23, 3939323 },
	{ 23, 957435 },
	{ 23, 3054587 },
	{ 23, 3136511 },
	{ 25, 7248891 },
	{ 25, 13540347 },
	{ 25, 15637499 },
	{ 25, 15719423 },
	{ 26, 24026107 },
	{ 26, 30317563 },
	{ 26, 32414715 },
	{ 26, 32496639 },
	{ 27, 57580539 },
	{ 27, 63871995 },
	{ 27, 65969147 },
	{ 27, 122592251 },
	{ 26, 33446907 },
	{ 26, 29318139 },
	{ 26, 14293759 },
	{ 26, 10099455 },
	{ 24, 5905151 },
	{ 24, 1710847 },
	{ 18, 104302 },
	{ 23, 989947 },
	{ 23, 3021563 },
	{ 25, 4922107 },
	{ 25, 6953723 },
	{ 24, 6757115 },
	{ 24, 7740155 },
	{ 25, 10689275 },
	{ 25, 11672315 },
	{ 23, 3742459 },
	{ 23, 3939067 },
	{ 23, 957179 },
	{ 23, 3054331 },
	{ 23, 3136255 },
	{ 25, 7248635 },
	{ 25, 13540091 },
	{ 25, 15637243 },
	{ 25, 15719167 },
	{ 26, 24025851 },
	{ 26, 30317307 },
	{ 26, 32414459 },
	{ 26, 32496383 },
	{ 27, 57580283 },
	{ 27, 63871739 },
	{ 27, 65968891 },
	{ 27, 122591995 },
	{ 26, 33446651 },
	{ 26, 29317883 },
	{ 26, 14356479 },
	{ 26, 10162175 },
	{ 24, 5967871 },
	{ 24, 1773567 },
	{ 18, 63470 },
	{ 24, 1708027 },
	{ 23, 3084283 },
	{ 25, 5115899 },
	{ 25, 7016443 },
	{ 25, 13242363 },
	{ 24, 7802875 },
	{ 25, 10883067 },
	{ 25, 11735035 },
	{ 25, 14815227 },
	{ 23, 4001787 },
	{ 24, 6819835 },
	{ 23, 1019899 },
	{ 23, 3117051 },
	{ 24, 5951487 },
	{ 25, 7311355 },
	{ 25, 13602811 },
	{ 25, 15699963 },
	{ 26, 21991419 },
	{ 26, 24088571 },
	{ 26, 30380027 },
	{ 26, 32477179 },
	{ 27, 55545851 },
	{ 27, 57643003 },
	{ 27, 63934459 },
	{ 27, 66031611 },
	{ 26, 33247227 },
	{ 26, 29249531 },
	{ 26, 16732155 },
	{ 26, 10161919 },
	{ 24, 5967615 },
	{ 24, 1773311 },
	{ 18, 55278 },
	{ 24, 1707771 },
	{ 23, 3084027 },
	{ 25, 5115643 },
	{ 25, 7016187 },
	{ 25, 13242107 },
	{ 24, 7802619 },
	{ 25, 10882811 },
	{ 25, 11734779 },
	{ 25, 14814971 },
	{ 23, 4001531 },
	{ 24, 6819579 },
	{ 23, 1019643 },
	{ 23, 3116795 },
	{ 24, 5951231 },
	{ 25, 7311099 },
	{ 25, 13602555 },
	{ 25, 15699707 },
	{ 26, 21991163 },
	{ 26, 24088315 },
	{ 26, 30379771 },
	{ 26, 32476923 },
	{ 27, 55545595 },
	{ 27, 57642747 },
	{ 27, 63934203 },
	{ 27, 66031355 },
	{ 26, 33246971 },
	{ 26, 29249275 },
	{ 26, 16731899 },
	{ 26, 10357759 },
	{ 24, 6163455 },
	{ 24, 1969151 },
	{ 19, 93550 },
	{ 24, 1772539 },
	{ 24, 5901307 },
	{ 25, 5180411 },
	{ 25, 7212027 },
	{ 25, 13306875 },
	{ 25, 15338491 },
	{ 25, 10947579 },
	{ 25, 11930619 },
	{ 25, 14879739 },
	{ 25, 15862779 },
	{ 24, 6884347 },
	{ 24, 7080955 },
	{ 24, 1739771 },
	{ 24, 5934075 },
	{ 24, 6015999 },
	{ 26, 14322683 },
	{ 26, 26905595 },
	{ 26, 31099899 },
	{ 26, 31181823 },
	{ 27, 47877115 },
	{ 27, 60460027 },
	{ 27, 64654331 },
	{ 27, 60509179 },
	{ 27, 48122875 },
	{ 27, 43994107 },
	{ 26, 33180667 },
	{ 26, 29051899 },
	{ 26, 16665595 },
	{ 26, 12536827 },
	{ 24, 6163199 },
	{ 24, 1968895 },
	{ 19, 77166 },
	{ 24, 1772283 },
	{ 24, 5901051 },
	{ 25, 5180155 },
	{ 25, 7211771 },
	{ 25, 13306619 },
	{ 25, 15338235 },
	{ 25, 10947323 },
	{ 25, 11930363 },
	{ 25, 14879483 },
	{ 25, 15862523 },
	{ 24, 6884091 },
	{ 24, 7080699 },
	{ 24, 1739515 },
	{ 24, 5933819 },
	{ 24, 6015743 },
	{ 26, 14322427 },
	{ 26, 26905339 },
	{ 26, 31099643 },
	{ 26, 31181567 },
	{ 26, 28821503 },
	{ 26, 27772927 },
	{ 25, 16238591 },
	{ 25, 15190015 },
	{ 25, 12044287 },
	{ 25, 10995711 },
	{ 24, 7849983 },
	{ 24, 6801407 },
	{ 24, 3655679 },
	{ 24, 2607103 },
	{ 22, 1558527 },
	{ 22, 509951 },
	{ 17, 60910 },
	{ 22, 493563 },
	{ 22, 1492987 },
	{ 24, 2525179 },
	{ 23, 1820667 },
	{ 23, 3377147 },
	{ 23, 3852283 },
	{ 24, 5408763 },
	{ 23, 3000315 },
	{ 23, 3770363 },
	{ 23, 3983355 },
	{ 22, 4159483 },
	{ 22, 1787899 },
	{ 22, 1968123 },
	{ 22, 452603 },
	{ 22, 1501179 },
	{ 22, 1554431 },
	{ 24, 3598331 },
	{ 24, 6744059 },
	{ 24, 7792635 },
	{ 24, 7845887 },
	{ 25, 11986939 },
	{ 24, 8116219 },
	{ 25, 16181243 },
	{ 25, 11982843 },
	{ 25, 10983419 },
	{ 24, 7854075 },
	{ 24, 7247867 },
	{ 24, 4118523 },
	{ 24, 3119099 },
	{ 22, 2086907 },
	{ 22, 509695 },
	{ 17, 44526 },
	{ 22, 493307 },
	{ 22, 1492731 },
	{ 24, 2524923 },
	{ 23, 1820411 },
	{ 23, 3376891 },
	{ 23, 3852027 },
	{ 24, 5408507 },
	{ 23, 3000059 },
	{ 23, 3770107 },
	{ 23, 3983099 },
	{ 22, 4159227 },
	{ 22, 1787643 },
	{ 22, 1967867 },
	{ 22, 452347 },
	{ 22, 1500923 },
	{ 22, 1554175 },
	{ 24, 3598075 },
	{ 24, 6743803 },
	{ 24, 7792379 },
	{ 24, 7845631 },
	{ 25, 11986683 },
	{ 24, 8115963 },
	{ 25, 16180987 },
	{ 25, 11982587 },
	{ 25, 10983163 },
	{ 24, 7853819 },
	{ 24, 7247611 },
	{ 24, 4118267 },
	{ 24, 3118843 },
	{ 22, 2086651 },
	{ 22, 951295 },
	{ 17, 28526 },
	{ 22, 508923 },
	{ 22, 1541115 },
	{ 24, 2540539 },
	{ 24, 3572731 },
	{ 23, 3392507 },
	{ 23, 3900411 },
	{ 24, 5424123 },
	{ 24, 5932027 },
	{ 23, 3785723 },
	{ 23, 4031483 },
	{ 22, 4154367 },
	{ 22, 4092923 },
	{ 22, 1983483 },
	{ 22, 2032635 },
	{ 22, 500731 },
	{ 22, 1549307 },
	{ 22, 1569791 },
	{ 24, 3646459 },
	{ 24, 6792187 },
	{ 24, 7840763 },
	{ 24, 7861247 },
	{ 24, 8098811 },
	{ 24, 7590907 },
	{ 25, 16229371 },
	{ 25, 10933243 },
	{ 24, 7836667 },
	{ 24, 6804475 },
	{ 24, 4101115 },
	{ 24, 3068923 },
	{ 22, 2069499 },
	{ 22, 1037307 },
	{ 17, 12142 },
	{ 22, 508667 },
	{ 22, 1540859 },
	{ 24, 2540283 },
	{ 24, 3572475 },
	{ 23, 3392251 },
	{ 23, 3900155 },
	{ 24, 5423867 },
	{ 24, 5931771 },
	{ 23, 3785467 },
	{ 23, 4031227 },
	{ 22, 4154111 },
	{ 22, 4092667 },
	{ 22, 1983227 },
	{ 22, 2032379 },
	{ 22, 500475 },
	{ 22, 1549051 },
	{ 22, 1569535 },
	{ 24, 3646203 },
	{ 24, 6791931 },
	{ 24, 7840507 },
	{ 24, 7860991 },
	{ 23, 4174335 },
	{ 23, 3912191 },
	{ 23, 3125759 },
	{ 23, 2863615 },
	{ 22, 2077183 },
	{ 22, 1815039 },
	{ 22, 1028607 },
	{ 22, 766463 },
	{ 20, 504319 },
	{ 20, 242175 },
	{ 15, 20462 },
	{ 20, 238075 },
	{ 20, 389627 },
	{ 22, 647675 },
	{ 22, 897531 },
	{ 22, 1679867 },
	{ 21, 979451 },
	{ 22, 1368571 },
	{ 22, 1487355 },
	{ 22, 1876475 },
	{ 21, 1012219 },
	{ 22, 1729019 },
	{ 20, 1022463 },
	{ 20, 974331 },
	{ 20, 512507 },
	{ 20, 950779 },
	{ 20, 129531 },
	{ 20, 391675 },
	{ 20, 503295 },
	{ 22, 915963 },
	{ 22, 1702395 },
	{ 22, 1964539 },
	{ 22, 2012667 },
	{ 22, 1893883 },
	{ 22, 1504763 },
	{ 23, 2864381 },
	{ 22, 2077949 },
	{ 22, 1815805 },
	{ 22, 1029373 },
	{ 22, 767229 },
	{ 20, 505085 },
	{ 20, 242941 },
	{ 15, 3994 },
	{ 20, 238841 },
	{ 20, 390393 },
	{ 22, 648441 },
	{ 22, 898297 },
	{ 22, 1680633 },
	{ 21, 980217 },
	{ 22, 1369337 },
	{ 22, 1488121 },
	{ 22, 2078969 },
	{ 21, 1012985 },
	{ 22, 1030393 },
	{ 20, 519421 },
	{ 20, 506105 },
	{ 20, 243961 },
	{ 20, 1016057 },
	{ 20, 971001 },
	{ 20, 515321 },
	{ 20, 956669 },
	{ 22, 1990905 },
	{ 22, 1798393 },
	{ 22, 2063609 },
	{ 22, 2011385 },
	{ 22, 1892601 },
	{ 22, 1503481 },
	{ 23, 2728185 },
	{ 22, 1945849 },
	{ 22, 1695993 },
	{ 22, 913657 },
	{ 22, 762105 },
	{ 20, 504057 },
	{ 20, 254201 },
	{ 15, 7658 },
	{ 20, 239097 },
	{ 20, 390649 },
	{ 22, 648697 },
	{ 22, 898553 },
	{ 22, 1680889 },
	{ 21, 980473 },
	{ 22, 1369593 },
	{ 22, 1488377 },
	{ 22, 2079225 },
	{ 21, 1013241 },
	{ 22, 1030649 },
	{ 20, 519677 },
	{ 20, 506361 },
	{ 20, 244217 },
	{ 20, 1016313 },
	{ 20, 971257 },
	{ 20, 515577 },
	{ 20, 956925 },
	{ 22, 1991161 },
	{ 22, 1798649 },
	{ 22, 2063865 },
	{ 22, 2011641 },
	{ 22, 1892857 },
	{ 22, 1503737 },
	{ 23, 2728441 },
	{ 22, 1946105 },
	{ 22, 1696249 },
	{ 22, 913913 },
	{ 22, 762361 },
	{ 20, 504313 },
	{ 20, 254457 },
	{ 15, 24042 },
	{ 20, 258557 },
	{ 20, 520701 },
	{ 22, 782845 },
	{ 22, 1044989 },
	{ 22, 1831421 },
	{ 22, 2093565 },
	{ 23, 2879997 },
	{ 23, 3142141 },
	{ 23, 3928573 },
	{ 23, 4190717 },
	{ 24, 7250681 },
	{ 24, 4104953 },
	{ 22, 2028285 },
	{ 22, 2007801 },
	{ 22, 959225 },
	{ 22, 3867385 },
	{ 22, 3818233 },
	{ 22, 3830521 },
	{ 22, 3891965 },
	{ 24, 7176953 },
	{ 24, 6931193 },
	{ 24, 8028921 },
	{ 24, 7521017 },
	{ 24, 5997305 },
	{ 24, 5489401 },
	{ 24, 7766777 },
	{ 24, 6734585 },
	{ 24, 3638009 },
	{ 24, 2605817 },
	{ 22, 1999609 },
	{ 22, 967417 },
	{ 17, 15722 },
	{ 22, 971769 },
	{ 22, 2003961 },
	{ 24, 2610169 },
	{ 24, 3642361 },
	{ 24, 6738937 },
	{ 24, 7771129 },
	{ 24, 5493753 },
	{ 24, 6001657 },
	{ 24, 7525369 },
	{ 24, 8299513 },
	{ 24, 7250937 },
	{ 24, 4105209 },
	{ 22, 2028541 },
	{ 22, 2008057 },
	{ 22, 959481 },
	{ 22, 3867641 },
	{ 22, 3818489 },
	{ 22, 3830777 },
	{ 22, 3892221 },
	{ 24, 7177209 },
	{ 24, 6931449 },
	{ 24, 8029177 },
	{ 24, 7521273 },
	{ 24, 5997561 },
	{ 24, 5489657 },
	{ 24, 7767033 },
	{ 24, 6734841 },
	{ 24, 3638265 },
	{ 24, 2606073 },
	{ 22, 1999865 },
	{ 22, 967673 },
	{ 17, 32106 },
	{ 22, 1021689 },
	{ 22, 2021113 },
	{ 24, 3053305 },
	{ 24, 3659513 },
	{ 24, 6788857 },
	{ 24, 7788281 },
	{ 25, 16246521 },
	{ 24, 6018809 },
	{ 24, 7575289 },
	{ 24, 8050425 },
	{ 24, 7857913 },
	{ 24, 6809337 },
	{ 24, 3663609 },
	{ 22, 2012925 },
	{ 22, 1566457 },
	{ 22, 517881 },
	{ 22, 3802873 },
	{ 22, 2049785 },
	{ 22, 3897081 },
	{ 22, 4089597 },
	{ 24, 6915833 },
	{ 23, 4048633 },
	{ 24, 7505657 },
	{ 24, 5949177 },
	{ 24, 5474041 },
	{ 23, 3917561 },
	{ 24, 6719225 },
	{ 24, 3589881 },
	{ 24, 2590457 },
	{ 22, 1558265 },
	{ 22, 952057 },
	{ 17, 45034 },
	{ 22, 1021945 },
	{ 22, 2021369 },
	{ 24, 3053561 },
	{ 24, 3659769 },
	{ 24, 6789113 },
	{ 24, 7788537 },
	{ 25, 16246777 },
	{ 24, 6019065 },
	{ 24, 7575545 },
	{ 24, 8050681 },
	{ 24, 7858169 },
	{ 24, 6809593 },
	{ 24, 3663865 },
	{ 22, 2013181 },
	{ 22, 1566713 },
	{ 22, 518137 },
	{ 22, 3803129 },
	{ 22, 2050041 },
	{ 22, 3897337 },
	{ 22, 4089853 },
	{ 24, 6916089 },
	{ 23, 4048889 },
	{ 24, 7505913 },
	{ 24, 5949433 },
	{ 24, 5474297 },
	{ 23, 3917817 },
	{ 24, 6719481 },
	{ 24, 3590137 },
	{ 24, 2590713 },
	{ 22, 1558521 },
	{ 22, 952313 },
	{ 17, 61418 },
	{ 22, 968701 },
	{ 22, 2017277 },
	{ 24, 3065853 },
	{ 24, 4114429 },
	{ 24, 7260157 },
	{ 24, 8308733 },
	{ 25, 11454461 },
	{ 25, 12503037 },
	{ 25, 15648765 },
	{ 25, 16697341 },
	{ 26, 31443709 },
	{ 26, 31361785 },
	{ 26, 27167481 },
	{ 26, 14584569 },
	{ 24, 6277885 },
	{ 24, 6195961 },
	{ 24, 2001657 },
	{ 24, 8129273 },
	{ 24, 7932665 },
	{ 24, 16370425 },
	{ 24, 16616189 },
	{ 25, 16124665 },
	{ 25, 15141625 },
	{ 26, 23726841 },
	{ 26, 21695225 },
	{ 25, 15600377 },
	{ 25, 13568761 },
	{ 26, 14289657 },
	{ 26, 10160889 },
	{ 24, 6163193 },
	{ 24, 2034425 },
	{ 19, 77674 },
	{ 24, 4148217 },
	{ 24, 8276985 },
	{ 26, 12274681 },
	{ 26, 16403449 },
	{ 26, 27216889 },
	{ 26, 31345657 },
	{ 27, 43731961 },
	{ 27, 64916473 },
	{ 26, 30362617 },
	{ 26, 32394233 },
	{ 26, 31443965 },
	{ 26, 31362041 },
	{ 26, 27167737 },
	{ 26, 14584825 },
	{ 24, 6278141 },
	{ 24, 6196217 },
	{ 24, 2001913 },
	{ 24, 8129529 },
	{ 24, 7932921 },
	{ 24, 16370681 },
	{ 24, 16616445 },
	{ 25, 16124921 },
	{ 25, 15141881 },
	{ 26, 23727097 },
	{ 26, 21695481 },
	{ 25, 15600633 },
	{ 25, 13569017 },
	{ 26, 14289913 },
	{ 26, 10161145 },
	{ 24, 6163449 },
	{ 24, 2034681 },
	{ 19, 94058 },
	{ 24, 3804157 },
	{ 24, 8343289 },
	{ 26, 12472057 },
	{ 26, 16469753 },
	{ 26, 28987129 },
	{ 26, 31411961 },
	{ 27, 43929337 },
	{ 27, 47927033 },
	{ 27, 64720633 },
	{ 26, 32460537 },
	{ 27, 47943417 },
	{ 26, 31379197 },
	{ 26, 31166201 },
	{ 26, 26971897 },
	{ 26, 14388985 },
	{ 24, 6213373 },
	{ 24, 6000377 },
	{ 24, 1806073 },
	{ 24, 7868153 },
	{ 24, 7147257 },
	{ 24, 16633593 },
	{ 25, 15929081 },
	{ 25, 15077113 },
	{ 25, 11996921 },
	{ 26, 21630713 },
	{ 25, 15404793 },
	{ 25, 13504249 },
	{ 25, 7278329 },
	{ 26, 10096377 },
	{ 24, 5967609 },
	{ 24, 1969913 },
	{ 19, 110058 },
	{ 24, 2035453 },
	{ 24, 8343545 },
	{ 26, 12472313 },
	{ 26, 16470009 },
	{ 26, 28987385 },
	{ 26, 31412217 },
	{ 27, 43929593 },
	{ 27, 47927289 },
	{ 27, 64720889 },
	{ 26, 32460793 },
	{ 27, 47943673 },
	{ 26, 31379453 },
	{ 26, 31166457 },
	{ 26, 26972153 },
	{ 26, 14389241 },
	{ 24, 6213629 },
	{ 24, 6000633 },
	{ 24, 1806329 },
	{ 24, 7868409 },
	{ 24, 7147513 },
	{ 24, 16633849 },
	{ 25, 15929337 },
	{ 25, 15077369 },
	{ 25, 11997177 },
	{ 26, 21630969 },
	{ 25, 15405049 },
	{ 25, 13504505 },
	{ 25, 7278585 },
	{ 26, 10096633 },
	{ 24, 5967865 },
	{ 24, 1970169 },
	{ 19, 126442 },
	{ 24, 2035709 },
	{ 24, 6230013 },
	{ 26, 12540665 },
	{ 26, 16669433 },
	{ 26, 29055737 },
	{ 26, 33184505 },
	{ 27, 43997945 },
	{ 27, 48126713 },
	{ 27, 60513017 },
	{ 27, 64658169 },
	{ 27, 60463865 },
	{ 27, 47880953 },
	{ 26, 31185661 },
	{ 26, 31103737 },
	{ 26, 26909433 },
	{ 26, 14326521 },
	{ 24, 6019837 },
	{ 24, 5937913 },
	{ 24, 1743609 },
	{ 24, 7084793 },
	{ 24, 6888185 },
	{ 25, 15866617 },
	{ 25, 14883577 },
	{ 25, 11934457 },
	{ 25, 10951417 },
	{ 25, 15342329 },
	{ 25, 13310713 },
	{ 25, 7215865 },
	{ 25, 5184249 },
	{ 24, 5905145 },
	{ 24, 1776377 },
	{ 19, 208234 },
	{ 24, 1972989 },
	{ 24, 6167293 },
	{ 26, 12540921 },
	{ 26, 16669689 },
	{ 26, 29055993 },
	{ 26, 33184761 },
	{ 27, 43998201 },
	{ 27, 48126969 },
	{ 27, 60513273 },
	{ 27, 64658425 },
	{ 27, 60464121 },
	{ 27, 47881209 },
	{ 26, 31185917 },
	{ 26, 31103993 },
	{ 26, 26909689 },
	{ 26, 14326777 },
	{ 24, 6020093 },
	{ 24, 5938169 },
	{ 24, 1743865 },
	{ 24, 7085049 },
	{ 24, 6888441 },
	{ 25, 15866873 },
	{ 25, 14883833 },
	{ 25, 11934713 },
	{ 25, 10951673 },
	{ 25, 15342585 },
	{ 25, 13310969 },
	{ 25, 7216121 },
	{ 25, 5184505 },
	{ 24, 5905401 },
	{ 24, 1776633 },
	{ 19, 224618 },
	{ 24, 1973245 },
	{ 24, 6167549 },
	{ 26, 10361853 },
	{ 26, 16735993 },
	{ 26, 29253369 },
	{ 26, 33251065 },
	{ 27, 66035449 },
	{ 27, 63938297 },
	{ 27, 57646841 },
	{ 27, 55549689 },
	{ 26, 32481017 },
	{ 26, 30383865 },
	{ 26, 24092409 },
	{ 26, 21995257 },
	{ 25, 15703801 },
	{ 25, 13606649 },
	{ 25, 7315193 },
	{ 24, 5955325 },
	{ 23, 3120889 },
	{ 23, 1023737 },
	{ 24, 6823673 },
	{ 23, 4005625 },
	{ 25, 14819065 },
	{ 25, 11738873 },
	{ 25, 10886905 },
	{ 24, 7806713 },
	{ 25, 13246201 },
	{ 25, 7020281 },
	{ 25, 5119737 },
	{ 23, 3088121 },
	{ 24, 1711865 },
	{ 18, 120810 },
	{ 24, 1777405 },
	{ 24, 5971709 },
	{ 26, 10166013 },
	{ 26, 16736249 },
	{ 26, 29253625 },
	{ 26, 33251321 },
	{ 27, 66035705 },
	{ 27, 63938553 },
	{ 27, 57647097 },
	{ 27, 55549945 },
	{ 26, 32481273 },
	{ 26, 30384121 },
	{ 26, 24092665 },
	{ 26, 21995513 },
	{ 25, 15704057 },
	{ 25, 13606905 },
	{ 25, 7315449 },
	{ 24, 5955581 },
	{ 23, 3121145 },
	{ 23, 1023993 },
	{ 24, 6823929 },
	{ 23, 4005881 },
	{ 25, 14819321 },
	{ 25, 11739129 },
	{ 25, 10887161 },
	{ 24, 7806969 },
	{ 25, 13246457 },
	{ 25, 7020537 },
	{ 25, 5119993 },
	{ 23, 3088377 },
	{ 24, 1712121 },
	{ 18, 129002 },
	{ 24, 1777661 },
	{ 24, 5971965 },
	{ 26, 10166269 },
	{ 26, 14360573 },
	{ 26, 26943485 },
	{ 26, 31137789 },
	{ 27, 43720701 },
	{ 27, 47915005 },
	{ 27, 60497917 },
	{ 27, 64692221 },
	{ 28, 129968893 },
	{ 28, 129641209 },
	{ 28, 121252601 },
	{ 28, 96086777 },
	{ 27, 62860029 },
	{ 27, 62532345 },
	{ 27, 54143737 },
	{ 27, 28977913 },
	{ 25, 12528381 },
	{ 25, 12200697 },
	{ 25, 3812089 },
	{ 25, 15739641 },
	{ 25, 14953209 },
	{ 27, 46672633 },
	{ 27, 42740473 },
	{ 26, 30943993 },
	{ 26, 27011833 },
	{ 27, 27798265 },
	{ 27, 19671801 },
	{ 25, 12069625 },
	{ 25, 3943161 },
	{ 19, 169834 },
	{ 26, 6826749 },
	{ 26, 23603965 },
	{ 28, 40381181 },
	{ 28, 57158397 },
	{ 28, 117255161 },
	{ 28, 133770233 },
	{ 29, 490351609 },
	{ 29, 263859193 },
	{ 29, 255470585 },
	{ 29, 230304761 },
	{ 28, 129969149 },
	{ 28, 129641465 },
	{ 28, 121252857 },
	{ 28, 96087033 },
	{ 27, 62860285 },
	{ 27, 62532601 },
	{ 27, 54143993 },
	{ 27, 28978169 },
	{ 25, 12528637 },
	{ 25, 12200953 },
	{ 25, 3812345 },
	{ 25, 15739897 },
	{ 25, 14953465 },
	{ 27, 46672889 },
	{ 27, 42740729 },
	{ 26, 30944249 },
	{ 26, 27012089 },
	{ 27, 27798521 },
	{ 27, 19672057 },
	{ 25, 12069881 },
	{ 25, 3943417 },
	{ 19, 178026 },
	{ 26, 6827005 },
	{ 26, 23604221 },
	{ 28, 40381437 },
	{ 28, 57158653 },
	{ 28, 107490301 },
	{ 28, 134033145 },
	{ 29, 497954553 },
	{ 29, 489565945 },
	{ 29, 263073529 },
	{ 29, 254684921 },
	{ 29, 229519097 },
	{ 28, 129707773 },
	{ 28, 128855801 },
	{ 28, 120467193 },
	{ 28, 95301369 },
	{ 27, 62598909 },
	{ 27, 61746937 },
	{ 27, 53358329 },
	{ 27, 28192505 },
	{ 25, 12267261 },
	{ 25, 11415289 },
	{ 25, 3026681 },
	{ 25, 14692089 },
	{ 25, 11808505 },
	{ 27, 42479353 },
	{ 26, 30158585 },
	{ 26, 26750713 },
	{ 26, 14429945 },
	{ 27, 19410681 },
	{ 25, 11284217 },
	{ 25, 3682041 },
	{ 19, 185834 },
	{ 25, 3944189 },
	{ 25, 12332797 },
	{ 27, 20721405 },
	{ 27, 29110013 },
	{ 27, 54275837 },
	{ 27, 62664445 },
	{ 28, 87830269 },
	{ 28, 96218877 },
	{ 28, 121384701 },
	{ 28, 129773309 },
	{ 29, 229519353 },
	{ 28, 129708029 },
	{ 28, 128856057 },
	{ 28, 120467449 },
	{ 28, 95301625 },
	{ 27, 62599165 },
	{ 27, 61747193 },
	{ 27, 53358585 },
	{ 27, 28192761 },
	{ 25, 12267517 },
	{ 25, 11415545 },
	{ 25, 3026937 },
	{ 25, 14692345 },
	{ 25, 11808761 },
	{ 27, 42479609 },
	{ 26, 30158841 },
	{ 26, 26750969 },
	{ 26, 14430201 },
	{ 27, 19410937 },
	{ 25, 11284473 },
	{ 25, 3682297 },
	{ 19, 194026 },
	{ 25, 3944445 },
	{ 25, 12333053 },
	{ 27, 20721661 },
	{ 27, 29110269 },
	{ 27, 54276093 },
	{ 27, 62664701 },
	{ 28, 87830525 },
	{ 28, 96219133 },
	{ 28, 121384957 },
	{ 28, 129773565 },
	{ 29, 254425849 },
	{ 29, 229260025 },
	{ 28, 128924413 },
	{ 28, 128596729 },
	{ 28, 120208121 },
	{ 28, 95042297 },
	{ 27, 61815549 },
	{ 27, 61487865 },
	{ 27, 53099257 },
	{ 27, 27933433 },
	{ 25, 11483901 },
	{ 25, 11156217 },
	{ 25, 2767609 },
	{ 25, 11549433 },
	{ 25, 10763001 },
	{ 26, 29899513 },
	{ 26, 25967353 },
	{ 26, 14170873 },
	{ 26, 10238713 },
	{ 25, 11025145 },
	{ 25, 2898681 },
	{ 19, 234858 },
	{ 25, 3685117 },
	{ 25, 12073725 },
	{ 26, 24313855 },
	{ 27, 28850941 },
	{ 27, 54016765 },
	{ 27, 62405373 },
	{ 28, 87571197 },
	{ 28, 95959805 },
	{ 28, 121125629 },
	{ 28, 129514237 },
	{ 29, 254426105 },
	{ 29, 229260281 },
	{ 28, 128924669 },
	{ 28, 128596985 },
	{ 28, 120208377 },
	{ 28, 95042553 },
	{ 27, 61815805 },
	{ 27, 61488121 },
	{ 27, 53099513 },
	{ 27, 27933689 },
	{ 25, 11484157 },
	{ 25, 11156473 },
	{ 25, 2767865 },
	{ 25, 11549689 },
	{ 25, 10763257 },
	{ 26, 29899769 },
	{ 26, 25967609 },
	{ 26, 14171129 },
	{ 26, 10238969 },
	{ 25, 11025401 },
	{ 25, 2898937 },
	{ 19, 243050 },
	{ 25, 3685373 },
	{ 25, 12073981 },
	{ 26, 24313599 },
	{ 27, 28851197 },
	{ 27, 54017021 },
	{ 27, 62405629 },
	{ 28, 266223353 },
	{ 28, 262029049 },
	{ 28, 249446137 },
	{ 28, 245251833 },
	{ 28, 132005625 },
	{ 28, 127811321 },
	{ 28, 115228409 },
	{ 28, 111034105 },
	{ 27, 64896761 },
	{ 27, 60702457 },
	{ 27, 48119545 },
	{ 27, 43925241 },
	{ 26, 31342329 },
	{ 26, 27148025 },
	{ 26, 14565113 },
	{ 25, 11222781 },
	{ 24, 6176505 },
	{ 24, 1982201 },
	{ 25, 10501881 },
	{ 24, 7618297 },
	{ 25, 15399931 },
	{ 26, 13385465 },
	{ 26, 9977593 },
	{ 24, 6045433 },
	{ 25, 2637561 },
	{ 18, 125930 },
	{ 25, 2899709 },
	{ 25, 11288317 },
	{ 26, 22739967 },
	{ 27, 28065533 },
	{ 27, 53231357 },
	{ 27, 61619965 },
	{ 28, 266223609 },
	{ 28, 262029305 },
	{ 28, 249446393 },
	{ 28, 245252089 },
	{ 28, 132005881 },
	{ 28, 127811577 },
	{ 28, 115228665 },
	{ 28, 111034361 },
	{ 27, 64897017 },
	{ 27, 60702713 },
	{ 27, 48119801 },
	{ 27, 43925497 },
	{ 26, 31342585 },
	{ 26, 27148281 },
	{ 26, 14565369 },
	{ 25, 11223037 },
	{ 24, 6176761 },
	{ 24, 1982457 },
	{ 25, 10502137 },
	{ 24, 7618553 },
	{ 25, 15399675 },
	{ 26, 13385721 },
	{ 26, 9977849 },
	{ 24, 6045689 },
	{ 25, 2637817 },
	{ 18, 130026 },
	{ 25, 2899965 },
	{ 25, 11288573 },
	{ 26, 22739711 },
	{ 27, 28065789 },
	{ 27, 53231613 },
	{ 27, 61620221 },
	{ 28, 266300157 },
	{ 28, 265972473 },
	{ 28, 261778169 },
	{ 28, 249195257 },
	{ 28, 245000953 },
	{ 28, 131754745 },
	{ 28, 127560441 },
	{ 28, 114977529 },
	{ 27, 64973565 },
	{ 27, 64645881 },
	{ 27, 60451577 },
	{ 27, 47868665 },
	{ 26, 31419133 },
	{ 26, 31091449 },
	{ 26, 26897145 },
	{ 26, 14314233 },
	{ 24, 6253309 },
	{ 24, 5925625 },
	{ 24, 1731321 },
	{ 24, 7367417 },
	{ 24, 6580985 },
	{ 25, 13299707 },
	{ 26, 9202425 },
	{ 24, 5794553 },
	{ 24, 1862393 },
	{ 19, 215914 },
	{ 25, 2648829 },
	{ 25, 11037437 },
	{ 26, 22212607 },
	{ 27, 27814653 },
	{ 27, 52980477 },
	{ 27, 61369085 },
	{ 28, 86534909 },
	{ 28, 265972729 },
	{ 28, 261778425 },
	{ 28, 249195513 },
	{ 28, 245001209 },
	{ 28, 131755001 },
	{ 28, 127560697 },
	{ 28, 114977785 },
	{ 27, 64973821 },
	{ 27, 64646137 },
	{ 27, 60451833 },
	{ 27, 47868921 },
	{ 26, 31419389 },
	{ 26, 31091705 },
	{ 26, 26897401 },
	{ 26, 14314489 },
	{ 24, 6253565 },
	{ 24, 5925881 },
	{ 24, 1731577 },
	{ 24, 7367673 },
	{ 24, 6581241 },
	{ 25, 13299451 },
	{ 26, 9202681 },
	{ 24, 5794809 },
	{ 24, 1862649 },
	{ 19, 220010 },
	{ 25, 2649085 },
	{ 25, 11037693 },
	{ 26, 22212351 },
	{ 27, 27814909 },
	{ 27, 52980733 },
	{ 27, 61369341 },
	{ 28, 86535165 },
	{ 28, 266039037 },
	{ 28, 265187065 },
	{ 28, 260992761 },
	{ 28, 248409849 },
	{ 28, 244215545 },
	{ 28, 130969337 },
	{ 28, 126775033 },
	{ 28, 114192121 },
	{ 27, 64712445 },
	{ 27, 63860473 },
	{ 27, 59666169 },
	{ 27, 47083257 },
	{ 26, 31158013 },
	{ 26, 30306041 },
	{ 26, 26111737 },
	{ 26, 13528825 },
	{ 24, 5992189 },
	{ 24, 5140217 },
	{ 24, 945913 },
	{ 24, 6319865 },
	{ 24, 3436281 },
	{ 25, 7007227 },
	{ 24, 5009145 },
	{ 24, 1601273 },
	{ 19, 223722 },
	{ 24, 1863421 },
	{ 24, 6057725 },
	{ 25, 12250111 },
	{ 26, 14446333 },
	{ 26, 27029245 },
	{ 26, 31223549 },
	{ 27, 43806461 },
	{ 27, 48000765 },
	{ 27, 60583677 },
	{ 27, 64777981 },
	{ 28, 248410105 },
	{ 28, 244215801 },
	{ 28, 130969593 },
	{ 28, 126775289 },
	{ 28, 114192377 },
	{ 27, 64712701 },
	{ 27, 63860729 },
	{ 27, 59666425 },
	{ 27, 47083513 },
	{ 26, 31158269 },
	{ 26, 30306297 },
	{ 26, 26111993 },
	{ 26, 13529081 },
	{ 24, 5992445 },
	{ 24, 5140473 },
	{ 24, 946169 },
	{ 24, 6320121 },
	{ 24, 3436537 },
	{ 25, 7006971 },
	{ 24, 5009401 },
	{ 24, 1601529 },
	{ 19, 227818 },
	{ 24, 1863677 },
	{ 24, 6057981 },
	{ 25, 12249855 },
	{ 26, 14446589 },
	{ 26, 27029501 },
	{ 26, 31223805 },
	{ 27, 43806717 },
	{ 27, 48001021 },
	{ 27, 60583933 },
	{ 27, 64778237 },
	{ 28, 260733689 },
	{ 28, 248150777 },
	{ 28, 243956473 },
	{ 28, 130710265 },
	{ 28, 126515961 },
	{ 28, 113933049 },
	{ 27, 63929085 },
	{ 27, 63601401 },
	{ 27, 59407097 },
	{ 27, 46824185 },
	{ 26, 30374653 },
	{ 26, 30046969 },
	{ 26, 25852665 },
	{ 26, 13269753 },
	{ 24, 5208829 },
	{ 24, 4881145 },
	{ 24, 686841 },
	{ 24, 3177209 },
	{ 24, 2390777 },
	{ 24, 4750073 },
	{ 24, 817913 },
	{ 19, 248170 },
	{ 19, 522526 },
	{ 24, 5798653 },
	{ 25, 11714559 },
	{ 26, 14187261 },
	{ 26, 26770173 },
	{ 26, 30964477 },
	{ 27, 43547389 },
	{ 27, 47741693 },
	{ 27, 60324605 },
	{ 27, 64518909 },
	{ 28, 260733945 },
	{ 28, 248151033 },
	{ 28, 243956729 },
	{ 28, 130710521 },
	{ 28, 126516217 },
	{ 28, 113933305 },
	{ 27, 63929341 },
	{ 27, 63601657 },
	{ 27, 59407353 },
	{ 27, 46824441 },
	{ 26, 30374909 },
	{ 26, 30047225 },
	{ 26, 25852921 },
	{ 26, 13270009 },
	{ 24, 5209085 },
	{ 24, 4881401 },
	{ 24, 687097 },
	{ 24, 3177465 },
	{ 24, 2391033 },
	{ 24, 4750329 },
	{ 24, 818169 },
	{ 19, 252266 },
	{ 19, 518430 },
	{ 24, 5798909 },
	{ 25, 11714303 },
	{ 26, 14187517 },
	{ 26, 26770429 },
	{ 26, 30964733 },
	{ 27, 43547645 },
	{ 27, 47741949 },
	{ 27, 60324861 },
	{ 27, 64519165 },
	{ 26, 66486009 },
	{ 26, 65437433 },
	{ 26, 62291705 },
	{ 26, 61243129 },
	{ 26, 32931577 },
	{ 26, 31883001 },
	{ 26, 28737273 },
	{ 26, 27688697 },
	{ 25, 16154361 },
	{ 25, 15105785 },
	{ 25, 11960057 },
	{ 25, 10911481 },
	{ 24, 7765753 },
	{ 24, 6717177 },
	{ 24, 3571449 },
	{ 24, 2522873 },
	{ 22, 1474297 },
	{ 22, 425721 },
	{ 23, 2538491 },
	{ 22, 1343225 },
	{ 23, 2800635 },
	{ 17, 64234 },
	{ 17, 128670 },
	{ 24, 5013245 },
	{ 25, 10140671 },
	{ 26, 13401853 },
	{ 26, 25984765 },
	{ 26, 30179069 },
	{ 27, 42761981 },
	{ 27, 46956285 },
	{ 27, 59539197 },
	{ 27, 63733501 },
	{ 26, 66486265 },
	{ 26, 65437689 },
	{ 26, 62291961 },
	{ 26, 61243385 },
	{ 26, 32931833 },
	{ 26, 31883257 },
	{ 26, 28737529 },
	{ 26, 27688953 },
	{ 25, 16154617 },
	{ 25, 15106041 },
	{ 25, 11960313 },
	{ 25, 10911737 },
	{ 24, 7766009 },
	{ 24, 6717433 },
	{ 24, 3571705 },
	{ 24, 2523129 },
	{ 22, 1474553 },
	{ 22, 425977 },
	{ 23, 2538235 },
	{ 22, 1343481 },
	{ 23, 2800379 },
	{ 17, 65258 },
	{ 17, 127646 },
	{ 24, 5013501 },
	{ 25, 10140415 },
	{ 26, 13402109 },
	{ 26, 25985021 },
	{ 26, 30179325 },
	{ 27, 42762237 },
	{ 27, 46956541 },
	{ 27, 59539453 },
	{ 27, 63733757 },
	{ 27, 133081853 },
	{ 27, 132426489 },
	{ 27, 130329337 },
	{ 27, 124037881 },
	{ 27, 121940729 },
	{ 27, 65317625 },
	{ 27, 63220473 },
	{ 27, 56929017 },
	{ 26, 32418557 },
	{ 26, 31763193 },
	{ 26, 29666041 },
	{ 26, 23374585 },
	{ 25, 15641341 },
	{ 25, 14985977 },
	{ 25, 12888825 },
	{ 25, 6597369 },
	{ 23, 3058429 },
	{ 23, 2403065 },
	{ 23, 305913 },
	{ 18, 238969 },
	{ 18, 245627 },
	{ 17, 119402 },
	{ 17, 122398 },
	{ 25, 9480957 },
	{ 25, 9613311 },
	{ 27, 26258173 },
	{ 27, 51423997 },
	{ 27, 59812605 },
	{ 27, 59944959 },
	{ 28, 93367037 },
	{ 28, 118532861 },
	{ 28, 126921469 },
	{ 27, 133082109 },
	{ 27, 132426745 },
	{ 27, 130329593 },
	{ 27, 124038137 },
	{ 27, 121940985 },
	{ 27, 65317881 },
	{ 27, 63220729 },
	{ 27, 56929273 },
	{ 26, 32418813 },
	{ 26, 31763449 },
	{ 26, 29666297 },
	{ 26, 23374841 },
	{ 25, 15641597 },
	{ 25, 14986233 },
	{ 25, 12889081 },
	{ 25, 6597625 },
	{ 23, 3058685 },
	{ 23, 2403321 },
	{ 23, 306169 },
	{ 18, 241017 },
	{ 18, 243579 },
	{ 17, 120426 },
	{ 17, 121374 },
	{ 25, 9481213 },
	{ 25, 9613055 },
	{ 27, 26258429 },
	{ 27, 51424253 },
	{ 27, 59812861 },
	{ 27, 59944703 },
	{ 28, 93367293 },
	{ 28, 118533117 },
	{ 28, 126921725 },
	{ 28, 127053567 },
	{ 27, 132558589 },
	{ 27, 130461437 },
	{ 27, 124169981 },
	{ 27, 122072829 },
	{ 27, 65449725 },
	{ 27, 63352573 },
	{ 27, 57061117 },
	{ 27, 54963965 },
	{ 26, 31895293 },
	{ 26, 29798141 },
	{ 26, 23506685 },
	{ 26, 21409533 },
	{ 25, 15118077 },
	{ 25, 13020925 },
	{ 25, 6729469 },
	{ 25, 4632317 },
	{ 23, 2535165 },
	{ 23, 438013 },
	{ 23, 306175 },
	{ 23, 4194217 },
	{ 23, 175099 },
	{ 23, 569085 },
	{ 23, 2666237 },
	{ 23, 2796543 },
	{ 25, 6860541 },
	{ 25, 13151997 },
	{ 25, 15249149 },
	{ 25, 15379455 },
	{ 26, 23637757 },
	{ 26, 29929213 },
	{ 26, 32026365 },
	{ 26, 32156671 },
	{ 27, 57192189 },
	{ 27, 63483645 },
	{ 27, 65580797 },
	{ 27, 122203901 },
	{ 27, 124301053 },
	{ 27, 130592509 },
	{ 27, 132689661 },
	{ 27, 54964221 },
	{ 26, 31895549 },
	{ 26, 29798397 },
	{ 26, 23506941 },
	{ 26, 21409789 },
	{ 25, 15118333 },
	{ 25, 13021181 },
	{ 25, 6729725 },
	{ 25, 4632573 },
	{ 23, 2535421 },
	{ 23, 438269 },
	{ 23, 305919 },
	{ 22, 2097097 },
	{ 21, 1048539 },
	{ 14, 7886 },
	{ 23, 2666493 },
	{ 23, 2796287 },
	{ 25, 6860797 },
	{ 25, 13152253 },
	{ 25, 15249405 },
	{ 25, 15379199 },
	{ 26, 23638013 },
	{ 26, 29929469 },
	{ 26, 32026621 },
	{ 26, 32156415 },
	{ 27, 57192445 },
	{ 27, 63483901 },
	{ 27, 132299517 },
	{ 26, 66093055 },
	{ 26, 65044479 },
	{ 26, 61898751 },
	{ 26, 60850175 },
	{ 26, 32538623 },
	{ 26, 31490047 },
	{ 26, 28344319 },
	{ 26, 31636221 },
	{ 25, 15761407 },
	{ 25, 14712831 },
	{ 25, 11567103 },
	{ 25, 14859005 },
	{ 24, 7372799 },
	{ 24, 6324223 },
	{ 24, 3178495 },
	{ 18, 255869 },
	{ 18, 130431 },
	{ 20, 524239 },
	{ 14, 7822 },
	{ 18, 255357 },
	{ 18, 130943 },
	{ 24, 2195455 },
	{ 24, 3244031 },
	{ 24, 6389759 },
	{ 24, 7438335 },
	{ 25, 10584063 },
	{ 25, 11632639 },
	{ 25, 14778367 },
	{ 25, 15826943 },
	{ 26, 27361279 },
	{ 26, 28409855 },
	{ 26, 31555583 },
	{ 26, 66092799 },
	{ 26, 65044223 },
	{ 26, 61898495 },
	{ 26, 60849919 },
	{ 26, 32538367 },
	{ 26, 31489791 },
	{ 26, 28344063 },
	{ 26, 31636477 },
	{ 25, 15761151 },
	{ 25, 14712575 },
	{ 25, 11566847 },
	{ 25, 14859261 },
	{ 24, 7372543 },
	{ 24, 6323967 },
	{ 24, 3178239 },
	{ 18, 257917 },
	{ 18, 128383 },
	{ 14, 15242 },
	{ 22, 4194253 },
	{ 18, 257405 },
	{ 18, 128895 },
	{ 24, 2195199 },
	{ 24, 3243775 },
	{ 24, 6389503 },
	{ 24, 7438079 },
	{ 25, 10583807 },
	{ 25, 11632383 },
	{ 25, 14778111 },
	{ 25, 15826687 },
	{ 26, 27361023 },
	{ 26, 28409599 },
	{ 26, 31555327 },
	{ 26, 32603903 },
	{ 26, 60915455 },
	{ 26, 61964031 },
	{ 26, 65109759 },
	{ 26, 66158335 },
	{ 26, 31751167 },
	{ 26, 28605439 },
	{ 26, 32161533 },
	{ 25, 16022527 },
	{ 25, 14973951 },
	{ 25, 11828223 },
	{ 25, 15384317 },
	{ 24, 7633919 },
	{ 24, 6585343 },
	{ 24, 3439615 },
	{ 23, 2801405 },
	{ 22, 1342463 },
	{ 14, 15306 },
	{ 21, 1048542 },
	{ 19, 262091 },
	{ 22, 2096955 },
	{ 22, 228351 },
	{ 22, 1276927 },
	{ 24, 2325503 },
	{ 24, 3374079 },
	{ 24, 6519807 },
	{ 24, 7568383 },
	{ 25, 10714111 },
	{ 25, 11762687 },
	{ 25, 14908415 },
	{ 25, 15956991 },
	{ 26, 27491327 },
	{ 26, 66353919 },
	{ 26, 65305343 },
	{ 26, 62159615 },
	{ 26, 61111039 },
	{ 26, 32799487 },
	{ 26, 31750911 },
	{ 26, 28605183 },
	{ 26, 32161789 },
	{ 25, 16022271 },
	{ 25, 14973695 },
	{ 25, 11827967 },
	{ 25, 15384573 },
	{ 24, 7633663 },
	{ 24, 6585087 },
	{ 24, 3439359 },
	{ 23, 2801661 },
	{ 22, 1342207 },
	{ 22, 293631 },
	{ 21, 1048414 },
	{ 20, 524203 },
	{ 22, 2097131 },
	{ 22, 228095 },
	{ 22, 1276671 },
	{ 24, 2325247 },
	{ 24, 3373823 },
	{ 24, 6519551 },
	{ 24, 7568127 },
	{ 25, 10713855 },
	{ 25, 11762431 },
	{ 25, 14908159 },
	{ 25, 15956735 },
	{ 26, 27491071 },
	{ 26, 28539647 },
	{ 26, 31685375 },
	{ 26, 32733951 },
	{ 26, 61045503 },
	{ 26, 62094079 },
	{ 26, 65239807 },
	{ 26, 66288383 },
	{ 28, 127068925 },
	{ 27, 63467519 },
	{ 27, 59273215 },
	{ 27, 46690303 },
	{ 27, 59960061 },
	{ 26, 29913087 },
	{ 26, 25718783 },
	{ 26, 13135871 },
	{ 25, 9628413 },
	{ 24, 4747263 },
	{ 24, 552959 },
	{ 17, 56942 },
	{ 22, 2096827 },
	{ 18, 114043 },
	{ 22, 159739 },
	{ 22, 1208315 },
	{ 22, 1535999 },
	{ 24, 3305467 },
	{ 24, 6451195 },
	{ 24, 7499771 },
	{ 24, 7827455 },
	{ 25, 11694075 },
	{ 25, 14839803 },
	{ 25, 15888379 },
	{ 25, 16216063 },
	{ 26, 28471291 },
	{ 26, 31617019 },
	{ 26, 32665595 },
	{ 26, 60977147 },
	{ 26, 62025723 },
	{ 26, 65171451 },
	{ 26, 66220027 },
	{ 26, 66547711 },
	{ 27, 63467263 },
	{ 27, 59272959 },
	{ 27, 46690047 },
	{ 27, 59960317 },
	{ 26, 29912831 },
	{ 26, 25718527 },
	{ 26, 13135615 },
	{ 25, 9628669 },
	{ 24, 4747007 },
	{ 24, 552703 },
	{ 17, 55918 },
	{ 22, 290555 },
	{ 18, 111995 },
	{ 22, 159483 },
	{ 22, 1208059 },
	{ 22, 1535743 },
	{ 24, 3305211 },
	{ 24, 6450939 },
	{ 24, 7499515 },
	{ 24, 7827199 },
	{ 25, 11693819 },
	{ 25, 14839547 },
	{ 25, 15888123 },
	{ 25, 16215807 },
	{ 26, 28471035 },
	{ 26, 31616763 },
	{ 26, 32665339 },
	{ 26, 60976891 },
	{ 26, 62025467 },
	{ 26, 65171195 },
	{ 26, 66219771 },
	{ 26, 66547455 },
	{ 27, 63728639 },
	{ 27, 59534335 },
	{ 27, 46951423 },
	{ 27, 60485373 },
	{ 26, 30174207 },
	{ 26, 25979903 },
	{ 26, 13396991 },
	{ 25, 10153725 },
	{ 24, 5008383 },
	{ 24, 814079 },
	{ 17, 55022 },
	{ 23, 2813689 },
	{ 22, 1338363 },
	{ 23, 2551545 },
	{ 22, 420859 },
	{ 22, 1469435 },
	{ 24, 2518011 },
	{ 24, 3566587 },
	{ 24, 6712315 },
	{ 24, 7760891 },
	{ 25, 10906619 },
	{ 25, 11955195 },
	{ 25, 15100923 },
	{ 25, 16149499 },
	{ 26, 27683835 },
	{ 26, 28732411 },
	{ 26, 31878139 },
	{ 26, 32926715 },
	{ 26, 61238267 },
	{ 26, 62286843 },
	{ 26, 65432571 },
	{ 26, 66481147 },
	{ 27, 63728383 },
	{ 27, 59534079 },
	{ 27, 46951167 },
	{ 27, 60485629 },
	{ 26, 30173951 },
	{ 26, 25979647 },
	{ 26, 13396735 },
	{ 25, 10153981 },
	{ 24, 5008127 },
	{ 24, 813823 },
	{ 17, 53998 },
	{ 23, 2813945 },
	{ 22, 1338107 },
	{ 23, 2551801 },
	{ 22, 420603 },
	{ 22, 1469179 },
	{ 24, 2517755 },
	{ 24, 3566331 },
	{ 24, 6712059 },
	{ 24, 7760635 },
	{ 25, 10906363 },
	{ 25, 11954939 },
	{ 25, 15100667 },
	{ 25, 16149243 },
	{ 26, 27683579 },
	{ 26, 28732155 },
	{ 26, 31877883 },
	{ 26, 32926459 },
	{ 26, 61238011 },
	{ 26, 62286587 },
	{ 26, 65432315 },
	{ 26, 66480891 },
	{ 27, 64503807 },
	{ 27, 60309503 },
	{ 27, 47726591 },
	{ 27, 62061309 },
	{ 26, 30949375 },
	{ 26, 26755071 },
	{ 26, 14172159 },
	{ 25, 11729661 },
	{ 24, 5783551 },
	{ 24, 1589247 },
	{ 18, 129390 },
	{ 24, 802811 },
	{ 24, 4734971 },
	{ 24, 2375675 },
	{ 24, 3162107 },
	{ 24, 671739 },
	{ 24, 4866043 },
	{ 24, 5193727 },
	{ 26, 13254651 },
	{ 26, 25837563 },
	{ 26, 30031867 },
	{ 26, 30359551 },
	{ 27, 46809083 },
	{ 27, 59391995 },
	{ 27, 63586299 },
	{ 27, 63913983 },
	{ 28, 113917947 },
	{ 28, 126500859 },
	{ 28, 130695163 },
	{ 28, 243941371 },
	{ 28, 248135675 },
	{ 28, 129170429 },
	{ 27, 64503551 },
	{ 27, 60309247 },
	{ 27, 47726335 },
	{ 27, 62061565 },
	{ 26, 30949119 },
	{ 26, 26754815 },
	{ 26, 14171903 },
	{ 25, 11729917 },
	{ 24, 5783295 },
	{ 24, 1588991 },
	{ 18, 125294 },
	{ 24, 802555 },
	{ 24, 4734715 },
	{ 24, 2375419 },
	{ 24, 3161851 },
	{ 24, 671483 },
	{ 24, 4865787 },
	{ 24, 5193471 },
	{ 26, 13254395 },
	{ 26, 25837307 },
	{ 26, 30031611 },
	{ 26, 30359295 },
	{ 27, 46808827 },
	{ 27, 59391739 },
	{ 27, 63586043 },
	{ 27, 63913727 },
	{ 28, 113917691 },
	{ 28, 126500603 },
	{ 28, 130694907 },
	{ 28, 243941115 },
	{ 28, 248135419 },
	{ 28, 129695485 },
	{ 27, 64764927 },
	{ 27, 60570623 },
	{ 27, 47987711 },
	{ 27, 62586621 },
	{ 26, 31210495 },
	{ 26, 27016191 },
	{ 26, 14433279 },
	{ 25, 12254973 },
	{ 24, 6044671 },
	{ 24, 1850367 },
	{ 18, 121326 },
	{ 24, 1588219 },
	{ 24, 4996091 },
	{ 25, 7012089 },
	{ 24, 3423227 },
	{ 24, 6306811 },
	{ 24, 932859 },
	{ 24, 5127163 },
	{ 24, 5979135 },
	{ 26, 13515771 },
	{ 26, 26098683 },
	{ 26, 30292987 },
	{ 26, 31144959 },
	{ 27, 47070203 },
	{ 27, 59653115 },
	{ 27, 63847419 },
	{ 27, 64699391 },
	{ 28, 114179067 },
	{ 28, 126761979 },
	{ 28, 130956283 },
	{ 28, 244202491 },
	{ 28, 129695741 },
	{ 27, 64764671 },
	{ 27, 60570367 },
	{ 27, 47987455 },
	{ 27, 62586877 },
	{ 26, 31210239 },
	{ 26, 27015935 },
	{ 26, 14433023 },
	{ 25, 12255229 },
	{ 24, 6044415 },
	{ 24, 1850111 },
	{ 18, 117230 },
	{ 24, 1587963 },
	{ 24, 4995835 },
	{ 25, 7012345 },
	{ 24, 3422971 },
	{ 24, 6306555 },
	{ 24, 932603 },
	{ 24, 5126907 },
	{ 24, 5978879 },
	{ 26, 13515515 },
	{ 26, 26098427 },
	{ 26, 30292731 },
	{ 26, 31144703 },
	{ 27, 47069947 },
	{ 27, 59652859 },
	{ 27, 63847163 },
	{ 27, 64699135 },
	{ 28, 114178811 },
	{ 28, 126761723 },
	{ 28, 130956027 },
	{ 28, 244202235 },
	{ 28, 248396539 },
	{ 28, 260979451 },
	{ 28, 265173755 },
	{ 28, 266025727 },
	{ 28, 86519807 },
	{ 27, 61353983 },
	{ 27, 52965375 },
	{ 27, 27799551 },
	{ 27, 44411645 },
	{ 25, 11022335 },
	{ 25, 2633727 },
	{ 18, 97134 },
	{ 24, 1847291 },
	{ 24, 5779451 },
	{ 26, 9187323 },
	{ 26, 26585849 },
	{ 24, 6565883 },
	{ 24, 7352315 },
	{ 24, 1716219 },
	{ 24, 5910523 },
	{ 24, 6238207 },
	{ 26, 14299131 },
	{ 26, 26882043 },
	{ 26, 31076347 },
	{ 26, 31404031 },
	{ 27, 47853563 },
	{ 27, 60436475 },
	{ 27, 64630779 },
	{ 27, 64958463 },
	{ 28, 114962427 },
	{ 28, 127545339 },
	{ 28, 131739643 },
	{ 28, 244985851 },
	{ 28, 249180155 },
	{ 28, 261763067 },
	{ 28, 265957371 },
	{ 28, 86519551 },
	{ 27, 61353727 },
	{ 27, 52965119 },
	{ 27, 27799295 },
	{ 27, 44411901 },
	{ 25, 11022079 },
	{ 25, 2633471 },
	{ 18, 93038 },
	{ 24, 1847035 },
	{ 24, 5779195 },
	{ 26, 9187067 },
	{ 26, 26586105 },
	{ 24, 6565627 },
	{ 24, 7352059 },
	{ 24, 1715963 },
	{ 24, 5910267 },
	{ 24, 6237951 },
	{ 26, 14298875 },
	{ 26, 26881787 },
	{ 26, 31076091 },
	{ 26, 31403775 },
	{ 27, 47853307 },
	{ 27, 60436219 },
	{ 27, 64630523 },
	{ 27, 64958207 },
	{ 28, 114962171 },
	{ 28, 127545083 },
	{ 28, 131739387 },
	{ 28, 244985595 },
	{ 28, 249179899 },
	{ 28, 261762811 },
	{ 28, 265957115 },
	{ 28, 266284799 },
	{ 27, 61615103 },
	{ 27, 53226495 },
	{ 27, 28060671 },
	{ 27, 45461245 },
	{ 25, 11283455 },
	{ 25, 2894847 },
	{ 18, 89070 },
	{ 25, 2632699 },
	{ 24, 6040571 },
	{ 26, 9972731 },
	{ 26, 13380603 },
	{ 26, 30781177 },
	{ 24, 7613435 },
	{ 25, 10497019 },
	{ 24, 1977339 },
	{ 24, 6171643 },
	{ 25, 11217919 },
	{ 26, 14560251 },
	{ 26, 27143163 },
	{ 26, 31337467 },
	{ 27, 43920379 },
	{ 27, 48114683 },
	{ 27, 60697595 },
	{ 27, 64891899 },
	{ 28, 111029243 },
	{ 28, 115223547 },
	{ 28, 127806459 },
	{ 28, 132000763 },
	{ 28, 245246971 },
	{ 28, 249441275 },
	{ 28, 262024187 },
	{ 28, 266218491 },
	{ 27, 61614847 },
	{ 27, 53226239 },
	{ 27, 28060415 },
	{ 27, 45461501 },
	{ 25, 11283199 },
	{ 25, 2894591 },
	{ 18, 84974 },
	{ 25, 2632443 },
	{ 24, 6040315 },
	{ 26, 9972475 },
	{ 26, 13380347 },
	{ 26, 30781433 },
	{ 24, 7613179 },
	{ 25, 10496763 },
	{ 24, 1977083 },
	{ 24, 6171387 },
	{ 25, 11217663 },
	{ 26, 14559995 },
	{ 26, 27142907 },
	{ 26, 31337211 },
	{ 27, 43920123 },
	{ 27, 48114427 },
	{ 27, 60697339 },
	{ 27, 64891643 },
	{ 27, 65937407 },
	{ 27, 63840255 },
	{ 27, 57548799 },
	{ 27, 55451647 },
	{ 26, 32382975 },
	{ 26, 30285823 },
	{ 26, 23994367 },
	{ 26, 21897215 },
	{ 25, 15605759 },
	{ 25, 13508607 },
	{ 25, 7217151 },
	{ 25, 5119999 },
	{ 23, 3022847 },
	{ 23, 925695 },
	{ 18, 128366 },
	{ 23, 729083 },
	{ 23, 2760699 },
	{ 24, 2564091 },
	{ 24, 3547131 },
	{ 24, 6496251 },
	{ 24, 7479291 },
	{ 23, 2695163 },
	{ 23, 2891771 },
	{ 23, 696315 },
	{ 23, 2793467 },
	{ 23, 2875391 },
	{ 25, 6987771 },
	{ 25, 13279227 },
	{ 25, 15376379 },
	{ 25, 15458303 },
	{ 26, 23764987 },
	{ 26, 30056443 },
	{ 26, 32153595 },
	{ 26, 32235519 },
	{ 27, 57319419 },
	{ 27, 63610875 },
	{ 26, 32382719 },
	{ 26, 30285567 },
	{ 26, 23994111 },
	{ 26, 21896959 },
	{ 25, 15605503 },
	{ 25, 13508351 },
	{ 25, 7216895 },
	{ 25, 5119743 },
	{ 23, 3022591 },
	{ 23, 925439 },
	{ 18, 120174 },
	{ 23, 728827 },
	{ 23, 2760443 },
	{ 24, 2563835 },
	{ 24, 3546875 },
	{ 24, 6495995 },
	{ 24, 7479035 },
	{ 23, 2694907 },
	{ 23, 2891515 },
	{ 23, 696059 },
	{ 23, 2793211 },
	{ 23, 2875135 },
	{ 25, 6987515 },
	{ 25, 13278971 },
	{ 25, 15376123 },
	{ 25, 15458047 },
	{ 26, 23764731 },
	{ 26, 30056187 },
	{ 26, 32153339 },
	{ 26, 32235263 },
	{ 27, 57319163 },
	{ 27, 63610619 },
	{ 26, 32447487 },
	{ 26, 30350335 },
	{ 26, 24058879 },
	{ 26, 21961727 },
	{ 25, 15670271 },
	{ 25, 13573119 },
	{ 25, 7281663 },
	{ 25, 5184511 },
	{ 23, 3087359 },
	{ 23, 990207 },
	{ 18, 112110 },
	{ 23, 924667 },
	{ 23, 2825211 },
	{ 25, 4856827 },
	{ 24, 3611643 },
	{ 24, 6691835 },
	{ 24, 7543803 },
	{ 25, 10623995 },
	{ 23, 2956283 },
	{ 23, 3677179 },
	{ 23, 760827 },
	{ 23, 2857979 },
	{ 23, 3070975 },
	{ 25, 7052283 },
	{ 25, 13343739 },
	{ 25, 15440891 },
	{ 25, 15653887 },
	{ 26, 23829499 },
	{ 26, 30120955 },
	{ 26, 32218107 },
	{ 26, 32431103 },
	{ 27, 57383931 },
	{ 26, 32447231 },
	{ 26, 30350079 },
	{ 26, 24058623 },
	{ 26, 21961471 },
	{ 25, 15670015 },
	{ 25, 13572863 },
	{ 25, 7281407 },
	{ 25, 5184255 },
	{ 23, 3087103 },
	{ 23, 989951 },
	{ 18, 103918 },
	{ 23, 924411 },
	{ 23, 2824955 },
	{ 25, 4856571 },
	{ 24, 3611387 },
	{ 24, 6691579 },
	{ 24, 7543547 },
	{ 25, 10623739 },
	{ 23, 2956027 },
	{ 23, 3676923 },
	{ 23, 760571 },
	{ 23, 2857723 },
	{ 23, 3070719 },
	{ 25, 7052027 },
	{ 25, 13343483 },
	{ 25, 15440635 },
	{ 25, 15653631 },
	{ 26, 23829243 },
	{ 26, 30120699 },
	{ 26, 32217851 },
	{ 26, 32430847 },
	{ 27, 57383675 },
	{ 27, 63675131 },
	{ 27, 65772283 },
	{ 27, 122395387 },
	{ 27, 124492539 },
	{ 26, 33512187 },
	{ 26, 26873855 },
	{ 26, 14290943 },
	{ 26, 10096639 },
	{ 24, 5902335 },
	{ 24, 1708031 },
	{ 18, 63342 },
	{ 23, 987131 },
	{ 23, 3018747 },
	{ 25, 4919291 },
	{ 25, 6950907 },
	{ 24, 6754299 },
	{ 24, 7737339 },
	{ 25, 10686459 },
	{ 25, 11669499 },
	{ 23, 3739643 },
	{ 23, 3936251 },
	{ 23, 954363 },
	{ 23, 3051515 },
	{ 23, 3133439 },
	{ 25, 7245819 },
	{ 25, 13537275 },
	{ 25, 15634427 },
	{ 25, 15716351 },
	{ 26, 24023035 },
	{ 26, 30314491 },
	{ 26, 32411643 },
	{ 26, 32493567 },
	{ 27, 57577467 },
	{ 27, 63868923 },
	{ 27, 65966075 },
	{ 27, 122589179 },
	{ 26, 33443835 },
	{ 26, 29315067 },
	{ 26, 14290687 },
	{ 26, 10096383 },
	{ 24, 5902079 },
	{ 24, 1707775 },
	{ 18, 55150 },
	{ 23, 986875 },
	{ 23, 3018491 },
	{ 25, 4919035 },
	{ 25, 6950651 },
	{ 24, 6754043 },
	{ 24, 7737083 },
	{ 25, 10686203 },
	{ 25, 11669243 },
	{ 23, 3739387 },
	{ 23, 3935995 },
	{ 23, 954107 },
	{ 23, 3051259 },
	{ 23, 3133183 },
	{ 25, 7245563 },
	{ 25, 13537019 },
	{ 25, 15634171 },
	{ 25, 15716095 },
	{ 26, 24022779 },
	{ 26, 30314235 },
	{ 26, 32411387 },
	{ 26, 32493311 },
	{ 27, 57577211 },
	{ 27, 63868667 },
	{ 27, 65965819 },
	{ 27, 122588923 },
	{ 26, 33443579 },
	{ 26, 29314811 },
	{ 26, 14355455 },
	{ 26, 10161151 },
	{ 24, 5966847 },
	{ 24, 1772543 },
	{ 18, 47086 },
	{ 24, 1707003 },
	{ 23, 3083259 },
	{ 25, 5114875 },
	{ 25, 7015419 },
	{ 25, 13241339 },
	{ 24, 7801851 },
	{ 25, 10882043 },
	{ 25, 11734011 },
	{ 25, 14814203 },
	{ 23, 4000763 },
	{ 24, 6818811 },
	{ 23, 1018875 },
	{ 23, 3116027 },
	{ 24, 5950463 },
	{ 25, 7310331 },
	{ 25, 13601787 },
	{ 25, 15698939 },
	{ 26, 21990395 },
	{ 26, 24087547 },
	{ 26, 30379003 },
	{ 26, 32476155 },
	{ 27, 55544827 },
	{ 27, 57641979 },
	{ 27, 63933435 },
	{ 27, 66030587 },
	{ 26, 33246203 },
	{ 26, 29248507 },
	{ 26, 16731131 },
	{ 26, 10160895 },
	{ 24, 5966591 },
	{ 24, 1772287 },
	{ 18, 38894 },
	{ 24, 1706747 },
	{ 23, 3083003 },
	{ 25, 5114619 },
	{ 25, 7015163 },
	{ 25, 13241083 },
	{ 24, 7801595 },
	{ 25, 10881787 },
	{ 25, 11733755 },
	{ 25, 14813947 },
	{ 23, 4000507 },
	{ 24, 6818555 },
	{ 23, 1018619 },
	{ 23, 3115771 },
	{ 24, 5950207 },
	{ 25, 7310075 },
	{ 25, 13601531 },
	{ 25, 15698683 },
	{ 26, 21990139 },
	{ 26, 24087291 },
	{ 26, 30378747 },
	{ 26, 32475899 },
	{ 25, 16222207 },
	{ 25, 15173631 },
	{ 25, 12027903 },
	{ 25, 10979327 },
	{ 24, 7833599 },
	{ 24, 6785023 },
	{ 24, 3639295 },
	{ 24, 2590719 },
	{ 22, 1542143 },
	{ 22, 493567 },
	{ 17, 60782 },
	{ 22, 444411 },
	{ 22, 1476603 },
	{ 23, 1296379 },
	{ 23, 1804283 },
	{ 23, 3327995 },
	{ 23, 3835899 },
	{ 23, 2738171 },
	{ 23, 2983931 },
	{ 23, 3721211 },
	{ 23, 3966971 },
	{ 22, 1722363 },
	{ 22, 1771515 },
	{ 22, 436219 },
	{ 22, 1484795 },
	{ 22, 1505279 },
	{ 24, 3581947 },
	{ 24, 6727675 },
	{ 24, 7776251 },
	{ 24, 7796735 },
	{ 25, 11970555 },
	{ 25, 15116283 },
	{ 25, 16164859 },
	{ 25, 15128571 },
	{ 25, 12031995 },
	{ 25, 10999803 },
	{ 24, 8296443 },
	{ 24, 7264251 },
	{ 24, 4167675 },
	{ 24, 3135483 },
	{ 22, 1541887 },
	{ 22, 493311 },
	{ 17, 44398 },
	{ 22, 444155 },
	{ 22, 1476347 },
	{ 23, 1296123 },
	{ 23, 1804027 },
	{ 23, 3327739 },
	{ 23, 3835643 },
	{ 23, 2737915 },
	{ 23, 2983675 },
	{ 23, 3720955 },
	{ 23, 3966715 },
	{ 22, 1722107 },
	{ 22, 1771259 },
	{ 22, 435963 },
	{ 22, 1484539 },
	{ 22, 1505023 },
	{ 24, 3581691 },
	{ 24, 6727419 },
	{ 24, 7775995 },
	{ 24, 7796479 },
	{ 25, 11970299 },
	{ 25, 15116027 },
	{ 25, 16164603 },
	{ 25, 15128315 },
	{ 25, 12031739 },
	{ 25, 10999547 },
	{ 24, 8296187 },
	{ 24, 7263995 },
	{ 24, 4167419 },
	{ 24, 3135227 },
	{ 22, 1557503 },
	{ 22, 508927 },
	{ 17, 28142 },
	{ 22, 492539 },
	{ 22, 1491963 },
	{ 24, 2524155 },
	{ 23, 1819643 },
	{ 23, 3376123 },
	{ 23, 3851259 },
	{ 24, 5407739 },
	{ 23, 2999291 },
	{ 23, 3769339 },
	{ 23, 3982331 },
	{ 22, 4158459 },
	{ 22, 1786875 },
	{ 22, 1967099 },
	{ 22, 451579 },
	{ 22, 1500155 },
	{ 22, 1553407 },
	{ 24, 3597307 },
	{ 24, 6743035 },
	{ 24, 7791611 },
	{ 24, 7844863 },
	{ 25, 11985915 },
	{ 24, 8115195 },
	{ 25, 16180219 },
	{ 25, 11981819 },
	{ 25, 10982395 },
	{ 24, 7853051 },
	{ 24, 7246843 },
	{ 24, 4117499 },
	{ 24, 3118075 },
	{ 22, 2085883 },
	{ 22, 508671 },
	{ 17, 11758 },
	{ 22, 492283 },
	{ 22, 1491707 },
	{ 24, 2523899 },
	{ 23, 1819387 },
	{ 23, 3375867 },
	{ 23, 3851003 },
	{ 24, 5407483 },
	{ 23, 2999035 },
	{ 23, 3769083 },
	{ 23, 3982075 },
	{ 22, 4158203 },
	{ 22, 1786619 },
	{ 22, 1966843 },
	{ 22, 451323 },
	{ 22, 1499899 },
	{ 22, 1553151 },
	{ 24, 3597051 },
	{ 24, 6742779 },
	{ 24, 7791355 },
	{ 24, 7844607 },
	{ 24, 7053823 },
	{ 23, 4170239 },
	{ 23, 3908095 },
	{ 23, 3121663 },
	{ 23, 2859519 },
	{ 22, 2073087 },
	{ 22, 1810943 },
	{ 22, 1024511 },
	{ 22, 762367 },
	{ 20, 500223 },
	{ 20, 238079 },
	{ 15, 20334 },
	{ 20, 127483 },
	{ 20, 385531 },
	{ 22, 635387 },
	{ 22, 893435 },
	{ 21, 848379 },
	{ 21, 975355 },
	{ 22, 1356283 },
	{ 22, 1483259 },
	{ 21, 946683 },
	{ 21, 1008123 },
	{ 20, 1038847 },
	{ 20, 1023483 },
	{ 20, 496123 },
	{ 20, 508411 },
	{ 20, 125435 },
	{ 20, 387579 },
	{ 20, 392703 },
	{ 22, 911867 },
	{ 22, 1698299 },
	{ 22, 1960443 },
	{ 22, 1965567 },
	{ 22, 2024955 },
	{ 22, 1897979 },
	{ 23, 3122429 },
	{ 23, 2860285 },
	{ 22, 2073853 },
	{ 22, 1811709 },
	{ 22, 1025277 },
	{ 22, 763133 },
	{ 20, 500989 },
	{ 20, 238845 },
	{ 15, 3866 },
	{ 20, 128249 },
	{ 20, 386297 },
	{ 22, 636153 },
	{ 22, 894201 },
	{ 21, 849145 },
	{ 21, 976121 },
	{ 22, 1357049 },
	{ 22, 2091257 },
	{ 21, 947449 },
	{ 21, 1008889 },
	{ 20, 523517 },
	{ 20, 518393 },
	{ 20, 256249 },
	{ 20, 1032441 },
	{ 20, 1020153 },
	{ 20, 498937 },
	{ 20, 514301 },
	{ 22, 2056441 },
	{ 22, 1995001 },
	{ 22, 1998073 },
	{ 22, 2062589 },
	{ 22, 2023673 },
	{ 22, 1896697 },
	{ 23, 2990329 },
	{ 23, 2732281 },
	{ 22, 1958137 },
	{ 22, 1700089 },
	{ 22, 1024249 },
	{ 22, 766201 },
	{ 20, 516345 },
	{ 20, 258297 },
	{ 15, 8042 },
	{ 20, 128505 },
	{ 20, 386553 },
	{ 22, 636409 },
	{ 22, 894457 },
	{ 21, 849401 },
	{ 21, 976377 },
	{ 22, 1357305 },
	{ 22, 2091513 },
	{ 21, 947705 },
	{ 21, 1009145 },
	{ 20, 523773 },
	{ 20, 518649 },
	{ 20, 256505 },
	{ 20, 1032697 },
	{ 20, 1020409 },
	{ 20, 499193 },
	{ 20, 514557 },
	{ 22, 2056697 },
	{ 22, 1995257 },
	{ 22, 1998329 },
	{ 22, 2062845 },
	{ 22, 2023929 },
	{ 22, 1896953 },
	{ 23, 2990585 },
	{ 23, 2732537 },
	{ 22, 1958393 },
	{ 22, 1700345 },
	{ 22, 1024505 },
	{ 22, 766457 },
	{ 20, 516601 },
	{ 20, 258553 },
	{ 15, 24426 },
	{ 22, 955129 },
	{ 22, 1561337 },
	{ 24, 2593529 },
	{ 24, 3592953 },
	{ 24, 6722297 },
	{ 23, 3920633 },
	{ 24, 5477113 },
	{ 24, 5952249 },
	{ 24, 8315641 },
	{ 23, 4051705 },
	{ 24, 4121337 },
	{ 22, 2077437 },
	{ 22, 2024185 },
	{ 22, 975609 },
	{ 22, 4063993 },
	{ 22, 3883769 },
	{ 22, 2061049 },
	{ 22, 3826429 },
	{ 24, 7963385 },
	{ 24, 7193337 },
	{ 24, 8254201 },
	{ 24, 8045305 },
	{ 24, 7570169 },
	{ 24, 6013689 },
	{ 25, 10912505 },
	{ 24, 7783161 },
	{ 24, 6783737 },
	{ 24, 3654393 },
	{ 24, 3048185 },
	{ 22, 2015993 },
	{ 22, 1016569 },
	{ 17, 15850 },
	{ 22, 955385 },
	{ 22, 1561593 },
	{ 24, 2593785 },
	{ 24, 3593209 },
	{ 24, 6722553 },
	{ 23, 3920889 },
	{ 24, 5477369 },
	{ 24, 5952505 },
	{ 24, 8315897 },
	{ 23, 4051961 },
	{ 24, 4121593 },
	{ 22, 2077693 },
	{ 22, 2024441 },
	{ 22, 975865 },
	{ 22, 4064249 },
	{ 22, 3884025 },
	{ 22, 2061305 },
	{ 22, 3826685 },
	{ 24, 7963641 },
	{ 24, 7193593 },
	{ 24, 8254457 },
	{ 24, 8045561 },
	{ 24, 7570425 },
	{ 24, 6013945 },
	{ 25, 10912761 },
	{ 24, 7783417 },
	{ 24, 6783993 },
	{ 24, 3654649 },
	{ 24, 3048441 },
	{ 22, 2016249 },
	{ 22, 1016825 },
	{ 17, 32234 },
	{ 22, 972537 },
	{ 22, 2004729 },
	{ 24, 2610937 },
	{ 24, 3643129 },
	{ 24, 6739705 },
	{ 24, 7771897 },
	{ 24, 5494521 },
	{ 24, 6002425 },
	{ 24, 7526137 },
	{ 24, 8300281 },
	{ 24, 7251705 },
	{ 24, 4105977 },
	{ 22, 2029309 },
	{ 22, 2008825 },
	{ 22, 960249 },
	{ 22, 3868409 },
	{ 22, 3819257 },
	{ 22, 3831545 },
	{ 22, 3892989 },
	{ 24, 7177977 },
	{ 24, 6932217 },
	{ 24, 8029945 },
	{ 24, 7522041 },
	{ 24, 5998329 },
	{ 24, 5490425 },
	{ 24, 7767801 },
	{ 24, 6735609 },
	{ 24, 3639033 },
	{ 24, 2606841 },
	{ 22, 2000633 },
	{ 22, 968441 },
	{ 17, 48490 },
	{ 22, 972793 },
	{ 22, 2004985 },
	{ 24, 2611193 },
	{ 24, 3643385 },
	{ 24, 6739961 },
	{ 24, 7772153 },
	{ 24, 5494777 },
	{ 24, 6002681 },
	{ 24, 7526393 },
	{ 24, 8300537 },
	{ 24, 7251961 },
	{ 24, 4106233 },
	{ 22, 2029565 },
	{ 22, 2009081 },
	{ 22, 960505 },
	{ 22, 3868665 },
	{ 22, 3819513 },
	{ 22, 3831801 },
	{ 22, 3893245 },
	{ 24, 7178233 },
	{ 24, 6932473 },
	{ 24, 8030201 },
	{ 24, 7522297 },
	{ 24, 5998585 },
	{ 24, 5490681 },
	{ 24, 7768057 },
	{ 24, 6735865 },
	{ 24, 3639289 },
	{ 24, 2607097 },
	{ 22, 2000889 },
	{ 22, 968697 },
	{ 17, 64874 },
	{ 22, 1017853 },
	{ 22, 2066429 },
	{ 24, 3115005 },
	{ 24, 4163581 },
	{ 24, 7309309 },
	{ 24, 8357885 },
	{ 25, 11503613 },
	{ 25, 12552189 },
	{ 25, 15697917 },
	{ 25, 16746493 },
	{ 26, 31427321 },
	{ 26, 27233017 },
	{ 26, 14650105 },
	{ 24, 8047357 },
	{ 24, 6261497 },
	{ 24, 2067193 },
	{ 24, 15207161 },
	{ 24, 8194809 },
	{ 24, 15583993 },
	{ 24, 16354045 },
	{ 26, 27659001 },
	{ 25, 16190201 },
	{ 26, 30018297 },
	{ 26, 23792377 },
	{ 26, 21891833 },
	{ 25, 15665913 },
	{ 26, 26872569 },
	{ 26, 14355193 },
	{ 26, 10357497 },
	{ 24, 6228729 },
	{ 24, 3803897 },
	{ 19, 77802 },
	{ 24, 4082681 },
	{ 24, 8080377 },
	{ 26, 12209145 },
	{ 26, 14633977 },
	{ 26, 27151353 },
	{ 26, 31149049 },
	{ 27, 64982009 },
	{ 26, 24071161 },
	{ 26, 30297081 },
	{ 26, 32197625 },
	{ 26, 31427577 },
	{ 26, 27233273 },
	{ 26, 14650361 },
	{ 24, 8047613 },
	{ 24, 6261753 },
	{ 24, 2067449 },
	{ 24, 15207417 },
	{ 24, 8195065 },
	{ 24, 15584249 },
	{ 24, 16354301 },
	{ 26, 27659257 },
	{ 25, 16190457 },
	{ 26, 30018553 },
	{ 26, 23792633 },
	{ 26, 21892089 },
	{ 25, 15666169 },
	{ 26, 26872825 },
	{ 26, 14355449 },
	{ 26, 10357753 },
	{ 24, 6228985 },
	{ 24, 3804153 },
	{ 19, 94186 },
	{ 24, 4148985 },
	{ 24, 8277753 },
	{ 26, 12275449 },
	{ 26, 16404217 },
	{ 26, 27217657 },
	{ 26, 31346425 },
	{ 27, 43732729 },
	{ 27, 64917241 },
	{ 26, 30363385 },
	{ 26, 32395001 },
	{ 26, 31444733 },
	{ 26, 31362809 },
	{ 26, 27168505 },
	{ 26, 14585593 },
	{ 24, 6278909 },
	{ 24, 6196985 },
	{ 24, 2002681 },
	{ 24, 8130297 },
	{ 24, 7933689 },
	{ 24, 16371449 },
	{ 24, 16617213 },
	{ 25, 16125689 },
	{ 25, 15142649 },
	{ 26, 23727865 },
	{ 26, 21696249 },
	{ 25, 15601401 },
	{ 25, 13569785 },
	{ 26, 14290681 },
	{ 26, 10161913 },
	{ 24, 6164217 },
	{ 24, 2035449 },
	{ 19, 110442 },
	{ 24, 4149241 },
	{ 24, 8278009 },
	{ 26, 12275705 },
	{ 26, 16404473 },
	{ 26, 27217913 },
	{ 26, 31346681 },
	{ 27, 43732985 },
	{ 27, 64917497 },
	{ 26, 30363641 },
	{ 26, 32395257 },
	{ 26, 31444989 },
	{ 26, 31363065 },
	{ 26, 27168761 },
	{ 26, 14585849 },
	{ 24, 6279165 },
	{ 24, 6197241 },
	{ 24, 2002937 },
	{ 24, 8130553 },
	{ 24, 7933945 },
	{ 24, 16371705 },
	{ 24, 16617469 },
	{ 25, 16125945 },
	{ 25, 15142905 },
	{ 26, 23728121 },
	{ 26, 21696505 },
	{ 25, 15601657 },
	{ 25, 13570041 },
	{ 26, 14290937 },
	{ 26, 10162169 },
	{ 24, 6164473 },
	{ 24, 2035705 },
	{ 19, 126826 },
	{ 24, 3805181 },
	{ 24, 8346361 },
	{ 26, 12475129 },
	{ 26, 16472825 },
	{ 26, 28990201 },
	{ 26, 31415033 },
	{ 27, 43932409 },
	{ 27, 47930105 },
	{ 27, 64723705 },
	{ 26, 32463609 },
	{ 27, 47946489 },
	{ 26, 31382269 },
	{ 26, 31169273 },
	{ 26, 26974969 },
	{ 26, 14392057 },
	{ 24, 6216445 },
	{ 24, 6003449 },
	{ 24, 1809145 },
	{ 24, 7871225 },
	{ 24, 7150329 },
	{ 24, 16636665 },
	{ 25, 15932153 },
	{ 25, 15080185 },
	{ 25, 11999993 },
	{ 26, 21633785 },
	{ 25, 15407865 },
	{ 25, 13507321 },
	{ 25, 7281401 },
	{ 26, 10099449 },
	{ 24, 5970681 },
	{ 24, 1972985 },
	{ 19, 208362 },
	{ 24, 2038525 },
	{ 24, 8346617 },
	{ 26, 12475385 },
	{ 26, 16473081 },
	{ 26, 28990457 },
	{ 26, 31415289 },
	{ 27, 43932665 },
	{ 27, 47930361 },
	{ 27, 64723961 },
	{ 26, 32463865 },
	{ 27, 47946745 },
	{ 26, 31382525 },
	{ 26, 31169529 },
	{ 26, 26975225 },
	{ 26, 14392313 },
	{ 24, 6216701 },
	{ 24, 6003705 },
	{ 24, 1809401 },
	{ 24, 7871481 },
	{ 24, 7150585 },
	{ 24, 16636921 },
	{ 25, 15932409 },
	{ 25, 15080441 },
	{ 25, 12000249 },
	{ 26, 21634041 },
	{ 25, 15408121 },
	{ 25, 13507577 },
	{ 25, 7281657 },
	{ 26, 10099705 },
	{ 24, 5970937 },
	{ 24, 1973241 },
	{ 19, 224746 },
	{ 24, 2038781 },
	{ 24, 6233085 },
	{ 26, 12541689 },
	{ 26, 16670457 },
	{ 26, 29056761 },
	{ 26, 33185529 },
	{ 27, 43998969 },
	{ 27, 48127737 },
	{ 27, 60514041 },
	{ 27, 64659193 },
	{ 27, 60464889 },
	{ 27, 47881977 },
	{ 26, 31186685 },
	{ 26, 31104761 },
	{ 26, 26910457 },
	{ 26, 14327545 },
	{ 24, 6020861 },
	{ 24, 5938937 },
	{ 24, 1744633 },
	{ 24, 7085817 },
	{ 24, 6889209 },
	{ 25, 15867641 },
	{ 25, 14884601 },
	{ 25, 11935481 },
	{ 25, 10952441 },
	{ 25, 15343353 },
	{ 25, 13311737 },
	{ 25, 7216889 },
	{ 25, 5185273 },
	{ 24, 5906169 },
	{ 24, 1777401 },
	{ 19, 241002 },
	{ 24, 1974013 },
	{ 24, 6168317 },
	{ 26, 12541945 },
	{ 26, 16670713 },
	{ 26, 29057017 },
	{ 26, 33185785 },
	{ 27, 43999225 },
	{ 27, 48127993 },
	{ 27, 60514297 },
	{ 27, 64659449 },
	{ 27, 60465145 },
	{ 27, 47882233 },
	{ 26, 31186941 },
	{ 26, 31105017 },
	{ 26, 26910713 },
	{ 26, 14327801 },
	{ 24, 6021117 },
	{ 24, 5939193 },
	{ 24, 1744889 },
	{ 24, 7086073 },
	{ 24, 6889465 },
	{ 25, 15867897 },
	{ 25, 14884857 },
	{ 25, 11935737 },
	{ 25, 10952697 },
	{ 25, 15343609 },
	{ 25, 13311993 },
	{ 25, 7217145 },
	{ 25, 5185529 },
	{ 24, 5906425 },
	{ 24, 1777657 },
	{ 19, 257386 },
	{ 24, 1974269 },
	{ 24, 6168573 },
	{ 26, 10362877 },
	{ 26, 14557181 },
	{ 26, 27140093 },
	{ 26, 31334397 },
	{ 27, 43917309 },
	{ 27, 48111613 },
	{ 27, 60694525 },
	{ 27, 64888829 },
	{ 28, 129903353 },
	{ 28, 121514745 },
	{ 28, 96348921 },
	{ 28, 87960313 },
	{ 27, 62794489 },
	{ 27, 54405881 },
	{ 27, 29240057 },
	{ 26, 23800573 },
	{ 25, 12462841 },
	{ 25, 4074233 },
	{ 26, 27273977 },
	{ 25, 16001785 },
	{ 27, 59255545 },
	{ 27, 46934777 },
	{ 27, 43526905 },
	{ 26, 31206137 },
	{ 27, 52964089 },
	{ 27, 28060409 },
	{ 27, 20458233 },
	{ 25, 12331769 },
	{ 26, 6826745 },
	{ 19, 169962 },
	{ 26, 7088893 },
	{ 26, 23866109 },
	{ 28, 40643325 },
	{ 28, 66923513 },
	{ 28, 116993017 },
	{ 28, 132983801 },
	{ 29, 264121337 },
	{ 29, 255732729 },
	{ 29, 230566905 },
	{ 29, 222178297 },
	{ 28, 129903609 },
	{ 28, 121515001 },
	{ 28, 96349177 },
	{ 28, 87960569 },
	{ 27, 62794745 },
	{ 27, 54406137 },
	{ 27, 29240313 },
	{ 26, 23800829 },
	{ 25, 12463097 },
	{ 25, 4074489 },
	{ 26, 27274233 },
	{ 25, 16002041 },
	{ 27, 59255801 },
	{ 27, 46935033 },
	{ 27, 43527161 },
	{ 26, 31206393 },
	{ 27, 52964345 },
	{ 27, 28060665 },
	{ 27, 20458489 },
	{ 25, 12332025 },
	{ 26, 6827001 },
	{ 19, 178154 },
	{ 26, 7089149 },
	{ 26, 23866365 },
	{ 28, 40643581 },
	{ 28, 57420797 },
	{ 28, 117255929 },
	{ 28, 133771001 },
	{ 29, 490352377 },
	{ 29, 263859961 },
	{ 29, 255471353 },
	{ 29, 230305529 },
	{ 28, 129969917 },
	{ 28, 129642233 },
	{ 28, 121253625 },
	{ 28, 96087801 },
	{ 27, 62861053 },
	{ 27, 62533369 },
	{ 27, 54144761 },
	{ 27, 28978937 },
	{ 25, 12529405 },
	{ 25, 12201721 },
	{ 25, 3813113 },
	{ 25, 15740665 },
	{ 25, 14954233 },
	{ 27, 46673657 },
	{ 27, 42741497 },
	{ 26, 30945017 },
	{ 26, 27012857 },
	{ 27, 27799289 },
	{ 27, 19672825 },
	{ 25, 12070649 },
	{ 25, 3944185 },
	{ 19, 186218 },
	{ 26, 6827773 },
	{ 26, 23604989 },
	{ 28, 40382205 },
	{ 28, 57159421 },
	{ 28, 117256185 },
	{ 28, 133771257 },
	{ 29, 490352633 },
	{ 29, 263860217 },
	{ 29, 255471609 },
	{ 29, 230305785 },
	{ 28, 129970173 },
	{ 28, 129642489 },
	{ 28, 121253881 },
	{ 28, 96088057 },
	{ 27, 62861309 },
	{ 27, 62533625 },
	{ 27, 54145017 },
	{ 27, 28979193 },
	{ 25, 12529661 },
	{ 25, 12201977 },
	{ 25, 3813369 },
	{ 25, 15740921 },
	{ 25, 14954489 },
	{ 27, 46673913 },
	{ 27, 42741753 },
	{ 26, 30945273 },
	{ 26, 27013113 },
	{ 27, 27799545 },
	{ 27, 19673081 },
	{ 25, 12070905 },
	{ 25, 3944441 },
	{ 19, 194410 },
	{ 26, 6828029 },
	{ 26, 23605245 },
	{ 28, 40382461 },
	{ 28, 57159677 },
	{ 28, 107491325 },
	{ 28, 134036217 },
	{ 29, 497957625 },
	{ 29, 489569017 },
	{ 29, 263076601 },
	{ 29, 254687993 },
	{ 29, 229522169 },
	{ 28, 129710845 },
	{ 28, 128858873 },
	{ 28, 120470265 },
	{ 28, 95304441 },
	{ 27, 62601981 },
	{ 27, 61750009 },
	{ 27, 53361401 },
	{ 27, 28195577 },
	{ 25, 12270333 },
	{ 25, 11418361 },
	{ 25, 3029753 },
	{ 25, 14695161 },
	{ 25, 11811577 },
	{ 26, 23789563 },
	{ 26, 30161657 },
	{ 26, 26753785 },
	{ 26, 14433017 },
	{ 27, 19413753 },
	{ 25, 11287289 },
	{ 25, 3685113 },
	{ 19, 234986 },
	{ 25, 3947261 },
	{ 25, 12335869 },
	{ 26, 24838143 },
	{ 27, 29113085 },
	{ 27, 54278909 },
	{ 27, 62667517 },
	{ 28, 87833341 },
	{ 28, 96221949 },
	{ 28, 121387773 },
	{ 28, 129776381 },
	{ 29, 229522425 },
	{ 28, 129711101 },
	{ 28, 128859129 },
	{ 28, 120470521 },
	{ 28, 95304697 },
	{ 27, 62602237 },
	{ 27, 61750265 },
	{ 27, 53361657 },
	{ 27, 28195833 },
	{ 25, 12270589 },
	{ 25, 11418617 },
	{ 25, 3030009 },
	{ 25, 14695417 },
	{ 25, 11811833 },
	{ 26, 23789307 },
	{ 26, 30161913 },
	{ 26, 26754041 },
	{ 26, 14433273 },
	{ 27, 19414009 },
	{ 25, 11287545 },
	{ 25, 3685369 },
	{ 19, 243178 },
	{ 25, 3947517 },
	{ 25, 12336125 },
	{ 26, 24837887 },
	{ 27, 29113341 },
	{ 27, 54279165 },
	{ 27, 62667773 },
	{ 28, 87833597 },
	{ 28, 96222205 },
	{ 28, 121388029 },
	{ 28, 129776637 },
	{ 29, 254426873 },
	{ 29, 229261049 },
	{ 28, 128925437 },
	{ 28, 128597753 },
	{ 28, 120209145 },
	{ 28, 95043321 },
	{ 27, 61816573 },
	{ 27, 61488889 },
	{ 27, 53100281 },
	{ 27, 27934457 },
	{ 25, 11484925 },
	{ 25, 11157241 },
	{ 25, 2768633 },
	{ 25, 11550457 },
	{ 25, 10764025 },
	{ 26, 29900537 },
	{ 26, 25968377 },
	{ 26, 14171897 },
	{ 26, 10239737 },
	{ 25, 11026169 },
	{ 25, 2899705 },
	{ 19, 251242 },
	{ 25, 3686141 },
	{ 25, 12074749 },
	{ 26, 24312831 },
	{ 27, 28851965 },
	{ 27, 54017789 },
	{ 27, 62406397 },
	{ 28, 87572221 },
	{ 28, 95960829 },
	{ 28, 121126653 },
	{ 28, 129515261 },
	{ 29, 254427129 },
	{ 29, 229261305 },
	{ 28, 128925693 },
	{ 28, 128598009 },
	{ 28, 120209401 },
	{ 28, 95043577 },
	{ 27, 61816829 },
	{ 27, 61489145 },
	{ 27, 53100537 },
	{ 27, 27934713 },
	{ 25, 11485181 },
	{ 25, 11157497 },
	{ 25, 2768889 },
	{ 25, 11550713 },
	{ 25, 10764281 },
	{ 26, 29900793 },
	{ 26, 25968633 },
	{ 26, 14172153 },
	{ 26, 10239993 },
	{ 25, 11026425 },
	{ 25, 2899961 },
	{ 19, 259434 },
	{ 25, 3686397 },
	{ 25, 12075005 },
	{ 26, 24312575 },
	{ 27, 28852221 },
	{ 27, 54018045 },
	{ 27, 62406653 },
	{ 28, 266234617 },
	{ 28, 262040313 },
	{ 28, 249457401 },
	{ 28, 245263097 },
	{ 28, 132016889 },
	{ 28, 127822585 },
	{ 28, 115239673 },
	{ 28, 111045369 },
	{ 27, 64908025 },
	{ 27, 60713721 },
	{ 27, 48130809 },
	{ 27, 43936505 },
	{ 26, 31353593 },
	{ 26, 27159289 },
	{ 26, 14576377 },
	{ 25, 11234045 },
	{ 24, 6187769 },
	{ 24, 1993465 },
	{ 25, 10513145 },
	{ 24, 7629561 },
	{ 25, 15396859 },
	{ 26, 13396729 },
	{ 26, 9988857 },
	{ 24, 6056697 },
	{ 25, 2648825 },
	{ 19, 216042 },
	{ 25, 2910973 },
	{ 25, 11299581 },
	{ 26, 22736895 },
	{ 27, 28076797 },
	{ 27, 53242621 },
	{ 27, 61631229 },
	{ 28, 266234873 },
	{ 28, 262040569 },
	{ 28, 249457657 },
	{ 28, 245263353 },
	{ 28, 132017145 },
	{ 28, 127822841 },
	{ 28, 115239929 },
	{ 28, 111045625 },
	{ 27, 64908281 },
	{ 27, 60713977 },
	{ 27, 48131065 },
	{ 27, 43936761 },
	{ 26, 31353849 },
	{ 26, 27159545 },
	{ 26, 14576633 },
	{ 25, 11234301 },
	{ 24, 6188025 },
	{ 24, 1993721 },
	{ 25, 10513401 },
	{ 24, 7629817 },
	{ 25, 15396603 },
	{ 26, 13396985 },
	{ 26, 9989113 },
	{ 24, 6056953 },
	{ 25, 2649081 },
	{ 19, 220138 },
	{ 25, 2911229 },
	{ 25, 11299837 },
	{ 26, 22736639 },
	{ 27, 28077053 },
	{ 27, 53242877 },
	{ 27, 61631485 },
	{ 28, 266301181 },
	{ 28, 265973497 },
	{ 28, 261779193 },
	{ 28, 249196281 },
	{ 28, 245001977 },
	{ 28, 131755769 },
	{ 28, 127561465 },
	{ 28, 114978553 },
	{ 27, 64974589 },
	{ 27, 64646905 },
	{ 27, 60452601 },
	{ 27, 47869689 },
	{ 26, 31420157 },
	{ 26, 31092473 },
	{ 26, 26898169 },
	{ 26, 14315257 },
	{ 24, 6254333 },
	{ 24, 5926649 },
	{ 24, 1732345 },
	{ 24, 7368441 },
	{ 24, 6582009 },
	{ 25, 13298683 },
	{ 26, 9203449 },
	{ 24, 5795577 },
	{ 24, 1863417 },
	{ 19, 224106 },
	{ 25, 2649853 },
	{ 25, 11038461 },
	{ 26, 22211583 },
	{ 27, 27815677 },
	{ 27, 52981501 },
	{ 27, 61370109 },
	{ 28, 86535933 },
	{ 28, 265973753 },
	{ 28, 261779449 },
	{ 28, 249196537 },
	{ 28, 245002233 },
	{ 28, 131756025 },
	{ 28, 127561721 },
	{ 28, 114978809 },
	{ 27, 64974845 },
	{ 27, 64647161 },
	{ 27, 60452857 },
	{ 27, 47869945 },
	{ 26, 31420413 },
	{ 26, 31092729 },
	{ 26, 26898425 },
	{ 26, 14315513 },
	{ 24, 6254589 },
	{ 24, 5926905 },
	{ 24, 1732601 },
	{ 24, 7368697 },
	{ 24, 6582265 },
	{ 25, 13298427 },
	{ 26, 9203705 },
	{ 24, 5795833 },
	{ 24, 1863673 },
	{ 19, 228202 },
	{ 25, 2650109 },
	{ 25, 11038717 },
	{ 26, 22211327 },
	{ 27, 27815933 },
	{ 27, 52981757 },
	{ 27, 61370365 },
	{ 28, 86536189 },
	{ 28, 266042109 },
	{ 28, 265190137 },
	{ 28, 260995833 },
	{ 28, 248412921 },
	{ 28, 244218617 },
	{ 28, 130972409 },
	{ 28, 126778105 },
	{ 28, 114195193 },
	{ 27, 64715517 },
	{ 27, 63863545 },
	{ 27, 59669241 },
	{ 27, 47086329 },
	{ 26, 31161085 },
	{ 26, 30309113 },
	{ 26, 26114809 },
	{ 26, 13531897 },
	{ 24, 5995261 },
	{ 24, 5143289 },
	{ 24, 948985 },
	{ 24, 6322937 },
	{ 24, 3439353 },
	{ 25, 6995963 },
	{ 24, 5012217 },
	{ 24, 1604345 },
	{ 19, 248298 },
	{ 19, 522654 },
	{ 24, 6060797 },
	{ 25, 12238847 },
	{ 26, 14449405 },
	{ 26, 27032317 },
	{ 26, 31226621 },
	{ 27, 43809533 },
	{ 27, 48003837 },
	{ 27, 60586749 },
	{ 27, 64781053 },
	{ 28, 248413177 },
	{ 28, 244218873 },
	{ 28, 130972665 },
	{ 28, 126778361 },
	{ 28, 114195449 },
	{ 27, 64715773 },
	{ 27, 63863801 },
	{ 27, 59669497 },
	{ 27, 47086585 },
	{ 26, 31161341 },
	{ 26, 30309369 },
	{ 26, 26115065 },
	{ 26, 13532153 },
	{ 24, 5995517 },
	{ 24, 5143545 },
	{ 24, 949241 },
	{ 24, 6323193 },
	{ 24, 3439609 },
	{ 25, 6995707 },
	{ 24, 5012473 },
	{ 24, 1604601 },
	{ 19, 252394 },
	{ 19, 518558 },
	{ 24, 6061053 },
	{ 25, 12238591 },
	{ 26, 14449661 },
	{ 26, 27032573 },
	{ 26, 31226877 },
	{ 27, 43809789 },
	{ 27, 48004093 },
	{ 27, 60587005 },
	{ 27, 64781309 },
	{ 28, 260734713 },
	{ 28, 248151801 },
	{ 28, 243957497 },
	{ 28, 130711289 },
	{ 28, 126516985 },
	{ 28, 113934073 },
	{ 27, 63930109 },
	{ 27, 63602425 },
	{ 27, 59408121 },
	{ 27, 46825209 },
	{ 26, 30375677 },
	{ 26, 30047993 },
	{ 26, 25853689 },
	{ 26, 13270777 },
	{ 24, 5209853 },
	{ 24, 4882169 },
	{ 24, 687865 },
	{ 24, 3178233 },
	{ 24, 2391801 },
	{ 24, 4751097 },
	{ 24, 818937 },
	{ 19, 256362 },
	{ 19, 514334 },
	{ 24, 5799677 },
	{ 25, 11713535 },
	{ 26, 14188285 },
	{ 26, 26771197 },
	{ 26, 30965501 },
	{ 27, 43548413 },
	{ 27, 47742717 },
	{ 27, 60325629 },
	{ 27, 64519933 },
	{ 28, 260734969 },
	{ 28, 248152057 },
	{ 28, 243957753 },
	{ 28, 130711545 },
	{ 28, 126517241 },
	{ 28, 113934329 },
	{ 27, 63930365 },
	{ 27, 63602681 },
	{ 27, 59408377 },
	{ 27, 46825465 },
	{ 26, 30375933 },
	{ 26, 30048249 },
	{ 26, 25853945 },
	{ 26, 13271033 },
	{ 24, 5210109 },
	{ 24, 4882425 },
	{ 24, 688121 },
	{ 24, 3178489 },
	{ 24, 2392057 },
	{ 24, 4751353 },
	{ 24, 819193 },
	{ 19, 260458 },
	{ 19, 510238 },
	{ 24, 5799933 },
	{ 25, 11713279 },
	{ 26, 14188541 },
	{ 26, 26771453 },
	{ 26, 30965757 },
	{ 27, 43548669 },
	{ 27, 47742973 },
	{ 27, 60325885 },
	{ 27, 64520189 },
	{ 27, 132950777 },
	{ 27, 130853625 },
	{ 27, 124562169 },
	{ 27, 122465017 },
	{ 27, 65841913 },
	{ 27, 63744761 },
	{ 27, 57453305 },
	{ 27, 55356153 },
	{ 26, 32287481 },
	{ 26, 30190329 },
	{ 26, 23898873 },
	{ 26, 21801721 },
	{ 25, 15510265 },
	{ 25, 13413113 },
	{ 25, 7121657 },
	{ 25, 5024505 },
	{ 23, 2927353 },
	{ 23, 830201 },
	{ 23, 2535419 },
	{ 23, 2665209 },
	{ 23, 2797563 },
	{ 17, 119530 },
	{ 17, 122526 },
	{ 25, 10005245 },
	{ 25, 10137599 },
	{ 27, 26782461 },
	{ 27, 51948285 },
	{ 27, 60336893 },
	{ 27, 60469247 },
	{ 28, 93891325 },
	{ 28, 119057149 },
	{ 28, 127445757 },
	{ 27, 132951033 },
	{ 27, 130853881 },
	{ 27, 124562425 },
	{ 27, 122465273 },
	{ 27, 65842169 },
	{ 27, 63745017 },
	{ 27, 57453561 },
	{ 27, 55356409 },
	{ 26, 32287737 },
	{ 26, 30190585 },
	{ 26, 23899129 },
	{ 26, 21801977 },
	{ 25, 15510521 },
	{ 25, 13413369 },
	{ 25, 7121913 },
	{ 25, 5024761 },
	{ 23, 2927609 },
	{ 23, 830457 },
	{ 23, 2535163 },
	{ 23, 2665465 },
	{ 23, 2797307 },
	{ 17, 120554 },
	{ 17, 121502 },
	{ 25, 10005501 },
	{ 25, 10137343 },
	{ 27, 26782717 },
	{ 27, 51948541 },
	{ 27, 60337149 },
	{ 27, 60468991 },
	{ 28, 93891581 },
	{ 28, 119057405 },
	{ 28, 127446013 },
	{ 27, 133082877 },
	{ 27, 132427513 },
	{ 27, 130330361 },
	{ 27, 124038905 },
	{ 27, 121941753 },
	{ 27, 65318649 },
	{ 27, 63221497 },
	{ 27, 56930041 },
	{ 26, 32419581 },
	{ 26, 31764217 },
	{ 26, 29667065 },
	{ 26, 23375609 },
	{ 25, 15642365 },
	{ 25, 14987001 },
	{ 25, 12889849 },
	{ 25, 6598393 },
	{ 23, 3059453 },
	{ 23, 2404089 },
	{ 23, 306937 },
	{ 18, 243065 },
	{ 18, 241531 },
	{ 17, 121450 },
	{ 17, 120350 },
	{ 25, 9481981 },
	{ 25, 9612287 },
	{ 27, 26259197 },
	{ 27, 51425021 },
	{ 27, 59813629 },
	{ 27, 59943935 },
	{ 28, 93368061 },
	{ 28, 118533885 },
	{ 28, 126922493 },
	{ 27, 133083133 },
	{ 27, 132427769 },
	{ 27, 130330617 },
	{ 27, 124039161 },
	{ 27, 121942009 },
	{ 27, 65318905 },
	{ 27, 63221753 },
	{ 27, 56930297 },
	{ 26, 32419837 },
	{ 26, 31764473 },
	{ 26, 29667321 },
	{ 26, 23375865 },
	{ 25, 15642621 },
	{ 25, 14987257 },
	{ 25, 12890105 },
	{ 25, 6598649 },
	{ 23, 3059709 },
	{ 23, 2404345 },
	{ 23, 307193 },
	{ 18, 245113 },
	{ 18, 239483 },
	{ 17, 122474 },
	{ 17, 119326 },
	{ 25, 9482237 },
	{ 25, 9612031 },
	{ 27, 26259453 },
	{ 27, 51425277 },
	{ 27, 59813885 },
	{ 27, 59943679 },
	{ 28, 93368317 },
	{ 28, 118534141 },
	{ 28, 126922749 },
	{ 28, 127052543 },
	{ 27, 132561661 },
	{ 26, 16678911 },
	{ 26, 16416767 },
	{ 26, 15630335 },
	{ 26, 15368191 },
	{ 26, 8290303 },
	{ 26, 8028159 },
	{ 26, 7241727 },
	{ 26, 31898365 },
	{ 25, 4095999 },
	{ 25, 3833855 },
	{ 25, 3047423 },
	{ 25, 15121149 },
	{ 24, 1998847 },
	{ 24, 1736703 },
	{ 24, 950271 },
	{ 23, 2538237 },
	{ 22, 425983 },
	{ 22, 163839 },
	{ 23, 8388521 },
	{ 22, 98299 },
	{ 23, 4194110 },
	{ 22, 360447 },
	{ 22, 1409023 },
	{ 24, 2457599 },
	{ 24, 3506175 },
	{ 24, 6651903 },
	{ 24, 7700479 },
	{ 25, 10846207 },
	{ 25, 11894783 },
	{ 25, 15040511 },
	{ 25, 16089087 },
	{ 26, 27623423 },
	{ 26, 16678655 },
	{ 26, 16416511 },
	{ 26, 15630079 },
	{ 26, 15367935 },
	{ 26, 8290047 },
	{ 26, 8027903 },
	{ 26, 7241471 },
	{ 26, 31898621 },
	{ 25, 4095743 },
	{ 25, 3833599 },
	{ 25, 3047167 },
	{ 25, 15121405 },
	{ 24, 1998591 },
	{ 24, 1736447 },
	{ 24, 950015 },
	{ 23, 2538493 },
	{ 22, 425727 },
	{ 22, 163583 },
	{ 22, 4194249 },
	{ 20, 524251 },
	{ 14, 7118 },
	{ 22, 360191 },
	{ 22, 1408767 },
	{ 24, 2457343 },
	{ 24, 3505919 },
	{ 24, 6651647 },
	{ 24, 7700223 },
	{ 25, 10845951 },
	{ 25, 11894527 },
	{ 25, 15040255 },
	{ 25, 16088831 },
	{ 26, 27623167 },
	{ 26, 28671743 },
	{ 26, 31817471 },
	{ 26, 32866047 },
	{ 26, 61177599 },
	{ 26, 62226175 },
	{ 26, 65371903 },
	{ 26, 66420479 },
	{ 26, 31489023 },
	{ 26, 28343295 },
	{ 26, 31637245 },
	{ 25, 15760383 },
	{ 25, 14711807 },
	{ 25, 11566079 },
	{ 25, 14860029 },
	{ 24, 7371775 },
	{ 24, 6323199 },
	{ 24, 3177471 },
	{ 18, 259965 },
	{ 18, 126335 },
	{ 19, 262095 },
	{ 14, 7054 },
	{ 18, 259453 },
	{ 18, 126847 },
	{ 24, 2194431 },
	{ 24, 3243007 },
	{ 24, 6388735 },
	{ 24, 7437311 },
	{ 25, 10583039 },
	{ 25, 11631615 },
	{ 25, 14777343 },
	{ 25, 15825919 },
	{ 26, 27360255 },
	{ 26, 28408831 },
	{ 26, 31554559 },
	{ 26, 66091775 },
	{ 26, 65043199 },
	{ 26, 61897471 },
	{ 26, 60848895 },
	{ 26, 32537343 },
	{ 26, 31488767 },
	{ 26, 28343039 },
	{ 26, 31637501 },
	{ 25, 15760127 },
	{ 25, 14711551 },
	{ 25, 11565823 },
	{ 25, 14860285 },
	{ 24, 7371519 },
	{ 24, 6322943 },
	{ 24, 3177215 },
	{ 18, 262013 },
	{ 18, 124287 },
	{ 14, 16010 },
	{ 23, 49149 },
	{ 18, 261501 },
	{ 18, 124799 },
	{ 24, 2194175 },
	{ 24, 3242751 },
	{ 24, 6388479 },
	{ 24, 7437055 },
	{ 25, 10582783 },
	{ 25, 11631359 },
	{ 25, 14777087 },
	{ 25, 15825663 },
	{ 26, 27359999 },
	{ 26, 28408575 },
	{ 26, 31554303 },
	{ 26, 32602879 },
	{ 26, 60914431 },
	{ 26, 61963007 },
	{ 26, 65108735 },
	{ 26, 66157311 },
	{ 26, 31748095 },
	{ 26, 28602367 },
	{ 26, 32172797 },
	{ 25, 16019455 },
	{ 25, 14970879 },
	{ 25, 11825151 },
	{ 25, 15395581 },
	{ 24, 7630847 },
	{ 24, 6582271 },
	{ 24, 3436543 },
	{ 23, 2812669 },
	{ 22, 1339391 },
	{ 14, 16074 },
	{ 20, 524254 },
	{ 18, 131019 },
	{ 21, 1048379 },
	{ 22, 225279 },
	{ 22, 1273855 },
	{ 24, 2322431 },
	{ 24, 3371007 },
	{ 24, 6516735 },
	{ 24, 7565311 },
	{ 25, 10711039 },
	{ 25, 11759615 },
	{ 25, 14905343 },
	{ 25, 15953919 },
	{ 26, 27488255 },
	{ 26, 66350847 },
	{ 26, 65302271 },
	{ 26, 62156543 },
	{ 26, 61107967 },
	{ 26, 32796415 },
	{ 26, 31747839 },
	{ 26, 28602111 },
	{ 26, 32173053 },
	{ 25, 16019199 },
	{ 25, 14970623 },
	{ 25, 11824895 },
	{ 25, 15395837 },
	{ 24, 7630591 },
	{ 24, 6582015 },
	{ 24, 3436287 },
	{ 23, 2812925 },
	{ 22, 1339135 },
	{ 22, 290559 },
	{ 20, 524126 },
	{ 19, 262059 },
	{ 21, 1048555 },
	{ 22, 225023 },
	{ 22, 1273599 },
	{ 24, 2322175 },
	{ 24, 3370751 },
	{ 24, 6516479 },
	{ 24, 7565055 },
	{ 25, 10710783 },
	{ 25, 11759359 },
	{ 25, 14905087 },
	{ 25, 15953663 },
	{ 26, 27487999 },
	{ 26, 28536575 },
	{ 26, 31682303 },
	{ 26, 32730879 },
	{ 26, 61042431 },
	{ 26, 62091007 },
	{ 26, 65236735 },
	{ 26, 66285311 },
	{ 28, 127069949 },
	{ 27, 63466495 },
	{ 27, 59272191 },
	{ 27, 46689279 },
	{ 27, 59961085 },
	{ 26, 29912063 },
	{ 26, 25717759 },
	{ 26, 13134847 },
	{ 25, 9629437 },
	{ 24, 4746239 },
	{ 24, 551935 },
	{ 17, 54894 },
	{ 21, 1048251 },
	{ 18, 109947 },
	{ 22, 158715 },
	{ 22, 1207291 },
	{ 22, 1534975 },
	{ 24, 3304443 },
	{ 24, 6450171 },
	{ 24, 7498747 },
	{ 24, 7826431 },
	{ 25, 11693051 },
	{ 25, 14838779 },
	{ 25, 15887355 },
	{ 25, 16215039 },
	{ 26, 28470267 },
	{ 26, 31615995 },
	{ 26, 32664571 },
	{ 26, 60976123 },
	{ 26, 62024699 },
	{ 26, 65170427 },
	{ 26, 66219003 },
	{ 26, 66546687 },
	{ 27, 63466239 },
	{ 27, 59271935 },
	{ 27, 46689023 },
	{ 27, 59961341 },
	{ 26, 29911807 },
	{ 26, 25717503 },
	{ 26, 13134591 },
	{ 25, 9629693 },
	{ 24, 4745983 },
	{ 24, 551679 },
	{ 17, 53870 },
	{ 22, 2096571 },
	{ 18, 107899 },
	{ 22, 158459 },
	{ 22, 1207035 },
	{ 22, 1534719 },
	{ 24, 3304187 },
	{ 24, 6449915 },
	{ 24, 7498491 },
	{ 24, 7826175 },
	{ 25, 11692795 },
	{ 25, 14838523 },
	{ 25, 15887099 },
	{ 25, 16214783 },
	{ 26, 28470011 },
	{ 26, 31615739 },
	{ 26, 32664315 },
	{ 26, 60975867 },
	{ 26, 62024443 },
	{ 26, 65170171 },
	{ 26, 66218747 },
	{ 26, 66546431 },
	{ 27, 63717375 },
	{ 27, 59523071 },
	{ 27, 46940159 },
	{ 27, 60488445 },
	{ 26, 30162943 },
	{ 26, 25968639 },
	{ 26, 13385727 },
	{ 25, 10156797 },
	{ 24, 4997119 },
	{ 24, 802815 },
	{ 16, 32494 },
	{ 23, 2816761 },
	{ 22, 1327099 },
	{ 23, 2554617 },
	{ 22, 409595 },
	{ 22, 1458171 },
	{ 24, 2506747 },
	{ 24, 3555323 },
	{ 24, 6701051 },
	{ 24, 7749627 },
	{ 25, 10895355 },
	{ 25, 11943931 },
	{ 25, 15089659 },
	{ 25, 16138235 },
	{ 26, 27672571 },
	{ 26, 28721147 },
	{ 26, 31866875 },
	{ 26, 32915451 },
	{ 26, 61227003 },
	{ 26, 62275579 },
	{ 26, 65421307 },
	{ 26, 66469883 },
	{ 27, 63717119 },
	{ 27, 59522815 },
	{ 27, 46939903 },
	{ 27, 60488701 },
	{ 26, 30162687 },
	{ 26, 25968383 },
	{ 26, 13385471 },
	{ 25, 10157053 },
	{ 24, 4996863 },
	{ 24, 802559 },
	{ 16, 31470 },
	{ 23, 2817017 },
	{ 22, 1326843 },
	{ 23, 2554873 },
	{ 22, 409339 },
	{ 22, 1457915 },
	{ 24, 2506491 },
	{ 24, 3555067 },
	{ 24, 6700795 },
	{ 24, 7749371 },
	{ 25, 10895099 },
	{ 25, 11943675 },
	{ 25, 15089403 },
	{ 25, 16137979 },
	{ 26, 27672315 },
	{ 26, 28720891 },
	{ 26, 31866619 },
	{ 26, 32915195 },
	{ 26, 61226747 },
	{ 26, 62275323 },
	{ 26, 65421051 },
	{ 26, 66469627 },
	{ 27, 64502783 },
	{ 27, 60308479 },
	{ 27, 47725567 },
	{ 27, 62062333 },
	{ 26, 30948351 },
	{ 26, 26754047 },
	{ 26, 14171135 },
	{ 25, 11730685 },
	{ 24, 5782527 },
	{ 24, 1588223 },
	{ 18, 121198 },
	{ 24, 801787 },
	{ 24, 4733947 },
	{ 24, 2374651 },
	{ 24, 3161083 },
	{ 24, 670715 },
	{ 24, 4865019 },
	{ 24, 5192703 },
	{ 26, 13253627 },
	{ 26, 25836539 },
	{ 26, 30030843 },
	{ 26, 30358527 },
	{ 27, 46808059 },
	{ 27, 59390971 },
	{ 27, 63585275 },
	{ 27, 63912959 },
	{ 28, 113916923 },
	{ 28, 126499835 },
	{ 28, 130694139 },
	{ 28, 243940347 },
	{ 28, 248134651 },
	{ 28, 129171453 },
	{ 27, 64502527 },
	{ 27, 60308223 },
	{ 27, 47725311 },
	{ 27, 62062589 },
	{ 26, 30948095 },
	{ 26, 26753791 },
	{ 26, 14170879 },
	{ 25, 11730941 },
	{ 24, 5782271 },
	{ 24, 1587967 },
	{ 18, 117102 },
	{ 24, 801531 },
	{ 24, 4733691 },
	{ 24, 2374395 },
	{ 24, 3160827 },
	{ 24, 670459 },
	{ 24, 4864763 },
	{ 24, 5192447 },
	{ 26, 13253371 },
	{ 26, 25836283 },
	{ 26, 30030587 },
	{ 26, 30358271 },
	{ 27, 46807803 },
	{ 27, 59390715 },
	{ 27, 63585019 },
	{ 27, 63912703 },
	{ 28, 113916667 },
	{ 28, 126499579 },
	{ 28, 130693883 },
	{ 28, 243940091 },
	{ 28, 248134395 },
	{ 28, 260717307 },
	{ 27, 64761855 },
	{ 27, 60567551 },
	{ 27, 47984639 },
	{ 27, 43790335 },
	{ 26, 31207423 },
	{ 26, 27013119 },
	{ 26, 14430207 },
	{ 26, 24488701 },
	{ 24, 6041599 },
	{ 24, 1847295 },
	{ 18, 96750 },
	{ 24, 1585147 },
	{ 24, 4993019 },
	{ 26, 14002937 },
	{ 24, 3420155 },
	{ 24, 6303739 },
	{ 24, 929787 },
	{ 24, 5124091 },
	{ 24, 5976063 },
	{ 26, 13512699 },
	{ 26, 26095611 },
	{ 26, 30289915 },
	{ 26, 31141887 },
	{ 27, 47067131 },
	{ 27, 59650043 },
	{ 27, 63844347 },
	{ 27, 64696319 },
	{ 28, 114175995 },
	{ 28, 126758907 },
	{ 28, 130953211 },
	{ 28, 244199419 },
	{ 28, 248393723 },
	{ 27, 64761599 },
	{ 27, 60567295 },
	{ 27, 47984383 },
	{ 27, 43790079 },
	{ 26, 31207167 },
	{ 26, 27012863 },
	{ 26, 14429951 },
	{ 26, 24488957 },
	{ 24, 6041343 },
	{ 24, 1847039 },
	{ 18, 92654 },
	{ 24, 1584891 },
	{ 24, 4992763 },
	{ 26, 14003193 },
	{ 24, 3419899 },
	{ 24, 6303483 },
	{ 24, 929531 },
	{ 24, 5123835 },
	{ 24, 5975807 },
	{ 26, 13512443 },
	{ 26, 26095355 },
	{ 26, 30289659 },
	{ 26, 31141631 },
	{ 27, 47066875 },
	{ 27, 59649787 },
	{ 27, 63844091 },
	{ 27, 64696063 },
	{ 28, 114175739 },
	{ 28, 126758651 },
	{ 28, 130952955 },
	{ 28, 244199163 },
	{ 28, 248393467 },
	{ 28, 260976379 },
	{ 28, 265170683 },
	{ 28, 266022655 },
	{ 28, 86518783 },
	{ 27, 61352959 },
	{ 27, 52964351 },
	{ 27, 27798527 },
	{ 27, 44412669 },
	{ 25, 11021311 },
	{ 25, 2632703 },
	{ 18, 88942 },
	{ 24, 1846267 },
	{ 24, 5778427 },
	{ 26, 9186299 },
	{ 26, 26586873 },
	{ 24, 6564859 },
	{ 24, 7351291 },
	{ 24, 1715195 },
	{ 24, 5909499 },
	{ 24, 6237183 },
	{ 26, 14298107 },
	{ 26, 26881019 },
	{ 26, 31075323 },
	{ 26, 31403007 },
	{ 27, 47852539 },
	{ 27, 60435451 },
	{ 27, 64629755 },
	{ 27, 64957439 },
	{ 28, 114961403 },
	{ 28, 127544315 },
	{ 28, 131738619 },
	{ 28, 244984827 },
	{ 28, 249179131 },
	{ 28, 261762043 },
	{ 28, 265956347 },
	{ 28, 86518527 },
	{ 27, 61352703 },
	{ 27, 52964095 },
	{ 27, 27798271 },
	{ 27, 44412925 },
	{ 25, 11021055 },
	{ 25, 2632447 },
	{ 18, 84846 },
	{ 24, 1846011 },
	{ 24, 5778171 },
	{ 26, 9186043 },
	{ 26, 26587129 },
	{ 24, 6564603 },
	{ 24, 7351035 },
	{ 24, 1714939 },
	{ 24, 5909243 },
	{ 24, 6236927 },
	{ 26, 14297851 },
	{ 26, 26880763 },
	{ 26, 31075067 },
	{ 26, 31402751 },
	{ 27, 47852283 },
	{ 27, 60435195 },
	{ 27, 64629499 },
	{ 27, 64957183 },
	{ 27, 65740799 },
	{ 27, 63643647 },
	{ 27, 57352191 },
	{ 27, 55255039 },
	{ 26, 32186367 },
	{ 26, 30089215 },
	{ 26, 23797759 },
	{ 26, 21700607 },
	{ 25, 15409151 },
	{ 25, 13311999 },
	{ 25, 7020543 },
	{ 25, 4923391 },
	{ 23, 2826239 },
	{ 23, 729087 },
	{ 17, 64494 },
	{ 23, 663547 },
	{ 22, 1515515 },
	{ 24, 2498555 },
	{ 24, 3350523 },
	{ 24, 6430715 },
	{ 22, 1908731 },
	{ 23, 2629627 },
	{ 22, 499707 },
	{ 22, 1548283 },
	{ 23, 2809855 },
	{ 24, 3645435 },
	{ 24, 6791163 },
	{ 24, 7839739 },
	{ 25, 10985467 },
	{ 25, 12034043 },
	{ 25, 15179771 },
	{ 25, 16228347 },
	{ 26, 27762683 },
	{ 26, 28811259 },
	{ 26, 31956987 },
	{ 26, 33005563 },
	{ 26, 61317115 },
	{ 26, 62365691 },
	{ 26, 65511419 },
	{ 26, 66559995 },
	{ 25, 15408895 },
	{ 25, 13311743 },
	{ 25, 7020287 },
	{ 25, 4923135 },
	{ 23, 2825983 },
	{ 23, 728831 },
	{ 17, 60398 },
	{ 23, 663291 },
	{ 22, 1515259 },
	{ 24, 2498299 },
	{ 24, 3350267 },
	{ 24, 6430459 },
	{ 22, 1908475 },
	{ 23, 2629371 },
	{ 22, 499451 },
	{ 22, 1548027 },
	{ 23, 2809599 },
	{ 24, 3645179 },
	{ 24, 6790907 },
	{ 24, 7839483 },
	{ 25, 10985211 },
	{ 25, 12033787 },
	{ 25, 15179515 },
	{ 25, 16228091 },
	{ 26, 27762427 },
	{ 26, 28811003 },
	{ 26, 31956731 },
	{ 26, 33005307 },
	{ 26, 61316859 },
	{ 26, 62365435 },
	{ 26, 65511163 },
	{ 26, 66559739 },
	{ 25, 15604735 },
	{ 25, 13507583 },
	{ 25, 7216127 },
	{ 25, 5118975 },
	{ 23, 3021823 },
	{ 23, 924671 },
	{ 18, 111982 },
	{ 23, 728059 },
	{ 23, 2759675 },
	{ 24, 2563067 },
	{ 24, 3546107 },
	{ 24, 6495227 },
	{ 24, 7478267 },
	{ 23, 2694139 },
	{ 23, 2890747 },
	{ 23, 695291 },
	{ 23, 2792443 },
	{ 23, 2874367 },
	{ 25, 6986747 },
	{ 25, 13278203 },
	{ 25, 15375355 },
	{ 25, 15457279 },
	{ 26, 23763963 },
	{ 26, 30055419 },
	{ 26, 32152571 },
	{ 26, 32234495 },
	{ 27, 57318395 },
	{ 27, 63609851 },
	{ 26, 32381695 },
	{ 26, 30284543 },
	{ 26, 23993087 },
	{ 26, 21895935 },
	{ 25, 15604479 },
	{ 25, 13507327 },
	{ 25, 7215871 },
	{ 25, 5118719 },
	{ 23, 3021567 },
	{ 23, 924415 },
	{ 18, 103790 },
	{ 23, 727803 },
	{ 23, 2759419 },
	{ 24, 2562811 },
	{ 24, 3545851 },
	{ 24, 6494971 },
	{ 24, 7478011 },
	{ 23, 2693883 },
	{ 23, 2890491 },
	{ 23, 695035 },
	{ 23, 2792187 },
	{ 23, 2874111 },
	{ 25, 6986491 },
	{ 25, 13277947 },
	{ 25, 15375099 },
	{ 25, 15457023 },
	{ 26, 23763707 },
	{ 26, 30055163 },
	{ 26, 32152315 },
	{ 26, 32234239 },
	{ 27, 57318139 },
	{ 27, 63609595 },
	{ 26, 32444415 },
	{ 26, 30347263 },
	{ 26, 24055807 },
	{ 26, 21958655 },
	{ 25, 15667199 },
	{ 25, 13570047 },
	{ 25, 7278591 },
	{ 25, 5181439 },
	{ 23, 3084287 },
	{ 23, 987135 },
	{ 18, 62958 },
	{ 23, 921595 },
	{ 23, 2822139 },
	{ 25, 4853755 },
	{ 24, 3608571 },
	{ 24, 6688763 },
	{ 24, 7540731 },
	{ 25, 10620923 },
	{ 23, 2953211 },
	{ 23, 3674107 },
	{ 23, 757755 },
	{ 23, 2854907 },
	{ 23, 3067903 },
	{ 25, 7049211 },
	{ 25, 13340667 },
	{ 25, 15437819 },
	{ 25, 15650815 },
	{ 26, 23826427 },
	{ 26, 30117883 },
	{ 26, 32215035 },
	{ 26, 32428031 },
	{ 27, 57380859 },
	{ 26, 32444159 },
	{ 26, 30347007 },
	{ 26, 24055551 },
	{ 26, 21958399 },
	{ 25, 15666943 },
	{ 25, 13569791 },
	{ 25, 7278335 },
	{ 25, 5181183 },
	{ 23, 3084031 },
	{ 23, 986879 },
	{ 18, 54766 },
	{ 23, 921339 },
	{ 23, 2821883 },
	{ 25, 4853499 },
	{ 24, 3608315 },
	{ 24, 6688507 },
	{ 24, 7540475 },
	{ 25, 10620667 },
	{ 23, 2952955 },
	{ 23, 3673851 },
	{ 23, 757499 },
	{ 23, 2854651 },
	{ 23, 3067647 },
	{ 25, 7048955 },
	{ 25, 13340411 },
	{ 25, 15437563 },
	{ 25, 15650559 },
	{ 26, 23826171 },
	{ 26, 30117627 },
	{ 26, 32214779 },
	{ 26, 32427775 },
	{ 27, 57380603 },
	{ 27, 63672059 },
	{ 27, 65769211 },
	{ 27, 122392315 },
	{ 27, 124489467 },
	{ 26, 33509115 },
	{ 26, 26872831 },
	{ 26, 14289919 },
	{ 26, 10095615 },
	{ 24, 5901311 },
	{ 24, 1707007 },
	{ 18, 46958 },
	{ 23, 986107 },
	{ 23, 3017723 },
	{ 25, 4918267 },
	{ 25, 6949883 },
	{ 24, 6753275 },
	{ 24, 7736315 },
	{ 25, 10685435 },
	{ 25, 11668475 },
	{ 23, 3738619 },
	{ 23, 3935227 },
	{ 23, 953339 },
	{ 23, 3050491 },
	{ 23, 3132415 },
	{ 25, 7244795 },
	{ 25, 13536251 },
	{ 25, 15633403 },
	{ 25, 15715327 },
	{ 26, 24022011 },
	{ 26, 30313467 },
	{ 26, 32410619 },
	{ 26, 32492543 },
	{ 27, 57576443 },
	{ 27, 63867899 },
	{ 27, 65965051 },
	{ 27, 122588155 },
	{ 26, 33442811 },
	{ 26, 29314043 },
	{ 26, 14289663 },
	{ 26, 10095359 },
	{ 24, 5901055 },
	{ 24, 1706751 },
	{ 18, 38766 },
	{ 23, 985851 },
	{ 23, 3017467 },
	{ 25, 4918011 },
	{ 25, 6949627 },
	{ 24, 6753019 },
	{ 24, 7736059 },
	{ 25, 10685179 },
	{ 25, 11668219 },
	{ 23, 3738363 },
	{ 23, 3934971 },
	{ 23, 953083 },
	{ 23, 3050235 },
	{ 23, 3132159 },
	{ 25, 7244539 },
	{ 25, 13535995 },
	{ 25, 15633147 },
	{ 25, 15715071 },
	{ 26, 24021755 },
	{ 26, 30313211 },
	{ 26, 32410363 },
	{ 26, 32492287 },
	{ 25, 16173055 },
	{ 25, 15124479 },
	{ 25, 11978751 },
	{ 25, 10930175 },
	{ 24, 7784447 },
	{ 24, 6735871 },
	{ 24, 3590143 },
	{ 24, 2541567 },
	{ 22, 1492991 },
	{ 22, 444415 },
	{ 16, 30702 },
	{ 22, 428027 },
	{ 21, 772091 },
	{ 23, 1279995 },
	{ 23, 1755131 },
	{ 23, 3311611 },
	{ 22, 1951739 },
	{ 23, 2721787 },
	{ 23, 2934779 },
	{ 23, 3704827 },
	{ 21, 1001467 },
	{ 22, 1705979 },
	{ 21, 255995 },
	{ 21, 780283 },
	{ 22, 1488895 },
	{ 23, 1828859 },
	{ 23, 3401723 },
	{ 23, 3926011 },
	{ 24, 5498875 },
	{ 24, 6023163 },
	{ 24, 7596027 },
	{ 24, 8120315 },
	{ 25, 13887483 },
	{ 25, 14411771 },
	{ 25, 15984635 },
	{ 25, 16508923 },
	{ 24, 8312827 },
	{ 24, 7313403 },
	{ 24, 4184059 },
	{ 24, 2541311 },
	{ 22, 1492735 },
	{ 22, 444159 },
	{ 16, 22510 },
	{ 22, 427771 },
	{ 21, 771835 },
	{ 23, 1279739 },
	{ 23, 1754875 },
	{ 23, 3311355 },
	{ 22, 1951483 },
	{ 23, 2721531 },
	{ 23, 2934523 },
	{ 23, 3704571 },
	{ 21, 1001211 },
	{ 22, 1705723 },
	{ 21, 255739 },
	{ 21, 780027 },
	{ 22, 1488639 },
	{ 23, 1828603 },
	{ 23, 3401467 },
	{ 23, 3925755 },
	{ 24, 5498619 },
	{ 24, 6022907 },
	{ 24, 7595771 },
	{ 24, 8120059 },
	{ 25, 13887227 },
	{ 25, 14411515 },
	{ 25, 15984379 },
	{ 25, 16508667 },
	{ 24, 8312571 },
	{ 24, 7313147 },
	{ 24, 4183803 },
	{ 24, 2589695 },
	{ 22, 1541119 },
	{ 22, 492543 },
	{ 17, 28014 },
	{ 22, 443387 },
	{ 22, 1475579 },
	{ 23, 1295355 },
	{ 23, 1803259 },
	{ 23, 3326971 },
	{ 23, 3834875 },
	{ 23, 2737147 },
	{ 23, 2982907 },
	{ 23, 3720187 },
	{ 23, 3965947 },
	{ 22, 1721339 },
	{ 22, 1770491 },
	{ 22, 435195 },
	{ 22, 1483771 },
	{ 22, 1504255 },
	{ 24, 3580923 },
	{ 24, 6726651 },
	{ 24, 7775227 },
	{ 24, 7795711 },
	{ 25, 11969531 },
	{ 25, 15115259 },
	{ 25, 16163835 },
	{ 25, 15127547 },
	{ 25, 12030971 },
	{ 25, 10998779 },
	{ 24, 8295419 },
	{ 24, 7263227 },
	{ 24, 4166651 },
	{ 24, 3134459 },
	{ 22, 1540863 },
	{ 22, 492287 },
	{ 17, 11630 },
	{ 22, 443131 },
	{ 22, 1475323 },
	{ 23, 1295099 },
	{ 23, 1803003 },
	{ 23, 3326715 },
	{ 23, 3834619 },
	{ 23, 2736891 },
	{ 23, 2982651 },
	{ 23, 3719931 },
	{ 23, 3965691 },
	{ 22, 1721083 },
	{ 22, 1770235 },
	{ 22, 434939 },
	{ 22, 1483515 },
	{ 22, 1503999 },
	{ 24, 3580667 },
	{ 24, 6726395 },
	{ 24, 7774971 },
	{ 24, 7795455 },
	{ 24, 7205375 },
	{ 24, 6943231 },
	{ 23, 4059647 },
	{ 23, 3797503 },
	{ 23, 3011071 },
	{ 23, 2748927 },
	{ 22, 1962495 },
	{ 22, 1700351 },
	{ 22, 913919 },
	{ 22, 651775 },
	{ 20, 389631 },
	{ 20, 127487 },
	{ 15, 19950 },
	{ 20, 123387 },
	{ 20, 373243 },
	{ 22, 631291 },
	{ 21, 455163 },
	{ 21, 844283 },
	{ 21, 963067 },
	{ 22, 1352187 },
	{ 21, 750075 },
	{ 21, 942587 },
	{ 21, 995835 },
	{ 20, 1039867 },
	{ 20, 446971 },
	{ 20, 492027 },
	{ 20, 113147 },
	{ 20, 375291 },
	{ 20, 388607 },
	{ 22, 899579 },
	{ 22, 1686011 },
	{ 22, 1948155 },
	{ 22, 1961471 },
	{ 23, 2996731 },
	{ 22, 2029051 },
	{ 23, 3798269 },
	{ 23, 3011837 },
	{ 23, 2749693 },
	{ 22, 1963261 },
	{ 22, 1701117 },
	{ 22, 914685 },
	{ 22, 652541 },
	{ 20, 390397 },
	{ 20, 128253 },
	{ 15, 3482 },
	{ 20, 124153 },
	{ 20, 374009 },
	{ 22, 632057 },
	{ 21, 455929 },
	{ 21, 845049 },
	{ 21, 963833 },
	{ 22, 2095353 },
	{ 21, 750841 },
	{ 21, 943353 },
	{ 21, 996601 },
	{ 20, 522489 },
	{ 20, 260345 },
	{ 20, 492793 },
	{ 20, 1036537 },
	{ 20, 449785 },
	{ 20, 497917 },
	{ 22, 3825913 },
	{ 22, 2060537 },
	{ 22, 1801465 },
	{ 22, 1997053 },
	{ 23, 3465465 },
	{ 22, 2027769 },
	{ 23, 3776761 },
	{ 23, 2994425 },
	{ 23, 2744569 },
	{ 22, 1962233 },
	{ 22, 1810681 },
	{ 22, 1028345 },
	{ 22, 778489 },
	{ 20, 520441 },
	{ 20, 128509 },
	{ 15, 8170 },
	{ 20, 124409 },
	{ 20, 374265 },
	{ 22, 632313 },
	{ 21, 456185 },
	{ 21, 845305 },
	{ 21, 964089 },
	{ 22, 2095609 },
	{ 21, 751097 },
	{ 21, 943609 },
	{ 21, 996857 },
	{ 20, 522745 },
	{ 20, 260601 },
	{ 20, 493049 },
	{ 20, 1036793 },
	{ 20, 450041 },
	{ 20, 498173 },
	{ 22, 3826169 },
	{ 22, 2060793 },
	{ 22, 1801721 },
	{ 22, 1997309 },
	{ 23, 3465721 },
	{ 22, 2028025 },
	{ 23, 3777017 },
	{ 23, 2994681 },
	{ 23, 2744825 },
	{ 22, 1962489 },
	{ 22, 1810937 },
	{ 22, 1028601 },
	{ 22, 778745 },
	{ 20, 520697 },
	{ 22, 955133 },
	{ 15, 24554 },
	{ 22, 512761 },
	{ 22, 1544953 },
	{ 24, 2544377 },
	{ 24, 3576569 },
	{ 23, 3396345 },
	{ 23, 3904249 },
	{ 24, 5427961 },
	{ 24, 8364793 },
	{ 23, 3789561 },
	{ 23, 4035321 },
	{ 22, 2093821 },
	{ 22, 2073337 },
	{ 22, 1024761 },
	{ 22, 4129529 },
	{ 22, 4080377 },
	{ 22, 1995513 },
	{ 22, 2056957 },
	{ 24, 8225529 },
	{ 24, 7979769 },
	{ 24, 7992057 },
	{ 24, 8250109 },
	{ 24, 8094457 },
	{ 24, 7586553 },
	{ 25, 11961081 },
	{ 25, 10928889 },
	{ 24, 7832313 },
	{ 24, 6800121 },
	{ 24, 4096761 },
	{ 24, 3064569 },
	{ 22, 2065145 },
	{ 22, 1032953 },
	{ 17, 16234 },
	{ 22, 513017 },
	{ 22, 1545209 },
	{ 24, 2544633 },
	{ 24, 3576825 },
	{ 23, 3396601 },
	{ 23, 3904505 },
	{ 24, 5428217 },
	{ 24, 8365049 },
	{ 23, 3789817 },
	{ 23, 4035577 },
	{ 22, 2094077 },
	{ 22, 2073593 },
	{ 22, 1025017 },
	{ 22, 4129785 },
	{ 22, 4080633 },
	{ 22, 1995769 },
	{ 22, 2057213 },
	{ 24, 8225785 },
	{ 24, 7980025 },
	{ 24, 7992313 },
	{ 24, 8250365 },
	{ 24, 8094713 },
	{ 24, 7586809 },
	{ 25, 11961337 },
	{ 25, 10929145 },
	{ 24, 7832569 },
	{ 24, 6800377 },
	{ 24, 4097017 },
	{ 24, 3064825 },
	{ 22, 2065401 },
	{ 22, 1033209 },
	{ 17, 32618 },
	{ 22, 956153 },
	{ 22, 1562361 },
	{ 24, 2594553 },
	{ 24, 3593977 },
	{ 24, 6723321 },
	{ 23, 3921657 },
	{ 24, 5478137 },
	{ 24, 5953273 },
	{ 24, 8316665 },
	{ 23, 4052729 },
	{ 24, 4122361 },
	{ 22, 2078461 },
	{ 22, 2025209 },
	{ 22, 976633 },
	{ 22, 4065017 },
	{ 22, 3884793 },
	{ 22, 2062073 },
	{ 22, 3827453 },
	{ 24, 7964409 },
	{ 24, 7194361 },
	{ 24, 8255225 },
	{ 24, 8046329 },
	{ 24, 7571193 },
	{ 24, 6014713 },
	{ 25, 10913529 },
	{ 24, 7784185 },
	{ 24, 6784761 },
	{ 24, 3655417 },
	{ 24, 3049209 },
	{ 22, 2017017 },
	{ 22, 1017593 },
	{ 17, 48618 },
	{ 22, 956409 },
	{ 22, 1562617 },
	{ 24, 2594809 },
	{ 24, 3594233 },
	{ 24, 6723577 },
	{ 23, 3921913 },
	{ 24, 5478393 },
	{ 24, 5953529 },
	{ 24, 8316921 },
	{ 23, 4052985 },
	{ 24, 4122617 },
	{ 22, 2078717 },
	{ 22, 2025465 },
	{ 22, 976889 },
	{ 22, 4065273 },
	{ 22, 3885049 },
	{ 22, 2062329 },
	{ 22, 3827709 },
	{ 24, 7964665 },
	{ 24, 7194617 },
	{ 24, 8255481 },
	{ 24, 8046585 },
	{ 24, 7571449 },
	{ 24, 6014969 },
	{ 25, 10913785 },
	{ 24, 7784441 },
	{ 24, 6785017 },
	{ 24, 3655673 },
	{ 24, 3049465 },
	{ 22, 2017273 },
	{ 22, 1017849 },
	{ 17, 65002 },
	{ 22, 1034237 },
	{ 22, 2082813 },
	{ 24, 3131389 },
	{ 24, 4179965 },
	{ 24, 7325693 },
	{ 24, 8374269 },
	{ 25, 11519997 },
	{ 25, 12568573 },
	{ 25, 15714301 },
	{ 25, 16762877 },
	{ 26, 29002489 },
	{ 26, 16419577 },
	{ 24, 8112893 },
	{ 24, 8030969 },
	{ 24, 3836665 },
	{ 24, 15469305 },
	{ 24, 15272697 },
	{ 24, 15321849 },
	{ 24, 15567613 },
	{ 26, 28707577 },
	{ 26, 27724537 },
	{ 26, 32115449 },
	{ 26, 30083833 },
	{ 26, 23988985 },
	{ 26, 21957369 },
	{ 26, 31066873 },
	{ 26, 26938105 },
	{ 26, 14551801 },
	{ 26, 10423033 },
	{ 24, 7998201 },
	{ 24, 3869433 },
	{ 19, 81258 },
	{ 24, 3886073 },
	{ 24, 8014841 },
	{ 26, 10439673 },
	{ 26, 14568441 },
	{ 26, 26954745 },
	{ 26, 31083513 },
	{ 26, 21974009 },
	{ 26, 24005625 },
	{ 26, 30100473 },
	{ 26, 33197049 },
	{ 26, 29002745 },
	{ 26, 16419833 },
	{ 24, 8113149 },
	{ 24, 8031225 },
	{ 24, 3836921 },
	{ 24, 15469561 },
	{ 24, 15272953 },
	{ 24, 15322105 },
	{ 24, 15567869 },
	{ 26, 28707833 },
	{ 26, 27724793 },
	{ 26, 32115705 },
	{ 26, 30084089 },
	{ 26, 23989241 },
	{ 26, 21957625 },
	{ 26, 31067129 },
	{ 26, 26938361 },
	{ 26, 14552057 },
	{ 26, 10423289 },
	{ 24, 7998457 },
	{ 24, 3869689 },
	{ 19, 97642 },
	{ 24, 4083449 },
	{ 24, 8081145 },
	{ 26, 12209913 },
	{ 26, 14634745 },
	{ 26, 27152121 },
	{ 26, 31149817 },
	{ 27, 64982777 },
	{ 26, 24071929 },
	{ 26, 30297849 },
	{ 26, 32198393 },
	{ 26, 31428345 },
	{ 26, 27234041 },
	{ 26, 14651129 },
	{ 24, 8048381 },
	{ 24, 6262521 },
	{ 24, 2068217 },
	{ 24, 15208185 },
	{ 24, 8195833 },
	{ 24, 15585017 },
	{ 24, 16355069 },
	{ 26, 27660025 },
	{ 25, 16191225 },
	{ 26, 30019321 },
	{ 26, 23793401 },
	{ 26, 21892857 },
	{ 25, 15666937 },
	{ 26, 26873593 },
	{ 26, 14356217 },
	{ 26, 10358521 },
	{ 24, 6229753 },
	{ 24, 3804921 },
	{ 19, 110570 },
	{ 24, 4083705 },
	{ 24, 8081401 },
	{ 26, 12210169 },
	{ 26, 14635001 },
	{ 26, 27152377 },
	{ 26, 31150073 },
	{ 27, 64983033 },
	{ 26, 24072185 },
	{ 26, 30298105 },
	{ 26, 32198649 },
	{ 26, 31428601 },
	{ 26, 27234297 },
	{ 26, 14651385 },
	{ 24, 8048637 },
	{ 24, 6262777 },
	{ 24, 2068473 },
	{ 24, 15208441 },
	{ 24, 8196089 },
	{ 24, 15585273 },
	{ 24, 16355325 },
	{ 26, 27660281 },
	{ 25, 16191481 },
	{ 26, 30019577 },
	{ 26, 23793657 },
	{ 26, 21893113 },
	{ 25, 15667193 },
	{ 26, 26873849 },
	{ 26, 14356473 },
	{ 26, 10358777 },
	{ 24, 6230009 },
	{ 24, 3805177 },
	{ 19, 126954 },
	{ 24, 4152057 },
	{ 24, 8280825 },
	{ 26, 12278521 },
	{ 26, 16407289 },
	{ 26, 27220729 },
	{ 26, 31349497 },
	{ 27, 43735801 },
	{ 27, 64920313 },
	{ 26, 30366457 },
	{ 26, 32398073 },
	{ 26, 31447805 },
	{ 26, 31365881 },
	{ 26, 27171577 },
	{ 26, 14588665 },
	{ 24, 6281981 },
	{ 24, 6200057 },
	{ 24, 2005753 },
	{ 24, 8133369 },
	{ 24, 7936761 },
	{ 24, 16374521 },
	{ 24, 16620285 },
	{ 25, 16128761 },
	{ 25, 15145721 },
	{ 26, 23730937 },
	{ 26, 21699321 },
	{ 25, 15604473 },
	{ 25, 13572857 },
	{ 26, 14293753 },
	{ 26, 10164985 },
	{ 24, 6167289 },
	{ 24, 2038521 },
	{ 19, 208746 },
	{ 24, 4152313 },
	{ 24, 8281081 },
	{ 26, 12278777 },
	{ 26, 16407545 },
	{ 26, 27220985 },
	{ 26, 31349753 },
	{ 27, 43736057 },
	{ 27, 64920569 },
	{ 26, 30366713 },
	{ 26, 32398329 },
	{ 26, 31448061 },
	{ 26, 31366137 },
	{ 26, 27171833 },
	{ 26, 14588921 },
	{ 24, 6282237 },
	{ 24, 6200313 },
	{ 24, 2006009 },
	{ 24, 8133625 },
	{ 24, 7937017 },
	{ 24, 16374777 },
	{ 24, 16620541 },
	{ 25, 16129017 },
	{ 25, 15145977 },
	{ 26, 23731193 },
	{ 26, 21699577 },
	{ 25, 15604729 },
	{ 25, 13573113 },
	{ 26, 14294009 },
	{ 26, 10165241 },
	{ 24, 6167545 },
	{ 24, 2038777 },
	{ 19, 225130 },
	{ 24, 3808253 },
	{ 24, 8347385 },
	{ 26, 12476153 },
	{ 26, 16473849 },
	{ 26, 28991225 },
	{ 26, 31416057 },
	{ 27, 43933433 },
	{ 27, 47931129 },
	{ 27, 64724729 },
	{ 26, 32464633 },
	{ 27, 47947513 },
	{ 26, 31383293 },
	{ 26, 31170297 },
	{ 26, 26975993 },
	{ 26, 14393081 },
	{ 24, 6217469 },
	{ 24, 6004473 },
	{ 24, 1810169 },
	{ 24, 7872249 },
	{ 24, 7151353 },
	{ 24, 16637689 },
	{ 25, 15933177 },
	{ 25, 15081209 },
	{ 25, 12001017 },
	{ 26, 21634809 },
	{ 25, 15408889 },
	{ 25, 13508345 },
	{ 25, 7282425 },
	{ 26, 10100473 },
	{ 24, 5971705 },
	{ 24, 1974009 },
	{ 19, 241130 },
	{ 24, 2039549 },
	{ 24, 8347641 },
	{ 26, 12476409 },
	{ 26, 16474105 },
	{ 26, 28991481 },
	{ 26, 31416313 },
	{ 27, 43933689 },
	{ 27, 47931385 },
	{ 27, 64724985 },
	{ 26, 32464889 },
	{ 27, 47947769 },
	{ 26, 31383549 },
	{ 26, 31170553 },
	{ 26, 26976249 },
	{ 26, 14393337 },
	{ 24, 6217725 },
	{ 24, 6004729 },
	{ 24, 1810425 },
	{ 24, 7872505 },
	{ 24, 7151609 },
	{ 24, 16637945 },
	{ 25, 15933433 },
	{ 25, 15081465 },
	{ 25, 12001273 },
	{ 26, 21635065 },
	{ 25, 15409145 },
	{ 25, 13508601 },
	{ 25, 7282681 },
	{ 26, 10100729 },
	{ 24, 5971961 },
	{ 24, 1974265 },
	{ 19, 257514 },
	{ 24, 2039805 },
	{ 24, 6234109 },
	{ 26, 10428413 },
	{ 26, 14622717 },
	{ 26, 27205629 },
	{ 26, 31399933 },
	{ 27, 43982845 },
	{ 27, 48177149 },
	{ 27, 60760061 },
	{ 27, 64954365 },
	{ 28, 111091709 },
	{ 28, 115286013 },
	{ 28, 124726013 },
	{ 28, 124398329 },
	{ 28, 107621113 },
	{ 28, 57289465 },
	{ 26, 24062717 },
	{ 26, 23735033 },
	{ 26, 6957817 },
	{ 26, 28322553 },
	{ 26, 27536121 },
	{ 27, 63449849 },
	{ 27, 59517689 },
	{ 27, 47721209 },
	{ 27, 43789049 },
	{ 27, 61352697 },
	{ 27, 53226233 },
	{ 27, 28846841 },
	{ 27, 20720377 },
	{ 26, 23603961 },
	{ 26, 7088889 },
	{ 20, 339306 },
	{ 26, 7875325 },
	{ 26, 24652541 },
	{ 28, 50146297 },
	{ 28, 66661369 },
	{ 28, 116206585 },
	{ 28, 132721657 },
	{ 29, 175975417 },
	{ 29, 192490489 },
	{ 29, 242035705 },
	{ 29, 258616313 },
	{ 29, 241839097 },
	{ 29, 191507449 },
	{ 28, 124726269 },
	{ 28, 124398585 },
	{ 28, 107621369 },
	{ 28, 57289721 },
	{ 26, 24062973 },
	{ 26, 23735289 },
	{ 26, 6958073 },
	{ 26, 28322809 },
	{ 26, 27536377 },
	{ 27, 63450105 },
	{ 27, 59517945 },
	{ 27, 47721465 },
	{ 27, 43789305 },
	{ 27, 61352953 },
	{ 27, 53226489 },
	{ 27, 28847097 },
	{ 27, 20720633 },
	{ 26, 23604217 },
	{ 26, 7089145 },
	{ 20, 355690 },
	{ 26, 7875581 },
	{ 26, 24652797 },
	{ 28, 41430013 },
	{ 28, 66924281 },
	{ 28, 116993785 },
	{ 28, 132984569 },
	{ 29, 264122105 },
	{ 29, 255733497 },
	{ 29, 230567673 },
	{ 29, 222179065 },
	{ 28, 129904377 },
	{ 28, 121515769 },
	{ 28, 96349945 },
	{ 28, 87961337 },
	{ 27, 62795513 },
	{ 27, 54406905 },
	{ 27, 29241081 },
	{ 26, 23801597 },
	{ 25, 12463865 },
	{ 25, 4075257 },
	{ 26, 27275001 },
	{ 25, 16002809 },
	{ 27, 59256569 },
	{ 27, 46935801 },
	{ 27, 43527929 },
	{ 26, 31207161 },
	{ 27, 52965113 },
	{ 27, 28061433 },
	{ 27, 20459257 },
	{ 25, 12332793 },
	{ 26, 6827769 },
	{ 19, 186346 },
	{ 26, 7089917 },
	{ 26, 23867133 },
	{ 28, 40644349 },
	{ 28, 66924537 },
	{ 28, 116994041 },
	{ 28, 132984825 },
	{ 29, 264122361 },
	{ 29, 255733753 },
	{ 29, 230567929 },
	{ 29, 222179321 },
	{ 28, 129904633 },
	{ 28, 121516025 },
	{ 28, 96350201 },
	{ 28, 87961593 },
	{ 27, 62795769 },
	{ 27, 54407161 },
	{ 27, 29241337 },
	{ 26, 23801853 },
	{ 25, 12464121 },
	{ 25, 4075513 },
	{ 26, 27275257 },
	{ 25, 16003065 },
	{ 27, 59256825 },
	{ 27, 46936057 },
	{ 27, 43528185 },
	{ 26, 31207417 },
	{ 27, 52965369 },
	{ 27, 28061689 },
	{ 27, 20459513 },
	{ 25, 12333049 },
	{ 26, 6828025 },
	{ 19, 194538 },
	{ 26, 7090173 },
	{ 26, 23867389 },
	{ 28, 40644605 },
	{ 28, 57421821 },
	{ 28, 117259001 },
	{ 28, 133774073 },
	{ 29, 490355449 },
	{ 29, 263863033 },
	{ 29, 255474425 },
	{ 29, 230308601 },
	{ 28, 129972989 },
	{ 28, 129645305 },
	{ 28, 121256697 },
	{ 28, 96090873 },
	{ 27, 62864125 },
	{ 27, 62536441 },
	{ 27, 54147833 },
	{ 27, 28982009 },
	{ 25, 12532477 },
	{ 25, 12204793 },
	{ 25, 3816185 },
	{ 25, 15743737 },
	{ 25, 14957305 },
	{ 26, 30081019 },
	{ 27, 42744569 },
	{ 26, 30948089 },
	{ 26, 27015929 },
	{ 27, 27802361 },
	{ 27, 19675897 },
	{ 25, 12073721 },
	{ 25, 3947257 },
	{ 19, 235370 },
	{ 26, 6830845 },
	{ 26, 23608061 },
	{ 27, 47382527 },
	{ 28, 57162493 },
	{ 28, 117259257 },
	{ 28, 133774329 },
	{ 29, 490355705 },
	{ 29, 263863289 },
	{ 29, 255474681 },
	{ 29, 230308857 },
	{ 28, 129973245 },
	{ 28, 129645561 },
	{ 28, 121256953 },
	{ 28, 96091129 },
	{ 27, 62864381 },
	{ 27, 62536697 },
	{ 27, 54148089 },
	{ 27, 28982265 },
	{ 25, 12532733 },
	{ 25, 12205049 },
	{ 25, 3816441 },
	{ 25, 15743993 },
	{ 25, 14957561 },
	{ 26, 30080763 },
	{ 27, 42744825 },
	{ 26, 30948345 },
	{ 26, 27016185 },
	{ 27, 27802617 },
	{ 27, 19676153 },
	{ 25, 12073977 },
	{ 25, 3947513 },
	{ 19, 243562 },
	{ 26, 6831101 },
	{ 26, 23608317 },
	{ 27, 47382271 },
	{ 28, 57162749 },
	{ 28, 107494397 },
	{ 28, 134037241 },
	{ 29, 497958649 },
	{ 29, 489570041 },
	{ 29, 263077625 },
	{ 29, 254689017 },
	{ 29, 229523193 },
	{ 28, 129711869 },
	{ 28, 128859897 },
	{ 28, 120471289 },
	{ 28, 95305465 },
	{ 27, 62603005 },
	{ 27, 61751033 },
	{ 27, 53362425 },
	{ 27, 28196601 },
	{ 25, 12271357 },
	{ 25, 11419385 },
	{ 25, 3030777 },
	{ 25, 14696185 },
	{ 25, 11812601 },
	{ 26, 23788539 },
	{ 26, 30162681 },
	{ 26, 26754809 },
	{ 26, 14434041 },
	{ 27, 19414777 },
	{ 25, 11288313 },
	{ 25, 3686137 },
	{ 19, 251370 },
	{ 25, 3948285 },
	{ 25, 12336893 },
	{ 26, 24837119 },
	{ 27, 29114109 },
	{ 27, 54279933 },
	{ 27, 62668541 },
	{ 28, 87834365 },
	{ 28, 96222973 },
	{ 28, 121388797 },
	{ 28, 129777405 },
	{ 29, 229523449 },
	{ 28, 129712125 },
	{ 28, 128860153 },
	{ 28, 120471545 },
	{ 28, 95305721 },
	{ 27, 62603261 },
	{ 27, 61751289 },
	{ 27, 53362681 },
	{ 27, 28196857 },
	{ 25, 12271613 },
	{ 25, 11419641 },
	{ 25, 3031033 },
	{ 25, 14696441 },
	{ 25, 11812857 },
	{ 26, 23788283 },
	{ 26, 30162937 },
	{ 26, 26755065 },
	{ 26, 14434297 },
	{ 27, 19415033 },
	{ 25, 11288569 },
	{ 25, 3686393 },
	{ 19, 259562 },
	{ 25, 3948541 },
	{ 25, 12337149 },
	{ 26, 24836863 },
	{ 27, 29114365 },
	{ 27, 54280189 },
	{ 27, 62668797 },
	{ 28, 87834621 },
	{ 28, 96223229 },
	{ 28, 121389053 },
	{ 28, 129777661 },
	{ 29, 254438137 },
	{ 29, 229272313 },
	{ 28, 128936701 },
	{ 28, 128609017 },
	{ 28, 120220409 },
	{ 28, 95054585 },
	{ 27, 61827837 },
	{ 27, 61500153 },
	{ 27, 53111545 },
	{ 27, 27945721 },
	{ 25, 11496189 },
	{ 25, 11168505 },
	{ 25, 2779897 },
	{ 25, 11561721 },
	{ 25, 10775289 },
	{ 26, 29911801 },
	{ 26, 25979641 },
	{ 26, 14183161 },
	{ 26, 10251001 },
	{ 25, 11037433 },
	{ 25, 2910969 },
	{ 20, 431466 },
	{ 25, 3697405 },
	{ 25, 12086013 },
	{ 26, 24309759 },
	{ 27, 28863229 },
	{ 27, 54029053 },
	{ 27, 62417661 },
	{ 28, 87583485 },
	{ 28, 95972093 },
	{ 28, 121137917 },
	{ 28, 129526525 },
	{ 29, 254438393 },
	{ 29, 229272569 },
	{ 28, 128936957 },
	{ 28, 128609273 },
	{ 28, 120220665 },
	{ 28, 95054841 },
	{ 27, 61828093 },
	{ 27, 61500409 },
	{ 27, 53111801 },
	{ 27, 27945977 },
	{ 25, 11496445 },
	{ 25, 11168761 },
	{ 25, 2780153 },
	{ 25, 11561977 },
	{ 25, 10775545 },
	{ 26, 29912057 },
	{ 26, 25979897 },
	{ 26, 14183417 },
	{ 26, 10251257 },
	{ 25, 11037689 },
	{ 25, 2911225 },
	{ 20, 439658 },
	{ 25, 3697661 },
	{ 25, 12086269 },
	{ 26, 24309503 },
	{ 27, 28863485 },
	{ 27, 54029309 },
	{ 27, 62417917 },
	{ 28, 266235641 },
	{ 28, 262041337 },
	{ 28, 249458425 },
	{ 28, 245264121 },
	{ 28, 132017913 },
	{ 28, 127823609 },
	{ 28, 115240697 },
	{ 28, 111046393 },
	{ 27, 64909049 },
	{ 27, 60714745 },
	{ 27, 48131833 },
	{ 27, 43937529 },
	{ 26, 31354617 },
	{ 26, 27160313 },
	{ 26, 14577401 },
	{ 25, 11235069 },
	{ 24, 6188793 },
	{ 24, 1994489 },
	{ 25, 10514169 },
	{ 24, 7630585 },
	{ 25, 15395835 },
	{ 26, 13397753 },
	{ 26, 9989881 },
	{ 24, 6057721 },
	{ 25, 2649849 },
	{ 19, 224234 },
	{ 25, 2911997 },
	{ 25, 11300605 },
	{ 26, 22735871 },
	{ 27, 28077821 },
	{ 27, 53243645 },
	{ 27, 61632253 },
	{ 28, 266235897 },
	{ 28, 262041593 },
	{ 28, 249458681 },
	{ 28, 245264377 },
	{ 28, 132018169 },
	{ 28, 127823865 },
	{ 28, 115240953 },
	{ 28, 111046649 },
	{ 27, 64909305 },
	{ 27, 60715001 },
	{ 27, 48132089 },
	{ 27, 43937785 },
	{ 26, 31354873 },
	{ 26, 27160569 },
	{ 26, 14577657 },
	{ 25, 11235325 },
	{ 24, 6189049 },
	{ 24, 1994745 },
	{ 25, 10514425 },
	{ 24, 7630841 },
	{ 25, 15395579 },
	{ 26, 13398009 },
	{ 26, 9990137 },
	{ 24, 6057977 },
	{ 25, 2650105 },
	{ 19, 228330 },
	{ 25, 2912253 },
	{ 25, 11300861 },
	{ 26, 22735615 },
	{ 27, 28078077 },
	{ 27, 53243901 },
	{ 27, 61632509 },
	{ 28, 266304253 },
	{ 28, 265976569 },
	{ 28, 261782265 },
	{ 28, 249199353 },
	{ 28, 245005049 },
	{ 28, 131758841 },
	{ 28, 127564537 },
	{ 28, 114981625 },
	{ 27, 64977661 },
	{ 27, 64649977 },
	{ 27, 60455673 },
	{ 27, 47872761 },
	{ 26, 31423229 },
	{ 26, 31095545 },
	{ 26, 26901241 },
	{ 26, 14318329 },
	{ 24, 6257405 },
	{ 24, 5929721 },
	{ 24, 1735417 },
	{ 24, 7371513 },
	{ 24, 6585081 },
	{ 25, 13287419 },
	{ 26, 9206521 },
	{ 24, 5798649 },
	{ 24, 1866489 },
	{ 19, 248682 },
	{ 19, 523038 },
	{ 25, 11041533 },
	{ 26, 22200319 },
	{ 27, 27818749 },
	{ 27, 52984573 },
	{ 27, 61373181 },
	{ 28, 86539005 },
	{ 28, 265976825 },
	{ 28, 261782521 },
	{ 28, 249199609 },
	{ 28, 245005305 },
	{ 28, 131759097 },
	{ 28, 127564793 },
	{ 28, 114981881 },
	{ 27, 64977917 },
	{ 27, 64650233 },
	{ 27, 60455929 },
	{ 27, 47873017 },
	{ 26, 31423485 },
	{ 26, 31095801 },
	{ 26, 26901497 },
	{ 26, 14318585 },
	{ 24, 6257661 },
	{ 24, 5929977 },
	{ 24, 1735673 },
	{ 24, 7371769 },
	{ 24, 6585337 },
	{ 25, 13287163 },
	{ 26, 9206777 },
	{ 24, 5798905 },
	{ 24, 1866745 },
	{ 19, 252778 },
	{ 19, 518942 },
	{ 25, 11041789 },
	{ 26, 22200063 },
	{ 27, 27819005 },
	{ 27, 52984829 },
	{ 27, 61373437 },
	{ 28, 86539261 },
	{ 28, 266043133 },
	{ 28, 265191161 },
	{ 28, 260996857 },
	{ 28, 248413945 },
	{ 28, 244219641 },
	{ 28, 130973433 },
	{ 28, 126779129 },
	{ 28, 114196217 },
	{ 27, 64716541 },
	{ 27, 63864569 },
	{ 27, 59670265 },
	{ 27, 47087353 },
	{ 26, 31162109 },
	{ 26, 30310137 },
	{ 26, 26115833 },
	{ 26, 13532921 },
	{ 24, 5996285 },
	{ 24, 5144313 },
	{ 24, 950009 },
	{ 24, 6323961 },
	{ 24, 3440377 },
	{ 25, 6994939 },
	{ 24, 5013241 },
	{ 24, 1605369 },
	{ 19, 256490 },
	{ 19, 514462 },
	{ 24, 6061821 },
	{ 25, 12237823 },
	{ 26, 14450429 },
	{ 26, 27033341 },
	{ 26, 31227645 },
	{ 27, 43810557 },
	{ 27, 48004861 },
	{ 27, 60587773 },
	{ 27, 64782077 },
	{ 28, 248414201 },
	{ 28, 244219897 },
	{ 28, 130973689 },
	{ 28, 126779385 },
	{ 28, 114196473 },
	{ 27, 64716797 },
	{ 27, 63864825 },
	{ 27, 59670521 },
	{ 27, 47087609 },
	{ 26, 31162365 },
	{ 26, 30310393 },
	{ 26, 26116089 },
	{ 26, 13533177 },
	{ 24, 5996541 },
	{ 24, 5144569 },
	{ 24, 950265 },
	{ 24, 6324217 },
	{ 24, 3440633 },
	{ 25, 6994683 },
	{ 24, 5013497 },
	{ 24, 1605625 },
	{ 19, 260586 },
	{ 19, 510366 },
	{ 24, 6062077 },
	{ 25, 12237567 },
	{ 26, 14450685 },
	{ 26, 27033597 },
	{ 26, 31227901 },
	{ 27, 43810813 },
	{ 27, 48005117 },
	{ 27, 60588029 },
	{ 27, 64782333 },
	{ 28, 110919677 },
	{ 28, 115113981 },
	{ 28, 127696893 },
	{ 28, 131891197 },
	{ 28, 245137405 },
	{ 28, 249331709 },
	{ 28, 127838973 },
	{ 28, 127183609 },
	{ 28, 118795001 },
	{ 28, 93629177 },
	{ 27, 60730109 },
	{ 27, 60074745 },
	{ 27, 51686137 },
	{ 27, 26520313 },
	{ 25, 10398461 },
	{ 25, 9743097 },
	{ 25, 1354489 },
	{ 25, 6335225 },
	{ 25, 4762361 },
	{ 25, 9480953 },
	{ 25, 1616633 },
	{ 19, 477546 },
	{ 19, 489758 },
	{ 25, 11578109 },
	{ 25, 11710463 },
	{ 27, 28355325 },
	{ 27, 53521149 },
	{ 27, 61909757 },
	{ 27, 62042111 },
	{ 28, 95464189 },
	{ 28, 120630013 },
	{ 28, 129018621 },
	{ 28, 129150975 },
	{ 29, 496282617 },
	{ 29, 487894009 },
	{ 29, 261401593 },
	{ 29, 253012985 },
	{ 29, 227847161 },
	{ 28, 127839229 },
	{ 28, 127183865 },
	{ 28, 118795257 },
	{ 28, 93629433 },
	{ 27, 60730365 },
	{ 27, 60075001 },
	{ 27, 51686393 },
	{ 27, 26520569 },
	{ 25, 10398717 },
	{ 25, 9743353 },
	{ 25, 1354745 },
	{ 25, 6335481 },
	{ 25, 4762617 },
	{ 25, 9481209 },
	{ 25, 1616889 },
	{ 19, 481642 },
	{ 19, 485662 },
	{ 25, 11578365 },
	{ 25, 11710207 },
	{ 27, 28355581 },
	{ 27, 53521405 },
	{ 27, 61910013 },
	{ 27, 62041855 },
	{ 28, 95464445 },
	{ 28, 120630269 },
	{ 28, 129018877 },
	{ 27, 132951801 },
	{ 27, 130854649 },
	{ 27, 124563193 },
	{ 27, 122466041 },
	{ 27, 65842937 },
	{ 27, 63745785 },
	{ 27, 57454329 },
	{ 27, 55357177 },
	{ 26, 32288505 },
	{ 26, 30191353 },
	{ 26, 23899897 },
	{ 26, 21802745 },
	{ 25, 15511289 },
	{ 25, 13414137 },
	{ 25, 7122681 },
	{ 25, 5025529 },
	{ 23, 2928377 },
	{ 23, 831225 },
	{ 23, 2534395 },
	{ 23, 2666233 },
	{ 23, 2796539 },
	{ 17, 121578 },
	{ 17, 120478 },
	{ 25, 10006269 },
	{ 25, 10136575 },
	{ 27, 26783485 },
	{ 27, 51949309 },
	{ 27, 60337917 },
	{ 27, 60468223 },
	{ 28, 93892349 },
	{ 28, 119058173 },
	{ 28, 127446781 },
	{ 27, 132952057 },
	{ 27, 130854905 },
	{ 27, 124563449 },
	{ 27, 122466297 },
	{ 27, 65843193 },
	{ 27, 63746041 },
	{ 27, 57454585 },
	{ 27, 55357433 },
	{ 26, 32288761 },
	{ 26, 30191609 },
	{ 26, 23900153 },
	{ 26, 21803001 },
	{ 25, 15511545 },
	{ 25, 13414393 },
	{ 25, 7122937 },
	{ 25, 5025785 },
	{ 23, 2928633 },
	{ 23, 831481 },
	{ 23, 2534139 },
	{ 23, 2666489 },
	{ 23, 2796283 },
	{ 17, 122602 },
	{ 17, 119454 },
	{ 25, 10006525 },
	{ 25, 10136319 },
	{ 27, 26783741 },
	{ 27, 51949565 },
	{ 27, 60338173 },
	{ 27, 60467967 },
	{ 28, 93892605 },
	{ 28, 119058429 },
	{ 28, 127447037 },
	{ 27, 133085949 },
	{ 26, 33456127 },
	{ 26, 16744443 },
	{ 26, 16482299 },
	{ 26, 15695867 },
	{ 26, 15433723 },
	{ 26, 8355835 },
	{ 26, 8093691 },
	{ 26, 32422653 },
	{ 25, 12484607 },
	{ 25, 4161531 },
	{ 25, 3899387 },
	{ 25, 15645437 },
	{ 24, 6193151 },
	{ 24, 2064379 },
	{ 24, 1802235 },
	{ 23, 3062525 },
	{ 22, 1474559 },
	{ 22, 491515 },
	{ 18, 255353 },
	{ 18, 130939 },
	{ 17, 127594 },
	{ 17, 65054 },
	{ 24, 622591 },
	{ 24, 4816895 },
	{ 26, 9011199 },
	{ 26, 13205503 },
	{ 26, 25788415 },
	{ 26, 29982719 },
	{ 27, 42565631 },
	{ 27, 46759935 },
	{ 27, 59342847 },
	{ 27, 133086205 },
	{ 26, 33455871 },
	{ 26, 16744187 },
	{ 26, 16482043 },
	{ 26, 15695611 },
	{ 26, 15433467 },
	{ 26, 8355579 },
	{ 26, 8093435 },
	{ 26, 32422909 },
	{ 25, 12484351 },
	{ 25, 4161275 },
	{ 25, 3899131 },
	{ 25, 15645693 },
	{ 24, 6192895 },
	{ 24, 2064123 },
	{ 24, 1801979 },
	{ 23, 3062781 },
	{ 22, 1474303 },
	{ 22, 491259 },
	{ 18, 257401 },
	{ 18, 128891 },
	{ 17, 128618 },
	{ 17, 64030 },
	{ 24, 622335 },
	{ 24, 4816639 },
	{ 26, 9010943 },
	{ 26, 13205247 },
	{ 26, 25788159 },
	{ 26, 29982463 },
	{ 27, 42565375 },
	{ 27, 46759679 },
	{ 27, 59342591 },
	{ 27, 63536895 },
	{ 27, 132562685 },
	{ 26, 16677887 },
	{ 26, 16415743 },
	{ 26, 15629311 },
	{ 26, 15367167 },
	{ 26, 8289279 },
	{ 26, 8027135 },
	{ 26, 7240703 },
	{ 26, 31899389 },
	{ 25, 4094975 },
	{ 25, 3832831 },
	{ 25, 3046399 },
	{ 25, 15122173 },
	{ 24, 1997823 },
	{ 24, 1735679 },
	{ 24, 949247 },
	{ 23, 2539261 },
	{ 22, 424959 },
	{ 22, 162815 },
	{ 22, 2096959 },
	{ 22, 2097003 },
	{ 22, 2096958 },
	{ 22, 359423 },
	{ 22, 1407999 },
	{ 24, 2456575 },
	{ 24, 3505151 },
	{ 24, 6650879 },
	{ 24, 7699455 },
	{ 25, 10845183 },
	{ 25, 11893759 },
	{ 25, 15039487 },
	{ 25, 16088063 },
	{ 26, 27622399 },
	{ 26, 16677631 },
	{ 26, 16415487 },
	{ 26, 15629055 },
	{ 26, 15366911 },
	{ 26, 8289023 },
	{ 26, 8026879 },
	{ 26, 7240447 },
	{ 26, 31899645 },
	{ 25, 4094719 },
	{ 25, 3832575 },
	{ 25, 3046143 },
	{ 25, 15122429 },
	{ 24, 1997567 },
	{ 24, 1735423 },
	{ 24, 948991 },
	{ 23, 2539517 },
	{ 22, 424703 },
	{ 22, 162559 },
	{ 22, 2097135 },
	{ 19, 262107 },
	{ 14, 6862 },
	{ 22, 359167 },
	{ 22, 1407743 },
	{ 24, 2456319 },
	{ 24, 3504895 },
	{ 24, 6650623 },
	{ 24, 7699199 },
	{ 25, 10844927 },
	{ 25, 11893503 },
	{ 25, 15039231 },
	{ 25, 16087807 },
	{ 26, 27622143 },
	{ 26, 28670719 },
	{ 26, 31816447 },
	{ 26, 32865023 },
	{ 26, 61176575 },
	{ 26, 62225151 },
	{ 26, 65370879 },
	{ 26, 66419455 },
	{ 26, 31485951 },
	{ 26, 28340223 },
	{ 26, 31648509 },
	{ 25, 15757311 },
	{ 25, 14708735 },
	{ 25, 11563007 },
	{ 25, 14871293 },
	{ 24, 7368703 },
	{ 24, 6320127 },
	{ 24, 3174399 },
	{ 23, 2288381 },
	{ 18, 114047 },
	{ 18, 131023 },
	{ 14, 6798 },
	{ 21, 1048431 },
	{ 18, 114559 },
	{ 24, 2191359 },
	{ 24, 3239935 },
	{ 24, 6385663 },
	{ 24, 7434239 },
	{ 25, 10579967 },
	{ 25, 11628543 },
	{ 25, 14774271 },
	{ 25, 15822847 },
	{ 26, 27357183 },
	{ 26, 28405759 },
	{ 26, 31551487 },
	{ 26, 66088703 },
	{ 26, 65040127 },
	{ 26, 61894399 },
	{ 26, 60845823 },
	{ 26, 32534271 },
	{ 26, 31485695 },
	{ 26, 28339967 },
	{ 26, 31648765 },
	{ 25, 15757055 },
	{ 25, 14708479 },
	{ 25, 11562751 },
	{ 25, 14871549 },
	{ 24, 7368447 },
	{ 24, 6319871 },
	{ 24, 3174143 },
	{ 23, 2288637 },
	{ 18, 111999 },
	{ 14, 16266 },
	{ 23, 60413 },
	{ 18, 131039 },
	{ 18, 112511 },
	{ 24, 2191103 },
	{ 24, 3239679 },
	{ 24, 6385407 },
	{ 24, 7433983 },
	{ 25, 10579711 },
	{ 25, 11628287 },
	{ 25, 14774015 },
	{ 25, 15822591 },
	{ 26, 27356927 },
	{ 26, 28405503 },
	{ 26, 31551231 },
	{ 26, 32599807 },
	{ 26, 60911359 },
	{ 26, 61959935 },
	{ 26, 65105663 },
	{ 26, 66154239 },
	{ 26, 31747071 },
	{ 26, 28601343 },
	{ 26, 32173821 },
	{ 25, 16018431 },
	{ 25, 14969855 },
	{ 25, 11824127 },
	{ 25, 15396605 },
	{ 24, 7629823 },
	{ 24, 6581247 },
	{ 24, 3435519 },
	{ 23, 2813693 },
	{ 22, 1338367 },
	{ 14, 16330 },
	{ 19, 262110 },
	{ 17, 65483 },
	{ 20, 524091 },
	{ 22, 224255 },
	{ 22, 1272831 },
	{ 24, 2321407 },
	{ 24, 3369983 },
	{ 24, 6515711 },
	{ 24, 7564287 },
	{ 25, 10710015 },
	{ 25, 11758591 },
	{ 25, 14904319 },
	{ 25, 15952895 },
	{ 26, 27487231 },
	{ 26, 66349823 },
	{ 26, 65301247 },
	{ 26, 62155519 },
	{ 26, 61106943 },
	{ 26, 32795391 },
	{ 26, 31746815 },
	{ 26, 28601087 },
	{ 26, 32174077 },
	{ 25, 16018175 },
	{ 25, 14969599 },
	{ 25, 11823871 },
	{ 25, 15396861 },
	{ 24, 7629567 },
	{ 24, 6580991 },
	{ 24, 3435263 },
	{ 23, 2813949 },
	{ 22, 1338111 },
	{ 22, 2096575 },
	{ 19, 261982 },
	{ 18, 130987 },
	{ 20, 524267 },
	{ 22, 223999 },
	{ 22, 1272575 },
	{ 24, 2321151 },
	{ 24, 3369727 },
	{ 24, 6515455 },
	{ 24, 7564031 },
	{ 25, 10709759 },
	{ 25, 11758335 },
	{ 25, 14904063 },
	{ 25, 15952639 },
	{ 26, 27486975 },
	{ 26, 28535551 },
	{ 26, 31681279 },
	{ 26, 32729855 },
	{ 26, 61041407 },
	{ 26, 62089983 },
	{ 26, 65235711 },
	{ 26, 66284287 },
	{ 28, 127073021 },
	{ 27, 63455231 },
	{ 27, 59260927 },
	{ 27, 46678015 },
	{ 27, 59964157 },
	{ 26, 29900799 },
	{ 26, 25706495 },
	{ 26, 13123583 },
	{ 25, 9632509 },
	{ 24, 4734975 },
	{ 24, 540671 },
	{ 16, 32366 },
	{ 20, 523963 },
	{ 17, 64891 },
	{ 22, 147451 },
	{ 22, 1196027 },
	{ 22, 1523711 },
	{ 24, 3293179 },
	{ 24, 6438907 },
	{ 24, 7487483 },
	{ 24, 7815167 },
	{ 25, 11681787 },
	{ 25, 14827515 },
	{ 25, 15876091 },
	{ 25, 16203775 },
	{ 26, 28459003 },
	{ 26, 31604731 },
	{ 26, 32653307 },
	{ 26, 60964859 },
	{ 26, 62013435 },
	{ 26, 65159163 },
	{ 26, 66207739 },
	{ 26, 66535423 },
	{ 27, 63454975 },
	{ 27, 59260671 },
	{ 27, 46677759 },
	{ 27, 59964413 },
	{ 26, 29900543 },
	{ 26, 25706239 },
	{ 26, 13123327 },
	{ 25, 9632765 },
	{ 24, 4734719 },
	{ 24, 540415 },
	{ 16, 31342 },
	{ 21, 1047995 },
	{ 17, 62843 },
	{ 22, 147195 },
	{ 22, 1195771 },
	{ 22, 1523455 },
	{ 24, 3292923 },
	{ 24, 6438651 },
	{ 24, 7487227 },
	{ 24, 7814911 },
	{ 25, 11681531 },
	{ 25, 14827259 },
	{ 25, 15875835 },
	{ 25, 16203519 },
	{ 26, 28458747 },
	{ 26, 31604475 },
	{ 26, 32653051 },
	{ 26, 60964603 },
	{ 26, 62013179 },
	{ 26, 65158907 },
	{ 26, 66207483 },
	{ 26, 66535167 },
	{ 27, 63716351 },
	{ 27, 59522047 },
	{ 27, 46939135 },
	{ 27, 60489469 },
	{ 26, 30161919 },
	{ 26, 25967615 },
	{ 26, 13384703 },
	{ 25, 10157821 },
	{ 24, 4996095 },
	{ 24, 801791 },
	{ 16, 30446 },
	{ 23, 2817785 },
	{ 22, 1326075 },
	{ 23, 2555641 },
	{ 22, 408571 },
	{ 22, 1457147 },
	{ 24, 2505723 },
	{ 24, 3554299 },
	{ 24, 6700027 },
	{ 24, 7748603 },
	{ 25, 10894331 },
	{ 25, 11942907 },
	{ 25, 15088635 },
	{ 25, 16137211 },
	{ 26, 27671547 },
	{ 26, 28720123 },
	{ 26, 31865851 },
	{ 26, 32914427 },
	{ 26, 61225979 },
	{ 26, 62274555 },
	{ 26, 65420283 },
	{ 26, 66468859 },
	{ 27, 63716095 },
	{ 27, 59521791 },
	{ 27, 46938879 },
	{ 27, 60489725 },
	{ 26, 30161663 },
	{ 26, 25967359 },
	{ 26, 13384447 },
	{ 25, 10158077 },
	{ 24, 4995839 },
	{ 24, 801535 },
	{ 16, 29422 },
	{ 23, 2818041 },
	{ 22, 1325819 },
	{ 23, 2555897 },
	{ 22, 408315 },
	{ 22, 1456891 },
	{ 24, 2505467 },
	{ 24, 3554043 },
	{ 24, 6699771 },
	{ 24, 7748347 },
	{ 25, 10894075 },
	{ 25, 11942651 },
	{ 25, 15088379 },
	{ 25, 16136955 },
	{ 26, 27671291 },
	{ 26, 28719867 },
	{ 26, 31865595 },
	{ 26, 32914171 },
	{ 26, 61225723 },
	{ 26, 62274299 },
	{ 26, 65420027 },
	{ 26, 66468603 },
	{ 27, 64499711 },
	{ 27, 60305407 },
	{ 27, 47722495 },
	{ 27, 43528191 },
	{ 26, 30945279 },
	{ 26, 26750975 },
	{ 26, 14168063 },
	{ 26, 23440125 },
	{ 24, 5779455 },
	{ 24, 1585151 },
	{ 18, 96622 },
	{ 24, 798715 },
	{ 24, 4730875 },
	{ 24, 2371579 },
	{ 24, 3158011 },
	{ 24, 667643 },
	{ 24, 4861947 },
	{ 24, 5189631 },
	{ 26, 13250555 },
	{ 26, 25833467 },
	{ 26, 30027771 },
	{ 26, 30355455 },
	{ 27, 46804987 },
	{ 27, 59387899 },
	{ 27, 63582203 },
	{ 27, 63909887 },
	{ 28, 113913851 },
	{ 28, 126496763 },
	{ 28, 130691067 },
	{ 28, 243937275 },
	{ 28, 248131579 },
	{ 28, 260714491 },
	{ 27, 64499455 },
	{ 27, 60305151 },
	{ 27, 47722239 },
	{ 27, 43527935 },
	{ 26, 30945023 },
	{ 26, 26750719 },
	{ 26, 14167807 },
	{ 26, 23440381 },
	{ 24, 5779199 },
	{ 24, 1584895 },
	{ 18, 92526 },
	{ 24, 798459 },
	{ 24, 4730619 },
	{ 24, 2371323 },
	{ 24, 3157755 },
	{ 24, 667387 },
	{ 24, 4861691 },
	{ 24, 5189375 },
	{ 26, 13250299 },
	{ 26, 25833211 },
	{ 26, 30027515 },
	{ 26, 30355199 },
	{ 27, 46804731 },
	{ 27, 59387643 },
	{ 27, 63581947 },
	{ 27, 63909631 },
	{ 28, 113913595 },
	{ 28, 126496507 },
	{ 28, 130690811 },
	{ 28, 243937019 },
	{ 28, 248131323 },
	{ 28, 260714235 },
	{ 27, 64760831 },
	{ 27, 60566527 },
	{ 27, 47983615 },
	{ 27, 43789311 },
	{ 26, 31206399 },
	{ 26, 27012095 },
	{ 26, 14429183 },
	{ 26, 24489725 },
	{ 24, 6040575 },
	{ 24, 1846271 },
	{ 18, 88558 },
	{ 24, 1584123 },
	{ 24, 4991995 },
	{ 26, 14003961 },
	{ 24, 3419131 },
	{ 24, 6302715 },
	{ 24, 928763 },
	{ 24, 5123067 },
	{ 24, 5975039 },
	{ 26, 13511675 },
	{ 26, 26094587 },
	{ 26, 30288891 },
	{ 26, 31140863 },
	{ 27, 47066107 },
	{ 27, 59649019 },
	{ 27, 63843323 },
	{ 27, 64695295 },
	{ 28, 114174971 },
	{ 28, 126757883 },
	{ 28, 130952187 },
	{ 28, 244198395 },
	{ 28, 248392699 },
	{ 27, 64760575 },
	{ 27, 60566271 },
	{ 27, 47983359 },
	{ 27, 43789055 },
	{ 26, 31206143 },
	{ 26, 27011839 },
	{ 26, 14428927 },
	{ 26, 24489981 },
	{ 24, 6040319 },
	{ 24, 1846015 },
	{ 18, 84462 },
	{ 24, 1583867 },
	{ 24, 4991739 },
	{ 26, 14004217 },
	{ 24, 3418875 },
	{ 24, 6302459 },
	{ 24, 928507 },
	{ 24, 5122811 },
	{ 24, 5974783 },
	{ 26, 13511419 },
	{ 26, 26094331 },
	{ 26, 30288635 },
	{ 26, 31140607 },
	{ 27, 47065851 },
	{ 27, 59648763 },
	{ 27, 63843067 },
	{ 27, 64695039 },
	{ 27, 122298367 },
	{ 27, 65675263 },
	{ 27, 63578111 },
	{ 27, 57286655 },
	{ 27, 55189503 },
	{ 26, 32120831 },
	{ 26, 30023679 },
	{ 26, 23732223 },
	{ 26, 21635071 },
	{ 25, 15343615 },
	{ 25, 13246463 },
	{ 25, 6955007 },
	{ 25, 4857855 },
	{ 23, 2760703 },
	{ 23, 663551 },
	{ 17, 64366 },
	{ 22, 466939 },
	{ 22, 1449979 },
	{ 24, 2301947 },
	{ 24, 3284987 },
	{ 22, 1646587 },
	{ 22, 1843195 },
	{ 22, 434171 },
	{ 22, 1482747 },
	{ 22, 1564671 },
	{ 24, 3579899 },
	{ 24, 6725627 },
	{ 24, 7774203 },
	{ 24, 7856127 },
	{ 25, 11968507 },
	{ 25, 15114235 },
	{ 25, 16162811 },
	{ 25, 16244735 },
	{ 26, 28745723 },
	{ 26, 31891451 },
	{ 26, 32940027 },
	{ 26, 61251579 },
	{ 26, 62300155 },
	{ 26, 65445883 },
	{ 26, 66494459 },
	{ 26, 21634815 },
	{ 25, 15343359 },
	{ 25, 13246207 },
	{ 25, 6954751 },
	{ 25, 4857599 },
	{ 23, 2760447 },
	{ 23, 663295 },
	{ 17, 60270 },
	{ 22, 466683 },
	{ 22, 1449723 },
	{ 24, 2301691 },
	{ 24, 3284731 },
	{ 22, 1646331 },
	{ 22, 1842939 },
	{ 22, 433915 },
	{ 22, 1482491 },
	{ 22, 1564415 },
	{ 24, 3579643 },
	{ 24, 6725371 },
	{ 24, 7773947 },
	{ 24, 7855871 },
	{ 25, 11968251 },
	{ 25, 15113979 },
	{ 25, 16162555 },
	{ 25, 16244479 },
	{ 26, 28745467 },
	{ 26, 31891195 },
	{ 26, 32939771 },
	{ 26, 61251323 },
	{ 26, 62299899 },
	{ 26, 65445627 },
	{ 26, 66494203 },
	{ 26, 66576127 },
	{ 25, 15408127 },
	{ 25, 13310975 },
	{ 25, 7019519 },
	{ 25, 4922367 },
	{ 23, 2825215 },
	{ 23, 728063 },
	{ 17, 56302 },
	{ 23, 662523 },
	{ 22, 1514491 },
	{ 24, 2497531 },
	{ 24, 3349499 },
	{ 24, 6429691 },
	{ 22, 1907707 },
	{ 23, 2628603 },
	{ 22, 498683 },
	{ 22, 1547259 },
	{ 23, 2808831 },
	{ 24, 3644411 },
	{ 24, 6790139 },
	{ 24, 7838715 },
	{ 25, 10984443 },
	{ 25, 12033019 },
	{ 25, 15178747 },
	{ 25, 16227323 },
	{ 26, 27761659 },
	{ 26, 28810235 },
	{ 26, 31955963 },
	{ 26, 33004539 },
	{ 26, 61316091 },
	{ 26, 62364667 },
	{ 26, 65510395 },
	{ 26, 66558971 },
	{ 25, 15407871 },
	{ 25, 13310719 },
	{ 25, 7019263 },
	{ 25, 4922111 },
	{ 23, 2824959 },
	{ 23, 727807 },
	{ 17, 52206 },
	{ 23, 662267 },
	{ 22, 1514235 },
	{ 24, 2497275 },
	{ 24, 3349243 },
	{ 24, 6429435 },
	{ 22, 1907451 },
	{ 23, 2628347 },
	{ 22, 498427 },
	{ 22, 1547003 },
	{ 23, 2808575 },
	{ 24, 3644155 },
	{ 24, 6789883 },
	{ 24, 7838459 },
	{ 25, 10984187 },
	{ 25, 12032763 },
	{ 25, 15178491 },
	{ 25, 16227067 },
	{ 26, 27761403 },
	{ 26, 28809979 },
	{ 26, 31955707 },
	{ 26, 33004283 },
	{ 26, 61315835 },
	{ 26, 62364411 },
	{ 26, 65510139 },
	{ 26, 66558715 },
	{ 25, 15601663 },
	{ 25, 13504511 },
	{ 25, 7213055 },
	{ 25, 5115903 },
	{ 23, 3018751 },
	{ 23, 921599 },
	{ 18, 62830 },
	{ 23, 724987 },
	{ 23, 2756603 },
	{ 24, 2559995 },
	{ 24, 3543035 },
	{ 24, 6492155 },
	{ 24, 7475195 },
	{ 23, 2691067 },
	{ 23, 2887675 },
	{ 23, 692219 },
	{ 23, 2789371 },
	{ 23, 2871295 },
	{ 25, 6983675 },
	{ 25, 13275131 },
	{ 25, 15372283 },
	{ 25, 15454207 },
	{ 26, 23760891 },
	{ 26, 30052347 },
	{ 26, 32149499 },
	{ 26, 32231423 },
	{ 27, 57315323 },
	{ 27, 63606779 },
	{ 26, 32378623 },
	{ 26, 30281471 },
	{ 26, 23990015 },
	{ 26, 21892863 },
	{ 25, 15601407 },
	{ 25, 13504255 },
	{ 25, 7212799 },
	{ 25, 5115647 },
	{ 23, 3018495 },
	{ 23, 921343 },
	{ 18, 54638 },
	{ 23, 724731 },
	{ 23, 2756347 },
	{ 24, 2559739 },
	{ 24, 3542779 },
	{ 24, 6491899 },
	{ 24, 7474939 },
	{ 23, 2690811 },
	{ 23, 2887419 },
	{ 23, 691963 },
	{ 23, 2789115 },
	{ 23, 2871039 },
	{ 25, 6983419 },
	{ 25, 13274875 },
	{ 25, 15372027 },
	{ 25, 15453951 },
	{ 26, 23760635 },
	{ 26, 30052091 },
	{ 26, 32149243 },
	{ 26, 32231167 },
	{ 27, 57315067 },
	{ 27, 63606523 },
	{ 26, 32443391 },
	{ 26, 30346239 },
	{ 26, 24054783 },
	{ 26, 21957631 },
	{ 25, 15666175 },
	{ 25, 13569023 },
	{ 25, 7277567 },
	{ 25, 5180415 },
	{ 23, 3083263 },
	{ 23, 986111 },
	{ 18, 46574 },
	{ 23, 920571 },
	{ 23, 2821115 },
	{ 25, 4852731 },
	{ 24, 3607547 },
	{ 24, 6687739 },
	{ 24, 7539707 },
	{ 25, 10619899 },
	{ 23, 2952187 },
	{ 23, 3673083 },
	{ 23, 756731 },
	{ 23, 2853883 },
	{ 23, 3066879 },
	{ 25, 7048187 },
	{ 25, 13339643 },
	{ 25, 15436795 },
	{ 25, 15649791 },
	{ 26, 23825403 },
	{ 26, 30116859 },
	{ 26, 32214011 },
	{ 26, 32427007 },
	{ 27, 57379835 },
	{ 26, 32443135 },
	{ 26, 30345983 },
	{ 26, 24054527 },
	{ 26, 21957375 },
	{ 25, 15665919 },
	{ 25, 13568767 },
	{ 25, 7277311 },
	{ 25, 5180159 },
	{ 23, 3083007 },
	{ 23, 985855 },
	{ 18, 38382 },
	{ 23, 920315 },
	{ 23, 2820859 },
	{ 25, 4852475 },
	{ 24, 3607291 },
	{ 24, 6687483 },
	{ 24, 7539451 },
	{ 25, 10619643 },
	{ 23, 2951931 },
	{ 23, 3672827 },
	{ 23, 756475 },
	{ 23, 2853627 },
	{ 23, 3066623 },
	{ 25, 7047931 },
	{ 25, 13339387 },
	{ 25, 15436539 },
	{ 25, 15649535 },
	{ 26, 23825147 },
	{ 26, 30116603 },
	{ 26, 32213755 },
	{ 26, 32426751 },
	{ 26, 27691007 },
	{ 25, 16156671 },
	{ 25, 15108095 },
	{ 25, 11962367 },
	{ 25, 10913791 },
	{ 24, 7768063 },
	{ 24, 6719487 },
	{ 24, 3573759 },
	{ 24, 2525183 },
	{ 22, 1476607 },
	{ 22, 428031 },
	{ 16, 30574 },
	{ 21, 247803 },
	{ 21, 755707 },
	{ 23, 1230843 },
	{ 23, 1738747 },
	{ 22, 1689595 },
	{ 22, 1935355 },
	{ 23, 2672635 },
	{ 23, 2918395 },
	{ 21, 935931 },
	{ 21, 985083 },
	{ 21, 239611 },
	{ 21, 763899 },
	{ 21, 784383 },
	{ 23, 1812475 },
	{ 23, 3385339 },
	{ 23, 3909627 },
	{ 23, 3930111 },
	{ 24, 6006779 },
	{ 24, 7579643 },
	{ 24, 8103931 },
	{ 24, 8124415 },
	{ 25, 14395387 },
	{ 25, 15968251 },
	{ 25, 16492539 },
	{ 25, 30648315 },
	{ 24, 8361979 },
	{ 24, 7329787 },
	{ 24, 3573503 },
	{ 24, 2524927 },
	{ 22, 1476351 },
	{ 22, 427775 },
	{ 16, 22382 },
	{ 21, 247547 },
	{ 21, 755451 },
	{ 23, 1230587 },
	{ 23, 1738491 },
	{ 22, 1689339 },
	{ 22, 1935099 },
	{ 23, 2672379 },
	{ 23, 2918139 },
	{ 21, 935675 },
	{ 21, 984827 },
	{ 21, 239355 },
	{ 21, 763643 },
	{ 21, 784127 },
	{ 23, 1812219 },
	{ 23, 3385083 },
	{ 23, 3909371 },
	{ 23, 3929855 },
	{ 24, 6006523 },
	{ 24, 7579387 },
	{ 24, 8103675 },
	{ 24, 8124159 },
	{ 25, 14395131 },
	{ 25, 15967995 },
	{ 25, 16492283 },
	{ 25, 30648059 },
	{ 24, 8361723 },
	{ 24, 7329531 },
	{ 24, 3589119 },
	{ 24, 2540543 },
	{ 22, 1491967 },
	{ 22, 443391 },
	{ 16, 14318 },
	{ 22, 427003 },
	{ 21, 771067 },
	{ 23, 1278971 },
	{ 23, 1754107 },
	{ 23, 3310587 },
	{ 22, 1950715 },
	{ 23, 2720763 },
	{ 23, 2933755 },
	{ 23, 3703803 },
	{ 21, 1000443 },
	{ 22, 1704955 },
	{ 21, 254971 },
	{ 21, 779259 },
	{ 22, 1487871 },
	{ 23, 1827835 },
	{ 23, 3400699 },
	{ 23, 3924987 },
	{ 24, 5497851 },
	{ 24, 6022139 },
	{ 24, 7595003 },
	{ 24, 8119291 },
	{ 25, 13886459 },
	{ 25, 14410747 },
	{ 25, 15983611 },
	{ 25, 16507899 },
	{ 24, 8311803 },
	{ 24, 7312379 },
	{ 24, 4183035 },
	{ 24, 2540287 },
	{ 22, 1491711 },
	{ 22, 443135 },
	{ 16, 6126 },
	{ 22, 426747 },
	{ 21, 770811 },
	{ 23, 1278715 },
	{ 23, 1753851 },
	{ 23, 3310331 },
	{ 22, 1950459 },
	{ 23, 2720507 },
	{ 23, 2933499 },
	{ 23, 3703547 },
	{ 21, 1000187 },
	{ 22, 1704699 },
	{ 21, 254715 },
	{ 21, 779003 },
	{ 22, 1487615 },
	{ 23, 1827579 },
	{ 23, 3400443 },
	{ 23, 3924731 },
	{ 24, 5497595 },
	{ 24, 6021883 },
	{ 24, 7594747 },
	{ 24, 8119035 },
	{ 23, 4055551 },
	{ 23, 3793407 },
	{ 23, 3006975 },
	{ 23, 2744831 },
	{ 22, 1958399 },
	{ 22, 1696255 },
	{ 22, 909823 },
	{ 22, 647679 },
	{ 20, 385535 },
	{ 20, 123391 },
	{ 15, 19822 },
	{ 20, 111099 },
	{ 20, 369147 },
	{ 21, 324091 },
	{ 21, 451067 },
	{ 21, 831995 },
	{ 21, 958971 },
	{ 21, 684539 },
	{ 21, 745979 },
	{ 21, 930299 },
	{ 21, 991739 },
	{ 20, 430587 },
	{ 20, 442875 },
	{ 20, 109051 },
	{ 20, 371195 },
	{ 20, 376319 },
	{ 22, 895483 },
	{ 22, 1681915 },
	{ 22, 1944059 },
	{ 22, 1949183 },
	{ 23, 2992635 },
	{ 23, 3779067 },
	{ 23, 4056317 },
	{ 23, 3794173 },
	{ 23, 3007741 },
	{ 23, 2745597 },
	{ 22, 1959165 },
	{ 22, 1697021 },
	{ 22, 910589 },
	{ 22, 648445 },
	{ 20, 386301 },
	{ 20, 124157 },
	{ 15, 3354 },
	{ 20, 111865 },
	{ 20, 369913 },
	{ 21, 324857 },
	{ 21, 451833 },
	{ 21, 832761 },
	{ 21, 959737 },
	{ 21, 685305 },
	{ 21, 746745 },
	{ 21, 931065 },
	{ 21, 992505 },
	{ 20, 431353 },
	{ 20, 443641 },
	{ 20, 429305 },
	{ 20, 433401 },
	{ 20, 448765 },
	{ 22, 3891449 },
	{ 22, 3830009 },
	{ 22, 1735929 },
	{ 22, 1800445 },
	{ 23, 3596537 },
	{ 23, 3469561 },
	{ 23, 4038905 },
	{ 23, 3780857 },
	{ 23, 3006713 },
	{ 23, 2748665 },
	{ 22, 2072825 },
	{ 22, 1814777 },
	{ 22, 1040633 },
	{ 22, 782585 },
	{ 20, 386557 },
	{ 20, 124413 },
	{ 15, 19738 },
	{ 20, 112121 },
	{ 20, 370169 },
	{ 21, 325113 },
	{ 21, 452089 },
	{ 21, 833017 },
	{ 21, 959993 },
	{ 21, 685561 },
	{ 21, 747001 },
	{ 21, 931321 },
	{ 21, 992761 },
	{ 20, 431609 },
	{ 20, 443897 },
	{ 20, 429561 },
	{ 20, 433657 },
	{ 20, 449021 },
	{ 22, 3891705 },
	{ 22, 3830265 },
	{ 22, 1736185 },
	{ 22, 1800701 },
	{ 23, 3596793 },
	{ 23, 3469817 },
	{ 23, 4039161 },
	{ 23, 3781113 },
	{ 23, 3006969 },
	{ 23, 2748921 },
	{ 22, 2073081 },
	{ 22, 1815033 },
	{ 22, 1040889 },
	{ 22, 782841 },
	{ 22, 1561341 },
	{ 22, 512765 },
	{ 17, 11674 },
	{ 22, 496377 },
	{ 22, 1495801 },
	{ 24, 2527993 },
	{ 23, 1823481 },
	{ 23, 3379961 },
	{ 23, 3855097 },
	{ 24, 8381177 },
	{ 23, 3003129 },
	{ 23, 3773177 },
	{ 23, 3986169 },
	{ 22, 2089721 },
	{ 22, 1041145 },
	{ 22, 1970937 },
	{ 22, 4145913 },
	{ 22, 1798905 },
	{ 22, 1991421 },
	{ 24, 15303417 },
	{ 24, 8241913 },
	{ 24, 7205625 },
	{ 24, 7987965 },
	{ 25, 13861625 },
	{ 24, 8110841 },
	{ 25, 15106809 },
	{ 25, 11977465 },
	{ 25, 10978041 },
	{ 24, 7848697 },
	{ 24, 7242489 },
	{ 24, 4113145 },
	{ 24, 3113721 },
	{ 22, 2081529 },
	{ 22, 513021 },
	{ 17, 16362 },
	{ 22, 496633 },
	{ 22, 1496057 },
	{ 24, 2528249 },
	{ 23, 1823737 },
	{ 23, 3380217 },
	{ 23, 3855353 },
	{ 24, 8381433 },
	{ 23, 3003385 },
	{ 23, 3773433 },
	{ 23, 3986425 },
	{ 22, 2089977 },
	{ 22, 1041401 },
	{ 22, 1971193 },
	{ 22, 4146169 },
	{ 22, 1799161 },
	{ 22, 1991677 },
	{ 24, 15303673 },
	{ 24, 8242169 },
	{ 24, 7205881 },
	{ 24, 7988221 },
	{ 25, 13861881 },
	{ 24, 8111097 },
	{ 25, 15107065 },
	{ 25, 11977721 },
	{ 25, 10978297 },
	{ 24, 7848953 },
	{ 24, 7242745 },
	{ 24, 4113401 },
	{ 24, 3113977 },
	{ 22, 2081785 },
	{ 22, 956157 },
	{ 17, 32746 },
	{ 22, 513785 },
	{ 22, 1545977 },
	{ 24, 2545401 },
	{ 24, 3577593 },
	{ 23, 3397369 },
	{ 23, 3905273 },
	{ 24, 5428985 },
	{ 24, 8365817 },
	{ 23, 3790585 },
	{ 23, 4036345 },
	{ 22, 2094845 },
	{ 22, 2074361 },
	{ 22, 1025785 },
	{ 22, 4130553 },
	{ 22, 4081401 },
	{ 22, 1996537 },
	{ 22, 2057981 },
	{ 24, 8226553 },
	{ 24, 7980793 },
	{ 24, 7993081 },
	{ 24, 8251133 },
	{ 24, 8095481 },
	{ 24, 7587577 },
	{ 25, 11962105 },
	{ 25, 10929913 },
	{ 24, 7833337 },
	{ 24, 6801145 },
	{ 24, 4097785 },
	{ 24, 3065593 },
	{ 22, 2066169 },
	{ 22, 1033977 },
	{ 17, 49002 },
	{ 22, 514041 },
	{ 22, 1546233 },
	{ 24, 2545657 },
	{ 24, 3577849 },
	{ 23, 3397625 },
	{ 23, 3905529 },
	{ 24, 5429241 },
	{ 24, 8366073 },
	{ 23, 3790841 },
	{ 23, 4036601 },
	{ 22, 2095101 },
	{ 22, 2074617 },
	{ 22, 1026041 },
	{ 22, 4130809 },
	{ 22, 4081657 },
	{ 22, 1996793 },
	{ 22, 2058237 },
	{ 24, 8226809 },
	{ 24, 7981049 },
	{ 24, 7993337 },
	{ 24, 8251389 },
	{ 24, 8095737 },
	{ 24, 7587833 },
	{ 25, 11962361 },
	{ 25, 10930169 },
	{ 24, 7833593 },
	{ 24, 6801401 },
	{ 24, 4098041 },
	{ 24, 3065849 },
	{ 22, 2066425 },
	{ 22, 1034233 },
	{ 17, 65386 },
	{ 24, 3820281 },
	{ 24, 6245113 },
	{ 26, 10373881 },
	{ 26, 14371577 },
	{ 26, 26888953 },
	{ 25, 15682297 },
	{ 26, 21908217 },
	{ 26, 23808761 },
	{ 26, 33262329 },
	{ 25, 16206585 },
	{ 26, 16485113 },
	{ 24, 8309501 },
	{ 24, 8096505 },
	{ 24, 3902201 },
	{ 24, 16255737 },
	{ 24, 15534841 },
	{ 24, 8243961 },
	{ 24, 15305469 },
	{ 26, 31853305 },
	{ 26, 28773113 },
	{ 26, 33016569 },
	{ 26, 32180985 },
	{ 26, 30280441 },
	{ 26, 24054521 },
	{ 27, 43649785 },
	{ 26, 31132409 },
	{ 26, 27134713 },
	{ 26, 14617337 },
	{ 26, 12192505 },
	{ 24, 8063737 },
	{ 24, 4066041 },
	{ 19, 81386 },
	{ 24, 3820537 },
	{ 24, 6245369 },
	{ 26, 10374137 },
	{ 26, 14371833 },
	{ 26, 26889209 },
	{ 25, 15682553 },
	{ 26, 21908473 },
	{ 26, 23809017 },
	{ 26, 33262585 },
	{ 25, 16206841 },
	{ 26, 16485369 },
	{ 24, 8309757 },
	{ 24, 8096761 },
	{ 24, 3902457 },
	{ 24, 16255993 },
	{ 24, 15535097 },
	{ 24, 8244217 },
	{ 24, 15305725 },
	{ 26, 31853561 },
	{ 26, 28773369 },
	{ 26, 33016825 },
	{ 26, 32181241 },
	{ 26, 30280697 },
	{ 26, 24054777 },
	{ 27, 43650041 },
	{ 26, 31132665 },
	{ 26, 27134969 },
	{ 26, 14617593 },
	{ 26, 12192761 },
	{ 24, 8063993 },
	{ 24, 4066297 },
	{ 19, 97770 },
	{ 24, 3886841 },
	{ 24, 8015609 },
	{ 26, 10440441 },
	{ 26, 14569209 },
	{ 26, 26955513 },
	{ 26, 31084281 },
	{ 26, 21974777 },
	{ 26, 24006393 },
	{ 26, 30101241 },
	{ 26, 33197817 },
	{ 26, 29003513 },
	{ 26, 16420601 },
	{ 24, 8113917 },
	{ 24, 8031993 },
	{ 24, 3837689 },
	{ 24, 15470329 },
	{ 24, 15273721 },
	{ 24, 15322873 },
	{ 24, 15568637 },
	{ 26, 28708601 },
	{ 26, 27725561 },
	{ 26, 32116473 },
	{ 26, 30084857 },
	{ 26, 23990009 },
	{ 26, 21958393 },
	{ 26, 31067897 },
	{ 26, 26939129 },
	{ 26, 14552825 },
	{ 26, 10424057 },
	{ 24, 7999225 },
	{ 24, 3870457 },
	{ 19, 114026 },
	{ 24, 3887097 },
	{ 24, 8015865 },
	{ 26, 10440697 },
	{ 26, 14569465 },
	{ 26, 26955769 },
	{ 26, 31084537 },
	{ 26, 21975033 },
	{ 26, 24006649 },
	{ 26, 30101497 },
	{ 26, 33198073 },
	{ 26, 29003769 },
	{ 26, 16420857 },
	{ 24, 8114173 },
	{ 24, 8032249 },
	{ 24, 3837945 },
	{ 24, 15470585 },
	{ 24, 15273977 },
	{ 24, 15323129 },
	{ 24, 15568893 },
	{ 26, 28708857 },
	{ 26, 27725817 },
	{ 26, 32116729 },
	{ 26, 30085113 },
	{ 26, 23990265 },
	{ 26, 21958649 },
	{ 26, 31068153 },
	{ 26, 26939385 },
	{ 26, 14553081 },
	{ 26, 10424313 },
	{ 24, 7999481 },
	{ 24, 3870713 },
	{ 19, 130410 },
	{ 24, 4086521 },
	{ 24, 8084217 },
	{ 26, 12212985 },
	{ 26, 14637817 },
	{ 26, 27155193 },
	{ 26, 31152889 },
	{ 27, 64985849 },
	{ 26, 24075001 },
	{ 26, 30300921 },
	{ 26, 32201465 },
	{ 26, 31431417 },
	{ 26, 27237113 },
	{ 26, 14654201 },
	{ 24, 8051453 },
	{ 24, 6265593 },
	{ 24, 2071289 },
	{ 24, 15211257 },
	{ 24, 8198905 },
	{ 24, 15588089 },
	{ 24, 16358141 },
	{ 26, 27663097 },
	{ 25, 16194297 },
	{ 26, 30022393 },
	{ 26, 23796473 },
	{ 26, 21895929 },
	{ 25, 15670009 },
	{ 26, 26876665 },
	{ 26, 14359289 },
	{ 26, 10361593 },
	{ 24, 6232825 },
	{ 24, 3807993 },
	{ 19, 208874 },
	{ 24, 4086777 },
	{ 24, 8084473 },
	{ 26, 12213241 },
	{ 26, 14638073 },
	{ 26, 27155449 },
	{ 26, 31153145 },
	{ 27, 64986105 },
	{ 26, 24075257 },
	{ 26, 30301177 },
	{ 26, 32201721 },
	{ 26, 31431673 },
	{ 26, 27237369 },
	{ 26, 14654457 },
	{ 24, 8051709 },
	{ 24, 6265849 },
	{ 24, 2071545 },
	{ 24, 15211513 },
	{ 24, 8199161 },
	{ 24, 15588345 },
	{ 24, 16358397 },
	{ 26, 27663353 },
	{ 25, 16194553 },
	{ 26, 30022649 },
	{ 26, 23796729 },
	{ 26, 21896185 },
	{ 25, 15670265 },
	{ 26, 26876921 },
	{ 26, 14359545 },
	{ 26, 10361849 },
	{ 24, 6233081 },
	{ 24, 3808249 },
	{ 19, 225258 },
	{ 24, 4153081 },
	{ 24, 8281849 },
	{ 26, 12279545 },
	{ 26, 16408313 },
	{ 26, 27221753 },
	{ 26, 31350521 },
	{ 27, 43736825 },
	{ 27, 64921337 },
	{ 26, 30367481 },
	{ 26, 32399097 },
	{ 26, 31448829 },
	{ 26, 31366905 },
	{ 26, 27172601 },
	{ 26, 14589689 },
	{ 24, 6283005 },
	{ 24, 6201081 },
	{ 24, 2006777 },
	{ 24, 8134393 },
	{ 24, 7937785 },
	{ 24, 16375545 },
	{ 24, 16621309 },
	{ 25, 16129785 },
	{ 25, 15146745 },
	{ 26, 23731961 },
	{ 26, 21700345 },
	{ 25, 15605497 },
	{ 25, 13573881 },
	{ 26, 14294777 },
	{ 26, 10166009 },
	{ 24, 6168313 },
	{ 24, 2039545 },
	{ 19, 241514 },
	{ 24, 4153337 },
	{ 24, 8282105 },
	{ 26, 12279801 },
	{ 26, 16408569 },
	{ 26, 27222009 },
	{ 26, 31350777 },
	{ 27, 43737081 },
	{ 27, 64921593 },
	{ 26, 30367737 },
	{ 26, 32399353 },
	{ 26, 31449085 },
	{ 26, 31367161 },
	{ 26, 27172857 },
	{ 26, 14589945 },
	{ 24, 6283261 },
	{ 24, 6201337 },
	{ 24, 2007033 },
	{ 24, 8134649 },
	{ 24, 7938041 },
	{ 24, 16375801 },
	{ 24, 16621565 },
	{ 25, 16130041 },
	{ 25, 15147001 },
	{ 26, 23732217 },
	{ 26, 21700601 },
	{ 25, 15605753 },
	{ 25, 13574137 },
	{ 26, 14295033 },
	{ 26, 10166265 },
	{ 24, 6168569 },
	{ 24, 2039801 },
	{ 19, 257898 },
	{ 24, 3809277 },
	{ 24, 8003581 },
	{ 26, 12197885 },
	{ 26, 16392189 },
	{ 26, 28975101 },
	{ 26, 33169405 },
	{ 27, 45752317 },
	{ 27, 49946621 },
	{ 27, 62529533 },
	{ 27, 66723837 },
	{ 28, 112861181 },
	{ 28, 125512445 },
	{ 28, 124660473 },
	{ 28, 107883257 },
	{ 28, 57551609 },
	{ 26, 24849149 },
	{ 26, 23997177 },
	{ 26, 7219961 },
	{ 26, 31468281 },
	{ 26, 28584697 },
	{ 26, 66530041 },
	{ 27, 63711993 },
	{ 27, 60304121 },
	{ 27, 47983353 },
	{ 28, 86518521 },
	{ 27, 61614841 },
	{ 27, 54012665 },
	{ 27, 29108985 },
	{ 28, 40381177 },
	{ 26, 23866105 },
	{ 26, 7875321 },
	{ 20, 339434 },
	{ 26, 8137469 },
	{ 26, 33369081 },
	{ 28, 49884153 },
	{ 28, 65874937 },
	{ 28, 115944441 },
	{ 28, 125643769 },
	{ 29, 175713273 },
	{ 29, 191704057 },
	{ 29, 258878457 },
	{ 28, 129838073 },
	{ 29, 191769593 },
	{ 28, 125512701 },
	{ 28, 124660729 },
	{ 28, 107883513 },
	{ 28, 57551865 },
	{ 26, 24849405 },
	{ 26, 23997433 },
	{ 26, 7220217 },
	{ 26, 31468537 },
	{ 26, 28584953 },
	{ 26, 66530297 },
	{ 27, 63712249 },
	{ 27, 60304377 },
	{ 27, 47983609 },
	{ 28, 86518777 },
	{ 27, 61615097 },
	{ 27, 54012921 },
	{ 27, 29109241 },
	{ 28, 40381433 },
	{ 26, 23866361 },
	{ 26, 7875577 },
	{ 20, 355818 },
	{ 26, 8137725 },
	{ 26, 24914941 },
	{ 28, 50147065 },
	{ 28, 66662137 },
	{ 28, 116207353 },
	{ 28, 132722425 },
	{ 29, 175976185 },
	{ 29, 192491257 },
	{ 29, 242036473 },
	{ 29, 258617081 },
	{ 29, 241839865 },
	{ 29, 191508217 },
	{ 28, 124727037 },
	{ 28, 124399353 },
	{ 28, 107622137 },
	{ 28, 57290489 },
	{ 26, 24063741 },
	{ 26, 23736057 },
	{ 26, 6958841 },
	{ 26, 28323577 },
	{ 26, 27537145 },
	{ 27, 63450873 },
	{ 27, 59518713 },
	{ 27, 47722233 },
	{ 27, 43790073 },
	{ 27, 61353721 },
	{ 27, 53227257 },
	{ 27, 28847865 },
	{ 27, 20721401 },
	{ 26, 23604985 },
	{ 26, 7089913 },
	{ 20, 372074 },
	{ 26, 7876349 },
	{ 26, 24653565 },
	{ 28, 50147321 },
	{ 28, 66662393 },
	{ 28, 116207609 },
	{ 28, 132722681 },
	{ 29, 175976441 },
	{ 29, 192491513 },
	{ 29, 242036729 },
	{ 29, 258617337 },
	{ 29, 241840121 },
	{ 29, 191508473 },
	{ 28, 124727293 },
	{ 28, 124399609 },
	{ 28, 107622393 },
	{ 28, 57290745 },
	{ 26, 24063997 },
	{ 26, 23736313 },
	{ 26, 6959097 },
	{ 26, 28323833 },
	{ 26, 27537401 },
	{ 27, 63451129 },
	{ 27, 59518969 },
	{ 27, 47722489 },
	{ 27, 43790329 },
	{ 27, 61353977 },
	{ 27, 53227513 },
	{ 27, 28848121 },
	{ 27, 20721657 },
	{ 26, 23605241 },
	{ 26, 7090169 },
	{ 20, 388458 },
	{ 26, 7876605 },
	{ 26, 24653821 },
	{ 28, 41431037 },
	{ 28, 66927353 },
	{ 28, 116996857 },
	{ 28, 132987641 },
	{ 29, 264125177 },
	{ 29, 255736569 },
	{ 29, 230570745 },
	{ 29, 222182137 },
	{ 28, 129907449 },
	{ 28, 121518841 },
	{ 28, 96353017 },
	{ 28, 87964409 },
	{ 27, 62798585 },
	{ 27, 54409977 },
	{ 27, 29244153 },
	{ 26, 23804669 },
	{ 25, 12466937 },
	{ 25, 4078329 },
	{ 26, 27278073 },
	{ 25, 16005881 },
	{ 26, 32178171 },
	{ 27, 46938873 },
	{ 27, 43531001 },
	{ 26, 31210233 },
	{ 27, 52968185 },
	{ 27, 28064505 },
	{ 27, 20462329 },
	{ 25, 12335865 },
	{ 26, 6830841 },
	{ 19, 235498 },
	{ 26, 7092989 },
	{ 26, 23870205 },
	{ 27, 47906815 },
	{ 28, 66927609 },
	{ 28, 116997113 },
	{ 28, 132987897 },
	{ 29, 264125433 },
	{ 29, 255736825 },
	{ 29, 230571001 },
	{ 29, 222182393 },
	{ 28, 129907705 },
	{ 28, 121519097 },
	{ 28, 96353273 },
	{ 28, 87964665 },
	{ 27, 62798841 },
	{ 27, 54410233 },
	{ 27, 29244409 },
	{ 26, 23804925 },
	{ 25, 12467193 },
	{ 25, 4078585 },
	{ 26, 27278329 },
	{ 25, 16006137 },
	{ 26, 32177915 },
	{ 27, 46939129 },
	{ 27, 43531257 },
	{ 26, 31210489 },
	{ 27, 52968441 },
	{ 27, 28064761 },
	{ 27, 20462585 },
	{ 25, 12336121 },
	{ 26, 6831097 },
	{ 19, 243690 },
	{ 26, 7093245 },
	{ 26, 23870461 },
	{ 27, 47906559 },
	{ 28, 57424893 },
	{ 28, 117260025 },
	{ 28, 133775097 },
	{ 29, 490356473 },
	{ 29, 263864057 },
	{ 29, 255475449 },
	{ 29, 230309625 },
	{ 28, 129974013 },
	{ 28, 129646329 },
	{ 28, 121257721 },
	{ 28, 96091897 },
	{ 27, 62865149 },
	{ 27, 62537465 },
	{ 27, 54148857 },
	{ 27, 28983033 },
	{ 25, 12533501 },
	{ 25, 12205817 },
	{ 25, 3817209 },
	{ 25, 15744761 },
	{ 25, 14958329 },
	{ 26, 30079995 },
	{ 27, 42745593 },
	{ 26, 30949113 },
	{ 26, 27016953 },
	{ 27, 27803385 },
	{ 27, 19676921 },
	{ 25, 12074745 },
	{ 25, 3948281 },
	{ 19, 251754 },
	{ 26, 6831869 },
	{ 26, 23609085 },
	{ 27, 47381503 },
	{ 28, 57163517 },
	{ 28, 117260281 },
	{ 28, 133775353 },
	{ 29, 490356729 },
	{ 29, 263864313 },
	{ 29, 255475705 },
	{ 29, 230309881 },
	{ 28, 129974269 },
	{ 28, 129646585 },
	{ 28, 121257977 },
	{ 28, 96092153 },
	{ 27, 62865405 },
	{ 27, 62537721 },
	{ 27, 54149113 },
	{ 27, 28983289 },
	{ 25, 12533757 },
	{ 25, 12206073 },
	{ 25, 3817465 },
	{ 25, 15745017 },
	{ 25, 14958585 },
	{ 26, 30079739 },
	{ 27, 42745849 },
	{ 26, 30949369 },
	{ 26, 27017209 },
	{ 27, 27803641 },
	{ 27, 19677177 },
	{ 25, 12075001 },
	{ 25, 3948537 },
	{ 19, 259946 },
	{ 26, 6832125 },
	{ 26, 23609341 },
	{ 27, 47381247 },
	{ 28, 57163773 },
	{ 28, 107495421 },
	{ 28, 134048505 },
	{ 29, 497969913 },
	{ 29, 489581305 },
	{ 29, 263088889 },
	{ 29, 254700281 },
	{ 29, 229534457 },
	{ 28, 129723133 },
	{ 28, 128871161 },
	{ 28, 120482553 },
	{ 28, 95316729 },
	{ 27, 62614269 },
	{ 27, 61762297 },
	{ 27, 53373689 },
	{ 27, 28207865 },
	{ 25, 12282621 },
	{ 25, 11430649 },
	{ 25, 3042041 },
	{ 25, 14707449 },
	{ 25, 11823865 },
	{ 26, 23785467 },
	{ 26, 30173945 },
	{ 26, 26766073 },
	{ 26, 14445305 },
	{ 27, 19426041 },
	{ 25, 11299577 },
	{ 25, 3697401 },
	{ 20, 431594 },
	{ 25, 3959549 },
	{ 25, 12348157 },
	{ 26, 24834047 },
	{ 27, 29125373 },
	{ 27, 54291197 },
	{ 27, 62679805 },
	{ 28, 87845629 },
	{ 28, 96234237 },
	{ 28, 121400061 },
	{ 28, 129788669 },
	{ 29, 229534713 },
	{ 28, 129723389 },
	{ 28, 128871417 },
	{ 28, 120482809 },
	{ 28, 95316985 },
	{ 27, 62614525 },
	{ 27, 61762553 },
	{ 27, 53373945 },
	{ 27, 28208121 },
	{ 25, 12282877 },
	{ 25, 11430905 },
	{ 25, 3042297 },
	{ 25, 14707705 },
	{ 25, 11824121 },
	{ 26, 23785211 },
	{ 26, 30174201 },
	{ 26, 26766329 },
	{ 26, 14445561 },
	{ 27, 19426297 },
	{ 25, 11299833 },
	{ 25, 3697657 },
	{ 20, 439786 },
	{ 25, 3959805 },
	{ 25, 12348413 },
	{ 26, 24833791 },
	{ 27, 29125629 },
	{ 27, 54291453 },
	{ 27, 62680061 },
	{ 28, 87845885 },
	{ 28, 96234493 },
	{ 28, 121400317 },
	{ 28, 129788925 },
	{ 29, 254439161 },
	{ 29, 229273337 },
	{ 28, 128937725 },
	{ 28, 128610041 },
	{ 28, 120221433 },
	{ 28, 95055609 },
	{ 27, 61828861 },
	{ 27, 61501177 },
	{ 27, 53112569 },
	{ 27, 27946745 },
	{ 25, 11497213 },
	{ 25, 11169529 },
	{ 25, 2780921 },
	{ 25, 11562745 },
	{ 25, 10776313 },
	{ 26, 29912825 },
	{ 26, 25980665 },
	{ 26, 14184185 },
	{ 26, 10252025 },
	{ 25, 11038457 },
	{ 25, 2911993 },
	{ 20, 447850 },
	{ 25, 3698429 },
	{ 25, 12087037 },
	{ 26, 24308735 },
	{ 27, 28864253 },
	{ 27, 54030077 },
	{ 27, 62418685 },
	{ 28, 87584509 },
	{ 28, 95973117 },
	{ 28, 121138941 },
	{ 28, 129527549 },
	{ 29, 254439417 },
	{ 29, 229273593 },
	{ 28, 128937981 },
	{ 28, 128610297 },
	{ 28, 120221689 },
	{ 28, 95055865 },
	{ 27, 61829117 },
	{ 27, 61501433 },
	{ 27, 53112825 },
	{ 27, 27947001 },
	{ 25, 11497469 },
	{ 25, 11169785 },
	{ 25, 2781177 },
	{ 25, 11563001 },
	{ 25, 10776569 },
	{ 26, 29913081 },
	{ 26, 25980921 },
	{ 26, 14184441 },
	{ 26, 10252281 },
	{ 25, 11038713 },
	{ 25, 2912249 },
	{ 20, 456042 },
	{ 25, 3698685 },
	{ 25, 12087293 },
	{ 26, 24308479 },
	{ 27, 28864509 },
	{ 27, 54030333 },
	{ 27, 62418941 },
	{ 28, 266238713 },
	{ 28, 262044409 },
	{ 28, 249461497 },
	{ 28, 245267193 },
	{ 28, 132020985 },
	{ 28, 127826681 },
	{ 28, 115243769 },
	{ 28, 111049465 },
	{ 27, 64912121 },
	{ 27, 60717817 },
	{ 27, 48134905 },
	{ 27, 43940601 },
	{ 26, 31357689 },
	{ 26, 27163385 },
	{ 26, 14580473 },
	{ 25, 11238141 },
	{ 24, 6191865 },
	{ 24, 1997561 },
	{ 25, 10517241 },
	{ 24, 7633657 },
	{ 25, 15384571 },
	{ 26, 13400825 },
	{ 26, 9992953 },
	{ 24, 6060793 },
	{ 25, 2652921 },
	{ 19, 248810 },
	{ 19, 523166 },
	{ 25, 11303677 },
	{ 26, 22724607 },
	{ 27, 28080893 },
	{ 27, 53246717 },
	{ 27, 61635325 },
	{ 28, 266238969 },
	{ 28, 262044665 },
	{ 28, 249461753 },
	{ 28, 245267449 },
	{ 28, 132021241 },
	{ 28, 127826937 },
	{ 28, 115244025 },
	{ 28, 111049721 },
	{ 27, 64912377 },
	{ 27, 60718073 },
	{ 27, 48135161 },
	{ 27, 43940857 },
	{ 26, 31357945 },
	{ 26, 27163641 },
	{ 26, 14580729 },
	{ 25, 11238397 },
	{ 24, 6192121 },
	{ 24, 1997817 },
	{ 25, 10517497 },
	{ 24, 7633913 },
	{ 25, 15384315 },
	{ 26, 13401081 },
	{ 26, 9993209 },
	{ 24, 6061049 },
	{ 25, 2653177 },
	{ 19, 252906 },
	{ 19, 519070 },
	{ 25, 11303933 },
	{ 26, 22724351 },
	{ 27, 28081149 },
	{ 27, 53246973 },
	{ 27, 61635581 },
	{ 28, 266305277 },
	{ 28, 265977593 },
	{ 28, 261783289 },
	{ 28, 249200377 },
	{ 28, 245006073 },
	{ 28, 131759865 },
	{ 28, 127565561 },
	{ 28, 114982649 },
	{ 27, 64978685 },
	{ 27, 64651001 },
	{ 27, 60456697 },
	{ 27, 47873785 },
	{ 26, 31424253 },
	{ 26, 31096569 },
	{ 26, 26902265 },
	{ 26, 14319353 },
	{ 24, 6258429 },
	{ 24, 5930745 },
	{ 24, 1736441 },
	{ 24, 7372537 },
	{ 24, 6586105 },
	{ 25, 13286395 },
	{ 26, 9207545 },
	{ 24, 5799673 },
	{ 24, 1867513 },
	{ 19, 256874 },
	{ 19, 514846 },
	{ 25, 11042557 },
	{ 26, 22199295 },
	{ 27, 27819773 },
	{ 27, 52985597 },
	{ 27, 61374205 },
	{ 28, 86540029 },
	{ 28, 265977849 },
	{ 28, 261783545 },
	{ 28, 249200633 },
	{ 28, 245006329 },
	{ 28, 131760121 },
	{ 28, 127565817 },
	{ 28, 114982905 },
	{ 27, 64978941 },
	{ 27, 64651257 },
	{ 27, 60456953 },
	{ 27, 47874041 },
	{ 26, 31424509 },
	{ 26, 31096825 },
	{ 26, 26902521 },
	{ 26, 14319609 },
	{ 24, 6258685 },
	{ 24, 5931001 },
	{ 24, 1736697 },
	{ 24, 7372793 },
	{ 24, 6586361 },
	{ 25, 13286139 },
	{ 26, 9207801 },
	{ 24, 5799929 },
	{ 24, 1867769 },
	{ 19, 260970 },
	{ 19, 510750 },
	{ 25, 11042813 },
	{ 26, 22199039 },
	{ 27, 27820029 },
	{ 27, 52985853 },
	{ 27, 61374461 },
	{ 28, 86540285 },
	{ 28, 94928893 },
	{ 28, 120094717 },
	{ 28, 128483325 },
	{ 29, 496806649 },
	{ 29, 488418041 },
	{ 29, 261925625 },
	{ 29, 253537017 },
	{ 29, 228371193 },
	{ 28, 129411837 },
	{ 28, 127707897 },
	{ 28, 119319289 },
	{ 28, 94153465 },
	{ 27, 62302973 },
	{ 27, 60599033 },
	{ 27, 52210425 },
	{ 27, 27044601 },
	{ 25, 11971325 },
	{ 25, 10267385 },
	{ 25, 1878777 },
	{ 25, 12626681 },
	{ 25, 6859513 },
	{ 25, 6991867 },
	{ 25, 10005241 },
	{ 25, 3189497 },
	{ 19, 477674 },
	{ 19, 489886 },
	{ 25, 12102397 },
	{ 25, 12234751 },
	{ 27, 28879613 },
	{ 27, 54045437 },
	{ 27, 62434045 },
	{ 27, 62566399 },
	{ 28, 95988477 },
	{ 28, 121154301 },
	{ 28, 129542909 },
	{ 28, 129675263 },
	{ 29, 488418297 },
	{ 29, 261925881 },
	{ 29, 253537273 },
	{ 29, 228371449 },
	{ 28, 129412093 },
	{ 28, 127708153 },
	{ 28, 119319545 },
	{ 28, 94153721 },
	{ 27, 62303229 },
	{ 27, 60599289 },
	{ 27, 52210681 },
	{ 27, 27044857 },
	{ 25, 11971581 },
	{ 25, 10267641 },
	{ 25, 1879033 },
	{ 25, 12626937 },
	{ 25, 6859769 },
	{ 25, 6991611 },
	{ 25, 10005497 },
	{ 25, 3189753 },
	{ 19, 481770 },
	{ 19, 485790 },
	{ 25, 12102653 },
	{ 25, 12234495 },
	{ 27, 28879869 },
	{ 27, 54045693 },
	{ 27, 62434301 },
	{ 27, 62566143 },
	{ 28, 95988733 },
	{ 28, 121154557 },
	{ 28, 129543165 },
	{ 28, 129675007 },
	{ 29, 496283385 },
	{ 29, 487894777 },
	{ 29, 261402361 },
	{ 29, 253013753 },
	{ 29, 227847929 },
	{ 28, 127839997 },
	{ 28, 127184633 },
	{ 28, 118796025 },
	{ 28, 93630201 },
	{ 27, 60731133 },
	{ 27, 60075769 },
	{ 27, 51687161 },
	{ 27, 26521337 },
	{ 25, 10399485 },
	{ 25, 9744121 },
	{ 25, 1355513 },
	{ 25, 6336249 },
	{ 25, 4763385 },
	{ 25, 9481977 },
	{ 25, 1617657 },
	{ 19, 485738 },
	{ 19, 481566 },
	{ 25, 11579133 },
	{ 25, 11709439 },
	{ 27, 28356349 },
	{ 27, 53522173 },
	{ 27, 61910781 },
	{ 27, 62041087 },
	{ 28, 95465213 },
	{ 28, 120631037 },
	{ 28, 129019645 },
	{ 28, 129149951 },
	{ 29, 496283641 },
	{ 29, 487895033 },
	{ 29, 261402617 },
	{ 29, 253014009 },
	{ 29, 227848185 },
	{ 28, 127840253 },
	{ 28, 127184889 },
	{ 28, 118796281 },
	{ 28, 93630457 },
	{ 27, 60731389 },
	{ 27, 60076025 },
	{ 27, 51687417 },
	{ 27, 26521593 },
	{ 25, 10399741 },
	{ 25, 9744377 },
	{ 25, 1355769 },
	{ 25, 6336505 },
	{ 25, 4763641 },
	{ 25, 9482233 },
	{ 25, 1617913 },
	{ 19, 489834 },
	{ 19, 477470 },
	{ 25, 11579389 },
	{ 25, 11709183 },
	{ 27, 28356605 },
	{ 27, 53522429 },
	{ 27, 61911037 },
	{ 27, 62040831 },
	{ 28, 95465469 },
	{ 28, 120631293 },
	{ 28, 129019901 },
	{ 27, 132954873 },
	{ 26, 33521659 },
	{ 26, 33259515 },
	{ 26, 32473083 },
	{ 26, 32210939 },
	{ 26, 25133051 },
	{ 26, 24870907 },
	{ 26, 24084475 },
	{ 26, 32291577 },
	{ 25, 12550139 },
	{ 25, 12287995 },
	{ 25, 11501563 },
	{ 25, 15514361 },
	{ 24, 6258683 },
	{ 24, 5996539 },
	{ 24, 5210107 },
	{ 23, 2931449 },
	{ 22, 1540091 },
	{ 22, 1277947 },
	{ 23, 2669305 },
	{ 22, 1409019 },
	{ 17, 127722 },
	{ 17, 65182 },
	{ 24, 884735 },
	{ 24, 5079039 },
	{ 26, 9273343 },
	{ 26, 13467647 },
	{ 26, 26050559 },
	{ 26, 30244863 },
	{ 27, 42827775 },
	{ 27, 47022079 },
	{ 27, 59604991 },
	{ 27, 132955129 },
	{ 26, 33521403 },
	{ 26, 33259259 },
	{ 26, 32472827 },
	{ 26, 32210683 },
	{ 26, 25132795 },
	{ 26, 24870651 },
	{ 26, 24084219 },
	{ 26, 32291833 },
	{ 25, 12549883 },
	{ 25, 12287739 },
	{ 25, 11501307 },
	{ 25, 15514617 },
	{ 24, 6258427 },
	{ 24, 5996283 },
	{ 24, 5209851 },
	{ 23, 2931705 },
	{ 22, 1539835 },
	{ 22, 1277691 },
	{ 23, 2669561 },
	{ 22, 1408763 },
	{ 17, 128746 },
	{ 17, 64158 },
	{ 24, 884479 },
	{ 24, 5078783 },
	{ 26, 9273087 },
	{ 26, 13467391 },
	{ 26, 26050303 },
	{ 26, 30244607 },
	{ 27, 42827519 },
	{ 27, 47021823 },
	{ 27, 59604735 },
	{ 27, 133086973 },
	{ 26, 33455103 },
	{ 26, 16743419 },
	{ 26, 16481275 },
	{ 26, 15694843 },
	{ 26, 15432699 },
	{ 26, 8354811 },
	{ 26, 8092667 },
	{ 26, 32423677 },
	{ 25, 12483583 },
	{ 25, 4160507 },
	{ 25, 3898363 },
	{ 25, 15646461 },
	{ 24, 6192127 },
	{ 24, 2063355 },
	{ 24, 1801211 },
	{ 23, 3063549 },
	{ 22, 1473535 },
	{ 22, 490491 },
	{ 18, 259449 },
	{ 18, 126843 },
	{ 17, 129642 },
	{ 17, 63006 },
	{ 24, 621567 },
	{ 24, 4815871 },
	{ 26, 9010175 },
	{ 26, 13204479 },
	{ 26, 25787391 },
	{ 26, 29981695 },
	{ 27, 42564607 },
	{ 27, 46758911 },
	{ 27, 59341823 },
	{ 27, 133087229 },
	{ 26, 33454847 },
	{ 26, 16743163 },
	{ 26, 16481019 },
	{ 26, 15694587 },
	{ 26, 15432443 },
	{ 26, 8354555 },
	{ 26, 8092411 },
	{ 26, 32423933 },
	{ 25, 12483327 },
	{ 25, 4160251 },
	{ 25, 3898107 },
	{ 25, 15646717 },
	{ 24, 6191871 },
	{ 24, 2063099 },
	{ 24, 1800955 },
	{ 23, 3063805 },
	{ 22, 1473279 },
	{ 22, 490235 },
	{ 18, 261497 },
	{ 18, 124795 },
	{ 17, 130666 },
	{ 17, 61982 },
	{ 24, 621311 },
	{ 24, 4815615 },
	{ 26, 9009919 },
	{ 26, 13204223 },
	{ 26, 25787135 },
	{ 26, 29981439 },
	{ 27, 42564351 },
	{ 27, 46758655 },
	{ 27, 59341567 },
	{ 27, 63535871 },
	{ 27, 132573949 },
	{ 26, 16674815 },
	{ 26, 16412671 },
	{ 26, 15626239 },
	{ 26, 15364095 },
	{ 26, 8286207 },
	{ 26, 8024063 },
	{ 26, 7237631 },
	{ 26, 31910653 },
	{ 25, 4091903 },
	{ 25, 3829759 },
	{ 25, 3043327 },
	{ 25, 15133437 },
	{ 24, 1994751 },
	{ 24, 1732607 },
	{ 24, 946175 },
	{ 23, 2550525 },
	{ 22, 421887 },
	{ 22, 159743 },
	{ 21, 1048383 },
	{ 21, 1048427 },
	{ 21, 1048382 },
	{ 22, 356351 },
	{ 22, 1404927 },
	{ 24, 2453503 },
	{ 24, 3502079 },
	{ 24, 6647807 },
	{ 24, 7696383 },
	{ 25, 10842111 },
	{ 25, 11890687 },
	{ 25, 15036415 },
	{ 25, 16084991 },
	{ 26, 27619327 },
	{ 26, 16674559 },
	{ 26, 16412415 },
	{ 26, 15625983 },
	{ 26, 15363839 },
	{ 26, 8285951 },
	{ 26, 8023807 },
	{ 26, 7237375 },
	{ 26, 31910909 },
	{ 25, 4091647 },
	{ 25, 3829503 },
	{ 25, 3043071 },
	{ 25, 15133693 },
	{ 24, 1994495 },
	{ 24, 1732351 },
	{ 24, 945919 },
	{ 23, 2550781 },
	{ 22, 421631 },
	{ 22, 159487 },
	{ 21, 1048559 },
	{ 18, 131035 },
	{ 13, 4046 },
	{ 22, 2096767 },
	{ 22, 1404671 },
	{ 24, 2453247 },
	{ 24, 3501823 },
	{ 24, 6647551 },
	{ 24, 7696127 },
	{ 25, 10841855 },
	{ 25, 11890431 },
	{ 25, 15036159 },
	{ 25, 16084735 },
	{ 26, 27619071 },
	{ 26, 28667647 },
	{ 26, 31813375 },
	{ 26, 32861951 },
	{ 26, 61173503 },
	{ 26, 62222079 },
	{ 26, 65367807 },
	{ 26, 66416383 },
	{ 26, 31484927 },
	{ 26, 28339199 },
	{ 26, 31649533 },
	{ 25, 15756287 },
	{ 25, 14707711 },
	{ 25, 11561983 },
	{ 25, 14872317 },
	{ 24, 7367679 },
	{ 24, 6319103 },
	{ 24, 3173375 },
	{ 23, 2289405 },
	{ 18, 109951 },
	{ 17, 65487 },
	{ 13, 3982 },
	{ 20, 524143 },
	{ 18, 110463 },
	{ 24, 2190335 },
	{ 24, 3238911 },
	{ 24, 6384639 },
	{ 24, 7433215 },
	{ 25, 10578943 },
	{ 25, 11627519 },
	{ 25, 14773247 },
	{ 25, 15821823 },
	{ 26, 27356159 },
	{ 26, 28404735 },
	{ 26, 31550463 },
	{ 26, 66087679 },
	{ 26, 65039103 },
	{ 26, 61893375 },
	{ 26, 60844799 },
	{ 26, 32533247 },
	{ 26, 31484671 },
	{ 26, 28338943 },
	{ 26, 31649789 },
	{ 25, 15756031 },
	{ 25, 14707455 },
	{ 25, 11561727 },
	{ 25, 14872573 },
	{ 24, 7367423 },
	{ 24, 6318847 },
	{ 24, 3173119 },
	{ 23, 2289661 },
	{ 18, 107903 },
	{ 18, 130991 },
	{ 23, 61437 },
	{ 17, 65503 },
	{ 18, 108415 },
	{ 24, 2190079 },
	{ 24, 3238655 },
	{ 24, 6384383 },
	{ 24, 7432959 },
	{ 25, 10578687 },
	{ 25, 11627263 },
	{ 25, 14772991 },
	{ 25, 15821567 },
	{ 26, 27355903 },
	{ 26, 28404479 },
	{ 26, 31550207 },
	{ 26, 32598783 },
	{ 26, 60910335 },
	{ 26, 61958911 },
	{ 26, 65104639 },
	{ 26, 66153215 },
	{ 26, 31735807 },
	{ 26, 28590079 },
	{ 26, 32176893 },
	{ 25, 16007167 },
	{ 25, 14958591 },
	{ 25, 11812863 },
	{ 25, 15399677 },
	{ 24, 7618559 },
	{ 24, 6569983 },
	{ 24, 3424255 },
	{ 23, 2816765 },
	{ 22, 1327103 },
	{ 20, 523967 },
	{ 18, 131038 },
	{ 16, 32715 },
	{ 19, 261947 },
	{ 22, 212991 },
	{ 22, 1261567 },
	{ 24, 2310143 },
	{ 24, 3358719 },
	{ 24, 6504447 },
	{ 24, 7553023 },
	{ 25, 10698751 },
	{ 25, 11747327 },
	{ 25, 14893055 },
	{ 25, 15941631 },
	{ 26, 27475967 },
	{ 26, 66338559 },
	{ 26, 65289983 },
	{ 26, 62144255 },
	{ 26, 61095679 },
	{ 26, 32784127 },
	{ 26, 31735551 },
	{ 26, 28589823 },
	{ 26, 32177149 },
	{ 25, 16006911 },
	{ 25, 14958335 },
	{ 25, 11812607 },
	{ 25, 15399933 },
	{ 24, 7618303 },
	{ 24, 6569727 },
	{ 24, 3423999 },
	{ 23, 2817021 },
	{ 22, 1326847 },
	{ 21, 1047999 },
	{ 18, 130910 },
	{ 17, 65451 },
	{ 19, 262123 },
	{ 22, 212735 },
	{ 22, 1261311 },
	{ 24, 2309887 },
	{ 24, 3358463 },
	{ 24, 6504191 },
	{ 24, 7552767 },
	{ 25, 10698495 },
	{ 25, 11747071 },
	{ 25, 14892799 },
	{ 25, 15941375 },
	{ 26, 27475711 },
	{ 26, 28524287 },
	{ 26, 31670015 },
	{ 26, 32718591 },
	{ 26, 61030143 },
	{ 26, 62078719 },
	{ 26, 65224447 },
	{ 26, 66273023 },
	{ 28, 127074045 },
	{ 27, 63454207 },
	{ 27, 59259903 },
	{ 27, 46676991 },
	{ 27, 59965181 },
	{ 26, 29899775 },
	{ 26, 25705471 },
	{ 26, 13122559 },
	{ 25, 9633533 },
	{ 24, 4733951 },
	{ 24, 539647 },
	{ 16, 30318 },
	{ 19, 261819 },
	{ 17, 60795 },
	{ 22, 146427 },
	{ 22, 1195003 },
	{ 22, 1522687 },
	{ 24, 3292155 },
	{ 24, 6437883 },
	{ 24, 7486459 },
	{ 24, 7814143 },
	{ 25, 11680763 },
	{ 25, 14826491 },
	{ 25, 15875067 },
	{ 25, 16202751 },
	{ 26, 28457979 },
	{ 26, 31603707 },
	{ 26, 32652283 },
	{ 26, 60963835 },
	{ 26, 62012411 },
	{ 26, 65158139 },
	{ 26, 66206715 },
	{ 26, 66534399 },
	{ 27, 63453951 },
	{ 27, 59259647 },
	{ 27, 46676735 },
	{ 27, 59965437 },
	{ 26, 29899519 },
	{ 26, 25705215 },
	{ 26, 13122303 },
	{ 25, 9633789 },
	{ 24, 4733695 },
	{ 24, 539391 },
	{ 16, 29294 },
	{ 20, 523707 },
	{ 17, 58747 },
	{ 22, 146171 },
	{ 22, 1194747 },
	{ 22, 1522431 },
	{ 24, 3291899 },
	{ 24, 6437627 },
	{ 24, 7486203 },
	{ 24, 7813887 },
	{ 25, 11680507 },
	{ 25, 14826235 },
	{ 25, 15874811 },
	{ 25, 16202495 },
	{ 26, 28457723 },
	{ 26, 31603451 },
	{ 26, 32652027 },
	{ 26, 60963579 },
	{ 26, 62012155 },
	{ 26, 65157883 },
	{ 26, 66206459 },
	{ 26, 66534143 },
	{ 27, 63713279 },
	{ 27, 59518975 },
	{ 27, 46936063 },
	{ 27, 42741759 },
	{ 26, 30158847 },
	{ 26, 25964543 },
	{ 26, 13381631 },
	{ 26, 20294397 },
	{ 24, 4993023 },
	{ 24, 798719 },
	{ 16, 24302 },
	{ 24, 5614329 },
	{ 22, 1323003 },
	{ 24, 5090041 },
	{ 22, 405499 },
	{ 22, 1454075 },
	{ 24, 2502651 },
	{ 24, 3551227 },
	{ 24, 6696955 },
	{ 24, 7745531 },
	{ 25, 10891259 },
	{ 25, 11939835 },
	{ 25, 15085563 },
	{ 25, 16134139 },
	{ 26, 27668475 },
	{ 26, 28717051 },
	{ 26, 31862779 },
	{ 26, 32911355 },
	{ 26, 61222907 },
	{ 26, 62271483 },
	{ 26, 65417211 },
	{ 26, 66465787 },
	{ 27, 63713023 },
	{ 27, 59518719 },
	{ 27, 46935807 },
	{ 27, 42741503 },
	{ 26, 30158591 },
	{ 26, 25964287 },
	{ 26, 13381375 },
	{ 26, 20294653 },
	{ 24, 4992767 },
	{ 24, 798463 },
	{ 16, 23278 },
	{ 24, 5614585 },
	{ 22, 1322747 },
	{ 24, 5090297 },
	{ 22, 405243 },
	{ 22, 1453819 },
	{ 24, 2502395 },
	{ 24, 3550971 },
	{ 24, 6696699 },
	{ 24, 7745275 },
	{ 25, 10891003 },
	{ 25, 11939579 },
	{ 25, 15085307 },
	{ 25, 16133883 },
	{ 26, 27668219 },
	{ 26, 28716795 },
	{ 26, 31862523 },
	{ 26, 32911099 },
	{ 26, 61222651 },
	{ 26, 62271227 },
	{ 26, 65416955 },
	{ 26, 66465531 },
	{ 27, 64498687 },
	{ 27, 60304383 },
	{ 27, 47721471 },
	{ 27, 43527167 },
	{ 26, 30944255 },
	{ 26, 26749951 },
	{ 26, 14167039 },
	{ 26, 23441149 },
	{ 24, 5778431 },
	{ 24, 1584127 },
	{ 18, 88430 },
	{ 24, 797691 },
	{ 24, 4729851 },
	{ 24, 2370555 },
	{ 24, 3156987 },
	{ 24, 666619 },
	{ 24, 4860923 },
	{ 24, 5188607 },
	{ 26, 13249531 },
	{ 26, 25832443 },
	{ 26, 30026747 },
	{ 26, 30354431 },
	{ 27, 46803963 },
	{ 27, 59386875 },
	{ 27, 63581179 },
	{ 27, 63908863 },
	{ 28, 113912827 },
	{ 28, 126495739 },
	{ 28, 130690043 },
	{ 28, 243936251 },
	{ 28, 248130555 },
	{ 28, 260713467 },
	{ 27, 64498431 },
	{ 27, 60304127 },
	{ 27, 47721215 },
	{ 27, 43526911 },
	{ 26, 30943999 },
	{ 26, 26749695 },
	{ 26, 14166783 },
	{ 26, 23441405 },
	{ 24, 5778175 },
	{ 24, 1583871 },
	{ 18, 84334 },
	{ 24, 797435 },
	{ 24, 4729595 },
	{ 24, 2370299 },
	{ 24, 3156731 },
	{ 24, 666363 },
	{ 24, 4860667 },
	{ 24, 5188351 },
	{ 26, 13249275 },
	{ 26, 25832187 },
	{ 26, 30026491 },
	{ 26, 30354175 },
	{ 27, 46803707 },
	{ 27, 59386619 },
	{ 26, 66527231 },
	{ 26, 65478655 },
	{ 26, 62332927 },
	{ 26, 61284351 },
	{ 26, 32972799 },
	{ 26, 31924223 },
	{ 26, 28778495 },
	{ 26, 27729919 },
	{ 25, 16195583 },
	{ 25, 15147007 },
	{ 25, 12001279 },
	{ 25, 10952703 },
	{ 24, 7806975 },
	{ 24, 6758399 },
	{ 24, 3612671 },
	{ 24, 2564095 },
	{ 22, 1515519 },
	{ 22, 466943 },
	{ 17, 63982 },
	{ 22, 401403 },
	{ 22, 1253371 },
	{ 24, 2236411 },
	{ 22, 860155 },
	{ 22, 1581051 },
	{ 22, 237563 },
	{ 22, 1286139 },
	{ 22, 1499135 },
	{ 24, 3383291 },
	{ 24, 6529019 },
	{ 24, 7577595 },
	{ 24, 7790591 },
	{ 25, 11771899 },
	{ 25, 14917627 },
	{ 25, 15966203 },
	{ 25, 16179199 },
	{ 26, 28549115 },
	{ 26, 31694843 },
	{ 26, 32743419 },
	{ 26, 61054971 },
	{ 26, 62103547 },
	{ 25, 16195327 },
	{ 25, 15146751 },
	{ 25, 12001023 },
	{ 25, 10952447 },
	{ 24, 7806719 },
	{ 24, 6758143 },
	{ 24, 3612415 },
	{ 24, 2563839 },
	{ 22, 1515263 },
	{ 22, 466687 },
	{ 17, 59886 },
	{ 22, 401147 },
	{ 22, 1253115 },
	{ 24, 2236155 },
	{ 22, 859899 },
	{ 22, 1580795 },
	{ 22, 237307 },
	{ 22, 1285883 },
	{ 22, 1498879 },
	{ 24, 3383035 },
	{ 24, 6528763 },
	{ 24, 7577339 },
	{ 24, 7790335 },
	{ 25, 11771643 },
	{ 25, 14917371 },
	{ 25, 15965947 },
	{ 25, 16178943 },
	{ 26, 28548859 },
	{ 26, 31694587 },
	{ 26, 32743163 },
	{ 26, 61054715 },
	{ 26, 62103291 },
	{ 26, 65249019 },
	{ 26, 66297595 },
	{ 26, 66510591 },
	{ 26, 21634047 },
	{ 25, 15342591 },
	{ 25, 13245439 },
	{ 25, 6953983 },
	{ 25, 4856831 },
	{ 23, 2759679 },
	{ 23, 662527 },
	{ 17, 56174 },
	{ 22, 465915 },
	{ 22, 1448955 },
	{ 24, 2300923 },
	{ 24, 3283963 },
	{ 22, 1645563 },
	{ 22, 1842171 },
	{ 22, 433147 },
	{ 22, 1481723 },
	{ 22, 1563647 },
	{ 24, 3578875 },
	{ 24, 6724603 },
	{ 24, 7773179 },
	{ 24, 7855103 },
	{ 25, 11967483 },
	{ 25, 15113211 },
	{ 25, 16161787 },
	{ 25, 16243711 },
	{ 26, 28744699 },
	{ 26, 31890427 },
	{ 26, 32939003 },
	{ 26, 61250555 },
	{ 26, 62299131 },
	{ 26, 65444859 },
	{ 26, 66493435 },
	{ 26, 21633791 },
	{ 25, 15342335 },
	{ 25, 13245183 },
	{ 25, 6953727 },
	{ 25, 4856575 },
	{ 23, 2759423 },
	{ 23, 662271 },
	{ 17, 52078 },
	{ 22, 465659 },
	{ 22, 1448699 },
	{ 24, 2300667 },
	{ 24, 3283707 },
	{ 22, 1645307 },
	{ 22, 1841915 },
	{ 22, 432891 },
	{ 22, 1481467 },
	{ 22, 1563391 },
	{ 24, 3578619 },
	{ 24, 6724347 },
	{ 24, 7772923 },
	{ 24, 7854847 },
	{ 25, 11967227 },
	{ 25, 15112955 },
	{ 25, 16161531 },
	{ 25, 16243455 },
	{ 26, 28744443 },
	{ 26, 31890171 },
	{ 26, 32938747 },
	{ 26, 61250299 },
	{ 26, 62298875 },
	{ 26, 65444603 },
	{ 26, 66493179 },
	{ 26, 66575103 },
	{ 25, 15405055 },
	{ 25, 13307903 },
	{ 25, 7016447 },
	{ 25, 4919295 },
	{ 23, 2822143 },
	{ 23, 724991 },
	{ 17, 31726 },
	{ 23, 659451 },
	{ 22, 1511419 },
	{ 24, 2494459 },
	{ 24, 3346427 },
	{ 24, 6426619 },
	{ 22, 1904635 },
	{ 23, 2625531 },
	{ 22, 495611 },
	{ 22, 1544187 },
	{ 23, 2805759 },
	{ 24, 3641339 },
	{ 24, 6787067 },
	{ 24, 7835643 },
	{ 25, 10981371 },
	{ 25, 12029947 },
	{ 25, 15175675 },
	{ 25, 16224251 },
	{ 26, 27758587 },
	{ 26, 28807163 },
	{ 26, 31952891 },
	{ 26, 33001467 },
	{ 26, 61313019 },
	{ 26, 62361595 },
	{ 26, 65507323 },
	{ 26, 66555899 },
	{ 25, 15404799 },
	{ 25, 13307647 },
	{ 25, 7016191 },
	{ 25, 4919039 },
	{ 23, 2821887 },
	{ 23, 724735 },
	{ 17, 27630 },
	{ 23, 659195 },
	{ 22, 1511163 },
	{ 24, 2494203 },
	{ 24, 3346171 },
	{ 24, 6426363 },
	{ 22, 1904379 },
	{ 23, 2625275 },
	{ 22, 495355 },
	{ 22, 1543931 },
	{ 23, 2805503 },
	{ 24, 3641083 },
	{ 24, 6786811 },
	{ 24, 7835387 },
	{ 25, 10981115 },
	{ 25, 12029691 },
	{ 25, 15175419 },
	{ 25, 16223995 },
	{ 26, 27758331 },
	{ 26, 28806907 },
	{ 26, 31952635 },
	{ 26, 33001211 },
	{ 26, 61312763 },
	{ 26, 62361339 },
	{ 26, 65507067 },
	{ 26, 66555643 },
	{ 25, 15600639 },
	{ 25, 13503487 },
	{ 25, 7212031 },
	{ 25, 5114879 },
	{ 23, 3017727 },
	{ 23, 920575 },
	{ 18, 46446 },
	{ 23, 723963 },
	{ 23, 2755579 },
	{ 24, 2558971 },
	{ 24, 3542011 },
	{ 24, 6491131 },
	{ 24, 7474171 },
	{ 23, 2690043 },
	{ 23, 2886651 },
	{ 23, 691195 },
	{ 23, 2788347 },
	{ 23, 2870271 },
	{ 25, 6982651 },
	{ 25, 13274107 },
	{ 25, 15371259 },
	{ 25, 15453183 },
	{ 26, 23759867 },
	{ 26, 30051323 },
	{ 26, 32148475 },
	{ 26, 32230399 },
	{ 27, 57314299 },
	{ 27, 63605755 },
	{ 26, 32377599 },
	{ 26, 30280447 },
	{ 26, 23988991 },
	{ 26, 21891839 },
	{ 25, 15600383 },
	{ 25, 13503231 },
	{ 25, 7211775 },
	{ 25, 5114623 },
	{ 23, 3017471 },
	{ 23, 920319 },
	{ 18, 38254 },
	{ 23, 723707 },
	{ 23, 2755323 },
	{ 24, 2558715 },
	{ 24, 3541755 },
	{ 24, 6490875 },
	{ 24, 7473915 },
	{ 23, 2689787 },
	{ 23, 2886395 },
	{ 23, 690939 },
	{ 23, 2788091 },
	{ 23, 2870015 },
	{ 25, 6982395 },
	{ 25, 13273851 },
	{ 25, 15371003 },
	{ 25, 15452927 },
	{ 25, 31180799 },
	{ 25, 30656511 },
	{ 25, 16500735 },
	{ 25, 15976447 },
	{ 25, 14403583 },
	{ 25, 13879295 },
	{ 24, 8112127 },
	{ 24, 7587839 },
	{ 24, 6014975 },
	{ 24, 5490687 },
	{ 23, 3917823 },
	{ 23, 3393535 },
	{ 23, 1820671 },
	{ 23, 1296383 },
	{ 21, 772095 },
	{ 21, 247807 },
	{ 16, 30190 },
	{ 21, 231419 },
	{ 21, 706555 },
	{ 23, 1214459 },
	{ 22, 903163 },
	{ 22, 1673211 },
	{ 22, 1886203 },
	{ 23, 2656251 },
	{ 21, 739323 },
	{ 21, 919547 },
	{ 21, 190459 },
	{ 21, 714747 },
	{ 21, 767999 },
	{ 23, 1763323 },
	{ 23, 3336187 },
	{ 23, 3860475 },
	{ 23, 3913727 },
	{ 24, 5957627 },
	{ 24, 7530491 },
	{ 24, 8054779 },
	{ 24, 8108031 },
	{ 25, 14346235 },
	{ 24, 8111871 },
	{ 24, 7587583 },
	{ 24, 6014719 },
	{ 24, 5490431 },
	{ 23, 3917567 },
	{ 23, 3393279 },
	{ 23, 1820415 },
	{ 23, 1296127 },
	{ 21, 771839 },
	{ 21, 247551 },
	{ 16, 21998 },
	{ 21, 231163 },
	{ 21, 706299 },
	{ 23, 1214203 },
	{ 22, 902907 },
	{ 22, 1672955 },
	{ 22, 1885947 },
	{ 23, 2655995 },
	{ 21, 739067 },
	{ 21, 919291 },
	{ 21, 190203 },
	{ 21, 714491 },
	{ 21, 767743 },
	{ 23, 1763067 },
	{ 23, 3335931 },
	{ 23, 3860219 },
	{ 23, 3913471 },
	{ 24, 5957371 },
	{ 24, 7530235 },
	{ 24, 8054523 },
	{ 24, 8107775 },
	{ 25, 14345979 },
	{ 25, 15918843 },
	{ 25, 16443131 },
	{ 25, 30598907 },
	{ 25, 31123195 },
	{ 24, 8378107 },
	{ 24, 6718463 },
	{ 24, 3572735 },
	{ 24, 2524159 },
	{ 22, 1475583 },
	{ 22, 427007 },
	{ 16, 14190 },
	{ 21, 246779 },
	{ 21, 754683 },
	{ 23, 1229819 },
	{ 23, 1737723 },
	{ 22, 1688571 },
	{ 22, 1934331 },
	{ 23, 2671611 },
	{ 23, 2917371 },
	{ 21, 934907 },
	{ 21, 984059 },
	{ 21, 238587 },
	{ 21, 762875 },
	{ 21, 783359 },
	{ 23, 1811451 },
	{ 23, 3384315 },
	{ 23, 3908603 },
	{ 23, 3929087 },
	{ 24, 6005755 },
	{ 24, 7578619 },
	{ 24, 8102907 },
	{ 24, 8123391 },
	{ 25, 14394363 },
	{ 25, 15967227 },
	{ 25, 16491515 },
	{ 25, 30647291 },
	{ 24, 8360955 },
	{ 24, 7328763 },
	{ 24, 3572479 },
	{ 24, 2523903 },
	{ 22, 1475327 },
	{ 22, 426751 },
	{ 16, 5998 },
	{ 21, 246523 },
	{ 21, 754427 },
	{ 23, 1229563 },
	{ 23, 1737467 },
	{ 22, 1688315 },
	{ 22, 1934075 },
	{ 23, 2671355 },
	{ 23, 2917115 },
	{ 21, 934651 },
	{ 21, 983803 },
	{ 21, 238331 },
	{ 21, 762619 },
	{ 21, 783103 },
	{ 23, 1811195 },
	{ 23, 3384059 },
	{ 23, 3908347 },
	{ 23, 3928831 },
	{ 24, 6005499 },
	{ 24, 7578363 },
	{ 24, 8102651 },
	{ 24, 8123135 },
	{ 23, 4043263 },
	{ 23, 3781119 },
	{ 23, 2994687 },
	{ 23, 2732543 },
	{ 22, 1946111 },
	{ 22, 1683967 },
	{ 22, 897535 },
	{ 22, 635391 },
	{ 20, 373247 },
	{ 20, 111103 },
	{ 14, 10222 },
	{ 20, 107003 },
	{ 19, 193019 },
	{ 21, 319995 },
	{ 21, 438779 },
	{ 21, 827899 },
	{ 20, 487931 },
	{ 21, 680443 },
	{ 21, 733691 },
	{ 21, 926203 },
	{ 19, 250363 },
	{ 20, 426491 },
	{ 19, 63995 },
	{ 19, 195067 },
	{ 20, 372223 },
	{ 21, 457211 },
	{ 21, 850427 },
	{ 21, 981499 },
	{ 22, 1374715 },
	{ 22, 1505787 },
	{ 22, 1899003 },
	{ 22, 2030075 },
	{ 23, 4044029 },
	{ 23, 3781885 },
	{ 23, 2995453 },
	{ 23, 2733309 },
	{ 22, 1946877 },
	{ 22, 1684733 },
	{ 22, 898301 },
	{ 22, 636157 },
	{ 20, 374013 },
	{ 20, 111869 },
	{ 14, 1946 },
	{ 20, 107769 },
	{ 19, 193785 },
	{ 21, 320761 },
	{ 21, 439545 },
	{ 21, 828665 },
	{ 20, 488697 },
	{ 21, 681209 },
	{ 21, 734457 },
	{ 21, 926969 },
	{ 19, 251129 },
	{ 20, 427257 },
	{ 19, 249081 },
	{ 19, 253177 },
	{ 20, 432381 },
	{ 21, 998649 },
	{ 21, 1010937 },
	{ 21, 1015033 },
	{ 22, 2010361 },
	{ 22, 2014457 },
	{ 22, 2026745 },
	{ 22, 2030841 },
	{ 23, 4043001 },
	{ 23, 3793145 },
	{ 23, 3010809 },
	{ 23, 2859257 },
	{ 22, 2076921 },
	{ 22, 1827065 },
	{ 22, 1044729 },
	{ 22, 636413 },
	{ 20, 374269 },
	{ 20, 112125 },
	{ 14, 10138 },
	{ 20, 108025 },
	{ 19, 194041 },
	{ 21, 321017 },
	{ 21, 439801 },
	{ 21, 828921 },
	{ 20, 488953 },
	{ 21, 681465 },
	{ 21, 734713 },
	{ 21, 927225 },
	{ 19, 251385 },
	{ 20, 427513 },
	{ 19, 249337 },
	{ 19, 253433 },
	{ 20, 432637 },
	{ 21, 998905 },
	{ 21, 1011193 },
	{ 21, 1015289 },
	{ 22, 2010617 },
	{ 22, 2014713 },
	{ 22, 2027001 },
	{ 22, 2031097 },
	{ 23, 4043257 },
	{ 23, 3793401 },
	{ 23, 3011065 },
	{ 23, 2859513 },
	{ 22, 2077177 },
	{ 22, 1827321 },
	{ 22, 1044985 },
	{ 23, 4193785 },
	{ 22, 1544957 },
	{ 22, 496381 },
	{ 17, 11546 },
	{ 22, 447225 },
	{ 22, 1479417 },
	{ 23, 1299193 },
	{ 23, 1807097 },
	{ 23, 3330809 },
	{ 23, 3838713 },
	{ 23, 2740985 },
	{ 23, 2986745 },
	{ 23, 3724025 },
	{ 23, 3969785 },
	{ 22, 1725177 },
	{ 22, 1774329 },
	{ 22, 1716985 },
	{ 22, 1733369 },
	{ 22, 1794813 },
	{ 24, 15565561 },
	{ 24, 15319801 },
	{ 24, 6943481 },
	{ 24, 7201533 },
	{ 25, 14385913 },
	{ 25, 13878009 },
	{ 25, 16155385 },
	{ 25, 15123193 },
	{ 25, 12026617 },
	{ 25, 10994425 },
	{ 24, 8291065 },
	{ 24, 7258873 },
	{ 24, 4162297 },
	{ 24, 3130105 },
	{ 22, 1545213 },
	{ 22, 496637 },
	{ 17, 27930 },
	{ 22, 447481 },
	{ 22, 1479673 },
	{ 23, 1299449 },
	{ 23, 1807353 },
	{ 23, 3331065 },
	{ 23, 3838969 },
	{ 23, 2741241 },
	{ 23, 2987001 },
	{ 23, 3724281 },
	{ 23, 3970041 },
	{ 22, 1725433 },
	{ 22, 1774585 },
	{ 22, 1717241 },
	{ 22, 1733625 },
	{ 22, 1795069 },
	{ 24, 15565817 },
	{ 24, 15320057 },
	{ 24, 6943737 },
	{ 24, 7201789 },
	{ 25, 14386169 },
	{ 25, 13878265 },
	{ 25, 16155641 },
	{ 25, 15123449 },
	{ 25, 12026873 },
	{ 25, 10994681 },
	{ 24, 8291321 },
	{ 24, 7259129 },
	{ 24, 4162553 },
	{ 24, 3130361 },
	{ 22, 1562365 },
	{ 22, 513789 },
	{ 17, 44442 },
	{ 22, 497401 },
	{ 22, 1496825 },
	{ 24, 2529017 },
	{ 23, 1824505 },
	{ 23, 3380985 },
	{ 23, 3856121 },
	{ 24, 8382201 },
	{ 23, 3004153 },
	{ 23, 3774201 },
	{ 23, 3987193 },
	{ 22, 2090745 },
	{ 22, 1042169 },
	{ 22, 1971961 },
	{ 22, 4146937 },
	{ 22, 1799929 },
	{ 22, 1992445 },
	{ 24, 15304441 },
	{ 24, 8242937 },
	{ 24, 7206649 },
	{ 24, 7988989 },
	{ 25, 13862649 },
	{ 24, 8111865 },
	{ 25, 15107833 },
	{ 25, 11978489 },
	{ 25, 10979065 },
	{ 24, 7849721 },
	{ 24, 7243513 },
	{ 24, 4114169 },
	{ 24, 3114745 },
	{ 22, 2082553 },
	{ 22, 514045 },
	{ 17, 49130 },
	{ 22, 497657 },
	{ 22, 1497081 },
	{ 24, 2529273 },
	{ 23, 1824761 },
	{ 23, 3381241 },
	{ 23, 3856377 },
	{ 24, 8382457 },
	{ 23, 3004409 },
	{ 23, 3774457 },
	{ 23, 3987449 },
	{ 22, 2091001 },
	{ 22, 1042425 },
	{ 22, 1972217 },
	{ 22, 4147193 },
	{ 22, 1800185 },
	{ 22, 1992701 },
	{ 24, 15304697 },
	{ 24, 8243193 },
	{ 24, 7206905 },
	{ 24, 7989245 },
	{ 25, 13862905 },
	{ 24, 8112121 },
	{ 25, 15108089 },
	{ 25, 11978745 },
	{ 25, 10979321 },
	{ 24, 7849977 },
	{ 24, 7243769 },
	{ 24, 4114425 },
	{ 24, 3115001 },
	{ 22, 2082809 },
	{ 24, 3820285 },
	{ 17, 65514 },
	{ 24, 2050809 },
	{ 24, 6179577 },
	{ 26, 10177273 },
	{ 26, 14306041 },
	{ 25, 13585145 },
	{ 25, 15616761 },
	{ 26, 21711609 },
	{ 26, 33458937 },
	{ 25, 15158009 },
	{ 25, 16141049 },
	{ 24, 8375037 },
	{ 24, 8293113 },
	{ 24, 4098809 },
	{ 24, 16517881 },
	{ 24, 16321273 },
	{ 24, 7981817 },
	{ 24, 8227581 },
	{ 26, 32901881 },
	{ 26, 31918841 },
	{ 26, 31967993 },
	{ 26, 33000189 },
	{ 26, 32377593 },
	{ 26, 30345977 },
	{ 27, 47844089 },
	{ 27, 43715321 },
	{ 26, 31329017 },
	{ 26, 27200249 },
	{ 26, 16386809 },
	{ 26, 12258041 },
	{ 24, 8260345 },
	{ 24, 4131577 },
	{ 19, 81770 },
	{ 24, 2051065 },
	{ 24, 6179833 },
	{ 26, 10177529 },
	{ 26, 14306297 },
	{ 25, 13585401 },
	{ 25, 15617017 },
	{ 26, 21711865 },
	{ 26, 33459193 },
	{ 25, 15158265 },
	{ 25, 16141305 },
	{ 24, 8375293 },
	{ 24, 8293369 },
	{ 24, 4099065 },
	{ 24, 16518137 },
	{ 24, 16321529 },
	{ 24, 7982073 },
	{ 24, 8227837 },
	{ 26, 32902137 },
	{ 26, 31919097 },
	{ 26, 31968249 },
	{ 26, 33000445 },
	{ 26, 32377849 },
	{ 26, 30346233 },
	{ 27, 47844345 },
	{ 27, 43715577 },
	{ 26, 31329273 },
	{ 26, 27200505 },
	{ 26, 16387065 },
	{ 26, 12258297 },
	{ 24, 8260601 },
	{ 24, 4131833 },
	{ 19, 98154 },
	{ 24, 3821305 },
	{ 24, 6246137 },
	{ 26, 10374905 },
	{ 26, 14372601 },
	{ 26, 26889977 },
	{ 25, 15683321 },
	{ 26, 21909241 },
	{ 26, 23809785 },
	{ 26, 33263353 },
	{ 25, 16207609 },
	{ 26, 16486137 },
	{ 24, 8310525 },
	{ 24, 8097529 },
	{ 24, 3903225 },
	{ 24, 16256761 },
	{ 24, 15535865 },
	{ 24, 8244985 },
	{ 24, 15306493 },
	{ 26, 31854329 },
	{ 26, 28774137 },
	{ 26, 33017593 },
	{ 26, 32182009 },
	{ 26, 30281465 },
	{ 26, 24055545 },
	{ 27, 43650809 },
	{ 26, 31133433 },
	{ 26, 27135737 },
	{ 26, 14618361 },
	{ 26, 12193529 },
	{ 24, 8064761 },
	{ 24, 4067065 },
	{ 19, 114154 },
	{ 24, 3821561 },
	{ 24, 6246393 },
	{ 26, 10375161 },
	{ 26, 14372857 },
	{ 26, 26890233 },
	{ 25, 15683577 },
	{ 26, 21909497 },
	{ 26, 23810041 },
	{ 26, 33263609 },
	{ 25, 16207865 },
	{ 26, 16486393 },
	{ 24, 8310781 },
	{ 24, 8097785 },
	{ 24, 3903481 },
	{ 24, 16257017 },
	{ 24, 15536121 },
	{ 24, 8245241 },
	{ 24, 15306749 },
	{ 26, 31854585 },
	{ 26, 28774393 },
	{ 26, 33017849 },
	{ 26, 32182265 },
	{ 26, 30281721 },
	{ 26, 24055801 },
	{ 27, 43651065 },
	{ 26, 31133689 },
	{ 26, 27135993 },
	{ 26, 14618617 },
	{ 26, 12193785 },
	{ 24, 8065017 },
	{ 24, 4067321 },
	{ 19, 130538 },
	{ 24, 3889913 },
	{ 24, 8018681 },
	{ 26, 10443513 },
	{ 26, 14572281 },
	{ 26, 26958585 },
	{ 26, 31087353 },
	{ 26, 21977849 },
	{ 26, 24009465 },
	{ 26, 30104313 },
	{ 26, 33200889 },
	{ 26, 29006585 },
	{ 26, 16423673 },
	{ 24, 8116989 },
	{ 24, 8035065 },
	{ 24, 3840761 },
	{ 24, 15473401 },
	{ 24, 15276793 },
	{ 24, 15325945 },
	{ 24, 15571709 },
	{ 26, 28711673 },
	{ 26, 27728633 },
	{ 26, 32119545 },
	{ 26, 30087929 },
	{ 26, 23993081 },
	{ 26, 21961465 },
	{ 26, 31070969 },
	{ 26, 26942201 },
	{ 26, 14555897 },
	{ 26, 10427129 },
	{ 24, 8002297 },
	{ 24, 3873529 },
	{ 19, 212330 },
	{ 24, 3890169 },
	{ 24, 8018937 },
	{ 26, 10443769 },
	{ 26, 14572537 },
	{ 26, 26958841 },
	{ 26, 31087609 },
	{ 26, 21978105 },
	{ 26, 24009721 },
	{ 26, 30104569 },
	{ 26, 33201145 },
	{ 26, 29006841 },
	{ 26, 16423929 },
	{ 24, 8117245 },
	{ 24, 8035321 },
	{ 24, 3841017 },
	{ 24, 15473657 },
	{ 24, 15277049 },
	{ 24, 15326201 },
	{ 24, 15571965 },
	{ 26, 28711929 },
	{ 26, 27728889 },
	{ 26, 32119801 },
	{ 26, 30088185 },
	{ 26, 23993337 },
	{ 26, 21961721 },
	{ 26, 31071225 },
	{ 26, 26942457 },
	{ 26, 14556153 },
	{ 26, 10427385 },
	{ 24, 8002553 },
	{ 24, 3873785 },
	{ 19, 228714 },
	{ 24, 4087545 },
	{ 24, 8085241 },
	{ 26, 12214009 },
	{ 26, 14638841 },
	{ 26, 27156217 },
	{ 26, 31153913 },
	{ 27, 64986873 },
	{ 26, 24076025 },
	{ 26, 30301945 },
	{ 26, 32202489 },
	{ 26, 31432441 },
	{ 26, 27238137 },
	{ 26, 14655225 },
	{ 24, 8052477 },
	{ 24, 6266617 },
	{ 24, 2072313 },
	{ 24, 15212281 },
	{ 24, 8199929 },
	{ 24, 15589113 },
	{ 24, 16359165 },
	{ 26, 27664121 },
	{ 25, 16195321 },
	{ 26, 30023417 },
	{ 26, 23797497 },
	{ 26, 21896953 },
	{ 25, 15671033 },
	{ 26, 26877689 },
	{ 26, 14360313 },
	{ 26, 10362617 },
	{ 24, 6233849 },
	{ 24, 3809017 },
	{ 19, 241642 },
	{ 24, 4087801 },
	{ 24, 8085497 },
	{ 26, 12214265 },
	{ 26, 14639097 },
	{ 26, 27156473 },
	{ 26, 31154169 },
	{ 27, 64987129 },
	{ 26, 24076281 },
	{ 26, 30302201 },
	{ 26, 32202745 },
	{ 26, 31432697 },
	{ 26, 27238393 },
	{ 26, 14655481 },
	{ 24, 8052733 },
	{ 24, 6266873 },
	{ 24, 2072569 },
	{ 24, 15212537 },
	{ 24, 8200185 },
	{ 24, 15589369 },
	{ 24, 16359421 },
	{ 26, 27664377 },
	{ 25, 16195577 },
	{ 26, 30023673 },
	{ 26, 23797753 },
	{ 26, 21897209 },
	{ 25, 15671289 },
	{ 26, 26877945 },
	{ 26, 14360569 },
	{ 26, 10362873 },
	{ 24, 6234105 },
	{ 24, 3809273 },
	{ 19, 258026 },
	{ 24, 3874813 },
	{ 24, 8069117 },
	{ 26, 12263421 },
	{ 26, 16457725 },
	{ 26, 29040637 },
	{ 26, 33234941 },
	{ 27, 45817853 },
	{ 27, 50012157 },
	{ 27, 62595069 },
	{ 27, 66789373 },
	{ 28, 125774589 },
	{ 28, 125446905 },
	{ 28, 108669689 },
	{ 28, 58338041 },
	{ 26, 25111293 },
	{ 26, 24783609 },
	{ 26, 8006393 },
	{ 26, 32516857 },
	{ 26, 31730425 },
	{ 26, 65481465 },
	{ 26, 66464509 },
	{ 27, 64498425 },
	{ 27, 60566265 },
	{ 28, 94907129 },
	{ 28, 86780665 },
	{ 27, 62401273 },
	{ 27, 54274809 },
	{ 28, 57158393 },
	{ 28, 40643321 },
	{ 26, 24652537 },
	{ 26, 8137465 },
	{ 20, 339818 },
	{ 26, 16591865 },
	{ 26, 33106937 },
	{ 28, 49097721 },
	{ 28, 65612793 },
	{ 28, 108866553 },
	{ 28, 125381625 },
	{ 29, 174926841 },
	{ 29, 259664889 },
	{ 28, 121449465 },
	{ 28, 129575929 },
	{ 28, 125774845 },
	{ 28, 125447161 },
	{ 28, 108669945 },
	{ 28, 58338297 },
	{ 26, 25111549 },
	{ 26, 24783865 },
	{ 26, 8006649 },
	{ 26, 32517113 },
	{ 26, 31730681 },
	{ 26, 65481721 },
	{ 26, 66464765 },
	{ 27, 64498681 },
	{ 27, 60566521 },
	{ 28, 94907385 },
	{ 28, 86780921 },
	{ 27, 62401529 },
	{ 27, 54275065 },
	{ 28, 57158649 },
	{ 28, 40643577 },
	{ 26, 24652793 },
	{ 26, 8137721 },
	{ 20, 356202 },
	{ 26, 15215613 },
	{ 26, 33369849 },
	{ 28, 49884921 },
	{ 28, 65875705 },
	{ 28, 115945209 },
	{ 28, 125644537 },
	{ 29, 175714041 },
	{ 29, 191704825 },
	{ 29, 258879225 },
	{ 28, 129838841 },
	{ 29, 191770361 },
	{ 28, 125513469 },
	{ 28, 124661497 },
	{ 28, 107884281 },
	{ 28, 57552633 },
	{ 26, 24850173 },
	{ 26, 23998201 },
	{ 26, 7220985 },
	{ 26, 31469305 },
	{ 26, 28585721 },
	{ 26, 66531065 },
	{ 27, 63713017 },
	{ 27, 60305145 },
	{ 27, 47984377 },
	{ 28, 86519545 },
	{ 27, 61615865 },
	{ 27, 54013689 },
	{ 27, 29110009 },
	{ 28, 40382201 },
	{ 26, 23867129 },
	{ 26, 7876345 },
	{ 20, 372202 },
	{ 26, 8138493 },
	{ 26, 33370105 },
	{ 28, 49885177 },
	{ 28, 65875961 },
	{ 28, 115945465 },
	{ 28, 125644793 },
	{ 29, 175714297 },
	{ 29, 191705081 },
	{ 29, 258879481 },
	{ 28, 129839097 },
	{ 29, 191770617 },
	{ 28, 125513725 },
	{ 28, 124661753 },
	{ 28, 107884537 },
	{ 28, 57552889 },
	{ 26, 24850429 },
	{ 26, 23998457 },
	{ 26, 7221241 },
	{ 26, 31469561 },
	{ 26, 28585977 },
	{ 26, 66531321 },
	{ 27, 63713273 },
	{ 27, 60305401 },
	{ 27, 47984633 },
	{ 28, 86519801 },
	{ 27, 61616121 },
	{ 27, 54013945 },
	{ 27, 29110265 },
	{ 28, 40382457 },
	{ 26, 23867385 },
	{ 26, 7876601 },
	{ 20, 388586 },
	{ 26, 8138749 },
	{ 26, 24915965 },
	{ 28, 50150137 },
	{ 28, 66665209 },
	{ 28, 116210425 },
	{ 28, 132725497 },
	{ 29, 175979257 },
	{ 29, 192494329 },
	{ 29, 242039545 },
	{ 29, 258620153 },
	{ 29, 241842937 },
	{ 29, 191511289 },
	{ 28, 124730109 },
	{ 28, 124402425 },
	{ 28, 107625209 },
	{ 28, 57293561 },
	{ 26, 24066813 },
	{ 26, 23739129 },
	{ 26, 6961913 },
	{ 26, 28326649 },
	{ 26, 27540217 },
	{ 27, 63453945 },
	{ 27, 59521785 },
	{ 27, 47725305 },
	{ 27, 43793145 },
	{ 27, 61356793 },
	{ 27, 53230329 },
	{ 27, 28850937 },
	{ 27, 20724473 },
	{ 26, 23608057 },
	{ 26, 7092985 },
	{ 20, 470378 },
	{ 26, 7879421 },
	{ 26, 24656637 },
	{ 27, 49479679 },
	{ 28, 66665465 },
	{ 28, 116210681 },
	{ 28, 132725753 },
	{ 29, 175979513 },
	{ 29, 192494585 },
	{ 29, 242039801 },
	{ 29, 258620409 },
	{ 29, 241843193 },
	{ 29, 191511545 },
	{ 28, 124730365 },
	{ 28, 124402681 },
	{ 28, 107625465 },
	{ 28, 57293817 },
	{ 26, 24067069 },
	{ 26, 23739385 },
	{ 26, 6962169 },
	{ 26, 28326905 },
	{ 26, 27540473 },
	{ 27, 63454201 },
	{ 27, 59522041 },
	{ 27, 47725561 },
	{ 27, 43793401 },
	{ 27, 61357049 },
	{ 27, 53230585 },
	{ 27, 28851193 },
	{ 27, 20724729 },
	{ 26, 23608313 },
	{ 26, 7093241 },
	{ 20, 486762 },
	{ 26, 7879677 },
	{ 26, 24656893 },
	{ 27, 49479423 },
	{ 28, 66928377 },
	{ 28, 116997881 },
	{ 28, 132988665 },
	{ 29, 264126201 },
	{ 29, 255737593 },
	{ 29, 230571769 },
	{ 29, 222183161 },
	{ 28, 129908473 },
	{ 28, 121519865 },
	{ 28, 96354041 },
	{ 28, 87965433 },
	{ 27, 62799609 },
	{ 27, 54411001 },
	{ 27, 29245177 },
	{ 26, 23805693 },
	{ 25, 12467961 },
	{ 25, 4079353 },
	{ 26, 27279097 },
	{ 25, 16006905 },
	{ 26, 32177147 },
	{ 27, 46939897 },
	{ 27, 43532025 },
	{ 26, 31211257 },
	{ 27, 52969209 },
	{ 27, 28065529 },
	{ 27, 20463353 },
	{ 25, 12336889 },
	{ 26, 6831865 },
	{ 19, 251882 },
	{ 26, 7094013 },
	{ 26, 23871229 },
	{ 27, 47905791 },
	{ 28, 66928633 },
	{ 28, 116998137 },
	{ 28, 132988921 },
	{ 29, 264126457 },
	{ 29, 255737849 },
	{ 29, 230572025 },
	{ 29, 222183417 },
	{ 28, 129908729 },
	{ 28, 121520121 },
	{ 28, 96354297 },
	{ 28, 87965689 },
	{ 27, 62799865 },
	{ 27, 54411257 },
	{ 27, 29245433 },
	{ 26, 23805949 },
	{ 25, 12468217 },
	{ 25, 4079609 },
	{ 26, 27279353 },
	{ 25, 16007161 },
	{ 26, 32176891 },
	{ 27, 46940153 },
	{ 27, 43532281 },
	{ 26, 31211513 },
	{ 27, 52969465 },
	{ 27, 28065785 },
	{ 27, 20463609 },
	{ 25, 12337145 },
	{ 26, 6832121 },
	{ 19, 260074 },
	{ 26, 7094269 },
	{ 26, 23871485 },
	{ 27, 47905535 },
	{ 28, 57425917 },
	{ 28, 117271289 },
	{ 28, 133786361 },
	{ 29, 490367737 },
	{ 29, 263875321 },
	{ 29, 255486713 },
	{ 29, 230320889 },
	{ 28, 129985277 },
	{ 28, 129657593 },
	{ 28, 121268985 },
	{ 28, 96103161 },
	{ 27, 62876413 },
	{ 27, 62548729 },
	{ 27, 54160121 },
	{ 27, 28994297 },
	{ 25, 12544765 },
	{ 25, 12217081 },
	{ 25, 3828473 },
	{ 25, 15756025 },
	{ 25, 14969593 },
	{ 26, 30076923 },
	{ 27, 42756857 },
	{ 26, 30960377 },
	{ 26, 27028217 },
	{ 27, 27814649 },
	{ 27, 19688185 },
	{ 25, 12086009 },
	{ 25, 3959545 },
	{ 20, 431978 },
	{ 26, 6843133 },
	{ 26, 23620349 },
	{ 27, 47378431 },
	{ 28, 57174781 },
	{ 28, 117271545 },
	{ 28, 133786617 },
	{ 29, 490367993 },
	{ 29, 263875577 },
	{ 29, 255486969 },
	{ 29, 230321145 },
	{ 28, 129985533 },
	{ 28, 129657849 },
	{ 28, 121269241 },
	{ 28, 96103417 },
	{ 27, 62876669 },
	{ 27, 62548985 },
	{ 27, 54160377 },
	{ 27, 28994553 },
	{ 25, 12545021 },
	{ 25, 12217337 },
	{ 25, 3828729 },
	{ 25, 15756281 },
	{ 25, 14969849 },
	{ 26, 30076667 },
	{ 27, 42757113 },
	{ 26, 30960633 },
	{ 26, 27028473 },
	{ 27, 27814905 },
	{ 27, 19688441 },
	{ 25, 12086265 },
	{ 25, 3959801 },
	{ 20, 440170 },
	{ 26, 6843389 },
	{ 26, 23620605 },
	{ 27, 47378175 },
	{ 28, 57175037 },
	{ 28, 107506685 },
	{ 28, 134049529 },
	{ 29, 497970937 },
	{ 29, 489582329 },
	{ 29, 263089913 },
	{ 29, 254701305 },
	{ 29, 229535481 },
	{ 28, 129724157 },
	{ 28, 128872185 },
	{ 28, 120483577 },
	{ 28, 95317753 },
	{ 27, 62615293 },
	{ 27, 61763321 },
	{ 27, 53374713 },
	{ 27, 28208889 },
	{ 25, 12283645 },
	{ 25, 11431673 },
	{ 25, 3043065 },
	{ 25, 14708473 },
	{ 25, 11824889 },
	{ 26, 23784443 },
	{ 26, 30174969 },
	{ 26, 26767097 },
	{ 26, 14446329 },
	{ 27, 19427065 },
	{ 25, 11300601 },
	{ 25, 3698425 },
	{ 20, 447978 },
	{ 25, 3960573 },
	{ 25, 12349181 },
	{ 26, 24833023 },
	{ 27, 29126397 },
	{ 27, 54292221 },
	{ 27, 62680829 },
	{ 28, 87846653 },
	{ 28, 96235261 },
	{ 28, 121401085 },
	{ 28, 129789693 },
	{ 29, 229535737 },
	{ 28, 129724413 },
	{ 28, 128872441 },
	{ 28, 120483833 },
	{ 28, 95318009 },
	{ 27, 62615549 },
	{ 27, 61763577 },
	{ 27, 53374969 },
	{ 27, 28209145 },
	{ 25, 12283901 },
	{ 25, 11431929 },
	{ 25, 3043321 },
	{ 25, 14708729 },
	{ 25, 11825145 },
	{ 26, 23784187 },
	{ 26, 30175225 },
	{ 26, 26767353 },
	{ 26, 14446585 },
	{ 27, 19427321 },
	{ 25, 11300857 },
	{ 25, 3698681 },
	{ 20, 456170 },
	{ 25, 3960829 },
	{ 25, 12349437 },
	{ 26, 24832767 },
	{ 27, 29126653 },
	{ 27, 54292477 },
	{ 27, 62681085 },
	{ 28, 87846909 },
	{ 28, 96235517 },
	{ 28, 121401341 },
	{ 28, 129789949 },
	{ 29, 254442233 },
	{ 29, 229276409 },
	{ 28, 128940797 },
	{ 28, 128613113 },
	{ 28, 120224505 },
	{ 28, 95058681 },
	{ 27, 61831933 },
	{ 27, 61504249 },
	{ 27, 53115641 },
	{ 27, 27949817 },
	{ 25, 11500285 },
	{ 25, 11172601 },
	{ 25, 2783993 },
	{ 25, 11565817 },
	{ 25, 10779385 },
	{ 26, 29915897 },
	{ 26, 25983737 },
	{ 26, 14187257 },
	{ 26, 10255097 },
	{ 25, 11041529 },
	{ 25, 2915065 },
	{ 20, 497002 },
	{ 20, 1045790 },
	{ 25, 12090109 },
	{ 26, 24297471 },
	{ 27, 28867325 },
	{ 27, 54033149 },
	{ 27, 62421757 },
	{ 28, 87587581 },
	{ 28, 95976189 },
	{ 28, 121142013 },
	{ 28, 129530621 },
	{ 29, 254442489 },
	{ 29, 229276665 },
	{ 28, 128941053 },
	{ 28, 128613369 },
	{ 28, 120224761 },
	{ 28, 95058937 },
	{ 27, 61832189 },
	{ 27, 61504505 },
	{ 27, 53115897 },
	{ 27, 27950073 },
	{ 25, 11500541 },
	{ 25, 11172857 },
	{ 25, 2784249 },
	{ 25, 11566073 },
	{ 25, 10779641 },
	{ 26, 29916153 },
	{ 26, 25983993 },
	{ 26, 14187513 },
	{ 26, 10255353 },
	{ 25, 11041785 },
	{ 25, 2915321 },
	{ 20, 505194 },
	{ 20, 1037598 },
	{ 25, 12090365 },
	{ 26, 24297215 },
	{ 27, 28867581 },
	{ 27, 54033405 },
	{ 27, 62422013 },
	{ 28, 266239737 },
	{ 28, 262045433 },
	{ 28, 249462521 },
	{ 28, 245268217 },
	{ 28, 132022009 },
	{ 28, 127827705 },
	{ 28, 115244793 },
	{ 28, 111050489 },
	{ 27, 64913145 },
	{ 27, 60718841 },
	{ 27, 48135929 },
	{ 27, 43941625 },
	{ 26, 31358713 },
	{ 26, 27164409 },
	{ 26, 14581497 },
	{ 25, 11239165 },
	{ 24, 6192889 },
	{ 24, 1998585 },
	{ 25, 10518265 },
	{ 24, 7634681 },
	{ 25, 15383547 },
	{ 26, 13401849 },
	{ 26, 9993977 },
	{ 24, 6061817 },
	{ 25, 2653945 },
	{ 19, 257002 },
	{ 19, 514974 },
	{ 25, 11304701 },
	{ 26, 22723583 },
	{ 27, 28081917 },
	{ 27, 53247741 },
	{ 27, 61636349 },
	{ 28, 266239993 },
	{ 28, 262045689 },
	{ 28, 249462777 },
	{ 28, 245268473 },
	{ 28, 132022265 },
	{ 28, 127827961 },
	{ 28, 115245049 },
	{ 28, 111050745 },
	{ 27, 64913401 },
	{ 27, 60719097 },
	{ 27, 48136185 },
	{ 27, 43941881 },
	{ 26, 31358969 },
	{ 26, 27164665 },
	{ 26, 14581753 },
	{ 25, 11239421 },
	{ 24, 6193145 },
	{ 24, 1998841 },
	{ 25, 10518521 },
	{ 24, 7634937 },
	{ 25, 15383291 },
	{ 26, 13402105 },
	{ 26, 9994233 },
	{ 24, 6062073 },
	{ 25, 2654201 },
	{ 19, 261098 },
	{ 19, 510878 },
	{ 25, 11304957 },
	{ 26, 22723327 },
	{ 27, 28082173 },
	{ 27, 53247997 },
	{ 27, 61636605 },
	{ 28, 86802429 },
	{ 28, 95191037 },
	{ 28, 120356861 },
	{ 28, 128745469 },
	{ 29, 489990905 },
	{ 29, 263498489 },
	{ 29, 255109881 },
	{ 29, 229944057 },
	{ 28, 129936125 },
	{ 28, 129280761 },
	{ 28, 120892153 },
	{ 28, 95726329 },
	{ 27, 62827261 },
	{ 27, 62171897 },
	{ 27, 53783289 },
	{ 27, 28617465 },
	{ 25, 12495613 },
	{ 25, 11840249 },
	{ 25, 3451641 },
	{ 25, 14723833 },
	{ 25, 13150969 },
	{ 25, 13283323 },
	{ 27, 18393849 },
	{ 25, 11578105 },
	{ 25, 3713785 },
	{ 19, 478058 },
	{ 19, 490270 },
	{ 26, 22063869 },
	{ 26, 22196223 },
	{ 28, 55618301 },
	{ 28, 105949949 },
	{ 28, 122727165 },
	{ 28, 122859519 },
	{ 29, 531934201 },
	{ 29, 523545593 },
	{ 29, 498379769 },
	{ 29, 489991161 },
	{ 29, 263498745 },
	{ 29, 255110137 },
	{ 29, 229944313 },
	{ 28, 129936381 },
	{ 28, 129281017 },
	{ 28, 120892409 },
	{ 28, 95726585 },
	{ 27, 62827517 },
	{ 27, 62172153 },
	{ 27, 53783545 },
	{ 27, 28617721 },
	{ 25, 12495869 },
	{ 25, 11840505 },
	{ 25, 3451897 },
	{ 25, 14724089 },
	{ 25, 13151225 },
	{ 25, 13283067 },
	{ 27, 18394105 },
	{ 25, 11578361 },
	{ 25, 3714041 },
	{ 19, 482154 },
	{ 19, 486174 },
	{ 26, 22064125 },
	{ 26, 22195967 },
	{ 28, 55618557 },
	{ 28, 105950205 },
	{ 28, 122727421 },
	{ 28, 122859263 },
	{ 29, 532066045 },
	{ 29, 530362105 },
	{ 29, 521973497 },
	{ 29, 496807673 },
	{ 29, 488419065 },
	{ 29, 261926649 },
	{ 29, 253538041 },
	{ 29, 228372217 },
	{ 28, 129412861 },
	{ 28, 127708921 },
	{ 28, 119320313 },
	{ 28, 94154489 },
	{ 27, 62303997 },
	{ 27, 60600057 },
	{ 27, 52211449 },
	{ 27, 27045625 },
	{ 25, 11972349 },
	{ 25, 10268409 },
	{ 25, 1879801 },
	{ 25, 12627705 },
	{ 25, 6860537 },
	{ 25, 6990843 },
	{ 25, 10006265 },
	{ 25, 3190521 },
	{ 19, 485866 },
	{ 19, 481694 },
	{ 25, 12103421 },
	{ 25, 12233727 },
	{ 27, 28880637 },
	{ 27, 54046461 },
	{ 27, 62435069 },
	{ 27, 62565375 },
	{ 28, 95989501 },
	{ 28, 121155325 },
	{ 28, 129543933 },
	{ 28, 129674239 },
	{ 29, 488419321 },
	{ 29, 261926905 },
	{ 29, 253538297 },
	{ 29, 228372473 },
	{ 28, 129413117 },
	{ 28, 127709177 },
	{ 28, 119320569 },
	{ 28, 94154745 },
	{ 27, 62304253 },
	{ 27, 60600313 },
	{ 27, 52211705 },
	{ 27, 27045881 },
	{ 25, 11972605 },
	{ 25, 10268665 },
	{ 25, 1880057 },
	{ 25, 12627961 },
	{ 25, 6860793 },
	{ 25, 6990587 },
	{ 25, 10006521 },
	{ 25, 3190777 },
	{ 19, 489962 },
	{ 19, 477598 },
	{ 25, 12103677 },
	{ 25, 12233471 },
	{ 27, 28880893 },
	{ 27, 54046717 },
	{ 27, 62435325 },
	{ 27, 62565119 },
	{ 28, 95989757 },
	{ 28, 121155581 },
	{ 28, 129544189 },
	{ 28, 50298875 },
	{ 28, 50036731 },
	{ 28, 49250299 },
	{ 28, 48988155 },
	{ 28, 41910267 },
	{ 28, 41648123 },
	{ 28, 127843069 },
	{ 27, 29261823 },
	{ 27, 20938747 },
	{ 27, 20676603 },
	{ 27, 60734205 },
	{ 26, 14581759 },
	{ 26, 10452987 },
	{ 26, 10190843 },
	{ 25, 10402557 },
	{ 24, 3571711 },
	{ 24, 2588667 },
	{ 24, 2326523 },
	{ 24, 3244027 },
	{ 24, 2457595 },
	{ 24, 4816891 },
	{ 19, 510314 },
	{ 19, 260382 },
	{ 24, 1671167 },
	{ 24, 5865471 },
	{ 26, 10059775 },
	{ 26, 14254079 },
	{ 26, 26836991 },
	{ 26, 31031295 },
	{ 27, 43614207 },
	{ 27, 47808511 },
	{ 27, 60391423 },
	{ 27, 64585727 },
	{ 28, 50036475 },
	{ 28, 49250043 },
	{ 28, 48987899 },
	{ 28, 41910011 },
	{ 28, 41647867 },
	{ 28, 127843325 },
	{ 27, 29261567 },
	{ 27, 20938491 },
	{ 27, 20676347 },
	{ 27, 60734461 },
	{ 26, 14581503 },
	{ 26, 10452731 },
	{ 26, 10190587 },
	{ 25, 10402813 },
	{ 24, 3571455 },
	{ 24, 2588411 },
	{ 24, 2326267 },
	{ 24, 3243771 },
	{ 24, 2457339 },
	{ 24, 4816635 },
	{ 19, 514410 },
	{ 19, 256286 },
	{ 24, 1670911 },
	{ 24, 5865215 },
	{ 26, 10059519 },
	{ 26, 14253823 },
	{ 26, 26836735 },
	{ 26, 31031039 },
	{ 27, 43613951 },
	{ 27, 47808255 },
	{ 27, 60391167 },
	{ 27, 132955897 },
	{ 26, 33520635 },
	{ 26, 33258491 },
	{ 26, 32472059 },
	{ 26, 32209915 },
	{ 26, 25132027 },
	{ 26, 24869883 },
	{ 26, 24083451 },
	{ 26, 32292601 },
	{ 25, 12549115 },
	{ 25, 12286971 },
	{ 25, 11500539 },
	{ 25, 15515385 },
	{ 24, 6257659 },
	{ 24, 5995515 },
	{ 24, 5209083 },
	{ 23, 2932473 },
	{ 22, 1539067 },
	{ 22, 1276923 },
	{ 23, 2670329 },
	{ 22, 1407995 },
	{ 17, 129770 },
	{ 17, 63134 },
	{ 24, 883711 },
	{ 24, 5078015 },
	{ 26, 9272319 },
	{ 26, 13466623 },
	{ 26, 26049535 },
	{ 26, 30243839 },
	{ 27, 42826751 },
	{ 27, 47021055 },
	{ 27, 59603967 },
	{ 27, 132956153 },
	{ 26, 33520379 },
	{ 26, 33258235 },
	{ 26, 32471803 },
	{ 26, 32209659 },
	{ 26, 25131771 },
	{ 26, 24869627 },
	{ 26, 24083195 },
	{ 26, 32292857 },
	{ 25, 12548859 },
	{ 25, 12286715 },
	{ 25, 11500283 },
	{ 25, 15515641 },
	{ 24, 6257403 },
	{ 24, 5995259 },
	{ 24, 5208827 },
	{ 23, 2932729 },
	{ 22, 1538811 },
	{ 22, 1276667 },
	{ 23, 2670585 },
	{ 22, 1407739 },
	{ 17, 130794 },
	{ 17, 62110 },
	{ 24, 883455 },
	{ 24, 5077759 },
	{ 26, 9272063 },
	{ 26, 13466367 },
	{ 26, 26049279 },
	{ 26, 30243583 },
	{ 27, 42826495 },
	{ 27, 47020799 },
	{ 27, 59603711 },
	{ 27, 133098237 },
	{ 26, 33452031 },
	{ 26, 16740347 },
	{ 26, 16478203 },
	{ 26, 15691771 },
	{ 26, 15429627 },
	{ 26, 8351739 },
	{ 26, 8089595 },
	{ 26, 32434941 },
	{ 25, 12480511 },
	{ 25, 4157435 },
	{ 25, 3895291 },
	{ 25, 15657725 },
	{ 24, 6189055 },
	{ 24, 2060283 },
	{ 24, 1798139 },
	{ 23, 3074813 },
	{ 22, 1470463 },
	{ 22, 487419 },
	{ 22, 225275 },
	{ 18, 114555 },
	{ 22, 356347 },
	{ 17, 56862 },
	{ 24, 618495 },
	{ 24, 4812799 },
	{ 26, 9007103 },
	{ 26, 13201407 },
	{ 26, 25784319 },
	{ 26, 29978623 },
	{ 27, 42561535 },
	{ 27, 46755839 },
	{ 27, 59338751 },
	{ 27, 133098493 },
	{ 26, 33451775 },
	{ 26, 16740091 },
	{ 26, 16477947 },
	{ 26, 15691515 },
	{ 26, 15429371 },
	{ 26, 8351483 },
	{ 26, 8089339 },
	{ 26, 32435197 },
	{ 25, 12480255 },
	{ 25, 4157179 },
	{ 25, 3895035 },
	{ 25, 15657981 },
	{ 24, 6188799 },
	{ 24, 2060027 },
	{ 24, 1797883 },
	{ 23, 3075069 },
	{ 22, 1470207 },
	{ 22, 487163 },
	{ 22, 225019 },
	{ 18, 112507 },
	{ 22, 2096763 },
	{ 17, 55838 },
	{ 24, 618239 },
	{ 24, 4812543 },
	{ 26, 9006847 },
	{ 26, 13201151 },
	{ 26, 25784063 },
	{ 26, 29978367 },
	{ 27, 42561279 },
	{ 27, 46755583 },
	{ 27, 59338495 },
	{ 27, 63532799 },
	{ 27, 132574973 },
	{ 26, 16673791 },
	{ 26, 16411647 },
	{ 26, 15625215 },
	{ 26, 15363071 },
	{ 26, 8285183 },
	{ 26, 8023039 },
	{ 26, 7236607 },
	{ 26, 31911677 },
	{ 25, 4090879 },
	{ 25, 3828735 },
	{ 25, 3042303 },
	{ 25, 15134461 },
	{ 24, 1993727 },
	{ 24, 1731583 },
	{ 24, 945151 },
	{ 23, 2551549 },
	{ 22, 420863 },
	{ 22, 158719 },
	{ 20, 524095 },
	{ 20, 524139 },
	{ 20, 524094 },
	{ 22, 2097087 },
	{ 22, 1403903 },
	{ 24, 2452479 },
	{ 24, 3501055 },
	{ 24, 6646783 },
	{ 24, 7695359 },
	{ 25, 10841087 },
	{ 25, 11889663 },
	{ 25, 15035391 },
	{ 25, 16083967 },
	{ 26, 27618303 },
	{ 26, 16673535 },
	{ 26, 16411391 },
	{ 26, 15624959 },
	{ 26, 15362815 },
	{ 26, 8284927 },
	{ 26, 8022783 },
	{ 26, 7236351 },
	{ 26, 31911933 },
	{ 25, 4090623 },
	{ 25, 3828479 },
	{ 25, 3042047 },
	{ 25, 15134717 },
	{ 24, 1993471 },
	{ 24, 1731327 },
	{ 24, 944895 },
	{ 23, 2551805 },
	{ 22, 420607 },
	{ 22, 158463 },
	{ 20, 524271 },
	{ 17, 65499 },
	{ 13, 3790 },
	{ 21, 1048191 },
	{ 22, 1403647 },
	{ 24, 2452223 },
	{ 24, 3500799 },
	{ 24, 6646527 },
	{ 24, 7695103 },
	{ 25, 10840831 },
	{ 25, 11889407 },
	{ 25, 15035135 },
	{ 25, 16083711 },
	{ 26, 27618047 },
	{ 26, 28666623 },
	{ 26, 31812351 },
	{ 26, 32860927 },
	{ 26, 61172479 },
	{ 26, 62221055 },
	{ 26, 65366783 },
	{ 26, 66415359 },
	{ 26, 31473663 },
	{ 26, 28327935 },
	{ 26, 31652605 },
	{ 25, 15745023 },
	{ 25, 14696447 },
	{ 25, 11550719 },
	{ 25, 14875389 },
	{ 24, 7356415 },
	{ 24, 6307839 },
	{ 24, 3162111 },
	{ 23, 2292477 },
	{ 17, 64895 },
	{ 16, 32719 },
	{ 13, 3726 },
	{ 19, 261999 },
	{ 17, 65407 },
	{ 24, 2179071 },
	{ 24, 3227647 },
	{ 24, 6373375 },
	{ 24, 7421951 },
	{ 25, 10567679 },
	{ 25, 11616255 },
	{ 25, 14761983 },
	{ 25, 15810559 },
	{ 26, 27344895 },
	{ 26, 28393471 },
	{ 26, 31539199 },
	{ 26, 66076415 },
	{ 26, 65027839 },
	{ 26, 61882111 },
	{ 26, 60833535 },
	{ 26, 32521983 },
	{ 26, 31473407 },
	{ 26, 28327679 },
	{ 26, 31652861 },
	{ 25, 15744767 },
	{ 25, 14696191 },
	{ 25, 11550463 },
	{ 25, 14875645 },
	{ 24, 7356159 },
	{ 24, 6307583 },
	{ 24, 3161855 },
	{ 23, 2292733 },
	{ 17, 62847 },
	{ 17, 65455 },
	{ 23, 64509 },
	{ 16, 32735 },
	{ 17, 63359 },
	{ 24, 2178815 },
	{ 24, 3227391 },
	{ 24, 6373119 },
	{ 24, 7421695 },
	{ 25, 10567423 },
	{ 25, 11615999 },
	{ 25, 14761727 },
	{ 25, 15810303 },
	{ 26, 27344639 },
	{ 26, 28393215 },
	{ 26, 31538943 },
	{ 26, 32587519 },
	{ 26, 60899071 },
	{ 26, 61947647 },
	{ 26, 65093375 },
	{ 26, 66141951 },
	{ 26, 31734783 },
	{ 26, 28589055 },
	{ 26, 32177917 },
	{ 25, 16006143 },
	{ 25, 14957567 },
	{ 25, 11811839 },
	{ 25, 15400701 },
	{ 24, 7617535 },
	{ 24, 6568959 },
	{ 24, 3423231 },
	{ 23, 2817789 },
	{ 22, 1326079 },
	{ 19, 261823 },
	{ 17, 65502 },
	{ 15, 16331 },
	{ 18, 130875 },
	{ 22, 211967 },
	{ 22, 1260543 },
	{ 24, 2309119 },
	{ 24, 3357695 },
	{ 24, 6503423 },
	{ 24, 7551999 },
	{ 25, 10697727 },
	{ 25, 11746303 },
	{ 25, 14892031 },
	{ 25, 15940607 },
	{ 26, 27474943 },
	{ 26, 66337535 },
	{ 26, 65288959 },
	{ 26, 62143231 },
	{ 26, 61094655 },
	{ 26, 32783103 },
	{ 26, 31734527 },
	{ 26, 28588799 },
	{ 26, 32178173 },
	{ 25, 16005887 },
	{ 25, 14957311 },
	{ 25, 11811583 },
	{ 25, 15400957 },
	{ 24, 7617279 },
	{ 24, 6568703 },
	{ 24, 3422975 },
	{ 23, 2818045 },
	{ 22, 1325823 },
	{ 20, 523711 },
	{ 17, 65374 },
	{ 16, 32683 },
	{ 18, 131051 },
	{ 22, 211711 },
	{ 22, 1260287 },
	{ 24, 2308863 },
	{ 24, 3357439 },
	{ 24, 6503167 },
	{ 24, 7551743 },
	{ 25, 10697471 },
	{ 25, 11746047 },
	{ 25, 14891775 },
	{ 25, 15940351 },
	{ 26, 27474687 },
	{ 26, 28523263 },
	{ 26, 31668991 },
	{ 26, 32717567 },
	{ 26, 61029119 },
	{ 26, 62077695 },
	{ 26, 65223423 },
	{ 26, 66271999 },
	{ 28, 109588479 },
	{ 27, 63451135 },
	{ 27, 59256831 },
	{ 27, 46673919 },
	{ 27, 42479615 },
	{ 26, 29896703 },
	{ 26, 25702399 },
	{ 26, 13119487 },
	{ 26, 19245821 },
	{ 24, 4730879 },
	{ 24, 536575 },
	{ 16, 24174 },
	{ 18, 130747 },
	{ 17, 48507 },
	{ 22, 143355 },
	{ 22, 1191931 },
	{ 22, 1519615 },
	{ 24, 3289083 },
	{ 24, 6434811 },
	{ 24, 7483387 },
	{ 24, 7811071 },
	{ 25, 11677691 },
	{ 25, 14823419 },
	{ 25, 15871995 },
	{ 25, 16199679 },
	{ 26, 28454907 },
	{ 26, 31600635 },
	{ 26, 32649211 },
	{ 26, 60960763 },
	{ 26, 62009339 },
	{ 26, 65155067 },
	{ 26, 66203643 },
	{ 26, 66531327 },
	{ 27, 63450879 },
	{ 27, 59256575 },
	{ 27, 46673663 },
	{ 27, 42479359 },
	{ 26, 29896447 },
	{ 26, 25702143 },
	{ 26, 13119231 },
	{ 26, 19246077 },
	{ 24, 4730623 },
	{ 24, 536319 },
	{ 16, 23150 },
	{ 19, 261563 },
	{ 17, 46459 },
	{ 22, 143099 },
	{ 22, 1191675 },
	{ 22, 1519359 },
	{ 24, 3288827 },
	{ 24, 6434555 },
	{ 24, 7483131 },
	{ 24, 7810815 },
	{ 25, 11677435 },
	{ 25, 14823163 },
	{ 25, 15871739 },
	{ 25, 16199423 },
	{ 26, 28454651 },
	{ 26, 31600379 },
	{ 26, 32648955 },
	{ 26, 60960507 },
	{ 26, 62009083 },
	{ 26, 65154811 },
	{ 26, 66203387 },
	{ 26, 66531071 },
	{ 27, 63712255 },
	{ 27, 59517951 },
	{ 27, 46935039 },
	{ 27, 42740735 },
	{ 26, 30157823 },
	{ 26, 25963519 },
	{ 26, 13380607 },
	{ 26, 20295421 },
	{ 24, 4991999 },
	{ 24, 797695 },
	{ 16, 22254 },
	{ 24, 5615353 },
	{ 22, 1321979 },
	{ 24, 5091065 },
	{ 22, 404475 },
	{ 22, 1453051 },
	{ 24, 2501627 },
	{ 24, 3550203 },
	{ 24, 6695931 },
	{ 24, 7744507 },
	{ 25, 10890235 },
	{ 25, 11938811 },
	{ 25, 15084539 },
	{ 25, 16133115 },
	{ 26, 27667451 },
	{ 26, 28716027 },
	{ 26, 31861755 },
	{ 26, 32910331 },
	{ 26, 61221883 },
	{ 26, 62270459 },
	{ 26, 65416187 },
	{ 26, 66464763 },
	{ 27, 63711999 },
	{ 27, 59517695 },
	{ 27, 46934783 },
	{ 27, 42740479 },
	{ 26, 30157567 },
	{ 26, 25963263 },
	{ 26, 13380351 },
	{ 26, 20295677 },
	{ 24, 4991743 },
	{ 24, 797439 },
	{ 16, 21230 },
	{ 24, 5615609 },
	{ 22, 1321723 },
	{ 24, 5091321 },
	{ 22, 404219 },
	{ 22, 1452795 },
	{ 24, 2501371 },
	{ 24, 3549947 },
	{ 24, 6695675 },
	{ 24, 7744251 },
	{ 25, 10889979 },
	{ 25, 11938555 },
	{ 25, 15084283 },
	{ 25, 16132859 },
	{ 26, 27667195 },
	{ 26, 28715771 },
	{ 26, 31861499 },
	{ 26, 32910075 },
	{ 26, 61221627 },
	{ 26, 62270203 },
	{ 26, 65415931 },
	{ 26, 66464507 },
	{ 25, 16130047 },
	{ 25, 15081471 },
	{ 25, 11935743 },
	{ 25, 10887167 },
	{ 24, 7741439 },
	{ 24, 6692863 },
	{ 24, 3547135 },
	{ 24, 2498559 },
	{ 22, 1449983 },
	{ 22, 401407 },
	{ 17, 63854 },
	{ 22, 204795 },
	{ 22, 1187835 },
	{ 22, 598011 },
	{ 22, 794619 },
	{ 22, 172027 },
	{ 22, 1220603 },
	{ 22, 1302527 },
	{ 24, 3317755 },
	{ 24, 6463483 },
	{ 24, 7512059 },
	{ 24, 7593983 },
	{ 25, 11706363 },
	{ 25, 14852091 },
	{ 25, 15900667 },
	{ 25, 15982591 },
	{ 26, 28483579 },
	{ 26, 31629307 },
	{ 26, 32677883 },
	{ 26, 60989435 },
	{ 26, 62038011 },
	{ 26, 65183739 },
	{ 25, 16129791 },
	{ 25, 15081215 },
	{ 25, 11935487 },
	{ 25, 10886911 },
	{ 24, 7741183 },
	{ 24, 6692607 },
	{ 24, 3546879 },
	{ 24, 2498303 },
	{ 22, 1449727 },
	{ 22, 401151 },
	{ 17, 59758 },
	{ 22, 204539 },
	{ 22, 1187579 },
	{ 22, 597755 },
	{ 22, 794363 },
	{ 22, 171771 },
	{ 22, 1220347 },
	{ 22, 1302271 },
	{ 24, 3317499 },
	{ 24, 6463227 },
	{ 24, 7511803 },
	{ 24, 7593727 },
	{ 25, 11706107 },
	{ 25, 14851835 },
	{ 25, 15900411 },
	{ 25, 15982335 },
	{ 26, 28483323 },
	{ 26, 31629051 },
	{ 26, 32677627 },
	{ 26, 60989179 },
	{ 26, 62037755 },
	{ 26, 65183483 },
	{ 25, 16194559 },
	{ 25, 15145983 },
	{ 25, 12000255 },
	{ 25, 10951679 },
	{ 24, 7805951 },
	{ 24, 6757375 },
	{ 24, 3611647 },
	{ 24, 2563071 },
	{ 22, 1514495 },
	{ 22, 465919 },
	{ 17, 55790 },
	{ 22, 400379 },
	{ 22, 1252347 },
	{ 24, 2235387 },
	{ 22, 859131 },
	{ 22, 1580027 },
	{ 22, 236539 },
	{ 22, 1285115 },
	{ 22, 1498111 },
	{ 24, 3382267 },
	{ 24, 6527995 },
	{ 24, 7576571 },
	{ 24, 7789567 },
	{ 25, 11770875 },
	{ 25, 14916603 },
	{ 25, 15965179 },
	{ 25, 16178175 },
	{ 26, 28548091 },
	{ 26, 31693819 },
	{ 26, 32742395 },
	{ 26, 61053947 },
	{ 26, 62102523 },
	{ 25, 16194303 },
	{ 25, 15145727 },
	{ 25, 11999999 },
	{ 25, 10951423 },
	{ 24, 7805695 },
	{ 24, 6757119 },
	{ 24, 3611391 },
	{ 24, 2562815 },
	{ 22, 1514239 },
	{ 22, 465663 },
	{ 17, 51694 },
	{ 22, 400123 },
	{ 22, 1252091 },
	{ 24, 2235131 },
	{ 22, 858875 },
	{ 22, 1579771 },
	{ 22, 236283 },
	{ 22, 1284859 },
	{ 22, 1497855 },
	{ 24, 3382011 },
	{ 24, 6527739 },
	{ 24, 7576315 },
	{ 24, 7789311 },
	{ 25, 11770619 },
	{ 25, 14916347 },
	{ 25, 15964923 },
	{ 25, 16177919 },
	{ 26, 28547835 },
	{ 26, 31693563 },
	{ 26, 32742139 },
	{ 26, 61053691 },
	{ 26, 62102267 },
	{ 26, 65247995 },
	{ 26, 66296571 },
	{ 26, 66509567 },
	{ 26, 21630975 },
	{ 25, 15339519 },
	{ 25, 13242367 },
	{ 25, 6950911 },
	{ 25, 4853759 },
	{ 23, 2756607 },
	{ 23, 659455 },
	{ 17, 31598 },
	{ 22, 462843 },
	{ 22, 1445883 },
	{ 24, 2297851 },
	{ 24, 3280891 },
	{ 22, 1642491 },
	{ 22, 1839099 },
	{ 22, 430075 },
	{ 22, 1478651 },
	{ 22, 1560575 },
	{ 24, 3575803 },
	{ 24, 6721531 },
	{ 24, 7770107 },
	{ 24, 7852031 },
	{ 25, 11964411 },
	{ 25, 15110139 },
	{ 25, 16158715 },
	{ 25, 16240639 },
	{ 26, 28741627 },
	{ 26, 31887355 },
	{ 26, 32935931 },
	{ 26, 61247483 },
	{ 26, 62296059 },
	{ 26, 65441787 },
	{ 26, 66490363 },
	{ 26, 21630719 },
	{ 25, 15339263 },
	{ 25, 13242111 },
	{ 25, 6950655 },
	{ 25, 4853503 },
	{ 23, 2756351 },
	{ 23, 659199 },
	{ 17, 27502 },
	{ 22, 462587 },
	{ 22, 1445627 },
	{ 24, 2297595 },
	{ 24, 3280635 },
	{ 22, 1642235 },
	{ 22, 1838843 },
	{ 22, 429819 },
	{ 22, 1478395 },
	{ 22, 1560319 },
	{ 24, 3575547 },
	{ 24, 6721275 },
	{ 24, 7769851 },
	{ 24, 7851775 },
	{ 25, 11964155 },
	{ 25, 15109883 },
	{ 25, 16158459 },
	{ 25, 16240383 },
	{ 26, 28741371 },
	{ 26, 31887099 },
	{ 26, 32935675 },
	{ 26, 61247227 },
	{ 26, 62295803 },
	{ 26, 65441531 },
	{ 26, 66490107 },
	{ 26, 66572031 },
	{ 25, 15404031 },
	{ 25, 13306879 },
	{ 25, 7015423 },
	{ 25, 4918271 },
	{ 23, 2821119 },
	{ 23, 723967 },
	{ 17, 23534 },
	{ 23, 658427 },
	{ 22, 1510395 },
	{ 24, 2493435 },
	{ 24, 3345403 },
	{ 24, 6425595 },
	{ 22, 1903611 },
	{ 23, 2624507 },
	{ 22, 494587 },
	{ 22, 1543163 },
	{ 23, 2804735 },
	{ 24, 3640315 },
	{ 24, 6786043 },
	{ 24, 7834619 },
	{ 25, 10980347 },
	{ 25, 12028923 },
	{ 25, 15174651 },
	{ 25, 16223227 },
	{ 26, 27757563 },
	{ 26, 28806139 },
	{ 26, 31951867 },
	{ 26, 33000443 },
	{ 26, 61311995 },
	{ 26, 62360571 },
	{ 26, 65506299 },
	{ 26, 66554875 },
	{ 25, 15403775 },
	{ 25, 13306623 },
	{ 25, 7015167 },
	{ 25, 4918015 },
	{ 23, 2820863 },
	{ 23, 723711 },
	{ 17, 19438 },
	{ 23, 658171 },
	{ 22, 1510139 },
	{ 24, 2493179 },
	{ 24, 3345147 },
	{ 24, 6425339 },
	{ 22, 1903355 },
	{ 23, 2624251 },
	{ 22, 494331 },
	{ 22, 1542907 },
	{ 23, 2804479 },
	{ 24, 3640059 },
	{ 24, 6785787 },
	{ 24, 7834363 },
	{ 25, 10980091 },
	{ 25, 12028667 },
	{ 25, 15174395 },
	{ 25, 16222971 },
	{ 25, 16484351 },
	{ 25, 15960063 },
	{ 25, 14387199 },
	{ 25, 13862911 },
	{ 24, 8095743 },
	{ 24, 7571455 },
	{ 24, 5998591 },
	{ 24, 5474303 },
	{ 23, 3901439 },
	{ 23, 3377151 },
	{ 23, 1804287 },
	{ 23, 1279999 },
	{ 21, 755711 },
	{ 21, 231423 },
	{ 16, 30062 },
	{ 21, 182267 },
	{ 21, 690171 },
	{ 22, 641019 },
	{ 22, 886779 },
	{ 22, 1624059 },
	{ 22, 1869819 },
	{ 21, 673787 },
	{ 21, 722939 },
	{ 21, 174075 },
	{ 21, 698363 },
	{ 21, 718847 },
	{ 23, 1746939 },
	{ 23, 3319803 },
	{ 23, 3844091 },
	{ 23, 3864575 },
	{ 24, 5941243 },
	{ 24, 7514107 },
	{ 24, 8038395 },
	{ 24, 8058879 },
	{ 25, 14329851 },
	{ 25, 15902715 },
	{ 24, 8095487 },
	{ 24, 7571199 },
	{ 24, 5998335 },
	{ 24, 5474047 },
	{ 23, 3901183 },
	{ 23, 3376895 },
	{ 23, 1804031 },
	{ 23, 1279743 },
	{ 21, 755455 },
	{ 21, 231167 },
	{ 16, 21870 },
	{ 21, 182011 },
	{ 21, 689915 },
	{ 22, 640763 },
	{ 22, 886523 },
	{ 22, 1623803 },
	{ 22, 1869563 },
	{ 21, 673531 },
	{ 21, 722683 },
	{ 21, 173819 },
	{ 21, 698107 },
	{ 21, 718591 },
	{ 23, 1746683 },
	{ 23, 3319547 },
	{ 23, 3843835 },
	{ 23, 3864319 },
	{ 24, 5940987 },
	{ 24, 7513851 },
	{ 24, 8038139 },
	{ 24, 8058623 },
	{ 25, 14329595 },
	{ 25, 15902459 },
	{ 24, 8111103 },
	{ 24, 7586815 },
	{ 24, 6013951 },
	{ 24, 5489663 },
	{ 23, 3916799 },
	{ 23, 3392511 },
	{ 23, 1819647 },
	{ 23, 1295359 },
	{ 21, 771071 },
	{ 21, 246783 },
	{ 16, 13806 },
	{ 21, 230395 },
	{ 21, 705531 },
	{ 23, 1213435 },
	{ 22, 902139 },
	{ 22, 1672187 },
	{ 22, 1885179 },
	{ 23, 2655227 },
	{ 21, 738299 },
	{ 21, 918523 },
	{ 21, 189435 },
	{ 21, 713723 },
	{ 21, 766975 },
	{ 23, 1762299 },
	{ 23, 3335163 },
	{ 23, 3859451 },
	{ 23, 3912703 },
	{ 24, 5956603 },
	{ 24, 7529467 },
	{ 24, 8053755 },
	{ 24, 8107007 },
	{ 25, 14345211 },
	{ 24, 8110847 },
	{ 24, 7586559 },
	{ 24, 6013695 },
	{ 24, 5489407 },
	{ 23, 3916543 },
	{ 23, 3392255 },
	{ 23, 1819391 },
	{ 23, 1295103 },
	{ 21, 770815 },
	{ 21, 246527 },
	{ 16, 5614 },
	{ 21, 230139 },
	{ 21, 705275 },
	{ 23, 1213179 },
	{ 22, 901883 },
	{ 22, 1671931 },
	{ 22, 1884923 },
	{ 23, 2654971 },
	{ 21, 738043 },
	{ 21, 918267 },
	{ 21, 189179 },
	{ 21, 713467 },
	{ 21, 766719 },
	{ 23, 1762043 },
	{ 23, 3334907 },
	{ 23, 3859195 },
	{ 23, 3912447 },
	{ 24, 5956347 },
	{ 24, 7529211 },
	{ 24, 8053499 },
	{ 24, 8106751 },
	{ 24, 6922751 },
	{ 23, 4039167 },
	{ 23, 3777023 },
	{ 23, 2990591 },
	{ 23, 2728447 },
	{ 22, 1942015 },
	{ 22, 1679871 },
	{ 22, 893439 },
	{ 22, 631295 },
	{ 20, 369151 },
	{ 20, 107007 },
	{ 14, 10094 },
	{ 19, 61947 },
	{ 19, 188923 },
	{ 21, 307707 },
	{ 21, 434683 },
	{ 20, 422395 },
	{ 20, 483835 },
	{ 21, 668155 },
	{ 21, 729595 },
	{ 19, 233979 },
	{ 19, 246267 },
	{ 19, 59899 },
	{ 19, 190971 },
	{ 19, 196095 },
	{ 21, 453115 },
	{ 21, 846331 },
	{ 21, 977403 },
	{ 21, 982527 },
	{ 22, 1501691 },
	{ 22, 1894907 },
	{ 22, 2025979 },
	{ 22, 2031103 },
	{ 23, 4039933 },
	{ 23, 3777789 },
	{ 23, 2991357 },
	{ 23, 2729213 },
	{ 22, 1942781 },
	{ 22, 1680637 },
	{ 22, 894205 },
	{ 22, 632061 },
	{ 20, 369917 },
	{ 20, 107773 },
	{ 14, 1818 },
	{ 19, 62713 },
	{ 19, 189689 },
	{ 21, 308473 },
	{ 21, 435449 },
	{ 20, 423161 },
	{ 20, 484601 },
	{ 21, 668921 },
	{ 21, 730361 },
	{ 19, 234745 },
	{ 19, 247033 },
	{ 19, 232697 },
	{ 19, 236793 },
	{ 19, 252157 },
	{ 21, 933113 },
	{ 21, 945401 },
	{ 21, 949497 },
	{ 21, 1014013 },
	{ 22, 1883385 },
	{ 22, 1895673 },
	{ 22, 1899769 },
	{ 22, 2029821 },
	{ 23, 4055289 },
	{ 23, 3797241 },
	{ 23, 3121401 },
	{ 23, 2863353 },
	{ 22, 2089209 },
	{ 22, 1831161 },
	{ 22, 894461 },
	{ 22, 632317 },
	{ 20, 370173 },
	{ 20, 108029 },
	{ 14, 10010 },
	{ 19, 62969 },
	{ 19, 189945 },
	{ 21, 308729 },
	{ 21, 435705 },
	{ 20, 423417 },
	{ 20, 484857 },
	{ 21, 669177 },
	{ 21, 730617 },
	{ 19, 235001 },
	{ 19, 247289 },
	{ 19, 232953 },
	{ 19, 237049 },
	{ 19, 252413 },
	{ 21, 933369 },
	{ 21, 945657 },
	{ 21, 949753 },
	{ 21, 1014269 },
	{ 22, 1883641 },
	{ 22, 1895929 },
	{ 22, 1900025 },
	{ 22, 2030077 },
	{ 23, 4055545 },
	{ 23, 3797497 },
	{ 23, 3121657 },
	{ 23, 2863609 },
	{ 22, 2089465 },
	{ 22, 1831417 },
	{ 23, 3931641 },
	{ 23, 4192765 },
	{ 22, 1495805 },
	{ 22, 447229 },
	{ 16, 6042 },
	{ 22, 430841 },
	{ 21, 774905 },
	{ 23, 1282809 },
	{ 23, 1757945 },
	{ 23, 3314425 },
	{ 22, 1954553 },
	{ 23, 2724601 },
	{ 23, 2937593 },
	{ 23, 3707641 },
	{ 21, 1004281 },
	{ 22, 1708793 },
	{ 21, 996089 },
	{ 21, 1012473 },
	{ 22, 1729277 },
	{ 23, 3994361 },
	{ 23, 4043513 },
	{ 23, 4059897 },
	{ 24, 8041209 },
	{ 24, 8057593 },
	{ 24, 8106745 },
	{ 24, 8123129 },
	{ 25, 16171769 },
	{ 25, 15172345 },
	{ 25, 12043001 },
	{ 25, 11436793 },
	{ 24, 8307449 },
	{ 24, 7308025 },
	{ 24, 4178681 },
	{ 24, 2544637 },
	{ 22, 1496061 },
	{ 22, 447485 },
	{ 16, 14234 },
	{ 22, 431097 },
	{ 21, 775161 },
	{ 23, 1283065 },
	{ 23, 1758201 },
	{ 23, 3314681 },
	{ 22, 1954809 },
	{ 23, 2724857 },
	{ 23, 2937849 },
	{ 23, 3707897 },
	{ 21, 1004537 },
	{ 22, 1709049 },
	{ 21, 996345 },
	{ 21, 1012729 },
	{ 22, 1729533 },
	{ 23, 3994617 },
	{ 23, 4043769 },
	{ 23, 4060153 },
	{ 24, 8041465 },
	{ 24, 8057849 },
	{ 24, 8107001 },
	{ 24, 8123385 },
	{ 25, 16172025 },
	{ 25, 15172601 },
	{ 25, 12043257 },
	{ 25, 11437049 },
	{ 24, 8307705 },
	{ 24, 7308281 },
	{ 24, 4178937 },
	{ 24, 2594557 },
	{ 22, 1545981 },
	{ 22, 497405 },
	{ 17, 44314 },
	{ 22, 448249 },
	{ 22, 1480441 },
	{ 23, 1300217 },
	{ 23, 1808121 },
	{ 23, 3331833 },
	{ 23, 3839737 },
	{ 23, 2742009 },
	{ 23, 2987769 },
	{ 23, 3725049 },
	{ 23, 3970809 },
	{ 22, 1726201 },
	{ 22, 1775353 },
	{ 22, 1718009 },
	{ 22, 1734393 },
	{ 22, 1795837 },
	{ 24, 15566585 },
	{ 24, 15320825 },
	{ 24, 6944505 },
	{ 24, 7202557 },
	{ 25, 14386937 },
	{ 25, 13879033 },
	{ 25, 16156409 },
	{ 25, 15124217 },
	{ 25, 12027641 },
	{ 25, 10995449 },
	{ 24, 8292089 },
	{ 24, 7259897 },
	{ 24, 4163321 },
	{ 24, 3131129 },
	{ 22, 1546237 },
	{ 22, 497661 },
	{ 17, 60698 },
	{ 22, 448505 },
	{ 22, 1480697 },
	{ 23, 1300473 },
	{ 23, 1808377 },
	{ 23, 3332089 },
	{ 23, 3839993 },
	{ 23, 2742265 },
	{ 23, 2988025 },
	{ 23, 3725305 },
	{ 23, 3971065 },
	{ 22, 1726457 },
	{ 22, 1775609 },
	{ 22, 1718265 },
	{ 22, 1734649 },
	{ 22, 1796093 },
	{ 24, 15566841 },
	{ 24, 15321081 },
	{ 24, 6944761 },
	{ 24, 7202813 },
	{ 25, 14387193 },
	{ 25, 13879289 },
	{ 25, 16156665 },
	{ 25, 15124473 },
	{ 25, 12027897 },
	{ 25, 10995705 },
	{ 24, 8292345 },
	{ 24, 7260153 },
	{ 24, 4163577 },
	{ 24, 3131385 },
	{ 24, 6245117 },
	{ 24, 2050813 },
	{ 19, 77210 },
	{ 24, 1985273 },
	{ 24, 5982969 },
	{ 26, 10111737 },
	{ 25, 7293689 },
	{ 25, 13519609 },
	{ 25, 15420153 },
	{ 26, 33524473 },
	{ 25, 12012281 },
	{ 25, 15092473 },
	{ 25, 15944441 },
	{ 24, 8358649 },
	{ 24, 4164345 },
	{ 24, 7883513 },
	{ 24, 16583417 },
	{ 24, 7195385 },
	{ 24, 7965437 },
	{ 26, 61213433 },
	{ 26, 32967417 },
	{ 26, 28822265 },
	{ 26, 31951613 },
	{ 27, 55446265 },
	{ 26, 32443129 },
	{ 27, 60427001 },
	{ 27, 47909625 },
	{ 27, 43911929 },
	{ 26, 31394553 },
	{ 26, 28969721 },
	{ 26, 16452345 },
	{ 26, 12454649 },
	{ 24, 8325881 },
	{ 24, 2051069 },
	{ 19, 81898 },
	{ 24, 1985529 },
	{ 24, 5983225 },
	{ 26, 10111993 },
	{ 25, 7293945 },
	{ 25, 13519865 },
	{ 25, 15420409 },
	{ 26, 33524729 },
	{ 25, 12012537 },
	{ 25, 15092729 },
	{ 25, 15944697 },
	{ 24, 8358905 },
	{ 24, 4164601 },
	{ 24, 7883769 },
	{ 24, 16583673 },
	{ 24, 7195641 },
	{ 24, 7965693 },
	{ 26, 61213689 },
	{ 26, 32967673 },
	{ 26, 28822521 },
	{ 26, 31951869 },
	{ 27, 55446521 },
	{ 26, 32443385 },
	{ 27, 60427257 },
	{ 27, 47909881 },
	{ 27, 43912185 },
	{ 26, 31394809 },
	{ 26, 28969977 },
	{ 26, 16452601 },
	{ 26, 12454905 },
	{ 24, 8326137 },
	{ 24, 3821309 },
	{ 19, 98282 },
	{ 24, 2051833 },
	{ 24, 6180601 },
	{ 26, 10178297 },
	{ 26, 14307065 },
	{ 25, 13586169 },
	{ 25, 15617785 },
	{ 26, 21712633 },
	{ 26, 33459961 },
	{ 25, 15159033 },
	{ 25, 16142073 },
	{ 24, 8376061 },
	{ 24, 8294137 },
	{ 24, 4099833 },
	{ 24, 16518905 },
	{ 24, 16322297 },
	{ 24, 7982841 },
	{ 24, 8228605 },
	{ 26, 32902905 },
	{ 26, 31919865 },
	{ 26, 31969017 },
	{ 26, 33001213 },
	{ 26, 32378617 },
	{ 26, 30347001 },
	{ 27, 47845113 },
	{ 27, 43716345 },
	{ 26, 31330041 },
	{ 26, 27201273 },
	{ 26, 16387833 },
	{ 26, 12259065 },
	{ 24, 8261369 },
	{ 24, 4132601 },
	{ 19, 114538 },
	{ 24, 2052089 },
	{ 24, 6180857 },
	{ 26, 10178553 },
	{ 26, 14307321 },
	{ 25, 13586425 },
	{ 25, 15618041 },
	{ 26, 21712889 },
	{ 26, 33460217 },
	{ 25, 15159289 },
	{ 25, 16142329 },
	{ 24, 8376317 },
	{ 24, 8294393 },
	{ 24, 4100089 },
	{ 24, 16519161 },
	{ 24, 16322553 },
	{ 24, 7983097 },
	{ 24, 8228861 },
	{ 26, 32903161 },
	{ 26, 31920121 },
	{ 26, 31969273 },
	{ 26, 33001469 },
	{ 26, 32378873 },
	{ 26, 30347257 },
	{ 27, 47845369 },
	{ 27, 43716601 },
	{ 26, 31330297 },
	{ 26, 27201529 },
	{ 26, 16388089 },
	{ 26, 12259321 },
	{ 24, 8261625 },
	{ 24, 4132857 },
	{ 19, 130922 },
	{ 24, 3824377 },
	{ 24, 6249209 },
	{ 26, 10377977 },
	{ 26, 14375673 },
	{ 26, 26893049 },
	{ 25, 15686393 },
	{ 26, 21912313 },
	{ 26, 23812857 },
	{ 26, 33266425 },
	{ 25, 16210681 },
	{ 26, 16489209 },
	{ 24, 8313597 },
	{ 24, 8100601 },
	{ 24, 3906297 },
	{ 24, 16259833 },
	{ 24, 15538937 },
	{ 24, 8248057 },
	{ 24, 15309565 },
	{ 26, 31857401 },
	{ 26, 28777209 },
	{ 26, 33020665 },
	{ 26, 32185081 },
	{ 26, 30284537 },
	{ 26, 24058617 },
	{ 27, 43653881 },
	{ 26, 31136505 },
	{ 26, 27138809 },
	{ 26, 14621433 },
	{ 26, 12196601 },
	{ 24, 8067833 },
	{ 24, 4070137 },
	{ 19, 212458 },
	{ 24, 3824633 },
	{ 24, 6249465 },
	{ 26, 10378233 },
	{ 26, 14375929 },
	{ 26, 26893305 },
	{ 25, 15686649 },
	{ 26, 21912569 },
	{ 26, 23813113 },
	{ 26, 33266681 },
	{ 25, 16210937 },
	{ 26, 16489465 },
	{ 24, 8313853 },
	{ 24, 8100857 },
	{ 24, 3906553 },
	{ 24, 16260089 },
	{ 24, 15539193 },
	{ 24, 8248313 },
	{ 24, 15309821 },
	{ 26, 31857657 },
	{ 26, 28777465 },
	{ 26, 33020921 },
	{ 26, 32185337 },
	{ 26, 30284793 },
	{ 26, 24058873 },
	{ 27, 43654137 },
	{ 26, 31136761 },
	{ 26, 27139065 },
	{ 26, 14621689 },
	{ 26, 12196857 },
	{ 24, 8068089 },
	{ 24, 4070393 },
	{ 19, 228842 },
	{ 24, 3890937 },
	{ 24, 8019705 },
	{ 26, 10444537 },
	{ 26, 14573305 },
	{ 26, 26959609 },
	{ 26, 31088377 },
	{ 26, 21978873 },
	{ 26, 24010489 },
	{ 26, 30105337 },
	{ 26, 33201913 },
	{ 26, 29007609 },
	{ 26, 16424697 },
	{ 24, 8118013 },
	{ 24, 8036089 },
	{ 24, 3841785 },
	{ 24, 15474425 },
	{ 24, 15277817 },
	{ 24, 15326969 },
	{ 24, 15572733 },
	{ 26, 28712697 },
	{ 26, 27729657 },
	{ 26, 32120569 },
	{ 26, 30088953 },
	{ 26, 23994105 },
	{ 26, 21962489 },
	{ 26, 31071993 },
	{ 26, 26943225 },
	{ 26, 14556921 },
	{ 26, 10428153 },
	{ 24, 8003321 },
	{ 24, 3874553 },
	{ 19, 245098 },
	{ 24, 3891193 },
	{ 24, 8019961 },
	{ 26, 10444793 },
	{ 26, 14573561 },
	{ 26, 26959865 },
	{ 26, 31088633 },
	{ 26, 21979129 },
	{ 26, 24010745 },
	{ 26, 30105593 },
	{ 26, 33202169 },
	{ 26, 29007865 },
	{ 26, 16424953 },
	{ 24, 8118269 },
	{ 24, 8036345 },
	{ 24, 3842041 },
	{ 24, 15474681 },
	{ 24, 15278073 },
	{ 24, 15327225 },
	{ 24, 15572989 },
	{ 26, 28712953 },
	{ 26, 27729913 },
	{ 26, 32120825 },
	{ 26, 30089209 },
	{ 26, 23994361 },
	{ 26, 21962745 },
	{ 26, 31072249 },
	{ 26, 26943481 },
	{ 26, 14557177 },
	{ 26, 10428409 },
	{ 24, 8003577 },
	{ 24, 3874809 },
	{ 19, 261482 },
	{ 24, 4071421 },
	{ 24, 8265725 },
	{ 26, 12460029 },
	{ 26, 16654333 },
	{ 26, 29237245 },
	{ 26, 33431549 },
	{ 27, 46014461 },
	{ 27, 50208765 },
	{ 27, 62791677 },
	{ 27, 66985981 },
	{ 28, 125709049 },
	{ 28, 108931833 },
	{ 28, 58600185 },
	{ 26, 32189181 },
	{ 26, 25045753 },
	{ 26, 8268537 },
	{ 26, 60828409 },
	{ 26, 32779001 },
	{ 26, 62335737 },
	{ 26, 65415933 },
	{ 28, 110635769 },
	{ 27, 64760569 },
	{ 28, 120072953 },
	{ 28, 95169273 },
	{ 28, 87567097 },
	{ 27, 62663417 },
	{ 28, 107490041 },
	{ 28, 57420537 },
	{ 28, 41429753 },
	{ 26, 24914681 },
	{ 26, 15215353 },
	{ 20, 339946 },
	{ 26, 16329721 },
	{ 26, 32320505 },
	{ 28, 48835577 },
	{ 28, 58534905 },
	{ 28, 108604409 },
	{ 28, 124595193 },
	{ 29, 259927033 },
	{ 28, 96283641 },
	{ 28, 121187321 },
	{ 28, 128789497 },
	{ 28, 125709305 },
	{ 28, 108932089 },
	{ 28, 58600441 },
	{ 26, 32189437 },
	{ 26, 25046009 },
	{ 26, 8268793 },
	{ 26, 60828665 },
	{ 26, 32779257 },
	{ 26, 62335993 },
	{ 26, 65416189 },
	{ 28, 110636025 },
	{ 27, 64760825 },
	{ 28, 120073209 },
	{ 28, 95169529 },
	{ 28, 87567353 },
	{ 27, 62663673 },
	{ 28, 107490297 },
	{ 28, 57420793 },
	{ 28, 41430009 },
	{ 26, 24914937 },
	{ 26, 15215609 },
	{ 20, 356330 },
	{ 26, 16592633 },
	{ 26, 33107705 },
	{ 28, 49098489 },
	{ 28, 65613561 },
	{ 28, 108867321 },
	{ 28, 125382393 },
	{ 29, 174927609 },
	{ 29, 259665657 },
	{ 28, 121450233 },
	{ 28, 129576697 },
	{ 28, 125775613 },
	{ 28, 125447929 },
	{ 28, 108670713 },
	{ 28, 58339065 },
	{ 26, 25112317 },
	{ 26, 24784633 },
	{ 26, 8007417 },
	{ 26, 32517881 },
	{ 26, 31731449 },
	{ 26, 65482489 },
	{ 26, 66465533 },
	{ 27, 64499449 },
	{ 27, 60567289 },
	{ 28, 94908153 },
	{ 28, 86781689 },
	{ 27, 62402297 },
	{ 27, 54275833 },
	{ 28, 57159417 },
	{ 28, 40644345 },
	{ 26, 24653561 },
	{ 26, 8138489 },
	{ 20, 372586 },
	{ 26, 16592889 },
	{ 26, 33107961 },
	{ 28, 49098745 },
	{ 28, 65613817 },
	{ 28, 108867577 },
	{ 28, 125382649 },
	{ 29, 174927865 },
	{ 29, 259665913 },
	{ 28, 121450489 },
	{ 28, 129576953 },
	{ 28, 125775869 },
	{ 28, 125448185 },
	{ 28, 108670969 },
	{ 28, 58339321 },
	{ 26, 25112573 },
	{ 26, 24784889 },
	{ 26, 8007673 },
	{ 26, 32518137 },
	{ 26, 31731705 },
	{ 26, 65482745 },
	{ 26, 66465789 },
	{ 27, 64499705 },
	{ 27, 60567545 },
	{ 28, 94908409 },
	{ 28, 86781945 },
	{ 27, 62402553 },
	{ 27, 54276089 },
	{ 28, 57159673 },
	{ 28, 40644601 },
	{ 26, 24653817 },
	{ 26, 8138745 },
	{ 20, 388970 },
	{ 26, 15216637 },
	{ 26, 33372921 },
	{ 27, 66650107 },
	{ 28, 65878777 },
	{ 28, 115948281 },
	{ 28, 125647609 },
	{ 29, 175717113 },
	{ 29, 191707897 },
	{ 29, 258882297 },
	{ 28, 129841913 },
	{ 29, 191773433 },
	{ 28, 125516541 },
	{ 28, 124664569 },
	{ 28, 107887353 },
	{ 28, 57555705 },
	{ 26, 24853245 },
	{ 26, 24001273 },
	{ 26, 7224057 },
	{ 26, 31472377 },
	{ 26, 28588793 },
	{ 26, 66534137 },
	{ 27, 63716089 },
	{ 27, 60308217 },
	{ 27, 47987449 },
	{ 28, 86522617 },
	{ 27, 61618937 },
	{ 27, 54016761 },
	{ 27, 29113081 },
	{ 28, 40385273 },
	{ 26, 23870201 },
	{ 26, 7879417 },
	{ 20, 470506 },
	{ 26, 8141565 },
	{ 26, 33373177 },
	{ 27, 66649851 },
	{ 28, 65879033 },
	{ 28, 115948537 },
	{ 28, 125647865 },
	{ 29, 175717369 },
	{ 29, 191708153 },
	{ 29, 258882553 },
	{ 28, 129842169 },
	{ 29, 191773689 },
	{ 28, 125516797 },
	{ 28, 124664825 },
	{ 28, 107887609 },
	{ 28, 57555961 },
	{ 26, 24853501 },
	{ 26, 24001529 },
	{ 26, 7224313 },
	{ 26, 31472633 },
	{ 26, 28589049 },
	{ 26, 66534393 },
	{ 27, 63716345 },
	{ 27, 60308473 },
	{ 27, 47987705 },
	{ 28, 86522873 },
	{ 27, 61619193 },
	{ 27, 54017017 },
	{ 27, 29113337 },
	{ 28, 40385529 },
	{ 26, 23870457 },
	{ 26, 7879673 },
	{ 20, 486890 },
	{ 26, 8141821 },
	{ 26, 24919037 },
	{ 27, 50003711 },
	{ 28, 66666233 },
	{ 28, 116211449 },
	{ 28, 132726521 },
	{ 29, 175980281 },
	{ 29, 192495353 },
	{ 29, 242040569 },
	{ 29, 258621177 },
	{ 29, 241843961 },
	{ 29, 191512313 },
	{ 28, 124731133 },
	{ 28, 124403449 },
	{ 28, 107626233 },
	{ 28, 57294585 },
	{ 26, 24067837 },
	{ 26, 23740153 },
	{ 26, 6962937 },
	{ 26, 28327673 },
	{ 26, 27541241 },
	{ 27, 63454969 },
	{ 27, 59522809 },
	{ 27, 47726329 },
	{ 27, 43794169 },
	{ 27, 61357817 },
	{ 27, 53231353 },
	{ 27, 28851961 },
	{ 27, 20725497 },
	{ 26, 23609081 },
	{ 26, 7094009 },
	{ 20, 503146 },
	{ 26, 7880445 },
	{ 26, 24657661 },
	{ 27, 49478655 },
	{ 28, 66666489 },
	{ 28, 116211705 },
	{ 28, 132726777 },
	{ 29, 175980537 },
	{ 29, 192495609 },
	{ 29, 242040825 },
	{ 29, 258621433 },
	{ 29, 241844217 },
	{ 29, 191512569 },
	{ 28, 124731389 },
	{ 28, 124403705 },
	{ 28, 107626489 },
	{ 28, 57294841 },
	{ 26, 24068093 },
	{ 26, 23740409 },
	{ 26, 6963193 },
	{ 26, 28327929 },
	{ 26, 27541497 },
	{ 27, 63455225 },
	{ 27, 59523065 },
	{ 27, 47726585 },
	{ 27, 43794425 },
	{ 27, 61358073 },
	{ 27, 53231609 },
	{ 27, 28852217 },
	{ 27, 20725753 },
	{ 26, 23609337 },
	{ 26, 7094265 },
	{ 20, 519530 },
	{ 26, 7880701 },
	{ 26, 24657917 },
	{ 27, 49478399 },
	{ 28, 66939641 },
	{ 28, 117009145 },
	{ 28, 132999929 },
	{ 29, 264137465 },
	{ 29, 255748857 },
	{ 29, 230583033 },
	{ 29, 222194425 },
	{ 28, 129919737 },
	{ 28, 121531129 },
	{ 28, 96365305 },
	{ 28, 87976697 },
	{ 27, 62810873 },
	{ 27, 54422265 },
	{ 27, 29256441 },
	{ 26, 23816957 },
	{ 25, 12479225 },
	{ 25, 4090617 },
	{ 26, 27290361 },
	{ 25, 16018169 },
	{ 26, 32174075 },
	{ 27, 46951161 },
	{ 27, 43543289 },
	{ 26, 31222521 },
	{ 27, 52980473 },
	{ 27, 28076793 },
	{ 27, 20474617 },
	{ 25, 12348153 },
	{ 26, 6843129 },
	{ 20, 432106 },
	{ 26, 7105277 },
	{ 26, 23882493 },
	{ 27, 47902719 },
	{ 28, 66939897 },
	{ 28, 117009401 },
	{ 28, 133000185 },
	{ 29, 264137721 },
	{ 29, 255749113 },
	{ 29, 230583289 },
	{ 29, 222194681 },
	{ 28, 129919993 },
	{ 28, 121531385 },
	{ 28, 96365561 },
	{ 28, 87976953 },
	{ 27, 62811129 },
	{ 27, 54422521 },
	{ 27, 29256697 },
	{ 26, 23817213 },
	{ 25, 12479481 },
	{ 25, 4090873 },
	{ 26, 27290617 },
	{ 25, 16018425 },
	{ 26, 32173819 },
	{ 27, 46951417 },
	{ 27, 43543545 },
	{ 26, 31222777 },
	{ 27, 52980729 },
	{ 27, 28077049 },
	{ 27, 20474873 },
	{ 25, 12348409 },
	{ 26, 6843385 },
	{ 20, 440298 },
	{ 26, 7105533 },
	{ 26, 23882749 },
	{ 27, 47902463 },
	{ 28, 57437181 },
	{ 28, 117272313 },
	{ 28, 133787385 },
	{ 29, 490368761 },
	{ 29, 263876345 },
	{ 29, 255487737 },
	{ 29, 230321913 },
	{ 28, 129986301 },
	{ 28, 129658617 },
	{ 28, 121270009 },
	{ 28, 96104185 },
	{ 27, 62877437 },
	{ 27, 62549753 },
	{ 27, 54161145 },
	{ 27, 28995321 },
	{ 25, 12545789 },
	{ 25, 12218105 },
	{ 25, 3829497 },
	{ 25, 15757049 },
	{ 25, 14970617 },
	{ 26, 30075899 },
	{ 27, 42757881 },
	{ 26, 30961401 },
	{ 26, 27029241 },
	{ 27, 27815673 },
	{ 27, 19689209 },
	{ 25, 12087033 },
	{ 25, 3960569 },
	{ 20, 448362 },
	{ 26, 6844157 },
	{ 26, 23621373 },
	{ 27, 47377407 },
	{ 28, 57175805 },
	{ 28, 117272569 },
	{ 28, 133787641 },
	{ 29, 490369017 },
	{ 29, 263876601 },
	{ 29, 255487993 },
	{ 29, 230322169 },
	{ 28, 129986557 },
	{ 28, 129658873 },
	{ 28, 121270265 },
	{ 28, 96104441 },
	{ 27, 62877693 },
	{ 27, 62550009 },
	{ 27, 54161401 },
	{ 27, 28995577 },
	{ 25, 12546045 },
	{ 25, 12218361 },
	{ 25, 3829753 },
	{ 25, 15757305 },
	{ 25, 14970873 },
	{ 26, 30075643 },
	{ 27, 42758137 },
	{ 26, 30961657 },
	{ 26, 27029497 },
	{ 27, 27815929 },
	{ 27, 19689465 },
	{ 25, 12087289 },
	{ 25, 3960825 },
	{ 20, 456554 },
	{ 26, 6844413 },
	{ 26, 23621629 },
	{ 27, 47377151 },
	{ 28, 57176061 },
	{ 28, 107507709 },
	{ 28, 134052601 },
	{ 29, 497974009 },
	{ 29, 489585401 },
	{ 29, 263092985 },
	{ 29, 254704377 },
	{ 29, 229538553 },
	{ 28, 129727229 },
	{ 28, 128875257 },
	{ 28, 120486649 },
	{ 28, 95320825 },
	{ 27, 62618365 },
	{ 27, 61766393 },
	{ 27, 53377785 },
	{ 27, 28211961 },
	{ 25, 12286717 },
	{ 25, 11434745 },
	{ 25, 3046137 },
	{ 25, 14711545 },
	{ 25, 11827961 },
	{ 26, 23773179 },
	{ 26, 30178041 },
	{ 26, 26770169 },
	{ 26, 14449401 },
	{ 27, 19430137 },
	{ 25, 11303673 },
	{ 25, 3701497 },
	{ 20, 497130 },
	{ 20, 1045918 },
	{ 25, 12352253 },
	{ 26, 24821759 },
	{ 27, 29129469 },
	{ 27, 54295293 },
	{ 27, 62683901 },
	{ 28, 87849725 },
	{ 28, 96238333 },
	{ 28, 121404157 },
	{ 28, 129792765 },
	{ 29, 229538809 },
	{ 28, 129727485 },
	{ 28, 128875513 },
	{ 28, 120486905 },
	{ 28, 95321081 },
	{ 27, 62618621 },
	{ 27, 61766649 },
	{ 27, 53378041 },
	{ 27, 28212217 },
	{ 25, 12286973 },
	{ 25, 11435001 },
	{ 25, 3046393 },
	{ 25, 14711801 },
	{ 25, 11828217 },
	{ 26, 23772923 },
	{ 26, 30178297 },
	{ 26, 26770425 },
	{ 26, 14449657 },
	{ 27, 19430393 },
	{ 25, 11303929 },
	{ 25, 3701753 },
	{ 20, 505322 },
	{ 20, 1037726 },
	{ 25, 12352509 },
	{ 26, 24821503 },
	{ 27, 29129725 },
	{ 27, 54295549 },
	{ 27, 62684157 },
	{ 28, 87849981 },
	{ 28, 96238589 },
	{ 28, 121404413 },
	{ 28, 129793021 },
	{ 29, 254443257 },
	{ 29, 229277433 },
	{ 28, 128941821 },
	{ 28, 128614137 },
	{ 28, 120225529 },
	{ 28, 95059705 },
	{ 27, 61832957 },
	{ 27, 61505273 },
	{ 27, 53116665 },
	{ 27, 27950841 },
	{ 25, 11501309 },
	{ 25, 11173625 },
	{ 25, 2785017 },
	{ 25, 11566841 },
	{ 25, 10780409 },
	{ 26, 29916921 },
	{ 26, 25984761 },
	{ 26, 14188281 },
	{ 26, 10256121 },
	{ 25, 11042553 },
	{ 25, 2916089 },
	{ 20, 513386 },
	{ 20, 1029406 },
	{ 25, 12091133 },
	{ 26, 24296447 },
	{ 27, 28868349 },
	{ 27, 54034173 },
	{ 27, 62422781 },
	{ 28, 87588605 },
	{ 28, 95977213 },
	{ 28, 121143037 },
	{ 28, 129531645 },
	{ 29, 254443513 },
	{ 29, 229277689 },
	{ 28, 128942077 },
	{ 28, 128614393 },
	{ 28, 120225785 },
	{ 28, 95059961 },
	{ 27, 61833213 },
	{ 27, 61505529 },
	{ 27, 53116921 },
	{ 27, 27951097 },
	{ 25, 11501565 },
	{ 25, 11173881 },
	{ 25, 2785273 },
	{ 25, 11567097 },
	{ 25, 10780665 },
	{ 26, 29917177 },
	{ 26, 25985017 },
	{ 26, 14188537 },
	{ 26, 10256377 },
	{ 25, 11042809 },
	{ 25, 2916345 },
	{ 20, 521578 },
	{ 20, 1021214 },
	{ 25, 12091389 },
	{ 26, 24296191 },
	{ 27, 28868605 },
	{ 27, 54034429 },
	{ 27, 62423037 },
	{ 28, 87588861 },
	{ 28, 95977469 },
	{ 28, 121143293 },
	{ 28, 129531901 },
	{ 29, 264022777 },
	{ 29, 255634169 },
	{ 29, 230468345 },
	{ 29, 222079737 },
	{ 28, 129805049 },
	{ 28, 121416441 },
	{ 28, 96250617 },
	{ 28, 87862009 },
	{ 27, 62696185 },
	{ 27, 54307577 },
	{ 27, 29141753 },
	{ 26, 22457085 },
	{ 25, 12364537 },
	{ 25, 3975929 },
	{ 25, 15118331 },
	{ 25, 15248121 },
	{ 25, 15380475 },
	{ 27, 26782457 },
	{ 27, 19966713 },
	{ 25, 12102393 },
	{ 25, 12234747 },
	{ 19, 478186 },
	{ 19, 490398 },
	{ 26, 22588157 },
	{ 26, 22720511 },
	{ 28, 56142589 },
	{ 28, 106474237 },
	{ 28, 123251453 },
	{ 28, 123383807 },
	{ 29, 524069881 },
	{ 29, 498904057 },
	{ 29, 490515449 },
	{ 29, 264023033 },
	{ 29, 255634425 },
	{ 29, 230468601 },
	{ 29, 222079993 },
	{ 28, 129805305 },
	{ 28, 121416697 },
	{ 28, 96250873 },
	{ 28, 87862265 },
	{ 27, 62696441 },
	{ 27, 54307833 },
	{ 27, 29142009 },
	{ 26, 22457341 },
	{ 25, 12364793 },
	{ 25, 3976185 },
	{ 25, 15118075 },
	{ 25, 15248377 },
	{ 25, 15380219 },
	{ 27, 26782713 },
	{ 27, 19966969 },
	{ 25, 12102649 },
	{ 25, 12234491 },
	{ 19, 482282 },
	{ 19, 486302 },
	{ 26, 22588413 },
	{ 26, 22720255 },
	{ 28, 56142845 },
	{ 28, 106474493 },
	{ 28, 123251709 },
	{ 28, 123383551 },
	{ 29, 531934969 },
	{ 29, 523546361 },
	{ 29, 498380537 },
	{ 29, 489991929 },
	{ 29, 263499513 },
	{ 29, 255110905 },
	{ 29, 229945081 },
	{ 28, 129937149 },
	{ 28, 129281785 },
	{ 28, 120893177 },
	{ 28, 95727353 },
	{ 27, 62828285 },
	{ 27, 62172921 },
	{ 27, 53784313 },
	{ 27, 28618489 },
	{ 25, 12496637 },
	{ 25, 11841273 },
	{ 25, 3452665 },
	{ 25, 14724857 },
	{ 25, 13151993 },
	{ 25, 13282299 },
	{ 27, 18394873 },
	{ 25, 11579129 },
	{ 25, 3714809 },
	{ 19, 486250 },
	{ 19, 482078 },
	{ 26, 22064893 },
	{ 26, 22195199 },
	{ 28, 55619325 },
	{ 28, 105950973 },
	{ 28, 122728189 },
	{ 28, 122858495 },
	{ 29, 531935225 },
	{ 29, 523546617 },
	{ 29, 498380793 },
	{ 29, 489992185 },
	{ 29, 263499769 },
	{ 29, 255111161 },
	{ 29, 229945337 },
	{ 28, 129937405 },
	{ 28, 129282041 },
	{ 28, 120893433 },
	{ 28, 95727609 },
	{ 27, 62828541 },
	{ 27, 62173177 },
	{ 27, 53784569 },
	{ 27, 28618745 },
	{ 25, 12496893 },
	{ 25, 11841529 },
	{ 25, 3452921 },
	{ 25, 14725113 },
	{ 25, 13152249 },
	{ 25, 13282043 },
	{ 27, 18395129 },
	{ 25, 11579385 },
	{ 25, 3715065 },
	{ 19, 490346 },
	{ 19, 477982 },
	{ 26, 22065149 },
	{ 26, 22194943 },
	{ 28, 55619581 },
	{ 28, 105951229 },
	{ 28, 122728445 },
	{ 28, 122858239 },
	{ 29, 532069117 },
	{ 28, 117342207 },
	{ 28, 67076091 },
	{ 28, 66813947 },
	{ 28, 66027515 },
	{ 28, 65765371 },
	{ 28, 58687483 },
	{ 28, 58425339 },
	{ 28, 129415933 },
	{ 27, 54427647 },
	{ 27, 29327355 },
	{ 27, 29065211 },
	{ 27, 62307069 },
	{ 26, 27164671 },
	{ 26, 14647291 },
	{ 26, 14385147 },
	{ 25, 11975421 },
	{ 24, 6717439 },
	{ 24, 3637243 },
	{ 24, 3375099 },
	{ 24, 6389755 },
	{ 24, 3506171 },
	{ 25, 10009337 },
	{ 24, 5079035 },
	{ 19, 510442 },
	{ 19, 260510 },
	{ 24, 1933311 },
	{ 24, 6127615 },
	{ 26, 10321919 },
	{ 26, 14516223 },
	{ 26, 27099135 },
	{ 26, 31293439 },
	{ 27, 43876351 },
	{ 27, 48070655 },
	{ 27, 60653567 },
	{ 27, 64847871 },
	{ 28, 66027259 },
	{ 28, 65765115 },
	{ 28, 58687227 },
	{ 28, 58425083 },
	{ 28, 129416189 },
	{ 27, 54427391 },
	{ 27, 29327099 },
	{ 27, 29064955 },
	{ 27, 62307325 },
	{ 26, 27164415 },
	{ 26, 14647035 },
	{ 26, 14384891 },
	{ 25, 11975677 },
	{ 24, 6717183 },
	{ 24, 3636987 },
	{ 24, 3374843 },
	{ 24, 6389499 },
	{ 24, 3505915 },
	{ 25, 10009593 },
	{ 24, 5078779 },
	{ 19, 514538 },
	{ 19, 256414 },
	{ 24, 1933055 },
	{ 24, 6127359 },
	{ 26, 10321663 },
	{ 26, 14515967 },
	{ 26, 27098879 },
	{ 26, 31293183 },
	{ 27, 43876095 },
	{ 27, 48070399 },
	{ 27, 60653311 },
	{ 27, 64847615 },
	{ 28, 50035707 },
	{ 28, 49249275 },
	{ 28, 48987131 },
	{ 28, 41909243 },
	{ 28, 41647099 },
	{ 28, 127844093 },
	{ 27, 29260799 },
	{ 27, 20937723 },
	{ 27, 20675579 },
	{ 27, 60735229 },
	{ 26, 14580735 },
	{ 26, 10451963 },
	{ 26, 10189819 },
	{ 25, 10403581 },
	{ 24, 3570687 },
	{ 24, 2587643 },
	{ 24, 2325499 },
	{ 24, 3243003 },
	{ 24, 2456571 },
	{ 24, 4815867 },
	{ 19, 518506 },
	{ 19, 252190 },
	{ 24, 1670143 },
	{ 24, 5864447 },
	{ 26, 10058751 },
	{ 26, 14253055 },
	{ 26, 26835967 },
	{ 26, 31030271 },
	{ 27, 43613183 },
	{ 27, 47807487 },
	{ 27, 60390399 },
	{ 27, 64584703 },
	{ 28, 50035451 },
	{ 28, 49249019 },
	{ 28, 48986875 },
	{ 28, 41908987 },
	{ 28, 41646843 },
	{ 28, 127844349 },
	{ 27, 29260543 },
	{ 27, 20937467 },
	{ 27, 20675323 },
	{ 27, 60735485 },
	{ 26, 14580479 },
	{ 26, 10451707 },
	{ 26, 10189563 },
	{ 25, 10403837 },
	{ 24, 3570431 },
	{ 24, 2587387 },
	{ 24, 2325243 },
	{ 24, 3242747 },
	{ 24, 2456315 },
	{ 24, 4815611 },
	{ 19, 522602 },
	{ 19, 248094 },
	{ 24, 1669887 },
	{ 24, 5864191 },
	{ 26, 10058495 },
	{ 26, 14252799 },
	{ 26, 26835711 },
	{ 26, 31030015 },
	{ 27, 43612927 },
	{ 27, 47807231 },
	{ 27, 60390143 },
	{ 27, 132967161 },
	{ 26, 33517563 },
	{ 26, 33255419 },
	{ 26, 32468987 },
	{ 26, 32206843 },
	{ 26, 25128955 },
	{ 26, 24866811 },
	{ 26, 24080379 },
	{ 26, 32303865 },
	{ 25, 12546043 },
	{ 25, 12283899 },
	{ 25, 11497467 },
	{ 25, 15526649 },
	{ 24, 6254587 },
	{ 24, 5992443 },
	{ 24, 5206011 },
	{ 23, 2943737 },
	{ 22, 1535995 },
	{ 22, 1273851 },
	{ 23, 2681593 },
	{ 22, 1404923 },
	{ 24, 618491 },
	{ 17, 56990 },
	{ 24, 880639 },
	{ 24, 5074943 },
	{ 26, 9269247 },
	{ 26, 13463551 },
	{ 26, 26046463 },
	{ 26, 30240767 },
	{ 27, 42823679 },
	{ 27, 47017983 },
	{ 27, 59600895 },
	{ 27, 132967417 },
	{ 26, 33517307 },
	{ 26, 33255163 },
	{ 26, 32468731 },
	{ 26, 32206587 },
	{ 26, 25128699 },
	{ 26, 24866555 },
	{ 26, 24080123 },
	{ 26, 32304121 },
	{ 25, 12545787 },
	{ 25, 12283643 },
	{ 25, 11497211 },
	{ 25, 15526905 },
	{ 24, 6254331 },
	{ 24, 5992187 },
	{ 24, 5205755 },
	{ 23, 2943993 },
	{ 22, 1535739 },
	{ 22, 1273595 },
	{ 23, 2681849 },
	{ 22, 1404667 },
	{ 24, 618235 },
	{ 17, 55966 },
	{ 24, 880383 },
	{ 24, 5074687 },
	{ 26, 9268991 },
	{ 26, 13463295 },
	{ 26, 26046207 },
	{ 26, 30240511 },
	{ 27, 42823423 },
	{ 27, 47017727 },
	{ 27, 59600639 },
	{ 27, 133099261 },
	{ 26, 33451007 },
	{ 26, 16739323 },
	{ 26, 16477179 },
	{ 26, 15690747 },
	{ 26, 15428603 },
	{ 26, 8350715 },
	{ 26, 8088571 },
	{ 26, 32435965 },
	{ 25, 12479487 },
	{ 25, 4156411 },
	{ 25, 3894267 },
	{ 25, 15658749 },
	{ 24, 6188031 },
	{ 24, 2059259 },
	{ 24, 1797115 },
	{ 23, 3075837 },
	{ 22, 1469439 },
	{ 22, 486395 },
	{ 22, 224251 },
	{ 18, 110459 },
	{ 22, 2097083 },
	{ 17, 54814 },
	{ 24, 617471 },
	{ 24, 4811775 },
	{ 26, 9006079 },
	{ 26, 13200383 },
	{ 26, 25783295 },
	{ 26, 29977599 },
	{ 27, 42560511 },
	{ 27, 46754815 },
	{ 27, 59337727 },
	{ 27, 133099517 },
	{ 26, 33450751 },
	{ 26, 16739067 },
	{ 26, 16476923 },
	{ 26, 15690491 },
	{ 26, 15428347 },
	{ 26, 8350459 },
	{ 26, 8088315 },
	{ 26, 32436221 },
	{ 25, 12479231 },
	{ 25, 4156155 },
	{ 25, 3894011 },
	{ 25, 15659005 },
	{ 24, 6187775 },
	{ 24, 2059003 },
	{ 24, 1796859 },
	{ 23, 3076093 },
	{ 22, 1469183 },
	{ 22, 486139 },
	{ 22, 223995 },
	{ 18, 108411 },
	{ 21, 1048187 },
	{ 17, 53790 },
	{ 24, 617215 },
	{ 24, 4811519 },
	{ 26, 9005823 },
	{ 26, 13200127 },
	{ 26, 25783039 },
	{ 26, 29977343 },
	{ 27, 42560255 },
	{ 27, 46754559 },
	{ 27, 59337471 },
	{ 27, 63531775 },
	{ 27, 132578045 },
	{ 26, 16662527 },
	{ 26, 16400383 },
	{ 26, 15613951 },
	{ 26, 15351807 },
	{ 26, 8273919 },
	{ 26, 8011775 },
	{ 26, 7225343 },
	{ 26, 31914749 },
	{ 25, 4079615 },
	{ 25, 3817471 },
	{ 25, 3031039 },
	{ 25, 15137533 },
	{ 24, 1982463 },
	{ 24, 1720319 },
	{ 24, 933887 },
	{ 23, 2554621 },
	{ 22, 409599 },
	{ 22, 147455 },
	{ 19, 261951 },
	{ 19, 261995 },
	{ 19, 261950 },
	{ 21, 1048511 },
	{ 22, 1392639 },
	{ 24, 2441215 },
	{ 24, 3489791 },
	{ 24, 6635519 },
	{ 24, 7684095 },
	{ 25, 10829823 },
	{ 25, 11878399 },
	{ 25, 15024127 },
	{ 25, 16072703 },
	{ 26, 27607039 },
	{ 26, 16662271 },
	{ 26, 16400127 },
	{ 26, 15613695 },
	{ 26, 15351551 },
	{ 26, 8273663 },
	{ 26, 8011519 },
	{ 26, 7225087 },
	{ 26, 31915005 },
	{ 25, 4079359 },
	{ 25, 3817215 },
	{ 25, 3030783 },
	{ 25, 15137789 },
	{ 24, 1982207 },
	{ 24, 1720063 },
	{ 24, 933631 },
	{ 23, 2554877 },
	{ 22, 409343 },
	{ 22, 147199 },
	{ 19, 262127 },
	{ 16, 32731 },
	{ 13, 3022 },
	{ 20, 523903 },
	{ 22, 1392383 },
	{ 24, 2440959 },
	{ 24, 3489535 },
	{ 24, 6635263 },
	{ 24, 7683839 },
	{ 25, 10829567 },
	{ 25, 11878143 },
	{ 25, 15023871 },
	{ 25, 16072447 },
	{ 26, 27606783 },
	{ 26, 28655359 },
	{ 26, 31801087 },
	{ 26, 32849663 },
	{ 26, 61161215 },
	{ 26, 62209791 },
	{ 26, 65355519 },
	{ 26, 66404095 },
	{ 26, 31472639 },
	{ 26, 28326911 },
	{ 26, 31653629 },
	{ 25, 15743999 },
	{ 25, 14695423 },
	{ 25, 11549695 },
	{ 25, 14876413 },
	{ 24, 7355391 },
	{ 24, 6306815 },
	{ 24, 3161087 },
	{ 23, 2293501 },
	{ 17, 60799 },
	{ 15, 16335 },
	{ 13, 2958 },
	{ 18, 130927 },
	{ 17, 61311 },
	{ 24, 2178047 },
	{ 24, 3226623 },
	{ 24, 6372351 },
	{ 24, 7420927 },
	{ 25, 10566655 },
	{ 25, 11615231 },
	{ 25, 14760959 },
	{ 25, 15809535 },
	{ 26, 27343871 },
	{ 26, 28392447 },
	{ 26, 31538175 },
	{ 26, 66075391 },
	{ 26, 65026815 },
	{ 26, 61881087 },
	{ 26, 60832511 },
	{ 26, 32520959 },
	{ 26, 31472383 },
	{ 26, 28326655 },
	{ 26, 31653885 },
	{ 25, 15743743 },
	{ 25, 14695167 },
	{ 25, 11549439 },
	{ 25, 14876669 },
	{ 24, 7355135 },
	{ 24, 6306559 },
	{ 24, 3160831 },
	{ 23, 2293757 },
	{ 17, 58751 },
	{ 16, 32687 },
	{ 23, 65533 },
	{ 15, 16351 },
	{ 17, 59263 },
	{ 24, 2177791 },
	{ 24, 3226367 },
	{ 24, 6372095 },
	{ 24, 7420671 },
	{ 25, 10566399 },
	{ 25, 11614975 },
	{ 25, 14760703 },
	{ 25, 15809279 },
	{ 26, 27343615 },
	{ 26, 28392191 },
	{ 26, 31537919 },
	{ 26, 32586495 },
	{ 26, 60898047 },
	{ 26, 61946623 },
	{ 26, 65092351 },
	{ 26, 66140927 },
	{ 26, 31731711 },
	{ 26, 28585983 },
	{ 26, 27537407 },
	{ 25, 16003071 },
	{ 25, 14954495 },
	{ 25, 11808767 },
	{ 25, 10760191 },
	{ 24, 7614463 },
	{ 24, 6565887 },
	{ 24, 3420159 },
	{ 24, 5614333 },
	{ 22, 1323007 },
	{ 18, 130751 },
	{ 16, 32734 },
	{ 14, 8139 },
	{ 17, 65339 },
	{ 22, 208895 },
	{ 22, 1257471 },
	{ 24, 2306047 },
	{ 24, 3354623 },
	{ 24, 6500351 },
	{ 24, 7548927 },
	{ 25, 10694655 },
	{ 25, 11743231 },
	{ 25, 14888959 },
	{ 25, 15937535 },
	{ 26, 27471871 },
	{ 26, 66334463 },
	{ 26, 65285887 },
	{ 26, 62140159 },
	{ 26, 61091583 },
	{ 26, 32780031 },
	{ 26, 31731455 },
	{ 26, 28585727 },
	{ 26, 27537151 },
	{ 25, 16002815 },
	{ 25, 14954239 },
	{ 25, 11808511 },
	{ 25, 10759935 },
	{ 24, 7614207 },
	{ 24, 6565631 },
	{ 24, 3419903 },
	{ 24, 5614589 },
	{ 22, 1322751 },
	{ 19, 261567 },
	{ 16, 32606 },
	{ 15, 16299 },
	{ 17, 65515 },
	{ 22, 208639 },
	{ 22, 1257215 },
	{ 24, 2305791 },
	{ 24, 3354367 },
	{ 24, 6500095 },
	{ 24, 7548671 },
	{ 25, 10694399 },
	{ 25, 11742975 },
	{ 25, 14888703 },
	{ 25, 15937279 },
	{ 26, 27471615 },
	{ 26, 28520191 },
	{ 26, 31665919 },
	{ 26, 32714495 },
	{ 26, 61026047 },
	{ 26, 62074623 },
	{ 26, 65220351 },
	{ 26, 66268927 },
	{ 28, 109587455 },
	{ 27, 63450111 },
	{ 27, 59255807 },
	{ 27, 46672895 },
	{ 27, 42478591 },
	{ 26, 29895679 },
	{ 26, 25701375 },
	{ 26, 13118463 },
	{ 26, 19246845 },
	{ 24, 4729855 },
	{ 24, 535551 },
	{ 16, 22126 },
	{ 17, 65211 },
	{ 17, 44411 },
	{ 22, 142331 },
	{ 22, 1190907 },
	{ 22, 1518591 },
	{ 24, 3288059 },
	{ 24, 6433787 },
	{ 24, 7482363 },
	{ 24, 7810047 },
	{ 25, 11676667 },
	{ 25, 14822395 },
	{ 25, 15870971 },
	{ 25, 16198655 },
	{ 26, 28453883 },
	{ 26, 31599611 },
	{ 26, 32648187 },
	{ 26, 60959739 },
	{ 26, 62008315 },
	{ 26, 65154043 },
	{ 26, 66202619 },
	{ 26, 66530303 },
	{ 27, 63449855 },
	{ 27, 59255551 },
	{ 27, 46672639 },
	{ 27, 42478335 },
	{ 26, 29895423 },
	{ 26, 25701119 },
	{ 26, 13118207 },
	{ 26, 19247101 },
	{ 24, 4729599 },
	{ 24, 535295 },
	{ 16, 21102 },
	{ 18, 130491 },
	{ 17, 42363 },
	{ 22, 142075 },
	{ 22, 1190651 },
	{ 22, 1518335 },
	{ 24, 3287803 },
	{ 24, 6433531 },
	{ 24, 7482107 },
	{ 24, 7809791 },
	{ 25, 11676411 },
	{ 25, 14822139 },
	{ 25, 15870715 },
	{ 25, 16198399 },
	{ 26, 28453627 },
	{ 26, 31599355 },
	{ 26, 32647931 },
	{ 26, 60959483 },
	{ 26, 62008059 },
	{ 26, 65153787 },
	{ 26, 66202363 },
	{ 26, 66530047 },
	{ 25, 15933439 },
	{ 25, 14884863 },
	{ 25, 11739135 },
	{ 25, 10690559 },
	{ 24, 7544831 },
	{ 24, 6496255 },
	{ 24, 3350527 },
	{ 24, 2301951 },
	{ 22, 1253375 },
	{ 22, 204799 },
	{ 15, 16110 },
	{ 22, 139259 },
	{ 20, 335867 },
	{ 22, 532475 },
	{ 20, 106491 },
	{ 20, 368635 },
	{ 22, 630779 },
	{ 22, 892923 },
	{ 22, 1679355 },
	{ 22, 1941499 },
	{ 23, 2727931 },
	{ 23, 2990075 },
	{ 23, 3776507 },
	{ 23, 4038651 },
	{ 24, 6922235 },
	{ 24, 7184379 },
	{ 24, 7970811 },
	{ 24, 8232955 },
	{ 24, 15310843 },
	{ 24, 15572987 },
	{ 24, 16359419 },
	{ 24, 16621563 },
	{ 25, 15933183 },
	{ 25, 14884607 },
	{ 25, 11738879 },
	{ 25, 10690303 },
	{ 24, 7544575 },
	{ 24, 6495999 },
	{ 24, 3350271 },
	{ 24, 2301695 },
	{ 22, 1253119 },
	{ 22, 204543 },
	{ 15, 15086 },
	{ 22, 139003 },
	{ 20, 335611 },
	{ 22, 532219 },
	{ 20, 106235 },
	{ 20, 368379 },
	{ 22, 630523 },
	{ 22, 892667 },
	{ 22, 1679099 },
	{ 22, 1941243 },
	{ 23, 2727675 },
	{ 23, 2989819 },
	{ 23, 3776251 },
	{ 23, 4038395 },
	{ 24, 6921979 },
	{ 24, 7184123 },
	{ 24, 7970555 },
	{ 24, 8232699 },
	{ 24, 15310587 },
	{ 24, 15572731 },
	{ 24, 16359163 },
	{ 24, 16621307 },
	{ 25, 16129023 },
	{ 25, 15080447 },
	{ 25, 11934719 },
	{ 25, 10886143 },
	{ 24, 7740415 },
	{ 24, 6691839 },
	{ 24, 3546111 },
	{ 24, 2497535 },
	{ 22, 1448959 },
	{ 22, 400383 },
	{ 17, 55662 },
	{ 22, 203771 },
	{ 22, 1186811 },
	{ 22, 596987 },
	{ 22, 793595 },
	{ 22, 171003 },
	{ 22, 1219579 },
	{ 22, 1301503 },
	{ 24, 3316731 },
	{ 24, 6462459 },
	{ 24, 7511035 },
	{ 24, 7592959 },
	{ 25, 11705339 },
	{ 25, 14851067 },
	{ 25, 15899643 },
	{ 25, 15981567 },
	{ 26, 28482555 },
	{ 26, 31628283 },
	{ 26, 32676859 },
	{ 26, 60988411 },
	{ 26, 62036987 },
	{ 26, 65182715 },
	{ 25, 16128767 },
	{ 25, 15080191 },
	{ 25, 11934463 },
	{ 25, 10885887 },
	{ 24, 7740159 },
	{ 24, 6691583 },
	{ 24, 3545855 },
	{ 24, 2497279 },
	{ 22, 1448703 },
	{ 22, 400127 },
	{ 17, 51566 },
	{ 22, 203515 },
	{ 22, 1186555 },
	{ 22, 596731 },
	{ 22, 793339 },
	{ 22, 170747 },
	{ 22, 1219323 },
	{ 22, 1301247 },
	{ 24, 3316475 },
	{ 24, 6462203 },
	{ 24, 7510779 },
	{ 24, 7592703 },
	{ 25, 11705083 },
	{ 25, 14850811 },
	{ 25, 15899387 },
	{ 25, 15981311 },
	{ 26, 28482299 },
	{ 26, 31628027 },
	{ 26, 32676603 },
	{ 26, 60988155 },
	{ 26, 62036731 },
	{ 26, 65182459 },
	{ 25, 16191487 },
	{ 25, 15142911 },
	{ 25, 11997183 },
	{ 25, 10948607 },
	{ 24, 7802879 },
	{ 24, 6754303 },
	{ 24, 3608575 },
	{ 24, 2559999 },
	{ 22, 1511423 },
	{ 22, 462847 },
	{ 17, 31214 },
	{ 22, 397307 },
	{ 22, 1249275 },
	{ 24, 2232315 },
	{ 22, 856059 },
	{ 22, 1576955 },
	{ 22, 233467 },
	{ 22, 1282043 },
	{ 22, 1495039 },
	{ 24, 3379195 },
	{ 24, 6524923 },
	{ 24, 7573499 },
	{ 24, 7786495 },
	{ 25, 11767803 },
	{ 25, 14913531 },
	{ 25, 15962107 },
	{ 25, 16175103 },
	{ 26, 28545019 },
	{ 26, 31690747 },
	{ 26, 32739323 },
	{ 26, 61050875 },
	{ 26, 62099451 },
	{ 25, 16191231 },
	{ 25, 15142655 },
	{ 25, 11996927 },
	{ 25, 10948351 },
	{ 24, 7802623 },
	{ 24, 6754047 },
	{ 24, 3608319 },
	{ 24, 2559743 },
	{ 22, 1511167 },
	{ 22, 462591 },
	{ 17, 27118 },
	{ 22, 397051 },
	{ 22, 1249019 },
	{ 24, 2232059 },
	{ 22, 855803 },
	{ 22, 1576699 },
	{ 22, 233211 },
	{ 22, 1281787 },
	{ 22, 1494783 },
	{ 24, 3378939 },
	{ 24, 6524667 },
	{ 24, 7573243 },
	{ 24, 7786239 },
	{ 25, 11767547 },
	{ 25, 14913275 },
	{ 25, 15961851 },
	{ 25, 16174847 },
	{ 26, 28544763 },
	{ 26, 31690491 },
	{ 26, 32739067 },
	{ 26, 61050619 },
	{ 26, 62099195 },
	{ 26, 65244923 },
	{ 26, 66293499 },
	{ 26, 66506495 },
	{ 26, 21629951 },
	{ 25, 15338495 },
	{ 25, 13241343 },
	{ 25, 6949887 },
	{ 25, 4852735 },
	{ 23, 2755583 },
	{ 23, 658431 },
	{ 17, 23406 },
	{ 22, 461819 },
	{ 22, 1444859 },
	{ 24, 2296827 },
	{ 24, 3279867 },
	{ 22, 1641467 },
	{ 22, 1838075 },
	{ 22, 429051 },
	{ 22, 1477627 },
	{ 22, 1559551 },
	{ 24, 3574779 },
	{ 24, 6720507 },
	{ 24, 7769083 },
	{ 24, 7851007 },
	{ 25, 11963387 },
	{ 25, 15109115 },
	{ 25, 16157691 },
	{ 25, 16239615 },
	{ 26, 28740603 },
	{ 26, 31886331 },
	{ 26, 32934907 },
	{ 26, 61246459 },
	{ 26, 62295035 },
	{ 26, 65440763 },
	{ 26, 66489339 },
	{ 26, 21629695 },
	{ 25, 15338239 },
	{ 25, 13241087 },
	{ 25, 6949631 },
	{ 25, 4852479 },
	{ 23, 2755327 },
	{ 23, 658175 },
	{ 17, 19310 },
	{ 22, 461563 },
	{ 22, 1444603 },
	{ 24, 2296571 },
	{ 24, 3279611 },
	{ 22, 1641211 },
	{ 22, 1837819 },
	{ 22, 428795 },
	{ 22, 1477371 },
	{ 22, 1559295 },
	{ 24, 3574523 },
	{ 24, 6720251 },
	{ 24, 7768827 },
	{ 24, 7850751 },
	{ 25, 11963131 },
	{ 25, 15108859 },
	{ 25, 16157435 },
	{ 25, 16239359 },
	{ 25, 16435199 },
	{ 25, 15910911 },
	{ 25, 14338047 },
	{ 25, 13813759 },
	{ 24, 8046591 },
	{ 24, 7522303 },
	{ 24, 5949439 },
	{ 24, 5425151 },
	{ 23, 3852287 },
	{ 23, 3327999 },
	{ 23, 1755135 },
	{ 23, 1230847 },
	{ 21, 706559 },
	{ 21, 182271 },
	{ 15, 15342 },
	{ 21, 165883 },
	{ 20, 378875 },
	{ 22, 624635 },
	{ 22, 837627 },
	{ 22, 1607675 },
	{ 20, 477179 },
	{ 21, 657403 },
	{ 20, 124923 },
	{ 20, 387067 },
	{ 21, 702463 },
	{ 22, 911355 },
	{ 22, 1697787 },
	{ 22, 1959931 },
	{ 23, 2746363 },
	{ 23, 3008507 },
	{ 23, 3794939 },
	{ 23, 4057083 },
	{ 24, 6940667 },
	{ 24, 7202811 },
	{ 24, 7989243 },
	{ 24, 8251387 },
	{ 24, 15329275 },
	{ 24, 15591419 },
	{ 24, 16377851 },
	{ 24, 16639995 },
	{ 23, 3852031 },
	{ 23, 3327743 },
	{ 23, 1754879 },
	{ 23, 1230591 },
	{ 21, 706303 },
	{ 21, 182015 },
	{ 15, 11246 },
	{ 21, 165627 },
	{ 20, 378619 },
	{ 22, 624379 },
	{ 22, 837371 },
	{ 22, 1607419 },
	{ 20, 476923 },
	{ 21, 657147 },
	{ 20, 124667 },
	{ 20, 386811 },
	{ 21, 702207 },
	{ 22, 911099 },
	{ 22, 1697531 },
	{ 22, 1959675 },
	{ 23, 2746107 },
	{ 23, 3008251 },
	{ 23, 3794683 },
	{ 23, 4056827 },
	{ 24, 6940411 },
	{ 24, 7202555 },
	{ 24, 7988987 },
	{ 24, 8251131 },
	{ 24, 15329019 },
	{ 24, 15591163 },
	{ 24, 16377595 },
	{ 24, 16639739 },
	{ 23, 3900415 },
	{ 23, 3376127 },
	{ 23, 1803263 },
	{ 23, 1278975 },
	{ 21, 754687 },
	{ 21, 230399 },
	{ 16, 13678 },
	{ 21, 181243 },
	{ 21, 689147 },
	{ 22, 639995 },
	{ 22, 885755 },
	{ 22, 1623035 },
	{ 22, 1868795 },
	{ 21, 672763 },
	{ 21, 721915 },
	{ 21, 173051 },
	{ 21, 697339 },
	{ 21, 717823 },
	{ 23, 1745915 },
	{ 23, 3318779 },
	{ 23, 3843067 },
	{ 23, 3863551 },
	{ 24, 5940219 },
	{ 24, 7513083 },
	{ 24, 8037371 },
	{ 24, 8057855 },
	{ 25, 14328827 },
	{ 25, 15901691 },
	{ 24, 8094463 },
	{ 24, 7570175 },
	{ 24, 5997311 },
	{ 24, 5473023 },
	{ 23, 3900159 },
	{ 23, 3375871 },
	{ 23, 1803007 },
	{ 23, 1278719 },
	{ 21, 754431 },
	{ 21, 230143 },
	{ 16, 5486 },
	{ 21, 180987 },
	{ 21, 688891 },
	{ 22, 639739 },
	{ 22, 885499 },
	{ 22, 1622779 },
	{ 22, 1868539 },
	{ 21, 672507 },
	{ 21, 721659 },
	{ 21, 172795 },
	{ 21, 697083 },
	{ 21, 717567 },
	{ 23, 1745659 },
	{ 23, 3318523 },
	{ 23, 3842811 },
	{ 23, 3863295 },
	{ 23, 7795199 },
	{ 23, 7664127 },
	{ 23, 4125183 },
	{ 23, 3994111 },
	{ 23, 3600895 },
	{ 23, 3469823 },
	{ 22, 2028031 },
	{ 22, 1896959 },
	{ 22, 1503743 },
	{ 22, 1372671 },
	{ 21, 979455 },
	{ 21, 848383 },
	{ 21, 455167 },
	{ 21, 324095 },
	{ 19, 193023 },
	{ 19, 61951 },
	{ 14, 9710 },
	{ 19, 57851 },
	{ 19, 176635 },
	{ 21, 303611 },
	{ 20, 225787 },
	{ 20, 418299 },
	{ 20, 471547 },
	{ 21, 664059 },
	{ 19, 184827 },
	{ 19, 229883 },
	{ 19, 47611 },
	{ 19, 178683 },
	{ 19, 191999 },
	{ 21, 440827 },
	{ 21, 834043 },
	{ 21, 965115 },
	{ 21, 978431 },
	{ 22, 1489403 },
	{ 22, 1882619 },
	{ 22, 2013691 },
	{ 22, 2027007 },
	{ 23, 3470589 },
	{ 22, 2028797 },
	{ 22, 1897725 },
	{ 22, 1504509 },
	{ 22, 1373437 },
	{ 21, 980221 },
	{ 21, 849149 },
	{ 21, 455933 },
	{ 21, 324861 },
	{ 19, 193789 },
	{ 19, 62717 },
	{ 14, 1434 },
	{ 19, 58617 },
	{ 19, 177401 },
	{ 21, 304377 },
	{ 20, 226553 },
	{ 20, 419065 },
	{ 20, 472313 },
	{ 21, 664825 },
	{ 19, 185593 },
	{ 19, 230649 },
	{ 19, 183545 },
	{ 19, 187641 },
	{ 19, 235773 },
	{ 21, 736505 },
	{ 21, 748793 },
	{ 21, 752889 },
	{ 21, 948477 },
	{ 22, 1490169 },
	{ 22, 1502457 },
	{ 22, 1506553 },
	{ 22, 1898749 },
	{ 23, 2997497 },
	{ 22, 2029053 },
	{ 22, 1897981 },
	{ 22, 1504765 },
	{ 22, 1373693 },
	{ 21, 980477 },
	{ 21, 849405 },
	{ 21, 456189 },
	{ 21, 325117 },
	{ 19, 194045 },
	{ 19, 62973 },
	{ 14, 9626 },
	{ 19, 58873 },
	{ 19, 177657 },
	{ 21, 304633 },
	{ 20, 226809 },
	{ 20, 419321 },
	{ 20, 472569 },
	{ 21, 665081 },
	{ 19, 185849 },
	{ 19, 230905 },
	{ 19, 183801 },
	{ 19, 187897 },
	{ 19, 236029 },
	{ 21, 736761 },
	{ 21, 749049 },
	{ 21, 753145 },
	{ 21, 948733 },
	{ 22, 1490425 },
	{ 22, 1502713 },
	{ 22, 1506809 },
	{ 22, 1899005 },
	{ 23, 2997753 },
	{ 23, 4059641 },
	{ 23, 3908089 },
	{ 23, 3125753 },
	{ 23, 2875897 },
	{ 22, 2093561 },
	{ 23, 3145209 },
	{ 23, 3930621 },
	{ 24, 2527997 },
	{ 22, 1479421 },
	{ 22, 430845 },
	{ 16, 5914 },
	{ 21, 250617 },
	{ 21, 758521 },
	{ 23, 1233657 },
	{ 23, 1741561 },
	{ 22, 1692409 },
	{ 22, 1938169 },
	{ 23, 2675449 },
	{ 23, 2921209 },
	{ 21, 938745 },
	{ 21, 987897 },
	{ 21, 930553 },
	{ 21, 946937 },
	{ 21, 1008381 },
	{ 23, 3732217 },
	{ 23, 3781369 },
	{ 23, 3797753 },
	{ 23, 4055805 },
	{ 24, 7533305 },
	{ 24, 7582457 },
	{ 24, 7598841 },
	{ 24, 8119037 },
	{ 25, 16220921 },
	{ 25, 15188729 },
	{ 25, 12485369 },
	{ 25, 11453177 },
	{ 24, 8356601 },
	{ 24, 7324409 },
	{ 24, 3576829 },
	{ 24, 2528253 },
	{ 22, 1479677 },
	{ 22, 431101 },
	{ 16, 14106 },
	{ 21, 250873 },
	{ 21, 758777 },
	{ 23, 1233913 },
	{ 23, 1741817 },
	{ 22, 1692665 },
	{ 22, 1938425 },
	{ 23, 2675705 },
	{ 23, 2921465 },
	{ 21, 939001 },
	{ 21, 988153 },
	{ 21, 930809 },
	{ 21, 947193 },
	{ 21, 1008637 },
	{ 23, 3732473 },
	{ 23, 3781625 },
	{ 23, 3798009 },
	{ 23, 4056061 },
	{ 24, 7533561 },
	{ 24, 7582713 },
	{ 24, 7599097 },
	{ 24, 8119293 },
	{ 25, 16221177 },
	{ 25, 15188985 },
	{ 25, 12485625 },
	{ 25, 11453433 },
	{ 24, 8356857 },
	{ 24, 7324665 },
	{ 24, 3593981 },
	{ 24, 2545405 },
	{ 22, 1496829 },
	{ 22, 448253 },
	{ 16, 22426 },
	{ 22, 431865 },
	{ 21, 775929 },
	{ 23, 1283833 },
	{ 23, 1758969 },
	{ 23, 3315449 },
	{ 22, 1955577 },
	{ 23, 2725625 },
	{ 23, 2938617 },
	{ 23, 3708665 },
	{ 21, 1005305 },
	{ 22, 1709817 },
	{ 21, 997113 },
	{ 21, 1013497 },
	{ 22, 1730301 },
	{ 23, 3995385 },
	{ 23, 4044537 },
	{ 23, 4060921 },
	{ 24, 8042233 },
	{ 24, 8058617 },
	{ 24, 8107769 },
	{ 24, 8124153 },
	{ 25, 16172793 },
	{ 25, 15173369 },
	{ 25, 12044025 },
	{ 25, 11437817 },
	{ 24, 8308473 },
	{ 24, 7309049 },
	{ 24, 4179705 },
	{ 24, 2545661 },
	{ 22, 1497085 },
	{ 22, 448509 },
	{ 16, 30618 },
	{ 22, 432121 },
	{ 21, 776185 },
	{ 23, 1284089 },
	{ 23, 1759225 },
	{ 23, 3315705 },
	{ 22, 1955833 },
	{ 23, 2725881 },
	{ 23, 2938873 },
	{ 23, 3708921 },
	{ 21, 1005561 },
	{ 22, 1710073 },
	{ 21, 997369 },
	{ 21, 1013753 },
	{ 22, 1730557 },
	{ 23, 3995641 },
	{ 23, 4044793 },
	{ 23, 4061177 },
	{ 24, 8042489 },
	{ 24, 8058873 },
	{ 24, 8108025 },
	{ 24, 8124409 },
	{ 25, 16173049 },
	{ 25, 15173625 },
	{ 25, 12044281 },
	{ 25, 11438073 },
	{ 24, 8308729 },
	{ 24, 7309305 },
	{ 24, 4179961 },
	{ 25, 16775161 },
	{ 24, 6179581 },
	{ 24, 1985277 },
	{ 19, 77082 },
	{ 24, 1788665 },
	{ 24, 5917433 },
	{ 25, 5196537 },
	{ 25, 7228153 },
	{ 25, 13323001 },
	{ 25, 15354617 },
	{ 25, 10963705 },
	{ 25, 11946745 },
	{ 25, 14895865 },
	{ 25, 15878905 },
	{ 24, 6900473 },
	{ 24, 7097081 },
	{ 24, 6867705 },
	{ 24, 6933241 },
	{ 24, 7179005 },
	{ 26, 62262009 },
	{ 26, 61278969 },
	{ 26, 27773689 },
	{ 26, 28805885 },
	{ 27, 57543417 },
	{ 27, 55511801 },
	{ 27, 64621305 },
	{ 27, 60492537 },
	{ 27, 48106233 },
	{ 27, 43977465 },
	{ 26, 33164025 },
	{ 26, 29035257 },
	{ 26, 16648953 },
	{ 26, 12520185 },
	{ 24, 6179837 },
	{ 24, 1985533 },
	{ 19, 93466 },
	{ 24, 1788921 },
	{ 24, 5917689 },
	{ 25, 5196793 },
	{ 25, 7228409 },
	{ 25, 13323257 },
	{ 25, 15354873 },
	{ 25, 10963961 },
	{ 25, 11947001 },
	{ 25, 14896121 },
	{ 25, 15879161 },
	{ 24, 6900729 },
	{ 24, 7097337 },
	{ 24, 6867961 },
	{ 24, 6933497 },
	{ 24, 7179261 },
	{ 26, 62262265 },
	{ 26, 61279225 },
	{ 26, 27773945 },
	{ 26, 28806141 },
	{ 27, 57543673 },
	{ 27, 55512057 },
	{ 27, 64621561 },
	{ 27, 60492793 },
	{ 27, 48106489 },
	{ 27, 43977721 },
	{ 26, 33164281 },
	{ 26, 29035513 },
	{ 26, 16649209 },
	{ 26, 12520441 },
	{ 24, 6246141 },
	{ 24, 2051837 },
	{ 19, 109978 },
	{ 24, 1986297 },
	{ 24, 5983993 },
	{ 26, 10112761 },
	{ 25, 7294713 },
	{ 25, 13520633 },
	{ 25, 15421177 },
	{ 26, 33525497 },
	{ 25, 12013305 },
	{ 25, 15093497 },
	{ 25, 15945465 },
	{ 24, 8359673 },
	{ 24, 4165369 },
	{ 24, 7884537 },
	{ 24, 16584441 },
	{ 24, 7196409 },
	{ 24, 7966461 },
	{ 26, 61214457 },
	{ 26, 32968441 },
	{ 26, 28823289 },
	{ 26, 31952637 },
	{ 27, 55447289 },
	{ 26, 32444153 },
	{ 27, 60428025 },
	{ 27, 47910649 },
	{ 27, 43912953 },
	{ 26, 31395577 },
	{ 26, 28970745 },
	{ 26, 16453369 },
	{ 26, 12455673 },
	{ 24, 8326905 },
	{ 24, 2052093 },
	{ 19, 114666 },
	{ 24, 1986553 },
	{ 24, 5984249 },
	{ 26, 10113017 },
	{ 25, 7294969 },
	{ 25, 13520889 },
	{ 25, 15421433 },
	{ 26, 33525753 },
	{ 25, 12013561 },
	{ 25, 15093753 },
	{ 25, 15945721 },
	{ 24, 8359929 },
	{ 24, 4165625 },
	{ 24, 7884793 },
	{ 24, 16584697 },
	{ 24, 7196665 },
	{ 24, 7966717 },
	{ 26, 61214713 },
	{ 26, 32968697 },
	{ 26, 28823545 },
	{ 26, 31952893 },
	{ 27, 55447545 },
	{ 26, 32444409 },
	{ 27, 60428281 },
	{ 27, 47910905 },
	{ 27, 43913209 },
	{ 26, 31395833 },
	{ 26, 28971001 },
	{ 26, 16453625 },
	{ 26, 12455929 },
	{ 24, 8327161 },
	{ 24, 3824381 },
	{ 19, 131050 },
	{ 24, 2054905 },
	{ 24, 6183673 },
	{ 26, 10181369 },
	{ 26, 14310137 },
	{ 25, 13589241 },
	{ 25, 15620857 },
	{ 26, 21715705 },
	{ 26, 33463033 },
	{ 25, 15162105 },
	{ 25, 16145145 },
	{ 24, 8379133 },
	{ 24, 8297209 },
	{ 24, 4102905 },
	{ 24, 16521977 },
	{ 24, 16325369 },
	{ 24, 7985913 },
	{ 24, 8231677 },
	{ 26, 32905977 },
	{ 26, 31922937 },
	{ 26, 31972089 },
	{ 26, 33004285 },
	{ 26, 32381689 },
	{ 26, 30350073 },
	{ 27, 47848185 },
	{ 27, 43719417 },
	{ 26, 31333113 },
	{ 26, 27204345 },
	{ 26, 16390905 },
	{ 26, 12262137 },
	{ 24, 8264441 },
	{ 24, 4135673 },
	{ 19, 212842 },
	{ 24, 2055161 },
	{ 24, 6183929 },
	{ 26, 10181625 },
	{ 26, 14310393 },
	{ 25, 13589497 },
	{ 25, 15621113 },
	{ 26, 21715961 },
	{ 26, 33463289 },
	{ 25, 15162361 },
	{ 25, 16145401 },
	{ 24, 8379389 },
	{ 24, 8297465 },
	{ 24, 4103161 },
	{ 24, 16522233 },
	{ 24, 16325625 },
	{ 24, 7986169 },
	{ 24, 8231933 },
	{ 26, 32906233 },
	{ 26, 31923193 },
	{ 26, 31972345 },
	{ 26, 33004541 },
	{ 26, 32381945 },
	{ 26, 30350329 },
	{ 27, 47848441 },
	{ 27, 43719673 },
	{ 26, 31333369 },
	{ 26, 27204601 },
	{ 26, 16391161 },
	{ 26, 12262393 },
	{ 24, 8264697 },
	{ 24, 4135929 },
	{ 19, 229226 },
	{ 24, 3825401 },
	{ 24, 6250233 },
	{ 26, 10379001 },
	{ 26, 14376697 },
	{ 26, 26894073 },
	{ 25, 15687417 },
	{ 26, 21913337 },
	{ 26, 23813881 },
	{ 26, 33267449 },
	{ 25, 16211705 },
	{ 26, 16490233 },
	{ 24, 8314621 },
	{ 24, 8101625 },
	{ 24, 3907321 },
	{ 24, 16260857 },
	{ 24, 15539961 },
	{ 24, 8249081 },
	{ 24, 15310589 },
	{ 26, 31858425 },
	{ 26, 28778233 },
	{ 26, 33021689 },
	{ 26, 32186105 },
	{ 26, 30285561 },
	{ 26, 24059641 },
	{ 27, 43654905 },
	{ 26, 31137529 },
	{ 26, 27139833 },
	{ 26, 14622457 },
	{ 26, 12197625 },
	{ 24, 8068857 },
	{ 24, 4071161 },
	{ 19, 245226 },
	{ 24, 3825657 },
	{ 24, 6250489 },
	{ 26, 10379257 },
	{ 26, 14376953 },
	{ 26, 26894329 },
	{ 25, 15687673 },
	{ 26, 21913593 },
	{ 26, 23814137 },
	{ 26, 33267705 },
	{ 25, 16211961 },
	{ 26, 16490489 },
	{ 24, 8314877 },
	{ 24, 8101881 },
	{ 24, 3907577 },
	{ 24, 16261113 },
	{ 24, 15540217 },
	{ 24, 8249337 },
	{ 24, 15310845 },
	{ 26, 31858681 },
	{ 26, 28778489 },
	{ 26, 33021945 },
	{ 26, 32186361 },
	{ 26, 30285817 },
	{ 26, 24059897 },
	{ 27, 43655161 },
	{ 26, 31137785 },
	{ 26, 27140089 },
	{ 26, 14622713 },
	{ 26, 12197881 },
	{ 24, 8069113 },
	{ 24, 4071417 },
	{ 19, 261610 },
	{ 24, 4136957 },
	{ 24, 8331261 },
	{ 26, 12525565 },
	{ 26, 16719869 },
	{ 26, 29302781 },
	{ 26, 33497085 },
	{ 27, 46079997 },
	{ 27, 50274301 },
	{ 27, 62857213 },
	{ 27, 67051517 },
	{ 28, 116009721 },
	{ 28, 65678073 },
	{ 26, 32451325 },
	{ 26, 32123641 },
	{ 26, 15346425 },
	{ 26, 61876985 },
	{ 26, 61090553 },
	{ 26, 61287161 },
	{ 26, 62270205 },
	{ 28, 114830073 },
	{ 28, 110897913 },
	{ 28, 128461561 },
	{ 28, 120335097 },
	{ 28, 95955705 },
	{ 28, 87829241 },
	{ 28, 124267257 },
	{ 28, 107752185 },
	{ 28, 58206969 },
	{ 28, 41691897 },
	{ 26, 31992569 },
	{ 26, 15477497 },
	{ 20, 343402 },
	{ 26, 15543289 },
	{ 26, 32058361 },
	{ 28, 41757689 },
	{ 28, 58272761 },
	{ 28, 107817977 },
	{ 28, 124333049 },
	{ 28, 87895033 },
	{ 28, 96021497 },
	{ 28, 120400889 },
	{ 28, 132787193 },
	{ 28, 116009977 },
	{ 28, 65678329 },
	{ 26, 32451581 },
	{ 26, 32123897 },
	{ 26, 15346681 },
	{ 26, 61877241 },
	{ 26, 61090809 },
	{ 26, 61287417 },
	{ 26, 62270461 },
	{ 28, 114830329 },
	{ 28, 110898169 },
	{ 28, 128461817 },
	{ 28, 120335353 },
	{ 28, 95955961 },
	{ 28, 87829497 },
	{ 28, 124267513 },
	{ 28, 107752441 },
	{ 28, 58207225 },
	{ 28, 41692153 },
	{ 26, 31992825 },
	{ 26, 15477753 },
	{ 20, 359786 },
	{ 26, 16330489 },
	{ 26, 32321273 },
	{ 28, 48836345 },
	{ 28, 58535673 },
	{ 28, 108605177 },
	{ 28, 124595961 },
	{ 29, 259927801 },
	{ 28, 96284409 },
	{ 28, 121188089 },
	{ 28, 128790265 },
	{ 28, 125710073 },
	{ 28, 108932857 },
	{ 28, 58601209 },
	{ 26, 32190205 },
	{ 26, 25046777 },
	{ 26, 8269561 },
	{ 26, 60829433 },
	{ 26, 32780025 },
	{ 26, 62336761 },
	{ 26, 65416957 },
	{ 28, 110636793 },
	{ 27, 64761593 },
	{ 28, 120073977 },
	{ 28, 95170297 },
	{ 28, 87568121 },
	{ 27, 62664441 },
	{ 28, 107491065 },
	{ 28, 57421561 },
	{ 28, 41430777 },
	{ 26, 24915705 },
	{ 26, 15216377 },
	{ 20, 372714 },
	{ 26, 16330745 },
	{ 26, 32321529 },
	{ 28, 48836601 },
	{ 28, 58535929 },
	{ 28, 108605433 },
	{ 28, 124596217 },
	{ 29, 259928057 },
	{ 28, 96284665 },
	{ 28, 121188345 },
	{ 28, 128790521 },
	{ 28, 125710329 },
	{ 28, 108933113 },
	{ 28, 58601465 },
	{ 26, 32190461 },
	{ 26, 25047033 },
	{ 26, 8269817 },
	{ 26, 60829689 },
	{ 26, 32780281 },
	{ 26, 62337017 },
	{ 26, 65417213 },
	{ 28, 110637049 },
	{ 27, 64761849 },
	{ 28, 120074233 },
	{ 28, 95170553 },
	{ 28, 87568377 },
	{ 27, 62664697 },
	{ 28, 107491321 },
	{ 28, 57421817 },
	{ 28, 41431033 },
	{ 26, 24915961 },
	{ 26, 15216633 },
	{ 20, 389098 },
	{ 26, 16595705 },
	{ 26, 33110777 },
	{ 27, 66125819 },
	{ 28, 65616633 },
	{ 28, 108870393 },
	{ 28, 125385465 },
	{ 29, 174930681 },
	{ 29, 259668729 },
	{ 28, 121453305 },
	{ 28, 129579769 },
	{ 28, 125778685 },
	{ 28, 125451001 },
	{ 28, 108673785 },
	{ 28, 58342137 },
	{ 26, 25115389 },
	{ 26, 24787705 },
	{ 26, 8010489 },
	{ 26, 32520953 },
	{ 26, 31734521 },
	{ 26, 65485561 },
	{ 26, 66468605 },
	{ 27, 64502521 },
	{ 27, 60570361 },
	{ 28, 94911225 },
	{ 28, 86784761 },
	{ 27, 62405369 },
	{ 27, 54278905 },
	{ 28, 57162489 },
	{ 28, 40647417 },
	{ 26, 24656633 },
	{ 26, 8141561 },
	{ 20, 470890 },
	{ 26, 16595961 },
	{ 26, 33111033 },
	{ 27, 66125563 },
	{ 28, 65616889 },
	{ 28, 108870649 },
	{ 28, 125385721 },
	{ 29, 174930937 },
	{ 29, 259668985 },
	{ 28, 121453561 },
	{ 28, 129580025 },
	{ 28, 125778941 },
	{ 28, 125451257 },
	{ 28, 108674041 },
	{ 28, 58342393 },
	{ 26, 25115645 },
	{ 26, 24787961 },
	{ 26, 8010745 },
	{ 26, 32521209 },
	{ 26, 31734777 },
	{ 26, 65485817 },
	{ 26, 66468861 },
	{ 27, 64502777 },
	{ 27, 60570617 },
	{ 28, 94911481 },
	{ 28, 86785017 },
	{ 27, 62405625 },
	{ 27, 54279161 },
	{ 28, 57162745 },
	{ 28, 40647673 },
	{ 26, 24656889 },
	{ 26, 8141817 },
	{ 20, 487274 },
	{ 26, 15219709 },
	{ 26, 33373945 },
	{ 27, 66649083 },
	{ 28, 65879801 },
	{ 28, 115949305 },
	{ 28, 125648633 },
	{ 29, 175718137 },
	{ 29, 191708921 },
	{ 29, 258883321 },
	{ 28, 129842937 },
	{ 29, 191774457 },
	{ 28, 125517565 },
	{ 28, 124665593 },
	{ 28, 107888377 },
	{ 28, 57556729 },
	{ 26, 24854269 },
	{ 26, 24002297 },
	{ 26, 7225081 },
	{ 26, 31473401 },
	{ 26, 28589817 },
	{ 26, 66535161 },
	{ 27, 63717113 },
	{ 27, 60309241 },
	{ 27, 47988473 },
	{ 28, 86523641 },
	{ 27, 61619961 },
	{ 27, 54017785 },
	{ 27, 29114105 },
	{ 28, 40386297 },
	{ 26, 23871225 },
	{ 26, 7880441 },
	{ 20, 503274 },
	{ 26, 8142589 },
	{ 26, 33374201 },
	{ 27, 66648827 },
	{ 28, 65880057 },
	{ 28, 115949561 },
	{ 28, 125648889 },
	{ 29, 175718393 },
	{ 29, 191709177 },
	{ 29, 258883577 },
	{ 28, 129843193 },
	{ 29, 191774713 },
	{ 28, 125517821 },
	{ 28, 124665849 },
	{ 28, 107888633 },
	{ 28, 57556985 },
	{ 26, 24854525 },
	{ 26, 24002553 },
	{ 26, 7225337 },
	{ 26, 31473657 },
	{ 26, 28590073 },
	{ 26, 66535417 },
	{ 27, 63717369 },
	{ 27, 60309497 },
	{ 27, 47988729 },
	{ 28, 86523897 },
	{ 27, 61620217 },
	{ 27, 54018041 },
	{ 27, 29114361 },
	{ 28, 40386553 },
	{ 26, 23871481 },
	{ 26, 7880697 },
	{ 20, 519658 },
	{ 26, 8142845 },
	{ 26, 24920061 },
	{ 27, 50002687 },
	{ 28, 66677497 },
	{ 28, 116222713 },
	{ 28, 132737785 },
	{ 29, 175991545 },
	{ 29, 192506617 },
	{ 29, 242051833 },
	{ 29, 258632441 },
	{ 29, 241855225 },
	{ 29, 191523577 },
	{ 28, 124742397 },
	{ 28, 124414713 },
	{ 28, 107637497 },
	{ 28, 57305849 },
	{ 26, 24079101 },
	{ 26, 23751417 },
	{ 26, 6974201 },
	{ 26, 28338937 },
	{ 26, 27552505 },
	{ 27, 63466233 },
	{ 27, 59534073 },
	{ 27, 47737593 },
	{ 27, 43805433 },
	{ 27, 61369081 },
	{ 27, 53242617 },
	{ 27, 28863225 },
	{ 27, 20736761 },
	{ 26, 23620345 },
	{ 26, 7105273 },
	{ 21, 863594 },
	{ 26, 7891709 },
	{ 26, 24668925 },
	{ 27, 49475583 },
	{ 28, 66677753 },
	{ 28, 116222969 },
	{ 28, 132738041 },
	{ 29, 175991801 },
	{ 29, 192506873 },
	{ 29, 242052089 },
	{ 29, 258632697 },
	{ 29, 241855481 },
	{ 29, 191523833 },
	{ 28, 124742653 },
	{ 28, 124414969 },
	{ 28, 107637753 },
	{ 28, 57306105 },
	{ 26, 24079357 },
	{ 26, 23751673 },
	{ 26, 6974457 },
	{ 26, 28339193 },
	{ 26, 27552761 },
	{ 27, 63466489 },
	{ 27, 59534329 },
	{ 27, 47737849 },
	{ 27, 43805689 },
	{ 27, 61369337 },
	{ 27, 53242873 },
	{ 27, 28863481 },
	{ 27, 20737017 },
	{ 26, 23620601 },
	{ 26, 7105529 },
	{ 21, 879978 },
	{ 26, 7891965 },
	{ 26, 24669181 },
	{ 27, 49475327 },
	{ 28, 66940665 },
	{ 28, 117010169 },
	{ 28, 133000953 },
	{ 29, 264138489 },
	{ 29, 255749881 },
	{ 29, 230584057 },
	{ 29, 222195449 },
	{ 28, 129920761 },
	{ 28, 121532153 },
	{ 28, 96366329 },
	{ 28, 87977721 },
	{ 27, 62811897 },
	{ 27, 54423289 },
	{ 27, 29257465 },
	{ 26, 23817981 },
	{ 25, 12480249 },
	{ 25, 4091641 },
	{ 26, 27291385 },
	{ 25, 16019193 },
	{ 26, 32173051 },
	{ 27, 46952185 },
	{ 27, 43544313 },
	{ 26, 31223545 },
	{ 27, 52981497 },
	{ 27, 28077817 },
	{ 27, 20475641 },
	{ 25, 12349177 },
	{ 26, 6844153 },
	{ 20, 448490 },
	{ 26, 7106301 },
	{ 26, 23883517 },
	{ 27, 47901695 },
	{ 28, 66940921 },
	{ 28, 117010425 },
	{ 28, 133001209 },
	{ 29, 264138745 },
	{ 29, 255750137 },
	{ 29, 230584313 },
	{ 29, 222195705 },
	{ 28, 129921017 },
	{ 28, 121532409 },
	{ 28, 96366585 },
	{ 28, 87977977 },
	{ 27, 62812153 },
	{ 27, 54423545 },
	{ 27, 29257721 },
	{ 26, 23818237 },
	{ 25, 12480505 },
	{ 25, 4091897 },
	{ 26, 27291641 },
	{ 25, 16019449 },
	{ 26, 32172795 },
	{ 27, 46952441 },
	{ 27, 43544569 },
	{ 26, 31223801 },
	{ 27, 52981753 },
	{ 27, 28078073 },
	{ 27, 20475897 },
	{ 25, 12349433 },
	{ 26, 6844409 },
	{ 20, 456682 },
	{ 26, 7106557 },
	{ 26, 23883773 },
	{ 27, 47901439 },
	{ 28, 57438205 },
	{ 28, 117275385 },
	{ 28, 133790457 },
	{ 29, 490371833 },
	{ 29, 263879417 },
	{ 29, 255490809 },
	{ 29, 230324985 },
	{ 28, 129989373 },
	{ 28, 129661689 },
	{ 28, 121273081 },
	{ 28, 96107257 },
	{ 27, 62880509 },
	{ 27, 62552825 },
	{ 27, 54164217 },
	{ 27, 28998393 },
	{ 25, 12548861 },
	{ 25, 12221177 },
	{ 25, 3832569 },
	{ 25, 15760121 },
	{ 25, 14973689 },
	{ 26, 30064635 },
	{ 27, 42760953 },
	{ 26, 30964473 },
	{ 26, 27032313 },
	{ 27, 27818745 },
	{ 27, 19692281 },
	{ 25, 12090105 },
	{ 25, 3963641 },
	{ 20, 497514 },
	{ 20, 1046302 },
	{ 26, 23624445 },
	{ 27, 47366143 },
	{ 28, 57178877 },
	{ 28, 117275641 },
	{ 28, 133790713 },
	{ 29, 490372089 },
	{ 29, 263879673 },
	{ 29, 255491065 },
	{ 29, 230325241 },
	{ 28, 129989629 },
	{ 28, 129661945 },
	{ 28, 121273337 },
	{ 28, 96107513 },
	{ 27, 62880765 },
	{ 27, 62553081 },
	{ 27, 54164473 },
	{ 27, 28998649 },
	{ 25, 12549117 },
	{ 25, 12221433 },
	{ 25, 3832825 },
	{ 25, 15760377 },
	{ 25, 14973945 },
	{ 26, 30064379 },
	{ 27, 42761209 },
	{ 26, 30964729 },
	{ 26, 27032569 },
	{ 27, 27819001 },
	{ 27, 19692537 },
	{ 25, 12090361 },
	{ 25, 3963897 },
	{ 20, 505706 },
	{ 20, 1038110 },
	{ 26, 23624701 },
	{ 27, 47365887 },
	{ 28, 57179133 },
	{ 28, 107510781 },
	{ 28, 134053625 },
	{ 29, 497975033 },
	{ 29, 489586425 },
	{ 29, 263094009 },
	{ 29, 254705401 },
	{ 29, 229539577 },
	{ 28, 129728253 },
	{ 28, 128876281 },
	{ 28, 120487673 },
	{ 28, 95321849 },
	{ 27, 62619389 },
	{ 27, 61767417 },
	{ 27, 53378809 },
	{ 27, 28212985 },
	{ 25, 12287741 },
	{ 25, 11435769 },
	{ 25, 3047161 },
	{ 25, 14712569 },
	{ 25, 11828985 },
	{ 26, 23772155 },
	{ 26, 30179065 },
	{ 26, 26771193 },
	{ 26, 14450425 },
	{ 27, 19431161 },
	{ 25, 11304697 },
	{ 25, 3702521 },
	{ 20, 513514 },
	{ 20, 1029534 },
	{ 25, 12353277 },
	{ 26, 24820735 },
	{ 27, 29130493 },
	{ 27, 54296317 },
	{ 27, 62684925 },
	{ 28, 87850749 },
	{ 28, 96239357 },
	{ 28, 121405181 },
	{ 28, 129793789 },
	{ 29, 229539833 },
	{ 28, 129728509 },
	{ 28, 128876537 },
	{ 28, 120487929 },
	{ 28, 95322105 },
	{ 27, 62619645 },
	{ 27, 61767673 },
	{ 27, 53379065 },
	{ 27, 28213241 },
	{ 25, 12287997 },
	{ 25, 11436025 },
	{ 25, 3047417 },
	{ 25, 14712825 },
	{ 25, 11829241 },
	{ 26, 23771899 },
	{ 26, 30179321 },
	{ 26, 26771449 },
	{ 26, 14450681 },
	{ 27, 19431417 },
	{ 25, 11304953 },
	{ 25, 3702777 },
	{ 20, 521706 },
	{ 20, 1021342 },
	{ 25, 12353533 },
	{ 26, 24820479 },
	{ 27, 29130749 },
	{ 27, 54296573 },
	{ 27, 62685181 },
	{ 28, 87851005 },
	{ 28, 96239613 },
	{ 28, 121405437 },
	{ 28, 129794045 },
	{ 29, 222068733 },
	{ 29, 230457341 },
	{ 29, 257862397 },
	{ 29, 257207033 },
	{ 29, 240429817 },
	{ 29, 190098169 },
	{ 28, 123644669 },
	{ 28, 122989305 },
	{ 28, 106212089 },
	{ 28, 55880441 },
	{ 26, 22981373 },
	{ 26, 22326009 },
	{ 26, 5548793 },
	{ 26, 23112441 },
	{ 26, 21539577 },
	{ 26, 21671931 },
	{ 27, 51948281 },
	{ 27, 28355321 },
	{ 27, 20491001 },
	{ 26, 22063865 },
	{ 26, 5810937 },
	{ 20, 955754 },
	{ 20, 980254 },
	{ 26, 24161021 },
	{ 26, 24293375 },
	{ 28, 57715453 },
	{ 28, 108047101 },
	{ 28, 124824317 },
	{ 28, 124956671 },
	{ 29, 191933181 },
	{ 29, 242264829 },
	{ 29, 259042045 },
	{ 29, 259174399 },
	{ 30, 458533881 },
	{ 29, 257862653 },
	{ 29, 257207289 },
	{ 29, 240430073 },
	{ 29, 190098425 },
	{ 28, 123644925 },
	{ 28, 122989561 },
	{ 28, 106212345 },
	{ 28, 55880697 },
	{ 26, 22981629 },
	{ 26, 22326265 },
	{ 26, 5549049 },
	{ 26, 23112697 },
	{ 26, 21539833 },
	{ 26, 21671675 },
	{ 27, 51948537 },
	{ 27, 28355577 },
	{ 27, 20491257 },
	{ 26, 22064121 },
	{ 26, 5811193 },
	{ 20, 963946 },
	{ 20, 972062 },
	{ 26, 24161277 },
	{ 26, 24293119 },
	{ 28, 57715709 },
	{ 28, 108047357 },
	{ 28, 124824573 },
	{ 28, 124956415 },
	{ 29, 524070649 },
	{ 29, 498904825 },
	{ 29, 490516217 },
	{ 29, 264023801 },
	{ 29, 255635193 },
	{ 29, 230469369 },
	{ 29, 222080761 },
	{ 28, 129806073 },
	{ 28, 121417465 },
	{ 28, 96251641 },
	{ 28, 87863033 },
	{ 27, 62697209 },
	{ 27, 54308601 },
	{ 27, 29142777 },
	{ 26, 22458109 },
	{ 25, 12365561 },
	{ 25, 3976953 },
	{ 25, 15117307 },
	{ 25, 15249145 },
	{ 25, 15379451 },
	{ 27, 26783481 },
	{ 27, 19967737 },
	{ 25, 12103417 },
	{ 25, 12233723 },
	{ 19, 486378 },
	{ 19, 482206 },
	{ 26, 22589181 },
	{ 26, 22719487 },
	{ 28, 56143613 },
	{ 28, 106475261 },
	{ 28, 123252477 },
	{ 28, 123382783 },
	{ 29, 524070905 },
	{ 29, 498905081 },
	{ 29, 490516473 },
	{ 29, 264024057 },
	{ 29, 255635449 },
	{ 29, 230469625 },
	{ 29, 222081017 },
	{ 28, 129806329 },
	{ 28, 121417721 },
	{ 28, 96251897 },
	{ 28, 87863289 },
	{ 27, 62697465 },
	{ 27, 54308857 },
	{ 27, 29143033 },
	{ 26, 22458365 },
	{ 25, 12365817 },
	{ 25, 3977209 },
	{ 25, 15117051 },
	{ 25, 15249401 },
	{ 25, 15379195 },
	{ 27, 26783737 },
	{ 27, 19967993 },
	{ 25, 12103673 },
	{ 25, 12233467 },
	{ 19, 490474 },
	{ 19, 478110 },
	{ 26, 22589437 },
	{ 26, 22719231 },
	{ 28, 56143869 },
	{ 28, 106475517 },
	{ 28, 123252733 },
	{ 28, 123382527 },
	{ 28, 134119423 },
	{ 28, 117407739 },
	{ 28, 117145595 },
	{ 28, 116359163 },
	{ 28, 116097019 },
	{ 28, 109019131 },
	{ 28, 108756987 },
	{ 28, 129940221 },
	{ 27, 62816255 },
	{ 27, 54493179 },
	{ 27, 54231035 },
	{ 27, 62831357 },
	{ 26, 31358975 },
	{ 26, 27230203 },
	{ 26, 26968059 },
	{ 25, 12499709 },
	{ 24, 7766015 },
	{ 24, 6782971 },
	{ 24, 6520827 },
	{ 24, 7438331 },
	{ 24, 6651899 },
	{ 26, 13205499 },
	{ 25, 11582201 },
	{ 24, 5865467 },
	{ 19, 510826 },
	{ 19, 260894 },
	{ 25, 2719743 },
	{ 25, 11108351 },
	{ 27, 19496959 },
	{ 27, 27885567 },
	{ 27, 53051391 },
	{ 27, 61439999 },
	{ 28, 134119167 },
	{ 28, 117407483 },
	{ 28, 117145339 },
	{ 28, 116358907 },
	{ 28, 116096763 },
	{ 28, 109018875 },
	{ 28, 108756731 },
	{ 28, 129940477 },
	{ 27, 62815999 },
	{ 27, 54492923 },
	{ 27, 54230779 },
	{ 27, 62831613 },
	{ 26, 31358719 },
	{ 26, 27229947 },
	{ 26, 26967803 },
	{ 25, 12499965 },
	{ 24, 7765759 },
	{ 24, 6782715 },
	{ 24, 6520571 },
	{ 24, 7438075 },
	{ 24, 6651643 },
	{ 26, 13205243 },
	{ 25, 11582457 },
	{ 24, 5865211 },
	{ 19, 514922 },
	{ 19, 256798 },
	{ 25, 2719487 },
	{ 25, 11108095 },
	{ 27, 19496703 },
	{ 27, 27885311 },
	{ 27, 53051135 },
	{ 27, 61439743 },
	{ 28, 86605567 },
	{ 28, 94994175 },
	{ 28, 67075067 },
	{ 28, 66812923 },
	{ 28, 66026491 },
	{ 28, 65764347 },
	{ 28, 58686459 },
	{ 28, 58424315 },
	{ 28, 129416957 },
	{ 27, 54426623 },
	{ 27, 29326331 },
	{ 27, 29064187 },
	{ 27, 62308093 },
	{ 26, 27163647 },
	{ 26, 14646267 },
	{ 26, 14384123 },
	{ 25, 11976445 },
	{ 24, 6716415 },
	{ 24, 3636219 },
	{ 24, 3374075 },
	{ 24, 6388731 },
	{ 24, 3505147 },
	{ 25, 10010361 },
	{ 24, 5078011 },
	{ 19, 518634 },
	{ 19, 252318 },
	{ 24, 1932287 },
	{ 24, 6126591 },
	{ 26, 10320895 },
	{ 26, 14515199 },
	{ 26, 27098111 },
	{ 26, 31292415 },
	{ 27, 43875327 },
	{ 27, 48069631 },
	{ 27, 60652543 },
	{ 27, 64846847 },
	{ 28, 66026235 },
	{ 28, 65764091 },
	{ 28, 58686203 },
	{ 28, 58424059 },
	{ 28, 129417213 },
	{ 27, 54426367 },
	{ 27, 29326075 },
	{ 27, 29063931 },
	{ 27, 62308349 },
	{ 26, 27163391 },
	{ 26, 14646011 },
	{ 26, 14383867 },
	{ 25, 11976701 },
	{ 24, 6716159 },
	{ 24, 3635963 },
	{ 24, 3373819 },
	{ 24, 6388475 },
	{ 24, 3504891 },
	{ 25, 10010617 },
	{ 24, 5077755 },
	{ 19, 522730 },
	{ 19, 248222 },
	{ 24, 1932031 },
	{ 24, 6126335 },
	{ 26, 10320639 },
	{ 26, 14514943 },
	{ 26, 27097855 },
	{ 26, 31292159 },
	{ 27, 43875071 },
	{ 27, 48069375 },
	{ 27, 60652287 },
	{ 27, 64846591 },
	{ 28, 50032635 },
	{ 28, 49246203 },
	{ 28, 48984059 },
	{ 28, 41906171 },
	{ 28, 41644027 },
	{ 28, 127855357 },
	{ 27, 29257727 },
	{ 27, 20934651 },
	{ 27, 20672507 },
	{ 27, 60746493 },
	{ 26, 14577663 },
	{ 26, 10448891 },
	{ 26, 10186747 },
	{ 25, 10414845 },
	{ 24, 3567615 },
	{ 24, 2584571 },
	{ 24, 2322427 },
	{ 24, 3239931 },
	{ 24, 2453499 },
	{ 24, 4812795 },
	{ 24, 880635 },
	{ 19, 227614 },
	{ 24, 1667071 },
	{ 24, 5861375 },
	{ 26, 10055679 },
	{ 26, 14249983 },
	{ 26, 26832895 },
	{ 26, 31027199 },
	{ 27, 43610111 },
	{ 27, 47804415 },
	{ 27, 60387327 },
	{ 27, 64581631 },
	{ 28, 50032379 },
	{ 28, 49245947 },
	{ 28, 48983803 },
	{ 28, 41905915 },
	{ 28, 41643771 },
	{ 28, 127855613 },
	{ 27, 29257471 },
	{ 27, 20934395 },
	{ 27, 20672251 },
	{ 27, 60746749 },
	{ 26, 14577407 },
	{ 26, 10448635 },
	{ 26, 10186491 },
	{ 25, 10415101 },
	{ 24, 3567359 },
	{ 24, 2584315 },
	{ 24, 2322171 },
	{ 24, 3239675 },
	{ 24, 2453243 },
	{ 24, 4812539 },
	{ 24, 880379 },
	{ 19, 223518 },
	{ 24, 1666815 },
	{ 24, 5861119 },
	{ 26, 10055423 },
	{ 26, 14249727 },
	{ 26, 26832639 },
	{ 26, 31026943 },
	{ 27, 43609855 },
	{ 27, 47804159 },
	{ 27, 60387071 },
	{ 27, 132968185 },
	{ 26, 33516539 },
	{ 26, 33254395 },
	{ 26, 32467963 },
	{ 26, 32205819 },
	{ 26, 25127931 },
	{ 26, 24865787 },
	{ 26, 24079355 },
	{ 26, 32304889 },
	{ 25, 12545019 },
	{ 25, 12282875 },
	{ 25, 11496443 },
	{ 25, 15527673 },
	{ 24, 6253563 },
	{ 24, 5991419 },
	{ 24, 5204987 },
	{ 23, 2944761 },
	{ 22, 1534971 },
	{ 22, 1272827 },
	{ 23, 2682617 },
	{ 22, 1403899 },
	{ 24, 617467 },
	{ 17, 54942 },
	{ 24, 879615 },
	{ 24, 5073919 },
	{ 26, 9268223 },
	{ 26, 13462527 },
	{ 26, 26045439 },
	{ 26, 30239743 },
	{ 27, 42822655 },
	{ 27, 47016959 },
	{ 27, 59599871 },
	{ 27, 132968441 },
	{ 26, 33516283 },
	{ 26, 33254139 },
	{ 26, 32467707 },
	{ 26, 32205563 },
	{ 26, 25127675 },
	{ 26, 24865531 },
	{ 26, 24079099 },
	{ 26, 32305145 },
	{ 25, 12544763 },
	{ 25, 12282619 },
	{ 25, 11496187 },
	{ 25, 15527929 },
	{ 24, 6253307 },
	{ 24, 5991163 },
	{ 24, 5204731 },
	{ 23, 2945017 },
	{ 22, 1534715 },
	{ 22, 1272571 },
	{ 23, 2682873 },
	{ 22, 1403643 },
	{ 24, 617211 },
	{ 17, 53918 },
	{ 24, 879359 },
	{ 24, 5073663 },
	{ 26, 9267967 },
	{ 26, 13462271 },
	{ 26, 26045183 },
	{ 26, 30239487 },
	{ 27, 42822399 },
	{ 27, 47016703 },
	{ 27, 59599615 },
	{ 27, 133102333 },
	{ 26, 33439743 },
	{ 26, 16728059 },
	{ 26, 16465915 },
	{ 26, 15679483 },
	{ 26, 15417339 },
	{ 26, 8339451 },
	{ 26, 8077307 },
	{ 26, 32439037 },
	{ 25, 12468223 },
	{ 25, 4145147 },
	{ 25, 3883003 },
	{ 25, 15661821 },
	{ 24, 6176767 },
	{ 24, 2047995 },
	{ 24, 1785851 },
	{ 23, 3078909 },
	{ 22, 1458175 },
	{ 22, 475131 },
	{ 22, 212987 },
	{ 17, 65403 },
	{ 21, 1048507 },
	{ 16, 32286 },
	{ 24, 606207 },
	{ 24, 4800511 },
	{ 26, 8994815 },
	{ 26, 13189119 },
	{ 26, 25772031 },
	{ 26, 29966335 },
	{ 27, 42549247 },
	{ 27, 46743551 },
	{ 27, 59326463 },
	{ 27, 133102589 },
	{ 26, 33439487 },
	{ 26, 16727803 },
	{ 26, 16465659 },
	{ 26, 15679227 },
	{ 26, 15417083 },
	{ 26, 8339195 },
	{ 26, 8077051 },
	{ 26, 32439293 },
	{ 25, 12467967 },
	{ 25, 4144891 },
	{ 25, 3882747 },
	{ 25, 15662077 },
	{ 24, 6176511 },
	{ 24, 2047739 },
	{ 24, 1785595 },
	{ 23, 3079165 },
	{ 22, 1457919 },
	{ 22, 474875 },
	{ 22, 212731 },
	{ 17, 63355 },
	{ 20, 523899 },
	{ 16, 31262 },
	{ 24, 605951 },
	{ 24, 4800255 },
	{ 26, 8994559 },
	{ 26, 13188863 },
	{ 26, 25771775 },
	{ 26, 29966079 },
	{ 27, 42548991 },
	{ 27, 46743295 },
	{ 27, 59326207 },
	{ 27, 63520511 },
	{ 27, 132579069 },
	{ 26, 16661503 },
	{ 26, 16399359 },
	{ 26, 15612927 },
	{ 26, 15350783 },
	{ 26, 8272895 },
	{ 26, 8010751 },
	{ 26, 7224319 },
	{ 26, 31915773 },
	{ 25, 4078591 },
	{ 25, 3816447 },
	{ 25, 3030015 },
	{ 25, 15138557 },
	{ 24, 1981439 },
	{ 24, 1719295 },
	{ 24, 932863 },
	{ 23, 2555645 },
	{ 22, 408575 },
	{ 22, 146431 },
	{ 18, 130879 },
	{ 18, 130923 },
	{ 18, 130878 },
	{ 20, 524223 },
	{ 22, 1391615 },
	{ 24, 2440191 },
	{ 24, 3488767 },
	{ 24, 6634495 },
	{ 24, 7683071 },
	{ 25, 10828799 },
	{ 25, 11877375 },
	{ 25, 15023103 },
	{ 25, 16071679 },
	{ 26, 27606015 },
	{ 26, 16661247 },
	{ 26, 16399103 },
	{ 26, 15612671 },
	{ 26, 15350527 },
	{ 26, 8272639 },
	{ 26, 8010495 },
	{ 26, 7224063 },
	{ 26, 31916029 },
	{ 25, 4078335 },
	{ 25, 3816191 },
	{ 25, 3029759 },
	{ 25, 15138813 },
	{ 24, 1981183 },
	{ 24, 1719039 },
	{ 24, 932607 },
	{ 23, 2555901 },
	{ 22, 408319 },
	{ 22, 146175 },
	{ 18, 131055 },
	{ 15, 16347 },
	{ 13, 2766 },
	{ 19, 261759 },
	{ 22, 1391359 },
	{ 24, 2439935 },
	{ 24, 3488511 },
	{ 24, 6634239 },
	{ 24, 7682815 },
	{ 25, 10828543 },
	{ 25, 11877119 },
	{ 25, 15022847 },
	{ 25, 16071423 },
	{ 26, 27605759 },
	{ 26, 28654335 },
	{ 26, 31800063 },
	{ 26, 32848639 },
	{ 26, 61160191 },
	{ 26, 62208767 },
	{ 26, 65354495 },
	{ 26, 66403071 },
	{ 26, 31469567 },
	{ 26, 28323839 },
	{ 26, 27275263 },
	{ 25, 15740927 },
	{ 25, 14692351 },
	{ 25, 11546623 },
	{ 25, 10498047 },
	{ 24, 7352319 },
	{ 24, 6303743 },
	{ 24, 3158015 },
	{ 24, 4565757 },
	{ 17, 48511 },
	{ 14, 8143 },
	{ 13, 2702 },
	{ 17, 65391 },
	{ 17, 49023 },
	{ 24, 2174975 },
	{ 24, 3223551 },
	{ 24, 6369279 },
	{ 24, 7417855 },
	{ 25, 10563583 },
	{ 25, 11612159 },
	{ 25, 14757887 },
	{ 25, 15806463 },
	{ 26, 27340799 },
	{ 26, 28389375 },
	{ 26, 31535103 },
	{ 26, 66072319 },
	{ 26, 65023743 },
	{ 26, 61878015 },
	{ 26, 60829439 },
	{ 26, 32517887 },
	{ 26, 31469311 },
	{ 26, 28323583 },
	{ 26, 27275007 },
	{ 25, 15740671 },
	{ 25, 14692095 },
	{ 25, 11546367 },
	{ 25, 10497791 },
	{ 24, 7352063 },
	{ 24, 6303487 },
	{ 24, 3157759 },
	{ 24, 4566013 },
	{ 17, 46463 },
	{ 15, 16303 },
	{ 24, 109565 },
	{ 14, 8159 },
	{ 17, 46975 },
	{ 24, 2174719 },
	{ 24, 3223295 },
	{ 24, 6369023 },
	{ 24, 7417599 },
	{ 25, 10563327 },
	{ 25, 11611903 },
	{ 25, 14757631 },
	{ 25, 15806207 },
	{ 26, 27340543 },
	{ 26, 28389119 },
	{ 26, 31534847 },
	{ 26, 32583423 },
	{ 26, 60894975 },
	{ 26, 61943551 },
	{ 26, 65089279 },
	{ 26, 66137855 },
	{ 26, 31730687 },
	{ 26, 28584959 },
	{ 26, 27536383 },
	{ 25, 16002047 },
	{ 25, 14953471 },
	{ 25, 11807743 },
	{ 25, 10759167 },
	{ 24, 7613439 },
	{ 24, 6564863 },
	{ 24, 3419135 },
	{ 24, 5615357 },
	{ 22, 1321983 },
	{ 17, 65215 },
	{ 15, 16350 },
	{ 13, 4043 },
	{ 16, 32571 },
	{ 22, 207871 },
	{ 22, 1256447 },
	{ 24, 2305023 },
	{ 24, 3353599 },
	{ 24, 6499327 },
	{ 24, 7547903 },
	{ 25, 10693631 },
	{ 25, 11742207 },
	{ 25, 14887935 },
	{ 25, 15936511 },
	{ 26, 27470847 },
	{ 26, 66333439 },
	{ 26, 65284863 },
	{ 26, 62139135 },
	{ 26, 61090559 },
	{ 26, 32779007 },
	{ 26, 31730431 },
	{ 26, 28584703 },
	{ 26, 27536127 },
	{ 25, 16001791 },
	{ 25, 14953215 },
	{ 25, 11807487 },
	{ 25, 10758911 },
	{ 24, 7613183 },
	{ 24, 6564607 },
	{ 24, 3418879 },
	{ 24, 5615613 },
	{ 22, 1321727 },
	{ 18, 130495 },
	{ 15, 16222 },
	{ 14, 8107 },
	{ 16, 32747 },
	{ 22, 207615 },
	{ 22, 1256191 },
	{ 24, 2304767 },
	{ 24, 3353343 },
	{ 24, 6499071 },
	{ 24, 7547647 },
	{ 25, 10693375 },
	{ 25, 11741951 },
	{ 25, 14887679 },
	{ 25, 15936255 },
	{ 26, 27470591 },
	{ 26, 28519167 },
	{ 26, 31664895 },
	{ 26, 32713471 },
	{ 26, 61025023 },
	{ 26, 62073599 },
	{ 26, 65219327 },
	{ 26, 66267903 },
	{ 26, 27402239 },
	{ 25, 15867903 },
	{ 25, 14819327 },
	{ 25, 11673599 },
	{ 25, 10625023 },
	{ 24, 7479295 },
	{ 24, 6430719 },
	{ 24, 3284991 },
	{ 24, 2236415 },
	{ 22, 1187839 },
	{ 22, 139263 },
	{ 15, 15982 },
	{ 16, 32443 },
	{ 16, 32123 },
	{ 20, 40955 },
	{ 20, 303099 },
	{ 20, 385023 },
	{ 22, 827387 },
	{ 22, 1613819 },
	{ 22, 1875963 },
	{ 22, 1957887 },
	{ 23, 2924539 },
	{ 23, 3710971 },
	{ 23, 3973115 },
	{ 23, 4055039 },
	{ 24, 7118843 },
	{ 24, 7905275 },
	{ 24, 8167419 },
	{ 24, 15245307 },
	{ 24, 15507451 },
	{ 24, 16293883 },
	{ 24, 16556027 },
	{ 24, 16637951 },
	{ 25, 15867647 },
	{ 25, 14819071 },
	{ 25, 11673343 },
	{ 25, 10624767 },
	{ 24, 7479039 },
	{ 24, 6430463 },
	{ 24, 3284735 },
	{ 24, 2236159 },
	{ 22, 1187583 },
	{ 22, 139007 },
	{ 15, 14958 },
	{ 17, 64955 },
	{ 16, 30075 },
	{ 20, 40699 },
	{ 20, 302843 },
	{ 20, 384767 },
	{ 22, 827131 },
	{ 22, 1613563 },
	{ 22, 1875707 },
	{ 22, 1957631 },
	{ 23, 2924283 },
	{ 23, 3710715 },
	{ 23, 3972859 },
	{ 23, 4054783 },
	{ 24, 7118587 },
	{ 24, 7905019 },
	{ 24, 8167163 },
	{ 24, 15245051 },
	{ 24, 15507195 },
	{ 24, 16293627 },
	{ 24, 16555771 },
	{ 24, 16637695 },
	{ 25, 15932415 },
	{ 25, 14883839 },
	{ 25, 11738111 },
	{ 25, 10689535 },
	{ 24, 7543807 },
	{ 24, 6495231 },
	{ 24, 3349503 },
	{ 24, 2300927 },
	{ 22, 1252351 },
	{ 22, 203775 },
	{ 15, 14062 },
	{ 22, 138235 },
	{ 20, 334843 },
	{ 22, 531451 },
	{ 20, 105467 },
	{ 20, 367611 },
	{ 22, 629755 },
	{ 22, 891899 },
	{ 22, 1678331 },
	{ 22, 1940475 },
	{ 23, 2726907 },
	{ 23, 2989051 },
	{ 23, 3775483 },
	{ 23, 4037627 },
	{ 24, 6921211 },
	{ 24, 7183355 },
	{ 24, 7969787 },
	{ 24, 8231931 },
	{ 24, 15309819 },
	{ 24, 15571963 },
	{ 24, 16358395 },
	{ 24, 16620539 },
	{ 25, 15932159 },
	{ 25, 14883583 },
	{ 25, 11737855 },
	{ 25, 10689279 },
	{ 24, 7543551 },
	{ 24, 6494975 },
	{ 24, 3349247 },
	{ 24, 2300671 },
	{ 22, 1252095 },
	{ 22, 203519 },
	{ 15, 13038 },
	{ 22, 137979 },
	{ 20, 334587 },
	{ 22, 531195 },
	{ 20, 105211 },
	{ 20, 367355 },
	{ 22, 629499 },
	{ 22, 891643 },
	{ 22, 1678075 },
	{ 22, 1940219 },
	{ 23, 2726651 },
	{ 23, 2988795 },
	{ 23, 3775227 },
	{ 23, 4037371 },
	{ 24, 6920955 },
	{ 24, 7183099 },
	{ 24, 7969531 },
	{ 24, 8231675 },
	{ 24, 15309563 },
	{ 24, 15571707 },
	{ 24, 16358139 },
	{ 24, 16620283 },
	{ 25, 16125951 },
	{ 25, 15077375 },
	{ 25, 11931647 },
	{ 25, 10883071 },
	{ 24, 7737343 },
	{ 24, 6688767 },
	{ 24, 3543039 },
	{ 24, 2494463 },
	{ 22, 1445887 },
	{ 22, 397311 },
	{ 17, 31086 },
	{ 22, 200699 },
	{ 22, 1183739 },
	{ 22, 593915 },
	{ 22, 790523 },
	{ 22, 167931 },
	{ 22, 1216507 },
	{ 22, 1298431 },
	{ 24, 3313659 },
	{ 24, 6459387 },
	{ 24, 7507963 },
	{ 24, 7589887 },
	{ 25, 11702267 },
	{ 25, 14847995 },
	{ 25, 15896571 },
	{ 25, 15978495 },
	{ 26, 28479483 },
	{ 26, 31625211 },
	{ 26, 32673787 },
	{ 26, 60985339 },
	{ 26, 62033915 },
	{ 26, 65179643 },
	{ 25, 16125695 },
	{ 25, 15077119 },
	{ 25, 11931391 },
	{ 25, 10882815 },
	{ 24, 7737087 },
	{ 24, 6688511 },
	{ 24, 3542783 },
	{ 24, 2494207 },
	{ 22, 1445631 },
	{ 22, 397055 },
	{ 17, 26990 },
	{ 22, 200443 },
	{ 22, 1183483 },
	{ 22, 593659 },
	{ 22, 790267 },
	{ 22, 167675 },
	{ 22, 1216251 },
	{ 22, 1298175 },
	{ 24, 3313403 },
	{ 24, 6459131 },
	{ 24, 7507707 },
	{ 24, 7589631 },
	{ 25, 11702011 },
	{ 25, 14847739 },
	{ 25, 15896315 },
	{ 25, 15978239 },
	{ 26, 28479227 },
	{ 26, 31624955 },
	{ 26, 32673531 },
	{ 26, 60985083 },
	{ 26, 62033659 },
	{ 26, 65179387 },
	{ 25, 16190463 },
	{ 25, 15141887 },
	{ 25, 11996159 },
	{ 25, 10947583 },
	{ 24, 7801855 },
	{ 24, 6753279 },
	{ 24, 3607551 },
	{ 24, 2558975 },
	{ 22, 1510399 },
	{ 22, 461823 },
	{ 17, 23022 },
	{ 22, 396283 },
	{ 22, 1248251 },
	{ 24, 2231291 },
	{ 22, 855035 },
	{ 22, 1575931 },
	{ 22, 232443 },
	{ 22, 1281019 },
	{ 22, 1494015 },
	{ 24, 3378171 },
	{ 24, 6523899 },
	{ 24, 7572475 },
	{ 24, 7785471 },
	{ 25, 11766779 },
	{ 25, 14912507 },
	{ 25, 15961083 },
	{ 25, 16174079 },
	{ 26, 28543995 },
	{ 26, 31689723 },
	{ 26, 32738299 },
	{ 26, 61049851 },
	{ 26, 62098427 },
	{ 25, 16190207 },
	{ 25, 15141631 },
	{ 25, 11995903 },
	{ 25, 10947327 },
	{ 24, 7801599 },
	{ 24, 6753023 },
	{ 24, 3607295 },
	{ 24, 2558719 },
	{ 22, 1510143 },
	{ 22, 461567 },
	{ 17, 18926 },
	{ 22, 396027 },
	{ 22, 1247995 },
	{ 24, 2231035 },
	{ 22, 854779 },
	{ 22, 1575675 },
	{ 22, 232187 },
	{ 22, 1280763 },
	{ 22, 1493759 },
	{ 24, 3377915 },
	{ 24, 6523643 },
	{ 24, 7572219 },
	{ 24, 7785215 },
	{ 25, 11766523 },
	{ 25, 14912251 },
	{ 25, 15960827 },
	{ 25, 16173823 },
	{ 25, 30574591 },
	{ 25, 16418815 },
	{ 25, 15894527 },
	{ 25, 14321663 },
	{ 25, 13797375 },
	{ 24, 8030207 },
	{ 24, 7505919 },
	{ 24, 5933055 },
	{ 24, 5408767 },
	{ 23, 3835903 },
	{ 23, 3311615 },
	{ 23, 1738751 },
	{ 23, 1214463 },
	{ 21, 690175 },
	{ 21, 165887 },
	{ 15, 15214 },
	{ 20, 116731 },
	{ 20, 362491 },
	{ 22, 575483 },
	{ 22, 821243 },
	{ 20, 411643 },
	{ 20, 460795 },
	{ 20, 108539 },
	{ 20, 370683 },
	{ 20, 391167 },
	{ 22, 894971 },
	{ 22, 1681403 },
	{ 22, 1943547 },
	{ 22, 1964031 },
	{ 23, 2992123 },
	{ 23, 3778555 },
	{ 23, 4040699 },
	{ 23, 4061183 },
	{ 24, 7186427 },
	{ 24, 7972859 },
	{ 24, 8235003 },
	{ 24, 15312891 },
	{ 24, 15575035 },
	{ 24, 16361467 },
	{ 24, 16623611 },
	{ 24, 5408511 },
	{ 23, 3835647 },
	{ 23, 3311359 },
	{ 23, 1738495 },
	{ 23, 1214207 },
	{ 21, 689919 },
	{ 21, 165631 },
	{ 15, 11118 },
	{ 20, 116475 },
	{ 20, 362235 },
	{ 22, 575227 },
	{ 22, 820987 },
	{ 20, 411387 },
	{ 20, 460539 },
	{ 20, 108283 },
	{ 20, 370427 },
	{ 20, 390911 },
	{ 22, 894715 },
	{ 22, 1681147 },
	{ 22, 1943291 },
	{ 22, 1963775 },
	{ 23, 2991867 },
	{ 23, 3778299 },
	{ 23, 4040443 },
	{ 23, 4060927 },
	{ 24, 7186171 },
	{ 24, 7972603 },
	{ 24, 8234747 },
	{ 24, 15312635 },
	{ 24, 15574779 },
	{ 24, 16361211 },
	{ 24, 16623355 },
	{ 24, 16643839 },
	{ 23, 3851263 },
	{ 23, 3326975 },
	{ 23, 1754111 },
	{ 23, 1229823 },
	{ 21, 705535 },
	{ 21, 181247 },
	{ 15, 7150 },
	{ 21, 164859 },
	{ 20, 377851 },
	{ 22, 623611 },
	{ 22, 836603 },
	{ 22, 1606651 },
	{ 20, 476155 },
	{ 21, 656379 },
	{ 20, 123899 },
	{ 20, 386043 },
	{ 21, 701439 },
	{ 22, 910331 },
	{ 22, 1696763 },
	{ 22, 1958907 },
	{ 23, 2745339 },
	{ 23, 3007483 },
	{ 23, 3793915 },
	{ 23, 4056059 },
	{ 24, 6939643 },
	{ 24, 7201787 },
	{ 24, 7988219 },
	{ 24, 8250363 },
	{ 24, 15328251 },
	{ 24, 15590395 },
	{ 24, 16376827 },
	{ 24, 16638971 },
	{ 23, 3851007 },
	{ 23, 3326719 },
	{ 23, 1753855 },
	{ 23, 1229567 },
	{ 21, 705279 },
	{ 21, 180991 },
	{ 15, 3054 },
	{ 21, 164603 },
	{ 20, 377595 },
	{ 22, 623355 },
	{ 22, 836347 },
	{ 22, 1606395 },
	{ 20, 475899 },
	{ 21, 656123 },
	{ 20, 123643 },
	{ 20, 385787 },
	{ 21, 701183 },
	{ 22, 910075 },
	{ 22, 1696507 },
	{ 22, 1958651 },
	{ 23, 2745083 },
	{ 23, 3007227 },
	{ 23, 3793659 },
	{ 23, 4055803 },
	{ 23, 4121087 },
	{ 23, 3990015 },
	{ 23, 3596799 },
	{ 23, 3465727 },
	{ 22, 2023935 },
	{ 22, 1892863 },
	{ 22, 1499647 },
	{ 22, 1368575 },
	{ 21, 975359 },
	{ 21, 844287 },
	{ 21, 451071 },
	{ 21, 319999 },
	{ 19, 188927 },
	{ 19, 57855 },
	{ 14, 9582 },
	{ 19, 45563 },
	{ 19, 172539 },
	{ 20, 160251 },
	{ 20, 221691 },
	{ 20, 406011 },
	{ 20, 467451 },
	{ 19, 168443 },
	{ 19, 180731 },
	{ 19, 43515 },
	{ 19, 174587 },
	{ 19, 179711 },
	{ 21, 436731 },
	{ 21, 829947 },
	{ 21, 961019 },
	{ 21, 966143 },
	{ 22, 1485307 },
	{ 22, 1878523 },
	{ 22, 2009595 },
	{ 22, 2014719 },
	{ 23, 3597565 },
	{ 23, 3466493 },
	{ 22, 2024701 },
	{ 22, 1893629 },
	{ 22, 1500413 },
	{ 22, 1369341 },
	{ 21, 976125 },
	{ 21, 845053 },
	{ 21, 451837 },
	{ 21, 320765 },
	{ 19, 189693 },
	{ 19, 58621 },
	{ 14, 1306 },
	{ 19, 46329 },
	{ 19, 173305 },
	{ 20, 161017 },
	{ 20, 222457 },
	{ 20, 406777 },
	{ 20, 468217 },
	{ 19, 169209 },
	{ 19, 181497 },
	{ 19, 167161 },
	{ 19, 171257 },
	{ 19, 186621 },
	{ 21, 670969 },
	{ 21, 683257 },
	{ 21, 687353 },
	{ 21, 751869 },
	{ 22, 1359097 },
	{ 22, 1371385 },
	{ 22, 1375481 },
	{ 22, 1505533 },
	{ 23, 2735353 },
	{ 23, 2747641 },
	{ 22, 2024957 },
	{ 22, 1893885 },
	{ 22, 1500669 },
	{ 22, 1369597 },
	{ 21, 976381 },
	{ 21, 845309 },
	{ 21, 452093 },
	{ 21, 321021 },
	{ 19, 189949 },
	{ 19, 58877 },
	{ 14, 9498 },
	{ 19, 46585 },
	{ 19, 173561 },
	{ 20, 161273 },
	{ 20, 222713 },
	{ 20, 407033 },
	{ 20, 468473 },
	{ 19, 169465 },
	{ 19, 181753 },
	{ 19, 167417 },
	{ 19, 171513 },
	{ 19, 186877 },
	{ 21, 671225 },
	{ 21, 683513 },
	{ 21, 687609 },
	{ 21, 752125 },
	{ 22, 1359353 },
	{ 22, 1371641 },
	{ 22, 1375737 },
	{ 22, 1505789 },
	{ 23, 2735609 },
	{ 23, 2747897 },
	{ 23, 4170233 },
	{ 23, 3912185 },
	{ 23, 3138041 },
	{ 23, 2879993 },
	{ 23, 2883065 },
	{ 23, 3396349 },
	{ 23, 1823485 },
	{ 23, 1299197 },
	{ 21, 774909 },
	{ 21, 250621 },
	{ 16, 5530 },
	{ 21, 234233 },
	{ 21, 709369 },
	{ 23, 1217273 },
	{ 22, 905977 },
	{ 22, 1676025 },
	{ 22, 1889017 },
	{ 23, 2659065 },
	{ 21, 742137 },
	{ 21, 922361 },
	{ 21, 733945 },
	{ 21, 750329 },
	{ 21, 942845 },
	{ 23, 2945785 },
	{ 23, 2994937 },
	{ 23, 3011321 },
	{ 23, 3793661 },
	{ 24, 5960441 },
	{ 24, 6009593 },
	{ 24, 6025977 },
	{ 24, 7594749 },
	{ 25, 11989753 },
	{ 24, 8115197 },
	{ 24, 7590909 },
	{ 24, 6018045 },
	{ 24, 5493757 },
	{ 23, 3920893 },
	{ 23, 3396605 },
	{ 23, 1823741 },
	{ 23, 1299453 },
	{ 21, 775165 },
	{ 21, 250877 },
	{ 16, 13722 },
	{ 21, 234489 },
	{ 21, 709625 },
	{ 23, 1217529 },
	{ 22, 906233 },
	{ 22, 1676281 },
	{ 22, 1889273 },
	{ 23, 2659321 },
	{ 21, 742393 },
	{ 21, 922617 },
	{ 21, 734201 },
	{ 21, 750585 },
	{ 21, 943101 },
	{ 23, 2946041 },
	{ 23, 2995193 },
	{ 23, 3011577 },
	{ 23, 3793917 },
	{ 24, 5960697 },
	{ 24, 6009849 },
	{ 24, 6026233 },
	{ 24, 7595005 },
	{ 25, 11990009 },
	{ 25, 16237561 },
	{ 25, 15631353 },
	{ 25, 12502009 },
	{ 25, 11502585 },
	{ 24, 8373241 },
	{ 24, 6723325 },
	{ 24, 3577597 },
	{ 24, 2529021 },
	{ 22, 1480445 },
	{ 22, 431869 },
	{ 16, 22298 },
	{ 21, 251641 },
	{ 21, 759545 },
	{ 23, 1234681 },
	{ 23, 1742585 },
	{ 22, 1693433 },
	{ 22, 1939193 },
	{ 23, 2676473 },
	{ 23, 2922233 },
	{ 21, 939769 },
	{ 21, 988921 },
	{ 21, 931577 },
	{ 21, 947961 },
	{ 21, 1009405 },
	{ 23, 3733241 },
	{ 23, 3782393 },
	{ 23, 3798777 },
	{ 23, 4056829 },
	{ 24, 7534329 },
	{ 24, 7583481 },
	{ 24, 7599865 },
	{ 24, 8120061 },
	{ 25, 16221945 },
	{ 25, 15189753 },
	{ 25, 12486393 },
	{ 25, 11454201 },
	{ 24, 8357625 },
	{ 24, 7325433 },
	{ 24, 3577853 },
	{ 24, 2529277 },
	{ 22, 1480701 },
	{ 22, 432125 },
	{ 16, 30490 },
	{ 21, 251897 },
	{ 21, 759801 },
	{ 23, 1234937 },
	{ 23, 1742841 },
	{ 22, 1693689 },
	{ 22, 1939449 },
	{ 23, 2676729 },
	{ 23, 2922489 },
	{ 21, 940025 },
	{ 21, 989177 },
	{ 21, 931833 },
	{ 21, 948217 },
	{ 21, 1009661 },
	{ 23, 3733497 },
	{ 23, 3782649 },
	{ 23, 3799033 },
	{ 23, 4057085 },
	{ 24, 7534585 },
	{ 24, 7583737 },
	{ 24, 7600121 },
	{ 24, 8120317 },
	{ 25, 16222201 },
	{ 25, 15190009 },
	{ 25, 12486649 },
	{ 25, 11454457 },
	{ 24, 8357881 },
	{ 24, 7325689 },
	{ 25, 15726585 },
	{ 25, 16771069 },
	{ 24, 5982973 },
	{ 24, 1788669 },
	{ 18, 38810 },
	{ 24, 1723129 },
	{ 23, 3099385 },
	{ 25, 5131001 },
	{ 25, 7031545 },
	{ 25, 13257465 },
	{ 24, 7817977 },
	{ 25, 10898169 },
	{ 25, 11750137 },
	{ 25, 14830329 },
	{ 23, 4016889 },
	{ 24, 6834937 },
	{ 23, 3984121 },
	{ 23, 4049657 },
	{ 24, 6916861 },
	{ 25, 15977209 },
	{ 25, 16173817 },
	{ 25, 16239353 },
	{ 26, 32164601 },
	{ 26, 32230137 },
	{ 26, 32426745 },
	{ 26, 32492281 },
	{ 27, 64686841 },
	{ 27, 60689145 },
	{ 27, 48171769 },
	{ 27, 45746937 },
	{ 26, 33229561 },
	{ 26, 29231865 },
	{ 26, 16714489 },
	{ 26, 10177533 },
	{ 24, 5983229 },
	{ 24, 1788925 },
	{ 18, 47002 },
	{ 24, 1723385 },
	{ 23, 3099641 },
	{ 25, 5131257 },
	{ 25, 7031801 },
	{ 25, 13257721 },
	{ 24, 7818233 },
	{ 25, 10898425 },
	{ 25, 11750393 },
	{ 25, 14830585 },
	{ 23, 4017145 },
	{ 24, 6835193 },
	{ 23, 3984377 },
	{ 23, 4049913 },
	{ 24, 6917117 },
	{ 25, 15977465 },
	{ 25, 16174073 },
	{ 25, 16239609 },
	{ 26, 32164857 },
	{ 26, 32230393 },
	{ 26, 32427001 },
	{ 26, 32492537 },
	{ 27, 64687097 },
	{ 27, 60689401 },
	{ 27, 48172025 },
	{ 27, 45747193 },
	{ 26, 33229817 },
	{ 26, 29232121 },
	{ 26, 16714745 },
	{ 26, 10374909 },
	{ 24, 6180605 },
	{ 24, 1986301 },
	{ 19, 109850 },
	{ 24, 1789689 },
	{ 24, 5918457 },
	{ 25, 5197561 },
	{ 25, 7229177 },
	{ 25, 13324025 },
	{ 25, 15355641 },
	{ 25, 10964729 },
	{ 25, 11947769 },
	{ 25, 14896889 },
	{ 25, 15879929 },
	{ 24, 6901497 },
	{ 24, 7098105 },
	{ 24, 6868729 },
	{ 24, 6934265 },
	{ 24, 7180029 },
	{ 26, 62263033 },
	{ 26, 61279993 },
	{ 26, 27774713 },
	{ 26, 28806909 },
	{ 27, 57544441 },
	{ 27, 55512825 },
	{ 27, 64622329 },
	{ 27, 60493561 },
	{ 27, 48107257 },
	{ 27, 43978489 },
	{ 26, 33165049 },
	{ 26, 29036281 },
	{ 26, 16649977 },
	{ 26, 12521209 },
	{ 24, 6180861 },
	{ 24, 1986557 },
	{ 19, 126234 },
	{ 24, 1789945 },
	{ 24, 5918713 },
	{ 25, 5197817 },
	{ 25, 7229433 },
	{ 25, 13324281 },
	{ 25, 15355897 },
	{ 25, 10964985 },
	{ 25, 11948025 },
	{ 25, 14897145 },
	{ 25, 15880185 },
	{ 24, 6901753 },
	{ 24, 7098361 },
	{ 24, 6868985 },
	{ 24, 6934521 },
	{ 24, 7180285 },
	{ 26, 62263289 },
	{ 26, 61280249 },
	{ 26, 27774969 },
	{ 26, 28807165 },
	{ 27, 57544697 },
	{ 27, 55513081 },
	{ 27, 64622585 },
	{ 27, 60493817 },
	{ 27, 48107513 },
	{ 27, 43978745 },
	{ 26, 33165305 },
	{ 26, 29036537 },
	{ 26, 16650233 },
	{ 26, 12521465 },
	{ 24, 6249213 },
	{ 24, 2054909 },
	{ 19, 208282 },
	{ 24, 1989369 },
	{ 24, 5987065 },
	{ 26, 10115833 },
	{ 25, 7297785 },
	{ 25, 13523705 },
	{ 25, 15424249 },
	{ 26, 33528569 },
	{ 25, 12016377 },
	{ 25, 15096569 },
	{ 25, 15948537 },
	{ 24, 8362745 },
	{ 24, 4168441 },
	{ 24, 7887609 },
	{ 24, 16587513 },
	{ 24, 7199481 },
	{ 24, 7969533 },
	{ 26, 61217529 },
	{ 26, 32971513 },
	{ 26, 28826361 },
	{ 26, 31955709 },
	{ 27, 55450361 },
	{ 26, 32447225 },
	{ 27, 60431097 },
	{ 27, 47913721 },
	{ 27, 43916025 },
	{ 26, 31398649 },
	{ 26, 28973817 },
	{ 26, 16456441 },
	{ 26, 12458745 },
	{ 24, 8329977 },
	{ 24, 2055165 },
	{ 19, 212970 },
	{ 24, 1989625 },
	{ 24, 5987321 },
	{ 26, 10116089 },
	{ 25, 7298041 },
	{ 25, 13523961 },
	{ 25, 15424505 },
	{ 26, 33528825 },
	{ 25, 12016633 },
	{ 25, 15096825 },
	{ 25, 15948793 },
	{ 24, 8363001 },
	{ 24, 4168697 },
	{ 24, 7887865 },
	{ 24, 16587769 },
	{ 24, 7199737 },
	{ 24, 7969789 },
	{ 26, 61217785 },
	{ 26, 32971769 },
	{ 26, 28826617 },
	{ 26, 31955965 },
	{ 27, 55450617 },
	{ 26, 32447481 },
	{ 27, 60431353 },
	{ 27, 47913977 },
	{ 27, 43916281 },
	{ 26, 31398905 },
	{ 26, 28974073 },
	{ 26, 16456697 },
	{ 26, 12459001 },
	{ 24, 8330233 },
	{ 24, 3825405 },
	{ 19, 229354 },
	{ 24, 2055929 },
	{ 24, 6184697 },
	{ 26, 10182393 },
	{ 26, 14311161 },
	{ 25, 13590265 },
	{ 25, 15621881 },
	{ 26, 21716729 },
	{ 26, 33464057 },
	{ 25, 15163129 },
	{ 25, 16146169 },
	{ 24, 8380157 },
	{ 24, 8298233 },
	{ 24, 4103929 },
	{ 24, 16523001 },
	{ 24, 16326393 },
	{ 24, 7986937 },
	{ 24, 8232701 },
	{ 26, 32907001 },
	{ 26, 31923961 },
	{ 26, 31973113 },
	{ 26, 33005309 },
	{ 26, 32382713 },
	{ 26, 30351097 },
	{ 27, 47849209 },
	{ 27, 43720441 },
	{ 26, 31334137 },
	{ 26, 27205369 },
	{ 26, 16391929 },
	{ 26, 12263161 },
	{ 24, 8265465 },
	{ 24, 4136697 },
	{ 19, 245610 },
	{ 24, 2056185 },
	{ 24, 6184953 },
	{ 26, 10182649 },
	{ 26, 14311417 },
	{ 25, 13590521 },
	{ 25, 15622137 },
	{ 26, 21716985 },
	{ 26, 33464313 },
	{ 25, 15163385 },
	{ 25, 16146425 },
	{ 24, 8380413 },
	{ 24, 8298489 },
	{ 24, 4104185 },
	{ 24, 16523257 },
	{ 24, 16326649 },
	{ 24, 7987193 },
	{ 24, 8232957 },
	{ 26, 32907257 },
	{ 26, 31924217 },
	{ 26, 31973369 },
	{ 26, 33005565 },
	{ 26, 32382969 },
	{ 26, 30351353 },
	{ 27, 47849465 },
	{ 27, 43720697 },
	{ 26, 31334393 },
	{ 26, 27205625 },
	{ 26, 16392185 },
	{ 26, 12263417 },
	{ 24, 8265721 },
	{ 24, 4136953 },
	{ 19, 261994 },
	{ 26, 15280889 },
	{ 26, 24980217 },
	{ 28, 41495289 },
	{ 28, 57486073 },
	{ 28, 107555577 },
	{ 27, 62728953 },
	{ 28, 87632633 },
	{ 28, 95234809 },
	{ 28, 133049081 },
	{ 27, 64826105 },
	{ 28, 65940217 },
	{ 26, 33237757 },
	{ 26, 32385785 },
	{ 26, 15608569 },
	{ 26, 65022713 },
	{ 26, 62139129 },
	{ 26, 32975609 },
	{ 26, 61221629 },
	{ 28, 127412985 },
	{ 28, 115092217 },
	{ 28, 132066041 },
	{ 28, 128723705 },
	{ 28, 121121529 },
	{ 28, 96217849 },
	{ 29, 174598905 },
	{ 28, 124529401 },
	{ 28, 108538617 },
	{ 28, 58469113 },
	{ 28, 48769785 },
	{ 26, 32254713 },
	{ 26, 16263929 },
	{ 20, 343530 },
	{ 26, 15281145 },
	{ 26, 24980473 },
	{ 28, 41495545 },
	{ 28, 57486329 },
	{ 28, 107555833 },
	{ 27, 62729209 },
	{ 28, 87632889 },
	{ 28, 95235065 },
	{ 28, 133049337 },
	{ 27, 64826361 },
	{ 28, 65940473 },
	{ 26, 33238013 },
	{ 26, 32386041 },
	{ 26, 15608825 },
	{ 26, 65022969 },
	{ 26, 62139385 },
	{ 26, 32975865 },
	{ 26, 61221885 },
	{ 28, 127413241 },
	{ 28, 115092473 },
	{ 28, 132066297 },
	{ 28, 128723961 },
	{ 28, 121121785 },
	{ 28, 96218105 },
	{ 29, 174599161 },
	{ 28, 124529657 },
	{ 28, 108538873 },
	{ 28, 58469369 },
	{ 28, 48770041 },
	{ 26, 32254969 },
	{ 26, 16264185 },
	{ 20, 359914 },
	{ 26, 15544057 },
	{ 26, 32059129 },
	{ 28, 41758457 },
	{ 28, 58273529 },
	{ 28, 107818745 },
	{ 28, 124333817 },
	{ 28, 87895801 },
	{ 28, 96022265 },
	{ 28, 120401657 },
	{ 28, 132787961 },
	{ 28, 116010745 },
	{ 28, 65679097 },
	{ 26, 32452349 },
	{ 26, 32124665 },
	{ 26, 15347449 },
	{ 26, 61878009 },
	{ 26, 61091577 },
	{ 26, 61288185 },
	{ 26, 62271229 },
	{ 28, 114831097 },
	{ 28, 110898937 },
	{ 28, 128462585 },
	{ 28, 120336121 },
	{ 28, 95956729 },
	{ 28, 87830265 },
	{ 28, 124268281 },
	{ 28, 107753209 },
	{ 28, 58207993 },
	{ 28, 41692921 },
	{ 26, 31993593 },
	{ 26, 15478521 },
	{ 20, 376170 },
	{ 26, 15544313 },
	{ 26, 32059385 },
	{ 28, 41758713 },
	{ 28, 58273785 },
	{ 28, 107819001 },
	{ 28, 124334073 },
	{ 28, 87896057 },
	{ 28, 96022521 },
	{ 28, 120401913 },
	{ 28, 132788217 },
	{ 28, 116011001 },
	{ 28, 65679353 },
	{ 26, 32452605 },
	{ 26, 32124921 },
	{ 26, 15347705 },
	{ 26, 61878265 },
	{ 26, 61091833 },
	{ 26, 61288441 },
	{ 26, 62271485 },
	{ 28, 114831353 },
	{ 28, 110899193 },
	{ 28, 128462841 },
	{ 28, 120336377 },
	{ 28, 95956985 },
	{ 28, 87830521 },
	{ 28, 124268537 },
	{ 28, 107753465 },
	{ 28, 58208249 },
	{ 28, 41693177 },
	{ 26, 31993849 },
	{ 26, 15478777 },
	{ 20, 392554 },
	{ 26, 16333561 },
	{ 26, 32324345 },
	{ 27, 64552955 },
	{ 28, 58538745 },
	{ 28, 108608249 },
	{ 28, 124599033 },
	{ 29, 259930873 },
	{ 28, 96287481 },
	{ 28, 121191161 },
	{ 28, 128793337 },
	{ 28, 125713145 },
	{ 28, 108935929 },
	{ 28, 58604281 },
	{ 26, 32193277 },
	{ 26, 25049849 },
	{ 26, 8272633 },
	{ 26, 60832505 },
	{ 26, 32783097 },
	{ 26, 62339833 },
	{ 26, 65420029 },
	{ 27, 66519039 },
	{ 27, 64764665 },
	{ 28, 120077049 },
	{ 28, 95173369 },
	{ 28, 87571193 },
	{ 27, 62667513 },
	{ 28, 107494137 },
	{ 28, 57424633 },
	{ 28, 41433849 },
	{ 26, 24918777 },
	{ 26, 15219449 },
	{ 20, 471018 },
	{ 26, 16333817 },
	{ 26, 32324601 },
	{ 27, 64552699 },
	{ 28, 58539001 },
	{ 28, 108608505 },
	{ 28, 124599289 },
	{ 29, 259931129 },
	{ 28, 96287737 },
	{ 28, 121191417 },
	{ 28, 128793593 },
	{ 28, 125713401 },
	{ 28, 108936185 },
	{ 28, 58604537 },
	{ 26, 32193533 },
	{ 26, 25050105 },
	{ 26, 8272889 },
	{ 26, 60832761 },
	{ 26, 32783353 },
	{ 26, 62340089 },
	{ 26, 65420285 },
	{ 27, 66518783 },
	{ 27, 64764921 },
	{ 28, 120077305 },
	{ 28, 95173625 },
	{ 28, 87571449 },
	{ 27, 62667769 },
	{ 28, 107494393 },
	{ 28, 57424889 },
	{ 28, 41434105 },
	{ 26, 24919033 },
	{ 26, 15219705 },
	{ 20, 487402 },
	{ 26, 16596729 },
	{ 26, 33111801 },
	{ 27, 66124795 },
	{ 28, 65617657 },
	{ 28, 108871417 },
	{ 28, 125386489 },
	{ 29, 174931705 },
	{ 29, 259669753 },
	{ 28, 121454329 },
	{ 28, 129580793 },
	{ 28, 125779709 },
	{ 28, 125452025 },
	{ 28, 108674809 },
	{ 28, 58343161 },
	{ 26, 25116413 },
	{ 26, 24788729 },
	{ 26, 8011513 },
	{ 26, 32521977 },
	{ 26, 31735545 },
	{ 26, 65486585 },
	{ 26, 66469629 },
	{ 27, 64503545 },
	{ 27, 60571385 },
	{ 28, 94912249 },
	{ 28, 86785785 },
	{ 27, 62406393 },
	{ 27, 54279929 },
	{ 28, 57163513 },
	{ 28, 40648441 },
	{ 26, 24657657 },
	{ 26, 8142585 },
	{ 20, 503658 },
	{ 26, 16596985 },
	{ 26, 33112057 },
	{ 27, 66124539 },
	{ 28, 65617913 },
	{ 28, 108871673 },
	{ 28, 125386745 },
	{ 29, 174931961 },
	{ 29, 259670009 },
	{ 28, 121454585 },
	{ 28, 129581049 },
	{ 28, 125779965 },
	{ 28, 125452281 },
	{ 28, 108675065 },
	{ 28, 58343417 },
	{ 26, 25116669 },
	{ 26, 24788985 },
	{ 26, 8011769 },
	{ 26, 32522233 },
	{ 26, 31735801 },
	{ 26, 65486841 },
	{ 26, 66469885 },
	{ 27, 64503801 },
	{ 27, 60571641 },
	{ 28, 94912505 },
	{ 28, 86786041 },
	{ 27, 62406649 },
	{ 27, 54280185 },
	{ 28, 57163769 },
	{ 28, 40648697 },
	{ 26, 24657913 },
	{ 26, 8142841 },
	{ 20, 520042 },
	{ 26, 15220733 },
	{ 26, 33385209 },
	{ 27, 66646011 },
	{ 28, 65891065 },
	{ 28, 115960569 },
	{ 28, 125659897 },
	{ 29, 175729401 },
	{ 29, 191720185 },
	{ 29, 258894585 },
	{ 28, 129854201 },
	{ 29, 191785721 },
	{ 28, 125528829 },
	{ 28, 124676857 },
	{ 28, 107899641 },
	{ 28, 57567993 },
	{ 26, 24865533 },
	{ 26, 24013561 },
	{ 26, 7236345 },
	{ 26, 31484665 },
	{ 26, 28601081 },
	{ 26, 66546425 },
	{ 27, 63728377 },
	{ 27, 60320505 },
	{ 27, 47999737 },
	{ 28, 86534905 },
	{ 27, 61631225 },
	{ 27, 54029049 },
	{ 27, 29125369 },
	{ 28, 40397561 },
	{ 26, 23882489 },
	{ 26, 7891705 },
	{ 21, 863722 },
	{ 26, 8153853 },
	{ 26, 33385465 },
	{ 27, 66645755 },
	{ 28, 65891321 },
	{ 28, 115960825 },
	{ 28, 125660153 },
	{ 29, 175729657 },
	{ 29, 191720441 },
	{ 29, 258894841 },
	{ 28, 129854457 },
	{ 29, 191785977 },
	{ 28, 125529085 },
	{ 28, 124677113 },
	{ 28, 107899897 },
	{ 28, 57568249 },
	{ 26, 24865789 },
	{ 26, 24013817 },
	{ 26, 7236601 },
	{ 26, 31484921 },
	{ 26, 28601337 },
	{ 26, 66546681 },
	{ 27, 63728633 },
	{ 27, 60320761 },
	{ 27, 47999993 },
	{ 28, 86535161 },
	{ 27, 61631481 },
	{ 27, 54029305 },
	{ 27, 29125625 },
	{ 28, 40397817 },
	{ 26, 23882745 },
	{ 26, 7891961 },
	{ 21, 880106 },
	{ 26, 8154109 },
	{ 26, 24931325 },
	{ 27, 49999615 },
	{ 28, 66678521 },
	{ 28, 116223737 },
	{ 28, 132738809 },
	{ 29, 175992569 },
	{ 29, 192507641 },
	{ 29, 242052857 },
	{ 29, 258633465 },
	{ 29, 241856249 },
	{ 29, 191524601 },
	{ 28, 124743421 },
	{ 28, 124415737 },
	{ 28, 107638521 },
	{ 28, 57306873 },
	{ 26, 24080125 },
	{ 26, 23752441 },
	{ 26, 6975225 },
	{ 26, 28339961 },
	{ 26, 27553529 },
	{ 27, 63467257 },
	{ 27, 59535097 },
	{ 27, 47738617 },
	{ 27, 43806457 },
	{ 27, 61370105 },
	{ 27, 53243641 },
	{ 27, 28864249 },
	{ 27, 20737785 },
	{ 26, 23621369 },
	{ 26, 7106297 },
	{ 21, 896362 },
	{ 26, 7892733 },
	{ 26, 24669949 },
	{ 27, 49474559 },
	{ 28, 66678777 },
	{ 28, 116223993 },
	{ 28, 132739065 },
	{ 29, 175992825 },
	{ 29, 192507897 },
	{ 29, 242053113 },
	{ 29, 258633721 },
	{ 29, 241856505 },
	{ 29, 191524857 },
	{ 28, 124743677 },
	{ 28, 124415993 },
	{ 28, 107638777 },
	{ 28, 57307129 },
	{ 26, 24080381 },
	{ 26, 23752697 },
	{ 26, 6975481 },
	{ 26, 28340217 },
	{ 26, 27553785 },
	{ 27, 63467513 },
	{ 27, 59535353 },
	{ 27, 47738873 },
	{ 27, 43806713 },
	{ 27, 61370361 },
	{ 27, 53243897 },
	{ 27, 28864505 },
	{ 27, 20738041 },
	{ 26, 23621625 },
	{ 26, 7106553 },
	{ 21, 912746 },
	{ 26, 7892989 },
	{ 26, 24670205 },
	{ 27, 49474303 },
	{ 28, 66943737 },
	{ 28, 117013241 },
	{ 28, 133004025 },
	{ 29, 264141561 },
	{ 29, 255752953 },
	{ 29, 230587129 },
	{ 29, 222198521 },
	{ 28, 129923833 },
	{ 28, 121535225 },
	{ 28, 96369401 },
	{ 28, 87980793 },
	{ 27, 62814969 },
	{ 27, 54426361 },
	{ 27, 29260537 },
	{ 26, 23821053 },
	{ 25, 12483321 },
	{ 25, 4094713 },
	{ 26, 27294457 },
	{ 25, 16022265 },
	{ 26, 32161787 },
	{ 27, 46955257 },
	{ 27, 43547385 },
	{ 26, 31226617 },
	{ 27, 52984569 },
	{ 27, 28080889 },
	{ 27, 20478713 },
	{ 25, 12352249 },
	{ 26, 6847225 },
	{ 20, 497642 },
	{ 20, 1046430 },
	{ 26, 23886589 },
	{ 27, 47890431 },
	{ 28, 66943993 },
	{ 28, 117013497 },
	{ 28, 133004281 },
	{ 29, 264141817 },
	{ 29, 255753209 },
	{ 29, 230587385 },
	{ 29, 222198777 },
	{ 28, 129924089 },
	{ 28, 121535481 },
	{ 28, 96369657 },
	{ 28, 87981049 },
	{ 27, 62815225 },
	{ 27, 54426617 },
	{ 27, 29260793 },
	{ 26, 23821309 },
	{ 25, 12483577 },
	{ 25, 4094969 },
	{ 26, 27294713 },
	{ 25, 16022521 },
	{ 26, 32161531 },
	{ 27, 46955513 },
	{ 27, 43547641 },
	{ 26, 31226873 },
	{ 27, 52984825 },
	{ 27, 28081145 },
	{ 27, 20478969 },
	{ 25, 12352505 },
	{ 26, 6847481 },
	{ 20, 505834 },
	{ 20, 1038238 },
	{ 26, 23886845 },
	{ 27, 47890175 },
	{ 28, 57441277 },
	{ 28, 117276409 },
	{ 28, 133791481 },
	{ 29, 490372857 },
	{ 29, 263880441 },
	{ 29, 255491833 },
	{ 29, 230326009 },
	{ 28, 129990397 },
	{ 28, 129662713 },
	{ 28, 121274105 },
	{ 28, 96108281 },
	{ 27, 62881533 },
	{ 27, 62553849 },
	{ 27, 54165241 },
	{ 27, 28999417 },
	{ 25, 12549885 },
	{ 25, 12222201 },
	{ 25, 3833593 },
	{ 25, 15761145 },
	{ 25, 14974713 },
	{ 26, 30063611 },
	{ 27, 42761977 },
	{ 26, 30965497 },
	{ 26, 27033337 },
	{ 27, 27819769 },
	{ 27, 19693305 },
	{ 25, 12091129 },
	{ 25, 3964665 },
	{ 20, 513898 },
	{ 20, 1029918 },
	{ 26, 23625469 },
	{ 27, 47365119 },
	{ 28, 57179901 },
	{ 28, 117276665 },
	{ 28, 133791737 },
	{ 29, 490373113 },
	{ 29, 263880697 },
	{ 29, 255492089 },
	{ 29, 230326265 },
	{ 28, 129990653 },
	{ 28, 129662969 },
	{ 28, 121274361 },
	{ 28, 96108537 },
	{ 27, 62881789 },
	{ 27, 62554105 },
	{ 27, 54165497 },
	{ 27, 28999673 },
	{ 25, 12550141 },
	{ 25, 12222457 },
	{ 25, 3833849 },
	{ 25, 15761401 },
	{ 25, 14974969 },
	{ 26, 30063355 },
	{ 27, 42762233 },
	{ 26, 30965753 },
	{ 26, 27033593 },
	{ 27, 27820025 },
	{ 27, 19693561 },
	{ 25, 12091385 },
	{ 25, 3964921 },
	{ 20, 522090 },
	{ 20, 1021726 },
	{ 26, 23625725 },
	{ 27, 47364863 },
	{ 28, 57180157 },
	{ 28, 107511805 },
	{ 28, 124289021 },
	{ 29, 174620669 },
	{ 29, 191397885 },
	{ 29, 241729533 },
	{ 29, 258506749 },
	{ 30, 459057913 },
	{ 29, 259435261 },
	{ 29, 257731321 },
	{ 29, 240954105 },
	{ 29, 190622457 },
	{ 28, 125217533 },
	{ 28, 123513593 },
	{ 28, 106736377 },
	{ 28, 56404729 },
	{ 26, 24554237 },
	{ 26, 22850297 },
	{ 26, 6073081 },
	{ 26, 29403897 },
	{ 26, 23636729 },
	{ 26, 23769083 },
	{ 27, 60336889 },
	{ 27, 53521145 },
	{ 27, 28879609 },
	{ 27, 29011963 },
	{ 26, 22588153 },
	{ 26, 7383801 },
	{ 20, 955882 },
	{ 20, 980382 },
	{ 26, 24685309 },
	{ 26, 24817663 },
	{ 28, 58239741 },
	{ 28, 108571389 },
	{ 28, 125348605 },
	{ 28, 125480959 },
	{ 29, 192457469 },
	{ 29, 242789117 },
	{ 29, 259566333 },
	{ 29, 259698687 },
	{ 29, 259435517 },
	{ 29, 257731577 },
	{ 29, 240954361 },
	{ 29, 190622713 },
	{ 28, 125217789 },
	{ 28, 123513849 },
	{ 28, 106736633 },
	{ 28, 56404985 },
	{ 26, 24554493 },
	{ 26, 22850553 },
	{ 26, 6073337 },
	{ 26, 29404153 },
	{ 26, 23636985 },
	{ 26, 23768827 },
	{ 27, 60337145 },
	{ 27, 53521401 },
	{ 27, 28879865 },
	{ 27, 29011707 },
	{ 26, 22588409 },
	{ 26, 7384057 },
	{ 20, 964074 },
	{ 20, 972190 },
	{ 26, 24685565 },
	{ 26, 24817407 },
	{ 28, 58239997 },
	{ 28, 108571645 },
	{ 28, 125348861 },
	{ 28, 125480703 },
	{ 29, 192457725 },
	{ 29, 242789373 },
	{ 29, 259566589 },
	{ 29, 259698431 },
	{ 30, 458534649 },
	{ 29, 257863421 },
	{ 29, 257208057 },
	{ 29, 240430841 },
	{ 29, 190099193 },
	{ 28, 123645693 },
	{ 28, 122990329 },
	{ 28, 106213113 },
	{ 28, 55881465 },
	{ 26, 22982397 },
	{ 26, 22327033 },
	{ 26, 5549817 },
	{ 26, 23113465 },
	{ 26, 21540601 },
	{ 26, 21670907 },
	{ 27, 51949305 },
	{ 27, 28356345 },
	{ 27, 20492025 },
	{ 26, 22064889 },
	{ 26, 5811961 },
	{ 20, 972138 },
	{ 20, 963870 },
	{ 26, 24162045 },
	{ 26, 24292351 },
	{ 28, 57716477 },
	{ 28, 108048125 },
	{ 28, 124825341 },
	{ 28, 124955647 },
	{ 29, 191934205 },
	{ 29, 242265853 },
	{ 29, 259043069 },
	{ 29, 259173375 },
	{ 30, 458534905 },
	{ 29, 257863677 },
	{ 29, 257208313 },
	{ 29, 240431097 },
	{ 29, 190099449 },
	{ 28, 123645949 },
	{ 28, 122990585 },
	{ 28, 106213369 },
	{ 28, 55881721 },
	{ 26, 22982653 },
	{ 26, 22327289 },
	{ 26, 5550073 },
	{ 26, 23113721 },
	{ 26, 21540857 },
	{ 26, 21670651 },
	{ 27, 51949561 },
	{ 27, 28356601 },
	{ 27, 20492281 },
	{ 26, 22065145 },
	{ 26, 5812217 },
	{ 20, 980330 },
	{ 20, 955678 },
	{ 26, 24162301 },
	{ 26, 24292095 },
	{ 28, 57716733 },
	{ 28, 108048381 },
	{ 28, 124825597 },
	{ 28, 124955391 },
	{ 28, 134184955 },
	{ 28, 133922811 },
	{ 28, 133136379 },
	{ 28, 132874235 },
	{ 28, 125796347 },
	{ 28, 125534203 },
	{ 28, 124747771 },
	{ 28, 129809145 },
	{ 27, 62881787 },
	{ 27, 62619643 },
	{ 27, 61833211 },
	{ 27, 62700281 },
	{ 26, 31424507 },
	{ 26, 31162363 },
	{ 26, 22461181 },
	{ 25, 12368633 },
	{ 24, 7831547 },
	{ 24, 7569403 },
	{ 25, 15252217 },
	{ 24, 7700475 },
	{ 26, 25788411 },
	{ 26, 13467643 },
	{ 25, 12106489 },
	{ 24, 6127611 },
	{ 19, 510954 },
	{ 19, 261022 },
	{ 25, 2981887 },
	{ 25, 11370495 },
	{ 27, 19759103 },
	{ 27, 28147711 },
	{ 27, 53313535 },
	{ 27, 61702143 },
	{ 28, 134184699 },
	{ 28, 133922555 },
	{ 28, 133136123 },
	{ 28, 132873979 },
	{ 28, 125796091 },
	{ 28, 125533947 },
	{ 28, 124747515 },
	{ 28, 129809401 },
	{ 27, 62881531 },
	{ 27, 62619387 },
	{ 27, 61832955 },
	{ 27, 62700537 },
	{ 26, 31424251 },
	{ 26, 31162107 },
	{ 26, 22461437 },
	{ 25, 12368889 },
	{ 24, 7831291 },
	{ 24, 7569147 },
	{ 25, 15252473 },
	{ 24, 7700219 },
	{ 26, 25788155 },
	{ 26, 13467387 },
	{ 25, 12106745 },
	{ 24, 6127355 },
	{ 19, 515050 },
	{ 19, 256926 },
	{ 25, 2981631 },
	{ 25, 11370239 },
	{ 27, 19758847 },
	{ 27, 28147455 },
	{ 27, 53313279 },
	{ 27, 61701887 },
	{ 28, 86867711 },
	{ 28, 117406715 },
	{ 28, 117144571 },
	{ 28, 116358139 },
	{ 28, 116095995 },
	{ 28, 109018107 },
	{ 28, 108755963 },
	{ 28, 129941245 },
	{ 27, 62815231 },
	{ 27, 54492155 },
	{ 27, 54230011 },
	{ 27, 62832381 },
	{ 26, 31357951 },
	{ 26, 27229179 },
	{ 26, 26967035 },
	{ 25, 12500733 },
	{ 24, 7764991 },
	{ 24, 6781947 },
	{ 24, 6519803 },
	{ 24, 7437307 },
	{ 24, 6650875 },
	{ 26, 13204475 },
	{ 25, 11583225 },
	{ 24, 5864443 },
	{ 19, 519018 },
	{ 19, 252702 },
	{ 25, 2718719 },
	{ 25, 11107327 },
	{ 27, 19495935 },
	{ 27, 27884543 },
	{ 27, 53050367 },
	{ 27, 61438975 },
	{ 28, 134118143 },
	{ 28, 117406459 },
	{ 28, 117144315 },
	{ 28, 116357883 },
	{ 28, 116095739 },
	{ 28, 109017851 },
	{ 28, 108755707 },
	{ 28, 129941501 },
	{ 27, 62814975 },
	{ 27, 54491899 },
	{ 27, 54229755 },
	{ 27, 62832637 },
	{ 26, 31357695 },
	{ 26, 27228923 },
	{ 26, 26966779 },
	{ 25, 12500989 },
	{ 24, 7764735 },
	{ 24, 6781691 },
	{ 24, 6519547 },
	{ 24, 7437051 },
	{ 24, 6650619 },
	{ 26, 13204219 },
	{ 25, 11583481 },
	{ 24, 5864187 },
	{ 19, 523114 },
	{ 19, 248606 },
	{ 25, 2718463 },
	{ 25, 11107071 },
	{ 27, 19495679 },
	{ 27, 27884287 },
	{ 27, 53050111 },
	{ 27, 61438719 },
	{ 28, 86604543 },
	{ 28, 94993151 },
	{ 28, 67071995 },
	{ 28, 66809851 },
	{ 28, 66023419 },
	{ 28, 65761275 },
	{ 28, 58683387 },
	{ 28, 58421243 },
	{ 28, 129428221 },
	{ 27, 54423551 },
	{ 27, 29323259 },
	{ 27, 29061115 },
	{ 27, 62319357 },
	{ 26, 27160575 },
	{ 26, 14643195 },
	{ 26, 14381051 },
	{ 25, 11987709 },
	{ 24, 6713343 },
	{ 24, 3633147 },
	{ 24, 3371003 },
	{ 24, 6385659 },
	{ 24, 3502075 },
	{ 25, 10021625 },
	{ 24, 5074939 },
	{ 24, 1667067 },
	{ 19, 227742 },
	{ 24, 1929215 },
	{ 24, 6123519 },
	{ 26, 10317823 },
	{ 26, 14512127 },
	{ 26, 27095039 },
	{ 26, 31289343 },
	{ 27, 43872255 },
	{ 27, 48066559 },
	{ 27, 60649471 },
	{ 27, 64843775 },
	{ 28, 66023163 },
	{ 28, 65761019 },
	{ 28, 58683131 },
	{ 28, 58420987 },
	{ 28, 129428477 },
	{ 27, 54423295 },
	{ 27, 29323003 },
	{ 27, 29060859 },
	{ 27, 62319613 },
	{ 26, 27160319 },
	{ 26, 14642939 },
	{ 26, 14380795 },
	{ 25, 11987965 },
	{ 24, 6713087 },
	{ 24, 3632891 },
	{ 24, 3370747 },
	{ 24, 6385403 },
	{ 24, 3501819 },
	{ 25, 10021881 },
	{ 24, 5074683 },
	{ 24, 1666811 },
	{ 19, 223646 },
	{ 24, 1928959 },
	{ 24, 6123263 },
	{ 26, 10317567 },
	{ 26, 14511871 },
	{ 26, 27094783 },
	{ 26, 31289087 },
	{ 27, 43871999 },
	{ 27, 48066303 },
	{ 27, 60649215 },
	{ 27, 64843519 },
	{ 28, 50031611 },
	{ 28, 49245179 },
	{ 28, 48983035 },
	{ 28, 41905147 },
	{ 28, 41643003 },
	{ 28, 127856381 },
	{ 27, 29256703 },
	{ 27, 20933627 },
	{ 27, 20671483 },
	{ 27, 60747517 },
	{ 26, 14576639 },
	{ 26, 10447867 },
	{ 26, 10185723 },
	{ 25, 10415869 },
	{ 24, 3566591 },
	{ 24, 2583547 },
	{ 24, 2321403 },
	{ 24, 3238907 },
	{ 24, 2452475 },
	{ 24, 4811771 },
	{ 24, 879611 },
	{ 19, 219422 },
	{ 24, 1666047 },
	{ 24, 5860351 },
	{ 26, 10054655 },
	{ 26, 14248959 },
	{ 26, 26831871 },
	{ 26, 31026175 },
	{ 27, 43609087 },
	{ 27, 47803391 },
	{ 27, 60386303 },
	{ 27, 64580607 },
	{ 28, 50031355 },
	{ 28, 49244923 },
	{ 28, 48982779 },
	{ 28, 41904891 },
	{ 28, 41642747 },
	{ 28, 127856637 },
	{ 27, 29256447 },
	{ 27, 20933371 },
	{ 27, 20671227 },
	{ 27, 60747773 },
	{ 26, 14576383 },
	{ 26, 10447611 },
	{ 26, 10185467 },
	{ 25, 10416125 },
	{ 24, 3566335 },
	{ 24, 2583291 },
	{ 24, 2321147 },
	{ 24, 3238651 },
	{ 24, 2452219 },
	{ 24, 4811515 },
	{ 24, 879355 },
	{ 19, 215326 },
	{ 24, 1665791 },
	{ 24, 5860095 },
	{ 26, 10054399 },
	{ 26, 14248703 },
	{ 26, 26831615 },
	{ 26, 31025919 },
	{ 27, 43608831 },
	{ 27, 47803135 },
	{ 27, 60386047 },
	{ 27, 132971257 },
	{ 26, 33505275 },
	{ 26, 33243131 },
	{ 26, 32456699 },
	{ 26, 32194555 },
	{ 26, 25116667 },
	{ 26, 24854523 },
	{ 26, 24068091 },
	{ 26, 32307961 },
	{ 25, 12533755 },
	{ 25, 12271611 },
	{ 25, 11485179 },
	{ 25, 15530745 },
	{ 24, 6242299 },
	{ 24, 5980155 },
	{ 24, 5193723 },
	{ 23, 2947833 },
	{ 22, 1523707 },
	{ 22, 1261563 },
	{ 23, 2685689 },
	{ 22, 1392635 },
	{ 24, 606203 },
	{ 16, 32414 },
	{ 24, 868351 },
	{ 24, 5062655 },
	{ 26, 9256959 },
	{ 26, 13451263 },
	{ 26, 26034175 },
	{ 26, 30228479 },
	{ 27, 42811391 },
	{ 27, 47005695 },
	{ 27, 59588607 },
	{ 27, 132971513 },
	{ 26, 33505019 },
	{ 26, 33242875 },
	{ 26, 32456443 },
	{ 26, 32194299 },
	{ 26, 25116411 },
	{ 26, 24854267 },
	{ 26, 24067835 },
	{ 26, 32308217 },
	{ 25, 12533499 },
	{ 25, 12271355 },
	{ 25, 11484923 },
	{ 25, 15531001 },
	{ 24, 6242043 },
	{ 24, 5979899 },
	{ 24, 5193467 },
	{ 23, 2948089 },
	{ 22, 1523451 },
	{ 22, 1261307 },
	{ 23, 2685945 },
	{ 22, 1392379 },
	{ 24, 605947 },
	{ 16, 31390 },
	{ 24, 868095 },
	{ 24, 5062399 },
	{ 26, 9256703 },
	{ 26, 13451007 },
	{ 26, 26033919 },
	{ 26, 30228223 },
	{ 27, 42811135 },
	{ 27, 47005439 },
	{ 27, 59588351 },
	{ 27, 133103357 },
	{ 26, 33438719 },
	{ 26, 16727035 },
	{ 26, 16464891 },
	{ 26, 15678459 },
	{ 26, 15416315 },
	{ 26, 8338427 },
	{ 26, 8076283 },
	{ 26, 32440061 },
	{ 25, 12467199 },
	{ 25, 4144123 },
	{ 25, 3881979 },
	{ 25, 15662845 },
	{ 24, 6175743 },
	{ 24, 2046971 },
	{ 24, 1784827 },
	{ 23, 3079933 },
	{ 22, 1457151 },
	{ 22, 474107 },
	{ 22, 211963 },
	{ 17, 61307 },
	{ 20, 524219 },
	{ 16, 30238 },
	{ 24, 605183 },
	{ 24, 4799487 },
	{ 26, 8993791 },
	{ 26, 13188095 },
	{ 26, 25771007 },
	{ 26, 29965311 },
	{ 27, 42548223 },
	{ 27, 46742527 },
	{ 27, 59325439 },
	{ 27, 133103613 },
	{ 26, 33438463 },
	{ 26, 16726779 },
	{ 26, 16464635 },
	{ 26, 15678203 },
	{ 26, 15416059 },
	{ 26, 8338171 },
	{ 26, 8076027 },
	{ 26, 32440317 },
	{ 25, 12466943 },
	{ 25, 4143867 },
	{ 25, 3881723 },
	{ 25, 15663101 },
	{ 24, 6175487 },
	{ 24, 2046715 },
	{ 24, 1784571 },
	{ 23, 3080189 },
	{ 22, 1456895 },
	{ 22, 473851 },
	{ 22, 211707 },
	{ 17, 59259 },
	{ 19, 261755 },
	{ 16, 29214 },
	{ 24, 604927 },
	{ 24, 4799231 },
	{ 26, 8993535 },
	{ 26, 13187839 },
	{ 26, 25770751 },
	{ 26, 29965055 },
	{ 27, 42547967 },
	{ 27, 46742271 },
	{ 27, 59325183 },
	{ 27, 63519487 },
	{ 28, 265136893 },
	{ 26, 16658431 },
	{ 26, 16396287 },
	{ 26, 15609855 },
	{ 26, 15347711 },
	{ 26, 8269823 },
	{ 26, 8007679 },
	{ 26, 7221247 },
	{ 26, 6959103 },
	{ 25, 4075519 },
	{ 25, 3813375 },
	{ 25, 3026943 },
	{ 25, 2764799 },
	{ 24, 1978367 },
	{ 24, 1716223 },
	{ 24, 929791 },
	{ 24, 5090045 },
	{ 22, 405503 },
	{ 22, 143359 },
	{ 17, 65343 },
	{ 17, 65387 },
	{ 17, 65342 },
	{ 19, 262079 },
	{ 22, 1388543 },
	{ 24, 2437119 },
	{ 24, 3485695 },
	{ 24, 6631423 },
	{ 24, 7679999 },
	{ 25, 10825727 },
	{ 25, 11874303 },
	{ 25, 15020031 },
	{ 25, 16068607 },
	{ 26, 27602943 },
	{ 26, 16658175 },
	{ 26, 16396031 },
	{ 26, 15609599 },
	{ 26, 15347455 },
	{ 26, 8269567 },
	{ 26, 8007423 },
	{ 26, 7220991 },
	{ 26, 6958847 },
	{ 25, 4075263 },
	{ 25, 3813119 },
	{ 25, 3026687 },
	{ 25, 2764543 },
	{ 24, 1978111 },
	{ 24, 1715967 },
	{ 24, 929535 },
	{ 24, 5090301 },
	{ 22, 405247 },
	{ 22, 143103 },
	{ 17, 65519 },
	{ 14, 8155 },
	{ 12, 1998 },
	{ 18, 130687 },
	{ 22, 1388287 },
	{ 24, 2436863 },
	{ 24, 3485439 },
	{ 24, 6631167 },
	{ 24, 7679743 },
	{ 25, 10825471 },
	{ 25, 11874047 },
	{ 25, 15019775 },
	{ 25, 16068351 },
	{ 26, 27602687 },
	{ 26, 28651263 },
	{ 26, 31796991 },
	{ 26, 32845567 },
	{ 26, 61157119 },
	{ 26, 62205695 },
	{ 26, 65351423 },
	{ 26, 66399999 },
	{ 26, 31468543 },
	{ 26, 28322815 },
	{ 26, 27274239 },
	{ 25, 15739903 },
	{ 25, 14691327 },
	{ 25, 11545599 },
	{ 25, 10497023 },
	{ 24, 7351295 },
	{ 24, 6302719 },
	{ 24, 3156991 },
	{ 24, 4566781 },
	{ 17, 44415 },
	{ 13, 4047 },
	{ 12, 1934 },
	{ 16, 32623 },
	{ 17, 44927 },
	{ 24, 2173951 },
	{ 24, 3222527 },
	{ 24, 6368255 },
	{ 24, 7416831 },
	{ 25, 10562559 },
	{ 25, 11611135 },
	{ 25, 14756863 },
	{ 25, 15805439 },
	{ 26, 27339775 },
	{ 26, 28388351 },
	{ 26, 31534079 },
	{ 26, 66071295 },
	{ 26, 65022719 },
	{ 26, 61876991 },
	{ 26, 60828415 },
	{ 26, 32516863 },
	{ 26, 31468287 },
	{ 26, 28322559 },
	{ 26, 27273983 },
	{ 25, 15739647 },
	{ 25, 14691071 },
	{ 25, 11545343 },
	{ 25, 10496767 },
	{ 24, 7351039 },
	{ 24, 6302463 },
	{ 24, 3156735 },
	{ 24, 4567037 },
	{ 17, 42367 },
	{ 14, 8111 },
	{ 24, 110589 },
	{ 13, 4063 },
	{ 17, 42879 },
	{ 24, 2173695 },
	{ 24, 3222271 },
	{ 24, 6367999 },
	{ 24, 7416575 },
	{ 25, 10562303 },
	{ 25, 11610879 },
	{ 25, 14756607 },
	{ 25, 15805183 },
	{ 26, 27339519 },
	{ 26, 28388095 },
	{ 26, 31533823 },
	{ 24, 16588799 },
	{ 24, 16326655 },
	{ 24, 15540223 },
	{ 24, 15278079 },
	{ 24, 8200191 },
	{ 24, 7938047 },
	{ 24, 7151615 },
	{ 24, 6889471 },
	{ 23, 4005887 },
	{ 23, 3743743 },
	{ 23, 2957311 },
	{ 23, 2695167 },
	{ 22, 1908735 },
	{ 22, 1646591 },
	{ 22, 860159 },
	{ 22, 598015 },
	{ 20, 335871 },
	{ 16, 32447 },
	{ 14, 8158 },
	{ 12, 1995 },
	{ 15, 16187 },
	{ 20, 57343 },
	{ 20, 319487 },
	{ 22, 581631 },
	{ 22, 843775 },
	{ 22, 1630207 },
	{ 22, 1892351 },
	{ 23, 2678783 },
	{ 23, 2940927 },
	{ 23, 3727359 },
	{ 23, 3989503 },
	{ 24, 6873087 },
	{ 24, 16588543 },
	{ 24, 16326399 },
	{ 24, 15539967 },
	{ 24, 15277823 },
	{ 24, 8199935 },
	{ 24, 7937791 },
	{ 24, 7151359 },
	{ 24, 6889215 },
	{ 23, 4005631 },
	{ 23, 3743487 },
	{ 23, 2957055 },
	{ 23, 2694911 },
	{ 22, 1908479 },
	{ 22, 1646335 },
	{ 22, 859903 },
	{ 22, 597759 },
	{ 20, 335615 },
	{ 17, 64959 },
	{ 14, 8030 },
	{ 13, 4011 },
	{ 15, 16363 },
	{ 20, 57087 },
	{ 20, 319231 },
	{ 22, 581375 },
	{ 22, 843519 },
	{ 22, 1629951 },
	{ 22, 1892095 },
	{ 23, 2678527 },
	{ 23, 2940671 },
	{ 23, 3727103 },
	{ 23, 3989247 },
	{ 24, 6872831 },
	{ 24, 7134975 },
	{ 24, 7921407 },
	{ 24, 8183551 },
	{ 24, 15261439 },
	{ 24, 15523583 },
	{ 24, 16310015 },
	{ 24, 16572159 },
	{ 26, 27401215 },
	{ 25, 15866879 },
	{ 25, 14818303 },
	{ 25, 11672575 },
	{ 25, 10623999 },
	{ 24, 7478271 },
	{ 24, 6429695 },
	{ 24, 3283967 },
	{ 24, 2235391 },
	{ 22, 1186815 },
	{ 22, 138239 },
	{ 15, 13934 },
	{ 15, 16059 },
	{ 16, 28027 },
	{ 20, 39931 },
	{ 20, 302075 },
	{ 20, 383999 },
	{ 22, 826363 },
	{ 22, 1612795 },
	{ 22, 1874939 },
	{ 22, 1956863 },
	{ 23, 2923515 },
	{ 23, 3709947 },
	{ 23, 3972091 },
	{ 23, 4054015 },
	{ 24, 7117819 },
	{ 24, 7904251 },
	{ 24, 8166395 },
	{ 24, 15244283 },
	{ 24, 15506427 },
	{ 24, 16292859 },
	{ 24, 16555003 },
	{ 24, 16636927 },
	{ 25, 15866623 },
	{ 25, 14818047 },
	{ 25, 11672319 },
	{ 25, 10623743 },
	{ 24, 7478015 },
	{ 24, 6429439 },
	{ 24, 3283711 },
	{ 24, 2235135 },
	{ 22, 1186559 },
	{ 22, 137983 },
	{ 15, 12910 },
	{ 16, 32187 },
	{ 16, 25979 },
	{ 20, 39675 },
	{ 20, 301819 },
	{ 20, 383743 },
	{ 22, 826107 },
	{ 22, 1612539 },
	{ 22, 1874683 },
	{ 22, 1956607 },
	{ 23, 2923259 },
	{ 23, 3709691 },
	{ 23, 3971835 },
	{ 23, 4053759 },
	{ 24, 7117563 },
	{ 24, 7903995 },
	{ 24, 8166139 },
	{ 24, 15244027 },
	{ 24, 15506171 },
	{ 24, 16292603 },
	{ 24, 16554747 },
	{ 24, 16636671 },
	{ 25, 15929343 },
	{ 25, 14880767 },
	{ 25, 11735039 },
	{ 25, 10686463 },
	{ 24, 7540735 },
	{ 24, 6492159 },
	{ 24, 3346431 },
	{ 24, 2297855 },
	{ 22, 1249279 },
	{ 22, 200703 },
	{ 15, 7918 },
	{ 22, 135163 },
	{ 20, 331771 },
	{ 22, 528379 },
	{ 20, 102395 },
	{ 20, 364539 },
	{ 22, 626683 },
	{ 22, 888827 },
	{ 22, 1675259 },
	{ 22, 1937403 },
	{ 23, 2723835 },
	{ 23, 2985979 },
	{ 23, 3772411 },
	{ 23, 4034555 },
	{ 24, 6918139 },
	{ 24, 7180283 },
	{ 24, 7966715 },
	{ 24, 8228859 },
	{ 24, 15306747 },
	{ 24, 15568891 },
	{ 24, 16355323 },
	{ 24, 16617467 },
	{ 25, 15929087 },
	{ 25, 14880511 },
	{ 25, 11734783 },
	{ 25, 10686207 },
	{ 24, 7540479 },
	{ 24, 6491903 },
	{ 24, 3346175 },
	{ 24, 2297599 },
	{ 22, 1249023 },
	{ 22, 200447 },
	{ 15, 6894 },
	{ 22, 134907 },
	{ 20, 331515 },
	{ 22, 528123 },
	{ 20, 102139 },
	{ 20, 364283 },
	{ 22, 626427 },
	{ 22, 888571 },
	{ 22, 1675003 },
	{ 22, 1937147 },
	{ 23, 2723579 },
	{ 23, 2985723 },
	{ 23, 3772155 },
	{ 23, 4034299 },
	{ 24, 6917883 },
	{ 24, 7180027 },
	{ 24, 7966459 },
	{ 24, 8228603 },
	{ 24, 15306491 },
	{ 24, 15568635 },
	{ 24, 16355067 },
	{ 24, 16617211 },
	{ 25, 16124927 },
	{ 25, 15076351 },
	{ 25, 11930623 },
	{ 25, 10882047 },
	{ 24, 7736319 },
	{ 24, 6687743 },
	{ 24, 3542015 },
	{ 24, 2493439 },
	{ 22, 1444863 },
	{ 22, 396287 },
	{ 17, 22894 },
	{ 22, 199675 },
	{ 22, 1182715 },
	{ 22, 592891 },
	{ 22, 789499 },
	{ 22, 166907 },
	{ 22, 1215483 },
	{ 22, 1297407 },
	{ 24, 3312635 },
	{ 24, 6458363 },
	{ 24, 7506939 },
	{ 24, 7588863 },
	{ 25, 11701243 },
	{ 25, 14846971 },
	{ 25, 15895547 },
	{ 25, 15977471 },
	{ 26, 28478459 },
	{ 26, 31624187 },
	{ 26, 32672763 },
	{ 26, 60984315 },
	{ 26, 62032891 },
	{ 26, 65178619 },
	{ 25, 16124671 },
	{ 25, 15076095 },
	{ 25, 11930367 },
	{ 25, 10881791 },
	{ 24, 7736063 },
	{ 24, 6687487 },
	{ 24, 3541759 },
	{ 24, 2493183 },
	{ 22, 1444607 },
	{ 22, 396031 },
	{ 17, 18798 },
	{ 22, 199419 },
	{ 22, 1182459 },
	{ 22, 592635 },
	{ 22, 789243 },
	{ 22, 166651 },
	{ 22, 1215227 },
	{ 22, 1297151 },
	{ 24, 3312379 },
	{ 24, 6458107 },
	{ 24, 7506683 },
	{ 24, 7588607 },
	{ 25, 11700987 },
	{ 25, 14846715 },
	{ 24, 16631807 },
	{ 24, 16369663 },
	{ 24, 15583231 },
	{ 24, 15321087 },
	{ 24, 8243199 },
	{ 24, 7981055 },
	{ 24, 7194623 },
	{ 24, 6932479 },
	{ 23, 4048895 },
	{ 23, 3786751 },
	{ 23, 3000319 },
	{ 23, 2738175 },
	{ 22, 1951743 },
	{ 22, 1689599 },
	{ 22, 903167 },
	{ 22, 641023 },
	{ 20, 378879 },
	{ 20, 116735 },
	{ 15, 14830 },
	{ 20, 100347 },
	{ 20, 313339 },
	{ 22, 559099 },
	{ 20, 215035 },
	{ 20, 395259 },
	{ 20, 59387 },
	{ 20, 321531 },
	{ 20, 374783 },
	{ 22, 845819 },
	{ 22, 1632251 },
	{ 22, 1894395 },
	{ 22, 1947647 },
	{ 23, 2942971 },
	{ 23, 3729403 },
	{ 23, 3991547 },
	{ 23, 4044799 },
	{ 24, 7137275 },
	{ 24, 7923707 },
	{ 24, 8185851 },
	{ 24, 15263739 },
	{ 24, 15525883 },
	{ 23, 4048639 },
	{ 23, 3786495 },
	{ 23, 3000063 },
	{ 23, 2737919 },
	{ 22, 1951487 },
	{ 22, 1689343 },
	{ 22, 902911 },
	{ 22, 640767 },
	{ 20, 378623 },
	{ 20, 116479 },
	{ 15, 10734 },
	{ 20, 100091 },
	{ 20, 313083 },
	{ 22, 558843 },
	{ 20, 214779 },
	{ 20, 395003 },
	{ 20, 59131 },
	{ 20, 321275 },
	{ 20, 374527 },
	{ 22, 845563 },
	{ 22, 1631995 },
	{ 22, 1894139 },
	{ 22, 1947391 },
	{ 23, 2942715 },
	{ 23, 3729147 },
	{ 23, 3991291 },
	{ 23, 4044543 },
	{ 24, 7137019 },
	{ 24, 7923451 },
	{ 24, 8185595 },
	{ 24, 15263483 },
	{ 24, 15525627 },
	{ 24, 16312059 },
	{ 24, 16574203 },
	{ 24, 16627455 },
	{ 24, 5407743 },
	{ 23, 3834879 },
	{ 23, 3310591 },
	{ 23, 1737727 },
	{ 23, 1213439 },
	{ 21, 689151 },
	{ 21, 164863 },
	{ 15, 7022 },
	{ 20, 115707 },
	{ 20, 361467 },
	{ 22, 574459 },
	{ 22, 820219 },
	{ 20, 410619 },
	{ 20, 459771 },
	{ 20, 107515 },
	{ 20, 369659 },
	{ 20, 390143 },
	{ 22, 893947 },
	{ 22, 1680379 },
	{ 22, 1942523 },
	{ 22, 1963007 },
	{ 23, 2991099 },
	{ 23, 3777531 },
	{ 23, 4039675 },
	{ 23, 4060159 },
	{ 24, 7185403 },
	{ 24, 7971835 },
	{ 24, 8233979 },
	{ 24, 15311867 },
	{ 24, 15574011 },
	{ 24, 16360443 },
	{ 24, 16622587 },
	{ 24, 5407487 },
	{ 23, 3834623 },
	{ 23, 3310335 },
	{ 23, 1737471 },
	{ 23, 1213183 },
	{ 21, 688895 },
	{ 21, 164607 },
	{ 15, 2926 },
	{ 20, 115451 },
	{ 20, 361211 },
	{ 22, 574203 },
	{ 22, 819963 },
	{ 20, 410363 },
	{ 20, 459515 },
	{ 20, 107259 },
	{ 20, 369403 },
	{ 20, 389887 },
	{ 22, 893691 },
	{ 22, 1680123 },
	{ 22, 1942267 },
	{ 22, 1962751 },
	{ 23, 2990843 },
	{ 23, 3777275 },
	{ 23, 4039419 },
	{ 23, 4059903 },
	{ 23, 4108799 },
	{ 23, 3977727 },
	{ 23, 3584511 },
	{ 23, 3453439 },
	{ 22, 2011647 },
	{ 22, 1880575 },
	{ 22, 1487359 },
	{ 22, 1356287 },
	{ 21, 963071 },
	{ 21, 831999 },
	{ 21, 438783 },
	{ 21, 307711 },
	{ 19, 176639 },
	{ 19, 45567 },
	{ 13, 5102 },
	{ 19, 41467 },
	{ 18, 94715 },
	{ 20, 156155 },
	{ 20, 209403 },
	{ 20, 401915 },
	{ 18, 119291 },
	{ 19, 164347 },
	{ 18, 31227 },
	{ 18, 96763 },
	{ 19, 175615 },
	{ 20, 227835 },
	{ 20, 424443 },
	{ 20, 489979 },
	{ 21, 686587 },
	{ 21, 752123 },
	{ 21, 948731 },
	{ 21, 1014267 },
	{ 22, 1735163 },
	{ 22, 1800699 },
	{ 22, 1997307 },
	{ 22, 2062843 },
	{ 22, 2012413 },
	{ 22, 1881341 },
	{ 22, 1488125 },
	{ 22, 1357053 },
	{ 21, 963837 },
	{ 21, 832765 },
	{ 21, 439549 },
	{ 21, 308477 },
	{ 19, 177405 },
	{ 19, 46333 },
	{ 13, 922 },
	{ 19, 42233 },
	{ 18, 95481 },
	{ 20, 156921 },
	{ 20, 210169 },
	{ 20, 402681 },
	{ 18, 120057 },
	{ 19, 165113 },
	{ 18, 118009 },
	{ 18, 122105 },
	{ 19, 170237 },
	{ 20, 474361 },
	{ 20, 486649 },
	{ 20, 490745 },
	{ 21, 961785 },
	{ 21, 965881 },
	{ 21, 978169 },
	{ 21, 982265 },
	{ 22, 1944825 },
	{ 22, 1948921 },
	{ 22, 1961209 },
	{ 22, 1965305 },
	{ 22, 2075897 },
	{ 22, 2079993 },
	{ 22, 2092281 },
	{ 22, 2096377 },
	{ 21, 964093 },
	{ 21, 833021 },
	{ 21, 439805 },
	{ 21, 308733 },
	{ 19, 177661 },
	{ 19, 46589 },
	{ 13, 5018 },
	{ 19, 42489 },
	{ 18, 95737 },
	{ 20, 157177 },
	{ 20, 210425 },
	{ 20, 402937 },
	{ 18, 120313 },
	{ 19, 165369 },
	{ 18, 118265 },
	{ 18, 122361 },
	{ 19, 170493 },
	{ 20, 474617 },
	{ 20, 486905 },
	{ 20, 491001 },
	{ 21, 962041 },
	{ 21, 966137 },
	{ 21, 978425 },
	{ 21, 982521 },
	{ 22, 1945081 },
	{ 22, 1949177 },
	{ 22, 1961465 },
	{ 22, 1965561 },
	{ 22, 2076153 },
	{ 22, 2080249 },
	{ 22, 2092537 },
	{ 22, 2096633 },
	{ 23, 3904253 },
	{ 23, 3379965 },
	{ 23, 1807101 },
	{ 23, 1282813 },
	{ 21, 758525 },
	{ 21, 234237 },
	{ 16, 5402 },
	{ 21, 185081 },
	{ 21, 692985 },
	{ 22, 643833 },
	{ 22, 889593 },
	{ 22, 1626873 },
	{ 22, 1872633 },
	{ 21, 676601 },
	{ 21, 725753 },
	{ 21, 668409 },
	{ 21, 684793 },
	{ 21, 746237 },
	{ 23, 2683641 },
	{ 23, 2732793 },
	{ 23, 2749177 },
	{ 23, 3007229 },
	{ 24, 5436153 },
	{ 24, 5485305 },
	{ 24, 5501689 },
	{ 24, 6021885 },
	{ 25, 10941177 },
	{ 25, 10990329 },
	{ 24, 8098813 },
	{ 24, 7574525 },
	{ 24, 6001661 },
	{ 24, 5477373 },
	{ 23, 3904509 },
	{ 23, 3380221 },
	{ 23, 1807357 },
	{ 23, 1283069 },
	{ 21, 758781 },
	{ 21, 234493 },
	{ 16, 13594 },
	{ 21, 185337 },
	{ 21, 693241 },
	{ 22, 644089 },
	{ 22, 889849 },
	{ 22, 1627129 },
	{ 22, 1872889 },
	{ 21, 676857 },
	{ 21, 726009 },
	{ 21, 668665 },
	{ 21, 685049 },
	{ 21, 746493 },
	{ 23, 2683897 },
	{ 23, 2733049 },
	{ 23, 2749433 },
	{ 23, 3007485 },
	{ 24, 5436409 },
	{ 24, 5485561 },
	{ 24, 5501945 },
	{ 24, 6022141 },
	{ 25, 10941433 },
	{ 25, 10990585 },
	{ 24, 8115965 },
	{ 24, 7591677 },
	{ 24, 6018813 },
	{ 24, 5494525 },
	{ 23, 3921661 },
	{ 23, 3397373 },
	{ 23, 1824509 },
	{ 23, 1300221 },
	{ 21, 775933 },
	{ 21, 251645 },
	{ 16, 21914 },
	{ 21, 235257 },
	{ 21, 710393 },
	{ 23, 1218297 },
	{ 22, 907001 },
	{ 22, 1677049 },
	{ 22, 1890041 },
	{ 23, 2660089 },
	{ 21, 743161 },
	{ 21, 923385 },
	{ 21, 734969 },
	{ 21, 751353 },
	{ 21, 943869 },
	{ 23, 2946809 },
	{ 23, 2995961 },
	{ 23, 3012345 },
	{ 23, 3794685 },
	{ 24, 5961465 },
	{ 24, 6010617 },
	{ 24, 6027001 },
	{ 24, 7595773 },
	{ 25, 11990777 },
	{ 24, 8116221 },
	{ 24, 7591933 },
	{ 24, 6019069 },
	{ 24, 5494781 },
	{ 23, 3921917 },
	{ 23, 3397629 },
	{ 23, 1824765 },
	{ 23, 1300477 },
	{ 21, 776189 },
	{ 21, 251901 },
	{ 16, 30106 },
	{ 21, 235513 },
	{ 21, 710649 },
	{ 23, 1218553 },
	{ 22, 907257 },
	{ 22, 1677305 },
	{ 22, 1890297 },
	{ 23, 2660345 },
	{ 21, 743417 },
	{ 21, 923641 },
	{ 21, 735225 },
	{ 21, 751609 },
	{ 21, 944125 },
	{ 23, 2947065 },
	{ 23, 2996217 },
	{ 23, 3012601 },
	{ 23, 3794941 },
	{ 24, 5961721 },
	{ 24, 6010873 },
	{ 24, 6027257 },
	{ 24, 7596029 },
	{ 25, 11991033 },
	{ 25, 16238585 },
	{ 25, 15632377 },
	{ 25, 12503033 },
	{ 25, 11503609 },
	{ 24, 8374265 },
	{ 25, 12580857 },
	{ 25, 15722493 },
	{ 26, 10111741 },
	{ 24, 5917437 },
	{ 24, 1723133 },
	{ 18, 38682 },
	{ 23, 1002233 },
	{ 23, 3033849 },
	{ 25, 4934393 },
	{ 25, 6966009 },
	{ 24, 6769401 },
	{ 24, 7752441 },
	{ 25, 10701561 },
	{ 25, 11684601 },
	{ 23, 3754745 },
	{ 23, 3951353 },
	{ 23, 3721977 },
	{ 23, 3787513 },
	{ 23, 4033277 },
	{ 25, 14928633 },
	{ 25, 15125241 },
	{ 25, 15190777 },
	{ 25, 16222973 },
	{ 26, 30132985 },
	{ 26, 30329593 },
	{ 26, 30395129 },
	{ 26, 32475901 },
	{ 27, 64883449 },
	{ 27, 60754681 },
	{ 27, 49941241 },
	{ 27, 45812473 },
	{ 26, 33426169 },
	{ 26, 29297401 },
	{ 26, 14306301 },
	{ 26, 10111997 },
	{ 24, 5917693 },
	{ 24, 1723389 },
	{ 18, 46874 },
	{ 23, 1002489 },
	{ 23, 3034105 },
	{ 25, 4934649 },
	{ 25, 6966265 },
	{ 24, 6769657 },
	{ 24, 7752697 },
	{ 25, 10701817 },
	{ 25, 11684857 },
	{ 23, 3755001 },
	{ 23, 3951609 },
	{ 23, 3722233 },
	{ 23, 3787769 },
	{ 23, 4033533 },
	{ 25, 14928889 },
	{ 25, 15125497 },
	{ 25, 15191033 },
	{ 25, 16223229 },
	{ 26, 30133241 },
	{ 26, 30329849 },
	{ 26, 30395385 },
	{ 26, 32476157 },
	{ 27, 64883705 },
	{ 27, 60754937 },
	{ 27, 49941497 },
	{ 27, 45812729 },
	{ 26, 33426425 },
	{ 26, 29297657 },
	{ 26, 14372605 },
	{ 26, 10178301 },
	{ 24, 5983997 },
	{ 24, 1789693 },
	{ 18, 55194 },
	{ 24, 1724153 },
	{ 23, 3100409 },
	{ 25, 5132025 },
	{ 25, 7032569 },
	{ 25, 13258489 },
	{ 24, 7819001 },
	{ 25, 10899193 },
	{ 25, 11751161 },
	{ 25, 14831353 },
	{ 23, 4017913 },
	{ 24, 6835961 },
	{ 23, 3985145 },
	{ 23, 4050681 },
	{ 24, 6917885 },
	{ 25, 15978233 },
	{ 25, 16174841 },
	{ 25, 16240377 },
	{ 26, 32165625 },
	{ 26, 32231161 },
	{ 26, 32427769 },
	{ 26, 32493305 },
	{ 27, 64687865 },
	{ 27, 60690169 },
	{ 27, 48172793 },
	{ 27, 45747961 },
	{ 26, 33230585 },
	{ 26, 29232889 },
	{ 26, 16715513 },
	{ 26, 10178557 },
	{ 24, 5984253 },
	{ 24, 1789949 },
	{ 18, 63386 },
	{ 24, 1724409 },
	{ 23, 3100665 },
	{ 25, 5132281 },
	{ 25, 7032825 },
	{ 25, 13258745 },
	{ 24, 7819257 },
	{ 25, 10899449 },
	{ 25, 11751417 },
	{ 25, 14831609 },
	{ 23, 4018169 },
	{ 24, 6836217 },
	{ 23, 3985401 },
	{ 23, 4050937 },
	{ 24, 6918141 },
	{ 25, 15978489 },
	{ 25, 16175097 },
	{ 25, 16240633 },
	{ 26, 32165881 },
	{ 26, 32231417 },
	{ 26, 32428025 },
	{ 26, 32493561 },
	{ 27, 64688121 },
	{ 27, 60690425 },
	{ 27, 48173049 },
	{ 27, 45748217 },
	{ 26, 33230841 },
	{ 26, 29233145 },
	{ 26, 16715769 },
	{ 26, 10377981 },
	{ 24, 6183677 },
	{ 24, 1989373 },
	{ 19, 208154 },
	{ 24, 1792761 },
	{ 24, 5921529 },
	{ 25, 5200633 },
	{ 25, 7232249 },
	{ 25, 13327097 },
	{ 25, 15358713 },
	{ 25, 10967801 },
	{ 25, 11950841 },
	{ 25, 14899961 },
	{ 25, 15883001 },
	{ 24, 6904569 },
	{ 24, 7101177 },
	{ 24, 6871801 },
	{ 24, 6937337 },
	{ 24, 7183101 },
	{ 26, 62266105 },
	{ 26, 61283065 },
	{ 26, 27777785 },
	{ 26, 28809981 },
	{ 27, 57547513 },
	{ 27, 55515897 },
	{ 27, 64625401 },
	{ 27, 60496633 },
	{ 27, 48110329 },
	{ 27, 43981561 },
	{ 26, 33168121 },
	{ 26, 29039353 },
	{ 26, 16653049 },
	{ 26, 12524281 },
	{ 24, 6183933 },
	{ 24, 1989629 },
	{ 19, 224538 },
	{ 24, 1793017 },
	{ 24, 5921785 },
	{ 25, 5200889 },
	{ 25, 7232505 },
	{ 25, 13327353 },
	{ 25, 15358969 },
	{ 25, 10968057 },
	{ 25, 11951097 },
	{ 25, 14900217 },
	{ 25, 15883257 },
	{ 24, 6904825 },
	{ 24, 7101433 },
	{ 24, 6872057 },
	{ 24, 6937593 },
	{ 24, 7183357 },
	{ 26, 62266361 },
	{ 26, 61283321 },
	{ 26, 27778041 },
	{ 26, 28810237 },
	{ 27, 57547769 },
	{ 27, 55516153 },
	{ 27, 64625657 },
	{ 27, 60496889 },
	{ 27, 48110585 },
	{ 27, 43981817 },
	{ 26, 33168377 },
	{ 26, 29039609 },
	{ 26, 16653305 },
	{ 26, 12524537 },
	{ 24, 6250237 },
	{ 24, 2055933 },
	{ 19, 241050 },
	{ 24, 1990393 },
	{ 24, 5988089 },
	{ 26, 10116857 },
	{ 25, 7298809 },
	{ 25, 13524729 },
	{ 25, 15425273 },
	{ 26, 33529593 },
	{ 25, 12017401 },
	{ 25, 15097593 },
	{ 25, 15949561 },
	{ 24, 8363769 },
	{ 24, 4169465 },
	{ 24, 7888633 },
	{ 24, 16588537 },
	{ 24, 7200505 },
	{ 24, 7970557 },
	{ 26, 61218553 },
	{ 26, 32972537 },
	{ 26, 28827385 },
	{ 26, 31956733 },
	{ 27, 55451385 },
	{ 26, 32448249 },
	{ 27, 60432121 },
	{ 27, 47914745 },
	{ 27, 43917049 },
	{ 26, 31399673 },
	{ 26, 28974841 },
	{ 26, 16457465 },
	{ 26, 12459769 },
	{ 24, 8331001 },
	{ 24, 2056189 },
	{ 19, 245738 },
	{ 24, 1990649 },
	{ 24, 5988345 },
	{ 26, 10117113 },
	{ 25, 7299065 },
	{ 25, 13524985 },
	{ 25, 15425529 },
	{ 26, 33529849 },
	{ 25, 12017657 },
	{ 25, 15097849 },
	{ 25, 15949817 },
	{ 24, 8364025 },
	{ 24, 4169721 },
	{ 24, 7888889 },
	{ 24, 16588793 },
	{ 24, 7200761 },
	{ 24, 7970813 },
	{ 26, 61218809 },
	{ 26, 32972793 },
	{ 26, 28827641 },
	{ 26, 31956989 },
	{ 27, 55451641 },
	{ 26, 32448505 },
	{ 27, 60432377 },
	{ 27, 47915001 },
	{ 27, 43917305 },
	{ 26, 31399929 },
	{ 26, 28975097 },
	{ 26, 16457721 },
	{ 26, 12460025 },
	{ 24, 8331257 },
	{ 26, 15280893 },
	{ 19, 262122 },
	{ 26, 8203001 },
	{ 26, 24718073 },
	{ 28, 40708857 },
	{ 28, 57223929 },
	{ 27, 54340345 },
	{ 27, 62466809 },
	{ 28, 86846201 },
	{ 28, 133835513 },
	{ 27, 60631801 },
	{ 27, 64563961 },
	{ 26, 33499901 },
	{ 26, 33172217 },
	{ 26, 16395001 },
	{ 26, 66071289 },
	{ 26, 65284857 },
	{ 26, 31927033 },
	{ 26, 32910077 },
	{ 28, 131607289 },
	{ 28, 127675129 },
	{ 28, 127871737 },
	{ 28, 132000509 },
	{ 28, 129510137 },
	{ 28, 121383673 },
	{ 29, 191376121 },
	{ 29, 174861049 },
	{ 28, 125315833 },
	{ 28, 108800761 },
	{ 28, 65547001 },
	{ 28, 49031929 },
	{ 26, 33041145 },
	{ 26, 16526073 },
	{ 20, 343914 },
	{ 26, 8203257 },
	{ 26, 24718329 },
	{ 28, 40709113 },
	{ 28, 57224185 },
	{ 27, 54340601 },
	{ 27, 62467065 },
	{ 28, 86846457 },
	{ 28, 133835769 },
	{ 27, 60632057 },
	{ 27, 64564217 },
	{ 26, 33500157 },
	{ 26, 33172473 },
	{ 26, 16395257 },
	{ 26, 66071545 },
	{ 26, 65285113 },
	{ 26, 31927289 },
	{ 26, 32910333 },
	{ 28, 131607545 },
	{ 28, 127675385 },
	{ 28, 127871993 },
	{ 28, 132000765 },
	{ 28, 129510393 },
	{ 28, 121383929 },
	{ 29, 191376377 },
	{ 29, 174861305 },
	{ 28, 125316089 },
	{ 28, 108801017 },
	{ 28, 65547257 },
	{ 28, 49032185 },
	{ 26, 33041401 },
	{ 26, 16526329 },
	{ 20, 360298 },
	{ 26, 15281913 },
	{ 26, 24981241 },
	{ 28, 41496313 },
	{ 28, 57487097 },
	{ 28, 107556601 },
	{ 27, 62729977 },
	{ 28, 87633657 },
	{ 28, 95235833 },
	{ 28, 133050105 },
	{ 27, 64827129 },
	{ 28, 65941241 },
	{ 26, 33238781 },
	{ 26, 32386809 },
	{ 26, 15609593 },
	{ 26, 65023737 },
	{ 26, 62140153 },
	{ 26, 32976633 },
	{ 26, 61222653 },
	{ 28, 127414009 },
	{ 28, 115093241 },
	{ 28, 132067065 },
	{ 28, 128724729 },
	{ 28, 121122553 },
	{ 28, 96218873 },
	{ 29, 174599929 },
	{ 28, 124530425 },
	{ 28, 108539641 },
	{ 28, 58470137 },
	{ 28, 48770809 },
	{ 26, 32255737 },
	{ 26, 16264953 },
	{ 20, 376298 },
	{ 26, 15282169 },
	{ 26, 24981497 },
	{ 28, 41496569 },
	{ 28, 57487353 },
	{ 28, 107556857 },
	{ 27, 62730233 },
	{ 28, 87633913 },
	{ 28, 95236089 },
	{ 28, 133050361 },
	{ 27, 64827385 },
	{ 28, 65941497 },
	{ 26, 33239037 },
	{ 26, 32387065 },
	{ 26, 15609849 },
	{ 26, 65023993 },
	{ 26, 62140409 },
	{ 26, 32976889 },
	{ 26, 61222909 },
	{ 28, 127414265 },
	{ 28, 115093497 },
	{ 28, 132067321 },
	{ 28, 128724985 },
	{ 28, 121122809 },
	{ 28, 96219129 },
	{ 29, 174600185 },
	{ 28, 124530681 },
	{ 28, 108539897 },
	{ 28, 58470393 },
	{ 28, 48771065 },
	{ 26, 32255993 },
	{ 26, 16265209 },
	{ 20, 392682 },
	{ 26, 15547129 },
	{ 26, 32062201 },
	{ 27, 64028667 },
	{ 28, 58276601 },
	{ 28, 107821817 },
	{ 28, 124336889 },
	{ 28, 87898873 },
	{ 28, 96025337 },
	{ 28, 120404729 },
	{ 28, 132791033 },
	{ 28, 116013817 },
	{ 28, 65682169 },
	{ 26, 32455421 },
	{ 26, 32127737 },
	{ 26, 15350521 },
	{ 26, 61881081 },
	{ 26, 61094649 },
	{ 26, 61291257 },
	{ 26, 62274301 },
	{ 27, 64946175 },
	{ 28, 110902009 },
	{ 28, 128465657 },
	{ 28, 120339193 },
	{ 28, 95959801 },
	{ 28, 87833337 },
	{ 28, 124271353 },
	{ 28, 107756281 },
	{ 28, 58211065 },
	{ 28, 41695993 },
	{ 26, 31996665 },
	{ 26, 15481593 },
	{ 20, 474474 },
	{ 26, 15547385 },
	{ 26, 32062457 },
	{ 27, 64028411 },
	{ 28, 58276857 },
	{ 28, 107822073 },
	{ 28, 124337145 },
	{ 28, 87899129 },
	{ 28, 96025593 },
	{ 28, 120404985 },
	{ 28, 132791289 },
	{ 28, 116014073 },
	{ 28, 65682425 },
	{ 26, 32455677 },
	{ 26, 32127993 },
	{ 26, 15350777 },
	{ 26, 61881337 },
	{ 26, 61094905 },
	{ 26, 61291513 },
	{ 26, 62274557 },
	{ 27, 64945919 },
	{ 28, 110902265 },
	{ 28, 128465913 },
	{ 28, 120339449 },
	{ 28, 95960057 },
	{ 28, 87833593 },
	{ 28, 124271609 },
	{ 28, 107756537 },
	{ 28, 58211321 },
	{ 28, 41696249 },
	{ 26, 31996921 },
	{ 26, 15481849 },
	{ 20, 490858 },
	{ 26, 16334585 },
	{ 26, 32325369 },
	{ 27, 64551931 },
	{ 28, 58539769 },
	{ 28, 108609273 },
	{ 28, 124600057 },
	{ 29, 259931897 },
	{ 28, 96288505 },
	{ 28, 121192185 },
	{ 28, 128794361 },
	{ 28, 125714169 },
	{ 28, 108936953 },
	{ 28, 58605305 },
	{ 26, 32194301 },
	{ 26, 25050873 },
	{ 26, 8273657 },
	{ 26, 60833529 },
	{ 26, 32784121 },
	{ 26, 62340857 },
	{ 26, 65421053 },
	{ 27, 66518015 },
	{ 27, 64765689 },
	{ 28, 120078073 },
	{ 28, 95174393 },
	{ 28, 87572217 },
	{ 27, 62668537 },
	{ 28, 107495161 },
	{ 28, 57425657 },
	{ 28, 41434873 },
	{ 26, 24919801 },
	{ 26, 15220473 },
	{ 20, 503786 },
	{ 26, 16334841 },
	{ 26, 32325625 },
	{ 27, 64551675 },
	{ 28, 58540025 },
	{ 28, 108609529 },
	{ 28, 124600313 },
	{ 29, 259932153 },
	{ 28, 96288761 },
	{ 28, 121192441 },
	{ 28, 128794617 },
	{ 28, 125714425 },
	{ 28, 108937209 },
	{ 28, 58605561 },
	{ 26, 32194557 },
	{ 26, 25051129 },
	{ 26, 8273913 },
	{ 26, 60833785 },
	{ 26, 32784377 },
	{ 26, 62341113 },
	{ 26, 65421309 },
	{ 27, 66517759 },
	{ 27, 64765945 },
	{ 28, 120078329 },
	{ 28, 95174649 },
	{ 28, 87572473 },
	{ 27, 62668793 },
	{ 28, 107495417 },
	{ 28, 57425913 },
	{ 28, 41435129 },
	{ 26, 24920057 },
	{ 26, 15220729 },
	{ 20, 520170 },
	{ 26, 16607993 },
	{ 26, 33123065 },
	{ 27, 66121723 },
	{ 28, 65628921 },
	{ 28, 108882681 },
	{ 28, 125397753 },
	{ 29, 174942969 },
	{ 29, 259681017 },
	{ 28, 121465593 },
	{ 28, 129592057 },
	{ 28, 125790973 },
	{ 28, 125463289 },
	{ 28, 108686073 },
	{ 28, 58354425 },
	{ 26, 25127677 },
	{ 26, 24799993 },
	{ 26, 8022777 },
	{ 26, 32533241 },
	{ 26, 31746809 },
	{ 26, 65497849 },
	{ 26, 66480893 },
	{ 27, 64514809 },
	{ 27, 60582649 },
	{ 28, 94923513 },
	{ 28, 86797049 },
	{ 27, 62417657 },
	{ 27, 54291193 },
	{ 28, 57174777 },
	{ 28, 40659705 },
	{ 26, 24668921 },
	{ 26, 8153849 },
	{ 21, 864106 },
	{ 26, 16608249 },
	{ 26, 33123321 },
	{ 27, 66121467 },
	{ 28, 65629177 },
	{ 28, 108882937 },
	{ 28, 125398009 },
	{ 29, 174943225 },
	{ 29, 259681273 },
	{ 28, 121465849 },
	{ 28, 129592313 },
	{ 28, 125791229 },
	{ 28, 125463545 },
	{ 28, 108686329 },
	{ 28, 58354681 },
	{ 26, 25127933 },
	{ 26, 24800249 },
	{ 26, 8023033 },
	{ 26, 32533497 },
	{ 26, 31747065 },
	{ 26, 65498105 },
	{ 26, 66481149 },
	{ 27, 64515065 },
	{ 27, 60582905 },
	{ 28, 94923769 },
	{ 28, 86797305 },
	{ 27, 62417913 },
	{ 27, 54291449 },
	{ 28, 57175033 },
	{ 28, 40659961 },
	{ 26, 24669177 },
	{ 26, 8154105 },
	{ 21, 880490 },
	{ 26, 15231997 },
	{ 26, 33386233 },
	{ 27, 66644987 },
	{ 28, 65892089 },
	{ 28, 115961593 },
	{ 28, 125660921 },
	{ 29, 175730425 },
	{ 29, 191721209 },
	{ 29, 258895609 },
	{ 28, 129855225 },
	{ 29, 191786745 },
	{ 28, 125529853 },
	{ 28, 124677881 },
	{ 28, 107900665 },
	{ 28, 57569017 },
	{ 26, 24866557 },
	{ 26, 24014585 },
	{ 26, 7237369 },
	{ 26, 31485689 },
	{ 26, 28602105 },
	{ 26, 66547449 },
	{ 27, 63729401 },
	{ 27, 60321529 },
	{ 27, 48000761 },
	{ 28, 86535929 },
	{ 27, 61632249 },
	{ 27, 54030073 },
	{ 27, 29126393 },
	{ 28, 40398585 },
	{ 26, 23883513 },
	{ 26, 7892729 },
	{ 21, 896490 },
	{ 26, 8154877 },
	{ 26, 33386489 },
	{ 27, 66644731 },
	{ 28, 65892345 },
	{ 28, 115961849 },
	{ 28, 125661177 },
	{ 29, 175730681 },
	{ 29, 191721465 },
	{ 29, 258895865 },
	{ 28, 129855481 },
	{ 29, 191787001 },
	{ 28, 125530109 },
	{ 28, 124678137 },
	{ 28, 107900921 },
	{ 28, 57569273 },
	{ 26, 24866813 },
	{ 26, 24014841 },
	{ 26, 7237625 },
	{ 26, 31485945 },
	{ 26, 28602361 },
	{ 26, 66547705 },
	{ 27, 63729657 },
	{ 27, 60321785 },
	{ 27, 48001017 },
	{ 28, 86536185 },
	{ 27, 61632505 },
	{ 27, 54030329 },
	{ 27, 29126649 },
	{ 28, 40398841 },
	{ 26, 23883769 },
	{ 26, 7892985 },
	{ 21, 912874 },
	{ 26, 8155133 },
	{ 26, 24932349 },
	{ 27, 49998591 },
	{ 28, 66681593 },
	{ 28, 116226809 },
	{ 28, 132741881 },
	{ 29, 175995641 },
	{ 29, 192510713 },
	{ 29, 242055929 },
	{ 29, 258636537 },
	{ 29, 241859321 },
	{ 29, 191527673 },
	{ 28, 124746493 },
	{ 28, 124418809 },
	{ 28, 107641593 },
	{ 28, 57309945 },
	{ 26, 24083197 },
	{ 26, 23755513 },
	{ 26, 6978297 },
	{ 26, 28343033 },
	{ 26, 27556601 },
	{ 27, 63470329 },
	{ 27, 59538169 },
	{ 27, 47741689 },
	{ 27, 43809529 },
	{ 27, 61373177 },
	{ 27, 53246713 },
	{ 27, 28867321 },
	{ 27, 20740857 },
	{ 26, 23624441 },
	{ 26, 7109369 },
	{ 21, 994666 },
	{ 21, 2092318 },
	{ 26, 24673021 },
	{ 27, 49463295 },
	{ 28, 66681849 },
	{ 28, 116227065 },
	{ 28, 132742137 },
	{ 29, 175995897 },
	{ 29, 192510969 },
	{ 29, 242056185 },
	{ 29, 258636793 },
	{ 29, 241859577 },
	{ 29, 191527929 },
	{ 28, 124746749 },
	{ 28, 124419065 },
	{ 28, 107641849 },
	{ 28, 57310201 },
	{ 26, 24083453 },
	{ 26, 23755769 },
	{ 26, 6978553 },
	{ 26, 28343289 },
	{ 26, 27556857 },
	{ 27, 63470585 },
	{ 27, 59538425 },
	{ 27, 47741945 },
	{ 27, 43809785 },
	{ 27, 61373433 },
	{ 27, 53246969 },
	{ 27, 28867577 },
	{ 27, 20741113 },
	{ 26, 23624697 },
	{ 26, 7109625 },
	{ 21, 1011050 },
	{ 21, 2075934 },
	{ 26, 24673277 },
	{ 27, 49463039 },
	{ 28, 66944761 },
	{ 28, 117014265 },
	{ 28, 133005049 },
	{ 29, 264142585 },
	{ 29, 255753977 },
	{ 29, 230588153 },
	{ 29, 222199545 },
	{ 28, 129924857 },
	{ 28, 121536249 },
	{ 28, 96370425 },
	{ 28, 87981817 },
	{ 27, 62815993 },
	{ 27, 54427385 },
	{ 27, 29261561 },
	{ 26, 23822077 },
	{ 25, 12484345 },
	{ 25, 4095737 },
	{ 26, 27295481 },
	{ 25, 16023289 },
	{ 26, 32160763 },
	{ 27, 46956281 },
	{ 27, 43548409 },
	{ 26, 31227641 },
	{ 27, 52985593 },
	{ 27, 28081913 },
	{ 27, 20479737 },
	{ 25, 12353273 },
	{ 26, 6848249 },
	{ 20, 514026 },
	{ 20, 1030046 },
	{ 26, 23887613 },
	{ 27, 47889407 },
	{ 28, 66945017 },
	{ 28, 117014521 },
	{ 28, 133005305 },
	{ 29, 264142841 },
	{ 29, 255754233 },
	{ 29, 230588409 },
	{ 29, 222199801 },
	{ 28, 129925113 },
	{ 28, 121536505 },
	{ 28, 96370681 },
	{ 28, 87982073 },
	{ 27, 62816249 },
	{ 27, 54427641 },
	{ 27, 29261817 },
	{ 26, 23822333 },
	{ 25, 12484601 },
	{ 25, 4095993 },
	{ 26, 27295737 },
	{ 25, 16023545 },
	{ 26, 32160507 },
	{ 27, 46956537 },
	{ 27, 43548665 },
	{ 26, 31227897 },
	{ 27, 52985849 },
	{ 27, 28082169 },
	{ 27, 20479993 },
	{ 25, 12353529 },
	{ 26, 6848505 },
	{ 20, 522218 },
	{ 20, 1021854 },
	{ 26, 23887869 },
	{ 27, 47889151 },
	{ 28, 57442301 },
	{ 28, 107773949 },
	{ 28, 124551165 },
	{ 29, 174882813 },
	{ 29, 191660029 },
	{ 29, 241991677 },
	{ 29, 258768893 },
	{ 29, 259959549 },
	{ 29, 259304185 },
	{ 29, 242526969 },
	{ 29, 192195321 },
	{ 28, 125741821 },
	{ 28, 125086457 },
	{ 28, 108309241 },
	{ 28, 57977593 },
	{ 26, 25078525 },
	{ 26, 24423161 },
	{ 26, 7645945 },
	{ 26, 31501049 },
	{ 26, 29928185 },
	{ 26, 30060539 },
	{ 28, 85502713 },
	{ 27, 61909753 },
	{ 27, 54045433 },
	{ 27, 54177787 },
	{ 28, 39365369 },
	{ 26, 24161017 },
	{ 26, 7908089 },
	{ 20, 956266 },
	{ 20, 980766 },
	{ 27, 47229693 },
	{ 27, 47362047 },
	{ 29, 114338557 },
	{ 29, 234531833 },
	{ 29, 267561977 },
	{ 29, 267431675 },
	{ 30, 527739897 },
	{ 30, 510962681 },
	{ 30, 460631033 },
	{ 29, 259959805 },
	{ 29, 259304441 },
	{ 29, 242527225 },
	{ 29, 192195577 },
	{ 28, 125742077 },
	{ 28, 125086713 },
	{ 28, 108309497 },
	{ 28, 57977849 },
	{ 26, 25078781 },
	{ 26, 24423417 },
	{ 26, 7646201 },
	{ 26, 31501305 },
	{ 26, 29928441 },
	{ 26, 30060283 },
	{ 28, 85502969 },
	{ 27, 61910009 },
	{ 27, 54045689 },
	{ 27, 54177531 },
	{ 28, 39365625 },
	{ 26, 24161273 },
	{ 26, 7908345 },
	{ 20, 964458 },
	{ 20, 972574 },
	{ 27, 47229949 },
	{ 27, 47361791 },
	{ 29, 114338813 },
	{ 29, 215002109 },
	{ 29, 268087033 },
	{ 29, 267955195 },
	{ 30, 979152633 },
	{ 30, 526167801 },
	{ 30, 509390585 },
	{ 30, 459058937 },
	{ 29, 259436285 },
	{ 29, 257732345 },
	{ 29, 240955129 },
	{ 29, 190623481 },
	{ 28, 125218557 },
	{ 28, 123514617 },
	{ 28, 106737401 },
	{ 28, 56405753 },
	{ 26, 24555261 },
	{ 26, 22851321 },
	{ 26, 6074105 },
	{ 26, 29404921 },
	{ 26, 23637753 },
	{ 26, 23768059 },
	{ 27, 60337913 },
	{ 27, 53522169 },
	{ 27, 28880633 },
	{ 27, 29010939 },
	{ 26, 22589177 },
	{ 26, 7384825 },
	{ 20, 972266 },
	{ 20, 963998 },
	{ 26, 24686333 },
	{ 26, 24816639 },
	{ 28, 58240765 },
	{ 28, 108572413 },
	{ 28, 125349629 },
	{ 28, 125479935 },
	{ 29, 192458493 },
	{ 29, 242790141 },
	{ 29, 259567357 },
	{ 29, 259697663 },
	{ 29, 259436541 },
	{ 29, 257732601 },
	{ 29, 240955385 },
	{ 29, 190623737 },
	{ 28, 125218813 },
	{ 28, 123514873 },
	{ 28, 106737657 },
	{ 28, 56406009 },
	{ 26, 24555517 },
	{ 26, 22851577 },
	{ 26, 6074361 },
	{ 26, 29405177 },
	{ 26, 23638009 },
	{ 26, 23767803 },
	{ 27, 60338169 },
	{ 27, 53522425 },
	{ 27, 28880889 },
	{ 27, 29010683 },
	{ 26, 22589433 },
	{ 26, 7385081 },
	{ 20, 980458 },
	{ 20, 955806 },
	{ 26, 24686589 },
	{ 26, 24816383 },
	{ 28, 58241021 },
	{ 28, 108572669 },
	{ 28, 125349885 },
	{ 28, 125479679 },
	{ 29, 192458749 },
	{ 29, 242790397 },
	{ 29, 259567613 },
	{ 29, 266895355 },
	{ 29, 175865851 },
	{ 29, 257866493 },
	{ 28, 96370687 },
	{ 28, 88047611 },
	{ 28, 87785467 },
	{ 28, 123648765 },
	{ 27, 48136191 },
	{ 27, 44007419 },
	{ 27, 43745275 },
	{ 26, 22985469 },
	{ 25, 11960319 },
	{ 25, 10977275 },
	{ 25, 10715131 },
	{ 25, 11632635 },
	{ 25, 10846203 },
	{ 26, 29982715 },
	{ 26, 26050555 },
	{ 26, 14254075 },
	{ 26, 22067961 },
	{ 25, 11108347 },
	{ 20, 1021290 },
	{ 20, 521502 },
	{ 25, 3768319 },
	{ 25, 12156927 },
	{ 27, 20545535 },
	{ 27, 28934143 },
	{ 27, 54099967 },
	{ 27, 62488575 },
	{ 28, 87654399 },
	{ 28, 96043007 },
	{ 28, 121208831 },
	{ 28, 129597439 },
	{ 29, 175865595 },
	{ 29, 257866749 },
	{ 28, 96370431 },
	{ 28, 88047355 },
	{ 28, 87785211 },
	{ 28, 123649021 },
	{ 27, 48135935 },
	{ 27, 44007163 },
	{ 27, 43745019 },
	{ 26, 22985725 },
	{ 25, 11960063 },
	{ 25, 10977019 },
	{ 25, 10714875 },
	{ 25, 11632379 },
	{ 25, 10845947 },
	{ 26, 29982459 },
	{ 26, 26050299 },
	{ 26, 14253819 },
	{ 26, 22068217 },
	{ 25, 11108091 },
	{ 20, 1029482 },
	{ 20, 513310 },
	{ 25, 3768063 },
	{ 25, 12156671 },
	{ 27, 20545279 },
	{ 27, 28933887 },
	{ 27, 54099711 },
	{ 27, 62488319 },
	{ 28, 134183931 },
	{ 28, 133921787 },
	{ 28, 133135355 },
	{ 28, 132873211 },
	{ 28, 125795323 },
	{ 28, 125533179 },
	{ 28, 124746747 },
	{ 28, 129810169 },
	{ 27, 62880763 },
	{ 27, 62618619 },
	{ 27, 61832187 },
	{ 27, 62701305 },
	{ 26, 31423483 },
	{ 26, 31161339 },
	{ 26, 22462205 },
	{ 25, 12369657 },
	{ 24, 7830523 },
	{ 24, 7568379 },
	{ 25, 15253241 },
	{ 24, 7699451 },
	{ 26, 25787387 },
	{ 26, 13466619 },
	{ 25, 12107513 },
	{ 24, 6126587 },
	{ 19, 519146 },
	{ 19, 252830 },
	{ 25, 2980863 },
	{ 25, 11369471 },
	{ 27, 19758079 },
	{ 27, 28146687 },
	{ 27, 53312511 },
	{ 27, 61701119 },
	{ 28, 134183675 },
	{ 28, 133921531 },
	{ 28, 133135099 },
	{ 28, 132872955 },
	{ 28, 125795067 },
	{ 28, 125532923 },
	{ 28, 124746491 },
	{ 28, 129810425 },
	{ 27, 62880507 },
	{ 27, 62618363 },
	{ 27, 61831931 },
	{ 27, 62701561 },
	{ 26, 31423227 },
	{ 26, 31161083 },
	{ 26, 22462461 },
	{ 25, 12369913 },
	{ 24, 7830267 },
	{ 24, 7568123 },
	{ 25, 15253497 },
	{ 24, 7699195 },
	{ 26, 25787131 },
	{ 26, 13466363 },
	{ 25, 12107769 },
	{ 24, 6126331 },
	{ 19, 523242 },
	{ 19, 248734 },
	{ 25, 2980607 },
	{ 25, 11369215 },
	{ 27, 19757823 },
	{ 27, 28146431 },
	{ 27, 53312255 },
	{ 27, 61700863 },
	{ 28, 86866687 },
	{ 28, 117403643 },
	{ 28, 117141499 },
	{ 28, 116355067 },
	{ 28, 116092923 },
	{ 28, 109015035 },
	{ 28, 108752891 },
	{ 28, 129952509 },
	{ 27, 62812159 },
	{ 27, 54489083 },
	{ 27, 54226939 },
	{ 27, 62843645 },
	{ 26, 31354879 },
	{ 26, 27226107 },
	{ 26, 26963963 },
	{ 25, 12511997 },
	{ 24, 7761919 },
	{ 24, 6778875 },
	{ 24, 6516731 },
	{ 24, 7434235 },
	{ 24, 6647803 },
	{ 26, 13201403 },
	{ 25, 11594489 },
	{ 24, 5861371 },
	{ 24, 1929211 },
	{ 19, 228126 },
	{ 25, 2715647 },
	{ 25, 11104255 },
	{ 27, 19492863 },
	{ 27, 27881471 },
	{ 27, 53047295 },
	{ 27, 61435903 },
	{ 28, 134115071 },
	{ 28, 117403387 },
	{ 28, 117141243 },
	{ 28, 116354811 },
	{ 28, 116092667 },
	{ 28, 109014779 },
	{ 28, 108752635 },
	{ 28, 129952765 },
	{ 27, 62811903 },
	{ 27, 54488827 },
	{ 27, 54226683 },
	{ 27, 62843901 },
	{ 26, 31354623 },
	{ 26, 27225851 },
	{ 26, 26963707 },
	{ 25, 12512253 },
	{ 24, 7761663 },
	{ 24, 6778619 },
	{ 24, 6516475 },
	{ 24, 7433979 },
	{ 24, 6647547 },
	{ 26, 13201147 },
	{ 25, 11594745 },
	{ 24, 5861115 },
	{ 24, 1928955 },
	{ 19, 224030 },
	{ 25, 2715391 },
	{ 25, 11103999 },
	{ 27, 19492607 },
	{ 27, 27881215 },
	{ 27, 53047039 },
	{ 27, 61435647 },
	{ 28, 86601471 },
	{ 28, 94990079 },
	{ 28, 67070971 },
	{ 28, 66808827 },
	{ 28, 66022395 },
	{ 28, 65760251 },
	{ 28, 58682363 },
	{ 28, 58420219 },
	{ 28, 129429245 },
	{ 27, 54422527 },
	{ 27, 29322235 },
	{ 27, 29060091 },
	{ 27, 62320381 },
	{ 26, 27159551 },
	{ 26, 14642171 },
	{ 26, 14380027 },
	{ 25, 11988733 },
	{ 24, 6712319 },
	{ 24, 3632123 },
	{ 24, 3369979 },
	{ 24, 6384635 },
	{ 24, 3501051 },
	{ 25, 10022649 },
	{ 24, 5073915 },
	{ 24, 1666043 },
	{ 19, 219550 },
	{ 24, 1928191 },
	{ 24, 6122495 },
	{ 26, 10316799 },
	{ 26, 14511103 },
	{ 26, 27094015 },
	{ 26, 31288319 },
	{ 27, 43871231 },
	{ 27, 48065535 },
	{ 27, 60648447 },
	{ 27, 64842751 },
	{ 28, 66022139 },
	{ 28, 65759995 },
	{ 28, 58682107 },
	{ 28, 58419963 },
	{ 28, 129429501 },
	{ 27, 54422271 },
	{ 27, 29321979 },
	{ 27, 29059835 },
	{ 27, 62320637 },
	{ 26, 27159295 },
	{ 26, 14641915 },
	{ 26, 14379771 },
	{ 25, 11988989 },
	{ 24, 6712063 },
	{ 24, 3631867 },
	{ 24, 3369723 },
	{ 24, 6384379 },
	{ 24, 3500795 },
	{ 25, 10022905 },
	{ 24, 5073659 },
	{ 24, 1665787 },
	{ 19, 215454 },
	{ 24, 1927935 },
	{ 24, 6122239 },
	{ 26, 10316543 },
	{ 26, 14510847 },
	{ 26, 27093759 },
	{ 26, 31288063 },
	{ 27, 43870975 },
	{ 27, 48065279 },
	{ 27, 60648191 },
	{ 27, 64842495 },
	{ 28, 50020347 },
	{ 28, 49233915 },
	{ 28, 48971771 },
	{ 28, 41893883 },
	{ 28, 41631739 },
	{ 28, 127859453 },
	{ 27, 29245439 },
	{ 27, 20922363 },
	{ 27, 20660219 },
	{ 27, 60750589 },
	{ 26, 14565375 },
	{ 26, 10436603 },
	{ 26, 10174459 },
	{ 25, 10418941 },
	{ 24, 3555327 },
	{ 24, 2572283 },
	{ 24, 2310139 },
	{ 24, 3227643 },
	{ 24, 2441211 },
	{ 24, 4800507 },
	{ 24, 868347 },
	{ 18, 129310 },
	{ 24, 1654783 },
	{ 24, 5849087 },
	{ 26, 10043391 },
	{ 26, 14237695 },
	{ 26, 26820607 },
	{ 26, 31014911 },
	{ 27, 43597823 },
	{ 27, 47792127 },
	{ 27, 60375039 },
	{ 27, 64569343 },
	{ 28, 50020091 },
	{ 28, 49233659 },
	{ 28, 48971515 },
	{ 28, 41893627 },
	{ 28, 41631483 },
	{ 28, 127859709 },
	{ 27, 29245183 },
	{ 27, 20922107 },
	{ 27, 20659963 },
	{ 27, 60750845 },
	{ 26, 14565119 },
	{ 26, 10436347 },
	{ 26, 10174203 },
	{ 25, 10419197 },
	{ 24, 3555071 },
	{ 24, 2572027 },
	{ 24, 2309883 },
	{ 24, 3227387 },
	{ 24, 2440955 },
	{ 24, 4800251 },
	{ 24, 868091 },
	{ 18, 125214 },
	{ 24, 1654527 },
	{ 24, 5848831 },
	{ 26, 10043135 },
	{ 26, 14237439 },
	{ 26, 26820351 },
	{ 26, 31014655 },
	{ 27, 43597567 },
	{ 27, 47791871 },
	{ 27, 60374783 },
	{ 27, 132972281 },
	{ 26, 33504251 },
	{ 26, 33242107 },
	{ 26, 32455675 },
	{ 26, 32193531 },
	{ 26, 25115643 },
	{ 26, 24853499 },
	{ 26, 24067067 },
	{ 26, 32308985 },
	{ 25, 12532731 },
	{ 25, 12270587 },
	{ 25, 11484155 },
	{ 25, 15531769 },
	{ 24, 6241275 },
	{ 24, 5979131 },
	{ 24, 5192699 },
	{ 23, 2948857 },
	{ 22, 1522683 },
	{ 22, 1260539 },
	{ 23, 2686713 },
	{ 22, 1391611 },
	{ 24, 605179 },
	{ 16, 30366 },
	{ 24, 867327 },
	{ 24, 5061631 },
	{ 26, 9255935 },
	{ 26, 13450239 },
	{ 26, 26033151 },
	{ 26, 30227455 },
	{ 27, 42810367 },
	{ 27, 47004671 },
	{ 27, 59587583 },
	{ 27, 132972537 },
	{ 26, 33503995 },
	{ 26, 33241851 },
	{ 26, 32455419 },
	{ 26, 32193275 },
	{ 26, 25115387 },
	{ 26, 24853243 },
	{ 26, 24066811 },
	{ 26, 32309241 },
	{ 25, 12532475 },
	{ 25, 12270331 },
	{ 25, 11483899 },
	{ 25, 15532025 },
	{ 24, 6241019 },
	{ 24, 5978875 },
	{ 24, 5192443 },
	{ 23, 2949113 },
	{ 22, 1522427 },
	{ 22, 1260283 },
	{ 23, 2686969 },
	{ 22, 1391355 },
	{ 24, 604923 },
	{ 16, 29342 },
	{ 24, 867071 },
	{ 24, 5061375 },
	{ 26, 9255679 },
	{ 26, 13449983 },
	{ 26, 26032895 },
	{ 26, 30227199 },
	{ 27, 42810111 },
	{ 27, 47004415 },
	{ 27, 59587327 },
	{ 27, 63781631 },
	{ 26, 33435647 },
	{ 26, 16723963 },
	{ 26, 16461819 },
	{ 26, 15675387 },
	{ 26, 15413243 },
	{ 26, 8335355 },
	{ 26, 8073211 },
	{ 26, 7286779 },
	{ 25, 12464127 },
	{ 25, 4141051 },
	{ 25, 3878907 },
	{ 25, 3092475 },
	{ 24, 6172671 },
	{ 24, 2043899 },
	{ 24, 1781755 },
	{ 24, 6138621 },
	{ 22, 1454079 },
	{ 22, 471035 },
	{ 22, 208891 },
	{ 17, 49019 },
	{ 19, 262075 },
	{ 16, 24094 },
	{ 24, 602111 },
	{ 24, 4796415 },
	{ 26, 8990719 },
	{ 26, 13185023 },
	{ 26, 25767935 },
	{ 26, 29962239 },
	{ 27, 42545151 },
	{ 27, 46739455 },
	{ 27, 59322367 },
	{ 27, 63516671 },
	{ 26, 33435391 },
	{ 26, 16723707 },
	{ 26, 16461563 },
	{ 26, 15675131 },
	{ 26, 15412987 },
	{ 26, 8335099 },
	{ 26, 8072955 },
	{ 26, 7286523 },
	{ 25, 12463871 },
	{ 25, 4140795 },
	{ 25, 3878651 },
	{ 25, 3092219 },
	{ 24, 6172415 },
	{ 24, 2043643 },
	{ 24, 1781499 },
	{ 24, 6138877 },
	{ 22, 1453823 },
	{ 22, 470779 },
	{ 22, 208635 },
	{ 17, 46971 },
	{ 18, 130683 },
	{ 16, 23070 },
	{ 24, 601855 },
	{ 24, 4796159 },
	{ 26, 8990463 },
	{ 26, 13184767 },
	{ 26, 25767679 },
	{ 26, 29961983 },
	{ 27, 42544895 },
	{ 27, 46739199 },
	{ 27, 59322111 },
	{ 27, 63516415 },
	{ 28, 265137917 },
	{ 26, 16657407 },
	{ 26, 16395263 },
	{ 26, 15608831 },
	{ 26, 15346687 },
	{ 26, 8268799 },
	{ 26, 8006655 },
	{ 26, 7220223 },
	{ 26, 6958079 },
	{ 25, 4074495 },
	{ 25, 3812351 },
	{ 25, 3025919 },
	{ 25, 2763775 },
	{ 24, 1977343 },
	{ 24, 1715199 },
	{ 24, 928767 },
	{ 24, 5091069 },
	{ 22, 404479 },
	{ 22, 142335 },
	{ 16, 32575 },
	{ 16, 32619 },
	{ 16, 32574 },
	{ 18, 131007 },
	{ 22, 1387519 },
	{ 24, 2436095 },
	{ 24, 3484671 },
	{ 24, 6630399 },
	{ 24, 7678975 },
	{ 25, 10824703 },
	{ 25, 11873279 },
	{ 25, 15019007 },
	{ 25, 16067583 },
	{ 26, 27601919 },
	{ 26, 16657151 },
	{ 26, 16395007 },
	{ 26, 15608575 },
	{ 26, 15346431 },
	{ 26, 8268543 },
	{ 26, 8006399 },
	{ 26, 7219967 },
	{ 26, 6957823 },
	{ 25, 4074239 },
	{ 25, 3812095 },
	{ 25, 3025663 },
	{ 25, 2763519 },
	{ 24, 1977087 },
	{ 24, 1714943 },
	{ 24, 928511 },
	{ 24, 5091325 },
	{ 22, 404223 },
	{ 22, 142079 },
	{ 16, 32751 },
	{ 13, 4059 },
	{ 12, 1742 },
	{ 17, 65151 },
	{ 22, 1387263 },
	{ 24, 2435839 },
	{ 24, 3484415 },
	{ 24, 6630143 },
	{ 24, 7678719 },
	{ 25, 10824447 },
	{ 25, 11873023 },
	{ 25, 15018751 },
	{ 25, 16067327 },
	{ 26, 27601663 },
	{ 26, 28650239 },
	{ 26, 31795967 },
	{ 24, 16523263 },
	{ 24, 16261119 },
	{ 24, 15474687 },
	{ 24, 15212543 },
	{ 24, 8134655 },
	{ 24, 7872511 },
	{ 24, 7086079 },
	{ 24, 6823935 },
	{ 23, 3940351 },
	{ 23, 3678207 },
	{ 23, 2891775 },
	{ 23, 2629631 },
	{ 22, 1843199 },
	{ 22, 1581055 },
	{ 22, 794623 },
	{ 22, 532479 },
	{ 16, 32127 },
	{ 12, 1999 },
	{ 12, 1678 },
	{ 15, 16239 },
	{ 16, 32639 },
	{ 22, 548863 },
	{ 22, 811007 },
	{ 22, 1597439 },
	{ 22, 1859583 },
	{ 23, 2646015 },
	{ 23, 2908159 },
	{ 23, 3694591 },
	{ 23, 3956735 },
	{ 24, 6840319 },
	{ 24, 7102463 },
	{ 24, 7888895 },
	{ 24, 16523007 },
	{ 24, 16260863 },
	{ 24, 15474431 },
	{ 24, 15212287 },
	{ 24, 8134399 },
	{ 24, 7872255 },
	{ 24, 7085823 },
	{ 24, 6823679 },
	{ 23, 3940095 },
	{ 23, 3677951 },
	{ 23, 2891519 },
	{ 23, 2629375 },
	{ 22, 1842943 },
	{ 22, 1580799 },
	{ 22, 794367 },
	{ 22, 532223 },
	{ 16, 30079 },
	{ 13, 4015 },
	{ 24, 113661 },
	{ 12, 2015 },
	{ 16, 30591 },
	{ 22, 548607 },
	{ 22, 810751 },
	{ 22, 1597183 },
	{ 22, 1859327 },
	{ 23, 2645759 },
	{ 23, 2907903 },
	{ 23, 3694335 },
	{ 23, 3956479 },
	{ 24, 6840063 },
	{ 24, 7102207 },
	{ 24, 7888639 },
	{ 24, 8150783 },
	{ 24, 15228671 },
	{ 24, 15490815 },
	{ 24, 16277247 },
	{ 24, 16539391 },
	{ 24, 7937023 },
	{ 24, 7150591 },
	{ 24, 6888447 },
	{ 23, 4004863 },
	{ 23, 3742719 },
	{ 23, 2956287 },
	{ 23, 2694143 },
	{ 22, 1907711 },
	{ 22, 1645567 },
	{ 22, 859135 },
	{ 22, 596991 },
	{ 20, 334847 },
	{ 15, 16063 },
	{ 13, 4062 },
	{ 11, 971 },
	{ 14, 7995 },
	{ 20, 56319 },
	{ 20, 318463 },
	{ 22, 580607 },
	{ 22, 842751 },
	{ 22, 1629183 },
	{ 22, 1891327 },
	{ 23, 2677759 },
	{ 23, 2939903 },
	{ 23, 3726335 },
	{ 23, 3988479 },
	{ 24, 6872063 },
	{ 24, 16587519 },
	{ 24, 16325375 },
	{ 24, 15538943 },
	{ 24, 15276799 },
	{ 24, 8198911 },
	{ 24, 7936767 },
	{ 24, 7150335 },
	{ 24, 6888191 },
	{ 23, 4004607 },
	{ 23, 3742463 },
	{ 23, 2956031 },
	{ 23, 2693887 },
	{ 22, 1907455 },
	{ 22, 1645311 },
	{ 22, 858879 },
	{ 22, 596735 },
	{ 20, 334591 },
	{ 16, 32191 },
	{ 13, 3934 },
	{ 12, 1963 },
	{ 14, 8171 },
	{ 20, 56063 },
	{ 20, 318207 },
	{ 22, 580351 },
	{ 22, 842495 },
	{ 22, 1628927 },
	{ 22, 1891071 },
	{ 23, 2677503 },
	{ 23, 2939647 },
	{ 23, 3726079 },
	{ 23, 3988223 },
	{ 24, 6871807 },
	{ 24, 7133951 },
	{ 24, 7920383 },
	{ 24, 8182527 },
	{ 24, 15260415 },
	{ 24, 15522559 },
	{ 24, 16308991 },
	{ 24, 16571135 },
	{ 26, 27398143 },
	{ 25, 15863807 },
	{ 25, 14815231 },
	{ 25, 11669503 },
	{ 25, 10620927 },
	{ 24, 7475199 },
	{ 24, 6426623 },
	{ 24, 3280895 },
	{ 24, 2232319 },
	{ 22, 1183743 },
	{ 22, 135167 },
	{ 15, 7790 },
	{ 14, 7867 },
	{ 16, 15739 },
	{ 20, 36859 },
	{ 20, 299003 },
	{ 20, 380927 },
	{ 22, 823291 },
	{ 22, 1609723 },
	{ 22, 1871867 },
	{ 22, 1953791 },
	{ 23, 2920443 },
	{ 23, 3706875 },
	{ 23, 3969019 },
	{ 23, 4050943 },
	{ 24, 7114747 },
	{ 24, 7901179 },
	{ 24, 8163323 },
	{ 24, 15241211 },
	{ 24, 15503355 },
	{ 24, 16289787 },
	{ 24, 16551931 },
	{ 24, 16633855 },
	{ 25, 15863551 },
	{ 25, 14814975 },
	{ 25, 11669247 },
	{ 25, 10620671 },
	{ 24, 7474943 },
	{ 24, 6426367 },
	{ 24, 3280639 },
	{ 24, 2232063 },
	{ 22, 1183487 },
	{ 22, 134911 },
	{ 15, 6766 },
	{ 15, 15803 },
	{ 16, 13691 },
	{ 20, 36603 },
	{ 20, 298747 },
	{ 20, 380671 },
	{ 22, 823035 },
	{ 22, 1609467 },
	{ 22, 1871611 },
	{ 22, 1953535 },
	{ 23, 2920187 },
	{ 23, 3706619 },
	{ 23, 3968763 },
	{ 23, 4050687 },
	{ 24, 7114491 },
	{ 24, 7900923 },
	{ 24, 8163067 },
	{ 24, 15240955 },
	{ 24, 15503099 },
	{ 24, 16289531 },
	{ 24, 16551675 },
	{ 24, 16633599 },
	{ 25, 15928319 },
	{ 25, 14879743 },
	{ 25, 11734015 },
	{ 25, 10685439 },
	{ 24, 7539711 },
	{ 24, 6491135 },
	{ 24, 3345407 },
	{ 24, 2296831 },
	{ 22, 1248255 },
	{ 22, 199679 },
	{ 15, 5870 },
	{ 22, 134139 },
	{ 20, 330747 },
	{ 22, 527355 },
	{ 20, 101371 },
	{ 20, 363515 },
	{ 22, 625659 },
	{ 22, 887803 },
	{ 22, 1674235 },
	{ 22, 1936379 },
	{ 23, 2722811 },
	{ 23, 2984955 },
	{ 23, 3771387 },
	{ 23, 4033531 },
	{ 24, 6917115 },
	{ 24, 7179259 },
	{ 24, 7965691 },
	{ 24, 8227835 },
	{ 24, 15305723 },
	{ 24, 15567867 },
	{ 24, 16354299 },
	{ 24, 16616443 },
	{ 25, 15928063 },
	{ 25, 14879487 },
	{ 25, 11733759 },
	{ 25, 10685183 },
	{ 24, 7539455 },
	{ 24, 6490879 },
	{ 24, 3345151 },
	{ 24, 2296575 },
	{ 22, 1247999 },
	{ 22, 199423 },
	{ 15, 4846 },
	{ 22, 133883 },
	{ 20, 330491 },
	{ 22, 527099 },
	{ 20, 101115 },
	{ 20, 363259 },
	{ 22, 625403 },
	{ 22, 887547 },
	{ 22, 1673979 },
	{ 22, 1936123 },
	{ 23, 2722555 },
	{ 23, 2984699 },
	{ 23, 3771131 },
	{ 23, 4033275 },
	{ 24, 6916859 },
	{ 24, 7179003 },
	{ 24, 7965435 },
	{ 24, 8227579 },
	{ 24, 15305467 },
	{ 24, 15567611 },
	{ 24, 16354043 },
	{ 24, 16616187 },
	{ 23, 4032511 },
	{ 23, 3770367 },
	{ 23, 2983935 },
	{ 23, 2721791 },
	{ 22, 1935359 },
	{ 22, 1673215 },
	{ 22, 886783 },
	{ 22, 624639 },
	{ 20, 362495 },
	{ 20, 100351 },
	{ 15, 14702 },
	{ 20, 51195 },
	{ 20, 296955 },
	{ 20, 149499 },
	{ 20, 198651 },
	{ 20, 43003 },
	{ 20, 305147 },
	{ 20, 325631 },
	{ 22, 829435 },
	{ 22, 1615867 },
	{ 22, 1878011 },
	{ 22, 1898495 },
	{ 23, 2926587 },
	{ 23, 3713019 },
	{ 23, 3975163 },
	{ 23, 3995647 },
	{ 24, 7120891 },
	{ 24, 7907323 },
	{ 24, 8169467 },
	{ 24, 15247355 },
	{ 24, 15509499 },
	{ 24, 16295931 },
	{ 23, 4032255 },
	{ 23, 3770111 },
	{ 23, 2983679 },
	{ 23, 2721535 },
	{ 22, 1935103 },
	{ 22, 1672959 },
	{ 22, 886527 },
	{ 22, 624383 },
	{ 20, 362239 },
	{ 20, 100095 },
	{ 15, 10606 },
	{ 20, 50939 },
	{ 20, 296699 },
	{ 20, 149243 },
	{ 20, 198395 },
	{ 20, 42747 },
	{ 20, 304891 },
	{ 20, 325375 },
	{ 22, 829179 },
	{ 22, 1615611 },
	{ 22, 1877755 },
	{ 22, 1898239 },
	{ 23, 2926331 },
	{ 23, 3712763 },
	{ 23, 3974907 },
	{ 23, 3995391 },
	{ 24, 7120635 },
	{ 24, 7907067 },
	{ 24, 8169211 },
	{ 24, 15247099 },
	{ 24, 15509243 },
	{ 24, 16295675 },
	{ 23, 4047871 },
	{ 23, 3785727 },
	{ 23, 2999295 },
	{ 23, 2737151 },
	{ 22, 1950719 },
	{ 22, 1688575 },
	{ 22, 902143 },
	{ 22, 639999 },
	{ 20, 377855 },
	{ 20, 115711 },
	{ 15, 6638 },
	{ 20, 99323 },
	{ 20, 312315 },
	{ 22, 558075 },
	{ 20, 214011 },
	{ 20, 394235 },
	{ 20, 58363 },
	{ 20, 320507 },
	{ 20, 373759 },
	{ 22, 844795 },
	{ 22, 1631227 },
	{ 22, 1893371 },
	{ 22, 1946623 },
	{ 23, 2941947 },
	{ 23, 3728379 },
	{ 23, 3990523 },
	{ 23, 4043775 },
	{ 24, 7136251 },
	{ 24, 7922683 },
	{ 24, 8184827 },
	{ 24, 15262715 },
	{ 24, 15524859 },
	{ 23, 4047615 },
	{ 23, 3785471 },
	{ 23, 2999039 },
	{ 23, 2736895 },
	{ 22, 1950463 },
	{ 22, 1688319 },
	{ 22, 901887 },
	{ 22, 639743 },
	{ 20, 377599 },
	{ 20, 115455 },
	{ 15, 2542 },
	{ 20, 99067 },
	{ 20, 312059 },
	{ 22, 557819 },
	{ 20, 213755 },
	{ 20, 393979 },
	{ 20, 58107 },
	{ 20, 320251 },
	{ 20, 373503 },
	{ 22, 844539 },
	{ 22, 1630971 },
	{ 22, 1893115 },
	{ 22, 1946367 },
	{ 23, 2941691 },
	{ 23, 3728123 },
	{ 23, 3990267 },
	{ 23, 4043519 },
	{ 23, 7643647 },
	{ 23, 4104703 },
	{ 23, 3973631 },
	{ 23, 3580415 },
	{ 23, 3449343 },
	{ 22, 2007551 },
	{ 22, 1876479 },
	{ 22, 1483263 },
	{ 22, 1352191 },
	{ 21, 958975 },
	{ 21, 827903 },
	{ 21, 434687 },
	{ 21, 303615 },
	{ 19, 172543 },
	{ 19, 41471 },
	{ 13, 4974 },
	{ 18, 29179 },
	{ 18, 90619 },
	{ 20, 143867 },
	{ 20, 205307 },
	{ 18, 102907 },
	{ 18, 115195 },
	{ 18, 27131 },
	{ 18, 92667 },
	{ 18, 97791 },
	{ 20, 223739 },
	{ 20, 420347 },
	{ 20, 485883 },
	{ 20, 491007 },
	{ 21, 748027 },
	{ 21, 944635 },
	{ 21, 1010171 },
	{ 21, 1015295 },
	{ 22, 1796603 },
	{ 22, 1993211 },
	{ 22, 2058747 },
	{ 22, 3828219 },
	{ 22, 2008317 },
	{ 22, 1877245 },
	{ 22, 1484029 },
	{ 22, 1352957 },
	{ 21, 959741 },
	{ 21, 828669 },
	{ 21, 435453 },
	{ 21, 304381 },
	{ 19, 173309 },
	{ 19, 42237 },
	{ 13, 794 },
	{ 18, 29945 },
	{ 18, 91385 },
	{ 20, 144633 },
	{ 20, 206073 },
	{ 18, 103673 },
	{ 18, 115961 },
	{ 18, 101625 },
	{ 18, 105721 },
	{ 18, 121085 },
	{ 20, 408825 },
	{ 20, 421113 },
	{ 20, 425209 },
	{ 20, 489725 },
	{ 21, 834809 },
	{ 21, 847097 },
	{ 21, 851193 },
	{ 21, 981245 },
	{ 22, 1686777 },
	{ 22, 1699065 },
	{ 22, 1703161 },
	{ 22, 1813753 },
	{ 22, 1817849 },
	{ 22, 1830137 },
	{ 22, 1834233 },
	{ 22, 2095357 },
	{ 21, 959997 },
	{ 21, 828925 },
	{ 21, 435709 },
	{ 21, 304637 },
	{ 19, 173565 },
	{ 19, 42493 },
	{ 13, 4890 },
	{ 18, 30201 },
	{ 18, 91641 },
	{ 20, 144889 },
	{ 20, 206329 },
	{ 18, 103929 },
	{ 18, 116217 },
	{ 18, 101881 },
	{ 18, 105977 },
	{ 18, 121341 },
	{ 20, 409081 },
	{ 20, 421369 },
	{ 20, 425465 },
	{ 20, 489981 },
	{ 21, 835065 },
	{ 21, 847353 },
	{ 21, 851449 },
	{ 21, 981501 },
	{ 22, 1687033 },
	{ 22, 1699321 },
	{ 22, 1703417 },
	{ 22, 1814009 },
	{ 22, 1818105 },
	{ 22, 1830393 },
	{ 22, 1834489 },
	{ 22, 2095613 },
	{ 23, 3855101 },
	{ 23, 3330813 },
	{ 23, 1757949 },
	{ 23, 1233661 },
	{ 21, 709373 },
	{ 21, 185085 },
	{ 15, 2970 },
	{ 21, 168697 },
	{ 20, 381689 },
	{ 22, 627449 },
	{ 22, 840441 },
	{ 22, 1610489 },
	{ 20, 479993 },
	{ 21, 660217 },
	{ 20, 471801 },
	{ 20, 488185 },
	{ 21, 680701 },
	{ 22, 1897209 },
	{ 22, 1946361 },
	{ 22, 1962745 },
	{ 23, 3846905 },
	{ 23, 3863289 },
	{ 23, 3912441 },
	{ 23, 3928825 },
	{ 24, 7779065 },
	{ 24, 7795449 },
	{ 24, 7844601 },
	{ 24, 7860985 },
	{ 24, 8303353 },
	{ 24, 8319737 },
	{ 24, 8368889 },
	{ 24, 8385273 },
	{ 23, 3855357 },
	{ 23, 3331069 },
	{ 23, 1758205 },
	{ 23, 1233917 },
	{ 21, 709629 },
	{ 21, 185341 },
	{ 15, 7066 },
	{ 21, 168953 },
	{ 20, 381945 },
	{ 22, 627705 },
	{ 22, 840697 },
	{ 22, 1610745 },
	{ 20, 480249 },
	{ 21, 660473 },
	{ 20, 472057 },
	{ 20, 488441 },
	{ 21, 680957 },
	{ 22, 1897465 },
	{ 22, 1946617 },
	{ 22, 1963001 },
	{ 23, 3847161 },
	{ 23, 3863545 },
	{ 23, 3912697 },
	{ 23, 3929081 },
	{ 24, 7779321 },
	{ 24, 7795705 },
	{ 24, 7844857 },
	{ 24, 7861241 },
	{ 24, 8303609 },
	{ 24, 8319993 },
	{ 24, 8369145 },
	{ 24, 8385529 },
	{ 23, 3905277 },
	{ 23, 3380989 },
	{ 23, 1808125 },
	{ 23, 1283837 },
	{ 21, 759549 },
	{ 21, 235261 },
	{ 16, 21786 },
	{ 21, 186105 },
	{ 21, 694009 },
	{ 22, 644857 },
	{ 22, 890617 },
	{ 22, 1627897 },
	{ 22, 1873657 },
	{ 21, 677625 },
	{ 21, 726777 },
	{ 21, 669433 },
	{ 21, 685817 },
	{ 21, 747261 },
	{ 23, 2684665 },
	{ 23, 2733817 },
	{ 23, 2750201 },
	{ 23, 3008253 },
	{ 24, 5437177 },
	{ 24, 5486329 },
	{ 24, 5502713 },
	{ 24, 6022909 },
	{ 25, 10942201 },
	{ 25, 10991353 },
	{ 24, 8099837 },
	{ 24, 7575549 },
	{ 24, 6002685 },
	{ 24, 5478397 },
	{ 23, 3905533 },
	{ 23, 3381245 },
	{ 23, 1808381 },
	{ 23, 1284093 },
	{ 21, 759805 },
	{ 21, 235517 },
	{ 16, 29978 },
	{ 21, 186361 },
	{ 21, 694265 },
	{ 22, 645113 },
	{ 22, 890873 },
	{ 22, 1628153 },
	{ 22, 1873913 },
	{ 21, 677881 },
	{ 21, 727033 },
	{ 21, 669689 },
	{ 21, 686073 },
	{ 21, 747517 },
	{ 23, 2684921 },
	{ 23, 2734073 },
	{ 23, 2750457 },
	{ 23, 3008509 },
	{ 24, 5437433 },
	{ 24, 5486585 },
	{ 24, 5502969 },
	{ 24, 6023165 },
	{ 25, 10942457 },
	{ 25, 10991609 },
	{ 25, 16680953 },
	{ 25, 15648761 },
	{ 25, 12552185 },
	{ 25, 11519993 },
	{ 25, 11532281 },
	{ 25, 13585149 },
	{ 25, 7293693 },
	{ 25, 5196541 },
	{ 23, 3099389 },
	{ 23, 1002237 },
	{ 18, 38298 },
	{ 23, 936697 },
	{ 23, 2837241 },
	{ 25, 4868857 },
	{ 24, 3623673 },
	{ 24, 6703865 },
	{ 24, 7555833 },
	{ 25, 10636025 },
	{ 23, 2968313 },
	{ 23, 3689209 },
	{ 23, 2935545 },
	{ 23, 3001081 },
	{ 23, 3771133 },
	{ 25, 11782905 },
	{ 25, 11979513 },
	{ 25, 12045049 },
	{ 25, 15174397 },
	{ 26, 23841529 },
	{ 26, 24038137 },
	{ 26, 24103673 },
	{ 26, 30378749 },
	{ 27, 47958777 },
	{ 26, 32459773 },
	{ 26, 30362621 },
	{ 26, 24071165 },
	{ 26, 21974013 },
	{ 25, 15682557 },
	{ 25, 13585405 },
	{ 25, 7293949 },
	{ 25, 5196797 },
	{ 23, 3099645 },
	{ 23, 1002493 },
	{ 18, 46490 },
	{ 23, 936953 },
	{ 23, 2837497 },
	{ 25, 4869113 },
	{ 24, 3623929 },
	{ 24, 6704121 },
	{ 24, 7556089 },
	{ 25, 10636281 },
	{ 23, 2968569 },
	{ 23, 3689465 },
	{ 23, 2935801 },
	{ 23, 3001337 },
	{ 23, 3771389 },
	{ 25, 11783161 },
	{ 25, 11979769 },
	{ 25, 12045305 },
	{ 25, 15174653 },
	{ 26, 23841785 },
	{ 26, 24038393 },
	{ 26, 24103929 },
	{ 26, 30379005 },
	{ 27, 47959033 },
	{ 27, 64949241 },
	{ 27, 62524409 },
	{ 27, 50007033 },
	{ 27, 46009337 },
	{ 26, 33491961 },
	{ 26, 26889981 },
	{ 26, 14307069 },
	{ 26, 10112765 },
	{ 24, 5918461 },
	{ 24, 1724157 },
	{ 18, 55066 },
	{ 23, 1003257 },
	{ 23, 3034873 },
	{ 25, 4935417 },
	{ 25, 6967033 },
	{ 24, 6770425 },
	{ 24, 7753465 },
	{ 25, 10702585 },
	{ 25, 11685625 },
	{ 23, 3755769 },
	{ 23, 3952377 },
	{ 23, 3723001 },
	{ 23, 3788537 },
	{ 23, 4034301 },
	{ 25, 14929657 },
	{ 25, 15126265 },
	{ 25, 15191801 },
	{ 25, 16223997 },
	{ 26, 30134009 },
	{ 26, 30330617 },
	{ 26, 30396153 },
	{ 26, 32476925 },
	{ 27, 64884473 },
	{ 27, 60755705 },
	{ 27, 49942265 },
	{ 27, 45813497 },
	{ 26, 33427193 },
	{ 26, 29298425 },
	{ 26, 14307325 },
	{ 26, 10113021 },
	{ 24, 5918717 },
	{ 24, 1724413 },
	{ 18, 63258 },
	{ 23, 1003513 },
	{ 23, 3035129 },
	{ 25, 4935673 },
	{ 25, 6967289 },
	{ 24, 6770681 },
	{ 24, 7753721 },
	{ 25, 10702841 },
	{ 25, 11685881 },
	{ 23, 3756025 },
	{ 23, 3952633 },
	{ 23, 3723257 },
	{ 23, 3788793 },
	{ 23, 4034557 },
	{ 25, 14929913 },
	{ 25, 15126521 },
	{ 25, 15192057 },
	{ 25, 16224253 },
	{ 26, 30134265 },
	{ 26, 30330873 },
	{ 26, 30396409 },
	{ 26, 32477181 },
	{ 27, 64884729 },
	{ 27, 60755961 },
	{ 27, 49942521 },
	{ 27, 45813753 },
	{ 26, 33427449 },
	{ 26, 29298681 },
	{ 26, 14375677 },
	{ 26, 10181373 },
	{ 24, 5987069 },
	{ 24, 1792765 },
	{ 18, 104346 },
	{ 24, 1727225 },
	{ 23, 3103481 },
	{ 25, 5135097 },
	{ 25, 7035641 },
	{ 25, 13261561 },
	{ 24, 7822073 },
	{ 25, 10902265 },
	{ 25, 11754233 },
	{ 25, 14834425 },
	{ 23, 4020985 },
	{ 24, 6839033 },
	{ 23, 3988217 },
	{ 23, 4053753 },
	{ 24, 6920957 },
	{ 25, 15981305 },
	{ 25, 16177913 },
	{ 25, 16243449 },
	{ 26, 32168697 },
	{ 26, 32234233 },
	{ 26, 32430841 },
	{ 26, 32496377 },
	{ 27, 64690937 },
	{ 27, 60693241 },
	{ 27, 48175865 },
	{ 27, 45751033 },
	{ 26, 33233657 },
	{ 26, 29235961 },
	{ 26, 16718585 },
	{ 26, 10181629 },
	{ 24, 5987325 },
	{ 24, 1793021 },
	{ 18, 112538 },
	{ 24, 1727481 },
	{ 23, 3103737 },
	{ 25, 5135353 },
	{ 25, 7035897 },
	{ 25, 13261817 },
	{ 24, 7822329 },
	{ 25, 10902521 },
	{ 25, 11754489 },
	{ 25, 14834681 },
	{ 23, 4021241 },
	{ 24, 6839289 },
	{ 23, 3988473 },
	{ 23, 4054009 },
	{ 24, 6921213 },
	{ 25, 15981561 },
	{ 25, 16178169 },
	{ 25, 16243705 },
	{ 26, 32168953 },
	{ 26, 32234489 },
	{ 26, 32431097 },
	{ 26, 32496633 },
	{ 27, 64691193 },
	{ 27, 60693497 },
	{ 27, 48176121 },
	{ 27, 45751289 },
	{ 26, 33233913 },
	{ 26, 29236217 },
	{ 26, 16718841 },
	{ 26, 10379005 },
	{ 24, 6184701 },
	{ 24, 1990397 },
	{ 19, 240922 },
	{ 24, 1793785 },
	{ 24, 5922553 },
	{ 25, 5201657 },
	{ 25, 7233273 },
	{ 25, 13328121 },
	{ 25, 15359737 },
	{ 25, 10968825 },
	{ 25, 11951865 },
	{ 25, 14900985 },
	{ 25, 15884025 },
	{ 24, 6905593 },
	{ 24, 7102201 },
	{ 24, 6872825 },
	{ 24, 6938361 },
	{ 24, 7184125 },
	{ 26, 62267129 },
	{ 26, 61284089 },
	{ 26, 27778809 },
	{ 26, 28811005 },
	{ 27, 57548537 },
	{ 27, 55516921 },
	{ 27, 64626425 },
	{ 27, 60497657 },
	{ 27, 48111353 },
	{ 27, 43982585 },
	{ 26, 33169145 },
	{ 26, 29040377 },
	{ 26, 16654073 },
	{ 26, 12525305 },
	{ 24, 6184957 },
	{ 24, 1990653 },
	{ 19, 257306 },
	{ 24, 1794041 },
	{ 24, 5922809 },
	{ 25, 5201913 },
	{ 25, 7233529 },
	{ 25, 13328377 },
	{ 25, 15359993 },
	{ 25, 10969081 },
	{ 25, 11952121 },
	{ 25, 14901241 },
	{ 25, 15884281 },
	{ 24, 6905849 },
	{ 24, 7102457 },
	{ 24, 6873081 },
	{ 24, 6938617 },
	{ 24, 7184381 },
	{ 26, 62267385 },
	{ 26, 61284345 },
	{ 26, 27779065 },
	{ 26, 28811261 },
	{ 27, 57548793 },
	{ 27, 55517177 },
	{ 27, 64626681 },
	{ 27, 60497913 },
	{ 27, 48111609 },
	{ 27, 43982841 },
	{ 26, 33169401 },
	{ 26, 29040633 },
	{ 26, 16654329 },
	{ 26, 12525561 },
	{ 26, 24980221 },
	{ 26, 8203005 },
	{ 20, 339354 },
	{ 26, 7940857 },
	{ 26, 23931641 },
	{ 28, 40446713 },
	{ 27, 29174521 },
	{ 27, 54078201 },
	{ 27, 61680377 },
	{ 28, 134097657 },
	{ 27, 48048889 },
	{ 27, 60369657 },
	{ 27, 63777529 },
	{ 26, 33434361 },
	{ 26, 16657145 },
	{ 26, 31533817 },
	{ 26, 66333433 },
	{ 26, 28781305 },
	{ 26, 31861501 },
	{ 28, 244853497 },
	{ 28, 131869433 },
	{ 28, 115288825 },
	{ 28, 127806205 },
	{ 29, 221784825 },
	{ 28, 129772281 },
	{ 29, 241707769 },
	{ 29, 191638265 },
	{ 29, 175647481 },
	{ 28, 125577977 },
	{ 28, 115878649 },
	{ 28, 65809145 },
	{ 28, 49818361 },
	{ 26, 33303289 },
	{ 26, 8203261 },
	{ 20, 344042 },
	{ 26, 7941113 },
	{ 26, 23931897 },
	{ 28, 40446969 },
	{ 27, 29174777 },
	{ 27, 54078457 },
	{ 27, 61680633 },
	{ 28, 134097913 },
	{ 27, 48049145 },
	{ 27, 60369913 },
	{ 27, 63777785 },
	{ 26, 33434617 },
	{ 26, 16657401 },
	{ 26, 31534073 },
	{ 26, 66333689 },
	{ 26, 28781561 },
	{ 26, 31861757 },
	{ 28, 244853753 },
	{ 28, 131869689 },
	{ 28, 115289081 },
	{ 28, 127806461 },
	{ 29, 221785081 },
	{ 28, 129772537 },
	{ 29, 241708025 },
	{ 29, 191638521 },
	{ 29, 175647737 },
	{ 28, 125578233 },
	{ 28, 115878905 },
	{ 28, 65809401 },
	{ 28, 49818617 },
	{ 26, 33303545 },
	{ 26, 15281917 },
	{ 20, 360426 },
	{ 26, 8204025 },
	{ 26, 24719097 },
	{ 28, 40709881 },
	{ 28, 57224953 },
	{ 27, 54341369 },
	{ 27, 62467833 },
	{ 28, 86847225 },
	{ 28, 133836537 },
	{ 27, 60632825 },
	{ 27, 64564985 },
	{ 26, 33500925 },
	{ 26, 33173241 },
	{ 26, 16396025 },
	{ 26, 66072313 },
	{ 26, 65285881 },
	{ 26, 31928057 },
	{ 26, 32911101 },
	{ 28, 131608313 },
	{ 28, 127676153 },
	{ 28, 127872761 },
	{ 28, 132001533 },
	{ 28, 129511161 },
	{ 28, 121384697 },
	{ 29, 191377145 },
	{ 29, 174862073 },
	{ 28, 125316857 },
	{ 28, 108801785 },
	{ 28, 65548025 },
	{ 28, 49032953 },
	{ 26, 33042169 },
	{ 26, 16527097 },
	{ 20, 376682 },
	{ 26, 8204281 },
	{ 26, 24719353 },
	{ 28, 40710137 },
	{ 28, 57225209 },
	{ 27, 54341625 },
	{ 27, 62468089 },
	{ 28, 86847481 },
	{ 28, 133836793 },
	{ 27, 60633081 },
	{ 27, 64565241 },
	{ 26, 33501181 },
	{ 26, 33173497 },
	{ 26, 16396281 },
	{ 26, 66072569 },
	{ 26, 65286137 },
	{ 26, 31928313 },
	{ 26, 32911357 },
	{ 28, 131608569 },
	{ 28, 127676409 },
	{ 28, 127873017 },
	{ 28, 132001789 },
	{ 28, 129511417 },
	{ 28, 121384953 },
	{ 29, 191377401 },
	{ 29, 174862329 },
	{ 28, 125317113 },
	{ 28, 108802041 },
	{ 28, 65548281 },
	{ 28, 49033209 },
	{ 26, 33042425 },
	{ 26, 16527353 },
	{ 20, 393066 },
	{ 26, 15284985 },
	{ 26, 24984313 },
	{ 27, 49872891 },
	{ 28, 57490169 },
	{ 28, 107559673 },
	{ 27, 62733049 },
	{ 28, 87636729 },
	{ 28, 95238905 },
	{ 28, 133053177 },
	{ 27, 64830201 },
	{ 28, 65944313 },
	{ 26, 33241853 },
	{ 26, 32389881 },
	{ 26, 15612665 },
	{ 26, 65026809 },
	{ 26, 62143225 },
	{ 26, 32979705 },
	{ 26, 61225725 },
	{ 27, 64421887 },
	{ 28, 115096313 },
	{ 28, 132070137 },
	{ 28, 128727801 },
	{ 28, 121125625 },
	{ 28, 96221945 },
	{ 29, 174603001 },
	{ 28, 124533497 },
	{ 28, 108542713 },
	{ 28, 58473209 },
	{ 28, 48773881 },
	{ 26, 32258809 },
	{ 26, 16268025 },
	{ 20, 474602 },
	{ 26, 15285241 },
	{ 26, 24984569 },
	{ 27, 49872635 },
	{ 28, 57490425 },
	{ 28, 107559929 },
	{ 27, 62733305 },
	{ 28, 87636985 },
	{ 28, 95239161 },
	{ 28, 133053433 },
	{ 27, 64830457 },
	{ 28, 65944569 },
	{ 26, 33242109 },
	{ 26, 32390137 },
	{ 26, 15612921 },
	{ 26, 65027065 },
	{ 26, 62143481 },
	{ 26, 32979961 },
	{ 26, 61225981 },
	{ 27, 64421631 },
	{ 28, 115096569 },
	{ 28, 132070393 },
	{ 28, 128728057 },
	{ 28, 121125881 },
	{ 28, 96222201 },
	{ 29, 174603257 },
	{ 28, 124533753 },
	{ 28, 108542969 },
	{ 28, 58473465 },
	{ 28, 48774137 },
	{ 26, 32259065 },
	{ 26, 16268281 },
	{ 20, 490986 },
	{ 26, 15548153 },
	{ 26, 32063225 },
	{ 27, 64027643 },
	{ 28, 58277625 },
	{ 28, 107822841 },
	{ 28, 124337913 },
	{ 28, 87899897 },
	{ 28, 96026361 },
	{ 28, 120405753 },
	{ 28, 132792057 },
	{ 28, 116014841 },
	{ 28, 65683193 },
	{ 26, 32456445 },
	{ 26, 32128761 },
	{ 26, 15351545 },
	{ 26, 61882105 },
	{ 26, 61095673 },
	{ 26, 61292281 },
	{ 26, 62275325 },
	{ 27, 64945151 },
	{ 28, 110903033 },
	{ 28, 128466681 },
	{ 28, 120340217 },
	{ 28, 95960825 },
	{ 28, 87834361 },
	{ 28, 124272377 },
	{ 28, 107757305 },
	{ 28, 58212089 },
	{ 28, 41697017 },
	{ 26, 31997689 },
	{ 26, 15482617 },
	{ 20, 507242 },
	{ 26, 15548409 },
	{ 26, 32063481 },
	{ 27, 64027387 },
	{ 28, 58277881 },
	{ 28, 107823097 },
	{ 28, 124338169 },
	{ 28, 87900153 },
	{ 28, 96026617 },
	{ 28, 120406009 },
	{ 28, 132792313 },
	{ 28, 116015097 },
	{ 28, 65683449 },
	{ 26, 32456701 },
	{ 26, 32129017 },
	{ 26, 15351801 },
	{ 26, 61882361 },
	{ 26, 61095929 },
	{ 26, 61292537 },
	{ 26, 62275581 },
	{ 27, 64944895 },
	{ 28, 110903289 },
	{ 28, 128466937 },
	{ 28, 120340473 },
	{ 28, 95961081 },
	{ 28, 87834617 },
	{ 28, 124272633 },
	{ 28, 107757561 },
	{ 28, 58212345 },
	{ 28, 41697273 },
	{ 26, 31997945 },
	{ 26, 15482873 },
	{ 20, 523626 },
	{ 26, 16345849 },
	{ 26, 32336633 },
	{ 27, 64548859 },
	{ 28, 58551033 },
	{ 28, 108620537 },
	{ 28, 124611321 },
	{ 29, 259943161 },
	{ 28, 96299769 },
	{ 28, 121203449 },
	{ 28, 128805625 },
	{ 28, 125725433 },
	{ 28, 108948217 },
	{ 28, 58616569 },
	{ 26, 32205565 },
	{ 26, 25062137 },
	{ 26, 8284921 },
	{ 26, 60844793 },
	{ 26, 32795385 },
	{ 26, 62352121 },
	{ 26, 65432317 },
	{ 27, 66514943 },
	{ 27, 64776953 },
	{ 28, 120089337 },
	{ 28, 95185657 },
	{ 28, 87583481 },
	{ 27, 62679801 },
	{ 28, 107506425 },
	{ 28, 57436921 },
	{ 28, 41446137 },
	{ 26, 24931065 },
	{ 26, 15231737 },
	{ 21, 864234 },
	{ 26, 16346105 },
	{ 26, 32336889 },
	{ 27, 64548603 },
	{ 28, 58551289 },
	{ 28, 108620793 },
	{ 28, 124611577 },
	{ 29, 259943417 },
	{ 28, 96300025 },
	{ 28, 121203705 },
	{ 28, 128805881 },
	{ 28, 125725689 },
	{ 28, 108948473 },
	{ 28, 58616825 },
	{ 26, 32205821 },
	{ 26, 25062393 },
	{ 26, 8285177 },
	{ 26, 60845049 },
	{ 26, 32795641 },
	{ 26, 62352377 },
	{ 26, 65432573 },
	{ 27, 66514687 },
	{ 27, 64777209 },
	{ 28, 120089593 },
	{ 28, 95185913 },
	{ 28, 87583737 },
	{ 27, 62680057 },
	{ 28, 107506681 },
	{ 28, 57437177 },
	{ 28, 41446393 },
	{ 26, 24931321 },
	{ 26, 15231993 },
	{ 21, 880618 },
	{ 26, 16609017 },
	{ 26, 33124089 },
	{ 27, 66120699 },
	{ 28, 65629945 },
	{ 28, 108883705 },
	{ 28, 125398777 },
	{ 29, 174943993 },
	{ 29, 259682041 },
	{ 28, 121466617 },
	{ 28, 129593081 },
	{ 28, 125791997 },
	{ 28, 125464313 },
	{ 28, 108687097 },
	{ 28, 58355449 },
	{ 26, 25128701 },
	{ 26, 24801017 },
	{ 26, 8023801 },
	{ 26, 32534265 },
	{ 26, 31747833 },
	{ 26, 65498873 },
	{ 26, 66481917 },
	{ 27, 64515833 },
	{ 27, 60583673 },
	{ 28, 94924537 },
	{ 28, 86798073 },
	{ 27, 62418681 },
	{ 27, 54292217 },
	{ 28, 57175801 },
	{ 28, 40660729 },
	{ 26, 24669945 },
	{ 26, 8154873 },
	{ 21, 896874 },
	{ 26, 16609273 },
	{ 26, 33124345 },
	{ 27, 66120443 },
	{ 28, 65630201 },
	{ 28, 108883961 },
	{ 28, 125399033 },
	{ 29, 174944249 },
	{ 29, 259682297 },
	{ 28, 121466873 },
	{ 28, 129593337 },
	{ 28, 125792253 },
	{ 28, 125464569 },
	{ 28, 108687353 },
	{ 28, 58355705 },
	{ 26, 25128957 },
	{ 26, 24801273 },
	{ 26, 8024057 },
	{ 26, 32534521 },
	{ 26, 31748089 },
	{ 26, 65499129 },
	{ 26, 66482173 },
	{ 27, 64516089 },
	{ 27, 60583929 },
	{ 28, 94924793 },
	{ 28, 86798329 },
	{ 27, 62418937 },
	{ 27, 54292473 },
	{ 28, 57176057 },
	{ 28, 40660985 },
	{ 26, 24670201 },
	{ 26, 8155129 },
	{ 21, 913258 },
	{ 21, 2097134 },
	{ 26, 33389305 },
	{ 27, 66633723 },
	{ 28, 65895161 },
	{ 28, 115964665 },
	{ 28, 125663993 },
	{ 29, 175733497 },
	{ 29, 191724281 },
	{ 29, 258898681 },
	{ 28, 129858297 },
	{ 29, 191789817 },
	{ 28, 125532925 },
	{ 28, 124680953 },
	{ 28, 107903737 },
	{ 28, 57572089 },
	{ 26, 24869629 },
	{ 26, 24017657 },
	{ 26, 7240441 },
	{ 26, 31488761 },
	{ 26, 28605177 },
	{ 26, 66550521 },
	{ 27, 63732473 },
	{ 27, 60324601 },
	{ 27, 48003833 },
	{ 28, 86539001 },
	{ 27, 61635321 },
	{ 27, 54033145 },
	{ 27, 29129465 },
	{ 28, 40401657 },
	{ 26, 23886585 },
	{ 26, 7895801 },
	{ 21, 994794 },
	{ 21, 2080750 },
	{ 26, 33389561 },
	{ 27, 66633467 },
	{ 28, 65895417 },
	{ 28, 115964921 },
	{ 28, 125664249 },
	{ 29, 175733753 },
	{ 29, 191724537 },
	{ 29, 258898937 },
	{ 28, 129858553 },
	{ 29, 191790073 },
	{ 28, 125533181 },
	{ 28, 124681209 },
	{ 28, 107903993 },
	{ 28, 57572345 },
	{ 26, 24869885 },
	{ 26, 24017913 },
	{ 26, 7240697 },
	{ 26, 31489017 },
	{ 26, 28605433 },
	{ 26, 66550777 },
	{ 27, 63732729 },
	{ 27, 60324857 },
	{ 27, 48004089 },
	{ 28, 86539257 },
	{ 27, 61635577 },
	{ 27, 54033401 },
	{ 27, 29129721 },
	{ 28, 40401913 },
	{ 26, 23886841 },
	{ 26, 7896057 },
	{ 21, 1011178 },
	{ 21, 2076062 },
	{ 26, 24935421 },
	{ 27, 49987327 },
	{ 28, 66682617 },
	{ 28, 116227833 },
	{ 28, 132742905 },
	{ 29, 175996665 },
	{ 29, 192511737 },
	{ 29, 242056953 },
	{ 29, 258637561 },
	{ 29, 241860345 },
	{ 29, 191528697 },
	{ 28, 124747517 },
	{ 28, 124419833 },
	{ 28, 107642617 },
	{ 28, 57310969 },
	{ 26, 24084221 },
	{ 26, 23756537 },
	{ 26, 6979321 },
	{ 26, 28344057 },
	{ 26, 27557625 },
	{ 27, 63471353 },
	{ 27, 59539193 },
	{ 27, 47742713 },
	{ 27, 43810553 },
	{ 27, 61374201 },
	{ 27, 53247737 },
	{ 27, 28868345 },
	{ 27, 20741881 },
	{ 26, 23625465 },
	{ 26, 7110393 },
	{ 21, 1027434 },
	{ 21, 2059550 },
	{ 26, 24674045 },
	{ 27, 49462271 },
	{ 28, 66682873 },
	{ 28, 116228089 },
	{ 28, 132743161 },
	{ 29, 175996921 },
	{ 29, 192511993 },
	{ 29, 242057209 },
	{ 29, 258637817 },
	{ 29, 241860601 },
	{ 29, 191528953 },
	{ 28, 124747773 },
	{ 28, 124420089 },
	{ 28, 107642873 },
	{ 28, 57311225 },
	{ 26, 24084477 },
	{ 26, 23756793 },
	{ 26, 6979577 },
	{ 26, 28344313 },
	{ 26, 27557881 },
	{ 27, 63471609 },
	{ 27, 59539449 },
	{ 27, 47742969 },
	{ 27, 43810809 },
	{ 27, 61374457 },
	{ 27, 53247993 },
	{ 27, 28868601 },
	{ 27, 20742137 },
	{ 26, 23625721 },
	{ 26, 7110649 },
	{ 21, 1043818 },
	{ 21, 2043166 },
	{ 26, 24674301 },
	{ 27, 49462015 },
	{ 28, 58228733 },
	{ 28, 108560381 },
	{ 28, 125337597 },
	{ 29, 175669245 },
	{ 29, 192446461 },
	{ 29, 242778109 },
	{ 29, 259555325 },
	{ 29, 259828473 },
	{ 29, 243051257 },
	{ 29, 192719609 },
	{ 29, 175942393 },
	{ 28, 125610745 },
	{ 28, 108833529 },
	{ 28, 58501881 },
	{ 27, 47622909 },
	{ 26, 24947449 },
	{ 26, 8170233 },
	{ 26, 31895547 },
	{ 26, 32025337 },
	{ 26, 32157691 },
	{ 28, 93891321 },
	{ 28, 87075577 },
	{ 27, 62434041 },
	{ 27, 62566395 },
	{ 28, 56142585 },
	{ 28, 40938233 },
	{ 26, 24685305 },
	{ 26, 24817659 },
	{ 20, 956394 },
	{ 20, 980894 },
	{ 27, 47753981 },
	{ 27, 47886335 },
	{ 29, 133868537 },
	{ 29, 234007545 },
	{ 29, 265989113 },
	{ 29, 265858811 },
	{ 30, 511486969 },
	{ 30, 461155321 },
	{ 30, 444378105 },
	{ 29, 259828729 },
	{ 29, 243051513 },
	{ 29, 192719865 },
	{ 29, 175942649 },
	{ 28, 125611001 },
	{ 28, 108833785 },
	{ 28, 58502137 },
	{ 27, 47623165 },
	{ 26, 24947705 },
	{ 26, 8170489 },
	{ 26, 31895291 },
	{ 26, 32025593 },
	{ 26, 32157435 },
	{ 28, 93891577 },
	{ 28, 87075833 },
	{ 27, 62434297 },
	{ 27, 62566139 },
	{ 28, 56142841 },
	{ 28, 40938489 },
	{ 26, 24685561 },
	{ 26, 24817403 },
	{ 20, 964586 },
	{ 20, 972702 },
	{ 27, 47754237 },
	{ 27, 47886079 },
	{ 29, 114863101 },
	{ 29, 234532601 },
	{ 29, 267562745 },
	{ 29, 267430907 },
	{ 30, 527740665 },
	{ 30, 510963449 },
	{ 30, 460631801 },
	{ 29, 259960573 },
	{ 29, 259305209 },
	{ 29, 242527993 },
	{ 29, 192196345 },
	{ 28, 125742845 },
	{ 28, 125087481 },
	{ 28, 108310265 },
	{ 28, 57978617 },
	{ 26, 25079549 },
	{ 26, 24424185 },
	{ 26, 7646969 },
	{ 26, 31502073 },
	{ 26, 29929209 },
	{ 26, 30059515 },
	{ 28, 85503737 },
	{ 27, 61910777 },
	{ 27, 54046457 },
	{ 27, 54176763 },
	{ 28, 39366393 },
	{ 26, 24162041 },
	{ 26, 7909113 },
	{ 20, 972650 },
	{ 20, 964382 },
	{ 27, 47230717 },
	{ 27, 47361023 },
	{ 29, 114339581 },
	{ 29, 234532857 },
	{ 29, 267563001 },
	{ 29, 267430651 },
	{ 30, 527740921 },
	{ 30, 510963705 },
	{ 30, 460632057 },
	{ 29, 259960829 },
	{ 29, 259305465 },
	{ 29, 242528249 },
	{ 29, 192196601 },
	{ 28, 125743101 },
	{ 28, 125087737 },
	{ 28, 108310521 },
	{ 28, 57978873 },
	{ 26, 25079805 },
	{ 26, 24424441 },
	{ 26, 7647225 },
	{ 26, 31502329 },
	{ 26, 29929465 },
	{ 26, 30059259 },
	{ 28, 85503993 },
	{ 27, 61911033 },
	{ 27, 54046713 },
	{ 27, 54176507 },
	{ 28, 39366649 },
	{ 26, 24162297 },
	{ 26, 7909369 },
	{ 20, 980842 },
	{ 20, 956190 },
	{ 27, 47230973 },
	{ 27, 47360767 },
	{ 29, 114339837 },
	{ 29, 215003133 },
	{ 29, 268090105 },
	{ 28, 133988347 },
	{ 29, 184057851 },
	{ 29, 200048635 },
	{ 29, 250118139 },
	{ 29, 259817467 },
	{ 29, 259439357 },
	{ 28, 121536511 },
	{ 28, 96436219 },
	{ 28, 96174075 },
	{ 28, 125221629 },
	{ 27, 60719103 },
	{ 27, 48201723 },
	{ 27, 47939579 },
	{ 26, 24558333 },
	{ 25, 15106047 },
	{ 25, 12025851 },
	{ 25, 11763707 },
	{ 25, 14778363 },
	{ 25, 11894779 },
	{ 27, 60340985 },
	{ 26, 30244859 },
	{ 26, 26836987 },
	{ 26, 14516219 },
	{ 26, 22592249 },
	{ 25, 11370491 },
	{ 20, 1021418 },
	{ 20, 521630 },
	{ 25, 4030463 },
	{ 25, 12419071 },
	{ 27, 20807679 },
	{ 27, 29196287 },
	{ 27, 54362111 },
	{ 27, 62750719 },
	{ 28, 87916543 },
	{ 28, 96305151 },
	{ 28, 121470975 },
	{ 28, 129859583 },
	{ 29, 259439613 },
	{ 28, 121536255 },
	{ 28, 96435963 },
	{ 28, 96173819 },
	{ 28, 125221885 },
	{ 27, 60718847 },
	{ 27, 48201467 },
	{ 27, 47939323 },
	{ 26, 24558589 },
	{ 25, 15105791 },
	{ 25, 12025595 },
	{ 25, 11763451 },
	{ 25, 14778107 },
	{ 25, 11894523 },
	{ 27, 60341241 },
	{ 26, 30244603 },
	{ 26, 26836731 },
	{ 26, 14515963 },
	{ 26, 22592505 },
	{ 25, 11370235 },
	{ 20, 1029610 },
	{ 20, 513438 },
	{ 25, 4030207 },
	{ 25, 12418815 },
	{ 27, 20807423 },
	{ 27, 29196031 },
	{ 27, 54361855 },
	{ 27, 62750463 },
	{ 28, 87916287 },
	{ 28, 96304895 },
	{ 28, 121470719 },
	{ 28, 129859327 },
	{ 29, 175864827 },
	{ 29, 257867517 },
	{ 28, 96369663 },
	{ 28, 88046587 },
	{ 28, 87784443 },
	{ 28, 123649789 },
	{ 27, 48135167 },
	{ 27, 44006395 },
	{ 27, 43744251 },
	{ 26, 22986493 },
	{ 25, 11959295 },
	{ 25, 10976251 },
	{ 25, 10714107 },
	{ 25, 11631611 },
	{ 25, 10845179 },
	{ 26, 29981691 },
	{ 26, 26049531 },
	{ 26, 14253051 },
	{ 26, 22068985 },
	{ 25, 11107323 },
	{ 20, 1037674 },
	{ 20, 505118 },
	{ 25, 3767295 },
	{ 25, 12155903 },
	{ 27, 20544511 },
	{ 27, 28933119 },
	{ 27, 54098943 },
	{ 27, 62487551 },
	{ 28, 87653375 },
	{ 28, 96041983 },
	{ 28, 121207807 },
	{ 28, 129596415 },
	{ 29, 175864571 },
	{ 29, 257867773 },
	{ 28, 96369407 },
	{ 28, 88046331 },
	{ 28, 87784187 },
	{ 28, 123650045 },
	{ 27, 48134911 },
	{ 27, 44006139 },
	{ 27, 43743995 },
	{ 26, 22986749 },
	{ 25, 11959039 },
	{ 25, 10975995 },
	{ 25, 10713851 },
	{ 25, 11631355 },
	{ 25, 10844923 },
	{ 26, 29981435 },
	{ 26, 26049275 },
	{ 26, 14252795 },
	{ 26, 22069241 },
	{ 25, 11107067 },
	{ 20, 1045866 },
	{ 20, 496926 },
	{ 25, 3767039 },
	{ 25, 12155647 },
	{ 27, 20544255 },
	{ 27, 28932863 },
	{ 27, 54098687 },
	{ 27, 62487295 },
	{ 28, 134180859 },
	{ 28, 133918715 },
	{ 28, 133132283 },
	{ 28, 132870139 },
	{ 28, 125792251 },
	{ 28, 125530107 },
	{ 28, 124743675 },
	{ 28, 129821433 },
	{ 27, 62877691 },
	{ 27, 62615547 },
	{ 27, 61829115 },
	{ 27, 62712569 },
	{ 26, 31420411 },
	{ 26, 31158267 },
	{ 26, 22473469 },
	{ 25, 12380921 },
	{ 24, 7827451 },
	{ 24, 7565307 },
	{ 25, 15264505 },
	{ 24, 7696379 },
	{ 26, 25784315 },
	{ 26, 13463547 },
	{ 25, 12118777 },
	{ 24, 6123515 },
	{ 25, 2715643 },
	{ 19, 228254 },
	{ 25, 2977791 },
	{ 25, 11366399 },
	{ 27, 19755007 },
	{ 27, 28143615 },
	{ 27, 53309439 },
	{ 27, 61698047 },
	{ 28, 134180603 },
	{ 28, 133918459 },
	{ 28, 133132027 },
	{ 28, 132869883 },
	{ 28, 125791995 },
	{ 28, 125529851 },
	{ 28, 124743419 },
	{ 28, 129821689 },
	{ 27, 62877435 },
	{ 27, 62615291 },
	{ 27, 61828859 },
	{ 27, 62712825 },
	{ 26, 31420155 },
	{ 26, 31158011 },
	{ 26, 22473725 },
	{ 25, 12381177 },
	{ 24, 7827195 },
	{ 24, 7565051 },
	{ 25, 15264761 },
	{ 24, 7696123 },
	{ 26, 25784059 },
	{ 26, 13463291 },
	{ 25, 12119033 },
	{ 24, 6123259 },
	{ 25, 2715387 },
	{ 19, 224158 },
	{ 25, 2977535 },
	{ 25, 11366143 },
	{ 27, 19754751 },
	{ 27, 28143359 },
	{ 27, 53309183 },
	{ 27, 61697791 },
	{ 28, 86863615 },
	{ 28, 117402619 },
	{ 28, 117140475 },
	{ 28, 116354043 },
	{ 28, 116091899 },
	{ 28, 109014011 },
	{ 28, 108751867 },
	{ 28, 129953533 },
	{ 27, 62811135 },
	{ 27, 54488059 },
	{ 27, 54225915 },
	{ 27, 62844669 },
	{ 26, 31353855 },
	{ 26, 27225083 },
	{ 26, 26962939 },
	{ 25, 12513021 },
	{ 24, 7760895 },
	{ 24, 6777851 },
	{ 24, 6515707 },
	{ 24, 7433211 },
	{ 24, 6646779 },
	{ 26, 13200379 },
	{ 25, 11595513 },
	{ 24, 5860347 },
	{ 24, 1928187 },
	{ 19, 219934 },
	{ 25, 2714623 },
	{ 25, 11103231 },
	{ 27, 19491839 },
	{ 27, 27880447 },
	{ 27, 53046271 },
	{ 27, 61434879 },
	{ 28, 134114047 },
	{ 28, 117402363 },
	{ 28, 117140219 },
	{ 28, 116353787 },
	{ 28, 116091643 },
	{ 28, 109013755 },
	{ 28, 108751611 },
	{ 28, 129953789 },
	{ 27, 62810879 },
	{ 27, 54487803 },
	{ 27, 54225659 },
	{ 27, 62844925 },
	{ 26, 31353599 },
	{ 26, 27224827 },
	{ 26, 26962683 },
	{ 25, 12513277 },
	{ 24, 7760639 },
	{ 24, 6777595 },
	{ 24, 6515451 },
	{ 24, 7432955 },
	{ 24, 6646523 },
	{ 26, 13200123 },
	{ 25, 11595769 },
	{ 24, 5860091 },
	{ 24, 1927931 },
	{ 19, 215838 },
	{ 25, 2714367 },
	{ 25, 11102975 },
	{ 27, 19491583 },
	{ 27, 27880191 },
	{ 27, 53046015 },
	{ 27, 61434623 },
	{ 28, 86600447 },
	{ 28, 94989055 },
	{ 28, 67059707 },
	{ 28, 66797563 },
	{ 28, 66011131 },
	{ 28, 65748987 },
	{ 28, 58671099 },
	{ 28, 58408955 },
	{ 28, 129432317 },
	{ 27, 54411263 },
	{ 27, 29310971 },
	{ 27, 29048827 },
	{ 27, 62323453 },
	{ 26, 27148287 },
	{ 26, 14630907 },
	{ 26, 14368763 },
	{ 25, 11991805 },
	{ 24, 6701055 },
	{ 24, 3620859 },
	{ 24, 3358715 },
	{ 24, 6373371 },
	{ 24, 3489787 },
	{ 25, 10025721 },
	{ 24, 5062651 },
	{ 24, 1654779 },
	{ 18, 129438 },
	{ 24, 1916927 },
	{ 24, 6111231 },
	{ 26, 10305535 },
	{ 26, 14499839 },
	{ 26, 27082751 },
	{ 26, 31277055 },
	{ 27, 43859967 },
	{ 27, 48054271 },
	{ 27, 60637183 },
	{ 27, 64831487 },
	{ 28, 66010875 },
	{ 28, 65748731 },
	{ 28, 58670843 },
	{ 28, 58408699 },
	{ 28, 129432573 },
	{ 27, 54411007 },
	{ 27, 29310715 },
	{ 27, 29048571 },
	{ 27, 62323709 },
	{ 26, 27148031 },
	{ 26, 14630651 },
	{ 26, 14368507 },
	{ 25, 11992061 },
	{ 24, 6700799 },
	{ 24, 3620603 },
	{ 24, 3358459 },
	{ 24, 6373115 },
	{ 24, 3489531 },
	{ 25, 10025977 },
	{ 24, 5062395 },
	{ 24, 1654523 },
	{ 18, 125342 },
	{ 24, 1916671 },
	{ 24, 6110975 },
	{ 26, 10305279 },
	{ 26, 14499583 },
	{ 26, 27082495 },
	{ 26, 31276799 },
	{ 27, 43859711 },
	{ 27, 48054015 },
	{ 27, 60636927 },
	{ 27, 64831231 },
	{ 28, 50019323 },
	{ 28, 49232891 },
	{ 28, 48970747 },
	{ 28, 41892859 },
	{ 28, 41630715 },
	{ 28, 127860477 },
	{ 27, 29244415 },
	{ 27, 20921339 },
	{ 27, 20659195 },
	{ 27, 60751613 },
	{ 26, 14564351 },
	{ 26, 10435579 },
	{ 26, 10173435 },
	{ 25, 10419965 },
	{ 24, 3554303 },
	{ 24, 2571259 },
	{ 24, 2309115 },
	{ 24, 3226619 },
	{ 24, 2440187 },
	{ 24, 4799483 },
	{ 24, 867323 },
	{ 18, 121118 },
	{ 24, 1653759 },
	{ 24, 5848063 },
	{ 26, 10042367 },
	{ 26, 14236671 },
	{ 26, 26819583 },
	{ 26, 31013887 },
	{ 27, 43596799 },
	{ 27, 47791103 },
	{ 27, 60374015 },
	{ 27, 64568319 },
	{ 28, 50019067 },
	{ 28, 49232635 },
	{ 28, 48970491 },
	{ 28, 41892603 },
	{ 28, 41630459 },
	{ 28, 127860733 },
	{ 27, 29244159 },
	{ 27, 20921083 },
	{ 27, 20658939 },
	{ 27, 60751869 },
	{ 26, 14564095 },
	{ 26, 10435323 },
	{ 26, 10173179 },
	{ 25, 10420221 },
	{ 24, 3554047 },
	{ 24, 2571003 },
	{ 24, 2308859 },
	{ 24, 3226363 },
	{ 24, 2439931 },
	{ 24, 4799227 },
	{ 24, 867067 },
	{ 18, 117022 },
	{ 24, 1653503 },
	{ 24, 5847807 },
	{ 26, 10042111 },
	{ 26, 14236415 },
	{ 26, 26819327 },
	{ 26, 31013631 },
	{ 27, 43596543 },
	{ 27, 47790847 },
	{ 27, 60373759 },
	{ 27, 64568063 },
	{ 26, 33501179 },
	{ 26, 33239035 },
	{ 26, 32452603 },
	{ 26, 32190459 },
	{ 26, 25112571 },
	{ 26, 24850427 },
	{ 26, 24063995 },
	{ 26, 23801851 },
	{ 25, 12529659 },
	{ 25, 12267515 },
	{ 25, 11481083 },
	{ 25, 11218939 },
	{ 24, 6238203 },
	{ 24, 5976059 },
	{ 24, 5189627 },
	{ 24, 5876473 },
	{ 22, 1519611 },
	{ 22, 1257467 },
	{ 24, 5352185 },
	{ 22, 1388539 },
	{ 24, 602107 },
	{ 16, 24222 },
	{ 24, 864255 },
	{ 24, 5058559 },
	{ 26, 9252863 },
	{ 26, 13447167 },
	{ 26, 26030079 },
	{ 26, 30224383 },
	{ 27, 42807295 },
	{ 27, 47001599 },
	{ 27, 59584511 },
	{ 27, 63778815 },
	{ 26, 33500923 },
	{ 26, 33238779 },
	{ 26, 32452347 },
	{ 26, 32190203 },
	{ 26, 25112315 },
	{ 26, 24850171 },
	{ 26, 24063739 },
	{ 26, 23801595 },
	{ 25, 12529403 },
	{ 25, 12267259 },
	{ 25, 11480827 },
	{ 25, 11218683 },
	{ 24, 6237947 },
	{ 24, 5975803 },
	{ 24, 5189371 },
	{ 24, 5876729 },
	{ 22, 1519355 },
	{ 22, 1257211 },
	{ 24, 5352441 },
	{ 22, 1388283 },
	{ 24, 601851 },
	{ 16, 23198 },
	{ 24, 863999 },
	{ 24, 5058303 },
	{ 26, 9252607 },
	{ 26, 13446911 },
	{ 26, 26029823 },
	{ 26, 30224127 },
	{ 27, 42807039 },
	{ 27, 47001343 },
	{ 27, 59584255 },
	{ 27, 63778559 },
	{ 26, 33434623 },
	{ 26, 16722939 },
	{ 26, 16460795 },
	{ 26, 15674363 },
	{ 26, 15412219 },
	{ 26, 8334331 },
	{ 26, 8072187 },
	{ 26, 7285755 },
	{ 25, 12463103 },
	{ 25, 4140027 },
	{ 25, 3877883 },
	{ 25, 3091451 },
	{ 24, 6171647 },
	{ 24, 2042875 },
	{ 24, 1780731 },
	{ 24, 6139645 },
	{ 22, 1453055 },
	{ 22, 470011 },
	{ 22, 207867 },
	{ 17, 44923 },
	{ 18, 131003 },
	{ 16, 22046 },
	{ 24, 601087 },
	{ 24, 4795391 },
	{ 26, 8989695 },
	{ 26, 13183999 },
	{ 26, 25766911 },
	{ 26, 29961215 },
	{ 27, 42544127 },
	{ 27, 46738431 },
	{ 27, 59321343 },
	{ 27, 63515647 },
	{ 26, 33434367 },
	{ 26, 16722683 },
	{ 26, 16460539 },
	{ 26, 15674107 },
	{ 26, 15411963 },
	{ 26, 8334075 },
	{ 26, 8071931 },
	{ 26, 7285499 },
	{ 25, 12462847 },
	{ 25, 4139771 },
	{ 25, 3877627 },
	{ 25, 3091195 },
	{ 24, 6171391 },
	{ 24, 2042619 },
	{ 24, 1780475 },
	{ 24, 6139901 },
	{ 22, 1452799 },
	{ 22, 469755 },
	{ 22, 207611 },
	{ 17, 42875 },
	{ 17, 65147 },
	{ 16, 21022 },
	{ 24, 600831 },
	{ 24, 4795135 },
	{ 26, 8989439 },
	{ 26, 13183743 },
	{ 26, 25766655 },
	{ 26, 29960959 },
	{ 27, 42543871 },
	{ 27, 46738175 },
	{ 27, 59321087 },
	{ 27, 63515391 },
	{ 28, 265140989 },
	{ 24, 4169727 },
	{ 24, 4104191 },
	{ 24, 3907583 },
	{ 24, 3842047 },
	{ 24, 2072575 },
	{ 24, 2007039 },
	{ 24, 1810431 },
	{ 24, 1744895 },
	{ 23, 1023999 },
	{ 23, 958463 },
	{ 23, 761855 },
	{ 23, 696319 },
	{ 22, 499711 },
	{ 22, 434175 },
	{ 22, 237567 },
	{ 22, 172031 },
	{ 20, 106495 },
	{ 20, 40959 },
	{ 15, 16191 },
	{ 15, 16235 },
	{ 15, 16190 },
	{ 17, 65471 },
	{ 20, 352255 },
	{ 22, 614399 },
	{ 22, 876543 },
	{ 22, 1662975 },
	{ 22, 1925119 },
	{ 23, 2711551 },
	{ 23, 2973695 },
	{ 23, 3760127 },
	{ 23, 4022271 },
	{ 24, 6905855 },
	{ 24, 4169471 },
	{ 24, 4103935 },
	{ 24, 3907327 },
	{ 24, 3841791 },
	{ 24, 2072319 },
	{ 24, 2006783 },
	{ 24, 1810175 },
	{ 24, 1744639 },
	{ 23, 1023743 },
	{ 23, 958207 },
	{ 23, 761599 },
	{ 23, 696063 },
	{ 22, 499455 },
	{ 22, 433919 },
	{ 22, 237311 },
	{ 22, 171775 },
	{ 20, 106239 },
	{ 20, 40703 },
	{ 15, 16367 },
	{ 12, 2011 },
	{ 12, 974 },
	{ 16, 32383 },
	{ 20, 351999 },
	{ 22, 614143 },
	{ 22, 876287 },
	{ 22, 1662719 },
	{ 22, 1924863 },
	{ 23, 2711295 },
	{ 23, 2973439 },
	{ 23, 3759871 },
	{ 23, 4022015 },
	{ 24, 6905599 },
	{ 24, 7167743 },
	{ 24, 7954175 },
	{ 24, 8216319 },
	{ 24, 15294207 },
	{ 24, 15556351 },
	{ 24, 16342783 },
	{ 24, 16604927 },
	{ 24, 7871487 },
	{ 24, 7085055 },
	{ 24, 6822911 },
	{ 23, 3939327 },
	{ 23, 3677183 },
	{ 23, 2890751 },
	{ 23, 2628607 },
	{ 22, 1842175 },
	{ 22, 1580031 },
	{ 22, 793599 },
	{ 22, 531455 },
	{ 16, 28031 },
	{ 11, 975 },
	{ 12, 910 },
	{ 14, 8047 },
	{ 16, 28543 },
	{ 22, 547839 },
	{ 22, 809983 },
	{ 22, 1596415 },
	{ 22, 1858559 },
	{ 23, 2644991 },
	{ 23, 2907135 },
	{ 23, 3693567 },
	{ 23, 3955711 },
	{ 24, 6839295 },
	{ 24, 7101439 },
	{ 24, 7887871 },
	{ 24, 16521983 },
	{ 24, 16259839 },
	{ 24, 15473407 },
	{ 24, 15211263 },
	{ 24, 8133375 },
	{ 24, 7871231 },
	{ 24, 7084799 },
	{ 24, 6822655 },
	{ 23, 3939071 },
	{ 23, 3676927 },
	{ 23, 2890495 },
	{ 23, 2628351 },
	{ 22, 1841919 },
	{ 22, 1579775 },
	{ 22, 793343 },
	{ 22, 531199 },
	{ 16, 25983 },
	{ 12, 1967 },
	{ 24, 114685 },
	{ 11, 991 },
	{ 16, 26495 },
	{ 22, 547583 },
	{ 22, 809727 },
	{ 22, 1596159 },
	{ 22, 1858303 },
	{ 23, 2644735 },
	{ 23, 2906879 },
	{ 23, 3693311 },
	{ 23, 3955455 },
	{ 24, 6839039 },
	{ 24, 7101183 },
	{ 24, 7887615 },
	{ 24, 8149759 },
	{ 24, 15227647 },
	{ 24, 15489791 },
	{ 24, 16276223 },
	{ 24, 16538367 },
	{ 24, 7933951 },
	{ 24, 7147519 },
	{ 24, 6885375 },
	{ 23, 4001791 },
	{ 23, 3739647 },
	{ 23, 2953215 },
	{ 23, 2691071 },
	{ 22, 1904639 },
	{ 22, 1642495 },
	{ 22, 856063 },
	{ 22, 593919 },
	{ 20, 331775 },
	{ 14, 7871 },
	{ 12, 2014 },
	{ 10, 459 },
	{ 13, 3899 },
	{ 20, 53247 },
	{ 20, 315391 },
	{ 22, 577535 },
	{ 22, 839679 },
	{ 22, 1626111 },
	{ 22, 1888255 },
	{ 23, 2674687 },
	{ 23, 2936831 },
	{ 23, 3723263 },
	{ 23, 3985407 },
	{ 24, 6868991 },
	{ 24, 16584447 },
	{ 24, 16322303 },
	{ 24, 15535871 },
	{ 24, 15273727 },
	{ 24, 8195839 },
	{ 24, 7933695 },
	{ 24, 7147263 },
	{ 24, 6885119 },
	{ 23, 4001535 },
	{ 23, 3739391 },
	{ 23, 2952959 },
	{ 23, 2690815 },
	{ 22, 1904383 },
	{ 22, 1642239 },
	{ 22, 855807 },
	{ 22, 593663 },
	{ 20, 331519 },
	{ 15, 15807 },
	{ 12, 1886 },
	{ 11, 939 },
	{ 13, 4075 },
	{ 20, 52991 },
	{ 20, 315135 },
	{ 22, 577279 },
	{ 22, 839423 },
	{ 22, 1625855 },
	{ 22, 1887999 },
	{ 23, 2674431 },
	{ 23, 2936575 },
	{ 23, 3723007 },
	{ 23, 3985151 },
	{ 24, 6868735 },
	{ 24, 7130879 },
	{ 24, 7917311 },
	{ 24, 8179455 },
	{ 24, 15257343 },
	{ 24, 15519487 },
	{ 24, 16305919 },
	{ 24, 16568063 },
	{ 26, 27397119 },
	{ 25, 15862783 },
	{ 25, 14814207 },
	{ 25, 11668479 },
	{ 25, 10619903 },
	{ 24, 7474175 },
	{ 24, 6425599 },
	{ 24, 3279871 },
	{ 24, 2231295 },
	{ 22, 1182719 },
	{ 22, 134143 },
	{ 15, 5742 },
	{ 13, 3771 },
	{ 16, 11643 },
	{ 20, 35835 },
	{ 20, 297979 },
	{ 20, 379903 },
	{ 22, 822267 },
	{ 22, 1608699 },
	{ 22, 1870843 },
	{ 22, 1952767 },
	{ 23, 2919419 },
	{ 23, 3705851 },
	{ 23, 3967995 },
	{ 23, 4049919 },
	{ 24, 7113723 },
	{ 24, 7900155 },
	{ 24, 8162299 },
	{ 24, 15240187 },
	{ 24, 15502331 },
	{ 24, 16288763 },
	{ 24, 16550907 },
	{ 24, 16632831 },
	{ 25, 15862527 },
	{ 25, 14813951 },
	{ 25, 11668223 },
	{ 25, 10619647 },
	{ 24, 7473919 },
	{ 24, 6425343 },
	{ 24, 3279615 },
	{ 24, 2231039 },
	{ 22, 1182463 },
	{ 22, 133887 },
	{ 15, 4718 },
	{ 14, 7611 },
	{ 16, 9595 },
	{ 20, 35579 },
	{ 20, 297723 },
	{ 20, 379647 },
	{ 22, 822011 },
	{ 22, 1608443 },
	{ 22, 1870587 },
	{ 22, 1952511 },
	{ 23, 2919163 },
	{ 23, 3705595 },
	{ 23, 3967739 },
	{ 23, 4049663 },
	{ 24, 7113467 },
	{ 24, 7899899 },
	{ 24, 8162043 },
	{ 24, 15239931 },
	{ 24, 15502075 },
	{ 24, 16288507 },
	{ 24, 16550651 },
	{ 24, 16632575 },
	{ 23, 3983359 },
	{ 23, 3721215 },
	{ 23, 2934783 },
	{ 23, 2672639 },
	{ 22, 1886207 },
	{ 22, 1624063 },
	{ 22, 837631 },
	{ 22, 575487 },
	{ 20, 313343 },
	{ 20, 51199 },
	{ 13, 3822 },
	{ 20, 34811 },
	{ 18, 83963 },
	{ 20, 133115 },
	{ 18, 26619 },
	{ 18, 92155 },
	{ 20, 157691 },
	{ 20, 223227 },
	{ 20, 419835 },
	{ 20, 485371 },
	{ 21, 681979 },
	{ 21, 747515 },
	{ 21, 944123 },
	{ 21, 1009659 },
	{ 22, 1730555 },
	{ 22, 1796091 },
	{ 22, 1992699 },
	{ 22, 2058235 },
	{ 22, 3827707 },
	{ 22, 3893243 },
	{ 22, 4089851 },
	{ 22, 4155387 },
	{ 23, 3983103 },
	{ 23, 3720959 },
	{ 23, 2934527 },
	{ 23, 2672383 },
	{ 22, 1885951 },
	{ 22, 1623807 },
	{ 22, 837375 },
	{ 22, 575231 },
	{ 20, 313087 },
	{ 20, 50943 },
	{ 13, 2798 },
	{ 20, 34555 },
	{ 18, 83707 },
	{ 20, 132859 },
	{ 18, 26363 },
	{ 18, 91899 },
	{ 20, 157435 },
	{ 20, 222971 },
	{ 20, 419579 },
	{ 20, 485115 },
	{ 21, 681723 },
	{ 21, 747259 },
	{ 21, 943867 },
	{ 21, 1009403 },
	{ 22, 1730299 },
	{ 22, 1795835 },
	{ 22, 1992443 },
	{ 22, 2057979 },
	{ 22, 3827451 },
	{ 22, 3892987 },
	{ 22, 4089595 },
	{ 22, 4155131 },
	{ 23, 4031487 },
	{ 23, 3769343 },
	{ 23, 2982911 },
	{ 23, 2720767 },
	{ 22, 1934335 },
	{ 22, 1672191 },
	{ 22, 885759 },
	{ 22, 623615 },
	{ 20, 361471 },
	{ 20, 99327 },
	{ 15, 6510 },
	{ 20, 50171 },
	{ 20, 295931 },
	{ 20, 148475 },
	{ 20, 197627 },
	{ 20, 41979 },
	{ 20, 304123 },
	{ 20, 324607 },
	{ 22, 828411 },
	{ 22, 1614843 },
	{ 22, 1876987 },
	{ 22, 1897471 },
	{ 23, 2925563 },
	{ 23, 3711995 },
	{ 23, 3974139 },
	{ 23, 3994623 },
	{ 24, 7119867 },
	{ 24, 7906299 },
	{ 24, 8168443 },
	{ 24, 15246331 },
	{ 24, 15508475 },
	{ 24, 16294907 },
	{ 23, 4031231 },
	{ 23, 3769087 },
	{ 23, 2982655 },
	{ 23, 2720511 },
	{ 22, 1934079 },
	{ 22, 1671935 },
	{ 22, 885503 },
	{ 22, 623359 },
	{ 20, 361215 },
	{ 20, 99071 },
	{ 15, 2414 },
	{ 20, 49915 },
	{ 20, 295675 },
	{ 20, 148219 },
	{ 20, 197371 },
	{ 20, 41723 },
	{ 20, 303867 },
	{ 20, 324351 },
	{ 22, 828155 },
	{ 22, 1614587 },
	{ 22, 1876731 },
	{ 22, 1897215 },
	{ 23, 2925307 },
	{ 23, 3711739 },
	{ 22, 4157951 },
	{ 22, 4092415 },
	{ 22, 3895807 },
	{ 22, 3830271 },
	{ 22, 2060799 },
	{ 22, 1995263 },
	{ 22, 1798655 },
	{ 22, 1733119 },
	{ 21, 1012223 },
	{ 21, 946687 },
	{ 21, 750079 },
	{ 21, 684543 },
	{ 20, 487935 },
	{ 20, 422399 },
	{ 20, 225791 },
	{ 20, 160255 },
	{ 18, 94719 },
	{ 18, 29183 },
	{ 13, 4590 },
	{ 18, 25083 },
	{ 18, 78331 },
	{ 20, 139771 },
	{ 18, 53755 },
	{ 18, 98811 },
	{ 18, 14843 },
	{ 18, 80379 },
	{ 18, 93695 },
	{ 20, 211451 },
	{ 20, 408059 },
	{ 20, 473595 },
	{ 20, 486911 },
	{ 21, 735739 },
	{ 21, 932347 },
	{ 21, 997883 },
	{ 21, 1011199 },
	{ 22, 3831037 },
	{ 22, 2061565 },
	{ 22, 1996029 },
	{ 22, 1799421 },
	{ 22, 1733885 },
	{ 21, 1012989 },
	{ 21, 947453 },
	{ 21, 750845 },
	{ 21, 685309 },
	{ 20, 488701 },
	{ 20, 423165 },
	{ 20, 226557 },
	{ 20, 161021 },
	{ 18, 95485 },
	{ 18, 29949 },
	{ 13, 410 },
	{ 18, 25849 },
	{ 18, 79097 },
	{ 20, 140537 },
	{ 18, 54521 },
	{ 18, 99577 },
	{ 18, 52473 },
	{ 18, 56569 },
	{ 18, 104701 },
	{ 20, 212217 },
	{ 20, 224505 },
	{ 20, 228601 },
	{ 20, 424189 },
	{ 21, 441593 },
	{ 21, 453881 },
	{ 21, 457977 },
	{ 21, 850173 },
	{ 22, 900345 },
	{ 22, 912633 },
	{ 22, 916729 },
	{ 22, 1027321 },
	{ 22, 1031417 },
	{ 21, 1013245 },
	{ 21, 947709 },
	{ 21, 751101 },
	{ 21, 685565 },
	{ 20, 488957 },
	{ 20, 423421 },
	{ 20, 226813 },
	{ 20, 161277 },
	{ 18, 95741 },
	{ 18, 30205 },
	{ 13, 4506 },
	{ 18, 26105 },
	{ 18, 79353 },
	{ 20, 140793 },
	{ 18, 54777 },
	{ 18, 99833 },
	{ 18, 52729 },
	{ 18, 56825 },
	{ 18, 104957 },
	{ 20, 212473 },
	{ 20, 224761 },
	{ 20, 228857 },
	{ 20, 424445 },
	{ 21, 441849 },
	{ 21, 454137 },
	{ 21, 458233 },
	{ 21, 850429 },
	{ 22, 900601 },
	{ 22, 912889 },
	{ 22, 916985 },
	{ 22, 1027577 },
	{ 22, 1031673 },
	{ 22, 1043961 },
	{ 22, 1048057 },
	{ 22, 1833469 },
	{ 24, 5411581 },
	{ 23, 3838717 },
	{ 23, 3314429 },
	{ 23, 1741565 },
	{ 23, 1217277 },
	{ 21, 692989 },
	{ 21, 168701 },
	{ 15, 2842 },
	{ 20, 119545 },
	{ 20, 365305 },
	{ 22, 578297 },
	{ 22, 824057 },
	{ 20, 414457 },
	{ 20, 463609 },
	{ 20, 406265 },
	{ 20, 422649 },
	{ 20, 484093 },
	{ 22, 1635065 },
	{ 22, 1684217 },
	{ 22, 1700601 },
	{ 22, 1958653 },
	{ 23, 3339001 },
	{ 23, 3388153 },
	{ 23, 3404537 },
	{ 23, 3924733 },
	{ 24, 6746873 },
	{ 24, 6796025 },
	{ 24, 6812409 },
	{ 24, 7254777 },
	{ 24, 7271161 },
	{ 24, 7320313 },
	{ 24, 7336697 },
	{ 24, 8381181 },
	{ 23, 3838973 },
	{ 23, 3314685 },
	{ 23, 1741821 },
	{ 23, 1217533 },
	{ 21, 693245 },
	{ 21, 168957 },
	{ 15, 6938 },
	{ 20, 119801 },
	{ 20, 365561 },
	{ 22, 578553 },
	{ 22, 824313 },
	{ 20, 414713 },
	{ 20, 463865 },
	{ 20, 406521 },
	{ 20, 422905 },
	{ 20, 484349 },
	{ 22, 1635321 },
	{ 22, 1684473 },
	{ 22, 1700857 },
	{ 22, 1958909 },
	{ 23, 3339257 },
	{ 23, 3388409 },
	{ 23, 3404793 },
	{ 23, 3924989 },
	{ 24, 6747129 },
	{ 24, 6796281 },
	{ 24, 6812665 },
	{ 24, 7255033 },
	{ 24, 7271417 },
	{ 24, 7320569 },
	{ 24, 7336953 },
	{ 24, 5428989 },
	{ 23, 3856125 },
	{ 23, 3331837 },
	{ 23, 1758973 },
	{ 23, 1234685 },
	{ 21, 710397 },
	{ 21, 186109 },
	{ 15, 11162 },
	{ 21, 169721 },
	{ 20, 382713 },
	{ 22, 628473 },
	{ 22, 841465 },
	{ 22, 1611513 },
	{ 20, 481017 },
	{ 21, 661241 },
	{ 20, 472825 },
	{ 20, 489209 },
	{ 21, 681725 },
	{ 22, 1898233 },
	{ 22, 1947385 },
	{ 22, 1963769 },
	{ 23, 3847929 },
	{ 23, 3864313 },
	{ 23, 3913465 },
	{ 23, 3929849 },
	{ 24, 7780089 },
	{ 24, 7796473 },
	{ 24, 7845625 },
	{ 24, 7862009 },
	{ 24, 8304377 },
	{ 24, 8320761 },
	{ 24, 8369913 },
	{ 24, 8386297 },
	{ 23, 3856381 },
	{ 23, 3332093 },
	{ 23, 1759229 },
	{ 23, 1234941 },
	{ 21, 710653 },
	{ 21, 186365 },
	{ 15, 15258 },
	{ 21, 169977 },
	{ 20, 382969 },
	{ 22, 628729 },
	{ 22, 841721 },
	{ 22, 1611769 },
	{ 20, 481273 },
	{ 21, 661497 },
	{ 20, 473081 },
	{ 20, 489465 },
	{ 21, 681981 },
	{ 22, 1898489 },
	{ 22, 1947641 },
	{ 22, 1964025 },
	{ 23, 3848185 },
	{ 23, 3864569 },
	{ 23, 3913721 },
	{ 23, 3930105 },
	{ 24, 7780345 },
	{ 24, 7796729 },
	{ 24, 7845881 },
	{ 24, 7862265 },
	{ 24, 8304633 },
	{ 24, 8321017 },
	{ 24, 8370169 },
	{ 24, 8386553 },
	{ 25, 15616765 },
	{ 25, 13519613 },
	{ 25, 7228157 },
	{ 25, 5131005 },
	{ 23, 3033853 },
	{ 23, 936701 },
	{ 18, 38170 },
	{ 23, 740089 },
	{ 23, 2771705 },
	{ 24, 2575097 },
	{ 24, 3558137 },
	{ 24, 6507257 },
	{ 24, 7490297 },
	{ 23, 2706169 },
	{ 23, 2902777 },
	{ 23, 2673401 },
	{ 23, 2738937 },
	{ 23, 2984701 },
	{ 25, 10734329 },
	{ 25, 10930937 },
	{ 25, 10996473 },
	{ 25, 12028669 },
	{ 26, 21744377 },
	{ 26, 21940985 },
	{ 26, 22006521 },
	{ 26, 24087293 },
	{ 27, 43764473 },
	{ 27, 43961081 },
	{ 26, 32394237 },
	{ 26, 30297085 },
	{ 26, 24005629 },
	{ 26, 21908477 },
	{ 25, 15617021 },
	{ 25, 13519869 },
	{ 25, 7228413 },
	{ 25, 5131261 },
	{ 23, 3034109 },
	{ 23, 936957 },
	{ 18, 46362 },
	{ 23, 740345 },
	{ 23, 2771961 },
	{ 24, 2575353 },
	{ 24, 3558393 },
	{ 24, 6507513 },
	{ 24, 7490553 },
	{ 23, 2706425 },
	{ 23, 2903033 },
	{ 23, 2673657 },
	{ 23, 2739193 },
	{ 23, 2984957 },
	{ 25, 10734585 },
	{ 25, 10931193 },
	{ 25, 10996729 },
	{ 25, 12028925 },
	{ 26, 21744633 },
	{ 26, 21941241 },
	{ 26, 22006777 },
	{ 26, 24087549 },
	{ 27, 43764729 },
	{ 27, 43961337 },
	{ 26, 32460541 },
	{ 26, 30363389 },
	{ 26, 24071933 },
	{ 26, 21974781 },
	{ 25, 15683325 },
	{ 25, 13586173 },
	{ 25, 7294717 },
	{ 25, 5197565 },
	{ 23, 3100413 },
	{ 23, 1003261 },
	{ 18, 54682 },
	{ 23, 937721 },
	{ 23, 2838265 },
	{ 25, 4869881 },
	{ 24, 3624697 },
	{ 24, 6704889 },
	{ 24, 7556857 },
	{ 25, 10637049 },
	{ 23, 2969337 },
	{ 23, 3690233 },
	{ 23, 2936569 },
	{ 23, 3002105 },
	{ 23, 3772157 },
	{ 25, 11783929 },
	{ 25, 11980537 },
	{ 25, 12046073 },
	{ 25, 15175421 },
	{ 26, 23842553 },
	{ 26, 24039161 },
	{ 26, 24104697 },
	{ 26, 30379773 },
	{ 27, 47959801 },
	{ 26, 32460797 },
	{ 26, 30363645 },
	{ 26, 24072189 },
	{ 26, 21975037 },
	{ 25, 15683581 },
	{ 25, 13586429 },
	{ 25, 7294973 },
	{ 25, 5197821 },
	{ 23, 3100669 },
	{ 23, 1003517 },
	{ 18, 62874 },
	{ 23, 937977 },
	{ 23, 2838521 },
	{ 25, 4870137 },
	{ 24, 3624953 },
	{ 24, 6705145 },
	{ 24, 7557113 },
	{ 25, 10637305 },
	{ 23, 2969593 },
	{ 23, 3690489 },
	{ 23, 2936825 },
	{ 23, 3002361 },
	{ 23, 3772413 },
	{ 25, 11784185 },
	{ 25, 11980793 },
	{ 25, 12046329 },
	{ 25, 15175677 },
	{ 26, 23842809 },
	{ 26, 24039417 },
	{ 26, 24104953 },
	{ 26, 30380029 },
	{ 27, 47960057 },
	{ 27, 64950265 },
	{ 27, 62525433 },
	{ 27, 50008057 },
	{ 27, 46010361 },
	{ 26, 33492985 },
	{ 26, 26893053 },
	{ 26, 14310141 },
	{ 26, 10115837 },
	{ 24, 5921533 },
	{ 24, 1727229 },
	{ 18, 104218 },
	{ 23, 1006329 },
	{ 23, 3037945 },
	{ 25, 4938489 },
	{ 25, 6970105 },
	{ 24, 6773497 },
	{ 24, 7756537 },
	{ 25, 10705657 },
	{ 25, 11688697 },
	{ 23, 3758841 },
	{ 23, 3955449 },
	{ 23, 3726073 },
	{ 23, 3791609 },
	{ 23, 4037373 },
	{ 25, 14932729 },
	{ 25, 15129337 },
	{ 25, 15194873 },
	{ 25, 16227069 },
	{ 26, 30137081 },
	{ 26, 30333689 },
	{ 26, 30399225 },
	{ 26, 32479997 },
	{ 27, 64887545 },
	{ 27, 60758777 },
	{ 27, 49945337 },
	{ 27, 45816569 },
	{ 26, 33430265 },
	{ 26, 29301497 },
	{ 26, 14310397 },
	{ 26, 10116093 },
	{ 24, 5921789 },
	{ 24, 1727485 },
	{ 18, 112410 },
	{ 23, 1006585 },
	{ 23, 3038201 },
	{ 25, 4938745 },
	{ 25, 6970361 },
	{ 24, 6773753 },
	{ 24, 7756793 },
	{ 25, 10705913 },
	{ 25, 11688953 },
	{ 23, 3759097 },
	{ 23, 3955705 },
	{ 23, 3726329 },
	{ 23, 3791865 },
	{ 23, 4037629 },
	{ 25, 14932985 },
	{ 25, 15129593 },
	{ 25, 15195129 },
	{ 25, 16227325 },
	{ 26, 30137337 },
	{ 26, 30333945 },
	{ 26, 30399481 },
	{ 26, 32480253 },
	{ 27, 64887801 },
	{ 27, 60759033 },
	{ 27, 49945593 },
	{ 27, 45816825 },
	{ 26, 33430521 },
	{ 26, 29301753 },
	{ 26, 14376701 },
	{ 26, 10182397 },
	{ 24, 5988093 },
	{ 24, 1793789 },
	{ 18, 120730 },
	{ 24, 1728249 },
	{ 23, 3104505 },
	{ 25, 5136121 },
	{ 25, 7036665 },
	{ 25, 13262585 },
	{ 24, 7823097 },
	{ 25, 10903289 },
	{ 25, 11755257 },
	{ 25, 14835449 },
	{ 23, 4022009 },
	{ 24, 6840057 },
	{ 23, 3989241 },
	{ 23, 4054777 },
	{ 24, 6921981 },
	{ 25, 15982329 },
	{ 25, 16178937 },
	{ 25, 16244473 },
	{ 26, 32169721 },
	{ 26, 32235257 },
	{ 26, 32431865 },
	{ 26, 32497401 },
	{ 27, 64691961 },
	{ 27, 60694265 },
	{ 27, 48176889 },
	{ 27, 45752057 },
	{ 26, 33234681 },
	{ 26, 29236985 },
	{ 26, 16719609 },
	{ 26, 10182653 },
	{ 24, 5988349 },
	{ 24, 1794045 },
	{ 18, 128922 },
	{ 24, 1728505 },
	{ 23, 3104761 },
	{ 25, 5136377 },
	{ 25, 7036921 },
	{ 25, 13262841 },
	{ 24, 7823353 },
	{ 25, 10903545 },
	{ 25, 11755513 },
	{ 25, 14835705 },
	{ 23, 4022265 },
	{ 24, 6840313 },
	{ 23, 3989497 },
	{ 23, 4055033 },
	{ 24, 6922237 },
	{ 25, 15982585 },
	{ 25, 16179193 },
	{ 25, 16244729 },
	{ 26, 32169977 },
	{ 26, 32235513 },
	{ 26, 32432121 },
	{ 26, 32497657 },
	{ 27, 64692217 },
	{ 27, 60694521 },
	{ 27, 48177145 },
	{ 27, 45752313 },
	{ 26, 33234937 },
	{ 26, 29237241 },
	{ 26, 16719865 },
	{ 27, 67100665 },
	{ 26, 24718077 },
	{ 26, 7940861 },
	{ 20, 339226 },
	{ 26, 7154425 },
	{ 26, 23669497 },
	{ 27, 20785913 },
	{ 27, 28912377 },
	{ 27, 53291769 },
	{ 27, 61418233 },
	{ 27, 43854585 },
	{ 27, 47786745 },
	{ 27, 59583225 },
	{ 27, 63515385 },
	{ 26, 27601657 },
	{ 26, 28388089 },
	{ 26, 27470585 },
	{ 26, 27732729 },
	{ 26, 28715773 },
	{ 28, 249047801 },
	{ 28, 245115641 },
	{ 28, 111094521 },
	{ 28, 115223293 },
	{ 29, 230173433 },
	{ 29, 222046969 },
	{ 29, 258484985 },
	{ 29, 241969913 },
	{ 29, 192424697 },
	{ 29, 175909625 },
	{ 28, 132655865 },
	{ 28, 116140793 },
	{ 28, 66595577 },
	{ 28, 50080505 },
	{ 26, 24718333 },
	{ 26, 7941117 },
	{ 20, 355610 },
	{ 26, 7154681 },
	{ 26, 23669753 },
	{ 27, 20786169 },
	{ 27, 28912633 },
	{ 27, 53292025 },
	{ 27, 61418489 },
	{ 27, 43854841 },
	{ 27, 47787001 },
	{ 27, 59583481 },
	{ 27, 63515641 },
	{ 26, 27601913 },
	{ 26, 28388345 },
	{ 26, 27470841 },
	{ 26, 27732985 },
	{ 26, 28716029 },
	{ 28, 249048057 },
	{ 28, 245115897 },
	{ 28, 111094777 },
	{ 28, 115223549 },
	{ 29, 230173689 },
	{ 29, 222047225 },
	{ 29, 258485241 },
	{ 29, 241970169 },
	{ 29, 192424953 },
	{ 29, 175909881 },
	{ 28, 132656121 },
	{ 28, 116141049 },
	{ 28, 66595833 },
	{ 28, 50080761 },
	{ 26, 24981245 },
	{ 26, 8204029 },
	{ 20, 372122 },
	{ 26, 7941881 },
	{ 26, 23932665 },
	{ 28, 40447737 },
	{ 27, 29175545 },
	{ 27, 54079225 },
	{ 27, 61681401 },
	{ 28, 134098681 },
	{ 27, 48049913 },
	{ 27, 60370681 },
	{ 27, 63778553 },
	{ 26, 33435385 },
	{ 26, 16658169 },
	{ 26, 31534841 },
	{ 26, 66334457 },
	{ 26, 28782329 },
	{ 26, 31862525 },
	{ 28, 244854521 },
	{ 28, 131870457 },
	{ 28, 115289849 },
	{ 28, 127807229 },
	{ 29, 221785849 },
	{ 28, 129773305 },
	{ 29, 241708793 },
	{ 29, 191639289 },
	{ 29, 175648505 },
	{ 28, 125579001 },
	{ 28, 115879673 },
	{ 28, 65810169 },
	{ 28, 49819385 },
	{ 26, 33304313 },
	{ 26, 8204285 },
	{ 20, 376810 },
	{ 26, 7942137 },
	{ 26, 23932921 },
	{ 28, 40447993 },
	{ 27, 29175801 },
	{ 27, 54079481 },
	{ 27, 61681657 },
	{ 28, 134098937 },
	{ 27, 48050169 },
	{ 27, 60370937 },
	{ 27, 63778809 },
	{ 26, 33435641 },
	{ 26, 16658425 },
	{ 26, 31535097 },
	{ 26, 66334713 },
	{ 26, 28782585 },
	{ 26, 31862781 },
	{ 28, 244854777 },
	{ 28, 131870713 },
	{ 28, 115290105 },
	{ 28, 127807485 },
	{ 29, 221786105 },
	{ 28, 129773561 },
	{ 29, 241709049 },
	{ 29, 191639545 },
	{ 29, 175648761 },
	{ 28, 125579257 },
	{ 28, 115879929 },
	{ 28, 65810425 },
	{ 28, 49819641 },
	{ 26, 33304569 },
	{ 26, 15284989 },
	{ 20, 393194 },
	{ 26, 8207097 },
	{ 26, 24722169 },
	{ 27, 49348603 },
	{ 28, 57228025 },
	{ 27, 54344441 },
	{ 27, 62470905 },
	{ 28, 86850297 },
	{ 28, 133839609 },
	{ 27, 60635897 },
	{ 27, 64568057 },
	{ 26, 33503997 },
	{ 26, 33176313 },
	{ 26, 16399097 },
	{ 26, 66075385 },
	{ 26, 65288953 },
	{ 26, 31931129 },
	{ 26, 32914173 },
	{ 27, 50266111 },
	{ 28, 127679225 },
	{ 28, 127875833 },
	{ 28, 132004605 },
	{ 28, 129514233 },
	{ 28, 121387769 },
	{ 29, 191380217 },
	{ 29, 174865145 },
	{ 28, 125319929 },
	{ 28, 108804857 },
	{ 28, 65551097 },
	{ 28, 49036025 },
	{ 26, 33045241 },
	{ 26, 16530169 },
	{ 20, 474986 },
	{ 26, 8207353 },
	{ 26, 24722425 },
	{ 27, 49348347 },
	{ 28, 57228281 },
	{ 27, 54344697 },
	{ 27, 62471161 },
	{ 28, 86850553 },
	{ 28, 133839865 },
	{ 27, 60636153 },
	{ 27, 64568313 },
	{ 26, 33504253 },
	{ 26, 33176569 },
	{ 26, 16399353 },
	{ 26, 66075641 },
	{ 26, 65289209 },
	{ 26, 31931385 },
	{ 26, 32914429 },
	{ 27, 50265855 },
	{ 28, 127679481 },
	{ 28, 127876089 },
	{ 28, 132004861 },
	{ 28, 129514489 },
	{ 28, 121388025 },
	{ 29, 191380473 },
	{ 29, 174865401 },
	{ 28, 125320185 },
	{ 28, 108805113 },
	{ 28, 65551353 },
	{ 28, 49036281 },
	{ 26, 33045497 },
	{ 26, 16530425 },
	{ 20, 491370 },
	{ 26, 15286009 },
	{ 26, 24985337 },
	{ 27, 49871867 },
	{ 28, 57491193 },
	{ 28, 107560697 },
	{ 27, 62734073 },
	{ 28, 87637753 },
	{ 28, 95239929 },
	{ 28, 133054201 },
	{ 27, 64831225 },
	{ 28, 65945337 },
	{ 26, 33242877 },
	{ 26, 32390905 },
	{ 26, 15613689 },
	{ 26, 65027833 },
	{ 26, 62144249 },
	{ 26, 32980729 },
	{ 26, 61226749 },
	{ 27, 64420863 },
	{ 28, 115097337 },
	{ 28, 132071161 },
	{ 28, 128728825 },
	{ 28, 121126649 },
	{ 28, 96222969 },
	{ 29, 174604025 },
	{ 28, 124534521 },
	{ 28, 108543737 },
	{ 28, 58474233 },
	{ 28, 48774905 },
	{ 26, 32259833 },
	{ 26, 16269049 },
	{ 20, 507370 },
	{ 26, 15286265 },
	{ 26, 24985593 },
	{ 27, 49871611 },
	{ 28, 57491449 },
	{ 28, 107560953 },
	{ 27, 62734329 },
	{ 28, 87638009 },
	{ 28, 95240185 },
	{ 28, 133054457 },
	{ 27, 64831481 },
	{ 28, 65945593 },
	{ 26, 33243133 },
	{ 26, 32391161 },
	{ 26, 15613945 },
	{ 26, 65028089 },
	{ 26, 62144505 },
	{ 26, 32980985 },
	{ 26, 61227005 },
	{ 27, 64420607 },
	{ 28, 115097593 },
	{ 28, 132071417 },
	{ 28, 128729081 },
	{ 28, 121126905 },
	{ 28, 96223225 },
	{ 29, 174604281 },
	{ 28, 124534777 },
	{ 28, 108543993 },
	{ 28, 58474489 },
	{ 28, 48775161 },
	{ 26, 32260089 },
	{ 26, 16269305 },
	{ 20, 523754 },
	{ 26, 15559417 },
	{ 26, 32074489 },
	{ 27, 64024571 },
	{ 28, 58288889 },
	{ 28, 107834105 },
	{ 28, 124349177 },
	{ 28, 87911161 },
	{ 28, 96037625 },
	{ 28, 120417017 },
	{ 28, 132803321 },
	{ 28, 116026105 },
	{ 28, 65694457 },
	{ 26, 32467709 },
	{ 26, 32140025 },
	{ 26, 15362809 },
	{ 26, 61893369 },
	{ 26, 61106937 },
	{ 26, 61303545 },
	{ 26, 62286589 },
	{ 27, 64942079 },
	{ 28, 110914297 },
	{ 28, 128477945 },
	{ 28, 120351481 },
	{ 28, 95972089 },
	{ 28, 87845625 },
	{ 28, 124283641 },
	{ 28, 107768569 },
	{ 28, 58223353 },
	{ 28, 41708281 },
	{ 26, 32008953 },
	{ 26, 15493881 },
	{ 21, 867690 },
	{ 26, 15559673 },
	{ 26, 32074745 },
	{ 27, 64024315 },
	{ 28, 58289145 },
	{ 28, 107834361 },
	{ 28, 124349433 },
	{ 28, 87911417 },
	{ 28, 96037881 },
	{ 28, 120417273 },
	{ 28, 132803577 },
	{ 28, 116026361 },
	{ 28, 65694713 },
	{ 26, 32467965 },
	{ 26, 32140281 },
	{ 26, 15363065 },
	{ 26, 61893625 },
	{ 26, 61107193 },
	{ 26, 61303801 },
	{ 26, 62286845 },
	{ 27, 64941823 },
	{ 28, 110914553 },
	{ 28, 128478201 },
	{ 28, 120351737 },
	{ 28, 95972345 },
	{ 28, 87845881 },
	{ 28, 124283897 },
	{ 28, 107768825 },
	{ 28, 58223609 },
	{ 28, 41708537 },
	{ 26, 32009209 },
	{ 26, 15494137 },
	{ 21, 884074 },
	{ 26, 16346873 },
	{ 26, 32337657 },
	{ 27, 64547835 },
	{ 28, 58552057 },
	{ 28, 108621561 },
	{ 28, 124612345 },
	{ 29, 259944185 },
	{ 28, 96300793 },
	{ 28, 121204473 },
	{ 28, 128806649 },
	{ 28, 125726457 },
	{ 28, 108949241 },
	{ 28, 58617593 },
	{ 26, 32206589 },
	{ 26, 25063161 },
	{ 26, 8285945 },
	{ 26, 60845817 },
	{ 26, 32796409 },
	{ 26, 62353145 },
	{ 26, 65433341 },
	{ 27, 66513919 },
	{ 27, 64777977 },
	{ 28, 120090361 },
	{ 28, 95186681 },
	{ 28, 87584505 },
	{ 27, 62680825 },
	{ 28, 107507449 },
	{ 28, 57437945 },
	{ 28, 41447161 },
	{ 26, 24932089 },
	{ 26, 15232761 },
	{ 21, 897002 },
	{ 26, 16347129 },
	{ 26, 32337913 },
	{ 27, 64547579 },
	{ 28, 58552313 },
	{ 28, 108621817 },
	{ 28, 124612601 },
	{ 29, 259944441 },
	{ 28, 96301049 },
	{ 28, 121204729 },
	{ 28, 128806905 },
	{ 28, 125726713 },
	{ 28, 108949497 },
	{ 28, 58617849 },
	{ 26, 32206845 },
	{ 26, 25063417 },
	{ 26, 8286201 },
	{ 26, 60846073 },
	{ 26, 32796665 },
	{ 26, 62353401 },
	{ 26, 65433597 },
	{ 27, 66513663 },
	{ 27, 64778233 },
	{ 28, 120090617 },
	{ 28, 95186937 },
	{ 28, 87584761 },
	{ 27, 62681081 },
	{ 28, 107507705 },
	{ 28, 57438201 },
	{ 28, 41447417 },
	{ 26, 24932345 },
	{ 26, 15233017 },
	{ 21, 913386 },
	{ 21, 2097006 },
	{ 26, 33127161 },
	{ 27, 66109435 },
	{ 28, 65633017 },
	{ 28, 108886777 },
	{ 28, 125401849 },
	{ 29, 174947065 },
	{ 29, 259685113 },
	{ 28, 121469689 },
	{ 28, 129596153 },
	{ 28, 125795069 },
	{ 28, 125467385 },
	{ 28, 108690169 },
	{ 28, 58358521 },
	{ 26, 25131773 },
	{ 26, 24804089 },
	{ 26, 8026873 },
	{ 26, 32537337 },
	{ 26, 31750905 },
	{ 26, 65501945 },
	{ 26, 66484989 },
	{ 27, 64518905 },
	{ 27, 60586745 },
	{ 28, 94927609 },
	{ 28, 86801145 },
	{ 27, 62421753 },
	{ 27, 54295289 },
	{ 28, 57178873 },
	{ 28, 40663801 },
	{ 26, 24673017 },
	{ 26, 8157945 },
	{ 21, 995178 },
	{ 21, 2080622 },
	{ 26, 33127417 },
	{ 27, 66109179 },
	{ 28, 65633273 },
	{ 28, 108887033 },
	{ 28, 125402105 },
	{ 29, 174947321 },
	{ 29, 259685369 },
	{ 28, 121469945 },
	{ 28, 129596409 },
	{ 28, 125795325 },
	{ 28, 125467641 },
	{ 28, 108690425 },
	{ 28, 58358777 },
	{ 26, 25132029 },
	{ 26, 24804345 },
	{ 26, 8027129 },
	{ 26, 32537593 },
	{ 26, 31751161 },
	{ 26, 65502201 },
	{ 26, 66485245 },
	{ 27, 64519161 },
	{ 27, 60587001 },
	{ 28, 94927865 },
	{ 28, 86801401 },
	{ 27, 62422009 },
	{ 27, 54295545 },
	{ 28, 57179129 },
	{ 28, 40664057 },
	{ 26, 24673273 },
	{ 26, 8158201 },
	{ 21, 1011562 },
	{ 21, 2064366 },
	{ 26, 33390329 },
	{ 27, 66632699 },
	{ 28, 65896185 },
	{ 28, 115965689 },
	{ 28, 125665017 },
	{ 29, 175734521 },
	{ 29, 191725305 },
	{ 29, 258899705 },
	{ 28, 129859321 },
	{ 29, 191790841 },
	{ 28, 125533949 },
	{ 28, 124681977 },
	{ 28, 107904761 },
	{ 28, 57573113 },
	{ 26, 24870653 },
	{ 26, 24018681 },
	{ 26, 7241465 },
	{ 26, 31489785 },
	{ 26, 28606201 },
	{ 26, 66551545 },
	{ 27, 63733497 },
	{ 27, 60325625 },
	{ 27, 48004857 },
	{ 28, 86540025 },
	{ 27, 61636345 },
	{ 27, 54034169 },
	{ 27, 29130489 },
	{ 28, 40402681 },
	{ 26, 23887609 },
	{ 26, 7896825 },
	{ 21, 1027562 },
	{ 21, 2047982 },
	{ 26, 33390585 },
	{ 27, 66632443 },
	{ 28, 65896441 },
	{ 28, 115965945 },
	{ 28, 125665273 },
	{ 29, 175734777 },
	{ 29, 191725561 },
	{ 29, 258899961 },
	{ 28, 129859577 },
	{ 29, 191791097 },
	{ 28, 125534205 },
	{ 28, 124682233 },
	{ 28, 107905017 },
	{ 28, 57573369 },
	{ 26, 24870909 },
	{ 26, 24018937 },
	{ 26, 7241721 },
	{ 26, 31490041 },
	{ 26, 28606457 },
	{ 26, 66551801 },
	{ 27, 63733753 },
	{ 27, 60325881 },
	{ 27, 48005113 },
	{ 28, 86540281 },
	{ 27, 61636601 },
	{ 27, 54034425 },
	{ 27, 29130745 },
	{ 28, 40402937 },
	{ 26, 23887865 },
	{ 26, 7897081 },
	{ 21, 1043946 },
	{ 21, 2043294 },
	{ 26, 24936445 },
	{ 27, 49986303 },
	{ 28, 58490877 },
	{ 28, 108822525 },
	{ 28, 125599741 },
	{ 29, 175931389 },
	{ 29, 192708605 },
	{ 29, 243040253 },
	{ 29, 259817469 },
	{ 30, 483699449 },
	{ 30, 383036153 },
	{ 29, 249473789 },
	{ 29, 248818425 },
	{ 29, 215263993 },
	{ 29, 114600697 },
	{ 27, 48147197 },
	{ 27, 47491833 },
	{ 27, 13937401 },
	{ 27, 56666873 },
	{ 27, 55094009 },
	{ 27, 55226363 },
	{ 28, 119057145 },
	{ 28, 95464185 },
	{ 28, 87599865 },
	{ 28, 122727161 },
	{ 28, 106474233 },
	{ 28, 57715449 },
	{ 28, 41462521 },
	{ 27, 47229689 },
	{ 27, 14199545 },
	{ 21, 1912170 },
	{ 21, 1961246 },
	{ 27, 49326845 },
	{ 27, 49459199 },
	{ 29, 133344249 },
	{ 29, 232434681 },
	{ 29, 265464825 },
	{ 29, 265334523 },
	{ 30, 385002489 },
	{ 30, 484092921 },
	{ 30, 517254137 },
	{ 30, 483699705 },
	{ 30, 383036409 },
	{ 29, 249474045 },
	{ 29, 248818681 },
	{ 29, 215264249 },
	{ 29, 114600953 },
	{ 27, 48147453 },
	{ 27, 47492089 },
	{ 27, 13937657 },
	{ 27, 56667129 },
	{ 27, 55094265 },
	{ 27, 55226107 },
	{ 28, 119057401 },
	{ 28, 95464441 },
	{ 28, 87600121 },
	{ 28, 122727417 },
	{ 28, 106474489 },
	{ 28, 57715705 },
	{ 28, 41462777 },
	{ 27, 47229945 },
	{ 27, 14199801 },
	{ 21, 1928554 },
	{ 21, 1944862 },
	{ 27, 49327101 },
	{ 27, 49458943 },
	{ 29, 133869305 },
	{ 29, 234008313 },
	{ 29, 265989881 },
	{ 29, 265858043 },
	{ 30, 511487737 },
	{ 30, 461156089 },
	{ 30, 444378873 },
	{ 29, 259829497 },
	{ 29, 243052281 },
	{ 29, 192720633 },
	{ 29, 175943417 },
	{ 28, 125611769 },
	{ 28, 108834553 },
	{ 28, 58502905 },
	{ 27, 47623933 },
	{ 26, 24948473 },
	{ 26, 8171257 },
	{ 26, 31894523 },
	{ 26, 32026361 },
	{ 26, 32156667 },
	{ 28, 93892345 },
	{ 28, 87076601 },
	{ 27, 62435065 },
	{ 27, 62565371 },
	{ 28, 56143609 },
	{ 28, 40939257 },
	{ 26, 24686329 },
	{ 26, 24816635 },
	{ 20, 972778 },
	{ 20, 964510 },
	{ 27, 47755005 },
	{ 27, 47885311 },
	{ 29, 133869561 },
	{ 29, 234008569 },
	{ 29, 265990137 },
	{ 29, 265857787 },
	{ 30, 511487993 },
	{ 30, 461156345 },
	{ 30, 444379129 },
	{ 29, 259829753 },
	{ 29, 243052537 },
	{ 29, 192720889 },
	{ 29, 175943673 },
	{ 28, 125612025 },
	{ 28, 108834809 },
	{ 28, 58503161 },
	{ 27, 47624189 },
	{ 26, 24948729 },
	{ 26, 8171513 },
	{ 26, 31894267 },
	{ 26, 32026617 },
	{ 26, 32156411 },
	{ 28, 93892601 },
	{ 28, 87076857 },
	{ 27, 62435321 },
	{ 27, 62565115 },
	{ 28, 56143865 },
	{ 28, 40939513 },
	{ 26, 24686585 },
	{ 26, 24816379 },
	{ 20, 980970 },
	{ 20, 956318 },
	{ 27, 47755261 },
	{ 27, 47885055 },
	{ 29, 114864125 },
	{ 29, 234535673 },
	{ 28, 117211131 },
	{ 28, 133726203 },
	{ 29, 183271419 },
	{ 29, 199786491 },
	{ 29, 243040251 },
	{ 29, 259963645 },
	{ 28, 129925119 },
	{ 28, 121602043 },
	{ 28, 121339899 },
	{ 28, 125745917 },
	{ 27, 64913407 },
	{ 27, 60784635 },
	{ 27, 60522491 },
	{ 26, 25082621 },
	{ 25, 16154623 },
	{ 25, 15171579 },
	{ 25, 14909435 },
	{ 25, 15826939 },
	{ 25, 15040507 },
	{ 27, 46759931 },
	{ 27, 61913849 },
	{ 26, 31031291 },
	{ 26, 27099131 },
	{ 27, 27885563 },
	{ 26, 24165113 },
	{ 25, 12156923 },
	{ 20, 1021802 },
	{ 20, 522014 },
	{ 26, 6914047 },
	{ 26, 23691263 },
	{ 28, 40468479 },
	{ 28, 57245695 },
	{ 28, 117210875 },
	{ 28, 133725947 },
	{ 29, 183271163 },
	{ 29, 199786235 },
	{ 29, 243039995 },
	{ 29, 259963901 },
	{ 28, 129924863 },
	{ 28, 121601787 },
	{ 28, 121339643 },
	{ 28, 125746173 },
	{ 27, 64913151 },
	{ 27, 60784379 },
	{ 27, 60522235 },
	{ 26, 25082877 },
	{ 25, 16154367 },
	{ 25, 15171323 },
	{ 25, 14909179 },
	{ 25, 15826683 },
	{ 25, 15040251 },
	{ 27, 46759675 },
	{ 27, 61914105 },
	{ 26, 31031035 },
	{ 26, 27098875 },
	{ 27, 27885307 },
	{ 26, 24165369 },
	{ 25, 12156667 },
	{ 20, 1029994 },
	{ 20, 513822 },
	{ 26, 6913791 },
	{ 26, 23691007 },
	{ 28, 40468223 },
	{ 28, 57245439 },
	{ 28, 107577087 },
	{ 28, 133987323 },
	{ 29, 184056827 },
	{ 29, 200047611 },
	{ 29, 250117115 },
	{ 29, 259816443 },
	{ 29, 259440381 },
	{ 28, 121535487 },
	{ 28, 96435195 },
	{ 28, 96173051 },
	{ 28, 125222653 },
	{ 27, 60718079 },
	{ 27, 48200699 },
	{ 27, 47938555 },
	{ 26, 24559357 },
	{ 25, 15105023 },
	{ 25, 12024827 },
	{ 25, 11762683 },
	{ 25, 14777339 },
	{ 25, 11893755 },
	{ 27, 60342009 },
	{ 26, 30243835 },
	{ 26, 26835963 },
	{ 26, 14515195 },
	{ 26, 22593273 },
	{ 25, 11369467 },
	{ 20, 1037802 },
	{ 20, 505246 },
	{ 25, 4029439 },
	{ 25, 12418047 },
	{ 27, 20806655 },
	{ 27, 29195263 },
	{ 27, 54361087 },
	{ 27, 62749695 },
	{ 28, 87915519 },
	{ 28, 96304127 },
	{ 28, 121469951 },
	{ 28, 129858559 },
	{ 29, 259440637 },
	{ 28, 121535231 },
	{ 28, 96434939 },
	{ 28, 96172795 },
	{ 28, 125222909 },
	{ 27, 60717823 },
	{ 27, 48200443 },
	{ 27, 47938299 },
	{ 26, 24559613 },
	{ 25, 15104767 },
	{ 25, 12024571 },
	{ 25, 11762427 },
	{ 25, 14777083 },
	{ 25, 11893499 },
	{ 27, 60342265 },
	{ 26, 30243579 },
	{ 26, 26835707 },
	{ 26, 14514939 },
	{ 26, 22593529 },
	{ 25, 11369211 },
	{ 20, 1045994 },
	{ 20, 497054 },
	{ 25, 4029183 },
	{ 25, 12417791 },
	{ 27, 20806399 },
	{ 27, 29195007 },
	{ 27, 54360831 },
	{ 27, 62749439 },
	{ 28, 87915263 },
	{ 28, 96303871 },
	{ 28, 121469695 },
	{ 28, 129858303 },
	{ 29, 175861755 },
	{ 29, 257878781 },
	{ 28, 96366591 },
	{ 28, 88043515 },
	{ 28, 87781371 },
	{ 28, 123661053 },
	{ 27, 48132095 },
	{ 27, 44003323 },
	{ 27, 43741179 },
	{ 26, 22997757 },
	{ 25, 11956223 },
	{ 25, 10973179 },
	{ 25, 10711035 },
	{ 25, 11628539 },
	{ 25, 10842107 },
	{ 26, 29978619 },
	{ 26, 26046459 },
	{ 26, 14249979 },
	{ 26, 22080249 },
	{ 25, 11104251 },
	{ 25, 2977787 },
	{ 20, 455966 },
	{ 25, 3764223 },
	{ 25, 12152831 },
	{ 27, 20541439 },
	{ 27, 28930047 },
	{ 27, 54095871 },
	{ 27, 62484479 },
	{ 28, 87650303 },
	{ 28, 96038911 },
	{ 28, 121204735 },
	{ 28, 129593343 },
	{ 29, 175861499 },
	{ 29, 257879037 },
	{ 28, 96366335 },
	{ 28, 88043259 },
	{ 28, 87781115 },
	{ 28, 123661309 },
	{ 27, 48131839 },
	{ 27, 44003067 },
	{ 27, 43740923 },
	{ 26, 22998013 },
	{ 25, 11955967 },
	{ 25, 10972923 },
	{ 25, 10710779 },
	{ 25, 11628283 },
	{ 25, 10841851 },
	{ 26, 29978363 },
	{ 26, 26046203 },
	{ 26, 14249723 },
	{ 26, 22080505 },
	{ 25, 11103995 },
	{ 25, 2977531 },
	{ 20, 447774 },
	{ 25, 3763967 },
	{ 25, 12152575 },
	{ 27, 20541183 },
	{ 27, 28929791 },
	{ 27, 54095615 },
	{ 27, 62484223 },
	{ 28, 134179835 },
	{ 28, 133917691 },
	{ 28, 133131259 },
	{ 28, 132869115 },
	{ 28, 125791227 },
	{ 28, 125529083 },
	{ 28, 124742651 },
	{ 28, 129822457 },
	{ 27, 62876667 },
	{ 27, 62614523 },
	{ 27, 61828091 },
	{ 27, 62713593 },
	{ 26, 31419387 },
	{ 26, 31157243 },
	{ 26, 22474493 },
	{ 25, 12381945 },
	{ 24, 7826427 },
	{ 24, 7564283 },
	{ 25, 15265529 },
	{ 24, 7695355 },
	{ 26, 25783291 },
	{ 26, 13462523 },
	{ 25, 12119801 },
	{ 24, 6122491 },
	{ 25, 2714619 },
	{ 19, 220062 },
	{ 25, 2976767 },
	{ 25, 11365375 },
	{ 27, 19753983 },
	{ 27, 28142591 },
	{ 27, 53308415 },
	{ 27, 61697023 },
	{ 28, 134179579 },
	{ 28, 133917435 },
	{ 28, 133131003 },
	{ 28, 132868859 },
	{ 28, 125790971 },
	{ 28, 125528827 },
	{ 28, 124742395 },
	{ 28, 129822713 },
	{ 27, 62876411 },
	{ 27, 62614267 },
	{ 27, 61827835 },
	{ 27, 62713849 },
	{ 26, 31419131 },
	{ 26, 31156987 },
	{ 26, 22474749 },
	{ 25, 12382201 },
	{ 24, 7826171 },
	{ 24, 7564027 },
	{ 25, 15265785 },
	{ 24, 7695099 },
	{ 26, 25783035 },
	{ 26, 13462267 },
	{ 25, 12120057 },
	{ 24, 6122235 },
	{ 25, 2714363 },
	{ 19, 215966 },
	{ 25, 2976511 },
	{ 25, 11365119 },
	{ 27, 19753727 },
	{ 27, 28142335 },
	{ 27, 53308159 },
	{ 27, 61696767 },
	{ 28, 86862591 },
	{ 28, 117391355 },
	{ 28, 117129211 },
	{ 28, 116342779 },
	{ 28, 116080635 },
	{ 28, 109002747 },
	{ 28, 108740603 },
	{ 28, 129956605 },
	{ 27, 62799871 },
	{ 27, 54476795 },
	{ 27, 54214651 },
	{ 27, 62847741 },
	{ 26, 31342591 },
	{ 26, 27213819 },
	{ 26, 26951675 },
	{ 25, 12516093 },
	{ 24, 7749631 },
	{ 24, 6766587 },
	{ 24, 6504443 },
	{ 24, 7421947 },
	{ 24, 6635515 },
	{ 26, 13189115 },
	{ 25, 11598585 },
	{ 24, 5849083 },
	{ 24, 1916923 },
	{ 18, 129822 },
	{ 25, 2703359 },
	{ 25, 11091967 },
	{ 27, 19480575 },
	{ 27, 27869183 },
	{ 27, 53035007 },
	{ 27, 61423615 },
	{ 28, 134102783 },
	{ 28, 117391099 },
	{ 28, 117128955 },
	{ 28, 116342523 },
	{ 28, 116080379 },
	{ 28, 109002491 },
	{ 28, 108740347 },
	{ 28, 129956861 },
	{ 27, 62799615 },
	{ 27, 54476539 },
	{ 27, 54214395 },
	{ 27, 62847997 },
	{ 26, 31342335 },
	{ 26, 27213563 },
	{ 26, 26951419 },
	{ 25, 12516349 },
	{ 24, 7749375 },
	{ 24, 6766331 },
	{ 24, 6504187 },
	{ 24, 7421691 },
	{ 24, 6635259 },
	{ 26, 13188859 },
	{ 25, 11598841 },
	{ 24, 5848827 },
	{ 24, 1916667 },
	{ 18, 125726 },
	{ 25, 2703103 },
	{ 25, 11091711 },
	{ 27, 19480319 },
	{ 27, 27868927 },
	{ 27, 53034751 },
	{ 27, 61423359 },
	{ 28, 86589183 },
	{ 28, 94977791 },
	{ 28, 67058683 },
	{ 28, 66796539 },
	{ 28, 66010107 },
	{ 28, 65747963 },
	{ 28, 58670075 },
	{ 28, 58407931 },
	{ 28, 129433341 },
	{ 27, 54410239 },
	{ 27, 29309947 },
	{ 27, 29047803 },
	{ 27, 62324477 },
	{ 26, 27147263 },
	{ 26, 14629883 },
	{ 26, 14367739 },
	{ 25, 11992829 },
	{ 24, 6700031 },
	{ 24, 3619835 },
	{ 24, 3357691 },
	{ 24, 6372347 },
	{ 24, 3488763 },
	{ 25, 10026745 },
	{ 24, 5061627 },
	{ 24, 1653755 },
	{ 18, 121246 },
	{ 24, 1915903 },
	{ 24, 6110207 },
	{ 26, 10304511 },
	{ 26, 14498815 },
	{ 26, 27081727 },
	{ 26, 31276031 },
	{ 27, 43858943 },
	{ 27, 48053247 },
	{ 27, 60636159 },
	{ 27, 64830463 },
	{ 28, 66009851 },
	{ 28, 65747707 },
	{ 28, 58669819 },
	{ 28, 58407675 },
	{ 28, 129433597 },
	{ 27, 54409983 },
	{ 27, 29309691 },
	{ 27, 29047547 },
	{ 27, 62324733 },
	{ 26, 27147007 },
	{ 26, 14629627 },
	{ 26, 14367483 },
	{ 25, 11993085 },
	{ 24, 6699775 },
	{ 24, 3619579 },
	{ 24, 3357435 },
	{ 24, 6372091 },
	{ 24, 3488507 },
	{ 25, 10027001 },
	{ 24, 5061371 },
	{ 24, 1653499 },
	{ 18, 117150 },
	{ 24, 1915647 },
	{ 24, 6109951 },
	{ 26, 10304255 },
	{ 26, 14498559 },
	{ 26, 27081471 },
	{ 26, 31275775 },
	{ 27, 43858687 },
	{ 27, 48052991 },
	{ 27, 60635903 },
	{ 27, 64830207 },
	{ 28, 50016251 },
	{ 28, 49229819 },
	{ 28, 48967675 },
	{ 28, 41889787 },
	{ 28, 41627643 },
	{ 28, 40841211 },
	{ 27, 29241343 },
	{ 27, 20918267 },
	{ 27, 20656123 },
	{ 27, 19869691 },
	{ 26, 14561279 },
	{ 26, 10432507 },
	{ 26, 10170363 },
	{ 26, 20818685 },
	{ 24, 3551231 },
	{ 24, 2568187 },
	{ 24, 2306043 },
	{ 24, 3223547 },
	{ 24, 2437115 },
	{ 24, 4796411 },
	{ 24, 864251 },
	{ 18, 96542 },
	{ 24, 1650687 },
	{ 24, 5844991 },
	{ 26, 10039295 },
	{ 26, 14233599 },
	{ 26, 26816511 },
	{ 26, 31010815 },
	{ 27, 43593727 },
	{ 27, 47788031 },
	{ 27, 60370943 },
	{ 27, 64565247 },
	{ 28, 50015995 },
	{ 28, 49229563 },
	{ 28, 48967419 },
	{ 28, 41889531 },
	{ 28, 41627387 },
	{ 28, 40840955 },
	{ 27, 29241087 },
	{ 27, 20918011 },
	{ 27, 20655867 },
	{ 27, 19869435 },
	{ 26, 14561023 },
	{ 26, 10432251 },
	{ 26, 10170107 },
	{ 26, 20818941 },
	{ 24, 3550975 },
	{ 24, 2567931 },
	{ 24, 2305787 },
	{ 24, 3223291 },
	{ 24, 2436859 },
	{ 24, 4796155 },
	{ 24, 863995 },
	{ 18, 92446 },
	{ 24, 1650431 },
	{ 24, 5844735 },
	{ 26, 10039039 },
	{ 26, 14233343 },
	{ 26, 26816255 },
	{ 26, 31010559 },
	{ 27, 43593471 },
	{ 27, 47787775 },
	{ 27, 60370687 },
	{ 27, 64564991 },
	{ 26, 33500155 },
	{ 26, 33238011 },
	{ 26, 32451579 },
	{ 26, 32189435 },
	{ 26, 25111547 },
	{ 26, 24849403 },
	{ 26, 24062971 },
	{ 26, 23800827 },
	{ 25, 12528635 },
	{ 25, 12266491 },
	{ 25, 11480059 },
	{ 25, 11217915 },
	{ 24, 6237179 },
	{ 24, 5975035 },
	{ 24, 5188603 },
	{ 24, 5877497 },
	{ 22, 1518587 },
	{ 22, 1256443 },
	{ 24, 5353209 },
	{ 22, 1387515 },
	{ 24, 601083 },
	{ 16, 22174 },
	{ 24, 863231 },
	{ 24, 5057535 },
	{ 26, 9251839 },
	{ 26, 13446143 },
	{ 26, 26029055 },
	{ 26, 30223359 },
	{ 27, 42806271 },
	{ 27, 47000575 },
	{ 27, 59583487 },
	{ 27, 63777791 },
	{ 26, 33499899 },
	{ 26, 33237755 },
	{ 26, 32451323 },
	{ 26, 32189179 },
	{ 26, 25111291 },
	{ 26, 24849147 },
	{ 26, 24062715 },
	{ 26, 23800571 },
	{ 25, 12528379 },
	{ 25, 12266235 },
	{ 25, 11479803 },
	{ 25, 11217659 },
	{ 24, 6236923 },
	{ 24, 5974779 },
	{ 24, 5188347 },
	{ 24, 5877753 },
	{ 22, 1518331 },
	{ 22, 1256187 },
	{ 24, 5353465 },
	{ 22, 1387259 },
	{ 24, 600827 },
	{ 16, 21150 },
	{ 24, 862975 },
	{ 24, 5057279 },
	{ 26, 9251583 },
	{ 26, 13445887 },
	{ 26, 26028799 },
	{ 26, 30223103 },
	{ 27, 42806015 },
	{ 27, 47000319 },
	{ 27, 59583231 },
	{ 27, 63777535 },
	{ 24, 8364031 },
	{ 24, 4186107 },
	{ 24, 4120571 },
	{ 24, 3923963 },
	{ 24, 3858427 },
	{ 24, 2088955 },
	{ 24, 2023419 },
	{ 24, 1826811 },
	{ 23, 3121151 },
	{ 23, 1040379 },
	{ 23, 974843 },
	{ 23, 778235 },
	{ 22, 1548287 },
	{ 22, 516091 },
	{ 22, 450555 },
	{ 22, 253947 },
	{ 20, 368639 },
	{ 20, 122875 },
	{ 20, 57339 },
	{ 16, 32635 },
	{ 17, 65467 },
	{ 15, 15902 },
	{ 22, 155647 },
	{ 22, 1204223 },
	{ 24, 2252799 },
	{ 24, 3301375 },
	{ 24, 6447103 },
	{ 24, 7495679 },
	{ 25, 10641407 },
	{ 25, 11689983 },
	{ 25, 14835711 },
	{ 25, 15884287 },
	{ 24, 8363775 },
	{ 24, 4185851 },
	{ 24, 4120315 },
	{ 24, 3923707 },
	{ 24, 3858171 },
	{ 24, 2088699 },
	{ 24, 2023163 },
	{ 24, 1826555 },
	{ 23, 3120895 },
	{ 23, 1040123 },
	{ 23, 974587 },
	{ 23, 777979 },
	{ 22, 1548031 },
	{ 22, 515835 },
	{ 22, 450299 },
	{ 22, 253691 },
	{ 20, 368383 },
	{ 20, 122619 },
	{ 20, 57083 },
	{ 16, 30587 },
	{ 16, 32379 },
	{ 15, 14878 },
	{ 22, 155391 },
	{ 22, 1203967 },
	{ 24, 2252543 },
	{ 24, 3301119 },
	{ 24, 6446847 },
	{ 24, 7495423 },
	{ 25, 10641151 },
	{ 25, 11689727 },
	{ 25, 14835455 },
	{ 25, 15884031 },
	{ 26, 27418367 },
	{ 24, 4168703 },
	{ 24, 4103167 },
	{ 24, 3906559 },
	{ 24, 3841023 },
	{ 24, 2071551 },
	{ 24, 2006015 },
	{ 24, 1809407 },
	{ 24, 1743871 },
	{ 23, 1022975 },
	{ 23, 957439 },
	{ 23, 760831 },
	{ 23, 695295 },
	{ 22, 498687 },
	{ 22, 433151 },
	{ 22, 236543 },
	{ 22, 171007 },
	{ 20, 105471 },
	{ 20, 39935 },
	{ 14, 7999 },
	{ 14, 8043 },
	{ 14, 7998 },
	{ 16, 32703 },
	{ 20, 351231 },
	{ 22, 613375 },
	{ 22, 875519 },
	{ 22, 1661951 },
	{ 22, 1924095 },
	{ 23, 2710527 },
	{ 23, 2972671 },
	{ 23, 3759103 },
	{ 23, 4021247 },
	{ 24, 6904831 },
	{ 24, 4168447 },
	{ 24, 4102911 },
	{ 24, 3906303 },
	{ 24, 3840767 },
	{ 24, 2071295 },
	{ 24, 2005759 },
	{ 24, 1809151 },
	{ 24, 1743615 },
	{ 23, 1022719 },
	{ 23, 957183 },
	{ 23, 760575 },
	{ 23, 695039 },
	{ 22, 498431 },
	{ 22, 432895 },
	{ 22, 236287 },
	{ 22, 170751 },
	{ 20, 105215 },
	{ 20, 39679 },
	{ 14, 8175 },
	{ 11, 987 },
	{ 12, 718 },
	{ 15, 15999 },
	{ 20, 350975 },
	{ 22, 613119 },
	{ 22, 875263 },
	{ 22, 1661695 },
	{ 22, 1923839 },
	{ 23, 2710271 },
	{ 23, 2972415 },
	{ 23, 3758847 },
	{ 23, 4020991 },
	{ 24, 6904575 },
	{ 24, 7166719 },
	{ 24, 7953151 },
	{ 24, 8215295 },
	{ 24, 15293183 },
	{ 24, 15555327 },
	{ 24, 16341759 },
	{ 24, 16603903 },
	{ 24, 7868415 },
	{ 24, 7081983 },
	{ 24, 6819839 },
	{ 23, 3936255 },
	{ 23, 3674111 },
	{ 23, 2887679 },
	{ 23, 2625535 },
	{ 22, 1839103 },
	{ 22, 1576959 },
	{ 22, 790527 },
	{ 22, 528383 },
	{ 16, 15743 },
	{ 10, 463 },
	{ 12, 654 },
	{ 13, 3951 },
	{ 16, 16255 },
	{ 22, 544767 },
	{ 22, 806911 },
	{ 22, 1593343 },
	{ 22, 1855487 },
	{ 23, 2641919 },
	{ 23, 2904063 },
	{ 23, 3690495 },
	{ 23, 3952639 },
	{ 24, 6836223 },
	{ 24, 7098367 },
	{ 24, 7884799 },
	{ 24, 16518911 },
	{ 24, 16256767 },
	{ 24, 15470335 },
	{ 24, 15208191 },
	{ 24, 8130303 },
	{ 24, 7868159 },
	{ 24, 7081727 },
	{ 24, 6819583 },
	{ 23, 3935999 },
	{ 23, 3673855 },
	{ 23, 2887423 },
	{ 23, 2625279 },
	{ 22, 1838847 },
	{ 22, 1576703 },
	{ 22, 790271 },
	{ 22, 528127 },
	{ 16, 13695 },
	{ 11, 943 },
	{ 24, 125949 },
	{ 10, 479 },
	{ 16, 14207 },
	{ 22, 544511 },
	{ 22, 806655 },
	{ 22, 1593087 },
	{ 22, 1855231 },
	{ 23, 2641663 },
	{ 23, 2903807 },
	{ 23, 3690239 },
	{ 23, 3952383 },
	{ 24, 6835967 },
	{ 24, 7098111 },
	{ 24, 7884543 },
	{ 24, 8146687 },
	{ 24, 15224575 },
	{ 24, 15486719 },
	{ 24, 16273151 },
	{ 24, 16535295 },
	{ 24, 7932927 },
	{ 24, 7146495 },
	{ 24, 6884351 },
	{ 23, 4000767 },
	{ 23, 3738623 },
	{ 23, 2952191 },
	{ 23, 2690047 },
	{ 22, 1903615 },
	{ 22, 1641471 },
	{ 22, 855039 },
	{ 22, 592895 },
	{ 20, 330751 },
	{ 13, 3775 },
	{ 11, 990 },
	{ 9, 203 },
	{ 12, 1851 },
	{ 20, 52223 },
	{ 20, 314367 },
	{ 22, 576511 },
	{ 22, 838655 },
	{ 22, 1625087 },
	{ 22, 1887231 },
	{ 23, 2673663 },
	{ 23, 2935807 },
	{ 23, 3722239 },
	{ 23, 3984383 },
	{ 24, 6867967 },
	{ 24, 16583423 },
	{ 24, 16321279 },
	{ 24, 15534847 },
	{ 24, 15272703 },
	{ 24, 8194815 },
	{ 24, 7932671 },
	{ 24, 7146239 },
	{ 24, 6884095 },
	{ 23, 4000511 },
	{ 23, 3738367 },
	{ 23, 2951935 },
	{ 23, 2689791 },
	{ 22, 1903359 },
	{ 22, 1641215 },
	{ 22, 854783 },
	{ 22, 592639 },
	{ 20, 330495 },
	{ 14, 7615 },
	{ 11, 862 },
	{ 10, 427 },
	{ 12, 2027 },
	{ 20, 51967 },
	{ 20, 314111 },
	{ 22, 576255 },
	{ 22, 838399 },
	{ 22, 1624831 },
	{ 22, 1886975 },
	{ 23, 2673407 },
	{ 23, 2935551 },
	{ 23, 3721983 },
	{ 23, 3984127 },
	{ 24, 6867711 },
	{ 24, 7129855 },
	{ 24, 7916287 },
	{ 24, 8178431 },
	{ 24, 15256319 },
	{ 24, 15518463 },
	{ 24, 16304895 },
	{ 24, 16567039 },
	{ 24, 6850559 },
	{ 23, 3966975 },
	{ 23, 3704831 },
	{ 23, 2918399 },
	{ 23, 2656255 },
	{ 22, 1869823 },
	{ 22, 1607679 },
	{ 22, 821247 },
	{ 22, 559103 },
	{ 20, 296959 },
	{ 20, 34815 },
	{ 13, 3694 },
	{ 12, 1723 },
	{ 14, 7547 },
	{ 18, 10235 },
	{ 18, 75771 },
	{ 18, 96255 },
	{ 20, 206843 },
	{ 20, 403451 },
	{ 20, 468987 },
	{ 20, 489471 },
	{ 21, 731131 },
	{ 21, 927739 },
	{ 21, 993275 },
	{ 21, 1013759 },
	{ 22, 1779707 },
	{ 22, 1976315 },
	{ 22, 2041851 },
	{ 22, 3811323 },
	{ 22, 3876859 },
	{ 22, 4073467 },
	{ 22, 4139003 },
	{ 22, 4159487 },
	{ 23, 3966719 },
	{ 23, 3704575 },
	{ 23, 2918143 },
	{ 23, 2655999 },
	{ 22, 1869567 },
	{ 22, 1607423 },
	{ 22, 820991 },
	{ 22, 558847 },
	{ 20, 296703 },
	{ 20, 34559 },
	{ 13, 2670 },
	{ 13, 3515 },
	{ 14, 5499 },
	{ 18, 9979 },
	{ 18, 75515 },
	{ 18, 95999 },
	{ 20, 206587 },
	{ 20, 403195 },
	{ 20, 468731 },
	{ 20, 489215 },
	{ 21, 730875 },
	{ 21, 927483 },
	{ 21, 993019 },
	{ 21, 1013503 },
	{ 22, 1779451 },
	{ 22, 1976059 },
	{ 22, 2041595 },
	{ 22, 3811067 },
	{ 22, 3876603 },
	{ 22, 4073211 },
	{ 22, 4138747 },
	{ 22, 4159231 },
	{ 23, 3982335 },
	{ 23, 3720191 },
	{ 23, 2933759 },
	{ 23, 2671615 },
	{ 22, 1885183 },
	{ 22, 1623039 },
	{ 22, 836607 },
	{ 22, 574463 },
	{ 20, 312319 },
	{ 20, 50175 },
	{ 13, 1774 },
	{ 20, 33787 },
	{ 18, 82939 },
	{ 20, 132091 },
	{ 18, 25595 },
	{ 18, 91131 },
	{ 20, 156667 },
	{ 20, 222203 },
	{ 20, 418811 },
	{ 20, 484347 },
	{ 21, 680955 },
	{ 21, 746491 },
	{ 21, 943099 },
	{ 21, 1008635 },
	{ 22, 1729531 },
	{ 22, 1795067 },
	{ 22, 1991675 },
	{ 22, 2057211 },
	{ 22, 3826683 },
	{ 22, 3892219 },
	{ 22, 4088827 },
	{ 22, 4154363 },
	{ 23, 3982079 },
	{ 23, 3719935 },
	{ 23, 2933503 },
	{ 23, 2671359 },
	{ 22, 1884927 },
	{ 22, 1622783 },
	{ 22, 836351 },
	{ 22, 574207 },
	{ 20, 312063 },
	{ 20, 49919 },
	{ 13, 750 },
	{ 20, 33531 },
	{ 18, 82683 },
	{ 20, 131835 },
	{ 18, 25339 },
	{ 18, 90875 },
	{ 20, 156411 },
	{ 20, 221947 },
	{ 20, 418555 },
	{ 20, 484091 },
	{ 21, 680699 },
	{ 21, 746235 },
	{ 21, 942843 },
	{ 21, 1008379 },
	{ 22, 1729275 },
	{ 22, 1794811 },
	{ 22, 1991419 },
	{ 22, 2056955 },
	{ 22, 3826427 },
	{ 22, 3891963 },
	{ 22, 4088571 },
	{ 22, 4154107 },
	{ 21, 1008127 },
	{ 21, 942591 },
	{ 21, 745983 },
	{ 21, 680447 },
	{ 20, 483839 },
	{ 20, 418303 },
	{ 20, 221695 },
	{ 20, 156159 },
	{ 18, 90623 },
	{ 18, 25087 },
	{ 13, 4462 },
	{ 18, 12795 },
	{ 18, 74235 },
	{ 18, 37371 },
	{ 18, 49659 },
	{ 18, 10747 },
	{ 18, 76283 },
	{ 18, 81407 },
	{ 20, 207355 },
	{ 20, 403963 },
	{ 20, 469499 },
	{ 20, 474623 },
	{ 21, 731643 },
	{ 21, 928251 },
	{ 21, 993787 },
	{ 21, 998911 },
	{ 22, 3892477 },
	{ 22, 3826941 },
	{ 22, 2057469 },
	{ 22, 1991933 },
	{ 22, 1795325 },
	{ 22, 1729789 },
	{ 21, 1008893 },
	{ 21, 943357 },
	{ 21, 746749 },
	{ 21, 681213 },
	{ 20, 484605 },
	{ 20, 419069 },
	{ 20, 222461 },
	{ 20, 156925 },
	{ 18, 91389 },
	{ 18, 25853 },
	{ 13, 282 },
	{ 18, 13561 },
	{ 18, 75001 },
	{ 18, 38137 },
	{ 18, 50425 },
	{ 18, 36089 },
	{ 18, 40185 },
	{ 18, 55549 },
	{ 20, 146681 },
	{ 20, 158969 },
	{ 20, 163065 },
	{ 20, 227581 },
	{ 21, 310521 },
	{ 21, 322809 },
	{ 21, 326905 },
	{ 21, 456957 },
	{ 22, 638201 },
	{ 22, 650489 },
	{ 22, 654585 },
	{ 22, 765177 },
	{ 22, 769273 },
	{ 22, 781561 },
	{ 21, 1009149 },
	{ 21, 943613 },
	{ 21, 747005 },
	{ 21, 681469 },
	{ 20, 484861 },
	{ 20, 419325 },
	{ 20, 222717 },
	{ 20, 157181 },
	{ 18, 91645 },
	{ 18, 26109 },
	{ 13, 4378 },
	{ 18, 13817 },
	{ 18, 75257 },
	{ 18, 38393 },
	{ 18, 50681 },
	{ 18, 36345 },
	{ 18, 40441 },
	{ 18, 55805 },
	{ 20, 146937 },
	{ 20, 159225 },
	{ 20, 163321 },
	{ 20, 227837 },
	{ 21, 310777 },
	{ 21, 323065 },
	{ 21, 327161 },
	{ 21, 457213 },
	{ 22, 638457 },
	{ 22, 650745 },
	{ 22, 654841 },
	{ 22, 765433 },
	{ 22, 769529 },
	{ 22, 781817 },
	{ 22, 785913 },
	{ 22, 1047037 },
	{ 23, 3003133 },
	{ 23, 2740989 },
	{ 22, 1954557 },
	{ 22, 1692413 },
	{ 22, 905981 },
	{ 22, 643837 },
	{ 20, 381693 },
	{ 20, 119549 },
	{ 15, 2458 },
	{ 20, 103161 },
	{ 20, 316153 },
	{ 22, 561913 },
	{ 20, 217849 },
	{ 20, 398073 },
	{ 20, 209657 },
	{ 20, 226041 },
	{ 20, 418557 },
	{ 22, 848633 },
	{ 22, 897785 },
	{ 22, 914169 },
	{ 22, 1696509 },
	{ 23, 1766137 },
	{ 23, 1815289 },
	{ 23, 1831673 },
	{ 23, 3400445 },
	{ 24, 3601145 },
	{ 24, 3650297 },
	{ 24, 3666681 },
	{ 24, 4109049 },
	{ 24, 4125433 },
	{ 23, 4051965 },
	{ 23, 3789821 },
	{ 23, 3003389 },
	{ 23, 2741245 },
	{ 22, 1954813 },
	{ 22, 1692669 },
	{ 22, 906237 },
	{ 22, 644093 },
	{ 20, 381949 },
	{ 20, 119805 },
	{ 15, 6554 },
	{ 20, 103417 },
	{ 20, 316409 },
	{ 22, 562169 },
	{ 20, 218105 },
	{ 20, 398329 },
	{ 20, 209913 },
	{ 20, 226297 },
	{ 20, 418813 },
	{ 22, 848889 },
	{ 22, 898041 },
	{ 22, 914425 },
	{ 22, 1696765 },
	{ 23, 1766393 },
	{ 23, 1815545 },
	{ 23, 1831929 },
	{ 23, 3400701 },
	{ 24, 3601401 },
	{ 24, 3650553 },
	{ 24, 3666937 },
	{ 24, 4109305 },
	{ 24, 4125689 },
	{ 24, 4174841 },
	{ 24, 4191225 },
	{ 24, 5936893 },
	{ 24, 5412605 },
	{ 23, 3839741 },
	{ 23, 3315453 },
	{ 23, 1742589 },
	{ 23, 1218301 },
	{ 21, 694013 },
	{ 21, 169725 },
	{ 15, 11034 },
	{ 20, 120569 },
	{ 20, 366329 },
	{ 22, 579321 },
	{ 22, 825081 },
	{ 20, 415481 },
	{ 20, 464633 },
	{ 20, 407289 },
	{ 20, 423673 },
	{ 20, 485117 },
	{ 22, 1636089 },
	{ 22, 1685241 },
	{ 22, 1701625 },
	{ 22, 1959677 },
	{ 23, 3340025 },
	{ 23, 3389177 },
	{ 23, 3405561 },
	{ 23, 3925757 },
	{ 24, 6747897 },
	{ 24, 6797049 },
	{ 24, 6813433 },
	{ 24, 7255801 },
	{ 24, 7272185 },
	{ 24, 7321337 },
	{ 24, 7337721 },
	{ 24, 8382205 },
	{ 23, 3839997 },
	{ 23, 3315709 },
	{ 23, 1742845 },
	{ 23, 1218557 },
	{ 21, 694269 },
	{ 21, 169981 },
	{ 15, 15130 },
	{ 20, 120825 },
	{ 20, 366585 },
	{ 22, 579577 },
	{ 22, 825337 },
	{ 20, 415737 },
	{ 20, 464889 },
	{ 20, 407545 },
	{ 20, 423929 },
	{ 20, 485373 },
	{ 22, 1636345 },
	{ 22, 1685497 },
	{ 22, 1701881 },
	{ 22, 1959933 },
	{ 23, 3340281 },
	{ 23, 3389433 },
	{ 23, 3405817 },
	{ 23, 3926013 },
	{ 24, 6748153 },
	{ 24, 6797305 },
	{ 24, 6813689 },
	{ 24, 7256057 },
	{ 24, 7272441 },
	{ 24, 7321593 },
	{ 24, 7337977 },
	{ 24, 8382461 },
	{ 25, 15420157 },
	{ 25, 13323005 },
	{ 25, 7031549 },
	{ 25, 4934397 },
	{ 23, 2837245 },
	{ 23, 740093 },
	{ 17, 19354 },
	{ 23, 674553 },
	{ 22, 1526521 },
	{ 24, 2509561 },
	{ 24, 3361529 },
	{ 24, 6441721 },
	{ 22, 1919737 },
	{ 23, 2640633 },
	{ 22, 1886969 },
	{ 22, 1952505 },
	{ 23, 2722557 },
	{ 24, 7588601 },
	{ 24, 7785209 },
	{ 24, 7850745 },
	{ 25, 15387385 },
	{ 25, 15452921 },
	{ 25, 15649529 },
	{ 25, 15715065 },
	{ 26, 31116025 },
	{ 26, 31181561 },
	{ 26, 31378169 },
	{ 26, 31443705 },
	{ 26, 33213177 },
	{ 26, 33278713 },
	{ 26, 33475321 },
	{ 26, 33540857 },
	{ 25, 15420413 },
	{ 25, 13323261 },
	{ 25, 7031805 },
	{ 25, 4934653 },
	{ 23, 2837501 },
	{ 23, 740349 },
	{ 17, 23450 },
	{ 23, 674809 },
	{ 22, 1526777 },
	{ 24, 2509817 },
	{ 24, 3361785 },
	{ 24, 6441977 },
	{ 22, 1919993 },
	{ 23, 2640889 },
	{ 22, 1887225 },
	{ 22, 1952761 },
	{ 23, 2722813 },
	{ 24, 7588857 },
	{ 24, 7785465 },
	{ 24, 7851001 },
	{ 25, 15387641 },
	{ 25, 15453177 },
	{ 25, 15649785 },
	{ 25, 15715321 },
	{ 26, 31116281 },
	{ 26, 31181817 },
	{ 26, 31378425 },
	{ 26, 31443961 },
	{ 26, 33213433 },
	{ 26, 33278969 },
	{ 26, 33475577 },
	{ 26, 33541113 },
	{ 25, 15617789 },
	{ 25, 13520637 },
	{ 25, 7229181 },
	{ 25, 5132029 },
	{ 23, 3034877 },
	{ 23, 937725 },
	{ 18, 54554 },
	{ 23, 741113 },
	{ 23, 2772729 },
	{ 24, 2576121 },
	{ 24, 3559161 },
	{ 24, 6508281 },
	{ 24, 7491321 },
	{ 23, 2707193 },
	{ 23, 2903801 },
	{ 23, 2674425 },
	{ 23, 2739961 },
	{ 23, 2985725 },
	{ 25, 10735353 },
	{ 25, 10931961 },
	{ 25, 10997497 },
	{ 25, 12029693 },
	{ 26, 21745401 },
	{ 26, 21942009 },
	{ 26, 22007545 },
	{ 26, 24088317 },
	{ 27, 43765497 },
	{ 27, 43962105 },
	{ 26, 32395261 },
	{ 26, 30298109 },
	{ 26, 24006653 },
	{ 26, 21909501 },
	{ 25, 15618045 },
	{ 25, 13520893 },
	{ 25, 7229437 },
	{ 25, 5132285 },
	{ 23, 3035133 },
	{ 23, 937981 },
	{ 18, 62746 },
	{ 23, 741369 },
	{ 23, 2772985 },
	{ 24, 2576377 },
	{ 24, 3559417 },
	{ 24, 6508537 },
	{ 24, 7491577 },
	{ 23, 2707449 },
	{ 23, 2904057 },
	{ 23, 2674681 },
	{ 23, 2740217 },
	{ 23, 2985981 },
	{ 25, 10735609 },
	{ 25, 10932217 },
	{ 25, 10997753 },
	{ 25, 12029949 },
	{ 26, 21745657 },
	{ 26, 21942265 },
	{ 26, 22007801 },
	{ 26, 24088573 },
	{ 27, 43765753 },
	{ 27, 43962361 },
	{ 26, 32463613 },
	{ 26, 30366461 },
	{ 26, 24075005 },
	{ 26, 21977853 },
	{ 25, 15686397 },
	{ 25, 13589245 },
	{ 25, 7297789 },
	{ 25, 5200637 },
	{ 23, 3103485 },
	{ 23, 1006333 },
	{ 18, 103834 },
	{ 23, 940793 },
	{ 23, 2841337 },
	{ 25, 4872953 },
	{ 24, 3627769 },
	{ 24, 6707961 },
	{ 24, 7559929 },
	{ 25, 10640121 },
	{ 23, 2972409 },
	{ 23, 3693305 },
	{ 23, 2939641 },
	{ 23, 3005177 },
	{ 23, 3775229 },
	{ 25, 11787001 },
	{ 25, 11983609 },
	{ 25, 12049145 },
	{ 25, 15178493 },
	{ 26, 23845625 },
	{ 26, 24042233 },
	{ 26, 24107769 },
	{ 26, 30382845 },
	{ 27, 47962873 },
	{ 26, 32463869 },
	{ 26, 30366717 },
	{ 26, 24075261 },
	{ 26, 21978109 },
	{ 25, 15686653 },
	{ 25, 13589501 },
	{ 25, 7298045 },
	{ 25, 5200893 },
	{ 23, 3103741 },
	{ 23, 1006589 },
	{ 18, 112026 },
	{ 23, 941049 },
	{ 23, 2841593 },
	{ 25, 4873209 },
	{ 24, 3628025 },
	{ 24, 6708217 },
	{ 24, 7560185 },
	{ 25, 10640377 },
	{ 23, 2972665 },
	{ 23, 3693561 },
	{ 23, 2939897 },
	{ 23, 3005433 },
	{ 23, 3775485 },
	{ 25, 11787257 },
	{ 25, 11983865 },
	{ 25, 12049401 },
	{ 25, 15178749 },
	{ 26, 23845881 },
	{ 26, 24042489 },
	{ 26, 24108025 },
	{ 26, 30383101 },
	{ 27, 47963129 },
	{ 27, 64953337 },
	{ 27, 62528505 },
	{ 27, 50011129 },
	{ 27, 46013433 },
	{ 26, 33496057 },
	{ 26, 26894077 },
	{ 26, 14311165 },
	{ 26, 10116861 },
	{ 24, 5922557 },
	{ 24, 1728253 },
	{ 18, 120602 },
	{ 23, 1007353 },
	{ 23, 3038969 },
	{ 25, 4939513 },
	{ 25, 6971129 },
	{ 24, 6774521 },
	{ 24, 7757561 },
	{ 25, 10706681 },
	{ 25, 11689721 },
	{ 23, 3759865 },
	{ 23, 3956473 },
	{ 23, 3727097 },
	{ 23, 3792633 },
	{ 23, 4038397 },
	{ 25, 14933753 },
	{ 25, 15130361 },
	{ 25, 15195897 },
	{ 25, 16228093 },
	{ 26, 30138105 },
	{ 26, 30334713 },
	{ 26, 30400249 },
	{ 26, 32481021 },
	{ 27, 64888569 },
	{ 27, 60759801 },
	{ 27, 49946361 },
	{ 27, 45817593 },
	{ 26, 33431289 },
	{ 26, 29302521 },
	{ 26, 14311421 },
	{ 26, 10117117 },
	{ 24, 5922813 },
	{ 24, 1728509 },
	{ 18, 128794 },
	{ 23, 1007609 },
	{ 23, 3039225 },
	{ 25, 4939769 },
	{ 25, 6971385 },
	{ 24, 6774777 },
	{ 24, 7757817 },
	{ 25, 10706937 },
	{ 25, 11689977 },
	{ 23, 3760121 },
	{ 23, 3956729 },
	{ 23, 3727353 },
	{ 23, 3792889 },
	{ 23, 4038653 },
	{ 25, 14934009 },
	{ 25, 15130617 },
	{ 25, 15196153 },
	{ 25, 16228349 },
	{ 26, 30138361 },
	{ 26, 30334969 },
	{ 26, 30400505 },
	{ 26, 32481277 },
	{ 27, 64888825 },
	{ 27, 60760057 },
	{ 27, 49946617 },
	{ 27, 45817849 },
	{ 26, 33431545 },
	{ 6, 63 },
	{ 27, 62906361 },
	{ 27, 67084285 },
	{ 26, 23931645 },
	{ 26, 7154429 },
	{ 19, 169882 },
	{ 26, 6892281 },
	{ 25, 12397305 },
	{ 27, 20523769 },
	{ 27, 28125945 },
	{ 27, 53029625 },
	{ 26, 31271673 },
	{ 27, 43592441 },
	{ 27, 47000313 },
	{ 27, 59321081 },
	{ 25, 16067321 },
	{ 26, 27339513 },
	{ 25, 15936249 },
	{ 25, 16198393 },
	{ 26, 27667197 },
	{ 27, 63908601 },
	{ 27, 64695033 },
	{ 27, 64957177 },
	{ 28, 128658169 },
	{ 28, 128920313 },
	{ 28, 129706745 },
	{ 28, 129968889 },
	{ 29, 258747129 },
	{ 29, 242756345 },
	{ 29, 192686841 },
	{ 29, 182987513 },
	{ 28, 132918009 },
	{ 28, 116927225 },
	{ 28, 66857721 },
	{ 28, 40709117 },
	{ 26, 23931901 },
	{ 26, 7154685 },
	{ 19, 178074 },
	{ 26, 6892537 },
	{ 25, 12397561 },
	{ 27, 20524025 },
	{ 27, 28126201 },
	{ 27, 53029881 },
	{ 26, 31271929 },
	{ 27, 43592697 },
	{ 27, 47000569 },
	{ 27, 59321337 },
	{ 25, 16067577 },
	{ 26, 27339769 },
	{ 25, 15936505 },
	{ 25, 16198649 },
	{ 26, 27667453 },
	{ 27, 63908857 },
	{ 27, 64695289 },
	{ 27, 64957433 },
	{ 28, 128658425 },
	{ 28, 128920569 },
	{ 28, 129707001 },
	{ 28, 129969145 },
	{ 29, 258747385 },
	{ 29, 242756601 },
	{ 29, 192687097 },
	{ 29, 182987769 },
	{ 28, 132918265 },
	{ 28, 116927481 },
	{ 28, 66857977 },
	{ 28, 41496317 },
	{ 26, 24719101 },
	{ 26, 7941885 },
	{ 20, 371994 },
	{ 26, 7155449 },
	{ 26, 23670521 },
	{ 27, 20786937 },
	{ 27, 28913401 },
	{ 27, 53292793 },
	{ 27, 61419257 },
	{ 27, 43855609 },
	{ 27, 47787769 },
	{ 27, 59584249 },
	{ 27, 63516409 },
	{ 26, 27602681 },
	{ 26, 28389113 },
	{ 26, 27471609 },
	{ 26, 27733753 },
	{ 26, 28716797 },
	{ 28, 249048825 },
	{ 28, 245116665 },
	{ 28, 111095545 },
	{ 28, 115224317 },
	{ 29, 230174457 },
	{ 29, 222047993 },
	{ 29, 258486009 },
	{ 29, 241970937 },
	{ 29, 192425721 },
	{ 29, 175910649 },
	{ 28, 132656889 },
	{ 28, 116141817 },
	{ 28, 66596601 },
	{ 28, 50081529 },
	{ 26, 24719357 },
	{ 26, 7942141 },
	{ 20, 388378 },
	{ 26, 7155705 },
	{ 26, 23670777 },
	{ 27, 20787193 },
	{ 27, 28913657 },
	{ 27, 53293049 },
	{ 27, 61419513 },
	{ 27, 43855865 },
	{ 27, 47788025 },
	{ 27, 59584505 },
	{ 27, 63516665 },
	{ 26, 27602937 },
	{ 26, 28389369 },
	{ 26, 27471865 },
	{ 26, 27734009 },
	{ 26, 28717053 },
	{ 28, 249049081 },
	{ 28, 245116921 },
	{ 28, 111095801 },
	{ 28, 115224573 },
	{ 29, 230174713 },
	{ 29, 222048249 },
	{ 29, 258486265 },
	{ 29, 241971193 },
	{ 29, 192425977 },
	{ 29, 175910905 },
	{ 28, 132657145 },
	{ 28, 116142073 },
	{ 28, 66596857 },
	{ 28, 50081785 },
	{ 26, 24984317 },
	{ 26, 8207101 },
	{ 20, 470426 },
	{ 26, 7944953 },
	{ 26, 23935737 },
	{ 27, 47775739 },
	{ 27, 29178617 },
	{ 27, 54082297 },
	{ 27, 61684473 },
	{ 28, 134101753 },
	{ 27, 48052985 },
	{ 27, 60373753 },
	{ 27, 63781625 },
	{ 26, 33438457 },
	{ 26, 16661241 },
	{ 26, 31537913 },
	{ 26, 66337529 },
	{ 26, 28785401 },
	{ 26, 31865597 },
	{ 27, 49741823 },
	{ 28, 131873529 },
	{ 28, 115292921 },
	{ 28, 127810301 },
	{ 29, 221788921 },
	{ 28, 129776377 },
	{ 29, 241711865 },
	{ 29, 191642361 },
	{ 29, 175651577 },
	{ 28, 125582073 },
	{ 28, 115882745 },
	{ 28, 65813241 },
	{ 28, 49822457 },
	{ 26, 33307385 },
	{ 26, 8207357 },
	{ 20, 475114 },
	{ 26, 7945209 },
	{ 26, 23935993 },
	{ 27, 47775483 },
	{ 27, 29178873 },
	{ 27, 54082553 },
	{ 27, 61684729 },
	{ 28, 134102009 },
	{ 27, 48053241 },
	{ 27, 60374009 },
	{ 27, 63781881 },
	{ 26, 33438713 },
	{ 26, 16661497 },
	{ 26, 31538169 },
	{ 26, 66337785 },
	{ 26, 28785657 },
	{ 26, 31865853 },
	{ 27, 49741567 },
	{ 28, 131873785 },
	{ 28, 115293177 },
	{ 28, 127810557 },
	{ 29, 221789177 },
	{ 28, 129776633 },
	{ 29, 241712121 },
	{ 29, 191642617 },
	{ 29, 175651833 },
	{ 28, 125582329 },
	{ 28, 115883001 },
	{ 28, 65813497 },
	{ 28, 49822713 },
	{ 26, 33307641 },
	{ 26, 15286013 },
	{ 20, 491498 },
	{ 26, 8208121 },
	{ 26, 24723193 },
	{ 27, 49347579 },
	{ 28, 57229049 },
	{ 27, 54345465 },
	{ 27, 62471929 },
	{ 28, 86851321 },
	{ 28, 133840633 },
	{ 27, 60636921 },
	{ 27, 64569081 },
	{ 26, 33505021 },
	{ 26, 33177337 },
	{ 26, 16400121 },
	{ 26, 66076409 },
	{ 26, 65289977 },
	{ 26, 31932153 },
	{ 26, 32915197 },
	{ 27, 50265087 },
	{ 28, 127680249 },
	{ 28, 127876857 },
	{ 28, 132005629 },
	{ 28, 129515257 },
	{ 28, 121388793 },
	{ 29, 191381241 },
	{ 29, 174866169 },
	{ 28, 125320953 },
	{ 28, 108805881 },
	{ 28, 65552121 },
	{ 28, 49037049 },
	{ 26, 33046265 },
	{ 26, 16531193 },
	{ 20, 507754 },
	{ 26, 8208377 },
	{ 26, 24723449 },
	{ 27, 49347323 },
	{ 28, 57229305 },
	{ 27, 54345721 },
	{ 27, 62472185 },
	{ 28, 86851577 },
	{ 28, 133840889 },
	{ 27, 60637177 },
	{ 27, 64569337 },
	{ 26, 33505277 },
	{ 26, 33177593 },
	{ 26, 16400377 },
	{ 26, 66076665 },
	{ 26, 65290233 },
	{ 26, 31932409 },
	{ 26, 32915453 },
	{ 27, 50264831 },
	{ 28, 127680505 },
	{ 28, 127877113 },
	{ 28, 132005885 },
	{ 28, 129515513 },
	{ 28, 121389049 },
	{ 29, 191381497 },
	{ 29, 174866425 },
	{ 28, 125321209 },
	{ 28, 108806137 },
	{ 28, 65552377 },
	{ 28, 49037305 },
	{ 26, 33046521 },
	{ 26, 16531449 },
	{ 20, 524138 },
	{ 26, 15297273 },
	{ 26, 24996601 },
	{ 27, 49868795 },
	{ 28, 57502457 },
	{ 28, 107571961 },
	{ 27, 62745337 },
	{ 28, 87649017 },
	{ 28, 95251193 },
	{ 28, 133065465 },
	{ 27, 64842489 },
	{ 28, 65956601 },
	{ 26, 33254141 },
	{ 26, 32402169 },
	{ 26, 15624953 },
	{ 26, 65039097 },
	{ 26, 62155513 },
	{ 26, 32991993 },
	{ 26, 61238013 },
	{ 27, 64417791 },
	{ 28, 115108601 },
	{ 28, 132082425 },
	{ 28, 128740089 },
	{ 28, 121137913 },
	{ 28, 96234233 },
	{ 29, 174615289 },
	{ 28, 124545785 },
	{ 28, 108555001 },
	{ 28, 58485497 },
	{ 28, 48786169 },
	{ 26, 32271097 },
	{ 26, 16280313 },
	{ 21, 867818 },
	{ 26, 15297529 },
	{ 26, 24996857 },
	{ 27, 49868539 },
	{ 28, 57502713 },
	{ 28, 107572217 },
	{ 27, 62745593 },
	{ 28, 87649273 },
	{ 28, 95251449 },
	{ 28, 133065721 },
	{ 27, 64842745 },
	{ 28, 65956857 },
	{ 26, 33254397 },
	{ 26, 32402425 },
	{ 26, 15625209 },
	{ 26, 65039353 },
	{ 26, 62155769 },
	{ 26, 32992249 },
	{ 26, 61238269 },
	{ 27, 64417535 },
	{ 28, 115108857 },
	{ 28, 132082681 },
	{ 28, 128740345 },
	{ 28, 121138169 },
	{ 28, 96234489 },
	{ 29, 174615545 },
	{ 28, 124546041 },
	{ 28, 108555257 },
	{ 28, 58485753 },
	{ 28, 48786425 },
	{ 26, 32271353 },
	{ 26, 16280569 },
	{ 21, 884202 },
	{ 26, 15560441 },
	{ 26, 32075513 },
	{ 27, 64023547 },
	{ 28, 58289913 },
	{ 28, 107835129 },
	{ 28, 124350201 },
	{ 28, 87912185 },
	{ 28, 96038649 },
	{ 28, 120418041 },
	{ 28, 132804345 },
	{ 28, 116027129 },
	{ 28, 65695481 },
	{ 26, 32468733 },
	{ 26, 32141049 },
	{ 26, 15363833 },
	{ 26, 61894393 },
	{ 26, 61107961 },
	{ 26, 61304569 },
	{ 26, 62287613 },
	{ 27, 64941055 },
	{ 28, 110915321 },
	{ 28, 128478969 },
	{ 28, 120352505 },
	{ 28, 95973113 },
	{ 28, 87846649 },
	{ 28, 124284665 },
	{ 28, 107769593 },
	{ 28, 58224377 },
	{ 28, 41709305 },
	{ 26, 32009977 },
	{ 26, 15494905 },
	{ 21, 900458 },
	{ 26, 15560697 },
	{ 26, 32075769 },
	{ 27, 64023291 },
	{ 28, 58290169 },
	{ 28, 107835385 },
	{ 28, 124350457 },
	{ 28, 87912441 },
	{ 28, 96038905 },
	{ 28, 120418297 },
	{ 28, 132804601 },
	{ 28, 116027385 },
	{ 28, 65695737 },
	{ 26, 32468989 },
	{ 26, 32141305 },
	{ 26, 15364089 },
	{ 26, 61894649 },
	{ 26, 61108217 },
	{ 26, 61304825 },
	{ 26, 62287869 },
	{ 27, 64940799 },
	{ 28, 110915577 },
	{ 28, 128479225 },
	{ 28, 120352761 },
	{ 28, 95973369 },
	{ 28, 87846905 },
	{ 28, 124284921 },
	{ 28, 107769849 },
	{ 28, 58224633 },
	{ 28, 41709561 },
	{ 26, 32010233 },
	{ 26, 15495161 },
	{ 21, 916842 },
	{ 21, 2096622 },
	{ 26, 32340729 },
	{ 27, 64536571 },
	{ 28, 58555129 },
	{ 28, 108624633 },
	{ 28, 124615417 },
	{ 29, 259947257 },
	{ 28, 96303865 },
	{ 28, 121207545 },
	{ 28, 128809721 },
	{ 28, 125729529 },
	{ 28, 108952313 },
	{ 28, 58620665 },
	{ 26, 32209661 },
	{ 26, 25066233 },
	{ 26, 8289017 },
	{ 26, 60848889 },
	{ 26, 32799481 },
	{ 26, 62356217 },
	{ 26, 65436413 },
	{ 27, 66502655 },
	{ 27, 64781049 },
	{ 28, 120093433 },
	{ 28, 95189753 },
	{ 28, 87587577 },
	{ 27, 62683897 },
	{ 28, 107510521 },
	{ 28, 57441017 },
	{ 28, 41450233 },
	{ 26, 24935161 },
	{ 26, 15235833 },
	{ 21, 995306 },
	{ 21, 2080238 },
	{ 26, 32340985 },
	{ 27, 64536315 },
	{ 28, 58555385 },
	{ 28, 108624889 },
	{ 28, 124615673 },
	{ 29, 259947513 },
	{ 28, 96304121 },
	{ 28, 121207801 },
	{ 28, 128809977 },
	{ 28, 125729785 },
	{ 28, 108952569 },
	{ 28, 58620921 },
	{ 26, 32209917 },
	{ 26, 25066489 },
	{ 26, 8289273 },
	{ 26, 60849145 },
	{ 26, 32799737 },
	{ 26, 62356473 },
	{ 26, 65436669 },
	{ 27, 66502399 },
	{ 27, 64781305 },
	{ 28, 120093689 },
	{ 28, 95190009 },
	{ 28, 87587833 },
	{ 27, 62684153 },
	{ 28, 107510777 },
	{ 28, 57441273 },
	{ 28, 41450489 },
	{ 26, 24935417 },
	{ 26, 15236089 },
	{ 21, 1011690 },
	{ 21, 2064238 },
	{ 26, 33128185 },
	{ 27, 66108411 },
	{ 28, 65634041 },
	{ 28, 108887801 },
	{ 28, 125402873 },
	{ 29, 174948089 },
	{ 29, 259686137 },
	{ 28, 121470713 },
	{ 28, 129597177 },
	{ 28, 125796093 },
	{ 28, 125468409 },
	{ 28, 108691193 },
	{ 28, 58359545 },
	{ 26, 25132797 },
	{ 26, 24805113 },
	{ 26, 8027897 },
	{ 26, 32538361 },
	{ 26, 31751929 },
	{ 26, 65502969 },
	{ 26, 66486013 },
	{ 27, 64519929 },
	{ 27, 60587769 },
	{ 28, 94928633 },
	{ 28, 86802169 },
	{ 27, 62422777 },
	{ 27, 54296313 },
	{ 28, 57179897 },
	{ 28, 40664825 },
	{ 26, 24674041 },
	{ 26, 8158969 },
	{ 21, 1027946 },
	{ 21, 2047854 },
	{ 26, 33128441 },
	{ 27, 66108155 },
	{ 28, 65634297 },
	{ 28, 108888057 },
	{ 28, 125403129 },
	{ 29, 174948345 },
	{ 29, 259686393 },
	{ 28, 121470969 },
	{ 28, 129597433 },
	{ 28, 125796349 },
	{ 28, 125468665 },
	{ 28, 108691449 },
	{ 28, 58359801 },
	{ 26, 25133053 },
	{ 26, 24805369 },
	{ 26, 8028153 },
	{ 26, 32538617 },
	{ 26, 31752185 },
	{ 26, 65503225 },
	{ 26, 66486269 },
	{ 27, 64520185 },
	{ 27, 60588025 },
	{ 28, 94928889 },
	{ 28, 86802425 },
	{ 27, 62423033 },
	{ 27, 54296569 },
	{ 28, 57180153 },
	{ 28, 40665081 },
	{ 26, 24674297 },
	{ 26, 8159225 },
	{ 21, 1044330 },
	{ 21, 1966062 },
	{ 26, 32014333 },
	{ 27, 66629627 },
	{ 28, 65568765 },
	{ 28, 115900413 },
	{ 28, 132677629 },
	{ 29, 183009277 },
	{ 29, 199786493 },
	{ 29, 250118141 },
	{ 29, 259697401 },
	{ 29, 259567611 },
	{ 29, 251046653 },
	{ 29, 249342713 },
	{ 29, 215788281 },
	{ 29, 115124985 },
	{ 27, 49720061 },
	{ 27, 48016121 },
	{ 27, 14461689 },
	{ 27, 62958329 },
	{ 27, 57191161 },
	{ 27, 133081849 },
	{ 27, 66891771 },
	{ 28, 120630009 },
	{ 28, 95988473 },
	{ 28, 96120827 },
	{ 28, 123251449 },
	{ 28, 108047097 },
	{ 28, 58239737 },
	{ 28, 58372091 },
	{ 27, 47753977 },
	{ 27, 15772409 },
	{ 21, 1912298 },
	{ 21, 1949678 },
	{ 27, 66759673 },
	{ 27, 66629371 },
	{ 29, 131771385 },
	{ 29, 231910393 },
	{ 29, 251309049 },
	{ 29, 251178747 },
	{ 30, 383429625 },
	{ 30, 517778425 },
	{ 29, 259697657 },
	{ 29, 259567355 },
	{ 29, 251046909 },
	{ 29, 249342969 },
	{ 29, 215788537 },
	{ 29, 115125241 },
	{ 27, 49720317 },
	{ 27, 48016377 },
	{ 27, 14461945 },
	{ 27, 62958585 },
	{ 27, 57191417 },
	{ 27, 133082105 },
	{ 27, 66891515 },
	{ 28, 120630265 },
	{ 28, 95988729 },
	{ 28, 96120571 },
	{ 28, 123251705 },
	{ 28, 108047353 },
	{ 28, 58239993 },
	{ 28, 58371835 },
	{ 27, 47754233 },
	{ 27, 15772665 },
	{ 21, 1928682 },
	{ 21, 1944990 },
	{ 27, 49851389 },
	{ 27, 49983231 },
	{ 29, 133345017 },
	{ 29, 232435449 },
	{ 29, 265465593 },
	{ 29, 265333755 },
	{ 30, 385003257 },
	{ 30, 484093689 },
	{ 30, 517254905 },
	{ 30, 483700473 },
	{ 30, 383037177 },
	{ 29, 249474813 },
	{ 29, 248819449 },
	{ 29, 215265017 },
	{ 29, 114601721 },
	{ 27, 48148221 },
	{ 27, 47492857 },
	{ 27, 13938425 },
	{ 27, 56667897 },
	{ 27, 55095033 },
	{ 27, 55225339 },
	{ 28, 119058169 },
	{ 28, 95465209 },
	{ 28, 87600889 },
	{ 28, 122728185 },
	{ 28, 106475257 },
	{ 28, 57716473 },
	{ 28, 41463545 },
	{ 27, 47230713 },
	{ 27, 14200569 },
	{ 21, 1944938 },
	{ 21, 1928478 },
	{ 27, 49327869 },
	{ 27, 49458175 },
	{ 29, 133345273 },
	{ 29, 232435705 },
	{ 29, 265465849 },
	{ 29, 265333499 },
	{ 30, 385003513 },
	{ 30, 484093945 },
	{ 30, 517255161 },
	{ 30, 483700729 },
	{ 30, 383037433 },
	{ 29, 249475069 },
	{ 29, 248819705 },
	{ 29, 215265273 },
	{ 29, 114601977 },
	{ 27, 48148477 },
	{ 27, 47493113 },
	{ 27, 13938681 },
	{ 27, 56668153 },
	{ 27, 55095289 },
	{ 27, 55225083 },
	{ 28, 119058425 },
	{ 28, 95465465 },
	{ 28, 87601145 },
	{ 28, 122728441 },
	{ 28, 106475513 },
	{ 28, 57716729 },
	{ 28, 41463801 },
	{ 27, 47230969 },
	{ 27, 14200825 },
	{ 21, 1961322 },
	{ 21, 1912094 },
	{ 27, 49328125 },
	{ 27, 49457919 },
	{ 29, 133872377 },
	{ 28, 66879483 },
	{ 28, 116948987 },
	{ 28, 132939771 },
	{ 29, 183009275 },
	{ 29, 192708603 },
	{ 29, 242778107 },
	{ 29, 259832569 },
	{ 28, 129990651 },
	{ 28, 129728507 },
	{ 28, 128942075 },
	{ 28, 125614841 },
	{ 27, 64978939 },
	{ 27, 64716795 },
	{ 27, 47627005 },
	{ 26, 24951545 },
	{ 25, 16220155 },
	{ 25, 15958011 },
	{ 26, 32029433 },
	{ 25, 16089083 },
	{ 27, 59342843 },
	{ 27, 47022075 },
	{ 27, 62438137 },
	{ 26, 31293435 },
	{ 27, 53051387 },
	{ 27, 28147707 },
	{ 26, 24689401 },
	{ 25, 12419067 },
	{ 20, 1021930 },
	{ 20, 522142 },
	{ 26, 7176191 },
	{ 26, 23953407 },
	{ 28, 40730623 },
	{ 28, 66879227 },
	{ 28, 116948731 },
	{ 28, 132939515 },
	{ 29, 183009019 },
	{ 29, 192708347 },
	{ 29, 242777851 },
	{ 29, 259832825 },
	{ 28, 129990395 },
	{ 28, 129728251 },
	{ 28, 128941819 },
	{ 28, 125615097 },
	{ 27, 64978683 },
	{ 27, 64716539 },
	{ 27, 47627261 },
	{ 26, 24951801 },
	{ 25, 16219899 },
	{ 25, 15957755 },
	{ 26, 32029689 },
	{ 25, 16088827 },
	{ 27, 59342587 },
	{ 27, 47021819 },
	{ 27, 62438393 },
	{ 26, 31293179 },
	{ 27, 53051131 },
	{ 27, 28147451 },
	{ 26, 24689657 },
	{ 25, 12418811 },
	{ 20, 1030122 },
	{ 20, 513950 },
	{ 26, 7175935 },
	{ 26, 23953151 },
	{ 28, 40730367 },
	{ 28, 57507583 },
	{ 28, 117210107 },
	{ 28, 133725179 },
	{ 29, 183270395 },
	{ 29, 199785467 },
	{ 29, 243039227 },
	{ 29, 259964669 },
	{ 28, 129924095 },
	{ 28, 121601019 },
	{ 28, 121338875 },
	{ 28, 125746941 },
	{ 27, 64912383 },
	{ 27, 60783611 },
	{ 27, 60521467 },
	{ 26, 25083645 },
	{ 25, 16153599 },
	{ 25, 15170555 },
	{ 25, 14908411 },
	{ 25, 15825915 },
	{ 25, 15039483 },
	{ 27, 46758907 },
	{ 27, 61914873 },
	{ 26, 31030267 },
	{ 26, 27098107 },
	{ 27, 27884539 },
	{ 26, 24166137 },
	{ 25, 12155899 },
	{ 20, 1038186 },
	{ 20, 505630 },
	{ 26, 6913023 },
	{ 26, 23690239 },
	{ 28, 40467455 },
	{ 28, 57244671 },
	{ 28, 117209851 },
	{ 28, 133724923 },
	{ 29, 183270139 },
	{ 29, 199785211 },
	{ 29, 243038971 },
	{ 29, 259964925 },
	{ 28, 129923839 },
	{ 28, 121600763 },
	{ 28, 121338619 },
	{ 28, 125747197 },
	{ 27, 64912127 },
	{ 27, 60783355 },
	{ 27, 60521211 },
	{ 26, 25083901 },
	{ 25, 16153343 },
	{ 25, 15170299 },
	{ 25, 14908155 },
	{ 25, 15825659 },
	{ 25, 15039227 },
	{ 27, 46758651 },
	{ 27, 61915129 },
	{ 26, 31030011 },
	{ 26, 27097851 },
	{ 27, 27884283 },
	{ 26, 24166393 },
	{ 25, 12155643 },
	{ 20, 1046378 },
	{ 20, 497438 },
	{ 26, 6912767 },
	{ 26, 23689983 },
	{ 28, 40467199 },
	{ 28, 57244415 },
	{ 28, 107576063 },
	{ 28, 133984251 },
	{ 29, 184053755 },
	{ 29, 200044539 },
	{ 29, 250114043 },
	{ 29, 259813371 },
	{ 29, 259451645 },
	{ 28, 121532415 },
	{ 28, 96432123 },
	{ 28, 96169979 },
	{ 28, 125233917 },
	{ 27, 60715007 },
	{ 27, 48197627 },
	{ 27, 47935483 },
	{ 26, 24570621 },
	{ 25, 15101951 },
	{ 25, 12021755 },
	{ 25, 11759611 },
	{ 25, 14774267 },
	{ 25, 11890683 },
	{ 27, 60353273 },
	{ 26, 30240763 },
	{ 26, 26832891 },
	{ 26, 14512123 },
	{ 26, 22604537 },
	{ 25, 11366395 },
	{ 25, 3764219 },
	{ 20, 456094 },
	{ 25, 4026367 },
	{ 25, 12414975 },
	{ 27, 20803583 },
	{ 27, 29192191 },
	{ 27, 54358015 },
	{ 27, 62746623 },
	{ 28, 87912447 },
	{ 28, 96301055 },
	{ 28, 121466879 },
	{ 28, 129855487 },
	{ 29, 259451901 },
	{ 28, 121532159 },
	{ 28, 96431867 },
	{ 28, 96169723 },
	{ 28, 125234173 },
	{ 27, 60714751 },
	{ 27, 48197371 },
	{ 27, 47935227 },
	{ 26, 24570877 },
	{ 25, 15101695 },
	{ 25, 12021499 },
	{ 25, 11759355 },
	{ 25, 14774011 },
	{ 25, 11890427 },
	{ 27, 60353529 },
	{ 26, 30240507 },
	{ 26, 26832635 },
	{ 26, 14511867 },
	{ 26, 22604793 },
	{ 25, 11366139 },
	{ 25, 3763963 },
	{ 20, 447902 },
	{ 25, 4026111 },
	{ 25, 12414719 },
	{ 27, 20803327 },
	{ 27, 29191935 },
	{ 27, 54357759 },
	{ 27, 62746367 },
	{ 28, 87912191 },
	{ 28, 96300799 },
	{ 28, 121466623 },
	{ 28, 129855231 },
	{ 29, 175860731 },
	{ 29, 257879805 },
	{ 28, 96365567 },
	{ 28, 88042491 },
	{ 28, 87780347 },
	{ 28, 123662077 },
	{ 27, 48131071 },
	{ 27, 44002299 },
	{ 27, 43740155 },
	{ 26, 22998781 },
	{ 25, 11955199 },
	{ 25, 10972155 },
	{ 25, 10710011 },
	{ 25, 11627515 },
	{ 25, 10841083 },
	{ 26, 29977595 },
	{ 26, 26045435 },
	{ 26, 14248955 },
	{ 26, 22081273 },
	{ 25, 11103227 },
	{ 25, 2976763 },
	{ 20, 439582 },
	{ 25, 3763199 },
	{ 25, 12151807 },
	{ 27, 20540415 },
	{ 27, 28929023 },
	{ 27, 54094847 },
	{ 27, 62483455 },
	{ 28, 87649279 },
	{ 28, 96037887 },
	{ 28, 121203711 },
	{ 28, 129592319 },
	{ 29, 175860475 },
	{ 29, 257880061 },
	{ 28, 96365311 },
	{ 28, 88042235 },
	{ 28, 87780091 },
	{ 28, 123662333 },
	{ 27, 48130815 },
	{ 27, 44002043 },
	{ 27, 43739899 },
	{ 26, 22999037 },
	{ 25, 11954943 },
	{ 25, 10971899 },
	{ 25, 10709755 },
	{ 25, 11627259 },
	{ 25, 10840827 },
	{ 26, 29977339 },
	{ 26, 26045179 },
	{ 26, 14248699 },
	{ 26, 22081529 },
	{ 25, 11102971 },
	{ 25, 2976507 },
	{ 20, 431390 },
	{ 25, 3762943 },
	{ 25, 12151551 },
	{ 27, 20540159 },
	{ 27, 28928767 },
	{ 27, 54094591 },
	{ 27, 62483199 },
	{ 28, 134168571 },
	{ 28, 133906427 },
	{ 28, 133119995 },
	{ 28, 132857851 },
	{ 28, 125779963 },
	{ 28, 125517819 },
	{ 28, 124731387 },
	{ 28, 129825529 },
	{ 27, 62865403 },
	{ 27, 62603259 },
	{ 27, 61816827 },
	{ 27, 62716665 },
	{ 26, 31408123 },
	{ 26, 31145979 },
	{ 26, 22477565 },
	{ 25, 12385017 },
	{ 24, 7815163 },
	{ 24, 7553019 },
	{ 25, 15268601 },
	{ 24, 7684091 },
	{ 26, 25772027 },
	{ 26, 13451259 },
	{ 25, 12122873 },
	{ 24, 6111227 },
	{ 25, 2703355 },
	{ 18, 129950 },
	{ 25, 2965503 },
	{ 25, 11354111 },
	{ 27, 19742719 },
	{ 27, 28131327 },
	{ 27, 53297151 },
	{ 27, 61685759 },
	{ 28, 134168315 },
	{ 28, 133906171 },
	{ 28, 133119739 },
	{ 28, 132857595 },
	{ 28, 125779707 },
	{ 28, 125517563 },
	{ 28, 124731131 },
	{ 28, 129825785 },
	{ 27, 62865147 },
	{ 27, 62603003 },
	{ 27, 61816571 },
	{ 27, 62716921 },
	{ 26, 31407867 },
	{ 26, 31145723 },
	{ 26, 22477821 },
	{ 25, 12385273 },
	{ 24, 7814907 },
	{ 24, 7552763 },
	{ 25, 15268857 },
	{ 24, 7683835 },
	{ 26, 25771771 },
	{ 26, 13451003 },
	{ 25, 12123129 },
	{ 24, 6110971 },
	{ 25, 2703099 },
	{ 18, 125854 },
	{ 25, 2965247 },
	{ 25, 11353855 },
	{ 27, 19742463 },
	{ 27, 28131071 },
	{ 27, 53296895 },
	{ 27, 61685503 },
	{ 28, 86851327 },
	{ 28, 117390331 },
	{ 28, 117128187 },
	{ 28, 116341755 },
	{ 28, 116079611 },
	{ 28, 109001723 },
	{ 28, 108739579 },
	{ 28, 129957629 },
	{ 27, 62798847 },
	{ 27, 54475771 },
	{ 27, 54213627 },
	{ 27, 62848765 },
	{ 26, 31341567 },
	{ 26, 27212795 },
	{ 26, 26950651 },
	{ 25, 12517117 },
	{ 24, 7748607 },
	{ 24, 6765563 },
	{ 24, 6503419 },
	{ 24, 7420923 },
	{ 24, 6634491 },
	{ 26, 13188091 },
	{ 25, 11599609 },
	{ 24, 5848059 },
	{ 24, 1915899 },
	{ 18, 121630 },
	{ 25, 2702335 },
	{ 25, 11090943 },
	{ 27, 19479551 },
	{ 27, 27868159 },
	{ 27, 53033983 },
	{ 27, 61422591 },
	{ 28, 134101759 },
	{ 28, 117390075 },
	{ 28, 117127931 },
	{ 28, 116341499 },
	{ 28, 116079355 },
	{ 28, 109001467 },
	{ 28, 108739323 },
	{ 28, 129957885 },
	{ 27, 62798591 },
	{ 27, 54475515 },
	{ 27, 54213371 },
	{ 27, 62849021 },
	{ 26, 31341311 },
	{ 26, 27212539 },
	{ 26, 26950395 },
	{ 25, 12517373 },
	{ 24, 7748351 },
	{ 24, 6765307 },
	{ 24, 6503163 },
	{ 24, 7420667 },
	{ 24, 6634235 },
	{ 26, 13187835 },
	{ 25, 11599865 },
	{ 24, 5847803 },
	{ 24, 1915643 },
	{ 18, 117534 },
	{ 25, 2702079 },
	{ 25, 11090687 },
	{ 27, 19479295 },
	{ 27, 27867903 },
	{ 27, 53033727 },
	{ 27, 61422335 },
	{ 28, 86588159 },
	{ 28, 94976767 },
	{ 28, 67055611 },
	{ 28, 66793467 },
	{ 28, 66007035 },
	{ 28, 65744891 },
	{ 28, 58667003 },
	{ 28, 58404859 },
	{ 28, 57618427 },
	{ 27, 54407167 },
	{ 27, 29306875 },
	{ 27, 29044731 },
	{ 27, 28258299 },
	{ 26, 27144191 },
	{ 26, 14626811 },
	{ 26, 14364667 },
	{ 26, 23964413 },
	{ 24, 6696959 },
	{ 24, 3616763 },
	{ 24, 3354619 },
	{ 24, 6369275 },
	{ 24, 3485691 },
	{ 26, 20032249 },
	{ 24, 5058555 },
	{ 24, 1650683 },
	{ 18, 96670 },
	{ 24, 1912831 },
	{ 24, 6107135 },
	{ 26, 10301439 },
	{ 26, 14495743 },
	{ 26, 27078655 },
	{ 26, 31272959 },
	{ 27, 43855871 },
	{ 27, 48050175 },
	{ 27, 60633087 },
	{ 27, 64827391 },
	{ 28, 66006779 },
	{ 28, 65744635 },
	{ 28, 58666747 },
	{ 28, 58404603 },
	{ 28, 57618171 },
	{ 27, 54406911 },
	{ 27, 29306619 },
	{ 27, 29044475 },
	{ 27, 28258043 },
	{ 26, 27143935 },
	{ 26, 14626555 },
	{ 26, 14364411 },
	{ 26, 23964669 },
	{ 24, 6696703 },
	{ 24, 3616507 },
	{ 24, 3354363 },
	{ 24, 6369019 },
	{ 24, 3485435 },
	{ 26, 20032505 },
	{ 24, 5058299 },
	{ 24, 1650427 },
	{ 18, 92574 },
	{ 24, 1912575 },
	{ 24, 6106879 },
	{ 26, 10301183 },
	{ 26, 14495487 },
	{ 26, 27078399 },
	{ 26, 31272703 },
	{ 27, 43855615 },
	{ 27, 48049919 },
	{ 27, 60632831 },
	{ 27, 64827135 },
	{ 28, 50015227 },
	{ 28, 49228795 },
	{ 28, 48966651 },
	{ 28, 41888763 },
	{ 28, 41626619 },
	{ 28, 40840187 },
	{ 27, 29240319 },
	{ 27, 20917243 },
	{ 27, 20655099 },
	{ 27, 19868667 },
	{ 26, 14560255 },
	{ 26, 10431483 },
	{ 26, 10169339 },
	{ 26, 20819709 },
	{ 24, 3550207 },
	{ 24, 2567163 },
	{ 24, 2305019 },
	{ 24, 3222523 },
	{ 24, 2436091 },
	{ 24, 4795387 },
	{ 24, 863227 },
	{ 18, 88350 },
	{ 24, 1649663 },
	{ 24, 5843967 },
	{ 26, 10038271 },
	{ 26, 14232575 },
	{ 26, 26815487 },
	{ 26, 31009791 },
	{ 27, 43592703 },
	{ 27, 47787007 },
	{ 27, 60369919 },
	{ 27, 64564223 },
	{ 28, 50014971 },
	{ 28, 49228539 },
	{ 28, 48966395 },
	{ 28, 41888507 },
	{ 28, 41626363 },
	{ 28, 40839931 },
	{ 27, 29240063 },
	{ 27, 20916987 },
	{ 27, 20654843 },
	{ 27, 19868411 },
	{ 26, 14559999 },
	{ 26, 10431227 },
	{ 26, 10169083 },
	{ 26, 20819965 },
	{ 24, 3549951 },
	{ 24, 2566907 },
	{ 24, 2304763 },
	{ 24, 3222267 },
	{ 24, 2435835 },
	{ 24, 4795131 },
	{ 24, 862971 },
	{ 18, 84254 },
	{ 24, 1649407 },
	{ 24, 5843711 },
	{ 26, 10038015 },
	{ 26, 14232319 },
	{ 26, 26815231 },
	{ 26, 31009535 },
	{ 27, 43592447 },
	{ 27, 47786751 },
	{ 27, 60369663 },
	{ 26, 12558335 },
	{ 24, 8380411 },
	{ 24, 8314875 },
	{ 24, 8118267 },
	{ 24, 8052731 },
	{ 24, 6283259 },
	{ 24, 6217723 },
	{ 24, 6021115 },
	{ 24, 5955579 },
	{ 23, 3137531 },
	{ 23, 3071995 },
	{ 23, 2875387 },
	{ 23, 2809851 },
	{ 22, 1564667 },
	{ 22, 1499131 },
	{ 22, 1302523 },
	{ 22, 1236987 },
	{ 20, 385019 },
	{ 20, 319483 },
	{ 22, 548859 },
	{ 20, 352251 },
	{ 22, 155643 },
	{ 15, 16030 },
	{ 22, 221183 },
	{ 22, 1269759 },
	{ 24, 2318335 },
	{ 24, 3366911 },
	{ 24, 6512639 },
	{ 24, 7561215 },
	{ 25, 10706943 },
	{ 25, 11755519 },
	{ 25, 14901247 },
	{ 25, 15949823 },
	{ 24, 8380155 },
	{ 24, 8314619 },
	{ 24, 8118011 },
	{ 24, 8052475 },
	{ 24, 6283003 },
	{ 24, 6217467 },
	{ 24, 6020859 },
	{ 24, 5955323 },
	{ 23, 3137275 },
	{ 23, 3071739 },
	{ 23, 2875131 },
	{ 23, 2809595 },
	{ 22, 1564411 },
	{ 22, 1498875 },
	{ 22, 1302267 },
	{ 22, 1236731 },
	{ 20, 384763 },
	{ 20, 319227 },
	{ 22, 548603 },
	{ 20, 351995 },
	{ 22, 155387 },
	{ 15, 15006 },
	{ 22, 220927 },
	{ 22, 1269503 },
	{ 24, 2318079 },
	{ 24, 3366655 },
	{ 24, 6512383 },
	{ 24, 7560959 },
	{ 25, 10706687 },
	{ 25, 11755263 },
	{ 25, 14900991 },
	{ 25, 15949567 },
	{ 24, 8363007 },
	{ 24, 4185083 },
	{ 24, 4119547 },
	{ 24, 3922939 },
	{ 24, 3857403 },
	{ 24, 2087931 },
	{ 24, 2022395 },
	{ 24, 1825787 },
	{ 23, 3120127 },
	{ 23, 1039355 },
	{ 23, 973819 },
	{ 23, 777211 },
	{ 22, 1547263 },
	{ 22, 515067 },
	{ 22, 449531 },
	{ 22, 252923 },
	{ 20, 367615 },
	{ 20, 121851 },
	{ 20, 56315 },
	{ 16, 28539 },
	{ 16, 32699 },
	{ 15, 13854 },
	{ 22, 154623 },
	{ 22, 1203199 },
	{ 24, 2251775 },
	{ 24, 3300351 },
	{ 24, 6446079 },
	{ 24, 7494655 },
	{ 25, 10640383 },
	{ 25, 11688959 },
	{ 25, 14834687 },
	{ 25, 15883263 },
	{ 24, 8362751 },
	{ 24, 4184827 },
	{ 24, 4119291 },
	{ 24, 3922683 },
	{ 24, 3857147 },
	{ 24, 2087675 },
	{ 24, 2022139 },
	{ 24, 1825531 },
	{ 23, 3119871 },
	{ 23, 1039099 },
	{ 23, 973563 },
	{ 23, 776955 },
	{ 22, 1547007 },
	{ 22, 514811 },
	{ 22, 449275 },
	{ 22, 252667 },
	{ 20, 367359 },
	{ 20, 121595 },
	{ 20, 56059 },
	{ 16, 26491 },
	{ 15, 15995 },
	{ 15, 12830 },
	{ 22, 154367 },
	{ 22, 1202943 },
	{ 24, 2251519 },
	{ 24, 3300095 },
	{ 24, 6445823 },
	{ 24, 7494399 },
	{ 25, 10640127 },
	{ 25, 11688703 },
	{ 25, 14834431 },
	{ 25, 15883007 },
	{ 26, 27417343 },
	{ 24, 4165631 },
	{ 24, 4100095 },
	{ 24, 3903487 },
	{ 24, 3837951 },
	{ 24, 2068479 },
	{ 24, 2002943 },
	{ 24, 1806335 },
	{ 24, 1740799 },
	{ 23, 1019903 },
	{ 23, 954367 },
	{ 23, 757759 },
	{ 23, 692223 },
	{ 22, 495615 },
	{ 22, 430079 },
	{ 22, 233471 },
	{ 22, 167935 },
	{ 20, 102399 },
	{ 20, 36863 },
	{ 13, 3903 },
	{ 13, 3947 },
	{ 13, 3902 },
	{ 15, 16319 },
	{ 20, 348159 },
	{ 22, 610303 },
	{ 22, 872447 },
	{ 22, 1658879 },
	{ 22, 1921023 },
	{ 23, 2707455 },
	{ 23, 2969599 },
	{ 23, 3756031 },
	{ 23, 4018175 },
	{ 24, 6901759 },
	{ 24, 4165375 },
	{ 24, 4099839 },
	{ 24, 3903231 },
	{ 24, 3837695 },
	{ 24, 2068223 },
	{ 24, 2002687 },
	{ 24, 1806079 },
	{ 24, 1740543 },
	{ 23, 1019647 },
	{ 23, 954111 },
	{ 23, 757503 },
	{ 23, 691967 },
	{ 22, 495359 },
	{ 22, 429823 },
	{ 22, 233215 },
	{ 22, 167679 },
	{ 20, 102143 },
	{ 20, 36607 },
	{ 13, 4079 },
	{ 10, 475 },
	{ 10, 462 },
	{ 14, 7807 },
	{ 20, 347903 },
	{ 22, 610047 },
	{ 22, 872191 },
	{ 22, 1658623 },
	{ 22, 1920767 },
	{ 23, 2707199 },
	{ 23, 2969343 },
	{ 23, 3755775 },
	{ 23, 4017919 },
	{ 24, 6901503 },
	{ 24, 7163647 },
	{ 24, 7950079 },
	{ 24, 8212223 },
	{ 24, 15290111 },
	{ 24, 15552255 },
	{ 24, 16338687 },
	{ 24, 16600831 },
	{ 24, 7867391 },
	{ 24, 7080959 },
	{ 24, 6818815 },
	{ 23, 3935231 },
	{ 23, 3673087 },
	{ 23, 2886655 },
	{ 23, 2624511 },
	{ 22, 1838079 },
	{ 22, 1575935 },
	{ 22, 789503 },
	{ 22, 527359 },
	{ 16, 11647 },
	{ 9, 207 },
	{ 10, 398 },
	{ 12, 1903 },
	{ 16, 12159 },
	{ 22, 543743 },
	{ 22, 805887 },
	{ 22, 1592319 },
	{ 22, 1854463 },
	{ 23, 2640895 },
	{ 23, 2903039 },
	{ 23, 3689471 },
	{ 23, 3951615 },
	{ 24, 6835199 },
	{ 24, 7097343 },
	{ 24, 7883775 },
	{ 24, 16517887 },
	{ 24, 16255743 },
	{ 24, 15469311 },
	{ 24, 15207167 },
	{ 24, 8129279 },
	{ 24, 7867135 },
	{ 24, 7080703 },
	{ 24, 6818559 },
	{ 23, 3934975 },
	{ 23, 3672831 },
	{ 23, 2886399 },
	{ 23, 2624255 },
	{ 22, 1837823 },
	{ 22, 1575679 },
	{ 22, 789247 },
	{ 22, 527103 },
	{ 16, 9599 },
	{ 10, 431 },
	{ 24, 126973 },
	{ 9, 223 },
	{ 16, 10111 },
	{ 22, 543487 },
	{ 22, 805631 },
	{ 22, 1592063 },
	{ 22, 1854207 },
	{ 23, 2640639 },
	{ 23, 2902783 },
	{ 23, 3689215 },
	{ 23, 3951359 },
	{ 24, 6834943 },
	{ 24, 7097087 },
	{ 24, 7883519 },
	{ 22, 4147199 },
	{ 22, 4081663 },
	{ 22, 3885055 },
	{ 22, 3819519 },
	{ 22, 2050047 },
	{ 22, 1984511 },
	{ 22, 1787903 },
	{ 22, 1722367 },
	{ 21, 1001471 },
	{ 21, 935935 },
	{ 21, 739327 },
	{ 21, 673791 },
	{ 20, 477183 },
	{ 20, 411647 },
	{ 20, 215039 },
	{ 20, 149503 },
	{ 18, 83967 },
	{ 12, 1727 },
	{ 10, 478 },
	{ 8, 75 },
	{ 11, 827 },
	{ 18, 14335 },
	{ 18, 79871 },
	{ 20, 145407 },
	{ 20, 210943 },
	{ 20, 407551 },
	{ 20, 473087 },
	{ 21, 669695 },
	{ 21, 735231 },
	{ 21, 931839 },
	{ 21, 997375 },
	{ 22, 1718271 },
	{ 22, 4146943 },
	{ 22, 4081407 },
	{ 22, 3884799 },
	{ 22, 3819263 },
	{ 22, 2049791 },
	{ 22, 1984255 },
	{ 22, 1787647 },
	{ 22, 1722111 },
	{ 21, 1001215 },
	{ 21, 935679 },
	{ 21, 739071 },
	{ 21, 673535 },
	{ 20, 476927 },
	{ 20, 411391 },
	{ 20, 214783 },
	{ 20, 149247 },
	{ 18, 83711 },
	{ 13, 3519 },
	{ 10, 350 },
	{ 9, 171 },
	{ 11, 1003 },
	{ 18, 14079 },
	{ 18, 79615 },
	{ 20, 145151 },
	{ 20, 210687 },
	{ 20, 407295 },
	{ 20, 472831 },
	{ 21, 669439 },
	{ 21, 734975 },
	{ 21, 931583 },
	{ 21, 997119 },
	{ 22, 1718015 },
	{ 22, 1783551 },
	{ 22, 1980159 },
	{ 22, 2045695 },
	{ 22, 3815167 },
	{ 22, 3880703 },
	{ 22, 4077311 },
	{ 22, 4142847 },
	{ 24, 6849535 },
	{ 23, 3965951 },
	{ 23, 3703807 },
	{ 23, 2917375 },
	{ 23, 2655231 },
	{ 22, 1868799 },
	{ 22, 1606655 },
	{ 22, 820223 },
	{ 22, 558079 },
	{ 20, 295935 },
	{ 20, 33791 },
	{ 13, 1646 },
	{ 11, 699 },
	{ 14, 3451 },
	{ 18, 9211 },
	{ 18, 74747 },
	{ 18, 95231 },
	{ 20, 205819 },
	{ 20, 402427 },
	{ 20, 467963 },
	{ 20, 488447 },
	{ 21, 730107 },
	{ 21, 926715 },
	{ 21, 992251 },
	{ 21, 1012735 },
	{ 22, 1778683 },
	{ 22, 1975291 },
	{ 22, 2040827 },
	{ 22, 3810299 },
	{ 22, 3875835 },
	{ 22, 4072443 },
	{ 22, 4137979 },
	{ 22, 4158463 },
	{ 23, 3965695 },
	{ 23, 3703551 },
	{ 23, 2917119 },
	{ 23, 2654975 },
	{ 22, 1868543 },
	{ 22, 1606399 },
	{ 22, 819967 },
	{ 22, 557823 },
	{ 20, 295679 },
	{ 20, 33535 },
	{ 13, 622 },
	{ 12, 1467 },
	{ 14, 1403 },
	{ 18, 8955 },
	{ 18, 74491 },
	{ 18, 94975 },
	{ 20, 205563 },
	{ 20, 402171 },
	{ 20, 467707 },
	{ 20, 488191 },
	{ 21, 729851 },
	{ 21, 926459 },
	{ 21, 991995 },
	{ 21, 1012479 },
	{ 22, 1778427 },
	{ 22, 1975035 },
	{ 22, 2040571 },
	{ 22, 3810043 },
	{ 22, 3875579 },
	{ 22, 4072187 },
	{ 22, 4137723 },
	{ 22, 4158207 },
	{ 21, 995839 },
	{ 21, 930303 },
	{ 21, 733695 },
	{ 21, 668159 },
	{ 20, 471551 },
	{ 20, 406015 },
	{ 20, 209407 },
	{ 20, 143871 },
	{ 18, 78335 },
	{ 18, 12799 },
	{ 11, 1262 },
	{ 18, 8699 },
	{ 16, 20987 },
	{ 18, 33275 },
	{ 16, 6651 },
	{ 16, 23035 },
	{ 18, 39419 },
	{ 18, 55803 },
	{ 18, 104955 },
	{ 18, 121339 },
	{ 19, 170491 },
	{ 19, 186875 },
	{ 19, 236027 },
	{ 19, 252411 },
	{ 20, 432635 },
	{ 20, 449019 },
	{ 20, 498171 },
	{ 20, 514555 },
	{ 20, 956923 },
	{ 20, 973307 },
	{ 20, 1022459 },
	{ 20, 1038843 },
	{ 21, 996605 },
	{ 21, 931069 },
	{ 21, 734461 },
	{ 21, 668925 },
	{ 20, 472317 },
	{ 20, 406781 },
	{ 20, 210173 },
	{ 20, 144637 },
	{ 18, 79101 },
	{ 18, 13565 },
	{ 11, 154 },
	{ 18, 9465 },
	{ 16, 21753 },
	{ 18, 34041 },
	{ 16, 19705 },
	{ 16, 23801 },
	{ 18, 77049 },
	{ 18, 81145 },
	{ 18, 93433 },
	{ 18, 97529 },
	{ 19, 175353 },
	{ 19, 179449 },
	{ 19, 191737 },
	{ 19, 195833 },
	{ 20, 371961 },
	{ 20, 376057 },
	{ 20, 388345 },
	{ 20, 392441 },
	{ 20, 503033 },
	{ 20, 507129 },
	{ 20, 519417 },
	{ 20, 523513 },
	{ 21, 996861 },
	{ 21, 931325 },
	{ 21, 734717 },
	{ 21, 669181 },
	{ 20, 472573 },
	{ 20, 407037 },
	{ 20, 210429 },
	{ 20, 144893 },
	{ 18, 79357 },
	{ 18, 13821 },
	{ 11, 1178 },
	{ 18, 9721 },
	{ 16, 22009 },
	{ 18, 34297 },
	{ 16, 19961 },
	{ 16, 24057 },
	{ 18, 77305 },
	{ 18, 81401 },
	{ 18, 93689 },
	{ 18, 97785 },
	{ 19, 175609 },
	{ 19, 179705 },
	{ 19, 191993 },
	{ 19, 196089 },
	{ 20, 372217 },
	{ 20, 376313 },
	{ 20, 388601 },
	{ 20, 392697 },
	{ 20, 503289 },
	{ 20, 507385 },
	{ 20, 519673 },
	{ 20, 523769 },
	{ 22, 784893 },
	{ 23, 3773181 },
	{ 23, 2986749 },
	{ 23, 2724605 },
	{ 22, 1938173 },
	{ 22, 1676029 },
	{ 22, 889597 },
	{ 22, 627453 },
	{ 20, 365309 },
	{ 20, 103165 },
	{ 15, 2330 },
	{ 20, 54009 },
	{ 20, 299769 },
	{ 20, 152313 },
	{ 20, 201465 },
	{ 20, 144121 },
	{ 20, 160505 },
	{ 20, 221949 },
	{ 22, 586489 },
	{ 22, 635641 },
	{ 22, 652025 },
	{ 22, 910077 },
	{ 23, 1241849 },
	{ 23, 1291001 },
	{ 23, 1307385 },
	{ 23, 1827581 },
	{ 24, 2552569 },
	{ 24, 2601721 },
	{ 24, 2618105 },
	{ 24, 3060473 },
	{ 24, 3076857 },
	{ 24, 3126009 },
	{ 23, 4035581 },
	{ 23, 3773437 },
	{ 23, 2987005 },
	{ 23, 2724861 },
	{ 22, 1938429 },
	{ 22, 1676285 },
	{ 22, 889853 },
	{ 22, 627709 },
	{ 20, 365565 },
	{ 20, 103421 },
	{ 15, 6426 },
	{ 20, 54265 },
	{ 20, 300025 },
	{ 20, 152569 },
	{ 20, 201721 },
	{ 20, 144377 },
	{ 20, 160761 },
	{ 20, 222205 },
	{ 22, 586745 },
	{ 22, 635897 },
	{ 22, 652281 },
	{ 22, 910333 },
	{ 23, 1242105 },
	{ 23, 1291257 },
	{ 23, 1307641 },
	{ 23, 1827837 },
	{ 24, 2552825 },
	{ 24, 2601977 },
	{ 24, 2618361 },
	{ 24, 3060729 },
	{ 24, 3077113 },
	{ 24, 3126265 },
	{ 23, 4052733 },
	{ 23, 3790589 },
	{ 23, 3004157 },
	{ 23, 2742013 },
	{ 22, 1955581 },
	{ 22, 1693437 },
	{ 22, 907005 },
	{ 22, 644861 },
	{ 20, 382717 },
	{ 20, 120573 },
	{ 15, 10650 },
	{ 20, 104185 },
	{ 20, 317177 },
	{ 22, 562937 },
	{ 20, 218873 },
	{ 20, 399097 },
	{ 20, 210681 },
	{ 20, 227065 },
	{ 20, 419581 },
	{ 22, 849657 },
	{ 22, 898809 },
	{ 22, 915193 },
	{ 22, 1697533 },
	{ 23, 1767161 },
	{ 23, 1816313 },
	{ 23, 1832697 },
	{ 23, 3401469 },
	{ 24, 3602169 },
	{ 24, 3651321 },
	{ 24, 3667705 },
	{ 24, 4110073 },
	{ 24, 4126457 },
	{ 23, 4052989 },
	{ 23, 3790845 },
	{ 23, 3004413 },
	{ 23, 2742269 },
	{ 22, 1955837 },
	{ 22, 1693693 },
	{ 22, 907261 },
	{ 22, 645117 },
	{ 20, 382973 },
	{ 20, 120829 },
	{ 15, 14746 },
	{ 20, 104441 },
	{ 20, 317433 },
	{ 22, 563193 },
	{ 20, 219129 },
	{ 20, 399353 },
	{ 20, 210937 },
	{ 20, 227321 },
	{ 20, 419837 },
	{ 22, 849913 },
	{ 22, 899065 },
	{ 22, 915449 },
	{ 22, 1697789 },
	{ 23, 1767417 },
	{ 23, 1816569 },
	{ 23, 1832953 },
	{ 23, 3401725 },
	{ 24, 3602425 },
	{ 24, 3651577 },
	{ 24, 3667961 },
	{ 24, 4110329 },
	{ 24, 4126713 },
	{ 24, 4175865 },
	{ 24, 4192249 },
	{ 24, 7333885 },
	{ 26, 21646077 },
	{ 25, 15354621 },
	{ 25, 13257469 },
	{ 25, 6966013 },
	{ 25, 4868861 },
	{ 23, 2771709 },
	{ 23, 674557 },
	{ 17, 19226 },
	{ 22, 477945 },
	{ 22, 1460985 },
	{ 24, 2312953 },
	{ 24, 3295993 },
	{ 22, 1657593 },
	{ 22, 1854201 },
	{ 22, 1624825 },
	{ 22, 1690361 },
	{ 22, 1936125 },
	{ 24, 6540025 },
	{ 24, 6736633 },
	{ 24, 6802169 },
	{ 24, 7834365 },
	{ 25, 13355769 },
	{ 25, 13552377 },
	{ 25, 13617913 },
	{ 25, 15698685 },
	{ 26, 26987257 },
	{ 26, 27183865 },
	{ 26, 27249401 },
	{ 26, 29018873 },
	{ 26, 29084409 },
	{ 26, 29281017 },
	{ 26, 29346553 },
	{ 26, 33524477 },
	{ 25, 15354877 },
	{ 25, 13257725 },
	{ 25, 6966269 },
	{ 25, 4869117 },
	{ 23, 2771965 },
	{ 23, 674813 },
	{ 17, 23322 },
	{ 22, 478201 },
	{ 22, 1461241 },
	{ 24, 2313209 },
	{ 24, 3296249 },
	{ 22, 1657849 },
	{ 22, 1854457 },
	{ 22, 1625081 },
	{ 22, 1690617 },
	{ 22, 1936381 },
	{ 24, 6540281 },
	{ 24, 6736889 },
	{ 24, 6802425 },
	{ 24, 7834621 },
	{ 25, 13356025 },
	{ 25, 13552633 },
	{ 25, 13618169 },
	{ 25, 15698941 },
	{ 26, 26987513 },
	{ 26, 27184121 },
	{ 26, 27249657 },
	{ 26, 29019129 },
	{ 26, 29084665 },
	{ 26, 29281273 },
	{ 26, 29346809 },
	{ 26, 21712637 },
	{ 25, 15421181 },
	{ 25, 13324029 },
	{ 25, 7032573 },
	{ 25, 4935421 },
	{ 23, 2838269 },
	{ 23, 741117 },
	{ 17, 27546 },
	{ 23, 675577 },
	{ 22, 1527545 },
	{ 24, 2510585 },
	{ 24, 3362553 },
	{ 24, 6442745 },
	{ 22, 1920761 },
	{ 23, 2641657 },
	{ 22, 1887993 },
	{ 22, 1953529 },
	{ 23, 2723581 },
	{ 24, 7589625 },
	{ 24, 7786233 },
	{ 24, 7851769 },
	{ 25, 15388409 },
	{ 25, 15453945 },
	{ 25, 15650553 },
	{ 25, 15716089 },
	{ 26, 31117049 },
	{ 26, 31182585 },
	{ 26, 31379193 },
	{ 26, 31444729 },
	{ 26, 33214201 },
	{ 26, 33279737 },
	{ 26, 33476345 },
	{ 26, 33541881 },
	{ 25, 15421437 },
	{ 25, 13324285 },
	{ 25, 7032829 },
	{ 25, 4935677 },
	{ 23, 2838525 },
	{ 23, 741373 },
	{ 17, 31642 },
	{ 23, 675833 },
	{ 22, 1527801 },
	{ 24, 2510841 },
	{ 24, 3362809 },
	{ 24, 6443001 },
	{ 22, 1921017 },
	{ 23, 2641913 },
	{ 22, 1888249 },
	{ 22, 1953785 },
	{ 23, 2723837 },
	{ 24, 7589881 },
	{ 24, 7786489 },
	{ 24, 7852025 },
	{ 25, 15388665 },
	{ 25, 15454201 },
	{ 25, 15650809 },
	{ 25, 15716345 },
	{ 26, 31117305 },
	{ 26, 31182841 },
	{ 26, 31379449 },
	{ 26, 31444985 },
	{ 26, 33214457 },
	{ 26, 33279993 },
	{ 26, 33476601 },
	{ 26, 33542137 },
	{ 25, 15620861 },
	{ 25, 13523709 },
	{ 25, 7232253 },
	{ 25, 5135101 },
	{ 23, 3037949 },
	{ 23, 940797 },
	{ 18, 103706 },
	{ 23, 744185 },
	{ 23, 2775801 },
	{ 24, 2579193 },
	{ 24, 3562233 },
	{ 24, 6511353 },
	{ 24, 7494393 },
	{ 23, 2710265 },
	{ 23, 2906873 },
	{ 23, 2677497 },
	{ 23, 2743033 },
	{ 23, 2988797 },
	{ 25, 10738425 },
	{ 25, 10935033 },
	{ 25, 11000569 },
	{ 25, 12032765 },
	{ 26, 21748473 },
	{ 26, 21945081 },
	{ 26, 22010617 },
	{ 26, 24091389 },
	{ 27, 43768569 },
	{ 27, 43965177 },
	{ 26, 32398333 },
	{ 26, 30301181 },
	{ 26, 24009725 },
	{ 26, 21912573 },
	{ 25, 15621117 },
	{ 25, 13523965 },
	{ 25, 7232509 },
	{ 25, 5135357 },
	{ 23, 3038205 },
	{ 23, 941053 },
	{ 18, 111898 },
	{ 23, 744441 },
	{ 23, 2776057 },
	{ 24, 2579449 },
	{ 24, 3562489 },
	{ 24, 6511609 },
	{ 24, 7494649 },
	{ 23, 2710521 },
	{ 23, 2907129 },
	{ 23, 2677753 },
	{ 23, 2743289 },
	{ 23, 2989053 },
	{ 25, 10738681 },
	{ 25, 10935289 },
	{ 25, 11000825 },
	{ 25, 12033021 },
	{ 26, 21748729 },
	{ 26, 21945337 },
	{ 26, 22010873 },
	{ 26, 24091645 },
	{ 27, 43768825 },
	{ 27, 43965433 },
	{ 26, 32464637 },
	{ 26, 30367485 },
	{ 26, 24076029 },
	{ 26, 21978877 },
	{ 25, 15687421 },
	{ 25, 13590269 },
	{ 25, 7298813 },
	{ 25, 5201661 },
	{ 23, 3104509 },
	{ 23, 1007357 },
	{ 18, 120218 },
	{ 23, 941817 },
	{ 23, 2842361 },
	{ 25, 4873977 },
	{ 24, 3628793 },
	{ 24, 6708985 },
	{ 24, 7560953 },
	{ 25, 10641145 },
	{ 23, 2973433 },
	{ 23, 3694329 },
	{ 23, 2940665 },
	{ 23, 3006201 },
	{ 23, 3776253 },
	{ 25, 11788025 },
	{ 25, 11984633 },
	{ 25, 12050169 },
	{ 25, 15179517 },
	{ 26, 23846649 },
	{ 26, 24043257 },
	{ 26, 24108793 },
	{ 26, 30383869 },
	{ 27, 47963897 },
	{ 26, 32464893 },
	{ 26, 30367741 },
	{ 26, 24076285 },
	{ 26, 21979133 },
	{ 25, 15687677 },
	{ 25, 13590525 },
	{ 25, 7299069 },
	{ 25, 5201917 },
	{ 23, 3104765 },
	{ 23, 1007613 },
	{ 18, 128410 },
	{ 23, 942073 },
	{ 23, 2842617 },
	{ 25, 4874233 },
	{ 24, 3629049 },
	{ 24, 6709241 },
	{ 24, 7561209 },
	{ 25, 10641401 },
	{ 23, 2973689 },
	{ 23, 3694585 },
	{ 23, 2940921 },
	{ 23, 3006457 },
	{ 23, 3776509 },
	{ 25, 11788281 },
	{ 25, 11984889 },
	{ 25, 12050425 },
	{ 25, 15179773 },
	{ 26, 23846905 },
	{ 26, 24043513 },
	{ 26, 24109049 },
	{ 26, 30384125 },
	{ 27, 47964153 },
	{ 27, 64954361 },
	{ 27, 62529529 },
	{ 27, 50012153 },
	{ 27, 46014457 },
	{ 26, 33497081 },
	{ 27, 50323449 },
	{ 27, 62889981 },
	{ 28, 40446717 },
	{ 26, 23669501 },
	{ 26, 6892285 },
	{ 19, 169754 },
	{ 25, 4008697 },
	{ 25, 12135161 },
	{ 27, 19737337 },
	{ 27, 27863801 },
	{ 26, 27077369 },
	{ 26, 31009529 },
	{ 27, 42806009 },
	{ 27, 46738169 },
	{ 25, 15018745 },
	{ 25, 15805177 },
	{ 25, 14887673 },
	{ 25, 15149817 },
	{ 25, 16132861 },
	{ 27, 59714297 },
	{ 27, 60500729 },
	{ 27, 60762873 },
	{ 27, 64891645 },
	{ 28, 120531705 },
	{ 28, 121318137 },
	{ 28, 121580281 },
	{ 28, 129903357 },
	{ 29, 259533561 },
	{ 29, 243018489 },
	{ 29, 199764729 },
	{ 29, 183249657 },
	{ 28, 133704441 },
	{ 28, 117189369 },
	{ 28, 57224189 },
	{ 28, 40446973 },
	{ 26, 23669757 },
	{ 26, 6892541 },
	{ 19, 177946 },
	{ 25, 4008953 },
	{ 25, 12135417 },
	{ 27, 19737593 },
	{ 27, 27864057 },
	{ 26, 27077625 },
	{ 26, 31009785 },
	{ 27, 42806265 },
	{ 27, 46738425 },
	{ 25, 15019001 },
	{ 25, 15805433 },
	{ 25, 14887929 },
	{ 25, 15150073 },
	{ 25, 16133117 },
	{ 27, 59714553 },
	{ 27, 60500985 },
	{ 27, 60763129 },
	{ 27, 64891901 },
	{ 28, 120531961 },
	{ 28, 121318393 },
	{ 28, 121580537 },
	{ 28, 129903613 },
	{ 29, 259533817 },
	{ 29, 243018745 },
	{ 29, 199764985 },
	{ 29, 183249913 },
	{ 28, 133704697 },
	{ 28, 117189625 },
	{ 28, 57487101 },
	{ 28, 40709885 },
	{ 26, 23932669 },
	{ 26, 7155453 },
	{ 19, 186266 },
	{ 26, 6893305 },
	{ 25, 12398329 },
	{ 27, 20524793 },
	{ 27, 28126969 },
	{ 27, 53030649 },
	{ 26, 31272697 },
	{ 27, 43593465 },
	{ 27, 47001337 },
	{ 27, 59322105 },
	{ 25, 16068345 },
	{ 26, 27340537 },
	{ 25, 15937273 },
	{ 25, 16199417 },
	{ 26, 27668221 },
	{ 27, 63909625 },
	{ 27, 64696057 },
	{ 27, 64958201 },
	{ 28, 128659193 },
	{ 28, 128921337 },
	{ 28, 129707769 },
	{ 28, 129969913 },
	{ 29, 258748153 },
	{ 29, 242757369 },
	{ 29, 192687865 },
	{ 29, 182988537 },
	{ 28, 132919033 },
	{ 28, 116928249 },
	{ 28, 66858745 },
	{ 28, 40710141 },
	{ 26, 23932925 },
	{ 26, 7155709 },
	{ 19, 194458 },
	{ 26, 6893561 },
	{ 25, 12398585 },
	{ 27, 20525049 },
	{ 27, 28127225 },
	{ 27, 53030905 },
	{ 26, 31272953 },
	{ 27, 43593721 },
	{ 27, 47001593 },
	{ 27, 59322361 },
	{ 25, 16068601 },
	{ 26, 27340793 },
	{ 25, 15937529 },
	{ 25, 16199673 },
	{ 26, 27668477 },
	{ 27, 63909881 },
	{ 27, 64696313 },
	{ 27, 64958457 },
	{ 28, 128659449 },
	{ 28, 128921593 },
	{ 28, 129708025 },
	{ 28, 129970169 },
	{ 29, 258748409 },
	{ 29, 242757625 },
	{ 29, 192688121 },
	{ 29, 182988793 },
	{ 28, 132919289 },
	{ 28, 116928505 },
	{ 28, 66859001 },
	{ 28, 41499389 },
	{ 26, 24722173 },
	{ 26, 7944957 },
	{ 20, 470298 },
	{ 26, 7158521 },
	{ 26, 23673593 },
	{ 27, 20790009 },
	{ 27, 28916473 },
	{ 27, 53295865 },
	{ 27, 61422329 },
	{ 27, 43858681 },
	{ 27, 47790841 },
	{ 27, 59587321 },
	{ 27, 63519481 },
	{ 26, 27605753 },
	{ 26, 28392185 },
	{ 26, 27474681 },
	{ 26, 27736825 },
	{ 26, 28719869 },
	{ 27, 48168959 },
	{ 28, 245119737 },
	{ 28, 111098617 },
	{ 28, 115227389 },
	{ 29, 230177529 },
	{ 29, 222051065 },
	{ 29, 258489081 },
	{ 29, 241974009 },
	{ 29, 192428793 },
	{ 29, 175913721 },
	{ 28, 132659961 },
	{ 28, 116144889 },
	{ 28, 66599673 },
	{ 28, 50084601 },
	{ 26, 24722429 },
	{ 26, 7945213 },
	{ 20, 486682 },
	{ 26, 7158777 },
	{ 26, 23673849 },
	{ 27, 20790265 },
	{ 27, 28916729 },
	{ 27, 53296121 },
	{ 27, 61422585 },
	{ 27, 43858937 },
	{ 27, 47791097 },
	{ 27, 59587577 },
	{ 27, 63519737 },
	{ 26, 27606009 },
	{ 26, 28392441 },
	{ 26, 27474937 },
	{ 26, 27737081 },
	{ 26, 28720125 },
	{ 27, 48168703 },
	{ 28, 245119993 },
	{ 28, 111098873 },
	{ 28, 115227645 },
	{ 29, 230177785 },
	{ 29, 222051321 },
	{ 29, 258489337 },
	{ 29, 241974265 },
	{ 29, 192429049 },
	{ 29, 175913977 },
	{ 28, 132660217 },
	{ 28, 116145145 },
	{ 28, 66599929 },
	{ 28, 50084857 },
	{ 26, 24985341 },
	{ 26, 8208125 },
	{ 20, 503194 },
	{ 26, 7945977 },
	{ 26, 23936761 },
	{ 27, 47774715 },
	{ 27, 29179641 },
	{ 27, 54083321 },
	{ 27, 61685497 },
	{ 28, 134102777 },
	{ 27, 48054009 },
	{ 27, 60374777 },
	{ 27, 63782649 },
	{ 26, 33439481 },
	{ 26, 16662265 },
	{ 26, 31538937 },
	{ 26, 66338553 },
	{ 26, 28786425 },
	{ 26, 31866621 },
	{ 27, 49740799 },
	{ 28, 131874553 },
	{ 28, 115293945 },
	{ 28, 127811325 },
	{ 29, 221789945 },
	{ 28, 129777401 },
	{ 29, 241712889 },
	{ 29, 191643385 },
	{ 29, 175652601 },
	{ 28, 125583097 },
	{ 28, 115883769 },
	{ 28, 65814265 },
	{ 28, 49823481 },
	{ 26, 33308409 },
	{ 26, 8208381 },
	{ 20, 507882 },
	{ 26, 7946233 },
	{ 26, 23937017 },
	{ 27, 47774459 },
	{ 27, 29179897 },
	{ 27, 54083577 },
	{ 27, 61685753 },
	{ 28, 134103033 },
	{ 27, 48054265 },
	{ 27, 60375033 },
	{ 27, 63782905 },
	{ 26, 33439737 },
	{ 26, 16662521 },
	{ 26, 31539193 },
	{ 26, 66338809 },
	{ 26, 28786681 },
	{ 26, 31866877 },
	{ 27, 49740543 },
	{ 28, 131874809 },
	{ 28, 115294201 },
	{ 28, 127811581 },
	{ 29, 221790201 },
	{ 28, 129777657 },
	{ 29, 241713145 },
	{ 29, 191643641 },
	{ 29, 175652857 },
	{ 28, 125583353 },
	{ 28, 115884025 },
	{ 28, 65814521 },
	{ 28, 49823737 },
	{ 26, 33308665 },
	{ 26, 15297277 },
	{ 20, 524266 },
	{ 26, 8219385 },
	{ 26, 24734457 },
	{ 27, 49344507 },
	{ 28, 57240313 },
	{ 27, 54356729 },
	{ 27, 62483193 },
	{ 28, 86862585 },
	{ 28, 133851897 },
	{ 27, 60648185 },
	{ 27, 64580345 },
	{ 26, 33516285 },
	{ 26, 33188601 },
	{ 26, 16411385 },
	{ 26, 66087673 },
	{ 26, 65301241 },
	{ 26, 31943417 },
	{ 26, 32926461 },
	{ 27, 50262015 },
	{ 28, 127691513 },
	{ 28, 127888121 },
	{ 28, 132016893 },
	{ 28, 129526521 },
	{ 28, 121400057 },
	{ 29, 191392505 },
	{ 29, 174877433 },
	{ 28, 125332217 },
	{ 28, 108817145 },
	{ 28, 65563385 },
	{ 28, 49048313 },
	{ 26, 33057529 },
	{ 26, 16542457 },
	{ 21, 868202 },
	{ 26, 8219641 },
	{ 26, 24734713 },
	{ 27, 49344251 },
	{ 28, 57240569 },
	{ 27, 54356985 },
	{ 27, 62483449 },
	{ 28, 86862841 },
	{ 28, 133852153 },
	{ 27, 60648441 },
	{ 27, 64580601 },
	{ 26, 33516541 },
	{ 26, 33188857 },
	{ 26, 16411641 },
	{ 26, 66087929 },
	{ 26, 65301497 },
	{ 26, 31943673 },
	{ 26, 32926717 },
	{ 27, 50261759 },
	{ 28, 127691769 },
	{ 28, 127888377 },
	{ 28, 132017149 },
	{ 28, 129526777 },
	{ 28, 121400313 },
	{ 29, 191392761 },
	{ 29, 174877689 },
	{ 28, 125332473 },
	{ 28, 108817401 },
	{ 28, 65563641 },
	{ 28, 49048569 },
	{ 26, 33057785 },
	{ 26, 16542713 },
	{ 21, 884586 },
	{ 26, 15298297 },
	{ 26, 24997625 },
	{ 27, 49867771 },
	{ 28, 57503481 },
	{ 28, 107572985 },
	{ 27, 62746361 },
	{ 28, 87650041 },
	{ 28, 95252217 },
	{ 28, 133066489 },
	{ 27, 64843513 },
	{ 28, 65957625 },
	{ 26, 33255165 },
	{ 26, 32403193 },
	{ 26, 15625977 },
	{ 26, 65040121 },
	{ 26, 62156537 },
	{ 26, 32993017 },
	{ 26, 61239037 },
	{ 27, 64416767 },
	{ 28, 115109625 },
	{ 28, 132083449 },
	{ 28, 128741113 },
	{ 28, 121138937 },
	{ 28, 96235257 },
	{ 29, 174616313 },
	{ 28, 124546809 },
	{ 28, 108556025 },
	{ 28, 58486521 },
	{ 28, 48787193 },
	{ 26, 32272121 },
	{ 26, 16281337 },
	{ 21, 900586 },
	{ 26, 15298553 },
	{ 26, 24997881 },
	{ 27, 49867515 },
	{ 28, 57503737 },
	{ 28, 107573241 },
	{ 27, 62746617 },
	{ 28, 87650297 },
	{ 28, 95252473 },
	{ 28, 133066745 },
	{ 27, 64843769 },
	{ 28, 65957881 },
	{ 26, 33255421 },
	{ 26, 32403449 },
	{ 26, 15626233 },
	{ 26, 65040377 },
	{ 26, 62156793 },
	{ 26, 32993273 },
	{ 26, 61239293 },
	{ 27, 64416511 },
	{ 28, 115109881 },
	{ 28, 132083705 },
	{ 28, 128741369 },
	{ 28, 121139193 },
	{ 28, 96235513 },
	{ 29, 174616569 },
	{ 28, 124547065 },
	{ 28, 108556281 },
	{ 28, 58486777 },
	{ 28, 48787449 },
	{ 26, 32272377 },
	{ 26, 16281593 },
	{ 21, 916970 },
	{ 21, 2096494 },
	{ 26, 32078585 },
	{ 27, 64012283 },
	{ 28, 58292985 },
	{ 28, 107838201 },
	{ 28, 124353273 },
	{ 28, 87915257 },
	{ 28, 96041721 },
	{ 28, 120421113 },
	{ 28, 132807417 },
	{ 28, 116030201 },
	{ 28, 65698553 },
	{ 26, 32471805 },
	{ 26, 32144121 },
	{ 26, 15366905 },
	{ 26, 61897465 },
	{ 26, 61111033 },
	{ 26, 61307641 },
	{ 26, 62290685 },
	{ 27, 64929791 },
	{ 28, 110918393 },
	{ 28, 128482041 },
	{ 28, 120355577 },
	{ 28, 95976185 },
	{ 28, 87849721 },
	{ 28, 124287737 },
	{ 28, 107772665 },
	{ 28, 58227449 },
	{ 28, 41712377 },
	{ 26, 32013049 },
	{ 26, 15497977 },
	{ 21, 998762 },
	{ 21, 2080110 },
	{ 26, 32078841 },
	{ 27, 64012027 },
	{ 28, 58293241 },
	{ 28, 107838457 },
	{ 28, 124353529 },
	{ 28, 87915513 },
	{ 28, 96041977 },
	{ 28, 120421369 },
	{ 28, 132807673 },
	{ 28, 116030457 },
	{ 28, 65698809 },
	{ 26, 32472061 },
	{ 26, 32144377 },
	{ 26, 15367161 },
	{ 26, 61897721 },
	{ 26, 61111289 },
	{ 26, 61307897 },
	{ 26, 62290941 },
	{ 27, 64929535 },
	{ 28, 110918649 },
	{ 28, 128482297 },
	{ 28, 120355833 },
	{ 28, 95976441 },
	{ 28, 87849977 },
	{ 28, 124287993 },
	{ 28, 107772921 },
	{ 28, 58227705 },
	{ 28, 41712633 },
	{ 26, 32013305 },
	{ 26, 15498233 },
	{ 21, 1015146 },
	{ 21, 2063854 },
	{ 26, 32341753 },
	{ 27, 64535547 },
	{ 28, 58556153 },
	{ 28, 108625657 },
	{ 28, 124616441 },
	{ 29, 259948281 },
	{ 28, 96304889 },
	{ 28, 121208569 },
	{ 28, 128810745 },
	{ 28, 125730553 },
	{ 28, 108953337 },
	{ 28, 58621689 },
	{ 26, 32210685 },
	{ 26, 25067257 },
	{ 26, 8290041 },
	{ 26, 60849913 },
	{ 26, 32800505 },
	{ 26, 62357241 },
	{ 26, 65437437 },
	{ 27, 66501631 },
	{ 27, 64782073 },
	{ 28, 120094457 },
	{ 28, 95190777 },
	{ 28, 87588601 },
	{ 27, 62684921 },
	{ 28, 107511545 },
	{ 28, 57442041 },
	{ 28, 41451257 },
	{ 26, 24936185 },
	{ 26, 15236857 },
	{ 21, 1028074 },
	{ 21, 2047470 },
	{ 26, 32342009 },
	{ 27, 64535291 },
	{ 28, 58556409 },
	{ 28, 108625913 },
	{ 28, 124616697 },
	{ 29, 259948537 },
	{ 28, 96305145 },
	{ 28, 121208825 },
	{ 28, 128811001 },
	{ 28, 125730809 },
	{ 28, 108953593 },
	{ 28, 58621945 },
	{ 26, 32210941 },
	{ 26, 25067513 },
	{ 26, 8290297 },
	{ 26, 60850169 },
	{ 26, 32800761 },
	{ 26, 62357497 },
	{ 26, 65437693 },
	{ 27, 66501375 },
	{ 27, 64782329 },
	{ 28, 120094713 },
	{ 28, 95191033 },
	{ 28, 87588857 },
	{ 27, 62685177 },
	{ 28, 107511801 },
	{ 28, 57442297 },
	{ 28, 41451513 },
	{ 26, 24936441 },
	{ 26, 15237113 },
	{ 21, 1044458 },
	{ 21, 1965934 },
	{ 26, 32276477 },
	{ 27, 66105339 },
	{ 28, 65830909 },
	{ 28, 116162557 },
	{ 28, 132939773 },
	{ 29, 183271421 },
	{ 29, 200048637 },
	{ 29, 242920185 },
	{ 29, 259173113 },
	{ 29, 251570941 },
	{ 29, 250915577 },
	{ 29, 217361145 },
	{ 29, 116697849 },
	{ 27, 50244349 },
	{ 27, 49588985 },
	{ 27, 16034553 },
	{ 27, 65055481 },
	{ 27, 63482617 },
	{ 27, 130984697 },
	{ 27, 132950781 },
	{ 27, 67022847 },
	{ 28, 121154297 },
	{ 28, 121286651 },
	{ 29, 173583097 },
	{ 28, 124824313 },
	{ 28, 108571385 },
	{ 28, 108703739 },
	{ 29, 81308409 },
	{ 27, 49326841 },
	{ 27, 16296697 },
	{ 21, 1912682 },
	{ 21, 1949550 },
	{ 27, 66235385 },
	{ 27, 66105083 },
	{ 29, 131247097 },
	{ 29, 217754617 },
	{ 29, 250784761 },
	{ 29, 250654459 },
	{ 30, 519351289 },
	{ 29, 242920441 },
	{ 29, 259173369 },
	{ 29, 251571197 },
	{ 29, 250915833 },
	{ 29, 217361401 },
	{ 29, 116698105 },
	{ 27, 50244605 },
	{ 27, 49589241 },
	{ 27, 16034809 },
	{ 27, 65055737 },
	{ 27, 63482873 },
	{ 27, 130984953 },
	{ 27, 132951037 },
	{ 27, 67022591 },
	{ 28, 121154553 },
	{ 28, 121286395 },
	{ 29, 173583353 },
	{ 28, 124824569 },
	{ 28, 108571641 },
	{ 28, 108703483 },
	{ 29, 81308665 },
	{ 27, 49327097 },
	{ 27, 16296953 },
	{ 21, 1929066 },
	{ 21, 1933294 },
	{ 27, 66760441 },
	{ 27, 66628603 },
	{ 29, 131772153 },
	{ 29, 231911161 },
	{ 29, 251309817 },
	{ 29, 251177979 },
	{ 30, 383430393 },
	{ 30, 517779193 },
	{ 29, 259698425 },
	{ 29, 259566587 },
	{ 29, 251047677 },
	{ 29, 249343737 },
	{ 29, 215789305 },
	{ 29, 115126009 },
	{ 27, 49721085 },
	{ 27, 48017145 },
	{ 27, 14462713 },
	{ 27, 62959353 },
	{ 27, 57192185 },
	{ 27, 133082873 },
	{ 27, 66890747 },
	{ 28, 120631033 },
	{ 28, 95989497 },
	{ 28, 96119803 },
	{ 28, 123252473 },
	{ 28, 108048121 },
	{ 28, 58240761 },
	{ 28, 58371067 },
	{ 27, 47755001 },
	{ 27, 15773433 },
	{ 21, 1945066 },
	{ 21, 1916910 },
	{ 27, 66760697 },
	{ 27, 66628347 },
	{ 29, 131772409 },
	{ 29, 231911417 },
	{ 29, 251310073 },
	{ 29, 251177723 },
	{ 30, 383430649 },
	{ 30, 517779449 },
	{ 29, 259698681 },
	{ 29, 259566331 },
	{ 29, 251047933 },
	{ 29, 249343993 },
	{ 29, 215789561 },
	{ 29, 115126265 },
	{ 27, 49721341 },
	{ 27, 48017401 },
	{ 27, 14462969 },
	{ 27, 62959609 },
	{ 27, 57192441 },
	{ 27, 133083129 },
	{ 27, 66890491 },
	{ 28, 120631289 },
	{ 28, 95989753 },
	{ 28, 96119547 },
	{ 28, 123252729 },
	{ 28, 108048377 },
	{ 28, 58241017 },
	{ 28, 58370811 },
	{ 27, 47755257 },
	{ 27, 15773689 },
	{ 21, 1961450 },
	{ 21, 1912222 },
	{ 27, 49852413 },
	{ 27, 49982207 },
	{ 28, 50102267 },
	{ 28, 66617339 },
	{ 28, 116162555 },
	{ 28, 132677627 },
	{ 29, 175931387 },
	{ 29, 192446459 },
	{ 29, 241991675 },
	{ 29, 258506747 },
	{ 29, 222068731 },
	{ 29, 249477885 },
	{ 28, 115245055 },
	{ 28, 111116283 },
	{ 28, 245137403 },
	{ 27, 48151293 },
	{ 26, 28737535 },
	{ 26, 27754491 },
	{ 26, 27492347 },
	{ 26, 28409851 },
	{ 26, 27623419 },
	{ 27, 63537147 },
	{ 27, 59604987 },
	{ 27, 47808507 },
	{ 27, 43876347 },
	{ 27, 61439995 },
	{ 27, 53313531 },
	{ 27, 28934139 },
	{ 27, 47233785 },
	{ 26, 23691259 },
	{ 21, 2043242 },
	{ 21, 1043742 },
	{ 26, 7962623 },
	{ 26, 24739839 },
	{ 28, 50102011 },
	{ 28, 66617083 },
	{ 28, 116162299 },
	{ 28, 132677371 },
	{ 29, 175931131 },
	{ 29, 192446203 },
	{ 29, 241991419 },
	{ 29, 258506491 },
	{ 29, 222068475 },
	{ 29, 249478141 },
	{ 28, 115244799 },
	{ 28, 111116027 },
	{ 28, 245137147 },
	{ 27, 48151549 },
	{ 26, 28737279 },
	{ 26, 27754235 },
	{ 26, 27492091 },
	{ 26, 28409595 },
	{ 26, 27623163 },
	{ 27, 63536891 },
	{ 27, 59604731 },
	{ 27, 47808251 },
	{ 27, 43876091 },
	{ 27, 61439739 },
	{ 27, 53313275 },
	{ 27, 28933883 },
	{ 27, 47234041 },
	{ 26, 23691003 },
	{ 21, 2059626 },
	{ 21, 1027358 },
	{ 26, 7962367 },
	{ 26, 24739583 },
	{ 28, 41516799 },
	{ 28, 66878459 },
	{ 28, 116947963 },
	{ 28, 132938747 },
	{ 29, 183008251 },
	{ 29, 192707579 },
	{ 29, 242777083 },
	{ 29, 259833593 },
	{ 28, 129989627 },
	{ 28, 129727483 },
	{ 28, 128941051 },
	{ 28, 125615865 },
	{ 27, 64977915 },
	{ 27, 64715771 },
	{ 27, 47628029 },
	{ 26, 24952569 },
	{ 25, 16219131 },
	{ 25, 15956987 },
	{ 26, 32030457 },
	{ 25, 16088059 },
	{ 27, 59341819 },
	{ 27, 47021051 },
	{ 27, 62439161 },
	{ 26, 31292411 },
	{ 27, 53050363 },
	{ 27, 28146683 },
	{ 26, 24690425 },
	{ 25, 12418043 },
	{ 20, 1038314 },
	{ 20, 505758 },
	{ 26, 7175167 },
	{ 26, 23952383 },
	{ 28, 40729599 },
	{ 28, 66878203 },
	{ 28, 116947707 },
	{ 28, 132938491 },
	{ 29, 183007995 },
	{ 29, 192707323 },
	{ 29, 242776827 },
	{ 29, 259833849 },
	{ 28, 129989371 },
	{ 28, 129727227 },
	{ 28, 128940795 },
	{ 28, 125616121 },
	{ 27, 64977659 },
	{ 27, 64715515 },
	{ 27, 47628285 },
	{ 26, 24952825 },
	{ 25, 16218875 },
	{ 25, 15956731 },
	{ 26, 32030713 },
	{ 25, 16087803 },
	{ 27, 59341563 },
	{ 27, 47020795 },
	{ 27, 62439417 },
	{ 26, 31292155 },
	{ 27, 53050107 },
	{ 27, 28146427 },
	{ 26, 24690681 },
	{ 25, 12417787 },
	{ 20, 1046506 },
	{ 20, 497566 },
	{ 26, 7174911 },
	{ 26, 23952127 },
	{ 28, 40729343 },
	{ 28, 57506559 },
	{ 28, 117207035 },
	{ 28, 133722107 },
	{ 29, 183267323 },
	{ 29, 199782395 },
	{ 29, 243036155 },
	{ 29, 259975933 },
	{ 28, 129921023 },
	{ 28, 121597947 },
	{ 28, 121335803 },
	{ 28, 125758205 },
	{ 27, 64909311 },
	{ 27, 60780539 },
	{ 27, 60518395 },
	{ 26, 25094909 },
	{ 25, 16150527 },
	{ 25, 15167483 },
	{ 25, 14905339 },
	{ 25, 15822843 },
	{ 25, 15036411 },
	{ 27, 46755835 },
	{ 27, 61926137 },
	{ 26, 31027195 },
	{ 26, 27095035 },
	{ 27, 27881467 },
	{ 26, 24177401 },
	{ 25, 12152827 },
	{ 25, 4026363 },
	{ 20, 456478 },
	{ 26, 6909951 },
	{ 26, 23687167 },
	{ 28, 40464383 },
	{ 28, 57241599 },
	{ 28, 117206779 },
	{ 28, 133721851 },
	{ 29, 183267067 },
	{ 29, 199782139 },
	{ 29, 243035899 },
	{ 29, 259976189 },
	{ 28, 129920767 },
	{ 28, 121597691 },
	{ 28, 121335547 },
	{ 28, 125758461 },
	{ 27, 64909055 },
	{ 27, 60780283 },
	{ 27, 60518139 },
	{ 26, 25095165 },
	{ 25, 16150271 },
	{ 25, 15167227 },
	{ 25, 14905083 },
	{ 25, 15822587 },
	{ 25, 15036155 },
	{ 27, 46755579 },
	{ 27, 61926393 },
	{ 26, 31026939 },
	{ 26, 27094779 },
	{ 27, 27881211 },
	{ 26, 24177657 },
	{ 25, 12152571 },
	{ 25, 4026107 },
	{ 20, 448286 },
	{ 26, 6909695 },
	{ 26, 23686911 },
	{ 28, 40464127 },
	{ 28, 57241343 },
	{ 28, 107572991 },
	{ 28, 133983227 },
	{ 29, 184052731 },
	{ 29, 200043515 },
	{ 29, 250113019 },
	{ 29, 259812347 },
	{ 29, 259452669 },
	{ 28, 121531391 },
	{ 28, 96431099 },
	{ 28, 96168955 },
	{ 28, 125234941 },
	{ 27, 60713983 },
	{ 27, 48196603 },
	{ 27, 47934459 },
	{ 26, 24571645 },
	{ 25, 15100927 },
	{ 25, 12020731 },
	{ 25, 11758587 },
	{ 25, 14773243 },
	{ 25, 11889659 },
	{ 27, 60354297 },
	{ 26, 30239739 },
	{ 26, 26831867 },
	{ 26, 14511099 },
	{ 26, 22605561 },
	{ 25, 11365371 },
	{ 25, 3763195 },
	{ 20, 439710 },
	{ 25, 4025343 },
	{ 25, 12413951 },
	{ 27, 20802559 },
	{ 27, 29191167 },
	{ 27, 54356991 },
	{ 27, 62745599 },
	{ 28, 87911423 },
	{ 28, 96300031 },
	{ 28, 121465855 },
	{ 28, 129854463 },
	{ 29, 259452925 },
	{ 28, 121531135 },
	{ 28, 96430843 },
	{ 28, 96168699 },
	{ 28, 125235197 },
	{ 27, 60713727 },
	{ 27, 48196347 },
	{ 27, 47934203 },
	{ 26, 24571901 },
	{ 25, 15100671 },
	{ 25, 12020475 },
	{ 25, 11758331 },
	{ 25, 14772987 },
	{ 25, 11889403 },
	{ 27, 60354553 },
	{ 26, 30239483 },
	{ 26, 26831611 },
	{ 26, 14510843 },
	{ 26, 22605817 },
	{ 25, 11365115 },
	{ 25, 3762939 },
	{ 20, 431518 },
	{ 25, 4025087 },
	{ 25, 12413695 },
	{ 27, 20802303 },
	{ 27, 29190911 },
	{ 27, 54356735 },
	{ 27, 62745343 },
	{ 28, 87911167 },
	{ 28, 96299775 },
	{ 28, 121465599 },
	{ 28, 129854207 },
	{ 29, 175849467 },
	{ 29, 257882877 },
	{ 28, 96354303 },
	{ 28, 88031227 },
	{ 28, 87769083 },
	{ 28, 123665149 },
	{ 27, 48119807 },
	{ 27, 43991035 },
	{ 27, 43728891 },
	{ 26, 23001853 },
	{ 25, 11943935 },
	{ 25, 10960891 },
	{ 25, 10698747 },
	{ 25, 11616251 },
	{ 25, 10829819 },
	{ 26, 29966331 },
	{ 26, 26034171 },
	{ 26, 14237691 },
	{ 26, 22084345 },
	{ 25, 11091963 },
	{ 25, 2965499 },
	{ 19, 259358 },
	{ 25, 3751935 },
	{ 25, 12140543 },
	{ 27, 20529151 },
	{ 27, 28917759 },
	{ 27, 54083583 },
	{ 27, 62472191 },
	{ 28, 87638015 },
	{ 28, 96026623 },
	{ 28, 121192447 },
	{ 28, 129581055 },
	{ 29, 175849211 },
	{ 29, 257883133 },
	{ 28, 96354047 },
	{ 28, 88030971 },
	{ 28, 87768827 },
	{ 28, 123665405 },
	{ 27, 48119551 },
	{ 27, 43990779 },
	{ 27, 43728635 },
	{ 26, 23002109 },
	{ 25, 11943679 },
	{ 25, 10960635 },
	{ 25, 10698491 },
	{ 25, 11615995 },
	{ 25, 10829563 },
	{ 26, 29966075 },
	{ 26, 26033915 },
	{ 26, 14237435 },
	{ 26, 22084601 },
	{ 25, 11091707 },
	{ 25, 2965243 },
	{ 19, 251166 },
	{ 25, 3751679 },
	{ 25, 12140287 },
	{ 27, 20528895 },
	{ 27, 28917503 },
	{ 27, 54083327 },
	{ 27, 62471935 },
	{ 28, 134167547 },
	{ 28, 133905403 },
	{ 28, 133118971 },
	{ 28, 132856827 },
	{ 28, 125778939 },
	{ 28, 125516795 },
	{ 28, 124730363 },
	{ 28, 129826553 },
	{ 27, 62864379 },
	{ 27, 62602235 },
	{ 27, 61815803 },
	{ 27, 62717689 },
	{ 26, 31407099 },
	{ 26, 31144955 },
	{ 26, 22478589 },
	{ 25, 12386041 },
	{ 24, 7814139 },
	{ 24, 7551995 },
	{ 25, 15269625 },
	{ 24, 7683067 },
	{ 26, 25771003 },
	{ 26, 13450235 },
	{ 25, 12123897 },
	{ 24, 6110203 },
	{ 25, 2702331 },
	{ 18, 121758 },
	{ 25, 2964479 },
	{ 25, 11353087 },
	{ 27, 19741695 },
	{ 27, 28130303 },
	{ 27, 53296127 },
	{ 27, 61684735 },
	{ 28, 134167291 },
	{ 28, 133905147 },
	{ 28, 133118715 },
	{ 28, 132856571 },
	{ 28, 125778683 },
	{ 28, 125516539 },
	{ 28, 124730107 },
	{ 28, 129826809 },
	{ 27, 62864123 },
	{ 27, 62601979 },
	{ 27, 61815547 },
	{ 27, 62717945 },
	{ 26, 31406843 },
	{ 26, 31144699 },
	{ 26, 22478845 },
	{ 25, 12386297 },
	{ 24, 7813883 },
	{ 24, 7551739 },
	{ 25, 15269881 },
	{ 24, 7682811 },
	{ 26, 25770747 },
	{ 26, 13449979 },
	{ 25, 12124153 },
	{ 24, 6109947 },
	{ 25, 2702075 },
	{ 18, 117662 },
	{ 25, 2964223 },
	{ 25, 11352831 },
	{ 27, 19741439 },
	{ 27, 28130047 },
	{ 27, 53295871 },
	{ 27, 61684479 },
	{ 28, 86850303 },
	{ 28, 117387259 },
	{ 28, 117125115 },
	{ 28, 116338683 },
	{ 28, 116076539 },
	{ 28, 108998651 },
	{ 28, 108736507 },
	{ 28, 107950075 },
	{ 27, 62795775 },
	{ 27, 54472699 },
	{ 27, 54210555 },
	{ 27, 53424123 },
	{ 26, 31338495 },
	{ 26, 27209723 },
	{ 26, 26947579 },
	{ 26, 25012989 },
	{ 24, 7745535 },
	{ 24, 6762491 },
	{ 24, 6500347 },
	{ 24, 7417851 },
	{ 24, 6631419 },
	{ 26, 13185019 },
	{ 26, 23177977 },
	{ 24, 5844987 },
	{ 24, 1912827 },
	{ 18, 97054 },
	{ 25, 2699263 },
	{ 25, 11087871 },
	{ 27, 19476479 },
	{ 27, 27865087 },
	{ 27, 53030911 },
	{ 27, 61419519 },
	{ 28, 134098687 },
	{ 28, 117387003 },
	{ 28, 117124859 },
	{ 28, 116338427 },
	{ 28, 116076283 },
	{ 28, 108998395 },
	{ 28, 108736251 },
	{ 28, 107949819 },
	{ 27, 62795519 },
	{ 27, 54472443 },
	{ 27, 54210299 },
	{ 27, 53423867 },
	{ 26, 31338239 },
	{ 26, 27209467 },
	{ 26, 26947323 },
	{ 26, 25013245 },
	{ 24, 7745279 },
	{ 24, 6762235 },
	{ 24, 6500091 },
	{ 24, 7417595 },
	{ 24, 6631163 },
	{ 26, 13184763 },
	{ 26, 23178233 },
	{ 24, 5844731 },
	{ 24, 1912571 },
	{ 18, 92958 },
	{ 25, 2699007 },
	{ 25, 11087615 },
	{ 27, 19476223 },
	{ 27, 27864831 },
	{ 27, 53030655 },
	{ 27, 61419263 },
	{ 28, 86585087 },
	{ 28, 94973695 },
	{ 28, 67054587 },
	{ 28, 66792443 },
	{ 28, 66006011 },
	{ 28, 65743867 },
	{ 28, 58665979 },
	{ 28, 58403835 },
	{ 28, 57617403 },
	{ 27, 54406143 },
	{ 27, 29305851 },
	{ 27, 29043707 },
	{ 27, 28257275 },
	{ 26, 27143167 },
	{ 26, 14625787 },
	{ 26, 14363643 },
	{ 26, 23965437 },
	{ 24, 6695935 },
	{ 24, 3615739 },
	{ 24, 3353595 },
	{ 24, 6368251 },
	{ 24, 3484667 },
	{ 26, 20033273 },
	{ 24, 5057531 },
	{ 24, 1649659 },
	{ 18, 88478 },
	{ 24, 1911807 },
	{ 24, 6106111 },
	{ 26, 10300415 },
	{ 26, 14494719 },
	{ 26, 27077631 },
	{ 26, 31271935 },
	{ 27, 43854847 },
	{ 27, 48049151 },
	{ 27, 60632063 },
	{ 27, 64826367 },
	{ 28, 66005755 },
	{ 28, 65743611 },
	{ 28, 58665723 },
	{ 28, 58403579 },
	{ 28, 57617147 },
	{ 27, 54405887 },
	{ 27, 29305595 },
	{ 27, 29043451 },
	{ 27, 28257019 },
	{ 26, 27142911 },
	{ 26, 14625531 },
	{ 26, 14363387 },
	{ 26, 23965693 },
	{ 24, 6695679 },
	{ 24, 3615483 },
	{ 24, 3353339 },
	{ 24, 6367995 },
	{ 24, 3484411 },
	{ 26, 20033529 },
	{ 24, 5057275 },
	{ 24, 1649403 },
	{ 18, 84382 },
	{ 24, 1911551 },
	{ 24, 6105855 },
	{ 26, 10300159 },
	{ 26, 14494463 },
	{ 26, 27077375 },
	{ 26, 31271679 },
	{ 27, 43854591 },
	{ 27, 48048895 },
	{ 26, 16752639 },
	{ 26, 12574715 },
	{ 26, 12509179 },
	{ 26, 12312571 },
	{ 26, 12247035 },
	{ 26, 10477563 },
	{ 26, 10412027 },
	{ 26, 10215419 },
	{ 25, 7315455 },
	{ 25, 5234683 },
	{ 25, 5169147 },
	{ 25, 4972539 },
	{ 24, 3645439 },
	{ 24, 2613243 },
	{ 24, 2547707 },
	{ 24, 2351099 },
	{ 22, 892927 },
	{ 22, 647163 },
	{ 22, 581627 },
	{ 22, 811003 },
	{ 22, 614395 },
	{ 22, 1204219 },
	{ 22, 221179 },
	{ 17, 63774 },
	{ 22, 417791 },
	{ 22, 1466367 },
	{ 24, 2514943 },
	{ 24, 3563519 },
	{ 24, 6709247 },
	{ 24, 7757823 },
	{ 25, 10903551 },
	{ 25, 11952127 },
	{ 25, 15097855 },
	{ 25, 16146431 },
	{ 26, 12508923 },
	{ 26, 12312315 },
	{ 26, 12246779 },
	{ 26, 10477307 },
	{ 26, 10411771 },
	{ 26, 10215163 },
	{ 25, 7315199 },
	{ 25, 5234427 },
	{ 25, 5168891 },
	{ 25, 4972283 },
	{ 24, 3645183 },
	{ 24, 2612987 },
	{ 24, 2547451 },
	{ 24, 2350843 },
	{ 22, 892671 },
	{ 22, 646907 },
	{ 22, 581371 },
	{ 22, 810747 },
	{ 22, 614139 },
	{ 22, 1203963 },
	{ 22, 220923 },
	{ 17, 59678 },
	{ 22, 417535 },
	{ 22, 1466111 },
	{ 24, 2514687 },
	{ 24, 3563263 },
	{ 24, 6708991 },
	{ 24, 7757567 },
	{ 25, 10903295 },
	{ 25, 11951871 },
	{ 25, 15097599 },
	{ 25, 16146175 },
	{ 24, 8379387 },
	{ 24, 8313851 },
	{ 24, 8117243 },
	{ 24, 8051707 },
	{ 24, 6282235 },
	{ 24, 6216699 },
	{ 24, 6020091 },
	{ 24, 5954555 },
	{ 23, 3136507 },
	{ 23, 3070971 },
	{ 23, 2874363 },
	{ 23, 2808827 },
	{ 22, 1563643 },
	{ 22, 1498107 },
	{ 22, 1301499 },
	{ 22, 1235963 },
	{ 20, 383995 },
	{ 20, 318459 },
	{ 22, 547835 },
	{ 20, 351227 },
	{ 22, 154619 },
	{ 15, 13982 },
	{ 22, 220159 },
	{ 22, 1268735 },
	{ 24, 2317311 },
	{ 24, 3365887 },
	{ 24, 6511615 },
	{ 24, 7560191 },
	{ 25, 10705919 },
	{ 25, 11754495 },
	{ 25, 14900223 },
	{ 25, 15948799 },
	{ 24, 8379131 },
	{ 24, 8313595 },
	{ 24, 8116987 },
	{ 24, 8051451 },
	{ 24, 6281979 },
	{ 24, 6216443 },
	{ 24, 6019835 },
	{ 24, 5954299 },
	{ 23, 3136251 },
	{ 23, 3070715 },
	{ 23, 2874107 },
	{ 23, 2808571 },
	{ 22, 1563387 },
	{ 22, 1497851 },
	{ 22, 1301243 },
	{ 22, 1235707 },
	{ 20, 383739 },
	{ 20, 318203 },
	{ 22, 547579 },
	{ 20, 350971 },
	{ 22, 154363 },
	{ 15, 12958 },
	{ 22, 219903 },
	{ 22, 1268479 },
	{ 24, 2317055 },
	{ 24, 3365631 },
	{ 24, 6511359 },
	{ 24, 7559935 },
	{ 25, 10705663 },
	{ 25, 11754239 },
	{ 25, 14899967 },
	{ 25, 15948543 },
	{ 24, 8359935 },
	{ 24, 4182011 },
	{ 24, 4116475 },
	{ 24, 3919867 },
	{ 24, 3854331 },
	{ 24, 2084859 },
	{ 24, 2019323 },
	{ 24, 1822715 },
	{ 23, 3117055 },
	{ 23, 1036283 },
	{ 23, 970747 },
	{ 23, 774139 },
	{ 22, 1544191 },
	{ 22, 511995 },
	{ 22, 446459 },
	{ 22, 249851 },
	{ 20, 364543 },
	{ 20, 118779 },
	{ 20, 53243 },
	{ 16, 16251 },
	{ 15, 16315 },
	{ 15, 7710 },
	{ 22, 151551 },
	{ 22, 1200127 },
	{ 24, 2248703 },
	{ 24, 3297279 },
	{ 24, 6443007 },
	{ 24, 7491583 },
	{ 25, 10637311 },
	{ 25, 11685887 },
	{ 25, 14831615 },
	{ 25, 15880191 },
	{ 24, 8359679 },
	{ 24, 4181755 },
	{ 24, 4116219 },
	{ 24, 3919611 },
	{ 24, 3854075 },
	{ 24, 2084603 },
	{ 24, 2019067 },
	{ 24, 1822459 },
	{ 23, 3116799 },
	{ 23, 1036027 },
	{ 23, 970491 },
	{ 23, 773883 },
	{ 22, 1543935 },
	{ 22, 511739 },
	{ 22, 446203 },
	{ 22, 249595 },
	{ 20, 364287 },
	{ 20, 118523 },
	{ 20, 52987 },
	{ 16, 14203 },
	{ 14, 7803 },
	{ 15, 6686 },
	{ 22, 151295 },
	{ 22, 1199871 },
	{ 24, 2248447 },
	{ 24, 3297023 },
	{ 24, 6442751 },
	{ 24, 7491327 },
	{ 25, 10637055 },
	{ 25, 11685631 },
	{ 25, 14831359 },
	{ 25, 15879935 },
	{ 26, 27414271 },
	{ 24, 4164607 },
	{ 24, 4099071 },
	{ 24, 3902463 },
	{ 24, 3836927 },
	{ 24, 2067455 },
	{ 24, 2001919 },
	{ 24, 1805311 },
	{ 24, 1739775 },
	{ 23, 1018879 },
	{ 23, 953343 },
	{ 23, 756735 },
	{ 23, 691199 },
	{ 22, 494591 },
	{ 22, 429055 },
	{ 22, 232447 },
	{ 22, 166911 },
	{ 20, 101375 },
	{ 20, 35839 },
	{ 12, 1855 },
	{ 12, 1899 },
	{ 12, 1854 },
	{ 14, 8127 },
	{ 20, 347135 },
	{ 22, 609279 },
	{ 22, 871423 },
	{ 22, 1657855 },
	{ 22, 1919999 },
	{ 23, 2706431 },
	{ 23, 2968575 },
	{ 23, 3755007 },
	{ 23, 4017151 },
	{ 24, 6900735 },
	{ 24, 4164351 },
	{ 24, 4098815 },
	{ 24, 3902207 },
	{ 24, 3836671 },
	{ 24, 2067199 },
	{ 24, 2001663 },
	{ 24, 1805055 },
	{ 24, 1739519 },
	{ 23, 1018623 },
	{ 23, 953087 },
	{ 23, 756479 },
	{ 23, 690943 },
	{ 22, 494335 },
	{ 22, 428799 },
	{ 22, 232191 },
	{ 22, 166655 },
	{ 20, 101119 },
	{ 20, 35583 },
	{ 12, 2031 },
	{ 9, 219 },
	{ 10, 206 },
	{ 13, 3711 },
	{ 20, 346879 },
	{ 22, 609023 },
	{ 22, 871167 },
	{ 22, 1657599 },
	{ 22, 1919743 },
	{ 23, 2706175 },
	{ 23, 2968319 },
	{ 23, 3754751 },
	{ 23, 4016895 },
	{ 24, 6900479 },
	{ 24, 7162623 },
	{ 24, 7949055 },
	{ 22, 4130815 },
	{ 22, 4065279 },
	{ 22, 3868671 },
	{ 22, 3803135 },
	{ 22, 2033663 },
	{ 22, 1968127 },
	{ 22, 1771519 },
	{ 22, 1705983 },
	{ 21, 985087 },
	{ 21, 919551 },
	{ 21, 722943 },
	{ 21, 657407 },
	{ 20, 460799 },
	{ 20, 395263 },
	{ 20, 198655 },
	{ 20, 133119 },
	{ 14, 7551 },
	{ 8, 79 },
	{ 10, 142 },
	{ 11, 879 },
	{ 14, 8063 },
	{ 20, 137215 },
	{ 20, 202751 },
	{ 20, 399359 },
	{ 20, 464895 },
	{ 21, 661503 },
	{ 21, 727039 },
	{ 21, 923647 },
	{ 21, 989183 },
	{ 22, 1710079 },
	{ 22, 1775615 },
	{ 22, 1972223 },
	{ 22, 4130559 },
	{ 22, 4065023 },
	{ 22, 3868415 },
	{ 22, 3802879 },
	{ 22, 2033407 },
	{ 22, 1967871 },
	{ 22, 1771263 },
	{ 22, 1705727 },
	{ 21, 984831 },
	{ 21, 919295 },
	{ 21, 722687 },
	{ 21, 657151 },
	{ 20, 460543 },
	{ 20, 395007 },
	{ 20, 198399 },
	{ 20, 132863 },
	{ 14, 5503 },
	{ 9, 175 },
	{ 24, 130045 },
	{ 8, 95 },
	{ 14, 6015 },
	{ 20, 136959 },
	{ 20, 202495 },
	{ 20, 399103 },
	{ 20, 464639 },
	{ 21, 661247 },
	{ 21, 726783 },
	{ 21, 923391 },
	{ 21, 988927 },
	{ 22, 1709823 },
	{ 22, 1775359 },
	{ 22, 1971967 },
	{ 22, 2037503 },
	{ 22, 3806975 },
	{ 22, 3872511 },
	{ 22, 4069119 },
	{ 22, 4134655 },
	{ 22, 1983487 },
	{ 22, 1786879 },
	{ 22, 1721343 },
	{ 21, 1000447 },
	{ 21, 934911 },
	{ 21, 738303 },
	{ 21, 672767 },
	{ 20, 476159 },
	{ 20, 410623 },
	{ 20, 214015 },
	{ 20, 148479 },
	{ 18, 82943 },
	{ 11, 703 },
	{ 9, 222 },
	{ 7, 11 },
	{ 10, 315 },
	{ 18, 13311 },
	{ 18, 78847 },
	{ 20, 144383 },
	{ 20, 209919 },
	{ 20, 406527 },
	{ 20, 472063 },
	{ 21, 668671 },
	{ 21, 734207 },
	{ 21, 930815 },
	{ 21, 996351 },
	{ 22, 1717247 },
	{ 22, 4145919 },
	{ 22, 4080383 },
	{ 22, 3883775 },
	{ 22, 3818239 },
	{ 22, 2048767 },
	{ 22, 1983231 },
	{ 22, 1786623 },
	{ 22, 1721087 },
	{ 21, 1000191 },
	{ 21, 934655 },
	{ 21, 738047 },
	{ 21, 672511 },
	{ 20, 475903 },
	{ 20, 410367 },
	{ 20, 213759 },
	{ 20, 148223 },
	{ 18, 82687 },
	{ 12, 1471 },
	{ 9, 94 },
	{ 8, 43 },
	{ 10, 491 },
	{ 18, 13055 },
	{ 18, 78591 },
	{ 20, 144127 },
	{ 20, 209663 },
	{ 20, 406271 },
	{ 20, 471807 },
	{ 21, 668415 },
	{ 21, 733951 },
	{ 21, 930559 },
	{ 21, 996095 },
	{ 22, 1716991 },
	{ 22, 1782527 },
	{ 22, 1979135 },
	{ 22, 2044671 },
	{ 22, 3814143 },
	{ 22, 3879679 },
	{ 22, 4076287 },
	{ 22, 4141823 },
	{ 22, 1712639 },
	{ 21, 991743 },
	{ 21, 926207 },
	{ 21, 729599 },
	{ 21, 664063 },
	{ 20, 467455 },
	{ 20, 401919 },
	{ 20, 205311 },
	{ 20, 139775 },
	{ 18, 74239 },
	{ 18, 8703 },
	{ 11, 1134 },
	{ 10, 187 },
	{ 12, 2427 },
	{ 16, 2555 },
	{ 16, 18939 },
	{ 16, 24063 },
	{ 18, 51707 },
	{ 18, 100859 },
	{ 18, 117243 },
	{ 18, 122367 },
	{ 19, 182779 },
	{ 19, 231931 },
	{ 19, 248315 },
	{ 19, 253439 },
	{ 20, 444923 },
	{ 20, 494075 },
	{ 20, 510459 },
	{ 20, 952827 },
	{ 20, 969211 },
	{ 20, 1018363 },
	{ 20, 1034747 },
	{ 20, 1039871 },
	{ 21, 992509 },
	{ 21, 926973 },
	{ 21, 730365 },
	{ 21, 664829 },
	{ 20, 468221 },
	{ 20, 402685 },
	{ 20, 206077 },
	{ 20, 140541 },
	{ 18, 75005 },
	{ 18, 9469 },
	{ 11, 26 },
	{ 10, 121 },
	{ 12, 889 },
	{ 16, 3321 },
	{ 16, 7417 },
	{ 16, 22781 },
	{ 18, 15609 },
	{ 18, 27897 },
	{ 18, 31993 },
	{ 18, 96509 },
	{ 19, 48377 },
	{ 19, 60665 },
	{ 19, 64761 },
	{ 19, 194813 },
	{ 20, 113913 },
	{ 20, 126201 },
	{ 20, 130297 },
	{ 20, 240889 },
	{ 20, 244985 },
	{ 20, 257273 },
	{ 20, 261369 },
	{ 20, 522493 },
	{ 21, 992765 },
	{ 21, 927229 },
	{ 21, 730621 },
	{ 21, 665085 },
	{ 20, 468477 },
	{ 20, 402941 },
	{ 20, 206333 },
	{ 20, 140797 },
	{ 18, 75261 },
	{ 18, 9725 },
	{ 11, 1050 },
	{ 11, 953 },
	{ 12, 2937 },
	{ 16, 3577 },
	{ 16, 7673 },
	{ 16, 23037 },
	{ 18, 15865 },
	{ 18, 28153 },
	{ 18, 32249 },
	{ 18, 96765 },
	{ 19, 48633 },
	{ 19, 60921 },
	{ 19, 65017 },
	{ 19, 195069 },
	{ 20, 114169 },
	{ 20, 126457 },
	{ 20, 130553 },
	{ 20, 241145 },
	{ 20, 245241 },
	{ 20, 257529 },
	{ 20, 261625 },
	{ 20, 522749 },
	{ 23, 3986173 },
	{ 23, 3724029 },
	{ 23, 2937597 },
	{ 23, 2675453 },
	{ 22, 1889021 },
	{ 22, 1626877 },
	{ 22, 840445 },
	{ 22, 578301 },
	{ 20, 316157 },
	{ 20, 54013 },
	{ 13, 666 },
	{ 20, 37625 },
	{ 18, 86777 },
	{ 20, 135929 },
	{ 18, 78585 },
	{ 18, 94969 },
	{ 20, 307961 },
	{ 20, 324345 },
	{ 20, 373497 },
	{ 20, 389881 },
	{ 21, 701177 },
	{ 21, 717561 },
	{ 21, 766713 },
	{ 21, 783097 },
	{ 22, 1487609 },
	{ 22, 1503993 },
	{ 22, 1553145 },
	{ 22, 1569529 },
	{ 22, 2011897 },
	{ 22, 2028281 },
	{ 22, 2077433 },
	{ 22, 2093817 },
	{ 23, 3986429 },
	{ 23, 3724285 },
	{ 23, 2937853 },
	{ 23, 2675709 },
	{ 22, 1889277 },
	{ 22, 1627133 },
	{ 22, 840701 },
	{ 22, 578557 },
	{ 20, 316413 },
	{ 20, 54269 },
	{ 13, 1690 },
	{ 20, 37881 },
	{ 18, 87033 },
	{ 20, 136185 },
	{ 18, 78841 },
	{ 18, 95225 },
	{ 20, 308217 },
	{ 20, 324601 },
	{ 20, 373753 },
	{ 20, 390137 },
	{ 21, 701433 },
	{ 21, 717817 },
	{ 21, 766969 },
	{ 21, 783353 },
	{ 22, 1487865 },
	{ 22, 1504249 },
	{ 22, 1553401 },
	{ 22, 1569785 },
	{ 22, 2012153 },
	{ 22, 2028537 },
	{ 22, 2077689 },
	{ 22, 2094073 },
	{ 23, 4036349 },
	{ 23, 3774205 },
	{ 23, 2987773 },
	{ 23, 2725629 },
	{ 22, 1939197 },
	{ 22, 1677053 },
	{ 22, 890621 },
	{ 22, 628477 },
	{ 20, 366333 },
	{ 20, 104189 },
	{ 15, 10522 },
	{ 20, 55033 },
	{ 20, 300793 },
	{ 20, 153337 },
	{ 20, 202489 },
	{ 20, 145145 },
	{ 20, 161529 },
	{ 20, 222973 },
	{ 22, 587513 },
	{ 22, 636665 },
	{ 22, 653049 },
	{ 22, 911101 },
	{ 23, 1242873 },
	{ 23, 1292025 },
	{ 23, 1308409 },
	{ 23, 1828605 },
	{ 24, 2553593 },
	{ 24, 2602745 },
	{ 24, 2619129 },
	{ 24, 3061497 },
	{ 24, 3077881 },
	{ 24, 3127033 },
	{ 23, 4036605 },
	{ 23, 3774461 },
	{ 23, 2988029 },
	{ 23, 2725885 },
	{ 22, 1939453 },
	{ 22, 1677309 },
	{ 22, 890877 },
	{ 22, 628733 },
	{ 20, 366589 },
	{ 20, 104445 },
	{ 15, 14618 },
	{ 20, 55289 },
	{ 20, 301049 },
	{ 20, 153593 },
	{ 20, 202745 },
	{ 20, 145401 },
	{ 20, 161785 },
	{ 20, 223229 },
	{ 22, 587769 },
	{ 22, 636921 },
	{ 22, 653305 },
	{ 22, 911357 },
	{ 23, 1243129 },
	{ 23, 1292281 },
	{ 23, 1308665 },
	{ 23, 1828861 },
	{ 24, 2553849 },
	{ 24, 2603001 },
	{ 24, 2619385 },
	{ 24, 3061753 },
	{ 24, 3078137 },
	{ 24, 3127289 },
	{ 24, 3143673 },
	{ 24, 4188157 },
	{ 25, 12012285 },
	{ 25, 10963709 },
	{ 24, 7817981 },
	{ 24, 6769405 },
	{ 24, 3623677 },
	{ 24, 2575101 },
	{ 22, 1526525 },
	{ 22, 477949 },
	{ 17, 18842 },
	{ 22, 412409 },
	{ 22, 1264377 },
	{ 24, 2247417 },
	{ 22, 871161 },
	{ 22, 1592057 },
	{ 22, 838393 },
	{ 22, 903929 },
	{ 22, 1673981 },
	{ 24, 3394297 },
	{ 24, 3590905 },
	{ 24, 3656441 },
	{ 24, 6785789 },
	{ 25, 7064313 },
	{ 25, 7260921 },
	{ 25, 7326457 },
	{ 25, 13601533 },
	{ 26, 14404345 },
	{ 26, 14600953 },
	{ 26, 14666489 },
	{ 26, 16435961 },
	{ 26, 16501497 },
	{ 25, 16206845 },
	{ 25, 15158269 },
	{ 25, 12012541 },
	{ 25, 10963965 },
	{ 24, 7818237 },
	{ 24, 6769661 },
	{ 24, 3623933 },
	{ 24, 2575357 },
	{ 22, 1526781 },
	{ 22, 478205 },
	{ 17, 22938 },
	{ 22, 412665 },
	{ 22, 1264633 },
	{ 24, 2247673 },
	{ 22, 871417 },
	{ 22, 1592313 },
	{ 22, 838649 },
	{ 22, 904185 },
	{ 22, 1674237 },
	{ 24, 3394553 },
	{ 24, 3591161 },
	{ 24, 3656697 },
	{ 24, 6786045 },
	{ 25, 7064569 },
	{ 25, 7261177 },
	{ 25, 7326713 },
	{ 25, 13601789 },
	{ 26, 14404601 },
	{ 26, 14601209 },
	{ 26, 14666745 },
	{ 26, 16436217 },
	{ 26, 16501753 },
	{ 26, 16698361 },
	{ 26, 16763897 },
	{ 26, 23744253 },
	{ 26, 21647101 },
	{ 25, 15355645 },
	{ 25, 13258493 },
	{ 25, 6967037 },
	{ 25, 4869885 },
	{ 23, 2772733 },
	{ 23, 675581 },
	{ 17, 27418 },
	{ 22, 478969 },
	{ 22, 1462009 },
	{ 24, 2313977 },
	{ 24, 3297017 },
	{ 22, 1658617 },
	{ 22, 1855225 },
	{ 22, 1625849 },
	{ 22, 1691385 },
	{ 22, 1937149 },
	{ 24, 6541049 },
	{ 24, 6737657 },
	{ 24, 6803193 },
	{ 24, 7835389 },
	{ 25, 13356793 },
	{ 25, 13553401 },
	{ 25, 13618937 },
	{ 25, 15699709 },
	{ 26, 26988281 },
	{ 26, 27184889 },
	{ 26, 27250425 },
	{ 26, 29019897 },
	{ 26, 29085433 },
	{ 26, 29282041 },
	{ 26, 29347577 },
	{ 26, 33525501 },
	{ 25, 15355901 },
	{ 25, 13258749 },
	{ 25, 6967293 },
	{ 25, 4870141 },
	{ 23, 2772989 },
	{ 23, 675837 },
	{ 17, 31514 },
	{ 22, 479225 },
	{ 22, 1462265 },
	{ 24, 2314233 },
	{ 24, 3297273 },
	{ 22, 1658873 },
	{ 22, 1855481 },
	{ 22, 1626105 },
	{ 22, 1691641 },
	{ 22, 1937405 },
	{ 24, 6541305 },
	{ 24, 6737913 },
	{ 24, 6803449 },
	{ 24, 7835645 },
	{ 25, 13357049 },
	{ 25, 13553657 },
	{ 25, 13619193 },
	{ 25, 15699965 },
	{ 26, 26988537 },
	{ 26, 27185145 },
	{ 26, 27250681 },
	{ 26, 29020153 },
	{ 26, 29085689 },
	{ 26, 29282297 },
	{ 26, 29347833 },
	{ 26, 21715709 },
	{ 25, 15424253 },
	{ 25, 13327101 },
	{ 25, 7035645 },
	{ 25, 4938493 },
	{ 23, 2841341 },
	{ 23, 744189 },
	{ 17, 52122 },
	{ 23, 678649 },
	{ 22, 1530617 },
	{ 24, 2513657 },
	{ 24, 3365625 },
	{ 24, 6445817 },
	{ 22, 1923833 },
	{ 23, 2644729 },
	{ 22, 1891065 },
	{ 22, 1956601 },
	{ 23, 2726653 },
	{ 24, 7592697 },
	{ 24, 7789305 },
	{ 24, 7854841 },
	{ 25, 15391481 },
	{ 25, 15457017 },
	{ 25, 15653625 },
	{ 25, 15719161 },
	{ 26, 31120121 },
	{ 26, 31185657 },
	{ 26, 31382265 },
	{ 26, 31447801 },
	{ 26, 33217273 },
	{ 26, 33282809 },
	{ 26, 33479417 },
	{ 26, 33544953 },
	{ 25, 15424509 },
	{ 25, 13327357 },
	{ 25, 7035901 },
	{ 25, 4938749 },
	{ 23, 2841597 },
	{ 23, 744445 },
	{ 17, 56218 },
	{ 23, 678905 },
	{ 22, 1530873 },
	{ 24, 2513913 },
	{ 24, 3365881 },
	{ 24, 6446073 },
	{ 22, 1924089 },
	{ 23, 2644985 },
	{ 22, 1891321 },
	{ 22, 1956857 },
	{ 23, 2726909 },
	{ 24, 7592953 },
	{ 24, 7789561 },
	{ 24, 7855097 },
	{ 25, 15391737 },
	{ 25, 15457273 },
	{ 25, 15653881 },
	{ 25, 15719417 },
	{ 26, 31120377 },
	{ 26, 31185913 },
	{ 26, 31382521 },
	{ 26, 31448057 },
	{ 26, 33217529 },
	{ 26, 33283065 },
	{ 26, 33479673 },
	{ 26, 33545209 },
	{ 25, 15621885 },
	{ 25, 13524733 },
	{ 25, 7233277 },
	{ 25, 5136125 },
	{ 23, 3038973 },
	{ 23, 941821 },
	{ 18, 120090 },
	{ 23, 745209 },
	{ 23, 2776825 },
	{ 24, 2580217 },
	{ 24, 3563257 },
	{ 24, 6512377 },
	{ 24, 7495417 },
	{ 23, 2711289 },
	{ 23, 2907897 },
	{ 23, 2678521 },
	{ 23, 2744057 },
	{ 23, 2989821 },
	{ 25, 10739449 },
	{ 25, 10936057 },
	{ 25, 11001593 },
	{ 25, 12033789 },
	{ 26, 21749497 },
	{ 26, 21946105 },
	{ 26, 22011641 },
	{ 26, 24092413 },
	{ 27, 43769593 },
	{ 27, 43966201 },
	{ 26, 32399357 },
	{ 26, 30302205 },
	{ 26, 24010749 },
	{ 26, 21913597 },
	{ 25, 15622141 },
	{ 25, 13524989 },
	{ 25, 7233533 },
	{ 25, 5136381 },
	{ 23, 3039229 },
	{ 23, 942077 },
	{ 18, 128282 },
	{ 23, 745465 },
	{ 23, 2777081 },
	{ 24, 2580473 },
	{ 24, 3563513 },
	{ 24, 6512633 },
	{ 24, 7495673 },
	{ 23, 2711545 },
	{ 23, 2908153 },
	{ 23, 2678777 },
	{ 23, 2744313 },
	{ 23, 2990077 },
	{ 25, 10739705 },
	{ 25, 10936313 },
	{ 25, 11001849 },
	{ 25, 12034045 },
	{ 26, 21749753 },
	{ 26, 21946361 },
	{ 26, 22011897 },
	{ 26, 24092669 },
	{ 27, 43769849 },
	{ 27, 43966457 },
	{ 27, 66723833 },
	{ 27, 62595065 },
	{ 27, 50208761 },
	{ 27, 46079993 },
	{ 27, 46129145 },
	{ 27, 54340349 },
	{ 27, 29174525 },
	{ 27, 20785917 },
	{ 25, 12397309 },
	{ 25, 4008701 },
	{ 19, 169370 },
	{ 25, 3746553 },
	{ 25, 11348729 },
	{ 27, 19475193 },
	{ 26, 14494457 },
	{ 26, 26815225 },
	{ 26, 30223097 },
	{ 27, 42543865 },
	{ 25, 11873017 },
	{ 25, 14756601 },
	{ 25, 11741945 },
	{ 25, 12004089 },
	{ 25, 15084285 },
	{ 27, 47131385 },
	{ 27, 47917817 },
	{ 27, 48179961 },
	{ 27, 60697341 },
	{ 28, 95365881 },
	{ 28, 96152313 },
	{ 28, 96414457 },
	{ 28, 121514749 },
	{ 29, 191834873 },
	{ 28, 129838077 },
	{ 28, 121449469 },
	{ 28, 96283645 },
	{ 28, 87895037 },
	{ 27, 62729213 },
	{ 27, 54340605 },
	{ 27, 29174781 },
	{ 27, 20786173 },
	{ 25, 12397565 },
	{ 25, 4008957 },
	{ 19, 177562 },
	{ 25, 3746809 },
	{ 25, 11348985 },
	{ 27, 19475449 },
	{ 26, 14494713 },
	{ 26, 26815481 },
	{ 26, 30223353 },
	{ 27, 42544121 },
	{ 25, 11873273 },
	{ 25, 14756857 },
	{ 25, 11742201 },
	{ 25, 12004345 },
	{ 25, 15084541 },
	{ 27, 47131641 },
	{ 27, 47918073 },
	{ 27, 48180217 },
	{ 27, 60697597 },
	{ 28, 95366137 },
	{ 28, 96152569 },
	{ 28, 96414713 },
	{ 28, 121515005 },
	{ 29, 191835129 },
	{ 29, 259795961 },
	{ 29, 250096633 },
	{ 29, 200027129 },
	{ 29, 184036345 },
	{ 28, 133966841 },
	{ 28, 107556605 },
	{ 28, 57224957 },
	{ 28, 40447741 },
	{ 26, 23670525 },
	{ 26, 6893309 },
	{ 19, 186138 },
	{ 25, 4009721 },
	{ 25, 12136185 },
	{ 27, 19738361 },
	{ 27, 27864825 },
	{ 26, 27078393 },
	{ 26, 31010553 },
	{ 27, 42807033 },
	{ 27, 46739193 },
	{ 25, 15019769 },
	{ 25, 15806201 },
	{ 25, 14888697 },
	{ 25, 15150841 },
	{ 25, 16133885 },
	{ 27, 59715321 },
	{ 27, 60501753 },
	{ 27, 60763897 },
	{ 27, 64892669 },
	{ 28, 120532729 },
	{ 28, 121319161 },
	{ 28, 121581305 },
	{ 28, 129904381 },
	{ 29, 259534585 },
	{ 29, 243019513 },
	{ 29, 199765753 },
	{ 29, 183250681 },
	{ 28, 133705465 },
	{ 28, 117190393 },
	{ 28, 57225213 },
	{ 28, 40447997 },
	{ 26, 23670781 },
	{ 26, 6893565 },
	{ 19, 194330 },
	{ 25, 4009977 },
	{ 25, 12136441 },
	{ 27, 19738617 },
	{ 27, 27865081 },
	{ 26, 27078649 },
	{ 26, 31010809 },
	{ 27, 42807289 },
	{ 27, 46739449 },
	{ 25, 15020025 },
	{ 25, 15806457 },
	{ 25, 14888953 },
	{ 25, 15151097 },
	{ 25, 16134141 },
	{ 27, 59715577 },
	{ 27, 60502009 },
	{ 27, 60764153 },
	{ 27, 64892925 },
	{ 28, 120532985 },
	{ 28, 121319417 },
	{ 28, 121581561 },
	{ 28, 129904637 },
	{ 29, 259534841 },
	{ 29, 243019769 },
	{ 29, 199766009 },
	{ 29, 183250937 },
	{ 28, 133705721 },
	{ 28, 117190649 },
	{ 28, 57490173 },
	{ 28, 40712957 },
	{ 26, 23935741 },
	{ 26, 7158525 },
	{ 19, 235418 },
	{ 26, 6896377 },
	{ 25, 12401401 },
	{ 26, 24707067 },
	{ 27, 28130041 },
	{ 27, 53033721 },
	{ 26, 31275769 },
	{ 27, 43596537 },
	{ 27, 47004409 },
	{ 27, 59325177 },
	{ 25, 16071417 },
	{ 26, 27343609 },
	{ 25, 15940345 },
	{ 25, 16202489 },
	{ 26, 27671293 },
	{ 27, 63912697 },
	{ 27, 64699129 },
	{ 27, 64961273 },
	{ 28, 128662265 },
	{ 28, 128924409 },
	{ 28, 129710841 },
	{ 28, 129972985 },
	{ 29, 258751225 },
	{ 29, 242760441 },
	{ 29, 192690937 },
	{ 29, 182991609 },
	{ 28, 132922105 },
	{ 28, 116931321 },
	{ 28, 66861817 },
	{ 28, 40713213 },
	{ 26, 23935997 },
	{ 26, 7158781 },
	{ 19, 243610 },
	{ 26, 6896633 },
	{ 25, 12401657 },
	{ 26, 24706811 },
	{ 27, 28130297 },
	{ 27, 53033977 },
	{ 26, 31276025 },
	{ 27, 43596793 },
	{ 27, 47004665 },
	{ 27, 59325433 },
	{ 25, 16071673 },
	{ 26, 27343865 },
	{ 25, 15940601 },
	{ 25, 16202745 },
	{ 26, 27671549 },
	{ 27, 63912953 },
	{ 27, 64699385 },
	{ 27, 64961529 },
	{ 28, 128662521 },
	{ 28, 128924665 },
	{ 28, 129711097 },
	{ 28, 129973241 },
	{ 29, 258751481 },
	{ 29, 242760697 },
	{ 29, 192691193 },
	{ 29, 182991865 },
	{ 28, 132922361 },
	{ 28, 116931577 },
	{ 28, 66862073 },
	{ 28, 41500413 },
	{ 26, 24723197 },
	{ 26, 7945981 },
	{ 20, 503066 },
	{ 26, 7159545 },
	{ 26, 23674617 },
	{ 27, 20791033 },
	{ 27, 28917497 },
	{ 27, 53296889 },
	{ 27, 61423353 },
	{ 27, 43859705 },
	{ 27, 47791865 },
	{ 27, 59588345 },
	{ 27, 63520505 },
	{ 26, 27606777 },
	{ 26, 28393209 },
	{ 26, 27475705 },
	{ 26, 27737849 },
	{ 26, 28720893 },
	{ 27, 48167935 },
	{ 28, 245120761 },
	{ 28, 111099641 },
	{ 28, 115228413 },
	{ 29, 230178553 },
	{ 29, 222052089 },
	{ 29, 258490105 },
	{ 29, 241975033 },
	{ 29, 192429817 },
	{ 29, 175914745 },
	{ 28, 132660985 },
	{ 28, 116145913 },
	{ 28, 66600697 },
	{ 28, 50085625 },
	{ 26, 24723453 },
	{ 26, 7946237 },
	{ 20, 519450 },
	{ 26, 7159801 },
	{ 26, 23674873 },
	{ 27, 20791289 },
	{ 27, 28917753 },
	{ 27, 53297145 },
	{ 27, 61423609 },
	{ 27, 43859961 },
	{ 27, 47792121 },
	{ 27, 59588601 },
	{ 27, 63520761 },
	{ 26, 27607033 },
	{ 26, 28393465 },
	{ 26, 27475961 },
	{ 26, 27738105 },
	{ 26, 28721149 },
	{ 27, 48167679 },
	{ 28, 245121017 },
	{ 28, 111099897 },
	{ 28, 115228669 },
	{ 29, 230178809 },
	{ 29, 222052345 },
	{ 29, 258490361 },
	{ 29, 241975289 },
	{ 29, 192430073 },
	{ 29, 175915001 },
	{ 28, 132661241 },
	{ 28, 116146169 },
	{ 28, 66600953 },
	{ 28, 50085881 },
	{ 26, 24996605 },
	{ 26, 8219389 },
	{ 21, 863642 },
	{ 26, 7957241 },
	{ 26, 23948025 },
	{ 27, 47771643 },
	{ 27, 29190905 },
	{ 27, 54094585 },
	{ 27, 61696761 },
	{ 28, 134114041 },
	{ 27, 48065273 },
	{ 27, 60386041 },
	{ 27, 63793913 },
	{ 26, 33450745 },
	{ 26, 16673529 },
	{ 26, 31550201 },
	{ 26, 66349817 },
	{ 26, 28797689 },
	{ 26, 31877885 },
	{ 27, 49737727 },
	{ 28, 131885817 },
	{ 28, 115305209 },
	{ 28, 127822589 },
	{ 29, 221801209 },
	{ 28, 129788665 },
	{ 29, 241724153 },
	{ 29, 191654649 },
	{ 29, 175663865 },
	{ 28, 125594361 },
	{ 28, 115895033 },
	{ 28, 65825529 },
	{ 28, 49834745 },
	{ 26, 33319673 },
	{ 26, 8219645 },
	{ 21, 868330 },
	{ 26, 7957497 },
	{ 26, 23948281 },
	{ 27, 47771387 },
	{ 27, 29191161 },
	{ 27, 54094841 },
	{ 27, 61697017 },
	{ 28, 134114297 },
	{ 27, 48065529 },
	{ 27, 60386297 },
	{ 27, 63794169 },
	{ 26, 33451001 },
	{ 26, 16673785 },
	{ 26, 31550457 },
	{ 26, 66350073 },
	{ 26, 28797945 },
	{ 26, 31878141 },
	{ 27, 49737471 },
	{ 28, 131886073 },
	{ 28, 115305465 },
	{ 28, 127822845 },
	{ 29, 221801465 },
	{ 28, 129788921 },
	{ 29, 241724409 },
	{ 29, 191654905 },
	{ 29, 175664121 },
	{ 28, 125594617 },
	{ 28, 115895289 },
	{ 28, 65825785 },
	{ 28, 49835001 },
	{ 26, 33319929 },
	{ 26, 15298301 },
	{ 21, 884714 },
	{ 26, 8220409 },
	{ 26, 24735481 },
	{ 27, 49343483 },
	{ 28, 57241337 },
	{ 27, 54357753 },
	{ 27, 62484217 },
	{ 28, 86863609 },
	{ 28, 133852921 },
	{ 27, 60649209 },
	{ 27, 64581369 },
	{ 26, 33517309 },
	{ 26, 33189625 },
	{ 26, 16412409 },
	{ 26, 66088697 },
	{ 26, 65302265 },
	{ 26, 31944441 },
	{ 26, 32927485 },
	{ 27, 50260991 },
	{ 28, 127692537 },
	{ 28, 127889145 },
	{ 28, 132017917 },
	{ 28, 129527545 },
	{ 28, 121401081 },
	{ 29, 191393529 },
	{ 29, 174878457 },
	{ 28, 125333241 },
	{ 28, 108818169 },
	{ 28, 65564409 },
	{ 28, 49049337 },
	{ 26, 33058553 },
	{ 26, 16543481 },
	{ 21, 900970 },
	{ 26, 8220665 },
	{ 26, 24735737 },
	{ 27, 49343227 },
	{ 28, 57241593 },
	{ 27, 54358009 },
	{ 27, 62484473 },
	{ 28, 86863865 },
	{ 28, 133853177 },
	{ 27, 60649465 },
	{ 27, 64581625 },
	{ 26, 33517565 },
	{ 26, 33189881 },
	{ 26, 16412665 },
	{ 26, 66088953 },
	{ 26, 65302521 },
	{ 26, 31944697 },
	{ 26, 32927741 },
	{ 27, 50260735 },
	{ 28, 127692793 },
	{ 28, 127889401 },
	{ 28, 132018173 },
	{ 28, 129527801 },
	{ 28, 121401337 },
	{ 29, 191393785 },
	{ 29, 174878713 },
	{ 28, 125333497 },
	{ 28, 108818425 },
	{ 28, 65564665 },
	{ 28, 49049593 },
	{ 26, 33058809 },
	{ 26, 16543737 },
	{ 21, 917354 },
	{ 21, 2093038 },
	{ 26, 25000697 },
	{ 27, 49856507 },
	{ 28, 57506553 },
	{ 28, 107576057 },
	{ 27, 62749433 },
	{ 28, 87653113 },
	{ 28, 95255289 },
	{ 28, 133069561 },
	{ 27, 64846585 },
	{ 28, 65960697 },
	{ 26, 33258237 },
	{ 26, 32406265 },
	{ 26, 15629049 },
	{ 26, 65043193 },
	{ 26, 62159609 },
	{ 26, 32996089 },
	{ 26, 61242109 },
	{ 27, 64405503 },
	{ 28, 115112697 },
	{ 28, 132086521 },
	{ 28, 128744185 },
	{ 28, 121142009 },
	{ 28, 96238329 },
	{ 29, 174619385 },
	{ 28, 124549881 },
	{ 28, 108559097 },
	{ 28, 58489593 },
	{ 28, 48790265 },
	{ 26, 32275193 },
	{ 26, 16284409 },
	{ 21, 998890 },
	{ 21, 2076654 },
	{ 26, 25000953 },
	{ 27, 49856251 },
	{ 28, 57506809 },
	{ 28, 107576313 },
	{ 27, 62749689 },
	{ 28, 87653369 },
	{ 28, 95255545 },
	{ 28, 133069817 },
	{ 27, 64846841 },
	{ 28, 65960953 },
	{ 26, 33258493 },
	{ 26, 32406521 },
	{ 26, 15629305 },
	{ 26, 65043449 },
	{ 26, 62159865 },
	{ 26, 32996345 },
	{ 26, 61242365 },
	{ 27, 64405247 },
	{ 28, 115112953 },
	{ 28, 132086777 },
	{ 28, 128744441 },
	{ 28, 121142265 },
	{ 28, 96238585 },
	{ 29, 174619641 },
	{ 28, 124550137 },
	{ 28, 108559353 },
	{ 28, 58489849 },
	{ 28, 48790521 },
	{ 26, 32275449 },
	{ 26, 16284665 },
	{ 21, 1015274 },
	{ 21, 2063726 },
	{ 26, 32079609 },
	{ 27, 64011259 },
	{ 28, 58294009 },
	{ 28, 107839225 },
	{ 28, 124354297 },
	{ 28, 87916281 },
	{ 28, 96042745 },
	{ 28, 120422137 },
	{ 28, 132808441 },
	{ 28, 116031225 },
	{ 28, 65699577 },
	{ 26, 32472829 },
	{ 26, 32145145 },
	{ 26, 15367929 },
	{ 26, 61898489 },
	{ 26, 61112057 },
	{ 26, 61308665 },
	{ 26, 62291709 },
	{ 27, 64928767 },
	{ 28, 110919417 },
	{ 28, 128483065 },
	{ 28, 120356601 },
	{ 28, 95977209 },
	{ 28, 87850745 },
	{ 28, 124288761 },
	{ 28, 107773689 },
	{ 28, 58228473 },
	{ 28, 41713401 },
	{ 26, 32014073 },
	{ 26, 15499001 },
	{ 21, 1031530 },
	{ 21, 2047342 },
	{ 26, 32079865 },
	{ 27, 64011003 },
	{ 28, 58294265 },
	{ 28, 107839481 },
	{ 28, 124354553 },
	{ 28, 87916537 },
	{ 28, 96043001 },
	{ 28, 120422393 },
	{ 28, 132808697 },
	{ 28, 116031481 },
	{ 28, 65699833 },
	{ 26, 32473085 },
	{ 26, 32145401 },
	{ 26, 15368185 },
	{ 26, 61898745 },
	{ 26, 61112313 },
	{ 26, 61308921 },
	{ 26, 62291965 },
	{ 27, 64928511 },
	{ 28, 110919673 },
	{ 28, 128483321 },
	{ 28, 120356857 },
	{ 28, 95977465 },
	{ 28, 87851001 },
	{ 28, 124289017 },
	{ 28, 107773945 },
	{ 28, 58228729 },
	{ 28, 41713657 },
	{ 26, 32014329 },
	{ 26, 15499257 },
	{ 21, 1047914 },
	{ 21, 1965550 },
	{ 26, 33062909 },
	{ 27, 64532475 },
	{ 28, 66617341 },
	{ 28, 116948989 },
	{ 28, 133726205 },
	{ 29, 184057853 },
	{ 29, 192588537 },
	{ 29, 242395897 },
	{ 29, 257600249 },
	{ 29, 251439865 },
	{ 29, 217885433 },
	{ 29, 117222137 },
	{ 27, 64400125 },
	{ 27, 50113273 },
	{ 27, 16558841 },
	{ 27, 121678585 },
	{ 27, 65579769 },
	{ 27, 124693241 },
	{ 27, 130853629 },
	{ 27, 66498559 },
	{ 28, 129542905 },
	{ 28, 129675259 },
	{ 29, 190360313 },
	{ 29, 175155961 },
	{ 28, 125348601 },
	{ 28, 125480955 },
	{ 29, 114862841 },
	{ 29, 82881273 },
	{ 27, 49851129 },
	{ 27, 30452473 },
	{ 21, 1912810 },
	{ 21, 1949166 },
	{ 27, 64662521 },
	{ 27, 64532219 },
	{ 29, 117091321 },
	{ 29, 217230329 },
	{ 29, 249211897 },
	{ 29, 249081595 },
	{ 29, 192588793 },
	{ 29, 242396153 },
	{ 29, 257600505 },
	{ 29, 251440121 },
	{ 29, 217885689 },
	{ 29, 117222393 },
	{ 27, 64400381 },
	{ 27, 50113529 },
	{ 27, 16559097 },
	{ 27, 121678841 },
	{ 27, 65580025 },
	{ 27, 124693497 },
	{ 27, 130853885 },
	{ 27, 66498303 },
	{ 28, 129543161 },
	{ 28, 129675003 },
	{ 29, 190360569 },
	{ 29, 175156217 },
	{ 28, 125348857 },
	{ 28, 125480699 },
	{ 29, 114863097 },
	{ 29, 82881529 },
	{ 27, 49851385 },
	{ 27, 30452729 },
	{ 21, 1929194 },
	{ 21, 1933166 },
	{ 27, 66236153 },
	{ 27, 66104315 },
	{ 29, 131247865 },
	{ 29, 217755385 },
	{ 29, 250785529 },
	{ 29, 250653691 },
	{ 30, 519352057 },
	{ 29, 242921209 },
	{ 29, 259174137 },
	{ 29, 251571965 },
	{ 29, 250916601 },
	{ 29, 217362169 },
	{ 29, 116698873 },
	{ 27, 50245373 },
	{ 27, 49590009 },
	{ 27, 16035577 },
	{ 27, 65056505 },
	{ 27, 63483641 },
	{ 27, 130985721 },
	{ 27, 132951805 },
	{ 27, 67021823 },
	{ 28, 121155321 },
	{ 28, 121285627 },
	{ 29, 173584121 },
	{ 28, 124825337 },
	{ 28, 108572409 },
	{ 28, 108702715 },
	{ 29, 81309433 },
	{ 27, 49327865 },
	{ 27, 16297721 },
	{ 21, 1945450 },
	{ 21, 1916782 },
	{ 27, 66236409 },
	{ 27, 66104059 },
	{ 29, 131248121 },
	{ 29, 217755641 },
	{ 29, 250785785 },
	{ 29, 250653435 },
	{ 30, 519352313 },
	{ 29, 242921465 },
	{ 29, 259174393 },
	{ 29, 251572221 },
	{ 29, 250916857 },
	{ 29, 217362425 },
	{ 29, 116699129 },
	{ 27, 50245629 },
	{ 27, 49590265 },
	{ 27, 16035833 },
	{ 27, 65056761 },
	{ 27, 63483897 },
	{ 27, 130985977 },
	{ 27, 132952061 },
	{ 27, 67021567 },
	{ 28, 121155577 },
	{ 28, 121285371 },
	{ 29, 173584377 },
	{ 28, 124825593 },
	{ 28, 108572665 },
	{ 28, 108702459 },
	{ 29, 81309689 },
	{ 27, 49328121 },
	{ 27, 16297977 },
	{ 21, 1961834 },
	{ 21, 1048558 },
	{ 27, 66763513 },
	{ 26, 33325051 },
	{ 28, 49840123 },
	{ 28, 65830907 },
	{ 28, 115900411 },
	{ 28, 125599739 },
	{ 29, 175669243 },
	{ 29, 191660027 },
	{ 29, 259701497 },
	{ 28, 129794043 },
	{ 29, 251050749 },
	{ 28, 127827967 },
	{ 28, 115310587 },
	{ 28, 131891195 },
	{ 27, 49724157 },
	{ 26, 31883263 },
	{ 26, 28803067 },
	{ 26, 66355195 },
	{ 26, 31555579 },
	{ 26, 16678907 },
	{ 26, 33456123 },
	{ 27, 63799291 },
	{ 27, 60391419 },
	{ 27, 48070651 },
	{ 28, 123255545 },
	{ 27, 61702139 },
	{ 27, 54099963 },
	{ 27, 29196283 },
	{ 27, 47758073 },
	{ 26, 23953403 },
	{ 21, 2043370 },
	{ 21, 1032174 },
	{ 26, 8224767 },
	{ 26, 33324795 },
	{ 28, 49839867 },
	{ 28, 65830651 },
	{ 28, 115900155 },
	{ 28, 125599483 },
	{ 29, 175668987 },
	{ 29, 191659771 },
	{ 29, 259701753 },
	{ 28, 129793787 },
	{ 29, 251051005 },
	{ 28, 127827711 },
	{ 28, 115310331 },
	{ 28, 131890939 },
	{ 27, 49724413 },
	{ 26, 31883007 },
	{ 26, 28802811 },
	{ 26, 66354939 },
	{ 26, 31555323 },
	{ 26, 16678651 },
	{ 26, 33455867 },
	{ 27, 63799035 },
	{ 27, 60391163 },
	{ 27, 48070395 },
	{ 28, 123255801 },
	{ 27, 61701883 },
	{ 27, 54099707 },
	{ 27, 29196027 },
	{ 27, 47758329 },
	{ 26, 23953147 },
	{ 21, 2059754 },
	{ 21, 1027486 },
	{ 26, 8224511 },
	{ 26, 25001727 },
	{ 28, 50101243 },
	{ 28, 66616315 },
	{ 28, 116161531 },
	{ 28, 132676603 },
	{ 29, 175930363 },
	{ 29, 192445435 },
	{ 29, 241990651 },
	{ 29, 258505723 },
	{ 29, 222067707 },
	{ 29, 249478909 },
	{ 28, 115244031 },
	{ 28, 111115259 },
	{ 28, 245136379 },
	{ 27, 48152317 },
	{ 26, 28736511 },
	{ 26, 27753467 },
	{ 26, 27491323 },
	{ 26, 28408827 },
	{ 26, 27622395 },
	{ 27, 63536123 },
	{ 27, 59603963 },
	{ 27, 47807483 },
	{ 27, 43875323 },
	{ 27, 61438971 },
	{ 27, 53312507 },
	{ 27, 28933115 },
	{ 27, 47234809 },
	{ 26, 23690235 },
	{ 21, 2076010 },
	{ 21, 1010974 },
	{ 26, 7961599 },
	{ 26, 24738815 },
	{ 28, 50100987 },
	{ 28, 66616059 },
	{ 28, 116161275 },
	{ 28, 132676347 },
	{ 29, 175930107 },
	{ 29, 192445179 },
	{ 29, 241990395 },
	{ 29, 258505467 },
	{ 29, 222067451 },
	{ 29, 249479165 },
	{ 28, 115243775 },
	{ 28, 111115003 },
	{ 28, 245136123 },
	{ 27, 48152573 },
	{ 26, 28736255 },
	{ 26, 27753211 },
	{ 26, 27491067 },
	{ 26, 28408571 },
	{ 26, 27622139 },
	{ 27, 63535867 },
	{ 27, 59603707 },
	{ 27, 47807227 },
	{ 27, 43875067 },
	{ 27, 61438715 },
	{ 27, 53312251 },
	{ 27, 28932859 },
	{ 27, 47235065 },
	{ 26, 23689979 },
	{ 21, 2092394 },
	{ 21, 994590 },
	{ 26, 7961343 },
	{ 26, 24738559 },
	{ 28, 41515775 },
	{ 28, 66875387 },
	{ 28, 116944891 },
	{ 28, 132935675 },
	{ 29, 183005179 },
	{ 29, 192704507 },
	{ 29, 242774011 },
	{ 29, 259844857 },
	{ 28, 129986555 },
	{ 28, 129724411 },
	{ 28, 128937979 },
	{ 28, 125627129 },
	{ 27, 64974843 },
	{ 27, 64712699 },
	{ 27, 47639293 },
	{ 26, 24963833 },
	{ 25, 16216059 },
	{ 25, 15953915 },
	{ 26, 32041721 },
	{ 25, 16084987 },
	{ 27, 59338747 },
	{ 27, 47017979 },
	{ 27, 62450425 },
	{ 26, 31289339 },
	{ 27, 53047291 },
	{ 27, 28143611 },
	{ 26, 24701689 },
	{ 25, 12414971 },
	{ 26, 6909947 },
	{ 20, 456606 },
	{ 26, 7172095 },
	{ 26, 23949311 },
	{ 28, 40726527 },
	{ 28, 66875131 },
	{ 28, 116944635 },
	{ 28, 132935419 },
	{ 29, 183004923 },
	{ 29, 192704251 },
	{ 29, 242773755 },
	{ 29, 259845113 },
	{ 28, 129986299 },
	{ 28, 129724155 },
	{ 28, 128937723 },
	{ 28, 125627385 },
	{ 27, 64974587 },
	{ 27, 64712443 },
	{ 27, 47639549 },
	{ 26, 24964089 },
	{ 25, 16215803 },
	{ 25, 15953659 },
	{ 26, 32041977 },
	{ 25, 16084731 },
	{ 27, 59338491 },
	{ 27, 47017723 },
	{ 27, 62450681 },
	{ 26, 31289083 },
	{ 27, 53047035 },
	{ 27, 28143355 },
	{ 26, 24701945 },
	{ 25, 12414715 },
	{ 26, 6909691 },
	{ 20, 448414 },
	{ 26, 7171839 },
	{ 26, 23949055 },
	{ 28, 40726271 },
	{ 28, 57503487 },
	{ 28, 117206011 },
	{ 28, 133721083 },
	{ 29, 183266299 },
	{ 29, 199781371 },
	{ 29, 243035131 },
	{ 29, 259976957 },
	{ 28, 129919999 },
	{ 28, 121596923 },
	{ 28, 121334779 },
	{ 28, 125759229 },
	{ 27, 64908287 },
	{ 27, 60779515 },
	{ 27, 60517371 },
	{ 26, 25095933 },
	{ 25, 16149503 },
	{ 25, 15166459 },
	{ 25, 14904315 },
	{ 25, 15821819 },
	{ 25, 15035387 },
	{ 27, 46754811 },
	{ 27, 61927161 },
	{ 26, 31026171 },
	{ 26, 27094011 },
	{ 27, 27880443 },
	{ 26, 24178425 },
	{ 25, 12151803 },
	{ 25, 4025339 },
	{ 20, 440094 },
	{ 26, 6908927 },
	{ 26, 23686143 },
	{ 28, 40463359 },
	{ 28, 57240575 },
	{ 28, 117205755 },
	{ 28, 133720827 },
	{ 29, 183266043 },
	{ 29, 199781115 },
	{ 29, 243034875 },
	{ 29, 259977213 },
	{ 28, 129919743 },
	{ 28, 121596667 },
	{ 28, 121334523 },
	{ 28, 125759485 },
	{ 27, 64908031 },
	{ 27, 60779259 },
	{ 27, 60517115 },
	{ 26, 25096189 },
	{ 25, 16149247 },
	{ 25, 15166203 },
	{ 25, 14904059 },
	{ 25, 15821563 },
	{ 25, 15035131 },
	{ 27, 46754555 },
	{ 27, 61927417 },
	{ 26, 31025915 },
	{ 26, 27093755 },
	{ 27, 27880187 },
	{ 26, 24178681 },
	{ 25, 12151547 },
	{ 25, 4025083 },
	{ 20, 431902 },
	{ 26, 6908671 },
	{ 26, 23685887 },
	{ 28, 40463103 },
	{ 28, 57240319 },
	{ 28, 107571967 },
	{ 28, 133971963 },
	{ 29, 184041467 },
	{ 29, 200032251 },
	{ 29, 250101755 },
	{ 29, 259801083 },
	{ 29, 259455741 },
	{ 28, 121520127 },
	{ 28, 96419835 },
	{ 28, 96157691 },
	{ 28, 125238013 },
	{ 27, 60702719 },
	{ 27, 48185339 },
	{ 27, 47923195 },
	{ 26, 24574717 },
	{ 25, 15089663 },
	{ 25, 12009467 },
	{ 25, 11747323 },
	{ 25, 14761979 },
	{ 25, 11878395 },
	{ 27, 60357369 },
	{ 26, 30228475 },
	{ 26, 26820603 },
	{ 26, 14499835 },
	{ 26, 22608633 },
	{ 25, 11354107 },
	{ 25, 3751931 },
	{ 19, 259486 },
	{ 25, 4014079 },
	{ 25, 12402687 },
	{ 27, 20791295 },
	{ 27, 29179903 },
	{ 27, 54345727 },
	{ 27, 62734335 },
	{ 28, 87900159 },
	{ 28, 96288767 },
	{ 28, 121454591 },
	{ 28, 129843199 },
	{ 29, 259455997 },
	{ 28, 121519871 },
	{ 28, 96419579 },
	{ 28, 96157435 },
	{ 28, 125238269 },
	{ 27, 60702463 },
	{ 27, 48185083 },
	{ 27, 47922939 },
	{ 26, 24574973 },
	{ 25, 15089407 },
	{ 25, 12009211 },
	{ 25, 11747067 },
	{ 25, 14761723 },
	{ 25, 11878139 },
	{ 27, 60357625 },
	{ 26, 30228219 },
	{ 26, 26820347 },
	{ 26, 14499579 },
	{ 26, 22608889 },
	{ 25, 11353851 },
	{ 25, 3751675 },
	{ 19, 251294 },
	{ 25, 4013823 },
	{ 25, 12402431 },
	{ 27, 20791039 },
	{ 27, 29179647 },
	{ 27, 54345471 },
	{ 27, 62734079 },
	{ 28, 87899903 },
	{ 28, 96288511 },
	{ 28, 121454335 },
	{ 28, 129842943 },
	{ 29, 175848443 },
	{ 29, 257883901 },
	{ 28, 96353279 },
	{ 28, 88030203 },
	{ 28, 87768059 },
	{ 28, 123666173 },
	{ 27, 48118783 },
	{ 27, 43990011 },
	{ 27, 43727867 },
	{ 26, 23002877 },
	{ 25, 11942911 },
	{ 25, 10959867 },
	{ 25, 10697723 },
	{ 25, 11615227 },
	{ 25, 10828795 },
	{ 26, 29965307 },
	{ 26, 26033147 },
	{ 26, 14236667 },
	{ 26, 22085369 },
	{ 25, 11090939 },
	{ 25, 2964475 },
	{ 19, 242974 },
	{ 25, 3750911 },
	{ 25, 12139519 },
	{ 27, 20528127 },
	{ 27, 28916735 },
	{ 27, 54082559 },
	{ 27, 62471167 },
	{ 28, 87636991 },
	{ 28, 96025599 },
	{ 28, 121191423 },
	{ 28, 129580031 },
	{ 29, 175848187 },
	{ 29, 257884157 },
	{ 28, 96353023 },
	{ 28, 88029947 },
	{ 28, 87767803 },
	{ 28, 123666429 },
	{ 27, 48118527 },
	{ 27, 43989755 },
	{ 27, 43727611 },
	{ 26, 23003133 },
	{ 25, 11942655 },
	{ 25, 10959611 },
	{ 25, 10697467 },
	{ 25, 11614971 },
	{ 25, 10828539 },
	{ 26, 29965051 },
	{ 26, 26032891 },
	{ 26, 14236411 },
	{ 26, 22085625 },
	{ 25, 11090683 },
	{ 25, 2964219 },
	{ 19, 234782 },
	{ 25, 3750655 },
	{ 25, 12139263 },
	{ 27, 20527871 },
	{ 27, 28916479 },
	{ 27, 54082303 },
	{ 27, 62470911 },
	{ 28, 134164475 },
	{ 28, 133902331 },
	{ 28, 133115899 },
	{ 28, 132853755 },
	{ 28, 125775867 },
	{ 28, 125513723 },
	{ 28, 124727291 },
	{ 28, 124465147 },
	{ 27, 62861307 },
	{ 27, 62599163 },
	{ 27, 61812731 },
	{ 27, 61550587 },
	{ 26, 31404027 },
	{ 26, 31141883 },
	{ 26, 30355451 },
	{ 25, 10891263 },
	{ 24, 7811067 },
	{ 24, 7548923 },
	{ 25, 10563579 },
	{ 24, 7679995 },
	{ 26, 25767931 },
	{ 26, 13447163 },
	{ 26, 24226553 },
	{ 24, 6107131 },
	{ 25, 2699259 },
	{ 18, 97182 },
	{ 25, 2961407 },
	{ 25, 11350015 },
	{ 27, 19738623 },
	{ 27, 28127231 },
	{ 27, 53293055 },
	{ 27, 61681663 },
	{ 28, 134164219 },
	{ 28, 133902075 },
	{ 28, 133115643 },
	{ 28, 132853499 },
	{ 28, 125775611 },
	{ 28, 125513467 },
	{ 28, 124727035 },
	{ 28, 124464891 },
	{ 27, 62861051 },
	{ 27, 62598907 },
	{ 27, 61812475 },
	{ 27, 61550331 },
	{ 26, 31403771 },
	{ 26, 31141627 },
	{ 26, 30355195 },
	{ 25, 10891007 },
	{ 24, 7810811 },
	{ 24, 7548667 },
	{ 25, 10563323 },
	{ 24, 7679739 },
	{ 26, 25767675 },
	{ 26, 13446907 },
	{ 26, 24226809 },
	{ 24, 6106875 },
	{ 25, 2699003 },
	{ 18, 93086 },
	{ 25, 2961151 },
	{ 25, 11349759 },
	{ 27, 19738367 },
	{ 27, 28126975 },
	{ 27, 53292799 },
	{ 27, 61681407 },
	{ 28, 86847231 },
	{ 28, 117386235 },
	{ 28, 117124091 },
	{ 28, 116337659 },
	{ 28, 116075515 },
	{ 28, 108997627 },
	{ 28, 108735483 },
	{ 28, 107949051 },
	{ 27, 62794751 },
	{ 27, 54471675 },
	{ 27, 54209531 },
	{ 27, 53423099 },
	{ 26, 31337471 },
	{ 26, 27208699 },
	{ 26, 26946555 },
	{ 26, 25014013 },
	{ 24, 7744511 },
	{ 24, 6761467 },
	{ 24, 6499323 },
	{ 24, 7416827 },
	{ 24, 6630395 },
	{ 26, 13183995 },
	{ 26, 23179001 },
	{ 24, 5843963 },
	{ 24, 1911803 },
	{ 18, 88862 },
	{ 25, 2698239 },
	{ 25, 11086847 },
	{ 27, 19475455 },
	{ 27, 27864063 },
	{ 27, 53029887 },
	{ 27, 61418495 },
	{ 28, 134097663 },
	{ 28, 117385979 },
	{ 28, 117123835 },
	{ 28, 116337403 },
	{ 28, 116075259 },
	{ 28, 108997371 },
	{ 28, 108735227 },
	{ 28, 107948795 },
	{ 27, 62794495 },
	{ 27, 54471419 },
	{ 27, 54209275 },
	{ 27, 53422843 },
	{ 26, 31337215 },
	{ 26, 27208443 },
	{ 26, 26946299 },
	{ 26, 25014269 },
	{ 24, 7744255 },
	{ 24, 6761211 },
	{ 24, 6499067 },
	{ 24, 7416571 },
	{ 24, 6630139 },
	{ 26, 13183739 },
	{ 26, 23179257 },
	{ 24, 5843707 },
	{ 24, 1911547 },
	{ 18, 84766 },
	{ 25, 2697983 },
	{ 25, 11086591 },
	{ 27, 19475199 },
	{ 27, 27863807 },
	{ 27, 53029631 },
	{ 27, 61418239 },
	{ 28, 86584063 },
	{ 26, 29335551 },
	{ 26, 16769019 },
	{ 26, 16703483 },
	{ 26, 16506875 },
	{ 26, 16441339 },
	{ 26, 14671867 },
	{ 26, 14606331 },
	{ 26, 14409723 },
	{ 25, 13606911 },
	{ 25, 7331835 },
	{ 25, 7266299 },
	{ 25, 7069691 },
	{ 24, 6791167 },
	{ 24, 3661819 },
	{ 24, 3596283 },
	{ 24, 3399675 },
	{ 22, 1679359 },
	{ 22, 909307 },
	{ 22, 843771 },
	{ 22, 1597435 },
	{ 22, 876539 },
	{ 24, 2252795 },
	{ 22, 1269755 },
	{ 22, 417787 },
	{ 17, 63902 },
	{ 22, 483327 },
	{ 22, 1531903 },
	{ 24, 2580479 },
	{ 24, 3629055 },
	{ 24, 6774783 },
	{ 24, 7823359 },
	{ 25, 10969087 },
	{ 25, 12017663 },
	{ 25, 15163391 },
	{ 25, 16211967 },
	{ 26, 16506619 },
	{ 26, 16441083 },
	{ 26, 14671611 },
	{ 26, 14606075 },
	{ 26, 14409467 },
	{ 25, 13606655 },
	{ 25, 7331579 },
	{ 25, 7266043 },
	{ 25, 7069435 },
	{ 24, 6790911 },
	{ 24, 3661563 },
	{ 24, 3596027 },
	{ 24, 3399419 },
	{ 22, 1679103 },
	{ 22, 909051 },
	{ 22, 843515 },
	{ 22, 1597179 },
	{ 22, 876283 },
	{ 24, 2252539 },
	{ 22, 1269499 },
	{ 22, 417531 },
	{ 17, 59806 },
	{ 22, 483071 },
	{ 22, 1531647 },
	{ 24, 2580223 },
	{ 24, 3628799 },
	{ 24, 6774527 },
	{ 24, 7823103 },
	{ 25, 10968831 },
	{ 25, 12017407 },
	{ 25, 15163135 },
	{ 25, 16211711 },
	{ 26, 12508155 },
	{ 26, 12311547 },
	{ 26, 12246011 },
	{ 26, 10476539 },
	{ 26, 10411003 },
	{ 26, 10214395 },
	{ 25, 7314431 },
	{ 25, 5233659 },
	{ 25, 5168123 },
	{ 25, 4971515 },
	{ 24, 3644415 },
	{ 24, 2612219 },
	{ 24, 2546683 },
	{ 24, 2350075 },
	{ 22, 891903 },
	{ 22, 646139 },
	{ 22, 580603 },
	{ 22, 809979 },
	{ 22, 613371 },
	{ 22, 1203195 },
	{ 22, 220155 },
	{ 17, 55582 },
	{ 22, 416767 },
	{ 22, 1465343 },
	{ 24, 2513919 },
	{ 24, 3562495 },
	{ 24, 6708223 },
	{ 24, 7756799 },
	{ 25, 10902527 },
	{ 25, 11951103 },
	{ 25, 15096831 },
	{ 25, 16145407 },
	{ 26, 12507899 },
	{ 26, 12311291 },
	{ 26, 12245755 },
	{ 26, 10476283 },
	{ 26, 10410747 },
	{ 26, 10214139 },
	{ 25, 7314175 },
	{ 25, 5233403 },
	{ 25, 5167867 },
	{ 25, 4971259 },
	{ 24, 3644159 },
	{ 24, 2611963 },
	{ 24, 2546427 },
	{ 24, 2349819 },
	{ 22, 891647 },
	{ 22, 645883 },
	{ 22, 580347 },
	{ 22, 809723 },
	{ 22, 613115 },
	{ 22, 1202939 },
	{ 22, 219899 },
	{ 17, 51486 },
	{ 22, 416511 },
	{ 22, 1465087 },
	{ 24, 2513663 },
	{ 24, 3562239 },
	{ 24, 6707967 },
	{ 24, 7756543 },
	{ 25, 10902271 },
	{ 25, 11950847 },
	{ 25, 15096575 },
	{ 25, 16145151 },
	{ 24, 8376315 },
	{ 24, 8310779 },
	{ 24, 8114171 },
	{ 24, 8048635 },
	{ 24, 6279163 },
	{ 24, 6213627 },
	{ 24, 6017019 },
	{ 24, 5951483 },
	{ 23, 3133435 },
	{ 23, 3067899 },
	{ 23, 2871291 },
	{ 23, 2805755 },
	{ 22, 1560571 },
	{ 22, 1495035 },
	{ 22, 1298427 },
	{ 22, 1232891 },
	{ 20, 380923 },
	{ 20, 315387 },
	{ 22, 544763 },
	{ 20, 348155 },
	{ 22, 151547 },
	{ 15, 7838 },
	{ 22, 217087 },
	{ 22, 1265663 },
	{ 24, 2314239 },
	{ 24, 3362815 },
	{ 24, 6508543 },
	{ 24, 7557119 },
	{ 25, 10702847 },
	{ 25, 11751423 },
	{ 25, 14897151 },
	{ 25, 15945727 },
	{ 24, 8376059 },
	{ 24, 8310523 },
	{ 24, 8113915 },
	{ 24, 8048379 },
	{ 24, 6278907 },
	{ 24, 6213371 },
	{ 24, 6016763 },
	{ 24, 5951227 },
	{ 23, 3133179 },
	{ 23, 3067643 },
	{ 23, 2871035 },
	{ 23, 2805499 },
	{ 22, 1560315 },
	{ 22, 1494779 },
	{ 22, 1298171 },
	{ 22, 1232635 },
	{ 20, 380667 },
	{ 20, 315131 },
	{ 22, 544507 },
	{ 20, 347899 },
	{ 22, 151291 },
	{ 15, 6814 },
	{ 22, 216831 },
	{ 22, 1265407 },
	{ 24, 2313983 },
	{ 24, 3362559 },
	{ 24, 6508287 },
	{ 24, 7556863 },
	{ 25, 10702591 },
	{ 25, 11751167 },
	{ 25, 14896895 },
	{ 25, 15945471 },
	{ 24, 8358911 },
	{ 24, 4180987 },
	{ 24, 4115451 },
	{ 24, 3918843 },
	{ 24, 3853307 },
	{ 24, 2083835 },
	{ 24, 2018299 },
	{ 24, 1821691 },
	{ 23, 3116031 },
	{ 23, 1035259 },
	{ 23, 969723 },
	{ 23, 773115 },
	{ 22, 1543167 },
	{ 22, 510971 },
	{ 22, 445435 },
	{ 22, 248827 },
	{ 20, 363519 },
	{ 20, 117755 },
	{ 20, 52219 },
	{ 16, 12155 },
	{ 14, 8123 },
	{ 15, 5662 },
	{ 22, 150527 },
	{ 22, 1199103 },
	{ 24, 2247679 },
	{ 24, 3296255 },
	{ 24, 6441983 },
	{ 24, 7490559 },
	{ 25, 10636287 },
	{ 25, 11684863 },
	{ 25, 14830591 },
	{ 25, 15879167 },
	{ 24, 8358655 },
	{ 24, 4180731 },
	{ 24, 4115195 },
	{ 24, 3918587 },
	{ 24, 3853051 },
	{ 24, 2083579 },
	{ 24, 2018043 },
	{ 24, 1821435 },
	{ 23, 3115775 },
	{ 23, 1035003 },
	{ 23, 969467 },
	{ 23, 772859 },
	{ 22, 1542911 },
	{ 22, 510715 },
	{ 22, 445179 },
	{ 22, 248571 },
	{ 20, 363263 },
	{ 20, 117499 },
	{ 20, 51963 },
	{ 16, 10107 },
	{ 13, 3707 },
	{ 15, 4638 },
	{ 22, 150271 },
	{ 22, 1198847 },
	{ 24, 2247423 },
	{ 24, 3295999 },
	{ 24, 6441727 },
	{ 24, 7490303 },
	{ 25, 10636031 },
	{ 25, 11684607 },
	{ 25, 14830335 },
	{ 25, 15878911 },
	{ 26, 27413247 },
	{ 22, 1042431 },
	{ 22, 1026047 },
	{ 22, 976895 },
	{ 22, 960511 },
	{ 22, 518143 },
	{ 22, 501759 },
	{ 22, 452607 },
	{ 22, 436223 },
	{ 21, 255999 },
	{ 21, 239615 },
	{ 21, 190463 },
	{ 21, 174079 },
	{ 20, 124927 },
	{ 20, 108543 },
	{ 20, 59391 },
	{ 20, 43007 },
	{ 18, 26623 },
	{ 18, 10239 },
	{ 11, 831 },
	{ 11, 875 },
	{ 11, 830 },
	{ 13, 4031 },
	{ 18, 88063 },
	{ 20, 153599 },
	{ 20, 219135 },
	{ 20, 415743 },
	{ 20, 481279 },
	{ 21, 677887 },
	{ 21, 743423 },
	{ 21, 940031 },
	{ 21, 1005567 },
	{ 22, 1726463 },
	{ 22, 1042175 },
	{ 22, 1025791 },
	{ 22, 976639 },
	{ 22, 960255 },
	{ 22, 517887 },
	{ 22, 501503 },
	{ 22, 452351 },
	{ 22, 435967 },
	{ 21, 255743 },
	{ 21, 239359 },
	{ 21, 190207 },
	{ 21, 173823 },
	{ 20, 124671 },
	{ 20, 108287 },
	{ 20, 59135 },
	{ 20, 42751 },
	{ 18, 26367 },
	{ 18, 9983 },
	{ 11, 1007 },
	{ 8, 91 },
	{ 8, 78 },
	{ 12, 1663 },
	{ 18, 87807 },
	{ 20, 153343 },
	{ 20, 218879 },
	{ 20, 415487 },
	{ 20, 481023 },
	{ 21, 677631 },
	{ 21, 743167 },
	{ 21, 939775 },
	{ 21, 1005311 },
	{ 22, 1726207 },
	{ 22, 1791743 },
	{ 22, 1988351 },
	{ 22, 2053887 },
	{ 22, 3823359 },
	{ 22, 3888895 },
	{ 22, 4085503 },
	{ 22, 4151039 },
	{ 22, 1967103 },
	{ 22, 1770495 },
	{ 22, 1704959 },
	{ 21, 984063 },
	{ 21, 918527 },
	{ 21, 721919 },
	{ 21, 656383 },
	{ 20, 459775 },
	{ 20, 394239 },
	{ 20, 197631 },
	{ 20, 132095 },
	{ 14, 3455 },
	{ 7, 15 },
	{ 8, 14 },
	{ 10, 367 },
	{ 14, 3967 },
	{ 20, 136191 },
	{ 20, 201727 },
	{ 20, 398335 },
	{ 20, 463871 },
	{ 21, 660479 },
	{ 21, 726015 },
	{ 21, 922623 },
	{ 21, 988159 },
	{ 22, 1709055 },
	{ 22, 1774591 },
	{ 22, 1971199 },
	{ 22, 4129535 },
	{ 22, 4063999 },
	{ 22, 3867391 },
	{ 22, 3801855 },
	{ 22, 2032383 },
	{ 22, 1966847 },
	{ 22, 1770239 },
	{ 22, 1704703 },
	{ 21, 983807 },
	{ 21, 918271 },
	{ 21, 721663 },
	{ 21, 656127 },
	{ 20, 459519 },
	{ 20, 393983 },
	{ 20, 197375 },
	{ 20, 131839 },
	{ 14, 1407 },
	{ 8, 47 },
	{ 6, 22 },
	{ 7, 31 },
	{ 14, 1919 },
	{ 20, 135935 },
	{ 20, 201471 },
	{ 20, 398079 },
	{ 20, 463615 },
	{ 21, 660223 },
	{ 21, 725759 },
	{ 21, 922367 },
	{ 21, 987903 },
	{ 22, 1708799 },
	{ 22, 1774335 },
	{ 22, 1970943 },
	{ 20, 1036799 },
	{ 20, 1020415 },
	{ 20, 971263 },
	{ 20, 954879 },
	{ 20, 512511 },
	{ 20, 496127 },
	{ 20, 446975 },
	{ 20, 430591 },
	{ 19, 250367 },
	{ 19, 233983 },
	{ 19, 184831 },
	{ 19, 168447 },
	{ 18, 119295 },
	{ 18, 102911 },
	{ 18, 53759 },
	{ 18, 37375 },
	{ 16, 20991 },
	{ 10, 191 },
	{ 6, 54 },
	{ 5, 19 },
	{ 9, 59 },
	{ 16, 3583 },
	{ 16, 19967 },
	{ 18, 36351 },
	{ 18, 52735 },
	{ 18, 101887 },
	{ 18, 118271 },
	{ 19, 167423 },
	{ 19, 183807 },
	{ 19, 232959 },
	{ 19, 249343 },
	{ 20, 429567 },
	{ 20, 1037565 },
	{ 20, 1021181 },
	{ 20, 972029 },
	{ 20, 955645 },
	{ 20, 513277 },
	{ 20, 496893 },
	{ 20, 447741 },
	{ 20, 431357 },
	{ 19, 251133 },
	{ 19, 234749 },
	{ 19, 185597 },
	{ 19, 169213 },
	{ 18, 120061 },
	{ 18, 103677 },
	{ 18, 54525 },
	{ 18, 38141 },
	{ 16, 21757 },
	{ 10, 125 },
	{ 7, 46 },
	{ 5, 3 },
	{ 9, 237 },
	{ 16, 2301 },
	{ 16, 6397 },
	{ 18, 10493 },
	{ 18, 14589 },
	{ 18, 26877 },
	{ 18, 30973 },
	{ 19, 43261 },
	{ 19, 47357 },
	{ 19, 59645 },
	{ 19, 63741 },
	{ 20, 108797 },
	{ 20, 112893 },
	{ 20, 125181 },
	{ 20, 129277 },
	{ 20, 239869 },
	{ 20, 243965 },
	{ 20, 256253 },
	{ 20, 260349 },
	{ 20, 431613 },
	{ 19, 251389 },
	{ 19, 235005 },
	{ 19, 185853 },
	{ 19, 169469 },
	{ 18, 120317 },
	{ 18, 103933 },
	{ 18, 54781 },
	{ 18, 38397 },
	{ 16, 22013 },
	{ 11, 957 },
	{ 9, 58 },
	{ 9, 105 },
	{ 9, 61 },
	{ 16, 2557 },
	{ 16, 6653 },
	{ 18, 10749 },
	{ 18, 14845 },
	{ 18, 27133 },
	{ 18, 31229 },
	{ 19, 43517 },
	{ 19, 47613 },
	{ 19, 59901 },
	{ 19, 63997 },
	{ 20, 109053 },
	{ 20, 113149 },
	{ 20, 125437 },
	{ 20, 129533 },
	{ 20, 240125 },
	{ 20, 244221 },
	{ 20, 256509 },
	{ 20, 260605 },
	{ 24, 6853373 },
	{ 23, 3969789 },
	{ 23, 3707645 },
	{ 23, 2921213 },
	{ 23, 2659069 },
	{ 22, 1872637 },
	{ 22, 1610493 },
	{ 22, 824061 },
	{ 22, 561917 },
	{ 20, 299773 },
	{ 20, 37629 },
	{ 13, 538 },
	{ 11, 633 },
	{ 14, 1913 },
	{ 18, 13049 },
	{ 18, 29433 },
	{ 18, 90877 },
	{ 20, 62201 },
	{ 20, 111353 },
	{ 20, 127737 },
	{ 20, 385789 },
	{ 21, 193273 },
	{ 21, 242425 },
	{ 21, 258809 },
	{ 21, 779005 },
	{ 22, 455417 },
	{ 22, 504569 },
	{ 22, 520953 },
	{ 22, 963321 },
	{ 22, 979705 },
	{ 22, 1028857 },
	{ 22, 1045241 },
	{ 22, 2089725 },
	{ 23, 3970045 },
	{ 23, 3707901 },
	{ 23, 2921469 },
	{ 23, 2659325 },
	{ 22, 1872893 },
	{ 22, 1610749 },
	{ 22, 824317 },
	{ 22, 562173 },
	{ 20, 300029 },
	{ 20, 37885 },
	{ 13, 1562 },
	{ 12, 1977 },
	{ 14, 3961 },
	{ 18, 13305 },
	{ 18, 29689 },
	{ 18, 91133 },
	{ 20, 62457 },
	{ 20, 111609 },
	{ 20, 127993 },
	{ 20, 386045 },
	{ 21, 193529 },
	{ 21, 242681 },
	{ 21, 259065 },
	{ 21, 779261 },
	{ 22, 455673 },
	{ 22, 504825 },
	{ 22, 521209 },
	{ 22, 963577 },
	{ 22, 979961 },
	{ 22, 1029113 },
	{ 22, 1045497 },
	{ 22, 2089981 },
	{ 23, 3987197 },
	{ 23, 3725053 },
	{ 23, 2938621 },
	{ 23, 2676477 },
	{ 22, 1890045 },
	{ 22, 1627901 },
	{ 22, 841469 },
	{ 22, 579325 },
	{ 20, 317181 },
	{ 20, 55037 },
	{ 13, 2714 },
	{ 20, 38649 },
	{ 18, 87801 },
	{ 20, 136953 },
	{ 18, 79609 },
	{ 18, 95993 },
	{ 20, 308985 },
	{ 20, 325369 },
	{ 20, 374521 },
	{ 20, 390905 },
	{ 21, 702201 },
	{ 21, 718585 },
	{ 21, 767737 },
	{ 21, 784121 },
	{ 22, 1488633 },
	{ 22, 1505017 },
	{ 22, 1554169 },
	{ 22, 1570553 },
	{ 22, 2012921 },
	{ 22, 2029305 },
	{ 22, 2078457 },
	{ 22, 2094841 },
	{ 23, 3987453 },
	{ 23, 3725309 },
	{ 23, 2938877 },
	{ 23, 2676733 },
	{ 22, 1890301 },
	{ 22, 1628157 },
	{ 22, 841725 },
	{ 22, 579581 },
	{ 20, 317437 },
	{ 20, 55293 },
	{ 13, 3738 },
	{ 20, 38905 },
	{ 18, 88057 },
	{ 20, 137209 },
	{ 18, 79865 },
	{ 18, 96249 },
	{ 20, 309241 },
	{ 20, 325625 },
	{ 20, 374777 },
	{ 20, 391161 },
	{ 21, 702457 },
	{ 21, 718841 },
	{ 21, 767993 },
	{ 21, 784377 },
	{ 22, 1488889 },
	{ 22, 1505273 },
	{ 22, 1554425 },
	{ 22, 1570809 },
	{ 22, 2013177 },
	{ 22, 2029561 },
	{ 22, 2078713 },
	{ 22, 2095097 },
	{ 24, 3139581 },
	{ 25, 15092477 },
	{ 25, 11946749 },
	{ 25, 10898173 },
	{ 24, 7752445 },
	{ 24, 6703869 },
	{ 24, 3558141 },
	{ 24, 2509565 },
	{ 22, 1460989 },
	{ 22, 412413 },
	{ 17, 18714 },
	{ 22, 215801 },
	{ 22, 1198841 },
	{ 22, 609017 },
	{ 22, 805625 },
	{ 22, 576249 },
	{ 22, 641785 },
	{ 22, 887549 },
	{ 24, 2345721 },
	{ 24, 2542329 },
	{ 24, 2607865 },
	{ 24, 3640061 },
	{ 25, 4967161 },
	{ 25, 5163769 },
	{ 25, 5229305 },
	{ 25, 7310077 },
	{ 26, 10210041 },
	{ 26, 10406649 },
	{ 26, 10472185 },
	{ 26, 12241657 },
	{ 26, 12307193 },
	{ 26, 12503801 },
	{ 25, 16141309 },
	{ 25, 15092733 },
	{ 25, 11947005 },
	{ 25, 10898429 },
	{ 24, 7752701 },
	{ 24, 6704125 },
	{ 24, 3558397 },
	{ 24, 2509821 },
	{ 22, 1461245 },
	{ 22, 412669 },
	{ 17, 22810 },
	{ 22, 216057 },
	{ 22, 1199097 },
	{ 22, 609273 },
	{ 22, 805881 },
	{ 22, 576505 },
	{ 22, 642041 },
	{ 22, 887805 },
	{ 24, 2345977 },
	{ 24, 2542585 },
	{ 24, 2608121 },
	{ 24, 3640317 },
	{ 25, 4967417 },
	{ 25, 5164025 },
	{ 25, 5229561 },
	{ 25, 7310333 },
	{ 26, 10210297 },
	{ 26, 10406905 },
	{ 26, 10472441 },
	{ 26, 12241913 },
	{ 26, 12307449 },
	{ 26, 12504057 },
	{ 25, 16207613 },
	{ 25, 15159037 },
	{ 25, 12013309 },
	{ 25, 10964733 },
	{ 24, 7819005 },
	{ 24, 6770429 },
	{ 24, 3624701 },
	{ 24, 2576125 },
	{ 22, 1527549 },
	{ 22, 478973 },
	{ 17, 27034 },
	{ 22, 413433 },
	{ 22, 1265401 },
	{ 24, 2248441 },
	{ 22, 872185 },
	{ 22, 1593081 },
	{ 22, 839417 },
	{ 22, 904953 },
	{ 22, 1675005 },
	{ 24, 3395321 },
	{ 24, 3591929 },
	{ 24, 3657465 },
	{ 24, 6786813 },
	{ 25, 7065337 },
	{ 25, 7261945 },
	{ 25, 7327481 },
	{ 25, 13602557 },
	{ 26, 14405369 },
	{ 26, 14601977 },
	{ 26, 14667513 },
	{ 26, 16436985 },
	{ 26, 16502521 },
	{ 25, 16207869 },
	{ 25, 15159293 },
	{ 25, 12013565 },
	{ 25, 10964989 },
	{ 24, 7819261 },
	{ 24, 6770685 },
	{ 24, 3624957 },
	{ 24, 2576381 },
	{ 22, 1527805 },
	{ 22, 479229 },
	{ 17, 31130 },
	{ 22, 413689 },
	{ 22, 1265657 },
	{ 24, 2248697 },
	{ 22, 872441 },
	{ 22, 1593337 },
	{ 22, 839673 },
	{ 22, 905209 },
	{ 22, 1675261 },
	{ 24, 3395577 },
	{ 24, 3592185 },
	{ 24, 3657721 },
	{ 24, 6787069 },
	{ 25, 7065593 },
	{ 25, 7262201 },
	{ 25, 7327737 },
	{ 25, 13602813 },
	{ 26, 14405625 },
	{ 26, 14602233 },
	{ 26, 14667769 },
	{ 26, 16437241 },
	{ 26, 16502777 },
	{ 26, 16699385 },
	{ 26, 16764921 },
	{ 26, 23747325 },
	{ 26, 21650173 },
	{ 25, 15358717 },
	{ 25, 13261565 },
	{ 25, 6970109 },
	{ 25, 4872957 },
	{ 23, 2775805 },
	{ 23, 678653 },
	{ 17, 51994 },
	{ 22, 482041 },
	{ 22, 1465081 },
	{ 24, 2317049 },
	{ 24, 3300089 },
	{ 22, 1661689 },
	{ 22, 1858297 },
	{ 22, 1628921 },
	{ 22, 1694457 },
	{ 22, 1940221 },
	{ 24, 6544121 },
	{ 24, 6740729 },
	{ 24, 6806265 },
	{ 24, 7838461 },
	{ 25, 13359865 },
	{ 25, 13556473 },
	{ 25, 13622009 },
	{ 25, 15702781 },
	{ 26, 26991353 },
	{ 26, 27187961 },
	{ 26, 27253497 },
	{ 26, 29022969 },
	{ 26, 29088505 },
	{ 26, 29285113 },
	{ 26, 29350649 },
	{ 26, 33528573 },
	{ 25, 15358973 },
	{ 25, 13261821 },
	{ 25, 6970365 },
	{ 25, 4873213 },
	{ 23, 2776061 },
	{ 23, 678909 },
	{ 17, 56090 },
	{ 22, 482297 },
	{ 22, 1465337 },
	{ 24, 2317305 },
	{ 24, 3300345 },
	{ 22, 1661945 },
	{ 22, 1858553 },
	{ 22, 1629177 },
	{ 22, 1694713 },
	{ 22, 1940477 },
	{ 24, 6544377 },
	{ 24, 6740985 },
	{ 24, 6806521 },
	{ 24, 7838717 },
	{ 25, 13360121 },
	{ 25, 13556729 },
	{ 25, 13622265 },
	{ 25, 15703037 },
	{ 26, 26991609 },
	{ 26, 27188217 },
	{ 26, 27253753 },
	{ 26, 29023225 },
	{ 26, 29088761 },
	{ 26, 29285369 },
	{ 26, 29350905 },
	{ 26, 21716733 },
	{ 25, 15425277 },
	{ 25, 13328125 },
	{ 25, 7036669 },
	{ 25, 4939517 },
	{ 23, 2842365 },
	{ 23, 745213 },
	{ 17, 60314 },
	{ 23, 679673 },
	{ 22, 1531641 },
	{ 24, 2514681 },
	{ 24, 3366649 },
	{ 24, 6446841 },
	{ 22, 1924857 },
	{ 23, 2645753 },
	{ 22, 1892089 },
	{ 22, 1957625 },
	{ 23, 2727677 },
	{ 24, 7593721 },
	{ 24, 7790329 },
	{ 24, 7855865 },
	{ 25, 15392505 },
	{ 25, 15458041 },
	{ 25, 15654649 },
	{ 25, 15720185 },
	{ 26, 31121145 },
	{ 26, 31186681 },
	{ 26, 31383289 },
	{ 26, 31448825 },
	{ 26, 33218297 },
	{ 26, 33283833 },
	{ 26, 33480441 },
	{ 26, 33545977 },
	{ 25, 15425533 },
	{ 25, 13328381 },
	{ 25, 7036925 },
	{ 25, 4939773 },
	{ 23, 2842621 },
	{ 23, 745469 },
	{ 17, 64410 },
	{ 23, 679929 },
	{ 22, 1531897 },
	{ 24, 2514937 },
	{ 24, 3366905 },
	{ 24, 6447097 },
	{ 22, 1925113 },
	{ 23, 2646009 },
	{ 22, 1892345 },
	{ 22, 1957881 },
	{ 23, 2727933 },
	{ 24, 7593977 },
	{ 24, 7790585 },
	{ 24, 7856121 },
	{ 25, 15392761 },
	{ 25, 15458297 },
	{ 25, 15654905 },
	{ 25, 15720441 },
	{ 26, 31121401 },
	{ 26, 31186937 },
	{ 26, 31383545 },
	{ 26, 31449081 },
	{ 26, 33218553 },
	{ 26, 33284089 },
	{ 26, 33480697 },
	{ 26, 33546233 },
	{ 27, 62466813 },
	{ 27, 54078205 },
	{ 27, 28912381 },
	{ 27, 20523773 },
	{ 25, 12135165 },
	{ 25, 3746557 },
	{ 19, 169242 },
	{ 25, 2960121 },
	{ 25, 11086585 },
	{ 26, 10300153 },
	{ 26, 14232313 },
	{ 26, 26028793 },
	{ 26, 29960953 },
	{ 25, 10824441 },
	{ 25, 11610873 },
	{ 25, 10693369 },
	{ 25, 10955513 },
	{ 25, 11938557 },
	{ 27, 42937081 },
	{ 27, 43723513 },
	{ 27, 43985657 },
	{ 27, 48114429 },
	{ 28, 86977273 },
	{ 28, 87763705 },
	{ 28, 88025849 },
	{ 28, 96348925 },
	{ 29, 175057657 },
	{ 29, 175844089 },
	{ 28, 129575933 },
	{ 28, 121187325 },
	{ 28, 96021501 },
	{ 28, 87632893 },
	{ 27, 62467069 },
	{ 27, 54078461 },
	{ 27, 28912637 },
	{ 27, 20524029 },
	{ 25, 12135421 },
	{ 25, 3746813 },
	{ 19, 177434 },
	{ 25, 2960377 },
	{ 25, 11086841 },
	{ 26, 10300409 },
	{ 26, 14232569 },
	{ 26, 26029049 },
	{ 26, 29961209 },
	{ 25, 10824697 },
	{ 25, 11611129 },
	{ 25, 10693625 },
	{ 25, 10955769 },
	{ 25, 11938813 },
	{ 27, 42937337 },
	{ 27, 43723769 },
	{ 27, 43985913 },
	{ 27, 48114685 },
	{ 28, 86977529 },
	{ 28, 87763961 },
	{ 28, 88026105 },
	{ 28, 96349181 },
	{ 29, 175057913 },
	{ 29, 175844345 },
	{ 28, 129838845 },
	{ 28, 121450237 },
	{ 28, 96284413 },
	{ 28, 87895805 },
	{ 27, 62729981 },
	{ 27, 54341373 },
	{ 27, 29175549 },
	{ 27, 20786941 },
	{ 25, 12398333 },
	{ 25, 4009725 },
	{ 19, 185754 },
	{ 25, 3747577 },
	{ 25, 11349753 },
	{ 27, 19476217 },
	{ 26, 14495481 },
	{ 26, 26816249 },
	{ 26, 30224121 },
	{ 27, 42544889 },
	{ 25, 11874041 },
	{ 25, 14757625 },
	{ 25, 11742969 },
	{ 25, 12005113 },
	{ 25, 15085309 },
	{ 27, 47132409 },
	{ 27, 47918841 },
	{ 27, 48180985 },
	{ 27, 60698365 },
	{ 28, 95366905 },
	{ 28, 96153337 },
	{ 28, 96415481 },
	{ 28, 121515773 },
	{ 29, 191835897 },
	{ 28, 129839101 },
	{ 28, 121450493 },
	{ 28, 96284669 },
	{ 28, 87896061 },
	{ 27, 62730237 },
	{ 27, 54341629 },
	{ 27, 29175805 },
	{ 27, 20787197 },
	{ 25, 12398589 },
	{ 25, 4009981 },
	{ 19, 193946 },
	{ 25, 3747833 },
	{ 25, 11350009 },
	{ 27, 19476473 },
	{ 26, 14495737 },
	{ 26, 26816505 },
	{ 26, 30224377 },
	{ 27, 42545145 },
	{ 25, 11874297 },
	{ 25, 14757881 },
	{ 25, 11743225 },
	{ 25, 12005369 },
	{ 25, 15085565 },
	{ 27, 47132665 },
	{ 27, 47919097 },
	{ 27, 48181241 },
	{ 27, 60698621 },
	{ 28, 95367161 },
	{ 28, 96153593 },
	{ 28, 96415737 },
	{ 28, 121516029 },
	{ 29, 191836153 },
	{ 29, 259796985 },
	{ 29, 250097657 },
	{ 29, 200028153 },
	{ 29, 184037369 },
	{ 28, 133967865 },
	{ 28, 107559677 },
	{ 28, 57228029 },
	{ 28, 40450813 },
	{ 26, 23673597 },
	{ 26, 6896381 },
	{ 19, 235290 },
	{ 25, 4012793 },
	{ 25, 12139257 },
	{ 26, 24182779 },
	{ 27, 27867897 },
	{ 26, 27081465 },
	{ 26, 31013625 },
	{ 27, 42810105 },
	{ 27, 46742265 },
	{ 25, 15022841 },
	{ 25, 15809273 },
	{ 25, 14891769 },
	{ 25, 15153913 },
	{ 25, 16136957 },
	{ 26, 25100287 },
	{ 27, 60504825 },
	{ 27, 60766969 },
	{ 27, 64895741 },
	{ 28, 120535801 },
	{ 28, 121322233 },
	{ 28, 121584377 },
	{ 28, 129907453 },
	{ 29, 259537657 },
	{ 29, 243022585 },
	{ 29, 199768825 },
	{ 29, 183253753 },
	{ 28, 133708537 },
	{ 28, 117193465 },
	{ 28, 57228285 },
	{ 28, 40451069 },
	{ 26, 23673853 },
	{ 26, 6896637 },
	{ 19, 243482 },
	{ 25, 4013049 },
	{ 25, 12139513 },
	{ 26, 24182523 },
	{ 27, 27868153 },
	{ 26, 27081721 },
	{ 26, 31013881 },
	{ 27, 42810361 },
	{ 27, 46742521 },
	{ 25, 15023097 },
	{ 25, 15809529 },
	{ 25, 14892025 },
	{ 25, 15154169 },
	{ 25, 16137213 },
	{ 26, 25100031 },
	{ 27, 60505081 },
	{ 27, 60767225 },
	{ 27, 64895997 },
	{ 28, 120536057 },
	{ 28, 121322489 },
	{ 28, 121584633 },
	{ 28, 129907709 },
	{ 29, 259537913 },
	{ 29, 243022841 },
	{ 29, 199769081 },
	{ 29, 183254009 },
	{ 28, 133708793 },
	{ 28, 117193721 },
	{ 28, 57491197 },
	{ 28, 40713981 },
	{ 26, 23936765 },
	{ 26, 7159549 },
	{ 19, 251802 },
	{ 26, 6897401 },
	{ 25, 12402425 },
	{ 26, 24706043 },
	{ 27, 28131065 },
	{ 27, 53034745 },
	{ 26, 31276793 },
	{ 27, 43597561 },
	{ 27, 47005433 },
	{ 27, 59326201 },
	{ 25, 16072441 },
	{ 26, 27344633 },
	{ 25, 15941369 },
	{ 25, 16203513 },
	{ 26, 27672317 },
	{ 27, 63913721 },
	{ 27, 64700153 },
	{ 27, 64962297 },
	{ 28, 128663289 },
	{ 28, 128925433 },
	{ 28, 129711865 },
	{ 28, 129974009 },
	{ 29, 258752249 },
	{ 29, 242761465 },
	{ 29, 192691961 },
	{ 29, 182992633 },
	{ 28, 132923129 },
	{ 28, 116932345 },
	{ 28, 66862841 },
	{ 28, 40714237 },
	{ 26, 23937021 },
	{ 26, 7159805 },
	{ 19, 259994 },
	{ 26, 6897657 },
	{ 25, 12402681 },
	{ 26, 24705787 },
	{ 27, 28131321 },
	{ 27, 53035001 },
	{ 26, 31277049 },
	{ 27, 43597817 },
	{ 27, 47005689 },
	{ 27, 59326457 },
	{ 25, 16072697 },
	{ 26, 27344889 },
	{ 25, 15941625 },
	{ 25, 16203769 },
	{ 26, 27672573 },
	{ 27, 63913977 },
	{ 27, 64700409 },
	{ 27, 64962553 },
	{ 28, 128663545 },
	{ 28, 128925689 },
	{ 28, 129712121 },
	{ 28, 129974265 },
	{ 29, 258752505 },
	{ 29, 242761721 },
	{ 29, 192692217 },
	{ 29, 182992889 },
	{ 28, 132923385 },
	{ 28, 116932601 },
	{ 28, 66863097 },
	{ 28, 41511677 },
	{ 26, 24734461 },
	{ 26, 7957245 },
	{ 21, 863514 },
	{ 26, 7170809 },
	{ 26, 23685881 },
	{ 27, 20802297 },
	{ 27, 28928761 },
	{ 27, 53308153 },
	{ 27, 61434617 },
	{ 27, 43870969 },
	{ 27, 47803129 },
	{ 27, 59599609 },
	{ 27, 63531769 },
	{ 26, 27618041 },
	{ 26, 28404473 },
	{ 26, 27486969 },
	{ 26, 27749113 },
	{ 26, 28732157 },
	{ 27, 48164863 },
	{ 28, 245132025 },
	{ 28, 111110905 },
	{ 28, 115239677 },
	{ 29, 230189817 },
	{ 29, 222063353 },
	{ 29, 258501369 },
	{ 29, 241986297 },
	{ 29, 192441081 },
	{ 29, 175926009 },
	{ 28, 132672249 },
	{ 28, 116157177 },
	{ 28, 66611961 },
	{ 28, 50096889 },
	{ 26, 24734717 },
	{ 26, 7957501 },
	{ 21, 879898 },
	{ 26, 7171065 },
	{ 26, 23686137 },
	{ 27, 20802553 },
	{ 27, 28929017 },
	{ 27, 53308409 },
	{ 27, 61434873 },
	{ 27, 43871225 },
	{ 27, 47803385 },
	{ 27, 59599865 },
	{ 27, 63532025 },
	{ 26, 27618297 },
	{ 26, 28404729 },
	{ 26, 27487225 },
	{ 26, 27749369 },
	{ 26, 28732413 },
	{ 27, 48164607 },
	{ 28, 245132281 },
	{ 28, 111111161 },
	{ 28, 115239933 },
	{ 29, 230190073 },
	{ 29, 222063609 },
	{ 29, 258501625 },
	{ 29, 241986553 },
	{ 29, 192441337 },
	{ 29, 175926265 },
	{ 28, 132672505 },
	{ 28, 116157433 },
	{ 28, 66612217 },
	{ 28, 50097145 },
	{ 26, 24997629 },
	{ 26, 8220413 },
	{ 21, 896410 },
	{ 26, 7958265 },
	{ 26, 23949049 },
	{ 27, 47770619 },
	{ 27, 29191929 },
	{ 27, 54095609 },
	{ 27, 61697785 },
	{ 28, 134115065 },
	{ 27, 48066297 },
	{ 27, 60387065 },
	{ 27, 63794937 },
	{ 26, 33451769 },
	{ 26, 16674553 },
	{ 26, 31551225 },
	{ 26, 66350841 },
	{ 26, 28798713 },
	{ 26, 31878909 },
	{ 27, 49736703 },
	{ 28, 131886841 },
	{ 28, 115306233 },
	{ 28, 127823613 },
	{ 29, 221802233 },
	{ 28, 129789689 },
	{ 29, 241725177 },
	{ 29, 191655673 },
	{ 29, 175664889 },
	{ 28, 125595385 },
	{ 28, 115896057 },
	{ 28, 65826553 },
	{ 28, 49835769 },
	{ 26, 33320697 },
	{ 26, 8220669 },
	{ 21, 901098 },
	{ 26, 7958521 },
	{ 26, 23949305 },
	{ 27, 47770363 },
	{ 27, 29192185 },
	{ 27, 54095865 },
	{ 27, 61698041 },
	{ 28, 134115321 },
	{ 27, 48066553 },
	{ 27, 60387321 },
	{ 27, 63795193 },
	{ 26, 33452025 },
	{ 26, 16674809 },
	{ 26, 31551481 },
	{ 26, 66351097 },
	{ 26, 28798969 },
	{ 26, 31879165 },
	{ 27, 49736447 },
	{ 28, 131887097 },
	{ 28, 115306489 },
	{ 28, 127823869 },
	{ 29, 221802489 },
	{ 28, 129789945 },
	{ 29, 241725433 },
	{ 29, 191655929 },
	{ 29, 175665145 },
	{ 28, 125595641 },
	{ 28, 115896313 },
	{ 28, 65826809 },
	{ 28, 49836025 },
	{ 26, 33320953 },
	{ 26, 15301373 },
	{ 21, 917482 },
	{ 21, 2092910 },
	{ 26, 24738553 },
	{ 27, 49332219 },
	{ 28, 57244409 },
	{ 27, 54360825 },
	{ 27, 62487289 },
	{ 28, 86866681 },
	{ 28, 133855993 },
	{ 27, 60652281 },
	{ 27, 64584441 },
	{ 26, 33520381 },
	{ 26, 33192697 },
	{ 26, 16415481 },
	{ 26, 66091769 },
	{ 26, 65305337 },
	{ 26, 31947513 },
	{ 26, 32930557 },
	{ 27, 50249727 },
	{ 28, 127695609 },
	{ 28, 127892217 },
	{ 28, 132020989 },
	{ 28, 129530617 },
	{ 28, 121404153 },
	{ 29, 191396601 },
	{ 29, 174881529 },
	{ 28, 125336313 },
	{ 28, 108821241 },
	{ 28, 65567481 },
	{ 28, 49052409 },
	{ 26, 33061625 },
	{ 26, 16546553 },
	{ 21, 999274 },
	{ 21, 2076526 },
	{ 26, 24738809 },
	{ 27, 49331963 },
	{ 28, 57244665 },
	{ 27, 54361081 },
	{ 27, 62487545 },
	{ 28, 86866937 },
	{ 28, 133856249 },
	{ 27, 60652537 },
	{ 27, 64584697 },
	{ 26, 33520637 },
	{ 26, 33192953 },
	{ 26, 16415737 },
	{ 26, 66092025 },
	{ 26, 65305593 },
	{ 26, 31947769 },
	{ 26, 32930813 },
	{ 27, 50249471 },
	{ 28, 127695865 },
	{ 28, 127892473 },
	{ 28, 132021245 },
	{ 28, 129530873 },
	{ 28, 121404409 },
	{ 29, 191396857 },
	{ 29, 174881785 },
	{ 28, 125336569 },
	{ 28, 108821497 },
	{ 28, 65567737 },
	{ 28, 49052665 },
	{ 26, 33061881 },
	{ 26, 16546809 },
	{ 21, 1015658 },
	{ 21, 2060270 },
	{ 26, 25001721 },
	{ 27, 49855483 },
	{ 28, 57507577 },
	{ 28, 107577081 },
	{ 27, 62750457 },
	{ 28, 87654137 },
	{ 28, 95256313 },
	{ 28, 133070585 },
	{ 27, 64847609 },
	{ 28, 65961721 },
	{ 26, 33259261 },
	{ 26, 32407289 },
	{ 26, 15630073 },
	{ 26, 65044217 },
	{ 26, 62160633 },
	{ 26, 32997113 },
	{ 26, 61243133 },
	{ 27, 64404479 },
	{ 28, 115113721 },
	{ 28, 132087545 },
	{ 28, 128745209 },
	{ 28, 121143033 },
	{ 28, 96239353 },
	{ 29, 174620409 },
	{ 28, 124550905 },
	{ 28, 108560121 },
	{ 28, 58490617 },
	{ 28, 48791289 },
	{ 26, 32276217 },
	{ 26, 16285433 },
	{ 21, 1031658 },
	{ 21, 2043886 },
	{ 26, 25001977 },
	{ 27, 49855227 },
	{ 28, 57507833 },
	{ 28, 107577337 },
	{ 27, 62750713 },
	{ 28, 87654393 },
	{ 28, 95256569 },
	{ 28, 133070841 },
	{ 27, 64847865 },
	{ 28, 65961977 },
	{ 26, 33259517 },
	{ 26, 32407545 },
	{ 26, 15630329 },
	{ 26, 65044473 },
	{ 26, 62160889 },
	{ 26, 32997369 },
	{ 26, 61243389 },
	{ 27, 64404223 },
	{ 28, 115113977 },
	{ 28, 132087801 },
	{ 28, 128745465 },
	{ 28, 121143289 },
	{ 28, 96239609 },
	{ 29, 174620665 },
	{ 28, 124551161 },
	{ 28, 108560377 },
	{ 28, 58490873 },
	{ 28, 48791545 },
	{ 26, 32276473 },
	{ 26, 16285689 },
	{ 21, 1048042 },
	{ 21, 1965422 },
	{ 26, 33325053 },
	{ 27, 64008187 },
	{ 28, 66879485 },
	{ 28, 117211133 },
	{ 28, 133988349 },
	{ 29, 175811321 },
	{ 29, 192064249 },
	{ 29, 240823033 },
	{ 29, 265595641 },
	{ 29, 232041209 },
	{ 29, 131377913 },
	{ 27, 64924413 },
	{ 27, 64269049 },
	{ 27, 30714617 },
	{ 27, 123775737 },
	{ 27, 122202873 },
	{ 27, 122596089 },
	{ 27, 124562173 },
	{ 27, 64925695 },
	{ 29, 221817593 },
	{ 29, 256944889 },
	{ 29, 240691961 },
	{ 29, 191933177 },
	{ 29, 175680249 },
	{ 29, 248556281 },
	{ 29, 215526137 },
	{ 29, 116435705 },
	{ 29, 83405561 },
	{ 27, 64006905 },
	{ 27, 30976761 },
	{ 21, 1916266 },
	{ 21, 1949038 },
	{ 27, 64138233 },
	{ 27, 64007931 },
	{ 29, 116567033 },
	{ 29, 215657465 },
	{ 29, 248687609 },
	{ 29, 175811577 },
	{ 29, 192064505 },
	{ 29, 240823289 },
	{ 29, 265595897 },
	{ 29, 232041465 },
	{ 29, 131378169 },
	{ 27, 64924669 },
	{ 27, 64269305 },
	{ 27, 30714873 },
	{ 27, 123775993 },
	{ 27, 122203129 },
	{ 27, 122596345 },
	{ 27, 124562429 },
	{ 27, 64925439 },
	{ 29, 221817849 },
	{ 29, 256945145 },
	{ 29, 240692217 },
	{ 29, 191933433 },
	{ 29, 175680505 },
	{ 29, 248556537 },
	{ 29, 215526393 },
	{ 29, 116435961 },
	{ 29, 83405817 },
	{ 27, 64007161 },
	{ 27, 30977017 },
	{ 21, 1932650 },
	{ 21, 1932782 },
	{ 27, 64663289 },
	{ 27, 64531451 },
	{ 29, 117092089 },
	{ 29, 217231097 },
	{ 29, 249212665 },
	{ 29, 249080827 },
	{ 29, 192589561 },
	{ 29, 242396921 },
	{ 29, 257601273 },
	{ 29, 251440889 },
	{ 29, 217886457 },
	{ 29, 117223161 },
	{ 27, 64401149 },
	{ 27, 50114297 },
	{ 27, 16559865 },
	{ 27, 121679609 },
	{ 27, 65580793 },
	{ 27, 124694265 },
	{ 27, 130854653 },
	{ 27, 66497535 },
	{ 28, 129543929 },
	{ 28, 129674235 },
	{ 29, 190361337 },
	{ 29, 175156985 },
	{ 28, 125349625 },
	{ 28, 125479931 },
	{ 29, 114863865 },
	{ 29, 82882297 },
	{ 27, 49852153 },
	{ 27, 30453497 },
	{ 21, 1945578 },
	{ 21, 1916398 },
	{ 27, 64663545 },
	{ 27, 64531195 },
	{ 29, 117092345 },
	{ 29, 217231353 },
	{ 29, 249212921 },
	{ 29, 249080571 },
	{ 29, 192589817 },
	{ 29, 242397177 },
	{ 29, 257601529 },
	{ 29, 251441145 },
	{ 29, 217886713 },
	{ 29, 117223417 },
	{ 27, 64401405 },
	{ 27, 50114553 },
	{ 27, 16560121 },
	{ 27, 121679865 },
	{ 27, 65581049 },
	{ 27, 124694521 },
	{ 27, 130854909 },
	{ 27, 66497279 },
	{ 28, 129544185 },
	{ 28, 129673979 },
	{ 29, 190361593 },
	{ 29, 175157241 },
	{ 28, 125349881 },
	{ 28, 125479675 },
	{ 29, 114864121 },
	{ 29, 82882553 },
	{ 27, 49852409 },
	{ 27, 30453753 },
	{ 21, 1961962 },
	{ 21, 1048430 },
	{ 26, 16547835 },
	{ 26, 33062907 },
	{ 28, 49053691 },
	{ 28, 65568763 },
	{ 28, 108822523 },
	{ 28, 125337595 },
	{ 29, 174882811 },
	{ 29, 242924281 },
	{ 28, 121405435 },
	{ 28, 129531899 },
	{ 28, 132022271 },
	{ 28, 127893499 },
	{ 28, 127696891 },
	{ 27, 50248445 },
	{ 26, 32931839 },
	{ 26, 31948795 },
	{ 26, 65306619 },
	{ 26, 66093051 },
	{ 26, 16416763 },
	{ 26, 33193979 },
	{ 26, 33521663 },
	{ 27, 64585723 },
	{ 27, 60653563 },
	{ 28, 133857275 },
	{ 28, 124828409 },
	{ 27, 62488571 },
	{ 27, 54362107 },
	{ 28, 57245691 },
	{ 27, 49330937 },
	{ 26, 24739835 },
	{ 21, 2043754 },
	{ 21, 1032046 },
	{ 26, 16547579 },
	{ 26, 33062651 },
	{ 28, 49053435 },
	{ 28, 65568507 },
	{ 28, 108822267 },
	{ 28, 125337339 },
	{ 29, 174882555 },
	{ 29, 242924537 },
	{ 28, 121405179 },
	{ 28, 129531643 },
	{ 28, 132022015 },
	{ 28, 127893243 },
	{ 28, 127696635 },
	{ 27, 50248701 },
	{ 26, 32931583 },
	{ 26, 31948539 },
	{ 26, 65306363 },
	{ 26, 66092795 },
	{ 26, 16416507 },
	{ 26, 33193723 },
	{ 26, 33521407 },
	{ 27, 64585467 },
	{ 27, 60653307 },
	{ 28, 133857019 },
	{ 28, 124828665 },
	{ 27, 62488315 },
	{ 27, 54361851 },
	{ 28, 57245435 },
	{ 27, 49331193 },
	{ 26, 24739579 },
	{ 21, 2060138 },
	{ 21, 1015790 },
	{ 26, 15302399 },
	{ 26, 33324027 },
	{ 28, 49839099 },
	{ 28, 65829883 },
	{ 28, 115899387 },
	{ 28, 125598715 },
	{ 29, 175668219 },
	{ 29, 191659003 },
	{ 29, 259702521 },
	{ 28, 129793019 },
	{ 29, 251051773 },
	{ 28, 127826943 },
	{ 28, 115309563 },
	{ 28, 131890171 },
	{ 27, 49725181 },
	{ 26, 31882239 },
	{ 26, 28802043 },
	{ 26, 66354171 },
	{ 26, 31554555 },
	{ 26, 16677883 },
	{ 26, 33455099 },
	{ 27, 63798267 },
	{ 27, 60390395 },
	{ 27, 48069627 },
	{ 28, 123256569 },
	{ 27, 61701115 },
	{ 27, 54098939 },
	{ 27, 29195259 },
	{ 27, 47759097 },
	{ 26, 23952379 },
	{ 21, 2076138 },
	{ 21, 999406 },
	{ 26, 8223743 },
	{ 26, 33323771 },
	{ 28, 49838843 },
	{ 28, 65829627 },
	{ 28, 115899131 },
	{ 28, 125598459 },
	{ 29, 175667963 },
	{ 29, 191658747 },
	{ 29, 259702777 },
	{ 28, 129792763 },
	{ 29, 251052029 },
	{ 28, 127826687 },
	{ 28, 115309307 },
	{ 28, 131889915 },
	{ 27, 49725437 },
	{ 26, 31881983 },
	{ 26, 28801787 },
	{ 26, 66353915 },
	{ 26, 31554299 },
	{ 26, 16677627 },
	{ 26, 33454843 },
	{ 27, 63798011 },
	{ 27, 60390139 },
	{ 27, 48069371 },
	{ 28, 123256825 },
	{ 27, 61700859 },
	{ 27, 54098683 },
	{ 27, 29195003 },
	{ 27, 47759353 },
	{ 26, 23952123 },
	{ 21, 2092522 },
	{ 21, 994718 },
	{ 26, 8223487 },
	{ 26, 25000703 },
	{ 28, 50098171 },
	{ 28, 66613243 },
	{ 28, 116158459 },
	{ 28, 132673531 },
	{ 29, 175927291 },
	{ 29, 192442363 },
	{ 29, 241987579 },
	{ 29, 258502651 },
	{ 29, 222064635 },
	{ 29, 249490173 },
	{ 28, 115240959 },
	{ 28, 111112187 },
	{ 28, 245133307 },
	{ 27, 48163581 },
	{ 26, 28733439 },
	{ 26, 27750395 },
	{ 26, 27488251 },
	{ 26, 28405755 },
	{ 26, 27619323 },
	{ 27, 63533051 },
	{ 27, 59600891 },
	{ 27, 47804411 },
	{ 27, 43872251 },
	{ 27, 61435899 },
	{ 27, 53309435 },
	{ 27, 28930043 },
	{ 27, 47246073 },
	{ 26, 23687163 },
	{ 26, 7172091 },
	{ 21, 912670 },
	{ 26, 7958527 },
	{ 26, 24735743 },
	{ 28, 50097915 },
	{ 28, 66612987 },
	{ 28, 116158203 },
	{ 28, 132673275 },
	{ 29, 175927035 },
	{ 29, 192442107 },
	{ 29, 241987323 },
	{ 29, 258502395 },
	{ 29, 222064379 },
	{ 29, 249490429 },
	{ 28, 115240703 },
	{ 28, 111111931 },
	{ 28, 245133051 },
	{ 27, 48163837 },
	{ 26, 28733183 },
	{ 26, 27750139 },
	{ 26, 27487995 },
	{ 26, 28405499 },
	{ 26, 27619067 },
	{ 27, 63532795 },
	{ 27, 59600635 },
	{ 27, 47804155 },
	{ 27, 43871995 },
	{ 27, 61435643 },
	{ 27, 53309179 },
	{ 27, 28929787 },
	{ 27, 47246329 },
	{ 26, 23686907 },
	{ 26, 7171835 },
	{ 21, 896286 },
	{ 26, 7958271 },
	{ 26, 24735487 },
	{ 28, 41512703 },
	{ 28, 66874363 },
	{ 28, 116943867 },
	{ 28, 132934651 },
	{ 29, 183004155 },
	{ 29, 192703483 },
	{ 29, 242772987 },
	{ 29, 259845881 },
	{ 28, 129985531 },
	{ 28, 129723387 },
	{ 28, 128936955 },
	{ 28, 125628153 },
	{ 27, 64973819 },
	{ 27, 64711675 },
	{ 27, 47640317 },
	{ 26, 24964857 },
	{ 25, 16215035 },
	{ 25, 15952891 },
	{ 26, 32042745 },
	{ 25, 16083963 },
	{ 27, 59337723 },
	{ 27, 47016955 },
	{ 27, 62451449 },
	{ 26, 31288315 },
	{ 27, 53046267 },
	{ 27, 28142587 },
	{ 26, 24702713 },
	{ 25, 12413947 },
	{ 26, 6908923 },
	{ 20, 440222 },
	{ 26, 7171071 },
	{ 26, 23948287 },
	{ 28, 40725503 },
	{ 28, 66874107 },
	{ 28, 116943611 },
	{ 28, 132934395 },
	{ 29, 183003899 },
	{ 29, 192703227 },
	{ 29, 242772731 },
	{ 29, 259846137 },
	{ 28, 129985275 },
	{ 28, 129723131 },
	{ 28, 128936699 },
	{ 28, 125628409 },
	{ 27, 64973563 },
	{ 27, 64711419 },
	{ 27, 47640573 },
	{ 26, 24965113 },
	{ 25, 16214779 },
	{ 25, 15952635 },
	{ 26, 32043001 },
	{ 25, 16083707 },
	{ 27, 59337467 },
	{ 27, 47016699 },
	{ 27, 62451705 },
	{ 26, 31288059 },
	{ 27, 53046011 },
	{ 27, 28142331 },
	{ 26, 24702969 },
	{ 25, 12413691 },
	{ 26, 6908667 },
	{ 20, 432030 },
	{ 26, 7170815 },
	{ 26, 23948031 },
	{ 28, 40725247 },
	{ 28, 57502463 },
	{ 28, 117194747 },
	{ 28, 133709819 },
	{ 29, 183255035 },
	{ 29, 199770107 },
	{ 29, 243023867 },
	{ 29, 259980029 },
	{ 28, 129908735 },
	{ 28, 121585659 },
	{ 28, 121323515 },
	{ 28, 125762301 },
	{ 27, 64897023 },
	{ 27, 60768251 },
	{ 27, 60506107 },
	{ 26, 25099005 },
	{ 25, 16138239 },
	{ 25, 15155195 },
	{ 25, 14893051 },
	{ 25, 15810555 },
	{ 25, 15024123 },
	{ 27, 46743547 },
	{ 27, 61930233 },
	{ 26, 31014907 },
	{ 26, 27082747 },
	{ 27, 27869179 },
	{ 26, 24181497 },
	{ 25, 12140539 },
	{ 25, 4014075 },
	{ 19, 259870 },
	{ 26, 6897663 },
	{ 26, 23674879 },
	{ 28, 40452095 },
	{ 28, 57229311 },
	{ 28, 117194491 },
	{ 28, 133709563 },
	{ 29, 183254779 },
	{ 29, 199769851 },
	{ 29, 243023611 },
	{ 29, 259980285 },
	{ 28, 129908479 },
	{ 28, 121585403 },
	{ 28, 121323259 },
	{ 28, 125762557 },
	{ 27, 64896767 },
	{ 27, 60767995 },
	{ 27, 60505851 },
	{ 26, 25099261 },
	{ 25, 16137983 },
	{ 25, 15154939 },
	{ 25, 14892795 },
	{ 25, 15810299 },
	{ 25, 15023867 },
	{ 27, 46743291 },
	{ 27, 61930489 },
	{ 26, 31014651 },
	{ 26, 27082491 },
	{ 27, 27868923 },
	{ 26, 24181753 },
	{ 25, 12140283 },
	{ 25, 4013819 },
	{ 19, 251678 },
	{ 26, 6897407 },
	{ 26, 23674623 },
	{ 28, 40451839 },
	{ 28, 57229055 },
	{ 28, 107560703 },
	{ 28, 133970939 },
	{ 29, 184040443 },
	{ 29, 200031227 },
	{ 29, 250100731 },
	{ 29, 259800059 },
	{ 29, 259456765 },
	{ 28, 121519103 },
	{ 28, 96418811 },
	{ 28, 96156667 },
	{ 28, 125239037 },
	{ 27, 60701695 },
	{ 27, 48184315 },
	{ 27, 47922171 },
	{ 26, 24575741 },
	{ 25, 15088639 },
	{ 25, 12008443 },
	{ 25, 11746299 },
	{ 25, 14760955 },
	{ 25, 11877371 },
	{ 27, 60358393 },
	{ 26, 30227451 },
	{ 26, 26819579 },
	{ 26, 14498811 },
	{ 26, 22609657 },
	{ 25, 11353083 },
	{ 25, 3750907 },
	{ 19, 243102 },
	{ 25, 4013055 },
	{ 25, 12401663 },
	{ 27, 20790271 },
	{ 27, 29178879 },
	{ 27, 54344703 },
	{ 27, 62733311 },
	{ 28, 87899135 },
	{ 28, 96287743 },
	{ 28, 121453567 },
	{ 28, 129842175 },
	{ 29, 259457021 },
	{ 28, 121518847 },
	{ 28, 96418555 },
	{ 28, 96156411 },
	{ 28, 125239293 },
	{ 27, 60701439 },
	{ 27, 48184059 },
	{ 27, 47921915 },
	{ 26, 24575997 },
	{ 25, 15088383 },
	{ 25, 12008187 },
	{ 25, 11746043 },
	{ 25, 14760699 },
	{ 25, 11877115 },
	{ 27, 60358649 },
	{ 26, 30227195 },
	{ 26, 26819323 },
	{ 26, 14498555 },
	{ 26, 22609913 },
	{ 25, 11352827 },
	{ 25, 3750651 },
	{ 19, 234910 },
	{ 25, 4012799 },
	{ 25, 12401407 },
	{ 27, 20790015 },
	{ 27, 29178623 },
	{ 27, 54344447 },
	{ 27, 62733055 },
	{ 28, 87898879 },
	{ 28, 96287487 },
	{ 28, 121453311 },
	{ 28, 129841919 },
	{ 29, 175845371 },
	{ 29, 175058939 },
	{ 28, 96350207 },
	{ 28, 88027131 },
	{ 28, 87764987 },
	{ 28, 86978555 },
	{ 27, 48115711 },
	{ 27, 43986939 },
	{ 27, 43724795 },
	{ 27, 45984509 },
	{ 25, 11939839 },
	{ 25, 10956795 },
	{ 25, 10694651 },
	{ 25, 11612155 },
	{ 25, 10825723 },
	{ 26, 29962235 },
	{ 26, 26030075 },
	{ 26, 14233595 },
	{ 26, 10301435 },
	{ 25, 11087867 },
	{ 25, 2961403 },
	{ 19, 193822 },
	{ 25, 3747839 },
	{ 25, 12136447 },
	{ 27, 20525055 },
	{ 27, 28913663 },
	{ 27, 54079487 },
	{ 27, 62468095 },
	{ 28, 87633919 },
	{ 28, 96022527 },
	{ 28, 121188351 },
	{ 28, 129576959 },
	{ 29, 175845115 },
	{ 29, 175058683 },
	{ 28, 96349951 },
	{ 28, 88026875 },
	{ 28, 87764731 },
	{ 28, 86978299 },
	{ 27, 48115455 },
	{ 27, 43986683 },
	{ 27, 43724539 },
	{ 27, 45984765 },
	{ 25, 11939583 },
	{ 25, 10956539 },
	{ 25, 10694395 },
	{ 25, 11611899 },
	{ 25, 10825467 },
	{ 26, 29961979 },
	{ 26, 26029819 },
	{ 26, 14233339 },
	{ 26, 10301179 },
	{ 25, 11087611 },
	{ 25, 2961147 },
	{ 19, 185630 },
	{ 25, 3747583 },
	{ 25, 12136191 },
	{ 27, 20524799 },
	{ 27, 28913407 },
	{ 27, 54079231 },
	{ 27, 62467839 },
	{ 28, 134163451 },
	{ 28, 133901307 },
	{ 28, 133114875 },
	{ 28, 132852731 },
	{ 28, 125774843 },
	{ 28, 125512699 },
	{ 28, 124726267 },
	{ 28, 124464123 },
	{ 27, 62860283 },
	{ 27, 62598139 },
	{ 27, 61811707 },
	{ 27, 61549563 },
	{ 26, 31403003 },
	{ 26, 31140859 },
	{ 26, 30354427 },
	{ 25, 10890239 },
	{ 24, 7810043 },
	{ 24, 7547899 },
	{ 25, 10562555 },
	{ 24, 7678971 },
	{ 26, 25766907 },
	{ 26, 13446139 },
	{ 26, 24227577 },
	{ 24, 6106107 },
	{ 25, 2698235 },
	{ 18, 88990 },
	{ 25, 2960383 },
	{ 25, 11348991 },
	{ 27, 19737599 },
	{ 27, 28126207 },
	{ 27, 53292031 },
	{ 27, 61680639 },
	{ 28, 134163195 },
	{ 28, 133901051 },
	{ 28, 133114619 },
	{ 28, 132852475 },
	{ 28, 125774587 },
	{ 28, 125512443 },
	{ 28, 124726011 },
	{ 28, 124463867 },
	{ 27, 62860027 },
	{ 27, 62597883 },
	{ 27, 61811451 },
	{ 27, 61549307 },
	{ 26, 31402747 },
	{ 26, 31140603 },
	{ 26, 30354171 },
	{ 25, 10889983 },
	{ 24, 7809787 },
	{ 24, 7547643 },
	{ 25, 10562299 },
	{ 24, 7678715 },
	{ 26, 25766651 },
	{ 26, 13445883 },
	{ 26, 24227833 },
	{ 24, 6105851 },
	{ 25, 2697979 },
	{ 18, 84894 },
	{ 25, 2960127 },
	{ 25, 11348735 },
	{ 27, 19737343 },
	{ 27, 28125951 },
	{ 27, 53291775 },
	{ 27, 61680383 },
	{ 26, 33529855 },
	{ 26, 29351931 },
	{ 26, 29286395 },
	{ 26, 29089787 },
	{ 26, 29024251 },
	{ 26, 27254779 },
	{ 26, 27189243 },
	{ 26, 26992635 },
	{ 25, 15704063 },
	{ 25, 13623291 },
	{ 25, 13557755 },
	{ 25, 13361147 },
	{ 24, 7839743 },
	{ 24, 6807547 },
	{ 24, 6742011 },
	{ 24, 6545403 },
	{ 22, 1941503 },
	{ 22, 1695739 },
	{ 22, 1630203 },
	{ 22, 1859579 },
	{ 22, 1662971 },
	{ 24, 3301371 },
	{ 24, 2318331 },
	{ 22, 1466363 },
	{ 22, 483323 },
	{ 17, 64286 },
	{ 23, 679935 },
	{ 23, 2777087 },
	{ 25, 4874239 },
	{ 25, 6971391 },
	{ 25, 13262847 },
	{ 25, 15359999 },
	{ 26, 33529599 },
	{ 26, 29351675 },
	{ 26, 29286139 },
	{ 26, 29089531 },
	{ 26, 29023995 },
	{ 26, 27254523 },
	{ 26, 27188987 },
	{ 26, 26992379 },
	{ 25, 15703807 },
	{ 25, 13623035 },
	{ 25, 13557499 },
	{ 25, 13360891 },
	{ 24, 7839487 },
	{ 24, 6807291 },
	{ 24, 6741755 },
	{ 24, 6545147 },
	{ 22, 1941247 },
	{ 22, 1695483 },
	{ 22, 1629947 },
	{ 22, 1859323 },
	{ 22, 1662715 },
	{ 24, 3301115 },
	{ 24, 2318075 },
	{ 22, 1466107 },
	{ 22, 483067 },
	{ 17, 60190 },
	{ 23, 679679 },
	{ 23, 2776831 },
	{ 25, 4873983 },
	{ 25, 6971135 },
	{ 25, 13262591 },
	{ 25, 15359743 },
	{ 26, 21651199 },
	{ 26, 23748351 },
	{ 26, 16767995 },
	{ 26, 16702459 },
	{ 26, 16505851 },
	{ 26, 16440315 },
	{ 26, 14670843 },
	{ 26, 14605307 },
	{ 26, 14408699 },
	{ 25, 13605887 },
	{ 25, 7330811 },
	{ 25, 7265275 },
	{ 25, 7068667 },
	{ 24, 6790143 },
	{ 24, 3660795 },
	{ 24, 3595259 },
	{ 24, 3398651 },
	{ 22, 1678335 },
	{ 22, 908283 },
	{ 22, 842747 },
	{ 22, 1596411 },
	{ 22, 875515 },
	{ 24, 2251771 },
	{ 22, 1268731 },
	{ 22, 416763 },
	{ 17, 55710 },
	{ 22, 482303 },
	{ 22, 1530879 },
	{ 24, 2579455 },
	{ 24, 3628031 },
	{ 24, 6773759 },
	{ 24, 7822335 },
	{ 25, 10968063 },
	{ 25, 12016639 },
	{ 25, 15162367 },
	{ 25, 16210943 },
	{ 26, 16505595 },
	{ 26, 16440059 },
	{ 26, 14670587 },
	{ 26, 14605051 },
	{ 26, 14408443 },
	{ 25, 13605631 },
	{ 25, 7330555 },
	{ 25, 7265019 },
	{ 25, 7068411 },
	{ 24, 6789887 },
	{ 24, 3660539 },
	{ 24, 3595003 },
	{ 24, 3398395 },
	{ 22, 1678079 },
	{ 22, 908027 },
	{ 22, 842491 },
	{ 22, 1596155 },
	{ 22, 875259 },
	{ 24, 2251515 },
	{ 22, 1268475 },
	{ 22, 416507 },
	{ 17, 51614 },
	{ 22, 482047 },
	{ 22, 1530623 },
	{ 24, 2579199 },
	{ 24, 3627775 },
	{ 24, 6773503 },
	{ 24, 7822079 },
	{ 25, 10967807 },
	{ 25, 12016383 },
	{ 25, 15162111 },
	{ 25, 16210687 },
	{ 26, 12505083 },
	{ 26, 12308475 },
	{ 26, 12242939 },
	{ 26, 10473467 },
	{ 26, 10407931 },
	{ 26, 10211323 },
	{ 25, 7311359 },
	{ 25, 5230587 },
	{ 25, 5165051 },
	{ 25, 4968443 },
	{ 24, 3641343 },
	{ 24, 2609147 },
	{ 24, 2543611 },
	{ 24, 2347003 },
	{ 22, 888831 },
	{ 22, 643067 },
	{ 22, 577531 },
	{ 22, 806907 },
	{ 22, 610299 },
	{ 22, 1200123 },
	{ 22, 217083 },
	{ 17, 31006 },
	{ 22, 413695 },
	{ 22, 1462271 },
	{ 24, 2510847 },
	{ 24, 3559423 },
	{ 24, 6705151 },
	{ 24, 7753727 },
	{ 25, 10899455 },
	{ 25, 11948031 },
	{ 25, 15093759 },
	{ 25, 16142335 },
	{ 26, 12504827 },
	{ 26, 12308219 },
	{ 26, 12242683 },
	{ 26, 10473211 },
	{ 26, 10407675 },
	{ 26, 10211067 },
	{ 25, 7311103 },
	{ 25, 5230331 },
	{ 25, 5164795 },
	{ 25, 4968187 },
	{ 24, 3641087 },
	{ 24, 2608891 },
	{ 24, 2543355 },
	{ 24, 2346747 },
	{ 22, 888575 },
	{ 22, 642811 },
	{ 22, 577275 },
	{ 22, 806651 },
	{ 22, 610043 },
	{ 22, 1199867 },
	{ 22, 216827 },
	{ 17, 26910 },
	{ 22, 413439 },
	{ 22, 1462015 },
	{ 24, 2510591 },
	{ 24, 3559167 },
	{ 24, 6704895 },
	{ 24, 7753471 },
	{ 25, 10899199 },
	{ 25, 11947775 },
	{ 25, 15093503 },
	{ 25, 16142079 },
	{ 24, 8375291 },
	{ 24, 8309755 },
	{ 24, 8113147 },
	{ 24, 8047611 },
	{ 24, 6278139 },
	{ 24, 6212603 },
	{ 24, 6015995 },
	{ 24, 5950459 },
	{ 23, 3132411 },
	{ 23, 3066875 },
	{ 23, 2870267 },
	{ 23, 2804731 },
	{ 22, 1559547 },
	{ 22, 1494011 },
	{ 22, 1297403 },
	{ 22, 1231867 },
	{ 20, 379899 },
	{ 20, 314363 },
	{ 22, 543739 },
	{ 20, 347131 },
	{ 22, 150523 },
	{ 15, 5790 },
	{ 22, 216063 },
	{ 22, 1264639 },
	{ 24, 2313215 },
	{ 24, 3361791 },
	{ 24, 6507519 },
	{ 24, 7556095 },
	{ 25, 10701823 },
	{ 25, 11750399 },
	{ 25, 14896127 },
	{ 25, 15944703 },
	{ 24, 8375035 },
	{ 24, 8309499 },
	{ 24, 8112891 },
	{ 24, 8047355 },
	{ 24, 6277883 },
	{ 24, 6212347 },
	{ 24, 6015739 },
	{ 24, 5950203 },
	{ 23, 3132155 },
	{ 23, 3066619 },
	{ 23, 2870011 },
	{ 23, 2804475 },
	{ 22, 1559291 },
	{ 22, 1493755 },
	{ 22, 1297147 },
	{ 22, 1231611 },
	{ 20, 379643 },
	{ 20, 314107 },
	{ 22, 543483 },
	{ 20, 346875 },
	{ 22, 150267 },
	{ 15, 4766 },
	{ 22, 215807 },
	{ 22, 1264383 },
	{ 24, 2312959 },
	{ 24, 3361535 },
	{ 24, 6507263 },
	{ 24, 7555839 },
	{ 25, 10701567 },
	{ 25, 11750143 },
	{ 25, 14895871 },
	{ 25, 15944447 },
	{ 22, 2091007 },
	{ 22, 1046523 },
	{ 22, 1030139 },
	{ 22, 980987 },
	{ 22, 964603 },
	{ 22, 522235 },
	{ 22, 505851 },
	{ 22, 456699 },
	{ 21, 780287 },
	{ 21, 260091 },
	{ 21, 243707 },
	{ 21, 194555 },
	{ 20, 387071 },
	{ 20, 129019 },
	{ 20, 112635 },
	{ 20, 63483 },
	{ 18, 92159 },
	{ 18, 30715 },
	{ 18, 14331 },
	{ 14, 8059 },
	{ 13, 4027 },
	{ 13, 3614 },
	{ 20, 38911 },
	{ 20, 301055 },
	{ 22, 563199 },
	{ 22, 825343 },
	{ 22, 1611775 },
	{ 22, 1873919 },
	{ 23, 2660351 },
	{ 23, 2922495 },
	{ 23, 3708927 },
	{ 23, 3971071 },
	{ 22, 2090751 },
	{ 22, 1046267 },
	{ 22, 1029883 },
	{ 22, 980731 },
	{ 22, 964347 },
	{ 22, 521979 },
	{ 22, 505595 },
	{ 22, 456443 },
	{ 21, 780031 },
	{ 21, 259835 },
	{ 21, 243451 },
	{ 21, 194299 },
	{ 20, 386815 },
	{ 20, 128763 },
	{ 20, 112379 },
	{ 20, 63227 },
	{ 18, 91903 },
	{ 18, 30459 },
	{ 18, 14075 },
	{ 14, 6011 },
	{ 12, 1659 },
	{ 13, 2590 },
	{ 20, 38655 },
	{ 20, 300799 },
	{ 22, 562943 },
	{ 22, 825087 },
	{ 22, 1611519 },
	{ 22, 1873663 },
	{ 23, 2660095 },
	{ 23, 2922239 },
	{ 23, 3708671 },
	{ 23, 3970815 },
	{ 24, 6854399 },
	{ 22, 1041407 },
	{ 22, 1025023 },
	{ 22, 975871 },
	{ 22, 959487 },
	{ 22, 517119 },
	{ 22, 500735 },
	{ 22, 451583 },
	{ 22, 435199 },
	{ 21, 254975 },
	{ 21, 238591 },
	{ 21, 189439 },
	{ 21, 173055 },
	{ 20, 123903 },
	{ 20, 107519 },
	{ 20, 58367 },
	{ 20, 41983 },
	{ 18, 25599 },
	{ 18, 9215 },
	{ 10, 319 },
	{ 10, 363 },
	{ 10, 318 },
	{ 12, 1983 },
	{ 18, 87039 },
	{ 20, 152575 },
	{ 20, 218111 },
	{ 20, 414719 },
	{ 20, 480255 },
	{ 21, 676863 },
	{ 21, 742399 },
	{ 21, 939007 },
	{ 21, 1004543 },
	{ 22, 1725439 },
	{ 22, 1041151 },
	{ 22, 1024767 },
	{ 22, 975615 },
	{ 22, 959231 },
	{ 22, 516863 },
	{ 22, 500479 },
	{ 22, 451327 },
	{ 22, 434943 },
	{ 21, 254719 },
	{ 21, 238335 },
	{ 21, 189183 },
	{ 21, 172799 },
	{ 20, 123647 },
	{ 20, 107263 },
	{ 20, 58111 },
	{ 20, 41727 },
	{ 18, 25343 },
	{ 18, 8959 },
	{ 10, 495 },
	{ 7, 27 },
	{ 9, 190 },
	{ 11, 639 },
	{ 18, 86783 },
	{ 20, 152319 },
	{ 20, 217855 },
	{ 20, 414463 },
	{ 20, 479999 },
	{ 21, 676607 },
	{ 21, 742143 },
	{ 21, 938751 },
	{ 21, 1004287 },
	{ 22, 1725183 },
	{ 22, 1790719 },
	{ 22, 1987327 },
	{ 20, 1032703 },
	{ 20, 1016319 },
	{ 20, 967167 },
	{ 20, 950783 },
	{ 20, 508415 },
	{ 20, 492031 },
	{ 20, 442879 },
	{ 20, 426495 },
	{ 19, 246271 },
	{ 19, 229887 },
	{ 19, 180735 },
	{ 19, 164351 },
	{ 18, 115199 },
	{ 18, 98815 },
	{ 18, 49663 },
	{ 18, 33279 },
	{ 12, 2431 },
	{ 5, 23 },
	{ 5, 6 },
	{ 9, 111 },
	{ 12, 2943 },
	{ 18, 34303 },
	{ 18, 50687 },
	{ 18, 99839 },
	{ 18, 116223 },
	{ 19, 165375 },
	{ 19, 181759 },
	{ 19, 230911 },
	{ 19, 247295 },
	{ 20, 427519 },
	{ 20, 443903 },
	{ 20, 493055 },
	{ 20, 1033469 },
	{ 20, 1017085 },
	{ 20, 967933 },
	{ 20, 951549 },
	{ 20, 509181 },
	{ 20, 492797 },
	{ 20, 443645 },
	{ 20, 427261 },
	{ 19, 247037 },
	{ 19, 230653 },
	{ 19, 181501 },
	{ 19, 165117 },
	{ 18, 115965 },
	{ 18, 99581 },
	{ 18, 50429 },
	{ 18, 34045 },
	{ 12, 893 },
	{ 5, 7 },
	{ 2, 0 },
	{ 5, 5 },
	{ 12, 381 },
	{ 18, 33021 },
	{ 18, 49405 },
	{ 18, 98557 },
	{ 18, 114941 },
	{ 19, 164093 },
	{ 19, 180477 },
	{ 19, 229629 },
	{ 19, 246013 },
	{ 20, 426237 },
	{ 20, 442621 },
	{ 20, 491773 },
	{ 20, 508157 },
	{ 20, 950525 },
	{ 20, 966909 },
	{ 20, 1016061 },
	{ 20, 1032445 },
	{ 20, 493053 },
	{ 20, 443901 },
	{ 20, 427517 },
	{ 19, 247293 },
	{ 19, 230909 },
	{ 19, 181757 },
	{ 19, 165373 },
	{ 18, 116221 },
	{ 18, 99837 },
	{ 18, 50685 },
	{ 18, 34301 },
	{ 12, 2941 },
	{ 9, 109 },
	{ 5, 2 },
	{ 5, 21 },
	{ 12, 2429 },
	{ 18, 33277 },
	{ 18, 49661 },
	{ 18, 98813 },
	{ 18, 115197 },
	{ 19, 164349 },
	{ 19, 180733 },
	{ 19, 229885 },
	{ 19, 246269 },
	{ 20, 426493 },
	{ 20, 442877 },
	{ 20, 492029 },
	{ 20, 508413 },
	{ 20, 950781 },
	{ 20, 967165 },
	{ 20, 1016317 },
	{ 20, 1032701 },
	{ 22, 1987325 },
	{ 22, 1790717 },
	{ 22, 1725181 },
	{ 21, 1004285 },
	{ 21, 938749 },
	{ 21, 742141 },
	{ 21, 676605 },
	{ 20, 479997 },
	{ 20, 414461 },
	{ 20, 217853 },
	{ 20, 152317 },
	{ 18, 86781 },
	{ 11, 637 },
	{ 9, 186 },
	{ 7, 25 },
	{ 10, 493 },
	{ 18, 8957 },
	{ 18, 25341 },
	{ 20, 41725 },
	{ 20, 58109 },
	{ 20, 107261 },
	{ 20, 123645 },
	{ 21, 172797 },
	{ 21, 189181 },
	{ 21, 238333 },
	{ 21, 254717 },
	{ 22, 434941 },
	{ 22, 451325 },
	{ 22, 500477 },
	{ 22, 516861 },
	{ 22, 959229 },
	{ 22, 975613 },
	{ 22, 1024765 },
	{ 22, 1041149 },
	{ 22, 1725437 },
	{ 21, 1004541 },
	{ 21, 939005 },
	{ 21, 742397 },
	{ 21, 676861 },
	{ 20, 480253 },
	{ 20, 414717 },
	{ 20, 218109 },
	{ 20, 152573 },
	{ 18, 87037 },
	{ 12, 1981 },
	{ 10, 314 },
	{ 10, 361 },
	{ 10, 317 },
	{ 18, 9213 },
	{ 18, 25597 },
	{ 20, 41981 },
	{ 20, 58365 },
	{ 20, 107517 },
	{ 20, 123901 },
	{ 21, 173053 },
	{ 21, 189437 },
	{ 21, 238589 },
	{ 21, 254973 },
	{ 22, 435197 },
	{ 22, 451581 },
	{ 22, 500733 },
	{ 22, 517117 },
	{ 22, 959485 },
	{ 22, 975869 },
	{ 22, 1025021 },
	{ 22, 1041405 },
	{ 24, 6854397 },
	{ 23, 3970813 },
	{ 23, 3708669 },
	{ 23, 2922237 },
	{ 23, 2660093 },
	{ 22, 1873661 },
	{ 22, 1611517 },
	{ 22, 825085 },
	{ 22, 562941 },
	{ 20, 300797 },
	{ 20, 38653 },
	{ 13, 2586 },
	{ 12, 1657 },
	{ 14, 6009 },
	{ 18, 14073 },
	{ 18, 30457 },
	{ 18, 91901 },
	{ 20, 63225 },
	{ 20, 112377 },
	{ 20, 128761 },
	{ 20, 386813 },
	{ 21, 194297 },
	{ 21, 243449 },
	{ 21, 259833 },
	{ 21, 780029 },
	{ 22, 456441 },
	{ 22, 505593 },
	{ 22, 521977 },
	{ 22, 964345 },
	{ 22, 980729 },
	{ 22, 1029881 },
	{ 22, 1046265 },
	{ 22, 2090749 },
	{ 23, 3971069 },
	{ 23, 3708925 },
	{ 23, 2922493 },
	{ 23, 2660349 },
	{ 22, 1873917 },
	{ 22, 1611773 },
	{ 22, 825341 },
	{ 22, 563197 },
	{ 20, 301053 },
	{ 20, 38909 },
	{ 13, 3610 },
	{ 13, 4025 },
	{ 14, 8057 },
	{ 18, 14329 },
	{ 18, 30713 },
	{ 18, 92157 },
	{ 20, 63481 },
	{ 20, 112633 },
	{ 20, 129017 },
	{ 20, 387069 },
	{ 21, 194553 },
	{ 21, 243705 },
	{ 21, 260089 },
	{ 21, 780285 },
	{ 22, 456697 },
	{ 22, 505849 },
	{ 22, 522233 },
	{ 22, 964601 },
	{ 22, 980985 },
	{ 22, 1030137 },
	{ 22, 1046521 },
	{ 22, 2091005 },
	{ 25, 15944445 },
	{ 25, 14895869 },
	{ 25, 11750141 },
	{ 25, 10701565 },
	{ 24, 7555837 },
	{ 24, 6507261 },
	{ 24, 3361533 },
	{ 24, 2312957 },
	{ 22, 1264381 },
	{ 22, 215805 },
	{ 15, 4762 },
	{ 22, 150265 },
	{ 20, 346873 },
	{ 22, 543481 },
	{ 20, 314105 },
	{ 20, 379641 },
	{ 22, 1231609 },
	{ 22, 1297145 },
	{ 22, 1493753 },
	{ 22, 1559289 },
	{ 23, 2804473 },
	{ 23, 2870009 },
	{ 23, 3066617 },
	{ 23, 3132153 },
	{ 24, 5950201 },
	{ 24, 6015737 },
	{ 24, 6212345 },
	{ 24, 6277881 },
	{ 24, 8047353 },
	{ 24, 8112889 },
	{ 24, 8309497 },
	{ 24, 8375033 },
	{ 25, 15944701 },
	{ 25, 14896125 },
	{ 25, 11750397 },
	{ 25, 10701821 },
	{ 24, 7556093 },
	{ 24, 6507517 },
	{ 24, 3361789 },
	{ 24, 2313213 },
	{ 22, 1264637 },
	{ 22, 216061 },
	{ 15, 5786 },
	{ 22, 150521 },
	{ 20, 347129 },
	{ 22, 543737 },
	{ 20, 314361 },
	{ 20, 379897 },
	{ 22, 1231865 },
	{ 22, 1297401 },
	{ 22, 1494009 },
	{ 22, 1559545 },
	{ 23, 2804729 },
	{ 23, 2870265 },
	{ 23, 3066873 },
	{ 23, 3132409 },
	{ 24, 5950457 },
	{ 24, 6015993 },
	{ 24, 6212601 },
	{ 24, 6278137 },
	{ 24, 8047609 },
	{ 24, 8113145 },
	{ 24, 8309753 },
	{ 24, 8375289 },
	{ 25, 16142077 },
	{ 25, 15093501 },
	{ 25, 11947773 },
	{ 25, 10899197 },
	{ 24, 7753469 },
	{ 24, 6704893 },
	{ 24, 3559165 },
	{ 24, 2510589 },
	{ 22, 1462013 },
	{ 22, 413437 },
	{ 17, 26906 },
	{ 22, 216825 },
	{ 22, 1199865 },
	{ 22, 610041 },
	{ 22, 806649 },
	{ 22, 577273 },
	{ 22, 642809 },
	{ 22, 888573 },
	{ 24, 2346745 },
	{ 24, 2543353 },
	{ 24, 2608889 },
	{ 24, 3641085 },
	{ 25, 4968185 },
	{ 25, 5164793 },
	{ 25, 5230329 },
	{ 25, 7311101 },
	{ 26, 10211065 },
	{ 26, 10407673 },
	{ 26, 10473209 },
	{ 26, 12242681 },
	{ 26, 12308217 },
	{ 26, 12504825 },
	{ 25, 16142333 },
	{ 25, 15093757 },
	{ 25, 11948029 },
	{ 25, 10899453 },
	{ 24, 7753725 },
	{ 24, 6705149 },
	{ 24, 3559421 },
	{ 24, 2510845 },
	{ 22, 1462269 },
	{ 22, 413693 },
	{ 17, 31002 },
	{ 22, 217081 },
	{ 22, 1200121 },
	{ 22, 610297 },
	{ 22, 806905 },
	{ 22, 577529 },
	{ 22, 643065 },
	{ 22, 888829 },
	{ 24, 2347001 },
	{ 24, 2543609 },
	{ 24, 2609145 },
	{ 24, 3641341 },
	{ 25, 4968441 },
	{ 25, 5165049 },
	{ 25, 5230585 },
	{ 25, 7311357 },
	{ 26, 10211321 },
	{ 26, 10407929 },
	{ 26, 10473465 },
	{ 26, 12242937 },
	{ 26, 12308473 },
	{ 26, 12505081 },
	{ 25, 16210685 },
	{ 25, 15162109 },
	{ 25, 12016381 },
	{ 25, 10967805 },
	{ 24, 7822077 },
	{ 24, 6773501 },
	{ 24, 3627773 },
	{ 24, 2579197 },
	{ 22, 1530621 },
	{ 22, 482045 },
	{ 17, 51610 },
	{ 22, 416505 },
	{ 22, 1268473 },
	{ 24, 2251513 },
	{ 22, 875257 },
	{ 22, 1596153 },
	{ 22, 842489 },
	{ 22, 908025 },
	{ 22, 1678077 },
	{ 24, 3398393 },
	{ 24, 3595001 },
	{ 24, 3660537 },
	{ 24, 6789885 },
	{ 25, 7068409 },
	{ 25, 7265017 },
	{ 25, 7330553 },
	{ 25, 13605629 },
	{ 26, 14408441 },
	{ 26, 14605049 },
	{ 26, 14670585 },
	{ 26, 16440057 },
	{ 26, 16505593 },
	{ 25, 16210941 },
	{ 25, 15162365 },
	{ 25, 12016637 },
	{ 25, 10968061 },
	{ 24, 7822333 },
	{ 24, 6773757 },
	{ 24, 3628029 },
	{ 24, 2579453 },
	{ 22, 1530877 },
	{ 22, 482301 },
	{ 17, 55706 },
	{ 22, 416761 },
	{ 22, 1268729 },
	{ 24, 2251769 },
	{ 22, 875513 },
	{ 22, 1596409 },
	{ 22, 842745 },
	{ 22, 908281 },
	{ 22, 1678333 },
	{ 24, 3398649 },
	{ 24, 3595257 },
	{ 24, 3660793 },
	{ 24, 6790141 },
	{ 25, 7068665 },
	{ 25, 7265273 },
	{ 25, 7330809 },
	{ 25, 13605885 },
	{ 26, 14408697 },
	{ 26, 14605305 },
	{ 26, 14670841 },
	{ 26, 16440313 },
	{ 26, 16505849 },
	{ 26, 16702457 },
	{ 26, 16767993 },
	{ 26, 23748349 },
	{ 26, 21651197 },
	{ 25, 15359741 },
	{ 25, 13262589 },
	{ 25, 6971133 },
	{ 25, 4873981 },
	{ 23, 2776829 },
	{ 23, 679677 },
	{ 17, 60186 },
	{ 22, 483065 },
	{ 22, 1466105 },
	{ 24, 2318073 },
	{ 24, 3301113 },
	{ 22, 1662713 },
	{ 22, 1859321 },
	{ 22, 1629945 },
	{ 22, 1695481 },
	{ 22, 1941245 },
	{ 24, 6545145 },
	{ 24, 6741753 },
	{ 24, 6807289 },
	{ 24, 7839485 },
	{ 25, 13360889 },
	{ 25, 13557497 },
	{ 25, 13623033 },
	{ 25, 15703805 },
	{ 26, 26992377 },
	{ 26, 27188985 },
	{ 26, 27254521 },
	{ 26, 29023993 },
	{ 26, 29089529 },
	{ 26, 29286137 },
	{ 26, 29351673 },
	{ 26, 33529597 },
	{ 25, 15359997 },
	{ 25, 13262845 },
	{ 25, 6971389 },
	{ 25, 4874237 },
	{ 23, 2777085 },
	{ 23, 679933 },
	{ 17, 64282 },
	{ 22, 483321 },
	{ 22, 1466361 },
	{ 24, 2318329 },
	{ 24, 3301369 },
	{ 22, 1662969 },
	{ 22, 1859577 },
	{ 22, 1630201 },
	{ 22, 1695737 },
	{ 22, 1941501 },
	{ 24, 6545401 },
	{ 24, 6742009 },
	{ 24, 6807545 },
	{ 24, 7839741 },
	{ 25, 13361145 },
	{ 25, 13557753 },
	{ 25, 13623289 },
	{ 25, 15704061 },
	{ 26, 26992633 },
	{ 26, 27189241 },
	{ 26, 27254777 },
	{ 26, 29024249 },
	{ 26, 29089785 },
	{ 26, 29286393 },
	{ 26, 29351929 },
	{ 26, 33529853 },
	{ 27, 61680381 },
	{ 27, 53291773 },
	{ 27, 28125949 },
	{ 27, 19737341 },
	{ 25, 11348733 },
	{ 25, 2960125 },
	{ 18, 84890 },
	{ 25, 2697977 },
	{ 24, 6105849 },
	{ 26, 10038009 },
	{ 26, 13445881 },
	{ 26, 25766649 },
	{ 24, 7678713 },
	{ 25, 10562297 },
	{ 24, 7547641 },
	{ 24, 7809785 },
	{ 25, 10889981 },
	{ 26, 30354169 },
	{ 26, 31140601 },
	{ 26, 31402745 },
	{ 27, 61549305 },
	{ 27, 61811449 },
	{ 27, 62597881 },
	{ 27, 62860025 },
	{ 28, 124463865 },
	{ 28, 124726009 },
	{ 28, 125512441 },
	{ 28, 125774585 },
	{ 28, 132852473 },
	{ 28, 133114617 },
	{ 28, 133901049 },
	{ 28, 134163193 },
	{ 27, 61680637 },
	{ 27, 53292029 },
	{ 27, 28126205 },
	{ 27, 19737597 },
	{ 25, 11348989 },
	{ 25, 2960381 },
	{ 18, 88986 },
	{ 25, 2698233 },
	{ 24, 6106105 },
	{ 26, 10038265 },
	{ 26, 13446137 },
	{ 26, 25766905 },
	{ 24, 7678969 },
	{ 25, 10562553 },
	{ 24, 7547897 },
	{ 24, 7810041 },
	{ 25, 10890237 },
	{ 26, 30354425 },
	{ 26, 31140857 },
	{ 26, 31403001 },
	{ 27, 61549561 },
	{ 27, 61811705 },
	{ 27, 62598137 },
	{ 27, 62860281 },
	{ 28, 124464121 },
	{ 28, 124726265 },
	{ 28, 125512697 },
	{ 28, 125774841 },
	{ 28, 132852729 },
	{ 28, 133114873 },
	{ 28, 133901305 },
	{ 28, 134163449 },
	{ 27, 62467837 },
	{ 27, 54079229 },
	{ 27, 28913405 },
	{ 27, 20524797 },
	{ 25, 12136189 },
	{ 25, 3747581 },
	{ 19, 185626 },
	{ 25, 2961145 },
	{ 25, 11087609 },
	{ 26, 10301177 },
	{ 26, 14233337 },
	{ 26, 26029817 },
	{ 26, 29961977 },
	{ 25, 10825465 },
	{ 25, 11611897 },
	{ 25, 10694393 },
	{ 25, 10956537 },
	{ 25, 11939581 },
	{ 27, 42938105 },
	{ 27, 43724537 },
	{ 27, 43986681 },
	{ 27, 48115453 },
	{ 28, 86978297 },
	{ 28, 87764729 },
	{ 28, 88026873 },
	{ 28, 96349949 },
	{ 29, 175058681 },
	{ 29, 175845113 },
	{ 28, 129576957 },
	{ 28, 121188349 },
	{ 28, 96022525 },
	{ 28, 87633917 },
	{ 27, 62468093 },
	{ 27, 54079485 },
	{ 27, 28913661 },
	{ 27, 20525053 },
	{ 25, 12136445 },
	{ 25, 3747837 },
	{ 19, 193818 },
	{ 25, 2961401 },
	{ 25, 11087865 },
	{ 26, 10301433 },
	{ 26, 14233593 },
	{ 26, 26030073 },
	{ 26, 29962233 },
	{ 25, 10825721 },
	{ 25, 11612153 },
	{ 25, 10694649 },
	{ 25, 10956793 },
	{ 25, 11939837 },
	{ 27, 42938361 },
	{ 27, 43724793 },
	{ 27, 43986937 },
	{ 27, 48115709 },
	{ 28, 86978553 },
	{ 28, 87764985 },
	{ 28, 88027129 },
	{ 28, 96350205 },
	{ 29, 175058937 },
	{ 29, 175845369 },
	{ 28, 129841917 },
	{ 28, 121453309 },
	{ 28, 96287485 },
	{ 28, 87898877 },
	{ 27, 62733053 },
	{ 27, 54344445 },
	{ 27, 29178621 },
	{ 27, 20790013 },
	{ 25, 12401405 },
	{ 25, 4012797 },
	{ 19, 234906 },
	{ 25, 3750649 },
	{ 25, 11352825 },
	{ 26, 22609915 },
	{ 26, 14498553 },
	{ 26, 26819321 },
	{ 26, 30227193 },
	{ 27, 42547961 },
	{ 25, 11877113 },
	{ 25, 14760697 },
	{ 25, 11746041 },
	{ 25, 12008185 },
	{ 25, 15088381 },
	{ 26, 24575999 },
	{ 27, 47921913 },
	{ 27, 48184057 },
	{ 27, 60701437 },
	{ 28, 95369977 },
	{ 28, 96156409 },
	{ 28, 96418553 },
	{ 28, 121518845 },
	{ 29, 191838969 },
	{ 28, 129842173 },
	{ 28, 121453565 },
	{ 28, 96287741 },
	{ 28, 87899133 },
	{ 27, 62733309 },
	{ 27, 54344701 },
	{ 27, 29178877 },
	{ 27, 20790269 },
	{ 25, 12401661 },
	{ 25, 4013053 },
	{ 19, 243098 },
	{ 25, 3750905 },
	{ 25, 11353081 },
	{ 26, 22609659 },
	{ 26, 14498809 },
	{ 26, 26819577 },
	{ 26, 30227449 },
	{ 27, 42548217 },
	{ 25, 11877369 },
	{ 25, 14760953 },
	{ 25, 11746297 },
	{ 25, 12008441 },
	{ 25, 15088637 },
	{ 26, 24575743 },
	{ 27, 47922169 },
	{ 27, 48184313 },
	{ 27, 60701693 },
	{ 28, 95370233 },
	{ 28, 96156665 },
	{ 28, 96418809 },
	{ 28, 121519101 },
	{ 29, 191839225 },
	{ 29, 259800057 },
	{ 29, 250100729 },
	{ 29, 200031225 },
	{ 29, 184040441 },
	{ 28, 133970937 },
	{ 28, 107560701 },
	{ 28, 57229053 },
	{ 28, 40451837 },
	{ 26, 23674621 },
	{ 26, 6897405 },
	{ 19, 251674 },
	{ 25, 4013817 },
	{ 25, 12140281 },
	{ 26, 24181755 },
	{ 27, 27868921 },
	{ 26, 27082489 },
	{ 26, 31014649 },
	{ 27, 42811129 },
	{ 27, 46743289 },
	{ 25, 15023865 },
	{ 25, 15810297 },
	{ 25, 14892793 },
	{ 25, 15154937 },
	{ 25, 16137981 },
	{ 26, 25099263 },
	{ 27, 60505849 },
	{ 27, 60767993 },
	{ 27, 64896765 },
	{ 28, 120536825 },
	{ 28, 121323257 },
	{ 28, 121585401 },
	{ 28, 129908477 },
	{ 29, 259538681 },
	{ 29, 243023609 },
	{ 29, 199769849 },
	{ 29, 183254777 },
	{ 28, 133709561 },
	{ 28, 117194489 },
	{ 28, 57229309 },
	{ 28, 40452093 },
	{ 26, 23674877 },
	{ 26, 6897661 },
	{ 19, 259866 },
	{ 25, 4014073 },
	{ 25, 12140537 },
	{ 26, 24181499 },
	{ 27, 27869177 },
	{ 26, 27082745 },
	{ 26, 31014905 },
	{ 27, 42811385 },
	{ 27, 46743545 },
	{ 25, 15024121 },
	{ 25, 15810553 },
	{ 25, 14893049 },
	{ 25, 15155193 },
	{ 25, 16138237 },
	{ 26, 25099007 },
	{ 27, 60506105 },
	{ 27, 60768249 },
	{ 27, 64897021 },
	{ 28, 120537081 },
	{ 28, 121323513 },
	{ 28, 121585657 },
	{ 28, 129908733 },
	{ 29, 259538937 },
	{ 29, 243023865 },
	{ 29, 199770105 },
	{ 29, 183255033 },
	{ 28, 133709817 },
	{ 28, 117194745 },
	{ 28, 57502461 },
	{ 28, 40725245 },
	{ 26, 23948029 },
	{ 26, 7170813 },
	{ 20, 432026 },
	{ 26, 6908665 },
	{ 25, 12413689 },
	{ 26, 24702971 },
	{ 27, 28142329 },
	{ 27, 53046009 },
	{ 26, 31288057 },
	{ 27, 43608825 },
	{ 27, 47016697 },
	{ 27, 59337465 },
	{ 25, 16083705 },
	{ 26, 27355897 },
	{ 25, 15952633 },
	{ 25, 16214777 },
	{ 26, 27683581 },
	{ 27, 63924985 },
	{ 27, 64711417 },
	{ 27, 64973561 },
	{ 28, 128674553 },
	{ 28, 128936697 },
	{ 28, 129723129 },
	{ 28, 129985273 },
	{ 29, 258763513 },
	{ 29, 242772729 },
	{ 29, 192703225 },
	{ 29, 183003897 },
	{ 28, 132934393 },
	{ 28, 116943609 },
	{ 28, 66874105 },
	{ 28, 40725501 },
	{ 26, 23948285 },
	{ 26, 7171069 },
	{ 20, 440218 },
	{ 26, 6908921 },
	{ 25, 12413945 },
	{ 26, 24702715 },
	{ 27, 28142585 },
	{ 27, 53046265 },
	{ 26, 31288313 },
	{ 27, 43609081 },
	{ 27, 47016953 },
	{ 27, 59337721 },
	{ 25, 16083961 },
	{ 26, 27356153 },
	{ 25, 15952889 },
	{ 25, 16215033 },
	{ 26, 27683837 },
	{ 27, 63925241 },
	{ 27, 64711673 },
	{ 27, 64973817 },
	{ 28, 128674809 },
	{ 28, 128936953 },
	{ 28, 129723385 },
	{ 28, 129985529 },
	{ 29, 258763769 },
	{ 29, 242772985 },
	{ 29, 192703481 },
	{ 29, 183004153 },
	{ 28, 132934649 },
	{ 28, 116943865 },
	{ 28, 66874361 },
	{ 28, 41512701 },
	{ 26, 24735485 },
	{ 26, 7958269 },
	{ 21, 896282 },
	{ 26, 7171833 },
	{ 26, 23686905 },
	{ 27, 20803321 },
	{ 27, 28929785 },
	{ 27, 53309177 },
	{ 27, 61435641 },
	{ 27, 43871993 },
	{ 27, 47804153 },
	{ 27, 59600633 },
	{ 27, 63532793 },
	{ 26, 27619065 },
	{ 26, 28405497 },
	{ 26, 27487993 },
	{ 26, 27750137 },
	{ 26, 28733181 },
	{ 27, 48163839 },
	{ 28, 245133049 },
	{ 28, 111111929 },
	{ 28, 115240701 },
	{ 29, 230190841 },
	{ 29, 222064377 },
	{ 29, 258502393 },
	{ 29, 241987321 },
	{ 29, 192442105 },
	{ 29, 175927033 },
	{ 28, 132673273 },
	{ 28, 116158201 },
	{ 28, 66612985 },
	{ 28, 50097913 },
	{ 26, 24735741 },
	{ 26, 7958525 },
	{ 21, 912666 },
	{ 26, 7172089 },
	{ 26, 23687161 },
	{ 27, 20803577 },
	{ 27, 28930041 },
	{ 27, 53309433 },
	{ 27, 61435897 },
	{ 27, 43872249 },
	{ 27, 47804409 },
	{ 27, 59600889 },
	{ 27, 63533049 },
	{ 26, 27619321 },
	{ 26, 28405753 },
	{ 26, 27488249 },
	{ 26, 27750393 },
	{ 26, 28733437 },
	{ 27, 48163583 },
	{ 28, 245133305 },
	{ 28, 111112185 },
	{ 28, 115240957 },
	{ 29, 230191097 },
	{ 29, 222064633 },
	{ 29, 258502649 },
	{ 29, 241987577 },
	{ 29, 192442361 },
	{ 29, 175927289 },
	{ 28, 132673529 },
	{ 28, 116158457 },
	{ 28, 66613241 },
	{ 28, 50098169 },
	{ 26, 25000701 },
	{ 26, 8223485 },
	{ 21, 994714 },
	{ 21, 2092526 },
	{ 26, 23952121 },
	{ 27, 47759355 },
	{ 27, 29195001 },
	{ 27, 54098681 },
	{ 27, 61700857 },
	{ 28, 134118137 },
	{ 27, 48069369 },
	{ 27, 60390137 },
	{ 27, 63798009 },
	{ 26, 33454841 },
	{ 26, 16677625 },
	{ 26, 31554297 },
	{ 26, 66353913 },
	{ 26, 28801785 },
	{ 26, 31881981 },
	{ 27, 49725439 },
	{ 28, 131889913 },
	{ 28, 115309305 },
	{ 28, 127826685 },
	{ 29, 221805305 },
	{ 28, 129792761 },
	{ 29, 241728249 },
	{ 29, 191658745 },
	{ 29, 175667961 },
	{ 28, 125598457 },
	{ 28, 115899129 },
	{ 28, 65829625 },
	{ 28, 49838841 },
	{ 26, 33323769 },
	{ 26, 8223741 },
	{ 21, 999402 },
	{ 21, 2076142 },
	{ 26, 23952377 },
	{ 27, 47759099 },
	{ 27, 29195257 },
	{ 27, 54098937 },
	{ 27, 61701113 },
	{ 28, 134118393 },
	{ 27, 48069625 },
	{ 27, 60390393 },
	{ 27, 63798265 },
	{ 26, 33455097 },
	{ 26, 16677881 },
	{ 26, 31554553 },
	{ 26, 66354169 },
	{ 26, 28802041 },
	{ 26, 31882237 },
	{ 27, 49725183 },
	{ 28, 131890169 },
	{ 28, 115309561 },
	{ 28, 127826941 },
	{ 29, 221805561 },
	{ 28, 129793017 },
	{ 29, 241728505 },
	{ 29, 191659001 },
	{ 29, 175668217 },
	{ 28, 125598713 },
	{ 28, 115899385 },
	{ 28, 65829881 },
	{ 28, 49839097 },
	{ 26, 33324025 },
	{ 26, 15302397 },
	{ 21, 1015786 },
	{ 21, 2060142 },
	{ 26, 24739577 },
	{ 27, 49331195 },
	{ 28, 57245433 },
	{ 27, 54361849 },
	{ 27, 62488313 },
	{ 28, 86867705 },
	{ 28, 133857017 },
	{ 27, 60653305 },
	{ 27, 64585465 },
	{ 26, 33521405 },
	{ 26, 33193721 },
	{ 26, 16416505 },
	{ 26, 66092793 },
	{ 26, 65306361 },
	{ 26, 31948537 },
	{ 26, 32931581 },
	{ 27, 50248703 },
	{ 28, 127696633 },
	{ 28, 127893241 },
	{ 28, 132022013 },
	{ 28, 129531641 },
	{ 28, 121405177 },
	{ 29, 191397625 },
	{ 29, 174882553 },
	{ 28, 125337337 },
	{ 28, 108822265 },
	{ 28, 65568505 },
	{ 28, 49053433 },
	{ 26, 33062649 },
	{ 26, 16547577 },
	{ 21, 1032042 },
	{ 21, 2043758 },
	{ 26, 24739833 },
	{ 27, 49330939 },
	{ 28, 57245689 },
	{ 27, 54362105 },
	{ 27, 62488569 },
	{ 28, 86867961 },
	{ 28, 133857273 },
	{ 27, 60653561 },
	{ 27, 64585721 },
	{ 26, 33521661 },
	{ 26, 33193977 },
	{ 26, 16416761 },
	{ 26, 66093049 },
	{ 26, 65306617 },
	{ 26, 31948793 },
	{ 26, 32931837 },
	{ 27, 50248447 },
	{ 28, 127696889 },
	{ 28, 127893497 },
	{ 28, 132022269 },
	{ 28, 129531897 },
	{ 28, 121405433 },
	{ 29, 191397881 },
	{ 29, 174882809 },
	{ 28, 125337593 },
	{ 28, 108822521 },
	{ 28, 65568761 },
	{ 28, 49053689 },
	{ 26, 33062905 },
	{ 26, 16547833 },
	{ 21, 1048426 },
	{ 21, 1961966 },
	{ 27, 49982201 },
	{ 27, 49852411 },
	{ 29, 114993913 },
	{ 29, 215132921 },
	{ 28, 125479673 },
	{ 28, 125349883 },
	{ 29, 190491385 },
	{ 29, 266119929 },
	{ 28, 129673977 },
	{ 28, 129544187 },
	{ 27, 66497277 },
	{ 27, 64793337 },
	{ 27, 31238905 },
	{ 27, 130067193 },
	{ 27, 124300025 },
	{ 27, 65972985 },
	{ 27, 122465021 },
	{ 27, 64401407 },
	{ 29, 230206201 },
	{ 29, 264153849 },
	{ 29, 257469177 },
	{ 29, 242264825 },
	{ 29, 192457465 },
	{ 29, 192589819 },
	{ 29, 249080569 },
	{ 29, 217099001 },
	{ 29, 116959993 },
	{ 29, 97561337 },
	{ 27, 64531193 },
	{ 27, 32549625 },
	{ 21, 1916394 },
	{ 21, 1945582 },
	{ 27, 49982457 },
	{ 27, 49852155 },
	{ 29, 114994169 },
	{ 29, 215133177 },
	{ 28, 125479929 },
	{ 28, 125349627 },
	{ 29, 190491641 },
	{ 29, 266120185 },
	{ 28, 129674233 },
	{ 28, 129543931 },
	{ 27, 66497533 },
	{ 27, 64793593 },
	{ 27, 31239161 },
	{ 27, 130067449 },
	{ 27, 124300281 },
	{ 27, 65973241 },
	{ 27, 122465277 },
	{ 27, 64401151 },
	{ 29, 230206457 },
	{ 29, 264154105 },
	{ 29, 257469433 },
	{ 29, 242265081 },
	{ 29, 192457721 },
	{ 29, 192589563 },
	{ 29, 249080825 },
	{ 29, 217099257 },
	{ 29, 116960249 },
	{ 29, 97561593 },
	{ 27, 64531449 },
	{ 27, 32549881 },
	{ 21, 1932778 },
	{ 21, 1932654 },
	{ 27, 64139001 },
	{ 27, 64007163 },
	{ 29, 116567801 },
	{ 29, 215658233 },
	{ 29, 248688377 },
	{ 29, 175812345 },
	{ 29, 192065273 },
	{ 29, 240824057 },
	{ 29, 265596665 },
	{ 29, 232042233 },
	{ 29, 131378937 },
	{ 27, 64925437 },
	{ 27, 64270073 },
	{ 27, 30715641 },
	{ 27, 123776761 },
	{ 27, 122203897 },
	{ 27, 122597113 },
	{ 27, 124563197 },
	{ 27, 64924671 },
	{ 29, 221818617 },
	{ 29, 256945913 },
	{ 29, 240692985 },
	{ 29, 191934201 },
	{ 29, 175681273 },
	{ 29, 248557305 },
	{ 29, 215527161 },
	{ 29, 116436729 },
	{ 29, 83406585 },
	{ 27, 64007929 },
	{ 27, 30977785 },
	{ 21, 1949034 },
	{ 21, 1916270 },
	{ 27, 64139257 },
	{ 27, 64006907 },
	{ 29, 116568057 },
	{ 29, 215658489 },
	{ 29, 248688633 },
	{ 29, 175812601 },
	{ 29, 192065529 },
	{ 29, 240824313 },
	{ 29, 265596921 },
	{ 29, 232042489 },
	{ 29, 131379193 },
	{ 27, 64925693 },
	{ 27, 64270329 },
	{ 27, 30715897 },
	{ 27, 123777017 },
	{ 27, 122204153 },
	{ 27, 122597369 },
	{ 27, 124563453 },
	{ 27, 64924415 },
	{ 29, 221818873 },
	{ 29, 256946169 },
	{ 29, 240693241 },
	{ 29, 191934457 },
	{ 29, 175681529 },
	{ 29, 248557561 },
	{ 28, 133988351 },
	{ 28, 117211135 },
	{ 28, 66879487 },
	{ 27, 64008185 },
	{ 26, 33325055 },
	{ 21, 1965418 },
	{ 21, 1048046 },
	{ 26, 16285691 },
	{ 26, 32276475 },
	{ 28, 48791547 },
	{ 28, 58490875 },
	{ 28, 108560379 },
	{ 28, 124551163 },
	{ 29, 192592633 },
	{ 28, 96239611 },
	{ 28, 121143291 },
	{ 28, 128745467 },
	{ 28, 132087803 },
	{ 28, 115113979 },
	{ 27, 64404221 },
	{ 26, 61243391 },
	{ 26, 32997371 },
	{ 26, 62160891 },
	{ 26, 65044475 },
	{ 26, 15630331 },
	{ 26, 32407547 },
	{ 26, 33259519 },
	{ 28, 129547001 },
	{ 27, 64847867 },
	{ 28, 133070843 },
	{ 28, 95256571 },
	{ 28, 125352697 },
	{ 27, 62750715 },
	{ 28, 107577339 },
	{ 28, 57507835 },
	{ 27, 49855225 },
	{ 26, 25001979 },
	{ 21, 2043882 },
	{ 21, 1031662 },
	{ 26, 16285435 },
	{ 26, 32276219 },
	{ 28, 48791291 },
	{ 28, 58490619 },
	{ 28, 108560123 },
	{ 28, 124550907 },
	{ 29, 192592889 },
	{ 28, 96239355 },
	{ 28, 121143035 },
	{ 28, 128745211 },
	{ 28, 132087547 },
	{ 28, 115113723 },
	{ 27, 64404477 },
	{ 26, 61243135 },
	{ 26, 32997115 },
	{ 26, 62160635 },
	{ 26, 65044219 },
	{ 26, 15630075 },
	{ 26, 32407291 },
	{ 26, 33259263 },
	{ 28, 129547257 },
	{ 27, 64847611 },
	{ 28, 133070587 },
	{ 28, 95256315 },
	{ 28, 125352953 },
	{ 27, 62750459 },
	{ 28, 107577083 },
	{ 28, 57507579 },
	{ 27, 49855481 },
	{ 26, 25001723 },
	{ 21, 2060266 },
	{ 21, 1015662 },
	{ 26, 16546811 },
	{ 26, 33061883 },
	{ 28, 49052667 },
	{ 28, 65567739 },
	{ 28, 108821499 },
	{ 28, 125336571 },
	{ 29, 174881787 },
	{ 29, 242925305 },
	{ 28, 121404411 },
	{ 28, 129530875 },
	{ 28, 132021247 },
	{ 28, 127892475 },
	{ 28, 127695867 },
	{ 27, 50249469 },
	{ 26, 32930815 },
	{ 26, 31947771 },
	{ 26, 65305595 },
	{ 26, 66092027 },
	{ 26, 16415739 },
	{ 26, 33192955 },
	{ 26, 33520639 },
	{ 27, 64584699 },
	{ 27, 60652539 },
	{ 28, 133856251 },
	{ 28, 124829433 },
	{ 27, 62487547 },
	{ 27, 54361083 },
	{ 28, 57244667 },
	{ 27, 49331961 },
	{ 26, 24738811 },
	{ 21, 2076522 },
	{ 21, 999278 },
	{ 26, 16546555 },
	{ 26, 33061627 },
	{ 28, 49052411 },
	{ 28, 65567483 },
	{ 28, 108821243 },
	{ 28, 125336315 },
	{ 29, 174881531 },
	{ 29, 242925561 },
	{ 28, 121404155 },
	{ 28, 129530619 },
	{ 28, 132020991 },
	{ 28, 127892219 },
	{ 28, 127695611 },
	{ 27, 50249725 },
	{ 26, 32930559 },
	{ 26, 31947515 },
	{ 26, 65305339 },
	{ 26, 66091771 },
	{ 26, 16415483 },
	{ 26, 33192699 },
	{ 26, 33520383 },
	{ 27, 64584443 },
	{ 27, 60652283 },
	{ 28, 133855995 },
	{ 28, 124829689 },
	{ 27, 62487291 },
	{ 27, 54360827 },
	{ 28, 57244411 },
	{ 27, 49332217 },
	{ 26, 24738555 },
	{ 21, 2092906 },
	{ 21, 917486 },
	{ 26, 15301375 },
	{ 26, 33320955 },
	{ 28, 49836027 },
	{ 28, 65826811 },
	{ 28, 115896315 },
	{ 28, 125595643 },
	{ 29, 175665147 },
	{ 29, 191655931 },
	{ 29, 259713785 },
	{ 28, 129789947 },
	{ 29, 251063037 },
	{ 28, 127823871 },
	{ 28, 115306491 },
	{ 28, 131887099 },
	{ 27, 49736445 },
	{ 26, 31879167 },
	{ 26, 28798971 },
	{ 26, 66351099 },
	{ 26, 31551483 },
	{ 26, 16674811 },
	{ 26, 33452027 },
	{ 27, 63795195 },
	{ 27, 60387323 },
	{ 27, 48066555 },
	{ 28, 123267833 },
	{ 27, 61698043 },
	{ 27, 54095867 },
	{ 27, 29192187 },
	{ 27, 47770361 },
	{ 26, 23949307 },
	{ 26, 7958523 },
	{ 21, 901102 },
	{ 26, 8220671 },
	{ 26, 33320699 },
	{ 28, 49835771 },
	{ 28, 65826555 },
	{ 28, 115896059 },
	{ 28, 125595387 },
	{ 29, 175664891 },
	{ 29, 191655675 },
	{ 29, 259714041 },
	{ 28, 129789691 },
	{ 29, 251063293 },
	{ 28, 127823615 },
	{ 28, 115306235 },
	{ 28, 131886843 },
	{ 27, 49736701 },
	{ 26, 31878911 },
	{ 26, 28798715 },
	{ 26, 66350843 },
	{ 26, 31551227 },
	{ 26, 16674555 },
	{ 26, 33451771 },
	{ 27, 63794939 },
	{ 27, 60387067 },
	{ 27, 48066299 },
	{ 28, 123268089 },
	{ 27, 61697787 },
	{ 27, 54095611 },
	{ 27, 29191931 },
	{ 27, 47770617 },
	{ 26, 23949051 },
	{ 26, 7958267 },
	{ 21, 896414 },
	{ 26, 8220415 },
	{ 26, 24997631 },
	{ 28, 50097147 },
	{ 28, 66612219 },
	{ 28, 116157435 },
	{ 28, 132672507 },
	{ 29, 175926267 },
	{ 29, 192441339 },
	{ 29, 241986555 },
	{ 29, 258501627 },
	{ 29, 222063611 },
	{ 29, 249491197 },
	{ 28, 115239935 },
	{ 28, 111111163 },
	{ 28, 245132283 },
	{ 27, 48164605 },
	{ 26, 28732415 },
	{ 26, 27749371 },
	{ 26, 27487227 },
	{ 26, 28404731 },
	{ 26, 27618299 },
	{ 27, 63532027 },
	{ 27, 59599867 },
	{ 27, 47803387 },
	{ 27, 43871227 },
	{ 27, 61434875 },
	{ 27, 53308411 },
	{ 27, 28929019 },
	{ 27, 47247097 },
	{ 26, 23686139 },
	{ 26, 7171067 },
	{ 21, 879902 },
	{ 26, 7957503 },
	{ 26, 24734719 },
	{ 28, 50096891 },
	{ 28, 66611963 },
	{ 28, 116157179 },
	{ 28, 132672251 },
	{ 29, 175926011 },
	{ 29, 192441083 },
	{ 29, 241986299 },
	{ 29, 258501371 },
	{ 29, 222063355 },
	{ 29, 249491453 },
	{ 28, 115239679 },
	{ 28, 111110907 },
	{ 28, 245132027 },
	{ 27, 48164861 },
	{ 26, 28732159 },
	{ 26, 27749115 },
	{ 26, 27486971 },
	{ 26, 28404475 },
	{ 26, 27618043 },
	{ 27, 63531771 },
	{ 27, 59599611 },
	{ 27, 47803131 },
	{ 27, 43870971 },
	{ 27, 61434619 },
	{ 27, 53308155 },
	{ 27, 28928763 },
	{ 27, 47247353 },
	{ 26, 23685883 },
	{ 26, 7170811 },
	{ 21, 863518 },
	{ 26, 7957247 },
	{ 26, 24734463 },
	{ 28, 41511679 },
	{ 28, 66863099 },
	{ 28, 116932603 },
	{ 28, 132923387 },
	{ 29, 182992891 },
	{ 29, 192692219 },
	{ 29, 242761723 },
	{ 29, 259848953 },
	{ 28, 129974267 },
	{ 28, 129712123 },
	{ 28, 128925691 },
	{ 28, 125631225 },
	{ 27, 64962555 },
	{ 27, 64700411 },
	{ 27, 47643389 },
	{ 26, 24967929 },
	{ 25, 16203771 },
	{ 25, 15941627 },
	{ 26, 32045817 },
	{ 25, 16072699 },
	{ 27, 59326459 },
	{ 27, 47005691 },
	{ 27, 62454521 },
	{ 26, 31277051 },
	{ 27, 53035003 },
	{ 27, 28131323 },
	{ 26, 24705785 },
	{ 25, 12402683 },
	{ 26, 6897659 },
	{ 19, 259998 },
	{ 26, 7159807 },
	{ 26, 23937023 },
	{ 28, 40714239 },
	{ 28, 66862843 },
	{ 28, 116932347 },
	{ 28, 132923131 },
	{ 29, 182992635 },
	{ 29, 192691963 },
	{ 29, 242761467 },
	{ 29, 259849209 },
	{ 28, 129974011 },
	{ 28, 129711867 },
	{ 28, 128925435 },
	{ 28, 125631481 },
	{ 27, 64962299 },
	{ 27, 64700155 },
	{ 27, 47643645 },
	{ 26, 24968185 },
	{ 25, 16203515 },
	{ 25, 15941371 },
	{ 26, 32046073 },
	{ 25, 16072443 },
	{ 27, 59326203 },
	{ 27, 47005435 },
	{ 27, 62454777 },
	{ 26, 31276795 },
	{ 27, 53034747 },
	{ 27, 28131067 },
	{ 26, 24706041 },
	{ 25, 12402427 },
	{ 26, 6897403 },
	{ 19, 251806 },
	{ 26, 7159551 },
	{ 26, 23936767 },
	{ 28, 40713983 },
	{ 28, 57491199 },
	{ 28, 117193723 },
	{ 28, 133708795 },
	{ 29, 183254011 },
	{ 29, 199769083 },
	{ 29, 243022843 },
	{ 29, 259981053 },
	{ 28, 129907711 },
	{ 28, 121584635 },
	{ 28, 121322491 },
	{ 28, 125763325 },
	{ 27, 64895999 },
	{ 27, 60767227 },
	{ 27, 60505083 },
	{ 26, 25100029 },
	{ 25, 16137215 },
	{ 25, 15154171 },
	{ 25, 14892027 },
	{ 25, 15809531 },
	{ 25, 15023099 },
	{ 27, 46742523 },
	{ 27, 61931257 },
	{ 26, 31013883 },
	{ 26, 27081723 },
	{ 27, 27868155 },
	{ 26, 24182521 },
	{ 25, 12139515 },
	{ 25, 4013051 },
	{ 19, 243486 },
	{ 26, 6896639 },
	{ 26, 23673855 },
	{ 28, 40451071 },
	{ 28, 57228287 },
	{ 28, 117193467 },
	{ 28, 133708539 },
	{ 29, 183253755 },
	{ 29, 199768827 },
	{ 29, 243022587 },
	{ 29, 259981309 },
	{ 28, 129907455 },
	{ 28, 121584379 },
	{ 28, 121322235 },
	{ 28, 125763581 },
	{ 27, 64895743 },
	{ 27, 60766971 },
	{ 27, 60504827 },
	{ 26, 25100285 },
	{ 25, 16136959 },
	{ 25, 15153915 },
	{ 25, 14891771 },
	{ 25, 15809275 },
	{ 25, 15022843 },
	{ 27, 46742267 },
	{ 27, 61931513 },
	{ 26, 31013627 },
	{ 26, 27081467 },
	{ 27, 27867899 },
	{ 26, 24182777 },
	{ 25, 12139259 },
	{ 25, 4012795 },
	{ 19, 235294 },
	{ 26, 6896383 },
	{ 26, 23673599 },
	{ 28, 40450815 },
	{ 28, 57228031 },
	{ 28, 107559679 },
	{ 28, 133967867 },
	{ 29, 184037371 },
	{ 29, 200028155 },
	{ 29, 250097659 },
	{ 29, 259796987 },
	{ 29, 191836155 },
	{ 28, 121516031 },
	{ 28, 96415739 },
	{ 28, 96153595 },
	{ 28, 95367163 },
	{ 27, 60698623 },
	{ 27, 48181243 },
	{ 27, 47919099 },
	{ 27, 49130237 },
	{ 25, 15085567 },
	{ 25, 12005371 },
	{ 25, 11743227 },
	{ 25, 14757883 },
	{ 25, 11874299 },
	{ 27, 42545147 },
	{ 26, 30224379 },
	{ 26, 26816507 },
	{ 26, 14495739 },
	{ 27, 45198073 },
	{ 25, 11350011 },
	{ 25, 3747835 },
	{ 19, 193950 },
	{ 25, 4009983 },
	{ 25, 12398591 },
	{ 27, 20787199 },
	{ 27, 29175807 },
	{ 27, 54341631 },
	{ 27, 62730239 },
	{ 28, 87896063 },
	{ 28, 96284671 },
	{ 28, 121450495 },
	{ 28, 129839103 },
	{ 29, 191835899 },
	{ 28, 121515775 },
	{ 28, 96415483 },
	{ 28, 96153339 },
	{ 28, 95366907 },
	{ 27, 60698367 },
	{ 27, 48180987 },
	{ 27, 47918843 },
	{ 27, 49130493 },
	{ 25, 15085311 },
	{ 25, 12005115 },
	{ 25, 11742971 },
	{ 25, 14757627 },
	{ 25, 11874043 },
	{ 27, 42544891 },
	{ 26, 30224123 },
	{ 26, 26816251 },
	{ 26, 14495483 },
	{ 27, 45198329 },
	{ 25, 11349755 },
	{ 25, 3747579 },
	{ 19, 185758 },
	{ 25, 4009727 },
	{ 25, 12398335 },
	{ 27, 20786943 },
	{ 27, 29175551 },
	{ 27, 54341375 },
	{ 27, 62729983 },
	{ 28, 87895807 },
	{ 28, 96284415 },
	{ 28, 121450239 },
	{ 28, 129838847 },
	{ 29, 175844347 },
	{ 29, 175057915 },
	{ 28, 96349183 },
	{ 28, 88026107 },
	{ 28, 87763963 },
	{ 28, 86977531 },
	{ 27, 48114687 },
	{ 27, 43985915 },
	{ 27, 43723771 },
	{ 27, 45985533 },
	{ 25, 11938815 },
	{ 25, 10955771 },
	{ 25, 10693627 },
	{ 25, 11611131 },
	{ 25, 10824699 },
	{ 26, 29961211 },
	{ 26, 26029051 },
	{ 26, 14232571 },
	{ 26, 10300411 },
	{ 25, 11086843 },
	{ 25, 2960379 },
	{ 19, 177438 },
	{ 25, 3746815 },
	{ 25, 12135423 },
	{ 27, 20524031 },
	{ 27, 28912639 },
	{ 27, 54078463 },
	{ 27, 62467071 },
	{ 28, 87632895 },
	{ 28, 96021503 },
	{ 28, 121187327 },
	{ 28, 129575935 },
	{ 29, 175844091 },
	{ 29, 175057659 },
	{ 28, 96348927 },
	{ 28, 88025851 },
	{ 28, 87763707 },
	{ 28, 86977275 },
	{ 27, 48114431 },
	{ 27, 43985659 },
	{ 27, 43723515 },
	{ 27, 45985789 },
	{ 25, 11938559 },
	{ 25, 10955515 },
	{ 25, 10693371 },
	{ 25, 11610875 },
	{ 25, 10824443 },
	{ 26, 29960955 },
	{ 26, 26028795 },
	{ 26, 14232315 },
	{ 26, 10300155 },
	{ 25, 11086587 },
	{ 25, 2960123 },
	{ 19, 169246 },
	{ 25, 3746559 },
	{ 25, 12135167 },
	{ 27, 20523775 },
	{ 27, 28912383 },
	{ 27, 54078207 },
	{ 27, 62466815 },
	{ 26, 33546235 },
	{ 26, 33480699 },
	{ 26, 33284091 },
	{ 26, 33218555 },
	{ 26, 31449083 },
	{ 26, 31383547 },
	{ 26, 31186939 },
	{ 26, 31121403 },
	{ 25, 15720443 },
	{ 25, 15654907 },
	{ 25, 15458299 },
	{ 25, 15392763 },
	{ 24, 7856123 },
	{ 24, 7790587 },
	{ 24, 7593979 },
	{ 23, 2727935 },
	{ 22, 1957883 },
	{ 22, 1892347 },
	{ 23, 2646011 },
	{ 22, 1925115 },
	{ 24, 6447099 },
	{ 24, 3366907 },
	{ 24, 2514939 },
	{ 22, 1531899 },
	{ 23, 679931 },
	{ 17, 64414 },
	{ 23, 745471 },
	{ 23, 2842623 },
	{ 25, 4939775 },
	{ 25, 7036927 },
	{ 25, 13328383 },
	{ 25, 15425535 },
	{ 26, 33545979 },
	{ 26, 33480443 },
	{ 26, 33283835 },
	{ 26, 33218299 },
	{ 26, 31448827 },
	{ 26, 31383291 },
	{ 26, 31186683 },
	{ 26, 31121147 },
	{ 25, 15720187 },
	{ 25, 15654651 },
	{ 25, 15458043 },
	{ 25, 15392507 },
	{ 24, 7855867 },
	{ 24, 7790331 },
	{ 24, 7593723 },
	{ 23, 2727679 },
	{ 22, 1957627 },
	{ 22, 1892091 },
	{ 23, 2645755 },
	{ 22, 1924859 },
	{ 24, 6446843 },
	{ 24, 3366651 },
	{ 24, 2514683 },
	{ 22, 1531643 },
	{ 23, 679675 },
	{ 17, 60318 },
	{ 23, 745215 },
	{ 23, 2842367 },
	{ 25, 4939519 },
	{ 25, 7036671 },
	{ 25, 13328127 },
	{ 25, 15425279 },
	{ 26, 21716735 },
	{ 26, 29350907 },
	{ 26, 29285371 },
	{ 26, 29088763 },
	{ 26, 29023227 },
	{ 26, 27253755 },
	{ 26, 27188219 },
	{ 26, 26991611 },
	{ 25, 15703039 },
	{ 25, 13622267 },
	{ 25, 13556731 },
	{ 25, 13360123 },
	{ 24, 7838719 },
	{ 24, 6806523 },
	{ 24, 6740987 },
	{ 24, 6544379 },
	{ 22, 1940479 },
	{ 22, 1694715 },
	{ 22, 1629179 },
	{ 22, 1858555 },
	{ 22, 1661947 },
	{ 24, 3300347 },
	{ 24, 2317307 },
	{ 22, 1465339 },
	{ 22, 482299 },
	{ 17, 56094 },
	{ 23, 678911 },
	{ 23, 2776063 },
	{ 25, 4873215 },
	{ 25, 6970367 },
	{ 25, 13261823 },
	{ 25, 15358975 },
	{ 26, 33528575 },
	{ 26, 29350651 },
	{ 26, 29285115 },
	{ 26, 29088507 },
	{ 26, 29022971 },
	{ 26, 27253499 },
	{ 26, 27187963 },
	{ 26, 26991355 },
	{ 25, 15702783 },
	{ 25, 13622011 },
	{ 25, 13556475 },
	{ 25, 13359867 },
	{ 24, 7838463 },
	{ 24, 6806267 },
	{ 24, 6740731 },
	{ 24, 6544123 },
	{ 22, 1940223 },
	{ 22, 1694459 },
	{ 22, 1628923 },
	{ 22, 1858299 },
	{ 22, 1661691 },
	{ 24, 3300091 },
	{ 24, 2317051 },
	{ 22, 1465083 },
	{ 22, 482043 },
	{ 17, 51998 },
	{ 23, 678655 },
	{ 23, 2775807 },
	{ 25, 4872959 },
	{ 25, 6970111 },
	{ 25, 13261567 },
	{ 25, 15358719 },
	{ 26, 21650175 },
	{ 26, 23747327 },
	{ 26, 16764923 },
	{ 26, 16699387 },
	{ 26, 16502779 },
	{ 26, 16437243 },
	{ 26, 14667771 },
	{ 26, 14602235 },
	{ 26, 14405627 },
	{ 25, 13602815 },
	{ 25, 7327739 },
	{ 25, 7262203 },
	{ 25, 7065595 },
	{ 24, 6787071 },
	{ 24, 3657723 },
	{ 24, 3592187 },
	{ 24, 3395579 },
	{ 22, 1675263 },
	{ 22, 905211 },
	{ 22, 839675 },
	{ 22, 1593339 },
	{ 22, 872443 },
	{ 24, 2248699 },
	{ 22, 1265659 },
	{ 22, 413691 },
	{ 17, 31134 },
	{ 22, 479231 },
	{ 22, 1527807 },
	{ 24, 2576383 },
	{ 24, 3624959 },
	{ 24, 6770687 },
	{ 24, 7819263 },
	{ 25, 10964991 },
	{ 25, 12013567 },
	{ 25, 15159295 },
	{ 25, 16207871 },
	{ 26, 16502523 },
	{ 26, 16436987 },
	{ 26, 14667515 },
	{ 26, 14601979 },
	{ 26, 14405371 },
	{ 25, 13602559 },
	{ 25, 7327483 },
	{ 25, 7261947 },
	{ 25, 7065339 },
	{ 24, 6786815 },
	{ 24, 3657467 },
	{ 24, 3591931 },
	{ 24, 3395323 },
	{ 22, 1675007 },
	{ 22, 904955 },
	{ 22, 839419 },
	{ 22, 1593083 },
	{ 22, 872187 },
	{ 24, 2248443 },
	{ 22, 1265403 },
	{ 22, 413435 },
	{ 17, 27038 },
	{ 22, 478975 },
	{ 22, 1527551 },
	{ 24, 2576127 },
	{ 24, 3624703 },
	{ 24, 6770431 },
	{ 24, 7819007 },
	{ 25, 10964735 },
	{ 25, 12013311 },
	{ 25, 15159039 },
	{ 25, 16207615 },
	{ 26, 12504059 },
	{ 26, 12307451 },
	{ 26, 12241915 },
	{ 26, 10472443 },
	{ 26, 10406907 },
	{ 26, 10210299 },
	{ 25, 7310335 },
	{ 25, 5229563 },
	{ 25, 5164027 },
	{ 25, 4967419 },
	{ 24, 3640319 },
	{ 24, 2608123 },
	{ 24, 2542587 },
	{ 24, 2345979 },
	{ 22, 887807 },
	{ 22, 642043 },
	{ 22, 576507 },
	{ 22, 805883 },
	{ 22, 609275 },
	{ 22, 1199099 },
	{ 22, 216059 },
	{ 17, 22814 },
	{ 22, 412671 },
	{ 22, 1461247 },
	{ 24, 2509823 },
	{ 24, 3558399 },
	{ 24, 6704127 },
	{ 24, 7752703 },
	{ 25, 10898431 },
	{ 25, 11947007 },
	{ 25, 15092735 },
	{ 25, 16141311 },
	{ 26, 12503803 },
	{ 26, 12307195 },
	{ 26, 12241659 },
	{ 26, 10472187 },
	{ 26, 10406651 },
	{ 26, 10210043 },
	{ 25, 7310079 },
	{ 25, 5229307 },
	{ 25, 5163771 },
	{ 25, 4967163 },
	{ 24, 3640063 },
	{ 24, 2607867 },
	{ 24, 2542331 },
	{ 24, 2345723 },
	{ 22, 887551 },
	{ 22, 641787 },
	{ 22, 576251 },
	{ 22, 805627 },
	{ 22, 609019 },
	{ 22, 1198843 },
	{ 22, 215803 },
	{ 17, 18718 },
	{ 22, 412415 },
	{ 22, 1460991 },
	{ 24, 2509567 },
	{ 24, 3558143 },
	{ 24, 6703871 },
	{ 24, 7752447 },
	{ 25, 10898175 },
	{ 25, 11946751 },
	{ 25, 15092479 },
	{ 24, 3139583 },
	{ 22, 2095099 },
	{ 22, 2078715 },
	{ 22, 2029563 },
	{ 22, 2013179 },
	{ 22, 1570811 },
	{ 22, 1554427 },
	{ 22, 1505275 },
	{ 22, 1488891 },
	{ 21, 784379 },
	{ 21, 767995 },
	{ 21, 718843 },
	{ 21, 702459 },
	{ 20, 391163 },
	{ 20, 374779 },
	{ 20, 325627 },
	{ 20, 309243 },
	{ 18, 96251 },
	{ 18, 79867 },
	{ 20, 137211 },
	{ 18, 88059 },
	{ 20, 38907 },
	{ 13, 3742 },
	{ 20, 55295 },
	{ 20, 317439 },
	{ 22, 579583 },
	{ 22, 841727 },
	{ 22, 1628159 },
	{ 22, 1890303 },
	{ 23, 2676735 },
	{ 23, 2938879 },
	{ 23, 3725311 },
	{ 23, 3987455 },
	{ 22, 2094843 },
	{ 22, 2078459 },
	{ 22, 2029307 },
	{ 22, 2012923 },
	{ 22, 1570555 },
	{ 22, 1554171 },
	{ 22, 1505019 },
	{ 22, 1488635 },
	{ 21, 784123 },
	{ 21, 767739 },
	{ 21, 718587 },
	{ 21, 702203 },
	{ 20, 390907 },
	{ 20, 374523 },
	{ 20, 325371 },
	{ 20, 308987 },
	{ 18, 95995 },
	{ 18, 79611 },
	{ 20, 136955 },
	{ 18, 87803 },
	{ 20, 38651 },
	{ 13, 2718 },
	{ 20, 55039 },
	{ 20, 317183 },
	{ 22, 579327 },
	{ 22, 841471 },
	{ 22, 1627903 },
	{ 22, 1890047 },
	{ 23, 2676479 },
	{ 23, 2938623 },
	{ 23, 3725055 },
	{ 23, 3987199 },
	{ 22, 2089983 },
	{ 22, 1045499 },
	{ 22, 1029115 },
	{ 22, 979963 },
	{ 22, 963579 },
	{ 22, 521211 },
	{ 22, 504827 },
	{ 22, 455675 },
	{ 21, 779263 },
	{ 21, 259067 },
	{ 21, 242683 },
	{ 21, 193531 },
	{ 20, 386047 },
	{ 20, 127995 },
	{ 20, 111611 },
	{ 20, 62459 },
	{ 18, 91135 },
	{ 18, 29691 },
	{ 18, 13307 },
	{ 14, 3963 },
	{ 12, 1979 },
	{ 13, 1566 },
	{ 20, 37887 },
	{ 20, 300031 },
	{ 22, 562175 },
	{ 22, 824319 },
	{ 22, 1610751 },
	{ 22, 1872895 },
	{ 23, 2659327 },
	{ 23, 2921471 },
	{ 23, 3707903 },
	{ 23, 3970047 },
	{ 22, 2089727 },
	{ 22, 1045243 },
	{ 22, 1028859 },
	{ 22, 979707 },
	{ 22, 963323 },
	{ 22, 520955 },
	{ 22, 504571 },
	{ 22, 455419 },
	{ 21, 779007 },
	{ 21, 258811 },
	{ 21, 242427 },
	{ 21, 193275 },
	{ 20, 385791 },
	{ 20, 127739 },
	{ 20, 111355 },
	{ 20, 62203 },
	{ 18, 90879 },
	{ 18, 29435 },
	{ 18, 13051 },
	{ 14, 1915 },
	{ 11, 635 },
	{ 13, 542 },
	{ 20, 37631 },
	{ 20, 299775 },
	{ 22, 561919 },
	{ 22, 824063 },
	{ 22, 1610495 },
	{ 22, 1872639 },
	{ 23, 2659071 },
	{ 23, 2921215 },
	{ 23, 3707647 },
	{ 23, 3969791 },
	{ 24, 6853375 },
	{ 20, 260607 },
	{ 20, 256511 },
	{ 20, 244223 },
	{ 20, 240127 },
	{ 20, 129535 },
	{ 20, 125439 },
	{ 20, 113151 },
	{ 20, 109055 },
	{ 19, 63999 },
	{ 19, 59903 },
	{ 19, 47615 },
	{ 19, 43519 },
	{ 18, 31231 },
	{ 18, 27135 },
	{ 18, 14847 },
	{ 18, 10751 },
	{ 16, 6655 },
	{ 16, 2559 },
	{ 9, 63 },
	{ 9, 107 },
	{ 9, 62 },
	{ 11, 959 },
	{ 16, 22015 },
	{ 18, 38399 },
	{ 18, 54783 },
	{ 18, 103935 },
	{ 18, 120319 },
	{ 19, 169471 },
	{ 19, 185855 },
	{ 19, 235007 },
	{ 19, 251391 },
	{ 20, 431615 },
	{ 20, 1035517 },
	{ 20, 1019133 },
	{ 20, 969981 },
	{ 20, 953597 },
	{ 20, 511229 },
	{ 20, 494845 },
	{ 20, 445693 },
	{ 20, 429309 },
	{ 19, 249085 },
	{ 19, 232701 },
	{ 19, 183549 },
	{ 19, 167165 },
	{ 18, 118013 },
	{ 18, 101629 },
	{ 18, 52477 },
	{ 18, 36093 },
	{ 16, 19709 },
	{ 16, 3325 },
	{ 9, 233 },
	{ 5, 1 },
	{ 7, 42 },
	{ 10, 127 },
	{ 16, 20733 },
	{ 18, 37117 },
	{ 18, 53501 },
	{ 18, 102653 },
	{ 18, 119037 },
	{ 19, 168189 },
	{ 19, 184573 },
	{ 19, 233725 },
	{ 19, 250109 },
	{ 20, 430333 },
	{ 20, 446717 },
	{ 20, 495869 },
	{ 20, 512253 },
	{ 20, 954621 },
	{ 20, 971005 },
	{ 20, 1020157 },
	{ 20, 1036541 },
	{ 20, 429565 },
	{ 19, 249341 },
	{ 19, 232957 },
	{ 19, 183805 },
	{ 19, 167421 },
	{ 18, 118269 },
	{ 18, 101885 },
	{ 18, 52733 },
	{ 18, 36349 },
	{ 16, 19965 },
	{ 16, 3581 },
	{ 9, 57 },
	{ 5, 17 },
	{ 6, 50 },
	{ 10, 189 },
	{ 16, 20989 },
	{ 18, 37373 },
	{ 18, 53757 },
	{ 18, 102909 },
	{ 18, 119293 },
	{ 19, 168445 },
	{ 19, 184829 },
	{ 19, 233981 },
	{ 19, 250365 },
	{ 20, 430589 },
	{ 20, 446973 },
	{ 20, 496125 },
	{ 20, 512509 },
	{ 20, 954877 },
	{ 20, 971261 },
	{ 20, 1020413 },
	{ 20, 1036797 },
	{ 22, 1970941 },
	{ 22, 1774333 },
	{ 22, 1708797 },
	{ 21, 987901 },
	{ 21, 922365 },
	{ 21, 725757 },
	{ 21, 660221 },
	{ 20, 463613 },
	{ 20, 398077 },
	{ 20, 201469 },
	{ 20, 135933 },
	{ 14, 1917 },
	{ 7, 29 },
	{ 6, 18 },
	{ 8, 45 },
	{ 14, 1405 },
	{ 20, 131837 },
	{ 20, 197373 },
	{ 20, 393981 },
	{ 20, 459517 },
	{ 21, 656125 },
	{ 21, 721661 },
	{ 21, 918269 },
	{ 21, 983805 },
	{ 22, 1704701 },
	{ 22, 1770237 },
	{ 22, 1966845 },
	{ 22, 2032381 },
	{ 22, 3801853 },
	{ 22, 3867389 },
	{ 22, 4063997 },
	{ 22, 4129533 },
	{ 22, 1971197 },
	{ 22, 1774589 },
	{ 22, 1709053 },
	{ 21, 988157 },
	{ 21, 922621 },
	{ 21, 726013 },
	{ 21, 660477 },
	{ 20, 463869 },
	{ 20, 398333 },
	{ 20, 201725 },
	{ 20, 136189 },
	{ 14, 3965 },
	{ 10, 365 },
	{ 8, 10 },
	{ 7, 13 },
	{ 14, 3453 },
	{ 20, 132093 },
	{ 20, 197629 },
	{ 20, 394237 },
	{ 20, 459773 },
	{ 21, 656381 },
	{ 21, 721917 },
	{ 21, 918525 },
	{ 21, 984061 },
	{ 22, 1704957 },
	{ 22, 1770493 },
	{ 22, 1967101 },
	{ 22, 4151037 },
	{ 22, 4085501 },
	{ 22, 3888893 },
	{ 22, 3823357 },
	{ 22, 2053885 },
	{ 22, 1988349 },
	{ 22, 1791741 },
	{ 22, 1726205 },
	{ 21, 1005309 },
	{ 21, 939773 },
	{ 21, 743165 },
	{ 21, 677629 },
	{ 20, 481021 },
	{ 20, 415485 },
	{ 20, 218877 },
	{ 20, 153341 },
	{ 18, 87805 },
	{ 12, 1661 },
	{ 8, 74 },
	{ 8, 89 },
	{ 11, 1005 },
	{ 18, 9981 },
	{ 18, 26365 },
	{ 20, 42749 },
	{ 20, 59133 },
	{ 20, 108285 },
	{ 20, 124669 },
	{ 21, 173821 },
	{ 21, 190205 },
	{ 21, 239357 },
	{ 21, 255741 },
	{ 22, 435965 },
	{ 22, 452349 },
	{ 22, 501501 },
	{ 22, 517885 },
	{ 22, 960253 },
	{ 22, 976637 },
	{ 22, 1025789 },
	{ 22, 1042173 },
	{ 22, 1726461 },
	{ 21, 1005565 },
	{ 21, 940029 },
	{ 21, 743421 },
	{ 21, 677885 },
	{ 20, 481277 },
	{ 20, 415741 },
	{ 20, 219133 },
	{ 20, 153597 },
	{ 18, 88061 },
	{ 13, 4029 },
	{ 11, 826 },
	{ 11, 873 },
	{ 11, 829 },
	{ 18, 10237 },
	{ 18, 26621 },
	{ 20, 43005 },
	{ 20, 59389 },
	{ 20, 108541 },
	{ 20, 124925 },
	{ 21, 174077 },
	{ 21, 190461 },
	{ 21, 239613 },
	{ 21, 255997 },
	{ 22, 436221 },
	{ 22, 452605 },
	{ 22, 501757 },
	{ 22, 518141 },
	{ 22, 960509 },
	{ 22, 976893 },
	{ 22, 1026045 },
	{ 22, 1042429 },
	{ 26, 27413245 },
	{ 25, 15878909 },
	{ 25, 14830333 },
	{ 25, 11684605 },
	{ 25, 10636029 },
	{ 24, 7490301 },
	{ 24, 6441725 },
	{ 24, 3295997 },
	{ 24, 2247421 },
	{ 22, 1198845 },
	{ 22, 150269 },
	{ 15, 4634 },
	{ 13, 3705 },
	{ 16, 10105 },
	{ 20, 51961 },
	{ 20, 117497 },
	{ 20, 363261 },
	{ 22, 248569 },
	{ 22, 445177 },
	{ 22, 510713 },
	{ 22, 1542909 },
	{ 23, 772857 },
	{ 23, 969465 },
	{ 23, 1035001 },
	{ 23, 3115773 },
	{ 24, 1821433 },
	{ 24, 2018041 },
	{ 24, 2083577 },
	{ 24, 3853049 },
	{ 24, 3918585 },
	{ 24, 4115193 },
	{ 24, 4180729 },
	{ 24, 8358653 },
	{ 25, 15879165 },
	{ 25, 14830589 },
	{ 25, 11684861 },
	{ 25, 10636285 },
	{ 24, 7490557 },
	{ 24, 6441981 },
	{ 24, 3296253 },
	{ 24, 2247677 },
	{ 22, 1199101 },
	{ 22, 150525 },
	{ 15, 5658 },
	{ 14, 8121 },
	{ 16, 12153 },
	{ 20, 52217 },
	{ 20, 117753 },
	{ 20, 363517 },
	{ 22, 248825 },
	{ 22, 445433 },
	{ 22, 510969 },
	{ 22, 1543165 },
	{ 23, 773113 },
	{ 23, 969721 },
	{ 23, 1035257 },
	{ 23, 3116029 },
	{ 24, 1821689 },
	{ 24, 2018297 },
	{ 24, 2083833 },
	{ 24, 3853305 },
	{ 24, 3918841 },
	{ 24, 4115449 },
	{ 24, 4180985 },
	{ 24, 8358909 },
	{ 25, 15945469 },
	{ 25, 14896893 },
	{ 25, 11751165 },
	{ 25, 10702589 },
	{ 24, 7556861 },
	{ 24, 6508285 },
	{ 24, 3362557 },
	{ 24, 2313981 },
	{ 22, 1265405 },
	{ 22, 216829 },
	{ 15, 6810 },
	{ 22, 151289 },
	{ 20, 347897 },
	{ 22, 544505 },
	{ 20, 315129 },
	{ 20, 380665 },
	{ 22, 1232633 },
	{ 22, 1298169 },
	{ 22, 1494777 },
	{ 22, 1560313 },
	{ 23, 2805497 },
	{ 23, 2871033 },
	{ 23, 3067641 },
	{ 23, 3133177 },
	{ 24, 5951225 },
	{ 24, 6016761 },
	{ 24, 6213369 },
	{ 24, 6278905 },
	{ 24, 8048377 },
	{ 24, 8113913 },
	{ 24, 8310521 },
	{ 24, 8376057 },
	{ 25, 15945725 },
	{ 25, 14897149 },
	{ 25, 11751421 },
	{ 25, 10702845 },
	{ 24, 7557117 },
	{ 24, 6508541 },
	{ 24, 3362813 },
	{ 24, 2314237 },
	{ 22, 1265661 },
	{ 22, 217085 },
	{ 15, 7834 },
	{ 22, 151545 },
	{ 20, 348153 },
	{ 22, 544761 },
	{ 20, 315385 },
	{ 20, 380921 },
	{ 22, 1232889 },
	{ 22, 1298425 },
	{ 22, 1495033 },
	{ 22, 1560569 },
	{ 23, 2805753 },
	{ 23, 2871289 },
	{ 23, 3067897 },
	{ 23, 3133433 },
	{ 24, 5951481 },
	{ 24, 6017017 },
	{ 24, 6213625 },
	{ 24, 6279161 },
	{ 24, 8048633 },
	{ 24, 8114169 },
	{ 24, 8310777 },
	{ 24, 8376313 },
	{ 25, 16145149 },
	{ 25, 15096573 },
	{ 25, 11950845 },
	{ 25, 10902269 },
	{ 24, 7756541 },
	{ 24, 6707965 },
	{ 24, 3562237 },
	{ 24, 2513661 },
	{ 22, 1465085 },
	{ 22, 416509 },
	{ 17, 51482 },
	{ 22, 219897 },
	{ 22, 1202937 },
	{ 22, 613113 },
	{ 22, 809721 },
	{ 22, 580345 },
	{ 22, 645881 },
	{ 22, 891645 },
	{ 24, 2349817 },
	{ 24, 2546425 },
	{ 24, 2611961 },
	{ 24, 3644157 },
	{ 25, 4971257 },
	{ 25, 5167865 },
	{ 25, 5233401 },
	{ 25, 7314173 },
	{ 26, 10214137 },
	{ 26, 10410745 },
	{ 26, 10476281 },
	{ 26, 12245753 },
	{ 26, 12311289 },
	{ 26, 12507897 },
	{ 25, 16145405 },
	{ 25, 15096829 },
	{ 25, 11951101 },
	{ 25, 10902525 },
	{ 24, 7756797 },
	{ 24, 6708221 },
	{ 24, 3562493 },
	{ 24, 2513917 },
	{ 22, 1465341 },
	{ 22, 416765 },
	{ 17, 55578 },
	{ 22, 220153 },
	{ 22, 1203193 },
	{ 22, 613369 },
	{ 22, 809977 },
	{ 22, 580601 },
	{ 22, 646137 },
	{ 22, 891901 },
	{ 24, 2350073 },
	{ 24, 2546681 },
	{ 24, 2612217 },
	{ 24, 3644413 },
	{ 25, 4971513 },
	{ 25, 5168121 },
	{ 25, 5233657 },
	{ 25, 7314429 },
	{ 26, 10214393 },
	{ 26, 10411001 },
	{ 26, 10476537 },
	{ 26, 12246009 },
	{ 26, 12311545 },
	{ 26, 12508153 },
	{ 25, 16211709 },
	{ 25, 15163133 },
	{ 25, 12017405 },
	{ 25, 10968829 },
	{ 24, 7823101 },
	{ 24, 6774525 },
	{ 24, 3628797 },
	{ 24, 2580221 },
	{ 22, 1531645 },
	{ 22, 483069 },
	{ 17, 59802 },
	{ 22, 417529 },
	{ 22, 1269497 },
	{ 24, 2252537 },
	{ 22, 876281 },
	{ 22, 1597177 },
	{ 22, 843513 },
	{ 22, 909049 },
	{ 22, 1679101 },
	{ 24, 3399417 },
	{ 24, 3596025 },
	{ 24, 3661561 },
	{ 24, 6790909 },
	{ 25, 7069433 },
	{ 25, 7266041 },
	{ 25, 7331577 },
	{ 25, 13606653 },
	{ 26, 14409465 },
	{ 26, 14606073 },
	{ 26, 14671609 },
	{ 26, 16441081 },
	{ 26, 16506617 },
	{ 25, 16211965 },
	{ 25, 15163389 },
	{ 25, 12017661 },
	{ 25, 10969085 },
	{ 24, 7823357 },
	{ 24, 6774781 },
	{ 24, 3629053 },
	{ 24, 2580477 },
	{ 22, 1531901 },
	{ 22, 483325 },
	{ 17, 63898 },
	{ 22, 417785 },
	{ 22, 1269753 },
	{ 24, 2252793 },
	{ 22, 876537 },
	{ 22, 1597433 },
	{ 22, 843769 },
	{ 22, 909305 },
	{ 22, 1679357 },
	{ 24, 3399673 },
	{ 24, 3596281 },
	{ 24, 3661817 },
	{ 24, 6791165 },
	{ 25, 7069689 },
	{ 25, 7266297 },
	{ 25, 7331833 },
	{ 25, 13606909 },
	{ 26, 14409721 },
	{ 26, 14606329 },
	{ 26, 14671865 },
	{ 26, 16441337 },
	{ 26, 16506873 },
	{ 26, 16703481 },
	{ 26, 16769017 },
	{ 26, 29335549 },
	{ 28, 86584061 },
	{ 27, 61418237 },
	{ 27, 53029629 },
	{ 27, 27863805 },
	{ 27, 19475197 },
	{ 25, 11086589 },
	{ 25, 2697981 },
	{ 18, 84762 },
	{ 24, 1911545 },
	{ 24, 5843705 },
	{ 26, 9251577 },
	{ 26, 13183737 },
	{ 24, 6630137 },
	{ 24, 7416569 },
	{ 24, 6499065 },
	{ 24, 6761209 },
	{ 24, 7744253 },
	{ 26, 26159865 },
	{ 26, 26946297 },
	{ 26, 27208441 },
	{ 26, 31337213 },
	{ 27, 53422841 },
	{ 27, 54209273 },
	{ 27, 54471417 },
	{ 27, 62794493 },
	{ 28, 107948793 },
	{ 28, 108735225 },
	{ 28, 108997369 },
	{ 28, 116075257 },
	{ 28, 116337401 },
	{ 28, 117123833 },
	{ 28, 117385977 },
	{ 28, 134097661 },
	{ 27, 61418493 },
	{ 27, 53029885 },
	{ 27, 27864061 },
	{ 27, 19475453 },
	{ 25, 11086845 },
	{ 25, 2698237 },
	{ 18, 88858 },
	{ 24, 1911801 },
	{ 24, 5843961 },
	{ 26, 9251833 },
	{ 26, 13183993 },
	{ 24, 6630393 },
	{ 24, 7416825 },
	{ 24, 6499321 },
	{ 24, 6761465 },
	{ 24, 7744509 },
	{ 26, 26160121 },
	{ 26, 26946553 },
	{ 26, 27208697 },
	{ 26, 31337469 },
	{ 27, 53423097 },
	{ 27, 54209529 },
	{ 27, 54471673 },
	{ 27, 62794749 },
	{ 28, 107949049 },
	{ 28, 108735481 },
	{ 28, 108997625 },
	{ 28, 116075513 },
	{ 28, 116337657 },
	{ 28, 117124089 },
	{ 28, 117386233 },
	{ 28, 86847229 },
	{ 27, 61681405 },
	{ 27, 53292797 },
	{ 27, 28126973 },
	{ 27, 19738365 },
	{ 25, 11349757 },
	{ 25, 2961149 },
	{ 18, 93082 },
	{ 25, 2699001 },
	{ 24, 6106873 },
	{ 26, 10039033 },
	{ 26, 13446905 },
	{ 26, 25767673 },
	{ 24, 7679737 },
	{ 25, 10563321 },
	{ 24, 7548665 },
	{ 24, 7810809 },
	{ 25, 10891005 },
	{ 26, 30355193 },
	{ 26, 31141625 },
	{ 26, 31403769 },
	{ 27, 61550329 },
	{ 27, 61812473 },
	{ 27, 62598905 },
	{ 27, 62861049 },
	{ 28, 124464889 },
	{ 28, 124727033 },
	{ 28, 125513465 },
	{ 28, 125775609 },
	{ 28, 132853497 },
	{ 28, 133115641 },
	{ 28, 133902073 },
	{ 28, 134164217 },
	{ 27, 61681661 },
	{ 27, 53293053 },
	{ 27, 28127229 },
	{ 27, 19738621 },
	{ 25, 11350013 },
	{ 25, 2961405 },
	{ 18, 97178 },
	{ 25, 2699257 },
	{ 24, 6107129 },
	{ 26, 10039289 },
	{ 26, 13447161 },
	{ 26, 25767929 },
	{ 24, 7679993 },
	{ 25, 10563577 },
	{ 24, 7548921 },
	{ 24, 7811065 },
	{ 25, 10891261 },
	{ 26, 30355449 },
	{ 26, 31141881 },
	{ 26, 31404025 },
	{ 27, 61550585 },
	{ 27, 61812729 },
	{ 27, 62599161 },
	{ 27, 62861305 },
	{ 28, 124465145 },
	{ 28, 124727289 },
	{ 28, 125513721 },
	{ 28, 125775865 },
	{ 28, 132853753 },
	{ 28, 133115897 },
	{ 28, 133902329 },
	{ 28, 134164473 },
	{ 27, 62470909 },
	{ 27, 54082301 },
	{ 27, 28916477 },
	{ 27, 20527869 },
	{ 25, 12139261 },
	{ 25, 3750653 },
	{ 19, 234778 },
	{ 25, 2964217 },
	{ 25, 11090681 },
	{ 26, 10304249 },
	{ 26, 14236409 },
	{ 26, 26032889 },
	{ 26, 29965049 },
	{ 25, 10828537 },
	{ 25, 11614969 },
	{ 25, 10697465 },
	{ 25, 10959609 },
	{ 25, 11942653 },
	{ 26, 23003135 },
	{ 27, 43727609 },
	{ 27, 43989753 },
	{ 27, 48118525 },
	{ 28, 86981369 },
	{ 28, 87767801 },
	{ 28, 88029945 },
	{ 28, 96353021 },
	{ 29, 175061753 },
	{ 29, 175848185 },
	{ 28, 129580029 },
	{ 28, 121191421 },
	{ 28, 96025597 },
	{ 28, 87636989 },
	{ 27, 62471165 },
	{ 27, 54082557 },
	{ 27, 28916733 },
	{ 27, 20528125 },
	{ 25, 12139517 },
	{ 25, 3750909 },
	{ 19, 242970 },
	{ 25, 2964473 },
	{ 25, 11090937 },
	{ 26, 10304505 },
	{ 26, 14236665 },
	{ 26, 26033145 },
	{ 26, 29965305 },
	{ 25, 10828793 },
	{ 25, 11615225 },
	{ 25, 10697721 },
	{ 25, 10959865 },
	{ 25, 11942909 },
	{ 26, 23002879 },
	{ 27, 43727865 },
	{ 27, 43990009 },
	{ 27, 48118781 },
	{ 28, 86981625 },
	{ 28, 87768057 },
	{ 28, 88030201 },
	{ 28, 96353277 },
	{ 29, 175062009 },
	{ 29, 175848441 },
	{ 28, 129842941 },
	{ 28, 121454333 },
	{ 28, 96288509 },
	{ 28, 87899901 },
	{ 27, 62734077 },
	{ 27, 54345469 },
	{ 27, 29179645 },
	{ 27, 20791037 },
	{ 25, 12402429 },
	{ 25, 4013821 },
	{ 19, 251290 },
	{ 25, 3751673 },
	{ 25, 11353849 },
	{ 26, 22608891 },
	{ 26, 14499577 },
	{ 26, 26820345 },
	{ 26, 30228217 },
	{ 27, 42548985 },
	{ 25, 11878137 },
	{ 25, 14761721 },
	{ 25, 11747065 },
	{ 25, 12009209 },
	{ 25, 15089405 },
	{ 26, 24574975 },
	{ 27, 47922937 },
	{ 27, 48185081 },
	{ 27, 60702461 },
	{ 28, 95371001 },
	{ 28, 96157433 },
	{ 28, 96419577 },
	{ 28, 121519869 },
	{ 29, 191839993 },
	{ 28, 129843197 },
	{ 28, 121454589 },
	{ 28, 96288765 },
	{ 28, 87900157 },
	{ 27, 62734333 },
	{ 27, 54345725 },
	{ 27, 29179901 },
	{ 27, 20791293 },
	{ 25, 12402685 },
	{ 25, 4014077 },
	{ 19, 259482 },
	{ 25, 3751929 },
	{ 25, 11354105 },
	{ 26, 22608635 },
	{ 26, 14499833 },
	{ 26, 26820601 },
	{ 26, 30228473 },
	{ 27, 42549241 },
	{ 25, 11878393 },
	{ 25, 14761977 },
	{ 25, 11747321 },
	{ 25, 12009465 },
	{ 25, 15089661 },
	{ 26, 24574719 },
	{ 27, 47923193 },
	{ 27, 48185337 },
	{ 27, 60702717 },
	{ 28, 95371257 },
	{ 28, 96157689 },
	{ 28, 96419833 },
	{ 28, 121520125 },
	{ 29, 191840249 },
	{ 29, 259801081 },
	{ 29, 250101753 },
	{ 29, 200032249 },
	{ 29, 184041465 },
	{ 28, 133971961 },
	{ 28, 107571965 },
	{ 28, 57240317 },
	{ 28, 40463101 },
	{ 26, 23685885 },
	{ 26, 6908669 },
	{ 20, 431898 },
	{ 25, 4025081 },
	{ 25, 12151545 },
	{ 26, 24178683 },
	{ 27, 27880185 },
	{ 26, 27093753 },
	{ 26, 31025913 },
	{ 27, 42822393 },
	{ 27, 46754553 },
	{ 25, 15035129 },
	{ 25, 15821561 },
	{ 25, 14904057 },
	{ 25, 15166201 },
	{ 25, 16149245 },
	{ 26, 25096191 },
	{ 27, 60517113 },
	{ 27, 60779257 },
	{ 27, 64908029 },
	{ 28, 120548089 },
	{ 28, 121334521 },
	{ 28, 121596665 },
	{ 28, 129919741 },
	{ 29, 259549945 },
	{ 29, 243034873 },
	{ 29, 199781113 },
	{ 29, 183266041 },
	{ 28, 133720825 },
	{ 28, 117205753 },
	{ 28, 57240573 },
	{ 28, 40463357 },
	{ 26, 23686141 },
	{ 26, 6908925 },
	{ 20, 440090 },
	{ 25, 4025337 },
	{ 25, 12151801 },
	{ 26, 24178427 },
	{ 27, 27880441 },
	{ 26, 27094009 },
	{ 26, 31026169 },
	{ 27, 42822649 },
	{ 27, 46754809 },
	{ 25, 15035385 },
	{ 25, 15821817 },
	{ 25, 14904313 },
	{ 25, 15166457 },
	{ 25, 16149501 },
	{ 26, 25095935 },
	{ 27, 60517369 },
	{ 27, 60779513 },
	{ 27, 64908285 },
	{ 28, 120548345 },
	{ 28, 121334777 },
	{ 28, 121596921 },
	{ 28, 129919997 },
	{ 29, 259550201 },
	{ 29, 243035129 },
	{ 29, 199781369 },
	{ 29, 183266297 },
	{ 28, 133721081 },
	{ 28, 117206009 },
	{ 28, 57503485 },
	{ 28, 40726269 },
	{ 26, 23949053 },
	{ 26, 7171837 },
	{ 20, 448410 },
	{ 26, 6909689 },
	{ 25, 12414713 },
	{ 26, 24701947 },
	{ 27, 28143353 },
	{ 27, 53047033 },
	{ 26, 31289081 },
	{ 27, 43609849 },
	{ 27, 47017721 },
	{ 27, 59338489 },
	{ 25, 16084729 },
	{ 26, 27356921 },
	{ 25, 15953657 },
	{ 25, 16215801 },
	{ 26, 27684605 },
	{ 27, 63926009 },
	{ 27, 64712441 },
	{ 27, 64974585 },
	{ 28, 128675577 },
	{ 28, 128937721 },
	{ 28, 129724153 },
	{ 28, 129986297 },
	{ 29, 258764537 },
	{ 29, 242773753 },
	{ 29, 192704249 },
	{ 29, 183004921 },
	{ 28, 132935417 },
	{ 28, 116944633 },
	{ 28, 66875129 },
	{ 28, 40726525 },
	{ 26, 23949309 },
	{ 26, 7172093 },
	{ 20, 456602 },
	{ 26, 6909945 },
	{ 25, 12414969 },
	{ 26, 24701691 },
	{ 27, 28143609 },
	{ 27, 53047289 },
	{ 26, 31289337 },
	{ 27, 43610105 },
	{ 27, 47017977 },
	{ 27, 59338745 },
	{ 25, 16084985 },
	{ 26, 27357177 },
	{ 25, 15953913 },
	{ 25, 16216057 },
	{ 26, 27684861 },
	{ 27, 63926265 },
	{ 27, 64712697 },
	{ 27, 64974841 },
	{ 28, 128675833 },
	{ 28, 128937977 },
	{ 28, 129724409 },
	{ 28, 129986553 },
	{ 29, 258764793 },
	{ 29, 242774009 },
	{ 29, 192704505 },
	{ 29, 183005177 },
	{ 28, 132935673 },
	{ 28, 116944889 },
	{ 28, 66875385 },
	{ 28, 41515773 },
	{ 26, 24738557 },
	{ 26, 7961341 },
	{ 21, 994586 },
	{ 21, 2092398 },
	{ 26, 23689977 },
	{ 27, 20806393 },
	{ 27, 28932857 },
	{ 27, 53312249 },
	{ 27, 61438713 },
	{ 27, 43875065 },
	{ 27, 47807225 },
	{ 27, 59603705 },
	{ 27, 63535865 },
	{ 26, 27622137 },
	{ 26, 28408569 },
	{ 26, 27491065 },
	{ 26, 27753209 },
	{ 26, 28736253 },
	{ 27, 48152575 },
	{ 28, 245136121 },
	{ 28, 111115001 },
	{ 28, 115243773 },
	{ 29, 230193913 },
	{ 29, 222067449 },
	{ 29, 258505465 },
	{ 29, 241990393 },
	{ 29, 192445177 },
	{ 29, 175930105 },
	{ 28, 132676345 },
	{ 28, 116161273 },
	{ 28, 66616057 },
	{ 28, 50100985 },
	{ 26, 24738813 },
	{ 26, 7961597 },
	{ 21, 1010970 },
	{ 21, 2076014 },
	{ 26, 23690233 },
	{ 27, 20806649 },
	{ 27, 28933113 },
	{ 27, 53312505 },
	{ 27, 61438969 },
	{ 27, 43875321 },
	{ 27, 47807481 },
	{ 27, 59603961 },
	{ 27, 63536121 },
	{ 26, 27622393 },
	{ 26, 28408825 },
	{ 26, 27491321 },
	{ 26, 27753465 },
	{ 26, 28736509 },
	{ 27, 48152319 },
	{ 28, 245136377 },
	{ 28, 111115257 },
	{ 28, 115244029 },
	{ 29, 230194169 },
	{ 29, 222067705 },
	{ 29, 258505721 },
	{ 29, 241990649 },
	{ 29, 192445433 },
	{ 29, 175930361 },
	{ 28, 132676601 },
	{ 28, 116161529 },
	{ 28, 66616313 },
	{ 28, 50101241 },
	{ 26, 25001725 },
	{ 26, 8224509 },
	{ 21, 1027482 },
	{ 21, 2059758 },
	{ 26, 23953145 },
	{ 27, 47758331 },
	{ 27, 29196025 },
	{ 27, 54099705 },
	{ 27, 61701881 },
	{ 28, 134119161 },
	{ 27, 48070393 },
	{ 27, 60391161 },
	{ 27, 63799033 },
	{ 26, 33455865 },
	{ 26, 16678649 },
	{ 26, 31555321 },
	{ 26, 66354937 },
	{ 26, 28802809 },
	{ 26, 31883005 },
	{ 27, 49724415 },
	{ 28, 131890937 },
	{ 28, 115310329 },
	{ 28, 127827709 },
	{ 29, 221806329 },
	{ 28, 129793785 },
	{ 29, 241729273 },
	{ 29, 191659769 },
	{ 29, 175668985 },
	{ 28, 125599481 },
	{ 28, 115900153 },
	{ 28, 65830649 },
	{ 28, 49839865 },
	{ 26, 33324793 },
	{ 26, 8224765 },
	{ 21, 1032170 },
	{ 21, 2043374 },
	{ 26, 23953401 },
	{ 27, 47758075 },
	{ 27, 29196281 },
	{ 27, 54099961 },
	{ 27, 61702137 },
	{ 28, 134119417 },
	{ 27, 48070649 },
	{ 27, 60391417 },
	{ 27, 63799289 },
	{ 26, 33456121 },
	{ 26, 16678905 },
	{ 26, 31555577 },
	{ 26, 66355193 },
	{ 26, 28803065 },
	{ 26, 31883261 },
	{ 27, 49724159 },
	{ 28, 131891193 },
	{ 28, 115310585 },
	{ 28, 127827965 },
	{ 29, 221806585 },
	{ 28, 129794041 },
	{ 29, 241729529 },
	{ 29, 191660025 },
	{ 29, 175669241 },
	{ 28, 125599737 },
	{ 28, 115900409 },
	{ 28, 65830905 },
	{ 28, 49840121 },
	{ 26, 33325049 },
	{ 27, 30583549 },
	{ 21, 1048554 },
	{ 21, 1961838 },
	{ 27, 49457913 },
	{ 27, 49328123 },
	{ 29, 114469625 },
	{ 28, 108702457 },
	{ 28, 124955385 },
	{ 28, 124825595 },
	{ 29, 267692793 },
	{ 28, 121285369 },
	{ 28, 129149689 },
	{ 27, 67021565 },
	{ 27, 66366201 },
	{ 27, 32811769 },
	{ 27, 132164345 },
	{ 27, 130591481 },
	{ 27, 63875833 },
	{ 27, 65841917 },
	{ 27, 50245631 },
	{ 29, 255372025 },
	{ 29, 255765241 },
	{ 29, 264022781 },
	{ 29, 259042041 },
	{ 29, 242789113 },
	{ 29, 242921467 },
	{ 30, 349743865 },
	{ 29, 250653433 },
	{ 29, 217623289 },
	{ 29, 131115769 },
	{ 29, 98085625 },
	{ 27, 66104057 },
	{ 27, 33073913 },
	{ 21, 1916778 },
	{ 21, 1945454 },
	{ 27, 49458169 },
	{ 27, 49327867 },
	{ 29, 114469881 },
	{ 28, 108702713 },
	{ 28, 124955641 },
	{ 28, 124825339 },
	{ 29, 267693049 },
	{ 28, 121285625 },
	{ 28, 129149945 },
	{ 27, 67021821 },
	{ 27, 66366457 },
	{ 27, 32812025 },
	{ 27, 132164601 },
	{ 27, 130591737 },
	{ 27, 63876089 },
	{ 27, 65842173 },
	{ 27, 50245375 },
	{ 29, 255372281 },
	{ 29, 255765497 },
	{ 29, 264023037 },
	{ 29, 259042297 },
	{ 29, 242789369 },
	{ 29, 242921211 },
	{ 30, 349744121 },
	{ 29, 250653689 },
	{ 29, 217623545 },
	{ 29, 131116025 },
	{ 29, 98085881 },
	{ 27, 66104313 },
	{ 27, 33074169 },
	{ 21, 1933162 },
	{ 21, 1929198 },
	{ 27, 49983225 },
	{ 27, 49851387 },
	{ 29, 114994937 },
	{ 29, 215133945 },
	{ 28, 125480697 },
	{ 28, 125348859 },
	{ 29, 190492409 },
	{ 29, 266120953 },
	{ 28, 129675001 },
	{ 28, 129543163 },
	{ 27, 66498301 },
	{ 27, 64794361 },
	{ 27, 31239929 },
	{ 27, 130068217 },
	{ 27, 124301049 },
	{ 27, 65974009 },
	{ 27, 122466045 },
	{ 27, 64400383 },
	{ 29, 230207225 },
	{ 29, 264154873 },
	{ 29, 257470201 },
	{ 29, 242265849 },
	{ 29, 192458489 },
	{ 29, 192588795 },
	{ 29, 249081593 },
	{ 29, 217100025 },
	{ 29, 116961017 },
	{ 29, 97562361 },
	{ 27, 64532217 },
	{ 27, 32550649 },
	{ 21, 1949162 },
	{ 21, 1912814 },
	{ 27, 49983481 },
	{ 27, 49851131 },
	{ 29, 114995193 },
	{ 29, 215134201 },
	{ 28, 125480953 },
	{ 28, 125348603 },
	{ 29, 190492665 },
	{ 29, 266121209 },
	{ 28, 129675257 },
	{ 28, 129542907 },
	{ 27, 66498557 },
	{ 27, 64794617 },
	{ 27, 31240185 },
	{ 27, 130068473 },
	{ 27, 124301305 },
	{ 27, 65974265 },
	{ 27, 122466301 },
	{ 27, 64400127 },
	{ 29, 230207481 },
	{ 29, 264155129 },
	{ 29, 257470457 },
	{ 29, 242266105 },
	{ 29, 192458745 },
	{ 29, 192588539 },
	{ 29, 249081849 },
	{ 28, 133726207 },
	{ 28, 116948991 },
	{ 28, 66617343 },
	{ 27, 64532473 },
	{ 26, 33062911 },
	{ 21, 1965546 },
	{ 21, 1047918 },
	{ 26, 15499259 },
	{ 26, 32014331 },
	{ 28, 41713659 },
	{ 28, 58228731 },
	{ 28, 107773947 },
	{ 28, 124289019 },
	{ 28, 87851003 },
	{ 28, 95977467 },
	{ 28, 120356859 },
	{ 28, 128483323 },
	{ 28, 110919675 },
	{ 27, 64928509 },
	{ 26, 62291967 },
	{ 26, 61308923 },
	{ 26, 61112315 },
	{ 26, 61898747 },
	{ 26, 15368187 },
	{ 26, 32145403 },
	{ 26, 32473087 },
	{ 28, 65699835 },
	{ 28, 116031483 },
	{ 28, 132808699 },
	{ 28, 120422395 },
	{ 28, 96043003 },
	{ 28, 87916539 },
	{ 28, 124354555 },
	{ 28, 107839483 },
	{ 28, 58294267 },
	{ 27, 64011001 },
	{ 26, 32079867 },
	{ 21, 2047338 },
	{ 21, 1031534 },
	{ 26, 15499003 },
	{ 26, 32014075 },
	{ 28, 41713403 },
	{ 28, 58228475 },
	{ 28, 107773691 },
	{ 28, 124288763 },
	{ 28, 87850747 },
	{ 28, 95977211 },
	{ 28, 120356603 },
	{ 28, 128483067 },
	{ 28, 110919419 },
	{ 27, 64928765 },
	{ 26, 62291711 },
	{ 26, 61308667 },
	{ 26, 61112059 },
	{ 26, 61898491 },
	{ 26, 15367931 },
	{ 26, 32145147 },
	{ 26, 32472831 },
	{ 28, 65699579 },
	{ 28, 116031227 },
	{ 28, 132808443 },
	{ 28, 120422139 },
	{ 28, 96042747 },
	{ 28, 87916283 },
	{ 28, 124354299 },
	{ 28, 107839227 },
	{ 28, 58294011 },
	{ 27, 64011257 },
	{ 26, 32079611 },
	{ 21, 2063722 },
	{ 21, 1015278 },
	{ 26, 16284667 },
	{ 26, 32275451 },
	{ 28, 48790523 },
	{ 28, 58489851 },
	{ 28, 108559355 },
	{ 28, 124550139 },
	{ 29, 192593657 },
	{ 28, 96238587 },
	{ 28, 121142267 },
	{ 28, 128744443 },
	{ 28, 132086779 },
	{ 28, 115112955 },
	{ 27, 64405245 },
	{ 26, 61242367 },
	{ 26, 32996347 },
	{ 26, 62159867 },
	{ 26, 65043451 },
	{ 26, 15629307 },
	{ 26, 32406523 },
	{ 26, 33258495 },
	{ 28, 129548025 },
	{ 27, 64846843 },
	{ 28, 133069819 },
	{ 28, 95255547 },
	{ 28, 125353721 },
	{ 27, 62749691 },
	{ 28, 107576315 },
	{ 28, 57506811 },
	{ 27, 49856249 },
	{ 26, 25000955 },
	{ 21, 2076650 },
	{ 21, 998894 },
	{ 26, 16284411 },
	{ 26, 32275195 },
	{ 28, 48790267 },
	{ 28, 58489595 },
	{ 28, 108559099 },
	{ 28, 124549883 },
	{ 29, 192593913 },
	{ 28, 96238331 },
	{ 28, 121142011 },
	{ 28, 128744187 },
	{ 28, 132086523 },
	{ 28, 115112699 },
	{ 27, 64405501 },
	{ 26, 61242111 },
	{ 26, 32996091 },
	{ 26, 62159611 },
	{ 26, 65043195 },
	{ 26, 15629051 },
	{ 26, 32406267 },
	{ 26, 33258239 },
	{ 28, 129548281 },
	{ 27, 64846587 },
	{ 28, 133069563 },
	{ 28, 95255291 },
	{ 28, 125353977 },
	{ 27, 62749435 },
	{ 28, 107576059 },
	{ 28, 57506555 },
	{ 27, 49856505 },
	{ 26, 25000699 },
	{ 21, 2093034 },
	{ 21, 917358 },
	{ 26, 16543739 },
	{ 26, 33058811 },
	{ 28, 49049595 },
	{ 28, 65564667 },
	{ 28, 108818427 },
	{ 28, 125333499 },
	{ 29, 174878715 },
	{ 29, 242936569 },
	{ 28, 121401339 },
	{ 28, 129527803 },
	{ 28, 132018175 },
	{ 28, 127889403 },
	{ 28, 127692795 },
	{ 27, 50260733 },
	{ 26, 32927743 },
	{ 26, 31944699 },
	{ 26, 65302523 },
	{ 26, 66088955 },
	{ 26, 16412667 },
	{ 26, 33189883 },
	{ 26, 33517567 },
	{ 27, 64581627 },
	{ 27, 60649467 },
	{ 28, 133853179 },
	{ 28, 124840697 },
	{ 27, 62484475 },
	{ 27, 54358011 },
	{ 28, 57241595 },
	{ 27, 49343225 },
	{ 26, 24735739 },
	{ 26, 8220667 },
	{ 21, 900974 },
	{ 26, 16543483 },
	{ 26, 33058555 },
	{ 28, 49049339 },
	{ 28, 65564411 },
	{ 28, 108818171 },
	{ 28, 125333243 },
	{ 29, 174878459 },
	{ 29, 242936825 },
	{ 28, 121401083 },
	{ 28, 129527547 },
	{ 28, 132017919 },
	{ 28, 127889147 },
	{ 28, 127692539 },
	{ 27, 50260989 },
	{ 26, 32927487 },
	{ 26, 31944443 },
	{ 26, 65302267 },
	{ 26, 66088699 },
	{ 26, 16412411 },
	{ 26, 33189627 },
	{ 26, 33517311 },
	{ 27, 64581371 },
	{ 27, 60649211 },
	{ 28, 133852923 },
	{ 28, 124840953 },
	{ 27, 62484219 },
	{ 27, 54357755 },
	{ 28, 57241339 },
	{ 27, 49343481 },
	{ 26, 24735483 },
	{ 26, 8220411 },
	{ 21, 884718 },
	{ 26, 15298303 },
	{ 26, 33319931 },
	{ 28, 49835003 },
	{ 28, 65825787 },
	{ 28, 115895291 },
	{ 28, 125594619 },
	{ 29, 175664123 },
	{ 29, 191654907 },
	{ 29, 259714809 },
	{ 28, 129788923 },
	{ 29, 251064061 },
	{ 28, 127822847 },
	{ 28, 115305467 },
	{ 28, 131886075 },
	{ 27, 49737469 },
	{ 26, 31878143 },
	{ 26, 28797947 },
	{ 26, 66350075 },
	{ 26, 31550459 },
	{ 26, 16673787 },
	{ 26, 33451003 },
	{ 27, 63794171 },
	{ 27, 60386299 },
	{ 27, 48065531 },
	{ 28, 123268857 },
	{ 27, 61697019 },
	{ 27, 54094843 },
	{ 27, 29191163 },
	{ 27, 47771385 },
	{ 26, 23948283 },
	{ 26, 7957499 },
	{ 21, 868334 },
	{ 26, 8219647 },
	{ 26, 33319675 },
	{ 28, 49834747 },
	{ 28, 65825531 },
	{ 28, 115895035 },
	{ 28, 125594363 },
	{ 29, 175663867 },
	{ 29, 191654651 },
	{ 29, 259715065 },
	{ 28, 129788667 },
	{ 29, 251064317 },
	{ 28, 127822591 },
	{ 28, 115305211 },
	{ 28, 131885819 },
	{ 27, 49737725 },
	{ 26, 31877887 },
	{ 26, 28797691 },
	{ 26, 66349819 },
	{ 26, 31550203 },
	{ 26, 16673531 },
	{ 26, 33450747 },
	{ 27, 63793915 },
	{ 27, 60386043 },
	{ 27, 48065275 },
	{ 28, 123269113 },
	{ 27, 61696763 },
	{ 27, 54094587 },
	{ 27, 29190907 },
	{ 27, 47771641 },
	{ 26, 23948027 },
	{ 26, 7957243 },
	{ 21, 863646 },
	{ 26, 8219391 },
	{ 26, 24996607 },
	{ 28, 50085883 },
	{ 28, 66600955 },
	{ 28, 116146171 },
	{ 28, 132661243 },
	{ 29, 175915003 },
	{ 29, 192430075 },
	{ 29, 241975291 },
	{ 29, 258490363 },
	{ 29, 222052347 },
	{ 29, 249494269 },
	{ 28, 115228671 },
	{ 28, 111099899 },
	{ 28, 245121019 },
	{ 27, 48167677 },
	{ 26, 28721151 },
	{ 26, 27738107 },
	{ 26, 27475963 },
	{ 26, 28393467 },
	{ 26, 27607035 },
	{ 27, 63520763 },
	{ 27, 59588603 },
	{ 27, 47792123 },
	{ 27, 43859963 },
	{ 27, 61423611 },
	{ 27, 53297147 },
	{ 27, 28917755 },
	{ 27, 47250169 },
	{ 26, 23674875 },
	{ 26, 7159803 },
	{ 20, 519454 },
	{ 26, 7946239 },
	{ 26, 24723455 },
	{ 28, 50085627 },
	{ 28, 66600699 },
	{ 28, 116145915 },
	{ 28, 132660987 },
	{ 29, 175914747 },
	{ 29, 192429819 },
	{ 29, 241975035 },
	{ 29, 258490107 },
	{ 29, 222052091 },
	{ 29, 249494525 },
	{ 28, 115228415 },
	{ 28, 111099643 },
	{ 28, 245120763 },
	{ 27, 48167933 },
	{ 26, 28720895 },
	{ 26, 27737851 },
	{ 26, 27475707 },
	{ 26, 28393211 },
	{ 26, 27606779 },
	{ 27, 63520507 },
	{ 27, 59588347 },
	{ 27, 47791867 },
	{ 27, 43859707 },
	{ 27, 61423355 },
	{ 27, 53296891 },
	{ 27, 28917499 },
	{ 27, 47250425 },
	{ 26, 23674619 },
	{ 26, 7159547 },
	{ 20, 503070 },
	{ 26, 7945983 },
	{ 26, 24723199 },
	{ 28, 41500415 },
	{ 28, 66862075 },
	{ 28, 116931579 },
	{ 28, 132922363 },
	{ 29, 182991867 },
	{ 29, 192691195 },
	{ 29, 242760699 },
	{ 29, 259849977 },
	{ 28, 129973243 },
	{ 28, 129711099 },
	{ 28, 128924667 },
	{ 28, 125632249 },
	{ 27, 64961531 },
	{ 27, 64699387 },
	{ 27, 47644413 },
	{ 26, 24968953 },
	{ 25, 16202747 },
	{ 25, 15940603 },
	{ 26, 32046841 },
	{ 25, 16071675 },
	{ 27, 59325435 },
	{ 27, 47004667 },
	{ 27, 62455545 },
	{ 26, 31276027 },
	{ 27, 53033979 },
	{ 27, 28130299 },
	{ 26, 24706809 },
	{ 25, 12401659 },
	{ 26, 6896635 },
	{ 19, 243614 },
	{ 26, 7158783 },
	{ 26, 23935999 },
	{ 28, 40713215 },
	{ 28, 66861819 },
	{ 28, 116931323 },
	{ 28, 132922107 },
	{ 29, 182991611 },
	{ 29, 192690939 },
	{ 29, 242760443 },
	{ 29, 259850233 },
	{ 28, 129972987 },
	{ 28, 129710843 },
	{ 28, 128924411 },
	{ 28, 125632505 },
	{ 27, 64961275 },
	{ 27, 64699131 },
	{ 27, 47644669 },
	{ 26, 24969209 },
	{ 25, 16202491 },
	{ 25, 15940347 },
	{ 26, 32047097 },
	{ 25, 16071419 },
	{ 27, 59325179 },
	{ 27, 47004411 },
	{ 27, 62455801 },
	{ 26, 31275771 },
	{ 27, 53033723 },
	{ 27, 28130043 },
	{ 26, 24707065 },
	{ 25, 12401403 },
	{ 26, 6896379 },
	{ 19, 235422 },
	{ 26, 7158527 },
	{ 26, 23935743 },
	{ 28, 40712959 },
	{ 28, 57490175 },
	{ 28, 117190651 },
	{ 28, 133705723 },
	{ 29, 183250939 },
	{ 29, 199766011 },
	{ 29, 243019771 },
	{ 29, 259534843 },
	{ 28, 129904639 },
	{ 28, 121581563 },
	{ 28, 121319419 },
	{ 28, 120532987 },
	{ 27, 64892927 },
	{ 27, 60764155 },
	{ 27, 60502011 },
	{ 27, 50178813 },
	{ 25, 16134143 },
	{ 25, 15151099 },
	{ 25, 14888955 },
	{ 25, 15806459 },
	{ 25, 15020027 },
	{ 27, 46739451 },
	{ 27, 42807291 },
	{ 26, 31010811 },
	{ 26, 27078651 },
	{ 27, 27865083 },
	{ 27, 48343801 },
	{ 25, 12136443 },
	{ 25, 4009979 },
	{ 19, 194334 },
	{ 26, 6893567 },
	{ 26, 23670783 },
	{ 28, 40447999 },
	{ 28, 57225215 },
	{ 28, 117190395 },
	{ 28, 133705467 },
	{ 29, 183250683 },
	{ 29, 199765755 },
	{ 29, 243019515 },
	{ 29, 259534587 },
	{ 28, 129904383 },
	{ 28, 121581307 },
	{ 28, 121319163 },
	{ 28, 120532731 },
	{ 27, 64892671 },
	{ 27, 60763899 },
	{ 27, 60501755 },
	{ 27, 50179069 },
	{ 25, 16133887 },
	{ 25, 15150843 },
	{ 25, 14888699 },
	{ 25, 15806203 },
	{ 25, 15019771 },
	{ 27, 46739195 },
	{ 27, 42807035 },
	{ 26, 31010555 },
	{ 26, 27078395 },
	{ 27, 27864827 },
	{ 27, 48344057 },
	{ 25, 12136187 },
	{ 25, 4009723 },
	{ 19, 186142 },
	{ 26, 6893311 },
	{ 26, 23670527 },
	{ 28, 40447743 },
	{ 28, 57224959 },
	{ 28, 107556607 },
	{ 28, 133966843 },
	{ 29, 184036347 },
	{ 29, 200027131 },
	{ 29, 250096635 },
	{ 29, 259795963 },
	{ 29, 191835131 },
	{ 28, 121515007 },
	{ 28, 96414715 },
	{ 28, 96152571 },
	{ 28, 95366139 },
	{ 27, 60697599 },
	{ 27, 48180219 },
	{ 27, 47918075 },
	{ 27, 49131261 },
	{ 25, 15084543 },
	{ 25, 12004347 },
	{ 25, 11742203 },
	{ 25, 14756859 },
	{ 25, 11873275 },
	{ 27, 42544123 },
	{ 26, 30223355 },
	{ 26, 26815483 },
	{ 26, 14494715 },
	{ 27, 45199097 },
	{ 25, 11348987 },
	{ 25, 3746811 },
	{ 19, 177566 },
	{ 25, 4008959 },
	{ 25, 12397567 },
	{ 27, 20786175 },
	{ 27, 29174783 },
	{ 27, 54340607 },
	{ 27, 62729215 },
	{ 28, 87895039 },
	{ 28, 96283647 },
	{ 28, 121449471 },
	{ 28, 129838079 },
	{ 29, 191834875 },
	{ 28, 121514751 },
	{ 28, 96414459 },
	{ 28, 96152315 },
	{ 28, 95365883 },
	{ 27, 60697343 },
	{ 27, 48179963 },
	{ 27, 47917819 },
	{ 27, 49131517 },
	{ 25, 15084287 },
	{ 25, 12004091 },
	{ 25, 11741947 },
	{ 25, 14756603 },
	{ 25, 11873019 },
	{ 27, 42543867 },
	{ 26, 30223099 },
	{ 26, 26815227 },
	{ 26, 14494459 },
	{ 27, 45199353 },
	{ 25, 11348731 },
	{ 25, 3746555 },
	{ 19, 169374 },
	{ 25, 4008703 },
	{ 25, 12397311 },
	{ 27, 20785919 },
	{ 27, 29174527 },
	{ 27, 54340351 },
	{ 27, 46129147 },
	{ 27, 46079995 },
	{ 27, 50208763 },
	{ 27, 62595067 },
	{ 27, 66723835 },
	{ 27, 43966459 },
	{ 27, 43769851 },
	{ 26, 24092671 },
	{ 26, 22011899 },
	{ 26, 21946363 },
	{ 26, 21749755 },
	{ 25, 12034047 },
	{ 25, 11001851 },
	{ 25, 10936315 },
	{ 25, 10739707 },
	{ 23, 2990079 },
	{ 23, 2744315 },
	{ 23, 2678779 },
	{ 23, 2908155 },
	{ 23, 2711547 },
	{ 24, 7495675 },
	{ 24, 6512635 },
	{ 24, 3563515 },
	{ 24, 2580475 },
	{ 23, 2777083 },
	{ 23, 745467 },
	{ 18, 128286 },
	{ 23, 942079 },
	{ 23, 3039231 },
	{ 25, 5136383 },
	{ 25, 7233535 },
	{ 25, 13524991 },
	{ 25, 15622143 },
	{ 26, 21913599 },
	{ 26, 24010751 },
	{ 26, 30302207 },
	{ 26, 32399359 },
	{ 27, 43966203 },
	{ 27, 43769595 },
	{ 26, 24092415 },
	{ 26, 22011643 },
	{ 26, 21946107 },
	{ 26, 21749499 },
	{ 25, 12033791 },
	{ 25, 11001595 },
	{ 25, 10936059 },
	{ 25, 10739451 },
	{ 23, 2989823 },
	{ 23, 2744059 },
	{ 23, 2678523 },
	{ 23, 2907899 },
	{ 23, 2711291 },
	{ 24, 7495419 },
	{ 24, 6512379 },
	{ 24, 3563259 },
	{ 24, 2580219 },
	{ 23, 2776827 },
	{ 23, 745211 },
	{ 18, 120094 },
	{ 23, 941823 },
	{ 23, 3038975 },
	{ 25, 5136127 },
	{ 25, 7233279 },
	{ 25, 13524735 },
	{ 25, 15621887 },
	{ 26, 33545211 },
	{ 26, 33479675 },
	{ 26, 33283067 },
	{ 26, 33217531 },
	{ 26, 31448059 },
	{ 26, 31382523 },
	{ 26, 31185915 },
	{ 26, 31120379 },
	{ 25, 15719419 },
	{ 25, 15653883 },
	{ 25, 15457275 },
	{ 25, 15391739 },
	{ 24, 7855099 },
	{ 24, 7789563 },
	{ 24, 7592955 },
	{ 23, 2726911 },
	{ 22, 1956859 },
	{ 22, 1891323 },
	{ 23, 2644987 },
	{ 22, 1924091 },
	{ 24, 6446075 },
	{ 24, 3365883 },
	{ 24, 2513915 },
	{ 22, 1530875 },
	{ 23, 678907 },
	{ 17, 56222 },
	{ 23, 744447 },
	{ 23, 2841599 },
	{ 25, 4938751 },
	{ 25, 7035903 },
	{ 25, 13327359 },
	{ 25, 15424511 },
	{ 26, 33544955 },
	{ 26, 33479419 },
	{ 26, 33282811 },
	{ 26, 33217275 },
	{ 26, 31447803 },
	{ 26, 31382267 },
	{ 26, 31185659 },
	{ 26, 31120123 },
	{ 25, 15719163 },
	{ 25, 15653627 },
	{ 25, 15457019 },
	{ 25, 15391483 },
	{ 24, 7854843 },
	{ 24, 7789307 },
	{ 24, 7592699 },
	{ 23, 2726655 },
	{ 22, 1956603 },
	{ 22, 1891067 },
	{ 23, 2644731 },
	{ 22, 1923835 },
	{ 24, 6445819 },
	{ 24, 3365627 },
	{ 24, 2513659 },
	{ 22, 1530619 },
	{ 23, 678651 },
	{ 17, 52126 },
	{ 23, 744191 },
	{ 23, 2841343 },
	{ 25, 4938495 },
	{ 25, 7035647 },
	{ 25, 13327103 },
	{ 25, 15424255 },
	{ 26, 21715711 },
	{ 26, 29347835 },
	{ 26, 29282299 },
	{ 26, 29085691 },
	{ 26, 29020155 },
	{ 26, 27250683 },
	{ 26, 27185147 },
	{ 26, 26988539 },
	{ 25, 15699967 },
	{ 25, 13619195 },
	{ 25, 13553659 },
	{ 25, 13357051 },
	{ 24, 7835647 },
	{ 24, 6803451 },
	{ 24, 6737915 },
	{ 24, 6541307 },
	{ 22, 1937407 },
	{ 22, 1691643 },
	{ 22, 1626107 },
	{ 22, 1855483 },
	{ 22, 1658875 },
	{ 24, 3297275 },
	{ 24, 2314235 },
	{ 22, 1462267 },
	{ 22, 479227 },
	{ 17, 31518 },
	{ 23, 675839 },
	{ 23, 2772991 },
	{ 25, 4870143 },
	{ 25, 6967295 },
	{ 25, 13258751 },
	{ 25, 15355903 },
	{ 26, 33525503 },
	{ 26, 29347579 },
	{ 26, 29282043 },
	{ 26, 29085435 },
	{ 26, 29019899 },
	{ 26, 27250427 },
	{ 26, 27184891 },
	{ 26, 26988283 },
	{ 25, 15699711 },
	{ 25, 13618939 },
	{ 25, 13553403 },
	{ 25, 13356795 },
	{ 24, 7835391 },
	{ 24, 6803195 },
	{ 24, 6737659 },
	{ 24, 6541051 },
	{ 22, 1937151 },
	{ 22, 1691387 },
	{ 22, 1625851 },
	{ 22, 1855227 },
	{ 22, 1658619 },
	{ 24, 3297019 },
	{ 24, 2313979 },
	{ 22, 1462011 },
	{ 22, 478971 },
	{ 17, 27422 },
	{ 23, 675583 },
	{ 23, 2772735 },
	{ 25, 4869887 },
	{ 25, 6967039 },
	{ 25, 13258495 },
	{ 25, 15355647 },
	{ 26, 21647103 },
	{ 26, 23744255 },
	{ 26, 16763899 },
	{ 26, 16698363 },
	{ 26, 16501755 },
	{ 26, 16436219 },
	{ 26, 14666747 },
	{ 26, 14601211 },
	{ 26, 14404603 },
	{ 25, 13601791 },
	{ 25, 7326715 },
	{ 25, 7261179 },
	{ 25, 7064571 },
	{ 24, 6786047 },
	{ 24, 3656699 },
	{ 24, 3591163 },
	{ 24, 3394555 },
	{ 22, 1674239 },
	{ 22, 904187 },
	{ 22, 838651 },
	{ 22, 1592315 },
	{ 22, 871419 },
	{ 24, 2247675 },
	{ 22, 1264635 },
	{ 22, 412667 },
	{ 17, 22942 },
	{ 22, 478207 },
	{ 22, 1526783 },
	{ 24, 2575359 },
	{ 24, 3623935 },
	{ 24, 6769663 },
	{ 24, 7818239 },
	{ 25, 10963967 },
	{ 25, 12012543 },
	{ 25, 15158271 },
	{ 25, 16206847 },
	{ 26, 16501499 },
	{ 26, 16435963 },
	{ 26, 14666491 },
	{ 26, 14600955 },
	{ 26, 14404347 },
	{ 25, 13601535 },
	{ 25, 7326459 },
	{ 25, 7260923 },
	{ 25, 7064315 },
	{ 24, 6785791 },
	{ 24, 3656443 },
	{ 24, 3590907 },
	{ 24, 3394299 },
	{ 22, 1673983 },
	{ 22, 903931 },
	{ 22, 838395 },
	{ 22, 1592059 },
	{ 22, 871163 },
	{ 24, 2247419 },
	{ 22, 1264379 },
	{ 22, 412411 },
	{ 17, 18846 },
	{ 22, 477951 },
	{ 22, 1526527 },
	{ 24, 2575103 },
	{ 24, 3623679 },
	{ 24, 6769407 },
	{ 24, 7817983 },
	{ 25, 10963711 },
	{ 25, 12012287 },
	{ 24, 4188159 },
	{ 24, 3143675 },
	{ 24, 3127291 },
	{ 24, 3078139 },
	{ 24, 3061755 },
	{ 24, 2619387 },
	{ 24, 2603003 },
	{ 24, 2553851 },
	{ 23, 1828863 },
	{ 23, 1308667 },
	{ 23, 1292283 },
	{ 23, 1243131 },
	{ 22, 911359 },
	{ 22, 653307 },
	{ 22, 636923 },
	{ 22, 587771 },
	{ 20, 223231 },
	{ 20, 161787 },
	{ 20, 145403 },
	{ 20, 202747 },
	{ 20, 153595 },
	{ 20, 301051 },
	{ 20, 55291 },
	{ 15, 14622 },
	{ 20, 104447 },
	{ 20, 366591 },
	{ 22, 628735 },
	{ 22, 890879 },
	{ 22, 1677311 },
	{ 22, 1939455 },
	{ 23, 2725887 },
	{ 23, 2988031 },
	{ 23, 3774463 },
	{ 23, 4036607 },
	{ 24, 3127035 },
	{ 24, 3077883 },
	{ 24, 3061499 },
	{ 24, 2619131 },
	{ 24, 2602747 },
	{ 24, 2553595 },
	{ 23, 1828607 },
	{ 23, 1308411 },
	{ 23, 1292027 },
	{ 23, 1242875 },
	{ 22, 911103 },
	{ 22, 653051 },
	{ 22, 636667 },
	{ 22, 587515 },
	{ 20, 222975 },
	{ 20, 161531 },
	{ 20, 145147 },
	{ 20, 202491 },
	{ 20, 153339 },
	{ 20, 300795 },
	{ 20, 55035 },
	{ 15, 10526 },
	{ 20, 104191 },
	{ 20, 366335 },
	{ 22, 628479 },
	{ 22, 890623 },
	{ 22, 1677055 },
	{ 22, 1939199 },
	{ 23, 2725631 },
	{ 23, 2987775 },
	{ 23, 3774207 },
	{ 23, 4036351 },
	{ 22, 2094075 },
	{ 22, 2077691 },
	{ 22, 2028539 },
	{ 22, 2012155 },
	{ 22, 1569787 },
	{ 22, 1553403 },
	{ 22, 1504251 },
	{ 22, 1487867 },
	{ 21, 783355 },
	{ 21, 766971 },
	{ 21, 717819 },
	{ 21, 701435 },
	{ 20, 390139 },
	{ 20, 373755 },
	{ 20, 324603 },
	{ 20, 308219 },
	{ 18, 95227 },
	{ 18, 78843 },
	{ 20, 136187 },
	{ 18, 87035 },
	{ 20, 37883 },
	{ 13, 1694 },
	{ 20, 54271 },
	{ 20, 316415 },
	{ 22, 578559 },
	{ 22, 840703 },
	{ 22, 1627135 },
	{ 22, 1889279 },
	{ 23, 2675711 },
	{ 23, 2937855 },
	{ 23, 3724287 },
	{ 23, 3986431 },
	{ 22, 2093819 },
	{ 22, 2077435 },
	{ 22, 2028283 },
	{ 22, 2011899 },
	{ 22, 1569531 },
	{ 22, 1553147 },
	{ 22, 1503995 },
	{ 22, 1487611 },
	{ 21, 783099 },
	{ 21, 766715 },
	{ 21, 717563 },
	{ 21, 701179 },
	{ 20, 389883 },
	{ 20, 373499 },
	{ 20, 324347 },
	{ 20, 307963 },
	{ 18, 94971 },
	{ 18, 78587 },
	{ 20, 135931 },
	{ 18, 86779 },
	{ 20, 37627 },
	{ 13, 670 },
	{ 20, 54015 },
	{ 20, 316159 },
	{ 22, 578303 },
	{ 22, 840447 },
	{ 22, 1626879 },
	{ 22, 1889023 },
	{ 23, 2675455 },
	{ 23, 2937599 },
	{ 23, 3724031 },
	{ 23, 3986175 },
	{ 20, 522751 },
	{ 20, 261627 },
	{ 20, 257531 },
	{ 20, 245243 },
	{ 20, 241147 },
	{ 20, 130555 },
	{ 20, 126459 },
	{ 20, 114171 },
	{ 19, 195071 },
	{ 19, 65019 },
	{ 19, 60923 },
	{ 19, 48635 },
	{ 18, 96767 },
	{ 18, 32251 },
	{ 18, 28155 },
	{ 18, 15867 },
	{ 16, 23039 },
	{ 16, 7675 },
	{ 16, 3579 },
	{ 12, 2939 },
	{ 11, 955 },
	{ 11, 1054 },
	{ 18, 9727 },
	{ 18, 75263 },
	{ 20, 140799 },
	{ 20, 206335 },
	{ 20, 402943 },
	{ 20, 468479 },
	{ 21, 665087 },
	{ 21, 730623 },
	{ 21, 927231 },
	{ 21, 992767 },
	{ 20, 1039613 },
	{ 20, 1034489 },
	{ 20, 1018105 },
	{ 20, 968953 },
	{ 20, 952569 },
	{ 20, 510201 },
	{ 20, 493817 },
	{ 20, 444665 },
	{ 19, 253181 },
	{ 19, 248057 },
	{ 19, 231673 },
	{ 19, 182521 },
	{ 18, 122109 },
	{ 18, 116985 },
	{ 18, 100601 },
	{ 18, 51449 },
	{ 16, 23805 },
	{ 16, 18681 },
	{ 16, 2297 },
	{ 12, 377 },
	{ 10, 123 },
	{ 11, 106 },
	{ 18, 8445 },
	{ 18, 73981 },
	{ 20, 139517 },
	{ 20, 205053 },
	{ 20, 401661 },
	{ 20, 467197 },
	{ 21, 663805 },
	{ 21, 729341 },
	{ 21, 925949 },
	{ 21, 991485 },
	{ 20, 1039869 },
	{ 20, 1034745 },
	{ 20, 1018361 },
	{ 20, 969209 },
	{ 20, 952825 },
	{ 20, 510457 },
	{ 20, 494073 },
	{ 20, 444921 },
	{ 19, 253437 },
	{ 19, 248313 },
	{ 19, 231929 },
	{ 19, 182777 },
	{ 18, 122365 },
	{ 18, 117241 },
	{ 18, 100857 },
	{ 18, 51705 },
	{ 16, 24061 },
	{ 16, 18937 },
	{ 16, 2553 },
	{ 12, 2425 },
	{ 10, 185 },
	{ 11, 1130 },
	{ 18, 8701 },
	{ 18, 74237 },
	{ 20, 139773 },
	{ 20, 205309 },
	{ 20, 401917 },
	{ 20, 467453 },
	{ 21, 664061 },
	{ 21, 729597 },
	{ 21, 926205 },
	{ 21, 991741 },
	{ 22, 1712637 },
	{ 22, 4141821 },
	{ 22, 4076285 },
	{ 22, 3879677 },
	{ 22, 3814141 },
	{ 22, 2044669 },
	{ 22, 1979133 },
	{ 22, 1782525 },
	{ 22, 1716989 },
	{ 21, 996093 },
	{ 21, 930557 },
	{ 21, 733949 },
	{ 21, 668413 },
	{ 20, 471805 },
	{ 20, 406269 },
	{ 20, 209661 },
	{ 20, 144125 },
	{ 18, 78589 },
	{ 18, 13053 },
	{ 10, 489 },
	{ 8, 41 },
	{ 9, 90 },
	{ 12, 1469 },
	{ 18, 82685 },
	{ 20, 148221 },
	{ 20, 213757 },
	{ 20, 410365 },
	{ 20, 475901 },
	{ 21, 672509 },
	{ 21, 738045 },
	{ 21, 934653 },
	{ 21, 1000189 },
	{ 22, 1721085 },
	{ 22, 1786621 },
	{ 22, 1983229 },
	{ 22, 2048765 },
	{ 22, 3818237 },
	{ 22, 3883773 },
	{ 22, 4080381 },
	{ 22, 4145917 },
	{ 22, 1717245 },
	{ 21, 996349 },
	{ 21, 930813 },
	{ 21, 734205 },
	{ 21, 668669 },
	{ 20, 472061 },
	{ 20, 406525 },
	{ 20, 209917 },
	{ 20, 144381 },
	{ 18, 78845 },
	{ 18, 13309 },
	{ 10, 313 },
	{ 7, 9 },
	{ 9, 218 },
	{ 11, 701 },
	{ 18, 82941 },
	{ 20, 148477 },
	{ 20, 214013 },
	{ 20, 410621 },
	{ 20, 476157 },
	{ 21, 672765 },
	{ 21, 738301 },
	{ 21, 934909 },
	{ 21, 1000445 },
	{ 22, 1721341 },
	{ 22, 1786877 },
	{ 22, 1983485 },
	{ 22, 4134653 },
	{ 22, 4069117 },
	{ 22, 3872509 },
	{ 22, 3806973 },
	{ 22, 2037501 },
	{ 22, 1971965 },
	{ 22, 1775357 },
	{ 22, 1709821 },
	{ 21, 988925 },
	{ 21, 923389 },
	{ 21, 726781 },
	{ 21, 661245 },
	{ 20, 464637 },
	{ 20, 399101 },
	{ 20, 202493 },
	{ 20, 136957 },
	{ 14, 6013 },
	{ 8, 93 },
	{ 24, 507641 },
	{ 9, 173 },
	{ 14, 5501 },
	{ 20, 132861 },
	{ 20, 198397 },
	{ 20, 395005 },
	{ 20, 460541 },
	{ 21, 657149 },
	{ 21, 722685 },
	{ 21, 919293 },
	{ 21, 984829 },
	{ 22, 1705725 },
	{ 22, 1771261 },
	{ 22, 1967869 },
	{ 22, 2033405 },
	{ 22, 3802877 },
	{ 22, 3868413 },
	{ 22, 4065021 },
	{ 22, 4130557 },
	{ 22, 1972221 },
	{ 22, 1775613 },
	{ 22, 1710077 },
	{ 21, 989181 },
	{ 21, 923645 },
	{ 21, 727037 },
	{ 21, 661501 },
	{ 20, 464893 },
	{ 20, 399357 },
	{ 20, 202749 },
	{ 20, 137213 },
	{ 14, 8061 },
	{ 11, 877 },
	{ 10, 138 },
	{ 8, 77 },
	{ 14, 7549 },
	{ 20, 133117 },
	{ 20, 198653 },
	{ 20, 395261 },
	{ 20, 460797 },
	{ 21, 657405 },
	{ 21, 722941 },
	{ 21, 919549 },
	{ 21, 985085 },
	{ 22, 1705981 },
	{ 22, 1771517 },
	{ 22, 1968125 },
	{ 22, 2033661 },
	{ 22, 3803133 },
	{ 22, 3868669 },
	{ 22, 4065277 },
	{ 22, 4130813 },
	{ 24, 7949053 },
	{ 24, 7162621 },
	{ 24, 6900477 },
	{ 23, 4016893 },
	{ 23, 3754749 },
	{ 23, 2968317 },
	{ 23, 2706173 },
	{ 22, 1919741 },
	{ 22, 1657597 },
	{ 22, 871165 },
	{ 22, 609021 },
	{ 20, 346877 },
	{ 13, 3709 },
	{ 10, 202 },
	{ 9, 217 },
	{ 12, 2029 },
	{ 20, 35581 },
	{ 20, 101117 },
	{ 22, 166653 },
	{ 22, 232189 },
	{ 22, 428797 },
	{ 22, 494333 },
	{ 23, 690941 },
	{ 23, 756477 },
	{ 23, 953085 },
	{ 23, 1018621 },
	{ 24, 1739517 },
	{ 24, 1805053 },
	{ 24, 2001661 },
	{ 24, 2067197 },
	{ 24, 3836669 },
	{ 24, 3902205 },
	{ 24, 4098813 },
	{ 24, 4164349 },
	{ 24, 6900733 },
	{ 23, 4017149 },
	{ 23, 3755005 },
	{ 23, 2968573 },
	{ 23, 2706429 },
	{ 22, 1919997 },
	{ 22, 1657853 },
	{ 22, 871421 },
	{ 22, 609277 },
	{ 20, 347133 },
	{ 14, 8125 },
	{ 12, 1850 },
	{ 12, 1897 },
	{ 12, 1853 },
	{ 20, 35837 },
	{ 20, 101373 },
	{ 22, 166909 },
	{ 22, 232445 },
	{ 22, 429053 },
	{ 22, 494589 },
	{ 23, 691197 },
	{ 23, 756733 },
	{ 23, 953341 },
	{ 23, 1018877 },
	{ 24, 1739773 },
	{ 24, 1805309 },
	{ 24, 2001917 },
	{ 24, 2067453 },
	{ 24, 3836925 },
	{ 24, 3902461 },
	{ 24, 4099069 },
	{ 24, 4164605 },
	{ 26, 27414269 },
	{ 25, 15879933 },
	{ 25, 14831357 },
	{ 25, 11685629 },
	{ 25, 10637053 },
	{ 24, 7491325 },
	{ 24, 6442749 },
	{ 24, 3297021 },
	{ 24, 2248445 },
	{ 22, 1199869 },
	{ 22, 151293 },
	{ 15, 6682 },
	{ 14, 7801 },
	{ 16, 14201 },
	{ 20, 52985 },
	{ 20, 118521 },
	{ 20, 364285 },
	{ 22, 249593 },
	{ 22, 446201 },
	{ 22, 511737 },
	{ 22, 1543933 },
	{ 23, 773881 },
	{ 23, 970489 },
	{ 23, 1036025 },
	{ 23, 3116797 },
	{ 24, 1822457 },
	{ 24, 2019065 },
	{ 24, 2084601 },
	{ 24, 3854073 },
	{ 24, 3919609 },
	{ 24, 4116217 },
	{ 24, 4181753 },
	{ 24, 8359677 },
	{ 25, 15880189 },
	{ 25, 14831613 },
	{ 25, 11685885 },
	{ 25, 10637309 },
	{ 24, 7491581 },
	{ 24, 6443005 },
	{ 24, 3297277 },
	{ 24, 2248701 },
	{ 22, 1200125 },
	{ 22, 151549 },
	{ 15, 7706 },
	{ 15, 16313 },
	{ 16, 16249 },
	{ 20, 53241 },
	{ 20, 118777 },
	{ 20, 364541 },
	{ 22, 249849 },
	{ 22, 446457 },
	{ 22, 511993 },
	{ 22, 1544189 },
	{ 23, 774137 },
	{ 23, 970745 },
	{ 23, 1036281 },
	{ 23, 3117053 },
	{ 24, 1822713 },
	{ 24, 2019321 },
	{ 24, 2084857 },
	{ 24, 3854329 },
	{ 24, 3919865 },
	{ 24, 4116473 },
	{ 24, 4182009 },
	{ 24, 8359933 },
	{ 25, 15948541 },
	{ 25, 14899965 },
	{ 25, 11754237 },
	{ 25, 10705661 },
	{ 24, 7559933 },
	{ 24, 6511357 },
	{ 24, 3365629 },
	{ 24, 2317053 },
	{ 22, 1268477 },
	{ 22, 219901 },
	{ 15, 12954 },
	{ 22, 154361 },
	{ 20, 350969 },
	{ 22, 547577 },
	{ 20, 318201 },
	{ 20, 383737 },
	{ 22, 1235705 },
	{ 22, 1301241 },
	{ 22, 1497849 },
	{ 22, 1563385 },
	{ 23, 2808569 },
	{ 23, 2874105 },
	{ 23, 3070713 },
	{ 23, 3136249 },
	{ 24, 5954297 },
	{ 24, 6019833 },
	{ 24, 6216441 },
	{ 24, 6281977 },
	{ 24, 8051449 },
	{ 24, 8116985 },
	{ 24, 8313593 },
	{ 24, 8379129 },
	{ 25, 15948797 },
	{ 25, 14900221 },
	{ 25, 11754493 },
	{ 25, 10705917 },
	{ 24, 7560189 },
	{ 24, 6511613 },
	{ 24, 3365885 },
	{ 24, 2317309 },
	{ 22, 1268733 },
	{ 22, 220157 },
	{ 15, 13978 },
	{ 22, 154617 },
	{ 20, 351225 },
	{ 22, 547833 },
	{ 20, 318457 },
	{ 20, 383993 },
	{ 22, 1235961 },
	{ 22, 1301497 },
	{ 22, 1498105 },
	{ 22, 1563641 },
	{ 23, 2808825 },
	{ 23, 2874361 },
	{ 23, 3070969 },
	{ 23, 3136505 },
	{ 24, 5954553 },
	{ 24, 6020089 },
	{ 24, 6216697 },
	{ 24, 6282233 },
	{ 24, 8051705 },
	{ 24, 8117241 },
	{ 24, 8313849 },
	{ 24, 8379385 },
	{ 25, 16146173 },
	{ 25, 15097597 },
	{ 25, 11951869 },
	{ 25, 10903293 },
	{ 24, 7757565 },
	{ 24, 6708989 },
	{ 24, 3563261 },
	{ 24, 2514685 },
	{ 22, 1466109 },
	{ 22, 417533 },
	{ 17, 59674 },
	{ 22, 220921 },
	{ 22, 1203961 },
	{ 22, 614137 },
	{ 22, 810745 },
	{ 22, 581369 },
	{ 22, 646905 },
	{ 22, 892669 },
	{ 24, 2350841 },
	{ 24, 2547449 },
	{ 24, 2612985 },
	{ 24, 3645181 },
	{ 25, 4972281 },
	{ 25, 5168889 },
	{ 25, 5234425 },
	{ 25, 7315197 },
	{ 26, 10215161 },
	{ 26, 10411769 },
	{ 26, 10477305 },
	{ 26, 12246777 },
	{ 26, 12312313 },
	{ 26, 12508921 },
	{ 25, 16146429 },
	{ 25, 15097853 },
	{ 25, 11952125 },
	{ 25, 10903549 },
	{ 24, 7757821 },
	{ 24, 6709245 },
	{ 24, 3563517 },
	{ 24, 2514941 },
	{ 22, 1466365 },
	{ 22, 417789 },
	{ 17, 63770 },
	{ 22, 221177 },
	{ 22, 1204217 },
	{ 22, 614393 },
	{ 22, 811001 },
	{ 22, 581625 },
	{ 22, 647161 },
	{ 22, 892925 },
	{ 24, 2351097 },
	{ 24, 2547705 },
	{ 24, 2613241 },
	{ 24, 3645437 },
	{ 25, 4972537 },
	{ 25, 5169145 },
	{ 25, 5234681 },
	{ 25, 7315453 },
	{ 26, 10215417 },
	{ 26, 10412025 },
	{ 26, 10477561 },
	{ 26, 12247033 },
	{ 26, 12312569 },
	{ 26, 12509177 },
	{ 26, 12574713 },
	{ 26, 16752637 },
	{ 27, 48048893 },
	{ 27, 43854589 },
	{ 26, 31271677 },
	{ 26, 27077373 },
	{ 26, 14494461 },
	{ 26, 10300157 },
	{ 24, 6105853 },
	{ 24, 1911549 },
	{ 18, 84378 },
	{ 24, 1649401 },
	{ 24, 5057273 },
	{ 26, 8989433 },
	{ 24, 3484409 },
	{ 24, 6367993 },
	{ 24, 3353337 },
	{ 24, 3615481 },
	{ 24, 6695677 },
	{ 26, 13576953 },
	{ 26, 14363385 },
	{ 26, 14625529 },
	{ 26, 27142909 },
	{ 27, 28257017 },
	{ 27, 29043449 },
	{ 27, 29305593 },
	{ 27, 54405885 },
	{ 28, 57617145 },
	{ 28, 58403577 },
	{ 28, 58665721 },
	{ 28, 65743609 },
	{ 28, 66005753 },
	{ 27, 64826365 },
	{ 27, 60632061 },
	{ 27, 48049149 },
	{ 27, 43854845 },
	{ 26, 31271933 },
	{ 26, 27077629 },
	{ 26, 14494717 },
	{ 26, 10300413 },
	{ 24, 6106109 },
	{ 24, 1911805 },
	{ 18, 88474 },
	{ 24, 1649657 },
	{ 24, 5057529 },
	{ 26, 8989689 },
	{ 24, 3484665 },
	{ 24, 6368249 },
	{ 24, 3353593 },
	{ 24, 3615737 },
	{ 24, 6695933 },
	{ 26, 13577209 },
	{ 26, 14363641 },
	{ 26, 14625785 },
	{ 26, 27143165 },
	{ 27, 28257273 },
	{ 27, 29043705 },
	{ 27, 29305849 },
	{ 27, 54406141 },
	{ 28, 57617401 },
	{ 28, 58403833 },
	{ 28, 58665977 },
	{ 28, 65743865 },
	{ 28, 66006009 },
	{ 28, 66792441 },
	{ 28, 67054585 },
	{ 28, 94973693 },
	{ 28, 86585085 },
	{ 27, 61419261 },
	{ 27, 53030653 },
	{ 27, 27864829 },
	{ 27, 19476221 },
	{ 25, 11087613 },
	{ 25, 2699005 },
	{ 18, 92954 },
	{ 24, 1912569 },
	{ 24, 5844729 },
	{ 26, 9252601 },
	{ 26, 13184761 },
	{ 24, 6631161 },
	{ 24, 7417593 },
	{ 24, 6500089 },
	{ 24, 6762233 },
	{ 24, 7745277 },
	{ 26, 26160889 },
	{ 26, 26947321 },
	{ 26, 27209465 },
	{ 26, 31338237 },
	{ 27, 53423865 },
	{ 27, 54210297 },
	{ 27, 54472441 },
	{ 27, 62795517 },
	{ 28, 107949817 },
	{ 28, 108736249 },
	{ 28, 108998393 },
	{ 28, 116076281 },
	{ 28, 116338425 },
	{ 28, 117124857 },
	{ 28, 117387001 },
	{ 28, 134098685 },
	{ 27, 61419517 },
	{ 27, 53030909 },
	{ 27, 27865085 },
	{ 27, 19476477 },
	{ 25, 11087869 },
	{ 25, 2699261 },
	{ 18, 97050 },
	{ 24, 1912825 },
	{ 24, 5844985 },
	{ 26, 9252857 },
	{ 26, 13185017 },
	{ 24, 6631417 },
	{ 24, 7417849 },
	{ 24, 6500345 },
	{ 24, 6762489 },
	{ 24, 7745533 },
	{ 26, 26161145 },
	{ 26, 26947577 },
	{ 26, 27209721 },
	{ 26, 31338493 },
	{ 27, 53424121 },
	{ 27, 54210553 },
	{ 27, 54472697 },
	{ 27, 62795773 },
	{ 28, 107950073 },
	{ 28, 108736505 },
	{ 28, 108998649 },
	{ 28, 116076537 },
	{ 28, 116338681 },
	{ 28, 117125113 },
	{ 28, 117387257 },
	{ 28, 86850301 },
	{ 27, 61684477 },
	{ 27, 53295869 },
	{ 27, 28130045 },
	{ 27, 19741437 },
	{ 25, 11352829 },
	{ 25, 2964221 },
	{ 18, 117658 },
	{ 25, 2702073 },
	{ 24, 6109945 },
	{ 25, 12124155 },
	{ 26, 13449977 },
	{ 26, 25770745 },
	{ 24, 7682809 },
	{ 25, 10566393 },
	{ 24, 7551737 },
	{ 24, 7813881 },
	{ 25, 10894077 },
	{ 26, 30358265 },
	{ 26, 31144697 },
	{ 26, 31406841 },
	{ 27, 61553401 },
	{ 27, 61815545 },
	{ 27, 62601977 },
	{ 27, 62864121 },
	{ 28, 124467961 },
	{ 28, 124730105 },
	{ 28, 125516537 },
	{ 28, 125778681 },
	{ 28, 132856569 },
	{ 28, 133118713 },
	{ 28, 133905145 },
	{ 28, 134167289 },
	{ 27, 61684733 },
	{ 27, 53296125 },
	{ 27, 28130301 },
	{ 27, 19741693 },
	{ 25, 11353085 },
	{ 25, 2964477 },
	{ 18, 121754 },
	{ 25, 2702329 },
	{ 24, 6110201 },
	{ 25, 12123899 },
	{ 26, 13450233 },
	{ 26, 25771001 },
	{ 24, 7683065 },
	{ 25, 10566649 },
	{ 24, 7551993 },
	{ 24, 7814137 },
	{ 25, 10894333 },
	{ 26, 30358521 },
	{ 26, 31144953 },
	{ 26, 31407097 },
	{ 27, 61553657 },
	{ 27, 61815801 },
	{ 27, 62602233 },
	{ 27, 62864377 },
	{ 28, 124468217 },
	{ 28, 124730361 },
	{ 28, 125516793 },
	{ 28, 125778937 },
	{ 28, 132856825 },
	{ 28, 133118969 },
	{ 28, 133905401 },
	{ 28, 134167545 },
	{ 27, 62471933 },
	{ 27, 54083325 },
	{ 27, 28917501 },
	{ 27, 20528893 },
	{ 25, 12140285 },
	{ 25, 3751677 },
	{ 19, 251162 },
	{ 25, 2965241 },
	{ 25, 11091705 },
	{ 26, 10305273 },
	{ 26, 14237433 },
	{ 26, 26033913 },
	{ 26, 29966073 },
	{ 25, 10829561 },
	{ 25, 11615993 },
	{ 25, 10698489 },
	{ 25, 10960633 },
	{ 25, 11943677 },
	{ 26, 23002111 },
	{ 27, 43728633 },
	{ 27, 43990777 },
	{ 27, 48119549 },
	{ 28, 86982393 },
	{ 28, 87768825 },
	{ 28, 88030969 },
	{ 28, 96354045 },
	{ 29, 175062777 },
	{ 29, 175849209 },
	{ 28, 129581053 },
	{ 28, 121192445 },
	{ 28, 96026621 },
	{ 28, 87638013 },
	{ 27, 62472189 },
	{ 27, 54083581 },
	{ 27, 28917757 },
	{ 27, 20529149 },
	{ 25, 12140541 },
	{ 25, 3751933 },
	{ 19, 259354 },
	{ 25, 2965497 },
	{ 25, 11091961 },
	{ 26, 10305529 },
	{ 26, 14237689 },
	{ 26, 26034169 },
	{ 26, 29966329 },
	{ 25, 10829817 },
	{ 25, 11616249 },
	{ 25, 10698745 },
	{ 25, 10960889 },
	{ 25, 11943933 },
	{ 26, 23001855 },
	{ 27, 43728889 },
	{ 27, 43991033 },
	{ 27, 48119805 },
	{ 28, 86982649 },
	{ 28, 87769081 },
	{ 28, 88031225 },
	{ 28, 96354301 },
	{ 29, 175063033 },
	{ 29, 175849465 },
	{ 28, 129854205 },
	{ 28, 121465597 },
	{ 28, 96299773 },
	{ 28, 87911165 },
	{ 27, 62745341 },
	{ 27, 54356733 },
	{ 27, 29190909 },
	{ 27, 20802301 },
	{ 25, 12413693 },
	{ 25, 4025085 },
	{ 20, 431514 },
	{ 25, 3762937 },
	{ 25, 11365113 },
	{ 26, 22605819 },
	{ 26, 14510841 },
	{ 26, 26831609 },
	{ 26, 30239481 },
	{ 27, 42560249 },
	{ 25, 11889401 },
	{ 25, 14772985 },
	{ 25, 11758329 },
	{ 25, 12020473 },
	{ 25, 15100669 },
	{ 26, 24571903 },
	{ 27, 47934201 },
	{ 27, 48196345 },
	{ 27, 60713725 },
	{ 28, 95382265 },
	{ 28, 96168697 },
	{ 28, 96430841 },
	{ 28, 121531133 },
	{ 29, 191851257 },
	{ 28, 129854461 },
	{ 28, 121465853 },
	{ 28, 96300029 },
	{ 28, 87911421 },
	{ 27, 62745597 },
	{ 27, 54356989 },
	{ 27, 29191165 },
	{ 27, 20802557 },
	{ 25, 12413949 },
	{ 25, 4025341 },
	{ 20, 439706 },
	{ 25, 3763193 },
	{ 25, 11365369 },
	{ 26, 22605563 },
	{ 26, 14511097 },
	{ 26, 26831865 },
	{ 26, 30239737 },
	{ 27, 42560505 },
	{ 25, 11889657 },
	{ 25, 14773241 },
	{ 25, 11758585 },
	{ 25, 12020729 },
	{ 25, 15100925 },
	{ 26, 24571647 },
	{ 27, 47934457 },
	{ 27, 48196601 },
	{ 27, 60713981 },
	{ 28, 95382521 },
	{ 28, 96168953 },
	{ 28, 96431097 },
	{ 28, 121531389 },
	{ 29, 191851513 },
	{ 29, 259812345 },
	{ 29, 250113017 },
	{ 29, 200043513 },
	{ 29, 184052729 },
	{ 28, 133983225 },
	{ 28, 107572989 },
	{ 28, 57241341 },
	{ 28, 40464125 },
	{ 26, 23686909 },
	{ 26, 6909693 },
	{ 20, 448282 },
	{ 25, 4026105 },
	{ 25, 12152569 },
	{ 26, 24177659 },
	{ 27, 27881209 },
	{ 26, 27094777 },
	{ 26, 31026937 },
	{ 27, 42823417 },
	{ 27, 46755577 },
	{ 25, 15036153 },
	{ 25, 15822585 },
	{ 25, 14905081 },
	{ 25, 15167225 },
	{ 25, 16150269 },
	{ 26, 25095167 },
	{ 27, 60518137 },
	{ 27, 60780281 },
	{ 27, 64909053 },
	{ 28, 120549113 },
	{ 28, 121335545 },
	{ 28, 121597689 },
	{ 28, 129920765 },
	{ 29, 259550969 },
	{ 29, 243035897 },
	{ 29, 199782137 },
	{ 29, 183267065 },
	{ 28, 133721849 },
	{ 28, 117206777 },
	{ 28, 57241597 },
	{ 28, 40464381 },
	{ 26, 23687165 },
	{ 26, 6909949 },
	{ 20, 456474 },
	{ 25, 4026361 },
	{ 25, 12152825 },
	{ 26, 24177403 },
	{ 27, 27881465 },
	{ 26, 27095033 },
	{ 26, 31027193 },
	{ 27, 42823673 },
	{ 27, 46755833 },
	{ 25, 15036409 },
	{ 25, 15822841 },
	{ 25, 14905337 },
	{ 25, 15167481 },
	{ 25, 16150525 },
	{ 26, 25094911 },
	{ 27, 60518393 },
	{ 27, 60780537 },
	{ 27, 64909309 },
	{ 28, 120549369 },
	{ 28, 121335801 },
	{ 28, 121597945 },
	{ 28, 129921021 },
	{ 29, 259551225 },
	{ 29, 243036153 },
	{ 29, 199782393 },
	{ 29, 183267321 },
	{ 28, 133722105 },
	{ 28, 117207033 },
	{ 28, 57506557 },
	{ 28, 40729341 },
	{ 26, 23952125 },
	{ 26, 7174909 },
	{ 20, 497562 },
	{ 20, 1046510 },
	{ 25, 12417785 },
	{ 26, 24690683 },
	{ 27, 28146425 },
	{ 27, 53050105 },
	{ 26, 31292153 },
	{ 27, 43612921 },
	{ 27, 47020793 },
	{ 27, 59341561 },
	{ 25, 16087801 },
	{ 26, 27359993 },
	{ 25, 15956729 },
	{ 25, 16218873 },
	{ 26, 27687677 },
	{ 27, 63929081 },
	{ 27, 64715513 },
	{ 27, 64977657 },
	{ 28, 128678649 },
	{ 28, 128940793 },
	{ 28, 129727225 },
	{ 28, 129989369 },
	{ 29, 258767609 },
	{ 29, 242776825 },
	{ 29, 192707321 },
	{ 29, 183007993 },
	{ 28, 132938489 },
	{ 28, 116947705 },
	{ 28, 66878201 },
	{ 28, 40729597 },
	{ 26, 23952381 },
	{ 26, 7175165 },
	{ 20, 505754 },
	{ 20, 1038318 },
	{ 25, 12418041 },
	{ 26, 24690427 },
	{ 27, 28146681 },
	{ 27, 53050361 },
	{ 26, 31292409 },
	{ 27, 43613177 },
	{ 27, 47021049 },
	{ 27, 59341817 },
	{ 25, 16088057 },
	{ 26, 27360249 },
	{ 25, 15956985 },
	{ 25, 16219129 },
	{ 26, 27687933 },
	{ 27, 63929337 },
	{ 27, 64715769 },
	{ 27, 64977913 },
	{ 28, 128678905 },
	{ 28, 128941049 },
	{ 28, 129727481 },
	{ 28, 129989625 },
	{ 29, 258767865 },
	{ 29, 242777081 },
	{ 29, 192707577 },
	{ 29, 183008249 },
	{ 28, 132938745 },
	{ 28, 116947961 },
	{ 28, 66878457 },
	{ 28, 41516797 },
	{ 26, 24739581 },
	{ 26, 7962365 },
	{ 21, 1027354 },
	{ 21, 2059630 },
	{ 26, 23691001 },
	{ 27, 20807417 },
	{ 27, 28933881 },
	{ 27, 53313273 },
	{ 27, 61439737 },
	{ 27, 43876089 },
	{ 27, 47808249 },
	{ 27, 59604729 },
	{ 27, 63536889 },
	{ 26, 27623161 },
	{ 26, 28409593 },
	{ 26, 27492089 },
	{ 26, 27754233 },
	{ 26, 28737277 },
	{ 27, 48151551 },
	{ 28, 245137145 },
	{ 28, 111116025 },
	{ 28, 115244797 },
	{ 29, 230194937 },
	{ 29, 222068473 },
	{ 29, 258506489 },
	{ 29, 241991417 },
	{ 29, 192446201 },
	{ 29, 175931129 },
	{ 28, 132677369 },
	{ 28, 116162297 },
	{ 28, 66617081 },
	{ 28, 50102009 },
	{ 26, 24739837 },
	{ 26, 7962621 },
	{ 21, 1043738 },
	{ 21, 2043246 },
	{ 26, 23691257 },
	{ 27, 20807673 },
	{ 27, 28934137 },
	{ 27, 53313529 },
	{ 27, 61439993 },
	{ 27, 43876345 },
	{ 27, 47808505 },
	{ 27, 59604985 },
	{ 27, 63537145 },
	{ 26, 27623417 },
	{ 26, 28409849 },
	{ 26, 27492345 },
	{ 26, 27754489 },
	{ 26, 28737533 },
	{ 27, 48151295 },
	{ 28, 245137401 },
	{ 28, 111116281 },
	{ 28, 115245053 },
	{ 29, 230195193 },
	{ 29, 222068729 },
	{ 29, 258506745 },
	{ 29, 241991673 },
	{ 29, 192446457 },
	{ 29, 175931385 },
	{ 28, 132677625 },
	{ 28, 116162553 },
	{ 28, 66617337 },
	{ 28, 50102265 },
	{ 27, 49982205 },
	{ 27, 16427773 },
	{ 21, 1912218 },
	{ 21, 1961454 },
	{ 27, 47885049 },
	{ 27, 47755259 },
	{ 28, 58370809 },
	{ 28, 108178169 },
	{ 28, 123382521 },
	{ 28, 123252731 },
	{ 28, 96119545 },
	{ 28, 120761081 },
	{ 28, 127576825 },
	{ 27, 66890489 },
	{ 27, 33336057 },
	{ 27, 63089401 },
	{ 27, 132688633 },
	{ 27, 57584377 },
	{ 27, 63744765 },
	{ 27, 49721343 },
	{ 29, 263760633 },
	{ 29, 230599417 },
	{ 29, 255634173 },
	{ 29, 251047935 },
	{ 29, 259566329 },
	{ 29, 259698683 },
	{ 30, 383298297 },
	{ 30, 351316729 },
	{ 29, 251177721 },
	{ 29, 231779065 },
	{ 29, 131640057 },
	{ 29, 99658489 },
	{ 27, 66628345 },
	{ 27, 16428029 },
	{ 21, 1916906 },
	{ 21, 1945070 },
	{ 27, 47885305 },
	{ 27, 47755003 },
	{ 28, 58371065 },
	{ 28, 108178425 },
	{ 28, 123382777 },
	{ 28, 123252475 },
	{ 28, 96119801 },
	{ 28, 120761337 },
	{ 28, 127577081 },
	{ 27, 66890745 },
	{ 27, 33336313 },
	{ 27, 63089657 },
	{ 27, 132688889 },
	{ 27, 57584633 },
	{ 27, 63745021 },
	{ 27, 49721087 },
	{ 29, 263760889 },
	{ 29, 230599673 },
	{ 29, 255634429 },
	{ 29, 251047679 },
	{ 29, 259566585 },
	{ 29, 259698427 },
	{ 30, 383298553 },
	{ 30, 351316985 },
	{ 29, 251177977 },
	{ 29, 231779321 },
	{ 29, 131640313 },
	{ 29, 99658745 },
	{ 27, 66628601 },
	{ 27, 30584573 },
	{ 21, 1933290 },
	{ 21, 1929070 },
	{ 27, 49458937 },
	{ 27, 49327099 },
	{ 29, 114470649 },
	{ 28, 108703481 },
	{ 28, 124956409 },
	{ 28, 124824571 },
	{ 29, 267693817 },
	{ 28, 121286393 },
	{ 28, 129150713 },
	{ 27, 67022589 },
	{ 27, 66367225 },
	{ 27, 32812793 },
	{ 27, 132165369 },
	{ 27, 130592505 },
	{ 27, 63876857 },
	{ 27, 65842941 },
	{ 27, 50244607 },
	{ 29, 255373049 },
	{ 29, 255766265 },
	{ 29, 264023805 },
	{ 29, 259043065 },
	{ 29, 242790137 },
	{ 29, 242920443 },
	{ 30, 349744889 },
	{ 29, 250654457 },
	{ 29, 217624313 },
	{ 29, 131116793 },
	{ 29, 98086649 },
	{ 27, 66105081 },
	{ 27, 33074937 },
	{ 21, 1949546 },
	{ 21, 1912686 },
	{ 27, 49459193 },
	{ 27, 49326843 },
	{ 29, 114470905 },
	{ 28, 108703737 },
	{ 28, 124956665 },
	{ 28, 124824315 },
	{ 29, 267694073 },
	{ 28, 121286649 },
	{ 28, 129150969 },
	{ 27, 67022845 },
	{ 27, 66367481 },
	{ 27, 32813049 },
	{ 27, 132165625 },
	{ 27, 130592761 },
	{ 27, 63877113 },
	{ 27, 65843197 },
	{ 27, 50244351 },
	{ 29, 255373305 },
	{ 29, 255766521 },
	{ 29, 264024061 },
	{ 29, 259043321 },
	{ 29, 242790393 },
	{ 29, 242920187 },
	{ 29, 200048639 },
	{ 29, 250654713 },
	{ 28, 132939775 },
	{ 28, 116162559 },
	{ 28, 65830911 },
	{ 27, 66105337 },
	{ 26, 32276479 },
	{ 21, 1965930 },
	{ 21, 1044462 },
	{ 26, 15237115 },
	{ 26, 24936443 },
	{ 28, 41451515 },
	{ 28, 57442299 },
	{ 28, 125483769 },
	{ 27, 62685179 },
	{ 28, 87588859 },
	{ 28, 95191035 },
	{ 28, 129678073 },
	{ 27, 64782331 },
	{ 27, 66501373 },
	{ 26, 65437695 },
	{ 26, 62357499 },
	{ 26, 32800763 },
	{ 26, 60850171 },
	{ 26, 8290299 },
	{ 26, 25067515 },
	{ 26, 32210943 },
	{ 28, 58621947 },
	{ 28, 108953595 },
	{ 28, 125730811 },
	{ 28, 128811003 },
	{ 28, 121208827 },
	{ 28, 96305147 },
	{ 29, 249084665 },
	{ 28, 124616699 },
	{ 28, 108625915 },
	{ 28, 58556411 },
	{ 27, 64535289 },
	{ 26, 32342011 },
	{ 21, 2047466 },
	{ 21, 1028078 },
	{ 26, 15236859 },
	{ 26, 24936187 },
	{ 28, 41451259 },
	{ 28, 57442043 },
	{ 28, 125484025 },
	{ 27, 62684923 },
	{ 28, 87588603 },
	{ 28, 95190779 },
	{ 28, 129678329 },
	{ 27, 64782075 },
	{ 27, 66501629 },
	{ 26, 65437439 },
	{ 26, 62357243 },
	{ 26, 32800507 },
	{ 26, 60849915 },
	{ 26, 8290043 },
	{ 26, 25067259 },
	{ 26, 32210687 },
	{ 28, 58621691 },
	{ 28, 108953339 },
	{ 28, 125730555 },
	{ 28, 128810747 },
	{ 28, 121208571 },
	{ 28, 96304891 },
	{ 29, 249084921 },
	{ 28, 124616443 },
	{ 28, 108625659 },
	{ 28, 58556155 },
	{ 27, 64535545 },
	{ 26, 32341755 },
	{ 21, 2063850 },
	{ 21, 1015150 },
	{ 26, 15498235 },
	{ 26, 32013307 },
	{ 28, 41712635 },
	{ 28, 58227707 },
	{ 28, 107772923 },
	{ 28, 124287995 },
	{ 28, 87849979 },
	{ 28, 95976443 },
	{ 28, 120355835 },
	{ 28, 128482299 },
	{ 28, 110918651 },
	{ 27, 64929533 },
	{ 26, 62290943 },
	{ 26, 61307899 },
	{ 26, 61111291 },
	{ 26, 61897723 },
	{ 26, 15367163 },
	{ 26, 32144379 },
	{ 26, 32472063 },
	{ 28, 65698811 },
	{ 28, 116030459 },
	{ 28, 132807675 },
	{ 28, 120421371 },
	{ 28, 96041979 },
	{ 28, 87915515 },
	{ 28, 124353531 },
	{ 28, 107838459 },
	{ 28, 58293243 },
	{ 27, 64012025 },
	{ 26, 32078843 },
	{ 21, 2080106 },
	{ 21, 998766 },
	{ 26, 15497979 },
	{ 26, 32013051 },
	{ 28, 41712379 },
	{ 28, 58227451 },
	{ 28, 107772667 },
	{ 28, 124287739 },
	{ 28, 87849723 },
	{ 28, 95976187 },
	{ 28, 120355579 },
	{ 28, 128482043 },
	{ 28, 110918395 },
	{ 27, 64929789 },
	{ 26, 62290687 },
	{ 26, 61307643 },
	{ 26, 61111035 },
	{ 26, 61897467 },
	{ 26, 15366907 },
	{ 26, 32144123 },
	{ 26, 32471807 },
	{ 28, 65698555 },
	{ 28, 116030203 },
	{ 28, 132807419 },
	{ 28, 120421115 },
	{ 28, 96041723 },
	{ 28, 87915259 },
	{ 28, 124353275 },
	{ 28, 107838203 },
	{ 28, 58292987 },
	{ 27, 64012281 },
	{ 26, 32078587 },
	{ 21, 2096490 },
	{ 21, 916974 },
	{ 26, 16281595 },
	{ 26, 32272379 },
	{ 28, 48787451 },
	{ 28, 58486779 },
	{ 28, 108556283 },
	{ 28, 124547067 },
	{ 29, 192604921 },
	{ 28, 96235515 },
	{ 28, 121139195 },
	{ 28, 128741371 },
	{ 28, 132083707 },
	{ 28, 115109883 },
	{ 27, 64416509 },
	{ 26, 61239295 },
	{ 26, 32993275 },
	{ 26, 62156795 },
	{ 26, 65040379 },
	{ 26, 15626235 },
	{ 26, 32403451 },
	{ 26, 33255423 },
	{ 28, 129559289 },
	{ 27, 64843771 },
	{ 28, 133066747 },
	{ 28, 95252475 },
	{ 28, 125364985 },
	{ 27, 62746619 },
	{ 28, 107573243 },
	{ 28, 57503739 },
	{ 27, 49867513 },
	{ 26, 24997883 },
	{ 26, 15298555 },
	{ 21, 900590 },
	{ 26, 16281339 },
	{ 26, 32272123 },
	{ 28, 48787195 },
	{ 28, 58486523 },
	{ 28, 108556027 },
	{ 28, 124546811 },
	{ 29, 192605177 },
	{ 28, 96235259 },
	{ 28, 121138939 },
	{ 28, 128741115 },
	{ 28, 132083451 },
	{ 28, 115109627 },
	{ 27, 64416765 },
	{ 26, 61239039 },
	{ 26, 32993019 },
	{ 26, 62156539 },
	{ 26, 65040123 },
	{ 26, 15625979 },
	{ 26, 32403195 },
	{ 26, 33255167 },
	{ 28, 129559545 },
	{ 27, 64843515 },
	{ 28, 133066491 },
	{ 28, 95252219 },
	{ 28, 125365241 },
	{ 27, 62746363 },
	{ 28, 107572987 },
	{ 28, 57503483 },
	{ 27, 49867769 },
	{ 26, 24997627 },
	{ 26, 15298299 },
	{ 21, 884590 },
	{ 26, 16542715 },
	{ 26, 33057787 },
	{ 28, 49048571 },
	{ 28, 65563643 },
	{ 28, 108817403 },
	{ 28, 125332475 },
	{ 29, 174877691 },
	{ 29, 242937593 },
	{ 28, 121400315 },
	{ 28, 129526779 },
	{ 28, 132017151 },
	{ 28, 127888379 },
	{ 28, 127691771 },
	{ 27, 50261757 },
	{ 26, 32926719 },
	{ 26, 31943675 },
	{ 26, 65301499 },
	{ 26, 66087931 },
	{ 26, 16411643 },
	{ 26, 33188859 },
	{ 26, 33516543 },
	{ 27, 64580603 },
	{ 27, 60648443 },
	{ 28, 133852155 },
	{ 28, 124841721 },
	{ 27, 62483451 },
	{ 27, 54356987 },
	{ 28, 57240571 },
	{ 27, 49344249 },
	{ 26, 24734715 },
	{ 26, 8219643 },
	{ 21, 868206 },
	{ 26, 16542459 },
	{ 26, 33057531 },
	{ 28, 49048315 },
	{ 28, 65563387 },
	{ 28, 108817147 },
	{ 28, 125332219 },
	{ 29, 174877435 },
	{ 29, 242937849 },
	{ 28, 121400059 },
	{ 28, 129526523 },
	{ 28, 132016895 },
	{ 28, 127888123 },
	{ 28, 127691515 },
	{ 27, 50262013 },
	{ 26, 32926463 },
	{ 26, 31943419 },
	{ 26, 65301243 },
	{ 26, 66087675 },
	{ 26, 16411387 },
	{ 26, 33188603 },
	{ 26, 33516287 },
	{ 27, 64580347 },
	{ 27, 60648187 },
	{ 28, 133851899 },
	{ 28, 124841977 },
	{ 27, 62483195 },
	{ 27, 54356731 },
	{ 28, 57240315 },
	{ 27, 49344505 },
	{ 26, 24734459 },
	{ 26, 8219387 },
	{ 20, 524270 },
	{ 26, 15297279 },
	{ 26, 33308667 },
	{ 28, 49823739 },
	{ 28, 65814523 },
	{ 28, 115884027 },
	{ 28, 125583355 },
	{ 29, 175652859 },
	{ 29, 191643643 },
	{ 29, 259717881 },
	{ 28, 129777659 },
	{ 29, 251067133 },
	{ 28, 127811583 },
	{ 28, 115294203 },
	{ 28, 131874811 },
	{ 27, 49740541 },
	{ 26, 31866879 },
	{ 26, 28786683 },
	{ 26, 66338811 },
	{ 26, 31539195 },
	{ 26, 16662523 },
	{ 26, 33439739 },
	{ 27, 63782907 },
	{ 27, 60375035 },
	{ 27, 48054267 },
	{ 28, 123271929 },
	{ 27, 61685755 },
	{ 27, 54083579 },
	{ 27, 29179899 },
	{ 27, 47774457 },
	{ 26, 23937019 },
	{ 26, 7946235 },
	{ 20, 507886 },
	{ 26, 8208383 },
	{ 26, 33308411 },
	{ 28, 49823483 },
	{ 28, 65814267 },
	{ 28, 115883771 },
	{ 28, 125583099 },
	{ 29, 175652603 },
	{ 29, 191643387 },
	{ 29, 259718137 },
	{ 28, 129777403 },
	{ 29, 251067389 },
	{ 28, 127811327 },
	{ 28, 115293947 },
	{ 28, 131874555 },
	{ 27, 49740797 },
	{ 26, 31866623 },
	{ 26, 28786427 },
	{ 26, 66338555 },
	{ 26, 31538939 },
	{ 26, 16662267 },
	{ 26, 33439483 },
	{ 27, 63782651 },
	{ 27, 60374779 },
	{ 27, 48054011 },
	{ 28, 123272185 },
	{ 27, 61685499 },
	{ 27, 54083323 },
	{ 27, 29179643 },
	{ 27, 47774713 },
	{ 26, 23936763 },
	{ 26, 7945979 },
	{ 20, 503198 },
	{ 26, 8208127 },
	{ 26, 24985343 },
	{ 28, 50084859 },
	{ 28, 66599931 },
	{ 28, 116145147 },
	{ 28, 132660219 },
	{ 29, 175913979 },
	{ 29, 192429051 },
	{ 29, 241974267 },
	{ 29, 258489339 },
	{ 29, 222051323 },
	{ 29, 249495293 },
	{ 28, 115227647 },
	{ 28, 111098875 },
	{ 28, 245119995 },
	{ 27, 48168701 },
	{ 26, 28720127 },
	{ 26, 27737083 },
	{ 26, 27474939 },
	{ 26, 28392443 },
	{ 26, 27606011 },
	{ 27, 63519739 },
	{ 27, 59587579 },
	{ 27, 47791099 },
	{ 27, 43858939 },
	{ 27, 61422587 },
	{ 27, 53296123 },
	{ 27, 28916731 },
	{ 27, 47251193 },
	{ 26, 23673851 },
	{ 26, 7158779 },
	{ 20, 486686 },
	{ 26, 7945215 },
	{ 26, 24722431 },
	{ 28, 50084603 },
	{ 28, 66599675 },
	{ 28, 116144891 },
	{ 28, 132659963 },
	{ 29, 175913723 },
	{ 29, 192428795 },
	{ 29, 241974011 },
	{ 29, 258489083 },
	{ 29, 222051067 },
	{ 29, 249495549 },
	{ 28, 115227391 },
	{ 28, 111098619 },
	{ 28, 245119739 },
	{ 27, 48168957 },
	{ 26, 28719871 },
	{ 26, 27736827 },
	{ 26, 27474683 },
	{ 26, 28392187 },
	{ 26, 27605755 },
	{ 27, 63519483 },
	{ 27, 59587323 },
	{ 27, 47790843 },
	{ 27, 43858683 },
	{ 27, 61422331 },
	{ 27, 53295867 },
	{ 27, 28916475 },
	{ 27, 47251449 },
	{ 26, 23673595 },
	{ 26, 7158523 },
	{ 20, 470302 },
	{ 26, 7944959 },
	{ 26, 24722175 },
	{ 28, 41499391 },
	{ 28, 66859003 },
	{ 28, 116928507 },
	{ 28, 132919291 },
	{ 29, 182988795 },
	{ 29, 192688123 },
	{ 29, 242757627 },
	{ 29, 258748411 },
	{ 28, 129970171 },
	{ 28, 129708027 },
	{ 28, 128921595 },
	{ 28, 128659451 },
	{ 27, 64958459 },
	{ 27, 64696315 },
	{ 27, 63909883 },
	{ 26, 27668479 },
	{ 25, 16199675 },
	{ 25, 15937531 },
	{ 26, 27340795 },
	{ 25, 16068603 },
	{ 27, 59322363 },
	{ 27, 47001595 },
	{ 27, 43593723 },
	{ 26, 31272955 },
	{ 27, 53030907 },
	{ 27, 28127227 },
	{ 27, 49392377 },
	{ 25, 12398587 },
	{ 26, 6893563 },
	{ 19, 194462 },
	{ 26, 7155711 },
	{ 26, 23932927 },
	{ 28, 40710143 },
	{ 28, 66858747 },
	{ 28, 116928251 },
	{ 28, 132919035 },
	{ 29, 182988539 },
	{ 29, 192687867 },
	{ 29, 242757371 },
	{ 29, 258748155 },
	{ 28, 129969915 },
	{ 28, 129707771 },
	{ 28, 128921339 },
	{ 28, 128659195 },
	{ 27, 64958203 },
	{ 27, 64696059 },
	{ 27, 63909627 },
	{ 26, 27668223 },
	{ 25, 16199419 },
	{ 25, 15937275 },
	{ 26, 27340539 },
	{ 25, 16068347 },
	{ 27, 59322107 },
	{ 27, 47001339 },
	{ 27, 43593467 },
	{ 26, 31272699 },
	{ 27, 53030651 },
	{ 27, 28126971 },
	{ 27, 49392633 },
	{ 25, 12398331 },
	{ 26, 6893307 },
	{ 19, 186270 },
	{ 26, 7155455 },
	{ 26, 23932671 },
	{ 28, 40709887 },
	{ 28, 57487103 },
	{ 28, 117189627 },
	{ 28, 133704699 },
	{ 29, 183249915 },
	{ 29, 199764987 },
	{ 29, 243018747 },
	{ 29, 259533819 },
	{ 28, 129903615 },
	{ 28, 121580539 },
	{ 28, 121318395 },
	{ 28, 120531963 },
	{ 27, 64891903 },
	{ 27, 60763131 },
	{ 27, 60500987 },
	{ 27, 50179837 },
	{ 25, 16133119 },
	{ 25, 15150075 },
	{ 25, 14887931 },
	{ 25, 15805435 },
	{ 25, 15019003 },
	{ 27, 46738427 },
	{ 27, 42806267 },
	{ 26, 31009787 },
	{ 26, 27077627 },
	{ 27, 27864059 },
	{ 27, 48344825 },
	{ 25, 12135419 },
	{ 25, 4008955 },
	{ 19, 177950 },
	{ 26, 6892543 },
	{ 26, 23669759 },
	{ 28, 40446975 },
	{ 28, 57224191 },
	{ 28, 117189371 },
	{ 28, 133704443 },
	{ 29, 183249659 },
	{ 29, 199764731 },
	{ 29, 243018491 },
	{ 29, 259533563 },
	{ 28, 129903359 },
	{ 28, 121580283 },
	{ 28, 121318139 },
	{ 28, 120531707 },
	{ 27, 64891647 },
	{ 27, 60762875 },
	{ 27, 60500731 },
	{ 27, 50180093 },
	{ 25, 16132863 },
	{ 25, 15149819 },
	{ 25, 14887675 },
	{ 25, 15805179 },
	{ 25, 15018747 },
	{ 27, 46738171 },
	{ 27, 42806011 },
	{ 26, 31009531 },
	{ 26, 27077371 },
	{ 27, 27863803 },
	{ 27, 48345081 },
	{ 25, 12135163 },
	{ 25, 4008699 },
	{ 19, 169758 },
	{ 26, 6892287 },
	{ 26, 23669503 },
	{ 28, 40446719 },
	{ 27, 62889983 },
	{ 27, 50323451 },
	{ 26, 33497083 },
	{ 27, 46014459 },
	{ 27, 50012155 },
	{ 27, 62529531 },
	{ 27, 64954363 },
	{ 27, 47964155 },
	{ 26, 30384127 },
	{ 26, 24109051 },
	{ 26, 24043515 },
	{ 26, 23846907 },
	{ 25, 15179775 },
	{ 25, 12050427 },
	{ 25, 11984891 },
	{ 25, 11788283 },
	{ 23, 3776511 },
	{ 23, 3006459 },
	{ 23, 2940923 },
	{ 23, 3694587 },
	{ 23, 2973691 },
	{ 25, 10641403 },
	{ 24, 7561211 },
	{ 24, 6709243 },
	{ 24, 3629051 },
	{ 25, 4874235 },
	{ 23, 2842619 },
	{ 23, 942075 },
	{ 18, 128414 },
	{ 23, 1007615 },
	{ 23, 3104767 },
	{ 25, 5201919 },
	{ 25, 7299071 },
	{ 25, 13590527 },
	{ 25, 15687679 },
	{ 26, 21979135 },
	{ 26, 24076287 },
	{ 26, 30367743 },
	{ 26, 32464895 },
	{ 27, 47963899 },
	{ 26, 30383871 },
	{ 26, 24108795 },
	{ 26, 24043259 },
	{ 26, 23846651 },
	{ 25, 15179519 },
	{ 25, 12050171 },
	{ 25, 11984635 },
	{ 25, 11788027 },
	{ 23, 3776255 },
	{ 23, 3006203 },
	{ 23, 2940667 },
	{ 23, 3694331 },
	{ 23, 2973435 },
	{ 25, 10641147 },
	{ 24, 7560955 },
	{ 24, 6708987 },
	{ 24, 3628795 },
	{ 25, 4873979 },
	{ 23, 2842363 },
	{ 23, 941819 },
	{ 18, 120222 },
	{ 23, 1007359 },
	{ 23, 3104511 },
	{ 25, 5201663 },
	{ 25, 7298815 },
	{ 25, 13590271 },
	{ 25, 15687423 },
	{ 26, 21978879 },
	{ 26, 24076031 },
	{ 26, 30367487 },
	{ 26, 32464639 },
	{ 27, 43965435 },
	{ 27, 43768827 },
	{ 26, 24091647 },
	{ 26, 22010875 },
	{ 26, 21945339 },
	{ 26, 21748731 },
	{ 25, 12033023 },
	{ 25, 11000827 },
	{ 25, 10935291 },
	{ 25, 10738683 },
	{ 23, 2989055 },
	{ 23, 2743291 },
	{ 23, 2677755 },
	{ 23, 2907131 },
	{ 23, 2710523 },
	{ 24, 7494651 },
	{ 24, 6511611 },
	{ 24, 3562491 },
	{ 24, 2579451 },
	{ 23, 2776059 },
	{ 23, 744443 },
	{ 18, 111902 },
	{ 23, 941055 },
	{ 23, 3038207 },
	{ 25, 5135359 },
	{ 25, 7232511 },
	{ 25, 13523967 },
	{ 25, 15621119 },
	{ 26, 21912575 },
	{ 26, 24009727 },
	{ 26, 30301183 },
	{ 26, 32398335 },
	{ 27, 43965179 },
	{ 27, 43768571 },
	{ 26, 24091391 },
	{ 26, 22010619 },
	{ 26, 21945083 },
	{ 26, 21748475 },
	{ 25, 12032767 },
	{ 25, 11000571 },
	{ 25, 10935035 },
	{ 25, 10738427 },
	{ 23, 2988799 },
	{ 23, 2743035 },
	{ 23, 2677499 },
	{ 23, 2906875 },
	{ 23, 2710267 },
	{ 24, 7494395 },
	{ 24, 6511355 },
	{ 24, 3562235 },
	{ 24, 2579195 },
	{ 23, 2775803 },
	{ 23, 744187 },
	{ 18, 103710 },
	{ 23, 940799 },
	{ 23, 3037951 },
	{ 25, 5135103 },
	{ 25, 7232255 },
	{ 25, 13523711 },
	{ 25, 15620863 },
	{ 26, 33542139 },
	{ 26, 33476603 },
	{ 26, 33279995 },
	{ 26, 33214459 },
	{ 26, 31444987 },
	{ 26, 31379451 },
	{ 26, 31182843 },
	{ 26, 31117307 },
	{ 25, 15716347 },
	{ 25, 15650811 },
	{ 25, 15454203 },
	{ 25, 15388667 },
	{ 24, 7852027 },
	{ 24, 7786491 },
	{ 24, 7589883 },
	{ 23, 2723839 },
	{ 22, 1953787 },
	{ 22, 1888251 },
	{ 23, 2641915 },
	{ 22, 1921019 },
	{ 24, 6443003 },
	{ 24, 3362811 },
	{ 24, 2510843 },
	{ 22, 1527803 },
	{ 23, 675835 },
	{ 17, 31646 },
	{ 23, 741375 },
	{ 23, 2838527 },
	{ 25, 4935679 },
	{ 25, 7032831 },
	{ 25, 13324287 },
	{ 25, 15421439 },
	{ 26, 33541883 },
	{ 26, 33476347 },
	{ 26, 33279739 },
	{ 26, 33214203 },
	{ 26, 31444731 },
	{ 26, 31379195 },
	{ 26, 31182587 },
	{ 26, 31117051 },
	{ 25, 15716091 },
	{ 25, 15650555 },
	{ 25, 15453947 },
	{ 25, 15388411 },
	{ 24, 7851771 },
	{ 24, 7786235 },
	{ 24, 7589627 },
	{ 23, 2723583 },
	{ 22, 1953531 },
	{ 22, 1887995 },
	{ 23, 2641659 },
	{ 22, 1920763 },
	{ 24, 6442747 },
	{ 24, 3362555 },
	{ 24, 2510587 },
	{ 22, 1527547 },
	{ 23, 675579 },
	{ 17, 27550 },
	{ 23, 741119 },
	{ 23, 2838271 },
	{ 25, 4935423 },
	{ 25, 7032575 },
	{ 25, 13324031 },
	{ 25, 15421183 },
	{ 26, 21712639 },
	{ 26, 29346811 },
	{ 26, 29281275 },
	{ 26, 29084667 },
	{ 26, 29019131 },
	{ 26, 27249659 },
	{ 26, 27184123 },
	{ 26, 26987515 },
	{ 25, 15698943 },
	{ 25, 13618171 },
	{ 25, 13552635 },
	{ 25, 13356027 },
	{ 24, 7834623 },
	{ 24, 6802427 },
	{ 24, 6736891 },
	{ 24, 6540283 },
	{ 22, 1936383 },
	{ 22, 1690619 },
	{ 22, 1625083 },
	{ 22, 1854459 },
	{ 22, 1657851 },
	{ 24, 3296251 },
	{ 24, 2313211 },
	{ 22, 1461243 },
	{ 22, 478203 },
	{ 17, 23326 },
	{ 23, 674815 },
	{ 23, 2771967 },
	{ 25, 4869119 },
	{ 25, 6966271 },
	{ 25, 13257727 },
	{ 25, 15354879 },
	{ 26, 33524479 },
	{ 26, 29346555 },
	{ 26, 29281019 },
	{ 26, 29084411 },
	{ 26, 29018875 },
	{ 26, 27249403 },
	{ 26, 27183867 },
	{ 26, 26987259 },
	{ 25, 15698687 },
	{ 25, 13617915 },
	{ 25, 13552379 },
	{ 25, 13355771 },
	{ 24, 7834367 },
	{ 24, 6802171 },
	{ 24, 6736635 },
	{ 24, 6540027 },
	{ 22, 1936127 },
	{ 22, 1690363 },
	{ 22, 1624827 },
	{ 22, 1854203 },
	{ 22, 1657595 },
	{ 24, 3295995 },
	{ 24, 2312955 },
	{ 22, 1460987 },
	{ 22, 477947 },
	{ 17, 19230 },
	{ 23, 674559 },
	{ 23, 2771711 },
	{ 25, 4868863 },
	{ 25, 6966015 },
	{ 25, 13257471 },
	{ 25, 15354623 },
	{ 26, 21646079 },
	{ 24, 7333887 },
	{ 24, 4192251 },
	{ 24, 4175867 },
	{ 24, 4126715 },
	{ 24, 4110331 },
	{ 24, 3667963 },
	{ 24, 3651579 },
	{ 24, 3602427 },
	{ 23, 3401727 },
	{ 23, 1832955 },
	{ 23, 1816571 },
	{ 23, 1767419 },
	{ 22, 1697791 },
	{ 22, 915451 },
	{ 22, 899067 },
	{ 22, 849915 },
	{ 20, 419839 },
	{ 20, 227323 },
	{ 20, 210939 },
	{ 20, 399355 },
	{ 20, 219131 },
	{ 22, 563195 },
	{ 20, 317435 },
	{ 20, 104443 },
	{ 15, 14750 },
	{ 20, 120831 },
	{ 20, 382975 },
	{ 22, 645119 },
	{ 22, 907263 },
	{ 22, 1693695 },
	{ 22, 1955839 },
	{ 23, 2742271 },
	{ 23, 3004415 },
	{ 23, 3790847 },
	{ 23, 4052991 },
	{ 24, 4126459 },
	{ 24, 4110075 },
	{ 24, 3667707 },
	{ 24, 3651323 },
	{ 24, 3602171 },
	{ 23, 3401471 },
	{ 23, 1832699 },
	{ 23, 1816315 },
	{ 23, 1767163 },
	{ 22, 1697535 },
	{ 22, 915195 },
	{ 22, 898811 },
	{ 22, 849659 },
	{ 20, 419583 },
	{ 20, 227067 },
	{ 20, 210683 },
	{ 20, 399099 },
	{ 20, 218875 },
	{ 22, 562939 },
	{ 20, 317179 },
	{ 20, 104187 },
	{ 15, 10654 },
	{ 20, 120575 },
	{ 20, 382719 },
	{ 22, 644863 },
	{ 22, 907007 },
	{ 22, 1693439 },
	{ 22, 1955583 },
	{ 23, 2742015 },
	{ 23, 3004159 },
	{ 23, 3790591 },
	{ 23, 4052735 },
	{ 24, 3126267 },
	{ 24, 3077115 },
	{ 24, 3060731 },
	{ 24, 2618363 },
	{ 24, 2601979 },
	{ 24, 2552827 },
	{ 23, 1827839 },
	{ 23, 1307643 },
	{ 23, 1291259 },
	{ 23, 1242107 },
	{ 22, 910335 },
	{ 22, 652283 },
	{ 22, 635899 },
	{ 22, 586747 },
	{ 20, 222207 },
	{ 20, 160763 },
	{ 20, 144379 },
	{ 20, 201723 },
	{ 20, 152571 },
	{ 20, 300027 },
	{ 20, 54267 },
	{ 15, 6430 },
	{ 20, 103423 },
	{ 20, 365567 },
	{ 22, 627711 },
	{ 22, 889855 },
	{ 22, 1676287 },
	{ 22, 1938431 },
	{ 23, 2724863 },
	{ 23, 2987007 },
	{ 23, 3773439 },
	{ 23, 4035583 },
	{ 24, 3126011 },
	{ 24, 3076859 },
	{ 24, 3060475 },
	{ 24, 2618107 },
	{ 24, 2601723 },
	{ 24, 2552571 },
	{ 23, 1827583 },
	{ 23, 1307387 },
	{ 23, 1291003 },
	{ 23, 1241851 },
	{ 22, 910079 },
	{ 22, 652027 },
	{ 22, 635643 },
	{ 22, 586491 },
	{ 20, 221951 },
	{ 20, 160507 },
	{ 20, 144123 },
	{ 20, 201467 },
	{ 20, 152315 },
	{ 20, 299771 },
	{ 20, 54011 },
	{ 15, 2334 },
	{ 20, 103167 },
	{ 20, 365311 },
	{ 22, 627455 },
	{ 22, 889599 },
	{ 22, 1676031 },
	{ 22, 1938175 },
	{ 23, 2724607 },
	{ 23, 2986751 },
	{ 23, 3773183 },
	{ 22, 784895 },
	{ 20, 523771 },
	{ 20, 519675 },
	{ 20, 507387 },
	{ 20, 503291 },
	{ 20, 392699 },
	{ 20, 388603 },
	{ 20, 376315 },
	{ 20, 372219 },
	{ 19, 196091 },
	{ 19, 191995 },
	{ 19, 179707 },
	{ 19, 175611 },
	{ 18, 97787 },
	{ 18, 93691 },
	{ 18, 81403 },
	{ 18, 77307 },
	{ 16, 24059 },
	{ 16, 19963 },
	{ 18, 34299 },
	{ 16, 22011 },
	{ 18, 9723 },
	{ 11, 1182 },
	{ 18, 13823 },
	{ 18, 79359 },
	{ 20, 144895 },
	{ 20, 210431 },
	{ 20, 407039 },
	{ 20, 472575 },
	{ 21, 669183 },
	{ 21, 734719 },
	{ 21, 931327 },
	{ 21, 996863 },
	{ 20, 1038585 },
	{ 20, 1022201 },
	{ 20, 973049 },
	{ 20, 956665 },
	{ 20, 514297 },
	{ 20, 497913 },
	{ 20, 448761 },
	{ 20, 432377 },
	{ 19, 252153 },
	{ 19, 235769 },
	{ 19, 186617 },
	{ 19, 170233 },
	{ 18, 121081 },
	{ 18, 104697 },
	{ 18, 55545 },
	{ 18, 39161 },
	{ 16, 22777 },
	{ 16, 6393 },
	{ 18, 33017 },
	{ 16, 20729 },
	{ 18, 8441 },
	{ 11, 234 },
	{ 18, 12541 },
	{ 18, 78077 },
	{ 20, 143613 },
	{ 20, 209149 },
	{ 20, 405757 },
	{ 20, 471293 },
	{ 21, 667901 },
	{ 21, 733437 },
	{ 21, 930045 },
	{ 21, 995581 },
	{ 20, 1038841 },
	{ 20, 1022457 },
	{ 20, 973305 },
	{ 20, 956921 },
	{ 20, 514553 },
	{ 20, 498169 },
	{ 20, 449017 },
	{ 20, 432633 },
	{ 19, 252409 },
	{ 19, 236025 },
	{ 19, 186873 },
	{ 19, 170489 },
	{ 18, 121337 },
	{ 18, 104953 },
	{ 18, 55801 },
	{ 18, 39417 },
	{ 16, 23033 },
	{ 16, 6649 },
	{ 18, 33273 },
	{ 16, 20985 },
	{ 18, 8697 },
	{ 11, 1258 },
	{ 18, 12797 },
	{ 18, 78333 },
	{ 20, 143869 },
	{ 20, 209405 },
	{ 20, 406013 },
	{ 20, 471549 },
	{ 21, 668157 },
	{ 21, 733693 },
	{ 21, 930301 },
	{ 21, 995837 },
	{ 22, 4158205 },
	{ 22, 4137721 },
	{ 22, 4072185 },
	{ 22, 3875577 },
	{ 22, 3810041 },
	{ 22, 2040569 },
	{ 22, 1975033 },
	{ 22, 1778425 },
	{ 21, 1012477 },
	{ 21, 991993 },
	{ 21, 926457 },
	{ 21, 729849 },
	{ 20, 488189 },
	{ 20, 467705 },
	{ 20, 402169 },
	{ 20, 205561 },
	{ 18, 94973 },
	{ 18, 74489 },
	{ 18, 8953 },
	{ 14, 1401 },
	{ 12, 1465 },
	{ 13, 618 },
	{ 20, 33533 },
	{ 20, 295677 },
	{ 22, 557821 },
	{ 22, 819965 },
	{ 22, 1606397 },
	{ 22, 1868541 },
	{ 23, 2654973 },
	{ 23, 2917117 },
	{ 23, 3703549 },
	{ 23, 3965693 },
	{ 22, 4158461 },
	{ 22, 4137977 },
	{ 22, 4072441 },
	{ 22, 3875833 },
	{ 22, 3810297 },
	{ 22, 2040825 },
	{ 22, 1975289 },
	{ 22, 1778681 },
	{ 21, 1012733 },
	{ 21, 992249 },
	{ 21, 926713 },
	{ 21, 730105 },
	{ 20, 488445 },
	{ 20, 467961 },
	{ 20, 402425 },
	{ 20, 205817 },
	{ 18, 95229 },
	{ 18, 74745 },
	{ 18, 9209 },
	{ 14, 3449 },
	{ 11, 697 },
	{ 13, 1642 },
	{ 20, 33789 },
	{ 20, 295933 },
	{ 22, 558077 },
	{ 22, 820221 },
	{ 22, 1606653 },
	{ 22, 1868797 },
	{ 23, 2655229 },
	{ 23, 2917373 },
	{ 23, 3703805 },
	{ 23, 3965949 },
	{ 24, 6849533 },
	{ 22, 4142845 },
	{ 22, 4077309 },
	{ 22, 3880701 },
	{ 22, 3815165 },
	{ 22, 2045693 },
	{ 22, 1980157 },
	{ 22, 1783549 },
	{ 22, 1718013 },
	{ 21, 997117 },
	{ 21, 931581 },
	{ 21, 734973 },
	{ 21, 669437 },
	{ 20, 472829 },
	{ 20, 407293 },
	{ 20, 210685 },
	{ 20, 145149 },
	{ 18, 79613 },
	{ 18, 14077 },
	{ 11, 1001 },
	{ 9, 169 },
	{ 10, 346 },
	{ 13, 3517 },
	{ 18, 83709 },
	{ 20, 149245 },
	{ 20, 214781 },
	{ 20, 411389 },
	{ 20, 476925 },
	{ 21, 673533 },
	{ 21, 739069 },
	{ 21, 935677 },
	{ 21, 1001213 },
	{ 22, 1722109 },
	{ 22, 1787645 },
	{ 22, 1984253 },
	{ 22, 2049789 },
	{ 22, 3819261 },
	{ 22, 3884797 },
	{ 22, 4081405 },
	{ 22, 4146941 },
	{ 22, 1718269 },
	{ 21, 997373 },
	{ 21, 931837 },
	{ 21, 735229 },
	{ 21, 669693 },
	{ 20, 473085 },
	{ 20, 407549 },
	{ 20, 210941 },
	{ 20, 145405 },
	{ 18, 79869 },
	{ 18, 14333 },
	{ 11, 825 },
	{ 8, 73 },
	{ 10, 474 },
	{ 12, 1725 },
	{ 18, 83965 },
	{ 20, 149501 },
	{ 20, 215037 },
	{ 20, 411645 },
	{ 20, 477181 },
	{ 21, 673789 },
	{ 21, 739325 },
	{ 21, 935933 },
	{ 21, 1001469 },
	{ 22, 1722365 },
	{ 22, 1787901 },
	{ 22, 1984509 },
	{ 22, 2050045 },
	{ 22, 3819517 },
	{ 22, 3885053 },
	{ 22, 4081661 },
	{ 22, 4147197 },
	{ 24, 7883517 },
	{ 24, 7097085 },
	{ 24, 6834941 },
	{ 23, 3951357 },
	{ 23, 3689213 },
	{ 23, 2902781 },
	{ 23, 2640637 },
	{ 22, 1854205 },
	{ 22, 1592061 },
	{ 22, 805629 },
	{ 22, 543485 },
	{ 16, 10109 },
	{ 9, 221 },
	{ 24, 518905 },
	{ 10, 429 },
	{ 16, 9597 },
	{ 22, 527101 },
	{ 22, 789245 },
	{ 22, 1575677 },
	{ 22, 1837821 },
	{ 23, 2624253 },
	{ 23, 2886397 },
	{ 23, 3672829 },
	{ 23, 3934973 },
	{ 24, 6818557 },
	{ 24, 7080701 },
	{ 24, 7867133 },
	{ 24, 8129277 },
	{ 24, 15207165 },
	{ 24, 15469309 },
	{ 24, 16255741 },
	{ 24, 16517885 },
	{ 24, 7883773 },
	{ 24, 7097341 },
	{ 24, 6835197 },
	{ 23, 3951613 },
	{ 23, 3689469 },
	{ 23, 2903037 },
	{ 23, 2640893 },
	{ 22, 1854461 },
	{ 22, 1592317 },
	{ 22, 805885 },
	{ 22, 543741 },
	{ 16, 12157 },
	{ 12, 1901 },
	{ 10, 394 },
	{ 9, 205 },
	{ 16, 11645 },
	{ 22, 527357 },
	{ 22, 789501 },
	{ 22, 1575933 },
	{ 22, 1838077 },
	{ 23, 2624509 },
	{ 23, 2886653 },
	{ 23, 3673085 },
	{ 23, 3935229 },
	{ 24, 6818813 },
	{ 24, 7080957 },
	{ 24, 7867389 },
	{ 24, 16600829 },
	{ 24, 16338685 },
	{ 24, 15552253 },
	{ 24, 15290109 },
	{ 24, 8212221 },
	{ 24, 7950077 },
	{ 24, 7163645 },
	{ 24, 6901501 },
	{ 23, 4017917 },
	{ 23, 3755773 },
	{ 23, 2969341 },
	{ 23, 2707197 },
	{ 22, 1920765 },
	{ 22, 1658621 },
	{ 22, 872189 },
	{ 22, 610045 },
	{ 20, 347901 },
	{ 14, 7805 },
	{ 10, 458 },
	{ 10, 473 },
	{ 13, 4077 },
	{ 20, 36605 },
	{ 20, 102141 },
	{ 22, 167677 },
	{ 22, 233213 },
	{ 22, 429821 },
	{ 22, 495357 },
	{ 23, 691965 },
	{ 23, 757501 },
	{ 23, 954109 },
	{ 23, 1019645 },
	{ 24, 1740541 },
	{ 24, 1806077 },
	{ 24, 2002685 },
	{ 24, 2068221 },
	{ 24, 3837693 },
	{ 24, 3903229 },
	{ 24, 4099837 },
	{ 24, 4165373 },
	{ 24, 6901757 },
	{ 23, 4018173 },
	{ 23, 3756029 },
	{ 23, 2969597 },
	{ 23, 2707453 },
	{ 22, 1921021 },
	{ 22, 1658877 },
	{ 22, 872445 },
	{ 22, 610301 },
	{ 20, 348157 },
	{ 15, 16317 },
	{ 13, 3898 },
	{ 13, 3945 },
	{ 13, 3901 },
	{ 20, 36861 },
	{ 20, 102397 },
	{ 22, 167933 },
	{ 22, 233469 },
	{ 22, 430077 },
	{ 22, 495613 },
	{ 23, 692221 },
	{ 23, 757757 },
	{ 23, 954365 },
	{ 23, 1019901 },
	{ 24, 1740797 },
	{ 24, 1806333 },
	{ 24, 2002941 },
	{ 24, 2068477 },
	{ 24, 3837949 },
	{ 24, 3903485 },
	{ 24, 4100093 },
	{ 24, 4165629 },
	{ 26, 27417341 },
	{ 25, 15883005 },
	{ 25, 14834429 },
	{ 25, 11688701 },
	{ 25, 10640125 },
	{ 24, 7494397 },
	{ 24, 6445821 },
	{ 24, 3300093 },
	{ 24, 2251517 },
	{ 22, 1202941 },
	{ 22, 154365 },
	{ 15, 12826 },
	{ 15, 15993 },
	{ 16, 26489 },
	{ 20, 56057 },
	{ 20, 121593 },
	{ 20, 367357 },
	{ 22, 252665 },
	{ 22, 449273 },
	{ 22, 514809 },
	{ 22, 1547005 },
	{ 23, 776953 },
	{ 23, 973561 },
	{ 23, 1039097 },
	{ 23, 3119869 },
	{ 24, 1825529 },
	{ 24, 2022137 },
	{ 24, 2087673 },
	{ 24, 3857145 },
	{ 24, 3922681 },
	{ 24, 4119289 },
	{ 24, 4184825 },
	{ 24, 8362749 },
	{ 25, 15883261 },
	{ 25, 14834685 },
	{ 25, 11688957 },
	{ 25, 10640381 },
	{ 24, 7494653 },
	{ 24, 6446077 },
	{ 24, 3300349 },
	{ 24, 2251773 },
	{ 22, 1203197 },
	{ 22, 154621 },
	{ 15, 13850 },
	{ 16, 32697 },
	{ 16, 28537 },
	{ 20, 56313 },
	{ 20, 121849 },
	{ 20, 367613 },
	{ 22, 252921 },
	{ 22, 449529 },
	{ 22, 515065 },
	{ 22, 1547261 },
	{ 23, 777209 },
	{ 23, 973817 },
	{ 23, 1039353 },
	{ 23, 3120125 },
	{ 24, 1825785 },
	{ 24, 2022393 },
	{ 24, 2087929 },
	{ 24, 3857401 },
	{ 24, 3922937 },
	{ 24, 4119545 },
	{ 24, 4185081 },
	{ 24, 8363005 },
	{ 25, 15949565 },
	{ 25, 14900989 },
	{ 25, 11755261 },
	{ 25, 10706685 },
	{ 24, 7560957 },
	{ 24, 6512381 },
	{ 24, 3366653 },
	{ 24, 2318077 },
	{ 22, 1269501 },
	{ 22, 220925 },
	{ 15, 15002 },
	{ 22, 155385 },
	{ 20, 351993 },
	{ 22, 548601 },
	{ 20, 319225 },
	{ 20, 384761 },
	{ 22, 1236729 },
	{ 22, 1302265 },
	{ 22, 1498873 },
	{ 22, 1564409 },
	{ 23, 2809593 },
	{ 23, 2875129 },
	{ 23, 3071737 },
	{ 23, 3137273 },
	{ 24, 5955321 },
	{ 24, 6020857 },
	{ 24, 6217465 },
	{ 24, 6283001 },
	{ 24, 8052473 },
	{ 24, 8118009 },
	{ 24, 8314617 },
	{ 24, 8380153 },
	{ 25, 15949821 },
	{ 25, 14901245 },
	{ 25, 11755517 },
	{ 25, 10706941 },
	{ 24, 7561213 },
	{ 24, 6512637 },
	{ 24, 3366909 },
	{ 24, 2318333 },
	{ 22, 1269757 },
	{ 22, 221181 },
	{ 15, 16026 },
	{ 22, 155641 },
	{ 20, 352249 },
	{ 22, 548857 },
	{ 20, 319481 },
	{ 20, 385017 },
	{ 22, 1236985 },
	{ 22, 1302521 },
	{ 22, 1499129 },
	{ 22, 1564665 },
	{ 23, 2809849 },
	{ 23, 2875385 },
	{ 23, 3071993 },
	{ 23, 3137529 },
	{ 24, 5955577 },
	{ 24, 6021113 },
	{ 24, 6217721 },
	{ 24, 6283257 },
	{ 24, 8052729 },
	{ 24, 8118265 },
	{ 24, 8314873 },
	{ 24, 8380409 },
	{ 26, 12558333 },
	{ 27, 60369661 },
	{ 27, 47786749 },
	{ 27, 43592445 },
	{ 26, 31009533 },
	{ 26, 26815229 },
	{ 26, 14232317 },
	{ 26, 10038013 },
	{ 24, 5843709 },
	{ 24, 1649405 },
	{ 18, 84250 },
	{ 24, 862969 },
	{ 24, 4795129 },
	{ 24, 2435833 },
	{ 24, 3222265 },
	{ 24, 2304761 },
	{ 24, 2566905 },
	{ 24, 3549949 },
	{ 26, 9382649 },
	{ 26, 10169081 },
	{ 26, 10431225 },
	{ 26, 14559997 },
	{ 27, 19868409 },
	{ 27, 20654841 },
	{ 27, 20916985 },
	{ 27, 29240061 },
	{ 28, 40839929 },
	{ 28, 41626361 },
	{ 28, 41888505 },
	{ 28, 48966393 },
	{ 28, 49228537 },
	{ 28, 50014969 },
	{ 27, 64564221 },
	{ 27, 60369917 },
	{ 27, 47787005 },
	{ 27, 43592701 },
	{ 26, 31009789 },
	{ 26, 26815485 },
	{ 26, 14232573 },
	{ 26, 10038269 },
	{ 24, 5843965 },
	{ 24, 1649661 },
	{ 18, 88346 },
	{ 24, 863225 },
	{ 24, 4795385 },
	{ 24, 2436089 },
	{ 24, 3222521 },
	{ 24, 2305017 },
	{ 24, 2567161 },
	{ 24, 3550205 },
	{ 26, 9382905 },
	{ 26, 10169337 },
	{ 26, 10431481 },
	{ 26, 14560253 },
	{ 27, 19868665 },
	{ 27, 20655097 },
	{ 27, 20917241 },
	{ 27, 29240317 },
	{ 28, 40840185 },
	{ 28, 41626617 },
	{ 28, 41888761 },
	{ 28, 48966649 },
	{ 28, 49228793 },
	{ 28, 50015225 },
	{ 27, 64827133 },
	{ 27, 60632829 },
	{ 27, 48049917 },
	{ 27, 43855613 },
	{ 26, 31272701 },
	{ 26, 27078397 },
	{ 26, 14495485 },
	{ 26, 10301181 },
	{ 24, 6106877 },
	{ 24, 1912573 },
	{ 18, 92570 },
	{ 24, 1650425 },
	{ 24, 5058297 },
	{ 26, 8990457 },
	{ 24, 3485433 },
	{ 24, 6369017 },
	{ 24, 3354361 },
	{ 24, 3616505 },
	{ 24, 6696701 },
	{ 26, 13577977 },
	{ 26, 14364409 },
	{ 26, 14626553 },
	{ 26, 27143933 },
	{ 27, 28258041 },
	{ 27, 29044473 },
	{ 27, 29306617 },
	{ 27, 54406909 },
	{ 28, 57618169 },
	{ 28, 58404601 },
	{ 28, 58666745 },
	{ 28, 65744633 },
	{ 28, 66006777 },
	{ 27, 64827389 },
	{ 27, 60633085 },
	{ 27, 48050173 },
	{ 27, 43855869 },
	{ 26, 31272957 },
	{ 26, 27078653 },
	{ 26, 14495741 },
	{ 26, 10301437 },
	{ 24, 6107133 },
	{ 24, 1912829 },
	{ 18, 96666 },
	{ 24, 1650681 },
	{ 24, 5058553 },
	{ 26, 8990713 },
	{ 24, 3485689 },
	{ 24, 6369273 },
	{ 24, 3354617 },
	{ 24, 3616761 },
	{ 24, 6696957 },
	{ 26, 13578233 },
	{ 26, 14364665 },
	{ 26, 14626809 },
	{ 26, 27144189 },
	{ 27, 28258297 },
	{ 27, 29044729 },
	{ 27, 29306873 },
	{ 27, 54407165 },
	{ 28, 57618425 },
	{ 28, 58404857 },
	{ 28, 58667001 },
	{ 28, 65744889 },
	{ 28, 66007033 },
	{ 28, 66793465 },
	{ 28, 67055609 },
	{ 28, 94976765 },
	{ 28, 86588157 },
	{ 27, 61422333 },
	{ 27, 53033725 },
	{ 27, 27867901 },
	{ 27, 19479293 },
	{ 25, 11090685 },
	{ 25, 2702077 },
	{ 18, 117530 },
	{ 24, 1915641 },
	{ 24, 5847801 },
	{ 25, 11599867 },
	{ 26, 13187833 },
	{ 24, 6634233 },
	{ 24, 7420665 },
	{ 24, 6503161 },
	{ 24, 6765305 },
	{ 24, 7748349 },
	{ 25, 12517375 },
	{ 26, 26950393 },
	{ 26, 27212537 },
	{ 26, 31341309 },
	{ 27, 53426937 },
	{ 27, 54213369 },
	{ 27, 54475513 },
	{ 27, 62798589 },
	{ 28, 107952889 },
	{ 28, 108739321 },
	{ 28, 109001465 },
	{ 28, 116079353 },
	{ 28, 116341497 },
	{ 28, 117127929 },
	{ 28, 117390073 },
	{ 28, 134101757 },
	{ 27, 61422589 },
	{ 27, 53033981 },
	{ 27, 27868157 },
	{ 27, 19479549 },
	{ 25, 11090941 },
	{ 25, 2702333 },
	{ 18, 121626 },
	{ 24, 1915897 },
	{ 24, 5848057 },
	{ 25, 11599611 },
	{ 26, 13188089 },
	{ 24, 6634489 },
	{ 24, 7420921 },
	{ 24, 6503417 },
	{ 24, 6765561 },
	{ 24, 7748605 },
	{ 25, 12517119 },
	{ 26, 26950649 },
	{ 26, 27212793 },
	{ 26, 31341565 },
	{ 27, 53427193 },
	{ 27, 54213625 },
	{ 27, 54475769 },
	{ 27, 62798845 },
	{ 28, 107953145 },
	{ 28, 108739577 },
	{ 28, 109001721 },
	{ 28, 116079609 },
	{ 28, 116341753 },
	{ 28, 117128185 },
	{ 28, 117390329 },
	{ 28, 86851325 },
	{ 27, 61685501 },
	{ 27, 53296893 },
	{ 27, 28131069 },
	{ 27, 19742461 },
	{ 25, 11353853 },
	{ 25, 2965245 },
	{ 18, 125850 },
	{ 25, 2703097 },
	{ 24, 6110969 },
	{ 25, 12123131 },
	{ 26, 13451001 },
	{ 26, 25771769 },
	{ 24, 7683833 },
	{ 25, 10567417 },
	{ 24, 7552761 },
	{ 24, 7814905 },
	{ 25, 10895101 },
	{ 26, 30359289 },
	{ 26, 31145721 },
	{ 26, 31407865 },
	{ 27, 61554425 },
	{ 27, 61816569 },
	{ 27, 62603001 },
	{ 27, 62865145 },
	{ 28, 124468985 },
	{ 28, 124731129 },
	{ 28, 125517561 },
	{ 28, 125779705 },
	{ 28, 132857593 },
	{ 28, 133119737 },
	{ 28, 133906169 },
	{ 28, 134168313 },
	{ 27, 61685757 },
	{ 27, 53297149 },
	{ 27, 28131325 },
	{ 27, 19742717 },
	{ 25, 11354109 },
	{ 25, 2965501 },
	{ 18, 129946 },
	{ 25, 2703353 },
	{ 24, 6111225 },
	{ 25, 12122875 },
	{ 26, 13451257 },
	{ 26, 25772025 },
	{ 24, 7684089 },
	{ 25, 10567673 },
	{ 24, 7553017 },
	{ 24, 7815161 },
	{ 25, 10895357 },
	{ 26, 30359545 },
	{ 26, 31145977 },
	{ 26, 31408121 },
	{ 27, 61554681 },
	{ 27, 61816825 },
	{ 27, 62603257 },
	{ 27, 62865401 },
	{ 28, 124469241 },
	{ 28, 124731385 },
	{ 28, 125517817 },
	{ 28, 125779961 },
	{ 28, 132857849 },
	{ 28, 133119993 },
	{ 28, 133906425 },
	{ 28, 134168569 },
	{ 27, 62483197 },
	{ 27, 54094589 },
	{ 27, 28928765 },
	{ 27, 20540157 },
	{ 25, 12151549 },
	{ 25, 3762941 },
	{ 20, 431386 },
	{ 25, 2976505 },
	{ 25, 11102969 },
	{ 26, 10316537 },
	{ 26, 14248697 },
	{ 26, 26045177 },
	{ 26, 29977337 },
	{ 25, 10840825 },
	{ 25, 11627257 },
	{ 25, 10709753 },
	{ 25, 10971897 },
	{ 25, 11954941 },
	{ 26, 22999039 },
	{ 27, 43739897 },
	{ 27, 44002041 },
	{ 27, 48130813 },
	{ 28, 86993657 },
	{ 28, 87780089 },
	{ 28, 88042233 },
	{ 28, 96365309 },
	{ 29, 175074041 },
	{ 29, 175860473 },
	{ 28, 129592317 },
	{ 28, 121203709 },
	{ 28, 96037885 },
	{ 28, 87649277 },
	{ 27, 62483453 },
	{ 27, 54094845 },
	{ 27, 28929021 },
	{ 27, 20540413 },
	{ 25, 12151805 },
	{ 25, 3763197 },
	{ 20, 439578 },
	{ 25, 2976761 },
	{ 25, 11103225 },
	{ 26, 10316793 },
	{ 26, 14248953 },
	{ 26, 26045433 },
	{ 26, 29977593 },
	{ 25, 10841081 },
	{ 25, 11627513 },
	{ 25, 10710009 },
	{ 25, 10972153 },
	{ 25, 11955197 },
	{ 26, 22998783 },
	{ 27, 43740153 },
	{ 27, 44002297 },
	{ 27, 48131069 },
	{ 28, 86993913 },
	{ 28, 87780345 },
	{ 28, 88042489 },
	{ 28, 96365565 },
	{ 29, 175074297 },
	{ 29, 175860729 },
	{ 28, 129855229 },
	{ 28, 121466621 },
	{ 28, 96300797 },
	{ 28, 87912189 },
	{ 27, 62746365 },
	{ 27, 54357757 },
	{ 27, 29191933 },
	{ 27, 20803325 },
	{ 25, 12414717 },
	{ 25, 4026109 },
	{ 20, 447898 },
	{ 25, 3763961 },
	{ 25, 11366137 },
	{ 26, 22604795 },
	{ 26, 14511865 },
	{ 26, 26832633 },
	{ 26, 30240505 },
	{ 27, 42561273 },
	{ 25, 11890425 },
	{ 25, 14774009 },
	{ 25, 11759353 },
	{ 25, 12021497 },
	{ 25, 15101693 },
	{ 26, 24570879 },
	{ 27, 47935225 },
	{ 27, 48197369 },
	{ 27, 60714749 },
	{ 28, 95383289 },
	{ 28, 96169721 },
	{ 28, 96431865 },
	{ 28, 121532157 },
	{ 29, 191852281 },
	{ 28, 129855485 },
	{ 28, 121466877 },
	{ 28, 96301053 },
	{ 28, 87912445 },
	{ 27, 62746621 },
	{ 27, 54358013 },
	{ 27, 29192189 },
	{ 27, 20803581 },
	{ 25, 12414973 },
	{ 25, 4026365 },
	{ 20, 456090 },
	{ 25, 3764217 },
	{ 25, 11366393 },
	{ 26, 22604539 },
	{ 26, 14512121 },
	{ 26, 26832889 },
	{ 26, 30240761 },
	{ 27, 42561529 },
	{ 25, 11890681 },
	{ 25, 14774265 },
	{ 25, 11759609 },
	{ 25, 12021753 },
	{ 25, 15101949 },
	{ 26, 24570623 },
	{ 27, 47935481 },
	{ 27, 48197625 },
	{ 27, 60715005 },
	{ 28, 95383545 },
	{ 28, 96169977 },
	{ 28, 96432121 },
	{ 28, 121532413 },
	{ 29, 191852537 },
	{ 29, 259813369 },
	{ 29, 250114041 },
	{ 29, 200044537 },
	{ 29, 184053753 },
	{ 28, 133984249 },
	{ 28, 107576061 },
	{ 28, 57244413 },
	{ 28, 40467197 },
	{ 26, 23689981 },
	{ 26, 6912765 },
	{ 20, 497434 },
	{ 20, 1046382 },
	{ 25, 12155641 },
	{ 26, 24166395 },
	{ 27, 27884281 },
	{ 26, 27097849 },
	{ 26, 31030009 },
	{ 27, 42826489 },
	{ 27, 46758649 },
	{ 25, 15039225 },
	{ 25, 15825657 },
	{ 25, 14908153 },
	{ 25, 15170297 },
	{ 25, 16153341 },
	{ 26, 25083903 },
	{ 27, 60521209 },
	{ 27, 60783353 },
	{ 27, 64912125 },
	{ 28, 120552185 },
	{ 28, 121338617 },
	{ 28, 121600761 },
	{ 28, 129923837 },
	{ 29, 259554041 },
	{ 29, 243038969 },
	{ 29, 199785209 },
	{ 29, 183270137 },
	{ 28, 133724921 },
	{ 28, 117209849 },
	{ 28, 57244669 },
	{ 28, 40467453 },
	{ 26, 23690237 },
	{ 26, 6913021 },
	{ 20, 505626 },
	{ 20, 1038190 },
	{ 25, 12155897 },
	{ 26, 24166139 },
	{ 27, 27884537 },
	{ 26, 27098105 },
	{ 26, 31030265 },
	{ 27, 42826745 },
	{ 27, 46758905 },
	{ 25, 15039481 },
	{ 25, 15825913 },
	{ 25, 14908409 },
	{ 25, 15170553 },
	{ 25, 16153597 },
	{ 26, 25083647 },
	{ 27, 60521465 },
	{ 27, 60783609 },
	{ 27, 64912381 },
	{ 28, 120552441 },
	{ 28, 121338873 },
	{ 28, 121601017 },
	{ 28, 129924093 },
	{ 29, 259554297 },
	{ 29, 243039225 },
	{ 29, 199785465 },
	{ 29, 183270393 },
	{ 28, 133725177 },
	{ 28, 117210105 },
	{ 28, 57507581 },
	{ 28, 40730365 },
	{ 26, 23953149 },
	{ 26, 7175933 },
	{ 20, 513946 },
	{ 20, 1030126 },
	{ 25, 12418809 },
	{ 26, 24689659 },
	{ 27, 28147449 },
	{ 27, 53051129 },
	{ 26, 31293177 },
	{ 27, 43613945 },
	{ 27, 47021817 },
	{ 27, 59342585 },
	{ 25, 16088825 },
	{ 26, 27361017 },
	{ 25, 15957753 },
	{ 25, 16219897 },
	{ 26, 27688701 },
	{ 27, 63930105 },
	{ 27, 64716537 },
	{ 27, 64978681 },
	{ 28, 128679673 },
	{ 28, 128941817 },
	{ 28, 129728249 },
	{ 28, 129990393 },
	{ 29, 258768633 },
	{ 29, 242777849 },
	{ 29, 192708345 },
	{ 29, 183009017 },
	{ 28, 132939513 },
	{ 28, 116948729 },
	{ 28, 66879225 },
	{ 28, 40730621 },
	{ 26, 23953405 },
	{ 26, 7176189 },
	{ 20, 522138 },
	{ 20, 1021934 },
	{ 25, 12419065 },
	{ 26, 24689403 },
	{ 27, 28147705 },
	{ 27, 53051385 },
	{ 26, 31293433 },
	{ 27, 43614201 },
	{ 27, 47022073 },
	{ 27, 59342841 },
	{ 25, 16089081 },
	{ 26, 27361273 },
	{ 25, 15958009 },
	{ 25, 16220153 },
	{ 26, 27688957 },
	{ 27, 63930361 },
	{ 27, 64716793 },
	{ 27, 64978937 },
	{ 28, 128679929 },
	{ 28, 128942073 },
	{ 28, 129728505 },
	{ 28, 129990649 },
	{ 29, 258768889 },
	{ 29, 242778105 },
	{ 29, 192708601 },
	{ 29, 183009273 },
	{ 28, 132939769 },
	{ 28, 116948985 },
	{ 28, 66879481 },
	{ 29, 268402681 },
	{ 27, 49457917 },
	{ 27, 15903485 },
	{ 21, 1912090 },
	{ 21, 1961326 },
	{ 27, 47360761 },
	{ 27, 47230971 },
	{ 28, 57846521 },
	{ 28, 106605305 },
	{ 28, 122858233 },
	{ 28, 87730937 },
	{ 28, 95595257 },
	{ 28, 119188217 },
	{ 28, 127052537 },
	{ 27, 55225081 },
	{ 27, 56797945 },
	{ 27, 54962937 },
	{ 27, 55487225 },
	{ 27, 57453309 },
	{ 27, 48148479 },
	{ 29, 490253049 },
	{ 29, 222210809 },
	{ 29, 230468349 },
	{ 29, 249475071 },
	{ 30, 444115705 },
	{ 30, 516991737 },
	{ 30, 483961593 },
	{ 30, 384871161 },
	{ 30, 351841017 },
	{ 29, 265333497 },
	{ 29, 232303353 },
	{ 29, 133212921 },
	{ 29, 100182777 },
	{ 27, 49458173 },
	{ 27, 15903741 },
	{ 21, 1928474 },
	{ 21, 1944942 },
	{ 27, 47361017 },
	{ 27, 47230715 },
	{ 28, 57846777 },
	{ 28, 106605561 },
	{ 28, 122858489 },
	{ 28, 87731193 },
	{ 28, 95595513 },
	{ 28, 119188473 },
	{ 28, 127052793 },
	{ 27, 55225337 },
	{ 27, 56798201 },
	{ 27, 54963193 },
	{ 27, 55487481 },
	{ 27, 57453565 },
	{ 27, 48148223 },
	{ 29, 490253305 },
	{ 29, 222211065 },
	{ 29, 230468605 },
	{ 29, 249474815 },
	{ 30, 444115961 },
	{ 30, 516991993 },
	{ 30, 483961849 },
	{ 30, 384871417 },
	{ 30, 351841273 },
	{ 29, 265333753 },
	{ 29, 232303609 },
	{ 29, 133213177 },
	{ 29, 100183033 },
	{ 27, 49983229 },
	{ 27, 16428797 },
	{ 21, 1944986 },
	{ 21, 1928686 },
	{ 27, 47886073 },
	{ 27, 47754235 },
	{ 28, 58371833 },
	{ 28, 108179193 },
	{ 28, 123383545 },
	{ 28, 123251707 },
	{ 28, 96120569 },
	{ 28, 120762105 },
	{ 28, 127577849 },
	{ 27, 66891513 },
	{ 27, 33337081 },
	{ 27, 63090425 },
	{ 27, 132689657 },
	{ 27, 57585401 },
	{ 27, 63745789 },
	{ 27, 49720319 },
	{ 29, 263761657 },
	{ 29, 230600441 },
	{ 29, 255635197 },
	{ 29, 251046911 },
	{ 29, 259567353 },
	{ 29, 259697659 },
	{ 30, 383299321 },
	{ 30, 351317753 },
	{ 29, 251178745 },
	{ 29, 231780089 },
	{ 29, 131641081 },
	{ 29, 99659513 },
	{ 27, 66629369 },
	{ 27, 16429053 },
	{ 21, 1949674 },
	{ 21, 1912302 },
	{ 27, 47886329 },
	{ 27, 47753979 },
	{ 28, 58372089 },
	{ 28, 108179449 },
	{ 28, 123383801 },
	{ 28, 123251451 },
	{ 28, 96120825 },
	{ 28, 120762361 },
	{ 28, 127578105 },
	{ 27, 66891769 },
	{ 27, 33337337 },
	{ 27, 63090681 },
	{ 27, 132689913 },
	{ 27, 57585657 },
	{ 27, 63746045 },
	{ 27, 49720063 },
	{ 29, 263761913 },
	{ 29, 230600697 },
	{ 29, 255635453 },
	{ 29, 251046655 },
	{ 29, 259567609 },
	{ 29, 259697403 },
	{ 29, 250118143 },
	{ 29, 199786495 },
	{ 29, 251179001 },
	{ 28, 132677631 },
	{ 28, 115900415 },
	{ 28, 65568767 },
	{ 27, 66629625 },
	{ 26, 32014335 },
	{ 21, 1966058 },
	{ 21, 1044334 },
	{ 26, 8159227 },
	{ 26, 24674299 },
	{ 28, 40665083 },
	{ 28, 108706553 },
	{ 27, 54296571 },
	{ 27, 62423035 },
	{ 28, 86802427 },
	{ 28, 121289465 },
	{ 27, 60588027 },
	{ 27, 67025661 },
	{ 26, 66486271 },
	{ 26, 65503227 },
	{ 26, 31752187 },
	{ 26, 32538619 },
	{ 26, 8028155 },
	{ 26, 24805371 },
	{ 26, 25133055 },
	{ 28, 58359803 },
	{ 28, 108691451 },
	{ 28, 125468667 },
	{ 28, 125796351 },
	{ 28, 129597435 },
	{ 28, 121470971 },
	{ 29, 259686395 },
	{ 29, 250657529 },
	{ 28, 125403131 },
	{ 28, 108888059 },
	{ 28, 65634299 },
	{ 27, 66108153 },
	{ 26, 33128443 },
	{ 21, 2047850 },
	{ 21, 1027950 },
	{ 26, 8158971 },
	{ 26, 24674043 },
	{ 28, 40664827 },
	{ 28, 108706809 },
	{ 27, 54296315 },
	{ 27, 62422779 },
	{ 28, 86802171 },
	{ 28, 121289721 },
	{ 27, 60587771 },
	{ 27, 67025917 },
	{ 26, 66486015 },
	{ 26, 65502971 },
	{ 26, 31751931 },
	{ 26, 32538363 },
	{ 26, 8027899 },
	{ 26, 24805115 },
	{ 26, 25132799 },
	{ 28, 58359547 },
	{ 28, 108691195 },
	{ 28, 125468411 },
	{ 28, 125796095 },
	{ 28, 129597179 },
	{ 28, 121470715 },
	{ 29, 259686139 },
	{ 29, 250657785 },
	{ 28, 125402875 },
	{ 28, 108887803 },
	{ 28, 65634043 },
	{ 27, 66108409 },
	{ 26, 33128187 },
	{ 21, 2064234 },
	{ 21, 1011694 },
	{ 26, 15236091 },
	{ 26, 24935419 },
	{ 28, 41450491 },
	{ 28, 57441275 },
	{ 28, 125484793 },
	{ 27, 62684155 },
	{ 28, 87587835 },
	{ 28, 95190011 },
	{ 28, 129679097 },
	{ 27, 64781307 },
	{ 27, 66502397 },
	{ 26, 65436671 },
	{ 26, 62356475 },
	{ 26, 32799739 },
	{ 26, 60849147 },
	{ 26, 8289275 },
	{ 26, 25066491 },
	{ 26, 32209919 },
	{ 28, 58620923 },
	{ 28, 108952571 },
	{ 28, 125729787 },
	{ 28, 128809979 },
	{ 28, 121207803 },
	{ 28, 96304123 },
	{ 29, 249085689 },
	{ 28, 124615675 },
	{ 28, 108624891 },
	{ 28, 58555387 },
	{ 27, 64536313 },
	{ 26, 32340987 },
	{ 21, 2080234 },
	{ 21, 995310 },
	{ 26, 15235835 },
	{ 26, 24935163 },
	{ 28, 41450235 },
	{ 28, 57441019 },
	{ 28, 125485049 },
	{ 27, 62683899 },
	{ 28, 87587579 },
	{ 28, 95189755 },
	{ 28, 129679353 },
	{ 27, 64781051 },
	{ 27, 66502653 },
	{ 26, 65436415 },
	{ 26, 62356219 },
	{ 26, 32799483 },
	{ 26, 60848891 },
	{ 26, 8289019 },
	{ 26, 25066235 },
	{ 26, 32209663 },
	{ 28, 58620667 },
	{ 28, 108952315 },
	{ 28, 125729531 },
	{ 28, 128809723 },
	{ 28, 121207547 },
	{ 28, 96303867 },
	{ 29, 249085945 },
	{ 28, 124615419 },
	{ 28, 108624635 },
	{ 28, 58555131 },
	{ 27, 64536569 },
	{ 26, 32340731 },
	{ 21, 2096618 },
	{ 21, 916846 },
	{ 26, 15495163 },
	{ 26, 32010235 },
	{ 28, 41709563 },
	{ 28, 58224635 },
	{ 28, 107769851 },
	{ 28, 124284923 },
	{ 28, 87846907 },
	{ 28, 95973371 },
	{ 28, 120352763 },
	{ 28, 128479227 },
	{ 28, 110915579 },
	{ 27, 64940797 },
	{ 26, 62287871 },
	{ 26, 61304827 },
	{ 26, 61108219 },
	{ 26, 61894651 },
	{ 26, 15364091 },
	{ 26, 32141307 },
	{ 26, 32468991 },
	{ 28, 65695739 },
	{ 28, 116027387 },
	{ 28, 132804603 },
	{ 28, 120418299 },
	{ 28, 96038907 },
	{ 28, 87912443 },
	{ 28, 124350459 },
	{ 28, 107835387 },
	{ 28, 58290171 },
	{ 27, 64023289 },
	{ 26, 32075771 },
	{ 26, 15560699 },
	{ 21, 900462 },
	{ 26, 15494907 },
	{ 26, 32009979 },
	{ 28, 41709307 },
	{ 28, 58224379 },
	{ 28, 107769595 },
	{ 28, 124284667 },
	{ 28, 87846651 },
	{ 28, 95973115 },
	{ 28, 120352507 },
	{ 28, 128478971 },
	{ 28, 110915323 },
	{ 27, 64941053 },
	{ 26, 62287615 },
	{ 26, 61304571 },
	{ 26, 61107963 },
	{ 26, 61894395 },
	{ 26, 15363835 },
	{ 26, 32141051 },
	{ 26, 32468735 },
	{ 28, 65695483 },
	{ 28, 116027131 },
	{ 28, 132804347 },
	{ 28, 120418043 },
	{ 28, 96038651 },
	{ 28, 87912187 },
	{ 28, 124350203 },
	{ 28, 107835131 },
	{ 28, 58289915 },
	{ 27, 64023545 },
	{ 26, 32075515 },
	{ 26, 15560443 },
	{ 21, 884206 },
	{ 26, 16280571 },
	{ 26, 32271355 },
	{ 28, 48786427 },
	{ 28, 58485755 },
	{ 28, 108555259 },
	{ 28, 124546043 },
	{ 29, 192605945 },
	{ 28, 96234491 },
	{ 28, 121138171 },
	{ 28, 128740347 },
	{ 28, 132082683 },
	{ 28, 115108859 },
	{ 27, 64417533 },
	{ 26, 61238271 },
	{ 26, 32992251 },
	{ 26, 62155771 },
	{ 26, 65039355 },
	{ 26, 15625211 },
	{ 26, 32402427 },
	{ 26, 33254399 },
	{ 28, 129560313 },
	{ 27, 64842747 },
	{ 28, 133065723 },
	{ 28, 95251451 },
	{ 28, 125366009 },
	{ 27, 62745595 },
	{ 28, 107572219 },
	{ 28, 57502715 },
	{ 27, 49868537 },
	{ 26, 24996859 },
	{ 26, 15297531 },
	{ 21, 867822 },
	{ 26, 16280315 },
	{ 26, 32271099 },
	{ 28, 48786171 },
	{ 28, 58485499 },
	{ 28, 108555003 },
	{ 28, 124545787 },
	{ 29, 192606201 },
	{ 28, 96234235 },
	{ 28, 121137915 },
	{ 28, 128740091 },
	{ 28, 132082427 },
	{ 28, 115108603 },
	{ 27, 64417789 },
	{ 26, 61238015 },
	{ 26, 32991995 },
	{ 26, 62155515 },
	{ 26, 65039099 },
	{ 26, 15624955 },
	{ 26, 32402171 },
	{ 26, 33254143 },
	{ 28, 129560569 },
	{ 27, 64842491 },
	{ 28, 133065467 },
	{ 28, 95251195 },
	{ 28, 125366265 },
	{ 27, 62745339 },
	{ 28, 107571963 },
	{ 28, 57502459 },
	{ 27, 49868793 },
	{ 26, 24996603 },
	{ 26, 15297275 },
	{ 20, 524142 },
	{ 26, 16531451 },
	{ 26, 33046523 },
	{ 28, 49037307 },
	{ 28, 65552379 },
	{ 28, 108806139 },
	{ 28, 125321211 },
	{ 29, 174866427 },
	{ 29, 242940665 },
	{ 28, 121389051 },
	{ 28, 129515515 },
	{ 28, 132005887 },
	{ 28, 127877115 },
	{ 28, 127680507 },
	{ 27, 50264829 },
	{ 26, 32915455 },
	{ 26, 31932411 },
	{ 26, 65290235 },
	{ 26, 66076667 },
	{ 26, 16400379 },
	{ 26, 33177595 },
	{ 26, 33505279 },
	{ 27, 64569339 },
	{ 27, 60637179 },
	{ 28, 133840891 },
	{ 28, 124844793 },
	{ 27, 62472187 },
	{ 27, 54345723 },
	{ 28, 57229307 },
	{ 27, 49347321 },
	{ 26, 24723451 },
	{ 26, 8208379 },
	{ 20, 507758 },
	{ 26, 16531195 },
	{ 26, 33046267 },
	{ 28, 49037051 },
	{ 28, 65552123 },
	{ 28, 108805883 },
	{ 28, 125320955 },
	{ 29, 174866171 },
	{ 29, 242940921 },
	{ 28, 121388795 },
	{ 28, 129515259 },
	{ 28, 132005631 },
	{ 28, 127876859 },
	{ 28, 127680251 },
	{ 27, 50265085 },
	{ 26, 32915199 },
	{ 26, 31932155 },
	{ 26, 65289979 },
	{ 26, 66076411 },
	{ 26, 16400123 },
	{ 26, 33177339 },
	{ 26, 33505023 },
	{ 27, 64569083 },
	{ 27, 60636923 },
	{ 28, 133840635 },
	{ 28, 124845049 },
	{ 27, 62471931 },
	{ 27, 54345467 },
	{ 28, 57229051 },
	{ 27, 49347577 },
	{ 26, 24723195 },
	{ 26, 8208123 },
	{ 20, 491502 },
	{ 26, 15286015 },
	{ 26, 33307643 },
	{ 28, 49822715 },
	{ 28, 65813499 },
	{ 28, 115883003 },
	{ 28, 125582331 },
	{ 29, 175651835 },
	{ 29, 191642619 },
	{ 29, 259718905 },
	{ 28, 129776635 },
	{ 29, 251068157 },
	{ 28, 127810559 },
	{ 28, 115293179 },
	{ 28, 131873787 },
	{ 27, 49741565 },
	{ 26, 31865855 },
	{ 26, 28785659 },
	{ 26, 66337787 },
	{ 26, 31538171 },
	{ 26, 16661499 },
	{ 26, 33438715 },
	{ 27, 63781883 },
	{ 27, 60374011 },
	{ 27, 48053243 },
	{ 28, 123272953 },
	{ 27, 61684731 },
	{ 27, 54082555 },
	{ 27, 29178875 },
	{ 27, 47775481 },
	{ 26, 23935995 },
	{ 26, 7945211 },
	{ 20, 475118 },
	{ 26, 8207359 },
	{ 26, 33307387 },
	{ 28, 49822459 },
	{ 28, 65813243 },
	{ 28, 115882747 },
	{ 28, 125582075 },
	{ 29, 175651579 },
	{ 29, 191642363 },
	{ 29, 259719161 },
	{ 28, 129776379 },
	{ 29, 251068413 },
	{ 28, 127810303 },
	{ 28, 115292923 },
	{ 28, 131873531 },
	{ 27, 49741821 },
	{ 26, 31865599 },
	{ 26, 28785403 },
	{ 26, 66337531 },
	{ 26, 31537915 },
	{ 26, 16661243 },
	{ 26, 33438459 },
	{ 27, 63781627 },
	{ 27, 60373755 },
	{ 27, 48052987 },
	{ 28, 123273209 },
	{ 27, 61684475 },
	{ 27, 54082299 },
	{ 27, 29178619 },
	{ 27, 47775737 },
	{ 26, 23935739 },
	{ 26, 7944955 },
	{ 20, 470430 },
	{ 26, 8207103 },
	{ 26, 24984319 },
	{ 28, 50081787 },
	{ 28, 66596859 },
	{ 28, 116142075 },
	{ 28, 132657147 },
	{ 29, 175910907 },
	{ 29, 192425979 },
	{ 29, 241971195 },
	{ 29, 258486267 },
	{ 29, 222048251 },
	{ 29, 230174715 },
	{ 28, 115224575 },
	{ 28, 111095803 },
	{ 28, 245116923 },
	{ 28, 96316157 },
	{ 26, 28717055 },
	{ 26, 27734011 },
	{ 26, 27471867 },
	{ 26, 28389371 },
	{ 26, 27602939 },
	{ 27, 63516667 },
	{ 27, 59584507 },
	{ 27, 47788027 },
	{ 27, 43855867 },
	{ 27, 61419515 },
	{ 27, 53293051 },
	{ 27, 28913659 },
	{ 27, 20787195 },
	{ 26, 23670779 },
	{ 26, 7155707 },
	{ 20, 388382 },
	{ 26, 7942143 },
	{ 26, 24719359 },
	{ 28, 50081531 },
	{ 28, 66596603 },
	{ 28, 116141819 },
	{ 28, 132656891 },
	{ 29, 175910651 },
	{ 29, 192425723 },
	{ 29, 241970939 },
	{ 29, 258486011 },
	{ 29, 222047995 },
	{ 29, 230174459 },
	{ 28, 115224319 },
	{ 28, 111095547 },
	{ 28, 245116667 },
	{ 28, 96316413 },
	{ 26, 28716799 },
	{ 26, 27733755 },
	{ 26, 27471611 },
	{ 26, 28389115 },
	{ 26, 27602683 },
	{ 27, 63516411 },
	{ 27, 59584251 },
	{ 27, 47787771 },
	{ 27, 43855611 },
	{ 27, 61419259 },
	{ 27, 53292795 },
	{ 27, 28913403 },
	{ 27, 20786939 },
	{ 26, 23670523 },
	{ 26, 7155451 },
	{ 20, 371998 },
	{ 26, 7941887 },
	{ 26, 24719103 },
	{ 28, 41496319 },
	{ 28, 66857979 },
	{ 28, 116927483 },
	{ 28, 132918267 },
	{ 29, 182987771 },
	{ 29, 192687099 },
	{ 29, 242756603 },
	{ 29, 258747387 },
	{ 28, 129969147 },
	{ 28, 129707003 },
	{ 28, 128920571 },
	{ 28, 128658427 },
	{ 27, 64957435 },
	{ 27, 64695291 },
	{ 27, 63908859 },
	{ 26, 27667455 },
	{ 25, 16198651 },
	{ 25, 15936507 },
	{ 26, 27339771 },
	{ 25, 16067579 },
	{ 27, 59321339 },
	{ 27, 47000571 },
	{ 27, 43592699 },
	{ 26, 31271931 },
	{ 27, 53029883 },
	{ 27, 28126203 },
	{ 27, 49393401 },
	{ 25, 12397563 },
	{ 26, 6892539 },
	{ 19, 178078 },
	{ 26, 7154687 },
	{ 26, 23931903 },
	{ 28, 40709119 },
	{ 28, 66857723 },
	{ 28, 116927227 },
	{ 28, 132918011 },
	{ 29, 182987515 },
	{ 29, 192686843 },
	{ 29, 242756347 },
	{ 29, 258747131 },
	{ 28, 129968891 },
	{ 28, 129706747 },
	{ 28, 128920315 },
	{ 28, 128658171 },
	{ 27, 64957179 },
	{ 27, 64695035 },
	{ 27, 63908603 },
	{ 26, 27667199 },
	{ 25, 16198395 },
	{ 25, 15936251 },
	{ 26, 27339515 },
	{ 25, 16067323 },
	{ 27, 59321083 },
	{ 27, 47000315 },
	{ 27, 43592443 },
	{ 26, 31271675 },
	{ 27, 53029627 },
	{ 27, 28125947 },
	{ 27, 49393657 },
	{ 25, 12397307 },
	{ 26, 6892283 },
	{ 19, 169886 },
	{ 26, 7154431 },
	{ 26, 23931647 },
	{ 27, 67084287 },
	{ 27, 62906363 },
	{ 5, 27 },
	{ 26, 33431547 },
	{ 27, 45817851 },
	{ 27, 49946619 },
	{ 27, 60760059 },
	{ 27, 64888827 },
	{ 26, 32481279 },
	{ 26, 30400507 },
	{ 26, 30334971 },
	{ 26, 30138363 },
	{ 25, 16228351 },
	{ 25, 15196155 },
	{ 25, 15130619 },
	{ 25, 14934011 },
	{ 23, 4038655 },
	{ 23, 3792891 },
	{ 23, 3727355 },
	{ 23, 3956731 },
	{ 23, 3760123 },
	{ 25, 11689979 },
	{ 25, 10706939 },
	{ 24, 7757819 },
	{ 24, 6774779 },
	{ 25, 6971387 },
	{ 25, 4939771 },
	{ 23, 3039227 },
	{ 23, 1007611 },
	{ 18, 128798 },
	{ 24, 1728511 },
	{ 24, 5922815 },
	{ 26, 10117119 },
	{ 26, 14311423 },
	{ 26, 29302523 },
	{ 26, 33431291 },
	{ 27, 45817595 },
	{ 27, 49946363 },
	{ 27, 60759803 },
	{ 27, 64888571 },
	{ 26, 32481023 },
	{ 26, 30400251 },
	{ 26, 30334715 },
	{ 26, 30138107 },
	{ 25, 16228095 },
	{ 25, 15195899 },
	{ 25, 15130363 },
	{ 25, 14933755 },
	{ 23, 4038399 },
	{ 23, 3792635 },
	{ 23, 3727099 },
	{ 23, 3956475 },
	{ 23, 3759867 },
	{ 25, 11689723 },
	{ 25, 10706683 },
	{ 24, 7757563 },
	{ 24, 6774523 },
	{ 25, 6971131 },
	{ 25, 4939515 },
	{ 23, 3038971 },
	{ 23, 1007355 },
	{ 18, 120606 },
	{ 24, 1728255 },
	{ 24, 5922559 },
	{ 26, 10116863 },
	{ 26, 14311167 },
	{ 26, 26894079 },
	{ 26, 33496059 },
	{ 27, 46013435 },
	{ 27, 50011131 },
	{ 27, 62528507 },
	{ 27, 64953339 },
	{ 27, 47963131 },
	{ 26, 30383103 },
	{ 26, 24108027 },
	{ 26, 24042491 },
	{ 26, 23845883 },
	{ 25, 15178751 },
	{ 25, 12049403 },
	{ 25, 11983867 },
	{ 25, 11787259 },
	{ 23, 3775487 },
	{ 23, 3005435 },
	{ 23, 2939899 },
	{ 23, 3693563 },
	{ 23, 2972667 },
	{ 25, 10640379 },
	{ 24, 7560187 },
	{ 24, 6708219 },
	{ 24, 3628027 },
	{ 25, 4873211 },
	{ 23, 2841595 },
	{ 23, 941051 },
	{ 18, 112030 },
	{ 23, 1006591 },
	{ 23, 3103743 },
	{ 25, 5200895 },
	{ 25, 7298047 },
	{ 25, 13589503 },
	{ 25, 15686655 },
	{ 26, 21978111 },
	{ 26, 24075263 },
	{ 26, 30366719 },
	{ 26, 32463871 },
	{ 27, 47962875 },
	{ 26, 30382847 },
	{ 26, 24107771 },
	{ 26, 24042235 },
	{ 26, 23845627 },
	{ 25, 15178495 },
	{ 25, 12049147 },
	{ 25, 11983611 },
	{ 25, 11787003 },
	{ 23, 3775231 },
	{ 23, 3005179 },
	{ 23, 2939643 },
	{ 23, 3693307 },
	{ 23, 2972411 },
	{ 25, 10640123 },
	{ 24, 7559931 },
	{ 24, 6707963 },
	{ 24, 3627771 },
	{ 25, 4872955 },
	{ 23, 2841339 },
	{ 23, 940795 },
	{ 18, 103838 },
	{ 23, 1006335 },
	{ 23, 3103487 },
	{ 25, 5200639 },
	{ 25, 7297791 },
	{ 25, 13589247 },
	{ 25, 15686399 },
	{ 26, 21977855 },
	{ 26, 24075007 },
	{ 26, 30366463 },
	{ 26, 32463615 },
	{ 27, 43962363 },
	{ 27, 43765755 },
	{ 26, 24088575 },
	{ 26, 22007803 },
	{ 26, 21942267 },
	{ 26, 21745659 },
	{ 25, 12029951 },
	{ 25, 10997755 },
	{ 25, 10932219 },
	{ 25, 10735611 },
	{ 23, 2985983 },
	{ 23, 2740219 },
	{ 23, 2674683 },
	{ 23, 2904059 },
	{ 23, 2707451 },
	{ 24, 7491579 },
	{ 24, 6508539 },
	{ 24, 3559419 },
	{ 24, 2576379 },
	{ 23, 2772987 },
	{ 23, 741371 },
	{ 18, 62750 },
	{ 23, 937983 },
	{ 23, 3035135 },
	{ 25, 5132287 },
	{ 25, 7229439 },
	{ 25, 13520895 },
	{ 25, 15618047 },
	{ 26, 21909503 },
	{ 26, 24006655 },
	{ 26, 30298111 },
	{ 26, 32395263 },
	{ 27, 43962107 },
	{ 27, 43765499 },
	{ 26, 24088319 },
	{ 26, 22007547 },
	{ 26, 21942011 },
	{ 26, 21745403 },
	{ 25, 12029695 },
	{ 25, 10997499 },
	{ 25, 10931963 },
	{ 25, 10735355 },
	{ 23, 2985727 },
	{ 23, 2739963 },
	{ 23, 2674427 },
	{ 23, 2903803 },
	{ 23, 2707195 },
	{ 24, 7491323 },
	{ 24, 6508283 },
	{ 24, 3559163 },
	{ 24, 2576123 },
	{ 23, 2772731 },
	{ 23, 741115 },
	{ 18, 54558 },
	{ 23, 937727 },
	{ 23, 3034879 },
	{ 25, 5132031 },
	{ 25, 7229183 },
	{ 25, 13520639 },
	{ 25, 15617791 },
	{ 26, 33541115 },
	{ 26, 33475579 },
	{ 26, 33278971 },
	{ 26, 33213435 },
	{ 26, 31443963 },
	{ 26, 31378427 },
	{ 26, 31181819 },
	{ 26, 31116283 },
	{ 25, 15715323 },
	{ 25, 15649787 },
	{ 25, 15453179 },
	{ 25, 15387643 },
	{ 24, 7851003 },
	{ 24, 7785467 },
	{ 24, 7588859 },
	{ 23, 2722815 },
	{ 22, 1952763 },
	{ 22, 1887227 },
	{ 23, 2640891 },
	{ 22, 1919995 },
	{ 24, 6441979 },
	{ 24, 3361787 },
	{ 24, 2509819 },
	{ 22, 1526779 },
	{ 23, 674811 },
	{ 17, 23454 },
	{ 23, 740351 },
	{ 23, 2837503 },
	{ 25, 4934655 },
	{ 25, 7031807 },
	{ 25, 13323263 },
	{ 25, 15420415 },
	{ 26, 33540859 },
	{ 26, 33475323 },
	{ 26, 33278715 },
	{ 26, 33213179 },
	{ 26, 31443707 },
	{ 26, 31378171 },
	{ 26, 31181563 },
	{ 26, 31116027 },
	{ 25, 15715067 },
	{ 25, 15649531 },
	{ 25, 15452923 },
	{ 25, 15387387 },
	{ 24, 7850747 },
	{ 24, 7785211 },
	{ 24, 7588603 },
	{ 23, 2722559 },
	{ 22, 1952507 },
	{ 22, 1886971 },
	{ 23, 2640635 },
	{ 22, 1919739 },
	{ 24, 6441723 },
	{ 24, 3361531 },
	{ 24, 2509563 },
	{ 22, 1526523 },
	{ 23, 674555 },
	{ 17, 19358 },
	{ 23, 740095 },
	{ 23, 2837247 },
	{ 25, 4934399 },
	{ 25, 7031551 },
	{ 25, 13323007 },
	{ 25, 15420159 },
	{ 24, 8382463 },
	{ 24, 7337979 },
	{ 24, 7321595 },
	{ 24, 7272443 },
	{ 24, 7256059 },
	{ 24, 6813691 },
	{ 24, 6797307 },
	{ 24, 6748155 },
	{ 23, 3926015 },
	{ 23, 3405819 },
	{ 23, 3389435 },
	{ 23, 3340283 },
	{ 22, 1959935 },
	{ 22, 1701883 },
	{ 22, 1685499 },
	{ 22, 1636347 },
	{ 20, 485375 },
	{ 20, 423931 },
	{ 20, 407547 },
	{ 20, 464891 },
	{ 20, 415739 },
	{ 22, 825339 },
	{ 22, 579579 },
	{ 20, 366587 },
	{ 20, 120827 },
	{ 15, 15134 },
	{ 21, 169983 },
	{ 21, 694271 },
	{ 23, 1218559 },
	{ 23, 1742847 },
	{ 23, 3315711 },
	{ 23, 3839999 },
	{ 24, 8382207 },
	{ 24, 7337723 },
	{ 24, 7321339 },
	{ 24, 7272187 },
	{ 24, 7255803 },
	{ 24, 6813435 },
	{ 24, 6797051 },
	{ 24, 6747899 },
	{ 23, 3925759 },
	{ 23, 3405563 },
	{ 23, 3389179 },
	{ 23, 3340027 },
	{ 22, 1959679 },
	{ 22, 1701627 },
	{ 22, 1685243 },
	{ 22, 1636091 },
	{ 20, 485119 },
	{ 20, 423675 },
	{ 20, 407291 },
	{ 20, 464635 },
	{ 20, 415483 },
	{ 22, 825083 },
	{ 22, 579323 },
	{ 20, 366331 },
	{ 20, 120571 },
	{ 15, 11038 },
	{ 21, 169727 },
	{ 21, 694015 },
	{ 23, 1218303 },
	{ 23, 1742591 },
	{ 23, 3315455 },
	{ 23, 3839743 },
	{ 24, 5412607 },
	{ 24, 5936895 },
	{ 24, 4191227 },
	{ 24, 4174843 },
	{ 24, 4125691 },
	{ 24, 4109307 },
	{ 24, 3666939 },
	{ 24, 3650555 },
	{ 24, 3601403 },
	{ 23, 3400703 },
	{ 23, 1831931 },
	{ 23, 1815547 },
	{ 23, 1766395 },
	{ 22, 1696767 },
	{ 22, 914427 },
	{ 22, 898043 },
	{ 22, 848891 },
	{ 20, 418815 },
	{ 20, 226299 },
	{ 20, 209915 },
	{ 20, 398331 },
	{ 20, 218107 },
	{ 22, 562171 },
	{ 20, 316411 },
	{ 20, 103419 },
	{ 15, 6558 },
	{ 20, 119807 },
	{ 20, 381951 },
	{ 22, 644095 },
	{ 22, 906239 },
	{ 22, 1692671 },
	{ 22, 1954815 },
	{ 23, 2741247 },
	{ 23, 3003391 },
	{ 23, 3789823 },
	{ 23, 4051967 },
	{ 24, 4125435 },
	{ 24, 4109051 },
	{ 24, 3666683 },
	{ 24, 3650299 },
	{ 24, 3601147 },
	{ 23, 3400447 },
	{ 23, 1831675 },
	{ 23, 1815291 },
	{ 23, 1766139 },
	{ 22, 1696511 },
	{ 22, 914171 },
	{ 22, 897787 },
	{ 22, 848635 },
	{ 20, 418559 },
	{ 20, 226043 },
	{ 20, 209659 },
	{ 20, 398075 },
	{ 20, 217851 },
	{ 22, 561915 },
	{ 20, 316155 },
	{ 20, 103163 },
	{ 15, 2462 },
	{ 20, 119551 },
	{ 20, 381695 },
	{ 22, 643839 },
	{ 22, 905983 },
	{ 22, 1692415 },
	{ 22, 1954559 },
	{ 23, 2740991 },
	{ 23, 3003135 },
	{ 22, 1047039 },
	{ 22, 785915 },
	{ 22, 781819 },
	{ 22, 769531 },
	{ 22, 765435 },
	{ 22, 654843 },
	{ 22, 650747 },
	{ 22, 638459 },
	{ 21, 457215 },
	{ 21, 327163 },
	{ 21, 323067 },
	{ 21, 310779 },
	{ 20, 227839 },
	{ 20, 163323 },
	{ 20, 159227 },
	{ 20, 146939 },
	{ 18, 55807 },
	{ 18, 40443 },
	{ 18, 36347 },
	{ 18, 50683 },
	{ 18, 38395 },
	{ 18, 75259 },
	{ 18, 13819 },
	{ 13, 4382 },
	{ 18, 26111 },
	{ 18, 91647 },
	{ 20, 157183 },
	{ 20, 222719 },
	{ 20, 419327 },
	{ 20, 484863 },
	{ 21, 681471 },
	{ 21, 747007 },
	{ 21, 943615 },
	{ 21, 1009151 },
	{ 22, 4073721 },
	{ 22, 3877113 },
	{ 22, 3811577 },
	{ 22, 2042105 },
	{ 22, 1976569 },
	{ 22, 1779961 },
	{ 21, 998653 },
	{ 21, 993529 },
	{ 21, 927993 },
	{ 21, 731385 },
	{ 20, 474365 },
	{ 20, 469241 },
	{ 20, 403705 },
	{ 20, 207097 },
	{ 18, 81149 },
	{ 18, 76025 },
	{ 18, 10489 },
	{ 18, 49401 },
	{ 18, 37113 },
	{ 18, 73977 },
	{ 18, 12537 },
	{ 13, 362 },
	{ 18, 24829 },
	{ 18, 90365 },
	{ 20, 155901 },
	{ 20, 221437 },
	{ 20, 418045 },
	{ 20, 483581 },
	{ 21, 680189 },
	{ 21, 745725 },
	{ 21, 942333 },
	{ 21, 1007869 },
	{ 22, 4073977 },
	{ 22, 3877369 },
	{ 22, 3811833 },
	{ 22, 2042361 },
	{ 22, 1976825 },
	{ 22, 1780217 },
	{ 21, 998909 },
	{ 21, 993785 },
	{ 21, 928249 },
	{ 21, 731641 },
	{ 20, 474621 },
	{ 20, 469497 },
	{ 20, 403961 },
	{ 20, 207353 },
	{ 18, 81405 },
	{ 18, 76281 },
	{ 18, 10745 },
	{ 18, 49657 },
	{ 18, 37369 },
	{ 18, 74233 },
	{ 18, 12793 },
	{ 13, 4458 },
	{ 18, 25085 },
	{ 18, 90621 },
	{ 20, 156157 },
	{ 20, 221693 },
	{ 20, 418301 },
	{ 20, 483837 },
	{ 21, 680445 },
	{ 21, 745981 },
	{ 21, 942589 },
	{ 21, 1008125 },
	{ 22, 4154105 },
	{ 22, 4088569 },
	{ 22, 3891961 },
	{ 22, 3826425 },
	{ 22, 2056953 },
	{ 22, 1991417 },
	{ 22, 1794809 },
	{ 22, 1729273 },
	{ 21, 1008377 },
	{ 21, 942841 },
	{ 21, 746233 },
	{ 21, 680697 },
	{ 20, 484089 },
	{ 20, 418553 },
	{ 20, 221945 },
	{ 20, 156409 },
	{ 18, 90873 },
	{ 18, 25337 },
	{ 20, 131833 },
	{ 18, 82681 },
	{ 20, 33529 },
	{ 13, 746 },
	{ 20, 49917 },
	{ 20, 312061 },
	{ 22, 574205 },
	{ 22, 836349 },
	{ 22, 1622781 },
	{ 22, 1884925 },
	{ 23, 2671357 },
	{ 23, 2933501 },
	{ 23, 3719933 },
	{ 23, 3982077 },
	{ 22, 4154361 },
	{ 22, 4088825 },
	{ 22, 3892217 },
	{ 22, 3826681 },
	{ 22, 2057209 },
	{ 22, 1991673 },
	{ 22, 1795065 },
	{ 22, 1729529 },
	{ 21, 1008633 },
	{ 21, 943097 },
	{ 21, 746489 },
	{ 21, 680953 },
	{ 20, 484345 },
	{ 20, 418809 },
	{ 20, 222201 },
	{ 20, 156665 },
	{ 18, 91129 },
	{ 18, 25593 },
	{ 20, 132089 },
	{ 18, 82937 },
	{ 20, 33785 },
	{ 13, 1770 },
	{ 20, 50173 },
	{ 20, 312317 },
	{ 22, 574461 },
	{ 22, 836605 },
	{ 22, 1623037 },
	{ 22, 1885181 },
	{ 23, 2671613 },
	{ 23, 2933757 },
	{ 23, 3720189 },
	{ 23, 3982333 },
	{ 22, 4159229 },
	{ 22, 4138745 },
	{ 22, 4073209 },
	{ 22, 3876601 },
	{ 22, 3811065 },
	{ 22, 2041593 },
	{ 22, 1976057 },
	{ 22, 1779449 },
	{ 21, 1013501 },
	{ 21, 993017 },
	{ 21, 927481 },
	{ 21, 730873 },
	{ 20, 489213 },
	{ 20, 468729 },
	{ 20, 403193 },
	{ 20, 206585 },
	{ 18, 95997 },
	{ 18, 75513 },
	{ 18, 9977 },
	{ 14, 5497 },
	{ 13, 3513 },
	{ 13, 2666 },
	{ 20, 34557 },
	{ 20, 296701 },
	{ 22, 558845 },
	{ 22, 820989 },
	{ 22, 1607421 },
	{ 22, 1869565 },
	{ 23, 2655997 },
	{ 23, 2918141 },
	{ 23, 3704573 },
	{ 23, 3966717 },
	{ 22, 4159485 },
	{ 22, 4139001 },
	{ 22, 4073465 },
	{ 22, 3876857 },
	{ 22, 3811321 },
	{ 22, 2041849 },
	{ 22, 1976313 },
	{ 22, 1779705 },
	{ 21, 1013757 },
	{ 21, 993273 },
	{ 21, 927737 },
	{ 21, 731129 },
	{ 20, 489469 },
	{ 20, 468985 },
	{ 20, 403449 },
	{ 20, 206841 },
	{ 18, 96253 },
	{ 18, 75769 },
	{ 18, 10233 },
	{ 14, 7545 },
	{ 12, 1721 },
	{ 13, 3690 },
	{ 20, 34813 },
	{ 20, 296957 },
	{ 22, 559101 },
	{ 22, 821245 },
	{ 22, 1607677 },
	{ 22, 1869821 },
	{ 23, 2656253 },
	{ 23, 2918397 },
	{ 23, 3704829 },
	{ 23, 3966973 },
	{ 24, 6850557 },
	{ 24, 16567037 },
	{ 24, 16304893 },
	{ 24, 15518461 },
	{ 24, 15256317 },
	{ 24, 8178429 },
	{ 24, 7916285 },
	{ 24, 7129853 },
	{ 24, 6867709 },
	{ 23, 3984125 },
	{ 23, 3721981 },
	{ 23, 2935549 },
	{ 23, 2673405 },
	{ 22, 1886973 },
	{ 22, 1624829 },
	{ 22, 838397 },
	{ 22, 576253 },
	{ 20, 314109 },
	{ 20, 51965 },
	{ 12, 2025 },
	{ 10, 425 },
	{ 11, 858 },
	{ 14, 7613 },
	{ 20, 330493 },
	{ 22, 592637 },
	{ 22, 854781 },
	{ 22, 1641213 },
	{ 22, 1903357 },
	{ 23, 2689789 },
	{ 23, 2951933 },
	{ 23, 3738365 },
	{ 23, 4000509 },
	{ 24, 6884093 },
	{ 24, 7146237 },
	{ 24, 7932669 },
	{ 24, 8194813 },
	{ 24, 15272701 },
	{ 24, 15534845 },
	{ 24, 16321277 },
	{ 24, 16583421 },
	{ 24, 6867965 },
	{ 23, 3984381 },
	{ 23, 3722237 },
	{ 23, 2935805 },
	{ 23, 2673661 },
	{ 22, 1887229 },
	{ 22, 1625085 },
	{ 22, 838653 },
	{ 22, 576509 },
	{ 20, 314365 },
	{ 20, 52221 },
	{ 12, 1849 },
	{ 9, 201 },
	{ 11, 986 },
	{ 13, 3773 },
	{ 20, 330749 },
	{ 22, 592893 },
	{ 22, 855037 },
	{ 22, 1641469 },
	{ 22, 1903613 },
	{ 23, 2690045 },
	{ 23, 2952189 },
	{ 23, 3738621 },
	{ 23, 4000765 },
	{ 24, 6884349 },
	{ 24, 7146493 },
	{ 24, 7932925 },
	{ 24, 16535293 },
	{ 24, 16273149 },
	{ 24, 15486717 },
	{ 24, 15224573 },
	{ 24, 8146685 },
	{ 24, 7884541 },
	{ 24, 7098109 },
	{ 24, 6835965 },
	{ 23, 3952381 },
	{ 23, 3690237 },
	{ 23, 2903805 },
	{ 23, 2641661 },
	{ 22, 1855229 },
	{ 22, 1593085 },
	{ 22, 806653 },
	{ 22, 544509 },
	{ 16, 14205 },
	{ 10, 477 },
	{ 24, 519929 },
	{ 11, 941 },
	{ 16, 13693 },
	{ 22, 528125 },
	{ 22, 790269 },
	{ 22, 1576701 },
	{ 22, 1838845 },
	{ 23, 2625277 },
	{ 23, 2887421 },
	{ 23, 3673853 },
	{ 23, 3935997 },
	{ 24, 6819581 },
	{ 24, 7081725 },
	{ 24, 7868157 },
	{ 24, 8130301 },
	{ 24, 15208189 },
	{ 24, 15470333 },
	{ 24, 16256765 },
	{ 24, 16518909 },
	{ 24, 7884797 },
	{ 24, 7098365 },
	{ 24, 6836221 },
	{ 23, 3952637 },
	{ 23, 3690493 },
	{ 23, 2904061 },
	{ 23, 2641917 },
	{ 22, 1855485 },
	{ 22, 1593341 },
	{ 22, 806909 },
	{ 22, 544765 },
	{ 16, 16253 },
	{ 13, 3949 },
	{ 12, 650 },
	{ 10, 461 },
	{ 16, 15741 },
	{ 22, 528381 },
	{ 22, 790525 },
	{ 22, 1576957 },
	{ 22, 1839101 },
	{ 23, 2625533 },
	{ 23, 2887677 },
	{ 23, 3674109 },
	{ 23, 3936253 },
	{ 24, 6819837 },
	{ 24, 7081981 },
	{ 24, 7868413 },
	{ 24, 16603901 },
	{ 24, 16341757 },
	{ 24, 15555325 },
	{ 24, 15293181 },
	{ 24, 8215293 },
	{ 24, 7953149 },
	{ 24, 7166717 },
	{ 24, 6904573 },
	{ 23, 4020989 },
	{ 23, 3758845 },
	{ 23, 2972413 },
	{ 23, 2710269 },
	{ 22, 1923837 },
	{ 22, 1661693 },
	{ 22, 875261 },
	{ 22, 613117 },
	{ 20, 350973 },
	{ 15, 15997 },
	{ 12, 714 },
	{ 11, 985 },
	{ 14, 8173 },
	{ 20, 39677 },
	{ 20, 105213 },
	{ 22, 170749 },
	{ 22, 236285 },
	{ 22, 432893 },
	{ 22, 498429 },
	{ 23, 695037 },
	{ 23, 760573 },
	{ 23, 957181 },
	{ 23, 1022717 },
	{ 24, 1743613 },
	{ 24, 1809149 },
	{ 24, 2005757 },
	{ 24, 2071293 },
	{ 24, 3840765 },
	{ 24, 3906301 },
	{ 24, 4102909 },
	{ 24, 4168445 },
	{ 24, 6904829 },
	{ 23, 4021245 },
	{ 23, 3759101 },
	{ 23, 2972669 },
	{ 23, 2710525 },
	{ 22, 1924093 },
	{ 22, 1661949 },
	{ 22, 875517 },
	{ 22, 613373 },
	{ 20, 351229 },
	{ 16, 32701 },
	{ 14, 7994 },
	{ 14, 8041 },
	{ 14, 7997 },
	{ 20, 39933 },
	{ 20, 105469 },
	{ 22, 171005 },
	{ 22, 236541 },
	{ 22, 433149 },
	{ 22, 498685 },
	{ 23, 695293 },
	{ 23, 760829 },
	{ 23, 957437 },
	{ 23, 1022973 },
	{ 24, 1743869 },
	{ 24, 1809405 },
	{ 24, 2006013 },
	{ 24, 2071549 },
	{ 24, 3841021 },
	{ 24, 3906557 },
	{ 24, 4103165 },
	{ 24, 4168701 },
	{ 26, 27418365 },
	{ 25, 15884029 },
	{ 25, 14835453 },
	{ 25, 11689725 },
	{ 25, 10641149 },
	{ 24, 7495421 },
	{ 24, 6446845 },
	{ 24, 3301117 },
	{ 24, 2252541 },
	{ 22, 1203965 },
	{ 22, 155389 },
	{ 15, 14874 },
	{ 16, 32377 },
	{ 16, 30585 },
	{ 20, 57081 },
	{ 20, 122617 },
	{ 20, 368381 },
	{ 22, 253689 },
	{ 22, 450297 },
	{ 22, 515833 },
	{ 22, 1548029 },
	{ 23, 777977 },
	{ 23, 974585 },
	{ 23, 1040121 },
	{ 23, 3120893 },
	{ 24, 1826553 },
	{ 24, 2023161 },
	{ 24, 2088697 },
	{ 24, 3858169 },
	{ 24, 3923705 },
	{ 24, 4120313 },
	{ 24, 4185849 },
	{ 24, 8363773 },
	{ 25, 15884285 },
	{ 25, 14835709 },
	{ 25, 11689981 },
	{ 25, 10641405 },
	{ 24, 7495677 },
	{ 24, 6447101 },
	{ 24, 3301373 },
	{ 24, 2252797 },
	{ 22, 1204221 },
	{ 22, 155645 },
	{ 15, 15898 },
	{ 17, 65465 },
	{ 16, 32633 },
	{ 20, 57337 },
	{ 20, 122873 },
	{ 20, 368637 },
	{ 22, 253945 },
	{ 22, 450553 },
	{ 22, 516089 },
	{ 22, 1548285 },
	{ 23, 778233 },
	{ 23, 974841 },
	{ 23, 1040377 },
	{ 23, 3121149 },
	{ 24, 1826809 },
	{ 24, 2023417 },
	{ 24, 2088953 },
	{ 24, 3858425 },
	{ 24, 3923961 },
	{ 24, 4120569 },
	{ 24, 4186105 },
	{ 24, 8364029 },
	{ 27, 63777533 },
	{ 27, 59583229 },
	{ 27, 47000317 },
	{ 27, 42806013 },
	{ 26, 30223101 },
	{ 26, 26028797 },
	{ 26, 13445885 },
	{ 26, 9251581 },
	{ 24, 5057277 },
	{ 24, 862973 },
	{ 16, 21146 },
	{ 24, 600825 },
	{ 22, 1387257 },
	{ 24, 2173689 },
	{ 22, 1256185 },
	{ 22, 1518329 },
	{ 24, 4926201 },
	{ 24, 5188345 },
	{ 24, 5974777 },
	{ 24, 6236921 },
	{ 25, 11217657 },
	{ 25, 11479801 },
	{ 25, 12266233 },
	{ 25, 12528377 },
	{ 26, 23800569 },
	{ 26, 24062713 },
	{ 26, 24849145 },
	{ 26, 25111289 },
	{ 26, 32189177 },
	{ 26, 32451321 },
	{ 26, 33237753 },
	{ 26, 33499897 },
	{ 27, 63777789 },
	{ 27, 59583485 },
	{ 27, 47000573 },
	{ 27, 42806269 },
	{ 26, 30223357 },
	{ 26, 26029053 },
	{ 26, 13446141 },
	{ 26, 9251837 },
	{ 24, 5057533 },
	{ 24, 863229 },
	{ 16, 22170 },
	{ 24, 601081 },
	{ 22, 1387513 },
	{ 24, 2173945 },
	{ 22, 1256441 },
	{ 22, 1518585 },
	{ 24, 4926457 },
	{ 24, 5188601 },
	{ 24, 5975033 },
	{ 24, 6237177 },
	{ 25, 11217913 },
	{ 25, 11480057 },
	{ 25, 12266489 },
	{ 25, 12528633 },
	{ 26, 23800825 },
	{ 26, 24062969 },
	{ 26, 24849401 },
	{ 26, 25111545 },
	{ 26, 32189433 },
	{ 26, 32451577 },
	{ 26, 33238009 },
	{ 26, 33500153 },
	{ 27, 64564989 },
	{ 27, 60370685 },
	{ 27, 47787773 },
	{ 27, 43593469 },
	{ 26, 31010557 },
	{ 26, 26816253 },
	{ 26, 14233341 },
	{ 26, 10039037 },
	{ 24, 5844733 },
	{ 24, 1650429 },
	{ 18, 92442 },
	{ 24, 863993 },
	{ 24, 4796153 },
	{ 24, 2436857 },
	{ 24, 3223289 },
	{ 24, 2305785 },
	{ 24, 2567929 },
	{ 24, 3550973 },
	{ 26, 9383673 },
	{ 26, 10170105 },
	{ 26, 10432249 },
	{ 26, 14561021 },
	{ 27, 19869433 },
	{ 27, 20655865 },
	{ 27, 20918009 },
	{ 27, 29241085 },
	{ 28, 40840953 },
	{ 28, 41627385 },
	{ 28, 41889529 },
	{ 28, 48967417 },
	{ 28, 49229561 },
	{ 28, 50015993 },
	{ 27, 64565245 },
	{ 27, 60370941 },
	{ 27, 47788029 },
	{ 27, 43593725 },
	{ 26, 31010813 },
	{ 26, 26816509 },
	{ 26, 14233597 },
	{ 26, 10039293 },
	{ 24, 5844989 },
	{ 24, 1650685 },
	{ 18, 96538 },
	{ 24, 864249 },
	{ 24, 4796409 },
	{ 24, 2437113 },
	{ 24, 3223545 },
	{ 24, 2306041 },
	{ 24, 2568185 },
	{ 24, 3551229 },
	{ 26, 9383929 },
	{ 26, 10170361 },
	{ 26, 10432505 },
	{ 26, 14561277 },
	{ 27, 19869689 },
	{ 27, 20656121 },
	{ 27, 20918265 },
	{ 27, 29241341 },
	{ 28, 40841209 },
	{ 28, 41627641 },
	{ 28, 41889785 },
	{ 28, 48967673 },
	{ 28, 49229817 },
	{ 28, 50016249 },
	{ 27, 64830205 },
	{ 27, 60635901 },
	{ 27, 48052989 },
	{ 27, 43858685 },
	{ 26, 31275773 },
	{ 26, 27081469 },
	{ 26, 14498557 },
	{ 26, 10304253 },
	{ 24, 6109949 },
	{ 24, 1915645 },
	{ 18, 117146 },
	{ 24, 1653497 },
	{ 24, 5061369 },
	{ 25, 10027003 },
	{ 24, 3488505 },
	{ 24, 6372089 },
	{ 24, 3357433 },
	{ 24, 3619577 },
	{ 24, 6699773 },
	{ 25, 11993087 },
	{ 26, 14367481 },
	{ 26, 14629625 },
	{ 26, 27147005 },
	{ 27, 28261113 },
	{ 27, 29047545 },
	{ 27, 29309689 },
	{ 27, 54409981 },
	{ 28, 57621241 },
	{ 28, 58407673 },
	{ 28, 58669817 },
	{ 28, 65747705 },
	{ 28, 66009849 },
	{ 27, 64830461 },
	{ 27, 60636157 },
	{ 27, 48053245 },
	{ 27, 43858941 },
	{ 26, 31276029 },
	{ 26, 27081725 },
	{ 26, 14498813 },
	{ 26, 10304509 },
	{ 24, 6110205 },
	{ 24, 1915901 },
	{ 18, 121242 },
	{ 24, 1653753 },
	{ 24, 5061625 },
	{ 25, 10026747 },
	{ 24, 3488761 },
	{ 24, 6372345 },
	{ 24, 3357689 },
	{ 24, 3619833 },
	{ 24, 6700029 },
	{ 25, 11992831 },
	{ 26, 14367737 },
	{ 26, 14629881 },
	{ 26, 27147261 },
	{ 27, 28261369 },
	{ 27, 29047801 },
	{ 27, 29309945 },
	{ 27, 54410237 },
	{ 28, 57621497 },
	{ 28, 58407929 },
	{ 28, 58670073 },
	{ 28, 65747961 },
	{ 28, 66010105 },
	{ 28, 66796537 },
	{ 28, 67058681 },
	{ 28, 94977789 },
	{ 28, 86589181 },
	{ 27, 61423357 },
	{ 27, 53034749 },
	{ 27, 27868925 },
	{ 27, 19480317 },
	{ 25, 11091709 },
	{ 25, 2703101 },
	{ 18, 125722 },
	{ 24, 1916665 },
	{ 24, 5848825 },
	{ 25, 11598843 },
	{ 26, 13188857 },
	{ 24, 6635257 },
	{ 24, 7421689 },
	{ 24, 6504185 },
	{ 24, 6766329 },
	{ 24, 7749373 },
	{ 25, 12516351 },
	{ 26, 26951417 },
	{ 26, 27213561 },
	{ 26, 31342333 },
	{ 27, 53427961 },
	{ 27, 54214393 },
	{ 27, 54476537 },
	{ 27, 62799613 },
	{ 28, 107953913 },
	{ 28, 108740345 },
	{ 28, 109002489 },
	{ 28, 116080377 },
	{ 28, 116342521 },
	{ 28, 117128953 },
	{ 28, 117391097 },
	{ 28, 134102781 },
	{ 27, 61423613 },
	{ 27, 53035005 },
	{ 27, 27869181 },
	{ 27, 19480573 },
	{ 25, 11091965 },
	{ 25, 2703357 },
	{ 18, 129818 },
	{ 24, 1916921 },
	{ 24, 5849081 },
	{ 25, 11598587 },
	{ 26, 13189113 },
	{ 24, 6635513 },
	{ 24, 7421945 },
	{ 24, 6504441 },
	{ 24, 6766585 },
	{ 24, 7749629 },
	{ 25, 12516095 },
	{ 26, 26951673 },
	{ 26, 27213817 },
	{ 26, 31342589 },
	{ 27, 53428217 },
	{ 27, 54214649 },
	{ 27, 54476793 },
	{ 27, 62799869 },
	{ 28, 107954169 },
	{ 28, 108740601 },
	{ 28, 109002745 },
	{ 28, 116080633 },
	{ 28, 116342777 },
	{ 28, 117129209 },
	{ 28, 117391353 },
	{ 28, 86862589 },
	{ 27, 61696765 },
	{ 27, 53308157 },
	{ 27, 28142333 },
	{ 27, 19753725 },
	{ 25, 11365117 },
	{ 25, 2976509 },
	{ 19, 215962 },
	{ 25, 2714361 },
	{ 24, 6122233 },
	{ 25, 12120059 },
	{ 26, 13462265 },
	{ 26, 25783033 },
	{ 24, 7695097 },
	{ 25, 10578681 },
	{ 24, 7564025 },
	{ 24, 7826169 },
	{ 25, 10906365 },
	{ 26, 30370553 },
	{ 26, 31156985 },
	{ 26, 31419129 },
	{ 27, 61565689 },
	{ 27, 61827833 },
	{ 27, 62614265 },
	{ 27, 62876409 },
	{ 28, 124480249 },
	{ 28, 124742393 },
	{ 28, 125528825 },
	{ 28, 125790969 },
	{ 28, 132868857 },
	{ 28, 133131001 },
	{ 28, 133917433 },
	{ 28, 134179577 },
	{ 27, 61697021 },
	{ 27, 53308413 },
	{ 27, 28142589 },
	{ 27, 19753981 },
	{ 25, 11365373 },
	{ 25, 2976765 },
	{ 19, 220058 },
	{ 25, 2714617 },
	{ 24, 6122489 },
	{ 25, 12119803 },
	{ 26, 13462521 },
	{ 26, 25783289 },
	{ 24, 7695353 },
	{ 25, 10578937 },
	{ 24, 7564281 },
	{ 24, 7826425 },
	{ 25, 10906621 },
	{ 26, 30370809 },
	{ 26, 31157241 },
	{ 26, 31419385 },
	{ 27, 61565945 },
	{ 27, 61828089 },
	{ 27, 62614521 },
	{ 27, 62876665 },
	{ 28, 124480505 },
	{ 28, 124742649 },
	{ 28, 125529081 },
	{ 28, 125791225 },
	{ 28, 132869113 },
	{ 28, 133131257 },
	{ 28, 133917689 },
	{ 28, 134179833 },
	{ 27, 62484221 },
	{ 27, 54095613 },
	{ 27, 28929789 },
	{ 27, 20541181 },
	{ 25, 12152573 },
	{ 25, 3763965 },
	{ 20, 447770 },
	{ 25, 2977529 },
	{ 25, 11103993 },
	{ 26, 10317561 },
	{ 26, 14249721 },
	{ 26, 26046201 },
	{ 26, 29978361 },
	{ 25, 10841849 },
	{ 25, 11628281 },
	{ 25, 10710777 },
	{ 25, 10972921 },
	{ 25, 11955965 },
	{ 26, 22998015 },
	{ 27, 43740921 },
	{ 27, 44003065 },
	{ 27, 48131837 },
	{ 28, 86994681 },
	{ 28, 87781113 },
	{ 28, 88043257 },
	{ 28, 96366333 },
	{ 29, 175075065 },
	{ 29, 175861497 },
	{ 28, 129593341 },
	{ 28, 121204733 },
	{ 28, 96038909 },
	{ 28, 87650301 },
	{ 27, 62484477 },
	{ 27, 54095869 },
	{ 27, 28930045 },
	{ 27, 20541437 },
	{ 25, 12152829 },
	{ 25, 3764221 },
	{ 20, 455962 },
	{ 25, 2977785 },
	{ 25, 11104249 },
	{ 26, 10317817 },
	{ 26, 14249977 },
	{ 26, 26046457 },
	{ 26, 29978617 },
	{ 25, 10842105 },
	{ 25, 11628537 },
	{ 25, 10711033 },
	{ 25, 10973177 },
	{ 25, 11956221 },
	{ 26, 22997759 },
	{ 27, 43741177 },
	{ 27, 44003321 },
	{ 27, 48132093 },
	{ 28, 86994937 },
	{ 28, 87781369 },
	{ 28, 88043513 },
	{ 28, 96366589 },
	{ 29, 175075321 },
	{ 29, 175861753 },
	{ 28, 129858301 },
	{ 28, 121469693 },
	{ 28, 96303869 },
	{ 28, 87915261 },
	{ 27, 62749437 },
	{ 27, 54360829 },
	{ 27, 29195005 },
	{ 27, 20806397 },
	{ 25, 12417789 },
	{ 25, 4029181 },
	{ 20, 497050 },
	{ 20, 1045998 },
	{ 25, 11369209 },
	{ 26, 22593531 },
	{ 26, 14514937 },
	{ 26, 26835705 },
	{ 26, 30243577 },
	{ 27, 42564345 },
	{ 25, 11893497 },
	{ 25, 14777081 },
	{ 25, 11762425 },
	{ 25, 12024569 },
	{ 25, 15104765 },
	{ 26, 24559615 },
	{ 27, 47938297 },
	{ 27, 48200441 },
	{ 27, 60717821 },
	{ 28, 95386361 },
	{ 28, 96172793 },
	{ 28, 96434937 },
	{ 28, 121535229 },
	{ 29, 191855353 },
	{ 28, 129858557 },
	{ 28, 121469949 },
	{ 28, 96304125 },
	{ 28, 87915517 },
	{ 27, 62749693 },
	{ 27, 54361085 },
	{ 27, 29195261 },
	{ 27, 20806653 },
	{ 25, 12418045 },
	{ 25, 4029437 },
	{ 20, 505242 },
	{ 20, 1037806 },
	{ 25, 11369465 },
	{ 26, 22593275 },
	{ 26, 14515193 },
	{ 26, 26835961 },
	{ 26, 30243833 },
	{ 27, 42564601 },
	{ 25, 11893753 },
	{ 25, 14777337 },
	{ 25, 11762681 },
	{ 25, 12024825 },
	{ 25, 15105021 },
	{ 26, 24559359 },
	{ 27, 47938553 },
	{ 27, 48200697 },
	{ 27, 60718077 },
	{ 28, 95386617 },
	{ 28, 96173049 },
	{ 28, 96435193 },
	{ 28, 121535485 },
	{ 29, 191855609 },
	{ 29, 259816441 },
	{ 29, 250117113 },
	{ 29, 200047609 },
	{ 29, 184056825 },
	{ 28, 133987321 },
	{ 28, 107577085 },
	{ 28, 57245437 },
	{ 28, 40468221 },
	{ 26, 23691005 },
	{ 26, 6913789 },
	{ 20, 513818 },
	{ 20, 1029998 },
	{ 25, 12156665 },
	{ 26, 24165371 },
	{ 27, 27885305 },
	{ 26, 27098873 },
	{ 26, 31031033 },
	{ 27, 42827513 },
	{ 27, 46759673 },
	{ 25, 15040249 },
	{ 25, 15826681 },
	{ 25, 14909177 },
	{ 25, 15171321 },
	{ 25, 16154365 },
	{ 26, 25082879 },
	{ 27, 60522233 },
	{ 27, 60784377 },
	{ 27, 64913149 },
	{ 28, 120553209 },
	{ 28, 121339641 },
	{ 28, 121601785 },
	{ 28, 129924861 },
	{ 29, 259555065 },
	{ 29, 243039993 },
	{ 29, 199786233 },
	{ 29, 183271161 },
	{ 28, 133725945 },
	{ 28, 117210873 },
	{ 28, 57245693 },
	{ 28, 40468477 },
	{ 26, 23691261 },
	{ 26, 6914045 },
	{ 20, 522010 },
	{ 20, 1021806 },
	{ 25, 12156921 },
	{ 26, 24165115 },
	{ 27, 27885561 },
	{ 26, 27099129 },
	{ 26, 31031289 },
	{ 27, 42827769 },
	{ 27, 46759929 },
	{ 25, 15040505 },
	{ 25, 15826937 },
	{ 25, 14909433 },
	{ 25, 15171577 },
	{ 25, 16154621 },
	{ 26, 25082623 },
	{ 27, 60522489 },
	{ 27, 60784633 },
	{ 27, 64913405 },
	{ 28, 120553465 },
	{ 28, 121339897 },
	{ 28, 121602041 },
	{ 28, 129925117 },
	{ 29, 259555321 },
	{ 29, 243040249 },
	{ 29, 199786489 },
	{ 29, 183271417 },
	{ 28, 133726201 },
	{ 28, 117211129 },
	{ 29, 251625465 },
	{ 29, 81439485 },
	{ 27, 47885053 },
	{ 27, 14330621 },
	{ 20, 956314 },
	{ 20, 980974 },
	{ 26, 24816377 },
	{ 26, 24686587 },
	{ 28, 56273657 },
	{ 28, 106081017 },
	{ 27, 62565113 },
	{ 27, 62435323 },
	{ 28, 94022393 },
	{ 28, 118663929 },
	{ 26, 32156409 },
	{ 26, 32026619 },
	{ 26, 31894265 },
	{ 26, 32418553 },
	{ 26, 24948731 },
	{ 27, 47624191 },
	{ 28, 129411833 },
	{ 28, 129936121 },
	{ 28, 125612027 },
	{ 29, 257862393 },
	{ 29, 259435257 },
	{ 29, 259959545 },
	{ 29, 259829755 },
	{ 30, 485534457 },
	{ 30, 385395449 },
	{ 30, 365996793 },
	{ 29, 265857785 },
	{ 29, 233876217 },
	{ 29, 133737209 },
	{ 29, 81439741 },
	{ 27, 47885309 },
	{ 27, 14330877 },
	{ 20, 964506 },
	{ 20, 972782 },
	{ 26, 24816633 },
	{ 26, 24686331 },
	{ 28, 56273913 },
	{ 28, 106081273 },
	{ 27, 62565369 },
	{ 27, 62435067 },
	{ 28, 94022649 },
	{ 28, 118664185 },
	{ 26, 32156665 },
	{ 26, 32026363 },
	{ 26, 31894521 },
	{ 26, 32418809 },
	{ 26, 24948475 },
	{ 27, 47623935 },
	{ 28, 129412089 },
	{ 28, 129936377 },
	{ 28, 125611771 },
	{ 29, 257862649 },
	{ 29, 259435513 },
	{ 29, 259959801 },
	{ 29, 259829499 },
	{ 30, 485534713 },
	{ 30, 385395705 },
	{ 30, 365997049 },
	{ 29, 265858041 },
	{ 29, 233876473 },
	{ 29, 133737465 },
	{ 29, 83013373 },
	{ 27, 49458941 },
	{ 27, 15904509 },
	{ 21, 1944858 },
	{ 21, 1928558 },
	{ 27, 47361785 },
	{ 27, 47229947 },
	{ 28, 57847545 },
	{ 28, 106606329 },
	{ 28, 122859257 },
	{ 28, 87731961 },
	{ 28, 95596281 },
	{ 28, 119189241 },
	{ 28, 127053561 },
	{ 27, 55226105 },
	{ 27, 56798969 },
	{ 27, 54963961 },
	{ 27, 55488249 },
	{ 27, 57454333 },
	{ 27, 48147455 },
	{ 29, 490254073 },
	{ 29, 222211833 },
	{ 29, 230469373 },
	{ 29, 249474047 },
	{ 30, 444116729 },
	{ 30, 516992761 },
	{ 30, 483962617 },
	{ 30, 384872185 },
	{ 30, 351842041 },
	{ 29, 265334521 },
	{ 29, 232304377 },
	{ 29, 133213945 },
	{ 29, 100183801 },
	{ 27, 49459197 },
	{ 27, 15904765 },
	{ 21, 1961242 },
	{ 21, 1912174 },
	{ 27, 47362041 },
	{ 27, 47229691 },
	{ 28, 57847801 },
	{ 28, 106606585 },
	{ 28, 122859513 },
	{ 28, 87732217 },
	{ 28, 95596537 },
	{ 28, 119189497 },
	{ 28, 127053817 },
	{ 27, 55226361 },
	{ 27, 56799225 },
	{ 27, 54964217 },
	{ 27, 55488505 },
	{ 27, 57454589 },
	{ 27, 48147199 },
	{ 29, 490254329 },
	{ 29, 222212089 },
	{ 29, 230469629 },
	{ 29, 249473791 },
	{ 30, 444116985 },
	{ 30, 516993017 },
	{ 29, 259817471 },
	{ 29, 243040255 },
	{ 29, 192708607 },
	{ 29, 265334777 },
	{ 28, 125599743 },
	{ 28, 108822527 },
	{ 28, 58490879 },
	{ 27, 49986301 },
	{ 26, 24936447 },
	{ 21, 2043290 },
	{ 21, 1043950 },
	{ 26, 7897083 },
	{ 26, 23887867 },
	{ 28, 58374905 },
	{ 27, 29130747 },
	{ 27, 54034427 },
	{ 27, 61636603 },
	{ 28, 96123641 },
	{ 27, 48005115 },
	{ 27, 60325883 },
	{ 27, 66894585 },
	{ 26, 66551803 },
	{ 26, 28606459 },
	{ 26, 31490043 },
	{ 26, 7241723 },
	{ 26, 24018939 },
	{ 26, 24870911 },
	{ 28, 57573371 },
	{ 28, 107905019 },
	{ 28, 124682235 },
	{ 28, 125534207 },
	{ 29, 259570425 },
	{ 28, 129859579 },
	{ 29, 258899963 },
	{ 29, 191725563 },
	{ 29, 251181817 },
	{ 28, 125665275 },
	{ 28, 115965947 },
	{ 28, 65896443 },
	{ 27, 66632441 },
	{ 26, 33390587 },
	{ 21, 2047978 },
	{ 21, 1027566 },
	{ 26, 7896827 },
	{ 26, 23887611 },
	{ 28, 58375161 },
	{ 27, 29130491 },
	{ 27, 54034171 },
	{ 27, 61636347 },
	{ 28, 96123897 },
	{ 27, 48004859 },
	{ 27, 60325627 },
	{ 27, 66894841 },
	{ 26, 66551547 },
	{ 26, 28606203 },
	{ 26, 31489787 },
	{ 26, 7241467 },
	{ 26, 24018683 },
	{ 26, 24870655 },
	{ 28, 57573115 },
	{ 28, 107904763 },
	{ 28, 124681979 },
	{ 28, 125533951 },
	{ 29, 259570681 },
	{ 28, 129859323 },
	{ 29, 258899707 },
	{ 29, 191725307 },
	{ 29, 251182073 },
	{ 28, 125665019 },
	{ 28, 115965691 },
	{ 28, 65896187 },
	{ 27, 66632697 },
	{ 26, 33390331 },
	{ 21, 2064362 },
	{ 21, 1011566 },
	{ 26, 8158203 },
	{ 26, 24673275 },
	{ 28, 40664059 },
	{ 28, 108707577 },
	{ 27, 54295547 },
	{ 27, 62422011 },
	{ 28, 86801403 },
	{ 28, 121290489 },
	{ 27, 60587003 },
	{ 27, 67026685 },
	{ 26, 66485247 },
	{ 26, 65502203 },
	{ 26, 31751163 },
	{ 26, 32537595 },
	{ 26, 8027131 },
	{ 26, 24804347 },
	{ 26, 25132031 },
	{ 28, 58358779 },
	{ 28, 108690427 },
	{ 28, 125467643 },
	{ 28, 125795327 },
	{ 28, 129596411 },
	{ 28, 121469947 },
	{ 29, 259685371 },
	{ 29, 250658553 },
	{ 28, 125402107 },
	{ 28, 108887035 },
	{ 28, 65633275 },
	{ 27, 66109177 },
	{ 26, 33127419 },
	{ 21, 2080618 },
	{ 21, 995182 },
	{ 26, 8157947 },
	{ 26, 24673019 },
	{ 28, 40663803 },
	{ 28, 108707833 },
	{ 27, 54295291 },
	{ 27, 62421755 },
	{ 28, 86801147 },
	{ 28, 121290745 },
	{ 27, 60586747 },
	{ 27, 67026941 },
	{ 26, 66484991 },
	{ 26, 65501947 },
	{ 26, 31750907 },
	{ 26, 32537339 },
	{ 26, 8026875 },
	{ 26, 24804091 },
	{ 26, 25131775 },
	{ 28, 58358523 },
	{ 28, 108690171 },
	{ 28, 125467387 },
	{ 28, 125795071 },
	{ 28, 129596155 },
	{ 28, 121469691 },
	{ 29, 259685115 },
	{ 29, 250658809 },
	{ 28, 125401851 },
	{ 28, 108886779 },
	{ 28, 65633019 },
	{ 27, 66109433 },
	{ 26, 33127163 },
	{ 21, 2097002 },
	{ 21, 913390 },
	{ 26, 15233019 },
	{ 26, 24932347 },
	{ 28, 41447419 },
	{ 28, 57438203 },
	{ 28, 125496057 },
	{ 27, 62681083 },
	{ 28, 87584763 },
	{ 28, 95186939 },
	{ 28, 129690361 },
	{ 27, 64778235 },
	{ 27, 66513661 },
	{ 26, 65433599 },
	{ 26, 62353403 },
	{ 26, 32796667 },
	{ 26, 60846075 },
	{ 26, 8286203 },
	{ 26, 25063419 },
	{ 26, 32206847 },
	{ 28, 58617851 },
	{ 28, 108949499 },
	{ 28, 125726715 },
	{ 28, 128806907 },
	{ 28, 121204731 },
	{ 28, 96301051 },
	{ 29, 249096953 },
	{ 28, 124612603 },
	{ 28, 108621819 },
	{ 28, 58552315 },
	{ 27, 64547577 },
	{ 26, 32337915 },
	{ 26, 16347131 },
	{ 21, 897006 },
	{ 26, 15232763 },
	{ 26, 24932091 },
	{ 28, 41447163 },
	{ 28, 57437947 },
	{ 28, 125496313 },
	{ 27, 62680827 },
	{ 28, 87584507 },
	{ 28, 95186683 },
	{ 28, 129690617 },
	{ 27, 64777979 },
	{ 27, 66513917 },
	{ 26, 65433343 },
	{ 26, 62353147 },
	{ 26, 32796411 },
	{ 26, 60845819 },
	{ 26, 8285947 },
	{ 26, 25063163 },
	{ 26, 32206591 },
	{ 28, 58617595 },
	{ 28, 108949243 },
	{ 28, 125726459 },
	{ 28, 128806651 },
	{ 28, 121204475 },
	{ 28, 96300795 },
	{ 29, 249097209 },
	{ 28, 124612347 },
	{ 28, 108621563 },
	{ 28, 58552059 },
	{ 27, 64547833 },
	{ 26, 32337659 },
	{ 26, 16346875 },
	{ 21, 884078 },
	{ 26, 15494139 },
	{ 26, 32009211 },
	{ 28, 41708539 },
	{ 28, 58223611 },
	{ 28, 107768827 },
	{ 28, 124283899 },
	{ 28, 87845883 },
	{ 28, 95972347 },
	{ 28, 120351739 },
	{ 28, 128478203 },
	{ 28, 110914555 },
	{ 27, 64941821 },
	{ 26, 62286847 },
	{ 26, 61303803 },
	{ 26, 61107195 },
	{ 26, 61893627 },
	{ 26, 15363067 },
	{ 26, 32140283 },
	{ 26, 32467967 },
	{ 28, 65694715 },
	{ 28, 116026363 },
	{ 28, 132803579 },
	{ 28, 120417275 },
	{ 28, 96037883 },
	{ 28, 87911419 },
	{ 28, 124349435 },
	{ 28, 107834363 },
	{ 28, 58289147 },
	{ 27, 64024313 },
	{ 26, 32074747 },
	{ 26, 15559675 },
	{ 21, 867694 },
	{ 26, 15493883 },
	{ 26, 32008955 },
	{ 28, 41708283 },
	{ 28, 58223355 },
	{ 28, 107768571 },
	{ 28, 124283643 },
	{ 28, 87845627 },
	{ 28, 95972091 },
	{ 28, 120351483 },
	{ 28, 128477947 },
	{ 28, 110914299 },
	{ 27, 64942077 },
	{ 26, 62286591 },
	{ 26, 61303547 },
	{ 26, 61106939 },
	{ 26, 61893371 },
	{ 26, 15362811 },
	{ 26, 32140027 },
	{ 26, 32467711 },
	{ 28, 65694459 },
	{ 28, 116026107 },
	{ 28, 132803323 },
	{ 28, 120417019 },
	{ 28, 96037627 },
	{ 28, 87911163 },
	{ 28, 124349179 },
	{ 28, 107834107 },
	{ 28, 58288891 },
	{ 27, 64024569 },
	{ 26, 32074491 },
	{ 26, 15559419 },
	{ 20, 523758 },
	{ 26, 16269307 },
	{ 26, 32260091 },
	{ 28, 48775163 },
	{ 28, 58474491 },
	{ 28, 108543995 },
	{ 28, 124534779 },
	{ 29, 192609017 },
	{ 28, 96223227 },
	{ 28, 121126907 },
	{ 28, 128729083 },
	{ 28, 132071419 },
	{ 28, 115097595 },
	{ 27, 64420605 },
	{ 26, 61227007 },
	{ 26, 32980987 },
	{ 26, 62144507 },
	{ 26, 65028091 },
	{ 26, 15613947 },
	{ 26, 32391163 },
	{ 26, 33243135 },
	{ 28, 129563385 },
	{ 27, 64831483 },
	{ 28, 133054459 },
	{ 28, 95240187 },
	{ 28, 125369081 },
	{ 27, 62734331 },
	{ 28, 107560955 },
	{ 28, 57491451 },
	{ 27, 49871609 },
	{ 26, 24985595 },
	{ 26, 15286267 },
	{ 20, 507374 },
	{ 26, 16269051 },
	{ 26, 32259835 },
	{ 28, 48774907 },
	{ 28, 58474235 },
	{ 28, 108543739 },
	{ 28, 124534523 },
	{ 29, 192609273 },
	{ 28, 96222971 },
	{ 28, 121126651 },
	{ 28, 128728827 },
	{ 28, 132071163 },
	{ 28, 115097339 },
	{ 27, 64420861 },
	{ 26, 61226751 },
	{ 26, 32980731 },
	{ 26, 62144251 },
	{ 26, 65027835 },
	{ 26, 15613691 },
	{ 26, 32390907 },
	{ 26, 33242879 },
	{ 28, 129563641 },
	{ 27, 64831227 },
	{ 28, 133054203 },
	{ 28, 95239931 },
	{ 28, 125369337 },
	{ 27, 62734075 },
	{ 28, 107560699 },
	{ 28, 57491195 },
	{ 27, 49871865 },
	{ 26, 24985339 },
	{ 26, 15286011 },
	{ 20, 491374 },
	{ 26, 16530427 },
	{ 26, 33045499 },
	{ 28, 49036283 },
	{ 28, 65551355 },
	{ 28, 108805115 },
	{ 28, 125320187 },
	{ 29, 174865403 },
	{ 29, 242941689 },
	{ 28, 121388027 },
	{ 28, 129514491 },
	{ 28, 132004863 },
	{ 28, 127876091 },
	{ 28, 127679483 },
	{ 27, 50265853 },
	{ 26, 32914431 },
	{ 26, 31931387 },
	{ 26, 65289211 },
	{ 26, 66075643 },
	{ 26, 16399355 },
	{ 26, 33176571 },
	{ 26, 33504255 },
	{ 27, 64568315 },
	{ 27, 60636155 },
	{ 28, 133839867 },
	{ 28, 124845817 },
	{ 27, 62471163 },
	{ 27, 54344699 },
	{ 28, 57228283 },
	{ 27, 49348345 },
	{ 26, 24722427 },
	{ 26, 8207355 },
	{ 20, 474990 },
	{ 26, 16530171 },
	{ 26, 33045243 },
	{ 28, 49036027 },
	{ 28, 65551099 },
	{ 28, 108804859 },
	{ 28, 125319931 },
	{ 29, 174865147 },
	{ 29, 242941945 },
	{ 28, 121387771 },
	{ 28, 129514235 },
	{ 28, 132004607 },
	{ 28, 127875835 },
	{ 28, 127679227 },
	{ 27, 50266109 },
	{ 26, 32914175 },
	{ 26, 31931131 },
	{ 26, 65288955 },
	{ 26, 66075387 },
	{ 26, 16399099 },
	{ 26, 33176315 },
	{ 26, 33503999 },
	{ 27, 64568059 },
	{ 27, 60635899 },
	{ 28, 133839611 },
	{ 28, 124846073 },
	{ 27, 62470907 },
	{ 27, 54344443 },
	{ 28, 57228027 },
	{ 27, 49348601 },
	{ 26, 24722171 },
	{ 26, 8207099 },
	{ 20, 393198 },
	{ 26, 15284991 },
	{ 26, 33304571 },
	{ 28, 49819643 },
	{ 28, 65810427 },
	{ 28, 115879931 },
	{ 28, 125579259 },
	{ 29, 175648763 },
	{ 29, 191639547 },
	{ 29, 241709051 },
	{ 28, 129773563 },
	{ 29, 221786107 },
	{ 28, 127807487 },
	{ 28, 115290107 },
	{ 28, 131870715 },
	{ 28, 99461885 },
	{ 26, 31862783 },
	{ 26, 28782587 },
	{ 26, 66334715 },
	{ 26, 31535099 },
	{ 26, 16658427 },
	{ 26, 33435643 },
	{ 27, 63778811 },
	{ 27, 60370939 },
	{ 27, 48050171 },
	{ 28, 134098939 },
	{ 27, 61681659 },
	{ 27, 54079483 },
	{ 27, 29175803 },
	{ 28, 95529721 },
	{ 26, 23932923 },
	{ 26, 7942139 },
	{ 20, 376814 },
	{ 26, 8204287 },
	{ 26, 33304315 },
	{ 28, 49819387 },
	{ 28, 65810171 },
	{ 28, 115879675 },
	{ 28, 125579003 },
	{ 29, 175648507 },
	{ 29, 191639291 },
	{ 29, 241708795 },
	{ 28, 129773307 },
	{ 29, 221785851 },
	{ 28, 127807231 },
	{ 28, 115289851 },
	{ 28, 131870459 },
	{ 28, 99462141 },
	{ 26, 31862527 },
	{ 26, 28782331 },
	{ 26, 66334459 },
	{ 26, 31534843 },
	{ 26, 16658171 },
	{ 26, 33435387 },
	{ 27, 63778555 },
	{ 27, 60370683 },
	{ 27, 48049915 },
	{ 28, 134098683 },
	{ 27, 61681403 },
	{ 27, 54079227 },
	{ 27, 29175547 },
	{ 28, 95529977 },
	{ 26, 23932667 },
	{ 26, 7941883 },
	{ 20, 372126 },
	{ 26, 8204031 },
	{ 26, 24981247 },
	{ 28, 50080763 },
	{ 28, 66595835 },
	{ 28, 116141051 },
	{ 28, 132656123 },
	{ 29, 175909883 },
	{ 29, 192424955 },
	{ 29, 241970171 },
	{ 29, 258485243 },
	{ 29, 222047227 },
	{ 29, 230173691 },
	{ 28, 115223551 },
	{ 28, 111094779 },
	{ 28, 245115899 },
	{ 28, 96317181 },
	{ 26, 28716031 },
	{ 26, 27732987 },
	{ 26, 27470843 },
	{ 26, 28388347 },
	{ 26, 27601915 },
	{ 27, 63515643 },
	{ 27, 59583483 },
	{ 27, 47787003 },
	{ 27, 43854843 },
	{ 27, 61418491 },
	{ 27, 53292027 },
	{ 27, 28912635 },
	{ 27, 20786171 },
	{ 26, 23669755 },
	{ 26, 7154683 },
	{ 20, 355614 },
	{ 26, 7941119 },
	{ 26, 24718335 },
	{ 28, 50080507 },
	{ 28, 66595579 },
	{ 28, 116140795 },
	{ 28, 132655867 },
	{ 29, 175909627 },
	{ 29, 192424699 },
	{ 29, 241969915 },
	{ 29, 258484987 },
	{ 29, 222046971 },
	{ 29, 230173435 },
	{ 28, 115223295 },
	{ 28, 111094523 },
	{ 28, 245115643 },
	{ 28, 96317437 },
	{ 26, 28715775 },
	{ 26, 27732731 },
	{ 26, 27470587 },
	{ 26, 28388091 },
	{ 26, 27601659 },
	{ 27, 63515387 },
	{ 27, 59583227 },
	{ 27, 47786747 },
	{ 27, 43854587 },
	{ 27, 61418235 },
	{ 27, 53291771 },
	{ 27, 28912379 },
	{ 27, 20785915 },
	{ 26, 23669499 },
	{ 26, 7154427 },
	{ 20, 339230 },
	{ 26, 7940863 },
	{ 26, 24718079 },
	{ 27, 67100667 },
	{ 26, 16719867 },
	{ 26, 29237243 },
	{ 26, 33234939 },
	{ 27, 45752315 },
	{ 27, 48177147 },
	{ 27, 60694523 },
	{ 27, 64692219 },
	{ 26, 32497659 },
	{ 26, 32432123 },
	{ 26, 32235515 },
	{ 26, 32169979 },
	{ 25, 16244731 },
	{ 25, 16179195 },
	{ 25, 15982587 },
	{ 24, 6922239 },
	{ 23, 4055035 },
	{ 23, 3989499 },
	{ 24, 6840315 },
	{ 23, 4022267 },
	{ 25, 14835707 },
	{ 25, 11755515 },
	{ 25, 10903547 },
	{ 24, 7823355 },
	{ 25, 13262843 },
	{ 25, 7036923 },
	{ 25, 5136379 },
	{ 23, 3104763 },
	{ 24, 1728507 },
	{ 18, 128926 },
	{ 24, 1794047 },
	{ 24, 5988351 },
	{ 26, 10182655 },
	{ 26, 16719611 },
	{ 26, 29236987 },
	{ 26, 33234683 },
	{ 27, 45752059 },
	{ 27, 48176891 },
	{ 27, 60694267 },
	{ 27, 64691963 },
	{ 26, 32497403 },
	{ 26, 32431867 },
	{ 26, 32235259 },
	{ 26, 32169723 },
	{ 25, 16244475 },
	{ 25, 16178939 },
	{ 25, 15982331 },
	{ 24, 6921983 },
	{ 23, 4054779 },
	{ 23, 3989243 },
	{ 24, 6840059 },
	{ 23, 4022011 },
	{ 25, 14835451 },
	{ 25, 11755259 },
	{ 25, 10903291 },
	{ 24, 7823099 },
	{ 25, 13262587 },
	{ 25, 7036667 },
	{ 25, 5136123 },
	{ 23, 3104507 },
	{ 24, 1728251 },
	{ 18, 120734 },
	{ 24, 1793791 },
	{ 24, 5988095 },
	{ 26, 10182399 },
	{ 26, 14376703 },
	{ 26, 29301755 },
	{ 26, 33430523 },
	{ 27, 45816827 },
	{ 27, 49945595 },
	{ 27, 60759035 },
	{ 27, 64887803 },
	{ 26, 32480255 },
	{ 26, 30399483 },
	{ 26, 30333947 },
	{ 26, 30137339 },
	{ 25, 16227327 },
	{ 25, 15195131 },
	{ 25, 15129595 },
	{ 25, 14932987 },
	{ 23, 4037631 },
	{ 23, 3791867 },
	{ 23, 3726331 },
	{ 23, 3955707 },
	{ 23, 3759099 },
	{ 25, 11688955 },
	{ 25, 10705915 },
	{ 24, 7756795 },
	{ 24, 6773755 },
	{ 25, 6970363 },
	{ 25, 4938747 },
	{ 23, 3038203 },
	{ 23, 1006587 },
	{ 18, 112414 },
	{ 24, 1727487 },
	{ 24, 5921791 },
	{ 26, 10116095 },
	{ 26, 14310399 },
	{ 26, 29301499 },
	{ 26, 33430267 },
	{ 27, 45816571 },
	{ 27, 49945339 },
	{ 27, 60758779 },
	{ 27, 64887547 },
	{ 26, 32479999 },
	{ 26, 30399227 },
	{ 26, 30333691 },
	{ 26, 30137083 },
	{ 25, 16227071 },
	{ 25, 15194875 },
	{ 25, 15129339 },
	{ 25, 14932731 },
	{ 23, 4037375 },
	{ 23, 3791611 },
	{ 23, 3726075 },
	{ 23, 3955451 },
	{ 23, 3758843 },
	{ 25, 11688699 },
	{ 25, 10705659 },
	{ 24, 7756539 },
	{ 24, 6773499 },
	{ 25, 6970107 },
	{ 25, 4938491 },
	{ 23, 3037947 },
	{ 23, 1006331 },
	{ 18, 104222 },
	{ 24, 1727231 },
	{ 24, 5921535 },
	{ 26, 10115839 },
	{ 26, 14310143 },
	{ 26, 26893055 },
	{ 26, 33492987 },
	{ 27, 46010363 },
	{ 27, 50008059 },
	{ 27, 62525435 },
	{ 27, 64950267 },
	{ 27, 47960059 },
	{ 26, 30380031 },
	{ 26, 24104955 },
	{ 26, 24039419 },
	{ 26, 23842811 },
	{ 25, 15175679 },
	{ 25, 12046331 },
	{ 25, 11980795 },
	{ 25, 11784187 },
	{ 23, 3772415 },
	{ 23, 3002363 },
	{ 23, 2936827 },
	{ 23, 3690491 },
	{ 23, 2969595 },
	{ 25, 10637307 },
	{ 24, 7557115 },
	{ 24, 6705147 },
	{ 24, 3624955 },
	{ 25, 4870139 },
	{ 23, 2838523 },
	{ 23, 937979 },
	{ 18, 62878 },
	{ 23, 1003519 },
	{ 23, 3100671 },
	{ 25, 5197823 },
	{ 25, 7294975 },
	{ 25, 13586431 },
	{ 25, 15683583 },
	{ 26, 21975039 },
	{ 26, 24072191 },
	{ 26, 30363647 },
	{ 26, 32460799 },
	{ 27, 47959803 },
	{ 26, 30379775 },
	{ 26, 24104699 },
	{ 26, 24039163 },
	{ 26, 23842555 },
	{ 25, 15175423 },
	{ 25, 12046075 },
	{ 25, 11980539 },
	{ 25, 11783931 },
	{ 23, 3772159 },
	{ 23, 3002107 },
	{ 23, 2936571 },
	{ 23, 3690235 },
	{ 23, 2969339 },
	{ 25, 10637051 },
	{ 24, 7556859 },
	{ 24, 6704891 },
	{ 24, 3624699 },
	{ 25, 4869883 },
	{ 23, 2838267 },
	{ 23, 937723 },
	{ 18, 54686 },
	{ 23, 1003263 },
	{ 23, 3100415 },
	{ 25, 5197567 },
	{ 25, 7294719 },
	{ 25, 13586175 },
	{ 25, 15683327 },
	{ 26, 21974783 },
	{ 26, 24071935 },
	{ 26, 30363391 },
	{ 26, 32460543 },
	{ 27, 43961339 },
	{ 27, 43764731 },
	{ 26, 24087551 },
	{ 26, 22006779 },
	{ 26, 21941243 },
	{ 26, 21744635 },
	{ 25, 12028927 },
	{ 25, 10996731 },
	{ 25, 10931195 },
	{ 25, 10734587 },
	{ 23, 2984959 },
	{ 23, 2739195 },
	{ 23, 2673659 },
	{ 23, 2903035 },
	{ 23, 2706427 },
	{ 24, 7490555 },
	{ 24, 6507515 },
	{ 24, 3558395 },
	{ 24, 2575355 },
	{ 23, 2771963 },
	{ 23, 740347 },
	{ 18, 46366 },
	{ 23, 936959 },
	{ 23, 3034111 },
	{ 25, 5131263 },
	{ 25, 7228415 },
	{ 25, 13519871 },
	{ 25, 15617023 },
	{ 26, 21908479 },
	{ 26, 24005631 },
	{ 26, 30297087 },
	{ 26, 32394239 },
	{ 27, 43961083 },
	{ 27, 43764475 },
	{ 26, 24087295 },
	{ 26, 22006523 },
	{ 26, 21940987 },
	{ 26, 21744379 },
	{ 25, 12028671 },
	{ 25, 10996475 },
	{ 25, 10930939 },
	{ 25, 10734331 },
	{ 23, 2984703 },
	{ 23, 2738939 },
	{ 23, 2673403 },
	{ 23, 2902779 },
	{ 23, 2706171 },
	{ 24, 7490299 },
	{ 24, 6507259 },
	{ 24, 3558139 },
	{ 24, 2575099 },
	{ 23, 2771707 },
	{ 23, 740091 },
	{ 18, 38174 },
	{ 23, 936703 },
	{ 23, 3033855 },
	{ 25, 5131007 },
	{ 25, 7228159 },
	{ 25, 13519615 },
	{ 25, 15616767 },
	{ 24, 8386555 },
	{ 24, 8370171 },
	{ 24, 8321019 },
	{ 24, 8304635 },
	{ 24, 7862267 },
	{ 24, 7845883 },
	{ 24, 7796731 },
	{ 24, 7780347 },
	{ 23, 3930107 },
	{ 23, 3913723 },
	{ 23, 3864571 },
	{ 23, 3848187 },
	{ 22, 1964027 },
	{ 22, 1947643 },
	{ 22, 1898491 },
	{ 21, 681983 },
	{ 20, 489467 },
	{ 20, 473083 },
	{ 21, 661499 },
	{ 20, 481275 },
	{ 22, 1611771 },
	{ 22, 841723 },
	{ 22, 628731 },
	{ 20, 382971 },
	{ 21, 169979 },
	{ 15, 15262 },
	{ 21, 186367 },
	{ 21, 710655 },
	{ 23, 1234943 },
	{ 23, 1759231 },
	{ 23, 3332095 },
	{ 23, 3856383 },
	{ 24, 8386299 },
	{ 24, 8369915 },
	{ 24, 8320763 },
	{ 24, 8304379 },
	{ 24, 7862011 },
	{ 24, 7845627 },
	{ 24, 7796475 },
	{ 24, 7780091 },
	{ 23, 3929851 },
	{ 23, 3913467 },
	{ 23, 3864315 },
	{ 23, 3847931 },
	{ 22, 1963771 },
	{ 22, 1947387 },
	{ 22, 1898235 },
	{ 21, 681727 },
	{ 20, 489211 },
	{ 20, 472827 },
	{ 21, 661243 },
	{ 20, 481019 },
	{ 22, 1611515 },
	{ 22, 841467 },
	{ 22, 628475 },
	{ 20, 382715 },
	{ 21, 169723 },
	{ 15, 11166 },
	{ 21, 186111 },
	{ 21, 710399 },
	{ 23, 1234687 },
	{ 23, 1758975 },
	{ 23, 3331839 },
	{ 23, 3856127 },
	{ 24, 5428991 },
	{ 24, 7336955 },
	{ 24, 7320571 },
	{ 24, 7271419 },
	{ 24, 7255035 },
	{ 24, 6812667 },
	{ 24, 6796283 },
	{ 24, 6747131 },
	{ 23, 3924991 },
	{ 23, 3404795 },
	{ 23, 3388411 },
	{ 23, 3339259 },
	{ 22, 1958911 },
	{ 22, 1700859 },
	{ 22, 1684475 },
	{ 22, 1635323 },
	{ 20, 484351 },
	{ 20, 422907 },
	{ 20, 406523 },
	{ 20, 463867 },
	{ 20, 414715 },
	{ 22, 824315 },
	{ 22, 578555 },
	{ 20, 365563 },
	{ 20, 119803 },
	{ 15, 6942 },
	{ 21, 168959 },
	{ 21, 693247 },
	{ 23, 1217535 },
	{ 23, 1741823 },
	{ 23, 3314687 },
	{ 23, 3838975 },
	{ 24, 8381183 },
	{ 24, 7336699 },
	{ 24, 7320315 },
	{ 24, 7271163 },
	{ 24, 7254779 },
	{ 24, 6812411 },
	{ 24, 6796027 },
	{ 24, 6746875 },
	{ 23, 3924735 },
	{ 23, 3404539 },
	{ 23, 3388155 },
	{ 23, 3339003 },
	{ 22, 1958655 },
	{ 22, 1700603 },
	{ 22, 1684219 },
	{ 22, 1635067 },
	{ 20, 484095 },
	{ 20, 422651 },
	{ 20, 406267 },
	{ 20, 463611 },
	{ 20, 414459 },
	{ 22, 824059 },
	{ 22, 578299 },
	{ 20, 365307 },
	{ 20, 119547 },
	{ 15, 2846 },
	{ 21, 168703 },
	{ 21, 692991 },
	{ 23, 1217279 },
	{ 23, 1741567 },
	{ 23, 3314431 },
	{ 23, 3838719 },
	{ 24, 5411583 },
	{ 22, 1833471 },
	{ 22, 1048059 },
	{ 22, 1043963 },
	{ 22, 1031675 },
	{ 22, 1027579 },
	{ 22, 916987 },
	{ 22, 912891 },
	{ 22, 900603 },
	{ 21, 850431 },
	{ 21, 458235 },
	{ 21, 454139 },
	{ 21, 441851 },
	{ 20, 424447 },
	{ 20, 228859 },
	{ 20, 224763 },
	{ 20, 212475 },
	{ 18, 104959 },
	{ 18, 56827 },
	{ 18, 52731 },
	{ 18, 99835 },
	{ 18, 54779 },
	{ 20, 140795 },
	{ 18, 79355 },
	{ 18, 26107 },
	{ 13, 4510 },
	{ 18, 30207 },
	{ 18, 95743 },
	{ 20, 161279 },
	{ 20, 226815 },
	{ 20, 423423 },
	{ 20, 488959 },
	{ 21, 685567 },
	{ 21, 751103 },
	{ 21, 947711 },
	{ 21, 1013247 },
	{ 22, 3881209 },
	{ 22, 3815673 },
	{ 22, 2046201 },
	{ 22, 1980665 },
	{ 22, 1784057 },
	{ 21, 1010941 },
	{ 21, 997625 },
	{ 21, 932089 },
	{ 21, 735481 },
	{ 20, 486653 },
	{ 20, 473337 },
	{ 20, 407801 },
	{ 20, 211193 },
	{ 18, 93437 },
	{ 18, 80121 },
	{ 18, 14585 },
	{ 18, 98553 },
	{ 18, 53497 },
	{ 20, 139513 },
	{ 18, 78073 },
	{ 18, 24825 },
	{ 13, 490 },
	{ 18, 28925 },
	{ 18, 94461 },
	{ 20, 159997 },
	{ 20, 225533 },
	{ 20, 422141 },
	{ 20, 487677 },
	{ 21, 684285 },
	{ 21, 749821 },
	{ 21, 946429 },
	{ 21, 1011965 },
	{ 22, 3881465 },
	{ 22, 3815929 },
	{ 22, 2046457 },
	{ 22, 1980921 },
	{ 22, 1784313 },
	{ 21, 1011197 },
	{ 21, 997881 },
	{ 21, 932345 },
	{ 21, 735737 },
	{ 20, 486909 },
	{ 20, 473593 },
	{ 20, 408057 },
	{ 20, 211449 },
	{ 18, 93693 },
	{ 18, 80377 },
	{ 18, 14841 },
	{ 18, 98809 },
	{ 18, 53753 },
	{ 20, 139769 },
	{ 18, 78329 },
	{ 18, 25081 },
	{ 13, 4586 },
	{ 18, 29181 },
	{ 18, 94717 },
	{ 20, 160253 },
	{ 20, 225789 },
	{ 20, 422397 },
	{ 20, 487933 },
	{ 21, 684541 },
	{ 21, 750077 },
	{ 21, 946685 },
	{ 21, 1012221 },
	{ 22, 1733117 },
	{ 22, 1798653 },
	{ 22, 1995261 },
	{ 22, 2060797 },
	{ 22, 3830269 },
	{ 22, 3895805 },
	{ 22, 4092413 },
	{ 22, 4157949 },
	{ 23, 3711737 },
	{ 23, 2925305 },
	{ 22, 1897213 },
	{ 22, 1876729 },
	{ 22, 1614585 },
	{ 22, 828153 },
	{ 20, 324349 },
	{ 20, 303865 },
	{ 20, 41721 },
	{ 20, 197369 },
	{ 20, 148217 },
	{ 20, 295673 },
	{ 20, 49913 },
	{ 15, 2410 },
	{ 20, 99069 },
	{ 20, 361213 },
	{ 22, 623357 },
	{ 22, 885501 },
	{ 22, 1671933 },
	{ 22, 1934077 },
	{ 23, 2720509 },
	{ 23, 2982653 },
	{ 23, 3769085 },
	{ 23, 4031229 },
	{ 24, 16294905 },
	{ 24, 15508473 },
	{ 24, 15246329 },
	{ 24, 8168441 },
	{ 24, 7906297 },
	{ 24, 7119865 },
	{ 23, 3994621 },
	{ 23, 3974137 },
	{ 23, 3711993 },
	{ 23, 2925561 },
	{ 22, 1897469 },
	{ 22, 1876985 },
	{ 22, 1614841 },
	{ 22, 828409 },
	{ 20, 324605 },
	{ 20, 304121 },
	{ 20, 41977 },
	{ 20, 197625 },
	{ 20, 148473 },
	{ 20, 295929 },
	{ 20, 50169 },
	{ 15, 6506 },
	{ 20, 99325 },
	{ 20, 361469 },
	{ 22, 623613 },
	{ 22, 885757 },
	{ 22, 1672189 },
	{ 22, 1934333 },
	{ 23, 2720765 },
	{ 23, 2982909 },
	{ 23, 3769341 },
	{ 23, 4031485 },
	{ 22, 4155129 },
	{ 22, 4089593 },
	{ 22, 3892985 },
	{ 22, 3827449 },
	{ 22, 2057977 },
	{ 22, 1992441 },
	{ 22, 1795833 },
	{ 22, 1730297 },
	{ 21, 1009401 },
	{ 21, 943865 },
	{ 21, 747257 },
	{ 21, 681721 },
	{ 20, 485113 },
	{ 20, 419577 },
	{ 20, 222969 },
	{ 20, 157433 },
	{ 18, 91897 },
	{ 18, 26361 },
	{ 20, 132857 },
	{ 18, 83705 },
	{ 20, 34553 },
	{ 13, 2794 },
	{ 20, 50941 },
	{ 20, 313085 },
	{ 22, 575229 },
	{ 22, 837373 },
	{ 22, 1623805 },
	{ 22, 1885949 },
	{ 23, 2672381 },
	{ 23, 2934525 },
	{ 23, 3720957 },
	{ 23, 3983101 },
	{ 22, 4155385 },
	{ 22, 4089849 },
	{ 22, 3893241 },
	{ 22, 3827705 },
	{ 22, 2058233 },
	{ 22, 1992697 },
	{ 22, 1796089 },
	{ 22, 1730553 },
	{ 21, 1009657 },
	{ 21, 944121 },
	{ 21, 747513 },
	{ 21, 681977 },
	{ 20, 485369 },
	{ 20, 419833 },
	{ 20, 223225 },
	{ 20, 157689 },
	{ 18, 92153 },
	{ 18, 26617 },
	{ 20, 133113 },
	{ 18, 83961 },
	{ 20, 34809 },
	{ 13, 3818 },
	{ 20, 51197 },
	{ 20, 313341 },
	{ 22, 575485 },
	{ 22, 837629 },
	{ 22, 1624061 },
	{ 22, 1886205 },
	{ 23, 2672637 },
	{ 23, 2934781 },
	{ 23, 3721213 },
	{ 23, 3983357 },
	{ 24, 16632573 },
	{ 24, 16550649 },
	{ 24, 16288505 },
	{ 24, 15502073 },
	{ 24, 15239929 },
	{ 24, 8162041 },
	{ 24, 7899897 },
	{ 24, 7113465 },
	{ 23, 4049661 },
	{ 23, 3967737 },
	{ 23, 3705593 },
	{ 23, 2919161 },
	{ 22, 1952509 },
	{ 22, 1870585 },
	{ 22, 1608441 },
	{ 22, 822009 },
	{ 20, 379645 },
	{ 20, 297721 },
	{ 20, 35577 },
	{ 16, 9593 },
	{ 14, 7609 },
	{ 15, 4714 },
	{ 22, 133885 },
	{ 22, 1182461 },
	{ 24, 2231037 },
	{ 24, 3279613 },
	{ 24, 6425341 },
	{ 24, 7473917 },
	{ 25, 10619645 },
	{ 25, 11668221 },
	{ 25, 14813949 },
	{ 25, 15862525 },
	{ 24, 16632829 },
	{ 24, 16550905 },
	{ 24, 16288761 },
	{ 24, 15502329 },
	{ 24, 15240185 },
	{ 24, 8162297 },
	{ 24, 7900153 },
	{ 24, 7113721 },
	{ 23, 4049917 },
	{ 23, 3967993 },
	{ 23, 3705849 },
	{ 23, 2919417 },
	{ 22, 1952765 },
	{ 22, 1870841 },
	{ 22, 1608697 },
	{ 22, 822265 },
	{ 20, 379901 },
	{ 20, 297977 },
	{ 20, 35833 },
	{ 16, 11641 },
	{ 13, 3769 },
	{ 15, 5738 },
	{ 22, 134141 },
	{ 22, 1182717 },
	{ 24, 2231293 },
	{ 24, 3279869 },
	{ 24, 6425597 },
	{ 24, 7474173 },
	{ 25, 10619901 },
	{ 25, 11668477 },
	{ 25, 14814205 },
	{ 25, 15862781 },
	{ 26, 27397117 },
	{ 24, 16568061 },
	{ 24, 16305917 },
	{ 24, 15519485 },
	{ 24, 15257341 },
	{ 24, 8179453 },
	{ 24, 7917309 },
	{ 24, 7130877 },
	{ 24, 6868733 },
	{ 23, 3985149 },
	{ 23, 3723005 },
	{ 23, 2936573 },
	{ 23, 2674429 },
	{ 22, 1887997 },
	{ 22, 1625853 },
	{ 22, 839421 },
	{ 22, 577277 },
	{ 20, 315133 },
	{ 20, 52989 },
	{ 13, 4073 },
	{ 11, 937 },
	{ 12, 1882 },
	{ 15, 15805 },
	{ 20, 331517 },
	{ 22, 593661 },
	{ 22, 855805 },
	{ 22, 1642237 },
	{ 22, 1904381 },
	{ 23, 2690813 },
	{ 23, 2952957 },
	{ 23, 3739389 },
	{ 23, 4001533 },
	{ 24, 6885117 },
	{ 24, 7147261 },
	{ 24, 7933693 },
	{ 24, 8195837 },
	{ 24, 15273725 },
	{ 24, 15535869 },
	{ 24, 16322301 },
	{ 24, 16584445 },
	{ 24, 6868989 },
	{ 23, 3985405 },
	{ 23, 3723261 },
	{ 23, 2936829 },
	{ 23, 2674685 },
	{ 22, 1888253 },
	{ 22, 1626109 },
	{ 22, 839677 },
	{ 22, 577533 },
	{ 20, 315389 },
	{ 20, 53245 },
	{ 13, 3897 },
	{ 10, 457 },
	{ 12, 2010 },
	{ 14, 7869 },
	{ 20, 331773 },
	{ 22, 593917 },
	{ 22, 856061 },
	{ 22, 1642493 },
	{ 22, 1904637 },
	{ 23, 2691069 },
	{ 23, 2953213 },
	{ 23, 3739645 },
	{ 23, 4001789 },
	{ 24, 6885373 },
	{ 24, 7147517 },
	{ 24, 7933949 },
	{ 24, 16538365 },
	{ 24, 16276221 },
	{ 24, 15489789 },
	{ 24, 15227645 },
	{ 24, 8149757 },
	{ 24, 7887613 },
	{ 24, 7101181 },
	{ 24, 6839037 },
	{ 23, 3955453 },
	{ 23, 3693309 },
	{ 23, 2906877 },
	{ 23, 2644733 },
	{ 22, 1858301 },
	{ 22, 1596157 },
	{ 22, 809725 },
	{ 22, 547581 },
	{ 16, 26493 },
	{ 11, 989 },
	{ 24, 523001 },
	{ 12, 1965 },
	{ 16, 25981 },
	{ 22, 531197 },
	{ 22, 793341 },
	{ 22, 1579773 },
	{ 22, 1841917 },
	{ 23, 2628349 },
	{ 23, 2890493 },
	{ 23, 3676925 },
	{ 23, 3939069 },
	{ 24, 6822653 },
	{ 24, 7084797 },
	{ 24, 7871229 },
	{ 24, 8133373 },
	{ 24, 15211261 },
	{ 24, 15473405 },
	{ 24, 16259837 },
	{ 24, 16521981 },
	{ 24, 7887869 },
	{ 24, 7101437 },
	{ 24, 6839293 },
	{ 23, 3955709 },
	{ 23, 3693565 },
	{ 23, 2907133 },
	{ 23, 2644989 },
	{ 22, 1858557 },
	{ 22, 1596413 },
	{ 22, 809981 },
	{ 22, 547837 },
	{ 16, 28541 },
	{ 14, 8045 },
	{ 12, 906 },
	{ 11, 973 },
	{ 16, 28029 },
	{ 22, 531453 },
	{ 22, 793597 },
	{ 22, 1580029 },
	{ 22, 1842173 },
	{ 23, 2628605 },
	{ 23, 2890749 },
	{ 23, 3677181 },
	{ 23, 3939325 },
	{ 24, 6822909 },
	{ 24, 7085053 },
	{ 24, 7871485 },
	{ 24, 16604925 },
	{ 24, 16342781 },
	{ 24, 15556349 },
	{ 24, 15294205 },
	{ 24, 8216317 },
	{ 24, 7954173 },
	{ 24, 7167741 },
	{ 24, 6905597 },
	{ 23, 4022013 },
	{ 23, 3759869 },
	{ 23, 2973437 },
	{ 23, 2711293 },
	{ 22, 1924861 },
	{ 22, 1662717 },
	{ 22, 876285 },
	{ 22, 614141 },
	{ 20, 351997 },
	{ 16, 32381 },
	{ 12, 970 },
	{ 12, 2009 },
	{ 15, 16365 },
	{ 20, 40701 },
	{ 20, 106237 },
	{ 22, 171773 },
	{ 22, 237309 },
	{ 22, 433917 },
	{ 22, 499453 },
	{ 23, 696061 },
	{ 23, 761597 },
	{ 23, 958205 },
	{ 23, 1023741 },
	{ 24, 1744637 },
	{ 24, 1810173 },
	{ 24, 2006781 },
	{ 24, 2072317 },
	{ 24, 3841789 },
	{ 24, 3907325 },
	{ 24, 4103933 },
	{ 24, 4169469 },
	{ 24, 6905853 },
	{ 23, 4022269 },
	{ 23, 3760125 },
	{ 23, 2973693 },
	{ 23, 2711549 },
	{ 22, 1925117 },
	{ 22, 1662973 },
	{ 22, 876541 },
	{ 22, 614397 },
	{ 20, 352253 },
	{ 17, 65469 },
	{ 15, 16186 },
	{ 15, 16233 },
	{ 15, 16189 },
	{ 20, 40957 },
	{ 20, 106493 },
	{ 22, 172029 },
	{ 22, 237565 },
	{ 22, 434173 },
	{ 22, 499709 },
	{ 23, 696317 },
	{ 23, 761853 },
	{ 23, 958461 },
	{ 23, 1023997 },
	{ 24, 1744893 },
	{ 24, 1810429 },
	{ 24, 2007037 },
	{ 24, 2072573 },
	{ 24, 3842045 },
	{ 24, 3907581 },
	{ 24, 4104189 },
	{ 24, 4169725 },
	{ 28, 109652733 },
	{ 27, 63515389 },
	{ 27, 59321085 },
	{ 27, 46738173 },
	{ 27, 42543869 },
	{ 26, 29960957 },
	{ 26, 25766653 },
	{ 26, 13183741 },
	{ 26, 8989437 },
	{ 24, 4795133 },
	{ 24, 600829 },
	{ 16, 21018 },
	{ 17, 65145 },
	{ 17, 42873 },
	{ 22, 207609 },
	{ 22, 469753 },
	{ 22, 1452797 },
	{ 24, 994041 },
	{ 24, 1780473 },
	{ 24, 2042617 },
	{ 24, 6171389 },
	{ 25, 3091193 },
	{ 25, 3877625 },
	{ 25, 4139769 },
	{ 25, 12462845 },
	{ 26, 7285497 },
	{ 26, 8071929 },
	{ 26, 8334073 },
	{ 26, 15411961 },
	{ 26, 15674105 },
	{ 26, 16460537 },
	{ 26, 16722681 },
	{ 26, 33434365 },
	{ 27, 63515645 },
	{ 27, 59321341 },
	{ 27, 46738429 },
	{ 27, 42544125 },
	{ 26, 29961213 },
	{ 26, 25766909 },
	{ 26, 13183997 },
	{ 26, 8989693 },
	{ 24, 4795389 },
	{ 24, 601085 },
	{ 16, 22042 },
	{ 18, 131001 },
	{ 17, 44921 },
	{ 22, 207865 },
	{ 22, 470009 },
	{ 22, 1453053 },
	{ 24, 994297 },
	{ 24, 1780729 },
	{ 24, 2042873 },
	{ 24, 6171645 },
	{ 25, 3091449 },
	{ 25, 3877881 },
	{ 25, 4140025 },
	{ 25, 12463101 },
	{ 26, 7285753 },
	{ 26, 8072185 },
	{ 26, 8334329 },
	{ 26, 15412217 },
	{ 26, 15674361 },
	{ 26, 16460793 },
	{ 26, 16722937 },
	{ 26, 33434621 },
	{ 27, 63778557 },
	{ 27, 59584253 },
	{ 27, 47001341 },
	{ 27, 42807037 },
	{ 26, 30224125 },
	{ 26, 26029821 },
	{ 26, 13446909 },
	{ 26, 9252605 },
	{ 24, 5058301 },
	{ 24, 863997 },
	{ 16, 23194 },
	{ 24, 601849 },
	{ 22, 1388281 },
	{ 24, 2174713 },
	{ 22, 1257209 },
	{ 22, 1519353 },
	{ 24, 4927225 },
	{ 24, 5189369 },
	{ 24, 5975801 },
	{ 24, 6237945 },
	{ 25, 11218681 },
	{ 25, 11480825 },
	{ 25, 12267257 },
	{ 25, 12529401 },
	{ 26, 23801593 },
	{ 26, 24063737 },
	{ 26, 24850169 },
	{ 26, 25112313 },
	{ 26, 32190201 },
	{ 26, 32452345 },
	{ 26, 33238777 },
	{ 26, 33500921 },
	{ 27, 63778813 },
	{ 27, 59584509 },
	{ 27, 47001597 },
	{ 27, 42807293 },
	{ 26, 30224381 },
	{ 26, 26030077 },
	{ 26, 13447165 },
	{ 26, 9252861 },
	{ 24, 5058557 },
	{ 24, 864253 },
	{ 16, 24218 },
	{ 24, 602105 },
	{ 22, 1388537 },
	{ 24, 2174969 },
	{ 22, 1257465 },
	{ 22, 1519609 },
	{ 24, 4927481 },
	{ 24, 5189625 },
	{ 24, 5976057 },
	{ 24, 6238201 },
	{ 25, 11218937 },
	{ 25, 11481081 },
	{ 25, 12267513 },
	{ 25, 12529657 },
	{ 26, 23801849 },
	{ 26, 24063993 },
	{ 26, 24850425 },
	{ 26, 25112569 },
	{ 26, 32190457 },
	{ 26, 32452601 },
	{ 26, 33239033 },
	{ 26, 33501177 },
	{ 27, 64568061 },
	{ 27, 60373757 },
	{ 27, 47790845 },
	{ 27, 43596541 },
	{ 26, 31013629 },
	{ 26, 26819325 },
	{ 26, 14236413 },
	{ 26, 10042109 },
	{ 24, 5847805 },
	{ 24, 1653501 },
	{ 18, 117018 },
	{ 24, 867065 },
	{ 24, 4799225 },
	{ 24, 2439929 },
	{ 24, 3226361 },
	{ 24, 2308857 },
	{ 24, 2571001 },
	{ 24, 3554045 },
	{ 25, 10420223 },
	{ 26, 10173177 },
	{ 26, 10435321 },
	{ 26, 14564093 },
	{ 27, 19872505 },
	{ 27, 20658937 },
	{ 27, 20921081 },
	{ 27, 29244157 },
	{ 28, 40844025 },
	{ 28, 41630457 },
	{ 28, 41892601 },
	{ 28, 48970489 },
	{ 28, 49232633 },
	{ 28, 50019065 },
	{ 27, 64568317 },
	{ 27, 60374013 },
	{ 27, 47791101 },
	{ 27, 43596797 },
	{ 26, 31013885 },
	{ 26, 26819581 },
	{ 26, 14236669 },
	{ 26, 10042365 },
	{ 24, 5848061 },
	{ 24, 1653757 },
	{ 18, 121114 },
	{ 24, 867321 },
	{ 24, 4799481 },
	{ 24, 2440185 },
	{ 24, 3226617 },
	{ 24, 2309113 },
	{ 24, 2571257 },
	{ 24, 3554301 },
	{ 25, 10419967 },
	{ 26, 10173433 },
	{ 26, 10435577 },
	{ 26, 14564349 },
	{ 27, 19872761 },
	{ 27, 20659193 },
	{ 27, 20921337 },
	{ 27, 29244413 },
	{ 28, 40844281 },
	{ 28, 41630713 },
	{ 28, 41892857 },
	{ 28, 48970745 },
	{ 28, 49232889 },
	{ 28, 50019321 },
	{ 27, 64831229 },
	{ 27, 60636925 },
	{ 27, 48054013 },
	{ 27, 43859709 },
	{ 26, 31276797 },
	{ 26, 27082493 },
	{ 26, 14499581 },
	{ 26, 10305277 },
	{ 24, 6110973 },
	{ 24, 1916669 },
	{ 18, 125338 },
	{ 24, 1654521 },
	{ 24, 5062393 },
	{ 25, 10025979 },
	{ 24, 3489529 },
	{ 24, 6373113 },
	{ 24, 3358457 },
	{ 24, 3620601 },
	{ 24, 6700797 },
	{ 25, 11992063 },
	{ 26, 14368505 },
	{ 26, 14630649 },
	{ 26, 27148029 },
	{ 27, 28262137 },
	{ 27, 29048569 },
	{ 27, 29310713 },
	{ 27, 54411005 },
	{ 28, 57622265 },
	{ 28, 58408697 },
	{ 28, 58670841 },
	{ 28, 65748729 },
	{ 28, 66010873 },
	{ 27, 64831485 },
	{ 27, 60637181 },
	{ 27, 48054269 },
	{ 27, 43859965 },
	{ 26, 31277053 },
	{ 26, 27082749 },
	{ 26, 14499837 },
	{ 26, 10305533 },
	{ 24, 6111229 },
	{ 24, 1916925 },
	{ 18, 129434 },
	{ 24, 1654777 },
	{ 24, 5062649 },
	{ 25, 10025723 },
	{ 24, 3489785 },
	{ 24, 6373369 },
	{ 24, 3358713 },
	{ 24, 3620857 },
	{ 24, 6701053 },
	{ 25, 11991807 },
	{ 26, 14368761 },
	{ 26, 14630905 },
	{ 26, 27148285 },
	{ 27, 28262393 },
	{ 27, 29048825 },
	{ 27, 29310969 },
	{ 27, 54411261 },
	{ 28, 57622521 },
	{ 28, 58408953 },
	{ 28, 58671097 },
	{ 28, 65748985 },
	{ 28, 66011129 },
	{ 28, 66797561 },
	{ 28, 67059705 },
	{ 28, 94989053 },
	{ 28, 86600445 },
	{ 27, 61434621 },
	{ 27, 53046013 },
	{ 27, 27880189 },
	{ 27, 19491581 },
	{ 25, 11102973 },
	{ 25, 2714365 },
	{ 19, 215834 },
	{ 24, 1927929 },
	{ 24, 5860089 },
	{ 25, 11595771 },
	{ 26, 13200121 },
	{ 24, 6646521 },
	{ 24, 7432953 },
	{ 24, 6515449 },
	{ 24, 6777593 },
	{ 24, 7760637 },
	{ 25, 12513279 },
	{ 26, 26962681 },
	{ 26, 27224825 },
	{ 26, 31353597 },
	{ 27, 53439225 },
	{ 27, 54225657 },
	{ 27, 54487801 },
	{ 27, 62810877 },
	{ 28, 107965177 },
	{ 28, 108751609 },
	{ 28, 109013753 },
	{ 28, 116091641 },
	{ 28, 116353785 },
	{ 28, 117140217 },
	{ 28, 117402361 },
	{ 28, 134114045 },
	{ 27, 61434877 },
	{ 27, 53046269 },
	{ 27, 27880445 },
	{ 27, 19491837 },
	{ 25, 11103229 },
	{ 25, 2714621 },
	{ 19, 219930 },
	{ 24, 1928185 },
	{ 24, 5860345 },
	{ 25, 11595515 },
	{ 26, 13200377 },
	{ 24, 6646777 },
	{ 24, 7433209 },
	{ 24, 6515705 },
	{ 24, 6777849 },
	{ 24, 7760893 },
	{ 25, 12513023 },
	{ 26, 26962937 },
	{ 26, 27225081 },
	{ 26, 31353853 },
	{ 27, 53439481 },
	{ 27, 54225913 },
	{ 27, 54488057 },
	{ 27, 62811133 },
	{ 28, 107965433 },
	{ 28, 108751865 },
	{ 28, 109014009 },
	{ 28, 116091897 },
	{ 28, 116354041 },
	{ 28, 117140473 },
	{ 28, 117402617 },
	{ 28, 86863613 },
	{ 27, 61697789 },
	{ 27, 53309181 },
	{ 27, 28143357 },
	{ 27, 19754749 },
	{ 25, 11366141 },
	{ 25, 2977533 },
	{ 19, 224154 },
	{ 25, 2715385 },
	{ 24, 6123257 },
	{ 25, 12119035 },
	{ 26, 13463289 },
	{ 26, 25784057 },
	{ 24, 7696121 },
	{ 25, 10579705 },
	{ 24, 7565049 },
	{ 24, 7827193 },
	{ 25, 10907389 },
	{ 26, 30371577 },
	{ 26, 31158009 },
	{ 26, 31420153 },
	{ 27, 61566713 },
	{ 27, 61828857 },
	{ 27, 62615289 },
	{ 27, 62877433 },
	{ 28, 124481273 },
	{ 28, 124743417 },
	{ 28, 125529849 },
	{ 28, 125791993 },
	{ 28, 132869881 },
	{ 28, 133132025 },
	{ 28, 133918457 },
	{ 28, 134180601 },
	{ 27, 61698045 },
	{ 27, 53309437 },
	{ 27, 28143613 },
	{ 27, 19755005 },
	{ 25, 11366397 },
	{ 25, 2977789 },
	{ 19, 228250 },
	{ 25, 2715641 },
	{ 24, 6123513 },
	{ 25, 12118779 },
	{ 26, 13463545 },
	{ 26, 25784313 },
	{ 24, 7696377 },
	{ 25, 10579961 },
	{ 24, 7565305 },
	{ 24, 7827449 },
	{ 25, 10907645 },
	{ 26, 30371833 },
	{ 26, 31158265 },
	{ 26, 31420409 },
	{ 27, 61566969 },
	{ 27, 61829113 },
	{ 27, 62615545 },
	{ 27, 62877689 },
	{ 28, 124481529 },
	{ 28, 124743673 },
	{ 28, 125530105 },
	{ 28, 125792249 },
	{ 28, 132870137 },
	{ 28, 133132281 },
	{ 28, 133918713 },
	{ 28, 134180857 },
	{ 27, 62487293 },
	{ 27, 54098685 },
	{ 27, 28932861 },
	{ 27, 20544253 },
	{ 25, 12155645 },
	{ 25, 3767037 },
	{ 20, 496922 },
	{ 20, 1045870 },
	{ 25, 11107065 },
	{ 26, 10320633 },
	{ 26, 14252793 },
	{ 26, 26049273 },
	{ 26, 29981433 },
	{ 25, 10844921 },
	{ 25, 11631353 },
	{ 25, 10713849 },
	{ 25, 10975993 },
	{ 25, 11959037 },
	{ 26, 22986751 },
	{ 27, 43743993 },
	{ 27, 44006137 },
	{ 27, 48134909 },
	{ 28, 86997753 },
	{ 28, 87784185 },
	{ 28, 88046329 },
	{ 28, 96369405 },
	{ 29, 175078137 },
	{ 29, 175864569 },
	{ 28, 129596413 },
	{ 28, 121207805 },
	{ 28, 96041981 },
	{ 28, 87653373 },
	{ 27, 62487549 },
	{ 27, 54098941 },
	{ 27, 28933117 },
	{ 27, 20544509 },
	{ 25, 12155901 },
	{ 25, 3767293 },
	{ 20, 505114 },
	{ 20, 1037678 },
	{ 25, 11107321 },
	{ 26, 10320889 },
	{ 26, 14253049 },
	{ 26, 26049529 },
	{ 26, 29981689 },
	{ 25, 10845177 },
	{ 25, 11631609 },
	{ 25, 10714105 },
	{ 25, 10976249 },
	{ 25, 11959293 },
	{ 26, 22986495 },
	{ 27, 43744249 },
	{ 27, 44006393 },
	{ 27, 48135165 },
	{ 28, 86998009 },
	{ 28, 87784441 },
	{ 28, 88046585 },
	{ 28, 96369661 },
	{ 29, 175078393 },
	{ 29, 175864825 },
	{ 28, 129859325 },
	{ 28, 121470717 },
	{ 28, 96304893 },
	{ 28, 87916285 },
	{ 27, 62750461 },
	{ 27, 54361853 },
	{ 27, 29196029 },
	{ 27, 20807421 },
	{ 25, 12418813 },
	{ 25, 4030205 },
	{ 20, 513434 },
	{ 20, 1029614 },
	{ 25, 11370233 },
	{ 26, 22592507 },
	{ 26, 14515961 },
	{ 26, 26836729 },
	{ 26, 30244601 },
	{ 27, 42565369 },
	{ 25, 11894521 },
	{ 25, 14778105 },
	{ 25, 11763449 },
	{ 25, 12025593 },
	{ 25, 15105789 },
	{ 26, 24558591 },
	{ 27, 47939321 },
	{ 27, 48201465 },
	{ 27, 60718845 },
	{ 28, 95387385 },
	{ 28, 96173817 },
	{ 28, 96435961 },
	{ 28, 121536253 },
	{ 29, 191856377 },
	{ 28, 129859581 },
	{ 28, 121470973 },
	{ 28, 96305149 },
	{ 28, 87916541 },
	{ 27, 62750717 },
	{ 27, 54362109 },
	{ 27, 29196285 },
	{ 27, 20807677 },
	{ 25, 12419069 },
	{ 25, 4030461 },
	{ 20, 521626 },
	{ 20, 1021422 },
	{ 25, 11370489 },
	{ 26, 22592251 },
	{ 26, 14516217 },
	{ 26, 26836985 },
	{ 26, 30244857 },
	{ 27, 42565625 },
	{ 25, 11894777 },
	{ 25, 14778361 },
	{ 25, 11763705 },
	{ 25, 12025849 },
	{ 25, 15106045 },
	{ 26, 24558335 },
	{ 27, 47939577 },
	{ 27, 48201721 },
	{ 27, 60719101 },
	{ 28, 95387641 },
	{ 28, 96174073 },
	{ 28, 96436217 },
	{ 28, 121536509 },
	{ 29, 191856633 },
	{ 29, 259817465 },
	{ 29, 250118137 },
	{ 29, 200048633 },
	{ 29, 184057849 },
	{ 28, 133988345 },
	{ 29, 201293817 },
	{ 29, 114469629 },
	{ 29, 80915197 },
	{ 27, 47360765 },
	{ 27, 13806333 },
	{ 20, 956186 },
	{ 20, 980846 },
	{ 26, 24292089 },
	{ 26, 24162299 },
	{ 28, 55749369 },
	{ 27, 54176505 },
	{ 27, 62040825 },
	{ 27, 61911035 },
	{ 28, 93498105 },
	{ 26, 30059257 },
	{ 26, 31632121 },
	{ 26, 29797113 },
	{ 26, 30321401 },
	{ 26, 32287485 },
	{ 26, 25079807 },
	{ 28, 121023225 },
	{ 28, 121547513 },
	{ 28, 129805053 },
	{ 28, 125743103 },
	{ 29, 242658041 },
	{ 29, 243182329 },
	{ 29, 259828477 },
	{ 29, 259960831 },
	{ 30, 486058745 },
	{ 30, 399551225 },
	{ 30, 366521081 },
	{ 29, 267430649 },
	{ 29, 234400505 },
	{ 29, 114469885 },
	{ 29, 80915453 },
	{ 27, 47361021 },
	{ 27, 13806589 },
	{ 20, 964378 },
	{ 20, 972654 },
	{ 26, 24292345 },
	{ 26, 24162043 },
	{ 28, 55749625 },
	{ 27, 54176761 },
	{ 27, 62041081 },
	{ 27, 61910779 },
	{ 28, 93498361 },
	{ 26, 30059513 },
	{ 26, 31632377 },
	{ 26, 29797369 },
	{ 26, 30321657 },
	{ 26, 32287741 },
	{ 26, 25079551 },
	{ 28, 121023481 },
	{ 28, 121547769 },
	{ 28, 129805309 },
	{ 28, 125742847 },
	{ 29, 242658297 },
	{ 29, 243182585 },
	{ 29, 259828733 },
	{ 29, 259960575 },
	{ 30, 486059001 },
	{ 30, 399551481 },
	{ 30, 366521337 },
	{ 29, 267430905 },
	{ 29, 234400761 },
	{ 29, 114994941 },
	{ 29, 81440509 },
	{ 27, 47886077 },
	{ 27, 14331645 },
	{ 20, 972698 },
	{ 20, 964590 },
	{ 26, 24817401 },
	{ 26, 24685563 },
	{ 28, 56274681 },
	{ 28, 106082041 },
	{ 27, 62566137 },
	{ 27, 62434299 },
	{ 28, 94023417 },
	{ 28, 118664953 },
	{ 26, 32157433 },
	{ 26, 32025595 },
	{ 26, 31895289 },
	{ 26, 32419577 },
	{ 26, 24947707 },
	{ 27, 47623167 },
	{ 28, 129412857 },
	{ 28, 129937145 },
	{ 28, 125611003 },
	{ 29, 257863417 },
	{ 29, 259436281 },
	{ 29, 259960569 },
	{ 29, 259828731 },
	{ 30, 485535481 },
	{ 30, 385396473 },
	{ 30, 365997817 },
	{ 29, 265858809 },
	{ 29, 233877241 },
	{ 29, 133738233 },
	{ 29, 81440765 },
	{ 27, 47886333 },
	{ 27, 14331901 },
	{ 20, 980890 },
	{ 20, 956398 },
	{ 26, 24817657 },
	{ 26, 24685307 },
	{ 28, 56274937 },
	{ 28, 106082297 },
	{ 27, 62566393 },
	{ 27, 62434043 },
	{ 28, 94023673 },
	{ 28, 118665209 },
	{ 26, 32157689 },
	{ 26, 32025339 },
	{ 26, 31895545 },
	{ 26, 32419833 },
	{ 26, 24947451 },
	{ 27, 47622911 },
	{ 28, 129413113 },
	{ 28, 129937401 },
	{ 28, 125610747 },
	{ 29, 257863673 },
	{ 29, 259436537 },
	{ 29, 259960825 },
	{ 29, 259828475 },
	{ 29, 259555327 },
	{ 29, 242778111 },
	{ 29, 192446463 },
	{ 29, 265859065 },
	{ 28, 125337599 },
	{ 28, 108560383 },
	{ 28, 58228735 },
	{ 27, 49462013 },
	{ 26, 24674303 },
	{ 21, 2043162 },
	{ 21, 1043822 },
	{ 26, 7110651 },
	{ 26, 23625723 },
	{ 27, 20742139 },
	{ 27, 28868603 },
	{ 27, 53247995 },
	{ 27, 61374459 },
	{ 27, 43810811 },
	{ 27, 47742971 },
	{ 27, 59539451 },
	{ 27, 55229177 },
	{ 26, 27557883 },
	{ 26, 28344315 },
	{ 26, 6979579 },
	{ 26, 23756795 },
	{ 26, 24084479 },
	{ 28, 57311227 },
	{ 28, 107642875 },
	{ 28, 124420091 },
	{ 28, 124747775 },
	{ 29, 191528955 },
	{ 29, 241860603 },
	{ 29, 258637819 },
	{ 29, 242057211 },
	{ 29, 192511995 },
	{ 29, 265337593 },
	{ 28, 132743163 },
	{ 28, 116228091 },
	{ 28, 66682875 },
	{ 27, 49462269 },
	{ 26, 24674047 },
	{ 21, 2059546 },
	{ 21, 1027438 },
	{ 26, 7110395 },
	{ 26, 23625467 },
	{ 27, 20741883 },
	{ 27, 28868347 },
	{ 27, 53247739 },
	{ 27, 61374203 },
	{ 27, 43810555 },
	{ 27, 47742715 },
	{ 27, 59539195 },
	{ 27, 55229433 },
	{ 26, 27557627 },
	{ 26, 28344059 },
	{ 26, 6979323 },
	{ 26, 23756539 },
	{ 26, 24084223 },
	{ 28, 57310971 },
	{ 28, 107642619 },
	{ 28, 124419835 },
	{ 28, 124747519 },
	{ 29, 191528699 },
	{ 29, 241860347 },
	{ 29, 258637563 },
	{ 29, 242056955 },
	{ 29, 192511739 },
	{ 29, 265337849 },
	{ 28, 132742907 },
	{ 28, 116227835 },
	{ 28, 66682619 },
	{ 27, 49987325 },
	{ 26, 24935423 },
	{ 21, 2076058 },
	{ 21, 1011182 },
	{ 26, 7896059 },
	{ 26, 23886843 },
	{ 28, 58375929 },
	{ 27, 29129723 },
	{ 27, 54033403 },
	{ 27, 61635579 },
	{ 28, 96124665 },
	{ 27, 48004091 },
	{ 27, 60324859 },
	{ 27, 66895609 },
	{ 26, 66550779 },
	{ 26, 28605435 },
	{ 26, 31489019 },
	{ 26, 7240699 },
	{ 26, 24017915 },
	{ 26, 24869887 },
	{ 28, 57572347 },
	{ 28, 107903995 },
	{ 28, 124681211 },
	{ 28, 125533183 },
	{ 29, 259571449 },
	{ 28, 129858555 },
	{ 29, 258898939 },
	{ 29, 191724539 },
	{ 29, 251182841 },
	{ 28, 125664251 },
	{ 28, 115964923 },
	{ 28, 65895419 },
	{ 27, 66633465 },
	{ 26, 33389563 },
	{ 21, 2080746 },
	{ 21, 994798 },
	{ 26, 7895803 },
	{ 26, 23886587 },
	{ 28, 58376185 },
	{ 27, 29129467 },
	{ 27, 54033147 },
	{ 27, 61635323 },
	{ 28, 96124921 },
	{ 27, 48003835 },
	{ 27, 60324603 },
	{ 27, 66895865 },
	{ 26, 66550523 },
	{ 26, 28605179 },
	{ 26, 31488763 },
	{ 26, 7240443 },
	{ 26, 24017659 },
	{ 26, 24869631 },
	{ 28, 57572091 },
	{ 28, 107903739 },
	{ 28, 124680955 },
	{ 28, 125532927 },
	{ 29, 259571705 },
	{ 28, 129858299 },
	{ 29, 258898683 },
	{ 29, 191724283 },
	{ 29, 251183097 },
	{ 28, 125663995 },
	{ 28, 115964667 },
	{ 28, 65895163 },
	{ 27, 66633721 },
	{ 26, 33389307 },
	{ 21, 2097130 },
	{ 21, 913262 },
	{ 26, 8155131 },
	{ 26, 24670203 },
	{ 28, 40660987 },
	{ 28, 108718841 },
	{ 27, 54292475 },
	{ 27, 62418939 },
	{ 28, 86798331 },
	{ 28, 121301753 },
	{ 27, 60583931 },
	{ 27, 67037949 },
	{ 26, 66482175 },
	{ 26, 65499131 },
	{ 26, 31748091 },
	{ 26, 32534523 },
	{ 26, 8024059 },
	{ 26, 24801275 },
	{ 26, 25128959 },
	{ 28, 58355707 },
	{ 28, 108687355 },
	{ 28, 125464571 },
	{ 28, 125792255 },
	{ 28, 129593339 },
	{ 28, 121466875 },
	{ 29, 259682299 },
	{ 29, 250669817 },
	{ 28, 125399035 },
	{ 28, 108883963 },
	{ 28, 65630203 },
	{ 27, 66120441 },
	{ 26, 33124347 },
	{ 26, 16609275 },
	{ 21, 896878 },
	{ 26, 8154875 },
	{ 26, 24669947 },
	{ 28, 40660731 },
	{ 28, 108719097 },
	{ 27, 54292219 },
	{ 27, 62418683 },
	{ 28, 86798075 },
	{ 28, 121302009 },
	{ 27, 60583675 },
	{ 27, 67038205 },
	{ 26, 66481919 },
	{ 26, 65498875 },
	{ 26, 31747835 },
	{ 26, 32534267 },
	{ 26, 8023803 },
	{ 26, 24801019 },
	{ 26, 25128703 },
	{ 28, 58355451 },
	{ 28, 108687099 },
	{ 28, 125464315 },
	{ 28, 125791999 },
	{ 28, 129593083 },
	{ 28, 121466619 },
	{ 29, 259682043 },
	{ 29, 250670073 },
	{ 28, 125398779 },
	{ 28, 108883707 },
	{ 28, 65629947 },
	{ 27, 66120697 },
	{ 26, 33124091 },
	{ 26, 16609019 },
	{ 21, 880622 },
	{ 26, 15231995 },
	{ 26, 24931323 },
	{ 28, 41446395 },
	{ 28, 57437179 },
	{ 28, 125497081 },
	{ 27, 62680059 },
	{ 28, 87583739 },
	{ 28, 95185915 },
	{ 28, 129691385 },
	{ 27, 64777211 },
	{ 27, 66514685 },
	{ 26, 65432575 },
	{ 26, 62352379 },
	{ 26, 32795643 },
	{ 26, 60845051 },
	{ 26, 8285179 },
	{ 26, 25062395 },
	{ 26, 32205823 },
	{ 28, 58616827 },
	{ 28, 108948475 },
	{ 28, 125725691 },
	{ 28, 128805883 },
	{ 28, 121203707 },
	{ 28, 96300027 },
	{ 29, 249097977 },
	{ 28, 124611579 },
	{ 28, 108620795 },
	{ 28, 58551291 },
	{ 27, 64548601 },
	{ 26, 32336891 },
	{ 26, 16346107 },
	{ 21, 864238 },
	{ 26, 15231739 },
	{ 26, 24931067 },
	{ 28, 41446139 },
	{ 28, 57436923 },
	{ 28, 125497337 },
	{ 27, 62679803 },
	{ 28, 87583483 },
	{ 28, 95185659 },
	{ 28, 129691641 },
	{ 27, 64776955 },
	{ 27, 66514941 },
	{ 26, 65432319 },
	{ 26, 62352123 },
	{ 26, 32795387 },
	{ 26, 60844795 },
	{ 26, 8284923 },
	{ 26, 25062139 },
	{ 26, 32205567 },
	{ 28, 58616571 },
	{ 28, 108948219 },
	{ 28, 125725435 },
	{ 28, 128805627 },
	{ 28, 121203451 },
	{ 28, 96299771 },
	{ 29, 249098233 },
	{ 28, 124611323 },
	{ 28, 108620539 },
	{ 28, 58551035 },
	{ 27, 64548857 },
	{ 26, 32336635 },
	{ 26, 16345851 },
	{ 20, 523630 },
	{ 26, 15482875 },
	{ 26, 31997947 },
	{ 28, 41697275 },
	{ 28, 58212347 },
	{ 28, 107757563 },
	{ 28, 124272635 },
	{ 28, 87834619 },
	{ 28, 95961083 },
	{ 28, 120340475 },
	{ 28, 128466939 },
	{ 28, 110903291 },
	{ 27, 64944893 },
	{ 26, 62275583 },
	{ 26, 61292539 },
	{ 26, 61095931 },
	{ 26, 61882363 },
	{ 26, 15351803 },
	{ 26, 32129019 },
	{ 26, 32456703 },
	{ 28, 65683451 },
	{ 28, 116015099 },
	{ 28, 132792315 },
	{ 28, 120406011 },
	{ 28, 96026619 },
	{ 28, 87900155 },
	{ 28, 124338171 },
	{ 28, 107823099 },
	{ 28, 58277883 },
	{ 27, 64027385 },
	{ 26, 32063483 },
	{ 26, 15548411 },
	{ 20, 507246 },
	{ 26, 15482619 },
	{ 26, 31997691 },
	{ 28, 41697019 },
	{ 28, 58212091 },
	{ 28, 107757307 },
	{ 28, 124272379 },
	{ 28, 87834363 },
	{ 28, 95960827 },
	{ 28, 120340219 },
	{ 28, 128466683 },
	{ 28, 110903035 },
	{ 27, 64945149 },
	{ 26, 62275327 },
	{ 26, 61292283 },
	{ 26, 61095675 },
	{ 26, 61882107 },
	{ 26, 15351547 },
	{ 26, 32128763 },
	{ 26, 32456447 },
	{ 28, 65683195 },
	{ 28, 116014843 },
	{ 28, 132792059 },
	{ 28, 120405755 },
	{ 28, 96026363 },
	{ 28, 87899899 },
	{ 28, 124337915 },
	{ 28, 107822843 },
	{ 28, 58277627 },
	{ 27, 64027641 },
	{ 26, 32063227 },
	{ 26, 15548155 },
	{ 20, 490990 },
	{ 26, 16268283 },
	{ 26, 32259067 },
	{ 28, 48774139 },
	{ 28, 58473467 },
	{ 28, 108542971 },
	{ 28, 124533755 },
	{ 29, 192610041 },
	{ 28, 96222203 },
	{ 28, 121125883 },
	{ 28, 128728059 },
	{ 28, 132070395 },
	{ 28, 115096571 },
	{ 27, 64421629 },
	{ 26, 61225983 },
	{ 26, 32979963 },
	{ 26, 62143483 },
	{ 26, 65027067 },
	{ 26, 15612923 },
	{ 26, 32390139 },
	{ 26, 33242111 },
	{ 28, 129564409 },
	{ 27, 64830459 },
	{ 28, 133053435 },
	{ 28, 95239163 },
	{ 28, 125370105 },
	{ 27, 62733307 },
	{ 28, 107559931 },
	{ 28, 57490427 },
	{ 27, 49872633 },
	{ 26, 24984571 },
	{ 26, 15285243 },
	{ 20, 474606 },
	{ 26, 16268027 },
	{ 26, 32258811 },
	{ 28, 48773883 },
	{ 28, 58473211 },
	{ 28, 108542715 },
	{ 28, 124533499 },
	{ 29, 192610297 },
	{ 28, 96221947 },
	{ 28, 121125627 },
	{ 28, 128727803 },
	{ 28, 132070139 },
	{ 28, 115096315 },
	{ 27, 64421885 },
	{ 26, 61225727 },
	{ 26, 32979707 },
	{ 26, 62143227 },
	{ 26, 65026811 },
	{ 26, 15612667 },
	{ 26, 32389883 },
	{ 26, 33241855 },
	{ 28, 129564665 },
	{ 27, 64830203 },
	{ 28, 133053179 },
	{ 28, 95238907 },
	{ 28, 125370361 },
	{ 27, 62733051 },
	{ 28, 107559675 },
	{ 28, 57490171 },
	{ 27, 49872889 },
	{ 26, 24984315 },
	{ 26, 15284987 },
	{ 20, 393070 },
	{ 26, 16527355 },
	{ 26, 33042427 },
	{ 28, 49033211 },
	{ 28, 65548283 },
	{ 28, 108802043 },
	{ 28, 125317115 },
	{ 29, 174862331 },
	{ 29, 191377403 },
	{ 28, 121384955 },
	{ 28, 129511419 },
	{ 28, 132001791 },
	{ 28, 127873019 },
	{ 28, 127676411 },
	{ 28, 100510461 },
	{ 26, 32911359 },
	{ 26, 31928315 },
	{ 26, 65286139 },
	{ 26, 66072571 },
	{ 26, 16396283 },
	{ 26, 33173499 },
	{ 26, 33501183 },
	{ 27, 64565243 },
	{ 27, 60633083 },
	{ 28, 133836795 },
	{ 28, 86847483 },
	{ 27, 62468091 },
	{ 27, 54341627 },
	{ 28, 57225211 },
	{ 28, 98675449 },
	{ 26, 24719355 },
	{ 26, 8204283 },
	{ 20, 376686 },
	{ 26, 16527099 },
	{ 26, 33042171 },
	{ 28, 49032955 },
	{ 28, 65548027 },
	{ 28, 108801787 },
	{ 28, 125316859 },
	{ 29, 174862075 },
	{ 29, 191377147 },
	{ 28, 121384699 },
	{ 28, 129511163 },
	{ 28, 132001535 },
	{ 28, 127872763 },
	{ 28, 127676155 },
	{ 28, 100510717 },
	{ 26, 32911103 },
	{ 26, 31928059 },
	{ 26, 65285883 },
	{ 26, 66072315 },
	{ 26, 16396027 },
	{ 26, 33173243 },
	{ 26, 33500927 },
	{ 27, 64564987 },
	{ 27, 60632827 },
	{ 28, 133836539 },
	{ 28, 86847227 },
	{ 27, 62467835 },
	{ 27, 54341371 },
	{ 28, 57224955 },
	{ 28, 98675705 },
	{ 26, 24719099 },
	{ 26, 8204027 },
	{ 20, 360430 },
	{ 26, 15281919 },
	{ 26, 33303547 },
	{ 28, 49818619 },
	{ 28, 65809403 },
	{ 28, 115878907 },
	{ 28, 125578235 },
	{ 29, 175647739 },
	{ 29, 191638523 },
	{ 29, 241708027 },
	{ 28, 129772539 },
	{ 29, 221785083 },
	{ 28, 127806463 },
	{ 28, 115289083 },
	{ 28, 131869691 },
	{ 28, 99462909 },
	{ 26, 31861759 },
	{ 26, 28781563 },
	{ 26, 66333691 },
	{ 26, 31534075 },
	{ 26, 16657403 },
	{ 26, 33434619 },
	{ 27, 63777787 },
	{ 27, 60369915 },
	{ 27, 48049147 },
	{ 28, 134097915 },
	{ 27, 61680635 },
	{ 27, 54078459 },
	{ 27, 29174779 },
	{ 28, 95530745 },
	{ 26, 23931899 },
	{ 26, 7941115 },
	{ 20, 344046 },
	{ 26, 8203263 },
	{ 26, 33303291 },
	{ 28, 49818363 },
	{ 28, 65809147 },
	{ 28, 115878651 },
	{ 28, 125577979 },
	{ 29, 175647483 },
	{ 29, 191638267 },
	{ 29, 241707771 },
	{ 28, 129772283 },
	{ 29, 221784827 },
	{ 28, 127806207 },
	{ 28, 115288827 },
	{ 28, 131869435 },
	{ 28, 99463165 },
	{ 26, 31861503 },
	{ 26, 28781307 },
	{ 26, 66333435 },
	{ 26, 31533819 },
	{ 26, 16657147 },
	{ 26, 33434363 },
	{ 27, 63777531 },
	{ 27, 60369659 },
	{ 27, 48048891 },
	{ 28, 134097659 },
	{ 27, 61680379 },
	{ 27, 54078203 },
	{ 27, 29174523 },
	{ 28, 95531001 },
	{ 26, 23931643 },
	{ 26, 7940859 },
	{ 20, 339358 },
	{ 26, 8203007 },
	{ 26, 24980223 },
	{ 26, 12525563 },
	{ 26, 16654331 },
	{ 26, 29040635 },
	{ 26, 33169403 },
	{ 27, 43982843 },
	{ 27, 48111611 },
	{ 27, 60497915 },
	{ 27, 64626683 },
	{ 27, 55517179 },
	{ 27, 57548795 },
	{ 26, 28811263 },
	{ 26, 27779067 },
	{ 26, 61284347 },
	{ 26, 62267387 },
	{ 24, 7184383 },
	{ 24, 6938619 },
	{ 24, 6873083 },
	{ 24, 7102459 },
	{ 24, 6905851 },
	{ 25, 15884283 },
	{ 25, 14901243 },
	{ 25, 11952123 },
	{ 25, 10969083 },
	{ 25, 15359995 },
	{ 25, 13328379 },
	{ 25, 7233531 },
	{ 25, 5201915 },
	{ 24, 5922811 },
	{ 24, 1794043 },
	{ 19, 257310 },
	{ 24, 1990655 },
	{ 24, 6184959 },
	{ 26, 12525307 },
	{ 26, 16654075 },
	{ 26, 29040379 },
	{ 26, 33169147 },
	{ 27, 43982587 },
	{ 27, 48111355 },
	{ 27, 60497659 },
	{ 27, 64626427 },
	{ 27, 55516923 },
	{ 27, 57548539 },
	{ 26, 28811007 },
	{ 26, 27778811 },
	{ 26, 61284091 },
	{ 26, 62267131 },
	{ 24, 7184127 },
	{ 24, 6938363 },
	{ 24, 6872827 },
	{ 24, 7102203 },
	{ 24, 6905595 },
	{ 25, 15884027 },
	{ 25, 14900987 },
	{ 25, 11951867 },
	{ 25, 10968827 },
	{ 25, 15359739 },
	{ 25, 13328123 },
	{ 25, 7233275 },
	{ 25, 5201659 },
	{ 24, 5922555 },
	{ 24, 1793787 },
	{ 19, 240926 },
	{ 24, 1990399 },
	{ 24, 6184703 },
	{ 26, 10379007 },
	{ 26, 16718843 },
	{ 26, 29236219 },
	{ 26, 33233915 },
	{ 27, 45751291 },
	{ 27, 48176123 },
	{ 27, 60693499 },
	{ 27, 64691195 },
	{ 26, 32496635 },
	{ 26, 32431099 },
	{ 26, 32234491 },
	{ 26, 32168955 },
	{ 25, 16243707 },
	{ 25, 16178171 },
	{ 25, 15981563 },
	{ 24, 6921215 },
	{ 23, 4054011 },
	{ 23, 3988475 },
	{ 24, 6839291 },
	{ 23, 4021243 },
	{ 25, 14834683 },
	{ 25, 11754491 },
	{ 25, 10902523 },
	{ 24, 7822331 },
	{ 25, 13261819 },
	{ 25, 7035899 },
	{ 25, 5135355 },
	{ 23, 3103739 },
	{ 24, 1727483 },
	{ 18, 112542 },
	{ 24, 1793023 },
	{ 24, 5987327 },
	{ 26, 10181631 },
	{ 26, 16718587 },
	{ 26, 29235963 },
	{ 26, 33233659 },
	{ 27, 45751035 },
	{ 27, 48175867 },
	{ 27, 60693243 },
	{ 27, 64690939 },
	{ 26, 32496379 },
	{ 26, 32430843 },
	{ 26, 32234235 },
	{ 26, 32168699 },
	{ 25, 16243451 },
	{ 25, 16177915 },
	{ 25, 15981307 },
	{ 24, 6920959 },
	{ 23, 4053755 },
	{ 23, 3988219 },
	{ 24, 6839035 },
	{ 23, 4020987 },
	{ 25, 14834427 },
	{ 25, 11754235 },
	{ 25, 10902267 },
	{ 24, 7822075 },
	{ 25, 13261563 },
	{ 25, 7035643 },
	{ 25, 5135099 },
	{ 23, 3103483 },
	{ 24, 1727227 },
	{ 18, 104350 },
	{ 24, 1792767 },
	{ 24, 5987071 },
	{ 26, 10181375 },
	{ 26, 14375679 },
	{ 26, 29298683 },
	{ 26, 33427451 },
	{ 27, 45813755 },
	{ 27, 49942523 },
	{ 27, 60755963 },
	{ 27, 64884731 },
	{ 26, 32477183 },
	{ 26, 30396411 },
	{ 26, 30330875 },
	{ 26, 30134267 },
	{ 25, 16224255 },
	{ 25, 15192059 },
	{ 25, 15126523 },
	{ 25, 14929915 },
	{ 23, 4034559 },
	{ 23, 3788795 },
	{ 23, 3723259 },
	{ 23, 3952635 },
	{ 23, 3756027 },
	{ 25, 11685883 },
	{ 25, 10702843 },
	{ 24, 7753723 },
	{ 24, 6770683 },
	{ 25, 6967291 },
	{ 25, 4935675 },
	{ 23, 3035131 },
	{ 23, 1003515 },
	{ 18, 63262 },
	{ 24, 1724415 },
	{ 24, 5918719 },
	{ 26, 10113023 },
	{ 26, 14307327 },
	{ 26, 29298427 },
	{ 26, 33427195 },
	{ 27, 45813499 },
	{ 27, 49942267 },
	{ 27, 60755707 },
	{ 27, 64884475 },
	{ 26, 32476927 },
	{ 26, 30396155 },
	{ 26, 30330619 },
	{ 26, 30134011 },
	{ 25, 16223999 },
	{ 25, 15191803 },
	{ 25, 15126267 },
	{ 25, 14929659 },
	{ 23, 4034303 },
	{ 23, 3788539 },
	{ 23, 3723003 },
	{ 23, 3952379 },
	{ 23, 3755771 },
	{ 25, 11685627 },
	{ 25, 10702587 },
	{ 24, 7753467 },
	{ 24, 6770427 },
	{ 25, 6967035 },
	{ 25, 4935419 },
	{ 23, 3034875 },
	{ 23, 1003259 },
	{ 18, 55070 },
	{ 24, 1724159 },
	{ 24, 5918463 },
	{ 26, 10112767 },
	{ 26, 14307071 },
	{ 26, 26889983 },
	{ 26, 33491963 },
	{ 27, 46009339 },
	{ 27, 50007035 },
	{ 27, 62524411 },
	{ 27, 64949243 },
	{ 27, 47959035 },
	{ 26, 30379007 },
	{ 26, 24103931 },
	{ 26, 24038395 },
	{ 26, 23841787 },
	{ 25, 15174655 },
	{ 25, 12045307 },
	{ 25, 11979771 },
	{ 25, 11783163 },
	{ 23, 3771391 },
	{ 23, 3001339 },
	{ 23, 2935803 },
	{ 23, 3689467 },
	{ 23, 2968571 },
	{ 25, 10636283 },
	{ 24, 7556091 },
	{ 24, 6704123 },
	{ 24, 3623931 },
	{ 25, 4869115 },
	{ 23, 2837499 },
	{ 23, 936955 },
	{ 18, 46494 },
	{ 23, 1002495 },
	{ 23, 3099647 },
	{ 25, 5196799 },
	{ 25, 7293951 },
	{ 25, 13585407 },
	{ 25, 15682559 },
	{ 26, 21974015 },
	{ 26, 24071167 },
	{ 26, 30362623 },
	{ 26, 32459775 },
	{ 27, 47958779 },
	{ 26, 30378751 },
	{ 26, 24103675 },
	{ 26, 24038139 },
	{ 26, 23841531 },
	{ 25, 15174399 },
	{ 25, 12045051 },
	{ 25, 11979515 },
	{ 25, 11782907 },
	{ 23, 3771135 },
	{ 23, 3001083 },
	{ 23, 2935547 },
	{ 23, 3689211 },
	{ 23, 2968315 },
	{ 25, 10636027 },
	{ 24, 7555835 },
	{ 24, 6703867 },
	{ 24, 3623675 },
	{ 25, 4868859 },
	{ 23, 2837243 },
	{ 23, 936699 },
	{ 18, 38302 },
	{ 23, 1002239 },
	{ 23, 3099391 },
	{ 25, 5196543 },
	{ 25, 7293695 },
	{ 25, 13585151 },
	{ 25, 11532283 },
	{ 25, 11519995 },
	{ 25, 12552187 },
	{ 25, 15648763 },
	{ 25, 16680955 },
	{ 25, 10991611 },
	{ 25, 10942459 },
	{ 24, 6023167 },
	{ 24, 5502971 },
	{ 24, 5486587 },
	{ 24, 5437435 },
	{ 23, 3008511 },
	{ 23, 2750459 },
	{ 23, 2734075 },
	{ 23, 2684923 },
	{ 21, 747519 },
	{ 21, 686075 },
	{ 21, 669691 },
	{ 21, 727035 },
	{ 21, 677883 },
	{ 22, 1873915 },
	{ 22, 1628155 },
	{ 22, 890875 },
	{ 22, 645115 },
	{ 21, 694267 },
	{ 21, 186363 },
	{ 16, 29982 },
	{ 21, 235519 },
	{ 21, 759807 },
	{ 23, 1284095 },
	{ 23, 1808383 },
	{ 23, 3381247 },
	{ 23, 3905535 },
	{ 24, 5478399 },
	{ 24, 6002687 },
	{ 24, 7575551 },
	{ 24, 8099839 },
	{ 25, 10991355 },
	{ 25, 10942203 },
	{ 24, 6022911 },
	{ 24, 5502715 },
	{ 24, 5486331 },
	{ 24, 5437179 },
	{ 23, 3008255 },
	{ 23, 2750203 },
	{ 23, 2733819 },
	{ 23, 2684667 },
	{ 21, 747263 },
	{ 21, 685819 },
	{ 21, 669435 },
	{ 21, 726779 },
	{ 21, 677627 },
	{ 22, 1873659 },
	{ 22, 1627899 },
	{ 22, 890619 },
	{ 22, 644859 },
	{ 21, 694011 },
	{ 21, 186107 },
	{ 16, 21790 },
	{ 21, 235263 },
	{ 21, 759551 },
	{ 23, 1283839 },
	{ 23, 1808127 },
	{ 23, 3380991 },
	{ 23, 3905279 },
	{ 24, 8385531 },
	{ 24, 8369147 },
	{ 24, 8319995 },
	{ 24, 8303611 },
	{ 24, 7861243 },
	{ 24, 7844859 },
	{ 24, 7795707 },
	{ 24, 7779323 },
	{ 23, 3929083 },
	{ 23, 3912699 },
	{ 23, 3863547 },
	{ 23, 3847163 },
	{ 22, 1963003 },
	{ 22, 1946619 },
	{ 22, 1897467 },
	{ 21, 680959 },
	{ 20, 488443 },
	{ 20, 472059 },
	{ 21, 660475 },
	{ 20, 480251 },
	{ 22, 1610747 },
	{ 22, 840699 },
	{ 22, 627707 },
	{ 20, 381947 },
	{ 21, 168955 },
	{ 15, 7070 },
	{ 21, 185343 },
	{ 21, 709631 },
	{ 23, 1233919 },
	{ 23, 1758207 },
	{ 23, 3331071 },
	{ 23, 3855359 },
	{ 24, 8385275 },
	{ 24, 8368891 },
	{ 24, 8319739 },
	{ 24, 8303355 },
	{ 24, 7860987 },
	{ 24, 7844603 },
	{ 24, 7795451 },
	{ 24, 7779067 },
	{ 23, 3928827 },
	{ 23, 3912443 },
	{ 23, 3863291 },
	{ 23, 3846907 },
	{ 22, 1962747 },
	{ 22, 1946363 },
	{ 22, 1897211 },
	{ 21, 680703 },
	{ 20, 488187 },
	{ 20, 471803 },
	{ 21, 660219 },
	{ 20, 479995 },
	{ 22, 1610491 },
	{ 22, 840443 },
	{ 22, 627451 },
	{ 20, 381691 },
	{ 21, 168699 },
	{ 15, 2974 },
	{ 21, 185087 },
	{ 21, 709375 },
	{ 23, 1233663 },
	{ 23, 1757951 },
	{ 23, 3330815 },
	{ 23, 3855103 },
	{ 22, 2095615 },
	{ 22, 1834491 },
	{ 22, 1830395 },
	{ 22, 1818107 },
	{ 22, 1814011 },
	{ 22, 1703419 },
	{ 22, 1699323 },
	{ 22, 1687035 },
	{ 21, 981503 },
	{ 21, 851451 },
	{ 21, 847355 },
	{ 21, 835067 },
	{ 20, 489983 },
	{ 20, 425467 },
	{ 20, 421371 },
	{ 20, 409083 },
	{ 18, 121343 },
	{ 18, 105979 },
	{ 18, 101883 },
	{ 18, 116219 },
	{ 18, 103931 },
	{ 20, 206331 },
	{ 20, 144891 },
	{ 18, 91643 },
	{ 18, 30203 },
	{ 13, 4894 },
	{ 19, 42495 },
	{ 19, 173567 },
	{ 21, 304639 },
	{ 21, 435711 },
	{ 21, 828927 },
	{ 21, 959999 },
	{ 22, 4160765 },
	{ 22, 4155641 },
	{ 22, 4090105 },
	{ 22, 3893497 },
	{ 22, 3827961 },
	{ 22, 2058489 },
	{ 22, 1992953 },
	{ 22, 1796345 },
	{ 21, 1015037 },
	{ 21, 1009913 },
	{ 21, 944377 },
	{ 21, 747769 },
	{ 20, 490749 },
	{ 20, 485625 },
	{ 20, 420089 },
	{ 20, 223481 },
	{ 18, 97533 },
	{ 18, 92409 },
	{ 18, 26873 },
	{ 18, 114937 },
	{ 18, 102649 },
	{ 20, 205049 },
	{ 20, 143609 },
	{ 18, 90361 },
	{ 18, 28921 },
	{ 13, 874 },
	{ 19, 41213 },
	{ 19, 172285 },
	{ 21, 303357 },
	{ 21, 434429 },
	{ 21, 827645 },
	{ 21, 958717 },
	{ 22, 1351933 },
	{ 22, 4155897 },
	{ 22, 4090361 },
	{ 22, 3893753 },
	{ 22, 3828217 },
	{ 22, 2058745 },
	{ 22, 1993209 },
	{ 22, 1796601 },
	{ 21, 1015293 },
	{ 21, 1010169 },
	{ 21, 944633 },
	{ 21, 748025 },
	{ 20, 491005 },
	{ 20, 485881 },
	{ 20, 420345 },
	{ 20, 223737 },
	{ 18, 97789 },
	{ 18, 92665 },
	{ 18, 27129 },
	{ 18, 115193 },
	{ 18, 102905 },
	{ 20, 205305 },
	{ 20, 143865 },
	{ 18, 90617 },
	{ 18, 29177 },
	{ 13, 4970 },
	{ 19, 41469 },
	{ 19, 172541 },
	{ 21, 303613 },
	{ 21, 434685 },
	{ 21, 827901 },
	{ 21, 958973 },
	{ 22, 1352189 },
	{ 22, 1483261 },
	{ 22, 1876477 },
	{ 22, 2007549 },
	{ 23, 3449341 },
	{ 23, 3580413 },
	{ 23, 3973629 },
	{ 23, 4104701 },
	{ 23, 7643645 },
	{ 23, 4043517 },
	{ 23, 3990265 },
	{ 23, 3728121 },
	{ 23, 2941689 },
	{ 22, 1946365 },
	{ 22, 1893113 },
	{ 22, 1630969 },
	{ 22, 844537 },
	{ 20, 373501 },
	{ 20, 320249 },
	{ 20, 58105 },
	{ 20, 393977 },
	{ 20, 213753 },
	{ 22, 557817 },
	{ 20, 312057 },
	{ 20, 99065 },
	{ 15, 2538 },
	{ 20, 115453 },
	{ 20, 377597 },
	{ 22, 639741 },
	{ 22, 901885 },
	{ 22, 1688317 },
	{ 22, 1950461 },
	{ 23, 2736893 },
	{ 23, 2999037 },
	{ 23, 3785469 },
	{ 23, 4047613 },
	{ 24, 15524857 },
	{ 24, 15262713 },
	{ 24, 8184825 },
	{ 24, 7922681 },
	{ 24, 7136249 },
	{ 23, 4043773 },
	{ 23, 3990521 },
	{ 23, 3728377 },
	{ 23, 2941945 },
	{ 22, 1946621 },
	{ 22, 1893369 },
	{ 22, 1631225 },
	{ 22, 844793 },
	{ 20, 373757 },
	{ 20, 320505 },
	{ 20, 58361 },
	{ 20, 394233 },
	{ 20, 214009 },
	{ 22, 558073 },
	{ 20, 312313 },
	{ 20, 99321 },
	{ 15, 6634 },
	{ 20, 115709 },
	{ 20, 377853 },
	{ 22, 639997 },
	{ 22, 902141 },
	{ 22, 1688573 },
	{ 22, 1950717 },
	{ 23, 2737149 },
	{ 23, 2999293 },
	{ 23, 3785725 },
	{ 23, 4047869 },
	{ 24, 16295673 },
	{ 24, 15509241 },
	{ 24, 15247097 },
	{ 24, 8169209 },
	{ 24, 7907065 },
	{ 24, 7120633 },
	{ 23, 3995389 },
	{ 23, 3974905 },
	{ 23, 3712761 },
	{ 23, 2926329 },
	{ 22, 1898237 },
	{ 22, 1877753 },
	{ 22, 1615609 },
	{ 22, 829177 },
	{ 20, 325373 },
	{ 20, 304889 },
	{ 20, 42745 },
	{ 20, 198393 },
	{ 20, 149241 },
	{ 20, 296697 },
	{ 20, 50937 },
	{ 15, 10602 },
	{ 20, 100093 },
	{ 20, 362237 },
	{ 22, 624381 },
	{ 22, 886525 },
	{ 22, 1672957 },
	{ 22, 1935101 },
	{ 23, 2721533 },
	{ 23, 2983677 },
	{ 23, 3770109 },
	{ 23, 4032253 },
	{ 24, 16295929 },
	{ 24, 15509497 },
	{ 24, 15247353 },
	{ 24, 8169465 },
	{ 24, 7907321 },
	{ 24, 7120889 },
	{ 23, 3995645 },
	{ 23, 3975161 },
	{ 23, 3713017 },
	{ 23, 2926585 },
	{ 22, 1898493 },
	{ 22, 1878009 },
	{ 22, 1615865 },
	{ 22, 829433 },
	{ 20, 325629 },
	{ 20, 305145 },
	{ 20, 43001 },
	{ 20, 198649 },
	{ 20, 149497 },
	{ 20, 296953 },
	{ 20, 51193 },
	{ 15, 14698 },
	{ 20, 100349 },
	{ 20, 362493 },
	{ 22, 624637 },
	{ 22, 886781 },
	{ 22, 1673213 },
	{ 22, 1935357 },
	{ 23, 2721789 },
	{ 23, 2983933 },
	{ 23, 3770365 },
	{ 23, 4032509 },
	{ 24, 16616185 },
	{ 24, 16354041 },
	{ 24, 15567609 },
	{ 24, 15305465 },
	{ 24, 8227577 },
	{ 24, 7965433 },
	{ 24, 7179001 },
	{ 24, 6916857 },
	{ 23, 4033273 },
	{ 23, 3771129 },
	{ 23, 2984697 },
	{ 23, 2722553 },
	{ 22, 1936121 },
	{ 22, 1673977 },
	{ 22, 887545 },
	{ 22, 625401 },
	{ 20, 363257 },
	{ 20, 101113 },
	{ 22, 527097 },
	{ 20, 330489 },
	{ 22, 133881 },
	{ 15, 4842 },
	{ 22, 199421 },
	{ 22, 1247997 },
	{ 24, 2296573 },
	{ 24, 3345149 },
	{ 24, 6490877 },
	{ 24, 7539453 },
	{ 25, 10685181 },
	{ 25, 11733757 },
	{ 25, 14879485 },
	{ 25, 15928061 },
	{ 24, 16616441 },
	{ 24, 16354297 },
	{ 24, 15567865 },
	{ 24, 15305721 },
	{ 24, 8227833 },
	{ 24, 7965689 },
	{ 24, 7179257 },
	{ 24, 6917113 },
	{ 23, 4033529 },
	{ 23, 3771385 },
	{ 23, 2984953 },
	{ 23, 2722809 },
	{ 22, 1936377 },
	{ 22, 1674233 },
	{ 22, 887801 },
	{ 22, 625657 },
	{ 20, 363513 },
	{ 20, 101369 },
	{ 22, 527353 },
	{ 20, 330745 },
	{ 22, 134137 },
	{ 15, 5866 },
	{ 22, 199677 },
	{ 22, 1248253 },
	{ 24, 2296829 },
	{ 24, 3345405 },
	{ 24, 6491133 },
	{ 24, 7539709 },
	{ 25, 10685437 },
	{ 25, 11734013 },
	{ 25, 14879741 },
	{ 25, 15928317 },
	{ 24, 16633597 },
	{ 24, 16551673 },
	{ 24, 16289529 },
	{ 24, 15503097 },
	{ 24, 15240953 },
	{ 24, 8163065 },
	{ 24, 7900921 },
	{ 24, 7114489 },
	{ 23, 4050685 },
	{ 23, 3968761 },
	{ 23, 3706617 },
	{ 23, 2920185 },
	{ 22, 1953533 },
	{ 22, 1871609 },
	{ 22, 1609465 },
	{ 22, 823033 },
	{ 20, 380669 },
	{ 20, 298745 },
	{ 20, 36601 },
	{ 16, 13689 },
	{ 15, 15801 },
	{ 15, 6762 },
	{ 22, 134909 },
	{ 22, 1183485 },
	{ 24, 2232061 },
	{ 24, 3280637 },
	{ 24, 6426365 },
	{ 24, 7474941 },
	{ 25, 10620669 },
	{ 25, 11669245 },
	{ 25, 14814973 },
	{ 25, 15863549 },
	{ 24, 16633853 },
	{ 24, 16551929 },
	{ 24, 16289785 },
	{ 24, 15503353 },
	{ 24, 15241209 },
	{ 24, 8163321 },
	{ 24, 7901177 },
	{ 24, 7114745 },
	{ 23, 4050941 },
	{ 23, 3969017 },
	{ 23, 3706873 },
	{ 23, 2920441 },
	{ 22, 1953789 },
	{ 22, 1871865 },
	{ 22, 1609721 },
	{ 22, 823289 },
	{ 20, 380925 },
	{ 20, 299001 },
	{ 20, 36857 },
	{ 16, 15737 },
	{ 14, 7865 },
	{ 15, 7786 },
	{ 22, 135165 },
	{ 22, 1183741 },
	{ 24, 2232317 },
	{ 24, 3280893 },
	{ 24, 6426621 },
	{ 24, 7475197 },
	{ 25, 10620925 },
	{ 25, 11669501 },
	{ 25, 14815229 },
	{ 25, 15863805 },
	{ 26, 27398141 },
	{ 24, 16571133 },
	{ 24, 16308989 },
	{ 24, 15522557 },
	{ 24, 15260413 },
	{ 24, 8182525 },
	{ 24, 7920381 },
	{ 24, 7133949 },
	{ 24, 6871805 },
	{ 23, 3988221 },
	{ 23, 3726077 },
	{ 23, 2939645 },
	{ 23, 2677501 },
	{ 22, 1891069 },
	{ 22, 1628925 },
	{ 22, 842493 },
	{ 22, 580349 },
	{ 20, 318205 },
	{ 20, 56061 },
	{ 14, 8169 },
	{ 12, 1961 },
	{ 13, 3930 },
	{ 16, 32189 },
	{ 20, 334589 },
	{ 22, 596733 },
	{ 22, 858877 },
	{ 22, 1645309 },
	{ 22, 1907453 },
	{ 23, 2693885 },
	{ 23, 2956029 },
	{ 23, 3742461 },
	{ 23, 4004605 },
	{ 24, 6888189 },
	{ 24, 7150333 },
	{ 24, 7936765 },
	{ 24, 8198909 },
	{ 24, 15276797 },
	{ 24, 15538941 },
	{ 24, 16325373 },
	{ 24, 16587517 },
	{ 24, 6872061 },
	{ 23, 3988477 },
	{ 23, 3726333 },
	{ 23, 2939901 },
	{ 23, 2677757 },
	{ 22, 1891325 },
	{ 22, 1629181 },
	{ 22, 842749 },
	{ 22, 580605 },
	{ 20, 318461 },
	{ 20, 56317 },
	{ 14, 7993 },
	{ 11, 969 },
	{ 13, 4058 },
	{ 15, 16061 },
	{ 20, 334845 },
	{ 22, 596989 },
	{ 22, 859133 },
	{ 22, 1645565 },
	{ 22, 1907709 },
	{ 23, 2694141 },
	{ 23, 2956285 },
	{ 23, 3742717 },
	{ 23, 4004861 },
	{ 24, 6888445 },
	{ 24, 7150589 },
	{ 24, 7937021 },
	{ 24, 16539389 },
	{ 24, 16277245 },
	{ 24, 15490813 },
	{ 24, 15228669 },
	{ 24, 8150781 },
	{ 24, 7888637 },
	{ 24, 7102205 },
	{ 24, 6840061 },
	{ 23, 3956477 },
	{ 23, 3694333 },
	{ 23, 2907901 },
	{ 23, 2645757 },
	{ 22, 1859325 },
	{ 22, 1597181 },
	{ 22, 810749 },
	{ 22, 548605 },
	{ 16, 30589 },
	{ 12, 2013 },
	{ 24, 524025 },
	{ 13, 4013 },
	{ 16, 30077 },
	{ 22, 532221 },
	{ 22, 794365 },
	{ 22, 1580797 },
	{ 22, 1842941 },
	{ 23, 2629373 },
	{ 23, 2891517 },
	{ 23, 3677949 },
	{ 23, 3940093 },
	{ 24, 6823677 },
	{ 24, 7085821 },
	{ 24, 7872253 },
	{ 24, 8134397 },
	{ 24, 15212285 },
	{ 24, 15474429 },
	{ 24, 16260861 },
	{ 24, 16523005 },
	{ 24, 7888893 },
	{ 24, 7102461 },
	{ 24, 6840317 },
	{ 23, 3956733 },
	{ 23, 3694589 },
	{ 23, 2908157 },
	{ 23, 2646013 },
	{ 22, 1859581 },
	{ 22, 1597437 },
	{ 22, 811005 },
	{ 22, 548861 },
	{ 16, 32637 },
	{ 15, 16237 },
	{ 12, 1674 },
	{ 12, 1997 },
	{ 16, 32125 },
	{ 22, 532477 },
	{ 22, 794621 },
	{ 22, 1581053 },
	{ 22, 1843197 },
	{ 23, 2629629 },
	{ 23, 2891773 },
	{ 23, 3678205 },
	{ 23, 3940349 },
	{ 24, 6823933 },
	{ 24, 7086077 },
	{ 24, 7872509 },
	{ 24, 8134653 },
	{ 24, 15212541 },
	{ 24, 15474685 },
	{ 24, 16261117 },
	{ 24, 16523261 },
	{ 26, 31795965 },
	{ 26, 28650237 },
	{ 26, 27601661 },
	{ 25, 16067325 },
	{ 25, 15018749 },
	{ 25, 11873021 },
	{ 25, 10824445 },
	{ 24, 7678717 },
	{ 24, 6630141 },
	{ 24, 3484413 },
	{ 24, 2435837 },
	{ 22, 1387261 },
	{ 17, 65149 },
	{ 12, 1738 },
	{ 13, 4057 },
	{ 16, 32749 },
	{ 22, 142077 },
	{ 22, 404221 },
	{ 24, 666365 },
	{ 24, 928509 },
	{ 24, 1714941 },
	{ 24, 1977085 },
	{ 25, 2763517 },
	{ 25, 3025661 },
	{ 25, 3812093 },
	{ 25, 4074237 },
	{ 26, 6957821 },
	{ 26, 7219965 },
	{ 26, 8006397 },
	{ 26, 8268541 },
	{ 26, 15346429 },
	{ 26, 15608573 },
	{ 26, 16395005 },
	{ 26, 16657149 },
	{ 26, 27601917 },
	{ 25, 16067581 },
	{ 25, 15019005 },
	{ 25, 11873277 },
	{ 25, 10824701 },
	{ 24, 7678973 },
	{ 24, 6630397 },
	{ 24, 3484669 },
	{ 24, 2436093 },
	{ 22, 1387517 },
	{ 18, 131005 },
	{ 16, 32570 },
	{ 16, 32617 },
	{ 16, 32573 },
	{ 22, 142333 },
	{ 22, 404477 },
	{ 24, 666621 },
	{ 24, 928765 },
	{ 24, 1715197 },
	{ 24, 1977341 },
	{ 25, 2763773 },
	{ 25, 3025917 },
	{ 25, 3812349 },
	{ 25, 4074493 },
	{ 26, 6958077 },
	{ 26, 7220221 },
	{ 26, 8006653 },
	{ 26, 8268797 },
	{ 26, 15346685 },
	{ 26, 15608829 },
	{ 26, 16395261 },
	{ 26, 16657405 },
	{ 28, 109653757 },
	{ 27, 63516413 },
	{ 27, 59322109 },
	{ 27, 46739197 },
	{ 27, 42544893 },
	{ 26, 29961981 },
	{ 26, 25767677 },
	{ 26, 13184765 },
	{ 26, 8990461 },
	{ 24, 4796157 },
	{ 24, 601853 },
	{ 16, 23066 },
	{ 18, 130681 },
	{ 17, 46969 },
	{ 22, 208633 },
	{ 22, 470777 },
	{ 22, 1453821 },
	{ 24, 995065 },
	{ 24, 1781497 },
	{ 24, 2043641 },
	{ 24, 6172413 },
	{ 25, 3092217 },
	{ 25, 3878649 },
	{ 25, 4140793 },
	{ 25, 12463869 },
	{ 26, 7286521 },
	{ 26, 8072953 },
	{ 26, 8335097 },
	{ 26, 15412985 },
	{ 26, 15675129 },
	{ 26, 16461561 },
	{ 26, 16723705 },
	{ 26, 33435389 },
	{ 27, 63516669 },
	{ 27, 59322365 },
	{ 27, 46739453 },
	{ 27, 42545149 },
	{ 26, 29962237 },
	{ 26, 25767933 },
	{ 26, 13185021 },
	{ 26, 8990717 },
	{ 24, 4796413 },
	{ 24, 602109 },
	{ 16, 24090 },
	{ 19, 262073 },
	{ 17, 49017 },
	{ 22, 208889 },
	{ 22, 471033 },
	{ 22, 1454077 },
	{ 24, 995321 },
	{ 24, 1781753 },
	{ 24, 2043897 },
	{ 24, 6172669 },
	{ 25, 3092473 },
	{ 25, 3878905 },
	{ 25, 4141049 },
	{ 25, 12464125 },
	{ 26, 7286777 },
	{ 26, 8073209 },
	{ 26, 8335353 },
	{ 26, 15413241 },
	{ 26, 15675385 },
	{ 26, 16461817 },
	{ 26, 16723961 },
	{ 26, 33435645 },
	{ 27, 63781629 },
	{ 27, 59587325 },
	{ 27, 47004413 },
	{ 27, 42810109 },
	{ 26, 30227197 },
	{ 26, 26032893 },
	{ 26, 13449981 },
	{ 26, 9255677 },
	{ 24, 5061373 },
	{ 24, 867069 },
	{ 16, 29338 },
	{ 24, 604921 },
	{ 22, 1391353 },
	{ 23, 2686971 },
	{ 22, 1260281 },
	{ 22, 1522425 },
	{ 23, 2949115 },
	{ 24, 5192441 },
	{ 24, 5978873 },
	{ 24, 6241017 },
	{ 25, 11221753 },
	{ 25, 11483897 },
	{ 25, 12270329 },
	{ 25, 12532473 },
	{ 26, 23804665 },
	{ 26, 24066809 },
	{ 26, 24853241 },
	{ 26, 25115385 },
	{ 26, 32193273 },
	{ 26, 32455417 },
	{ 26, 33241849 },
	{ 26, 33503993 },
	{ 27, 63781885 },
	{ 27, 59587581 },
	{ 27, 47004669 },
	{ 27, 42810365 },
	{ 26, 30227453 },
	{ 26, 26033149 },
	{ 26, 13450237 },
	{ 26, 9255933 },
	{ 24, 5061629 },
	{ 24, 867325 },
	{ 16, 30362 },
	{ 24, 605177 },
	{ 22, 1391609 },
	{ 23, 2686715 },
	{ 22, 1260537 },
	{ 22, 1522681 },
	{ 23, 2948859 },
	{ 24, 5192697 },
	{ 24, 5979129 },
	{ 24, 6241273 },
	{ 25, 11222009 },
	{ 25, 11484153 },
	{ 25, 12270585 },
	{ 25, 12532729 },
	{ 26, 23804921 },
	{ 26, 24067065 },
	{ 26, 24853497 },
	{ 26, 25115641 },
	{ 26, 32193529 },
	{ 26, 32455673 },
	{ 26, 33242105 },
	{ 26, 33504249 },
	{ 27, 64569085 },
	{ 27, 60374781 },
	{ 27, 47791869 },
	{ 27, 43597565 },
	{ 26, 31014653 },
	{ 26, 26820349 },
	{ 26, 14237437 },
	{ 26, 10043133 },
	{ 24, 5848829 },
	{ 24, 1654525 },
	{ 18, 125210 },
	{ 24, 868089 },
	{ 24, 4800249 },
	{ 24, 2440953 },
	{ 24, 3227385 },
	{ 24, 2309881 },
	{ 24, 2572025 },
	{ 24, 3555069 },
	{ 25, 10419199 },
	{ 26, 10174201 },
	{ 26, 10436345 },
	{ 26, 14565117 },
	{ 27, 19873529 },
	{ 27, 20659961 },
	{ 27, 20922105 },
	{ 27, 29245181 },
	{ 28, 40845049 },
	{ 28, 41631481 },
	{ 28, 41893625 },
	{ 28, 48971513 },
	{ 28, 49233657 },
	{ 28, 50020089 },
	{ 27, 64569341 },
	{ 27, 60375037 },
	{ 27, 47792125 },
	{ 27, 43597821 },
	{ 26, 31014909 },
	{ 26, 26820605 },
	{ 26, 14237693 },
	{ 26, 10043389 },
	{ 24, 5849085 },
	{ 24, 1654781 },
	{ 18, 129306 },
	{ 24, 868345 },
	{ 24, 4800505 },
	{ 24, 2441209 },
	{ 24, 3227641 },
	{ 24, 2310137 },
	{ 24, 2572281 },
	{ 24, 3555325 },
	{ 25, 10418943 },
	{ 26, 10174457 },
	{ 26, 10436601 },
	{ 26, 14565373 },
	{ 27, 19873785 },
	{ 27, 20660217 },
	{ 27, 20922361 },
	{ 27, 29245437 },
	{ 28, 40845305 },
	{ 28, 41631737 },
	{ 28, 41893881 },
	{ 28, 48971769 },
	{ 28, 49233913 },
	{ 28, 50020345 },
	{ 27, 64842493 },
	{ 27, 60648189 },
	{ 27, 48065277 },
	{ 27, 43870973 },
	{ 26, 31288061 },
	{ 26, 27093757 },
	{ 26, 14510845 },
	{ 26, 10316541 },
	{ 24, 6122237 },
	{ 24, 1927933 },
	{ 19, 215450 },
	{ 24, 1665785 },
	{ 24, 5073657 },
	{ 25, 10022907 },
	{ 24, 3500793 },
	{ 24, 6384377 },
	{ 24, 3369721 },
	{ 24, 3631865 },
	{ 24, 6712061 },
	{ 25, 11988991 },
	{ 26, 14379769 },
	{ 26, 14641913 },
	{ 26, 27159293 },
	{ 27, 28273401 },
	{ 27, 29059833 },
	{ 27, 29321977 },
	{ 27, 54422269 },
	{ 28, 57633529 },
	{ 28, 58419961 },
	{ 28, 58682105 },
	{ 28, 65759993 },
	{ 28, 66022137 },
	{ 27, 64842749 },
	{ 27, 60648445 },
	{ 27, 48065533 },
	{ 27, 43871229 },
	{ 26, 31288317 },
	{ 26, 27094013 },
	{ 26, 14511101 },
	{ 26, 10316797 },
	{ 24, 6122493 },
	{ 24, 1928189 },
	{ 19, 219546 },
	{ 24, 1666041 },
	{ 24, 5073913 },
	{ 25, 10022651 },
	{ 24, 3501049 },
	{ 24, 6384633 },
	{ 24, 3369977 },
	{ 24, 3632121 },
	{ 24, 6712317 },
	{ 25, 11988735 },
	{ 26, 14380025 },
	{ 26, 14642169 },
	{ 26, 27159549 },
	{ 27, 28273657 },
	{ 27, 29060089 },
	{ 27, 29322233 },
	{ 27, 54422525 },
	{ 28, 57633785 },
	{ 28, 58420217 },
	{ 28, 58682361 },
	{ 28, 65760249 },
	{ 28, 66022393 },
	{ 28, 66808825 },
	{ 28, 67070969 },
	{ 28, 94990077 },
	{ 28, 86601469 },
	{ 27, 61435645 },
	{ 27, 53047037 },
	{ 27, 27881213 },
	{ 27, 19492605 },
	{ 25, 11103997 },
	{ 25, 2715389 },
	{ 19, 224026 },
	{ 24, 1928953 },
	{ 24, 5861113 },
	{ 25, 11594747 },
	{ 26, 13201145 },
	{ 24, 6647545 },
	{ 24, 7433977 },
	{ 24, 6516473 },
	{ 24, 6778617 },
	{ 24, 7761661 },
	{ 25, 12512255 },
	{ 26, 26963705 },
	{ 26, 27225849 },
	{ 26, 31354621 },
	{ 27, 53440249 },
	{ 27, 54226681 },
	{ 27, 54488825 },
	{ 27, 62811901 },
	{ 28, 107966201 },
	{ 28, 108752633 },
	{ 28, 109014777 },
	{ 28, 116092665 },
	{ 28, 116354809 },
	{ 28, 117141241 },
	{ 28, 117403385 },
	{ 28, 134115069 },
	{ 27, 61435901 },
	{ 27, 53047293 },
	{ 27, 27881469 },
	{ 27, 19492861 },
	{ 25, 11104253 },
	{ 25, 2715645 },
	{ 19, 228122 },
	{ 24, 1929209 },
	{ 24, 5861369 },
	{ 25, 11594491 },
	{ 26, 13201401 },
	{ 24, 6647801 },
	{ 24, 7434233 },
	{ 24, 6516729 },
	{ 24, 6778873 },
	{ 24, 7761917 },
	{ 25, 12511999 },
	{ 26, 26963961 },
	{ 26, 27226105 },
	{ 26, 31354877 },
	{ 27, 53440505 },
	{ 27, 54226937 },
	{ 27, 54489081 },
	{ 27, 62812157 },
	{ 28, 107966457 },
	{ 28, 108752889 },
	{ 28, 109015033 },
	{ 28, 116092921 },
	{ 28, 116355065 },
	{ 28, 117141497 },
	{ 28, 117403641 },
	{ 28, 86866685 },
	{ 27, 61700861 },
	{ 27, 53312253 },
	{ 27, 28146429 },
	{ 27, 19757821 },
	{ 25, 11369213 },
	{ 25, 2980605 },
	{ 19, 248730 },
	{ 19, 523246 },
	{ 24, 6126329 },
	{ 25, 12107771 },
	{ 26, 13466361 },
	{ 26, 25787129 },
	{ 24, 7699193 },
	{ 25, 10582777 },
	{ 24, 7568121 },
	{ 24, 7830265 },
	{ 25, 10910461 },
	{ 26, 30374649 },
	{ 26, 31161081 },
	{ 26, 31423225 },
	{ 27, 61569785 },
	{ 27, 61831929 },
	{ 27, 62618361 },
	{ 27, 62880505 },
	{ 28, 124484345 },
	{ 28, 124746489 },
	{ 28, 125532921 },
	{ 28, 125795065 },
	{ 28, 132872953 },
	{ 28, 133135097 },
	{ 28, 133921529 },
	{ 28, 134183673 },
	{ 27, 61701117 },
	{ 27, 53312509 },
	{ 27, 28146685 },
	{ 27, 19758077 },
	{ 25, 11369469 },
	{ 25, 2980861 },
	{ 19, 252826 },
	{ 19, 519150 },
	{ 24, 6126585 },
	{ 25, 12107515 },
	{ 26, 13466617 },
	{ 26, 25787385 },
	{ 24, 7699449 },
	{ 25, 10583033 },
	{ 24, 7568377 },
	{ 24, 7830521 },
	{ 25, 10910717 },
	{ 26, 30374905 },
	{ 26, 31161337 },
	{ 26, 31423481 },
	{ 27, 61570041 },
	{ 27, 61832185 },
	{ 27, 62618617 },
	{ 27, 62880761 },
	{ 28, 124484601 },
	{ 28, 124746745 },
	{ 28, 125533177 },
	{ 28, 125795321 },
	{ 28, 132873209 },
	{ 28, 133135353 },
	{ 28, 133921785 },
	{ 28, 134183929 },
	{ 27, 62488317 },
	{ 27, 54099709 },
	{ 27, 28933885 },
	{ 27, 20545277 },
	{ 25, 12156669 },
	{ 25, 3768061 },
	{ 20, 513306 },
	{ 20, 1029486 },
	{ 25, 11108089 },
	{ 26, 10321657 },
	{ 26, 14253817 },
	{ 26, 26050297 },
	{ 26, 29982457 },
	{ 25, 10845945 },
	{ 25, 11632377 },
	{ 25, 10714873 },
	{ 25, 10977017 },
	{ 25, 11960061 },
	{ 26, 22985727 },
	{ 27, 43745017 },
	{ 27, 44007161 },
	{ 27, 48135933 },
	{ 28, 86998777 },
	{ 28, 87785209 },
	{ 28, 88047353 },
	{ 28, 96370429 },
	{ 29, 175079161 },
	{ 29, 175865593 },
	{ 28, 129597437 },
	{ 28, 121208829 },
	{ 28, 96043005 },
	{ 28, 87654397 },
	{ 27, 62488573 },
	{ 27, 54099965 },
	{ 27, 28934141 },
	{ 27, 20545533 },
	{ 25, 12156925 },
	{ 25, 3768317 },
	{ 20, 521498 },
	{ 20, 1021294 },
	{ 25, 11108345 },
	{ 26, 10321913 },
	{ 26, 14254073 },
	{ 26, 26050553 },
	{ 26, 29982713 },
	{ 25, 10846201 },
	{ 25, 11632633 },
	{ 25, 10715129 },
	{ 25, 10977273 },
	{ 25, 11960317 },
	{ 26, 22985471 },
	{ 27, 43745273 },
	{ 27, 44007417 },
	{ 27, 48136189 },
	{ 28, 86999033 },
	{ 28, 87785465 },
	{ 28, 88047609 },
	{ 28, 96370685 },
	{ 29, 175079417 },
	{ 29, 175865849 },
	{ 29, 266895353 },
	{ 29, 250380281 },
	{ 29, 200835065 },
	{ 29, 184319993 },
	{ 28, 125479677 },
	{ 28, 108702461 },
	{ 28, 58370813 },
	{ 28, 41593597 },
	{ 26, 24816381 },
	{ 26, 8039165 },
	{ 20, 955802 },
	{ 20, 980462 },
	{ 26, 22719225 },
	{ 26, 22589435 },
	{ 27, 29010681 },
	{ 27, 53652217 },
	{ 27, 60467961 },
	{ 27, 60338171 },
	{ 26, 23767801 },
	{ 26, 29534969 },
	{ 26, 23505657 },
	{ 26, 24029945 },
	{ 26, 30190333 },
	{ 26, 24555519 },
	{ 28, 95857401 },
	{ 28, 96381689 },
	{ 28, 121416445 },
	{ 28, 125218815 },
	{ 29, 192326393 },
	{ 29, 192850681 },
	{ 29, 243051261 },
	{ 29, 259436543 },
	{ 29, 259697661 },
	{ 29, 242920445 },
	{ 29, 192588797 },
	{ 29, 175811581 },
	{ 28, 125479933 },
	{ 28, 108702717 },
	{ 28, 58371069 },
	{ 28, 41593853 },
	{ 26, 24816637 },
	{ 26, 8039421 },
	{ 20, 963994 },
	{ 20, 972270 },
	{ 26, 22719481 },
	{ 26, 22589179 },
	{ 27, 29010937 },
	{ 27, 53652473 },
	{ 27, 60468217 },
	{ 27, 60337915 },
	{ 26, 23768057 },
	{ 26, 29535225 },
	{ 26, 23505913 },
	{ 26, 24030201 },
	{ 26, 30190589 },
	{ 26, 24555263 },
	{ 28, 95857657 },
	{ 28, 96381945 },
	{ 28, 121416701 },
	{ 28, 125218559 },
	{ 29, 192326649 },
	{ 29, 192850937 },
	{ 29, 243051517 },
	{ 29, 259436287 },
	{ 30, 519613433 },
	{ 30, 500214777 },
	{ 30, 400075769 },
	{ 30, 368094201 },
	{ 29, 267955193 },
	{ 29, 215133949 },
	{ 29, 114470653 },
	{ 29, 80916221 },
	{ 27, 47361789 },
	{ 27, 13807357 },
	{ 20, 972570 },
	{ 20, 964462 },
	{ 26, 24293113 },
	{ 26, 24161275 },
	{ 28, 55750393 },
	{ 27, 54177529 },
	{ 27, 62041849 },
	{ 27, 61910011 },
	{ 28, 93499129 },
	{ 26, 30060281 },
	{ 26, 31633145 },
	{ 26, 29798137 },
	{ 26, 30322425 },
	{ 26, 32288509 },
	{ 26, 25078783 },
	{ 28, 121024249 },
	{ 28, 121548537 },
	{ 28, 129806077 },
	{ 28, 125742079 },
	{ 29, 242659065 },
	{ 29, 243183353 },
	{ 29, 259829501 },
	{ 29, 259959807 },
	{ 30, 486059769 },
	{ 30, 399552249 },
	{ 30, 366522105 },
	{ 29, 267431673 },
	{ 29, 234401529 },
	{ 29, 114470909 },
	{ 29, 80916477 },
	{ 27, 47362045 },
	{ 27, 13807613 },
	{ 20, 980762 },
	{ 20, 956270 },
	{ 26, 24293369 },
	{ 26, 24161019 },
	{ 28, 55750649 },
	{ 27, 54177785 },
	{ 27, 62042105 },
	{ 27, 61909755 },
	{ 28, 93499385 },
	{ 26, 30060537 },
	{ 26, 31633401 },
	{ 26, 29798393 },
	{ 26, 30322681 },
	{ 26, 32288765 },
	{ 26, 25078527 },
	{ 28, 121024505 },
	{ 28, 121548793 },
	{ 28, 129806333 },
	{ 28, 125741823 },
	{ 29, 242659321 },
	{ 29, 243183609 },
	{ 29, 259829757 },
	{ 29, 259959551 },
	{ 29, 258768895 },
	{ 29, 241991679 },
	{ 29, 191660031 },
	{ 29, 267431929 },
	{ 28, 124551167 },
	{ 28, 107773951 },
	{ 28, 57442303 },
	{ 27, 47889149 },
	{ 26, 23887871 },
	{ 20, 1021850 },
	{ 20, 522222 },
	{ 26, 24820473 },
	{ 25, 12353531 },
	{ 27, 20479995 },
	{ 27, 28082171 },
	{ 27, 62569209 },
	{ 26, 31227899 },
	{ 27, 43548667 },
	{ 27, 46956539 },
	{ 26, 32160505 },
	{ 25, 16023547 },
	{ 26, 31898361 },
	{ 25, 4095995 },
	{ 25, 12484603 },
	{ 26, 23822335 },
	{ 27, 29261819 },
	{ 27, 54427643 },
	{ 27, 62816251 },
	{ 28, 87982075 },
	{ 28, 96370683 },
	{ 28, 121536507 },
	{ 28, 129925115 },
	{ 29, 222199803 },
	{ 29, 230588411 },
	{ 29, 255754235 },
	{ 29, 265861881 },
	{ 28, 133005307 },
	{ 28, 117014523 },
	{ 28, 66945019 },
	{ 27, 47889405 },
	{ 26, 23887615 },
	{ 20, 1030042 },
	{ 20, 514030 },
	{ 26, 24820729 },
	{ 25, 12353275 },
	{ 27, 20479739 },
	{ 27, 28081915 },
	{ 27, 62569465 },
	{ 26, 31227643 },
	{ 27, 43548411 },
	{ 27, 46956283 },
	{ 26, 32160761 },
	{ 25, 16023291 },
	{ 26, 31898617 },
	{ 25, 4095739 },
	{ 25, 12484347 },
	{ 26, 23822079 },
	{ 27, 29261563 },
	{ 27, 54427387 },
	{ 27, 62815995 },
	{ 28, 87981819 },
	{ 28, 96370427 },
	{ 28, 121536251 },
	{ 28, 129924859 },
	{ 29, 222199547 },
	{ 29, 230588155 },
	{ 29, 255753979 },
	{ 29, 265862137 },
	{ 28, 133005051 },
	{ 28, 117014267 },
	{ 28, 66944763 },
	{ 27, 49463037 },
	{ 26, 24673279 },
	{ 21, 2075930 },
	{ 21, 1011054 },
	{ 26, 7109627 },
	{ 26, 23624699 },
	{ 27, 20741115 },
	{ 27, 28867579 },
	{ 27, 53246971 },
	{ 27, 61373435 },
	{ 27, 43809787 },
	{ 27, 47741947 },
	{ 27, 59538427 },
	{ 27, 55230201 },
	{ 26, 27556859 },
	{ 26, 28343291 },
	{ 26, 6978555 },
	{ 26, 23755771 },
	{ 26, 24083455 },
	{ 28, 57310203 },
	{ 28, 107641851 },
	{ 28, 124419067 },
	{ 28, 124746751 },
	{ 29, 191527931 },
	{ 29, 241859579 },
	{ 29, 258636795 },
	{ 29, 242056187 },
	{ 29, 192510971 },
	{ 29, 265338617 },
	{ 28, 132742139 },
	{ 28, 116227067 },
	{ 28, 66681851 },
	{ 27, 49463293 },
	{ 26, 24673023 },
	{ 21, 2092314 },
	{ 21, 994670 },
	{ 26, 7109371 },
	{ 26, 23624443 },
	{ 27, 20740859 },
	{ 27, 28867323 },
	{ 27, 53246715 },
	{ 27, 61373179 },
	{ 27, 43809531 },
	{ 27, 47741691 },
	{ 27, 59538171 },
	{ 27, 55230457 },
	{ 26, 27556603 },
	{ 26, 28343035 },
	{ 26, 6978299 },
	{ 26, 23755515 },
	{ 26, 24083199 },
	{ 28, 57309947 },
	{ 28, 107641595 },
	{ 28, 124418811 },
	{ 28, 124746495 },
	{ 29, 191527675 },
	{ 29, 241859323 },
	{ 29, 258636539 },
	{ 29, 242055931 },
	{ 29, 192510715 },
	{ 29, 265338873 },
	{ 28, 132741883 },
	{ 28, 116226811 },
	{ 28, 66681595 },
	{ 27, 49998589 },
	{ 26, 24932351 },
	{ 26, 8155135 },
	{ 21, 912878 },
	{ 26, 7892987 },
	{ 26, 23883771 },
	{ 28, 58387193 },
	{ 27, 29126651 },
	{ 27, 54030331 },
	{ 27, 61632507 },
	{ 28, 96135929 },
	{ 27, 48001019 },
	{ 27, 60321787 },
	{ 27, 66906873 },
	{ 26, 66547707 },
	{ 26, 28602363 },
	{ 26, 31485947 },
	{ 26, 7237627 },
	{ 26, 24014843 },
	{ 26, 24866815 },
	{ 28, 57569275 },
	{ 28, 107900923 },
	{ 28, 124678139 },
	{ 28, 125530111 },
	{ 29, 259582713 },
	{ 28, 129855483 },
	{ 29, 258895867 },
	{ 29, 191721467 },
	{ 29, 251194105 },
	{ 28, 125661179 },
	{ 28, 115961851 },
	{ 28, 65892347 },
	{ 27, 66644729 },
	{ 26, 33386491 },
	{ 26, 8154879 },
	{ 21, 896494 },
	{ 26, 7892731 },
	{ 26, 23883515 },
	{ 28, 58387449 },
	{ 27, 29126395 },
	{ 27, 54030075 },
	{ 27, 61632251 },
	{ 28, 96136185 },
	{ 27, 48000763 },
	{ 27, 60321531 },
	{ 27, 66907129 },
	{ 26, 66547451 },
	{ 26, 28602107 },
	{ 26, 31485691 },
	{ 26, 7237371 },
	{ 26, 24014587 },
	{ 26, 24866559 },
	{ 28, 57569019 },
	{ 28, 107900667 },
	{ 28, 124677883 },
	{ 28, 125529855 },
	{ 29, 259582969 },
	{ 28, 129855227 },
	{ 29, 258895611 },
	{ 29, 191721211 },
	{ 29, 251194361 },
	{ 28, 125660923 },
	{ 28, 115961595 },
	{ 28, 65892091 },
	{ 27, 66644985 },
	{ 26, 33386235 },
	{ 26, 15231999 },
	{ 21, 880494 },
	{ 26, 8154107 },
	{ 26, 24669179 },
	{ 28, 40659963 },
	{ 28, 108719865 },
	{ 27, 54291451 },
	{ 27, 62417915 },
	{ 28, 86797307 },
	{ 28, 121302777 },
	{ 27, 60582907 },
	{ 27, 67038973 },
	{ 26, 66481151 },
	{ 26, 65498107 },
	{ 26, 31747067 },
	{ 26, 32533499 },
	{ 26, 8023035 },
	{ 26, 24800251 },
	{ 26, 25127935 },
	{ 28, 58354683 },
	{ 28, 108686331 },
	{ 28, 125463547 },
	{ 28, 125791231 },
	{ 28, 129592315 },
	{ 28, 121465851 },
	{ 29, 259681275 },
	{ 29, 250670841 },
	{ 28, 125398011 },
	{ 28, 108882939 },
	{ 28, 65629179 },
	{ 27, 66121465 },
	{ 26, 33123323 },
	{ 26, 16608251 },
	{ 21, 864110 },
	{ 26, 8153851 },
	{ 26, 24668923 },
	{ 28, 40659707 },
	{ 28, 108720121 },
	{ 27, 54291195 },
	{ 27, 62417659 },
	{ 28, 86797051 },
	{ 28, 121303033 },
	{ 27, 60582651 },
	{ 27, 67039229 },
	{ 26, 66480895 },
	{ 26, 65497851 },
	{ 26, 31746811 },
	{ 26, 32533243 },
	{ 26, 8022779 },
	{ 26, 24799995 },
	{ 26, 25127679 },
	{ 28, 58354427 },
	{ 28, 108686075 },
	{ 28, 125463291 },
	{ 28, 125790975 },
	{ 28, 129592059 },
	{ 28, 121465595 },
	{ 29, 259681019 },
	{ 29, 250671097 },
	{ 28, 125397755 },
	{ 28, 108882683 },
	{ 28, 65628923 },
	{ 27, 66121721 },
	{ 26, 33123067 },
	{ 26, 16607995 },
	{ 20, 520174 },
	{ 26, 15220731 },
	{ 26, 24920059 },
	{ 28, 41435131 },
	{ 28, 57425915 },
	{ 28, 125500153 },
	{ 27, 62668795 },
	{ 28, 87572475 },
	{ 28, 95174651 },
	{ 28, 129694457 },
	{ 27, 64765947 },
	{ 27, 66517757 },
	{ 26, 65421311 },
	{ 26, 62341115 },
	{ 26, 32784379 },
	{ 26, 60833787 },
	{ 26, 8273915 },
	{ 26, 25051131 },
	{ 26, 32194559 },
	{ 28, 58605563 },
	{ 28, 108937211 },
	{ 28, 125714427 },
	{ 28, 128794619 },
	{ 28, 121192443 },
	{ 28, 96288763 },
	{ 29, 249101049 },
	{ 28, 124600315 },
	{ 28, 108609531 },
	{ 28, 58540027 },
	{ 27, 64551673 },
	{ 26, 32325627 },
	{ 26, 16334843 },
	{ 20, 503790 },
	{ 26, 15220475 },
	{ 26, 24919803 },
	{ 28, 41434875 },
	{ 28, 57425659 },
	{ 28, 125500409 },
	{ 27, 62668539 },
	{ 28, 87572219 },
	{ 28, 95174395 },
	{ 28, 129694713 },
	{ 27, 64765691 },
	{ 27, 66518013 },
	{ 26, 65421055 },
	{ 26, 62340859 },
	{ 26, 32784123 },
	{ 26, 60833531 },
	{ 26, 8273659 },
	{ 26, 25050875 },
	{ 26, 32194303 },
	{ 28, 58605307 },
	{ 28, 108936955 },
	{ 28, 125714171 },
	{ 28, 128794363 },
	{ 28, 121192187 },
	{ 28, 96288507 },
	{ 29, 249101305 },
	{ 28, 124600059 },
	{ 28, 108609275 },
	{ 28, 58539771 },
	{ 27, 64551929 },
	{ 26, 32325371 },
	{ 26, 16334587 },
	{ 20, 490862 },
	{ 26, 15481851 },
	{ 26, 31996923 },
	{ 28, 41696251 },
	{ 28, 58211323 },
	{ 28, 107756539 },
	{ 28, 124271611 },
	{ 28, 87833595 },
	{ 28, 95960059 },
	{ 28, 120339451 },
	{ 28, 128465915 },
	{ 28, 110902267 },
	{ 27, 64945917 },
	{ 26, 62274559 },
	{ 26, 61291515 },
	{ 26, 61094907 },
	{ 26, 61881339 },
	{ 26, 15350779 },
	{ 26, 32127995 },
	{ 26, 32455679 },
	{ 28, 65682427 },
	{ 28, 116014075 },
	{ 28, 132791291 },
	{ 28, 120404987 },
	{ 28, 96025595 },
	{ 28, 87899131 },
	{ 28, 124337147 },
	{ 28, 107822075 },
	{ 28, 58276859 },
	{ 27, 64028409 },
	{ 26, 32062459 },
	{ 26, 15547387 },
	{ 20, 474478 },
	{ 26, 15481595 },
	{ 26, 31996667 },
	{ 28, 41695995 },
	{ 28, 58211067 },
	{ 28, 107756283 },
	{ 28, 124271355 },
	{ 28, 87833339 },
	{ 28, 95959803 },
	{ 28, 120339195 },
	{ 28, 128465659 },
	{ 28, 110902011 },
	{ 27, 64946173 },
	{ 26, 62274303 },
	{ 26, 61291259 },
	{ 26, 61094651 },
	{ 26, 61881083 },
	{ 26, 15350523 },
	{ 26, 32127739 },
	{ 26, 32455423 },
	{ 28, 65682171 },
	{ 28, 116013819 },
	{ 28, 132791035 },
	{ 28, 120404731 },
	{ 28, 96025339 },
	{ 28, 87898875 },
	{ 28, 124336891 },
	{ 28, 107821819 },
	{ 28, 58276603 },
	{ 27, 64028665 },
	{ 26, 32062203 },
	{ 26, 15547131 },
	{ 20, 392686 },
	{ 26, 16265211 },
	{ 26, 32255995 },
	{ 28, 48771067 },
	{ 28, 58470395 },
	{ 28, 108539899 },
	{ 28, 124530683 },
	{ 29, 174600187 },
	{ 28, 96219131 },
	{ 28, 121122811 },
	{ 28, 128724987 },
	{ 28, 132067323 },
	{ 28, 115093499 },
	{ 28, 128822013 },
	{ 26, 61222911 },
	{ 26, 32976891 },
	{ 26, 62140411 },
	{ 26, 65023995 },
	{ 26, 15609851 },
	{ 26, 32387067 },
	{ 26, 33239039 },
	{ 28, 65941499 },
	{ 27, 64827387 },
	{ 28, 133050363 },
	{ 28, 95236091 },
	{ 28, 87633915 },
	{ 27, 62730235 },
	{ 28, 107556859 },
	{ 28, 57487355 },
	{ 28, 99724025 },
	{ 26, 24981499 },
	{ 26, 15282171 },
	{ 20, 376302 },
	{ 26, 16264955 },
	{ 26, 32255739 },
	{ 28, 48770811 },
	{ 28, 58470139 },
	{ 28, 108539643 },
	{ 28, 124530427 },
	{ 29, 174599931 },
	{ 28, 96218875 },
	{ 28, 121122555 },
	{ 28, 128724731 },
	{ 28, 132067067 },
	{ 28, 115093243 },
	{ 28, 128822269 },
	{ 26, 61222655 },
	{ 26, 32976635 },
	{ 26, 62140155 },
	{ 26, 65023739 },
	{ 26, 15609595 },
	{ 26, 32386811 },
	{ 26, 33238783 },
	{ 28, 65941243 },
	{ 27, 64827131 },
	{ 28, 133050107 },
	{ 28, 95235835 },
	{ 28, 87633659 },
	{ 27, 62729979 },
	{ 28, 107556603 },
	{ 28, 57487099 },
	{ 28, 99724281 },
	{ 26, 24981243 },
	{ 26, 15281915 },
	{ 20, 360302 },
	{ 26, 16526331 },
	{ 26, 33041403 },
	{ 28, 49032187 },
	{ 28, 65547259 },
	{ 28, 108801019 },
	{ 28, 125316091 },
	{ 29, 174861307 },
	{ 29, 191376379 },
	{ 28, 121383931 },
	{ 28, 129510395 },
	{ 28, 132000767 },
	{ 28, 127871995 },
	{ 28, 127675387 },
	{ 28, 100511485 },
	{ 26, 32910335 },
	{ 26, 31927291 },
	{ 26, 65285115 },
	{ 26, 66071547 },
	{ 26, 16395259 },
	{ 26, 33172475 },
	{ 26, 33500159 },
	{ 27, 64564219 },
	{ 27, 60632059 },
	{ 28, 133835771 },
	{ 28, 86846459 },
	{ 27, 62467067 },
	{ 27, 54340603 },
	{ 28, 57224187 },
	{ 28, 98676473 },
	{ 26, 24718331 },
	{ 26, 8203259 },
	{ 20, 343918 },
	{ 26, 16526075 },
	{ 26, 33041147 },
	{ 28, 49031931 },
	{ 28, 65547003 },
	{ 28, 108800763 },
	{ 28, 125315835 },
	{ 29, 174861051 },
	{ 29, 191376123 },
	{ 28, 121383675 },
	{ 28, 129510139 },
	{ 28, 132000511 },
	{ 28, 127871739 },
	{ 28, 127675131 },
	{ 28, 100511741 },
	{ 26, 32910079 },
	{ 26, 31927035 },
	{ 26, 65284859 },
	{ 26, 66071291 },
	{ 26, 16395003 },
	{ 26, 33172219 },
	{ 26, 33499903 },
	{ 27, 64563963 },
	{ 27, 60631803 },
	{ 28, 133835515 },
	{ 28, 86846203 },
	{ 27, 62466811 },
	{ 27, 54340347 },
	{ 28, 57223931 },
	{ 28, 98676729 },
	{ 26, 24718075 },
	{ 26, 8203003 },
	{ 19, 262126 },
	{ 26, 15280895 },
	{ 24, 8331259 },
	{ 26, 12460027 },
	{ 26, 16457723 },
	{ 26, 28975099 },
	{ 26, 31399931 },
	{ 27, 43917307 },
	{ 27, 47915003 },
	{ 27, 60432379 },
	{ 26, 32448507 },
	{ 27, 55451643 },
	{ 26, 31956991 },
	{ 26, 28827643 },
	{ 26, 32972795 },
	{ 26, 61218811 },
	{ 24, 7970815 },
	{ 24, 7200763 },
	{ 24, 16588795 },
	{ 24, 7888891 },
	{ 24, 4169723 },
	{ 24, 8364027 },
	{ 25, 15949819 },
	{ 25, 15097851 },
	{ 25, 12017659 },
	{ 26, 33529851 },
	{ 25, 15425531 },
	{ 25, 13524987 },
	{ 25, 7299067 },
	{ 26, 10117115 },
	{ 24, 5988347 },
	{ 24, 1990651 },
	{ 19, 245742 },
	{ 24, 2056191 },
	{ 24, 8331003 },
	{ 26, 12459771 },
	{ 26, 16457467 },
	{ 26, 28974843 },
	{ 26, 31399675 },
	{ 27, 43917051 },
	{ 27, 47914747 },
	{ 27, 60432123 },
	{ 26, 32448251 },
	{ 27, 55451387 },
	{ 26, 31956735 },
	{ 26, 28827387 },
	{ 26, 32972539 },
	{ 26, 61218555 },
	{ 24, 7970559 },
	{ 24, 7200507 },
	{ 24, 16588539 },
	{ 24, 7888635 },
	{ 24, 4169467 },
	{ 24, 8363771 },
	{ 25, 15949563 },
	{ 25, 15097595 },
	{ 25, 12017403 },
	{ 26, 33529595 },
	{ 25, 15425275 },
	{ 25, 13524731 },
	{ 25, 7298811 },
	{ 26, 10116859 },
	{ 24, 5988091 },
	{ 24, 1990395 },
	{ 19, 241054 },
	{ 24, 2055935 },
	{ 24, 6250239 },
	{ 26, 12524539 },
	{ 26, 16653307 },
	{ 26, 29039611 },
	{ 26, 33168379 },
	{ 27, 43981819 },
	{ 27, 48110587 },
	{ 27, 60496891 },
	{ 27, 64625659 },
	{ 27, 55516155 },
	{ 27, 57547771 },
	{ 26, 28810239 },
	{ 26, 27778043 },
	{ 26, 61283323 },
	{ 26, 62266363 },
	{ 24, 7183359 },
	{ 24, 6937595 },
	{ 24, 6872059 },
	{ 24, 7101435 },
	{ 24, 6904827 },
	{ 25, 15883259 },
	{ 25, 14900219 },
	{ 25, 11951099 },
	{ 25, 10968059 },
	{ 25, 15358971 },
	{ 25, 13327355 },
	{ 25, 7232507 },
	{ 25, 5200891 },
	{ 24, 5921787 },
	{ 24, 1793019 },
	{ 19, 224542 },
	{ 24, 1989631 },
	{ 24, 6183935 },
	{ 26, 12524283 },
	{ 26, 16653051 },
	{ 26, 29039355 },
	{ 26, 33168123 },
	{ 27, 43981563 },
	{ 27, 48110331 },
	{ 27, 60496635 },
	{ 27, 64625403 },
	{ 27, 55515899 },
	{ 27, 57547515 },
	{ 26, 28809983 },
	{ 26, 27777787 },
	{ 26, 61283067 },
	{ 26, 62266107 },
	{ 24, 7183103 },
	{ 24, 6937339 },
	{ 24, 6871803 },
	{ 24, 7101179 },
	{ 24, 6904571 },
	{ 25, 15883003 },
	{ 25, 14899963 },
	{ 25, 11950843 },
	{ 25, 10967803 },
	{ 25, 15358715 },
	{ 25, 13327099 },
	{ 25, 7232251 },
	{ 25, 5200635 },
	{ 24, 5921531 },
	{ 24, 1792763 },
	{ 19, 208158 },
	{ 24, 1989375 },
	{ 24, 6183679 },
	{ 26, 10377983 },
	{ 26, 16715771 },
	{ 26, 29233147 },
	{ 26, 33230843 },
	{ 27, 45748219 },
	{ 27, 48173051 },
	{ 27, 60690427 },
	{ 27, 64688123 },
	{ 26, 32493563 },
	{ 26, 32428027 },
	{ 26, 32231419 },
	{ 26, 32165883 },
	{ 25, 16240635 },
	{ 25, 16175099 },
	{ 25, 15978491 },
	{ 24, 6918143 },
	{ 23, 4050939 },
	{ 23, 3985403 },
	{ 24, 6836219 },
	{ 23, 4018171 },
	{ 25, 14831611 },
	{ 25, 11751419 },
	{ 25, 10899451 },
	{ 24, 7819259 },
	{ 25, 13258747 },
	{ 25, 7032827 },
	{ 25, 5132283 },
	{ 23, 3100667 },
	{ 24, 1724411 },
	{ 18, 63390 },
	{ 24, 1789951 },
	{ 24, 5984255 },
	{ 26, 10178559 },
	{ 26, 16715515 },
	{ 26, 29232891 },
	{ 26, 33230587 },
	{ 27, 45747963 },
	{ 27, 48172795 },
	{ 27, 60690171 },
	{ 27, 64687867 },
	{ 26, 32493307 },
	{ 26, 32427771 },
	{ 26, 32231163 },
	{ 26, 32165627 },
	{ 25, 16240379 },
	{ 25, 16174843 },
	{ 25, 15978235 },
	{ 24, 6917887 },
	{ 23, 4050683 },
	{ 23, 3985147 },
	{ 24, 6835963 },
	{ 23, 4017915 },
	{ 25, 14831355 },
	{ 25, 11751163 },
	{ 25, 10899195 },
	{ 24, 7819003 },
	{ 25, 13258491 },
	{ 25, 7032571 },
	{ 25, 5132027 },
	{ 23, 3100411 },
	{ 24, 1724155 },
	{ 18, 55198 },
	{ 24, 1789695 },
	{ 24, 5983999 },
	{ 26, 10178303 },
	{ 26, 14372607 },
	{ 26, 29297659 },
	{ 26, 33426427 },
	{ 27, 45812731 },
	{ 27, 49941499 },
	{ 27, 60754939 },
	{ 27, 64883707 },
	{ 26, 32476159 },
	{ 26, 30395387 },
	{ 26, 30329851 },
	{ 26, 30133243 },
	{ 25, 16223231 },
	{ 25, 15191035 },
	{ 25, 15125499 },
	{ 25, 14928891 },
	{ 23, 4033535 },
	{ 23, 3787771 },
	{ 23, 3722235 },
	{ 23, 3951611 },
	{ 23, 3755003 },
	{ 25, 11684859 },
	{ 25, 10701819 },
	{ 24, 7752699 },
	{ 24, 6769659 },
	{ 25, 6966267 },
	{ 25, 4934651 },
	{ 23, 3034107 },
	{ 23, 1002491 },
	{ 18, 46878 },
	{ 24, 1723391 },
	{ 24, 5917695 },
	{ 26, 10111999 },
	{ 26, 14306303 },
	{ 26, 29297403 },
	{ 26, 33426171 },
	{ 27, 45812475 },
	{ 27, 49941243 },
	{ 27, 60754683 },
	{ 27, 64883451 },
	{ 26, 32475903 },
	{ 26, 30395131 },
	{ 26, 30329595 },
	{ 26, 30132987 },
	{ 25, 16222975 },
	{ 25, 15190779 },
	{ 25, 15125243 },
	{ 25, 14928635 },
	{ 23, 4033279 },
	{ 23, 3787515 },
	{ 23, 3721979 },
	{ 23, 3951355 },
	{ 23, 3754747 },
	{ 25, 11684603 },
	{ 25, 10701563 },
	{ 24, 7752443 },
	{ 24, 6769403 },
	{ 25, 6966011 },
	{ 25, 4934395 },
	{ 23, 3033851 },
	{ 23, 1002235 },
	{ 18, 38686 },
	{ 24, 1723135 },
	{ 24, 5917439 },
	{ 26, 10111743 },
	{ 25, 15722495 },
	{ 25, 12580859 },
	{ 24, 8374267 },
	{ 25, 11503611 },
	{ 25, 12503035 },
	{ 25, 15632379 },
	{ 25, 16238587 },
	{ 25, 11991035 },
	{ 24, 7596031 },
	{ 24, 6027259 },
	{ 24, 6010875 },
	{ 24, 5961723 },
	{ 23, 3794943 },
	{ 23, 3012603 },
	{ 23, 2996219 },
	{ 23, 2947067 },
	{ 21, 944127 },
	{ 21, 751611 },
	{ 21, 735227 },
	{ 21, 923643 },
	{ 21, 743419 },
	{ 23, 2660347 },
	{ 22, 1890299 },
	{ 22, 1677307 },
	{ 22, 907259 },
	{ 23, 1218555 },
	{ 21, 710651 },
	{ 21, 235515 },
	{ 16, 30110 },
	{ 21, 251903 },
	{ 21, 776191 },
	{ 23, 1300479 },
	{ 23, 1824767 },
	{ 23, 3397631 },
	{ 23, 3921919 },
	{ 24, 5494783 },
	{ 24, 6019071 },
	{ 24, 7591935 },
	{ 24, 8116223 },
	{ 25, 11990779 },
	{ 24, 7595775 },
	{ 24, 6027003 },
	{ 24, 6010619 },
	{ 24, 5961467 },
	{ 23, 3794687 },
	{ 23, 3012347 },
	{ 23, 2995963 },
	{ 23, 2946811 },
	{ 21, 943871 },
	{ 21, 751355 },
	{ 21, 734971 },
	{ 21, 923387 },
	{ 21, 743163 },
	{ 23, 2660091 },
	{ 22, 1890043 },
	{ 22, 1677051 },
	{ 22, 907003 },
	{ 23, 1218299 },
	{ 21, 710395 },
	{ 21, 235259 },
	{ 16, 21918 },
	{ 21, 251647 },
	{ 21, 775935 },
	{ 23, 1300223 },
	{ 23, 1824511 },
	{ 23, 3397375 },
	{ 23, 3921663 },
	{ 24, 5494527 },
	{ 24, 6018815 },
	{ 24, 7591679 },
	{ 24, 8115967 },
	{ 25, 10990587 },
	{ 25, 10941435 },
	{ 24, 6022143 },
	{ 24, 5501947 },
	{ 24, 5485563 },
	{ 24, 5436411 },
	{ 23, 3007487 },
	{ 23, 2749435 },
	{ 23, 2733051 },
	{ 23, 2683899 },
	{ 21, 746495 },
	{ 21, 685051 },
	{ 21, 668667 },
	{ 21, 726011 },
	{ 21, 676859 },
	{ 22, 1872891 },
	{ 22, 1627131 },
	{ 22, 889851 },
	{ 22, 644091 },
	{ 21, 693243 },
	{ 21, 185339 },
	{ 16, 13598 },
	{ 21, 234495 },
	{ 21, 758783 },
	{ 23, 1283071 },
	{ 23, 1807359 },
	{ 23, 3380223 },
	{ 23, 3904511 },
	{ 24, 5477375 },
	{ 24, 6001663 },
	{ 24, 7574527 },
	{ 24, 8098815 },
	{ 25, 10990331 },
	{ 25, 10941179 },
	{ 24, 6021887 },
	{ 24, 5501691 },
	{ 24, 5485307 },
	{ 24, 5436155 },
	{ 23, 3007231 },
	{ 23, 2749179 },
	{ 23, 2732795 },
	{ 23, 2683643 },
	{ 21, 746239 },
	{ 21, 684795 },
	{ 21, 668411 },
	{ 21, 725755 },
	{ 21, 676603 },
	{ 22, 1872635 },
	{ 22, 1626875 },
	{ 22, 889595 },
	{ 22, 643835 },
	{ 21, 692987 },
	{ 21, 185083 },
	{ 16, 5406 },
	{ 21, 234239 },
	{ 21, 758527 },
	{ 23, 1282815 },
	{ 23, 1807103 },
	{ 23, 3379967 },
	{ 23, 3904255 },
	{ 22, 2096635 },
	{ 22, 2092539 },
	{ 22, 2080251 },
	{ 22, 2076155 },
	{ 22, 1965563 },
	{ 22, 1961467 },
	{ 22, 1949179 },
	{ 22, 1945083 },
	{ 21, 982523 },
	{ 21, 978427 },
	{ 21, 966139 },
	{ 21, 962043 },
	{ 20, 491003 },
	{ 20, 486907 },
	{ 20, 474619 },
	{ 19, 170495 },
	{ 18, 122363 },
	{ 18, 118267 },
	{ 19, 165371 },
	{ 18, 120315 },
	{ 20, 402939 },
	{ 20, 210427 },
	{ 20, 157179 },
	{ 18, 95739 },
	{ 19, 42491 },
	{ 13, 5022 },
	{ 19, 46591 },
	{ 19, 177663 },
	{ 21, 308735 },
	{ 21, 439807 },
	{ 21, 833023 },
	{ 21, 964095 },
	{ 22, 4159737 },
	{ 22, 4094201 },
	{ 22, 3897593 },
	{ 22, 3832057 },
	{ 22, 2062585 },
	{ 22, 1997049 },
	{ 22, 1800441 },
	{ 22, 1734905 },
	{ 21, 1014009 },
	{ 21, 948473 },
	{ 21, 751865 },
	{ 21, 686329 },
	{ 20, 489721 },
	{ 20, 424185 },
	{ 20, 227577 },
	{ 19, 175357 },
	{ 18, 96505 },
	{ 18, 30969 },
	{ 19, 164089 },
	{ 18, 119033 },
	{ 20, 401657 },
	{ 20, 209145 },
	{ 20, 155897 },
	{ 18, 94457 },
	{ 19, 41209 },
	{ 13, 1002 },
	{ 19, 45309 },
	{ 19, 176381 },
	{ 21, 307453 },
	{ 21, 438525 },
	{ 21, 831741 },
	{ 21, 962813 },
	{ 22, 4159993 },
	{ 22, 4094457 },
	{ 22, 3897849 },
	{ 22, 3832313 },
	{ 22, 2062841 },
	{ 22, 1997305 },
	{ 22, 1800697 },
	{ 22, 1735161 },
	{ 21, 1014265 },
	{ 21, 948729 },
	{ 21, 752121 },
	{ 21, 686585 },
	{ 20, 489977 },
	{ 20, 424441 },
	{ 20, 227833 },
	{ 19, 175613 },
	{ 18, 96761 },
	{ 18, 31225 },
	{ 19, 164345 },
	{ 18, 119289 },
	{ 20, 401913 },
	{ 20, 209401 },
	{ 20, 156153 },
	{ 18, 94713 },
	{ 19, 41465 },
	{ 13, 5098 },
	{ 19, 45565 },
	{ 19, 176637 },
	{ 21, 307709 },
	{ 21, 438781 },
	{ 21, 831997 },
	{ 21, 963069 },
	{ 22, 1356285 },
	{ 22, 1487357 },
	{ 22, 1880573 },
	{ 22, 2011645 },
	{ 23, 3453437 },
	{ 23, 3584509 },
	{ 23, 3977725 },
	{ 23, 4108797 },
	{ 23, 4059901 },
	{ 23, 4039417 },
	{ 23, 3777273 },
	{ 23, 2990841 },
	{ 22, 1962749 },
	{ 22, 1942265 },
	{ 22, 1680121 },
	{ 22, 893689 },
	{ 20, 389885 },
	{ 20, 369401 },
	{ 20, 107257 },
	{ 20, 459513 },
	{ 20, 410361 },
	{ 22, 819961 },
	{ 22, 574201 },
	{ 20, 361209 },
	{ 20, 115449 },
	{ 15, 2922 },
	{ 21, 164605 },
	{ 21, 688893 },
	{ 23, 1213181 },
	{ 23, 1737469 },
	{ 23, 3310333 },
	{ 23, 3834621 },
	{ 24, 5407485 },
	{ 24, 16622585 },
	{ 24, 16360441 },
	{ 24, 15574009 },
	{ 24, 15311865 },
	{ 24, 8233977 },
	{ 24, 7971833 },
	{ 24, 7185401 },
	{ 23, 4060157 },
	{ 23, 4039673 },
	{ 23, 3777529 },
	{ 23, 2991097 },
	{ 22, 1963005 },
	{ 22, 1942521 },
	{ 22, 1680377 },
	{ 22, 893945 },
	{ 20, 390141 },
	{ 20, 369657 },
	{ 20, 107513 },
	{ 20, 459769 },
	{ 20, 410617 },
	{ 22, 820217 },
	{ 22, 574457 },
	{ 20, 361465 },
	{ 20, 115705 },
	{ 15, 7018 },
	{ 21, 164861 },
	{ 21, 689149 },
	{ 23, 1213437 },
	{ 23, 1737725 },
	{ 23, 3310589 },
	{ 23, 3834877 },
	{ 24, 5407741 },
	{ 24, 16627453 },
	{ 24, 16574201 },
	{ 24, 16312057 },
	{ 24, 15525625 },
	{ 24, 15263481 },
	{ 24, 8185593 },
	{ 24, 7923449 },
	{ 24, 7137017 },
	{ 23, 4044541 },
	{ 23, 3991289 },
	{ 23, 3729145 },
	{ 23, 2942713 },
	{ 22, 1947389 },
	{ 22, 1894137 },
	{ 22, 1631993 },
	{ 22, 845561 },
	{ 20, 374525 },
	{ 20, 321273 },
	{ 20, 59129 },
	{ 20, 395001 },
	{ 20, 214777 },
	{ 22, 558841 },
	{ 20, 313081 },
	{ 20, 100089 },
	{ 15, 10730 },
	{ 20, 116477 },
	{ 20, 378621 },
	{ 22, 640765 },
	{ 22, 902909 },
	{ 22, 1689341 },
	{ 22, 1951485 },
	{ 23, 2737917 },
	{ 23, 3000061 },
	{ 23, 3786493 },
	{ 23, 4048637 },
	{ 24, 15525881 },
	{ 24, 15263737 },
	{ 24, 8185849 },
	{ 24, 7923705 },
	{ 24, 7137273 },
	{ 23, 4044797 },
	{ 23, 3991545 },
	{ 23, 3729401 },
	{ 23, 2942969 },
	{ 22, 1947645 },
	{ 22, 1894393 },
	{ 22, 1632249 },
	{ 22, 845817 },
	{ 20, 374781 },
	{ 20, 321529 },
	{ 20, 59385 },
	{ 20, 395257 },
	{ 20, 215033 },
	{ 22, 559097 },
	{ 20, 313337 },
	{ 20, 100345 },
	{ 15, 14826 },
	{ 20, 116733 },
	{ 20, 378877 },
	{ 22, 641021 },
	{ 22, 903165 },
	{ 22, 1689597 },
	{ 22, 1951741 },
	{ 23, 2738173 },
	{ 23, 3000317 },
	{ 23, 3786749 },
	{ 23, 4048893 },
	{ 24, 6932477 },
	{ 24, 7194621 },
	{ 24, 7981053 },
	{ 24, 8243197 },
	{ 24, 15321085 },
	{ 24, 15583229 },
	{ 24, 16369661 },
	{ 24, 16631805 },
	{ 25, 14846713 },
	{ 25, 11700985 },
	{ 24, 7588605 },
	{ 24, 7506681 },
	{ 24, 6458105 },
	{ 24, 3312377 },
	{ 22, 1297149 },
	{ 22, 1215225 },
	{ 22, 166649 },
	{ 22, 789241 },
	{ 22, 592633 },
	{ 22, 1182457 },
	{ 22, 199417 },
	{ 17, 18794 },
	{ 22, 396029 },
	{ 22, 1444605 },
	{ 24, 2493181 },
	{ 24, 3541757 },
	{ 24, 6687485 },
	{ 24, 7736061 },
	{ 25, 10881789 },
	{ 25, 11930365 },
	{ 25, 15076093 },
	{ 25, 16124669 },
	{ 26, 65178617 },
	{ 26, 62032889 },
	{ 26, 60984313 },
	{ 26, 32672761 },
	{ 26, 31624185 },
	{ 26, 28478457 },
	{ 25, 15977469 },
	{ 25, 15895545 },
	{ 25, 14846969 },
	{ 25, 11701241 },
	{ 24, 7588861 },
	{ 24, 7506937 },
	{ 24, 6458361 },
	{ 24, 3312633 },
	{ 22, 1297405 },
	{ 22, 1215481 },
	{ 22, 166905 },
	{ 22, 789497 },
	{ 22, 592889 },
	{ 22, 1182713 },
	{ 22, 199673 },
	{ 17, 22890 },
	{ 22, 396285 },
	{ 22, 1444861 },
	{ 24, 2493437 },
	{ 24, 3542013 },
	{ 24, 6687741 },
	{ 24, 7736317 },
	{ 25, 10882045 },
	{ 25, 11930621 },
	{ 25, 15076349 },
	{ 25, 16124925 },
	{ 24, 16617209 },
	{ 24, 16355065 },
	{ 24, 15568633 },
	{ 24, 15306489 },
	{ 24, 8228601 },
	{ 24, 7966457 },
	{ 24, 7180025 },
	{ 24, 6917881 },
	{ 23, 4034297 },
	{ 23, 3772153 },
	{ 23, 2985721 },
	{ 23, 2723577 },
	{ 22, 1937145 },
	{ 22, 1675001 },
	{ 22, 888569 },
	{ 22, 626425 },
	{ 20, 364281 },
	{ 20, 102137 },
	{ 22, 528121 },
	{ 20, 331513 },
	{ 22, 134905 },
	{ 15, 6890 },
	{ 22, 200445 },
	{ 22, 1249021 },
	{ 24, 2297597 },
	{ 24, 3346173 },
	{ 24, 6491901 },
	{ 24, 7540477 },
	{ 25, 10686205 },
	{ 25, 11734781 },
	{ 25, 14880509 },
	{ 25, 15929085 },
	{ 24, 16617465 },
	{ 24, 16355321 },
	{ 24, 15568889 },
	{ 24, 15306745 },
	{ 24, 8228857 },
	{ 24, 7966713 },
	{ 24, 7180281 },
	{ 24, 6918137 },
	{ 23, 4034553 },
	{ 23, 3772409 },
	{ 23, 2985977 },
	{ 23, 2723833 },
	{ 22, 1937401 },
	{ 22, 1675257 },
	{ 22, 888825 },
	{ 22, 626681 },
	{ 20, 364537 },
	{ 20, 102393 },
	{ 22, 528377 },
	{ 20, 331769 },
	{ 22, 135161 },
	{ 15, 7914 },
	{ 22, 200701 },
	{ 22, 1249277 },
	{ 24, 2297853 },
	{ 24, 3346429 },
	{ 24, 6492157 },
	{ 24, 7540733 },
	{ 25, 10686461 },
	{ 25, 11735037 },
	{ 25, 14880765 },
	{ 25, 15929341 },
	{ 24, 16636669 },
	{ 24, 16554745 },
	{ 24, 16292601 },
	{ 24, 15506169 },
	{ 24, 15244025 },
	{ 24, 8166137 },
	{ 24, 7903993 },
	{ 24, 7117561 },
	{ 23, 4053757 },
	{ 23, 3971833 },
	{ 23, 3709689 },
	{ 23, 2923257 },
	{ 22, 1956605 },
	{ 22, 1874681 },
	{ 22, 1612537 },
	{ 22, 826105 },
	{ 20, 383741 },
	{ 20, 301817 },
	{ 20, 39673 },
	{ 16, 25977 },
	{ 16, 32185 },
	{ 15, 12906 },
	{ 22, 137981 },
	{ 22, 1186557 },
	{ 24, 2235133 },
	{ 24, 3283709 },
	{ 24, 6429437 },
	{ 24, 7478013 },
	{ 25, 10623741 },
	{ 25, 11672317 },
	{ 25, 14818045 },
	{ 25, 15866621 },
	{ 24, 16636925 },
	{ 24, 16555001 },
	{ 24, 16292857 },
	{ 24, 15506425 },
	{ 24, 15244281 },
	{ 24, 8166393 },
	{ 24, 7904249 },
	{ 24, 7117817 },
	{ 23, 4054013 },
	{ 23, 3972089 },
	{ 23, 3709945 },
	{ 23, 2923513 },
	{ 22, 1956861 },
	{ 22, 1874937 },
	{ 22, 1612793 },
	{ 22, 826361 },
	{ 20, 383997 },
	{ 20, 302073 },
	{ 20, 39929 },
	{ 16, 28025 },
	{ 15, 16057 },
	{ 15, 13930 },
	{ 22, 138237 },
	{ 22, 1186813 },
	{ 24, 2235389 },
	{ 24, 3283965 },
	{ 24, 6429693 },
	{ 24, 7478269 },
	{ 25, 10623997 },
	{ 25, 11672573 },
	{ 25, 14818301 },
	{ 25, 15866877 },
	{ 26, 27401213 },
	{ 24, 16572157 },
	{ 24, 16310013 },
	{ 24, 15523581 },
	{ 24, 15261437 },
	{ 24, 8183549 },
	{ 24, 7921405 },
	{ 24, 7134973 },
	{ 24, 6872829 },
	{ 23, 3989245 },
	{ 23, 3727101 },
	{ 23, 2940669 },
	{ 23, 2678525 },
	{ 22, 1892093 },
	{ 22, 1629949 },
	{ 22, 843517 },
	{ 22, 581373 },
	{ 20, 319229 },
	{ 20, 57085 },
	{ 15, 16361 },
	{ 13, 4009 },
	{ 14, 8026 },
	{ 17, 64957 },
	{ 20, 335613 },
	{ 22, 597757 },
	{ 22, 859901 },
	{ 22, 1646333 },
	{ 22, 1908477 },
	{ 23, 2694909 },
	{ 23, 2957053 },
	{ 23, 3743485 },
	{ 23, 4005629 },
	{ 24, 6889213 },
	{ 24, 7151357 },
	{ 24, 7937789 },
	{ 24, 8199933 },
	{ 24, 15277821 },
	{ 24, 15539965 },
	{ 24, 16326397 },
	{ 24, 16588541 },
	{ 24, 6873085 },
	{ 23, 3989501 },
	{ 23, 3727357 },
	{ 23, 2940925 },
	{ 23, 2678781 },
	{ 22, 1892349 },
	{ 22, 1630205 },
	{ 22, 843773 },
	{ 22, 581629 },
	{ 20, 319485 },
	{ 20, 57341 },
	{ 15, 16185 },
	{ 12, 1993 },
	{ 14, 8154 },
	{ 16, 32445 },
	{ 20, 335869 },
	{ 22, 598013 },
	{ 22, 860157 },
	{ 22, 1646589 },
	{ 22, 1908733 },
	{ 23, 2695165 },
	{ 23, 2957309 },
	{ 23, 3743741 },
	{ 23, 4005885 },
	{ 24, 6889469 },
	{ 24, 7151613 },
	{ 24, 7938045 },
	{ 24, 8200189 },
	{ 24, 15278077 },
	{ 24, 15540221 },
	{ 24, 16326653 },
	{ 24, 16588797 },
	{ 26, 31533821 },
	{ 26, 28388093 },
	{ 26, 27339517 },
	{ 25, 15805181 },
	{ 25, 14756605 },
	{ 25, 11610877 },
	{ 25, 10562301 },
	{ 24, 7416573 },
	{ 24, 6367997 },
	{ 24, 3222269 },
	{ 24, 2173693 },
	{ 17, 42877 },
	{ 13, 4061 },
	{ 24, 110591 },
	{ 14, 8109 },
	{ 17, 42365 },
	{ 24, 2108157 },
	{ 24, 3156733 },
	{ 24, 6302461 },
	{ 24, 7351037 },
	{ 25, 10496765 },
	{ 25, 11545341 },
	{ 25, 14691069 },
	{ 25, 15739645 },
	{ 26, 27273981 },
	{ 26, 28322557 },
	{ 26, 31468285 },
	{ 26, 32516861 },
	{ 26, 60828413 },
	{ 26, 61876989 },
	{ 26, 65022717 },
	{ 26, 66071293 },
	{ 26, 31534077 },
	{ 26, 28388349 },
	{ 26, 27339773 },
	{ 25, 15805437 },
	{ 25, 14756861 },
	{ 25, 11611133 },
	{ 25, 10562557 },
	{ 24, 7416829 },
	{ 24, 6368253 },
	{ 24, 3222525 },
	{ 24, 2173949 },
	{ 17, 44925 },
	{ 16, 32621 },
	{ 12, 1930 },
	{ 13, 4045 },
	{ 17, 44413 },
	{ 24, 2108413 },
	{ 24, 3156989 },
	{ 24, 6302717 },
	{ 24, 7351293 },
	{ 25, 10497021 },
	{ 25, 11545597 },
	{ 25, 14691325 },
	{ 25, 15739901 },
	{ 26, 27274237 },
	{ 26, 28322813 },
	{ 26, 31468541 },
	{ 26, 66399997 },
	{ 26, 65351421 },
	{ 26, 62205693 },
	{ 26, 61157117 },
	{ 26, 32845565 },
	{ 26, 31796989 },
	{ 26, 28651261 },
	{ 26, 27602685 },
	{ 25, 16068349 },
	{ 25, 15019773 },
	{ 25, 11874045 },
	{ 25, 10825469 },
	{ 24, 7679741 },
	{ 24, 6631165 },
	{ 24, 3485437 },
	{ 24, 2436861 },
	{ 22, 1388285 },
	{ 18, 130685 },
	{ 12, 1994 },
	{ 14, 8153 },
	{ 17, 65517 },
	{ 22, 143101 },
	{ 22, 405245 },
	{ 24, 667389 },
	{ 24, 929533 },
	{ 24, 1715965 },
	{ 24, 1978109 },
	{ 25, 2764541 },
	{ 25, 3026685 },
	{ 25, 3813117 },
	{ 25, 4075261 },
	{ 26, 6958845 },
	{ 26, 7220989 },
	{ 26, 8007421 },
	{ 26, 8269565 },
	{ 26, 15347453 },
	{ 26, 15609597 },
	{ 26, 16396029 },
	{ 26, 16658173 },
	{ 26, 27602941 },
	{ 25, 16068605 },
	{ 25, 15020029 },
	{ 25, 11874301 },
	{ 25, 10825725 },
	{ 24, 7679997 },
	{ 24, 6631421 },
	{ 24, 3485693 },
	{ 24, 2437117 },
	{ 22, 1388541 },
	{ 19, 262077 },
	{ 17, 65338 },
	{ 17, 65385 },
	{ 17, 65341 },
	{ 22, 143357 },
	{ 22, 405501 },
	{ 24, 667645 },
	{ 24, 929789 },
	{ 24, 1716221 },
	{ 24, 1978365 },
	{ 25, 2764797 },
	{ 25, 3026941 },
	{ 25, 3813373 },
	{ 25, 4075517 },
	{ 26, 6959101 },
	{ 26, 7221245 },
	{ 26, 8007677 },
	{ 26, 8269821 },
	{ 26, 15347709 },
	{ 26, 15609853 },
	{ 26, 16396285 },
	{ 26, 16658429 },
	{ 28, 109656829 },
	{ 27, 63519485 },
	{ 27, 59325181 },
	{ 27, 46742269 },
	{ 27, 42547965 },
	{ 26, 29965053 },
	{ 26, 25770749 },
	{ 26, 13187837 },
	{ 26, 8993533 },
	{ 24, 4799229 },
	{ 24, 604925 },
	{ 16, 29210 },
	{ 19, 261753 },
	{ 17, 59257 },
	{ 22, 211705 },
	{ 22, 473849 },
	{ 22, 1456893 },
	{ 23, 3080191 },
	{ 24, 1784569 },
	{ 24, 2046713 },
	{ 24, 6175485 },
	{ 25, 3095289 },
	{ 25, 3881721 },
	{ 25, 4143865 },
	{ 25, 12466941 },
	{ 26, 7289593 },
	{ 26, 8076025 },
	{ 26, 8338169 },
	{ 26, 15416057 },
	{ 26, 15678201 },
	{ 26, 16464633 },
	{ 26, 16726777 },
	{ 26, 33438461 },
	{ 27, 63519741 },
	{ 27, 59325437 },
	{ 27, 46742525 },
	{ 27, 42548221 },
	{ 26, 29965309 },
	{ 26, 25771005 },
	{ 26, 13188093 },
	{ 26, 8993789 },
	{ 24, 4799485 },
	{ 24, 605181 },
	{ 16, 30234 },
	{ 20, 524217 },
	{ 17, 61305 },
	{ 22, 211961 },
	{ 22, 474105 },
	{ 22, 1457149 },
	{ 23, 3079935 },
	{ 24, 1784825 },
	{ 24, 2046969 },
	{ 24, 6175741 },
	{ 25, 3095545 },
	{ 25, 3881977 },
	{ 25, 4144121 },
	{ 25, 12467197 },
	{ 26, 7289849 },
	{ 26, 8076281 },
	{ 26, 8338425 },
	{ 26, 15416313 },
	{ 26, 15678457 },
	{ 26, 16464889 },
	{ 26, 16727033 },
	{ 26, 33438717 },
	{ 27, 63782653 },
	{ 27, 59588349 },
	{ 27, 47005437 },
	{ 27, 42811133 },
	{ 26, 30228221 },
	{ 26, 26033917 },
	{ 26, 13451005 },
	{ 26, 9256701 },
	{ 24, 5062397 },
	{ 24, 868093 },
	{ 16, 31386 },
	{ 24, 605945 },
	{ 22, 1392377 },
	{ 23, 2685947 },
	{ 22, 1261305 },
	{ 22, 1523449 },
	{ 23, 2948091 },
	{ 24, 5193465 },
	{ 24, 5979897 },
	{ 24, 6242041 },
	{ 25, 11222777 },
	{ 25, 11484921 },
	{ 25, 12271353 },
	{ 25, 12533497 },
	{ 26, 23805689 },
	{ 26, 24067833 },
	{ 26, 24854265 },
	{ 26, 25116409 },
	{ 26, 32194297 },
	{ 26, 32456441 },
	{ 26, 33242873 },
	{ 26, 33505017 },
	{ 27, 63782909 },
	{ 27, 59588605 },
	{ 27, 47005693 },
	{ 27, 42811389 },
	{ 26, 30228477 },
	{ 26, 26034173 },
	{ 26, 13451261 },
	{ 26, 9256957 },
	{ 24, 5062653 },
	{ 24, 868349 },
	{ 16, 32410 },
	{ 24, 606201 },
	{ 22, 1392633 },
	{ 23, 2685691 },
	{ 22, 1261561 },
	{ 22, 1523705 },
	{ 23, 2947835 },
	{ 24, 5193721 },
	{ 24, 5980153 },
	{ 24, 6242297 },
	{ 25, 11223033 },
	{ 25, 11485177 },
	{ 25, 12271609 },
	{ 25, 12533753 },
	{ 26, 23805945 },
	{ 26, 24068089 },
	{ 26, 24854521 },
	{ 26, 25116665 },
	{ 26, 32194553 },
	{ 26, 32456697 },
	{ 26, 33243129 },
	{ 26, 33505273 },
	{ 27, 64580349 },
	{ 27, 60386045 },
	{ 27, 47803133 },
	{ 27, 43608829 },
	{ 26, 31025917 },
	{ 26, 26831613 },
	{ 26, 14248701 },
	{ 26, 10054397 },
	{ 24, 5860093 },
	{ 24, 1665789 },
	{ 19, 215322 },
	{ 24, 879353 },
	{ 24, 4811513 },
	{ 24, 2452217 },
	{ 24, 3238649 },
	{ 24, 2321145 },
	{ 24, 2583289 },
	{ 24, 3566333 },
	{ 25, 10416127 },
	{ 26, 10185465 },
	{ 26, 10447609 },
	{ 26, 14576381 },
	{ 27, 19884793 },
	{ 27, 20671225 },
	{ 27, 20933369 },
	{ 27, 29256445 },
	{ 28, 40856313 },
	{ 28, 41642745 },
	{ 28, 41904889 },
	{ 28, 48982777 },
	{ 28, 49244921 },
	{ 28, 50031353 },
	{ 27, 64580605 },
	{ 27, 60386301 },
	{ 27, 47803389 },
	{ 27, 43609085 },
	{ 26, 31026173 },
	{ 26, 26831869 },
	{ 26, 14248957 },
	{ 26, 10054653 },
	{ 24, 5860349 },
	{ 24, 1666045 },
	{ 19, 219418 },
	{ 24, 879609 },
	{ 24, 4811769 },
	{ 24, 2452473 },
	{ 24, 3238905 },
	{ 24, 2321401 },
	{ 24, 2583545 },
	{ 24, 3566589 },
	{ 25, 10415871 },
	{ 26, 10185721 },
	{ 26, 10447865 },
	{ 26, 14576637 },
	{ 27, 19885049 },
	{ 27, 20671481 },
	{ 27, 20933625 },
	{ 27, 29256701 },
	{ 28, 40856569 },
	{ 28, 41643001 },
	{ 28, 41905145 },
	{ 28, 48983033 },
	{ 28, 49245177 },
	{ 28, 50031609 },
	{ 27, 64843517 },
	{ 27, 60649213 },
	{ 27, 48066301 },
	{ 27, 43871997 },
	{ 26, 31289085 },
	{ 26, 27094781 },
	{ 26, 14511869 },
	{ 26, 10317565 },
	{ 24, 6123261 },
	{ 24, 1928957 },
	{ 19, 223642 },
	{ 24, 1666809 },
	{ 24, 5074681 },
	{ 25, 10021883 },
	{ 24, 3501817 },
	{ 24, 6385401 },
	{ 24, 3370745 },
	{ 24, 3632889 },
	{ 24, 6713085 },
	{ 25, 11987967 },
	{ 26, 14380793 },
	{ 26, 14642937 },
	{ 26, 27160317 },
	{ 27, 28274425 },
	{ 27, 29060857 },
	{ 27, 29323001 },
	{ 27, 54423293 },
	{ 28, 57634553 },
	{ 28, 58420985 },
	{ 28, 58683129 },
	{ 28, 65761017 },
	{ 28, 66023161 },
	{ 27, 64843773 },
	{ 27, 60649469 },
	{ 27, 48066557 },
	{ 27, 43872253 },
	{ 26, 31289341 },
	{ 26, 27095037 },
	{ 26, 14512125 },
	{ 26, 10317821 },
	{ 24, 6123517 },
	{ 24, 1929213 },
	{ 19, 227738 },
	{ 24, 1667065 },
	{ 24, 5074937 },
	{ 25, 10021627 },
	{ 24, 3502073 },
	{ 24, 6385657 },
	{ 24, 3371001 },
	{ 24, 3633145 },
	{ 24, 6713341 },
	{ 25, 11987711 },
	{ 26, 14381049 },
	{ 26, 14643193 },
	{ 26, 27160573 },
	{ 27, 28274681 },
	{ 27, 29061113 },
	{ 27, 29323257 },
	{ 27, 54423549 },
	{ 28, 57634809 },
	{ 28, 58421241 },
	{ 28, 58683385 },
	{ 28, 65761273 },
	{ 28, 66023417 },
	{ 28, 66809849 },
	{ 28, 67071993 },
	{ 28, 94993149 },
	{ 28, 86604541 },
	{ 27, 61438717 },
	{ 27, 53050109 },
	{ 27, 27884285 },
	{ 27, 19495677 },
	{ 25, 11107069 },
	{ 25, 2718461 },
	{ 19, 248602 },
	{ 19, 523118 },
	{ 24, 5864185 },
	{ 25, 11583483 },
	{ 26, 13204217 },
	{ 24, 6650617 },
	{ 24, 7437049 },
	{ 24, 6519545 },
	{ 24, 6781689 },
	{ 24, 7764733 },
	{ 25, 12500991 },
	{ 26, 26966777 },
	{ 26, 27228921 },
	{ 26, 31357693 },
	{ 27, 53443321 },
	{ 27, 54229753 },
	{ 27, 54491897 },
	{ 27, 62814973 },
	{ 28, 107969273 },
	{ 28, 108755705 },
	{ 28, 109017849 },
	{ 28, 116095737 },
	{ 28, 116357881 },
	{ 28, 117144313 },
	{ 28, 117406457 },
	{ 28, 134118141 },
	{ 27, 61438973 },
	{ 27, 53050365 },
	{ 27, 27884541 },
	{ 27, 19495933 },
	{ 25, 11107325 },
	{ 25, 2718717 },
	{ 19, 252698 },
	{ 19, 519022 },
	{ 24, 5864441 },
	{ 25, 11583227 },
	{ 26, 13204473 },
	{ 24, 6650873 },
	{ 24, 7437305 },
	{ 24, 6519801 },
	{ 24, 6781945 },
	{ 24, 7764989 },
	{ 25, 12500735 },
	{ 26, 26967033 },
	{ 26, 27229177 },
	{ 26, 31357949 },
	{ 27, 53443577 },
	{ 27, 54230009 },
	{ 27, 54492153 },
	{ 27, 62815229 },
	{ 28, 107969529 },
	{ 28, 108755961 },
	{ 28, 109018105 },
	{ 28, 116095993 },
	{ 28, 116358137 },
	{ 28, 117144569 },
	{ 28, 117406713 },
	{ 28, 86867709 },
	{ 27, 61701885 },
	{ 27, 53313277 },
	{ 27, 28147453 },
	{ 27, 19758845 },
	{ 25, 11370237 },
	{ 25, 2981629 },
	{ 19, 256922 },
	{ 19, 515054 },
	{ 24, 6127353 },
	{ 25, 12106747 },
	{ 26, 13467385 },
	{ 26, 25788153 },
	{ 24, 7700217 },
	{ 25, 10583801 },
	{ 24, 7569145 },
	{ 24, 7831289 },
	{ 25, 10911485 },
	{ 26, 30375673 },
	{ 26, 31162105 },
	{ 26, 31424249 },
	{ 27, 61570809 },
	{ 27, 61832953 },
	{ 27, 62619385 },
	{ 27, 62881529 },
	{ 28, 124485369 },
	{ 28, 124747513 },
	{ 28, 125533945 },
	{ 28, 125796089 },
	{ 28, 132873977 },
	{ 28, 133136121 },
	{ 28, 133922553 },
	{ 28, 134184697 },
	{ 27, 61702141 },
	{ 27, 53313533 },
	{ 27, 28147709 },
	{ 27, 19759101 },
	{ 25, 11370493 },
	{ 25, 2981885 },
	{ 19, 261018 },
	{ 19, 510958 },
	{ 24, 6127609 },
	{ 25, 12106491 },
	{ 26, 13467641 },
	{ 26, 25788409 },
	{ 24, 7700473 },
	{ 25, 10584057 },
	{ 24, 7569401 },
	{ 24, 7831545 },
	{ 25, 10911741 },
	{ 26, 30375929 },
	{ 26, 31162361 },
	{ 26, 31424505 },
	{ 27, 61571065 },
	{ 27, 61833209 },
	{ 27, 62619641 },
	{ 27, 62881785 },
	{ 28, 124485625 },
	{ 28, 124747769 },
	{ 28, 125534201 },
	{ 28, 125796345 },
	{ 28, 132874233 },
	{ 28, 133136377 },
	{ 28, 133922809 },
	{ 28, 134184953 },
	{ 28, 124955389 },
	{ 28, 108178173 },
	{ 28, 57846525 },
	{ 28, 41069309 },
	{ 26, 24292093 },
	{ 26, 7514877 },
	{ 20, 955674 },
	{ 20, 980334 },
	{ 26, 22194937 },
	{ 26, 22065147 },
	{ 27, 28486393 },
	{ 27, 52079353 },
	{ 27, 59943673 },
	{ 26, 21670649 },
	{ 26, 23243513 },
	{ 26, 21408505 },
	{ 26, 21932793 },
	{ 26, 23898877 },
	{ 26, 22982655 },
	{ 28, 87468793 },
	{ 28, 87993081 },
	{ 28, 96250621 },
	{ 28, 123645951 },
	{ 29, 175549177 },
	{ 29, 176073465 },
	{ 29, 192719613 },
	{ 29, 257863679 },
	{ 30, 351709945 },
	{ 29, 259173373 },
	{ 29, 242396157 },
	{ 29, 192064509 },
	{ 29, 175287293 },
	{ 28, 124955645 },
	{ 28, 108178429 },
	{ 28, 57846781 },
	{ 28, 41069565 },
	{ 26, 24292349 },
	{ 26, 7515133 },
	{ 20, 963866 },
	{ 20, 972142 },
	{ 26, 22195193 },
	{ 26, 22064891 },
	{ 27, 28486649 },
	{ 27, 52079609 },
	{ 27, 59943929 },
	{ 26, 21670905 },
	{ 26, 23243769 },
	{ 26, 21408761 },
	{ 26, 21933049 },
	{ 26, 23899133 },
	{ 26, 22982399 },
	{ 28, 87469049 },
	{ 28, 87993337 },
	{ 28, 96250877 },
	{ 28, 123645695 },
	{ 29, 175549433 },
	{ 29, 176073721 },
	{ 29, 192719869 },
	{ 29, 257863423 },
	{ 30, 351710201 },
	{ 29, 259698429 },
	{ 29, 242921213 },
	{ 29, 192589565 },
	{ 29, 175812349 },
	{ 28, 125480701 },
	{ 28, 108703485 },
	{ 28, 58371837 },
	{ 28, 41594621 },
	{ 26, 24817405 },
	{ 26, 8040189 },
	{ 20, 972186 },
	{ 20, 964078 },
	{ 26, 22720249 },
	{ 26, 22588411 },
	{ 27, 29011705 },
	{ 27, 53653241 },
	{ 27, 60468985 },
	{ 27, 60337147 },
	{ 26, 23768825 },
	{ 26, 29535993 },
	{ 26, 23506681 },
	{ 26, 24030969 },
	{ 26, 30191357 },
	{ 26, 24554495 },
	{ 28, 95858425 },
	{ 28, 96382713 },
	{ 28, 121417469 },
	{ 28, 125217791 },
	{ 29, 192327417 },
	{ 29, 192851705 },
	{ 29, 243052285 },
	{ 29, 259435519 },
	{ 29, 259698685 },
	{ 29, 242921469 },
	{ 29, 192589821 },
	{ 29, 175812605 },
	{ 28, 125480957 },
	{ 28, 108703741 },
	{ 28, 58372093 },
	{ 28, 41594877 },
	{ 26, 24817661 },
	{ 26, 8040445 },
	{ 20, 980378 },
	{ 20, 955886 },
	{ 26, 22720505 },
	{ 26, 22588155 },
	{ 27, 29011961 },
	{ 27, 53653497 },
	{ 27, 60469241 },
	{ 27, 60336891 },
	{ 26, 23769081 },
	{ 26, 29536249 },
	{ 26, 23506937 },
	{ 26, 24031225 },
	{ 26, 30191613 },
	{ 26, 24554239 },
	{ 28, 95858681 },
	{ 28, 96382969 },
	{ 28, 121417725 },
	{ 28, 125217535 },
	{ 29, 192327673 },
	{ 29, 192851961 },
	{ 29, 243052541 },
	{ 29, 259435263 },
	{ 30, 519614457 },
	{ 29, 258506751 },
	{ 29, 241729535 },
	{ 29, 191397887 },
	{ 29, 267956217 },
	{ 28, 124289023 },
	{ 28, 107511807 },
	{ 28, 57180159 },
	{ 27, 47364861 },
	{ 26, 23625727 },
	{ 20, 1021722 },
	{ 20, 522094 },
	{ 25, 3964923 },
	{ 25, 12091387 },
	{ 27, 19693563 },
	{ 27, 54180601 },
	{ 26, 27033595 },
	{ 26, 30965755 },
	{ 27, 42762235 },
	{ 26, 30063353 },
	{ 25, 14974971 },
	{ 25, 15761403 },
	{ 25, 3833851 },
	{ 25, 12222459 },
	{ 25, 12550143 },
	{ 27, 28999675 },
	{ 27, 54165499 },
	{ 27, 62554107 },
	{ 27, 62881791 },
	{ 28, 96108539 },
	{ 28, 121274363 },
	{ 28, 129662971 },
	{ 28, 129990655 },
	{ 29, 230326267 },
	{ 29, 255492091 },
	{ 29, 263880699 },
	{ 29, 267434745 },
	{ 28, 133791739 },
	{ 28, 117276667 },
	{ 28, 57179903 },
	{ 27, 47365117 },
	{ 26, 23625471 },
	{ 20, 1029914 },
	{ 20, 513902 },
	{ 25, 3964667 },
	{ 25, 12091131 },
	{ 27, 19693307 },
	{ 27, 54180857 },
	{ 26, 27033339 },
	{ 26, 30965499 },
	{ 27, 42761979 },
	{ 26, 30063609 },
	{ 25, 14974715 },
	{ 25, 15761147 },
	{ 25, 3833595 },
	{ 25, 12222203 },
	{ 25, 12549887 },
	{ 27, 28999419 },
	{ 27, 54165243 },
	{ 27, 62553851 },
	{ 27, 62881535 },
	{ 28, 96108283 },
	{ 28, 121274107 },
	{ 28, 129662715 },
	{ 28, 129990399 },
	{ 29, 230326011 },
	{ 29, 255491835 },
	{ 29, 263880443 },
	{ 29, 267435001 },
	{ 28, 133791483 },
	{ 28, 117276411 },
	{ 28, 57441279 },
	{ 27, 47890173 },
	{ 26, 23886847 },
	{ 20, 1038234 },
	{ 20, 505838 },
	{ 26, 24821497 },
	{ 25, 12352507 },
	{ 27, 20478971 },
	{ 27, 28081147 },
	{ 27, 62570233 },
	{ 26, 31226875 },
	{ 27, 43547643 },
	{ 27, 46955515 },
	{ 26, 32161529 },
	{ 25, 16022523 },
	{ 26, 31899385 },
	{ 25, 4094971 },
	{ 25, 12483579 },
	{ 26, 23821311 },
	{ 27, 29260795 },
	{ 27, 54426619 },
	{ 27, 62815227 },
	{ 28, 87981051 },
	{ 28, 96369659 },
	{ 28, 121535483 },
	{ 28, 129924091 },
	{ 29, 222198779 },
	{ 29, 230587387 },
	{ 29, 255753211 },
	{ 29, 265862905 },
	{ 28, 133004283 },
	{ 28, 117013499 },
	{ 28, 66943995 },
	{ 27, 47890429 },
	{ 26, 23886591 },
	{ 20, 1046426 },
	{ 20, 497646 },
	{ 26, 24821753 },
	{ 25, 12352251 },
	{ 27, 20478715 },
	{ 27, 28080891 },
	{ 27, 62570489 },
	{ 26, 31226619 },
	{ 27, 43547387 },
	{ 27, 46955259 },
	{ 26, 32161785 },
	{ 25, 16022267 },
	{ 26, 31899641 },
	{ 25, 4094715 },
	{ 25, 12483323 },
	{ 26, 23821055 },
	{ 27, 29260539 },
	{ 27, 54426363 },
	{ 27, 62814971 },
	{ 28, 87980795 },
	{ 28, 96369403 },
	{ 28, 121535227 },
	{ 28, 129923835 },
	{ 29, 222198523 },
	{ 29, 230587131 },
	{ 29, 255752955 },
	{ 29, 265863161 },
	{ 28, 133004027 },
	{ 28, 117013243 },
	{ 28, 66943739 },
	{ 27, 49474301 },
	{ 26, 24670207 },
	{ 26, 7892991 },
	{ 21, 912750 },
	{ 26, 7106555 },
	{ 26, 23621627 },
	{ 27, 20738043 },
	{ 27, 28864507 },
	{ 27, 53243899 },
	{ 27, 61370363 },
	{ 27, 43806715 },
	{ 27, 47738875 },
	{ 27, 59535355 },
	{ 27, 55241465 },
	{ 26, 27553787 },
	{ 26, 28340219 },
	{ 26, 6975483 },
	{ 26, 23752699 },
	{ 26, 24080383 },
	{ 28, 57307131 },
	{ 28, 107638779 },
	{ 28, 124415995 },
	{ 28, 124743679 },
	{ 29, 191524859 },
	{ 29, 241856507 },
	{ 29, 258633723 },
	{ 29, 242053115 },
	{ 29, 192507899 },
	{ 29, 265349881 },
	{ 28, 132739067 },
	{ 28, 116223995 },
	{ 28, 66678779 },
	{ 27, 49474557 },
	{ 26, 24669951 },
	{ 26, 7892735 },
	{ 21, 896366 },
	{ 26, 7106299 },
	{ 26, 23621371 },
	{ 27, 20737787 },
	{ 27, 28864251 },
	{ 27, 53243643 },
	{ 27, 61370107 },
	{ 27, 43806459 },
	{ 27, 47738619 },
	{ 27, 59535099 },
	{ 27, 55241721 },
	{ 26, 27553531 },
	{ 26, 28339963 },
	{ 26, 6975227 },
	{ 26, 23752443 },
	{ 26, 24080127 },
	{ 28, 57306875 },
	{ 28, 107638523 },
	{ 28, 124415739 },
	{ 28, 124743423 },
	{ 29, 191524603 },
	{ 29, 241856251 },
	{ 29, 258633467 },
	{ 29, 242052859 },
	{ 29, 192507643 },
	{ 29, 265350137 },
	{ 28, 132738811 },
	{ 28, 116223739 },
	{ 28, 66678523 },
	{ 27, 49999613 },
	{ 26, 24931327 },
	{ 26, 8154111 },
	{ 21, 880110 },
	{ 26, 7891963 },
	{ 26, 23882747 },
	{ 28, 58388217 },
	{ 27, 29125627 },
	{ 27, 54029307 },
	{ 27, 61631483 },
	{ 28, 96136953 },
	{ 27, 47999995 },
	{ 27, 60320763 },
	{ 27, 66907897 },
	{ 26, 66546683 },
	{ 26, 28601339 },
	{ 26, 31484923 },
	{ 26, 7236603 },
	{ 26, 24013819 },
	{ 26, 24865791 },
	{ 28, 57568251 },
	{ 28, 107899899 },
	{ 28, 124677115 },
	{ 28, 125529087 },
	{ 29, 259583737 },
	{ 28, 129854459 },
	{ 29, 258894843 },
	{ 29, 191720443 },
	{ 29, 251195129 },
	{ 28, 125660155 },
	{ 28, 115960827 },
	{ 28, 65891323 },
	{ 27, 66645753 },
	{ 26, 33385467 },
	{ 26, 8153855 },
	{ 21, 863726 },
	{ 26, 7891707 },
	{ 26, 23882491 },
	{ 28, 58388473 },
	{ 27, 29125371 },
	{ 27, 54029051 },
	{ 27, 61631227 },
	{ 28, 96137209 },
	{ 27, 47999739 },
	{ 27, 60320507 },
	{ 27, 66908153 },
	{ 26, 66546427 },
	{ 26, 28601083 },
	{ 26, 31484667 },
	{ 26, 7236347 },
	{ 26, 24013563 },
	{ 26, 24865535 },
	{ 28, 57567995 },
	{ 28, 107899643 },
	{ 28, 124676859 },
	{ 28, 125528831 },
	{ 29, 259583993 },
	{ 28, 129854203 },
	{ 29, 258894587 },
	{ 29, 191720187 },
	{ 29, 251195385 },
	{ 28, 125659899 },
	{ 28, 115960571 },
	{ 28, 65891067 },
	{ 27, 66646009 },
	{ 26, 33385211 },
	{ 26, 15220735 },
	{ 20, 520046 },
	{ 26, 8142843 },
	{ 26, 24657915 },
	{ 28, 40648699 },
	{ 28, 108722937 },
	{ 27, 54280187 },
	{ 27, 62406651 },
	{ 28, 86786043 },
	{ 28, 121305849 },
	{ 27, 60571643 },
	{ 27, 67042045 },
	{ 26, 66469887 },
	{ 26, 65486843 },
	{ 26, 31735803 },
	{ 26, 32522235 },
	{ 26, 8011771 },
	{ 26, 24788987 },
	{ 26, 25116671 },
	{ 28, 58343419 },
	{ 28, 108675067 },
	{ 28, 125452283 },
	{ 28, 125779967 },
	{ 28, 129581051 },
	{ 28, 121454587 },
	{ 29, 259670011 },
	{ 29, 250673913 },
	{ 28, 125386747 },
	{ 28, 108871675 },
	{ 28, 65617915 },
	{ 27, 66124537 },
	{ 26, 33112059 },
	{ 26, 16596987 },
	{ 20, 503662 },
	{ 26, 8142587 },
	{ 26, 24657659 },
	{ 28, 40648443 },
	{ 28, 108723193 },
	{ 27, 54279931 },
	{ 27, 62406395 },
	{ 28, 86785787 },
	{ 28, 121306105 },
	{ 27, 60571387 },
	{ 27, 67042301 },
	{ 26, 66469631 },
	{ 26, 65486587 },
	{ 26, 31735547 },
	{ 26, 32521979 },
	{ 26, 8011515 },
	{ 26, 24788731 },
	{ 26, 25116415 },
	{ 28, 58343163 },
	{ 28, 108674811 },
	{ 28, 125452027 },
	{ 28, 125779711 },
	{ 28, 129580795 },
	{ 28, 121454331 },
	{ 29, 259669755 },
	{ 29, 250674169 },
	{ 28, 125386491 },
	{ 28, 108871419 },
	{ 28, 65617659 },
	{ 27, 66124793 },
	{ 26, 33111803 },
	{ 26, 16596731 },
	{ 20, 487406 },
	{ 26, 15219707 },
	{ 26, 24919035 },
	{ 28, 41434107 },
	{ 28, 57424891 },
	{ 28, 125501177 },
	{ 27, 62667771 },
	{ 28, 87571451 },
	{ 28, 95173627 },
	{ 28, 129695481 },
	{ 27, 64764923 },
	{ 27, 66518781 },
	{ 26, 65420287 },
	{ 26, 62340091 },
	{ 26, 32783355 },
	{ 26, 60832763 },
	{ 26, 8272891 },
	{ 26, 25050107 },
	{ 26, 32193535 },
	{ 28, 58604539 },
	{ 28, 108936187 },
	{ 28, 125713403 },
	{ 28, 128793595 },
	{ 28, 121191419 },
	{ 28, 96287739 },
	{ 29, 249102073 },
	{ 28, 124599291 },
	{ 28, 108608507 },
	{ 28, 58539003 },
	{ 27, 64552697 },
	{ 26, 32324603 },
	{ 26, 16333819 },
	{ 20, 471022 },
	{ 26, 15219451 },
	{ 26, 24918779 },
	{ 28, 41433851 },
	{ 28, 57424635 },
	{ 28, 125501433 },
	{ 27, 62667515 },
	{ 28, 87571195 },
	{ 28, 95173371 },
	{ 28, 129695737 },
	{ 27, 64764667 },
	{ 27, 66519037 },
	{ 26, 65420031 },
	{ 26, 62339835 },
	{ 26, 32783099 },
	{ 26, 60832507 },
	{ 26, 8272635 },
	{ 26, 25049851 },
	{ 26, 32193279 },
	{ 28, 58604283 },
	{ 28, 108935931 },
	{ 28, 125713147 },
	{ 28, 128793339 },
	{ 28, 121191163 },
	{ 28, 96287483 },
	{ 29, 249102329 },
	{ 28, 124599035 },
	{ 28, 108608251 },
	{ 28, 58538747 },
	{ 27, 64552953 },
	{ 26, 32324347 },
	{ 26, 16333563 },
	{ 20, 392558 },
	{ 26, 15478779 },
	{ 26, 31993851 },
	{ 28, 41693179 },
	{ 28, 58208251 },
	{ 28, 107753467 },
	{ 28, 124268539 },
	{ 28, 87830523 },
	{ 28, 95956987 },
	{ 28, 120336379 },
	{ 28, 128462843 },
	{ 28, 110899195 },
	{ 28, 129870589 },
	{ 26, 62271487 },
	{ 26, 61288443 },
	{ 26, 61091835 },
	{ 26, 61878267 },
	{ 26, 15347707 },
	{ 26, 32124923 },
	{ 26, 32452607 },
	{ 28, 65679355 },
	{ 28, 116011003 },
	{ 28, 132788219 },
	{ 28, 120401915 },
	{ 28, 96022523 },
	{ 28, 87896059 },
	{ 28, 124334075 },
	{ 28, 107819003 },
	{ 28, 58273787 },
	{ 28, 128035577 },
	{ 26, 32059387 },
	{ 26, 15544315 },
	{ 20, 376174 },
	{ 26, 15478523 },
	{ 26, 31993595 },
	{ 28, 41692923 },
	{ 28, 58207995 },
	{ 28, 107753211 },
	{ 28, 124268283 },
	{ 28, 87830267 },
	{ 28, 95956731 },
	{ 28, 120336123 },
	{ 28, 128462587 },
	{ 28, 110898939 },
	{ 28, 129870845 },
	{ 26, 62271231 },
	{ 26, 61288187 },
	{ 26, 61091579 },
	{ 26, 61878011 },
	{ 26, 15347451 },
	{ 26, 32124667 },
	{ 26, 32452351 },
	{ 28, 65679099 },
	{ 28, 116010747 },
	{ 28, 132787963 },
	{ 28, 120401659 },
	{ 28, 96022267 },
	{ 28, 87895803 },
	{ 28, 124333819 },
	{ 28, 107818747 },
	{ 28, 58273531 },
	{ 28, 128035833 },
	{ 26, 32059131 },
	{ 26, 15544059 },
	{ 20, 359918 },
	{ 26, 16264187 },
	{ 26, 32254971 },
	{ 28, 48770043 },
	{ 28, 58469371 },
	{ 28, 108538875 },
	{ 28, 124529659 },
	{ 29, 174599163 },
	{ 28, 96218107 },
	{ 28, 121121787 },
	{ 28, 128723963 },
	{ 28, 132066299 },
	{ 28, 115092475 },
	{ 28, 128823037 },
	{ 26, 61221887 },
	{ 26, 32975867 },
	{ 26, 62139387 },
	{ 26, 65022971 },
	{ 26, 15608827 },
	{ 26, 32386043 },
	{ 26, 33238015 },
	{ 28, 65940475 },
	{ 27, 64826363 },
	{ 28, 133049339 },
	{ 28, 95235067 },
	{ 28, 87632891 },
	{ 27, 62729211 },
	{ 28, 107555835 },
	{ 28, 57486331 },
	{ 28, 99725049 },
	{ 26, 24980475 },
	{ 26, 15281147 },
	{ 20, 343534 },
	{ 26, 16263931 },
	{ 26, 32254715 },
	{ 28, 48769787 },
	{ 28, 58469115 },
	{ 28, 108538619 },
	{ 28, 124529403 },
	{ 29, 174598907 },
	{ 28, 96217851 },
	{ 28, 121121531 },
	{ 28, 128723707 },
	{ 28, 132066043 },
	{ 28, 115092219 },
	{ 28, 128823293 },
	{ 26, 61221631 },
	{ 26, 32975611 },
	{ 26, 62139131 },
	{ 26, 65022715 },
	{ 26, 15608571 },
	{ 26, 32385787 },
	{ 26, 33237759 },
	{ 28, 65940219 },
	{ 27, 64826107 },
	{ 28, 133049083 },
	{ 28, 95234811 },
	{ 28, 87632635 },
	{ 27, 62728955 },
	{ 28, 107555579 },
	{ 28, 57486075 },
	{ 28, 99725305 },
	{ 26, 24980219 },
	{ 26, 15280891 },
	{ 19, 261998 },
	{ 24, 4136955 },
	{ 24, 8265723 },
	{ 26, 12263419 },
	{ 26, 16392187 },
	{ 26, 27205627 },
	{ 26, 31334395 },
	{ 27, 43720699 },
	{ 27, 47849467 },
	{ 26, 30351355 },
	{ 26, 32382971 },
	{ 26, 33005567 },
	{ 26, 31973371 },
	{ 26, 31924219 },
	{ 26, 32907259 },
	{ 24, 8232959 },
	{ 24, 7987195 },
	{ 24, 16326651 },
	{ 24, 16523259 },
	{ 24, 4104187 },
	{ 24, 8298491 },
	{ 24, 8380415 },
	{ 25, 16146427 },
	{ 25, 15163387 },
	{ 26, 33464315 },
	{ 26, 21716987 },
	{ 25, 15622139 },
	{ 25, 13590523 },
	{ 26, 14311419 },
	{ 26, 10182651 },
	{ 24, 6184955 },
	{ 24, 2056187 },
	{ 19, 245614 },
	{ 24, 4136699 },
	{ 24, 8265467 },
	{ 26, 12263163 },
	{ 26, 16391931 },
	{ 26, 27205371 },
	{ 26, 31334139 },
	{ 27, 43720443 },
	{ 27, 47849211 },
	{ 26, 30351099 },
	{ 26, 32382715 },
	{ 26, 33005311 },
	{ 26, 31973115 },
	{ 26, 31923963 },
	{ 26, 32907003 },
	{ 24, 8232703 },
	{ 24, 7986939 },
	{ 24, 16326395 },
	{ 24, 16523003 },
	{ 24, 4103931 },
	{ 24, 8298235 },
	{ 24, 8380159 },
	{ 25, 16146171 },
	{ 25, 15163131 },
	{ 26, 33464059 },
	{ 26, 21716731 },
	{ 25, 15621883 },
	{ 25, 13590267 },
	{ 26, 14311163 },
	{ 26, 10182395 },
	{ 24, 6184699 },
	{ 24, 2055931 },
	{ 19, 229358 },
	{ 24, 3825407 },
	{ 24, 8330235 },
	{ 26, 12459003 },
	{ 26, 16456699 },
	{ 26, 28974075 },
	{ 26, 31398907 },
	{ 27, 43916283 },
	{ 27, 47913979 },
	{ 27, 60431355 },
	{ 26, 32447483 },
	{ 27, 55450619 },
	{ 26, 31955967 },
	{ 26, 28826619 },
	{ 26, 32971771 },
	{ 26, 61217787 },
	{ 24, 7969791 },
	{ 24, 7199739 },
	{ 24, 16587771 },
	{ 24, 7887867 },
	{ 24, 4168699 },
	{ 24, 8363003 },
	{ 25, 15948795 },
	{ 25, 15096827 },
	{ 25, 12016635 },
	{ 26, 33528827 },
	{ 25, 15424507 },
	{ 25, 13523963 },
	{ 25, 7298043 },
	{ 26, 10116091 },
	{ 24, 5987323 },
	{ 24, 1989627 },
	{ 19, 212974 },
	{ 24, 2055167 },
	{ 24, 8329979 },
	{ 26, 12458747 },
	{ 26, 16456443 },
	{ 26, 28973819 },
	{ 26, 31398651 },
	{ 27, 43916027 },
	{ 27, 47913723 },
	{ 27, 60431099 },
	{ 26, 32447227 },
	{ 27, 55450363 },
	{ 26, 31955711 },
	{ 26, 28826363 },
	{ 26, 32971515 },
	{ 26, 61217531 },
	{ 24, 7969535 },
	{ 24, 7199483 },
	{ 24, 16587515 },
	{ 24, 7887611 },
	{ 24, 4168443 },
	{ 24, 8362747 },
	{ 25, 15948539 },
	{ 25, 15096571 },
	{ 25, 12016379 },
	{ 26, 33528571 },
	{ 25, 15424251 },
	{ 25, 13523707 },
	{ 25, 7297787 },
	{ 26, 10115835 },
	{ 24, 5987067 },
	{ 24, 1989371 },
	{ 19, 208286 },
	{ 24, 2054911 },
	{ 24, 6249215 },
	{ 26, 12521467 },
	{ 26, 16650235 },
	{ 26, 29036539 },
	{ 26, 33165307 },
	{ 27, 43978747 },
	{ 27, 48107515 },
	{ 27, 60493819 },
	{ 27, 64622587 },
	{ 27, 55513083 },
	{ 27, 57544699 },
	{ 26, 28807167 },
	{ 26, 27774971 },
	{ 26, 61280251 },
	{ 26, 62263291 },
	{ 24, 7180287 },
	{ 24, 6934523 },
	{ 24, 6868987 },
	{ 24, 7098363 },
	{ 24, 6901755 },
	{ 25, 15880187 },
	{ 25, 14897147 },
	{ 25, 11948027 },
	{ 25, 10964987 },
	{ 25, 15355899 },
	{ 25, 13324283 },
	{ 25, 7229435 },
	{ 25, 5197819 },
	{ 24, 5918715 },
	{ 24, 1789947 },
	{ 19, 126238 },
	{ 24, 1986559 },
	{ 24, 6180863 },
	{ 26, 12521211 },
	{ 26, 16649979 },
	{ 26, 29036283 },
	{ 26, 33165051 },
	{ 27, 43978491 },
	{ 27, 48107259 },
	{ 27, 60493563 },
	{ 27, 64622331 },
	{ 27, 55512827 },
	{ 27, 57544443 },
	{ 26, 28806911 },
	{ 26, 27774715 },
	{ 26, 61279995 },
	{ 26, 62263035 },
	{ 24, 7180031 },
	{ 24, 6934267 },
	{ 24, 6868731 },
	{ 24, 7098107 },
	{ 24, 6901499 },
	{ 25, 15879931 },
	{ 25, 14896891 },
	{ 25, 11947771 },
	{ 25, 10964731 },
	{ 25, 15355643 },
	{ 25, 13324027 },
	{ 25, 7229179 },
	{ 25, 5197563 },
	{ 24, 5918459 },
	{ 24, 1789691 },
	{ 19, 109854 },
	{ 24, 1986303 },
	{ 24, 6180607 },
	{ 26, 10374911 },
	{ 26, 16714747 },
	{ 26, 29232123 },
	{ 26, 33229819 },
	{ 27, 45747195 },
	{ 27, 48172027 },
	{ 27, 60689403 },
	{ 27, 64687099 },
	{ 26, 32492539 },
	{ 26, 32427003 },
	{ 26, 32230395 },
	{ 26, 32164859 },
	{ 25, 16239611 },
	{ 25, 16174075 },
	{ 25, 15977467 },
	{ 24, 6917119 },
	{ 23, 4049915 },
	{ 23, 3984379 },
	{ 24, 6835195 },
	{ 23, 4017147 },
	{ 25, 14830587 },
	{ 25, 11750395 },
	{ 25, 10898427 },
	{ 24, 7818235 },
	{ 25, 13257723 },
	{ 25, 7031803 },
	{ 25, 5131259 },
	{ 23, 3099643 },
	{ 24, 1723387 },
	{ 18, 47006 },
	{ 24, 1788927 },
	{ 24, 5983231 },
	{ 26, 10177535 },
	{ 26, 16714491 },
	{ 26, 29231867 },
	{ 26, 33229563 },
	{ 27, 45746939 },
	{ 27, 48171771 },
	{ 27, 60689147 },
	{ 27, 64686843 },
	{ 26, 32492283 },
	{ 26, 32426747 },
	{ 26, 32230139 },
	{ 26, 32164603 },
	{ 25, 16239355 },
	{ 25, 16173819 },
	{ 25, 15977211 },
	{ 24, 6916863 },
	{ 23, 4049659 },
	{ 23, 3984123 },
	{ 24, 6834939 },
	{ 23, 4016891 },
	{ 25, 14830331 },
	{ 25, 11750139 },
	{ 25, 10898171 },
	{ 24, 7817979 },
	{ 25, 13257467 },
	{ 25, 7031547 },
	{ 25, 5131003 },
	{ 23, 3099387 },
	{ 24, 1723131 },
	{ 18, 38814 },
	{ 24, 1788671 },
	{ 24, 5982975 },
	{ 25, 16771071 },
	{ 25, 15726587 },
	{ 24, 7325691 },
	{ 24, 8357883 },
	{ 25, 11454459 },
	{ 25, 12486651 },
	{ 25, 15190011 },
	{ 25, 16222203 },
	{ 24, 8120319 },
	{ 24, 7600123 },
	{ 24, 7583739 },
	{ 24, 7534587 },
	{ 23, 4057087 },
	{ 23, 3799035 },
	{ 23, 3782651 },
	{ 23, 3733499 },
	{ 21, 1009663 },
	{ 21, 948219 },
	{ 21, 931835 },
	{ 21, 989179 },
	{ 21, 940027 },
	{ 23, 2922491 },
	{ 23, 2676731 },
	{ 22, 1939451 },
	{ 22, 1693691 },
	{ 23, 1742843 },
	{ 23, 1234939 },
	{ 21, 759803 },
	{ 21, 251899 },
	{ 16, 30494 },
	{ 22, 432127 },
	{ 22, 1480703 },
	{ 24, 2529279 },
	{ 24, 3577855 },
	{ 24, 7325435 },
	{ 24, 8357627 },
	{ 25, 11454203 },
	{ 25, 12486395 },
	{ 25, 15189755 },
	{ 25, 16221947 },
	{ 24, 8120063 },
	{ 24, 7599867 },
	{ 24, 7583483 },
	{ 24, 7534331 },
	{ 23, 4056831 },
	{ 23, 3798779 },
	{ 23, 3782395 },
	{ 23, 3733243 },
	{ 21, 1009407 },
	{ 21, 947963 },
	{ 21, 931579 },
	{ 21, 988923 },
	{ 21, 939771 },
	{ 23, 2922235 },
	{ 23, 2676475 },
	{ 22, 1939195 },
	{ 22, 1693435 },
	{ 23, 1742587 },
	{ 23, 1234683 },
	{ 21, 759547 },
	{ 21, 251643 },
	{ 16, 22302 },
	{ 22, 431871 },
	{ 22, 1480447 },
	{ 24, 2529023 },
	{ 24, 3577599 },
	{ 24, 6723327 },
	{ 24, 8373243 },
	{ 25, 11502587 },
	{ 25, 12502011 },
	{ 25, 15631355 },
	{ 25, 16237563 },
	{ 25, 11990011 },
	{ 24, 7595007 },
	{ 24, 6026235 },
	{ 24, 6009851 },
	{ 24, 5960699 },
	{ 23, 3793919 },
	{ 23, 3011579 },
	{ 23, 2995195 },
	{ 23, 2946043 },
	{ 21, 943103 },
	{ 21, 750587 },
	{ 21, 734203 },
	{ 21, 922619 },
	{ 21, 742395 },
	{ 23, 2659323 },
	{ 22, 1889275 },
	{ 22, 1676283 },
	{ 22, 906235 },
	{ 23, 1217531 },
	{ 21, 709627 },
	{ 21, 234491 },
	{ 16, 13726 },
	{ 21, 250879 },
	{ 21, 775167 },
	{ 23, 1299455 },
	{ 23, 1823743 },
	{ 23, 3396607 },
	{ 23, 3920895 },
	{ 24, 5493759 },
	{ 24, 6018047 },
	{ 24, 7590911 },
	{ 24, 8115199 },
	{ 25, 11989755 },
	{ 24, 7594751 },
	{ 24, 6025979 },
	{ 24, 6009595 },
	{ 24, 5960443 },
	{ 23, 3793663 },
	{ 23, 3011323 },
	{ 23, 2994939 },
	{ 23, 2945787 },
	{ 21, 942847 },
	{ 21, 750331 },
	{ 21, 733947 },
	{ 21, 922363 },
	{ 21, 742139 },
	{ 23, 2659067 },
	{ 22, 1889019 },
	{ 22, 1676027 },
	{ 22, 905979 },
	{ 23, 1217275 },
	{ 21, 709371 },
	{ 21, 234235 },
	{ 16, 5534 },
	{ 21, 250623 },
	{ 21, 774911 },
	{ 23, 1299199 },
	{ 23, 1823487 },
	{ 23, 3396351 },
	{ 23, 2883067 },
	{ 23, 2879995 },
	{ 23, 3138043 },
	{ 23, 3912187 },
	{ 23, 4170235 },
	{ 23, 2747899 },
	{ 23, 2735611 },
	{ 22, 1505791 },
	{ 22, 1375739 },
	{ 22, 1371643 },
	{ 22, 1359355 },
	{ 21, 752127 },
	{ 21, 687611 },
	{ 21, 683515 },
	{ 21, 671227 },
	{ 19, 186879 },
	{ 19, 171515 },
	{ 19, 167419 },
	{ 19, 181755 },
	{ 19, 169467 },
	{ 20, 468475 },
	{ 20, 407035 },
	{ 20, 222715 },
	{ 20, 161275 },
	{ 19, 173563 },
	{ 19, 46587 },
	{ 14, 9502 },
	{ 19, 58879 },
	{ 19, 189951 },
	{ 21, 321023 },
	{ 21, 452095 },
	{ 21, 845311 },
	{ 21, 976383 },
	{ 22, 1369599 },
	{ 22, 1500671 },
	{ 22, 1893887 },
	{ 22, 2024959 },
	{ 23, 3975417 },
	{ 23, 3582201 },
	{ 22, 2014461 },
	{ 22, 2009337 },
	{ 22, 1878265 },
	{ 22, 1485049 },
	{ 21, 965885 },
	{ 21, 960761 },
	{ 21, 829689 },
	{ 21, 436473 },
	{ 19, 179453 },
	{ 19, 174329 },
	{ 19, 43257 },
	{ 19, 180473 },
	{ 19, 168185 },
	{ 20, 467193 },
	{ 20, 405753 },
	{ 20, 221433 },
	{ 20, 159993 },
	{ 19, 172281 },
	{ 19, 45305 },
	{ 14, 1386 },
	{ 19, 57597 },
	{ 19, 188669 },
	{ 21, 319741 },
	{ 21, 450813 },
	{ 21, 844029 },
	{ 21, 975101 },
	{ 22, 1368317 },
	{ 22, 1499389 },
	{ 22, 1892605 },
	{ 22, 2023677 },
	{ 23, 3975673 },
	{ 23, 3582457 },
	{ 22, 2014717 },
	{ 22, 2009593 },
	{ 22, 1878521 },
	{ 22, 1485305 },
	{ 21, 966141 },
	{ 21, 961017 },
	{ 21, 829945 },
	{ 21, 436729 },
	{ 19, 179709 },
	{ 19, 174585 },
	{ 19, 43513 },
	{ 19, 180729 },
	{ 19, 168441 },
	{ 20, 467449 },
	{ 20, 406009 },
	{ 20, 221689 },
	{ 20, 160249 },
	{ 19, 172537 },
	{ 19, 45561 },
	{ 14, 9578 },
	{ 19, 57853 },
	{ 19, 188925 },
	{ 21, 319997 },
	{ 21, 451069 },
	{ 21, 844285 },
	{ 21, 975357 },
	{ 22, 1368573 },
	{ 22, 1499645 },
	{ 22, 1892861 },
	{ 22, 2023933 },
	{ 23, 3465725 },
	{ 23, 3596797 },
	{ 23, 3990013 },
	{ 23, 4121085 },
	{ 23, 4055801 },
	{ 23, 3793657 },
	{ 23, 3007225 },
	{ 23, 2745081 },
	{ 22, 1958649 },
	{ 22, 1696505 },
	{ 22, 910073 },
	{ 21, 701181 },
	{ 20, 385785 },
	{ 20, 123641 },
	{ 21, 656121 },
	{ 20, 475897 },
	{ 22, 1606393 },
	{ 22, 836345 },
	{ 22, 623353 },
	{ 20, 377593 },
	{ 21, 164601 },
	{ 15, 3050 },
	{ 21, 180989 },
	{ 21, 705277 },
	{ 23, 1229565 },
	{ 23, 1753853 },
	{ 23, 3326717 },
	{ 23, 3851005 },
	{ 24, 16638969 },
	{ 24, 16376825 },
	{ 24, 15590393 },
	{ 24, 15328249 },
	{ 24, 8250361 },
	{ 24, 7988217 },
	{ 24, 7201785 },
	{ 24, 6939641 },
	{ 23, 4056057 },
	{ 23, 3793913 },
	{ 23, 3007481 },
	{ 23, 2745337 },
	{ 22, 1958905 },
	{ 22, 1696761 },
	{ 22, 910329 },
	{ 21, 701437 },
	{ 20, 386041 },
	{ 20, 123897 },
	{ 21, 656377 },
	{ 20, 476153 },
	{ 22, 1606649 },
	{ 22, 836601 },
	{ 22, 623609 },
	{ 20, 377849 },
	{ 21, 164857 },
	{ 15, 7146 },
	{ 21, 181245 },
	{ 21, 705533 },
	{ 23, 1229821 },
	{ 23, 1754109 },
	{ 23, 3326973 },
	{ 23, 3851261 },
	{ 24, 16643837 },
	{ 24, 16623353 },
	{ 24, 16361209 },
	{ 24, 15574777 },
	{ 24, 15312633 },
	{ 24, 8234745 },
	{ 24, 7972601 },
	{ 24, 7186169 },
	{ 23, 4060925 },
	{ 23, 4040441 },
	{ 23, 3778297 },
	{ 23, 2991865 },
	{ 22, 1963773 },
	{ 22, 1943289 },
	{ 22, 1681145 },
	{ 22, 894713 },
	{ 20, 390909 },
	{ 20, 370425 },
	{ 20, 108281 },
	{ 20, 460537 },
	{ 20, 411385 },
	{ 22, 820985 },
	{ 22, 575225 },
	{ 20, 362233 },
	{ 20, 116473 },
	{ 15, 11114 },
	{ 21, 165629 },
	{ 21, 689917 },
	{ 23, 1214205 },
	{ 23, 1738493 },
	{ 23, 3311357 },
	{ 23, 3835645 },
	{ 24, 5408509 },
	{ 24, 16623609 },
	{ 24, 16361465 },
	{ 24, 15575033 },
	{ 24, 15312889 },
	{ 24, 8235001 },
	{ 24, 7972857 },
	{ 24, 7186425 },
	{ 23, 4061181 },
	{ 23, 4040697 },
	{ 23, 3778553 },
	{ 23, 2992121 },
	{ 22, 1964029 },
	{ 22, 1943545 },
	{ 22, 1681401 },
	{ 22, 894969 },
	{ 20, 391165 },
	{ 20, 370681 },
	{ 20, 108537 },
	{ 20, 460793 },
	{ 20, 411641 },
	{ 22, 821241 },
	{ 22, 575481 },
	{ 20, 362489 },
	{ 20, 116729 },
	{ 15, 15210 },
	{ 21, 165885 },
	{ 21, 690173 },
	{ 23, 1214461 },
	{ 23, 1738749 },
	{ 23, 3311613 },
	{ 23, 3835901 },
	{ 24, 5408765 },
	{ 24, 5933053 },
	{ 24, 7505917 },
	{ 24, 8030205 },
	{ 25, 13797373 },
	{ 25, 14321661 },
	{ 25, 15894525 },
	{ 25, 16418813 },
	{ 25, 30574589 },
	{ 25, 16173821 },
	{ 25, 15960825 },
	{ 25, 14912249 },
	{ 25, 11766521 },
	{ 24, 7785213 },
	{ 24, 7572217 },
	{ 24, 6523641 },
	{ 24, 3377913 },
	{ 22, 1493757 },
	{ 22, 1280761 },
	{ 22, 232185 },
	{ 22, 1575673 },
	{ 22, 854777 },
	{ 24, 2231033 },
	{ 22, 1247993 },
	{ 22, 396025 },
	{ 17, 18922 },
	{ 22, 461565 },
	{ 22, 1510141 },
	{ 24, 2558717 },
	{ 24, 3607293 },
	{ 24, 6753021 },
	{ 24, 7801597 },
	{ 25, 10947325 },
	{ 25, 11995901 },
	{ 25, 15141629 },
	{ 25, 16190205 },
	{ 26, 62098425 },
	{ 26, 61049849 },
	{ 26, 32738297 },
	{ 26, 31689721 },
	{ 26, 28543993 },
	{ 25, 16174077 },
	{ 25, 15961081 },
	{ 25, 14912505 },
	{ 25, 11766777 },
	{ 24, 7785469 },
	{ 24, 7572473 },
	{ 24, 6523897 },
	{ 24, 3378169 },
	{ 22, 1494013 },
	{ 22, 1281017 },
	{ 22, 232441 },
	{ 22, 1575929 },
	{ 22, 855033 },
	{ 24, 2231289 },
	{ 22, 1248249 },
	{ 22, 396281 },
	{ 17, 23018 },
	{ 22, 461821 },
	{ 22, 1510397 },
	{ 24, 2558973 },
	{ 24, 3607549 },
	{ 24, 6753277 },
	{ 24, 7801853 },
	{ 25, 10947581 },
	{ 25, 11996157 },
	{ 25, 15141885 },
	{ 25, 16190461 },
	{ 26, 65179385 },
	{ 26, 62033657 },
	{ 26, 60985081 },
	{ 26, 32673529 },
	{ 26, 31624953 },
	{ 26, 28479225 },
	{ 25, 15978237 },
	{ 25, 15896313 },
	{ 25, 14847737 },
	{ 25, 11702009 },
	{ 24, 7589629 },
	{ 24, 7507705 },
	{ 24, 6459129 },
	{ 24, 3313401 },
	{ 22, 1298173 },
	{ 22, 1216249 },
	{ 22, 167673 },
	{ 22, 790265 },
	{ 22, 593657 },
	{ 22, 1183481 },
	{ 22, 200441 },
	{ 17, 26986 },
	{ 22, 397053 },
	{ 22, 1445629 },
	{ 24, 2494205 },
	{ 24, 3542781 },
	{ 24, 6688509 },
	{ 24, 7737085 },
	{ 25, 10882813 },
	{ 25, 11931389 },
	{ 25, 15077117 },
	{ 25, 16125693 },
	{ 26, 65179641 },
	{ 26, 62033913 },
	{ 26, 60985337 },
	{ 26, 32673785 },
	{ 26, 31625209 },
	{ 26, 28479481 },
	{ 25, 15978493 },
	{ 25, 15896569 },
	{ 25, 14847993 },
	{ 25, 11702265 },
	{ 24, 7589885 },
	{ 24, 7507961 },
	{ 24, 6459385 },
	{ 24, 3313657 },
	{ 22, 1298429 },
	{ 22, 1216505 },
	{ 22, 167929 },
	{ 22, 790521 },
	{ 22, 593913 },
	{ 22, 1183737 },
	{ 22, 200697 },
	{ 17, 31082 },
	{ 22, 397309 },
	{ 22, 1445885 },
	{ 24, 2494461 },
	{ 24, 3543037 },
	{ 24, 6688765 },
	{ 24, 7737341 },
	{ 25, 10883069 },
	{ 25, 11931645 },
	{ 25, 15077373 },
	{ 25, 16125949 },
	{ 24, 16620281 },
	{ 24, 16358137 },
	{ 24, 15571705 },
	{ 24, 15309561 },
	{ 24, 8231673 },
	{ 24, 7969529 },
	{ 24, 7183097 },
	{ 24, 6920953 },
	{ 23, 4037369 },
	{ 23, 3775225 },
	{ 23, 2988793 },
	{ 23, 2726649 },
	{ 22, 1940217 },
	{ 22, 1678073 },
	{ 22, 891641 },
	{ 22, 629497 },
	{ 20, 367353 },
	{ 20, 105209 },
	{ 22, 531193 },
	{ 20, 334585 },
	{ 22, 137977 },
	{ 15, 13034 },
	{ 22, 203517 },
	{ 22, 1252093 },
	{ 24, 2300669 },
	{ 24, 3349245 },
	{ 24, 6494973 },
	{ 24, 7543549 },
	{ 25, 10689277 },
	{ 25, 11737853 },
	{ 25, 14883581 },
	{ 25, 15932157 },
	{ 24, 16620537 },
	{ 24, 16358393 },
	{ 24, 15571961 },
	{ 24, 15309817 },
	{ 24, 8231929 },
	{ 24, 7969785 },
	{ 24, 7183353 },
	{ 24, 6921209 },
	{ 23, 4037625 },
	{ 23, 3775481 },
	{ 23, 2989049 },
	{ 23, 2726905 },
	{ 22, 1940473 },
	{ 22, 1678329 },
	{ 22, 891897 },
	{ 22, 629753 },
	{ 20, 367609 },
	{ 20, 105465 },
	{ 22, 531449 },
	{ 20, 334841 },
	{ 22, 138233 },
	{ 15, 14058 },
	{ 22, 203773 },
	{ 22, 1252349 },
	{ 24, 2300925 },
	{ 24, 3349501 },
	{ 24, 6495229 },
	{ 24, 7543805 },
	{ 25, 10689533 },
	{ 25, 11738109 },
	{ 25, 14883837 },
	{ 25, 15932413 },
	{ 24, 16637693 },
	{ 24, 16555769 },
	{ 24, 16293625 },
	{ 24, 15507193 },
	{ 24, 15245049 },
	{ 24, 8167161 },
	{ 24, 7905017 },
	{ 24, 7118585 },
	{ 23, 4054781 },
	{ 23, 3972857 },
	{ 23, 3710713 },
	{ 23, 2924281 },
	{ 22, 1957629 },
	{ 22, 1875705 },
	{ 22, 1613561 },
	{ 22, 827129 },
	{ 20, 384765 },
	{ 20, 302841 },
	{ 20, 40697 },
	{ 16, 30073 },
	{ 17, 64953 },
	{ 15, 14954 },
	{ 22, 139005 },
	{ 22, 1187581 },
	{ 24, 2236157 },
	{ 24, 3284733 },
	{ 24, 6430461 },
	{ 24, 7479037 },
	{ 25, 10624765 },
	{ 25, 11673341 },
	{ 25, 14819069 },
	{ 25, 15867645 },
	{ 24, 16637949 },
	{ 24, 16556025 },
	{ 24, 16293881 },
	{ 24, 15507449 },
	{ 24, 15245305 },
	{ 24, 8167417 },
	{ 24, 7905273 },
	{ 24, 7118841 },
	{ 23, 4055037 },
	{ 23, 3973113 },
	{ 23, 3710969 },
	{ 23, 2924537 },
	{ 22, 1957885 },
	{ 22, 1875961 },
	{ 22, 1613817 },
	{ 22, 827385 },
	{ 20, 385021 },
	{ 20, 303097 },
	{ 20, 40953 },
	{ 16, 32121 },
	{ 16, 32441 },
	{ 15, 15978 },
	{ 22, 139261 },
	{ 22, 1187837 },
	{ 24, 2236413 },
	{ 24, 3284989 },
	{ 24, 6430717 },
	{ 24, 7479293 },
	{ 25, 10625021 },
	{ 25, 11673597 },
	{ 25, 14819325 },
	{ 25, 15867901 },
	{ 26, 27402237 },
	{ 26, 66267901 },
	{ 26, 65219325 },
	{ 26, 62073597 },
	{ 26, 61025021 },
	{ 26, 32713469 },
	{ 26, 31664893 },
	{ 26, 28519165 },
	{ 26, 27470589 },
	{ 25, 15936253 },
	{ 25, 14887677 },
	{ 25, 11741949 },
	{ 25, 10693373 },
	{ 24, 7547645 },
	{ 24, 6499069 },
	{ 24, 3353341 },
	{ 24, 2304765 },
	{ 22, 1256189 },
	{ 22, 207613 },
	{ 16, 32745 },
	{ 14, 8105 },
	{ 15, 16218 },
	{ 18, 130493 },
	{ 22, 1321725 },
	{ 24, 2370301 },
	{ 24, 3418877 },
	{ 24, 6564605 },
	{ 24, 7613181 },
	{ 25, 10758909 },
	{ 25, 11807485 },
	{ 25, 14953213 },
	{ 25, 16001789 },
	{ 26, 27536125 },
	{ 26, 28584701 },
	{ 26, 31730429 },
	{ 26, 32779005 },
	{ 26, 61090557 },
	{ 26, 62139133 },
	{ 26, 65284861 },
	{ 26, 66333437 },
	{ 26, 27470845 },
	{ 25, 15936509 },
	{ 25, 14887933 },
	{ 25, 11742205 },
	{ 25, 10693629 },
	{ 24, 7547901 },
	{ 24, 6499325 },
	{ 24, 3353597 },
	{ 24, 2305021 },
	{ 22, 1256445 },
	{ 22, 207869 },
	{ 16, 32569 },
	{ 13, 4041 },
	{ 15, 16346 },
	{ 17, 65213 },
	{ 22, 1321981 },
	{ 24, 2370557 },
	{ 24, 3419133 },
	{ 24, 6564861 },
	{ 24, 7613437 },
	{ 25, 10759165 },
	{ 25, 11807741 },
	{ 25, 14953469 },
	{ 25, 16002045 },
	{ 26, 27536381 },
	{ 26, 28584957 },
	{ 26, 31730685 },
	{ 26, 66137853 },
	{ 26, 65089277 },
	{ 26, 61943549 },
	{ 26, 60894973 },
	{ 26, 32583421 },
	{ 26, 31534845 },
	{ 26, 28389117 },
	{ 26, 27340541 },
	{ 25, 15806205 },
	{ 25, 14757629 },
	{ 25, 11611901 },
	{ 25, 10563325 },
	{ 24, 7417597 },
	{ 24, 6369021 },
	{ 24, 3223293 },
	{ 24, 2174717 },
	{ 17, 46973 },
	{ 14, 8157 },
	{ 24, 109567 },
	{ 15, 16301 },
	{ 17, 46461 },
	{ 24, 2109181 },
	{ 24, 3157757 },
	{ 24, 6303485 },
	{ 24, 7352061 },
	{ 25, 10497789 },
	{ 25, 11546365 },
	{ 25, 14692093 },
	{ 25, 15740669 },
	{ 26, 27275005 },
	{ 26, 28323581 },
	{ 26, 31469309 },
	{ 26, 32517885 },
	{ 26, 60829437 },
	{ 26, 61878013 },
	{ 26, 65023741 },
	{ 26, 66072317 },
	{ 26, 31535101 },
	{ 26, 28389373 },
	{ 26, 27340797 },
	{ 25, 15806461 },
	{ 25, 14757885 },
	{ 25, 11612157 },
	{ 25, 10563581 },
	{ 24, 7417853 },
	{ 24, 6369277 },
	{ 24, 3223549 },
	{ 24, 2174973 },
	{ 17, 49021 },
	{ 17, 65389 },
	{ 13, 2698 },
	{ 14, 8141 },
	{ 17, 48509 },
	{ 24, 2109437 },
	{ 24, 3158013 },
	{ 24, 6303741 },
	{ 24, 7352317 },
	{ 25, 10498045 },
	{ 25, 11546621 },
	{ 25, 14692349 },
	{ 25, 15740925 },
	{ 26, 27275261 },
	{ 26, 28323837 },
	{ 26, 31469565 },
	{ 26, 66403069 },
	{ 26, 65354493 },
	{ 26, 62208765 },
	{ 26, 61160189 },
	{ 26, 32848637 },
	{ 26, 31800061 },
	{ 26, 28654333 },
	{ 26, 27605757 },
	{ 25, 16071421 },
	{ 25, 15022845 },
	{ 25, 11877117 },
	{ 25, 10828541 },
	{ 24, 7682813 },
	{ 24, 6634237 },
	{ 24, 3488509 },
	{ 24, 2439933 },
	{ 22, 1391357 },
	{ 19, 261757 },
	{ 13, 2762 },
	{ 15, 16345 },
	{ 18, 131053 },
	{ 22, 146173 },
	{ 22, 408317 },
	{ 23, 2555903 },
	{ 24, 932605 },
	{ 24, 1719037 },
	{ 24, 1981181 },
	{ 25, 2767613 },
	{ 25, 3029757 },
	{ 25, 3816189 },
	{ 25, 4078333 },
	{ 26, 6961917 },
	{ 26, 7224061 },
	{ 26, 8010493 },
	{ 26, 8272637 },
	{ 26, 15350525 },
	{ 26, 15612669 },
	{ 26, 16399101 },
	{ 26, 16661245 },
	{ 26, 27606013 },
	{ 25, 16071677 },
	{ 25, 15023101 },
	{ 25, 11877373 },
	{ 25, 10828797 },
	{ 24, 7683069 },
	{ 24, 6634493 },
	{ 24, 3488765 },
	{ 24, 2440189 },
	{ 22, 1391613 },
	{ 20, 524221 },
	{ 18, 130874 },
	{ 18, 130921 },
	{ 18, 130877 },
	{ 22, 146429 },
	{ 22, 408573 },
	{ 23, 2555647 },
	{ 24, 932861 },
	{ 24, 1719293 },
	{ 24, 1981437 },
	{ 25, 2767869 },
	{ 25, 3030013 },
	{ 25, 3816445 },
	{ 25, 4078589 },
	{ 26, 6962173 },
	{ 26, 7224317 },
	{ 26, 8010749 },
	{ 26, 8272893 },
	{ 26, 15350781 },
	{ 26, 15612925 },
	{ 26, 16399357 },
	{ 26, 16661501 },
	{ 27, 132579071 },
	{ 27, 63520509 },
	{ 27, 59326205 },
	{ 27, 46743293 },
	{ 27, 42548989 },
	{ 26, 29966077 },
	{ 26, 25771773 },
	{ 26, 13188861 },
	{ 26, 8994557 },
	{ 24, 4800253 },
	{ 24, 605949 },
	{ 16, 31258 },
	{ 20, 523897 },
	{ 17, 63353 },
	{ 22, 212729 },
	{ 22, 474873 },
	{ 22, 1457917 },
	{ 23, 3079167 },
	{ 24, 1785593 },
	{ 24, 2047737 },
	{ 24, 6176509 },
	{ 25, 3096313 },
	{ 25, 3882745 },
	{ 25, 4144889 },
	{ 25, 12467965 },
	{ 26, 7290617 },
	{ 26, 8077049 },
	{ 26, 8339193 },
	{ 26, 15417081 },
	{ 26, 15679225 },
	{ 26, 16465657 },
	{ 26, 16727801 },
	{ 26, 33439485 },
	{ 27, 63520765 },
	{ 27, 59326461 },
	{ 27, 46743549 },
	{ 27, 42549245 },
	{ 26, 29966333 },
	{ 26, 25772029 },
	{ 26, 13189117 },
	{ 26, 8994813 },
	{ 24, 4800509 },
	{ 24, 606205 },
	{ 16, 32282 },
	{ 21, 1048505 },
	{ 17, 65401 },
	{ 22, 212985 },
	{ 22, 475129 },
	{ 22, 1458173 },
	{ 23, 3078911 },
	{ 24, 1785849 },
	{ 24, 2047993 },
	{ 24, 6176765 },
	{ 25, 3096569 },
	{ 25, 3883001 },
	{ 25, 4145145 },
	{ 25, 12468221 },
	{ 26, 7290873 },
	{ 26, 8077305 },
	{ 26, 8339449 },
	{ 26, 15417337 },
	{ 26, 15679481 },
	{ 26, 16465913 },
	{ 26, 16728057 },
	{ 26, 33439741 },
	{ 27, 63793917 },
	{ 27, 59599613 },
	{ 27, 47016701 },
	{ 27, 42822397 },
	{ 26, 30239485 },
	{ 26, 26045181 },
	{ 26, 13462269 },
	{ 26, 9267965 },
	{ 24, 5073661 },
	{ 24, 879357 },
	{ 17, 53914 },
	{ 24, 617209 },
	{ 22, 1403641 },
	{ 23, 2682875 },
	{ 22, 1272569 },
	{ 22, 1534713 },
	{ 23, 2945019 },
	{ 24, 5204729 },
	{ 24, 5991161 },
	{ 24, 6253305 },
	{ 25, 11234041 },
	{ 25, 11496185 },
	{ 25, 12282617 },
	{ 25, 12544761 },
	{ 26, 23816953 },
	{ 26, 24079097 },
	{ 26, 24865529 },
	{ 26, 25127673 },
	{ 26, 32205561 },
	{ 26, 32467705 },
	{ 26, 33254137 },
	{ 26, 33516281 },
	{ 27, 63794173 },
	{ 27, 59599869 },
	{ 27, 47016957 },
	{ 27, 42822653 },
	{ 26, 30239741 },
	{ 26, 26045437 },
	{ 26, 13462525 },
	{ 26, 9268221 },
	{ 24, 5073917 },
	{ 24, 879613 },
	{ 17, 54938 },
	{ 24, 617465 },
	{ 22, 1403897 },
	{ 23, 2682619 },
	{ 22, 1272825 },
	{ 22, 1534969 },
	{ 23, 2944763 },
	{ 24, 5204985 },
	{ 24, 5991417 },
	{ 24, 6253561 },
	{ 25, 11234297 },
	{ 25, 11496441 },
	{ 25, 12282873 },
	{ 25, 12545017 },
	{ 26, 23817209 },
	{ 26, 24079353 },
	{ 26, 24865785 },
	{ 26, 25127929 },
	{ 26, 32205817 },
	{ 26, 32467961 },
	{ 26, 33254393 },
	{ 26, 33516537 },
	{ 27, 64581373 },
	{ 27, 60387069 },
	{ 27, 47804157 },
	{ 27, 43609853 },
	{ 26, 31026941 },
	{ 26, 26832637 },
	{ 26, 14249725 },
	{ 26, 10055421 },
	{ 24, 5861117 },
	{ 24, 1666813 },
	{ 19, 223514 },
	{ 24, 880377 },
	{ 24, 4812537 },
	{ 24, 2453241 },
	{ 24, 3239673 },
	{ 24, 2322169 },
	{ 24, 2584313 },
	{ 24, 3567357 },
	{ 25, 10415103 },
	{ 26, 10186489 },
	{ 26, 10448633 },
	{ 26, 14577405 },
	{ 27, 19885817 },
	{ 27, 20672249 },
	{ 27, 20934393 },
	{ 27, 29257469 },
	{ 28, 40857337 },
	{ 28, 41643769 },
	{ 28, 41905913 },
	{ 28, 48983801 },
	{ 28, 49245945 },
	{ 28, 50032377 },
	{ 27, 64581629 },
	{ 27, 60387325 },
	{ 27, 47804413 },
	{ 27, 43610109 },
	{ 26, 31027197 },
	{ 26, 26832893 },
	{ 26, 14249981 },
	{ 26, 10055677 },
	{ 24, 5861373 },
	{ 24, 1667069 },
	{ 19, 227610 },
	{ 24, 880633 },
	{ 24, 4812793 },
	{ 24, 2453497 },
	{ 24, 3239929 },
	{ 24, 2322425 },
	{ 24, 2584569 },
	{ 24, 3567613 },
	{ 25, 10414847 },
	{ 26, 10186745 },
	{ 26, 10448889 },
	{ 26, 14577661 },
	{ 27, 19886073 },
	{ 27, 20672505 },
	{ 27, 20934649 },
	{ 27, 29257725 },
	{ 28, 40857593 },
	{ 28, 41644025 },
	{ 28, 41906169 },
	{ 28, 48984057 },
	{ 28, 49246201 },
	{ 28, 50032633 },
	{ 27, 64846589 },
	{ 27, 60652285 },
	{ 27, 48069373 },
	{ 27, 43875069 },
	{ 26, 31292157 },
	{ 26, 27097853 },
	{ 26, 14514941 },
	{ 26, 10320637 },
	{ 24, 6126333 },
	{ 24, 1932029 },
	{ 19, 248218 },
	{ 19, 522734 },
	{ 24, 5077753 },
	{ 25, 10010619 },
	{ 24, 3504889 },
	{ 24, 6388473 },
	{ 24, 3373817 },
	{ 24, 3635961 },
	{ 24, 6716157 },
	{ 25, 11976703 },
	{ 26, 14383865 },
	{ 26, 14646009 },
	{ 26, 27163389 },
	{ 27, 28277497 },
	{ 27, 29063929 },
	{ 27, 29326073 },
	{ 27, 54426365 },
	{ 28, 57637625 },
	{ 28, 58424057 },
	{ 28, 58686201 },
	{ 28, 65764089 },
	{ 28, 66026233 },
	{ 27, 64846845 },
	{ 27, 60652541 },
	{ 27, 48069629 },
	{ 27, 43875325 },
	{ 26, 31292413 },
	{ 26, 27098109 },
	{ 26, 14515197 },
	{ 26, 10320893 },
	{ 24, 6126589 },
	{ 24, 1932285 },
	{ 19, 252314 },
	{ 19, 518638 },
	{ 24, 5078009 },
	{ 25, 10010363 },
	{ 24, 3505145 },
	{ 24, 6388729 },
	{ 24, 3374073 },
	{ 24, 3636217 },
	{ 24, 6716413 },
	{ 25, 11976447 },
	{ 26, 14384121 },
	{ 26, 14646265 },
	{ 26, 27163645 },
	{ 27, 28277753 },
	{ 27, 29064185 },
	{ 27, 29326329 },
	{ 27, 54426621 },
	{ 28, 57637881 },
	{ 28, 58424313 },
	{ 28, 58686457 },
	{ 28, 65764345 },
	{ 28, 66026489 },
	{ 28, 66812921 },
	{ 28, 67075065 },
	{ 28, 94994173 },
	{ 28, 86605565 },
	{ 27, 61439741 },
	{ 27, 53051133 },
	{ 27, 27885309 },
	{ 27, 19496701 },
	{ 25, 11108093 },
	{ 25, 2719485 },
	{ 19, 256794 },
	{ 19, 514926 },
	{ 24, 5865209 },
	{ 25, 11582459 },
	{ 26, 13205241 },
	{ 24, 6651641 },
	{ 24, 7438073 },
	{ 24, 6520569 },
	{ 24, 6782713 },
	{ 24, 7765757 },
	{ 25, 12499967 },
	{ 26, 26967801 },
	{ 26, 27229945 },
	{ 26, 31358717 },
	{ 27, 53444345 },
	{ 27, 54230777 },
	{ 27, 54492921 },
	{ 27, 62815997 },
	{ 28, 107970297 },
	{ 28, 108756729 },
	{ 28, 109018873 },
	{ 28, 116096761 },
	{ 28, 116358905 },
	{ 28, 117145337 },
	{ 28, 117407481 },
	{ 28, 134119165 },
	{ 27, 61439997 },
	{ 27, 53051389 },
	{ 27, 27885565 },
	{ 27, 19496957 },
	{ 25, 11108349 },
	{ 25, 2719741 },
	{ 19, 260890 },
	{ 19, 510830 },
	{ 24, 5865465 },
	{ 25, 11582203 },
	{ 26, 13205497 },
	{ 24, 6651897 },
	{ 24, 7438329 },
	{ 24, 6520825 },
	{ 24, 6782969 },
	{ 24, 7766013 },
	{ 25, 12499711 },
	{ 26, 26968057 },
	{ 26, 27230201 },
	{ 26, 31358973 },
	{ 27, 53444601 },
	{ 27, 54231033 },
	{ 27, 54493177 },
	{ 27, 62816253 },
	{ 28, 107970553 },
	{ 28, 108756985 },
	{ 28, 109019129 },
	{ 28, 116097017 },
	{ 28, 116359161 },
	{ 28, 117145593 },
	{ 28, 117407737 },
	{ 28, 134119421 },
	{ 28, 123382525 },
	{ 28, 106605309 },
	{ 28, 56273661 },
	{ 28, 39496445 },
	{ 26, 22719229 },
	{ 26, 5942013 },
	{ 19, 478106 },
	{ 19, 490478 },
	{ 25, 12233465 },
	{ 25, 12103675 },
	{ 27, 26913529 },
	{ 27, 51555065 },
	{ 25, 15379193 },
	{ 25, 15249403 },
	{ 25, 15117049 },
	{ 25, 15641337 },
	{ 25, 12365819 },
	{ 26, 22458367 },
	{ 27, 62302969 },
	{ 27, 62827257 },
	{ 27, 62697467 },
	{ 28, 123644665 },
	{ 28, 125217529 },
	{ 28, 125741817 },
	{ 28, 129806331 },
	{ 29, 249473785 },
	{ 29, 251046649 },
	{ 29, 251570937 },
	{ 29, 265726713 },
	{ 29, 266251001 },
	{ 29, 267823865 },
	{ 29, 268348153 },
	{ 28, 123382781 },
	{ 28, 106605565 },
	{ 28, 56273917 },
	{ 28, 39496701 },
	{ 26, 22719485 },
	{ 26, 5942269 },
	{ 19, 482202 },
	{ 19, 486382 },
	{ 25, 12233721 },
	{ 25, 12103419 },
	{ 27, 26913785 },
	{ 27, 51555321 },
	{ 25, 15379449 },
	{ 25, 15249147 },
	{ 25, 15117305 },
	{ 25, 15641593 },
	{ 25, 12365563 },
	{ 26, 22458111 },
	{ 27, 62303225 },
	{ 27, 62827513 },
	{ 27, 62697211 },
	{ 28, 123644921 },
	{ 28, 125217785 },
	{ 28, 125742073 },
	{ 28, 129806075 },
	{ 29, 249474041 },
	{ 29, 251046905 },
	{ 29, 251571193 },
	{ 29, 265726969 },
	{ 29, 266251257 },
	{ 29, 267824121 },
	{ 29, 268348409 },
	{ 28, 124956413 },
	{ 28, 108179197 },
	{ 28, 57847549 },
	{ 28, 41070333 },
	{ 26, 24293117 },
	{ 26, 7515901 },
	{ 20, 972058 },
	{ 20, 963950 },
	{ 26, 22195961 },
	{ 26, 22064123 },
	{ 27, 28487417 },
	{ 27, 52080377 },
	{ 27, 59944697 },
	{ 26, 21671673 },
	{ 26, 23244537 },
	{ 26, 21409529 },
	{ 26, 21933817 },
	{ 26, 23899901 },
	{ 26, 22981631 },
	{ 28, 87469817 },
	{ 28, 87994105 },
	{ 28, 96251645 },
	{ 28, 123644927 },
	{ 29, 175550201 },
	{ 29, 176074489 },
	{ 29, 192720637 },
	{ 29, 257862655 },
	{ 30, 351710969 },
	{ 29, 259174397 },
	{ 29, 242397181 },
	{ 29, 192065533 },
	{ 29, 175288317 },
	{ 28, 124956669 },
	{ 28, 108179453 },
	{ 28, 57847805 },
	{ 28, 41070589 },
	{ 26, 24293373 },
	{ 26, 7516157 },
	{ 20, 980250 },
	{ 20, 955758 },
	{ 26, 22196217 },
	{ 26, 22063867 },
	{ 27, 28487673 },
	{ 27, 52080633 },
	{ 27, 59944953 },
	{ 26, 21671929 },
	{ 26, 23244793 },
	{ 26, 21409785 },
	{ 26, 21934073 },
	{ 26, 23900157 },
	{ 26, 22981375 },
	{ 28, 87470073 },
	{ 28, 87994361 },
	{ 28, 96251901 },
	{ 28, 123644671 },
	{ 29, 175550457 },
	{ 29, 176074745 },
	{ 29, 192720893 },
	{ 29, 257862399 },
	{ 29, 230457343 },
	{ 29, 259701501 },
	{ 28, 129794047 },
	{ 28, 121405439 },
	{ 28, 96239615 },
	{ 28, 125483773 },
	{ 27, 62685183 },
	{ 27, 54296575 },
	{ 27, 29130751 },
	{ 26, 24820477 },
	{ 25, 12353535 },
	{ 20, 1021338 },
	{ 20, 521710 },
	{ 25, 3702779 },
	{ 25, 11304955 },
	{ 27, 29014777 },
	{ 26, 14450683 },
	{ 26, 26771451 },
	{ 26, 30179323 },
	{ 26, 23771897 },
	{ 25, 11829243 },
	{ 25, 14712827 },
	{ 25, 3047419 },
	{ 25, 11436027 },
	{ 25, 12287999 },
	{ 27, 28213243 },
	{ 27, 53379067 },
	{ 27, 61767675 },
	{ 27, 62619647 },
	{ 28, 95322107 },
	{ 28, 120487931 },
	{ 28, 128876539 },
	{ 28, 129728511 },
	{ 29, 259701757 },
	{ 28, 129793791 },
	{ 28, 121405183 },
	{ 28, 96239359 },
	{ 28, 125484029 },
	{ 27, 62684927 },
	{ 27, 54296319 },
	{ 27, 29130495 },
	{ 26, 24820733 },
	{ 25, 12353279 },
	{ 20, 1029530 },
	{ 20, 513518 },
	{ 25, 3702523 },
	{ 25, 11304699 },
	{ 27, 29015033 },
	{ 26, 14450427 },
	{ 26, 26771195 },
	{ 26, 30179067 },
	{ 26, 23772153 },
	{ 25, 11828987 },
	{ 25, 14712571 },
	{ 25, 3047163 },
	{ 25, 11435771 },
	{ 25, 12287743 },
	{ 27, 28212987 },
	{ 27, 53378811 },
	{ 27, 61767419 },
	{ 27, 62619391 },
	{ 28, 95321851 },
	{ 28, 120487675 },
	{ 28, 128876283 },
	{ 28, 129728255 },
	{ 29, 229539579 },
	{ 29, 254705403 },
	{ 29, 263094011 },
	{ 29, 489586427 },
	{ 29, 267959289 },
	{ 28, 134053627 },
	{ 28, 107510783 },
	{ 28, 57179135 },
	{ 27, 47365885 },
	{ 26, 23624703 },
	{ 20, 1038106 },
	{ 20, 505710 },
	{ 25, 3963899 },
	{ 25, 12090363 },
	{ 27, 19692539 },
	{ 27, 54181625 },
	{ 26, 27032571 },
	{ 26, 30964731 },
	{ 27, 42761211 },
	{ 26, 30064377 },
	{ 25, 14973947 },
	{ 25, 15760379 },
	{ 25, 3832827 },
	{ 25, 12221435 },
	{ 25, 12549119 },
	{ 27, 28998651 },
	{ 27, 54164475 },
	{ 27, 62553083 },
	{ 27, 62880767 },
	{ 28, 96107515 },
	{ 28, 121273339 },
	{ 28, 129661947 },
	{ 28, 129989631 },
	{ 29, 230325243 },
	{ 29, 255491067 },
	{ 29, 263879675 },
	{ 29, 267435769 },
	{ 28, 133790715 },
	{ 28, 117275643 },
	{ 28, 57178879 },
	{ 27, 47366141 },
	{ 26, 23624447 },
	{ 20, 1046298 },
	{ 20, 497518 },
	{ 25, 3963643 },
	{ 25, 12090107 },
	{ 27, 19692283 },
	{ 27, 54181881 },
	{ 26, 27032315 },
	{ 26, 30964475 },
	{ 27, 42760955 },
	{ 26, 30064633 },
	{ 25, 14973691 },
	{ 25, 15760123 },
	{ 25, 3832571 },
	{ 25, 12221179 },
	{ 25, 12548863 },
	{ 27, 28998395 },
	{ 27, 54164219 },
	{ 27, 62552827 },
	{ 27, 62880511 },
	{ 28, 96107259 },
	{ 28, 121273083 },
	{ 28, 129661691 },
	{ 28, 129989375 },
	{ 29, 230324987 },
	{ 29, 255490811 },
	{ 29, 263879419 },
	{ 29, 267436025 },
	{ 28, 133790459 },
	{ 28, 117275387 },
	{ 28, 57438207 },
	{ 27, 47901437 },
	{ 26, 23883775 },
	{ 26, 7106559 },
	{ 20, 456686 },
	{ 26, 24832761 },
	{ 25, 12349435 },
	{ 27, 20475899 },
	{ 27, 28078075 },
	{ 27, 62581497 },
	{ 26, 31223803 },
	{ 27, 43544571 },
	{ 27, 46952443 },
	{ 26, 32172793 },
	{ 25, 16019451 },
	{ 26, 31910649 },
	{ 25, 4091899 },
	{ 25, 12480507 },
	{ 26, 23818239 },
	{ 27, 29257723 },
	{ 27, 54423547 },
	{ 27, 62812155 },
	{ 28, 87977979 },
	{ 28, 96366587 },
	{ 28, 121532411 },
	{ 28, 129921019 },
	{ 29, 222195707 },
	{ 29, 230584315 },
	{ 29, 255750139 },
	{ 29, 265874169 },
	{ 28, 133001211 },
	{ 28, 117010427 },
	{ 28, 66940923 },
	{ 27, 47901693 },
	{ 26, 23883519 },
	{ 26, 7106303 },
	{ 20, 448494 },
	{ 26, 24833017 },
	{ 25, 12349179 },
	{ 27, 20475643 },
	{ 27, 28077819 },
	{ 27, 62581753 },
	{ 26, 31223547 },
	{ 27, 43544315 },
	{ 27, 46952187 },
	{ 26, 32173049 },
	{ 25, 16019195 },
	{ 26, 31910905 },
	{ 25, 4091643 },
	{ 25, 12480251 },
	{ 26, 23817983 },
	{ 27, 29257467 },
	{ 27, 54423291 },
	{ 27, 62811899 },
	{ 28, 87977723 },
	{ 28, 96366331 },
	{ 28, 121532155 },
	{ 28, 129920763 },
	{ 29, 222195451 },
	{ 29, 230584059 },
	{ 29, 255749883 },
	{ 29, 265874425 },
	{ 28, 133000955 },
	{ 28, 117010171 },
	{ 28, 66940667 },
	{ 27, 49475325 },
	{ 26, 24669183 },
	{ 26, 7891967 },
	{ 21, 879982 },
	{ 26, 7105531 },
	{ 26, 23620603 },
	{ 27, 20737019 },
	{ 27, 28863483 },
	{ 27, 53242875 },
	{ 27, 61369339 },
	{ 27, 43805691 },
	{ 27, 47737851 },
	{ 27, 59534331 },
	{ 27, 55242489 },
	{ 26, 27552763 },
	{ 26, 28339195 },
	{ 26, 6974459 },
	{ 26, 23751675 },
	{ 26, 24079359 },
	{ 28, 57306107 },
	{ 28, 107637755 },
	{ 28, 124414971 },
	{ 28, 124742655 },
	{ 29, 191523835 },
	{ 29, 241855483 },
	{ 29, 258632699 },
	{ 29, 242052091 },
	{ 29, 192506875 },
	{ 29, 265350905 },
	{ 28, 132738043 },
	{ 28, 116222971 },
	{ 28, 66677755 },
	{ 27, 49475581 },
	{ 26, 24668927 },
	{ 26, 7891711 },
	{ 21, 863598 },
	{ 26, 7105275 },
	{ 26, 23620347 },
	{ 27, 20736763 },
	{ 27, 28863227 },
	{ 27, 53242619 },
	{ 27, 61369083 },
	{ 27, 43805435 },
	{ 27, 47737595 },
	{ 27, 59534075 },
	{ 27, 55242745 },
	{ 26, 27552507 },
	{ 26, 28338939 },
	{ 26, 6974203 },
	{ 26, 23751419 },
	{ 26, 24079103 },
	{ 28, 57305851 },
	{ 28, 107637499 },
	{ 28, 124414715 },
	{ 28, 124742399 },
	{ 29, 191523579 },
	{ 29, 241855227 },
	{ 29, 258632443 },
	{ 29, 242051835 },
	{ 29, 192506619 },
	{ 29, 265351161 },
	{ 28, 132737787 },
	{ 28, 116222715 },
	{ 28, 66677499 },
	{ 27, 50002685 },
	{ 26, 24920063 },
	{ 26, 8142847 },
	{ 20, 519662 },
	{ 26, 7880699 },
	{ 26, 23871483 },
	{ 28, 58391289 },
	{ 27, 29114363 },
	{ 27, 54018043 },
	{ 27, 61620219 },
	{ 28, 96140025 },
	{ 27, 47988731 },
	{ 27, 60309499 },
	{ 27, 66910969 },
	{ 26, 66535419 },
	{ 26, 28590075 },
	{ 26, 31473659 },
	{ 26, 7225339 },
	{ 26, 24002555 },
	{ 26, 24854527 },
	{ 28, 57556987 },
	{ 28, 107888635 },
	{ 28, 124665851 },
	{ 28, 125517823 },
	{ 29, 259586809 },
	{ 28, 129843195 },
	{ 29, 258883579 },
	{ 29, 191709179 },
	{ 29, 251198201 },
	{ 28, 125648891 },
	{ 28, 115949563 },
	{ 28, 65880059 },
	{ 27, 66648825 },
	{ 26, 33374203 },
	{ 26, 8142591 },
	{ 20, 503278 },
	{ 26, 7880443 },
	{ 26, 23871227 },
	{ 28, 58391545 },
	{ 27, 29114107 },
	{ 27, 54017787 },
	{ 27, 61619963 },
	{ 28, 96140281 },
	{ 27, 47988475 },
	{ 27, 60309243 },
	{ 27, 66911225 },
	{ 26, 66535163 },
	{ 26, 28589819 },
	{ 26, 31473403 },
	{ 26, 7225083 },
	{ 26, 24002299 },
	{ 26, 24854271 },
	{ 28, 57556731 },
	{ 28, 107888379 },
	{ 28, 124665595 },
	{ 28, 125517567 },
	{ 29, 259587065 },
	{ 28, 129842939 },
	{ 29, 258883323 },
	{ 29, 191708923 },
	{ 29, 251198457 },
	{ 28, 125648635 },
	{ 28, 115949307 },
	{ 28, 65879803 },
	{ 27, 66649081 },
	{ 26, 33373947 },
	{ 26, 15219711 },
	{ 20, 487278 },
	{ 26, 8141819 },
	{ 26, 24656891 },
	{ 28, 40647675 },
	{ 28, 108723961 },
	{ 27, 54279163 },
	{ 27, 62405627 },
	{ 28, 86785019 },
	{ 28, 121306873 },
	{ 27, 60570619 },
	{ 27, 67043069 },
	{ 26, 66468863 },
	{ 26, 65485819 },
	{ 26, 31734779 },
	{ 26, 32521211 },
	{ 26, 8010747 },
	{ 26, 24787963 },
	{ 26, 25115647 },
	{ 28, 58342395 },
	{ 28, 108674043 },
	{ 28, 125451259 },
	{ 28, 125778943 },
	{ 28, 129580027 },
	{ 28, 121453563 },
	{ 29, 259668987 },
	{ 29, 250674937 },
	{ 28, 125385723 },
	{ 28, 108870651 },
	{ 28, 65616891 },
	{ 27, 66125561 },
	{ 26, 33111035 },
	{ 26, 16595963 },
	{ 20, 470894 },
	{ 26, 8141563 },
	{ 26, 24656635 },
	{ 28, 40647419 },
	{ 28, 108724217 },
	{ 27, 54278907 },
	{ 27, 62405371 },
	{ 28, 86784763 },
	{ 28, 121307129 },
	{ 27, 60570363 },
	{ 27, 67043325 },
	{ 26, 66468607 },
	{ 26, 65485563 },
	{ 26, 31734523 },
	{ 26, 32520955 },
	{ 26, 8010491 },
	{ 26, 24787707 },
	{ 26, 25115391 },
	{ 28, 58342139 },
	{ 28, 108673787 },
	{ 28, 125451003 },
	{ 28, 125778687 },
	{ 28, 129579771 },
	{ 28, 121453307 },
	{ 29, 259668731 },
	{ 29, 250675193 },
	{ 28, 125385467 },
	{ 28, 108870395 },
	{ 28, 65616635 },
	{ 27, 66125817 },
	{ 26, 33110779 },
	{ 26, 16595707 },
	{ 20, 389102 },
	{ 26, 15216635 },
	{ 26, 24915963 },
	{ 28, 41431035 },
	{ 28, 57421819 },
	{ 28, 107491323 },
	{ 27, 62664699 },
	{ 28, 87568379 },
	{ 28, 95170555 },
	{ 28, 120074235 },
	{ 27, 64761851 },
	{ 28, 133016317 },
	{ 26, 65417215 },
	{ 26, 62337019 },
	{ 26, 32780283 },
	{ 26, 60829691 },
	{ 26, 8269819 },
	{ 26, 25047035 },
	{ 26, 32190463 },
	{ 28, 58601467 },
	{ 28, 108933115 },
	{ 28, 125710331 },
	{ 28, 128790523 },
	{ 28, 121188347 },
	{ 28, 96284667 },
	{ 29, 259928059 },
	{ 28, 124596219 },
	{ 28, 108605435 },
	{ 28, 58535931 },
	{ 28, 129084153 },
	{ 26, 32321531 },
	{ 26, 16330747 },
	{ 20, 372718 },
	{ 26, 15216379 },
	{ 26, 24915707 },
	{ 28, 41430779 },
	{ 28, 57421563 },
	{ 28, 107491067 },
	{ 27, 62664443 },
	{ 28, 87568123 },
	{ 28, 95170299 },
	{ 28, 120073979 },
	{ 27, 64761595 },
	{ 28, 133016573 },
	{ 26, 65416959 },
	{ 26, 62336763 },
	{ 26, 32780027 },
	{ 26, 60829435 },
	{ 26, 8269563 },
	{ 26, 25046779 },
	{ 26, 32190207 },
	{ 28, 58601211 },
	{ 28, 108932859 },
	{ 28, 125710075 },
	{ 28, 128790267 },
	{ 28, 121188091 },
	{ 28, 96284411 },
	{ 29, 259927803 },
	{ 28, 124595963 },
	{ 28, 108605179 },
	{ 28, 58535675 },
	{ 28, 129084409 },
	{ 26, 32321275 },
	{ 26, 16330491 },
	{ 20, 359790 },
	{ 26, 15477755 },
	{ 26, 31992827 },
	{ 28, 41692155 },
	{ 28, 58207227 },
	{ 28, 107752443 },
	{ 28, 124267515 },
	{ 28, 87829499 },
	{ 28, 95955963 },
	{ 28, 120335355 },
	{ 28, 128461819 },
	{ 28, 110898171 },
	{ 28, 129871613 },
	{ 26, 62270463 },
	{ 26, 61287419 },
	{ 26, 61090811 },
	{ 26, 61877243 },
	{ 26, 15346683 },
	{ 26, 32123899 },
	{ 26, 32451583 },
	{ 28, 65678331 },
	{ 28, 116009979 },
	{ 28, 132787195 },
	{ 28, 120400891 },
	{ 28, 96021499 },
	{ 28, 87895035 },
	{ 28, 124333051 },
	{ 28, 107817979 },
	{ 28, 58272763 },
	{ 28, 128036601 },
	{ 26, 32058363 },
	{ 26, 15543291 },
	{ 20, 343406 },
	{ 26, 15477499 },
	{ 26, 31992571 },
	{ 28, 41691899 },
	{ 28, 58206971 },
	{ 28, 107752187 },
	{ 28, 124267259 },
	{ 28, 87829243 },
	{ 28, 95955707 },
	{ 28, 120335099 },
	{ 28, 128461563 },
	{ 28, 110897915 },
	{ 28, 129871869 },
	{ 26, 62270207 },
	{ 26, 61287163 },
	{ 26, 61090555 },
	{ 26, 61876987 },
	{ 26, 15346427 },
	{ 26, 32123643 },
	{ 26, 32451327 },
	{ 28, 65678075 },
	{ 28, 116009723 },
	{ 27, 67051519 },
	{ 27, 62857215 },
	{ 27, 50274303 },
	{ 27, 46079999 },
	{ 26, 33497087 },
	{ 26, 29302783 },
	{ 26, 16719871 },
	{ 26, 12525567 },
	{ 24, 8331263 },
	{ 24, 4136959 },
	{ 19, 261614 },
	{ 24, 4071419 },
	{ 24, 8069115 },
	{ 26, 12197883 },
	{ 26, 14622715 },
	{ 26, 27140091 },
	{ 26, 31137787 },
	{ 27, 43655163 },
	{ 26, 24059899 },
	{ 26, 30285819 },
	{ 26, 32186363 },
	{ 26, 33021947 },
	{ 26, 28778491 },
	{ 26, 31858683 },
	{ 24, 15310847 },
	{ 24, 8249339 },
	{ 24, 15540219 },
	{ 24, 16261115 },
	{ 24, 3907579 },
	{ 24, 8101883 },
	{ 24, 8314879 },
	{ 26, 16490491 },
	{ 25, 16211963 },
	{ 26, 33267707 },
	{ 26, 23814139 },
	{ 26, 21913595 },
	{ 25, 15687675 },
	{ 26, 26894331 },
	{ 26, 14376955 },
	{ 26, 10379259 },
	{ 24, 6250491 },
	{ 24, 3825659 },
	{ 19, 245230 },
	{ 24, 4071163 },
	{ 24, 8068859 },
	{ 26, 12197627 },
	{ 26, 14622459 },
	{ 26, 27139835 },
	{ 26, 31137531 },
	{ 27, 43654907 },
	{ 26, 24059643 },
	{ 26, 30285563 },
	{ 26, 32186107 },
	{ 26, 33021691 },
	{ 26, 28778235 },
	{ 26, 31858427 },
	{ 24, 15310591 },
	{ 24, 8249083 },
	{ 24, 15539963 },
	{ 24, 16260859 },
	{ 24, 3907323 },
	{ 24, 8101627 },
	{ 24, 8314623 },
	{ 26, 16490235 },
	{ 25, 16211707 },
	{ 26, 33267451 },
	{ 26, 23813883 },
	{ 26, 21913339 },
	{ 25, 15687419 },
	{ 26, 26894075 },
	{ 26, 14376699 },
	{ 26, 10379003 },
	{ 24, 6250235 },
	{ 24, 3825403 },
	{ 19, 229230 },
	{ 24, 4135931 },
	{ 24, 8264699 },
	{ 26, 12262395 },
	{ 26, 16391163 },
	{ 26, 27204603 },
	{ 26, 31333371 },
	{ 27, 43719675 },
	{ 27, 47848443 },
	{ 26, 30350331 },
	{ 26, 32381947 },
	{ 26, 33004543 },
	{ 26, 31972347 },
	{ 26, 31923195 },
	{ 26, 32906235 },
	{ 24, 8231935 },
	{ 24, 7986171 },
	{ 24, 16325627 },
	{ 24, 16522235 },
	{ 24, 4103163 },
	{ 24, 8297467 },
	{ 24, 8379391 },
	{ 25, 16145403 },
	{ 25, 15162363 },
	{ 26, 33463291 },
	{ 26, 21715963 },
	{ 25, 15621115 },
	{ 25, 13589499 },
	{ 26, 14310395 },
	{ 26, 10181627 },
	{ 24, 6183931 },
	{ 24, 2055163 },
	{ 19, 212846 },
	{ 24, 4135675 },
	{ 24, 8264443 },
	{ 26, 12262139 },
	{ 26, 16390907 },
	{ 26, 27204347 },
	{ 26, 31333115 },
	{ 27, 43719419 },
	{ 27, 47848187 },
	{ 26, 30350075 },
	{ 26, 32381691 },
	{ 26, 33004287 },
	{ 26, 31972091 },
	{ 26, 31922939 },
	{ 26, 32905979 },
	{ 24, 8231679 },
	{ 24, 7985915 },
	{ 24, 16325371 },
	{ 24, 16521979 },
	{ 24, 4102907 },
	{ 24, 8297211 },
	{ 24, 8379135 },
	{ 25, 16145147 },
	{ 25, 15162107 },
	{ 26, 33463035 },
	{ 26, 21715707 },
	{ 25, 15620859 },
	{ 25, 13589243 },
	{ 26, 14310139 },
	{ 26, 10181371 },
	{ 24, 6183675 },
	{ 24, 2054907 },
	{ 19, 131054 },
	{ 24, 3824383 },
	{ 24, 8327163 },
	{ 26, 12455931 },
	{ 26, 16453627 },
	{ 26, 28971003 },
	{ 26, 31395835 },
	{ 27, 43913211 },
	{ 27, 47910907 },
	{ 27, 60428283 },
	{ 26, 32444411 },
	{ 27, 55447547 },
	{ 26, 31952895 },
	{ 26, 28823547 },
	{ 26, 32968699 },
	{ 26, 61214715 },
	{ 24, 7966719 },
	{ 24, 7196667 },
	{ 24, 16584699 },
	{ 24, 7884795 },
	{ 24, 4165627 },
	{ 24, 8359931 },
	{ 25, 15945723 },
	{ 25, 15093755 },
	{ 25, 12013563 },
	{ 26, 33525755 },
	{ 25, 15421435 },
	{ 25, 13520891 },
	{ 25, 7294971 },
	{ 26, 10113019 },
	{ 24, 5984251 },
	{ 24, 1986555 },
	{ 19, 114670 },
	{ 24, 2052095 },
	{ 24, 8326907 },
	{ 26, 12455675 },
	{ 26, 16453371 },
	{ 26, 28970747 },
	{ 26, 31395579 },
	{ 27, 43912955 },
	{ 27, 47910651 },
	{ 27, 60428027 },
	{ 26, 32444155 },
	{ 27, 55447291 },
	{ 26, 31952639 },
	{ 26, 28823291 },
	{ 26, 32968443 },
	{ 26, 61214459 },
	{ 24, 7966463 },
	{ 24, 7196411 },
	{ 24, 16584443 },
	{ 24, 7884539 },
	{ 24, 4165371 },
	{ 24, 8359675 },
	{ 25, 15945467 },
	{ 25, 15093499 },
	{ 25, 12013307 },
	{ 26, 33525499 },
	{ 25, 15421179 },
	{ 25, 13520635 },
	{ 25, 7294715 },
	{ 26, 10112763 },
	{ 24, 5983995 },
	{ 24, 1986299 },
	{ 19, 109982 },
	{ 24, 2051839 },
	{ 24, 6246143 },
	{ 26, 12520443 },
	{ 26, 16649211 },
	{ 26, 29035515 },
	{ 26, 33164283 },
	{ 27, 43977723 },
	{ 27, 48106491 },
	{ 27, 60492795 },
	{ 27, 64621563 },
	{ 27, 55512059 },
	{ 27, 57543675 },
	{ 26, 28806143 },
	{ 26, 27773947 },
	{ 26, 61279227 },
	{ 26, 62262267 },
	{ 24, 7179263 },
	{ 24, 6933499 },
	{ 24, 6867963 },
	{ 24, 7097339 },
	{ 24, 6900731 },
	{ 25, 15879163 },
	{ 25, 14896123 },
	{ 25, 11947003 },
	{ 25, 10963963 },
	{ 25, 15354875 },
	{ 25, 13323259 },
	{ 25, 7228411 },
	{ 25, 5196795 },
	{ 24, 5917691 },
	{ 24, 1788923 },
	{ 19, 93470 },
	{ 24, 1985535 },
	{ 24, 6179839 },
	{ 26, 12520187 },
	{ 26, 16648955 },
	{ 26, 29035259 },
	{ 26, 33164027 },
	{ 27, 43977467 },
	{ 27, 48106235 },
	{ 27, 60492539 },
	{ 27, 64621307 },
	{ 27, 55511803 },
	{ 27, 57543419 },
	{ 26, 28805887 },
	{ 26, 27773691 },
	{ 26, 61278971 },
	{ 26, 62262011 },
	{ 24, 7179007 },
	{ 24, 6933243 },
	{ 24, 6867707 },
	{ 24, 7097083 },
	{ 24, 6900475 },
	{ 25, 15878907 },
	{ 25, 14895867 },
	{ 25, 11946747 },
	{ 25, 10963707 },
	{ 25, 15354619 },
	{ 25, 13323003 },
	{ 25, 7228155 },
	{ 25, 5196539 },
	{ 24, 5917435 },
	{ 24, 1788667 },
	{ 19, 77086 },
	{ 24, 1985279 },
	{ 24, 6179583 },
	{ 25, 16775163 },
	{ 24, 4179963 },
	{ 24, 7309307 },
	{ 24, 8308731 },
	{ 25, 11438075 },
	{ 25, 12044283 },
	{ 25, 15173627 },
	{ 25, 16173051 },
	{ 24, 8124411 },
	{ 24, 8108027 },
	{ 24, 8058875 },
	{ 24, 8042491 },
	{ 23, 4061179 },
	{ 23, 4044795 },
	{ 23, 3995643 },
	{ 22, 1730559 },
	{ 21, 1013755 },
	{ 21, 997371 },
	{ 22, 1710075 },
	{ 21, 1005563 },
	{ 23, 3708923 },
	{ 23, 2938875 },
	{ 23, 2725883 },
	{ 22, 1955835 },
	{ 23, 3315707 },
	{ 23, 1759227 },
	{ 23, 1284091 },
	{ 21, 776187 },
	{ 22, 432123 },
	{ 16, 30622 },
	{ 22, 448511 },
	{ 22, 1497087 },
	{ 24, 2545663 },
	{ 24, 4179707 },
	{ 24, 7309051 },
	{ 24, 8308475 },
	{ 25, 11437819 },
	{ 25, 12044027 },
	{ 25, 15173371 },
	{ 25, 16172795 },
	{ 24, 8124155 },
	{ 24, 8107771 },
	{ 24, 8058619 },
	{ 24, 8042235 },
	{ 23, 4060923 },
	{ 23, 4044539 },
	{ 23, 3995387 },
	{ 22, 1730303 },
	{ 21, 1013499 },
	{ 21, 997115 },
	{ 22, 1709819 },
	{ 21, 1005307 },
	{ 23, 3708667 },
	{ 23, 2938619 },
	{ 23, 2725627 },
	{ 22, 1955579 },
	{ 23, 3315451 },
	{ 23, 1758971 },
	{ 23, 1283835 },
	{ 21, 775931 },
	{ 22, 431867 },
	{ 16, 22430 },
	{ 22, 448255 },
	{ 22, 1496831 },
	{ 24, 2545407 },
	{ 24, 3593983 },
	{ 24, 7324667 },
	{ 24, 8356859 },
	{ 25, 11453435 },
	{ 25, 12485627 },
	{ 25, 15188987 },
	{ 25, 16221179 },
	{ 24, 8119295 },
	{ 24, 7599099 },
	{ 24, 7582715 },
	{ 24, 7533563 },
	{ 23, 4056063 },
	{ 23, 3798011 },
	{ 23, 3781627 },
	{ 23, 3732475 },
	{ 21, 1008639 },
	{ 21, 947195 },
	{ 21, 930811 },
	{ 21, 988155 },
	{ 21, 939003 },
	{ 23, 2921467 },
	{ 23, 2675707 },
	{ 22, 1938427 },
	{ 22, 1692667 },
	{ 23, 1741819 },
	{ 23, 1233915 },
	{ 21, 758779 },
	{ 21, 250875 },
	{ 16, 14110 },
	{ 22, 431103 },
	{ 22, 1479679 },
	{ 24, 2528255 },
	{ 24, 3576831 },
	{ 24, 7324411 },
	{ 24, 8356603 },
	{ 25, 11453179 },
	{ 25, 12485371 },
	{ 25, 15188731 },
	{ 25, 16220923 },
	{ 24, 8119039 },
	{ 24, 7598843 },
	{ 24, 7582459 },
	{ 24, 7533307 },
	{ 23, 4055807 },
	{ 23, 3797755 },
	{ 23, 3781371 },
	{ 23, 3732219 },
	{ 21, 1008383 },
	{ 21, 946939 },
	{ 21, 930555 },
	{ 21, 987899 },
	{ 21, 938747 },
	{ 23, 2921211 },
	{ 23, 2675451 },
	{ 22, 1938171 },
	{ 22, 1692411 },
	{ 23, 1741563 },
	{ 23, 1233659 },
	{ 21, 758523 },
	{ 21, 250619 },
	{ 16, 5918 },
	{ 22, 430847 },
	{ 22, 1479423 },
	{ 24, 2527999 },
	{ 23, 3930623 },
	{ 23, 3145211 },
	{ 22, 2093563 },
	{ 23, 2875899 },
	{ 23, 3125755 },
	{ 23, 3908091 },
	{ 23, 4059643 },
	{ 23, 2997755 },
	{ 22, 1899007 },
	{ 22, 1506811 },
	{ 22, 1502715 },
	{ 22, 1490427 },
	{ 21, 948735 },
	{ 21, 753147 },
	{ 21, 749051 },
	{ 21, 736763 },
	{ 19, 236031 },
	{ 19, 187899 },
	{ 19, 183803 },
	{ 19, 230907 },
	{ 19, 185851 },
	{ 21, 665083 },
	{ 20, 472571 },
	{ 20, 419323 },
	{ 20, 226811 },
	{ 21, 304635 },
	{ 19, 177659 },
	{ 19, 58875 },
	{ 14, 9630 },
	{ 19, 62975 },
	{ 19, 194047 },
	{ 21, 325119 },
	{ 21, 456191 },
	{ 21, 849407 },
	{ 21, 980479 },
	{ 22, 1373695 },
	{ 22, 1504767 },
	{ 22, 1897983 },
	{ 22, 2029055 },
	{ 23, 3586297 },
	{ 22, 2026749 },
	{ 22, 2013433 },
	{ 22, 1882361 },
	{ 22, 1489145 },
	{ 21, 978173 },
	{ 21, 964857 },
	{ 21, 833785 },
	{ 21, 440569 },
	{ 19, 191741 },
	{ 19, 178425 },
	{ 19, 47353 },
	{ 19, 229625 },
	{ 19, 184569 },
	{ 21, 663801 },
	{ 20, 471289 },
	{ 20, 418041 },
	{ 20, 225529 },
	{ 21, 303353 },
	{ 19, 176377 },
	{ 19, 57593 },
	{ 14, 1514 },
	{ 19, 61693 },
	{ 19, 192765 },
	{ 21, 323837 },
	{ 21, 454909 },
	{ 21, 848125 },
	{ 21, 979197 },
	{ 22, 1372413 },
	{ 22, 1503485 },
	{ 22, 1896701 },
	{ 22, 2027773 },
	{ 23, 3586553 },
	{ 22, 2027005 },
	{ 22, 2013689 },
	{ 22, 1882617 },
	{ 22, 1489401 },
	{ 21, 978429 },
	{ 21, 965113 },
	{ 21, 834041 },
	{ 21, 440825 },
	{ 19, 191997 },
	{ 19, 178681 },
	{ 19, 47609 },
	{ 19, 229881 },
	{ 19, 184825 },
	{ 21, 664057 },
	{ 20, 471545 },
	{ 20, 418297 },
	{ 20, 225785 },
	{ 21, 303609 },
	{ 19, 176633 },
	{ 19, 57849 },
	{ 14, 9706 },
	{ 19, 61949 },
	{ 19, 193021 },
	{ 21, 324093 },
	{ 21, 455165 },
	{ 21, 848381 },
	{ 21, 979453 },
	{ 22, 1372669 },
	{ 22, 1503741 },
	{ 22, 1896957 },
	{ 22, 2028029 },
	{ 23, 3469821 },
	{ 23, 3600893 },
	{ 23, 3994109 },
	{ 23, 4125181 },
	{ 23, 7664125 },
	{ 23, 7795197 },
	{ 23, 3863293 },
	{ 23, 3842809 },
	{ 23, 3318521 },
	{ 23, 1745657 },
	{ 21, 717565 },
	{ 21, 697081 },
	{ 21, 172793 },
	{ 21, 721657 },
	{ 21, 672505 },
	{ 22, 1868537 },
	{ 22, 1622777 },
	{ 22, 885497 },
	{ 22, 639737 },
	{ 21, 688889 },
	{ 21, 180985 },
	{ 16, 5482 },
	{ 21, 230141 },
	{ 21, 754429 },
	{ 23, 1278717 },
	{ 23, 1803005 },
	{ 23, 3375869 },
	{ 23, 3900157 },
	{ 24, 5473021 },
	{ 24, 5997309 },
	{ 24, 7570173 },
	{ 24, 8094461 },
	{ 25, 15901689 },
	{ 25, 14328825 },
	{ 24, 8057853 },
	{ 24, 8037369 },
	{ 24, 7513081 },
	{ 24, 5940217 },
	{ 23, 3863549 },
	{ 23, 3843065 },
	{ 23, 3318777 },
	{ 23, 1745913 },
	{ 21, 717821 },
	{ 21, 697337 },
	{ 21, 173049 },
	{ 21, 721913 },
	{ 21, 672761 },
	{ 22, 1868793 },
	{ 22, 1623033 },
	{ 22, 885753 },
	{ 22, 639993 },
	{ 21, 689145 },
	{ 21, 181241 },
	{ 16, 13674 },
	{ 21, 230397 },
	{ 21, 754685 },
	{ 23, 1278973 },
	{ 23, 1803261 },
	{ 23, 3376125 },
	{ 23, 3900413 },
	{ 24, 16639737 },
	{ 24, 16377593 },
	{ 24, 15591161 },
	{ 24, 15329017 },
	{ 24, 8251129 },
	{ 24, 7988985 },
	{ 24, 7202553 },
	{ 24, 6940409 },
	{ 23, 4056825 },
	{ 23, 3794681 },
	{ 23, 3008249 },
	{ 23, 2746105 },
	{ 22, 1959673 },
	{ 22, 1697529 },
	{ 22, 911097 },
	{ 21, 702205 },
	{ 20, 386809 },
	{ 20, 124665 },
	{ 21, 657145 },
	{ 20, 476921 },
	{ 22, 1607417 },
	{ 22, 837369 },
	{ 22, 624377 },
	{ 20, 378617 },
	{ 21, 165625 },
	{ 15, 11242 },
	{ 21, 182013 },
	{ 21, 706301 },
	{ 23, 1230589 },
	{ 23, 1754877 },
	{ 23, 3327741 },
	{ 23, 3852029 },
	{ 24, 16639993 },
	{ 24, 16377849 },
	{ 24, 15591417 },
	{ 24, 15329273 },
	{ 24, 8251385 },
	{ 24, 7989241 },
	{ 24, 7202809 },
	{ 24, 6940665 },
	{ 23, 4057081 },
	{ 23, 3794937 },
	{ 23, 3008505 },
	{ 23, 2746361 },
	{ 22, 1959929 },
	{ 22, 1697785 },
	{ 22, 911353 },
	{ 21, 702461 },
	{ 20, 387065 },
	{ 20, 124921 },
	{ 21, 657401 },
	{ 20, 477177 },
	{ 22, 1607673 },
	{ 22, 837625 },
	{ 22, 624633 },
	{ 20, 378873 },
	{ 21, 165881 },
	{ 15, 15338 },
	{ 21, 182269 },
	{ 21, 706557 },
	{ 23, 1230845 },
	{ 23, 1755133 },
	{ 23, 3327997 },
	{ 23, 3852285 },
	{ 24, 5425149 },
	{ 24, 5949437 },
	{ 24, 7522301 },
	{ 24, 8046589 },
	{ 25, 13813757 },
	{ 25, 14338045 },
	{ 25, 15910909 },
	{ 25, 16435197 },
	{ 25, 16239357 },
	{ 25, 16157433 },
	{ 25, 15108857 },
	{ 25, 11963129 },
	{ 24, 7850749 },
	{ 24, 7768825 },
	{ 24, 6720249 },
	{ 24, 3574521 },
	{ 22, 1559293 },
	{ 22, 1477369 },
	{ 22, 428793 },
	{ 22, 1837817 },
	{ 22, 1641209 },
	{ 24, 3279609 },
	{ 24, 2296569 },
	{ 22, 1444601 },
	{ 22, 461561 },
	{ 17, 19306 },
	{ 23, 658173 },
	{ 23, 2755325 },
	{ 25, 4852477 },
	{ 25, 6949629 },
	{ 25, 13241085 },
	{ 25, 15338237 },
	{ 26, 21629693 },
	{ 26, 66489337 },
	{ 26, 65440761 },
	{ 26, 62295033 },
	{ 26, 61246457 },
	{ 26, 32934905 },
	{ 26, 31886329 },
	{ 26, 28740601 },
	{ 25, 16239613 },
	{ 25, 16157689 },
	{ 25, 15109113 },
	{ 25, 11963385 },
	{ 24, 7851005 },
	{ 24, 7769081 },
	{ 24, 6720505 },
	{ 24, 3574777 },
	{ 22, 1559549 },
	{ 22, 1477625 },
	{ 22, 429049 },
	{ 22, 1838073 },
	{ 22, 1641465 },
	{ 24, 3279865 },
	{ 24, 2296825 },
	{ 22, 1444857 },
	{ 22, 461817 },
	{ 17, 23402 },
	{ 23, 658429 },
	{ 23, 2755581 },
	{ 25, 4852733 },
	{ 25, 6949885 },
	{ 25, 13241341 },
	{ 25, 15338493 },
	{ 26, 21629949 },
	{ 26, 66506493 },
	{ 26, 66293497 },
	{ 26, 65244921 },
	{ 26, 62099193 },
	{ 26, 61050617 },
	{ 26, 32739065 },
	{ 26, 31690489 },
	{ 26, 28544761 },
	{ 25, 16174845 },
	{ 25, 15961849 },
	{ 25, 14913273 },
	{ 25, 11767545 },
	{ 24, 7786237 },
	{ 24, 7573241 },
	{ 24, 6524665 },
	{ 24, 3378937 },
	{ 22, 1494781 },
	{ 22, 1281785 },
	{ 22, 233209 },
	{ 22, 1576697 },
	{ 22, 855801 },
	{ 24, 2232057 },
	{ 22, 1249017 },
	{ 22, 397049 },
	{ 17, 27114 },
	{ 22, 462589 },
	{ 22, 1511165 },
	{ 24, 2559741 },
	{ 24, 3608317 },
	{ 24, 6754045 },
	{ 24, 7802621 },
	{ 25, 10948349 },
	{ 25, 11996925 },
	{ 25, 15142653 },
	{ 25, 16191229 },
	{ 26, 62099449 },
	{ 26, 61050873 },
	{ 26, 32739321 },
	{ 26, 31690745 },
	{ 26, 28545017 },
	{ 25, 16175101 },
	{ 25, 15962105 },
	{ 25, 14913529 },
	{ 25, 11767801 },
	{ 24, 7786493 },
	{ 24, 7573497 },
	{ 24, 6524921 },
	{ 24, 3379193 },
	{ 22, 1495037 },
	{ 22, 1282041 },
	{ 22, 233465 },
	{ 22, 1576953 },
	{ 22, 856057 },
	{ 24, 2232313 },
	{ 22, 1249273 },
	{ 22, 397305 },
	{ 17, 31210 },
	{ 22, 462845 },
	{ 22, 1511421 },
	{ 24, 2559997 },
	{ 24, 3608573 },
	{ 24, 6754301 },
	{ 24, 7802877 },
	{ 25, 10948605 },
	{ 25, 11997181 },
	{ 25, 15142909 },
	{ 25, 16191485 },
	{ 26, 65182457 },
	{ 26, 62036729 },
	{ 26, 60988153 },
	{ 26, 32676601 },
	{ 26, 31628025 },
	{ 26, 28482297 },
	{ 25, 15981309 },
	{ 25, 15899385 },
	{ 25, 14850809 },
	{ 25, 11705081 },
	{ 24, 7592701 },
	{ 24, 7510777 },
	{ 24, 6462201 },
	{ 24, 3316473 },
	{ 22, 1301245 },
	{ 22, 1219321 },
	{ 22, 170745 },
	{ 22, 793337 },
	{ 22, 596729 },
	{ 22, 1186553 },
	{ 22, 203513 },
	{ 17, 51562 },
	{ 22, 400125 },
	{ 22, 1448701 },
	{ 24, 2497277 },
	{ 24, 3545853 },
	{ 24, 6691581 },
	{ 24, 7740157 },
	{ 25, 10885885 },
	{ 25, 11934461 },
	{ 25, 15080189 },
	{ 25, 16128765 },
	{ 26, 65182713 },
	{ 26, 62036985 },
	{ 26, 60988409 },
	{ 26, 32676857 },
	{ 26, 31628281 },
	{ 26, 28482553 },
	{ 25, 15981565 },
	{ 25, 15899641 },
	{ 25, 14851065 },
	{ 25, 11705337 },
	{ 24, 7592957 },
	{ 24, 7511033 },
	{ 24, 6462457 },
	{ 24, 3316729 },
	{ 22, 1301501 },
	{ 22, 1219577 },
	{ 22, 171001 },
	{ 22, 793593 },
	{ 22, 596985 },
	{ 22, 1186809 },
	{ 22, 203769 },
	{ 17, 55658 },
	{ 22, 400381 },
	{ 22, 1448957 },
	{ 24, 2497533 },
	{ 24, 3546109 },
	{ 24, 6691837 },
	{ 24, 7740413 },
	{ 25, 10886141 },
	{ 25, 11934717 },
	{ 25, 15080445 },
	{ 25, 16129021 },
	{ 24, 16621305 },
	{ 24, 16359161 },
	{ 24, 15572729 },
	{ 24, 15310585 },
	{ 24, 8232697 },
	{ 24, 7970553 },
	{ 24, 7184121 },
	{ 24, 6921977 },
	{ 23, 4038393 },
	{ 23, 3776249 },
	{ 23, 2989817 },
	{ 23, 2727673 },
	{ 22, 1941241 },
	{ 22, 1679097 },
	{ 22, 892665 },
	{ 22, 630521 },
	{ 20, 368377 },
	{ 20, 106233 },
	{ 22, 532217 },
	{ 20, 335609 },
	{ 22, 139001 },
	{ 15, 15082 },
	{ 22, 204541 },
	{ 22, 1253117 },
	{ 24, 2301693 },
	{ 24, 3350269 },
	{ 24, 6495997 },
	{ 24, 7544573 },
	{ 25, 10690301 },
	{ 25, 11738877 },
	{ 25, 14884605 },
	{ 25, 15933181 },
	{ 24, 16621561 },
	{ 24, 16359417 },
	{ 24, 15572985 },
	{ 24, 15310841 },
	{ 24, 8232953 },
	{ 24, 7970809 },
	{ 24, 7184377 },
	{ 24, 6922233 },
	{ 23, 4038649 },
	{ 23, 3776505 },
	{ 23, 2990073 },
	{ 23, 2727929 },
	{ 22, 1941497 },
	{ 22, 1679353 },
	{ 22, 892921 },
	{ 22, 630777 },
	{ 20, 368633 },
	{ 20, 106489 },
	{ 22, 532473 },
	{ 20, 335865 },
	{ 22, 139257 },
	{ 15, 16106 },
	{ 22, 204797 },
	{ 22, 1253373 },
	{ 24, 2301949 },
	{ 24, 3350525 },
	{ 24, 6496253 },
	{ 24, 7544829 },
	{ 25, 10690557 },
	{ 25, 11739133 },
	{ 25, 14884861 },
	{ 25, 15933437 },
	{ 26, 66530045 },
	{ 26, 66202361 },
	{ 26, 65153785 },
	{ 26, 62008057 },
	{ 26, 60959481 },
	{ 26, 32647929 },
	{ 26, 31599353 },
	{ 26, 28453625 },
	{ 25, 16198397 },
	{ 25, 15870713 },
	{ 25, 14822137 },
	{ 25, 11676409 },
	{ 24, 7809789 },
	{ 24, 7482105 },
	{ 24, 6433529 },
	{ 24, 3287801 },
	{ 22, 1518333 },
	{ 22, 1190649 },
	{ 22, 142073 },
	{ 17, 42361 },
	{ 18, 130489 },
	{ 16, 21098 },
	{ 24, 535293 },
	{ 24, 4729597 },
	{ 26, 8923901 },
	{ 26, 13118205 },
	{ 26, 25701117 },
	{ 26, 29895421 },
	{ 27, 42478333 },
	{ 27, 46672637 },
	{ 27, 59255549 },
	{ 27, 63449853 },
	{ 26, 66530301 },
	{ 26, 66202617 },
	{ 26, 65154041 },
	{ 26, 62008313 },
	{ 26, 60959737 },
	{ 26, 32648185 },
	{ 26, 31599609 },
	{ 26, 28453881 },
	{ 25, 16198653 },
	{ 25, 15870969 },
	{ 25, 14822393 },
	{ 25, 11676665 },
	{ 24, 7810045 },
	{ 24, 7482361 },
	{ 24, 6433785 },
	{ 24, 3288057 },
	{ 22, 1518589 },
	{ 22, 1190905 },
	{ 22, 142329 },
	{ 17, 44409 },
	{ 17, 65209 },
	{ 16, 22122 },
	{ 24, 535549 },
	{ 24, 4729853 },
	{ 26, 8924157 },
	{ 26, 13118461 },
	{ 26, 25701373 },
	{ 26, 29895677 },
	{ 27, 42478589 },
	{ 27, 46672893 },
	{ 27, 59255805 },
	{ 27, 63450109 },
	{ 28, 109587453 },
	{ 26, 66268925 },
	{ 26, 65220349 },
	{ 26, 62074621 },
	{ 26, 61026045 },
	{ 26, 32714493 },
	{ 26, 31665917 },
	{ 26, 28520189 },
	{ 26, 27471613 },
	{ 25, 15937277 },
	{ 25, 14888701 },
	{ 25, 11742973 },
	{ 25, 10694397 },
	{ 24, 7548669 },
	{ 24, 6500093 },
	{ 24, 3354365 },
	{ 24, 2305789 },
	{ 22, 1257213 },
	{ 22, 208637 },
	{ 17, 65513 },
	{ 15, 16297 },
	{ 16, 32602 },
	{ 19, 261565 },
	{ 22, 1322749 },
	{ 24, 2371325 },
	{ 24, 3419901 },
	{ 24, 6565629 },
	{ 24, 7614205 },
	{ 25, 10759933 },
	{ 25, 11808509 },
	{ 25, 14954237 },
	{ 25, 16002813 },
	{ 26, 27537149 },
	{ 26, 28585725 },
	{ 26, 31731453 },
	{ 26, 32780029 },
	{ 26, 61091581 },
	{ 26, 62140157 },
	{ 26, 65285885 },
	{ 26, 66334461 },
	{ 26, 27471869 },
	{ 25, 15937533 },
	{ 25, 14888957 },
	{ 25, 11743229 },
	{ 25, 10694653 },
	{ 24, 7548925 },
	{ 24, 6500349 },
	{ 24, 3354621 },
	{ 24, 2306045 },
	{ 22, 1257469 },
	{ 22, 208893 },
	{ 17, 65337 },
	{ 14, 8137 },
	{ 16, 32730 },
	{ 18, 130749 },
	{ 22, 1323005 },
	{ 24, 2371581 },
	{ 24, 3420157 },
	{ 24, 6565885 },
	{ 24, 7614461 },
	{ 25, 10760189 },
	{ 25, 11808765 },
	{ 25, 14954493 },
	{ 25, 16003069 },
	{ 26, 27537405 },
	{ 26, 28585981 },
	{ 26, 31731709 },
	{ 26, 66140925 },
	{ 26, 65092349 },
	{ 26, 61946621 },
	{ 26, 60898045 },
	{ 26, 32586493 },
	{ 26, 31537917 },
	{ 26, 28392189 },
	{ 26, 27343613 },
	{ 25, 15809277 },
	{ 25, 14760701 },
	{ 25, 11614973 },
	{ 25, 10566397 },
	{ 24, 7420669 },
	{ 24, 6372093 },
	{ 24, 3226365 },
	{ 24, 2177789 },
	{ 17, 59261 },
	{ 15, 16349 },
	{ 23, 65535 },
	{ 16, 32685 },
	{ 17, 58749 },
	{ 23, 2293759 },
	{ 24, 3160829 },
	{ 24, 6306557 },
	{ 24, 7355133 },
	{ 25, 10500861 },
	{ 25, 11549437 },
	{ 25, 14695165 },
	{ 25, 15743741 },
	{ 26, 27278077 },
	{ 26, 28326653 },
	{ 26, 31472381 },
	{ 26, 32520957 },
	{ 26, 60832509 },
	{ 26, 61881085 },
	{ 26, 65026813 },
	{ 26, 66075389 },
	{ 26, 31538173 },
	{ 26, 28392445 },
	{ 26, 27343869 },
	{ 25, 15809533 },
	{ 25, 14760957 },
	{ 25, 11615229 },
	{ 25, 10566653 },
	{ 24, 7420925 },
	{ 24, 6372349 },
	{ 24, 3226621 },
	{ 24, 2178045 },
	{ 17, 61309 },
	{ 18, 130925 },
	{ 13, 2954 },
	{ 15, 16333 },
	{ 17, 60797 },
	{ 23, 2293503 },
	{ 24, 3161085 },
	{ 24, 6306813 },
	{ 24, 7355389 },
	{ 25, 10501117 },
	{ 25, 11549693 },
	{ 25, 14695421 },
	{ 25, 15743997 },
	{ 26, 27278333 },
	{ 26, 28326909 },
	{ 26, 31472637 },
	{ 26, 66404093 },
	{ 26, 65355517 },
	{ 26, 62209789 },
	{ 26, 61161213 },
	{ 26, 32849661 },
	{ 26, 31801085 },
	{ 26, 28655357 },
	{ 26, 27606781 },
	{ 25, 16072445 },
	{ 25, 15023869 },
	{ 25, 11878141 },
	{ 25, 10829565 },
	{ 24, 7683837 },
	{ 24, 6635261 },
	{ 24, 3489533 },
	{ 24, 2440957 },
	{ 22, 1392381 },
	{ 20, 523901 },
	{ 13, 3018 },
	{ 16, 32729 },
	{ 19, 262125 },
	{ 22, 147197 },
	{ 22, 409341 },
	{ 23, 2554879 },
	{ 24, 933629 },
	{ 24, 1720061 },
	{ 24, 1982205 },
	{ 25, 2768637 },
	{ 25, 3030781 },
	{ 25, 3817213 },
	{ 25, 4079357 },
	{ 26, 6962941 },
	{ 26, 7225085 },
	{ 26, 8011517 },
	{ 26, 8273661 },
	{ 26, 15351549 },
	{ 26, 15613693 },
	{ 26, 16400125 },
	{ 26, 16662269 },
	{ 26, 27607037 },
	{ 25, 16072701 },
	{ 25, 15024125 },
	{ 25, 11878397 },
	{ 25, 10829821 },
	{ 24, 7684093 },
	{ 24, 6635517 },
	{ 24, 3489789 },
	{ 24, 2441213 },
	{ 22, 1392637 },
	{ 21, 1048509 },
	{ 19, 261946 },
	{ 19, 261993 },
	{ 19, 261949 },
	{ 22, 147453 },
	{ 22, 409597 },
	{ 23, 2554623 },
	{ 24, 933885 },
	{ 24, 1720317 },
	{ 24, 1982461 },
	{ 25, 2768893 },
	{ 25, 3031037 },
	{ 25, 3817469 },
	{ 25, 4079613 },
	{ 26, 6963197 },
	{ 26, 7225341 },
	{ 26, 8011773 },
	{ 26, 8273917 },
	{ 26, 15351805 },
	{ 26, 15613949 },
	{ 26, 16400381 },
	{ 26, 16662525 },
	{ 27, 132578047 },
	{ 27, 63531773 },
	{ 27, 59337469 },
	{ 27, 46754557 },
	{ 27, 42560253 },
	{ 26, 29977341 },
	{ 26, 25783037 },
	{ 26, 13200125 },
	{ 26, 9005821 },
	{ 24, 4811517 },
	{ 24, 617213 },
	{ 17, 53786 },
	{ 21, 1048185 },
	{ 18, 108409 },
	{ 22, 223993 },
	{ 22, 486137 },
	{ 22, 1469181 },
	{ 23, 3076095 },
	{ 24, 1796857 },
	{ 24, 2059001 },
	{ 24, 6187773 },
	{ 25, 3107577 },
	{ 25, 3894009 },
	{ 25, 4156153 },
	{ 25, 12479229 },
	{ 26, 7301881 },
	{ 26, 8088313 },
	{ 26, 8350457 },
	{ 26, 15428345 },
	{ 26, 15690489 },
	{ 26, 16476921 },
	{ 26, 16739065 },
	{ 26, 33450749 },
	{ 27, 63532029 },
	{ 27, 59337725 },
	{ 27, 46754813 },
	{ 27, 42560509 },
	{ 26, 29977597 },
	{ 26, 25783293 },
	{ 26, 13200381 },
	{ 26, 9006077 },
	{ 24, 4811773 },
	{ 24, 617469 },
	{ 17, 54810 },
	{ 22, 2097081 },
	{ 18, 110457 },
	{ 22, 224249 },
	{ 22, 486393 },
	{ 22, 1469437 },
	{ 23, 3075839 },
	{ 24, 1797113 },
	{ 24, 2059257 },
	{ 24, 6188029 },
	{ 25, 3107833 },
	{ 25, 3894265 },
	{ 25, 4156409 },
	{ 25, 12479485 },
	{ 26, 7302137 },
	{ 26, 8088569 },
	{ 26, 8350713 },
	{ 26, 15428601 },
	{ 26, 15690745 },
	{ 26, 16477177 },
	{ 26, 16739321 },
	{ 26, 33451005 },
	{ 27, 63794941 },
	{ 27, 59600637 },
	{ 27, 47017725 },
	{ 27, 42823421 },
	{ 26, 30240509 },
	{ 26, 26046205 },
	{ 26, 13463293 },
	{ 26, 9268989 },
	{ 24, 5074685 },
	{ 24, 880381 },
	{ 17, 55962 },
	{ 24, 618233 },
	{ 22, 1404665 },
	{ 23, 2681851 },
	{ 22, 1273593 },
	{ 22, 1535737 },
	{ 23, 2943995 },
	{ 24, 5205753 },
	{ 24, 5992185 },
	{ 24, 6254329 },
	{ 25, 11235065 },
	{ 25, 11497209 },
	{ 25, 12283641 },
	{ 25, 12545785 },
	{ 26, 23817977 },
	{ 26, 24080121 },
	{ 26, 24866553 },
	{ 26, 25128697 },
	{ 26, 32206585 },
	{ 26, 32468729 },
	{ 26, 33255161 },
	{ 26, 33517305 },
	{ 27, 63795197 },
	{ 27, 59600893 },
	{ 27, 47017981 },
	{ 27, 42823677 },
	{ 26, 30240765 },
	{ 26, 26046461 },
	{ 26, 13463549 },
	{ 26, 9269245 },
	{ 24, 5074941 },
	{ 24, 880637 },
	{ 17, 56986 },
	{ 24, 618489 },
	{ 22, 1404921 },
	{ 23, 2681595 },
	{ 22, 1273849 },
	{ 22, 1535993 },
	{ 23, 2943739 },
	{ 24, 5206009 },
	{ 24, 5992441 },
	{ 24, 6254585 },
	{ 25, 11235321 },
	{ 25, 11497465 },
	{ 25, 12283897 },
	{ 25, 12546041 },
	{ 26, 23818233 },
	{ 26, 24080377 },
	{ 26, 24866809 },
	{ 26, 25128953 },
	{ 26, 32206841 },
	{ 26, 32468985 },
	{ 26, 33255417 },
	{ 26, 33517561 },
	{ 27, 64584445 },
	{ 27, 60390141 },
	{ 27, 47807229 },
	{ 27, 43612925 },
	{ 26, 31030013 },
	{ 26, 26835709 },
	{ 26, 14252797 },
	{ 26, 10058493 },
	{ 24, 5864189 },
	{ 24, 1669885 },
	{ 19, 248090 },
	{ 19, 522606 },
	{ 24, 4815609 },
	{ 24, 2456313 },
	{ 24, 3242745 },
	{ 24, 2325241 },
	{ 24, 2587385 },
	{ 24, 3570429 },
	{ 25, 10403839 },
	{ 26, 10189561 },
	{ 26, 10451705 },
	{ 26, 14580477 },
	{ 27, 19888889 },
	{ 27, 20675321 },
	{ 27, 20937465 },
	{ 27, 29260541 },
	{ 28, 40860409 },
	{ 28, 41646841 },
	{ 28, 41908985 },
	{ 28, 48986873 },
	{ 28, 49249017 },
	{ 28, 50035449 },
	{ 27, 64584701 },
	{ 27, 60390397 },
	{ 27, 47807485 },
	{ 27, 43613181 },
	{ 26, 31030269 },
	{ 26, 26835965 },
	{ 26, 14253053 },
	{ 26, 10058749 },
	{ 24, 5864445 },
	{ 24, 1670141 },
	{ 19, 252186 },
	{ 19, 518510 },
	{ 24, 4815865 },
	{ 24, 2456569 },
	{ 24, 3243001 },
	{ 24, 2325497 },
	{ 24, 2587641 },
	{ 24, 3570685 },
	{ 25, 10403583 },
	{ 26, 10189817 },
	{ 26, 10451961 },
	{ 26, 14580733 },
	{ 27, 19889145 },
	{ 27, 20675577 },
	{ 27, 20937721 },
	{ 27, 29260797 },
	{ 28, 40860665 },
	{ 28, 41647097 },
	{ 28, 41909241 },
	{ 28, 48987129 },
	{ 28, 49249273 },
	{ 28, 50035705 },
	{ 27, 64847613 },
	{ 27, 60653309 },
	{ 27, 48070397 },
	{ 27, 43876093 },
	{ 26, 31293181 },
	{ 26, 27098877 },
	{ 26, 14515965 },
	{ 26, 10321661 },
	{ 24, 6127357 },
	{ 24, 1933053 },
	{ 19, 256410 },
	{ 19, 514542 },
	{ 24, 5078777 },
	{ 25, 10009595 },
	{ 24, 3505913 },
	{ 24, 6389497 },
	{ 24, 3374841 },
	{ 24, 3636985 },
	{ 24, 6717181 },
	{ 25, 11975679 },
	{ 26, 14384889 },
	{ 26, 14647033 },
	{ 26, 27164413 },
	{ 27, 28278521 },
	{ 27, 29064953 },
	{ 27, 29327097 },
	{ 27, 54427389 },
	{ 28, 57638649 },
	{ 28, 58425081 },
	{ 28, 58687225 },
	{ 28, 65765113 },
	{ 28, 66027257 },
	{ 27, 64847869 },
	{ 27, 60653565 },
	{ 27, 48070653 },
	{ 27, 43876349 },
	{ 26, 31293437 },
	{ 26, 27099133 },
	{ 26, 14516221 },
	{ 26, 10321917 },
	{ 24, 6127613 },
	{ 24, 1933309 },
	{ 19, 260506 },
	{ 19, 510446 },
	{ 24, 5079033 },
	{ 25, 10009339 },
	{ 24, 3506169 },
	{ 24, 6389753 },
	{ 24, 3375097 },
	{ 24, 3637241 },
	{ 24, 6717437 },
	{ 25, 11975423 },
	{ 26, 14385145 },
	{ 26, 14647289 },
	{ 26, 27164669 },
	{ 27, 28278777 },
	{ 27, 29065209 },
	{ 27, 29327353 },
	{ 27, 54427645 },
	{ 28, 57638905 },
	{ 28, 58425337 },
	{ 28, 58687481 },
	{ 28, 65765369 },
	{ 28, 66027513 },
	{ 28, 66813945 },
	{ 28, 67076089 },
	{ 28, 117342205 },
	{ 29, 173189885 },
	{ 28, 122858237 },
	{ 28, 106081021 },
	{ 28, 55749373 },
	{ 28, 38972157 },
	{ 26, 22194941 },
	{ 26, 5417725 },
	{ 19, 477978 },
	{ 19, 490350 },
	{ 25, 11709177 },
	{ 25, 11579387 },
	{ 27, 26389241 },
	{ 25, 13282041 },
	{ 25, 14854905 },
	{ 25, 13019897 },
	{ 25, 13544185 },
	{ 25, 15510269 },
	{ 25, 12496895 },
	{ 27, 53914361 },
	{ 27, 54438649 },
	{ 27, 62696189 },
	{ 27, 62828543 },
	{ 28, 108440313 },
	{ 28, 108964601 },
	{ 28, 125610749 },
	{ 28, 129937407 },
	{ 29, 217492217 },
	{ 29, 218016505 },
	{ 29, 232172281 },
	{ 29, 232696569 },
	{ 29, 234269433 },
	{ 29, 234793721 },
	{ 29, 268217085 },
	{ 28, 122858493 },
	{ 28, 106081277 },
	{ 28, 55749629 },
	{ 28, 38972413 },
	{ 26, 22195197 },
	{ 26, 5417981 },
	{ 19, 482074 },
	{ 19, 486254 },
	{ 25, 11709433 },
	{ 25, 11579131 },
	{ 27, 26389497 },
	{ 25, 13282297 },
	{ 25, 14855161 },
	{ 25, 13020153 },
	{ 25, 13544441 },
	{ 25, 15510525 },
	{ 25, 12496639 },
	{ 27, 53914617 },
	{ 27, 54438905 },
	{ 27, 62696445 },
	{ 27, 62828287 },
	{ 28, 108440569 },
	{ 28, 108964857 },
	{ 28, 125611005 },
	{ 28, 129937151 },
	{ 29, 217492473 },
	{ 29, 218016761 },
	{ 29, 232172537 },
	{ 29, 232696825 },
	{ 29, 234269689 },
	{ 29, 234793977 },
	{ 29, 173715197 },
	{ 28, 123383549 },
	{ 28, 106606333 },
	{ 28, 56274685 },
	{ 28, 39497469 },
	{ 26, 22720253 },
	{ 26, 5943037 },
	{ 19, 486298 },
	{ 19, 482286 },
	{ 25, 12234489 },
	{ 25, 12102651 },
	{ 27, 26914553 },
	{ 27, 51556089 },
	{ 25, 15380217 },
	{ 25, 15248379 },
	{ 25, 15118073 },
	{ 25, 15642361 },
	{ 25, 12364795 },
	{ 26, 22457343 },
	{ 27, 62303993 },
	{ 27, 62828281 },
	{ 27, 62696443 },
	{ 28, 123645689 },
	{ 28, 125218553 },
	{ 28, 125742841 },
	{ 28, 129805307 },
	{ 29, 249474809 },
	{ 29, 251047673 },
	{ 29, 251571961 },
	{ 29, 265727737 },
	{ 29, 266252025 },
	{ 29, 267824889 },
	{ 29, 268349177 },
	{ 28, 123383805 },
	{ 28, 106606589 },
	{ 28, 56274941 },
	{ 28, 39497725 },
	{ 26, 22720509 },
	{ 26, 5943293 },
	{ 19, 490394 },
	{ 19, 478190 },
	{ 25, 12234745 },
	{ 25, 12102395 },
	{ 27, 26914809 },
	{ 27, 51556345 },
	{ 25, 15380473 },
	{ 25, 15248123 },
	{ 25, 15118329 },
	{ 25, 15642617 },
	{ 25, 12364539 },
	{ 26, 22457087 },
	{ 27, 62304249 },
	{ 27, 62828537 },
	{ 27, 62696187 },
	{ 28, 123645945 },
	{ 28, 125218809 },
	{ 28, 125743097 },
	{ 28, 129805051 },
	{ 29, 249475065 },
	{ 29, 251047929 },
	{ 29, 251572217 },
	{ 29, 265727993 },
	{ 28, 129531903 },
	{ 28, 121143295 },
	{ 28, 95977471 },
	{ 28, 124959485 },
	{ 27, 62423039 },
	{ 27, 54034431 },
	{ 27, 28868607 },
	{ 26, 24296189 },
	{ 25, 12091391 },
	{ 20, 1021210 },
	{ 20, 521582 },
	{ 25, 2916347 },
	{ 25, 11042811 },
	{ 26, 10256379 },
	{ 26, 14188539 },
	{ 26, 25985019 },
	{ 26, 21674745 },
	{ 25, 10780667 },
	{ 25, 11567099 },
	{ 25, 2785275 },
	{ 25, 11173883 },
	{ 25, 11501567 },
	{ 27, 27951099 },
	{ 27, 53116923 },
	{ 27, 61505531 },
	{ 27, 61833215 },
	{ 28, 95059963 },
	{ 28, 120225787 },
	{ 28, 128614395 },
	{ 28, 128942079 },
	{ 29, 229277691 },
	{ 29, 259177469 },
	{ 28, 129531647 },
	{ 28, 121143039 },
	{ 28, 95977215 },
	{ 28, 124959741 },
	{ 27, 62422783 },
	{ 27, 54034175 },
	{ 27, 28868351 },
	{ 26, 24296445 },
	{ 25, 12091135 },
	{ 20, 1029402 },
	{ 20, 513390 },
	{ 25, 2916091 },
	{ 25, 11042555 },
	{ 26, 10256123 },
	{ 26, 14188283 },
	{ 26, 25984763 },
	{ 26, 21675001 },
	{ 25, 10780411 },
	{ 25, 11566843 },
	{ 25, 2785019 },
	{ 25, 11173627 },
	{ 25, 11501311 },
	{ 27, 27950843 },
	{ 27, 53116667 },
	{ 27, 61505275 },
	{ 27, 61832959 },
	{ 28, 95059707 },
	{ 28, 120225531 },
	{ 28, 128614139 },
	{ 28, 128941823 },
	{ 29, 229277435 },
	{ 29, 259702525 },
	{ 28, 129793023 },
	{ 28, 121404415 },
	{ 28, 96238591 },
	{ 28, 125484797 },
	{ 27, 62684159 },
	{ 27, 54295551 },
	{ 27, 29129727 },
	{ 26, 24821501 },
	{ 25, 12352511 },
	{ 20, 1037722 },
	{ 20, 505326 },
	{ 25, 3701755 },
	{ 25, 11303931 },
	{ 27, 29015801 },
	{ 26, 14449659 },
	{ 26, 26770427 },
	{ 26, 30178299 },
	{ 26, 23772921 },
	{ 25, 11828219 },
	{ 25, 14711803 },
	{ 25, 3046395 },
	{ 25, 11435003 },
	{ 25, 12286975 },
	{ 27, 28212219 },
	{ 27, 53378043 },
	{ 27, 61766651 },
	{ 27, 62618623 },
	{ 28, 95321083 },
	{ 28, 120486907 },
	{ 28, 128875515 },
	{ 28, 129727487 },
	{ 29, 259702781 },
	{ 28, 129792767 },
	{ 28, 121404159 },
	{ 28, 96238335 },
	{ 28, 125485053 },
	{ 27, 62683903 },
	{ 27, 54295295 },
	{ 27, 29129471 },
	{ 26, 24821757 },
	{ 25, 12352255 },
	{ 20, 1045914 },
	{ 20, 497134 },
	{ 25, 3701499 },
	{ 25, 11303675 },
	{ 27, 29016057 },
	{ 26, 14449403 },
	{ 26, 26770171 },
	{ 26, 30178043 },
	{ 26, 23773177 },
	{ 25, 11827963 },
	{ 25, 14711547 },
	{ 25, 3046139 },
	{ 25, 11434747 },
	{ 25, 12286719 },
	{ 27, 28211963 },
	{ 27, 53377787 },
	{ 27, 61766395 },
	{ 27, 62618367 },
	{ 28, 95320827 },
	{ 28, 120486651 },
	{ 28, 128875259 },
	{ 28, 129727231 },
	{ 29, 229538555 },
	{ 29, 254704379 },
	{ 29, 263092987 },
	{ 29, 489585403 },
	{ 29, 267960313 },
	{ 28, 134052603 },
	{ 28, 107507711 },
	{ 28, 57176063 },
	{ 27, 47377149 },
	{ 26, 23621631 },
	{ 26, 6844415 },
	{ 20, 456558 },
	{ 25, 3960827 },
	{ 25, 12087291 },
	{ 27, 19689467 },
	{ 27, 54192889 },
	{ 26, 27029499 },
	{ 26, 30961659 },
	{ 27, 42758139 },
	{ 26, 30075641 },
	{ 25, 14970875 },
	{ 25, 15757307 },
	{ 25, 3829755 },
	{ 25, 12218363 },
	{ 25, 12546047 },
	{ 27, 28995579 },
	{ 27, 54161403 },
	{ 27, 62550011 },
	{ 27, 62877695 },
	{ 28, 96104443 },
	{ 28, 121270267 },
	{ 28, 129658875 },
	{ 28, 129986559 },
	{ 29, 230322171 },
	{ 29, 255487995 },
	{ 29, 263876603 },
	{ 29, 267447033 },
	{ 28, 133787643 },
	{ 28, 117272571 },
	{ 28, 57175807 },
	{ 27, 47377405 },
	{ 26, 23621375 },
	{ 26, 6844159 },
	{ 20, 448366 },
	{ 25, 3960571 },
	{ 25, 12087035 },
	{ 27, 19689211 },
	{ 27, 54193145 },
	{ 26, 27029243 },
	{ 26, 30961403 },
	{ 27, 42757883 },
	{ 26, 30075897 },
	{ 25, 14970619 },
	{ 25, 15757051 },
	{ 25, 3829499 },
	{ 25, 12218107 },
	{ 25, 12545791 },
	{ 27, 28995323 },
	{ 27, 54161147 },
	{ 27, 62549755 },
	{ 27, 62877439 },
	{ 28, 96104187 },
	{ 28, 121270011 },
	{ 28, 129658619 },
	{ 28, 129986303 },
	{ 29, 230321915 },
	{ 29, 255487739 },
	{ 29, 263876347 },
	{ 29, 267447289 },
	{ 28, 133787387 },
	{ 28, 117272315 },
	{ 28, 57437183 },
	{ 27, 47902461 },
	{ 26, 23882751 },
	{ 26, 7105535 },
	{ 20, 440302 },
	{ 26, 24833785 },
	{ 25, 12348411 },
	{ 27, 20474875 },
	{ 27, 28077051 },
	{ 27, 62582521 },
	{ 26, 31222779 },
	{ 27, 43543547 },
	{ 27, 46951419 },
	{ 26, 32173817 },
	{ 25, 16018427 },
	{ 26, 31911673 },
	{ 25, 4090875 },
	{ 25, 12479483 },
	{ 26, 23817215 },
	{ 27, 29256699 },
	{ 27, 54422523 },
	{ 27, 62811131 },
	{ 28, 87976955 },
	{ 28, 96365563 },
	{ 28, 121531387 },
	{ 28, 129919995 },
	{ 29, 222194683 },
	{ 29, 230583291 },
	{ 29, 255749115 },
	{ 29, 265875193 },
	{ 28, 133000187 },
	{ 28, 117009403 },
	{ 28, 66939899 },
	{ 27, 47902717 },
	{ 26, 23882495 },
	{ 26, 7105279 },
	{ 20, 432110 },
	{ 26, 24834041 },
	{ 25, 12348155 },
	{ 27, 20474619 },
	{ 27, 28076795 },
	{ 27, 62582777 },
	{ 26, 31222523 },
	{ 27, 43543291 },
	{ 27, 46951163 },
	{ 26, 32174073 },
	{ 25, 16018171 },
	{ 26, 31911929 },
	{ 25, 4090619 },
	{ 25, 12479227 },
	{ 26, 23816959 },
	{ 27, 29256443 },
	{ 27, 54422267 },
	{ 27, 62810875 },
	{ 28, 87976699 },
	{ 28, 96365307 },
	{ 28, 121531131 },
	{ 28, 129919739 },
	{ 29, 222194427 },
	{ 29, 230583035 },
	{ 29, 255748859 },
	{ 29, 265875449 },
	{ 28, 132999931 },
	{ 28, 117009147 },
	{ 28, 66939643 },
	{ 27, 49478397 },
	{ 26, 24657919 },
	{ 26, 7880703 },
	{ 20, 519534 },
	{ 26, 7094267 },
	{ 26, 23609339 },
	{ 27, 20725755 },
	{ 27, 28852219 },
	{ 27, 53231611 },
	{ 27, 61358075 },
	{ 27, 43794427 },
	{ 27, 47726587 },
	{ 27, 59523067 },
	{ 27, 55245561 },
	{ 26, 27541499 },
	{ 26, 28327931 },
	{ 26, 6963195 },
	{ 26, 23740411 },
	{ 26, 24068095 },
	{ 28, 57294843 },
	{ 28, 107626491 },
	{ 28, 124403707 },
	{ 28, 124731391 },
	{ 29, 191512571 },
	{ 29, 241844219 },
	{ 29, 258621435 },
	{ 29, 242040827 },
	{ 29, 192495611 },
	{ 29, 265353977 },
	{ 28, 132726779 },
	{ 28, 116211707 },
	{ 28, 66666491 },
	{ 27, 49478653 },
	{ 26, 24657663 },
	{ 26, 7880447 },
	{ 20, 503150 },
	{ 26, 7094011 },
	{ 26, 23609083 },
	{ 27, 20725499 },
	{ 27, 28851963 },
	{ 27, 53231355 },
	{ 27, 61357819 },
	{ 27, 43794171 },
	{ 27, 47726331 },
	{ 27, 59522811 },
	{ 27, 55245817 },
	{ 26, 27541243 },
	{ 26, 28327675 },
	{ 26, 6962939 },
	{ 26, 23740155 },
	{ 26, 24067839 },
	{ 28, 57294587 },
	{ 28, 107626235 },
	{ 28, 124403451 },
	{ 28, 124731135 },
	{ 29, 191512315 },
	{ 29, 241843963 },
	{ 29, 258621179 },
	{ 29, 242040571 },
	{ 29, 192495355 },
	{ 29, 265354233 },
	{ 28, 132726523 },
	{ 28, 116211451 },
	{ 28, 66666235 },
	{ 27, 50003709 },
	{ 26, 24919039 },
	{ 26, 8141823 },
	{ 20, 486894 },
	{ 26, 7879675 },
	{ 26, 23870459 },
	{ 28, 58392313 },
	{ 27, 29113339 },
	{ 27, 54017019 },
	{ 27, 61619195 },
	{ 28, 96141049 },
	{ 27, 47987707 },
	{ 27, 60308475 },
	{ 27, 66911993 },
	{ 26, 66534395 },
	{ 26, 28589051 },
	{ 26, 31472635 },
	{ 26, 7224315 },
	{ 26, 24001531 },
	{ 26, 24853503 },
	{ 28, 57555963 },
	{ 28, 107887611 },
	{ 28, 124664827 },
	{ 28, 125516799 },
	{ 29, 259587833 },
	{ 28, 129842171 },
	{ 29, 258882555 },
	{ 29, 191708155 },
	{ 29, 251199225 },
	{ 28, 125647867 },
	{ 28, 115948539 },
	{ 28, 65879035 },
	{ 27, 66649849 },
	{ 26, 33373179 },
	{ 26, 8141567 },
	{ 20, 470510 },
	{ 26, 7879419 },
	{ 26, 23870203 },
	{ 28, 58392569 },
	{ 27, 29113083 },
	{ 27, 54016763 },
	{ 27, 61618939 },
	{ 28, 96141305 },
	{ 27, 47987451 },
	{ 27, 60308219 },
	{ 27, 66912249 },
	{ 26, 66534139 },
	{ 26, 28588795 },
	{ 26, 31472379 },
	{ 26, 7224059 },
	{ 26, 24001275 },
	{ 26, 24853247 },
	{ 28, 57555707 },
	{ 28, 107887355 },
	{ 28, 124664571 },
	{ 28, 125516543 },
	{ 29, 259588089 },
	{ 28, 129841915 },
	{ 29, 258882299 },
	{ 29, 191707899 },
	{ 29, 251199481 },
	{ 28, 125647611 },
	{ 28, 115948283 },
	{ 28, 65878779 },
	{ 27, 66650105 },
	{ 26, 33372923 },
	{ 26, 15216639 },
	{ 20, 388974 },
	{ 26, 8138747 },
	{ 26, 24653819 },
	{ 28, 40644603 },
	{ 28, 57159675 },
	{ 27, 54276091 },
	{ 27, 62402555 },
	{ 28, 86781947 },
	{ 28, 94908411 },
	{ 27, 60567547 },
	{ 27, 64499707 },
	{ 26, 66465791 },
	{ 26, 65482747 },
	{ 26, 31731707 },
	{ 26, 32518139 },
	{ 26, 8007675 },
	{ 26, 24784891 },
	{ 26, 25112575 },
	{ 28, 58339323 },
	{ 28, 108670971 },
	{ 28, 125448187 },
	{ 28, 125775871 },
	{ 28, 129576955 },
	{ 28, 121450491 },
	{ 29, 259665915 },
	{ 29, 174927867 },
	{ 28, 125382651 },
	{ 28, 108867579 },
	{ 28, 65613819 },
	{ 28, 132229881 },
	{ 26, 33107963 },
	{ 26, 16592891 },
	{ 20, 372590 },
	{ 26, 8138491 },
	{ 26, 24653563 },
	{ 28, 40644347 },
	{ 28, 57159419 },
	{ 27, 54275835 },
	{ 27, 62402299 },
	{ 28, 86781691 },
	{ 28, 94908155 },
	{ 27, 60567291 },
	{ 27, 64499451 },
	{ 26, 66465535 },
	{ 26, 65482491 },
	{ 26, 31731451 },
	{ 26, 32517883 },
	{ 26, 8007419 },
	{ 26, 24784635 },
	{ 26, 25112319 },
	{ 28, 58339067 },
	{ 28, 108670715 },
	{ 28, 125447931 },
	{ 28, 125775615 },
	{ 28, 129576699 },
	{ 28, 121450235 },
	{ 29, 259665659 },
	{ 29, 174927611 },
	{ 28, 125382395 },
	{ 28, 108867323 },
	{ 28, 65613563 },
	{ 28, 132230137 },
	{ 26, 33107707 },
	{ 26, 16592635 },
	{ 20, 356334 },
	{ 26, 15215611 },
	{ 26, 24914939 },
	{ 28, 41430011 },
	{ 28, 57420795 },
	{ 28, 107490299 },
	{ 27, 62663675 },
	{ 28, 87567355 },
	{ 28, 95169531 },
	{ 28, 120073211 },
	{ 27, 64760827 },
	{ 28, 133017341 },
	{ 26, 65416191 },
	{ 26, 62335995 },
	{ 26, 32779259 },
	{ 26, 60828667 },
	{ 26, 8268795 },
	{ 26, 25046011 },
	{ 26, 32189439 },
	{ 28, 58600443 },
	{ 28, 108932091 },
	{ 28, 125709307 },
	{ 28, 128789499 },
	{ 28, 121187323 },
	{ 28, 96283643 },
	{ 29, 259927035 },
	{ 28, 124595195 },
	{ 28, 108604411 },
	{ 28, 58534907 },
	{ 28, 129085177 },
	{ 26, 32320507 },
	{ 26, 16329723 },
	{ 20, 339950 },
	{ 26, 15215355 },
	{ 26, 24914683 },
	{ 28, 41429755 },
	{ 28, 57420539 },
	{ 28, 107490043 },
	{ 27, 62663419 },
	{ 28, 87567099 },
	{ 28, 95169275 },
	{ 28, 120072955 },
	{ 27, 64760571 },
	{ 28, 133017597 },
	{ 26, 65415935 },
	{ 26, 62335739 },
	{ 26, 32779003 },
	{ 26, 60828411 },
	{ 26, 8268539 },
	{ 26, 25045755 },
	{ 26, 32189183 },
	{ 28, 58600187 },
	{ 28, 108931835 },
	{ 28, 125709051 },
	{ 27, 66985983 },
	{ 27, 62791679 },
	{ 27, 50208767 },
	{ 27, 46014463 },
	{ 26, 33431551 },
	{ 26, 29237247 },
	{ 26, 16654335 },
	{ 26, 12460031 },
	{ 24, 8265727 },
	{ 24, 4071423 },
	{ 19, 261486 },
	{ 24, 3874811 },
	{ 24, 8003579 },
	{ 26, 10428411 },
	{ 26, 14557179 },
	{ 26, 26943483 },
	{ 26, 31072251 },
	{ 26, 21962747 },
	{ 26, 23994363 },
	{ 26, 30089211 },
	{ 26, 32120827 },
	{ 26, 27729915 },
	{ 26, 28712955 },
	{ 24, 15572991 },
	{ 24, 15327227 },
	{ 24, 15278075 },
	{ 24, 15474683 },
	{ 24, 3842043 },
	{ 24, 8036347 },
	{ 24, 8118271 },
	{ 26, 16424955 },
	{ 26, 29007867 },
	{ 26, 33202171 },
	{ 26, 30105595 },
	{ 26, 24010747 },
	{ 26, 21979131 },
	{ 26, 31088635 },
	{ 26, 26959867 },
	{ 26, 14573563 },
	{ 26, 10444795 },
	{ 24, 8019963 },
	{ 24, 3891195 },
	{ 19, 245102 },
	{ 24, 3874555 },
	{ 24, 8003323 },
	{ 26, 10428155 },
	{ 26, 14556923 },
	{ 26, 26943227 },
	{ 26, 31071995 },
	{ 26, 21962491 },
	{ 26, 23994107 },
	{ 26, 30088955 },
	{ 26, 32120571 },
	{ 26, 27729659 },
	{ 26, 28712699 },
	{ 24, 15572735 },
	{ 24, 15326971 },
	{ 24, 15277819 },
	{ 24, 15474427 },
	{ 24, 3841787 },
	{ 24, 8036091 },
	{ 24, 8118015 },
	{ 26, 16424699 },
	{ 26, 29007611 },
	{ 26, 33201915 },
	{ 26, 30105339 },
	{ 26, 24010491 },
	{ 26, 21978875 },
	{ 26, 31088379 },
	{ 26, 26959611 },
	{ 26, 14573307 },
	{ 26, 10444539 },
	{ 24, 8019707 },
	{ 24, 3890939 },
	{ 19, 228846 },
	{ 24, 4070395 },
	{ 24, 8068091 },
	{ 26, 12196859 },
	{ 26, 14621691 },
	{ 26, 27139067 },
	{ 26, 31136763 },
	{ 27, 43654139 },
	{ 26, 24058875 },
	{ 26, 30284795 },
	{ 26, 32185339 },
	{ 26, 33020923 },
	{ 26, 28777467 },
	{ 26, 31857659 },
	{ 24, 15309823 },
	{ 24, 8248315 },
	{ 24, 15539195 },
	{ 24, 16260091 },
	{ 24, 3906555 },
	{ 24, 8100859 },
	{ 24, 8313855 },
	{ 26, 16489467 },
	{ 25, 16210939 },
	{ 26, 33266683 },
	{ 26, 23813115 },
	{ 26, 21912571 },
	{ 25, 15686651 },
	{ 26, 26893307 },
	{ 26, 14375931 },
	{ 26, 10378235 },
	{ 24, 6249467 },
	{ 24, 3824635 },
	{ 19, 212462 },
	{ 24, 4070139 },
	{ 24, 8067835 },
	{ 26, 12196603 },
	{ 26, 14621435 },
	{ 26, 27138811 },
	{ 26, 31136507 },
	{ 27, 43653883 },
	{ 26, 24058619 },
	{ 26, 30284539 },
	{ 26, 32185083 },
	{ 26, 33020667 },
	{ 26, 28777211 },
	{ 26, 31857403 },
	{ 24, 15309567 },
	{ 24, 8248059 },
	{ 24, 15538939 },
	{ 24, 16259835 },
	{ 24, 3906299 },
	{ 24, 8100603 },
	{ 24, 8313599 },
	{ 26, 16489211 },
	{ 25, 16210683 },
	{ 26, 33266427 },
	{ 26, 23812859 },
	{ 26, 21912315 },
	{ 25, 15686395 },
	{ 26, 26893051 },
	{ 26, 14375675 },
	{ 26, 10377979 },
	{ 24, 6249211 },
	{ 24, 3824379 },
	{ 19, 130926 },
	{ 24, 4132859 },
	{ 24, 8261627 },
	{ 26, 12259323 },
	{ 26, 16388091 },
	{ 26, 27201531 },
	{ 26, 31330299 },
	{ 27, 43716603 },
	{ 27, 47845371 },
	{ 26, 30347259 },
	{ 26, 32378875 },
	{ 26, 33001471 },
	{ 26, 31969275 },
	{ 26, 31920123 },
	{ 26, 32903163 },
	{ 24, 8228863 },
	{ 24, 7983099 },
	{ 24, 16322555 },
	{ 24, 16519163 },
	{ 24, 4100091 },
	{ 24, 8294395 },
	{ 24, 8376319 },
	{ 25, 16142331 },
	{ 25, 15159291 },
	{ 26, 33460219 },
	{ 26, 21712891 },
	{ 25, 15618043 },
	{ 25, 13586427 },
	{ 26, 14307323 },
	{ 26, 10178555 },
	{ 24, 6180859 },
	{ 24, 2052091 },
	{ 19, 114542 },
	{ 24, 4132603 },
	{ 24, 8261371 },
	{ 26, 12259067 },
	{ 26, 16387835 },
	{ 26, 27201275 },
	{ 26, 31330043 },
	{ 27, 43716347 },
	{ 27, 47845115 },
	{ 26, 30347003 },
	{ 26, 32378619 },
	{ 26, 33001215 },
	{ 26, 31969019 },
	{ 26, 31919867 },
	{ 26, 32902907 },
	{ 24, 8228607 },
	{ 24, 7982843 },
	{ 24, 16322299 },
	{ 24, 16518907 },
	{ 24, 4099835 },
	{ 24, 8294139 },
	{ 24, 8376063 },
	{ 25, 16142075 },
	{ 25, 15159035 },
	{ 26, 33459963 },
	{ 26, 21712635 },
	{ 25, 15617787 },
	{ 25, 13586171 },
	{ 26, 14307067 },
	{ 26, 10178299 },
	{ 24, 6180603 },
	{ 24, 2051835 },
	{ 19, 98286 },
	{ 24, 3821311 },
	{ 24, 8326139 },
	{ 26, 12454907 },
	{ 26, 16452603 },
	{ 26, 28969979 },
	{ 26, 31394811 },
	{ 27, 43912187 },
	{ 27, 47909883 },
	{ 27, 60427259 },
	{ 26, 32443387 },
	{ 27, 55446523 },
	{ 26, 31951871 },
	{ 26, 28822523 },
	{ 26, 32967675 },
	{ 26, 61213691 },
	{ 24, 7965695 },
	{ 24, 7195643 },
	{ 24, 16583675 },
	{ 24, 7883771 },
	{ 24, 4164603 },
	{ 24, 8358907 },
	{ 25, 15944699 },
	{ 25, 15092731 },
	{ 25, 12012539 },
	{ 26, 33524731 },
	{ 25, 15420411 },
	{ 25, 13519867 },
	{ 25, 7293947 },
	{ 26, 10111995 },
	{ 24, 5983227 },
	{ 24, 1985531 },
	{ 19, 81902 },
	{ 24, 2051071 },
	{ 24, 8325883 },
	{ 26, 12454651 },
	{ 26, 16452347 },
	{ 26, 28969723 },
	{ 26, 31394555 },
	{ 27, 43911931 },
	{ 27, 47909627 },
	{ 27, 60427003 },
	{ 26, 32443131 },
	{ 27, 55446267 },
	{ 26, 31951615 },
	{ 26, 28822267 },
	{ 26, 32967419 },
	{ 26, 61213435 },
	{ 24, 7965439 },
	{ 24, 7195387 },
	{ 24, 16583419 },
	{ 24, 7883515 },
	{ 24, 4164347 },
	{ 24, 8358651 },
	{ 25, 15944443 },
	{ 25, 15092475 },
	{ 25, 12012283 },
	{ 26, 33524475 },
	{ 25, 15420155 },
	{ 25, 13519611 },
	{ 25, 7293691 },
	{ 26, 10111739 },
	{ 24, 5982971 },
	{ 24, 1985275 },
	{ 19, 77214 },
	{ 24, 2050815 },
	{ 24, 6245119 },
	{ 24, 3131387 },
	{ 24, 4163579 },
	{ 24, 7260155 },
	{ 24, 8292347 },
	{ 25, 10995707 },
	{ 25, 12027899 },
	{ 25, 15124475 },
	{ 25, 16156667 },
	{ 25, 13879291 },
	{ 25, 14387195 },
	{ 24, 7202815 },
	{ 24, 6944763 },
	{ 24, 15321083 },
	{ 24, 15566843 },
	{ 22, 1796095 },
	{ 22, 1734651 },
	{ 22, 1718267 },
	{ 22, 1775611 },
	{ 22, 1726459 },
	{ 23, 3971067 },
	{ 23, 3725307 },
	{ 23, 2988027 },
	{ 23, 2742267 },
	{ 23, 3839995 },
	{ 23, 3332091 },
	{ 23, 1808379 },
	{ 23, 1300475 },
	{ 22, 1480699 },
	{ 22, 448507 },
	{ 17, 60702 },
	{ 22, 497663 },
	{ 22, 1546239 },
	{ 24, 3131131 },
	{ 24, 4163323 },
	{ 24, 7259899 },
	{ 24, 8292091 },
	{ 25, 10995451 },
	{ 25, 12027643 },
	{ 25, 15124219 },
	{ 25, 16156411 },
	{ 25, 13879035 },
	{ 25, 14386939 },
	{ 24, 7202559 },
	{ 24, 6944507 },
	{ 24, 15320827 },
	{ 24, 15566587 },
	{ 22, 1795839 },
	{ 22, 1734395 },
	{ 22, 1718011 },
	{ 22, 1775355 },
	{ 22, 1726203 },
	{ 23, 3970811 },
	{ 23, 3725051 },
	{ 23, 2987771 },
	{ 23, 2742011 },
	{ 23, 3839739 },
	{ 23, 3331835 },
	{ 23, 1808123 },
	{ 23, 1300219 },
	{ 22, 1480443 },
	{ 22, 448251 },
	{ 17, 44318 },
	{ 22, 497407 },
	{ 22, 1545983 },
	{ 24, 2594559 },
	{ 24, 4178939 },
	{ 24, 7308283 },
	{ 24, 8307707 },
	{ 25, 11437051 },
	{ 25, 12043259 },
	{ 25, 15172603 },
	{ 25, 16172027 },
	{ 24, 8123387 },
	{ 24, 8107003 },
	{ 24, 8057851 },
	{ 24, 8041467 },
	{ 23, 4060155 },
	{ 23, 4043771 },
	{ 23, 3994619 },
	{ 22, 1729535 },
	{ 21, 1012731 },
	{ 21, 996347 },
	{ 22, 1709051 },
	{ 21, 1004539 },
	{ 23, 3707899 },
	{ 23, 2937851 },
	{ 23, 2724859 },
	{ 22, 1954811 },
	{ 23, 3314683 },
	{ 23, 1758203 },
	{ 23, 1283067 },
	{ 21, 775163 },
	{ 22, 431099 },
	{ 16, 14238 },
	{ 22, 447487 },
	{ 22, 1496063 },
	{ 24, 2544639 },
	{ 24, 4178683 },
	{ 24, 7308027 },
	{ 24, 8307451 },
	{ 25, 11436795 },
	{ 25, 12043003 },
	{ 25, 15172347 },
	{ 25, 16171771 },
	{ 24, 8123131 },
	{ 24, 8106747 },
	{ 24, 8057595 },
	{ 24, 8041211 },
	{ 23, 4059899 },
	{ 23, 4043515 },
	{ 23, 3994363 },
	{ 22, 1729279 },
	{ 21, 1012475 },
	{ 21, 996091 },
	{ 22, 1708795 },
	{ 21, 1004283 },
	{ 23, 3707643 },
	{ 23, 2937595 },
	{ 23, 2724603 },
	{ 22, 1954555 },
	{ 23, 3314427 },
	{ 23, 1757947 },
	{ 23, 1282811 },
	{ 21, 774907 },
	{ 22, 430843 },
	{ 16, 6046 },
	{ 22, 447231 },
	{ 22, 1495807 },
	{ 23, 4192767 },
	{ 23, 3931643 },
	{ 22, 1831419 },
	{ 22, 2089467 },
	{ 23, 2863611 },
	{ 23, 3121659 },
	{ 23, 3797499 },
	{ 23, 4055547 },
	{ 22, 2030079 },
	{ 22, 1900027 },
	{ 22, 1895931 },
	{ 22, 1883643 },
	{ 21, 1014271 },
	{ 21, 949755 },
	{ 21, 945659 },
	{ 21, 933371 },
	{ 19, 252415 },
	{ 19, 237051 },
	{ 19, 232955 },
	{ 19, 247291 },
	{ 19, 235003 },
	{ 21, 730619 },
	{ 21, 669179 },
	{ 20, 484859 },
	{ 20, 423419 },
	{ 21, 435707 },
	{ 21, 308731 },
	{ 19, 189947 },
	{ 19, 62971 },
	{ 14, 10014 },
	{ 20, 108031 },
	{ 20, 370175 },
	{ 22, 632319 },
	{ 22, 894463 },
	{ 22, 1832185 },
	{ 22, 2090233 },
	{ 23, 7661817 },
	{ 23, 4122873 },
	{ 23, 3991801 },
	{ 23, 3598585 },
	{ 22, 2030845 },
	{ 22, 2025721 },
	{ 22, 1894649 },
	{ 22, 1501433 },
	{ 21, 982269 },
	{ 21, 977145 },
	{ 21, 846073 },
	{ 21, 452857 },
	{ 19, 195837 },
	{ 19, 190713 },
	{ 19, 59641 },
	{ 19, 246009 },
	{ 19, 233721 },
	{ 21, 729337 },
	{ 21, 667897 },
	{ 20, 483577 },
	{ 20, 422137 },
	{ 21, 434425 },
	{ 21, 307449 },
	{ 19, 188665 },
	{ 19, 61689 },
	{ 14, 1898 },
	{ 20, 106749 },
	{ 20, 368893 },
	{ 22, 631037 },
	{ 22, 893181 },
	{ 22, 1832441 },
	{ 22, 2090489 },
	{ 23, 7662073 },
	{ 23, 4123129 },
	{ 23, 3992057 },
	{ 23, 3598841 },
	{ 22, 2031101 },
	{ 22, 2025977 },
	{ 22, 1894905 },
	{ 22, 1501689 },
	{ 21, 982525 },
	{ 21, 977401 },
	{ 21, 846329 },
	{ 21, 453113 },
	{ 19, 196093 },
	{ 19, 190969 },
	{ 19, 59897 },
	{ 19, 246265 },
	{ 19, 233977 },
	{ 21, 729593 },
	{ 21, 668153 },
	{ 20, 483833 },
	{ 20, 422393 },
	{ 21, 434681 },
	{ 21, 307705 },
	{ 19, 188921 },
	{ 19, 61945 },
	{ 14, 10090 },
	{ 20, 107005 },
	{ 20, 369149 },
	{ 22, 631293 },
	{ 22, 893437 },
	{ 22, 1679869 },
	{ 22, 1942013 },
	{ 23, 2728445 },
	{ 23, 2990589 },
	{ 23, 3777021 },
	{ 23, 4039165 },
	{ 24, 6922749 },
	{ 24, 8106749 },
	{ 24, 8053497 },
	{ 24, 7529209 },
	{ 24, 5956345 },
	{ 23, 3912445 },
	{ 23, 3859193 },
	{ 23, 3334905 },
	{ 23, 1762041 },
	{ 21, 766717 },
	{ 21, 713465 },
	{ 21, 189177 },
	{ 21, 918265 },
	{ 21, 738041 },
	{ 23, 2654969 },
	{ 22, 1884921 },
	{ 22, 1671929 },
	{ 22, 901881 },
	{ 23, 1213177 },
	{ 21, 705273 },
	{ 21, 230137 },
	{ 16, 5610 },
	{ 21, 246525 },
	{ 21, 770813 },
	{ 23, 1295101 },
	{ 23, 1819389 },
	{ 23, 3392253 },
	{ 23, 3916541 },
	{ 24, 5489405 },
	{ 24, 6013693 },
	{ 24, 7586557 },
	{ 24, 8110845 },
	{ 25, 14345209 },
	{ 24, 8107005 },
	{ 24, 8053753 },
	{ 24, 7529465 },
	{ 24, 5956601 },
	{ 23, 3912701 },
	{ 23, 3859449 },
	{ 23, 3335161 },
	{ 23, 1762297 },
	{ 21, 766973 },
	{ 21, 713721 },
	{ 21, 189433 },
	{ 21, 918521 },
	{ 21, 738297 },
	{ 23, 2655225 },
	{ 22, 1885177 },
	{ 22, 1672185 },
	{ 22, 902137 },
	{ 23, 1213433 },
	{ 21, 705529 },
	{ 21, 230393 },
	{ 16, 13802 },
	{ 21, 246781 },
	{ 21, 771069 },
	{ 23, 1295357 },
	{ 23, 1819645 },
	{ 23, 3392509 },
	{ 23, 3916797 },
	{ 24, 5489661 },
	{ 24, 6013949 },
	{ 24, 7586813 },
	{ 24, 8111101 },
	{ 25, 15902457 },
	{ 25, 14329593 },
	{ 24, 8058621 },
	{ 24, 8038137 },
	{ 24, 7513849 },
	{ 24, 5940985 },
	{ 23, 3864317 },
	{ 23, 3843833 },
	{ 23, 3319545 },
	{ 23, 1746681 },
	{ 21, 718589 },
	{ 21, 698105 },
	{ 21, 173817 },
	{ 21, 722681 },
	{ 21, 673529 },
	{ 22, 1869561 },
	{ 22, 1623801 },
	{ 22, 886521 },
	{ 22, 640761 },
	{ 21, 689913 },
	{ 21, 182009 },
	{ 16, 21866 },
	{ 21, 231165 },
	{ 21, 755453 },
	{ 23, 1279741 },
	{ 23, 1804029 },
	{ 23, 3376893 },
	{ 23, 3901181 },
	{ 24, 5474045 },
	{ 24, 5998333 },
	{ 24, 7571197 },
	{ 24, 8095485 },
	{ 25, 15902713 },
	{ 25, 14329849 },
	{ 24, 8058877 },
	{ 24, 8038393 },
	{ 24, 7514105 },
	{ 24, 5941241 },
	{ 23, 3864573 },
	{ 23, 3844089 },
	{ 23, 3319801 },
	{ 23, 1746937 },
	{ 21, 718845 },
	{ 21, 698361 },
	{ 21, 174073 },
	{ 21, 722937 },
	{ 21, 673785 },
	{ 22, 1869817 },
	{ 22, 1624057 },
	{ 22, 886777 },
	{ 22, 641017 },
	{ 21, 690169 },
	{ 21, 182265 },
	{ 16, 30058 },
	{ 21, 231421 },
	{ 21, 755709 },
	{ 23, 1279997 },
	{ 23, 1804285 },
	{ 23, 3377149 },
	{ 23, 3901437 },
	{ 24, 5474301 },
	{ 24, 5998589 },
	{ 24, 7571453 },
	{ 24, 8095741 },
	{ 25, 13862909 },
	{ 25, 14387197 },
	{ 25, 15960061 },
	{ 25, 16484349 },
	{ 25, 16222969 },
	{ 25, 15174393 },
	{ 25, 12028665 },
	{ 25, 10980089 },
	{ 24, 7834361 },
	{ 24, 6785785 },
	{ 24, 3640057 },
	{ 23, 2804477 },
	{ 22, 1542905 },
	{ 22, 494329 },
	{ 23, 2624249 },
	{ 22, 1903353 },
	{ 24, 6425337 },
	{ 24, 3345145 },
	{ 24, 2493177 },
	{ 22, 1510137 },
	{ 23, 658169 },
	{ 17, 19434 },
	{ 23, 723709 },
	{ 23, 2820861 },
	{ 25, 4918013 },
	{ 25, 7015165 },
	{ 25, 13306621 },
	{ 25, 15403773 },
	{ 26, 66554873 },
	{ 26, 65506297 },
	{ 26, 62360569 },
	{ 26, 61311993 },
	{ 26, 33000441 },
	{ 26, 31951865 },
	{ 26, 28806137 },
	{ 26, 27757561 },
	{ 25, 16223225 },
	{ 25, 15174649 },
	{ 25, 12028921 },
	{ 25, 10980345 },
	{ 24, 7834617 },
	{ 24, 6786041 },
	{ 24, 3640313 },
	{ 23, 2804733 },
	{ 22, 1543161 },
	{ 22, 494585 },
	{ 23, 2624505 },
	{ 22, 1903609 },
	{ 24, 6425593 },
	{ 24, 3345401 },
	{ 24, 2493433 },
	{ 22, 1510393 },
	{ 23, 658425 },
	{ 17, 23530 },
	{ 23, 723965 },
	{ 23, 2821117 },
	{ 25, 4918269 },
	{ 25, 7015421 },
	{ 25, 13306877 },
	{ 25, 15404029 },
	{ 26, 66572029 },
	{ 26, 66490105 },
	{ 26, 65441529 },
	{ 26, 62295801 },
	{ 26, 61247225 },
	{ 26, 32935673 },
	{ 26, 31887097 },
	{ 26, 28741369 },
	{ 25, 16240381 },
	{ 25, 16158457 },
	{ 25, 15109881 },
	{ 25, 11964153 },
	{ 24, 7851773 },
	{ 24, 7769849 },
	{ 24, 6721273 },
	{ 24, 3575545 },
	{ 22, 1560317 },
	{ 22, 1478393 },
	{ 22, 429817 },
	{ 22, 1838841 },
	{ 22, 1642233 },
	{ 24, 3280633 },
	{ 24, 2297593 },
	{ 22, 1445625 },
	{ 22, 462585 },
	{ 17, 27498 },
	{ 23, 659197 },
	{ 23, 2756349 },
	{ 25, 4853501 },
	{ 25, 6950653 },
	{ 25, 13242109 },
	{ 25, 15339261 },
	{ 26, 21630717 },
	{ 26, 66490361 },
	{ 26, 65441785 },
	{ 26, 62296057 },
	{ 26, 61247481 },
	{ 26, 32935929 },
	{ 26, 31887353 },
	{ 26, 28741625 },
	{ 25, 16240637 },
	{ 25, 16158713 },
	{ 25, 15110137 },
	{ 25, 11964409 },
	{ 24, 7852029 },
	{ 24, 7770105 },
	{ 24, 6721529 },
	{ 24, 3575801 },
	{ 22, 1560573 },
	{ 22, 1478649 },
	{ 22, 430073 },
	{ 22, 1839097 },
	{ 22, 1642489 },
	{ 24, 3280889 },
	{ 24, 2297849 },
	{ 22, 1445881 },
	{ 22, 462841 },
	{ 17, 31594 },
	{ 23, 659453 },
	{ 23, 2756605 },
	{ 25, 4853757 },
	{ 25, 6950909 },
	{ 25, 13242365 },
	{ 25, 15339517 },
	{ 26, 21630973 },
	{ 26, 66509565 },
	{ 26, 66296569 },
	{ 26, 65247993 },
	{ 26, 62102265 },
	{ 26, 61053689 },
	{ 26, 32742137 },
	{ 26, 31693561 },
	{ 26, 28547833 },
	{ 25, 16177917 },
	{ 25, 15964921 },
	{ 25, 14916345 },
	{ 25, 11770617 },
	{ 24, 7789309 },
	{ 24, 7576313 },
	{ 24, 6527737 },
	{ 24, 3382009 },
	{ 22, 1497853 },
	{ 22, 1284857 },
	{ 22, 236281 },
	{ 22, 1579769 },
	{ 22, 858873 },
	{ 24, 2235129 },
	{ 22, 1252089 },
	{ 22, 400121 },
	{ 17, 51690 },
	{ 22, 465661 },
	{ 22, 1514237 },
	{ 24, 2562813 },
	{ 24, 3611389 },
	{ 24, 6757117 },
	{ 24, 7805693 },
	{ 25, 10951421 },
	{ 25, 11999997 },
	{ 25, 15145725 },
	{ 25, 16194301 },
	{ 26, 62102521 },
	{ 26, 61053945 },
	{ 26, 32742393 },
	{ 26, 31693817 },
	{ 26, 28548089 },
	{ 25, 16178173 },
	{ 25, 15965177 },
	{ 25, 14916601 },
	{ 25, 11770873 },
	{ 24, 7789565 },
	{ 24, 7576569 },
	{ 24, 6527993 },
	{ 24, 3382265 },
	{ 22, 1498109 },
	{ 22, 1285113 },
	{ 22, 236537 },
	{ 22, 1580025 },
	{ 22, 859129 },
	{ 24, 2235385 },
	{ 22, 1252345 },
	{ 22, 400377 },
	{ 17, 55786 },
	{ 22, 465917 },
	{ 22, 1514493 },
	{ 24, 2563069 },
	{ 24, 3611645 },
	{ 24, 6757373 },
	{ 24, 7805949 },
	{ 25, 10951677 },
	{ 25, 12000253 },
	{ 25, 15145981 },
	{ 25, 16194557 },
	{ 26, 65183481 },
	{ 26, 62037753 },
	{ 26, 60989177 },
	{ 26, 32677625 },
	{ 26, 31629049 },
	{ 26, 28483321 },
	{ 25, 15982333 },
	{ 25, 15900409 },
	{ 25, 14851833 },
	{ 25, 11706105 },
	{ 24, 7593725 },
	{ 24, 7511801 },
	{ 24, 6463225 },
	{ 24, 3317497 },
	{ 22, 1302269 },
	{ 22, 1220345 },
	{ 22, 171769 },
	{ 22, 794361 },
	{ 22, 597753 },
	{ 22, 1187577 },
	{ 22, 204537 },
	{ 17, 59754 },
	{ 22, 401149 },
	{ 22, 1449725 },
	{ 24, 2498301 },
	{ 24, 3546877 },
	{ 24, 6692605 },
	{ 24, 7741181 },
	{ 25, 10886909 },
	{ 25, 11935485 },
	{ 25, 15081213 },
	{ 25, 16129789 },
	{ 26, 65183737 },
	{ 26, 62038009 },
	{ 26, 60989433 },
	{ 26, 32677881 },
	{ 26, 31629305 },
	{ 26, 28483577 },
	{ 25, 15982589 },
	{ 25, 15900665 },
	{ 25, 14852089 },
	{ 25, 11706361 },
	{ 24, 7593981 },
	{ 24, 7512057 },
	{ 24, 6463481 },
	{ 24, 3317753 },
	{ 22, 1302525 },
	{ 22, 1220601 },
	{ 22, 172025 },
	{ 22, 794617 },
	{ 22, 598009 },
	{ 22, 1187833 },
	{ 22, 204793 },
	{ 17, 63850 },
	{ 22, 401405 },
	{ 22, 1449981 },
	{ 24, 2498557 },
	{ 24, 3547133 },
	{ 24, 6692861 },
	{ 24, 7741437 },
	{ 25, 10887165 },
	{ 25, 11935741 },
	{ 25, 15081469 },
	{ 25, 16130045 },
	{ 26, 66464505 },
	{ 26, 65415929 },
	{ 26, 62270201 },
	{ 26, 61221625 },
	{ 26, 32910073 },
	{ 26, 31861497 },
	{ 26, 28715769 },
	{ 26, 27667193 },
	{ 25, 16132857 },
	{ 25, 15084281 },
	{ 25, 11938553 },
	{ 25, 10889977 },
	{ 24, 7744249 },
	{ 24, 6695673 },
	{ 24, 3549945 },
	{ 24, 2501369 },
	{ 22, 1452793 },
	{ 22, 404217 },
	{ 24, 2108153 },
	{ 22, 1321721 },
	{ 24, 535289 },
	{ 16, 21226 },
	{ 24, 797437 },
	{ 24, 4991741 },
	{ 26, 9186045 },
	{ 26, 13380349 },
	{ 26, 25963261 },
	{ 26, 30157565 },
	{ 27, 42740477 },
	{ 27, 46934781 },
	{ 27, 59517693 },
	{ 27, 63711997 },
	{ 26, 66464761 },
	{ 26, 65416185 },
	{ 26, 62270457 },
	{ 26, 61221881 },
	{ 26, 32910329 },
	{ 26, 31861753 },
	{ 26, 28716025 },
	{ 26, 27667449 },
	{ 25, 16133113 },
	{ 25, 15084537 },
	{ 25, 11938809 },
	{ 25, 10890233 },
	{ 24, 7744505 },
	{ 24, 6695929 },
	{ 24, 3550201 },
	{ 24, 2501625 },
	{ 22, 1453049 },
	{ 22, 404473 },
	{ 24, 2108409 },
	{ 22, 1321977 },
	{ 24, 535545 },
	{ 16, 22250 },
	{ 24, 797693 },
	{ 24, 4991997 },
	{ 26, 9186301 },
	{ 26, 13380605 },
	{ 26, 25963517 },
	{ 26, 30157821 },
	{ 27, 42740733 },
	{ 27, 46935037 },
	{ 27, 59517949 },
	{ 27, 63712253 },
	{ 26, 66531069 },
	{ 26, 66203385 },
	{ 26, 65154809 },
	{ 26, 62009081 },
	{ 26, 60960505 },
	{ 26, 32648953 },
	{ 26, 31600377 },
	{ 26, 28454649 },
	{ 25, 16199421 },
	{ 25, 15871737 },
	{ 25, 14823161 },
	{ 25, 11677433 },
	{ 24, 7810813 },
	{ 24, 7483129 },
	{ 24, 6434553 },
	{ 24, 3288825 },
	{ 22, 1519357 },
	{ 22, 1191673 },
	{ 22, 143097 },
	{ 17, 46457 },
	{ 19, 261561 },
	{ 16, 23146 },
	{ 24, 536317 },
	{ 24, 4730621 },
	{ 26, 8924925 },
	{ 26, 13119229 },
	{ 26, 25702141 },
	{ 26, 29896445 },
	{ 27, 42479357 },
	{ 27, 46673661 },
	{ 27, 59256573 },
	{ 27, 63450877 },
	{ 26, 66531325 },
	{ 26, 66203641 },
	{ 26, 65155065 },
	{ 26, 62009337 },
	{ 26, 60960761 },
	{ 26, 32649209 },
	{ 26, 31600633 },
	{ 26, 28454905 },
	{ 25, 16199677 },
	{ 25, 15871993 },
	{ 25, 14823417 },
	{ 25, 11677689 },
	{ 24, 7811069 },
	{ 24, 7483385 },
	{ 24, 6434809 },
	{ 24, 3289081 },
	{ 22, 1519613 },
	{ 22, 1191929 },
	{ 22, 143353 },
	{ 17, 48505 },
	{ 18, 130745 },
	{ 16, 24170 },
	{ 24, 536573 },
	{ 24, 4730877 },
	{ 26, 8925181 },
	{ 26, 13119485 },
	{ 26, 25702397 },
	{ 26, 29896701 },
	{ 27, 42479613 },
	{ 27, 46673917 },
	{ 27, 59256829 },
	{ 27, 63451133 },
	{ 28, 109588477 },
	{ 26, 66271997 },
	{ 26, 65223421 },
	{ 26, 62077693 },
	{ 26, 61029117 },
	{ 26, 32717565 },
	{ 26, 31668989 },
	{ 26, 28523261 },
	{ 26, 27474685 },
	{ 25, 15940349 },
	{ 25, 14891773 },
	{ 25, 11746045 },
	{ 25, 10697469 },
	{ 24, 7551741 },
	{ 24, 6503165 },
	{ 24, 3357437 },
	{ 24, 2308861 },
	{ 22, 1260285 },
	{ 22, 211709 },
	{ 18, 131049 },
	{ 16, 32681 },
	{ 17, 65370 },
	{ 20, 523709 },
	{ 22, 1325821 },
	{ 23, 2818047 },
	{ 24, 3422973 },
	{ 24, 6568701 },
	{ 24, 7617277 },
	{ 25, 10763005 },
	{ 25, 11811581 },
	{ 25, 14957309 },
	{ 25, 16005885 },
	{ 26, 27540221 },
	{ 26, 28588797 },
	{ 26, 31734525 },
	{ 26, 32783101 },
	{ 26, 61094653 },
	{ 26, 62143229 },
	{ 26, 65288957 },
	{ 26, 66337533 },
	{ 26, 27474941 },
	{ 25, 15940605 },
	{ 25, 14892029 },
	{ 25, 11746301 },
	{ 25, 10697725 },
	{ 24, 7551997 },
	{ 24, 6503421 },
	{ 24, 3357693 },
	{ 24, 2309117 },
	{ 22, 1260541 },
	{ 22, 211965 },
	{ 18, 130873 },
	{ 15, 16329 },
	{ 17, 65498 },
	{ 19, 261821 },
	{ 22, 1326077 },
	{ 23, 2817791 },
	{ 24, 3423229 },
	{ 24, 6568957 },
	{ 24, 7617533 },
	{ 25, 10763261 },
	{ 25, 11811837 },
	{ 25, 14957565 },
	{ 25, 16006141 },
	{ 26, 27540477 },
	{ 26, 28589053 },
	{ 26, 31734781 },
	{ 26, 66141949 },
	{ 26, 65093373 },
	{ 26, 61947645 },
	{ 26, 60899069 },
	{ 26, 32587517 },
	{ 26, 31538941 },
	{ 26, 28393213 },
	{ 26, 27344637 },
	{ 25, 15810301 },
	{ 25, 14761725 },
	{ 25, 11615997 },
	{ 25, 10567421 },
	{ 24, 7421693 },
	{ 24, 6373117 },
	{ 24, 3227389 },
	{ 24, 2178813 },
	{ 17, 63357 },
	{ 16, 32733 },
	{ 23, 64511 },
	{ 17, 65453 },
	{ 17, 62845 },
	{ 23, 2292735 },
	{ 24, 3161853 },
	{ 24, 6307581 },
	{ 24, 7356157 },
	{ 25, 10501885 },
	{ 25, 11550461 },
	{ 25, 14696189 },
	{ 25, 15744765 },
	{ 26, 27279101 },
	{ 26, 28327677 },
	{ 26, 31473405 },
	{ 26, 32521981 },
	{ 26, 60833533 },
	{ 26, 61882109 },
	{ 26, 65027837 },
	{ 26, 66076413 },
	{ 26, 31539197 },
	{ 26, 28393469 },
	{ 26, 27344893 },
	{ 25, 15810557 },
	{ 25, 14761981 },
	{ 25, 11616253 },
	{ 25, 10567677 },
	{ 24, 7421949 },
	{ 24, 6373373 },
	{ 24, 3227645 },
	{ 24, 2179069 },
	{ 17, 65405 },
	{ 19, 261997 },
	{ 13, 3722 },
	{ 16, 32717 },
	{ 17, 64893 },
	{ 23, 2292479 },
	{ 24, 3162109 },
	{ 24, 6307837 },
	{ 24, 7356413 },
	{ 25, 10502141 },
	{ 25, 11550717 },
	{ 25, 14696445 },
	{ 25, 15745021 },
	{ 26, 27279357 },
	{ 26, 28327933 },
	{ 26, 31473661 },
	{ 26, 66415357 },
	{ 26, 65366781 },
	{ 26, 62221053 },
	{ 26, 61172477 },
	{ 26, 32860925 },
	{ 26, 31812349 },
	{ 26, 28666621 },
	{ 26, 27618045 },
	{ 25, 16083709 },
	{ 25, 15035133 },
	{ 25, 11889405 },
	{ 25, 10840829 },
	{ 24, 7695101 },
	{ 24, 6646525 },
	{ 24, 3500797 },
	{ 24, 2452221 },
	{ 22, 1403645 },
	{ 21, 1048189 },
	{ 13, 3786 },
	{ 17, 65497 },
	{ 20, 524269 },
	{ 22, 158461 },
	{ 22, 420605 },
	{ 23, 2551807 },
	{ 24, 944893 },
	{ 24, 1731325 },
	{ 24, 1993469 },
	{ 25, 2779901 },
	{ 25, 3042045 },
	{ 25, 3828477 },
	{ 25, 4090621 },
	{ 26, 6974205 },
	{ 26, 7236349 },
	{ 26, 8022781 },
	{ 26, 8284925 },
	{ 26, 15362813 },
	{ 26, 15624957 },
	{ 26, 16411389 },
	{ 26, 16673533 },
	{ 26, 27618301 },
	{ 25, 16083965 },
	{ 25, 15035389 },
	{ 25, 11889661 },
	{ 25, 10841085 },
	{ 24, 7695357 },
	{ 24, 6646781 },
	{ 24, 3501053 },
	{ 24, 2452477 },
	{ 22, 1403901 },
	{ 22, 2097085 },
	{ 20, 524090 },
	{ 20, 524137 },
	{ 20, 524093 },
	{ 22, 158717 },
	{ 22, 420861 },
	{ 23, 2551551 },
	{ 24, 945149 },
	{ 24, 1731581 },
	{ 24, 1993725 },
	{ 25, 2780157 },
	{ 25, 3042301 },
	{ 25, 3828733 },
	{ 25, 4090877 },
	{ 26, 6974461 },
	{ 26, 7236605 },
	{ 26, 8023037 },
	{ 26, 8285181 },
	{ 26, 15363069 },
	{ 26, 15625213 },
	{ 26, 16411645 },
	{ 26, 16673789 },
	{ 27, 132574975 },
	{ 27, 63532797 },
	{ 27, 59338493 },
	{ 27, 46755581 },
	{ 27, 42561277 },
	{ 26, 29978365 },
	{ 26, 25784061 },
	{ 26, 13201149 },
	{ 26, 9006845 },
	{ 24, 4812541 },
	{ 24, 618237 },
	{ 17, 55834 },
	{ 22, 2096761 },
	{ 18, 112505 },
	{ 22, 225017 },
	{ 22, 487161 },
	{ 22, 1470205 },
	{ 23, 3075071 },
	{ 24, 1797881 },
	{ 24, 2060025 },
	{ 24, 6188797 },
	{ 25, 3108601 },
	{ 25, 3895033 },
	{ 25, 4157177 },
	{ 25, 12480253 },
	{ 26, 7302905 },
	{ 26, 8089337 },
	{ 26, 8351481 },
	{ 26, 15429369 },
	{ 26, 15691513 },
	{ 26, 16477945 },
	{ 26, 16740089 },
	{ 26, 33451773 },
	{ 27, 63533053 },
	{ 27, 59338749 },
	{ 27, 46755837 },
	{ 27, 42561533 },
	{ 26, 29978621 },
	{ 26, 25784317 },
	{ 26, 1