/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Control;

public abstract class FloatControl
extends Control {
    private float minimum;
    private float maximum;
    private float precision;
    private int updatePeriod;
    private float value;
    private String units;
    private String minLabel;
    private String maxLabel;
    private String midLabel;

    protected FloatControl(Type type, float min, float max, float prec, int update, float init, String units) {
        super(type);
        this.minimum = min;
        this.maximum = max;
        this.precision = prec;
        this.updatePeriod = update;
        this.value = init;
        this.units = units;
        this.minLabel = "";
        this.maxLabel = "";
        this.midLabel = "";
    }

    protected FloatControl(Type type, float min, float max, float prec, int update, float init, String units, String minLabel, String midLabel, String maxLabel) {
        super(type);
        this.minimum = min;
        this.maximum = max;
        this.precision = prec;
        this.updatePeriod = update;
        this.value = init;
        this.units = units;
        this.minLabel = minLabel;
        this.maxLabel = maxLabel;
        this.midLabel = midLabel;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public String getMaxLabel() {
        return this.maxLabel;
    }

    public String getMidLabel() {
        return this.midLabel;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public String getMinLabel() {
        return this.minLabel;
    }

    public float getPrecision() {
        return this.precision;
    }

    public String getUnits() {
        return this.units;
    }

    public int getUpdatePeriod() {
        return this.updatePeriod;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        if (value < this.minimum || value > this.maximum) {
            throw new IllegalArgumentException("value out of range");
        }
        this.value = value;
    }

    public void shift(float from, float to, int ms) {
        if (from < this.minimum || from > this.maximum || to < this.minimum || to > this.maximum || ms < 0) {
            throw new IllegalArgumentException("argument out of range");
        }
        this.value = to;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ": " + this.value;
    }

    public static class Type
    extends Control.Type {
        public static final Type AUX_RETURN = new Type("AUX return");
        public static final Type AUX_SEND = new Type("AUX send");
        public static final Type BALANCE = new Type("Balance");
        public static final Type MASTER_GAIN = new Type("Master gain");
        public static final Type PAN = new Type("Pan");
        public static final Type REVERB_RETURN = new Type("Reverb return");
        public static final Type REVERB_SEND = new Type("Reverb send");
        public static final Type SAMPLE_RATE = new Type("Sample rate");
        public static final Type VOLUME = new Type("Volume");

        protected Type(String name) {
            super(name);
        }
    }
}

