/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;

public abstract class ByteEncodeLoopHelper {
    protected abstract boolean isMappable(char var1);

    protected abstract byte mapToByte(char var1);

    CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        if (in.hasArray() && out.hasArray()) {
            return this.arrayEncodeLoop(in, out);
        }
        return this.normalEncodeLoop(in, out);
    }

    private CoderResult normalEncodeLoop(CharBuffer in, ByteBuffer out) {
        int outRemaining = out.remaining();
        int inRemaining = in.remaining();
        while (inRemaining > 0 && outRemaining > 0) {
            char c = in.get();
            --inRemaining;
            if (!this.isMappable(c)) {
                in.position(in.position() - 1);
                return CoderResult.unmappableForLength(1);
            }
            byte b = this.mapToByte(c);
            out.put(b);
            --outRemaining;
        }
        if (inRemaining > 0) {
            return CoderResult.OVERFLOW;
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult arrayEncodeLoop(CharBuffer in, ByteBuffer out) {
        CoderResult result;
        int outPos;
        int inPos;
        block6: {
            int outRemaining;
            char[] inArray = in.array();
            byte[] outArray = out.array();
            inPos = in.arrayOffset() + in.position();
            outPos = out.arrayOffset() + out.position();
            int inRemaining = in.remaining();
            if (inRemaining <= (outRemaining = out.remaining())) {
                int i = 0;
                while (i < inRemaining) {
                    byte b;
                    char inChar = inArray[inPos];
                    ++inPos;
                    if (!this.isMappable(inChar)) {
                        --inPos;
                        result = CoderResult.unmappableForLength(1);
                        break block6;
                    }
                    outArray[outPos] = b = this.mapToByte(inChar);
                    ++outPos;
                    ++i;
                }
                result = CoderResult.UNDERFLOW;
            } else {
                int i = 0;
                while (i < outRemaining) {
                    byte b;
                    char inChar = inArray[inPos];
                    ++inPos;
                    if (!this.isMappable(inChar)) {
                        --inPos;
                        result = CoderResult.unmappableForLength(1);
                        break block6;
                    }
                    outArray[outPos] = b = this.mapToByte(inChar);
                    ++outPos;
                    ++i;
                }
                result = CoderResult.OVERFLOW;
            }
        }
        in.position(inPos - in.arrayOffset());
        out.position(outPos - out.arrayOffset());
        return result;
    }
}

