/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer;

import gnu.java.awt.peer.GnomeDesktopPeer;
import gnu.java.awt.peer.KDEDesktopPeer;
import java.awt.AWTPermission;
import java.awt.Desktop;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.prefs.Preferences;

public class ClasspathDesktopPeer
implements DesktopPeer {
    protected static final String _DEFAULT_BROWSER = "firefox";
    protected static final String _BROWSE = "html";
    protected static final String _MAIL = "mail";
    protected static final String _EDIT = "edit";
    protected static final String _PRINT = "print";
    protected static final String _OPEN = "open";
    protected static final KDEDesktopPeer kde = new KDEDesktopPeer();
    protected static final GnomeDesktopPeer gnome = new GnomeDesktopPeer();
    protected static final ClasspathDesktopPeer classpath = new ClasspathDesktopPeer();
    protected Preferences prefs = Preferences.userNodeForPackage(ClasspathDesktopPeer.class).node("Desktop");

    protected ClasspathDesktopPeer() {
    }

    public boolean isSupported(Desktop.Action action) {
        String check = null;
        switch (action) {
            case BROWSE: {
                check = _BROWSE;
                break;
            }
            case MAIL: {
                check = _MAIL;
                break;
            }
            case EDIT: {
                check = _EDIT;
                break;
            }
            case PRINT: {
                check = _PRINT;
                break;
            }
            default: {
                check = _OPEN;
            }
        }
        return this.supportCommand(check);
    }

    public void browse(URI url) throws IOException {
        this.checkPermissions();
        String browser = this.getCommand(_BROWSE);
        if (browser == null) {
            throw new UnsupportedOperationException();
        }
        browser = String.valueOf(browser) + " " + url.toString();
        Runtime.getRuntime().exec(browser);
    }

    public void edit(File file) throws IOException {
        this.checkPermissions(file, false);
        String edit = this.getCommand(_EDIT);
        if (edit == null) {
            throw new UnsupportedOperationException();
        }
        edit = String.valueOf(edit) + " " + file.getAbsolutePath();
        Runtime.getRuntime().exec(edit);
    }

    public void mail(URI mailtoURL) throws IOException {
        this.checkPermissions();
        String scheme = mailtoURL.getScheme();
        if (scheme == null || !scheme.equalsIgnoreCase("mailto")) {
            throw new IllegalArgumentException("URI Scheme not of type mailto");
        }
        String mail = this.getCommand(_MAIL);
        if (mail == null) {
            throw new UnsupportedOperationException();
        }
        mail = String.valueOf(mail) + " " + mailtoURL.toString();
        Runtime.getRuntime().exec(mail);
    }

    public void mail() throws IOException {
        this.checkPermissions();
        String mail = this.getCommand(_MAIL);
        if (mail == null) {
            throw new UnsupportedOperationException();
        }
        Runtime.getRuntime().exec(mail);
    }

    public void open(File file) throws IOException {
        this.checkPermissions(file, true);
        String open = this.getCommand(_OPEN);
        if (open == null) {
            throw new UnsupportedOperationException();
        }
        open = String.valueOf(open) + " " + file.getAbsolutePath();
        Runtime.getRuntime().exec(open);
    }

    public void print(File file) throws IOException {
        this.checkPrintPermissions(file);
        String print = this.getCommand(_PRINT);
        if (print == null) {
            throw new UnsupportedOperationException();
        }
        print = String.valueOf(print) + " " + file.getAbsolutePath();
        Runtime.getRuntime().exec(print);
    }

    protected String getCommand(String action) {
        String command = System.getProperty("gnu.java.awt.peer.Desktop." + action + ".command");
        if (command == null) {
            command = this.prefs.node(action).get("command", null);
        }
        return command;
    }

    protected void checkPermissions() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AWTPermission("showWindowWithoutWarningBanner"));
        }
    }

    protected void checkPermissions(File file, boolean readOnly) {
        this.checkPermissions();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkRead(file.toString());
            if (!readOnly) {
                sm.checkWrite(file.toString());
            }
        }
    }

    protected void checkPrintPermissions(File file) {
        this.checkPermissions(file, true);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPrintJobAccess();
        }
    }

    protected boolean supportCommand(String check) {
        return this.getCommand(check) != null;
    }

    public static DesktopPeer getDesktop() {
        String desktopSession = System.getenv("GNOME_DESKTOP_SESSION_ID");
        if (desktopSession == null) {
            desktopSession = System.getenv("KDE_FULL_SESSION");
            if (desktopSession != null) {
                return kde;
            }
        } else {
            return gnome;
        }
        return classpath;
    }
}

