/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.runtime;

import gnu.gcj.Core;
import gnu.gcj.RawData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.security.CodeSource;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SharedLibHelper {
    RawData handler;
    RawData core_chain;
    HashMap classMap = new HashMap(20);
    ClassLoader loader;
    String baseName;
    ProtectionDomain domain;
    int flags;
    boolean initialized = false;
    static HashMap map = new HashMap();

    SharedLibHelper(String libname, ClassLoader parent, CodeSource source, ProtectionDomain domain, int flags) {
        this.loader = parent;
        this.baseName = libname;
        if (domain == null) {
            domain = new ProtectionDomain(source, Policy.getPolicy().getPermissions(source));
        }
        this.domain = domain;
        this.flags = flags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedLibHelper findHelper(String libname) {
        HashMap hashMap = map;
        synchronized (hashMap) {
            Set s;
            block5: {
                s = (Set)map.get(libname);
                if (s != null) break block5;
                return null;
            }
            for (WeakReference ref : s) {
                if (ref == null) continue;
                return (SharedLibHelper)ref.get();
            }
            return null;
        }
    }

    static void copyFile(File in, File out) throws IOException {
        FileChannel source = new FileInputStream(in).getChannel();
        FileChannel destination = new FileOutputStream(out).getChannel();
        source.transferTo(0L, source.size(), destination);
        source.close();
        destination.close();
    }

    public static SharedLibHelper findHelper(ClassLoader loader, String libname, CodeSource source, boolean tryParents) {
        return SharedLibHelper.findHelper(loader, libname, source, null, tryParents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedLibHelper findHelper(ClassLoader loader, String libname, CodeSource source, ProtectionDomain domain, boolean tryParents) {
        HashMap hashMap = map;
        synchronized (hashMap) {
            SharedLibHelper result;
            HashSet s;
            block10: {
                s = (HashSet)map.get(libname);
                if (s == null) {
                    s = new HashSet();
                    map.put(libname, s);
                    break block10;
                }
                for (WeakReference ref : s) {
                    if (ref == null || (result = (SharedLibHelper)ref.get()) == null) continue;
                    ClassLoader l = loader;
                    do {
                        if (result.loader == l) {
                            return result;
                        }
                        l = l.getParent();
                    } while (tryParents && l != null);
                }
                try {
                    File copy = File.createTempFile(new File(libname).getName(), ".so", new File("/tmp"));
                    File src = new File(libname);
                    SharedLibHelper.copyFile(src, copy);
                    copy.deleteOnExit();
                    libname = copy.getPath();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            result = new SharedLibHelper(libname, loader, source, domain, 0);
            s.add(new WeakReference<SharedLibHelper>(result));
            return result;
        }
    }

    public native void finalize();

    public Class findClass(String name) {
        this.ensureInit();
        Class result = (Class)this.classMap.get(name);
        if (result != null) {
            this.ensureSupersLinked(result);
        }
        return result;
    }

    public URL findResource(String name) {
        this.ensureInit();
        if (!this.hasResource(name)) {
            return null;
        }
        try {
            return new URL("gcjlib", "", -1, String.valueOf(this.baseName) + "!/" + name);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public native Core findCore(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureInit() {
        HashMap hashMap = this.classMap;
        synchronized (hashMap) {
            if (this.initialized) {
                return;
            }
            this.init();
            this.initialized = true;
        }
    }

    native boolean hasResource(String var1);

    native void init();

    native void ensureSupersLinked(Class var1);

    public String toString() {
        return "shared object " + this.baseName;
    }

    void registerClass(String name, Class cls) {
        this.classMap.put(name, cls);
    }
}

