/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class DeleteCmd
extends Command {
    private static final Logger log = Logger.getLogger(DeleteCmd.class.getName());
    protected String _alias;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;

    DeleteCmd() {
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public void setStoretype(String type) {
        this._ksType = type;
    }

    public void setKeystore(String url) {
        this._ksURL = url;
    }

    public void setStorepass(String password) {
        this._ksPassword = password;
    }

    public void setProvider(String className) {
        this._providerClassName = className;
    }

    void setup() throws Exception {
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setTheAlias(this._alias);
        if (Configuration.DEBUG) {
            log.fine("-delete handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        this.ensureStoreContainsAlias();
        this.store.deleteEntry(this.alias);
        this.saveKeyStore();
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("delete", true);
        result.setHeader(Messages.getString("DeleteCmd.18"));
        result.setFooter(Messages.getString("DeleteCmd.17"));
        OptionGroup options = new OptionGroup(Messages.getString("DeleteCmd.16"));
        options.add(new Option("alias", Messages.getString("DeleteCmd.15"), Messages.getString("DeleteCmd.14")){

            public void parsed(String argument) throws OptionException {
                DeleteCmd.this._alias = argument;
            }
        });
        options.add(new Option("storetype", Messages.getString("DeleteCmd.13"), Messages.getString("DeleteCmd.12")){

            public void parsed(String argument) throws OptionException {
                DeleteCmd.this._ksType = argument;
            }
        });
        options.add(new Option("keystore", Messages.getString("DeleteCmd.11"), Messages.getString("DeleteCmd.10")){

            public void parsed(String argument) throws OptionException {
                DeleteCmd.this._ksURL = argument;
            }
        });
        options.add(new Option("storepass", Messages.getString("DeleteCmd.9"), Messages.getString("DeleteCmd.8")){

            public void parsed(String argument) throws OptionException {
                DeleteCmd.this._ksPassword = argument;
            }
        });
        options.add(new Option("provider", Messages.getString("DeleteCmd.7"), Messages.getString("DeleteCmd.6")){

            public void parsed(String argument) throws OptionException {
                DeleteCmd.this._providerClassName = argument;
            }
        });
        options.add(new Option("v", Messages.getString("DeleteCmd.5")){

            public void parsed(String argument) throws OptionException {
                DeleteCmd.this.verbose = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }

    private void setTheAlias(String anAlias) throws IOException, UnsupportedCallbackException {
        if (anAlias == null || anAlias.trim().length() == 0) {
            String prompt = Messages.getString("DeleteCmd.19");
            NameCallback ncb = new NameCallback(prompt);
            this.getCallbackHandler().handle(new Callback[]{ncb});
            anAlias = ncb.getName();
            if (anAlias == null || anAlias.trim().length() == 0) {
                throw new SecurityException(Messages.getString("DeleteCmd.20"));
            }
        }
        this.alias = anAlias.trim();
    }
}

