;;;;;;;;;;;;;;;;;;;;;;;;;;;;;<--OGI-->;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                        ;;
;;             Center for Spoken Language Understanding                   ;;
;;        Oregon Graduate Institute of Science & Technology               ;;
;;                         Portland, OR USA                               ;;
;;                        Copyright (c) 1999                              ;;
;;                                                                        ;;
;;      This module is not part of the CSTR/University of Edinburgh       ;;
;;               release of the Festival TTS system.                      ;;
;;                                                                        ;;
;;  In addition to any conditions disclaimers below, please see the file  ;;
;;  "license_ogi_tts.txt" distributed with this software for information  ;;
;;  on usage and redistribution, and for a DISCLAIMER OF ALL WARRANTIES.  ;;
;;                                                                        ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;<--OGI-->;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  Set up diphone voice
;;;  Voice Conversion mapping using MWM diphones
;;;  converts male American English to male Amer Engl.


;; Location at runtime
(defvar mwm_diphone_dir (cdr (assoc 'mwm_diphone voice-locations))
  "mwm_diphone_dir
  The default directory for the mwm diphone voice.")

(set! load-path (cons (path-append mwm_diphone_dir "festvox") load-path))
(require 'mwm_diphone)

;; Location at runtime
(defvar mwm2jph_conv_dir (cdr (assoc 'mwm2jph_diphone voice-locations))
  "mwm2jph_conv_dir
  The default directory for the mwm2jph diphone voice.")
 
(define (voice_mwm2jph_diphone)
"(voice_mwm2jph_diphone)
 Set up the current voice to be an American male MWM2JPH using
 the MWM diphone set and OGIresLPC."

  ;; reset global parameters
  (voice_reset)

  ;; load mwm database, change only relevant things
  (voice_mwm_diphone)

  ;; F0 prediction
  (set! int_lr_params
	'((target_f0_mean 115) (target_f0_std 18)
	  (model_f0_mean 170) (model_f0_std 34)))
  
  (OGIdbase.activate "mwm_diphone")      
  (OGIresLPC.init mwm2jphdi_OGI_syn_params)  
  (set! current_voice_reset mwmdi_voice_reset)
  (set! current-voice 'mwm2jph_diphone)  
)


;; Context-dependent smoothing:

;;
;;  Residual LPC synthesizer parameters - used by OGIresLPC.init
;;
(set! mwm2jphdi_OGI_syn_params  
 (list
  (list 'vc_file (path-append mwm2jph_conv_dir "convert" "mwm2jph_gmmjd_set_q32"))
  '(F0_default 50.0)      ;; default Fo used if can't find any Fo targets
  '(T0_UV_thresh 0.020)   ;; used to make V/UV decision 
  '(T0_UV_pm 0.010)       ;; used to place UV pmarks
  '(post_gain 0.9)        ;; adjust final loudness
  '(deemphasis 0.96)      ;; opposite of preemphasis (lowpass filter)
  '(mod_method "direct")  ;; method for realizing prosodic targets
  '(beta_smooth 5)        ;; smoother len for pitch mod factor in "soft" mod method
  '(smooth_cross_ph_join "Y") ;; smooth across joins at phone boundaries?
  '(spectra_match_or_replace "match") ;; for join smoothing
  '(power_match_or_replace   "match") ;; for join smoothing
  mwmdi_smooth_spectra
  mwmdi_smooth_power
  ))


(proclaim_voice
 'mwm2jph_diphone
 '((language english)
   (gender male)
   (dialect american)
   (description
    "This voice provides an American English male voice using a
     residual excited LPC diphone synthesis module and voice conversion mapping created at
     OGI.  It uses a lexicon compiled from MOBY and CMU lexicons, and
     other trained modules used by CSTR voices.")))

(provide 'mwm2jph_diphone)





