'''OpenGL extension VERSION.GL_1_1

This module customises the behaviour of the 
OpenGL.raw.GL.VERSION.GL_1_1 to provide a more 
Python-friendly API

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/VERSION/GL_1_1.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.VERSION.GL_1_1 import *
### END AUTOGENERATED SECTION
GL_MODELVIEW0_EXT = GL_MODELVIEW # alias
GL_MODELVIEW0_MATRIX_EXT = GL_MODELVIEW_MATRIX # alias
GL_MODELVIEW0_STACK_DEPTH_EXT = GL_MODELVIEW_STACK_DEPTH # alias
GL_TEXTURE_COMPONENTS = GL_TEXTURE_INTERNAL_FORMAT # alias

glAreTexturesResident = arrays.setInputArraySizeType(
    glAreTexturesResident,
    None, # XXX Could not determine size of argument textures for glAreTexturesResident arrays.GLuintArray
    arrays.GLuintArray, 
    'textures',
)

glBitmap = arrays.setInputArraySizeType(
    glBitmap,
    None, # XXX Could not determine size of argument bitmap for glBitmap arrays.GLubyteArray
    arrays.GLubyteArray, 
    'bitmap',
)

glClipPlane = arrays.setInputArraySizeType(
    glClipPlane,
    None, # XXX Could not determine size of argument equation for glClipPlane arrays.GLdoubleArray
    arrays.GLdoubleArray, 
    'equation',
)

glColor3bv = arrays.setInputArraySizeType(
    glColor3bv,
    3,
    arrays.GLbyteArray,
    'v',
)

glColor3dv = arrays.setInputArraySizeType(
    glColor3dv,
    3,
    arrays.GLdoubleArray,
    'v',
)

glColor3fv = arrays.setInputArraySizeType(
    glColor3fv,
    3,
    arrays.GLfloatArray,
    'v',
)

glColor3iv = arrays.setInputArraySizeType(
    glColor3iv,
    3,
    arrays.GLintArray,
    'v',
)

glColor3sv = arrays.setInputArraySizeType(
    glColor3sv,
    3,
    arrays.GLshortArray,
    'v',
)

glColor3ubv = arrays.setInputArraySizeType(
    glColor3ubv,
    3,
    arrays.GLubyteArray,
    'v',
)

glColor3uiv = arrays.setInputArraySizeType(
    glColor3uiv,
    3,
    arrays.GLuintArray,
    'v',
)

glColor3usv = arrays.setInputArraySizeType(
    glColor3usv,
    3,
    arrays.GLushortArray,
    'v',
)

glColor4bv = arrays.setInputArraySizeType(
    glColor4bv,
    4,
    arrays.GLbyteArray,
    'v',
)

glColor4dv = arrays.setInputArraySizeType(
    glColor4dv,
    4,
    arrays.GLdoubleArray,
    'v',
)

glColor4fv = arrays.setInputArraySizeType(
    glColor4fv,
    4,
    arrays.GLfloatArray,
    'v',
)

glColor4iv = arrays.setInputArraySizeType(
    glColor4iv,
    4,
    arrays.GLintArray,
    'v',
)

glColor4sv = arrays.setInputArraySizeType(
    glColor4sv,
    4,
    arrays.GLshortArray,
    'v',
)

glColor4ubv = arrays.setInputArraySizeType(
    glColor4ubv,
    4,
    arrays.GLubyteArray,
    'v',
)

glColor4uiv = arrays.setInputArraySizeType(
    glColor4uiv,
    4,
    arrays.GLuintArray,
    'v',
)

glColor4usv = arrays.setInputArraySizeType(
    glColor4usv,
    4,
    arrays.GLushortArray,
    'v',
)

glDeleteTextures = arrays.setInputArraySizeType(
    glDeleteTextures,
    None, # XXX Could not determine size of argument textures for glDeleteTextures arrays.GLuintArray
    arrays.GLuintArray, 
    'textures',
)

glEvalCoord1dv = arrays.setInputArraySizeType(
    glEvalCoord1dv,
    1,
    arrays.GLdoubleArray,
    'u',
)

glEvalCoord1fv = arrays.setInputArraySizeType(
    glEvalCoord1fv,
    1,
    arrays.GLfloatArray,
    'u',
)

glEvalCoord2dv = arrays.setInputArraySizeType(
    glEvalCoord2dv,
    2,
    arrays.GLdoubleArray,
    'u',
)

glEvalCoord2fv = arrays.setInputArraySizeType(
    glEvalCoord2fv,
    2,
    arrays.GLfloatArray,
    'u',
)

glFeedbackBuffer = arrays.setInputArraySizeType(
    glFeedbackBuffer,
    None, # XXX Could not determine size of argument buffer for glFeedbackBuffer arrays.GLfloatArray
    arrays.GLfloatArray, 
    'buffer',
)

glFogfv = arrays.setInputArraySizeType(
    glFogfv,
    None, # XXX Could not determine size of argument params for glFogfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glFogiv = arrays.setInputArraySizeType(
    glFogiv,
    None, # XXX Could not determine size of argument params for glFogiv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glGenTextures = arrays.setInputArraySizeType(
    glGenTextures,
    None, # XXX Could not determine size of argument textures for glGenTextures arrays.GLuintArray
    arrays.GLuintArray, 
    'textures',
)

glGetClipPlane = arrays.setInputArraySizeType(
    glGetClipPlane,
    None, # XXX Could not determine size of argument equation for glGetClipPlane arrays.GLdoubleArray
    arrays.GLdoubleArray, 
    'equation',
)

glGetDoublev = arrays.setInputArraySizeType(
    glGetDoublev,
    None, # XXX Could not determine size of argument params for glGetDoublev arrays.GLdoubleArray
    arrays.GLdoubleArray, 
    'params',
)

glGetFloatv = arrays.setInputArraySizeType(
    glGetFloatv,
    None, # XXX Could not determine size of argument params for glGetFloatv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glGetIntegerv = arrays.setInputArraySizeType(
    glGetIntegerv,
    None, # XXX Could not determine size of argument params for glGetIntegerv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glGetLightfv = arrays.setInputArraySizeType(
    glGetLightfv,
    None, # XXX Could not determine size of argument params for glGetLightfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glGetLightiv = arrays.setInputArraySizeType(
    glGetLightiv,
    None, # XXX Could not determine size of argument params for glGetLightiv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glGetMapdv = arrays.setInputArraySizeType(
    glGetMapdv,
    None, # XXX Could not determine size of argument v for glGetMapdv arrays.GLdoubleArray
    arrays.GLdoubleArray, 
    'v',
)

glGetMapfv = arrays.setInputArraySizeType(
    glGetMapfv,
    None, # XXX Could not determine size of argument v for glGetMapfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'v',
)

glGetMapiv = arrays.setInputArraySizeType(
    glGetMapiv,
    None, # XXX Could not determine size of argument v for glGetMapiv arrays.GLintArray
    arrays.GLintArray, 
    'v',
)

glGetMaterialfv = arrays.setInputArraySizeType(
    glGetMaterialfv,
    None, # XXX Could not determine size of argument params for glGetMaterialfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glGetMaterialiv = arrays.setInputArraySizeType(
    glGetMaterialiv,
    None, # XXX Could not determine size of argument params for glGetMaterialiv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glGetPixelMapfv = arrays.setInputArraySizeType(
    glGetPixelMapfv,
    None, # XXX Could not determine size of argument values for glGetPixelMapfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'values',
)

glGetPixelMapuiv = arrays.setInputArraySizeType(
    glGetPixelMapuiv,
    None, # XXX Could not determine size of argument values for glGetPixelMapuiv arrays.GLuintArray
    arrays.GLuintArray, 
    'values',
)

glGetPixelMapusv = arrays.setInputArraySizeType(
    glGetPixelMapusv,
    None, # XXX Could not determine size of argument values for glGetPixelMapusv arrays.GLushortArray
    arrays.GLushortArray, 
    'values',
)

glGetPolygonStipple = arrays.setInputArraySizeType(
    glGetPolygonStipple,
    None, # XXX Could not determine size of argument mask for glGetPolygonStipple arrays.GLubyteArray
    arrays.GLubyteArray, 
    'mask',
)

glGetTexEnvfv = arrays.setInputArraySizeType(
    glGetTexEnvfv,
    None, # XXX Could not determine size of argument params for glGetTexEnvfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glGetTexEnviv = arrays.setInputArraySizeType(
    glGetTexEnviv,
    None, # XXX Could not determine size of argument params for glGetTexEnviv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glGetTexGendv = arrays.setInputArraySizeType(
    glGetTexGendv,
    None, # XXX Could not determine size of argument params for glGetTexGendv arrays.GLdoubleArray
    arrays.GLdoubleArray, 
    'params',
)

glGetTexGenfv = arrays.setInputArraySizeType(
    glGetTexGenfv,
    None, # XXX Could not determine size of argument params for glGetTexGenfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glGetTexGeniv = arrays.setInputArraySizeType(
    glGetTexGeniv,
    None, # XXX Could not determine size of argument params for glGetTexGeniv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glGetTexLevelParameterfv = arrays.setInputArraySizeType(
    glGetTexLevelParameterfv,
    None, # XXX Could not determine size of argument params for glGetTexLevelParameterfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glGetTexLevelParameteriv = arrays.setInputArraySizeType(
    glGetTexLevelParameteriv,
    None, # XXX Could not determine size of argument params for glGetTexLevelParameteriv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glGetTexParameterfv = arrays.setInputArraySizeType(
    glGetTexParameterfv,
    None, # XXX Could not determine size of argument params for glGetTexParameterfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glGetTexParameteriv = arrays.setInputArraySizeType(
    glGetTexParameteriv,
    None, # XXX Could not determine size of argument params for glGetTexParameteriv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glIndexdv = arrays.setInputArraySizeType(
    glIndexdv,
    None, # XXX Could not determine size of argument c for glIndexdv arrays.GLdoubleArray
    arrays.GLdoubleArray, 
    'c',
)

glIndexfv = arrays.setInputArraySizeType(
    glIndexfv,
    None, # XXX Could not determine size of argument c for glIndexfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'c',
)

glIndexiv = arrays.setInputArraySizeType(
    glIndexiv,
    None, # XXX Could not determine size of argument c for glIndexiv arrays.GLintArray
    arrays.GLintArray, 
    'c',
)

glIndexsv = arrays.setInputArraySizeType(
    glIndexsv,
    None, # XXX Could not determine size of argument c for glIndexsv arrays.GLshortArray
    arrays.GLshortArray, 
    'c',
)

glIndexubv = arrays.setInputArraySizeType(
    glIndexubv,
    None, # XXX Could not determine size of argument c for glIndexubv arrays.GLubyteArray
    arrays.GLubyteArray, 
    'c',
)

glLightModelfv = arrays.setInputArraySizeType(
    glLightModelfv,
    None, # XXX Could not determine size of argument params for glLightModelfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glLightModeliv = arrays.setInputArraySizeType(
    glLightModeliv,
    None, # XXX Could not determine size of argument params for glLightModeliv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glLightfv = arrays.setInputArraySizeType(
    glLightfv,
    None, # XXX Could not determine size of argument params for glLightfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glLightiv = arrays.setInputArraySizeType(
    glLightiv,
    None, # XXX Could not determine size of argument params for glLightiv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glLoadMatrixd = arrays.setInputArraySizeType(
    glLoadMatrixd,
    16,
    arrays.GLdoubleArray,
    'm',
)

glLoadMatrixf = arrays.setInputArraySizeType(
    glLoadMatrixf,
    16,
    arrays.GLfloatArray,
    'm',
)

glMap1d = arrays.setInputArraySizeType(
    glMap1d,
    None, # XXX Could not determine size of argument points for glMap1d arrays.GLdoubleArray
    arrays.GLdoubleArray, 
    'points',
)

glMap1f = arrays.setInputArraySizeType(
    glMap1f,
    None, # XXX Could not determine size of argument points for glMap1f arrays.GLfloatArray
    arrays.GLfloatArray, 
    'points',
)

glMap2d = arrays.setInputArraySizeType(
    glMap2d,
    None, # XXX Could not determine size of argument points for glMap2d arrays.GLdoubleArray
    arrays.GLdoubleArray, 
    'points',
)

glMap2f = arrays.setInputArraySizeType(
    glMap2f,
    None, # XXX Could not determine size of argument points for glMap2f arrays.GLfloatArray
    arrays.GLfloatArray, 
    'points',
)

glMaterialfv = arrays.setInputArraySizeType(
    glMaterialfv,
    None, # XXX Could not determine size of argument params for glMaterialfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glMaterialiv = arrays.setInputArraySizeType(
    glMaterialiv,
    None, # XXX Could not determine size of argument params for glMaterialiv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glMultMatrixd = arrays.setInputArraySizeType(
    glMultMatrixd,
    16,
    arrays.GLdoubleArray,
    'm',
)

glMultMatrixf = arrays.setInputArraySizeType(
    glMultMatrixf,
    16,
    arrays.GLfloatArray,
    'm',
)

glNormal3bv = arrays.setInputArraySizeType(
    glNormal3bv,
    3,
    arrays.GLbyteArray,
    'v',
)

glNormal3dv = arrays.setInputArraySizeType(
    glNormal3dv,
    3,
    arrays.GLdoubleArray,
    'v',
)

glNormal3fv = arrays.setInputArraySizeType(
    glNormal3fv,
    3,
    arrays.GLfloatArray,
    'v',
)

glNormal3iv = arrays.setInputArraySizeType(
    glNormal3iv,
    3,
    arrays.GLintArray,
    'v',
)

glNormal3sv = arrays.setInputArraySizeType(
    glNormal3sv,
    3,
    arrays.GLshortArray,
    'v',
)

glPixelMapfv = arrays.setInputArraySizeType(
    glPixelMapfv,
    None, # XXX Could not determine size of argument values for glPixelMapfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'values',
)

glPixelMapuiv = arrays.setInputArraySizeType(
    glPixelMapuiv,
    None, # XXX Could not determine size of argument values for glPixelMapuiv arrays.GLuintArray
    arrays.GLuintArray, 
    'values',
)

glPixelMapusv = arrays.setInputArraySizeType(
    glPixelMapusv,
    None, # XXX Could not determine size of argument values for glPixelMapusv arrays.GLushortArray
    arrays.GLushortArray, 
    'values',
)

glPolygonStipple = arrays.setInputArraySizeType(
    glPolygonStipple,
    None, # XXX Could not determine size of argument mask for glPolygonStipple arrays.GLubyteArray
    arrays.GLubyteArray, 
    'mask',
)

glPrioritizeTextures = arrays.setInputArraySizeType(
    arrays.setInputArraySizeType(
        glPrioritizeTextures,
        None, # XXX Could not determine size of argument textures for glPrioritizeTextures arrays.GLuintArray
        arrays.GLuintArray, 
        'textures',
    ),
    None, # XXX Could not determine size of argument priorities for glPrioritizeTextures arrays.GLclampfArray
    arrays.GLclampfArray, 
    'priorities',
)

glRasterPos2dv = arrays.setInputArraySizeType(
    glRasterPos2dv,
    2,
    arrays.GLdoubleArray,
    'v',
)

glRasterPos2fv = arrays.setInputArraySizeType(
    glRasterPos2fv,
    2,
    arrays.GLfloatArray,
    'v',
)

glRasterPos2iv = arrays.setInputArraySizeType(
    glRasterPos2iv,
    2,
    arrays.GLintArray,
    'v',
)

glRasterPos2sv = arrays.setInputArraySizeType(
    glRasterPos2sv,
    2,
    arrays.GLshortArray,
    'v',
)

glRasterPos3dv = arrays.setInputArraySizeType(
    glRasterPos3dv,
    3,
    arrays.GLdoubleArray,
    'v',
)

glRasterPos3fv = arrays.setInputArraySizeType(
    glRasterPos3fv,
    3,
    arrays.GLfloatArray,
    'v',
)

glRasterPos3iv = arrays.setInputArraySizeType(
    glRasterPos3iv,
    3,
    arrays.GLintArray,
    'v',
)

glRasterPos3sv = arrays.setInputArraySizeType(
    glRasterPos3sv,
    3,
    arrays.GLshortArray,
    'v',
)

glRasterPos4dv = arrays.setInputArraySizeType(
    glRasterPos4dv,
    4,
    arrays.GLdoubleArray,
    'v',
)

glRasterPos4fv = arrays.setInputArraySizeType(
    glRasterPos4fv,
    4,
    arrays.GLfloatArray,
    'v',
)

glRasterPos4iv = arrays.setInputArraySizeType(
    glRasterPos4iv,
    4,
    arrays.GLintArray,
    'v',
)

glRasterPos4sv = arrays.setInputArraySizeType(
    glRasterPos4sv,
    4,
    arrays.GLshortArray,
    'v',
)

glRectdv = arrays.setInputArraySizeType(
    arrays.setInputArraySizeType(
        glRectdv,
        None, # XXX Could not determine size of argument v1 for glRectdv arrays.GLdoubleArray
        arrays.GLdoubleArray, 
        'v1',
    ),
    None, # XXX Could not determine size of argument v2 for glRectdv arrays.GLdoubleArray
    arrays.GLdoubleArray, 
    'v2',
)

glRectfv = arrays.setInputArraySizeType(
    arrays.setInputArraySizeType(
        glRectfv,
        None, # XXX Could not determine size of argument v1 for glRectfv arrays.GLfloatArray
        arrays.GLfloatArray, 
        'v1',
    ),
    None, # XXX Could not determine size of argument v2 for glRectfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'v2',
)

glRectiv = arrays.setInputArraySizeType(
    arrays.setInputArraySizeType(
        glRectiv,
        None, # XXX Could not determine size of argument v1 for glRectiv arrays.GLintArray
        arrays.GLintArray, 
        'v1',
    ),
    None, # XXX Could not determine size of argument v2 for glRectiv arrays.GLintArray
    arrays.GLintArray, 
    'v2',
)

glRectsv = arrays.setInputArraySizeType(
    arrays.setInputArraySizeType(
        glRectsv,
        None, # XXX Could not determine size of argument v1 for glRectsv arrays.GLshortArray
        arrays.GLshortArray, 
        'v1',
    ),
    None, # XXX Could not determine size of argument v2 for glRectsv arrays.GLshortArray
    arrays.GLshortArray, 
    'v2',
)

glSelectBuffer = arrays.setInputArraySizeType(
    glSelectBuffer,
    None, # XXX Could not determine size of argument buffer for glSelectBuffer arrays.GLuintArray
    arrays.GLuintArray, 
    'buffer',
)

glTexCoord1dv = arrays.setInputArraySizeType(
    glTexCoord1dv,
    1,
    arrays.GLdoubleArray,
    'v',
)

glTexCoord1fv = arrays.setInputArraySizeType(
    glTexCoord1fv,
    1,
    arrays.GLfloatArray,
    'v',
)

glTexCoord1iv = arrays.setInputArraySizeType(
    glTexCoord1iv,
    1,
    arrays.GLintArray,
    'v',
)

glTexCoord1sv = arrays.setInputArraySizeType(
    glTexCoord1sv,
    1,
    arrays.GLshortArray,
    'v',
)

glTexCoord2dv = arrays.setInputArraySizeType(
    glTexCoord2dv,
    2,
    arrays.GLdoubleArray,
    'v',
)

glTexCoord2fv = arrays.setInputArraySizeType(
    glTexCoord2fv,
    2,
    arrays.GLfloatArray,
    'v',
)

glTexCoord2iv = arrays.setInputArraySizeType(
    glTexCoord2iv,
    2,
    arrays.GLintArray,
    'v',
)

glTexCoord2sv = arrays.setInputArraySizeType(
    glTexCoord2sv,
    2,
    arrays.GLshortArray,
    'v',
)

glTexCoord3dv = arrays.setInputArraySizeType(
    glTexCoord3dv,
    3,
    arrays.GLdoubleArray,
    'v',
)

glTexCoord3fv = arrays.setInputArraySizeType(
    glTexCoord3fv,
    3,
    arrays.GLfloatArray,
    'v',
)

glTexCoord3iv = arrays.setInputArraySizeType(
    glTexCoord3iv,
    3,
    arrays.GLintArray,
    'v',
)

glTexCoord3sv = arrays.setInputArraySizeType(
    glTexCoord3sv,
    3,
    arrays.GLshortArray,
    'v',
)

glTexCoord4dv = arrays.setInputArraySizeType(
    glTexCoord4dv,
    4,
    arrays.GLdoubleArray,
    'v',
)

glTexCoord4fv = arrays.setInputArraySizeType(
    glTexCoord4fv,
    4,
    arrays.GLfloatArray,
    'v',
)

glTexCoord4iv = arrays.setInputArraySizeType(
    glTexCoord4iv,
    4,
    arrays.GLintArray,
    'v',
)

glTexCoord4sv = arrays.setInputArraySizeType(
    glTexCoord4sv,
    4,
    arrays.GLshortArray,
    'v',
)

glTexEnvfv = arrays.setInputArraySizeType(
    glTexEnvfv,
    None, # XXX Could not determine size of argument params for glTexEnvfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glTexEnviv = arrays.setInputArraySizeType(
    glTexEnviv,
    None, # XXX Could not determine size of argument params for glTexEnviv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glTexGendv = arrays.setInputArraySizeType(
    glTexGendv,
    None, # XXX Could not determine size of argument params for glTexGendv arrays.GLdoubleArray
    arrays.GLdoubleArray, 
    'params',
)

glTexGenfv = arrays.setInputArraySizeType(
    glTexGenfv,
    None, # XXX Could not determine size of argument params for glTexGenfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glTexGeniv = arrays.setInputArraySizeType(
    glTexGeniv,
    None, # XXX Could not determine size of argument params for glTexGeniv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glTexParameterfv = arrays.setInputArraySizeType(
    glTexParameterfv,
    None, # XXX Could not determine size of argument params for glTexParameterfv arrays.GLfloatArray
    arrays.GLfloatArray, 
    'params',
)

glTexParameteriv = arrays.setInputArraySizeType(
    glTexParameteriv,
    None, # XXX Could not determine size of argument params for glTexParameteriv arrays.GLintArray
    arrays.GLintArray, 
    'params',
)

glVertex2dv = arrays.setInputArraySizeType(
    glVertex2dv,
    2,
    arrays.GLdoubleArray,
    'v',
)

glVertex2fv = arrays.setInputArraySizeType(
    glVertex2fv,
    2,
    arrays.GLfloatArray,
    'v',
)

glVertex2iv = arrays.setInputArraySizeType(
    glVertex2iv,
    2,
    arrays.GLintArray,
    'v',
)

glVertex2sv = arrays.setInputArraySizeType(
    glVertex2sv,
    2,
    arrays.GLshortArray,
    'v',
)

glVertex3dv = arrays.setInputArraySizeType(
    glVertex3dv,
    3,
    arrays.GLdoubleArray,
    'v',
)

glVertex3fv = arrays.setInputArraySizeType(
    glVertex3fv,
    3,
    arrays.GLfloatArray,
    'v',
)

glVertex3iv = arrays.setInputArraySizeType(
    glVertex3iv,
    3,
    arrays.GLintArray,
    'v',
)

glVertex3sv = arrays.setInputArraySizeType(
    glVertex3sv,
    3,
    arrays.GLshortArray,
    'v',
)

glVertex4dv = arrays.setInputArraySizeType(
    glVertex4dv,
    4,
    arrays.GLdoubleArray,
    'v',
)

glVertex4fv = arrays.setInputArraySizeType(
    glVertex4fv,
    4,
    arrays.GLfloatArray,
    'v',
)

glVertex4iv = arrays.setInputArraySizeType(
    glVertex4iv,
    4,
    arrays.GLintArray,
    'v',
)

glVertex4sv = arrays.setInputArraySizeType(
    glVertex4sv,
    4,
    arrays.GLshortArray,
    'v',
)
