/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.IOException;
import java.io.InputStream;
import virtuoso.jdbc3.VirtuosoBlob;

class VirtuosoBlobStream
extends InputStream {
    private VirtuosoBlob blob;
    protected long pos = 1L;

    VirtuosoBlobStream(VirtuosoBlob virtuosoBlob) {
        this.blob = virtuosoBlob;
    }

    public int read() throws IOException {
        try {
            return this.pos > this.blob.length() ? -1 : this.blob.getBytes(this.pos++, 1)[0];
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            byte[] byArray2 = null;
            if (n2 <= 0) {
                return 0;
            }
            if (this.pos + (long)n2 > this.blob.length()) {
                int n3 = (int)(this.blob.length() - this.pos + 1L);
                if (n3 > 0) {
                    byArray2 = this.blob.getBytes(this.pos, n3);
                }
                if (byArray2 != null) {
                    System.arraycopy(byArray2, 0, byArray, n, n3);
                    this.pos = this.blob.length() + 1L;
                    return byArray2.length;
                }
                return -1;
            }
            byArray2 = this.blob.getBytes(this.pos, n2);
            if (byArray2 != null) {
                System.arraycopy(byArray2, 0, byArray, n, n2);
                this.pos += (long)byArray2.length;
                return byArray2.length;
            }
            return -1;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public long skip(long l) throws IOException {
        try {
            if (l <= 0L) {
                return 0L;
            }
            if (this.pos + l > this.blob.length()) {
                long l2 = this.blob.length() - this.pos + 1L;
                this.pos = this.blob.length();
                return l2;
            }
            this.pos += l;
            return l;
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public int available() throws IOException {
        try {
            return (int)(this.blob.length() - this.pos + 1L);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public void reset() {
        this.pos = 1L;
    }
}

