/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ext;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.zaproxy.zap.control.ExtensionFactory;

public class OptionsExtensionTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{Constant.messages.getString("options.ext.label.enabled"), Constant.messages.getString("options.ext.label.core"), Constant.messages.getString("options.ext.label.author"), Constant.messages.getString("options.ext.label.extension")};
    private List<Extension> extensions = ExtensionFactory.getAllExtensions();
    private static Logger log = Logger.getLogger(OptionsExtensionTableModel.class);

    public OptionsExtensionTableModel() {
        Collections.sort(this.extensions, new Comparator<Extension>(){

            @Override
            public int compare(Extension extension, Extension extension2) {
                if (extension == null || extension2 == null) {
                    return 0;
                }
                return extension.getUIName().compareTo(extension2.getUIName());
            }
        });
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.extensions.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Extension extension = this.getExtension(n);
        if (extension != null) {
            try {
                switch (n2) {
                    case 0: {
                        return extension.isEnabled();
                    }
                    case 1: {
                        if (extension.isCore()) {
                            return Constant.messages.getString("options.ext.label.iscore");
                        }
                        return "";
                    }
                    case 2: {
                        return extension.getAuthor();
                    }
                    case 3: {
                        return extension.getUIName();
                    }
                }
            }
            catch (Exception exception) {
                log.error((Object)("Failed on extension " + extension.getName()), (Throwable)exception);
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 0) {
            if (this.getExtension(n).isCore() && this.getExtension(n).isEnabled()) {
                return false;
            }
            List<Class<?>> list = this.getExtension(n).getDependencies();
            for (Class<?> clazz : list) {
                Extension extension = this.getExtension(clazz);
                if (extension != null && extension.isEnabled()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Extension getExtension(Class<?> clazz) {
        for (Extension extension : this.extensions) {
            if (!extension.getClass().equals(clazz)) continue;
            return extension;
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0) {
            this.getExtension(n).setEnabled((Boolean)object);
            this.fireTableCellUpdated(n, n2);
            this.enableDependants(this.getExtension(n), (Boolean)object);
        }
    }

    private void enableDependants(Extension extension, Boolean bl) {
        int n = 0;
        for (Extension extension2 : this.extensions) {
            if (extension2.getDependencies().contains(extension.getClass())) {
                extension2.setEnabled(bl);
                this.fireTableCellUpdated(n, 0);
                this.enableDependants(extension2, bl);
            }
            ++n;
        }
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    protected Extension getExtension(int n) {
        return this.extensions.get(n);
    }

    protected Extension getExtension(String string) {
        for (Extension extension : this.extensions) {
            if (!extension.getName().equals(string)) continue;
            return extension;
        }
        return null;
    }

    protected List<Extension> getExtensions() {
        return this.extensions;
    }
}

