/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.brk.BreakPanelToolbarFactory;
import org.zaproxy.zap.extension.brk.BreakpointsParam;
import org.zaproxy.zap.extension.brk.ExtensionBreak;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.HttpPanelRequest;
import org.zaproxy.zap.extension.httppanel.HttpPanelResponse;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.tab.Tab;

public class BreakPanel
extends AbstractPanel
implements Tab {
    private static final long serialVersionUID = 1L;
    private static final String REQUEST_PANEL = "request";
    private static final String RESPONSE_PANEL = "response";
    private HttpPanelRequest requestPanel;
    private HttpPanelResponse responsePanel;
    private ExtensionBreak extension;
    private JPanel panelContent;
    private BreakPanelToolbarFactory breakToolbarFactory;
    private BreakpointsParam breakpointsParams;
    private final JToggleButton toolBarReqButton;
    private final JToggleButton toolBarResButton;
    private final JToggleButton toolBarAllButton;
    private final JButton toolBarBtnStep;
    private final JButton toolBarBtnContinue;
    private final JButton toolBarBtnDrop;
    private final JButton toolBarBtnBreakPoint;
    private boolean isAlwaysOnTop = false;
    private final BreakButtonsUI mainBreakButtons;
    private final BreakButtonsUI requestBreakButtons;
    private final BreakButtonsUI responseBreakButtons;
    private int currentButtonsLocation;
    private int currentButtonMode;

    public BreakPanel(ExtensionBreak extensionBreak, BreakpointsParam breakpointsParam) {
        this.extension = extensionBreak;
        this.breakpointsParams = breakpointsParam;
        this.setIcon(new ImageIcon(BreakPanel.class.getResource("/resource/icon/16/101grey.png")));
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
        this.setMnemonic(Constant.messages.getChar("brk.panel.mnemonic"));
        this.setLayout(new BorderLayout());
        this.breakToolbarFactory = new BreakPanelToolbarFactory(breakpointsParam, this);
        this.panelContent = new JPanel(new CardLayout());
        this.add((Component)this.panelContent, "Center");
        this.requestPanel = new HttpPanelRequest(false, "view.break.");
        this.requestPanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
        this.responsePanel = new HttpPanelResponse(false, "view.break.");
        this.responsePanel.loadConfig(Model.getSingleton().getOptionsParam().getConfig());
        this.panelContent.add((Component)this.requestPanel, REQUEST_PANEL);
        this.panelContent.add((Component)this.responsePanel, RESPONSE_PANEL);
        this.toolBarReqButton = this.breakToolbarFactory.getBtnBreakRequest();
        View.getSingleton().addMainToolbarButton(this.toolBarReqButton);
        this.toolBarResButton = this.breakToolbarFactory.getBtnBreakResponse();
        View.getSingleton().addMainToolbarButton(this.toolBarResButton);
        this.toolBarAllButton = this.breakToolbarFactory.getBtnBreakAll();
        View.getSingleton().addMainToolbarButton(this.toolBarAllButton);
        this.toolBarBtnStep = this.breakToolbarFactory.getBtnStep();
        View.getSingleton().addMainToolbarButton(this.toolBarBtnStep);
        this.toolBarBtnContinue = this.breakToolbarFactory.getBtnContinue();
        View.getSingleton().addMainToolbarButton(this.toolBarBtnContinue);
        this.toolBarBtnDrop = this.breakToolbarFactory.getBtnDrop();
        View.getSingleton().addMainToolbarButton(this.toolBarBtnDrop);
        this.toolBarBtnBreakPoint = this.breakToolbarFactory.getBtnBreakPoint();
        View.getSingleton().addMainToolbarButton(this.toolBarBtnBreakPoint);
        this.mainBreakButtons = new BreakButtonsUI("mainBreakButtons", this.breakToolbarFactory);
        this.add((Component)this.mainBreakButtons.getComponent(), "North");
        this.requestBreakButtons = new BreakButtonsUI("requestBreakButtons", this.breakToolbarFactory);
        this.requestPanel.addOptions(this.requestBreakButtons.getComponent(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        this.responseBreakButtons = new BreakButtonsUI("responseBreakButtons", this.breakToolbarFactory);
        this.responsePanel.addOptions(this.responseBreakButtons.getComponent(), HttpPanel.OptionsLocation.AFTER_COMPONENTS);
        this.currentButtonsLocation = -1;
    }

    void setButtonsLocation(int n) {
        if (this.currentButtonsLocation == n) {
            this.mainBreakButtons.setVisible(n == 0 && this.isMainToolBarHidden());
            return;
        }
        this.currentButtonsLocation = n;
        switch (n) {
            case 0: {
                this.requestBreakButtons.setVisible(false);
                this.responseBreakButtons.setVisible(false);
                this.setToolbarButtonsVisible(true);
                this.mainBreakButtons.setVisible(this.isMainToolBarHidden());
                break;
            }
            case 1: 
            case 2: {
                this.requestBreakButtons.setVisible(true);
                this.responseBreakButtons.setVisible(true);
                this.setToolbarButtonsVisible(n == 2);
                this.mainBreakButtons.setVisible(false);
                break;
            }
            default: {
                this.setToolbarButtonsVisible(true);
            }
        }
    }

    private boolean isMainToolBarHidden() {
        return !this.extension.getModel().getOptionsParam().getViewParam().isShowMainToolbar();
    }

    public boolean isBreakRequest() {
        return this.breakToolbarFactory.isBreakRequest();
    }

    public boolean isBreakResponse() {
        return this.breakToolbarFactory.isBreakResponse();
    }

    public boolean isBreakAll() {
        return this.breakToolbarFactory.isBreakAll();
    }

    public void breakpointHit() {
        this.breakToolbarFactory.breakpointHit();
    }

    public boolean isHoldMessage() {
        return this.breakToolbarFactory.isHoldMessage();
    }

    public boolean isStepping() {
        return this.breakToolbarFactory.isStepping();
    }

    public boolean isToBeDropped() {
        return this.breakToolbarFactory.isToBeDropped();
    }

    protected void breakpointDisplayed() {
        final Boolean bl = this.breakpointsParams.getAlwaysOnTop();
        if (bl == null || bl.booleanValue()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    View.getSingleton().getMainFrame().setAlwaysOnTop(true);
                    View.getSingleton().getMainFrame().toFront();
                    BreakPanel.this.setTabFocus();
                    BreakPanel.this.isAlwaysOnTop = true;
                    if (bl == null) {
                        boolean bl2 = View.getSingleton().showConfirmDialog(Constant.messages.getString("brk.alwaysOnTop.message")) == 0;
                        BreakPanel.this.breakpointsParams.setAlwaysOnTop(bl2);
                        if (!bl2) {
                            View.getSingleton().getMainFrame().setAlwaysOnTop(false);
                            BreakPanel.this.isAlwaysOnTop = false;
                        }
                    }
                }
            });
        }
    }

    private void setToolbarButtonsVisible(boolean bl) {
        boolean bl2 = this.currentButtonMode == 1;
        this.toolBarReqButton.setVisible(bl && !bl2);
        this.toolBarResButton.setVisible(bl && !bl2);
        this.toolBarAllButton.setVisible(bl && bl2);
        this.toolBarBtnStep.setVisible(bl);
        this.toolBarBtnContinue.setVisible(bl);
        this.toolBarBtnDrop.setVisible(bl);
        this.toolBarBtnBreakPoint.setVisible(bl);
    }

    public void setMessage(Message message, boolean bl) {
        CardLayout cardLayout = (CardLayout)this.panelContent.getLayout();
        if (bl) {
            this.requestPanel.setMessage(message, true);
            this.requestPanel.setEditable(true);
            cardLayout.show(this.panelContent, REQUEST_PANEL);
        } else {
            this.responsePanel.setMessage(message, true);
            this.responsePanel.setEditable(true);
            cardLayout.show(this.panelContent, RESPONSE_PANEL);
        }
    }

    public void saveMessage(boolean bl) {
        CardLayout cardLayout = (CardLayout)this.panelContent.getLayout();
        if (bl) {
            this.requestPanel.saveData();
            cardLayout.show(this.panelContent, REQUEST_PANEL);
        } else {
            this.responsePanel.saveData();
            cardLayout.show(this.panelContent, RESPONSE_PANEL);
        }
    }

    public void savePanels() {
        this.requestPanel.saveConfig(Model.getSingleton().getOptionsParam().getConfig());
        this.responsePanel.saveConfig(Model.getSingleton().getOptionsParam().getConfig());
    }

    public void clearAndDisableRequest() {
        this.requestPanel.clearView(false);
        this.requestPanel.setEditable(false);
        this.breakpointLeft();
    }

    public void clearAndDisableResponse() {
        this.responsePanel.clearView(false);
        this.responsePanel.setEditable(false);
        this.breakpointLeft();
    }

    private void breakpointLeft() {
        if (this.isAlwaysOnTop) {
            View.getSingleton().getMainFrame().setAlwaysOnTop(false);
            this.isAlwaysOnTop = false;
        }
    }

    public void init() {
        this.breakToolbarFactory.init();
    }

    public void reset() {
        this.breakToolbarFactory.reset();
    }

    public void sessionModeChanged(Control.Mode mode) {
        if (mode.equals((Object)Control.Mode.safe)) {
            this.breakToolbarFactory.setBreakEnabled(false);
        } else {
            this.breakToolbarFactory.setBreakEnabled(true);
        }
    }

    public void setBreakAllRequests(boolean bl) {
        this.breakToolbarFactory.setBreakRequest(bl);
    }

    public void setBreakAllResponses(boolean bl) {
        this.breakToolbarFactory.setBreakResponse(bl);
    }

    public void setBreakAll(boolean bl) {
        this.breakToolbarFactory.setBreakAll(bl);
    }

    public void step() {
        this.breakToolbarFactory.setStep(true);
    }

    public void cont() {
        this.breakToolbarFactory.setContinue(true);
    }

    public void drop() {
        this.breakToolbarFactory.drop();
    }

    public void showNewBreakPointDialog() {
        this.extension.addUiBreakpoint(new HttpMessage());
    }

    public void setButtonMode(int n) {
        if (this.currentButtonMode == n) {
            return;
        }
        this.currentButtonMode = n;
        this.breakToolbarFactory.setButtonMode(n);
        if (this.currentButtonsLocation == 0 || this.currentButtonsLocation == 2) {
            boolean bl = n == 1;
            this.toolBarReqButton.setVisible(!bl);
            this.toolBarResButton.setVisible(!bl);
            this.toolBarAllButton.setVisible(bl);
        }
        this.mainBreakButtons.setButtonMode(n);
        this.requestBreakButtons.setButtonMode(n);
        this.responseBreakButtons.setButtonMode(n);
    }

    private static class BreakButtonsUI {
        private final JToolBar toolBar;
        private final JToggleButton requestButton;
        private final JToggleButton responseButton;
        private final JToggleButton allButton;

        public BreakButtonsUI(String string, BreakPanelToolbarFactory breakPanelToolbarFactory) {
            this.requestButton = breakPanelToolbarFactory.getBtnBreakRequest();
            this.responseButton = breakPanelToolbarFactory.getBtnBreakResponse();
            this.allButton = breakPanelToolbarFactory.getBtnBreakAll();
            this.toolBar = new JToolBar();
            this.toolBar.setFloatable(false);
            this.toolBar.setBorder(BorderFactory.createEmptyBorder());
            this.toolBar.setRollover(true);
            this.toolBar.setName(string);
            this.toolBar.add(this.requestButton);
            this.toolBar.add(this.responseButton);
            this.toolBar.add(this.allButton);
            this.toolBar.add(breakPanelToolbarFactory.getBtnStep());
            this.toolBar.add(breakPanelToolbarFactory.getBtnContinue());
            this.toolBar.add(breakPanelToolbarFactory.getBtnDrop());
            this.toolBar.add(breakPanelToolbarFactory.getBtnBreakPoint());
        }

        public void setVisible(boolean bl) {
            this.toolBar.setVisible(bl);
        }

        public void setButtonMode(int n) {
            boolean bl = n == 1;
            this.requestButton.setVisible(!bl);
            this.responseButton.setVisible(!bl);
            this.allButton.setVisible(bl);
        }

        public JComponent getComponent() {
            return this.toolBar;
        }
    }
}

