/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import javax.swing.JOptionPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ContextAPI;
import org.zaproxy.zap.extension.api.CoreAPI;
import org.zaproxy.zap.extension.api.OptionsApiPanel;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionAPI
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionAPI";
    public static final String API_URL = "http://zap/";
    private OptionsApiPanel optionsApiPanel = null;
    private ZapMenuItem menuAPI = null;
    private CoreAPI coreApi = null;

    public ExtensionAPI() {
        this.initialize();
    }

    public ExtensionAPI(String string) {
        super(string);
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(10);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addSessionListener(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsAPIPanel());
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuAPI());
        }
        this.coreApi = new CoreAPI();
        this.coreApi.addApiOptions(extensionHook.getModel().getOptionsParam().getConnectionParam());
        API.getInstance().registerApiImplementor(this.coreApi);
        API.getInstance().registerApiImplementor(new ContextAPI());
    }

    private OptionsApiPanel getOptionsAPIPanel() {
        if (this.optionsApiPanel == null) {
            this.optionsApiPanel = new OptionsApiPanel();
        }
        return this.optionsApiPanel;
    }

    public static String generateApiKey() {
        SecureRandom secureRandom = new SecureRandom();
        return new BigInteger(130, secureRandom).toString(32);
    }

    private ZapMenuItem getMenuAPI() {
        if (this.menuAPI == null) {
            this.menuAPI = new ZapMenuItem("api.menu.tools.url");
            this.menuAPI.setEnabled(DesktopUtils.canOpenUrlInBrowser());
            this.menuAPI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!API.getInstance().isEnabled()) {
                        String string = Constant.messages.getString("api.dialogue.browseApiNotEnabled.title");
                        String string2 = Constant.messages.getString("api.dialogue.browseApiNotEnabled.message");
                        String string3 = Constant.messages.getString("api.dialogue.browseApiNotEnabled.button.confirm.label");
                        String string4 = Constant.messages.getString("api.dialogue.browseApiNotEnabled.button.cancel.label");
                        int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), string2, string, 0, 3, null, new String[]{string3, string4}, null);
                        if (n != 0) {
                            return;
                        }
                        Model.getSingleton().getOptionsParam().getApiParam().setEnabled(true);
                    }
                    DesktopUtils.openUrlInBrowser(ExtensionAPI.API_URL);
                }
            });
        }
        return this.menuAPI;
    }

    @Override
    public void sessionChanged(Session session) {
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("api.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    public CoreAPI getCoreAPI() {
        return this.coreApi;
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }
}

