/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfParam;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfParamToken;
import org.zaproxy.zap.extension.anticsrf.DialogAddToken;
import org.zaproxy.zap.extension.anticsrf.DialogModifyToken;
import org.zaproxy.zap.extension.anticsrf.OptionsAntiCsrfTableModel;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;

public class OptionsAntiCsrfPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private AntiCsrfMultipleOptionsPanel tokensOptionsPanel;
    private OptionsAntiCsrfTableModel antiCsrfModel = null;

    public OptionsAntiCsrfPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setName(Constant.messages.getString("options.acsrf.title"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        this.add((Component)new JLabel(Constant.messages.getString("options.acsrf.label.tokens")), gridBagConstraints);
        this.tokensOptionsPanel = new AntiCsrfMultipleOptionsPanel(this.getAntiCsrfModel());
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tokensOptionsPanel, gridBagConstraints);
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        AntiCsrfParam antiCsrfParam = optionsParam.getAntiCsrfParam();
        this.getAntiCsrfModel().setTokens(antiCsrfParam.getTokens());
        this.tokensOptionsPanel.setRemoveWithoutConfirmation(!antiCsrfParam.isConfirmRemoveToken());
    }

    @Override
    public void validateParam(Object object) throws Exception {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        AntiCsrfParam antiCsrfParam = optionsParam.getAntiCsrfParam();
        antiCsrfParam.setTokens(this.getAntiCsrfModel().getElements());
        antiCsrfParam.setConfirmRemoveToken(!this.tokensOptionsPanel.isRemoveWithoutConfirmation());
    }

    private OptionsAntiCsrfTableModel getAntiCsrfModel() {
        if (this.antiCsrfModel == null) {
            this.antiCsrfModel = new OptionsAntiCsrfTableModel();
        }
        return this.antiCsrfModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.anticsrf";
    }

    private static class AntiCsrfMultipleOptionsPanel
    extends AbstractMultipleOptionsTablePanel<AntiCsrfParamToken> {
        private static final long serialVersionUID = -115340627058929308L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("options.acsrf.dialog.token.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("options.acsrf.dialog.token.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("options.acsrf.dialog.token.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("options.acsrf.dialog.token.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("options.acsrf.dialog.token.remove.checkbox.label");
        private DialogAddToken addDialog = null;
        private DialogModifyToken modifyDialog = null;
        private OptionsAntiCsrfTableModel model;

        public AntiCsrfMultipleOptionsPanel(OptionsAntiCsrfTableModel optionsAntiCsrfTableModel) {
            super(optionsAntiCsrfTableModel);
            this.model = optionsAntiCsrfTableModel;
            this.getTable().getColumnExt(0).setPreferredWidth(20);
            this.getTable().setSortOrder(1, SortOrder.ASCENDING);
        }

        @Override
        public AntiCsrfParamToken showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddToken(View.getSingleton().getOptionsDialog(null));
                this.addDialog.pack();
            }
            this.addDialog.setTokens(this.model.getElements());
            this.addDialog.setVisible(true);
            AntiCsrfParamToken antiCsrfParamToken = this.addDialog.getToken();
            this.addDialog.clear();
            return antiCsrfParamToken;
        }

        @Override
        public AntiCsrfParamToken showModifyDialogue(AntiCsrfParamToken antiCsrfParamToken) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyToken(View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.setTokens(this.model.getElements());
            this.modifyDialog.setToken(antiCsrfParamToken);
            this.modifyDialog.setVisible(true);
            AntiCsrfParamToken antiCsrfParamToken2 = this.modifyDialog.getToken();
            this.modifyDialog.clear();
            if (!antiCsrfParamToken2.equals(antiCsrfParamToken)) {
                return antiCsrfParamToken2;
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(AntiCsrfParamToken antiCsrfParamToken) {
            JCheckBox jCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] objectArray = new Object[]{REMOVE_DIALOG_TEXT, " ", jCheckBox};
            int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), objectArray, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (n == 0) {
                this.setRemoveWithoutConfirmation(jCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

