/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.menu;

import com.Ostermiller.util.Browser;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.owasp.jbrofuzz.help.Topics;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.AbstractPanel;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.ui.menu.AboutBox;
import org.owasp.jbrofuzz.version.ImageCreator;

public class JBroFuzzToolBar
extends JToolBar {
    private static final long serialVersionUID = 8897142041231978024L;
    private final JBroFuzzWindow mFrameWindow;
    private final JButton start;
    private final JButton pause;
    private final JButton stop;
    private final JButton add;
    private final JButton remove;
    private final JButton help;
    private final JButton about;
    private final JButton website;

    public JBroFuzzToolBar(JBroFuzzWindow mFrameWindow) {
        this.mFrameWindow = mFrameWindow;
        this.start = new JButton(ImageCreator.IMG_START);
        this.start.setToolTipText("Start");
        this.pause = new JButton(ImageCreator.IMG_PAUSE);
        this.pause.setToolTipText("Pause");
        this.pause.setEnabled(false);
        this.stop = new JButton(ImageCreator.IMG_STOP);
        this.stop.setToolTipText("Stop");
        this.add = new JButton(ImageCreator.IMG_ADD);
        this.add.setToolTipText("Add");
        this.remove = new JButton(ImageCreator.IMG_REMOVE);
        this.remove.setToolTipText("Remove");
        this.help = new JButton(ImageCreator.IMG_TOPICS);
        this.help.setToolTipText("Help Topics");
        this.about = new JButton(ImageCreator.IMG_ABOUT);
        this.about.setToolTipText("About");
        this.website = new JButton(ImageCreator.IMG_OWASP_SML);
        this.website.setToolTipText("JBroFuzz Website");
        this.addSeparator(new Dimension(13, 0));
        this.add(this.start);
        this.add(this.pause);
        this.add(this.stop);
        this.addSeparator(new Dimension(13, 0));
        this.add(this.add);
        this.add(this.remove);
        this.addSeparator(new Dimension(13, 0));
        this.add(this.help);
        this.add(this.website);
        this.add(this.about);
        this.setFloatable(true);
        this.setRollover(true);
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final class Starter
                extends SwingWorker<String, Object> {
                    AbstractPanel p;

                    Starter() {
                    }

                    @Override
                    public String doInBackground() {
                        int c = JBroFuzzToolBar.this.getFrame().getTp().getSelectedIndex();
                        this.p = (AbstractPanel)JBroFuzzToolBar.this.getFrame().getTp().getComponent(c);
                        this.p.start();
                        return "start-menu-bar-done";
                    }

                    @Override
                    protected void done() {
                        this.p.stop();
                    }
                }
                new Starter().execute();
            }
        });
        this.stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int c = JBroFuzzToolBar.this.getFrame().getTp().getSelectedIndex();
                AbstractPanel p = (AbstractPanel)JBroFuzzToolBar.this.getFrame().getTp().getComponent(c);
                p.stop();
            }
        });
        this.pause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Logger.log("Pause functionality has not yet being implemented", 2);
                    }
                });
            }
        });
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int c = JBroFuzzToolBar.this.getFrame().getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)JBroFuzzToolBar.this.getFrame().getTp().getComponent(c);
                        p.add();
                    }
                });
            }
        });
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int c = JBroFuzzToolBar.this.getFrame().getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)JBroFuzzToolBar.this.getFrame().getTp().getComponent(c);
                        p.remove();
                    }
                });
            }
        });
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new Topics(JBroFuzzToolBar.this.getFrame());
                    }
                });
            }
        });
        this.about.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new AboutBox(JBroFuzzToolBar.this.getFrame(), AboutBox.Tab.ABOUT);
                    }
                });
            }
        });
        this.website.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Browser.init();
                        try {
                            Browser.displayURL((String)"http://www.owasp.org/index.php/JBroFuzz");
                        }
                        catch (IOException ex) {
                            Logger.log("Could not launch link in external browser", 3);
                        }
                    }
                });
            }
        });
    }

    public JBroFuzzWindow getFrame() {
        return this.mFrameWindow;
    }

    public void setEnabledPanelOptions(boolean[] b) {
        if (b.length == 5) {
            this.start.setEnabled(b[0]);
            this.stop.setEnabled(b[1]);
            this.pause.setEnabled(b[2]);
            this.add.setEnabled(b[3]);
            this.remove.setEnabled(b[4]);
        }
    }
}

