/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.property.Uid;

public class UidGenerator {
    private String pid;
    private InetAddress hostAddress;
    private static long lastMillis;

    public UidGenerator(String pid) throws SocketException {
        this(UidGenerator.findNonLoopbackAddress(), pid);
    }

    public UidGenerator(InetAddress hostAddress, String pid) {
        this.hostAddress = hostAddress;
        this.pid = pid;
    }

    public Uid generateUid() {
        StringBuffer b = new StringBuffer();
        b.append(UidGenerator.uniqueTimestamp());
        b.append('-');
        b.append(this.pid);
        if (this.hostAddress != null) {
            b.append('@');
            b.append(this.hostAddress.getHostName());
        }
        return new Uid(b.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateTime uniqueTimestamp() {
        long currentMillis;
        Class clazz = UidGenerator.class;
        synchronized (clazz) {
            currentMillis = System.currentTimeMillis();
            if (currentMillis < lastMillis) {
                currentMillis = lastMillis;
            }
            if (currentMillis - lastMillis < 1000L) {
                currentMillis += 1000L;
            }
            lastMillis = currentMillis;
        }
        DateTime timestamp = new DateTime(currentMillis);
        timestamp.setUtc(true);
        return timestamp;
    }

    private static InetAddress findNonLoopbackAddress() throws SocketException {
        Enumeration<NetworkInterface> enumInterfaceAddress = NetworkInterface.getNetworkInterfaces();
        while (enumInterfaceAddress.hasMoreElements()) {
            NetworkInterface netIf = enumInterfaceAddress.nextElement();
            Enumeration<InetAddress> enumInetAdress = netIf.getInetAddresses();
            while (enumInetAdress.hasMoreElements()) {
                InetAddress address = enumInetAdress.nextElement();
                if (address.isLoopbackAddress()) continue;
                return address;
            }
        }
        return null;
    }
}

