/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.explorer.view.MenuView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewTemplateAction
extends NodeAction {
    private static DataObject selectedTemplate;
    private static DataFolder targetFolder;
    private static int MAX_RECENT_ITEMS;
    private boolean active = false;
    private DataFolder privilegedListFolder;
    private DataFolder recentListFolder;
    private boolean recentChanged = true;
    private List<DataObject> recentList = new ArrayList<DataObject>(0);
    private static final Node[] EMPTY_NODE_ARRAY;

    static TemplateWizard getWizard(Node node) {
        TemplateWizard templateWizard;
        Cookie cookie;
        Node node2;
        if (node == null && ((Node[])(node2 = WindowManager.getDefault().getRegistry().getActivatedNodes())).length == 1) {
            node = node2[0];
        }
        targetFolder = null;
        for (node2 = node; targetFolder == null && node2 != null; node2 = node2.getParentNode()) {
            targetFolder = (DataFolder)node2.getCookie(DataFolder.class);
        }
        Cookie cookie2 = cookie = node == null ? null : (Cookie)node.getCookie(Cookie.class);
        if (cookie != null && (templateWizard = cookie.getTemplateWizard()) != null) {
            return templateWizard;
        }
        return new DefaultTemplateWizard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void performAction(Node[] nodeArray) {
        block19: {
            if (this.active) {
                return;
            }
            this.active = true;
            Node node = nodeArray.length == 1 ? nodeArray[0] : null;
            TemplateWizard templateWizard = NewTemplateAction.getWizard(node);
            if (templateWizard instanceof DefaultTemplateWizard) {
                if (targetFolder != null && targetFolder.isValid()) {
                    templateWizard.setTargetFolder(targetFolder);
                }
                if (selectedTemplate != null && selectedTemplate.isValid()) {
                    templateWizard.setTemplate(selectedTemplate);
                }
            }
            boolean bl = false;
            try {
                templateWizard.setTargetName(null);
                bl = templateWizard.instantiate() != null;
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (templateWizard instanceof DefaultTemplateWizard) {
                    try {
                        if (bl && (selectedTemplate = templateWizard.getTemplate()) != null) {
                            this.recentChanged = this.addRecent(selectedTemplate);
                        }
                        targetFolder = templateWizard.getTargetFolder();
                    }
                    catch (IOException iOException) {
                        selectedTemplate = null;
                        targetFolder = null;
                    }
                }
                this.active = false;
                throw throwable;
            }
            if (templateWizard instanceof DefaultTemplateWizard) {
                try {
                    if (bl && (selectedTemplate = templateWizard.getTemplate()) != null) {
                        this.recentChanged = this.addRecent(selectedTemplate);
                    }
                    targetFolder = templateWizard.getTargetFolder();
                }
                catch (IOException iOException) {
                    selectedTemplate = null;
                    targetFolder = null;
                }
            }
            this.active = false;
            {
                break block19;
                catch (IOException iOException) {
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(DataObject.class, (String)"EXC_TemplateFailed"));
                    Exceptions.printStackTrace((Throwable)iOException);
                    Object var7_6 = null;
                    if (templateWizard instanceof DefaultTemplateWizard) {
                        try {
                            if (bl && (selectedTemplate = templateWizard.getTemplate()) != null) {
                                this.recentChanged = this.addRecent(selectedTemplate);
                            }
                            targetFolder = templateWizard.getTargetFolder();
                        }
                        catch (IOException iOException2) {
                            selectedTemplate = null;
                            targetFolder = null;
                        }
                    }
                    this.active = false;
                }
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1) {
            return false;
        }
        Cookie cookie = (Cookie)nodeArray[0].getCookie(Cookie.class);
        if (cookie != null) {
            return cookie.getTemplateWizard() != null;
        }
        DataFolder dataFolder = (DataFolder)nodeArray[0].getCookie(DataFolder.class);
        return dataFolder != null && dataFolder.getPrimaryFile().canWrite();
    }

    public String getName() {
        return NbBundle.getMessage(DataObject.class, (String)"NewTemplate");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(NewTemplateAction.class);
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.MenuItem((SystemAction)this, true){

            public void setEnabled(boolean bl) {
                super.setEnabled(true);
            }
        };
    }

    public Component getToolbarPresenter() {
        return new Actions.ToolbarButton((SystemAction)this){

            public void setEnabled(boolean bl) {
                super.setEnabled(true);
            }
        };
    }

    public JMenuItem getPopupPresenter() {
        return this.getPopupPresenter(null, (Action)((Object)this));
    }

    private JMenuItem getPopupPresenter(Lookup lookup, Action action) {
        Node node;
        TemplateWizard templateWizard;
        Node[] nodeArray = new Node[]{};
        if (lookup != null) {
            nodeArray = NewTemplateAction.getNodesFromLookup(lookup);
        }
        if ((templateWizard = NewTemplateAction.getWizard(node = nodeArray.length == 1 ? nodeArray[0] : null)) instanceof DefaultTemplateWizard) {
            return new MenuWithRecent(node, this.isEnabled());
        }
        MenuView.Menu menu = new MenuView.Menu(null, new TemplateActionListener(lookup), false){

            public JPopupMenu getPopupMenu() {
                if (this.node == null) {
                    this.node = NewTemplateAction.getTemplateRoot(node);
                }
                return super.getPopupMenu();
            }
        };
        Actions.connect((JMenuItem)menu, (Action)action, (boolean)true);
        return menu;
    }

    private List<DataObject> getPrivilegedList() {
        DataObject[] dataObjectArray;
        if (this.privilegedListFolder == null && (dataObjectArray = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Privileged")) != null) {
            this.privilegedListFolder = DataFolder.findFolder((FileObject)dataObjectArray);
        }
        if (this.privilegedListFolder != null) {
            dataObjectArray = this.privilegedListFolder.getChildren();
            ArrayList<DataObject> arrayList = new ArrayList<DataObject>(dataObjectArray.length);
            for (int i = 0; i < dataObjectArray.length; ++i) {
                DataObject dataObject = dataObjectArray[i];
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (!this.isValidTemplate(dataObject)) continue;
                arrayList.add(dataObject);
            }
            return arrayList;
        }
        return new ArrayList<DataObject>(0);
    }

    private void doShowWizard(DataObject dataObject, Node node) {
        targetFolder = null;
        TemplateWizard templateWizard = NewTemplateAction.getWizard(node);
        try {
            templateWizard.setTargetName(null);
            Set<DataObject> set = templateWizard.instantiate(dataObject, targetFolder);
            if (set != null && templateWizard instanceof DefaultTemplateWizard && (selectedTemplate = templateWizard.getTemplate()) != null) {
                this.recentChanged = this.addRecent(selectedTemplate);
            }
        }
        catch (IOException iOException) {
            Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(DataObject.class, (String)"EXC_TemplateFailed"));
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private DataFolder getRecentFolder() {
        FileObject fileObject;
        if (this.recentListFolder == null && (fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Recent")) != null) {
            this.recentListFolder = DataFolder.findFolder(fileObject);
        }
        return this.recentListFolder;
    }

    private List<DataObject> getRecentList() {
        if (!this.recentChanged) {
            return this.recentList;
        }
        if (this.getRecentFolder() != null) {
            DataObject[] dataObjectArray = this.getRecentFolder().getChildren();
            ArrayList<DataObject> arrayList = new ArrayList<DataObject>(dataObjectArray.length);
            for (int i = 0; i < dataObjectArray.length; ++i) {
                DataObject dataObject = dataObjectArray[i];
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (this.isValidTemplate(dataObject)) {
                    arrayList.add(dataObject);
                    continue;
                }
                this.removeRecent(dataObjectArray[i]);
            }
            this.recentList = arrayList;
        } else {
            this.recentList = new ArrayList<DataObject>(0);
        }
        this.recentChanged = false;
        return this.recentList;
    }

    private boolean isValidTemplate(DataObject dataObject) {
        return dataObject != null && dataObject.isTemplate() && dataObject.isValid();
    }

    private boolean addRecent(DataObject dataObject) {
        int n;
        DataFolder dataFolder = this.getRecentFolder();
        if (dataFolder == null) {
            return false;
        }
        if (this.getPrivilegedList().contains(dataObject)) {
            return false;
        }
        if (this.isRecent(dataObject)) {
            return false;
        }
        DataObject[] dataObjectArray = dataFolder.getChildren();
        DataObject[] dataObjectArray2 = new DataObject[dataObjectArray.length + 1];
        for (n = 1; n < dataObjectArray2.length; ++n) {
            dataObjectArray2[n] = dataObjectArray[n - 1];
        }
        try {
            dataObjectArray2[0] = dataObject.createShadow(dataFolder);
            dataFolder.setOrder(dataObjectArray2);
        }
        catch (IOException iOException) {
            Logger.getLogger(NewTemplateAction.class.getName()).log(Level.WARNING, null, iOException);
            return false;
        }
        dataObjectArray = dataFolder.getChildren();
        for (n = dataObjectArray.length; n > MAX_RECENT_ITEMS; --n) {
            this.removeRecent(dataObjectArray[n - 1]);
        }
        return true;
    }

    private boolean removeRecent(DataObject dataObject) {
        DataFolder dataFolder = this.getRecentFolder();
        if (dataFolder == null) {
            return false;
        }
        try {
            dataObject.delete();
            return true;
        }
        catch (IOException iOException) {
            Logger.getLogger(NewTemplateAction.class.getName()).log(Level.WARNING, null, iOException);
            return false;
        }
    }

    private boolean isRecent(DataObject dataObject) {
        return this.getRecentList().contains(dataObject);
    }

    public static Node getTemplateRoot() {
        RootChildren rootChildren = new RootChildren(null);
        DataFolder dataFolder = rootChildren.getRootFolder();
        dataFolder.getClass();
        return new DataFolder.FolderNode(dataFolder, (Children)rootChildren);
    }

    private static Node getTemplateRoot(Node node) {
        RootChildren rootChildren = new RootChildren(node);
        DataFolder dataFolder = rootChildren.getRootFolder();
        dataFolder.getClass();
        DataFolder.FolderNode folderNode = new DataFolder.FolderNode(dataFolder, (Children)rootChildren);
        return folderNode;
    }

    private static boolean acceptObj(DataObject dataObject) {
        if (dataObject.isTemplate()) {
            return true;
        }
        if (dataObject instanceof DataFolder) {
            Object object = dataObject.getPrimaryFile().getAttribute("simple");
            return object == null || Boolean.TRUE.equals(object);
        }
        return false;
    }

    private void updateAction() {
    }

    private static final synchronized Node[] getNodesFromLookup(Lookup lookup) {
        if (lookup != null) {
            return lookup.lookupAll(Node.class).toArray(EMPTY_NODE_ARRAY);
        }
        return EMPTY_NODE_ARRAY;
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new DelegateAction(this, lookup);
    }

    static {
        MAX_RECENT_ITEMS = 5;
        EMPTY_NODE_ARRAY = new Node[0];
    }

    private static final class DelegateAction
    implements Action,
    Presenter.Popup,
    LookupListener {
        private NewTemplateAction delegate;
        private Lookup actionContext;
        private Lookup.Result nodesResult;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);

        public DelegateAction(NewTemplateAction newTemplateAction, Lookup lookup) {
            this.delegate = newTemplateAction;
            this.actionContext = lookup;
            this.nodesResult = lookup.lookupResult(Node.class);
            this.nodesResult.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        public String toString() {
            return super.toString() + "[delegate=" + (Object)((Object)this.delegate) + "]";
        }

        public void putValue(String string, Object object) {
        }

        public boolean isEnabled() {
            return this.delegate.enable(NewTemplateAction.getNodesFromLookup(this.actionContext));
        }

        public Object getValue(String string) {
            return this.delegate.getValue(string);
        }

        public void setEnabled(boolean bl) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.support.removePropertyChangeListener(propertyChangeListener);
        }

        public JMenuItem getPopupPresenter() {
            return this.delegate.getPopupPresenter(this.actionContext, this);
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.getPopupPresenter();
        }
    }

    private class NodeLookupListener
    implements LookupListener {
        private NodeLookupListener() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            NewTemplateAction.this.updateAction();
        }
    }

    private static class DefaultTemplateWizard
    extends TemplateWizard {
        DefaultTemplateWizard() {
        }
    }

    private static class DataShadowFilterNode
    extends FilterNode {
        private String name;

        public DataShadowFilterNode(Node node, Children children, String string) {
            super(node, children);
            this.name = string;
            this.disableDelegation(4);
        }

        public String getDisplayName() {
            return this.name;
        }
    }

    private static class TemplateChildren
    extends FilterNode.Children {
        public TemplateChildren(Node node) {
            super(node);
        }

        protected Node[] createNodes(Node node) {
            String string = node.getDisplayName();
            DataObject dataObject = null;
            DataShadow dataShadow = (DataShadow)node.getCookie(DataShadow.class);
            if (dataShadow != null) {
                DataNode dataNode = new DataNode(dataShadow, Children.LEAF);
                string = dataNode.getDisplayName();
                dataObject = dataShadow.getOriginal();
                node = dataObject.getNodeDelegate();
            }
            if (dataObject == null) {
                dataObject = (DataObject)node.getCookie(DataObject.class);
            }
            if (dataObject != null) {
                if (dataObject.isTemplate()) {
                    return new Node[]{new DataShadowFilterNode(node, LEAF, string)};
                }
                if (NewTemplateAction.acceptObj(dataObject)) {
                    return new Node[]{new DataShadowFilterNode(node, (Children)new TemplateChildren(node), string)};
                }
            }
            return new Node[0];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootChildren
    extends Children.Keys<Node>
    implements NodeListener {
        private TemplateWizard wizard;
        private DataFolder rootFolder;
        private WeakReference<Node> current;
        private NodeListener listener = NodeOp.weakNodeListener((NodeListener)this, null);

        public RootChildren(Node node) {
            TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
            registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)((Object)this), (Object)registry));
            this.updateWizard(NewTemplateAction.getWizard(node));
        }

        public DataFolder getRootFolder() {
            if (this.rootFolder == null) {
                this.doSetKeys();
            }
            return this.rootFolder;
        }

        protected Node[] createNodes(Node node) {
            String string = node.getDisplayName();
            DataObject dataObject = null;
            DataShadow dataShadow = (DataShadow)node.getCookie(DataShadow.class);
            if (dataShadow != null) {
                DataNode dataNode = new DataNode(dataShadow, Children.LEAF);
                string = dataNode.getDisplayName();
                dataObject = dataShadow.getOriginal();
                node = dataObject.getNodeDelegate();
            }
            if (dataObject == null) {
                dataObject = (DataObject)node.getCookie(DataObject.class);
            }
            if (dataObject != null) {
                if (dataObject.isTemplate()) {
                    return new Node[]{new DataShadowFilterNode(node, LEAF, string)};
                }
                if (NewTemplateAction.acceptObj(dataObject)) {
                    return new Node[]{new DataShadowFilterNode(node, (Children)new TemplateChildren(node), string)};
                }
            }
            return null;
        }

        private void updateNode(Node node) {
            Node node2;
            if (this.current != null && this.current.get() == node) {
                return;
            }
            Node node3 = node2 = this.current != null ? (Node)this.current.get() : null;
            if (node2 != null) {
                node2.removeNodeListener(this.listener);
            }
            node.addNodeListener(this.listener);
            this.current = new WeakReference<Node>(node);
        }

        private void updateWizard(TemplateWizard templateWizard) {
            Node node;
            if (this.wizard == templateWizard) {
                return;
            }
            if (this.wizard != null) {
                node = this.wizard.getTemplatesFolder().getNodeDelegate();
                node.removeNodeListener(this.listener);
            }
            node = templateWizard.getTemplatesFolder().getNodeDelegate();
            node.addNodeListener(this.listener);
            this.wizard = templateWizard;
            this.updateKeys();
        }

        private void updateKeys() {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    RootChildren.this.doSetKeys();
                }
            });
        }

        private void doSetKeys() {
            this.rootFolder = this.wizard.getTemplatesFolder();
            this.setKeys(this.rootFolder.getNodeDelegate().getChildren().getNodes(true));
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
            this.updateKeys();
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
            this.updateKeys();
        }

        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
            this.updateKeys();
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Node[] nodeArray;
            String string = propertyChangeEvent.getPropertyName();
            if (this.current != null && propertyChangeEvent.getSource() == this.current.get()) {
                if ("cookie".equals(string)) {
                    final Node node = (Node)this.current.get();
                    Mutex.EVENT.readAccess(new Runnable(){

                        public void run() {
                            RootChildren.this.updateWizard(NewTemplateAction.getWizard(node));
                        }
                    });
                }
            } else if ("activatedNodes".equals(string) && (nodeArray = WindowManager.getDefault().getRegistry().getActivatedNodes()).length == 1) {
                this.updateNode(nodeArray[0]);
            }
        }
    }

    private static class TemplateActionListener
    implements NodeAcceptor,
    DataFilter {
        static final long serialVersionUID = 1214995994333505784L;
        Lookup actionContext;

        TemplateActionListener(Lookup lookup) {
            this.actionContext = lookup;
        }

        public boolean acceptNodes(Node[] nodeArray) {
            Node[] nodeArray2 = null;
            if (this.actionContext != null) {
                nodeArray2 = NewTemplateAction.getNodesFromLookup(this.actionContext);
            }
            if (nodeArray2 == null || nodeArray2.length != 1) {
                Logger.getAnonymousLogger().warning("Wrong count of nodes in context lookup.");
                return false;
            }
            if (nodeArray == null || nodeArray.length != 1) {
                Logger.getAnonymousLogger().warning("Wrong count of selected nodes in popup menu.");
                return false;
            }
            Node node = nodeArray[0];
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject == null || !dataObject.isTemplate()) {
                Logger.getAnonymousLogger().warning("Selected node in popup menu is not acceptable.");
                return false;
            }
            TemplateWizard templateWizard = NewTemplateAction.getWizard(nodeArray2[0]);
            try {
                templateWizard.setTargetName(null);
                templateWizard.instantiate(dataObject, targetFolder);
            }
            catch (IOException iOException) {
                Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(DataObject.class, (String)"EXC_TemplateFailed"));
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return true;
        }

        public boolean acceptDataObject(DataObject dataObject) {
            return NewTemplateAction.acceptObj(dataObject);
        }
    }

    public static interface Cookie
    extends Node.Cookie {
        public TemplateWizard getTemplateWizard();
    }

    private class MenuWithRecent
    extends JMenuPlus {
        private boolean initialized = false;
        private Node node;
        private boolean canWrite;

        public MenuWithRecent(Node node, boolean bl) {
            Actions.setMenuText((AbstractButton)((Object)this), (String)NewTemplateAction.this.getName(), (boolean)false);
            this.node = node;
            this.canWrite = bl;
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu jPopupMenu = super.getPopupMenu();
            if (!this.initialized) {
                jPopupMenu.add(new Item(null));
                List list = NewTemplateAction.this.getPrivilegedList();
                if (list.size() > 0) {
                    jPopupMenu.add(new JSeparator());
                }
                for (DataObject dataObject : list) {
                    if (dataObject instanceof DataShadow) {
                        dataObject = ((DataShadow)dataObject).getOriginal();
                    }
                    jPopupMenu.add(new Item(dataObject));
                }
                boolean bl = false;
                boolean bl2 = !NewTemplateAction.this.getRecentList().isEmpty();
                for (DataObject dataObject : NewTemplateAction.this.getRecentList()) {
                    if (NewTemplateAction.this.isValidTemplate(dataObject)) {
                        if (bl2) {
                            jPopupMenu.add(new JSeparator());
                        }
                        bl2 = false;
                        jPopupMenu.add(new Item(dataObject));
                        continue;
                    }
                    bl = true;
                }
                NewTemplateAction.this.recentChanged = NewTemplateAction.this.recentChanged || bl;
                this.initialized = true;
            }
            return jPopupMenu;
        }

        private class Item
        extends JMenuItem
        implements HelpCtx.Provider,
        ActionListener {
            DataObject template;

            public Item(DataObject dataObject) {
                this.template = dataObject;
                this.setText(dataObject == null ? NbBundle.getMessage(DataObject.class, (String)"NewTemplateAction") : dataObject.getNodeDelegate().getDisplayName());
                if (dataObject == null) {
                    this.setIcon(NewTemplateAction.this.getIcon());
                } else {
                    this.setIcon(new ImageIcon(dataObject.getNodeDelegate().getIcon(1)));
                }
                this.addActionListener(this);
                this.setEnabled(MenuWithRecent.this.canWrite);
            }

            public HelpCtx getHelpCtx() {
                if (this.template != null) {
                    return this.template.getHelpCtx();
                }
                return NewTemplateAction.this.getHelpCtx();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                NewTemplateAction.this.doShowWizard(this.template, MenuWithRecent.this.node);
            }
        }
    }
}

