/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfviewer.PageWrapper;
import org.pdfbox.pdfviewer.ReaderBottomPanel;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.util.DefaultFileFilter;

public class PDFReader
extends JFrame {
    private File currentDir = new File(".");
    private JMenuItem aboutMenuItem;
    private JMenuItem contentsMenuItem;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenu editMenu;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuBar menuBar;
    private JMenuItem openMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem saveMenuItem;
    private JPanel documentPanel = new JPanel();
    private ReaderBottomPanel bottomStatusPanel = new ReaderBottomPanel();
    private PDDocument document = null;

    public PDFReader() {
        this.initComponents();
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.contentsMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.setTitle("PDFBox - PDF Reader");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PDFReader.this.exitForm(evt);
            }
        });
        JScrollPane documentScroller = new JScrollPane();
        documentScroller.setViewportView(this.documentPanel);
        this.getContentPane().add((Component)documentScroller, "Center");
        this.getContentPane().add((Component)this.bottomStatusPanel, "South");
        this.fileMenu.setText("File");
        this.openMenuItem.setText("Open");
        this.openMenuItem.setToolTipText("Open PDF file");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFReader.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText("Save");
        this.saveAsMenuItem.setText("Save As ...");
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PDFReader.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.cutMenuItem.setText("Cut");
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText("Copy");
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText("Paste");
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.editMenu.add(this.deleteMenuItem);
        this.helpMenu.setText("Help");
        this.contentsMenuItem.setText("Contents");
        this.helpMenu.add(this.contentsMenuItem);
        this.aboutMenuItem.setText("About");
        this.helpMenu.add(this.aboutMenuItem);
        this.setJMenuBar(this.menuBar);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 700) / 2, (screenSize.height - 600) / 2, 700, 600);
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(this.currentDir);
        DefaultFileFilter pdfFilter = new DefaultFileFilter(new String[]{"pdf", "PDF"}, "PDF Files");
        chooser.setFileFilter(pdfFilter);
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            String name = chooser.getSelectedFile().getPath();
            this.currentDir = new File(name).getParentFile();
            try {
                this.openPDFFile(name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) throws Exception {
        PDFReader viewer = new PDFReader();
        if (args.length > 0) {
            viewer.openPDFFile(args[0]);
        }
        viewer.show();
    }

    private void openPDFFile(String file) throws Exception {
        if (this.document != null) {
            this.document.close();
            this.documentPanel.removeAll();
        }
        FileInputStream input = null;
        File f = new File(file);
        input = new FileInputStream(f);
        this.document = PDFReader.parseDocument(input);
        this.setTitle("PDFBox - " + f.getAbsolutePath());
        List pages = this.document.getDocumentCatalog().getAllPages();
        for (int i = 0; i < pages.size(); ++i) {
            PageWrapper wrapper = new PageWrapper(this);
            wrapper.displayPage((PDPage)pages.get(i));
            this.documentPanel.add(wrapper.getPanel());
        }
    }

    private static PDDocument parseDocument(InputStream input) throws IOException {
        PDDocument document = PDDocument.load(input);
        if (document.isEncrypted()) {
            try {
                document.decrypt("");
            }
            catch (InvalidPasswordException e) {
                System.err.println("Error: The document is encrypted.");
            }
            catch (CryptographyException e) {
                e.printStackTrace();
            }
        }
        return document;
    }

    public ReaderBottomPanel getBottomStatusPanel() {
        return this.bottomStatusPanel;
    }
}

