/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineOutputStream;
import com.sun.mail.util.SharedByteArrayInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.NewsAddress;
import javax.mail.internet.SharedInputStream;
import javax.mail.internet.UniqueValue;

public class MimeMessage
extends Message
implements MimePart {
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;
    protected Flags flags;
    protected boolean modified = false;
    protected boolean saved = false;
    private static MailDateFormat mailDateFormat = new MailDateFormat();
    private boolean strict = true;
    private static final Flags answeredFlag = new Flags(Flags.Flag.ANSWERED);

    public MimeMessage(Session session) {
        super(session);
        this.modified = true;
        this.headers = new InternetHeaders();
        this.flags = new Flags();
        this.initStrict();
    }

    public MimeMessage(Session session, InputStream inputStream) throws MessagingException {
        super(session);
        this.flags = new Flags();
        this.initStrict();
        this.parse(inputStream);
        this.saved = true;
    }

    public MimeMessage(MimeMessage mimeMessage) throws MessagingException {
        super(mimeMessage.session);
        this.flags = mimeMessage.getFlags();
        int n = mimeMessage.getSize();
        ByteArrayOutputStream byteArrayOutputStream = n > 0 ? new ByteArrayOutputStream(n) : new ByteArrayOutputStream();
        try {
            this.strict = mimeMessage.strict;
            mimeMessage.writeTo(byteArrayOutputStream);
            ((OutputStream)byteArrayOutputStream).close();
            SharedByteArrayInputStream sharedByteArrayInputStream = new SharedByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this.parse(sharedByteArrayInputStream);
            ((InputStream)sharedByteArrayInputStream).close();
            this.saved = true;
            return;
        }
        catch (IOException iOException) {
            throw new MessagingException("IOException while copying message", iOException);
        }
    }

    protected MimeMessage(Folder folder, int n) {
        super(folder, n);
        this.flags = new Flags();
        this.saved = true;
        this.initStrict();
    }

    protected MimeMessage(Folder folder, InputStream inputStream, int n) throws MessagingException {
        this(folder, n);
        this.initStrict();
        this.parse(inputStream);
    }

    protected MimeMessage(Folder folder, InternetHeaders internetHeaders, byte[] byArray, int n) throws MessagingException {
        this(folder, n);
        this.headers = internetHeaders;
        this.content = byArray;
        this.initStrict();
    }

    private void initStrict() {
        if (this.session != null) {
            String string = this.session.getProperty("mail.mime.address.strict");
            this.strict = string == null || !string.equalsIgnoreCase("false");
        }
    }

    protected void parse(InputStream inputStream) throws MessagingException {
        if (!(inputStream instanceof ByteArrayInputStream || inputStream instanceof BufferedInputStream || inputStream instanceof SharedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this.headers = this.createInternetHeaders(inputStream);
        if (inputStream instanceof SharedInputStream) {
            SharedInputStream sharedInputStream = (SharedInputStream)((Object)inputStream);
            this.contentStream = sharedInputStream.newStream(sharedInputStream.getPosition(), -1L);
        } else {
            try {
                this.content = ASCIIUtility.getBytes(inputStream);
            }
            catch (IOException iOException) {
                throw new MessagingException("IOException", iOException);
            }
        }
        this.modified = false;
    }

    public Address[] getFrom() throws MessagingException {
        Address[] addressArray = this.getAddressHeader("From");
        if (addressArray == null) {
            addressArray = this.getAddressHeader("Sender");
        }
        return addressArray;
    }

    public void setFrom(Address address) throws MessagingException {
        if (address == null) {
            this.removeHeader("From");
            return;
        }
        this.setHeader("From", address.toString());
    }

    public void setFrom() throws MessagingException {
        InternetAddress internetAddress = InternetAddress.getLocalAddress(this.session);
        if (internetAddress != null) {
            this.setFrom(internetAddress);
            return;
        }
        throw new MessagingException("No From address");
    }

    public void addFrom(Address[] addressArray) throws MessagingException {
        this.addAddressHeader("From", addressArray);
    }

    public Address getSender() throws MessagingException {
        Address[] addressArray = this.getAddressHeader("Sender");
        if (addressArray == null || addressArray.length == 0) {
            return null;
        }
        return addressArray[0];
    }

    public void setSender(Address address) throws MessagingException {
        if (address == null) {
            this.removeHeader("Sender");
            return;
        }
        this.setHeader("Sender", address.toString());
    }

    public Address[] getRecipients(Message.RecipientType recipientType) throws MessagingException {
        if (recipientType == RecipientType.NEWSGROUPS) {
            String string = this.getHeader("Newsgroups", ",");
            if (string == null) {
                return null;
            }
            return NewsAddress.parse(string);
        }
        return this.getAddressHeader(this.getHeaderName(recipientType));
    }

    public Address[] getAllRecipients() throws MessagingException {
        Address[] addressArray = super.getAllRecipients();
        Address[] addressArray2 = this.getRecipients(RecipientType.NEWSGROUPS);
        if (addressArray2 == null) {
            return addressArray;
        }
        int n = (addressArray != null ? addressArray.length : 0) + (addressArray2 != null ? addressArray2.length : 0);
        Address[] addressArray3 = new Address[n];
        int n2 = 0;
        if (addressArray != null) {
            System.arraycopy(addressArray, 0, addressArray3, n2, addressArray.length);
            n2 += addressArray.length;
        }
        if (addressArray2 != null) {
            System.arraycopy(addressArray2, 0, addressArray3, n2, addressArray2.length);
            n2 += addressArray2.length;
        }
        return addressArray3;
    }

    public void setRecipients(Message.RecipientType recipientType, Address[] addressArray) throws MessagingException {
        if (recipientType == RecipientType.NEWSGROUPS) {
            if (addressArray == null || addressArray.length == 0) {
                this.removeHeader("Newsgroups");
                return;
            }
            this.setHeader("Newsgroups", NewsAddress.toString(addressArray));
            return;
        }
        this.setAddressHeader(this.getHeaderName(recipientType), addressArray);
    }

    public void setRecipients(Message.RecipientType recipientType, String string) throws MessagingException {
        if (recipientType == RecipientType.NEWSGROUPS) {
            if (string == null || string.length() == 0) {
                this.removeHeader("Newsgroups");
                return;
            }
            this.setHeader("Newsgroups", string);
            return;
        }
        this.setAddressHeader(this.getHeaderName(recipientType), InternetAddress.parse(string));
    }

    public void addRecipients(Message.RecipientType recipientType, Address[] addressArray) throws MessagingException {
        if (recipientType == RecipientType.NEWSGROUPS) {
            String string = NewsAddress.toString(addressArray);
            if (string != null) {
                this.addHeader("Newsgroups", string);
                return;
            }
        } else {
            this.addAddressHeader(this.getHeaderName(recipientType), addressArray);
        }
    }

    public void addRecipients(Message.RecipientType recipientType, String string) throws MessagingException {
        if (recipientType == RecipientType.NEWSGROUPS) {
            if (string != null && string.length() != 0) {
                this.addHeader("Newsgroups", string);
                return;
            }
        } else {
            this.addAddressHeader(this.getHeaderName(recipientType), InternetAddress.parse(string));
        }
    }

    public Address[] getReplyTo() throws MessagingException {
        Address[] addressArray = this.getAddressHeader("Reply-To");
        if (addressArray == null) {
            addressArray = this.getFrom();
        }
        return addressArray;
    }

    public void setReplyTo(Address[] addressArray) throws MessagingException {
        this.setAddressHeader("Reply-To", addressArray);
    }

    private Address[] getAddressHeader(String string) throws MessagingException {
        String string2 = this.getHeader(string, ",");
        if (string2 == null) {
            return null;
        }
        return InternetAddress.parseHeader(string2, this.strict);
    }

    private void setAddressHeader(String string, Address[] addressArray) throws MessagingException {
        String string2 = InternetAddress.toString(addressArray);
        if (string2 == null) {
            this.removeHeader(string);
            return;
        }
        this.setHeader(string, string2);
    }

    private void addAddressHeader(String string, Address[] addressArray) throws MessagingException {
        String string2 = InternetAddress.toString(addressArray);
        if (string2 == null) {
            return;
        }
        this.addHeader(string, string2);
    }

    public String getSubject() throws MessagingException {
        String string = this.getHeader("Subject", null);
        if (string == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText(MimeUtility.unfold(string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public void setSubject(String string) throws MessagingException {
        this.setSubject(string, null);
    }

    public void setSubject(String string, String string2) throws MessagingException {
        if (string == null) {
            this.removeHeader("Subject");
        }
        try {
            this.setHeader("Subject", MimeUtility.fold(9, MimeUtility.encodeText(string, string2, null)));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new MessagingException("Encoding error", unsupportedEncodingException);
        }
    }

    public Date getSentDate() throws MessagingException {
        String string = this.getHeader("Date", null);
        if (string != null) {
            try {
                MailDateFormat mailDateFormat = MimeMessage.mailDateFormat;
                synchronized (mailDateFormat) {
                    Date date = MimeMessage.mailDateFormat.parse(string);
                    Object var4_4 = null;
                    return date;
                }
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    public void setSentDate(Date date) throws MessagingException {
        if (date == null) {
            this.removeHeader("Date");
            return;
        }
        MailDateFormat mailDateFormat = MimeMessage.mailDateFormat;
        synchronized (mailDateFormat) {
            this.setHeader("Date", MimeMessage.mailDateFormat.format(date));
            return;
        }
    }

    public Date getReceivedDate() throws MessagingException {
        return null;
    }

    public int getSize() throws MessagingException {
        block4: {
            if (this.content != null) {
                return this.content.length;
            }
            if (this.contentStream == null) break block4;
            try {
                int n = this.contentStream.available();
                if (n > 0) {
                    return n;
                }
            }
            catch (IOException iOException) {}
        }
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        String string = this.getHeader("Content-Type", null);
        if (string == null) {
            return "text/plain";
        }
        return string;
    }

    public boolean isMimeType(String string) throws MessagingException {
        return MimeBodyPart.isMimeType(this, string);
    }

    public String getDisposition() throws MessagingException {
        return MimeBodyPart.getDisposition(this);
    }

    public void setDisposition(String string) throws MessagingException {
        MimeBodyPart.setDisposition(this, string);
    }

    public String getEncoding() throws MessagingException {
        return MimeBodyPart.getEncoding(this);
    }

    public String getContentID() throws MessagingException {
        return this.getHeader("Content-Id", null);
    }

    public void setContentID(String string) throws MessagingException {
        if (string == null) {
            this.removeHeader("Content-ID");
            return;
        }
        this.setHeader("Content-ID", string);
    }

    public String getContentMD5() throws MessagingException {
        return this.getHeader("Content-MD5", null);
    }

    public void setContentMD5(String string) throws MessagingException {
        this.setHeader("Content-MD5", string);
    }

    public String getDescription() throws MessagingException {
        return MimeBodyPart.getDescription(this);
    }

    public void setDescription(String string) throws MessagingException {
        this.setDescription(string, null);
    }

    public void setDescription(String string, String string2) throws MessagingException {
        MimeBodyPart.setDescription(this, string, string2);
    }

    public String[] getContentLanguage() throws MessagingException {
        return MimeBodyPart.getContentLanguage(this);
    }

    public void setContentLanguage(String[] stringArray) throws MessagingException {
        MimeBodyPart.setContentLanguage(this, stringArray);
    }

    public String getMessageID() throws MessagingException {
        return this.getHeader("Message-ID", null);
    }

    public String getFileName() throws MessagingException {
        return MimeBodyPart.getFileName(this);
    }

    public void setFileName(String string) throws MessagingException {
        MimeBodyPart.setFileName(this, string);
    }

    private String getHeaderName(Message.RecipientType recipientType) throws MessagingException {
        String string;
        if (recipientType == Message.RecipientType.TO) {
            string = "To";
        } else if (recipientType == Message.RecipientType.CC) {
            string = "Cc";
        } else if (recipientType == Message.RecipientType.BCC) {
            string = "Bcc";
        } else if (recipientType == RecipientType.NEWSGROUPS) {
            string = "Newsgroups";
        } else {
            throw new MessagingException("Invalid Recipient Type");
        }
        return string;
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.contentStream != null) {
            return ((SharedInputStream)((Object)this.contentStream)).newStream(0L, -1L);
        }
        if (this.content != null) {
            return new SharedByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler((DataSource)new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() throws IOException, MessagingException {
        return this.getDataHandler().getContent();
    }

    public synchronized void setDataHandler(DataHandler dataHandler) throws MessagingException {
        this.dh = dataHandler;
        MimeBodyPart.invalidateContentHeaders(this);
    }

    public void setContent(Object object, String string) throws MessagingException {
        this.setDataHandler(new DataHandler(object, string));
    }

    public void setText(String string) throws MessagingException {
        this.setText(string, null);
    }

    public void setText(String string, String string2) throws MessagingException {
        MimeBodyPart.setText(this, string, string2);
    }

    public void setContent(Multipart multipart) throws MessagingException {
        this.setDataHandler(new DataHandler((Object)multipart, multipart.getContentType()));
        multipart.setParent(this);
    }

    public Message reply(boolean bl) throws MessagingException {
        Object object;
        MimeMessage mimeMessage = new MimeMessage(this.session);
        String string = this.getHeader("Subject", null);
        if (string != null) {
            if (!string.regionMatches(true, 0, "Re: ", 0, 4)) {
                string = "Re: " + string;
            }
            mimeMessage.setHeader("Subject", string);
        }
        Address[] addressArray = this.getReplyTo();
        mimeMessage.setRecipients(Message.RecipientType.TO, addressArray);
        if (bl) {
            object = new Vector();
            InternetAddress internetAddress = InternetAddress.getLocalAddress(this.session);
            if (internetAddress != null) {
                ((Vector)object).addElement(internetAddress);
            }
            String string2 = null;
            if (this.session != null) {
                string2 = this.session.getProperty("mail.alternates");
            }
            if (string2 != null) {
                this.eliminateDuplicates((Vector)object, InternetAddress.parse(string2, false));
            }
            String string3 = null;
            if (this.session != null) {
                string3 = this.session.getProperty("mail.replyallcc");
            }
            boolean bl2 = string3 != null && string3.equalsIgnoreCase("true");
            this.eliminateDuplicates((Vector)object, addressArray);
            addressArray = this.getRecipients(Message.RecipientType.TO);
            addressArray = this.eliminateDuplicates((Vector)object, addressArray);
            if (addressArray != null && addressArray.length > 0) {
                if (bl2) {
                    mimeMessage.addRecipients(Message.RecipientType.CC, addressArray);
                } else {
                    mimeMessage.addRecipients(Message.RecipientType.TO, addressArray);
                }
            }
            addressArray = this.getRecipients(Message.RecipientType.CC);
            if ((addressArray = this.eliminateDuplicates((Vector)object, addressArray)) != null && addressArray.length > 0) {
                mimeMessage.addRecipients(Message.RecipientType.CC, addressArray);
            }
            if ((addressArray = this.getRecipients(RecipientType.NEWSGROUPS)) != null && addressArray.length > 0) {
                mimeMessage.setRecipients((Message.RecipientType)RecipientType.NEWSGROUPS, addressArray);
            }
        }
        if ((object = this.getHeader("Message-Id", null)) != null) {
            mimeMessage.setHeader("In-Reply-To", (String)object);
        }
        try {
            this.setFlags(answeredFlag, true);
        }
        catch (MessagingException messagingException) {}
        return mimeMessage;
    }

    private Address[] eliminateDuplicates(Vector vector, Address[] addressArray) {
        int n;
        if (addressArray == null) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < addressArray.length) {
            boolean bl = false;
            n = 0;
            while (n < vector.size()) {
                if (((InternetAddress)vector.elementAt(n)).equals(addressArray[n3])) {
                    bl = true;
                    ++n2;
                    addressArray[n3] = null;
                    break;
                }
                ++n;
            }
            if (!bl) {
                vector.addElement(addressArray[n3]);
            }
            ++n3;
        }
        if (n2 != 0) {
            Address[] addressArray2 = addressArray instanceof InternetAddress[] ? new InternetAddress[addressArray.length - n2] : new Address[addressArray.length - n2];
            n = 0;
            int n4 = 0;
            while (n < addressArray.length) {
                if (addressArray[n] != null) {
                    addressArray2[n4++] = addressArray[n];
                }
                ++n;
            }
            addressArray = addressArray2;
        }
        return addressArray;
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        this.writeTo(outputStream, null);
    }

    public void writeTo(OutputStream outputStream, String[] stringArray) throws IOException, MessagingException {
        if (!this.saved) {
            this.saveChanges();
        }
        if (this.modified) {
            MimeBodyPart.writeTo(this, outputStream, stringArray);
            return;
        }
        Enumeration enumeration = this.getNonMatchingHeaderLines(stringArray);
        LineOutputStream lineOutputStream = new LineOutputStream(outputStream);
        while (enumeration.hasMoreElements()) {
            lineOutputStream.writeln((String)enumeration.nextElement());
        }
        lineOutputStream.writeln();
        if (this.content == null) {
            int n;
            InputStream inputStream = this.getContentStream();
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
            inputStream.close();
            byArray = null;
        } else {
            outputStream.write(this.content);
        }
        outputStream.flush();
    }

    public String[] getHeader(String string) throws MessagingException {
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) throws MessagingException {
        return this.headers.getHeader(string, string2);
    }

    public void setHeader(String string, String string2) throws MessagingException {
        this.headers.setHeader(string, string2);
    }

    public void addHeader(String string, String string2) throws MessagingException {
        this.headers.addHeader(string, string2);
    }

    public void removeHeader(String string) throws MessagingException {
        this.headers.removeHeader(string);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        return this.headers.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        return this.headers.getNonMatchingHeaders(stringArray);
    }

    public void addHeaderLine(String string) throws MessagingException {
        this.headers.addHeaderLine(string);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        return this.headers.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(stringArray);
    }

    public synchronized Flags getFlags() throws MessagingException {
        return (Flags)this.flags.clone();
    }

    public synchronized boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.flags.contains(flag);
    }

    public synchronized void setFlags(Flags flags, boolean bl) throws MessagingException {
        if (bl) {
            this.flags.add(flags);
            return;
        }
        this.flags.remove(flags);
    }

    public void saveChanges() throws MessagingException {
        this.modified = true;
        this.saved = true;
        this.updateHeaders();
    }

    protected void updateHeaders() throws MessagingException {
        MimeBodyPart.updateHeaders(this);
        this.setHeader("MIME-Version", "1.0");
        this.setHeader("Message-ID", "<" + UniqueValue.getUniqueMessageIDValue(this.session) + ">");
    }

    protected InternetHeaders createInternetHeaders(InputStream inputStream) throws MessagingException {
        return new InternetHeaders(inputStream);
    }

    public static class RecipientType
    extends Message.RecipientType {
        private static final long serialVersionUID = -5468290701714395543L;
        public static final RecipientType NEWSGROUPS = new RecipientType("Newsgroups");

        protected RecipientType(String string) {
            super(string);
        }

        protected Object readResolve() throws ObjectStreamException {
            if (this.type.equals("Newsgroups")) {
                return NEWSGROUPS;
            }
            return super.readResolve();
        }
    }
}

