/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.xml.jaxp.JXUtil;
import oracle.xml.parser.v2.NSName;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.util.XMLUtil;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;

public class XSLOutput
extends XSLNode
implements XSLConstants {
    String method;
    String version;
    String encoding;
    boolean bom;
    boolean setbommanually = false;
    String standalone;
    String mediaType;
    int indent;
    int omitXMLDecl;
    boolean ignoreOmitXMLDecl;
    String doctypePublic;
    String doctypeSystem;
    Hashtable cdataSectionElements;
    boolean isChMapped = false;
    HashMap mappings;
    Vector calledCharacterMaps;
    NSName name2;
    boolean ict = true;
    boolean eua = true;
    String normunicode10gr1 = "no";
    String normunicode = NONE;
    static String NFC = "NFC";
    static String NFD = "NFD";
    static String NKFC = "NKFC";
    static String NKFD = "NKFD";
    static String FULLY_NORMALIZED = "fully-normalized";
    static String NONE = "none";
    public static final int INONE = 65536;
    public static final int IFULLY_NORMALIZED = 65537;
    static final String INCLUDE_CONTENT_TYPE = "include-content-type";
    static final String ESCAPE_URI_ATTRIBUTES = "escape-uri-attributes";
    static final String NORMALIZATION_FORM = "normalization-form";
    static final String NORMALIZE_UNICODE = "normalize-unicode";
    static final String BYTE_ORDER_MARK = "byte-order-mark";
    String oraHref;
    String oraName;
    boolean oraOmitXMLEncoding;
    Hashtable outProps;
    static final String HTML = "html";
    static final String XML = "xml";
    static final String TEXT = "text";
    static final String XHTML = "xhtml";
    static final String YES = "yes";
    static final String NO = "no";
    static final String OMIT = "omit";
    static final String ORAHREF = "href";
    static final String OMIT_XML_ENCODING = "omit-xml-encoding";
    Properties m_props;
    Properties m_defaultProps;

    public XSLOutput(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 3;
        this.initialize();
    }

    void initialize() {
        this.method = "";
        this.version = "";
        this.encoding = "";
        this.bom = false;
        this.setbommanually = false;
        this.standalone = "";
        this.mediaType = "";
        this.doctypePublic = "";
        this.doctypeSystem = "";
        this.outProps = new Hashtable(20);
        this.omitXMLDecl = -1;
        this.ignoreOmitXMLDecl = false;
        this.indent = -1;
        this.name2 = null;
        this.ict = true;
        this.eua = true;
        this.normunicode = NONE;
        this.normunicode10gr1 = NO;
        this.oraName = "";
        this.oraOmitXMLEncoding = false;
        this.m_defaultProps = new Properties();
        this.m_props = new Properties(this.m_defaultProps);
        JXUtil.setDefaultProps(this.m_defaultProps, XML);
    }

    boolean isCDATASectionElement() {
        return this.cdataSectionElements != null;
    }

    boolean checkCDATASectionElement(String string) {
        if (this.cdataSectionElements == null) {
            return false;
        }
        return this.cdataSectionElements.get(string) != null;
    }

    String getOraHref() {
        return this.oraHref;
    }

    void setOraHref(String string) {
        this.oraHref = string;
    }

    boolean getOraOmitXMLEncoding() {
        return this.oraOmitXMLEncoding;
    }

    void setOraOmitXMLEncoding(boolean bl) {
        this.oraOmitXMLEncoding = bl;
    }

    NSName getName2() {
        return this.name2;
    }

    String getName() {
        return this.oraName;
    }

    void setName(String string) {
        this.oraName = string;
    }

    String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    Hashtable getCdataSectionElements() {
        return this.cdataSectionElements;
    }

    void setCdataSectionElements(Hashtable hashtable) {
        this.cdataSectionElements = hashtable;
    }

    String getVersion() {
        if (this.version == "") {
            if (this.method == HTML) {
                this.version = "4.0";
            } else if (this.method != "") {
                this.version = "1.0";
            } else {
                return "1.0";
            }
        }
        return this.version;
    }

    void setVersion(String string) {
        this.version = string != null ? string.intern() : "";
    }

    boolean isEncodingSpecified() {
        return this.encoding != "";
    }

    String getEncoding() {
        if (this.encoding == "") {
            return "UTF-8";
        }
        return this.encoding;
    }

    void setEncoding(String string) {
        this.encoding = string != null ? string.intern() : "";
        this.setDefaultBOM();
    }

    void setBOM(boolean bl) {
        this.bom = bl;
        this.setbommanually = true;
    }

    boolean getBOM() {
        return this.bom;
    }

    private void setDefaultBOM() {
        if (this.encoding.equalsIgnoreCase("UTF-16") && this.xss.getXSLTVersion() >= 20 && !this.setbommanually) {
            this.bom = true;
        }
    }

    String getStandalone() {
        if (this.standalone.equals(OMIT)) {
            this.standalone = "";
        }
        return this.standalone;
    }

    void setStandalone(String string) {
        this.standalone = string != null ? string.intern() : "";
    }

    boolean getOmitXMLDecl() {
        if (this.omitXMLDecl == -1) {
            this.omitXMLDecl = this.method == XML || this.method == "" ? 0 : 1;
        }
        return this.omitXMLDecl == 1;
    }

    void setOmitXMLDecl(boolean bl) {
        this.omitXMLDecl = bl ? 1 : 0;
    }

    String getDoctypePublic() {
        return this.doctypePublic;
    }

    void setDoctypePublic(String string) {
        this.doctypePublic = string != null ? string.intern() : "";
    }

    String getDoctypeSystem() {
        return this.doctypeSystem;
    }

    void setDoctypeSystem(String string) {
        this.doctypeSystem = string != null ? string.intern() : "";
    }

    boolean getIndent() {
        if (this.indent == -1) {
            if (this.method == XML || this.method == "") {
                this.indent = 0;
            } else if (this.method == HTML) {
                this.indent = 1;
            }
        }
        return this.indent == 1;
    }

    void setIndent(boolean bl) {
        this.indent = bl ? 1 : 0;
    }

    String getMediaType() {
        if (this.mediaType == "") {
            if (this.method == HTML) {
                this.mediaType = "text/html";
            } else if (this.method == TEXT) {
                this.mediaType = "text/plain";
            } else if (this.method == XHTML) {
                this.mediaType = "text/html";
            } else if (this.method != "") {
                this.mediaType = "text/xml";
            } else {
                return "text/xml";
            }
        }
        return this.mediaType;
    }

    void setMediaType(String string) {
        this.mediaType = string != null ? string.intern() : "";
    }

    boolean getIncludeContentType() {
        return this.ict;
    }

    void setIncludeContentType(boolean bl) {
        this.ict = bl;
    }

    boolean getEscapeURIAttributes() {
        return this.eua;
    }

    void setEscapeURIAttributes(boolean bl) {
        this.eua = bl;
    }

    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && string == "") {
            this.outProps.put(string3, string4);
        } else {
            super.setAttribute(string, string2, string3, string4);
        }
    }

    public String getAttribute(String string, String string2) throws XSLException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java" && string == "") {
            return (String)this.outProps.get(string2);
        }
        return super.getAttribute(string, string2);
    }

    public void startContent() throws XSLException {
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java") {
            if (this.getAttribute("", "name") == null) {
                this.xss.err.error2(1009, 1, "name", this.getQualifiedName());
            }
            if (this.getAttribute("", ORAHREF) == null) {
                this.xss.err.error2(1009, 2, ORAHREF, this.getQualifiedName());
            }
        }
    }

    void merge(XSLOutput xSLOutput) throws XSLException {
        String string = xSLOutput.getAttribute("", "name");
        if (string != null) {
            this.name2 = this.resolveQname(string);
        }
        if ((string = xSLOutput.getAttribute("", "method")) != null) {
            this.method = string.intern();
            this.m_props.put("method", this.method);
            JXUtil.setDefaultProps(this.m_defaultProps, this.method);
        }
        if ((string = xSLOutput.getAttribute("", "version")) != null) {
            this.version = string;
            this.m_props.put("version", this.version);
        }
        if ((string = xSLOutput.getAttribute("", "encoding")) != null) {
            this.encoding = string;
            if (!(this.xss.getXSLTVersion() < 20 || this.encoding.equalsIgnoreCase("UTF-8") || this.encoding.equalsIgnoreCase("UTF-16") || this.ignoreOmitXMLDecl)) {
                this.omitXMLDecl = 0;
                this.ignoreOmitXMLDecl = true;
            }
            this.setDefaultBOM();
            this.m_props.put("encoding", this.encoding);
        }
        if ((string = xSLOutput.getAttribute("", BYTE_ORDER_MARK)) != null) {
            this.bom = XMLUtil.checkYesNo(string, this.xss.err);
            this.setbommanually = true;
        }
        if ((string = xSLOutput.getAttribute("", "standalone")) != null) {
            this.standalone = string;
            if (this.xss.getXSLTVersion() >= 20 && !this.ignoreOmitXMLDecl) {
                this.omitXMLDecl = 0;
                this.ignoreOmitXMLDecl = true;
            }
            this.m_props.put("standalone", this.standalone);
        }
        if ((string = xSLOutput.getAttribute("", "media-type")) != null) {
            this.mediaType = string;
            this.m_props.put("media-type", this.mediaType);
        }
        if ((string = xSLOutput.getAttribute("", "doctype-public")) != null) {
            this.doctypePublic = string;
            this.m_props.put("doctype-public", this.doctypePublic);
        }
        if ((string = xSLOutput.getAttribute("", "doctype-system")) != null) {
            this.doctypeSystem = string;
            this.m_props.put("doctype-system", this.doctypeSystem);
        }
        if (this.namespace == "http://www.oracle.com/XSL/Transform/java") {
            this.oraHref = xSLOutput.getAttribute("", ORAHREF);
            this.oraName = xSLOutput.getAttribute("", "name");
            if (this.oraName == null) {
                this.oraName = "";
            }
        }
        if ((string = xSLOutput.getAttribute("", "indent")) != null) {
            this.m_props.put("indent", string);
            if (string.equals(YES)) {
                this.indent = 1;
            } else if (string.equals(NO)) {
                this.indent = 0;
            }
        }
        if ((string = xSLOutput.getAttribute("", "omit-xml-declaration")) != null) {
            this.m_props.put("omit-xml-declaration", string);
            if (!this.ignoreOmitXMLDecl) {
                if (string.equals(YES)) {
                    this.omitXMLDecl = 1;
                } else if (string.equals(NO)) {
                    this.omitXMLDecl = 0;
                }
            }
        }
        if ((string = xSLOutput.getAttribute("", OMIT_XML_ENCODING)) != null) {
            this.m_props.put(OMIT_XML_ENCODING, string);
            if (string.equals(YES)) {
                this.oraOmitXMLEncoding = true;
            } else if (string.equals(NO)) {
                this.oraOmitXMLEncoding = false;
            }
        }
        if (this.xss.getXSLTVersion() == 10) {
            this.ict = true;
            this.normunicode = NONE;
            this.normunicode10gr1 = NO;
            this.eua = false;
        } else if (this.xss.getXSLTVersion() >= 20) {
            string = xSLOutput.getAttribute("", INCLUDE_CONTENT_TYPE);
            if (string != null && string.equals(NO)) {
                this.ict = false;
            }
            if ((string = xSLOutput.getAttribute("", NORMALIZATION_FORM)) != null) {
                this.normunicode = string;
            }
            if (XMLParser.getIs1010Compatible() && (string = xSLOutput.getAttribute("", NORMALIZE_UNICODE)) != null) {
                this.normunicode10gr1 = string;
            }
            if ((string = xSLOutput.getAttribute("", ESCAPE_URI_ATTRIBUTES)) != null && string.equals(NO)) {
                this.eua = false;
            }
            if ((string = xSLOutput.getAttribute("", "use-character-maps")) != null) {
                this.calledCharacterMaps = this.processUseCharacterMaps(string);
                this.makeCharacterMaps(this.calledCharacterMaps);
            }
        }
        String string2 = xSLOutput.getAttribute("", "cdata-section-elements");
        if (string2 != null) {
            this.m_props.put("cdata-section-elements", string2);
            this.cdataSectionElements = this.processCdataSectionElement(this.cdataSectionElements, xSLOutput, string2, true);
        }
    }

    Hashtable processCdataSectionElement(Hashtable hashtable, XSLOutput xSLOutput, String string, boolean bl) throws XSLException {
        int n = 0;
        int n2 = 0;
        do {
            String string2 = (n2 = string.indexOf(32, n)) == -1 ? string.substring(n, string.length()) : string.substring(n, n2);
            n = n2 + 1;
            String string3 = xSLOutput.resolveQname(string2).getExpandedName();
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>(20);
            }
            if (bl) {
                hashtable.put(string3, string3);
                continue;
            }
            Object v = hashtable.get(string3);
            if (v != null && v.toString().equals(string3)) continue;
            hashtable.put(string3, string3);
        } while (n2 != -1);
        return hashtable;
    }

    Vector calledUCM() {
        return this.calledCharacterMaps;
    }

    void makeCharacterMaps(Vector vector) throws XSLException {
        int n;
        this.xss.expandedCharacterMaps = null;
        for (n = 0; n < vector.size(); ++n) {
            this.xss.getCharacterMap((NSName)vector.get(n));
        }
        for (n = 0; n < vector.size(); ++n) {
            this.xss.expandedCharacterMaps.add(this.calledCharacterMaps.get(n));
        }
        Properties properties = this.xss.mergeCharacterMap();
        this.isChMapped = true;
        this.makeCharacterMap(properties);
    }

    Vector mergeCharacterMaps(Vector vector, Vector vector2) {
        int n = vector.size();
        vector.setSize(n + vector2.size());
        int n2 = 0;
        for (int i = 0; i < vector2.size(); ++i) {
            int n3;
            NSName nSName = (NSName)vector2.get(i);
            for (n3 = 0; n3 < n; ++n3) {
                NSName nSName2 = (NSName)vector.get(n3);
                if (nSName2 != nSName) continue;
                ++n2;
                break;
            }
            if (n3 != n) continue;
            vector.set(n + i - n2, nSName);
        }
        vector.setSize(n + vector2.size() - n2);
        return vector;
    }

    Vector processUseCharacterMaps(String string) throws XSLException {
        Vector<NSName> vector = new Vector<NSName>(5, 5);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            NSName nSName = this.resolveQname(string2);
            vector.add(nSName);
        }
        return vector;
    }

    private void makeCharacterMap(Properties properties) {
        int n = properties.size();
        char[] cArray = new char[n];
        String[] stringArray = new String[n];
        Enumeration<?> enumeration = properties.propertyNames();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            cArray[n2] = string.toCharArray()[0];
            stringArray[n2++] = (String)properties.get(string);
        }
        this.mappings = new HashMap(n);
        for (n2 = 0; n2 < n; ++n2) {
            this.mappings.put(new Character(cArray[n2]), stringArray[n2]);
        }
    }

    boolean isCharacterMapped() {
        return this.isChMapped;
    }

    HashMap getMappings() {
        return this.mappings;
    }

    int normalizationForm() {
        if (XMLParser.getIs1010Compatible() && this.normunicode10gr1.intern() == YES) {
            return 1;
        }
        if (this.normunicode.intern() == NFC.intern()) {
            return 1;
        }
        if (this.normunicode.intern() == NFD.intern()) {
            return 0;
        }
        if (this.normunicode.intern() == NKFC.intern()) {
            return 3;
        }
        if (this.normunicode.intern() == NKFD.intern()) {
            return 2;
        }
        if (this.normunicode.intern() == NONE.intern()) {
            return 65536;
        }
        if (this.normunicode.intern() == FULLY_NORMALIZED.intern()) {
            return 65537;
        }
        return -1;
    }

    void setNormalizationForm(String string) {
        this.normunicode = string != null ? string.intern() : NONE;
    }

    void printAttributes(PrintWriter printWriter) {
        super.printAttributes(printWriter);
        Hashtable hashtable = this.attrHash;
        this.attrHash = this.outProps;
        super.printAttributes(printWriter);
        this.attrHash = hashtable;
    }

    public Properties getDefaultProps() {
        return this.m_defaultProps;
    }

    public Properties getProps() {
        return this.m_props;
    }

    public void setProps(Properties properties) {
        this.m_props = properties;
        Enumeration<?> enumeration = this.m_props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = enumeration.nextElement().toString();
            if (string2.equals("method")) {
                this.method = this.m_props.getProperty("method");
                if (this.method != null) {
                    this.method = this.method.intern();
                    JXUtil.setDefaultProps(this.m_defaultProps, this.method);
                    continue;
                }
                this.method = "";
                continue;
            }
            if (string2.equals("version")) {
                this.version = this.m_props.getProperty("version");
                if (this.version != null) {
                    this.version = this.version.intern();
                    continue;
                }
                this.version = "";
                continue;
            }
            if (string2.equals("encoding")) {
                this.encoding = (String)this.m_props.get("encoding");
                this.encoding = this.encoding != null ? this.encoding.intern() : "";
                if (!(this.xss.getXSLTVersion() < 20 || this.encoding.equalsIgnoreCase("UTF-8") || this.encoding.equalsIgnoreCase("UTF-16") || this.ignoreOmitXMLDecl)) {
                    this.omitXMLDecl = 0;
                    this.ignoreOmitXMLDecl = true;
                }
                this.setDefaultBOM();
                continue;
            }
            if (string2.equals(BYTE_ORDER_MARK)) {
                String string3 = this.m_props.getProperty(BYTE_ORDER_MARK);
                try {
                    this.bom = XMLUtil.checkYesNo(string3, this.xss.err);
                }
                catch (XSLException xSLException) {
                    this.xss.err.error2(1069, 1, YES, NO);
                }
                this.setbommanually = true;
                continue;
            }
            if (string2.equals("standalone")) {
                this.standalone = this.m_props.getProperty("standalone");
                if (this.standalone != null) {
                    this.standalone = this.standalone.intern();
                    if (this.xss.getXSLTVersion() < 20 || this.ignoreOmitXMLDecl) continue;
                    this.omitXMLDecl = 0;
                    this.ignoreOmitXMLDecl = true;
                    continue;
                }
                this.standalone = "";
                continue;
            }
            if (string2.equals("media-type")) {
                this.mediaType = this.m_props.getProperty("media-type");
                if (this.mediaType != null) {
                    this.mediaType = this.mediaType.intern();
                    continue;
                }
                this.mediaType = "";
                continue;
            }
            if (string2.equals("doctype-public")) {
                this.doctypePublic = this.m_props.getProperty("doctype-public");
                if (this.doctypePublic != null) {
                    this.doctypePublic = this.doctypePublic.intern();
                    continue;
                }
                this.doctypePublic = "";
                continue;
            }
            if (string2.equals("doctype-system")) {
                this.doctypeSystem = this.m_props.getProperty("doctype-system");
                if (this.doctypeSystem != null) {
                    this.doctypeSystem = this.doctypeSystem.intern();
                    continue;
                }
                this.doctypeSystem = "";
                continue;
            }
            if (string2.equals("indent")) {
                string = this.m_props.getProperty("indent");
                if (string == null) continue;
                if ((string = string.intern()) == YES) {
                    this.indent = 1;
                    continue;
                }
                if (string != NO) continue;
                this.indent = 0;
                continue;
            }
            if (string2.equals("omit-xml-declaration")) {
                string = this.m_props.getProperty("omit-xml-declaration");
                if (string == null) continue;
                string = string.intern();
                if (this.ignoreOmitXMLDecl) continue;
                if (string == YES) {
                    this.omitXMLDecl = 1;
                    continue;
                }
                if (string != NO) continue;
                this.omitXMLDecl = 0;
                continue;
            }
            if (string2.equals(NORMALIZATION_FORM)) {
                string = this.m_props.getProperty(NORMALIZATION_FORM);
                if (string != null) {
                    this.normunicode = string.intern();
                    continue;
                }
                this.normunicode = NONE;
                continue;
            }
            if (XMLParser.getIs1010Compatible() && string2.equals(NORMALIZE_UNICODE)) {
                string = this.m_props.getProperty(NORMALIZE_UNICODE);
                if (string != null) {
                    this.normunicode10gr1 = string.intern();
                    continue;
                }
                this.normunicode10gr1 = NO;
                continue;
            }
            if (!string2.equals("cdata-section-elements")) continue;
            string = this.m_props.getProperty("cdata-section-elements");
            try {
                if (string == null) continue;
                this.cdataSectionElements = this.processCdataSectionElement(this.cdataSectionElements, this, string, false);
            }
            catch (XSLException xSLException) {}
        }
    }
}

