/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.util.Hashtable;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.DefaultXMLDocumentHandler;
import oracle.xml.parser.v2.NonValidatingParser;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLDocumentHandler;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.parser.v2.XMLUtil;
import oracle.xml.util.NSNameImpl;
import org.xml.sax.Attributes;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLContentHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler {
    NSNameImpl nsName;
    SAXAttrList saxAttrList;
    DocumentHandler docHandler;
    XMLDocumentHandler xmlHandler;
    boolean isXMLHandler;
    int cDATASectionDepth;
    XMLParser xmlParser;
    Hashtable externalEntities;

    public XMLContentHandler() {
        this(new DefaultXMLDocumentHandler());
    }

    public XMLContentHandler(DocumentHandler documentHandler) {
        this.docHandler = documentHandler;
        if (documentHandler instanceof XMLDocumentHandler) {
            this.xmlHandler = (XMLDocumentHandler)documentHandler;
            this.isXMLHandler = true;
            this.nsName = new NSNameImpl();
        }
        this.saxAttrList = new SAXAttrList(4);
    }

    public void setDocumentLocator(Locator locator) {
        this.docHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        if (this.isXMLHandler && this.xmlParser != null) {
            NonValidatingParser nonValidatingParser = this.xmlParser.parser;
            if (nonValidatingParser.reader.xmlDecl) {
                this.xmlHandler.setXMLDecl(nonValidatingParser.reader.xmlDeclVersion, nonValidatingParser.reader.xmlDeclStandalone, nonValidatingParser.reader.xmlDeclEncoding);
            }
        }
        this.docHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        this.docHandler.endDocument();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        SAXAttrList sAXAttrList = XMLContentHandler.createSAXAttrList(attributes, this.saxAttrList);
        if (this.isXMLHandler) {
            this.nsName.setNamespace(string);
            this.nsName.setLocalName(string2);
            this.nsName.setQualifiedName(string3);
            this.nsName.setPrefix(XMLUtil.getPrefix(string3));
            this.xmlHandler.startElement(this.nsName, sAXAttrList);
        } else {
            this.docHandler.startElement(string3, sAXAttrList);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.isXMLHandler) {
            this.nsName.setNamespace(string);
            this.nsName.setLocalName(string2);
            this.nsName.setQualifiedName(string3);
            this.nsName.setPrefix(XMLUtil.getPrefix(string3));
            this.xmlHandler.endElement(this.nsName);
        } else {
            this.docHandler.endElement(string3);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.isXMLHandler && this.cDATASectionDepth > 0) {
            this.xmlHandler.cDATASection(cArray, n, n2);
        } else {
            this.docHandler.characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.docHandler.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.docHandler.processingInstruction(string, string2);
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        if (this.isXMLHandler && this.xmlParser != null) {
            DTD dTD = this.xmlParser.parser.dtd;
            if (this.xmlParser.parser.fixedDTD) {
                dTD = !this.xmlParser.useDTDForValidation ? (DTD)dTD.xdkCopyNode(null, 5) : new DTD();
            }
            dTD.setRootTag(string);
            dTD.xdkSetSystemId(string3);
            dTD.xdkSetPublicId(string2);
            this.xmlHandler.setDoctype(dTD);
        }
    }

    public void endDTD() throws SAXException {
        if (this.isXMLHandler && this.xmlParser != null) {
            this.xmlHandler.endDoctype();
        }
    }

    public void startEntity(String string) throws SAXException {
        if (this.isXMLHandler && this.externalEntities != null && this.externalEntities.get(string) != null && this.xmlParser != null) {
            NonValidatingParser nonValidatingParser = this.xmlParser.parser;
            if (nonValidatingParser.reader.xmlDecl) {
                this.xmlHandler.setTextDecl(nonValidatingParser.reader.xmlDeclVersion, nonValidatingParser.reader.xmlDeclEncoding);
            }
        }
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        ++this.cDATASectionDepth;
    }

    public void endCDATA() throws SAXException {
        --this.cDATASectionDepth;
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.isXMLHandler) {
            this.xmlHandler.comment(new String(cArray, n, n2));
        }
    }

    public void elementDecl(String string, String string2) throws SAXException {
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        if (this.externalEntities == null) {
            this.externalEntities = new Hashtable(5);
        }
        this.externalEntities.put(string, string);
    }

    public void setProperty(String string, Object object) {
    }

    public static SAXAttrList createSAXAttrList(Attributes attributes, SAXAttrList sAXAttrList) {
        if (attributes instanceof SAXAttrList) {
            return (SAXAttrList)attributes;
        }
        int n = attributes.getLength();
        sAXAttrList.reset();
        for (int i = 0; i < n; ++i) {
            String string = attributes.getQName(i);
            String string2 = XMLUtil.getPrefix(string);
            sAXAttrList.addAttr(string2, attributes.getLocalName(i), string, attributes.getValue(i), true, XMLContentHandler.typeToInt(attributes.getType(i)), attributes.getURI(i));
        }
        return sAXAttrList;
    }

    static int typeToInt(String string) {
        if ((string = string.intern()) == "ID") {
            return 1;
        }
        if (string == "IDREF") {
            return 2;
        }
        if (string == "IDREFS") {
            return 3;
        }
        if (string == "ENTITY") {
            return 4;
        }
        if (string == "ENTITIES") {
            return 5;
        }
        if (string == "NMTOKEN") {
            return 6;
        }
        if (string == "NMTOKENS") {
            return 7;
        }
        if (string == "NOTATION") {
            return 8;
        }
        if (string == "CDATA") {
            return 0;
        }
        return -1;
    }
}

