/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.jdwp.XSLDebugProp;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPPacketValue;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLTContext;
import org.w3c.dom.NodeList;

public class XSLJDWPUtil
implements XSLJDWPConstants {
    public static XSLJDWPPacketValue convertXPathSequence2PacketValue(OXMLSequence oXMLSequence) {
        try {
            String string = XPathSequence.getTypeString(oXMLSequence).intern();
            byte by = 0;
            if (string == "boolean") {
                boolean bl;
                by = 90;
                try {
                    bl = XPathSequence.getBooleanValue(oXMLSequence);
                }
                catch (XQException xQException) {
                    bl = false;
                }
                return new XSLJDWPPacketValue(by, new Boolean(bl));
            }
            if (string == "number") {
                double d;
                by = 68;
                try {
                    d = XPathSequence.getNumberValue(oXMLSequence);
                }
                catch (XQException xQException) {
                    d = 0.0;
                }
                return new XSLJDWPPacketValue(by, new Double(d));
            }
            if (string == "string") {
                String string2;
                by = 76;
                try {
                    string2 = XPathSequence.getStringValue(oXMLSequence);
                }
                catch (XQException xQException) {
                    string2 = null;
                }
                return new XSLJDWPPacketValue(by, string2);
            }
            if (string == "node-set") {
                by = 91;
                NodeList nodeList = XPathSequence.getNodeList(oXMLSequence);
                return new XSLJDWPPacketValue(by, nodeList);
            }
            if (string == "result tree fragment") {
                by = 76;
                XMLDocumentFragment xMLDocumentFragment = XPathSequence.getResultTreeValue(oXMLSequence);
                return new XSLJDWPPacketValue(by, xMLDocumentFragment);
            }
        }
        catch (NullPointerException nullPointerException) {
            return new XSLJDWPPacketValue(76, "out of scope");
        }
        catch (XQException xQException) {
            return new XSLJDWPPacketValue(76, "out of scope");
        }
        return null;
    }

    public static String getJNISignature(OXMLSequence oXMLSequence) {
        String string = null;
        try {
            string = XPathSequence.getTypeString(oXMLSequence).intern();
        }
        catch (XQException xQException) {
            // empty catch block
        }
        String string2 = "s";
        if (string == "boolean") {
            string2 = "Z";
        } else if (string == "number") {
            string2 = "D";
        } else if (string == "string") {
            string2 = "L$oracle/xml/xslt/XMLString;";
        } else if (string == "node-set") {
            string2 = "[L$oracle/xml/xslt/XMLNode;";
        } else if (string == "result tree fragment") {
            string2 = "L$oracle/xml/xslt/XMLNode;";
        }
        return string2;
    }

    public static String getClassSignature(URL uRL) {
        String string = XSLJDWPUtil.getClassName(uRL);
        return "L$oracle/xml/xslt/" + string + ";";
    }

    public static String getClassSignature(String string) {
        if (string.compareTo("XMLNode[]") == 0) {
            return "[L$oracle/xml/xslt/XMLNode;";
        }
        if (string.compareTo("char[]") == 0) {
            return "[C";
        }
        return "L$oracle/xml/xslt/" + string + ";";
    }

    public static String getClassName(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '_') {
                stringBuffer.append("__");
                continue;
            }
            if (string.charAt(i) == '\\') {
                stringBuffer.append("_A");
                continue;
            }
            if (string.charAt(i) == '/') {
                stringBuffer.append("_A");
                continue;
            }
            if (string.charAt(i) == '.') {
                stringBuffer.append("_B");
                continue;
            }
            if (string.charAt(i) == '-') {
                stringBuffer.append("_C");
                continue;
            }
            if (string.charAt(i) == ' ') {
                stringBuffer.append("_D");
                continue;
            }
            if (string.charAt(i) == ':') {
                stringBuffer.append("_E");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static String getClassName(URL uRL) {
        String string = uRL.getFile();
        return XSLJDWPUtil.getClassName(string);
    }

    public static String convertMethodName(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '_') {
                stringBuffer.append("__");
                continue;
            }
            if (string.charAt(i) == '\\') {
                stringBuffer.append("_A");
                continue;
            }
            if (string.charAt(i) == '/') {
                stringBuffer.append("_A");
                continue;
            }
            if (string.charAt(i) == '.') {
                stringBuffer.append("_B");
                continue;
            }
            if (string.charAt(i) == '-') {
                stringBuffer.append("_C");
                continue;
            }
            if (string.charAt(i) == ':') {
                stringBuffer.append("_D");
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static Hashtable[] ensureHashtableSize(Hashtable[] hashtableArray, int n) {
        int n2 = hashtableArray.length;
        if (n > n2) {
            Hashtable[] hashtableArray2 = new Hashtable[n2 * 2];
            System.arraycopy(hashtableArray, 0, hashtableArray2, 0, n2);
            return hashtableArray2;
        }
        return hashtableArray;
    }

    public static Integer pos(Integer n, Vector vector) {
        int n2 = vector.indexOf(n);
        return new Integer(n2);
    }

    public static OXMLSequence toOXMLSequence(String string, XSLTContext xSLTContext) {
        XPathSequence xPathSequence = new XPathSequence(xSLTContext);
        XPathSequence.setStringValue(xPathSequence, string);
        return xPathSequence;
    }

    public static String toString(Object object) {
        if (object instanceof OXMLSequence) {
            return XPathSequence.getStringValue((OXMLSequence)object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static void printTrace(String string) {
        XSLDebugProp xSLDebugProp = new XSLDebugProp();
        if (xSLDebugProp.debug() && xSLDebugProp.getTrace()) {
            System.err.println(string);
        }
    }

    public static void printTrace(XSLDebugProp xSLDebugProp, String string) {
        if (xSLDebugProp.getTrace()) {
            System.err.println(string);
        }
    }

    public static void printForTest(String string) {
        XSLDebugProp xSLDebugProp = new XSLDebugProp();
        if (xSLDebugProp.debug() && xSLDebugProp.getTest()) {
            System.out.println(string);
        }
    }

    public static void printForTest(XSLDebugProp xSLDebugProp, String string) {
        if (xSLDebugProp.getTest()) {
            System.out.println(string);
        }
    }
}

