/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.FlexContext;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.TypeMarshaller;
import flex.messaging.io.amf.ASObject;
import flex.messaging.io.amf.translator.ASTranslator;
import java.util.IdentityHashMap;
import java.util.Map;

public class TypeMarshallingContext {
    private static ThreadLocal contexts = new ThreadLocal();
    private static ThreadLocal marshallers = new ThreadLocal();
    private IdentityHashMap knownObjects;
    private ClassLoader classLoader;

    public static void setTypeMarshallingContext(TypeMarshallingContext context) {
        if (context == null) {
            contexts.remove();
        } else {
            contexts.set(context);
        }
    }

    public static TypeMarshallingContext getTypeMarshallingContext() {
        TypeMarshallingContext context = (TypeMarshallingContext)contexts.get();
        if (context == null) {
            context = new TypeMarshallingContext();
            TypeMarshallingContext.setTypeMarshallingContext(context);
        }
        return context;
    }

    public static void setTypeMarshaller(TypeMarshaller marshaller) {
        if (marshaller == null) {
            marshallers.remove();
        } else {
            marshallers.set(marshaller);
        }
    }

    public static TypeMarshaller getTypeMarshaller() {
        TypeMarshaller marshaller = (TypeMarshaller)marshallers.get();
        if (marshaller == null) {
            marshaller = new ASTranslator();
            TypeMarshallingContext.setTypeMarshaller(marshaller);
        }
        return marshaller;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return FlexContext.getMessageBroker() == null ? null : FlexContext.getMessageBroker().getClassLoader();
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public IdentityHashMap getKnownObjects() {
        if (this.knownObjects == null) {
            this.knownObjects = new IdentityHashMap(64);
        }
        return this.knownObjects;
    }

    public void setKnownObjects(IdentityHashMap knownObjects) {
        this.knownObjects = knownObjects;
    }

    public void reset() {
        if (this.knownObjects != null) {
            this.knownObjects.clear();
        }
    }

    public static String getType(Object obj) {
        String type = null;
        if (obj != null && obj instanceof Map) {
            Object registerClass;
            Map map = (Map)obj;
            if (map instanceof ASObject) {
                ASObject aso = (ASObject)map;
                type = aso.getType();
            }
            SerializationContext sc = SerializationContext.getSerializationContext();
            if (type == null && sc.supportRemoteClass && (registerClass = map.get("_remoteClass")) != null && registerClass instanceof String) {
                type = (String)registerClass;
            }
        }
        return type;
    }

    public static void clearThreadLocalObjects() {
        contexts.remove();
        marshallers.remove();
    }

    public static void releaseThreadLocalObjects() {
        contexts = null;
        marshallers = null;
    }

    public static void createThreadLocalObjects() {
        if (contexts == null) {
            contexts = new ThreadLocal();
        }
        if (marshallers == null) {
            marshallers = new ThreadLocal();
        }
    }
}

