/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.datareaders;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BitInputStream;
import org.apache.sanselan.formats.tiff.TiffImageData;
import org.apache.sanselan.formats.tiff.datareaders.DataReader;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreter;

public final class DataReaderTiled
extends DataReader {
    private final int tileWidth;
    private final int tileLength;
    private final int bitsPerPixel;
    private final int width;
    private final int height;
    private final int compression;
    private final TiffImageData.Tiles imageData;

    public DataReaderTiled(PhotometricInterpreter photometricInterpreter, int tileWidth, int tileLength, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height, int compression, TiffImageData.Tiles imageData) {
        super(photometricInterpreter, bitsPerSample, predictor, samplesPerPixel);
        this.tileWidth = tileWidth;
        this.tileLength = tileLength;
        this.bitsPerPixel = bitsPerPixel;
        this.width = width;
        this.height = height;
        this.compression = compression;
        this.imageData = imageData;
    }

    private void interpretTile(BufferedImage bi, byte[] bytes, int startX, int startY) throws ImageReadException, IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BitInputStream bis = new BitInputStream(bais);
        int pixelsPerTile = this.tileWidth * this.tileLength;
        int tileX = 0;
        int tileY = 0;
        for (int i = 0; i < pixelsPerTile; ++i) {
            int x = tileX + startX;
            int y = tileY + startY;
            int[] samples = this.getSamplesAsBytes(bis);
            if (x < this.width && y < this.height) {
                samples = this.applyPredictor(samples, x);
                this.photometricInterpreter.interpretPixel(bi, samples, x, y);
            }
            if (++tileX < this.tileWidth) continue;
            tileX = 0;
            bis.flushCache();
            if (++tileY >= this.tileLength) break;
        }
    }

    public void readImageData(BufferedImage bi) throws ImageReadException, IOException {
        int bitsPerRow = this.tileWidth * this.bitsPerPixel;
        int bytesPerRow = (bitsPerRow + 7) / 8;
        int bytesPerTile = bytesPerRow * this.tileLength;
        int x = 0;
        int y = 0;
        for (int tile = 0; tile < this.imageData.tiles.length; ++tile) {
            byte[] compressed = this.imageData.tiles[tile].data;
            byte[] decompressed = this.decompress(compressed, this.compression, bytesPerTile);
            this.interpretTile(bi, decompressed, x, y);
            if ((x += this.tileWidth) < this.width) continue;
            x = 0;
            if ((y += this.tileLength) >= this.height) break;
        }
    }
}

