/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.sanselan.FormatCompliance;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.tiff.TiffContents;
import org.apache.sanselan.formats.tiff.TiffDirectory;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffImageData;
import org.apache.sanselan.formats.tiff.TiffImageMetadata;
import org.apache.sanselan.formats.tiff.TiffReader;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.formats.tiff.datareaders.DataReader;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreter;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterBiLevel;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterCIELAB;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterCMYK;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterLogLUV;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterPalette;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterRGB;
import org.apache.sanselan.formats.tiff.photometricinterpreters.PhotometricInterpreterYCbCr;
import org.apache.sanselan.formats.tiff.write.TiffImageWriterLossy;

public class TiffImageParser
extends ImageParser
implements TiffConstants {
    private static final String DEFAULT_EXTENSION = ".tif";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".tif", ".tiff"};

    public String getName() {
        return "Tiff-Custom";
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_TIFF};
    }

    public byte[] getICCProfileBytes(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readFirstDirectory(byteSource, params, false, formatCompliance);
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        TiffField field = directory.findField(EXIF_TAG_ICC_PROFILE);
        if (null == field) {
            return null;
        }
        return field.oversizeValue;
    }

    public Dimension getImageSize(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readFirstDirectory(byteSource, params, false, formatCompliance);
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        int width = directory.findField(TIFF_TAG_IMAGE_WIDTH).getIntValue();
        int height = directory.findField(TIFF_TAG_IMAGE_LENGTH).getIntValue();
        return new Dimension(width, height);
    }

    public byte[] embedICCProfile(byte[] image, byte[] profile) {
        return null;
    }

    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readContents(byteSource, params, formatCompliance);
        ArrayList directories = contents.directories;
        TiffImageMetadata result = new TiffImageMetadata(contents);
        for (int i = 0; i < directories.size(); ++i) {
            TiffDirectory dir = (TiffDirectory)directories.get(i);
            TiffImageMetadata.Directory metadataDirectory = new TiffImageMetadata.Directory(dir);
            ArrayList entries = dir.getDirectoryEntrys();
            for (int j = 0; j < entries.size(); ++j) {
                TiffField entry = (TiffField)entries.get(j);
                metadataDirectory.add(entry);
            }
            result.add(metadataDirectory);
        }
        return result;
    }

    public ImageInfo getImageInfo(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        String compressionAlgorithm;
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readDirectories(byteSource, false, formatCompliance);
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        TiffField widthField = directory.findField(TIFF_TAG_IMAGE_WIDTH, true);
        TiffField heightField = directory.findField(TIFF_TAG_IMAGE_LENGTH, true);
        if (widthField == null || heightField == null) {
            throw new ImageReadException("TIFF image missing size info.");
        }
        int height = heightField.getIntValue();
        int width = widthField.getIntValue();
        TiffField resolutionUnitField = directory.findField(TIFF_TAG_RESOLUTION_UNIT);
        int resolutionUnit = 2;
        if (resolutionUnitField != null && resolutionUnitField.getValue() != null) {
            resolutionUnit = resolutionUnitField.getIntValue();
        }
        double unitsPerInch = -1.0;
        switch (resolutionUnit) {
            case 1: {
                break;
            }
            case 2: {
                unitsPerInch = 1.0;
                break;
            }
            case 3: {
                unitsPerInch = 0.0254;
                break;
            }
        }
        TiffField xResolutionField = directory.findField(TIFF_TAG_XRESOLUTION);
        TiffField yResolutionField = directory.findField(TIFF_TAG_YRESOLUTION);
        int physicalWidthDpi = -1;
        float physicalWidthInch = -1.0f;
        int physicalHeightDpi = -1;
        float physicalHeightInch = -1.0f;
        if (unitsPerInch > 0.0) {
            if (xResolutionField != null && xResolutionField.getValue() != null) {
                double XResolutionPixelsPerUnit = xResolutionField.getDoubleValue();
                physicalWidthDpi = (int)(XResolutionPixelsPerUnit / unitsPerInch);
                physicalWidthInch = (float)((double)width / (XResolutionPixelsPerUnit * unitsPerInch));
            }
            if (yResolutionField != null && yResolutionField.getValue() != null) {
                double YResolutionPixelsPerUnit = yResolutionField.getDoubleValue();
                physicalHeightDpi = (int)(YResolutionPixelsPerUnit / unitsPerInch);
                physicalHeightInch = (float)((double)height / (YResolutionPixelsPerUnit * unitsPerInch));
            }
        }
        TiffField bitsPerSampleField = directory.findField(TIFF_TAG_BITS_PER_SAMPLE);
        int bitsPerSample = -1;
        if (bitsPerSampleField != null && bitsPerSampleField.getValue() != null) {
            bitsPerSample = bitsPerSampleField.getIntValueOrArraySum();
        }
        int bitsPerPixel = bitsPerSample;
        ArrayList<String> comments = new ArrayList<String>();
        ArrayList entries = directory.entries;
        for (int i = 0; i < entries.size(); ++i) {
            TiffField field = (TiffField)entries.get(i);
            String comment = field.toString();
            comments.add(comment);
        }
        ImageFormat format = ImageFormat.IMAGE_FORMAT_TIFF;
        String formatName = "TIFF Tag-based Image File Format";
        String mimeType = "image/tiff";
        int numberOfImages = contents.directories.size();
        boolean isProgressive = false;
        String formatDetails = "Tiff v." + contents.header.tiffVersion;
        boolean isTransparent = false;
        boolean usesPalette = false;
        TiffField colorMapField = directory.findField(TIFF_TAG_COLOR_MAP);
        if (colorMapField != null) {
            usesPalette = true;
        }
        int colorType = 2;
        int compression = directory.findField(TIFF_TAG_COMPRESSION).getIntValue();
        switch (compression) {
            case 1: {
                compressionAlgorithm = "None";
                break;
            }
            case 2: {
                compressionAlgorithm = "CCITT 1D";
                break;
            }
            case 3: {
                compressionAlgorithm = "CCITT Group 3 1-Dimensional Modified Huffman run-length encoding.";
                break;
            }
            case 4: {
                compressionAlgorithm = "CCITT Group 4";
                break;
            }
            case 5: {
                compressionAlgorithm = "LZW";
                break;
            }
            case 6: {
                compressionAlgorithm = "JPEG";
                break;
            }
            case 32771: {
                compressionAlgorithm = "None";
                break;
            }
            case 32773: {
                compressionAlgorithm = "PackBits";
                break;
            }
            default: {
                compressionAlgorithm = "Unknown";
            }
        }
        ImageInfo result = new ImageInfo(formatDetails, bitsPerPixel, comments, format, formatName, height, mimeType, numberOfImages, physicalHeightDpi, physicalHeightInch, physicalWidthDpi, physicalWidthInch, width, isProgressive, isTransparent, usesPalette, colorType, compressionAlgorithm);
        return result;
    }

    public String getXmpXml(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readDirectories(byteSource, false, formatCompliance);
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        TiffField xmpField = directory.findField(TIFF_TAG_XMP, false);
        if (xmpField == null) {
            return null;
        }
        byte[] bytes = xmpField.getByteArrayValue();
        try {
            String xml = new String(bytes, "utf-8");
            return xml;
        }
        catch (UnsupportedEncodingException e) {
            throw new ImageReadException("Invalid JPEG XMP Segment.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        try {
            pw.println("tiff.dumpImageFile");
            ImageInfo imageData = this.getImageInfo(byteSource);
            if (imageData == null) {
                boolean bl = false;
                return bl;
            }
            imageData.toString(pw, "");
            pw.println("");
            FormatCompliance formatCompliance = FormatCompliance.getDefault();
            Map params = null;
            TiffContents contents = new TiffReader(true).readContents(byteSource, params, formatCompliance);
            ArrayList directories = contents.directories;
            if (directories == null) {
                boolean bl = false;
                return bl;
            }
            for (int d = 0; d < directories.size(); ++d) {
                TiffDirectory directory = (TiffDirectory)directories.get(d);
                ArrayList entries = directory.entries;
                if (entries == null) {
                    boolean bl = false;
                    return bl;
                }
                for (int i = 0; i < entries.size(); ++i) {
                    TiffField field = (TiffField)entries.get(i);
                    field.dump(pw, d + "");
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            pw.println("");
        }
    }

    public FormatCompliance getFormatCompliance(ByteSource byteSource) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        Map params = null;
        new TiffReader(TiffImageParser.isStrict(params)).readContents(byteSource, params, formatCompliance);
        return formatCompliance;
    }

    public List collectRawImageData(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readDirectories(byteSource, true, formatCompliance);
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int i = 0; i < contents.directories.size(); ++i) {
            TiffDirectory directory = (TiffDirectory)contents.directories.get(i);
            ArrayList dataElements = directory.getTiffRawImageDataElements();
            for (int j = 0; j < dataElements.size(); ++j) {
                TiffDirectory.ImageDataElement element = (TiffDirectory.ImageDataElement)dataElements.get(j);
                byte[] bytes = byteSource.getBlock(element.offset, element.length);
                result.add(bytes);
            }
        }
        return result;
    }

    public BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        FormatCompliance formatCompliance = FormatCompliance.getDefault();
        TiffContents contents = new TiffReader(TiffImageParser.isStrict(params)).readFirstDirectory(byteSource, params, true, formatCompliance);
        TiffDirectory directory = (TiffDirectory)contents.directories.get(0);
        BufferedImage result = directory.getTiffImage(params);
        if (null == result) {
            throw new ImageReadException("TIFF does not contain an image.");
        }
        return result;
    }

    protected BufferedImage getBufferedImage(TiffDirectory directory, Map params) throws ImageReadException, IOException {
        ArrayList entries = directory.entries;
        if (entries == null) {
            throw new ImageReadException("TIFF missing entries");
        }
        int photometricInterpretation = directory.findField(TIFF_TAG_PHOTOMETRIC_INTERPRETATION, true).getIntValue();
        int compression = directory.findField(TIFF_TAG_COMPRESSION, true).getIntValue();
        int width = directory.findField(TIFF_TAG_IMAGE_WIDTH, true).getIntValue();
        int height = directory.findField(TIFF_TAG_IMAGE_LENGTH, true).getIntValue();
        int samplesPerPixel = directory.findField(TIFF_TAG_SAMPLES_PER_PIXEL, true).getIntValue();
        int[] bitsPerSample = directory.findField(TIFF_TAG_BITS_PER_SAMPLE, true).getIntArrayValue();
        int bitsPerPixel = directory.findField(TIFF_TAG_BITS_PER_SAMPLE, true).getIntValueOrArraySum();
        int predictor = -1;
        TiffField predictorField = directory.findField(TIFF_TAG_PREDICTOR);
        if (null != predictorField) {
            predictor = predictorField.getIntValueOrArraySum();
        }
        if (samplesPerPixel != bitsPerSample.length) {
            throw new ImageReadException("Tiff: samplesPerPixel (" + samplesPerPixel + ")!=fBitsPerSample.length (" + bitsPerSample.length + ")");
        }
        boolean hasAlpha = false;
        BufferedImage result = this.getBufferedImageFactory(params).getColorBufferedImage(width, height, hasAlpha);
        PhotometricInterpreter photometricInterpreter = this.getPhotometricInterpreter(directory, photometricInterpretation, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height);
        TiffImageData imageData = directory.getTiffImageData();
        DataReader dataReader = imageData.getDataReader(entries, photometricInterpreter, bitsPerPixel, bitsPerSample, predictor, samplesPerPixel, width, height, compression);
        dataReader.readImageData(result);
        photometricInterpreter.dumpstats();
        return result;
    }

    private PhotometricInterpreter getPhotometricInterpreter(TiffDirectory directory, int photometricInterpretation, int bitsPerPixel, int[] bitsPerSample, int predictor, int samplesPerPixel, int width, int height) throws IOException, ImageReadException {
        switch (photometricInterpretation) {
            case 0: 
            case 1: {
                boolean invert = photometricInterpretation == 0;
                return new PhotometricInterpreterBiLevel(bitsPerPixel, samplesPerPixel, bitsPerSample, predictor, width, height, invert);
            }
            case 3: {
                int[] colorMap = directory.findField(TIFF_TAG_COLOR_MAP, true).getIntArrayValue();
                int expected_colormap_size = 3 * (1 << bitsPerPixel);
                if (colorMap.length != expected_colormap_size) {
                    throw new ImageReadException("Tiff: fColorMap.length (" + colorMap.length + ")!=expected_colormap_size (" + expected_colormap_size + ")");
                }
                return new PhotometricInterpreterPalette(samplesPerPixel, bitsPerSample, predictor, width, height, colorMap);
            }
            case 2: {
                return new PhotometricInterpreterRGB(samplesPerPixel, bitsPerSample, predictor, width, height);
            }
            case 5: {
                return new PhotometricInterpreterCMYK(samplesPerPixel, bitsPerSample, predictor, width, height);
            }
            case 6: {
                double[] yCbCrCoefficients = directory.findField(TIFF_TAG_YCBCR_COEFFICIENTS, true).getDoubleArrayValue();
                int[] yCbCrPositioning = directory.findField(TIFF_TAG_YCBCR_POSITIONING, true).getIntArrayValue();
                int[] yCbCrSubSampling = directory.findField(TIFF_TAG_YCBCR_SUB_SAMPLING, true).getIntArrayValue();
                double[] referenceBlackWhite = directory.findField(TIFF_TAG_REFERENCE_BLACK_WHITE, true).getDoubleArrayValue();
                return new PhotometricInterpreterYCbCr(yCbCrCoefficients, yCbCrPositioning, yCbCrSubSampling, referenceBlackWhite, samplesPerPixel, bitsPerSample, predictor, width, height);
            }
            case 8: {
                return new PhotometricInterpreterCIELAB(samplesPerPixel, bitsPerSample, predictor, width, height);
            }
            case 32844: 
            case 32845: {
                boolean yonly = photometricInterpretation == 32844;
                return new PhotometricInterpreterLogLUV(samplesPerPixel, bitsPerSample, predictor, width, height, yonly);
            }
        }
        throw new ImageReadException("TIFF: Unknown fPhotometricInterpretation: " + photometricInterpretation);
    }

    public void writeImage(BufferedImage src, OutputStream os, Map params) throws ImageWriteException, IOException {
        new TiffImageWriterLossy().writeImage(src, os, params);
    }
}

