/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.cfx;

import com.allaire.cfx.Query;
import com.allaire.cfx.Response;
import java.util.Enumeration;
import java.util.Hashtable;
import railo.loader.engine.CFMLEngineFactory;
import railo.runtime.cfx.QueryWrap;

public final class DebugResponse
implements Response {
    private StringBuffer write = new StringBuffer();
    private StringBuffer writeDebug = new StringBuffer();
    private Hashtable variables = new Hashtable();
    private Hashtable queries = new Hashtable();

    @Override
    public Query addQuery(String name, String[] columns) {
        QueryWrap query = new QueryWrap(CFMLEngineFactory.getInstance().getCreationUtil().createQuery(columns, 0, name), name.toLowerCase());
        this.queries.put(name.toLowerCase(), query);
        return query;
    }

    @Override
    public void setVariable(String key, String value) {
        this.variables.put(key.toLowerCase(), value);
    }

    @Override
    public void write(String str) {
        this.write.append(str);
    }

    @Override
    public void writeDebug(String str) {
        this.writeDebug.append(str);
    }

    public void printResults() {
        System.out.println("[ --- Railo Debug Response --- ]");
        System.out.println();
        System.out.println("----------------------------");
        System.out.println("|          Output          |");
        System.out.println("----------------------------");
        System.out.println(this.write);
        System.out.println();
        System.out.println("----------------------------");
        System.out.println("|       Debug Output       |");
        System.out.println("----------------------------");
        System.out.println(this.writeDebug);
        System.out.println();
        System.out.println("----------------------------");
        System.out.println("|        Variables         |");
        System.out.println("----------------------------");
        Enumeration e = this.variables.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            System.out.println("[Variable:" + key + "]");
            System.out.println(this.escapeString(this.variables.get(key).toString()));
        }
        System.out.println();
        e = this.queries.keys();
        while (e.hasMoreElements()) {
            Query query = (Query)this.queries.get(e.nextElement());
            this.printQuery(query);
            System.out.println();
        }
    }

    public void printQuery(Query query) {
        if (query != null) {
            String[] cols = query.getColumns();
            int rows = query.getRowCount();
            System.out.println("[Query:" + query.getName() + "]");
            int i = 0;
            while (i < cols.length) {
                if (i > 0) {
                    System.out.print(", ");
                }
                System.out.print(cols[i]);
                ++i;
            }
            System.out.println();
            int row = 1;
            while (row <= rows) {
                int col = 1;
                while (col <= cols.length) {
                    if (col > 1) {
                        System.out.print(", ");
                    }
                    System.out.print(this.escapeString(query.getData(row, col)));
                    ++col;
                }
                System.out.println();
                ++row;
            }
        }
    }

    private String escapeString(String string) {
        int len = string.length();
        StringBuffer sb = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == '\n') {
                sb.append("\\n");
            } else if (c == '\t') {
                sb.append("\\t");
            } else if (c == '\\') {
                sb.append("\\\\");
            } else if (c == '\b') {
                sb.append("\\b");
            } else if (c == '\r') {
                sb.append("\\r");
            } else if (c == '\"') {
                sb.append("\\\"");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return "\"" + sb.toString() + "\"";
    }
}

