/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.sprites;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.PointerBuffer;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLContext;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLDeviceCapabilities;
import org.lwjgl.opencl.CLKernel;
import org.lwjgl.opencl.CLMem;
import org.lwjgl.opencl.CLObject;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.opencl.CLProgram;
import org.lwjgl.opencl.api.Filter;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Util;

public final class SpriteShootoutCL {
    private static final int SCREEN_WIDTH = 800;
    private static final int SCREEN_HEIGHT = 600;
    private static final int ANIMATION_TICKS = 60;
    private boolean run = true;
    private boolean render = true;
    private boolean colorMask = true;
    private boolean animate = true;
    private boolean smooth;
    private boolean vsync;
    private int ballSize = 42;
    private int ballCount = 100000;
    private SpriteRenderer renderer;
    private int texID;
    private int texBigID;
    private int texSmallID;
    private IntBuffer errorCode = BufferUtils.createIntBuffer((int)1);
    private CLDevice clDevice;
    private CLContext clContext;
    private CLCommandQueue queue;
    private CLProgram program;
    private CLKernel kernel;
    private CLMem clTransform;
    private PointerBuffer kernelGlobalWorkSize;

    private SpriteShootoutCL() {
    }

    public static void main(String[] args) {
        try {
            new SpriteShootoutCL().start();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() throws LWJGLException {
        try {
            this.initGL();
            this.initCL();
            this.renderer = new SpriteRendererDefault();
            this.updateBalls(this.ballCount);
            this.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.destroy();
        }
    }

    private void initCL() throws LWJGLException {
        CL.create();
        List platforms = CLPlatform.getPlatforms();
        if (platforms == null) {
            throw new RuntimeException("No OpenCL platforms found.");
        }
        Filter<CLDevice> glSharingFilter = new Filter<CLDevice>(){

            public boolean accept(CLDevice device) {
                CLDeviceCapabilities caps = CLCapabilities.getDeviceCapabilities((CLDevice)device);
                return caps.CL_KHR_gl_sharing;
            }
        };
        CLPlatform platform = null;
        List devices = null;
        for (CLPlatform p : platforms) {
            devices = p.getDevices(4, (Filter)glSharingFilter);
            if (devices == null) continue;
            platform = p;
            break;
        }
        if (devices == null) {
            throw new RuntimeException("No OpenCL GPU device found.");
        }
        this.clDevice = (CLDevice)devices.get(0);
        devices.clear();
        devices.add(this.clDevice);
        this.clContext = CLContext.create((CLPlatform)platform, (List)devices, (CLContextCallback)new CLContextCallback(){

            protected void handleMessage(String errinfo, ByteBuffer private_info) {
                System.out.println("[CONTEXT MESSAGE] " + errinfo);
            }
        }, (Drawable)Display.getDrawable(), (IntBuffer)this.errorCode);
        SpriteShootoutCL.checkCLError(this.errorCode);
        this.queue = CL10.clCreateCommandQueue((CLContext)this.clContext, (CLDevice)this.clDevice, (long)0L, (IntBuffer)this.errorCode);
        SpriteShootoutCL.checkCLError(this.errorCode);
    }

    private void initGL() throws LWJGLException {
        Display.setLocation((int)((Display.getDisplayMode().getWidth() - 800) / 2), (int)((Display.getDisplayMode().getHeight() - 600) / 2));
        Display.setDisplayMode((DisplayMode)new DisplayMode(800, 600));
        Display.setTitle((String)"Sprite Shootout - CL");
        Display.create();
        ContextCapabilities caps = GLContext.getCapabilities();
        if (!caps.OpenGL20) {
            throw new RuntimeException("OpenGL 2.0 is required for this demo.");
        }
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)800.0, (double)0.0, (double)600.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glViewport((int)0, (int)0, (int)800, (int)600);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        try {
            this.texSmallID = SpriteShootoutCL.createTexture("res/ball_sm.png");
            this.texBigID = SpriteShootoutCL.createTexture("res/ball.png");
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.texID = this.texBigID;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)771);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glColorMask((boolean)this.colorMask, (boolean)this.colorMask, (boolean)this.colorMask, (boolean)false);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        if (caps.GL_ARB_compatibility || !caps.OpenGL31) {
            GL11.glEnable((int)34913);
        }
        Util.checkGLError();
    }

    private static int createTexture(String path) throws IOException {
        BufferedImage img = ImageIO.read(SpriteShootoutCL.class.getClassLoader().getResource(path));
        int w = img.getWidth();
        int h = img.getHeight();
        ByteBuffer buffer = SpriteShootoutCL.readImage(img);
        int texID = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)texID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)w, (int)h, (int)0, (int)32993, (int)5121, (ByteBuffer)buffer);
        return texID;
    }

    private static ByteBuffer readImage(BufferedImage img) throws IOException {
        WritableRaster raster = img.getRaster();
        int bands = raster.getNumBands();
        int w = img.getWidth();
        int h = img.getHeight();
        int size = w * h * bands;
        byte[] pixels = new byte[size];
        raster.getDataElements(0, 0, w, h, pixels);
        ByteBuffer pbuffer = BufferUtils.createByteBuffer((int)size);
        if (bands == 4) {
            for (int i = 0; i < w * h * 4; i += 4) {
                float a = SpriteShootoutCL.unpackUByte01(pixels[i + 3]);
                pbuffer.put(SpriteShootoutCL.packUByte01(SpriteShootoutCL.unpackUByte01(pixels[i + 2]) * a));
                pbuffer.put(SpriteShootoutCL.packUByte01(SpriteShootoutCL.unpackUByte01(pixels[i + 1]) * a));
                pbuffer.put(SpriteShootoutCL.packUByte01(SpriteShootoutCL.unpackUByte01(pixels[i + 0]) * a));
                pbuffer.put(pixels[i + 3]);
            }
        } else if (bands == 3) {
            for (int i = 0; i < w * h * 3; i += 3) {
                pbuffer.put(pixels[i + 2]);
                pbuffer.put(pixels[i + 1]);
                pbuffer.put(pixels[i + 0]);
            }
        } else {
            pbuffer.put(pixels, 0, size);
        }
        pbuffer.flip();
        return pbuffer;
    }

    private static float unpackUByte01(byte x) {
        return (float)(x & 0xFF) / 255.0f;
    }

    private static byte packUByte01(float x) {
        return (byte)(x * 255.0f);
    }

    private void updateBalls(int count) {
        System.out.println("NUMBER OF BALLS: " + count);
        this.renderer.updateBalls(this.ballCount);
    }

    private void run() {
        long startTime = System.currentTimeMillis() + 5000L;
        long fps = 0L;
        long time = Sys.getTime();
        int ticksPerUpdate = (int)(Sys.getTimerResolution() / 60L);
        this.renderer.render(false, true, 0);
        while (this.run) {
            Display.processMessages();
            this.handleInput();
            GL11.glClear((int)16384);
            long currTime = Sys.getTime();
            int delta = (int)(currTime - time);
            if (this.smooth || delta >= ticksPerUpdate) {
                this.renderer.render(this.render, this.animate, delta);
                time = currTime;
            } else {
                this.renderer.render(this.render, false, 0);
            }
            Display.update((boolean)false);
            if (startTime > System.currentTimeMillis()) {
                ++fps;
                continue;
            }
            long timeUsed = 5000L + (startTime - System.currentTimeMillis());
            startTime = System.currentTimeMillis() + 5000L;
            System.out.println("FPS: " + (double)Math.round((double)fps / ((double)timeUsed / 1000.0) * 10.0) / 10.0 + ", Balls: " + this.ballCount);
            fps = 0L;
        }
    }

    private void handleInput() {
        if (Display.isCloseRequested()) {
            this.run = false;
        }
        while (Keyboard.next()) {
            if (Keyboard.getEventKeyState()) continue;
            switch (Keyboard.getEventKey()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    this.ballCount = 1 << Keyboard.getEventKey() - 2;
                    this.updateBalls(this.ballCount);
                    break;
                }
                case 74: 
                case 78: {
                    int mult = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? 1000 : (Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184) ? 100 : (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157) ? 10 : 1));
                    if (Keyboard.getEventKey() == 74) {
                        mult = -mult;
                    }
                    this.ballCount += mult * 100;
                    if (this.ballCount <= 0) {
                        this.ballCount = 1;
                    }
                    this.updateBalls(this.ballCount);
                    break;
                }
                case 1: {
                    this.run = false;
                    break;
                }
                case 30: {
                    this.animate = !this.animate;
                    System.out.println("Animation is now " + (this.animate ? "on" : "off") + ".");
                    break;
                }
                case 46: {
                    this.colorMask = !this.colorMask;
                    GL11.glColorMask((boolean)this.colorMask, (boolean)this.colorMask, (boolean)this.colorMask, (boolean)false);
                    System.out.println("Color mask is now " + (this.colorMask ? "on" : "off") + ".");
                    if (this.colorMask) {
                        GL11.glEnable((int)3042);
                        GL11.glEnable((int)3008);
                        break;
                    }
                    GL11.glDisable((int)3042);
                    GL11.glDisable((int)3008);
                    break;
                }
                case 19: {
                    this.render = !this.render;
                    System.out.println("Rendering is now " + (this.render ? "on" : "off") + ".");
                    break;
                }
                case 31: {
                    this.smooth = !this.smooth;
                    System.out.println("Smooth animation is now " + (this.smooth ? "on" : "off") + ".");
                    break;
                }
                case 20: {
                    if (this.texID == this.texBigID) {
                        this.texID = this.texSmallID;
                        this.ballSize = 16;
                    } else {
                        this.texID = this.texBigID;
                        this.ballSize = 42;
                    }
                    this.renderer.updateBallSize();
                    GL11.glBindTexture((int)3553, (int)this.texID);
                    System.out.println("Now using the " + (this.texID == this.texBigID ? "big" : "small") + " texture.");
                    break;
                }
                case 47: {
                    this.vsync = !this.vsync;
                    Display.setVSyncEnabled((boolean)this.vsync);
                    System.out.println("VSYNC is now " + (this.vsync ? "enabled" : "disabled") + ".");
                }
            }
        }
        while (Mouse.next()) {
        }
    }

    private static void checkCLError(IntBuffer buffer) {
        org.lwjgl.opencl.Util.checkCLError((int)buffer.get(0));
    }

    private void destroy() {
        if (this.clContext != null) {
            CL10.clReleaseContext((CLContext)this.clContext);
        }
        Display.destroy();
        System.exit(0);
    }

    private class SpriteRendererDefault
    extends SpriteRenderer {
        SpriteRendererDefault() {
            System.out.println("Shootout Implementation: OpenCL GPU animation");
            int vshID = GL20.glCreateShader((int)35633);
            GL20.glShaderSource((int)vshID, (CharSequence)"#version 150\nvoid main(void) {\n     gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\n}");
            GL20.glCompileShader((int)vshID);
            if (GL20.glGetShaderi((int)vshID, (int)35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog((int)vshID, (int)GL20.glGetShaderi((int)vshID, (int)35716)));
                throw new RuntimeException("Failed to compile vertex shader.");
            }
            this.createProgram(vshID);
            Util.checkGLError();
            this.createKernel("kernel void animate(\n        const int WIDTH,\n        const int HEIGHT,\n        const float radius,\n        const int delta,\n        global float4 *balls\n) {\n    unsigned int b = get_global_id(0);\n\n     float4 anim = balls[b];\n     anim.xy = anim.xy + anim.zw * delta;\n     float2 animC = clamp(anim.xy, (float2)radius, (float2)(WIDTH - radius, HEIGHT - radius));\n     if ( anim.x != animC.x ) anim.z = -anim.z;\n     if ( anim.y != animC.y ) anim.w = -anim.w;\n\n     balls[b] = (float4)(animC, anim.zw);\n}");
            this.updateBallSize();
        }

        public void updateBalls(int count) {
            super.updateBalls(count);
        }

        public void render(boolean render, boolean animate, int delta) {
            if (animate) {
                SpriteShootoutCL.this.kernel.setArg(3, delta);
                CL10GL.clEnqueueAcquireGLObjects((CLCommandQueue)SpriteShootoutCL.this.queue, (CLMem)SpriteShootoutCL.this.clTransform, null, null);
                CL10.clEnqueueNDRangeKernel((CLCommandQueue)SpriteShootoutCL.this.queue, (CLKernel)SpriteShootoutCL.this.kernel, (int)1, null, (PointerBuffer)SpriteShootoutCL.this.kernelGlobalWorkSize, null, null, null);
                CL10GL.clEnqueueReleaseGLObjects((CLCommandQueue)SpriteShootoutCL.this.queue, (CLMem)SpriteShootoutCL.this.clTransform, null, null);
                CL10.clFinish((CLCommandQueue)SpriteShootoutCL.this.queue);
            }
            if (render) {
                GL11.glDrawArrays((int)0, (int)0, (int)SpriteShootoutCL.this.ballCount);
            }
        }
    }

    private abstract class SpriteRenderer {
        protected int progID;
        protected int animVBO;

        private SpriteRenderer() {
        }

        protected void createKernel(String source) {
            SpriteShootoutCL.this.program = CL10.clCreateProgramWithSource((CLContext)SpriteShootoutCL.this.clContext, (CharSequence)source, (IntBuffer)SpriteShootoutCL.this.errorCode);
            SpriteShootoutCL.checkCLError(SpriteShootoutCL.this.errorCode);
            int build = CL10.clBuildProgram((CLProgram)SpriteShootoutCL.this.program, (CLDevice)SpriteShootoutCL.this.clDevice, (CharSequence)"", null);
            if (build != 0) {
                System.out.println("BUILD LOG: " + SpriteShootoutCL.this.program.getBuildInfoString(SpriteShootoutCL.this.clDevice, 4483));
                throw new RuntimeException("Failed to build CL program, status: " + build);
            }
            SpriteShootoutCL.this.kernel = CL10.clCreateKernel((CLProgram)SpriteShootoutCL.this.program, (CharSequence)"animate", (IntBuffer)SpriteShootoutCL.this.errorCode);
            SpriteShootoutCL.checkCLError(SpriteShootoutCL.this.errorCode);
            SpriteShootoutCL.this.kernelGlobalWorkSize = BufferUtils.createPointerBuffer((int)1);
            SpriteShootoutCL.this.kernelGlobalWorkSize.put(0, (long)SpriteShootoutCL.this.ballCount);
            SpriteShootoutCL.this.kernel.setArg(0, 800);
            SpriteShootoutCL.this.kernel.setArg(1, 600);
        }

        protected void createProgram(int vshID) {
            int fshID = GL20.glCreateShader((int)35632);
            GL20.glShaderSource((int)fshID, (CharSequence)"#version 110\nuniform sampler2D COLOR_MAP;void main(void) {\n     gl_FragColor = texture2D(COLOR_MAP, gl_PointCoord);\n}");
            GL20.glCompileShader((int)fshID);
            if (GL20.glGetShaderi((int)fshID, (int)35713) == 0) {
                System.out.println(GL20.glGetShaderInfoLog((int)fshID, (int)GL20.glGetShaderi((int)fshID, (int)35716)));
                throw new RuntimeException("Failed to compile fragment shader.");
            }
            this.progID = GL20.glCreateProgram();
            GL20.glAttachShader((int)this.progID, (int)vshID);
            GL20.glAttachShader((int)this.progID, (int)fshID);
            GL20.glLinkProgram((int)this.progID);
            if (GL20.glGetProgrami((int)this.progID, (int)35714) == 0) {
                System.out.println(GL20.glGetProgramInfoLog((int)this.progID, (int)GL20.glGetProgrami((int)this.progID, (int)35716)));
                throw new RuntimeException("Failed to link shader program.");
            }
            GL20.glUseProgram((int)this.progID);
            GL20.glUniform1i((int)GL20.glGetUniformLocation((int)this.progID, (CharSequence)"COLOR_MAP"), (int)0);
            GL11.glEnableClientState((int)32884);
        }

        public void updateBallSize() {
            GL11.glPointSize((float)SpriteShootoutCL.this.ballSize);
            SpriteShootoutCL.this.kernel.setArg(2, (float)SpriteShootoutCL.this.ballSize * 0.5f);
        }

        public void updateBalls(int count) {
            SpriteShootoutCL.this.kernelGlobalWorkSize.put(0, (long)SpriteShootoutCL.this.ballCount);
            FloatBuffer transform = BufferUtils.createFloatBuffer((int)(count * 4));
            Random random = new Random();
            for (int i = 0; i < count; ++i) {
                transform.put((float)((int)(random.nextFloat() * (float)(800 - SpriteShootoutCL.this.ballSize))) + (float)SpriteShootoutCL.this.ballSize * 0.5f);
                transform.put((float)((int)(random.nextFloat() * (float)(600 - SpriteShootoutCL.this.ballSize))) + (float)SpriteShootoutCL.this.ballSize * 0.5f);
                transform.put(random.nextFloat() * 0.4f - 0.2f);
                transform.put(random.nextFloat() * 0.4f - 0.2f);
            }
            transform.flip();
            if (this.animVBO != 0) {
                CL10.clReleaseMemObject((CLMem)SpriteShootoutCL.this.clTransform);
                GL15.glDeleteBuffers((int)this.animVBO);
            }
            this.animVBO = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)this.animVBO);
            GL15.glBufferData((int)34962, (FloatBuffer)transform, (int)35044);
            GL11.glVertexPointer((int)2, (int)5126, (int)16, (long)0L);
            SpriteShootoutCL.this.clTransform = CL10GL.clCreateFromGLBuffer((CLContext)SpriteShootoutCL.this.clContext, (long)1L, (int)this.animVBO, (IntBuffer)SpriteShootoutCL.this.errorCode);
            SpriteShootoutCL.checkCLError(SpriteShootoutCL.this.errorCode);
            SpriteShootoutCL.this.kernel.setArg(4, (CLObject)SpriteShootoutCL.this.clTransform);
        }

        protected abstract void render(boolean var1, boolean var2, int var3);
    }
}

