/*
 * This file has been generated by the onto2vocabularyclass tool
 * copyright (C) 2007-2010 Sebastian Trueg <trueg@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _SOPRANO_NUAO_H_
#define _SOPRANO_NUAO_H_

#include <QtCore/QUrl>
#include "nepomuk_export.h"

namespace Nepomuk {
    namespace Vocabulary {
        namespace NUAO {
            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#
             */
            NEPOMUK_EXPORT QUrl nuaoNamespace();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#DesktopEvent 
             * 
             * A desktop event: activity performed by an user. A "hook" class 
             * that should be extended by other ontologies such as desktop 
             * service ontology to specify which application or service was 
             * involved in the desktop event. 
             */
            NEPOMUK_EXPORT QUrl DesktopEvent();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#Event 
             * 
             * An event: activity that have a specific start datetime and possibly 
             * a duration 
             */
            NEPOMUK_EXPORT QUrl Event();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#FocusEvent 
             * 
             * An event which refers to the timespan in which a resource was 
             * in the focus of the user. 
             */
            NEPOMUK_EXPORT QUrl FocusEvent();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#ModificationEvent 
             * 
             * An event that lead to changes of the resource that are meaningful 
             * to the user 
             */
            NEPOMUK_EXPORT QUrl ModificationEvent();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#UsageEvent 
             * 
             * An event of primary or intended use of the resource by the user. 
             * Primary or intended use is defined as the use by the consumer 
             * of the resource, such as watching a movie or listening to a song. 
             * Not to be confused with a low-level read on a file. 
             */
            NEPOMUK_EXPORT QUrl UsageEvent();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#duration 
             * 
             * Duration of the event. Deprecated in favor of nuao:end. 
             */
            NEPOMUK_EXPORT QUrl duration();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#end 
             * 
             * The time the event finished 
             */
            NEPOMUK_EXPORT QUrl end();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#eventCount 
             * 
             * The total number of events 
             */
            NEPOMUK_EXPORT QUrl eventCount();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#firstEvent 
             * 
             * The start time of the first event 
             */
            NEPOMUK_EXPORT QUrl firstEvent();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#firstModification 
             * 
             * The start time of the first modification 
             */
            NEPOMUK_EXPORT QUrl firstModification();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#firstUsage 
             * 
             * The start time of the first usage 
             */
            NEPOMUK_EXPORT QUrl firstUsage();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#initiatingAgent 
             * 
             * Relates an event to the agent initiating the event. 
             */
            NEPOMUK_EXPORT QUrl initiatingAgent();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#involves 
             * 
             * Relates an event to the resources that are involved in the event. 
             */
            NEPOMUK_EXPORT QUrl involves();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#lastEvent 
             * 
             * The start time of the last event 
             */
            NEPOMUK_EXPORT QUrl lastEvent();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#lastModification 
             * 
             * The start time of the last modification 
             */
            NEPOMUK_EXPORT QUrl lastModification();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#lastUsage 
             * 
             * The start time of the last usage 
             */
            NEPOMUK_EXPORT QUrl lastUsage();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#modificationCount 
             * 
             * The total number of modifications 
             */
            NEPOMUK_EXPORT QUrl modificationCount();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#start 
             * 
             * The time of the start of the event 
             */
            NEPOMUK_EXPORT QUrl start();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#targettedResource 
             * 
             * Relates an event to the resource that was targetted in the event. 
             */
            NEPOMUK_EXPORT QUrl targettedResource();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#totalEventDuration 
             * 
             * The total duration of all events 
             */
            NEPOMUK_EXPORT QUrl totalEventDuration();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#totalFocusDuration 
             * 
             * The total amount of time a resource was in focus during a UsageEvent. 
             * This property should be used to 'compress' several FocusEvent 
             * instances into the essential information. 
             */
            NEPOMUK_EXPORT QUrl totalFocusDuration();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#totalModificationDuration 
             * 
             * The total duration of all modifications 
             */
            NEPOMUK_EXPORT QUrl totalModificationDuration();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#totalUsageDuration 
             * 
             * The total duration of all usages 
             */
            NEPOMUK_EXPORT QUrl totalUsageDuration();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao#usageCount 
             * 
             * The total number of usages 
             */
            NEPOMUK_EXPORT QUrl usageCount();

            /**
             * http://www.semanticdesktop.org/ontologies/2010/01/25/nuao/metadata 
             */
            NEPOMUK_EXPORT QUrl metadata();
        }
    }
}

#endif
