/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.TemplatedWMSTileSource;
import org.openstreetmap.josm.data.imagery.WMSCachedTileLoader;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;

public class WMSLayer
extends AbstractCachedTileSourceLayer<TemplatedWMSTileSource> {
    private static final String PREFERENCE_PREFIX = "imagery.wms.";
    public static final IntegerProperty PROP_IMAGE_SIZE = new IntegerProperty("imagery.wms.imageSize", 512);
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.wms.default_autozoom", true);
    private static final String CACHE_REGION_NAME = "WMS";
    private final Set<String> supportedProjections;

    public WMSLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
        this.supportedProjections = new TreeSet<String>(imageryInfo.getServerProjections());
        this.autoZoom = PROP_DEFAULT_AUTOZOOM.get();
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.addAll(Arrays.asList(super.getMenuEntries()));
        arrayList.add(Layer.SeparatorLayerAction.INSTANCE);
        arrayList.add(new Layer.LayerSaveAction(this));
        arrayList.add(new Layer.LayerSaveAsAction(this));
        arrayList.add(new BookmarkWmsAction());
        return arrayList.toArray(new Action[0]);
    }

    @Override
    protected TemplatedWMSTileSource getTileSource(ImageryInfo imageryInfo) {
        if (imageryInfo.getImageryType() == ImageryInfo.ImageryType.WMS && imageryInfo.getUrl() != null) {
            TemplatedWMSTileSource.checkUrl(imageryInfo.getUrl());
            TemplatedWMSTileSource templatedWMSTileSource = new TemplatedWMSTileSource(imageryInfo);
            imageryInfo.setAttribution(templatedWMSTileSource);
            return templatedWMSTileSource;
        }
        return null;
    }

    @Override
    protected Map<String, String> getHeaders(TemplatedWMSTileSource templatedWMSTileSource) {
        return templatedWMSTileSource.getHeaders();
    }

    @Override
    public boolean isProjectionSupported(Projection projection) {
        return this.supportedProjections == null || this.supportedProjections.isEmpty() || this.supportedProjections.contains(projection.toCode()) || this.info.isEpsg4326To3857Supported() && this.supportedProjections.contains("EPSG:4326") && "EPSG:3857".equals(Main.getProjection().toCode());
    }

    @Override
    public String nameSupportedProjections() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.supportedProjections) {
            stringBuilder.append(string).append(", ");
        }
        Object object = "";
        if (this.isReprojectionPossible()) {
            object = ". <p>" + I18n.tr("JOSM will use EPSG:4326 to query the server, but results may vary depending on the WMS server", new Object[0]) + "</p>";
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2) + (String)object;
    }

    @Override
    public void projectionChanged(Projection projection, Projection projection2) {
        if (!this.isProjectionSupported(projection2)) {
            String string = "<html><body><p>" + I18n.tr("The layer {0} does not support the new projection {1}.", this.getName(), projection2.toCode()) + "<p style='width: 450px; position: absolute; margin: 0px;'>" + I18n.tr("Supported projections are: {0}", this.nameSupportedProjections()) + "</p>" + "<p>" + I18n.tr("Change the projection again or remove the layer.", new Object[0]);
            ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Warning", new Object[0]), new String[]{I18n.tr("OK", new Object[0])}).setContent(string).setIcon(2);
            if (this.isReprojectionPossible()) {
                extendedDialog.toggleEnable("imagery.wms.projectionSupportWarnings." + ((TemplatedWMSTileSource)this.tileSource).getBaseUrl());
            }
            extendedDialog.showDialog();
        }
        if (!projection2.equals(projection)) {
            ((TemplatedWMSTileSource)this.tileSource).initProjection(projection2);
        }
    }

    @Override
    protected Class<? extends TileLoader> getTileLoaderClass() {
        return WMSCachedTileLoader.class;
    }

    @Override
    protected String getCacheName() {
        return CACHE_REGION_NAME;
    }

    public static CacheAccess<String, BufferedImageCacheEntry> getCache() {
        return AbstractCachedTileSourceLayer.getCache(CACHE_REGION_NAME);
    }

    private boolean isReprojectionPossible() {
        return this.supportedProjections.contains("EPSG:4326") && "EPSG:3857".equals(Main.getProjection().toCode());
    }

    public class BookmarkWmsAction
    extends AbstractAction {
        public BookmarkWmsAction() {
            super(I18n.tr("Set WMS Bookmark", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImageryLayerInfo.addLayer(new ImageryInfo(WMSLayer.this.info));
        }
    }
}

