/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.tools.I18n;

public class CyclicUploadDependencyException
extends Exception {
    private final Stack<Relation> cycle;

    public CyclicUploadDependencyException(Stack<Relation> stack) {
        this.cycle = stack;
    }

    protected String formatRelation(Relation relation) {
        StringBuilder stringBuilder = new StringBuilder();
        if (relation.getName() != null) {
            stringBuilder.append('\'').append(relation.getName()).append('\'');
        } else if (!relation.isNew()) {
            stringBuilder.append(relation.getId());
        } else {
            stringBuilder.append("relation@").append(relation.hashCode());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(I18n.tr("Cyclic dependency between relations:", new Object[0])).append('[');
        for (int i = 0; i < this.cycle.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.formatRelation((Relation)this.cycle.get(i)));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public List<Relation> getCyclicUploadDependency() {
        return new ArrayList<Relation>(this.cycle);
    }
}

