/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelInstrument;
import com.sun.media.sound.ModelOscillator;
import com.sun.media.sound.ModelOscillatorStream;
import com.sun.media.sound.ModelPatch;
import com.sun.media.sound.ModelPerformer;
import com.sun.media.sound.SimpleInstrument;
import com.sun.media.sound.SimpleSoundbank;
import java.io.IOException;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.Patch;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import javax.sound.midi.VoiceStatus;

public abstract class ModelAbstractOscillator
implements ModelOscillator,
ModelOscillatorStream,
Soundbank {
    protected float pitch = 6000.0f;
    protected float samplerate;
    protected MidiChannel channel;
    protected VoiceStatus voice;
    protected int noteNumber;
    protected int velocity;
    protected boolean on = false;

    public void init() {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void noteOff(int n) {
        this.on = false;
    }

    @Override
    public void noteOn(MidiChannel midiChannel, VoiceStatus voiceStatus, int n, int n2) {
        this.channel = midiChannel;
        this.voice = voiceStatus;
        this.noteNumber = n;
        this.velocity = n2;
        this.on = true;
    }

    @Override
    public int read(float[][] fArray, int n, int n2) throws IOException {
        return -1;
    }

    public MidiChannel getChannel() {
        return this.channel;
    }

    public VoiceStatus getVoice() {
        return this.voice;
    }

    public int getNoteNumber() {
        return this.noteNumber;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public boolean isOn() {
        return this.on;
    }

    @Override
    public void setPitch(float f) {
        this.pitch = f;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setSampleRate(float f) {
        this.samplerate = f;
    }

    public float getSampleRate() {
        return this.samplerate;
    }

    @Override
    public float getAttenuation() {
        return 0.0f;
    }

    @Override
    public int getChannels() {
        return 1;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public Patch getPatch() {
        return new Patch(0, 0);
    }

    @Override
    public ModelOscillatorStream open(float f) {
        ModelAbstractOscillator modelAbstractOscillator;
        try {
            modelAbstractOscillator = (ModelAbstractOscillator)this.getClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException(illegalAccessException);
        }
        modelAbstractOscillator.setSampleRate(f);
        modelAbstractOscillator.init();
        return modelAbstractOscillator;
    }

    public ModelPerformer getPerformer() {
        ModelPerformer modelPerformer = new ModelPerformer();
        modelPerformer.getOscillators().add(this);
        return modelPerformer;
    }

    public ModelInstrument getInstrument() {
        SimpleInstrument simpleInstrument = new SimpleInstrument();
        simpleInstrument.setName(this.getName());
        simpleInstrument.add(this.getPerformer());
        simpleInstrument.setPatch(this.getPatch());
        return simpleInstrument;
    }

    public Soundbank getSoundBank() {
        SimpleSoundbank simpleSoundbank = new SimpleSoundbank();
        simpleSoundbank.addInstrument(this.getInstrument());
        return simpleSoundbank;
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public Instrument getInstrument(Patch patch) {
        ModelInstrument modelInstrument = this.getInstrument();
        Patch patch2 = modelInstrument.getPatch();
        if (patch2.getBank() != patch.getBank()) {
            return null;
        }
        if (patch2.getProgram() != patch.getProgram()) {
            return null;
        }
        if (patch2 instanceof ModelPatch && patch instanceof ModelPatch && ((ModelPatch)patch2).isPercussion() != ((ModelPatch)patch).isPercussion()) {
            return null;
        }
        return modelInstrument;
    }

    @Override
    public Instrument[] getInstruments() {
        return new Instrument[]{this.getInstrument()};
    }

    @Override
    public SoundbankResource[] getResources() {
        return new SoundbankResource[0];
    }

    @Override
    public String getVendor() {
        return null;
    }

    @Override
    public String getVersion() {
        return null;
    }
}

