/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Instruction;
import sun.jvm.hotspot.asm.Register;
import sun.jvm.hotspot.asm.sparc.MemoryInstructionDecoder;
import sun.jvm.hotspot.asm.sparc.SPARCInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCInstructionFactory;
import sun.jvm.hotspot.asm.sparc.SPARCRegister;
import sun.jvm.hotspot.asm.sparc.SPARCRegisterIndirectAddress;
import sun.jvm.hotspot.asm.sparc.SPARCRegisters;

class JmplDecoder
extends MemoryInstructionDecoder {
    JmplDecoder() {
        super(56, "jmpl", 5);
    }

    @Override
    Instruction decodeMemoryInstruction(int instruction, SPARCRegisterIndirectAddress addr, SPARCRegister rd, SPARCInstructionFactory factory) {
        SPARCInstruction instr = null;
        if (rd == SPARCRegisters.O7) {
            instr = factory.newIndirectCallInstruction(addr, rd);
        } else if (rd == SPARCRegisters.G0) {
            int disp = (int)addr.getDisplacement();
            Register base = addr.getBase();
            instr = base == SPARCRegisters.I7 && disp == 8 ? factory.newReturnInstruction(addr, rd, false) : (base == SPARCRegisters.O7 && disp == 8 ? factory.newReturnInstruction(addr, rd, true) : factory.newJmplInstruction(addr, rd));
        } else {
            instr = factory.newJmplInstruction(addr, rd);
        }
        return instr;
    }
}

