/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import gnu.java.util.EmptyEnumeration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DefaultMutableTreeNode
implements Cloneable,
MutableTreeNode,
Serializable {
    private static final long serialVersionUID = -4298474751201349152L;
    public static final Enumeration<TreeNode> EMPTY_ENUMERATION = new EmptyEnumeration<TreeNode>();
    protected MutableTreeNode parent;
    protected Vector<MutableTreeNode> children = new Vector();
    protected transient Object userObject;
    protected boolean allowsChildren;

    public DefaultMutableTreeNode() {
        this(null, true);
    }

    public DefaultMutableTreeNode(Object userObject) {
        this(userObject, true);
    }

    public DefaultMutableTreeNode(Object userObject, boolean allowsChildren) {
        this.userObject = userObject;
        this.allowsChildren = allowsChildren;
    }

    public Object clone() {
        return new DefaultMutableTreeNode(this.userObject, this.allowsChildren);
    }

    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        return this.userObject.toString();
    }

    public void add(MutableTreeNode child) {
        if (!this.allowsChildren) {
            throw new IllegalStateException();
        }
        if (child == null) {
            throw new IllegalArgumentException();
        }
        if (this.isNodeAncestor(child)) {
            throw new IllegalArgumentException("Cannot add ancestor node.");
        }
        this.children.add(child);
        child.setParent(this);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void remove(int index) {
        MutableTreeNode child = this.children.remove(index);
        child.setParent(null);
    }

    public void remove(MutableTreeNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException("Null 'node' argument.");
        }
        if (node2.getParent() != this) {
            throw new IllegalArgumentException("The given 'node' is not a child of this node.");
        }
        this.children.remove(node2);
        node2.setParent(null);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
    }

    public void insert(MutableTreeNode node2, int index) {
        if (!this.allowsChildren) {
            throw new IllegalStateException();
        }
        if (node2 == null) {
            throw new IllegalArgumentException("Null 'node' argument.");
        }
        if (this.isNodeAncestor(node2)) {
            throw new IllegalArgumentException("Cannot insert ancestor node.");
        }
        this.children.insertElementAt(node2, index);
    }

    public TreeNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    public Enumeration children() {
        if (this.children.size() == 0) {
            return EMPTY_ENUMERATION;
        }
        return this.children.elements();
    }

    public void setParent(MutableTreeNode node2) {
        this.parent = node2;
    }

    public TreeNode getChildAt(int index) {
        return this.children.elementAt(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException("Null 'node' argument.");
        }
        return this.children.indexOf(node2);
    }

    public void setAllowsChildren(boolean allowsChildren) {
        if (!allowsChildren) {
            this.removeAllChildren();
        }
        this.allowsChildren = allowsChildren;
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void removeFromParent() {
        this.parent.remove(this);
        this.parent = null;
    }

    public void removeAllChildren() {
        int i = this.getChildCount() - 1;
        while (i >= 0) {
            this.remove(i);
            --i;
        }
    }

    public boolean isNodeAncestor(TreeNode node2) {
        if (node2 == null) {
            return false;
        }
        TreeNode current = this;
        while (current != null && current != node2) {
            current = current.getParent();
        }
        return current == node2;
    }

    public boolean isNodeDescendant(DefaultMutableTreeNode node2) {
        if (node2 == null) {
            return false;
        }
        TreeNode current = node2;
        while (current != null && current != this) {
            current = current.getParent();
        }
        return current == this;
    }

    public TreeNode getSharedAncestor(DefaultMutableTreeNode node2) {
        TreeNode current = this;
        ArrayList<DefaultMutableTreeNode> list2 = new ArrayList<DefaultMutableTreeNode>();
        while (current != null) {
            list2.add((DefaultMutableTreeNode)current);
            current = current.getParent();
        }
        current = node2;
        while (current != null) {
            if (list2.contains(current)) {
                return current;
            }
            current = current.getParent();
        }
        return null;
    }

    public boolean isNodeRelated(DefaultMutableTreeNode node2) {
        if (node2 == null) {
            return false;
        }
        return node2.getRoot() == this.getRoot();
    }

    public int getDepth() {
        if (!this.allowsChildren || this.children.size() == 0) {
            return 0;
        }
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(new Integer(0));
        TreeNode node2 = this.getChildAt(0);
        int depth = 0;
        int current = 1;
        while (!stack.empty()) {
            int size;
            int index;
            if (node2.getChildCount() != 0) {
                node2 = node2.getChildAt(0);
                stack.push(new Integer(0));
                ++current;
                continue;
            }
            if (current > depth) {
                depth = current;
            }
            do {
                node2 = node2.getParent();
                size = node2.getChildCount();
                index = (Integer)stack.pop() + 1;
                --current;
            } while (index >= size && node2 != this);
            if (index >= size) continue;
            node2 = node2.getChildAt(index);
            stack.push(new Integer(index));
            ++current;
        }
        return depth;
    }

    public int getLevel() {
        int count = -1;
        TreeNode current = this;
        do {
            current = current.getParent();
            ++count;
        } while (current != null);
        return count;
    }

    protected TreeNode[] getPathToRoot(TreeNode node2, int depth) {
        if (node2 == null) {
            if (depth == 0) {
                return null;
            }
            return new TreeNode[depth];
        }
        TreeNode[] path = this.getPathToRoot(node2.getParent(), depth + 1);
        path[path.length - depth - 1] = node2;
        return path;
    }

    public Object[] getUserObjectPath() {
        TreeNode[] path = this.getPathToRoot(this, 0);
        Object[] object = new Object[path.length];
        int index = 0;
        while (index < path.length) {
            object[index] = ((DefaultMutableTreeNode)path[index]).getUserObject();
            ++index;
        }
        return object;
    }

    public TreeNode getRoot() {
        TreeNode current = this;
        TreeNode check = current.getParent();
        while (check != null) {
            current = check;
            check = current.getParent();
        }
        return current;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public DefaultMutableTreeNode getNextNode() {
        DefaultMutableTreeNode sibling;
        if (this.getChildCount() != 0) {
            return (DefaultMutableTreeNode)this.getChildAt(0);
        }
        DefaultMutableTreeNode node2 = this;
        do {
            sibling = node2.getNextSibling();
            node2 = (DefaultMutableTreeNode)node2.getParent();
        } while (sibling == null && node2 != null);
        return sibling;
    }

    public DefaultMutableTreeNode getPreviousNode() {
        if (this.parent == null) {
            return null;
        }
        DefaultMutableTreeNode sibling = this.getPreviousSibling();
        if (sibling == null) {
            return (DefaultMutableTreeNode)this.parent;
        }
        if (sibling.getChildCount() != 0) {
            return sibling.getLastLeaf();
        }
        return sibling;
    }

    public Enumeration preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    public Enumeration postorderEnumeration() {
        return new PostorderEnumeration(this);
    }

    public Enumeration breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this);
    }

    public Enumeration depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    public Enumeration pathFromAncestorEnumeration(TreeNode node2) {
        if (node2 == null) {
            throw new IllegalArgumentException();
        }
        TreeNode parent = this;
        Vector<DefaultMutableTreeNode> nodes = new Vector<DefaultMutableTreeNode>();
        nodes.add(this);
        while (parent != node2 && parent != null) {
            parent = parent.getParent();
            nodes.add(0, (DefaultMutableTreeNode)parent);
        }
        if (parent != node2) {
            throw new IllegalArgumentException();
        }
        return nodes.elements();
    }

    public boolean isNodeChild(TreeNode node2) {
        if (node2 == null) {
            return false;
        }
        return node2.getParent() == this;
    }

    public TreeNode getFirstChild() {
        return this.children.firstElement();
    }

    public TreeNode getLastChild() {
        return this.children.lastElement();
    }

    public TreeNode getChildAfter(TreeNode node2) {
        if (node2 == null || node2.getParent() != this) {
            throw new IllegalArgumentException();
        }
        int index = this.getIndex(node2) + 1;
        if (index == this.getChildCount()) {
            return null;
        }
        return this.getChildAt(index);
    }

    public TreeNode getChildBefore(TreeNode node2) {
        if (node2 == null || node2.getParent() != this) {
            throw new IllegalArgumentException();
        }
        int index = this.getIndex(node2) - 1;
        if (index < 0) {
            return null;
        }
        return this.getChildAt(index);
    }

    public boolean isNodeSibling(TreeNode node2) {
        if (node2 == null) {
            return false;
        }
        if (node2 == this) {
            return true;
        }
        return node2.getParent() == this.getParent() && this.getParent() != null;
    }

    public int getSiblingCount() {
        if (this.parent == null) {
            return 1;
        }
        return this.parent.getChildCount();
    }

    public DefaultMutableTreeNode getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        int index = this.parent.getIndex(this) + 1;
        if (index == this.parent.getChildCount()) {
            return null;
        }
        return (DefaultMutableTreeNode)this.parent.getChildAt(index);
    }

    public DefaultMutableTreeNode getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        int index = this.parent.getIndex(this) - 1;
        if (index < 0) {
            return null;
        }
        return (DefaultMutableTreeNode)this.parent.getChildAt(index);
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public DefaultMutableTreeNode getFirstLeaf() {
        TreeNode current = this;
        while (current.getChildCount() > 0) {
            current = current.getChildAt(0);
        }
        return current;
    }

    public DefaultMutableTreeNode getLastLeaf() {
        TreeNode current = this;
        int size = current.getChildCount();
        while (size > 0) {
            current = current.getChildAt(size - 1);
            size = current.getChildCount();
        }
        return current;
    }

    public DefaultMutableTreeNode getNextLeaf() {
        DefaultMutableTreeNode sibling = this.getNextSibling();
        if (sibling != null) {
            return sibling.getFirstLeaf();
        }
        if (this.parent != null) {
            return ((DefaultMutableTreeNode)this.parent).getNextLeaf();
        }
        return null;
    }

    public DefaultMutableTreeNode getPreviousLeaf() {
        DefaultMutableTreeNode sibling = this.getPreviousSibling();
        if (sibling != null) {
            return sibling.getLastLeaf();
        }
        if (this.parent != null) {
            return ((DefaultMutableTreeNode)this.parent).getPreviousLeaf();
        }
        return null;
    }

    public int getLeafCount() {
        int count = 0;
        Enumeration e = this.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            TreeNode current = (TreeNode)e.nextElement();
            if (!current.isLeaf()) continue;
            ++count;
        }
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BreadthFirstEnumeration
    implements Enumeration<TreeNode> {
        LinkedList<TreeNode> queue = new LinkedList();

        BreadthFirstEnumeration(TreeNode node2) {
            this.queue.add(node2);
        }

        @Override
        public boolean hasMoreElements() {
            return !this.queue.isEmpty();
        }

        @Override
        public TreeNode nextElement() {
            if (this.queue.isEmpty()) {
                throw new NoSuchElementException("No more elements left.");
            }
            TreeNode node2 = this.queue.removeFirst();
            Enumeration children = node2.children();
            while (children.hasMoreElements()) {
                this.queue.add((TreeNode)children.nextElement());
            }
            return node2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PostorderEnumeration
    implements Enumeration<TreeNode> {
        Stack<TreeNode> nodes = new Stack();
        Stack<Enumeration<TreeNode>> childrenEnums = new Stack();

        PostorderEnumeration(TreeNode node2) {
            this.nodes.push(node2);
            Enumeration children = node2.children();
            this.childrenEnums.push(children);
        }

        @Override
        public boolean hasMoreElements() {
            return !this.nodes.isEmpty();
        }

        @Override
        public TreeNode nextElement() {
            if (this.nodes.isEmpty()) {
                throw new NoSuchElementException("No more elements left!");
            }
            Enumeration<TreeNode> children = this.childrenEnums.peek();
            return this.traverse(children);
        }

        private TreeNode traverse(Enumeration<TreeNode> children) {
            if (children.hasMoreElements()) {
                TreeNode node2 = children.nextElement();
                this.nodes.push(node2);
                Enumeration newChildren = node2.children();
                this.childrenEnums.push(newChildren);
                return this.traverse(newChildren);
            }
            this.childrenEnums.pop();
            TreeNode next = this.nodes.peek();
            this.nodes.pop();
            return next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PreorderEnumeration
    implements Enumeration<TreeNode> {
        TreeNode next;
        Stack<Enumeration<TreeNode>> childrenEnums = new Stack();

        PreorderEnumeration(TreeNode node2) {
            this.next = node2;
            Enumeration children = node2.children();
            this.childrenEnums.push(children);
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public TreeNode nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException("No more elements left.");
            }
            TreeNode current = this.next;
            Enumeration<TreeNode> children = this.childrenEnums.peek();
            this.next = this.traverse(children);
            return current;
        }

        private TreeNode traverse(Enumeration<TreeNode> children) {
            if (children.hasMoreElements()) {
                TreeNode child = children.nextElement();
                Enumeration grandchildren = child.children();
                this.childrenEnums.push(grandchildren);
                return child;
            }
            this.childrenEnums.pop();
            if (this.childrenEnums.isEmpty()) {
                return null;
            }
            return this.traverse(this.childrenEnums.peek());
        }
    }
}

