/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributedStringIterator
implements AttributedCharacterIterator {
    private CharacterIterator ci;
    private AttributedString.AttributeRange[] attribs;
    private AttributedCharacterIterator.Attribute[] restricts;

    AttributedStringIterator(StringCharacterIterator sci, AttributedString.AttributeRange[] attribs, int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] restricts) {
        this.ci = new StringCharacterIterator(sci, beginIndex, endIndex);
        this.attribs = attribs;
        this.restricts = restricts;
    }

    @Override
    public Object clone() {
        return this.ci.clone();
    }

    @Override
    public char current() {
        return this.ci.current();
    }

    @Override
    public char next() {
        return this.ci.next();
    }

    @Override
    public char previous() {
        return this.ci.previous();
    }

    @Override
    public char first() {
        return this.ci.first();
    }

    @Override
    public char last() {
        return this.ci.last();
    }

    @Override
    public int getIndex() {
        return this.ci.getIndex();
    }

    @Override
    public char setIndex(int index) {
        return this.ci.setIndex(index);
    }

    @Override
    public int getBeginIndex() {
        return this.ci.getBeginIndex();
    }

    @Override
    public int getEndIndex() {
        return this.ci.getEndIndex();
    }

    @Override
    public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
        HashSet<AttributedCharacterIterator.Attribute> s = new HashSet<AttributedCharacterIterator.Attribute>();
        if (this.attribs == null) {
            return s;
        }
        int i = 0;
        while (i < this.attribs.length) {
            if (this.attribs[i].beginIndex <= this.getEndIndex() && this.attribs[i].endIndex > this.getBeginIndex()) {
                Iterator<? extends AttributedCharacterIterator.Attribute> iter = this.attribs[i].attribs.keySet().iterator();
                while (iter.hasNext()) {
                    s.add(iter.next());
                }
            }
            ++i;
        }
        return s;
    }

    @Override
    public int getRunLimit() {
        return this.getRunLimit(this.getAllAttributeKeys());
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute attrib) {
        HashSet<AttributedCharacterIterator.Attribute> s = new HashSet<AttributedCharacterIterator.Attribute>();
        s.add(attrib);
        return this.getRunLimit(s);
    }

    @Override
    public synchronized int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> attributeSet) {
        if (attributeSet == null) {
            return this.ci.getEndIndex();
        }
        int current = this.ci.getIndex();
        int end = this.ci.getEndIndex();
        int limit = current;
        if (current == end) {
            return end;
        }
        Map<AttributedCharacterIterator.Attribute, Object> runValues = this.getAttributes();
        while (limit < end) {
            for (AttributedCharacterIterator.Attribute attribute : attributeSet) {
                Object v1 = runValues.get(attribute);
                Object v2 = this.getAttribute(attribute, limit + 1);
                boolean changed = false;
                if (v1 != null) {
                    changed = !v1.equals(v2);
                } else {
                    boolean bl = changed = v2 != null;
                }
                if (!changed) continue;
                return limit + 1;
            }
            ++limit;
        }
        return end;
    }

    @Override
    public int getRunStart() {
        return this.getRunStart(this.getAttributes().keySet());
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute attrib) {
        if (attrib == null) {
            return this.ci.getBeginIndex();
        }
        HashSet<AttributedCharacterIterator.Attribute> s = new HashSet<AttributedCharacterIterator.Attribute>();
        s.add(attrib);
        return this.getRunStart(s);
    }

    @Override
    public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> attributeSet) {
        int begin;
        if (attributeSet == null) {
            return this.ci.getBeginIndex();
        }
        int current = this.ci.getIndex();
        int start = current;
        if (start == (begin = this.ci.getBeginIndex())) {
            return begin;
        }
        Map<AttributedCharacterIterator.Attribute, Object> runValues = this.getAttributes();
        int prev = start - 1;
        while (start > begin) {
            for (AttributedCharacterIterator.Attribute attribute : attributeSet) {
                Object v1 = runValues.get(attribute);
                Object v2 = this.getAttribute(attribute, prev);
                boolean changed = false;
                if (v1 != null) {
                    changed = !v1.equals(v2);
                } else {
                    boolean bl = changed = v2 != null;
                }
                if (!changed) continue;
                return start;
            }
            --start;
            --prev;
        }
        return start;
    }

    private Object getAttribute(AttributedCharacterIterator.Attribute key, int pos) {
        if (this.attribs == null) {
            return null;
        }
        int i = this.attribs.length - 1;
        while (i >= 0) {
            Set<? extends AttributedCharacterIterator.Attribute> keys;
            if (pos >= this.attribs[i].beginIndex && pos < this.attribs[i].endIndex && (keys = this.attribs[i].attribs.keySet()).contains(key)) {
                return this.attribs[i].attribs.get(key);
            }
            --i;
        }
        return null;
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute key) {
        return this.getAttribute(key, this.ci.getIndex());
    }

    @Override
    public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
        HashMap<AttributedCharacterIterator.Attribute, Object> m = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        if (this.attribs == null) {
            return m;
        }
        int i = 0;
        while (i < this.attribs.length) {
            if (this.ci.getIndex() >= this.attribs[i].beginIndex && this.ci.getIndex() < this.attribs[i].endIndex) {
                m.putAll(this.attribs[i].attribs);
            }
            ++i;
        }
        return m;
    }
}

