/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.logging.Logger;

public class RSAKeyPairPKCS8Codec
implements IKeyPairCodec {
    private static final Logger log = null;
    private static final OID RSA_ALG_OID = new OID("1.2.840.113549.1.1.1");

    public int getFormatID() {
        return 3;
    }

    public byte[] encodePublicKey(PublicKey key) {
        throw new InvalidParameterException("Wrong format for public keys");
    }

    public byte[] encodePrivateKey(PrivateKey key) {
        byte[] result;
        if (!(key instanceof GnuRSAPrivateKey)) {
            throw new InvalidParameterException("Wrong key type");
        }
        GnuRSAPrivateKey pk = (GnuRSAPrivateKey)key;
        BigInteger n = pk.getN();
        BigInteger e = pk.getE();
        BigInteger d = pk.getPrivateExponent();
        BigInteger p = pk.getPrimeP();
        BigInteger q = pk.getPrimeQ();
        BigInteger dP = pk.getPrimeExponentP();
        BigInteger dQ = pk.getPrimeExponentQ();
        BigInteger qInv = pk.getCrtCoefficient();
        DERValue derVersion = new DERValue(2, BigInteger.ZERO);
        DERValue derOID = new DERValue(6, RSA_ALG_OID);
        ArrayList<DERValue> algorithmID = new ArrayList<DERValue>(2);
        algorithmID.add(derOID);
        algorithmID.add(new DERValue(5, null));
        DERValue derAlgorithmID = new DERValue(48, algorithmID);
        DERValue derRSAVersion = new DERValue(2, BigInteger.ZERO);
        DERValue derN = new DERValue(2, n);
        DERValue derE = new DERValue(2, e);
        DERValue derD = new DERValue(2, d);
        DERValue derP = new DERValue(2, p);
        DERValue derQ = new DERValue(2, q);
        DERValue derDP = new DERValue(2, dP);
        DERValue derDQ = new DERValue(2, dQ);
        DERValue derQInv = new DERValue(2, qInv);
        ArrayList<DERValue> rsaPrivateKey = new ArrayList<DERValue>();
        rsaPrivateKey.add(derRSAVersion);
        rsaPrivateKey.add(derN);
        rsaPrivateKey.add(derE);
        rsaPrivateKey.add(derD);
        rsaPrivateKey.add(derP);
        rsaPrivateKey.add(derQ);
        rsaPrivateKey.add(derDP);
        rsaPrivateKey.add(derDQ);
        rsaPrivateKey.add(derQInv);
        DERValue derRSAPrivateKey = new DERValue(48, rsaPrivateKey);
        byte[] pkBytes = derRSAPrivateKey.getEncoded();
        DERValue derPrivateKey = new DERValue(4, pkBytes);
        ArrayList<DERValue> pki = new ArrayList<DERValue>(3);
        pki.add(derVersion);
        pki.add(derAlgorithmID);
        pki.add(derPrivateKey);
        DERValue derPKI = new DERValue(48, pki);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DERWriter.write(baos, derPKI);
            result = baos.toByteArray();
        }
        catch (IOException x) {
            InvalidParameterException y = new InvalidParameterException();
            y.initCause(x);
            throw y;
        }
        return result;
    }

    public PublicKey decodePublicKey(byte[] input) {
        throw new InvalidParameterException("Wrong format for public keys");
    }

    public PrivateKey decodePrivateKey(byte[] input) {
        BigInteger qInv;
        BigInteger dQ;
        BigInteger dP;
        BigInteger q;
        BigInteger p;
        BigInteger d;
        BigInteger e;
        BigInteger n;
        if (input == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader der = new DERReader(input);
        try {
            DERValue derPKI = der.read();
            DerUtil.checkIsConstructed(derPKI, "Wrong PrivateKeyInfo field");
            DERValue derVersion = der.read();
            DerUtil.checkIsBigInteger(derVersion, "Wrong Version field");
            BigInteger version = (BigInteger)derVersion.getValue();
            if (version.compareTo(BigInteger.ZERO) != 0) {
                throw new InvalidParameterException("Unexpected Version: " + version);
            }
            DERValue derAlgoritmID = der.read();
            DerUtil.checkIsConstructed(derAlgoritmID, "Wrong AlgorithmIdentifier field");
            DERValue derOID = der.read();
            OID algOID = (OID)derOID.getValue();
            if (!algOID.equals(RSA_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + algOID);
            }
            DERValue val = der.read();
            if (val.getTag() == 5) {
                val = der.read();
            }
            byte[] pkBytes = (byte[])val.getValue();
            der = new DERReader(pkBytes);
            DERValue derRSAPrivateKey = der.read();
            DerUtil.checkIsConstructed(derRSAPrivateKey, "Wrong RSAPrivateKey field");
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong RSAPrivateKey Version field");
            version = (BigInteger)val.getValue();
            if (version.compareTo(BigInteger.ZERO) != 0) {
                throw new InvalidParameterException("Unexpected RSAPrivateKey Version: " + version);
            }
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong modulus field");
            n = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong publicExponent field");
            e = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong privateExponent field");
            d = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong prime1 field");
            p = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong prime2 field");
            q = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong exponent1 field");
            dP = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong exponent2 field");
            dQ = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong coefficient field");
            qInv = (BigInteger)val.getValue();
        }
        catch (IOException x) {
            InvalidParameterException y = new InvalidParameterException();
            y.initCause(x);
            throw y;
        }
        GnuRSAPrivateKey result = new GnuRSAPrivateKey(3, n, e, d, p, q, dP, dQ, qInv);
        return result;
    }
}

